/***************************************************************************
 *   Copyright (C) 2024 by Ilya Kotov                                      *
 *   forkotov02@ya.ru                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/

#ifndef COVERLOADER_P_H
#define COVERLOADER_P_H

#include <QThread>
#include <QObject>
#include <QMutex>
#include <QPixmap>
#include <QStack>

class CoverLoader : public QThread
{
    Q_OBJECT
public:
    explicit CoverLoader(QObject *parent = nullptr);

    void add(const QStringList &paths);
    void finish();

signals:
    void ready(const QString &path, const QImage &img);

private:
    void run() override;

    QStack<QString> m_paths;
    QMutex m_mutex;
};

#endif // COVERLOADER_P_H
