#!/usr/bin/python

"""Command-line client for pwrkap."""
# (C) Copyright IBM Corp. 2008-2009
# Licensed under the GPLv2.
import socket
import sys
import cPickle as pickle
import traceback
import thread

host = "localhost"
port = 9410

if len(sys.argv) > 1:
	host = sys.argv[1]
if len(sys.argv) > 2:
	port = int(sys.argv[2])

sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
sock.connect((host, port))
fp = sock.makefile()

def dump_input(file):
	"""Read objects from a socket and dump them."""
	try:
		obj = pickle.load(file)
		while True:
			print ("recv'd", obj)
			obj = pickle.load(file)
	except Exception, e:
		print e
		traceback.print_exc()
		sys.exit(1)

def print_help():
	"""Print command help."""
	print "Command format: domain_name command args"
	print "domain_name is the name of the domain to alter."
	print "command = {dump, cap}"
	print "    dump:           Dump transition tables to daemon console."
	print "    cap new_cap:    Set a new power cap."

def send_console(file):
	"""Read console and send to server."""
	data = sys.stdin.readline()
	while data != "":
		commands = data.split()
		if commands[0] == "help":
			print_help()
			data = sys.stdin.readline()
			continue
		pickled = pickle.dumps(commands, protocol = pickle.HIGHEST_PROTOCOL)
		file.write(pickled)
		file.flush()
		data = sys.stdin.readline()

thread.start_new_thread(dump_input, (fp,))
send_console(fp)
