#! /usr/bin/perl -w

use strict;
use warnings;

use GD::Graph::pie;

my $graph = GD::Graph::pie->new(450, 300);

if ($graph->can_do_ttf())
{
  my @data = (
    ["1st","2nd","3rd","4th","5th","6th","7th", "8th", "9th"],
    [    1,    2,    5,    6,    3,  1.5,    1,     3,     4],
    [ sort { $a <=> $b } (1, 2, 5, 6, 3, 1.5, 1, 3, 4) ]
  );

  $graph->set(
    label         => 'label',
    transparent   => 0,
    interlaced    => 1
  );

 # Marges o on ne dessine rien :
#  t_margin
#  b_margin
#  l_margin
#  r_margin
 # logo :
#  logo
#  logo_resize
#  logo_position

  my $gd=$graph->plot(\@data);
    # Convert the image to PNG and print it on standard output
  print "Content-Type: image/png\n\n";
  print $gd->png;
}
else
{
  print "Content-Type: text/html\n\n";
  print "<font color="red">No TTF support compiled in GD</font><br>\n";
}

