// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IGESSelect_WorkLibrary_HeaderFile
#define _IGESSelect_WorkLibrary_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_IGESSelect_WorkLibrary.hxx>

#include <Standard_Boolean.hxx>
#include <IFSelect_WorkLibrary.hxx>
#include <Standard_Integer.hxx>
#include <Standard_CString.hxx>
#include <Handle_Interface_InterfaceModel.hxx>
#include <Handle_Interface_Protocol.hxx>
#include <Handle_IGESData_Protocol.hxx>
#include <Handle_Standard_Transient.hxx>
#include <Handle_Message_Messenger.hxx>
class Interface_InterfaceModel;
class Interface_Protocol;
class IFSelect_ContextWrite;
class IGESData_Protocol;
class Standard_Transient;
class Message_Messenger;


//! Performs Read and Write an IGES File with an IGES Model
class IGESSelect_WorkLibrary : public IFSelect_WorkLibrary
{

public:

  
  //! Creates a IGES WorkLibrary
  //! If <modefnes> is given as True, it will work for FNES
  Standard_EXPORT IGESSelect_WorkLibrary(const Standard_Boolean modefnes = Standard_False);
  
  //! Reads a IGES File and returns a IGES Model (into <mod>),
  //! or lets <mod> "Null" in case of Error
  //! Returns 0 if OK, 1 if Read Error, -1 if File not opened
  Standard_EXPORT   Standard_Integer ReadFile (const Standard_CString name, Handle(Interface_InterfaceModel)& model, const Handle(Interface_Protocol)& protocol)  const;
  
  //! Writes a File from a IGES Model (brought by <ctx>)
  //! Returns False (and writes no file) if <ctx> is not for IGES
  Standard_EXPORT   Standard_Boolean WriteFile (IFSelect_ContextWrite& ctx)  const;
  
  //! Defines a protocol to be adequate for IGES
  //! (encompasses ALL the IGES norm including IGESSolid, IGESAppli)
  Standard_EXPORT static   Handle(IGESData_Protocol) DefineProtocol() ;
  
  //! Dumps an IGES Entity with an IGES Dumper. <level> is the one
  //! used by IGESDumper.
  Standard_EXPORT   void DumpEntity (const Handle(Interface_InterfaceModel)& model, const Handle(Interface_Protocol)& protocol, const Handle(Standard_Transient)& entity, const Handle(Message_Messenger)& S, const Standard_Integer level)  const;




  DEFINE_STANDARD_RTTI(IGESSelect_WorkLibrary)

protected:




private: 


  Standard_Boolean themodefnes;


};







#endif // _IGESSelect_WorkLibrary_HeaderFile
