// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IGESSelect_AddFileComment_HeaderFile
#define _IGESSelect_AddFileComment_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_IGESSelect_AddFileComment.hxx>

#include <Handle_TColStd_HSequenceOfHAsciiString.hxx>
#include <IGESSelect_FileModifier.hxx>
#include <Standard_CString.hxx>
#include <Standard_Integer.hxx>
class TColStd_HSequenceOfHAsciiString;
class IFSelect_ContextWrite;
class IGESData_IGESWriter;
class TCollection_AsciiString;


//! This class allows to add comment lines on writing an IGES File
//! These lines are added to Start Section, instead of the only
//! one blank line written by default.
class IGESSelect_AddFileComment : public IGESSelect_FileModifier
{

public:

  
  //! Creates a new emoty AddFileComment. Use AddLine to complete it
  Standard_EXPORT IGESSelect_AddFileComment();
  
  //! Clears the list of file comment lines already stored
  Standard_EXPORT   void Clear() ;
  
  //! Adds a line for file comment
  //! Remark : Lines are limited to 72 useful char.s . A line of more than
  //! 72 char.s will be splited into several ones of 72 max each.
  Standard_EXPORT   void AddLine (const Standard_CString line) ;
  
  //! Adds a list of lines for file comment
  //! Each of them must comply with demand of AddLine
  Standard_EXPORT   void AddLines (const Handle(TColStd_HSequenceOfHAsciiString)& lines) ;
  
  //! Returns the count of stored lines
  Standard_EXPORT   Standard_Integer NbLines()  const;
  
  //! Returns a stored line given its rank
  Standard_EXPORT   Standard_CString Line (const Standard_Integer num)  const;
  
  //! Returns the complete list of lines in once
  Standard_EXPORT   Handle(TColStd_HSequenceOfHAsciiString) Lines()  const;
  
  //! Sends the comment lines to the file (Start Section)
  Standard_EXPORT   void Perform (IFSelect_ContextWrite& ctx, IGESData_IGESWriter& writer)  const;
  
  //! Returns specific Label, which is
  //! "Add <nn> Comment Lines (Start Section)"
  Standard_EXPORT   TCollection_AsciiString Label()  const;




  DEFINE_STANDARD_RTTI(IGESSelect_AddFileComment)

protected:




private: 


  Handle(TColStd_HSequenceOfHAsciiString) thelist;


};







#endif // _IGESSelect_AddFileComment_HeaderFile
