---
id: fast-foundation.foundationelement
title: FoundationElement class
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-foundation](./fast-foundation.md) &gt; [FoundationElement](./fast-foundation.foundationelement.md)

## FoundationElement class

Defines a foundation element class that: 1. Connects the element to its ComponentPresentation 2. Allows resolving the element template from the instance or ComponentPresentation 3. Allows resolving the element styles from the instance or ComponentPresentation

<b>Signature:</b>

```typescript
export declare class FoundationElement extends FASTElement 
```

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [$presentation](./fast-foundation.foundationelement._presentation.md) |  | [ComponentPresentation](./fast-foundation.componentpresentation.md) \| null | A property which resolves the ComponentPresentation instance for the current component. |
|  [styles](./fast-foundation.foundationelement.styles.md) |  | [ElementStyles](./fast-element.elementstyles.md) \| void \| null | Sets the default styles for the element instance. When undefined, the element will attempt to resolve default styles from the associated presentation or custom element definition. |
|  [template](./fast-foundation.foundationelement.template.md) |  | [ElementViewTemplate](./fast-element.elementviewtemplate.md) \| void \| null | Sets the template of the element instance. When undefined, the element will attempt to resolve the template from the associated presentation or custom element definition. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [compose(this, elementDefinition)](./fast-foundation.foundationelement.compose.md) | <code>static</code> | Defines an element registry function with a set of element definition defaults. |
|  [connectedCallback()](./fast-foundation.foundationelement.connectedcallback.md) |  | The connected callback for this FASTElement. |
|  [stylesChanged()](./fast-foundation.foundationelement.styleschanged.md) |  |  |
|  [templateChanged()](./fast-foundation.foundationelement.templatechanged.md) |  |  |
