/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sxpath;

import javax.xml.transform.Source;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternSponsor;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathStaticContext;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.Type;

public class XPathEvaluator {
    private XPathStaticContext staticContext;
    private boolean stripSpace = false;

    public XPathEvaluator() {
        this(new Configuration());
    }

    public XPathEvaluator(Configuration config) {
        this.staticContext = new IndependentContext(config);
    }

    public Configuration getConfiguration() {
        return this.staticContext.getConfiguration();
    }

    public void setStripSpace(boolean strip) {
        this.stripSpace = strip;
    }

    public NodeInfo build(Source source) throws XPathException {
        if (this.stripSpace) {
            AugmentedSource as = AugmentedSource.makeAugmentedSource(source);
            as.setStripSpace(2);
            source = as;
        } else if (source instanceof NodeInfo) {
            return (NodeInfo)source;
        }
        return this.getConfiguration().buildDocument(source);
    }

    public XPathVariable declareVariable(String uri, String localName) {
        return this.staticContext.declareVariable(uri, localName);
    }

    public void setStaticContext(XPathStaticContext context) {
        this.staticContext = context;
    }

    public XPathStaticContext getStaticContext() {
        return this.staticContext;
    }

    public Executable getExecutable() {
        return this.staticContext.getExecutable();
    }

    public XPathExpression createExpression(String expression) throws XPathException {
        Expression exp = ExpressionTool.make(expression, this.staticContext, 0, -1, 1, false);
        exp.setContainer(this.staticContext);
        ExpressionVisitor visitor = ExpressionVisitor.make(this.staticContext);
        visitor.setExecutable(this.getExecutable());
        exp = visitor.typeCheck(exp, Type.ITEM_TYPE);
        exp = visitor.optimize(exp, Type.ITEM_TYPE);
        SlotManager map = this.staticContext.getStackFrameMap();
        int numberOfExternalVariables = map.getNumberOfVariables();
        ExpressionTool.allocateSlots(exp, numberOfExternalVariables, map);
        XPathExpression xpe = new XPathExpression(this, exp);
        xpe.setStackFrameMap(map, numberOfExternalVariables);
        return xpe;
    }

    public XPathExpression createPattern(String pattern) throws XPathException {
        Pattern pat = Pattern.make(pattern, this.staticContext, this.staticContext.getExecutable());
        ExpressionVisitor visitor = ExpressionVisitor.make(this.staticContext);
        pat.analyze(visitor, Type.NODE_TYPE);
        SlotManager map = this.staticContext.getStackFrameMap();
        int slots = map.getNumberOfVariables();
        slots = pat.allocateSlots(this.staticContext, map, slots);
        PatternSponsor sponsor = new PatternSponsor(pat);
        XPathExpression xpe = new XPathExpression(this, sponsor);
        xpe.setStackFrameMap(map, slots);
        return xpe;
    }

    public void setNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.staticContext.setNamespaceResolver(namespaceResolver);
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.staticContext.getNamespaceResolver();
    }

    public void setDefaultElementNamespace(String uri) {
        this.staticContext.setDefaultElementNamespace(uri);
    }

    public static void main(String[] args) throws Exception {
        XPathEvaluator xpe = new XPathEvaluator();
        xpe.createPattern("text()[position() = last()]");
    }
}

