/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import net.sf.saxon.sort.IntArraySet;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.sort.IntToIntHashMap;
import net.sf.saxon.sort.IntToIntMap;

public class CaseVariants {
    private static IntToIntMap monoVariants = new IntToIntHashMap(2500);
    private static IntHashMap<int[]> polyVariants = new IntHashMap(100);
    public static int[] ROMAN_VARIANTS = new int[]{304, 305, 8490, 383};

    private static void cv(int a, int b) {
        monoVariants.put(a, b);
    }

    private static void cv(int a, int b, int c) {
        int[] v = new int[]{b, c};
        polyVariants.put(a, v);
    }

    private static void cv(int a, int b, int c, int d) {
        int[] v = new int[]{b, c, d};
        polyVariants.put(a, v);
    }

    public static int[] getCaseVariants(int code) {
        int mono = monoVariants.get(code);
        if (mono != monoVariants.getDefaultValue()) {
            return new int[]{mono};
        }
        int[] result = polyVariants.get(code);
        if (result == null) {
            return IntArraySet.EMPTY_INT_ARRAY;
        }
        return result;
    }

    static {
        CaseVariants.cv(65, 97);
        CaseVariants.cv(66, 98);
        CaseVariants.cv(67, 99);
        CaseVariants.cv(68, 100);
        CaseVariants.cv(69, 101);
        CaseVariants.cv(70, 102);
        CaseVariants.cv(71, 103);
        CaseVariants.cv(72, 104);
        CaseVariants.cv(73, 105, 304, 305);
        CaseVariants.cv(74, 106);
        CaseVariants.cv(75, 107, 8490);
        CaseVariants.cv(76, 108);
        CaseVariants.cv(77, 109);
        CaseVariants.cv(78, 110);
        CaseVariants.cv(79, 111);
        CaseVariants.cv(80, 112);
        CaseVariants.cv(81, 113);
        CaseVariants.cv(82, 114);
        CaseVariants.cv(83, 115, 383);
        CaseVariants.cv(84, 116);
        CaseVariants.cv(85, 117);
        CaseVariants.cv(86, 118);
        CaseVariants.cv(87, 119);
        CaseVariants.cv(88, 120);
        CaseVariants.cv(89, 121);
        CaseVariants.cv(90, 122);
        CaseVariants.cv(97, 65);
        CaseVariants.cv(98, 66);
        CaseVariants.cv(99, 67);
        CaseVariants.cv(100, 68);
        CaseVariants.cv(101, 69);
        CaseVariants.cv(102, 70);
        CaseVariants.cv(103, 71);
        CaseVariants.cv(104, 72);
        CaseVariants.cv(105, 73, 304, 305);
        CaseVariants.cv(106, 74);
        CaseVariants.cv(107, 75, 8490);
        CaseVariants.cv(108, 76);
        CaseVariants.cv(109, 77);
        CaseVariants.cv(110, 78);
        CaseVariants.cv(111, 79);
        CaseVariants.cv(112, 80);
        CaseVariants.cv(113, 81);
        CaseVariants.cv(114, 82);
        CaseVariants.cv(115, 83, 383);
        CaseVariants.cv(116, 84);
        CaseVariants.cv(117, 85);
        CaseVariants.cv(118, 86);
        CaseVariants.cv(119, 87);
        CaseVariants.cv(120, 88);
        CaseVariants.cv(121, 89);
        CaseVariants.cv(122, 90);
        CaseVariants.cv(181, 924, 956);
        CaseVariants.cv(192, 224);
        CaseVariants.cv(193, 225);
        CaseVariants.cv(194, 226);
        CaseVariants.cv(195, 227);
        CaseVariants.cv(196, 228);
        CaseVariants.cv(197, 229, 8491);
        CaseVariants.cv(198, 230);
        CaseVariants.cv(199, 231);
        CaseVariants.cv(200, 232);
        CaseVariants.cv(201, 233);
        CaseVariants.cv(202, 234);
        CaseVariants.cv(203, 235);
        CaseVariants.cv(204, 236);
        CaseVariants.cv(205, 237);
        CaseVariants.cv(206, 238);
        CaseVariants.cv(207, 239);
        CaseVariants.cv(208, 240);
        CaseVariants.cv(209, 241);
        CaseVariants.cv(210, 242);
        CaseVariants.cv(211, 243);
        CaseVariants.cv(212, 244);
        CaseVariants.cv(213, 245);
        CaseVariants.cv(214, 246);
        CaseVariants.cv(216, 248);
        CaseVariants.cv(217, 249);
        CaseVariants.cv(218, 250);
        CaseVariants.cv(219, 251);
        CaseVariants.cv(220, 252);
        CaseVariants.cv(221, 253);
        CaseVariants.cv(222, 254);
        CaseVariants.cv(224, 192);
        CaseVariants.cv(225, 193);
        CaseVariants.cv(226, 194);
        CaseVariants.cv(227, 195);
        CaseVariants.cv(228, 196);
        CaseVariants.cv(229, 197, 8491);
        CaseVariants.cv(230, 198);
        CaseVariants.cv(231, 199);
        CaseVariants.cv(232, 200);
        CaseVariants.cv(233, 201);
        CaseVariants.cv(234, 202);
        CaseVariants.cv(235, 203);
        CaseVariants.cv(236, 204);
        CaseVariants.cv(237, 205);
        CaseVariants.cv(238, 206);
        CaseVariants.cv(239, 207);
        CaseVariants.cv(240, 208);
        CaseVariants.cv(241, 209);
        CaseVariants.cv(242, 210);
        CaseVariants.cv(243, 211);
        CaseVariants.cv(244, 212);
        CaseVariants.cv(245, 213);
        CaseVariants.cv(246, 214);
        CaseVariants.cv(248, 216);
        CaseVariants.cv(249, 217);
        CaseVariants.cv(250, 218);
        CaseVariants.cv(251, 219);
        CaseVariants.cv(252, 220);
        CaseVariants.cv(253, 221);
        CaseVariants.cv(254, 222);
        CaseVariants.cv(255, 376);
        CaseVariants.cv(256, 257);
        CaseVariants.cv(257, 256);
        CaseVariants.cv(258, 259);
        CaseVariants.cv(259, 258);
        CaseVariants.cv(260, 261);
        CaseVariants.cv(261, 260);
        CaseVariants.cv(262, 263);
        CaseVariants.cv(263, 262);
        CaseVariants.cv(264, 265);
        CaseVariants.cv(265, 264);
        CaseVariants.cv(266, 267);
        CaseVariants.cv(267, 266);
        CaseVariants.cv(268, 269);
        CaseVariants.cv(269, 268);
        CaseVariants.cv(270, 271);
        CaseVariants.cv(271, 270);
        CaseVariants.cv(272, 273);
        CaseVariants.cv(273, 272);
        CaseVariants.cv(274, 275);
        CaseVariants.cv(275, 274);
        CaseVariants.cv(276, 277);
        CaseVariants.cv(277, 276);
        CaseVariants.cv(278, 279);
        CaseVariants.cv(279, 278);
        CaseVariants.cv(280, 281);
        CaseVariants.cv(281, 280);
        CaseVariants.cv(282, 283);
        CaseVariants.cv(283, 282);
        CaseVariants.cv(284, 285);
        CaseVariants.cv(285, 284);
        CaseVariants.cv(286, 287);
        CaseVariants.cv(287, 286);
        CaseVariants.cv(288, 289);
        CaseVariants.cv(289, 288);
        CaseVariants.cv(290, 291);
        CaseVariants.cv(291, 290);
        CaseVariants.cv(292, 293);
        CaseVariants.cv(293, 292);
        CaseVariants.cv(294, 295);
        CaseVariants.cv(295, 294);
        CaseVariants.cv(296, 297);
        CaseVariants.cv(297, 296);
        CaseVariants.cv(298, 299);
        CaseVariants.cv(299, 298);
        CaseVariants.cv(300, 301);
        CaseVariants.cv(301, 300);
        CaseVariants.cv(302, 303);
        CaseVariants.cv(303, 302);
        CaseVariants.cv(304, 73, 105);
        CaseVariants.cv(305, 73, 105);
        CaseVariants.cv(306, 307);
        CaseVariants.cv(307, 306);
        CaseVariants.cv(308, 309);
        CaseVariants.cv(309, 308);
        CaseVariants.cv(310, 311);
        CaseVariants.cv(311, 310);
        CaseVariants.cv(313, 314);
        CaseVariants.cv(314, 313);
        CaseVariants.cv(315, 316);
        CaseVariants.cv(316, 315);
        CaseVariants.cv(317, 318);
        CaseVariants.cv(318, 317);
        CaseVariants.cv(319, 320);
        CaseVariants.cv(320, 319);
        CaseVariants.cv(321, 322);
        CaseVariants.cv(322, 321);
        CaseVariants.cv(323, 324);
        CaseVariants.cv(324, 323);
        CaseVariants.cv(325, 326);
        CaseVariants.cv(326, 325);
        CaseVariants.cv(327, 328);
        CaseVariants.cv(328, 327);
        CaseVariants.cv(330, 331);
        CaseVariants.cv(331, 330);
        CaseVariants.cv(332, 333);
        CaseVariants.cv(333, 332);
        CaseVariants.cv(334, 335);
        CaseVariants.cv(335, 334);
        CaseVariants.cv(336, 337);
        CaseVariants.cv(337, 336);
        CaseVariants.cv(338, 339);
        CaseVariants.cv(339, 338);
        CaseVariants.cv(340, 341);
        CaseVariants.cv(341, 340);
        CaseVariants.cv(342, 343);
        CaseVariants.cv(343, 342);
        CaseVariants.cv(344, 345);
        CaseVariants.cv(345, 344);
        CaseVariants.cv(346, 347);
        CaseVariants.cv(347, 346);
        CaseVariants.cv(348, 349);
        CaseVariants.cv(349, 348);
        CaseVariants.cv(350, 351);
        CaseVariants.cv(351, 350);
        CaseVariants.cv(352, 353);
        CaseVariants.cv(353, 352);
        CaseVariants.cv(354, 355);
        CaseVariants.cv(355, 354);
        CaseVariants.cv(356, 357);
        CaseVariants.cv(357, 356);
        CaseVariants.cv(358, 359);
        CaseVariants.cv(359, 358);
        CaseVariants.cv(360, 361);
        CaseVariants.cv(361, 360);
        CaseVariants.cv(362, 363);
        CaseVariants.cv(363, 362);
        CaseVariants.cv(364, 365);
        CaseVariants.cv(365, 364);
        CaseVariants.cv(366, 367);
        CaseVariants.cv(367, 366);
        CaseVariants.cv(368, 369);
        CaseVariants.cv(369, 368);
        CaseVariants.cv(370, 371);
        CaseVariants.cv(371, 370);
        CaseVariants.cv(372, 373);
        CaseVariants.cv(373, 372);
        CaseVariants.cv(374, 375);
        CaseVariants.cv(375, 374);
        CaseVariants.cv(376, 255);
        CaseVariants.cv(377, 378);
        CaseVariants.cv(378, 377);
        CaseVariants.cv(379, 380);
        CaseVariants.cv(380, 379);
        CaseVariants.cv(381, 382);
        CaseVariants.cv(382, 381);
        CaseVariants.cv(383, 83, 115);
        CaseVariants.cv(385, 595);
        CaseVariants.cv(386, 387);
        CaseVariants.cv(387, 386);
        CaseVariants.cv(388, 389);
        CaseVariants.cv(389, 388);
        CaseVariants.cv(390, 596);
        CaseVariants.cv(391, 392);
        CaseVariants.cv(392, 391);
        CaseVariants.cv(393, 598);
        CaseVariants.cv(394, 599);
        CaseVariants.cv(395, 396);
        CaseVariants.cv(396, 395);
        CaseVariants.cv(398, 477);
        CaseVariants.cv(399, 601);
        CaseVariants.cv(400, 603);
        CaseVariants.cv(401, 402);
        CaseVariants.cv(402, 401);
        CaseVariants.cv(403, 608);
        CaseVariants.cv(404, 611);
        CaseVariants.cv(405, 502);
        CaseVariants.cv(406, 617);
        CaseVariants.cv(407, 616);
        CaseVariants.cv(408, 409);
        CaseVariants.cv(409, 408);
        CaseVariants.cv(410, 573);
        CaseVariants.cv(412, 623);
        CaseVariants.cv(413, 626);
        CaseVariants.cv(414, 544);
        CaseVariants.cv(415, 629);
        CaseVariants.cv(416, 417);
        CaseVariants.cv(417, 416);
        CaseVariants.cv(418, 419);
        CaseVariants.cv(419, 418);
        CaseVariants.cv(420, 421);
        CaseVariants.cv(421, 420);
        CaseVariants.cv(422, 640);
        CaseVariants.cv(423, 424);
        CaseVariants.cv(424, 423);
        CaseVariants.cv(425, 643);
        CaseVariants.cv(428, 429);
        CaseVariants.cv(429, 428);
        CaseVariants.cv(430, 648);
        CaseVariants.cv(431, 432);
        CaseVariants.cv(432, 431);
        CaseVariants.cv(433, 650);
        CaseVariants.cv(434, 651);
        CaseVariants.cv(435, 436);
        CaseVariants.cv(436, 435);
        CaseVariants.cv(437, 438);
        CaseVariants.cv(438, 437);
        CaseVariants.cv(439, 658);
        CaseVariants.cv(440, 441);
        CaseVariants.cv(441, 440);
        CaseVariants.cv(444, 445);
        CaseVariants.cv(445, 444);
        CaseVariants.cv(447, 503);
        CaseVariants.cv(452, 453, 454);
        CaseVariants.cv(453, 452, 454);
        CaseVariants.cv(454, 452, 453);
        CaseVariants.cv(455, 456, 457);
        CaseVariants.cv(456, 455, 457);
        CaseVariants.cv(457, 455, 456);
        CaseVariants.cv(458, 459, 460);
        CaseVariants.cv(459, 458, 460);
        CaseVariants.cv(460, 458, 459);
        CaseVariants.cv(461, 462);
        CaseVariants.cv(462, 461);
        CaseVariants.cv(463, 464);
        CaseVariants.cv(464, 463);
        CaseVariants.cv(465, 466);
        CaseVariants.cv(466, 465);
        CaseVariants.cv(467, 468);
        CaseVariants.cv(468, 467);
        CaseVariants.cv(469, 470);
        CaseVariants.cv(470, 469);
        CaseVariants.cv(471, 472);
        CaseVariants.cv(472, 471);
        CaseVariants.cv(473, 474);
        CaseVariants.cv(474, 473);
        CaseVariants.cv(475, 476);
        CaseVariants.cv(476, 475);
        CaseVariants.cv(477, 398);
        CaseVariants.cv(478, 479);
        CaseVariants.cv(479, 478);
        CaseVariants.cv(480, 481);
        CaseVariants.cv(481, 480);
        CaseVariants.cv(482, 483);
        CaseVariants.cv(483, 482);
        CaseVariants.cv(484, 485);
        CaseVariants.cv(485, 484);
        CaseVariants.cv(486, 487);
        CaseVariants.cv(487, 486);
        CaseVariants.cv(488, 489);
        CaseVariants.cv(489, 488);
        CaseVariants.cv(490, 491);
        CaseVariants.cv(491, 490);
        CaseVariants.cv(492, 493);
        CaseVariants.cv(493, 492);
        CaseVariants.cv(494, 495);
        CaseVariants.cv(495, 494);
        CaseVariants.cv(497, 498, 499);
        CaseVariants.cv(498, 497, 499);
        CaseVariants.cv(499, 497, 498);
        CaseVariants.cv(500, 501);
        CaseVariants.cv(501, 500);
        CaseVariants.cv(502, 405);
        CaseVariants.cv(503, 447);
        CaseVariants.cv(504, 505);
        CaseVariants.cv(505, 504);
        CaseVariants.cv(506, 507);
        CaseVariants.cv(507, 506);
        CaseVariants.cv(508, 509);
        CaseVariants.cv(509, 508);
        CaseVariants.cv(510, 511);
        CaseVariants.cv(511, 510);
        CaseVariants.cv(512, 513);
        CaseVariants.cv(513, 512);
        CaseVariants.cv(514, 515);
        CaseVariants.cv(515, 514);
        CaseVariants.cv(516, 517);
        CaseVariants.cv(517, 516);
        CaseVariants.cv(518, 519);
        CaseVariants.cv(519, 518);
        CaseVariants.cv(520, 521);
        CaseVariants.cv(521, 520);
        CaseVariants.cv(522, 523);
        CaseVariants.cv(523, 522);
        CaseVariants.cv(524, 525);
        CaseVariants.cv(525, 524);
        CaseVariants.cv(526, 527);
        CaseVariants.cv(527, 526);
        CaseVariants.cv(528, 529);
        CaseVariants.cv(529, 528);
        CaseVariants.cv(530, 531);
        CaseVariants.cv(531, 530);
        CaseVariants.cv(532, 533);
        CaseVariants.cv(533, 532);
        CaseVariants.cv(534, 535);
        CaseVariants.cv(535, 534);
        CaseVariants.cv(536, 537);
        CaseVariants.cv(537, 536);
        CaseVariants.cv(538, 539);
        CaseVariants.cv(539, 538);
        CaseVariants.cv(540, 541);
        CaseVariants.cv(541, 540);
        CaseVariants.cv(542, 543);
        CaseVariants.cv(543, 542);
        CaseVariants.cv(544, 414);
        CaseVariants.cv(546, 547);
        CaseVariants.cv(547, 546);
        CaseVariants.cv(548, 549);
        CaseVariants.cv(549, 548);
        CaseVariants.cv(550, 551);
        CaseVariants.cv(551, 550);
        CaseVariants.cv(552, 553);
        CaseVariants.cv(553, 552);
        CaseVariants.cv(554, 555);
        CaseVariants.cv(555, 554);
        CaseVariants.cv(556, 557);
        CaseVariants.cv(557, 556);
        CaseVariants.cv(558, 559);
        CaseVariants.cv(559, 558);
        CaseVariants.cv(560, 561);
        CaseVariants.cv(561, 560);
        CaseVariants.cv(562, 563);
        CaseVariants.cv(563, 562);
        CaseVariants.cv(571, 572);
        CaseVariants.cv(572, 571);
        CaseVariants.cv(573, 410);
        CaseVariants.cv(577, 660);
        CaseVariants.cv(595, 385);
        CaseVariants.cv(596, 390);
        CaseVariants.cv(598, 393);
        CaseVariants.cv(599, 394);
        CaseVariants.cv(601, 399);
        CaseVariants.cv(603, 400);
        CaseVariants.cv(608, 403);
        CaseVariants.cv(611, 404);
        CaseVariants.cv(616, 407);
        CaseVariants.cv(617, 406);
        CaseVariants.cv(623, 412);
        CaseVariants.cv(626, 413);
        CaseVariants.cv(629, 415);
        CaseVariants.cv(640, 422);
        CaseVariants.cv(643, 425);
        CaseVariants.cv(648, 430);
        CaseVariants.cv(650, 433);
        CaseVariants.cv(651, 434);
        CaseVariants.cv(658, 439);
        CaseVariants.cv(660, 577);
        CaseVariants.cv(837, 921, 953, 8126);
        CaseVariants.cv(902, 940);
        CaseVariants.cv(904, 941);
        CaseVariants.cv(905, 942);
        CaseVariants.cv(906, 943);
        CaseVariants.cv(908, 972);
        CaseVariants.cv(910, 973);
        CaseVariants.cv(911, 974);
        CaseVariants.cv(913, 945);
        CaseVariants.cv(914, 946, 976);
        CaseVariants.cv(915, 947);
        CaseVariants.cv(916, 948);
        CaseVariants.cv(917, 949, 1013);
        CaseVariants.cv(918, 950);
        CaseVariants.cv(919, 951);
        CaseVariants.cv(920, 952, 977, 1012);
        CaseVariants.cv(921, 837, 953, 8126);
        CaseVariants.cv(922, 954, 1008);
        CaseVariants.cv(923, 955);
        CaseVariants.cv(924, 181, 956);
        CaseVariants.cv(925, 957);
        CaseVariants.cv(926, 958);
        CaseVariants.cv(927, 959);
        CaseVariants.cv(928, 960, 982);
        CaseVariants.cv(929, 961, 1009);
        CaseVariants.cv(931, 962, 963);
        CaseVariants.cv(932, 964);
        CaseVariants.cv(933, 965);
        CaseVariants.cv(934, 966, 981);
        CaseVariants.cv(935, 967);
        CaseVariants.cv(936, 968);
        CaseVariants.cv(937, 969, 8486);
        CaseVariants.cv(938, 970);
        CaseVariants.cv(939, 971);
        CaseVariants.cv(940, 902);
        CaseVariants.cv(941, 904);
        CaseVariants.cv(942, 905);
        CaseVariants.cv(943, 906);
        CaseVariants.cv(945, 913);
        CaseVariants.cv(946, 914, 976);
        CaseVariants.cv(947, 915);
        CaseVariants.cv(948, 916);
        CaseVariants.cv(949, 917, 1013);
        CaseVariants.cv(950, 918);
        CaseVariants.cv(951, 919);
        CaseVariants.cv(952, 920, 977, 1012);
        CaseVariants.cv(953, 837, 921, 8126);
        CaseVariants.cv(954, 922, 1008);
        CaseVariants.cv(955, 923);
        CaseVariants.cv(956, 181, 924);
        CaseVariants.cv(957, 925);
        CaseVariants.cv(958, 926);
        CaseVariants.cv(959, 927);
        CaseVariants.cv(960, 928, 982);
        CaseVariants.cv(961, 929, 1009);
        CaseVariants.cv(962, 931, 963);
        CaseVariants.cv(963, 931, 962);
        CaseVariants.cv(964, 932);
        CaseVariants.cv(965, 933);
        CaseVariants.cv(966, 934, 981);
        CaseVariants.cv(967, 935);
        CaseVariants.cv(968, 936);
        CaseVariants.cv(969, 937, 8486);
        CaseVariants.cv(970, 938);
        CaseVariants.cv(971, 939);
        CaseVariants.cv(972, 908);
        CaseVariants.cv(973, 910);
        CaseVariants.cv(974, 911);
        CaseVariants.cv(976, 914, 946);
        CaseVariants.cv(977, 920, 952);
        CaseVariants.cv(981, 934, 966);
        CaseVariants.cv(982, 928, 960);
        CaseVariants.cv(984, 985);
        CaseVariants.cv(985, 984);
        CaseVariants.cv(986, 987);
        CaseVariants.cv(987, 986);
        CaseVariants.cv(988, 989);
        CaseVariants.cv(989, 988);
        CaseVariants.cv(990, 991);
        CaseVariants.cv(991, 990);
        CaseVariants.cv(992, 993);
        CaseVariants.cv(993, 992);
        CaseVariants.cv(994, 995);
        CaseVariants.cv(995, 994);
        CaseVariants.cv(996, 997);
        CaseVariants.cv(997, 996);
        CaseVariants.cv(998, 999);
        CaseVariants.cv(999, 998);
        CaseVariants.cv(1000, 1001);
        CaseVariants.cv(1001, 1000);
        CaseVariants.cv(1002, 1003);
        CaseVariants.cv(1003, 1002);
        CaseVariants.cv(1004, 1005);
        CaseVariants.cv(1005, 1004);
        CaseVariants.cv(1006, 1007);
        CaseVariants.cv(1007, 1006);
        CaseVariants.cv(1008, 922, 954);
        CaseVariants.cv(1009, 929, 961);
        CaseVariants.cv(1010, 1017);
        CaseVariants.cv(1012, 920, 952);
        CaseVariants.cv(1013, 917, 949);
        CaseVariants.cv(1015, 1016);
        CaseVariants.cv(1016, 1015);
        CaseVariants.cv(1017, 1010);
        CaseVariants.cv(1018, 1019);
        CaseVariants.cv(1019, 1018);
        CaseVariants.cv(1024, 1104);
        CaseVariants.cv(1025, 1105);
        CaseVariants.cv(1026, 1106);
        CaseVariants.cv(1027, 1107);
        CaseVariants.cv(1028, 1108);
        CaseVariants.cv(1029, 1109);
        CaseVariants.cv(1030, 1110);
        CaseVariants.cv(1031, 1111);
        CaseVariants.cv(1032, 1112);
        CaseVariants.cv(1033, 1113);
        CaseVariants.cv(1034, 1114);
        CaseVariants.cv(1035, 1115);
        CaseVariants.cv(1036, 1116);
        CaseVariants.cv(1037, 1117);
        CaseVariants.cv(1038, 1118);
        CaseVariants.cv(1039, 1119);
        CaseVariants.cv(1040, 1072);
        CaseVariants.cv(1041, 1073);
        CaseVariants.cv(1042, 1074);
        CaseVariants.cv(1043, 1075);
        CaseVariants.cv(1044, 1076);
        CaseVariants.cv(1045, 1077);
        CaseVariants.cv(1046, 1078);
        CaseVariants.cv(1047, 1079);
        CaseVariants.cv(1048, 1080);
        CaseVariants.cv(1049, 1081);
        CaseVariants.cv(1050, 1082);
        CaseVariants.cv(1051, 1083);
        CaseVariants.cv(1052, 1084);
        CaseVariants.cv(1053, 1085);
        CaseVariants.cv(1054, 1086);
        CaseVariants.cv(1055, 1087);
        CaseVariants.cv(1056, 1088);
        CaseVariants.cv(1057, 1089);
        CaseVariants.cv(1058, 1090);
        CaseVariants.cv(1059, 1091);
        CaseVariants.cv(1060, 1092);
        CaseVariants.cv(1061, 1093);
        CaseVariants.cv(1062, 1094);
        CaseVariants.cv(1063, 1095);
        CaseVariants.cv(1064, 1096);
        CaseVariants.cv(1065, 1097);
        CaseVariants.cv(1066, 1098);
        CaseVariants.cv(1067, 1099);
        CaseVariants.cv(1068, 1100);
        CaseVariants.cv(1069, 1101);
        CaseVariants.cv(1070, 1102);
        CaseVariants.cv(1071, 1103);
        CaseVariants.cv(1072, 1040);
        CaseVariants.cv(1073, 1041);
        CaseVariants.cv(1074, 1042);
        CaseVariants.cv(1075, 1043);
        CaseVariants.cv(1076, 1044);
        CaseVariants.cv(1077, 1045);
        CaseVariants.cv(1078, 1046);
        CaseVariants.cv(1079, 1047);
        CaseVariants.cv(1080, 1048);
        CaseVariants.cv(1081, 1049);
        CaseVariants.cv(1082, 1050);
        CaseVariants.cv(1083, 1051);
        CaseVariants.cv(1084, 1052);
        CaseVariants.cv(1085, 1053);
        CaseVariants.cv(1086, 1054);
        CaseVariants.cv(1087, 1055);
        CaseVariants.cv(1088, 1056);
        CaseVariants.cv(1089, 1057);
        CaseVariants.cv(1090, 1058);
        CaseVariants.cv(1091, 1059);
        CaseVariants.cv(1092, 1060);
        CaseVariants.cv(1093, 1061);
        CaseVariants.cv(1094, 1062);
        CaseVariants.cv(1095, 1063);
        CaseVariants.cv(1096, 1064);
        CaseVariants.cv(1097, 1065);
        CaseVariants.cv(1098, 1066);
        CaseVariants.cv(1099, 1067);
        CaseVariants.cv(1100, 1068);
        CaseVariants.cv(1101, 1069);
        CaseVariants.cv(1102, 1070);
        CaseVariants.cv(1103, 1071);
        CaseVariants.cv(1104, 1024);
        CaseVariants.cv(1105, 1025);
        CaseVariants.cv(1106, 1026);
        CaseVariants.cv(1107, 1027);
        CaseVariants.cv(1108, 1028);
        CaseVariants.cv(1109, 1029);
        CaseVariants.cv(1110, 1030);
        CaseVariants.cv(1111, 1031);
        CaseVariants.cv(1112, 1032);
        CaseVariants.cv(1113, 1033);
        CaseVariants.cv(1114, 1034);
        CaseVariants.cv(1115, 1035);
        CaseVariants.cv(1116, 1036);
        CaseVariants.cv(1117, 1037);
        CaseVariants.cv(1118, 1038);
        CaseVariants.cv(1119, 1039);
        CaseVariants.cv(1120, 1121);
        CaseVariants.cv(1121, 1120);
        CaseVariants.cv(1122, 1123);
        CaseVariants.cv(1123, 1122);
        CaseVariants.cv(1124, 1125);
        CaseVariants.cv(1125, 1124);
        CaseVariants.cv(1126, 1127);
        CaseVariants.cv(1127, 1126);
        CaseVariants.cv(1128, 1129);
        CaseVariants.cv(1129, 1128);
        CaseVariants.cv(1130, 1131);
        CaseVariants.cv(1131, 1130);
        CaseVariants.cv(1132, 1133);
        CaseVariants.cv(1133, 1132);
        CaseVariants.cv(1134, 1135);
        CaseVariants.cv(1135, 1134);
        CaseVariants.cv(1136, 1137);
        CaseVariants.cv(1137, 1136);
        CaseVariants.cv(1138, 1139);
        CaseVariants.cv(1139, 1138);
        CaseVariants.cv(1140, 1141);
        CaseVariants.cv(1141, 1140);
        CaseVariants.cv(1142, 1143);
        CaseVariants.cv(1143, 1142);
        CaseVariants.cv(1144, 1145);
        CaseVariants.cv(1145, 1144);
        CaseVariants.cv(1146, 1147);
        CaseVariants.cv(1147, 1146);
        CaseVariants.cv(1148, 1149);
        CaseVariants.cv(1149, 1148);
        CaseVariants.cv(1150, 1151);
        CaseVariants.cv(1151, 1150);
        CaseVariants.cv(1152, 1153);
        CaseVariants.cv(1153, 1152);
        CaseVariants.cv(1162, 1163);
        CaseVariants.cv(1163, 1162);
        CaseVariants.cv(1164, 1165);
        CaseVariants.cv(1165, 1164);
        CaseVariants.cv(1166, 1167);
        CaseVariants.cv(1167, 1166);
        CaseVariants.cv(1168, 1169);
        CaseVariants.cv(1169, 1168);
        CaseVariants.cv(1170, 1171);
        CaseVariants.cv(1171, 1170);
        CaseVariants.cv(1172, 1173);
        CaseVariants.cv(1173, 1172);
        CaseVariants.cv(1174, 1175);
        CaseVariants.cv(1175, 1174);
        CaseVariants.cv(1176, 1177);
        CaseVariants.cv(1177, 1176);
        CaseVariants.cv(1178, 1179);
        CaseVariants.cv(1179, 1178);
        CaseVariants.cv(1180, 1181);
        CaseVariants.cv(1181, 1180);
        CaseVariants.cv(1182, 1183);
        CaseVariants.cv(1183, 1182);
        CaseVariants.cv(1184, 1185);
        CaseVariants.cv(1185, 1184);
        CaseVariants.cv(1186, 1187);
        CaseVariants.cv(1187, 1186);
        CaseVariants.cv(1188, 1189);
        CaseVariants.cv(1189, 1188);
        CaseVariants.cv(1190, 1191);
        CaseVariants.cv(1191, 1190);
        CaseVariants.cv(1192, 1193);
        CaseVariants.cv(1193, 1192);
        CaseVariants.cv(1194, 1195);
        CaseVariants.cv(1195, 1194);
        CaseVariants.cv(1196, 1197);
        CaseVariants.cv(1197, 1196);
        CaseVariants.cv(1198, 1199);
        CaseVariants.cv(1199, 1198);
        CaseVariants.cv(1200, 1201);
        CaseVariants.cv(1201, 1200);
        CaseVariants.cv(1202, 1203);
        CaseVariants.cv(1203, 1202);
        CaseVariants.cv(1204, 1205);
        CaseVariants.cv(1205, 1204);
        CaseVariants.cv(1206, 1207);
        CaseVariants.cv(1207, 1206);
        CaseVariants.cv(1208, 1209);
        CaseVariants.cv(1209, 1208);
        CaseVariants.cv(1210, 1211);
        CaseVariants.cv(1211, 1210);
        CaseVariants.cv(1212, 1213);
        CaseVariants.cv(1213, 1212);
        CaseVariants.cv(1214, 1215);
        CaseVariants.cv(1215, 1214);
        CaseVariants.cv(1217, 1218);
        CaseVariants.cv(1218, 1217);
        CaseVariants.cv(1219, 1220);
        CaseVariants.cv(1220, 1219);
        CaseVariants.cv(1221, 1222);
        CaseVariants.cv(1222, 1221);
        CaseVariants.cv(1223, 1224);
        CaseVariants.cv(1224, 1223);
        CaseVariants.cv(1225, 1226);
        CaseVariants.cv(1226, 1225);
        CaseVariants.cv(1227, 1228);
        CaseVariants.cv(1228, 1227);
        CaseVariants.cv(1229, 1230);
        CaseVariants.cv(1230, 1229);
        CaseVariants.cv(1232, 1233);
        CaseVariants.cv(1233, 1232);
        CaseVariants.cv(1234, 1235);
        CaseVariants.cv(1235, 1234);
        CaseVariants.cv(1236, 1237);
        CaseVariants.cv(1237, 1236);
        CaseVariants.cv(1238, 1239);
        CaseVariants.cv(1239, 1238);
        CaseVariants.cv(1240, 1241);
        CaseVariants.cv(1241, 1240);
        CaseVariants.cv(1242, 1243);
        CaseVariants.cv(1243, 1242);
        CaseVariants.cv(1244, 1245);
        CaseVariants.cv(1245, 1244);
        CaseVariants.cv(1246, 1247);
        CaseVariants.cv(1247, 1246);
        CaseVariants.cv(1248, 1249);
        CaseVariants.cv(1249, 1248);
        CaseVariants.cv(1250, 1251);
        CaseVariants.cv(1251, 1250);
        CaseVariants.cv(1252, 1253);
        CaseVariants.cv(1253, 1252);
        CaseVariants.cv(1254, 1255);
        CaseVariants.cv(1255, 1254);
        CaseVariants.cv(1256, 1257);
        CaseVariants.cv(1257, 1256);
        CaseVariants.cv(1258, 1259);
        CaseVariants.cv(1259, 1258);
        CaseVariants.cv(1260, 1261);
        CaseVariants.cv(1261, 1260);
        CaseVariants.cv(1262, 1263);
        CaseVariants.cv(1263, 1262);
        CaseVariants.cv(1264, 1265);
        CaseVariants.cv(1265, 1264);
        CaseVariants.cv(1266, 1267);
        CaseVariants.cv(1267, 1266);
        CaseVariants.cv(1268, 1269);
        CaseVariants.cv(1269, 1268);
        CaseVariants.cv(1270, 1271);
        CaseVariants.cv(1271, 1270);
        CaseVariants.cv(1272, 1273);
        CaseVariants.cv(1273, 1272);
        CaseVariants.cv(1280, 1281);
        CaseVariants.cv(1281, 1280);
        CaseVariants.cv(1282, 1283);
        CaseVariants.cv(1283, 1282);
        CaseVariants.cv(1284, 1285);
        CaseVariants.cv(1285, 1284);
        CaseVariants.cv(1286, 1287);
        CaseVariants.cv(1287, 1286);
        CaseVariants.cv(1288, 1289);
        CaseVariants.cv(1289, 1288);
        CaseVariants.cv(1290, 1291);
        CaseVariants.cv(1291, 1290);
        CaseVariants.cv(1292, 1293);
        CaseVariants.cv(1293, 1292);
        CaseVariants.cv(1294, 1295);
        CaseVariants.cv(1295, 1294);
        CaseVariants.cv(1329, 1377);
        CaseVariants.cv(1330, 1378);
        CaseVariants.cv(1331, 1379);
        CaseVariants.cv(1332, 1380);
        CaseVariants.cv(1333, 1381);
        CaseVariants.cv(1334, 1382);
        CaseVariants.cv(1335, 1383);
        CaseVariants.cv(1336, 1384);
        CaseVariants.cv(1337, 1385);
        CaseVariants.cv(1338, 1386);
        CaseVariants.cv(1339, 1387);
        CaseVariants.cv(1340, 1388);
        CaseVariants.cv(1341, 1389);
        CaseVariants.cv(1342, 1390);
        CaseVariants.cv(1343, 1391);
        CaseVariants.cv(1344, 1392);
        CaseVariants.cv(1345, 1393);
        CaseVariants.cv(1346, 1394);
        CaseVariants.cv(1347, 1395);
        CaseVariants.cv(1348, 1396);
        CaseVariants.cv(1349, 1397);
        CaseVariants.cv(1350, 1398);
        CaseVariants.cv(1351, 1399);
        CaseVariants.cv(1352, 1400);
        CaseVariants.cv(1353, 1401);
        CaseVariants.cv(1354, 1402);
        CaseVariants.cv(1355, 1403);
        CaseVariants.cv(1356, 1404);
        CaseVariants.cv(1357, 1405);
        CaseVariants.cv(1358, 1406);
        CaseVariants.cv(1359, 1407);
        CaseVariants.cv(1360, 1408);
        CaseVariants.cv(1361, 1409);
        CaseVariants.cv(1362, 1410);
        CaseVariants.cv(1363, 1411);
        CaseVariants.cv(1364, 1412);
        CaseVariants.cv(1365, 1413);
        CaseVariants.cv(1366, 1414);
        CaseVariants.cv(1377, 1329);
        CaseVariants.cv(1378, 1330);
        CaseVariants.cv(1379, 1331);
        CaseVariants.cv(1380, 1332);
        CaseVariants.cv(1381, 1333);
        CaseVariants.cv(1382, 1334);
        CaseVariants.cv(1383, 1335);
        CaseVariants.cv(1384, 1336);
        CaseVariants.cv(1385, 1337);
        CaseVariants.cv(1386, 1338);
        CaseVariants.cv(1387, 1339);
        CaseVariants.cv(1388, 1340);
        CaseVariants.cv(1389, 1341);
        CaseVariants.cv(1390, 1342);
        CaseVariants.cv(1391, 1343);
        CaseVariants.cv(1392, 1344);
        CaseVariants.cv(1393, 1345);
        CaseVariants.cv(1394, 1346);
        CaseVariants.cv(1395, 1347);
        CaseVariants.cv(1396, 1348);
        CaseVariants.cv(1397, 1349);
        CaseVariants.cv(1398, 1350);
        CaseVariants.cv(1399, 1351);
        CaseVariants.cv(1400, 1352);
        CaseVariants.cv(1401, 1353);
        CaseVariants.cv(1402, 1354);
        CaseVariants.cv(1403, 1355);
        CaseVariants.cv(1404, 1356);
        CaseVariants.cv(1405, 1357);
        CaseVariants.cv(1406, 1358);
        CaseVariants.cv(1407, 1359);
        CaseVariants.cv(1408, 1360);
        CaseVariants.cv(1409, 1361);
        CaseVariants.cv(1410, 1362);
        CaseVariants.cv(1411, 1363);
        CaseVariants.cv(1412, 1364);
        CaseVariants.cv(1413, 1365);
        CaseVariants.cv(1414, 1366);
        CaseVariants.cv(4256, 11520);
        CaseVariants.cv(4257, 11521);
        CaseVariants.cv(4258, 11522);
        CaseVariants.cv(4259, 11523);
        CaseVariants.cv(4260, 11524);
        CaseVariants.cv(4261, 11525);
        CaseVariants.cv(4262, 11526);
        CaseVariants.cv(4263, 11527);
        CaseVariants.cv(4264, 11528);
        CaseVariants.cv(4265, 11529);
        CaseVariants.cv(4266, 11530);
        CaseVariants.cv(4267, 11531);
        CaseVariants.cv(4268, 11532);
        CaseVariants.cv(4269, 11533);
        CaseVariants.cv(4270, 11534);
        CaseVariants.cv(4271, 11535);
        CaseVariants.cv(4272, 11536);
        CaseVariants.cv(4273, 11537);
        CaseVariants.cv(4274, 11538);
        CaseVariants.cv(4275, 11539);
        CaseVariants.cv(4276, 11540);
        CaseVariants.cv(4277, 11541);
        CaseVariants.cv(4278, 11542);
        CaseVariants.cv(4279, 11543);
        CaseVariants.cv(4280, 11544);
        CaseVariants.cv(4281, 11545);
        CaseVariants.cv(4282, 11546);
        CaseVariants.cv(4283, 11547);
        CaseVariants.cv(4284, 11548);
        CaseVariants.cv(4285, 11549);
        CaseVariants.cv(4286, 11550);
        CaseVariants.cv(4287, 11551);
        CaseVariants.cv(4288, 11552);
        CaseVariants.cv(4289, 11553);
        CaseVariants.cv(4290, 11554);
        CaseVariants.cv(4291, 11555);
        CaseVariants.cv(4292, 11556);
        CaseVariants.cv(4293, 11557);
        CaseVariants.cv(7680, 7681);
        CaseVariants.cv(7681, 7680);
        CaseVariants.cv(7682, 7683);
        CaseVariants.cv(7683, 7682);
        CaseVariants.cv(7684, 7685);
        CaseVariants.cv(7685, 7684);
        CaseVariants.cv(7686, 7687);
        CaseVariants.cv(7687, 7686);
        CaseVariants.cv(7688, 7689);
        CaseVariants.cv(7689, 7688);
        CaseVariants.cv(7690, 7691);
        CaseVariants.cv(7691, 7690);
        CaseVariants.cv(7692, 7693);
        CaseVariants.cv(7693, 7692);
        CaseVariants.cv(7694, 7695);
        CaseVariants.cv(7695, 7694);
        CaseVariants.cv(7696, 7697);
        CaseVariants.cv(7697, 7696);
        CaseVariants.cv(7698, 7699);
        CaseVariants.cv(7699, 7698);
        CaseVariants.cv(7700, 7701);
        CaseVariants.cv(7701, 7700);
        CaseVariants.cv(7702, 7703);
        CaseVariants.cv(7703, 7702);
        CaseVariants.cv(7704, 7705);
        CaseVariants.cv(7705, 7704);
        CaseVariants.cv(7706, 7707);
        CaseVariants.cv(7707, 7706);
        CaseVariants.cv(7708, 7709);
        CaseVariants.cv(7709, 7708);
        CaseVariants.cv(7710, 7711);
        CaseVariants.cv(7711, 7710);
        CaseVariants.cv(7712, 7713);
        CaseVariants.cv(7713, 7712);
        CaseVariants.cv(7714, 7715);
        CaseVariants.cv(7715, 7714);
        CaseVariants.cv(7716, 7717);
        CaseVariants.cv(7717, 7716);
        CaseVariants.cv(7718, 7719);
        CaseVariants.cv(7719, 7718);
        CaseVariants.cv(7720, 7721);
        CaseVariants.cv(7721, 7720);
        CaseVariants.cv(7722, 7723);
        CaseVariants.cv(7723, 7722);
        CaseVariants.cv(7724, 7725);
        CaseVariants.cv(7725, 7724);
        CaseVariants.cv(7726, 7727);
        CaseVariants.cv(7727, 7726);
        CaseVariants.cv(7728, 7729);
        CaseVariants.cv(7729, 7728);
        CaseVariants.cv(7730, 7731);
        CaseVariants.cv(7731, 7730);
        CaseVariants.cv(7732, 7733);
        CaseVariants.cv(7733, 7732);
        CaseVariants.cv(7734, 7735);
        CaseVariants.cv(7735, 7734);
        CaseVariants.cv(7736, 7737);
        CaseVariants.cv(7737, 7736);
        CaseVariants.cv(7738, 7739);
        CaseVariants.cv(7739, 7738);
        CaseVariants.cv(7740, 7741);
        CaseVariants.cv(7741, 7740);
        CaseVariants.cv(7742, 7743);
        CaseVariants.cv(7743, 7742);
        CaseVariants.cv(7744, 7745);
        CaseVariants.cv(7745, 7744);
        CaseVariants.cv(7746, 7747);
        CaseVariants.cv(7747, 7746);
        CaseVariants.cv(7748, 7749);
        CaseVariants.cv(7749, 7748);
        CaseVariants.cv(7750, 7751);
        CaseVariants.cv(7751, 7750);
        CaseVariants.cv(7752, 7753);
        CaseVariants.cv(7753, 7752);
        CaseVariants.cv(7754, 7755);
        CaseVariants.cv(7755, 7754);
        CaseVariants.cv(7756, 7757);
        CaseVariants.cv(7757, 7756);
        CaseVariants.cv(7758, 7759);
        CaseVariants.cv(7759, 7758);
        CaseVariants.cv(7760, 7761);
        CaseVariants.cv(7761, 7760);
        CaseVariants.cv(7762, 7763);
        CaseVariants.cv(7763, 7762);
        CaseVariants.cv(7764, 7765);
        CaseVariants.cv(7765, 7764);
        CaseVariants.cv(7766, 7767);
        CaseVariants.cv(7767, 7766);
        CaseVariants.cv(7768, 7769);
        CaseVariants.cv(7769, 7768);
        CaseVariants.cv(7770, 7771);
        CaseVariants.cv(7771, 7770);
        CaseVariants.cv(7772, 7773);
        CaseVariants.cv(7773, 7772);
        CaseVariants.cv(7774, 7775);
        CaseVariants.cv(7775, 7774);
        CaseVariants.cv(7776, 7777, 7835);
        CaseVariants.cv(7777, 7776, 7835);
        CaseVariants.cv(7778, 7779);
        CaseVariants.cv(7779, 7778);
        CaseVariants.cv(7780, 7781);
        CaseVariants.cv(7781, 7780);
        CaseVariants.cv(7782, 7783);
        CaseVariants.cv(7783, 7782);
        CaseVariants.cv(7784, 7785);
        CaseVariants.cv(7785, 7784);
        CaseVariants.cv(7786, 7787);
        CaseVariants.cv(7787, 7786);
        CaseVariants.cv(7788, 7789);
        CaseVariants.cv(7789, 7788);
        CaseVariants.cv(7790, 7791);
        CaseVariants.cv(7791, 7790);
        CaseVariants.cv(7792, 7793);
        CaseVariants.cv(7793, 7792);
        CaseVariants.cv(7794, 7795);
        CaseVariants.cv(7795, 7794);
        CaseVariants.cv(7796, 7797);
        CaseVariants.cv(7797, 7796);
        CaseVariants.cv(7798, 7799);
        CaseVariants.cv(7799, 7798);
        CaseVariants.cv(7800, 7801);
        CaseVariants.cv(7801, 7800);
        CaseVariants.cv(7802, 7803);
        CaseVariants.cv(7803, 7802);
        CaseVariants.cv(7804, 7805);
        CaseVariants.cv(7805, 7804);
        CaseVariants.cv(7806, 7807);
        CaseVariants.cv(7807, 7806);
        CaseVariants.cv(7808, 7809);
        CaseVariants.cv(7809, 7808);
        CaseVariants.cv(7810, 7811);
        CaseVariants.cv(7811, 7810);
        CaseVariants.cv(7812, 7813);
        CaseVariants.cv(7813, 7812);
        CaseVariants.cv(7814, 7815);
        CaseVariants.cv(7815, 7814);
        CaseVariants.cv(7816, 7817);
        CaseVariants.cv(7817, 7816);
        CaseVariants.cv(7818, 7819);
        CaseVariants.cv(7819, 7818);
        CaseVariants.cv(7820, 7821);
        CaseVariants.cv(7821, 7820);
        CaseVariants.cv(7822, 7823);
        CaseVariants.cv(7823, 7822);
        CaseVariants.cv(7824, 7825);
        CaseVariants.cv(7825, 7824);
        CaseVariants.cv(7826, 7827);
        CaseVariants.cv(7827, 7826);
        CaseVariants.cv(7828, 7829);
        CaseVariants.cv(7829, 7828);
        CaseVariants.cv(7835, 7776, 7777);
        CaseVariants.cv(7840, 7841);
        CaseVariants.cv(7841, 7840);
        CaseVariants.cv(7842, 7843);
        CaseVariants.cv(7843, 7842);
        CaseVariants.cv(7844, 7845);
        CaseVariants.cv(7845, 7844);
        CaseVariants.cv(7846, 7847);
        CaseVariants.cv(7847, 7846);
        CaseVariants.cv(7848, 7849);
        CaseVariants.cv(7849, 7848);
        CaseVariants.cv(7850, 7851);
        CaseVariants.cv(7851, 7850);
        CaseVariants.cv(7852, 7853);
        CaseVariants.cv(7853, 7852);
        CaseVariants.cv(7854, 7855);
        CaseVariants.cv(7855, 7854);
        CaseVariants.cv(7856, 7857);
        CaseVariants.cv(7857, 7856);
        CaseVariants.cv(7858, 7859);
        CaseVariants.cv(7859, 7858);
        CaseVariants.cv(7860, 7861);
        CaseVariants.cv(7861, 7860);
        CaseVariants.cv(7862, 7863);
        CaseVariants.cv(7863, 7862);
        CaseVariants.cv(7864, 7865);
        CaseVariants.cv(7865, 7864);
        CaseVariants.cv(7866, 7867);
        CaseVariants.cv(7867, 7866);
        CaseVariants.cv(7868, 7869);
        CaseVariants.cv(7869, 7868);
        CaseVariants.cv(7870, 7871);
        CaseVariants.cv(7871, 7870);
        CaseVariants.cv(7872, 7873);
        CaseVariants.cv(7873, 7872);
        CaseVariants.cv(7874, 7875);
        CaseVariants.cv(7875, 7874);
        CaseVariants.cv(7876, 7877);
        CaseVariants.cv(7877, 7876);
        CaseVariants.cv(7878, 7879);
        CaseVariants.cv(7879, 7878);
        CaseVariants.cv(7880, 7881);
        CaseVariants.cv(7881, 7880);
        CaseVariants.cv(7882, 7883);
        CaseVariants.cv(7883, 7882);
        CaseVariants.cv(7884, 7885);
        CaseVariants.cv(7885, 7884);
        CaseVariants.cv(7886, 7887);
        CaseVariants.cv(7887, 7886);
        CaseVariants.cv(7888, 7889);
        CaseVariants.cv(7889, 7888);
        CaseVariants.cv(7890, 7891);
        CaseVariants.cv(7891, 7890);
        CaseVariants.cv(7892, 7893);
        CaseVariants.cv(7893, 7892);
        CaseVariants.cv(7894, 7895);
        CaseVariants.cv(7895, 7894);
        CaseVariants.cv(7896, 7897);
        CaseVariants.cv(7897, 7896);
        CaseVariants.cv(7898, 7899);
        CaseVariants.cv(7899, 7898);
        CaseVariants.cv(7900, 7901);
        CaseVariants.cv(7901, 7900);
        CaseVariants.cv(7902, 7903);
        CaseVariants.cv(7903, 7902);
        CaseVariants.cv(7904, 7905);
        CaseVariants.cv(7905, 7904);
        CaseVariants.cv(7906, 7907);
        CaseVariants.cv(7907, 7906);
        CaseVariants.cv(7908, 7909);
        CaseVariants.cv(7909, 7908);
        CaseVariants.cv(7910, 7911);
        CaseVariants.cv(7911, 7910);
        CaseVariants.cv(7912, 7913);
        CaseVariants.cv(7913, 7912);
        CaseVariants.cv(7914, 7915);
        CaseVariants.cv(7915, 7914);
        CaseVariants.cv(7916, 7917);
        CaseVariants.cv(7917, 7916);
        CaseVariants.cv(7918, 7919);
        CaseVariants.cv(7919, 7918);
        CaseVariants.cv(7920, 7921);
        CaseVariants.cv(7921, 7920);
        CaseVariants.cv(7922, 7923);
        CaseVariants.cv(7923, 7922);
        CaseVariants.cv(7924, 7925);
        CaseVariants.cv(7925, 7924);
        CaseVariants.cv(7926, 7927);
        CaseVariants.cv(7927, 7926);
        CaseVariants.cv(7928, 7929);
        CaseVariants.cv(7929, 7928);
        CaseVariants.cv(7936, 7944);
        CaseVariants.cv(7937, 7945);
        CaseVariants.cv(7938, 7946);
        CaseVariants.cv(7939, 7947);
        CaseVariants.cv(7940, 7948);
        CaseVariants.cv(7941, 7949);
        CaseVariants.cv(7942, 7950);
        CaseVariants.cv(7943, 7951);
        CaseVariants.cv(7944, 7936);
        CaseVariants.cv(7945, 7937);
        CaseVariants.cv(7946, 7938);
        CaseVariants.cv(7947, 7939);
        CaseVariants.cv(7948, 7940);
        CaseVariants.cv(7949, 7941);
        CaseVariants.cv(7950, 7942);
        CaseVariants.cv(7951, 7943);
        CaseVariants.cv(7952, 7960);
        CaseVariants.cv(7953, 7961);
        CaseVariants.cv(7954, 7962);
        CaseVariants.cv(7955, 7963);
        CaseVariants.cv(7956, 7964);
        CaseVariants.cv(7957, 7965);
        CaseVariants.cv(7960, 7952);
        CaseVariants.cv(7961, 7953);
        CaseVariants.cv(7962, 7954);
        CaseVariants.cv(7963, 7955);
        CaseVariants.cv(7964, 7956);
        CaseVariants.cv(7965, 7957);
        CaseVariants.cv(7968, 7976);
        CaseVariants.cv(7969, 7977);
        CaseVariants.cv(7970, 7978);
        CaseVariants.cv(7971, 7979);
        CaseVariants.cv(7972, 7980);
        CaseVariants.cv(7973, 7981);
        CaseVariants.cv(7974, 7982);
        CaseVariants.cv(7975, 7983);
        CaseVariants.cv(7976, 7968);
        CaseVariants.cv(7977, 7969);
        CaseVariants.cv(7978, 7970);
        CaseVariants.cv(7979, 7971);
        CaseVariants.cv(7980, 7972);
        CaseVariants.cv(7981, 7973);
        CaseVariants.cv(7982, 7974);
        CaseVariants.cv(7983, 7975);
        CaseVariants.cv(7984, 7992);
        CaseVariants.cv(7985, 7993);
        CaseVariants.cv(7986, 7994);
        CaseVariants.cv(7987, 7995);
        CaseVariants.cv(7988, 7996);
        CaseVariants.cv(7989, 7997);
        CaseVariants.cv(7990, 7998);
        CaseVariants.cv(7991, 7999);
        CaseVariants.cv(7992, 7984);
        CaseVariants.cv(7993, 7985);
        CaseVariants.cv(7994, 7986);
        CaseVariants.cv(7995, 7987);
        CaseVariants.cv(7996, 7988);
        CaseVariants.cv(7997, 7989);
        CaseVariants.cv(7998, 7990);
        CaseVariants.cv(7999, 7991);
        CaseVariants.cv(8000, 8008);
        CaseVariants.cv(8001, 8009);
        CaseVariants.cv(8002, 8010);
        CaseVariants.cv(8003, 8011);
        CaseVariants.cv(8004, 8012);
        CaseVariants.cv(8005, 8013);
        CaseVariants.cv(8008, 8000);
        CaseVariants.cv(8009, 8001);
        CaseVariants.cv(8010, 8002);
        CaseVariants.cv(8011, 8003);
        CaseVariants.cv(8012, 8004);
        CaseVariants.cv(8013, 8005);
        CaseVariants.cv(8017, 8025);
        CaseVariants.cv(8019, 8027);
        CaseVariants.cv(8021, 8029);
        CaseVariants.cv(8023, 8031);
        CaseVariants.cv(8025, 8017);
        CaseVariants.cv(8027, 8019);
        CaseVariants.cv(8029, 8021);
        CaseVariants.cv(8031, 8023);
        CaseVariants.cv(8032, 8040);
        CaseVariants.cv(8033, 8041);
        CaseVariants.cv(8034, 8042);
        CaseVariants.cv(8035, 8043);
        CaseVariants.cv(8036, 8044);
        CaseVariants.cv(8037, 8045);
        CaseVariants.cv(8038, 8046);
        CaseVariants.cv(8039, 8047);
        CaseVariants.cv(8040, 8032);
        CaseVariants.cv(8041, 8033);
        CaseVariants.cv(8042, 8034);
        CaseVariants.cv(8043, 8035);
        CaseVariants.cv(8044, 8036);
        CaseVariants.cv(8045, 8037);
        CaseVariants.cv(8046, 8038);
        CaseVariants.cv(8047, 8039);
        CaseVariants.cv(8048, 8122);
        CaseVariants.cv(8049, 8123);
        CaseVariants.cv(8050, 8136);
        CaseVariants.cv(8051, 8137);
        CaseVariants.cv(8052, 8138);
        CaseVariants.cv(8053, 8139);
        CaseVariants.cv(8054, 8154);
        CaseVariants.cv(8055, 8155);
        CaseVariants.cv(8056, 8184);
        CaseVariants.cv(8057, 8185);
        CaseVariants.cv(8058, 8170);
        CaseVariants.cv(8059, 8171);
        CaseVariants.cv(8060, 8186);
        CaseVariants.cv(8061, 8187);
        CaseVariants.cv(8064, 8072);
        CaseVariants.cv(8065, 8073);
        CaseVariants.cv(8066, 8074);
        CaseVariants.cv(8067, 8075);
        CaseVariants.cv(8068, 8076);
        CaseVariants.cv(8069, 8077);
        CaseVariants.cv(8070, 8078);
        CaseVariants.cv(8071, 8079);
        CaseVariants.cv(8072, 8064);
        CaseVariants.cv(8073, 8065);
        CaseVariants.cv(8074, 8066);
        CaseVariants.cv(8075, 8067);
        CaseVariants.cv(8076, 8068);
        CaseVariants.cv(8077, 8069);
        CaseVariants.cv(8078, 8070);
        CaseVariants.cv(8079, 8071);
        CaseVariants.cv(8080, 8088);
        CaseVariants.cv(8081, 8089);
        CaseVariants.cv(8082, 8090);
        CaseVariants.cv(8083, 8091);
        CaseVariants.cv(8084, 8092);
        CaseVariants.cv(8085, 8093);
        CaseVariants.cv(8086, 8094);
        CaseVariants.cv(8087, 8095);
        CaseVariants.cv(8088, 8080);
        CaseVariants.cv(8089, 8081);
        CaseVariants.cv(8090, 8082);
        CaseVariants.cv(8091, 8083);
        CaseVariants.cv(8092, 8084);
        CaseVariants.cv(8093, 8085);
        CaseVariants.cv(8094, 8086);
        CaseVariants.cv(8095, 8087);
        CaseVariants.cv(8096, 8104);
        CaseVariants.cv(8097, 8105);
        CaseVariants.cv(8098, 8106);
        CaseVariants.cv(8099, 8107);
        CaseVariants.cv(8100, 8108);
        CaseVariants.cv(8101, 8109);
        CaseVariants.cv(8102, 8110);
        CaseVariants.cv(8103, 8111);
        CaseVariants.cv(8104, 8096);
        CaseVariants.cv(8105, 8097);
        CaseVariants.cv(8106, 8098);
        CaseVariants.cv(8107, 8099);
        CaseVariants.cv(8108, 8100);
        CaseVariants.cv(8109, 8101);
        CaseVariants.cv(8110, 8102);
        CaseVariants.cv(8111, 8103);
        CaseVariants.cv(8112, 8120);
        CaseVariants.cv(8113, 8121);
        CaseVariants.cv(8115, 8124);
        CaseVariants.cv(8120, 8112);
        CaseVariants.cv(8121, 8113);
        CaseVariants.cv(8122, 8048);
        CaseVariants.cv(8123, 8049);
        CaseVariants.cv(8124, 8115);
        CaseVariants.cv(8126, 837, 921, 953);
        CaseVariants.cv(8131, 8140);
        CaseVariants.cv(8136, 8050);
        CaseVariants.cv(8137, 8051);
        CaseVariants.cv(8138, 8052);
        CaseVariants.cv(8139, 8053);
        CaseVariants.cv(8140, 8131);
        CaseVariants.cv(8144, 8152);
        CaseVariants.cv(8145, 8153);
        CaseVariants.cv(8152, 8144);
        CaseVariants.cv(8153, 8145);
        CaseVariants.cv(8154, 8054);
        CaseVariants.cv(8155, 8055);
        CaseVariants.cv(8160, 8168);
        CaseVariants.cv(8161, 8169);
        CaseVariants.cv(8165, 8172);
        CaseVariants.cv(8168, 8160);
        CaseVariants.cv(8169, 8161);
        CaseVariants.cv(8170, 8058);
        CaseVariants.cv(8171, 8059);
        CaseVariants.cv(8172, 8165);
        CaseVariants.cv(8179, 8188);
        CaseVariants.cv(8184, 8056);
        CaseVariants.cv(8185, 8057);
        CaseVariants.cv(8186, 8060);
        CaseVariants.cv(8187, 8061);
        CaseVariants.cv(8188, 8179);
        CaseVariants.cv(8486, 937, 969);
        CaseVariants.cv(8490, 75, 107);
        CaseVariants.cv(8491, 197, 229);
        CaseVariants.cv(8544, 8560);
        CaseVariants.cv(8545, 8561);
        CaseVariants.cv(8546, 8562);
        CaseVariants.cv(8547, 8563);
        CaseVariants.cv(8548, 8564);
        CaseVariants.cv(8549, 8565);
        CaseVariants.cv(8550, 8566);
        CaseVariants.cv(8551, 8567);
        CaseVariants.cv(8552, 8568);
        CaseVariants.cv(8553, 8569);
        CaseVariants.cv(8554, 8570);
        CaseVariants.cv(8555, 8571);
        CaseVariants.cv(8556, 8572);
        CaseVariants.cv(8557, 8573);
        CaseVariants.cv(8558, 8574);
        CaseVariants.cv(8559, 8575);
        CaseVariants.cv(8560, 8544);
        CaseVariants.cv(8561, 8545);
        CaseVariants.cv(8562, 8546);
        CaseVariants.cv(8563, 8547);
        CaseVariants.cv(8564, 8548);
        CaseVariants.cv(8565, 8549);
        CaseVariants.cv(8566, 8550);
        CaseVariants.cv(8567, 8551);
        CaseVariants.cv(8568, 8552);
        CaseVariants.cv(8569, 8553);
        CaseVariants.cv(8570, 8554);
        CaseVariants.cv(8571, 8555);
        CaseVariants.cv(8572, 8556);
        CaseVariants.cv(8573, 8557);
        CaseVariants.cv(8574, 8558);
        CaseVariants.cv(8575, 8559);
        CaseVariants.cv(9398, 9424);
        CaseVariants.cv(9399, 9425);
        CaseVariants.cv(9400, 9426);
        CaseVariants.cv(9401, 9427);
        CaseVariants.cv(9402, 9428);
        CaseVariants.cv(9403, 9429);
        CaseVariants.cv(9404, 9430);
        CaseVariants.cv(9405, 9431);
        CaseVariants.cv(9406, 9432);
        CaseVariants.cv(9407, 9433);
        CaseVariants.cv(9408, 9434);
        CaseVariants.cv(9409, 9435);
        CaseVariants.cv(9410, 9436);
        CaseVariants.cv(9411, 9437);
        CaseVariants.cv(9412, 9438);
        CaseVariants.cv(9413, 9439);
        CaseVariants.cv(9414, 9440);
        CaseVariants.cv(9415, 9441);
        CaseVariants.cv(9416, 9442);
        CaseVariants.cv(9417, 9443);
        CaseVariants.cv(9418, 9444);
        CaseVariants.cv(9419, 9445);
        CaseVariants.cv(9420, 9446);
        CaseVariants.cv(9421, 9447);
        CaseVariants.cv(9422, 9448);
        CaseVariants.cv(9423, 9449);
        CaseVariants.cv(9424, 9398);
        CaseVariants.cv(9425, 9399);
        CaseVariants.cv(9426, 9400);
        CaseVariants.cv(9427, 9401);
        CaseVariants.cv(9428, 9402);
        CaseVariants.cv(9429, 9403);
        CaseVariants.cv(9430, 9404);
        CaseVariants.cv(9431, 9405);
        CaseVariants.cv(9432, 9406);
        CaseVariants.cv(9433, 9407);
        CaseVariants.cv(9434, 9408);
        CaseVariants.cv(9435, 9409);
        CaseVariants.cv(9436, 9410);
        CaseVariants.cv(9437, 9411);
        CaseVariants.cv(9438, 9412);
        CaseVariants.cv(9439, 9413);
        CaseVariants.cv(9440, 9414);
        CaseVariants.cv(9441, 9415);
        CaseVariants.cv(9442, 9416);
        CaseVariants.cv(9443, 9417);
        CaseVariants.cv(9444, 9418);
        CaseVariants.cv(9445, 9419);
        CaseVariants.cv(9446, 9420);
        CaseVariants.cv(9447, 9421);
        CaseVariants.cv(9448, 9422);
        CaseVariants.cv(9449, 9423);
        CaseVariants.cv(11264, 11312);
        CaseVariants.cv(11265, 11313);
        CaseVariants.cv(11266, 11314);
        CaseVariants.cv(11267, 11315);
        CaseVariants.cv(11268, 11316);
        CaseVariants.cv(11269, 11317);
        CaseVariants.cv(11270, 11318);
        CaseVariants.cv(11271, 11319);
        CaseVariants.cv(11272, 11320);
        CaseVariants.cv(11273, 11321);
        CaseVariants.cv(11274, 11322);
        CaseVariants.cv(11275, 11323);
        CaseVariants.cv(11276, 11324);
        CaseVariants.cv(11277, 11325);
        CaseVariants.cv(11278, 11326);
        CaseVariants.cv(11279, 11327);
        CaseVariants.cv(11280, 11328);
        CaseVariants.cv(11281, 11329);
        CaseVariants.cv(11282, 11330);
        CaseVariants.cv(11283, 11331);
        CaseVariants.cv(11284, 11332);
        CaseVariants.cv(11285, 11333);
        CaseVariants.cv(11286, 11334);
        CaseVariants.cv(11287, 11335);
        CaseVariants.cv(11288, 11336);
        CaseVariants.cv(11289, 11337);
        CaseVariants.cv(11290, 11338);
        CaseVariants.cv(11291, 11339);
        CaseVariants.cv(11292, 11340);
        CaseVariants.cv(11293, 11341);
        CaseVariants.cv(11294, 11342);
        CaseVariants.cv(11295, 11343);
        CaseVariants.cv(11296, 11344);
        CaseVariants.cv(11297, 11345);
        CaseVariants.cv(11298, 11346);
        CaseVariants.cv(11299, 11347);
        CaseVariants.cv(11300, 11348);
        CaseVariants.cv(11301, 11349);
        CaseVariants.cv(11302, 11350);
        CaseVariants.cv(11303, 11351);
        CaseVariants.cv(11304, 11352);
        CaseVariants.cv(11305, 11353);
        CaseVariants.cv(11306, 11354);
        CaseVariants.cv(11307, 11355);
        CaseVariants.cv(11308, 11356);
        CaseVariants.cv(11309, 11357);
        CaseVariants.cv(11310, 11358);
        CaseVariants.cv(11312, 11264);
        CaseVariants.cv(11313, 11265);
        CaseVariants.cv(11314, 11266);
        CaseVariants.cv(11315, 11267);
        CaseVariants.cv(11316, 11268);
        CaseVariants.cv(11317, 11269);
        CaseVariants.cv(11318, 11270);
        CaseVariants.cv(11319, 11271);
        CaseVariants.cv(11320, 11272);
        CaseVariants.cv(11321, 11273);
        CaseVariants.cv(11322, 11274);
        CaseVariants.cv(11323, 11275);
        CaseVariants.cv(11324, 11276);
        CaseVariants.cv(11325, 11277);
        CaseVariants.cv(11326, 11278);
        CaseVariants.cv(11327, 11279);
        CaseVariants.cv(11328, 11280);
        CaseVariants.cv(11329, 11281);
        CaseVariants.cv(11330, 11282);
        CaseVariants.cv(11331, 11283);
        CaseVariants.cv(11332, 11284);
        CaseVariants.cv(11333, 11285);
        CaseVariants.cv(11334, 11286);
        CaseVariants.cv(11335, 11287);
        CaseVariants.cv(11336, 11288);
        CaseVariants.cv(11337, 11289);
        CaseVariants.cv(11338, 11290);
        CaseVariants.cv(11339, 11291);
        CaseVariants.cv(11340, 11292);
        CaseVariants.cv(11341, 11293);
        CaseVariants.cv(11342, 11294);
        CaseVariants.cv(11343, 11295);
        CaseVariants.cv(11344, 11296);
        CaseVariants.cv(11345, 11297);
        CaseVariants.cv(11346, 11298);
        CaseVariants.cv(11347, 11299);
        CaseVariants.cv(11348, 11300);
        CaseVariants.cv(11349, 11301);
        CaseVariants.cv(11350, 11302);
        CaseVariants.cv(11351, 11303);
        CaseVariants.cv(11352, 11304);
        CaseVariants.cv(11353, 11305);
        CaseVariants.cv(11354, 11306);
        CaseVariants.cv(11355, 11307);
        CaseVariants.cv(11356, 11308);
        CaseVariants.cv(11357, 11309);
        CaseVariants.cv(11358, 11310);
        CaseVariants.cv(11392, 11393);
        CaseVariants.cv(11393, 11392);
        CaseVariants.cv(11394, 11395);
        CaseVariants.cv(11395, 11394);
        CaseVariants.cv(11396, 11397);
        CaseVariants.cv(11397, 11396);
        CaseVariants.cv(11398, 11399);
        CaseVariants.cv(11399, 11398);
        CaseVariants.cv(11400, 11401);
        CaseVariants.cv(11401, 11400);
        CaseVariants.cv(11402, 11403);
        CaseVariants.cv(11403, 11402);
        CaseVariants.cv(11404, 11405);
        CaseVariants.cv(11405, 11404);
        CaseVariants.cv(11406, 11407);
        CaseVariants.cv(11407, 11406);
        CaseVariants.cv(11408, 11409);
        CaseVariants.cv(11409, 11408);
        CaseVariants.cv(11410, 11411);
        CaseVariants.cv(11411, 11410);
        CaseVariants.cv(11412, 11413);
        CaseVariants.cv(11413, 11412);
        CaseVariants.cv(11414, 11415);
        CaseVariants.cv(11415, 11414);
        CaseVariants.cv(11416, 11417);
        CaseVariants.cv(11417, 11416);
        CaseVariants.cv(11418, 11419);
        CaseVariants.cv(11419, 11418);
        CaseVariants.cv(11420, 11421);
        CaseVariants.cv(11421, 11420);
        CaseVariants.cv(11422, 11423);
        CaseVariants.cv(11423, 11422);
        CaseVariants.cv(11424, 11425);
        CaseVariants.cv(11425, 11424);
        CaseVariants.cv(11426, 11427);
        CaseVariants.cv(11427, 11426);
        CaseVariants.cv(11428, 11429);
        CaseVariants.cv(11429, 11428);
        CaseVariants.cv(11430, 11431);
        CaseVariants.cv(11431, 11430);
        CaseVariants.cv(11432, 11433);
        CaseVariants.cv(11433, 11432);
        CaseVariants.cv(11434, 11435);
        CaseVariants.cv(11435, 11434);
        CaseVariants.cv(11436, 11437);
        CaseVariants.cv(11437, 11436);
        CaseVariants.cv(11438, 11439);
        CaseVariants.cv(11439, 11438);
        CaseVariants.cv(11440, 11441);
        CaseVariants.cv(11441, 11440);
        CaseVariants.cv(11442, 11443);
        CaseVariants.cv(11443, 11442);
        CaseVariants.cv(11444, 11445);
        CaseVariants.cv(11445, 11444);
        CaseVariants.cv(11446, 11447);
        CaseVariants.cv(11447, 11446);
        CaseVariants.cv(11448, 11449);
        CaseVariants.cv(11449, 11448);
        CaseVariants.cv(11450, 11451);
        CaseVariants.cv(11451, 11450);
        CaseVariants.cv(11452, 11453);
        CaseVariants.cv(11453, 11452);
        CaseVariants.cv(11454, 11455);
        CaseVariants.cv(11455, 11454);
        CaseVariants.cv(11456, 11457);
        CaseVariants.cv(11457, 11456);
        CaseVariants.cv(11458, 11459);
        CaseVariants.cv(11459, 11458);
        CaseVariants.cv(11460, 11461);
        CaseVariants.cv(11461, 11460);
        CaseVariants.cv(11462, 11463);
        CaseVariants.cv(11463, 11462);
        CaseVariants.cv(11464, 11465);
        CaseVariants.cv(11465, 11464);
        CaseVariants.cv(11466, 11467);
        CaseVariants.cv(11467, 11466);
        CaseVariants.cv(11468, 11469);
        CaseVariants.cv(11469, 11468);
        CaseVariants.cv(11470, 11471);
        CaseVariants.cv(11471, 11470);
        CaseVariants.cv(11472, 11473);
        CaseVariants.cv(11473, 11472);
        CaseVariants.cv(11474, 11475);
        CaseVariants.cv(11475, 11474);
        CaseVariants.cv(11476, 11477);
        CaseVariants.cv(11477, 11476);
        CaseVariants.cv(11478, 11479);
        CaseVariants.cv(11479, 11478);
        CaseVariants.cv(11480, 11481);
        CaseVariants.cv(11481, 11480);
        CaseVariants.cv(11482, 11483);
        CaseVariants.cv(11483, 11482);
        CaseVariants.cv(11484, 11485);
        CaseVariants.cv(11485, 11484);
        CaseVariants.cv(11486, 11487);
        CaseVariants.cv(11487, 11486);
        CaseVariants.cv(11488, 11489);
        CaseVariants.cv(11489, 11488);
        CaseVariants.cv(11490, 11491);
        CaseVariants.cv(11491, 11490);
        CaseVariants.cv(11520, 4256);
        CaseVariants.cv(11521, 4257);
        CaseVariants.cv(11522, 4258);
        CaseVariants.cv(11523, 4259);
        CaseVariants.cv(11524, 4260);
        CaseVariants.cv(11525, 4261);
        CaseVariants.cv(11526, 4262);
        CaseVariants.cv(11527, 4263);
        CaseVariants.cv(11528, 4264);
        CaseVariants.cv(11529, 4265);
        CaseVariants.cv(11530, 4266);
        CaseVariants.cv(11531, 4267);
        CaseVariants.cv(11532, 4268);
        CaseVariants.cv(11533, 4269);
        CaseVariants.cv(11534, 4270);
        CaseVariants.cv(11535, 4271);
        CaseVariants.cv(11536, 4272);
        CaseVariants.cv(11537, 4273);
        CaseVariants.cv(11538, 4274);
        CaseVariants.cv(11539, 4275);
        CaseVariants.cv(11540, 4276);
        CaseVariants.cv(11541, 4277);
        CaseVariants.cv(11542, 4278);
        CaseVariants.cv(11543, 4279);
        CaseVariants.cv(11544, 4280);
        CaseVariants.cv(11545, 4281);
        CaseVariants.cv(11546, 4282);
        CaseVariants.cv(11547, 4283);
        CaseVariants.cv(11548, 4284);
        CaseVariants.cv(11549, 4285);
        CaseVariants.cv(11550, 4286);
        CaseVariants.cv(11551, 4287);
        CaseVariants.cv(11552, 4288);
        CaseVariants.cv(11553, 4289);
        CaseVariants.cv(11554, 4290);
        CaseVariants.cv(11555, 4291);
        CaseVariants.cv(11556, 4292);
        CaseVariants.cv(11557, 4293);
        CaseVariants.cv(65313, 65345);
        CaseVariants.cv(65314, 65346);
        CaseVariants.cv(65315, 65347);
        CaseVariants.cv(65316, 65348);
        CaseVariants.cv(65317, 65349);
        CaseVariants.cv(65318, 65350);
        CaseVariants.cv(65319, 65351);
        CaseVariants.cv(65320, 65352);
        CaseVariants.cv(65321, 65353);
        CaseVariants.cv(65322, 65354);
        CaseVariants.cv(65323, 65355);
        CaseVariants.cv(65324, 65356);
        CaseVariants.cv(65325, 65357);
        CaseVariants.cv(65326, 65358);
        CaseVariants.cv(65327, 65359);
        CaseVariants.cv(65328, 65360);
        CaseVariants.cv(65329, 65361);
        CaseVariants.cv(65330, 65362);
        CaseVariants.cv(65331, 65363);
        CaseVariants.cv(65332, 65364);
        CaseVariants.cv(65333, 65365);
        CaseVariants.cv(65334, 65366);
        CaseVariants.cv(65335, 65367);
        CaseVariants.cv(65336, 65368);
        CaseVariants.cv(65337, 65369);
        CaseVariants.cv(65338, 65370);
        CaseVariants.cv(65345, 65313);
        CaseVariants.cv(65346, 65314);
        CaseVariants.cv(65347, 65315);
        CaseVariants.cv(65348, 65316);
        CaseVariants.cv(65349, 65317);
        CaseVariants.cv(65350, 65318);
        CaseVariants.cv(65351, 65319);
        CaseVariants.cv(65352, 65320);
        CaseVariants.cv(65353, 65321);
        CaseVariants.cv(65354, 65322);
        CaseVariants.cv(65355, 65323);
        CaseVariants.cv(65356, 65324);
        CaseVariants.cv(65357, 65325);
        CaseVariants.cv(65358, 65326);
        CaseVariants.cv(65359, 65327);
        CaseVariants.cv(65360, 65328);
        CaseVariants.cv(65361, 65329);
        CaseVariants.cv(65362, 65330);
        CaseVariants.cv(65363, 65331);
        CaseVariants.cv(65364, 65332);
        CaseVariants.cv(65365, 65333);
        CaseVariants.cv(65366, 65334);
        CaseVariants.cv(65367, 65335);
        CaseVariants.cv(65368, 65336);
        CaseVariants.cv(65369, 65337);
        CaseVariants.cv(65370, 65338);
        CaseVariants.cv(66560, 66600);
        CaseVariants.cv(66561, 66601);
        CaseVariants.cv(66562, 66602);
        CaseVariants.cv(66563, 66603);
        CaseVariants.cv(66564, 66604);
        CaseVariants.cv(66565, 66605);
        CaseVariants.cv(66566, 66606);
        CaseVariants.cv(66567, 66607);
        CaseVariants.cv(66568, 66608);
        CaseVariants.cv(66569, 66609);
        CaseVariants.cv(66570, 66610);
        CaseVariants.cv(66571, 66611);
        CaseVariants.cv(66572, 66612);
        CaseVariants.cv(66573, 66613);
        CaseVariants.cv(66574, 66614);
        CaseVariants.cv(66575, 66615);
        CaseVariants.cv(66576, 66616);
        CaseVariants.cv(66577, 66617);
        CaseVariants.cv(66578, 66618);
        CaseVariants.cv(66579, 66619);
        CaseVariants.cv(66580, 66620);
        CaseVariants.cv(66581, 66621);
        CaseVariants.cv(66582, 66622);
        CaseVariants.cv(66583, 66623);
        CaseVariants.cv(66584, 66624);
        CaseVariants.cv(66585, 66625);
        CaseVariants.cv(66586, 66626);
        CaseVariants.cv(66587, 66627);
        CaseVariants.cv(66588, 66628);
        CaseVariants.cv(66589, 66629);
        CaseVariants.cv(66590, 66630);
        CaseVariants.cv(66591, 66631);
        CaseVariants.cv(66592, 66632);
        CaseVariants.cv(66593, 66633);
        CaseVariants.cv(66594, 66634);
        CaseVariants.cv(66595, 66635);
        CaseVariants.cv(66596, 66636);
        CaseVariants.cv(66597, 66637);
        CaseVariants.cv(66598, 66638);
        CaseVariants.cv(66599, 66639);
        CaseVariants.cv(66600, 66560);
        CaseVariants.cv(66601, 66561);
        CaseVariants.cv(66602, 66562);
        CaseVariants.cv(66603, 66563);
        CaseVariants.cv(66604, 66564);
        CaseVariants.cv(66605, 66565);
        CaseVariants.cv(66606, 66566);
        CaseVariants.cv(66607, 66567);
        CaseVariants.cv(66608, 66568);
        CaseVariants.cv(66609, 66569);
        CaseVariants.cv(66610, 66570);
        CaseVariants.cv(66611, 66571);
        CaseVariants.cv(66612, 66572);
        CaseVariants.cv(66613, 66573);
        CaseVariants.cv(66614, 66574);
        CaseVariants.cv(66615, 66575);
        CaseVariants.cv(66616, 66576);
        CaseVariants.cv(66617, 66577);
        CaseVariants.cv(66618, 66578);
        CaseVariants.cv(66619, 66579);
        CaseVariants.cv(66620, 66580);
        CaseVariants.cv(66621, 66581);
        CaseVariants.cv(66622, 66582);
        CaseVariants.cv(66623, 66583);
        CaseVariants.cv(66624, 66584);
        CaseVariants.cv(66625, 66585);
        CaseVariants.cv(66626, 66586);
        CaseVariants.cv(66627, 66587);
        CaseVariants.cv(66628, 66588);
        CaseVariants.cv(66629, 66589);
        CaseVariants.cv(66630, 66590);
        CaseVariants.cv(66631, 66591);
        CaseVariants.cv(66632, 66592);
        CaseVariants.cv(66633, 66593);
        CaseVariants.cv(66634, 66594);
        CaseVariants.cv(66635, 66595);
        CaseVariants.cv(66636, 66596);
        CaseVariants.cv(66637, 66597);
        CaseVariants.cv(66638, 66598);
        CaseVariants.cv(66639, 66599);
    }
}

