/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.charcode.UTF16CharacterSet;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class CodepointsToString
extends SystemFunction {
    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        XPathContext context = visitor.getStaticContext().makeEarlyEvaluationContext();
        return new StringLiteral(CodepointsToString.unicodeToString(this.argument[0].iterate(context), context));
    }

    public Item evaluateItem(XPathContext c) throws XPathException {
        return StringValue.makeStringValue(CodepointsToString.unicodeToString(this.argument[0].iterate(c), c));
    }

    public static CharSequence unicodeToString(SequenceIterator chars, XPathContext context) throws XPathException {
        FastStringBuffer sb = new FastStringBuffer(64);
        NameChecker checker = context.getConfiguration().getNameChecker();
        NumericValue nextInt;
        while ((nextInt = (NumericValue)chars.next()) != null) {
            long next = nextInt.longValue();
            if (next < 0L || next > Integer.MAX_VALUE || !checker.isValidChar((int)next)) {
                XPathException e = new XPathException("Invalid XML character [x " + Integer.toHexString((int)next) + ']');
                e.setErrorCode("FOCH0001");
                if (context instanceof XPathContext) {
                    e.setXPathContext(context);
                }
                throw e;
            }
            if (next < 65536L) {
                sb.append((char)next);
                continue;
            }
            sb.append(UTF16CharacterSet.highSurrogate((int)next));
            sb.append(UTF16CharacterSet.lowSurrogate((int)next));
        }
        return sb.condense();
    }
}

