/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2008 Sun Microsystems, Inc.
 */

package org.netbeans.modules.maven.hints.pom;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;

/**
 *
 * @author mkleint
 */
public class ParentVersionErrorCustomizer extends javax.swing.JPanel {
    private Preferences preferences;
    private final Map<String, Object> id2Saved = new HashMap<String, Object>();

    /** Creates new form ParentVersionErrorCustomizer */
    public ParentVersionErrorCustomizer(Preferences prefs) {
        initComponents();
        preferences = prefs;
        buttonGroup1.add(rbLatest);
        buttonGroup1.add(rbSources);
        rbSources.setSelected(preferences.getBoolean(ParentVersionError.PROP_SOURCES, true));
        rbLatest.setSelected(!preferences.getBoolean(ParentVersionError.PROP_SOURCES, true));
        cbSnapshots.setSelected(preferences.getBoolean(ParentVersionError.PROP_SNAPSHOT, false));
        enableSnapshots();
        ActionListener al = new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                preferences.putBoolean(ParentVersionError.PROP_SOURCES, rbSources.isSelected());
                enableSnapshots();
            }
        };
        rbSources.addActionListener(al);
        rbLatest.addActionListener(al);
        cbSnapshots.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                preferences.putBoolean(ParentVersionError.PROP_SNAPSHOT, cbSnapshots.isSelected());
            }
        });
    
        id2Saved.put(ParentVersionError.PROP_SOURCES, rbSources.isSelected());
        id2Saved.put(ParentVersionError.PROP_SNAPSHOT, cbSnapshots.isSelected());
    }
    
    String getSavedValue(String key) {
        return id2Saved.get(key).toString();
    }

    private void enableSnapshots() {
        cbSnapshots.setEnabled(rbLatest.isSelected());
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        rbSources = new javax.swing.JRadioButton();
        rbLatest = new javax.swing.JRadioButton();
        cbSnapshots = new javax.swing.JCheckBox();

        org.openide.awt.Mnemonics.setLocalizedText(rbSources, org.openide.util.NbBundle.getMessage(ParentVersionErrorCustomizer.class, "ParentVersionErrorCustomizer.rbSources.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(rbLatest, org.openide.util.NbBundle.getMessage(ParentVersionErrorCustomizer.class, "ParentVersionErrorCustomizer.rbLatest.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(cbSnapshots, org.openide.util.NbBundle.getMessage(ParentVersionErrorCustomizer.class, "ParentVersionErrorCustomizer.cbSnapshots.text")); // NOI18N
        cbSnapshots.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cbSnapshotsActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(21, 21, 21)
                        .addComponent(cbSnapshots))
                    .addComponent(rbSources)
                    .addComponent(rbLatest))
                .addContainerGap(37, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(rbSources)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(rbLatest)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(cbSnapshots)
                .addContainerGap(215, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void cbSnapshotsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cbSnapshotsActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_cbSnapshotsActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JCheckBox cbSnapshots;
    private javax.swing.JRadioButton rbLatest;
    private javax.swing.JRadioButton rbSources;
    // End of variables declaration//GEN-END:variables

}
