/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2012 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2012 Sun Microsystems, Inc.
 */
package org.netbeans.modules.cnd.search.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.search.SearchHistory;
import org.netbeans.api.search.SearchPattern;
import org.netbeans.api.search.provider.SearchInfo;
import org.netbeans.api.search.ui.ComponentUtils;
import org.netbeans.api.search.ui.FileNameController;
import org.netbeans.api.search.ui.ScopeController;
import org.netbeans.api.search.ui.SearchPatternController;
import org.netbeans.modules.cnd.search.impl.SearchBrowseHostScope;
import org.netbeans.modules.cnd.search.util.SearchScopeValidator;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.spi.search.SearchScopeDefinition;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

/**
 *
 * @author akrasny
 */
public final class CNDSearchPanel extends javax.swing.JPanel {

    private final ScopeController scopeController;
    private FileNameController fileNameController;
    private SearchPatternController searchPatternController;
    private volatile ValidationStatus validationStatus;
    private final ChangesListener listener;
    private final ChangeSupport cs = new ChangeSupport(this);
    private final SearchScopeValidator validator = new SearchScopeValidator();

    /**
     * Creates new form CndSearchPanel
     */
    public CNDSearchPanel() {
        initComponents();
        listener = new ChangesListener();

        scopeController = ComponentUtils.adjustComboForScope(cbScope, null, getAdditionalSearchScopes());
        cbScope.addActionListener(listener);
        fileNameController = ComponentUtils.adjustComboForFileName(cbFilename);
        fileNameController.addChangeListener(listener);
        searchPatternController = ComponentUtils.adjustComboForSearchPattern(cbSearchPattern);
        searchPatternController.bind(SearchPatternController.Option.MATCH_CASE, cbCaseSensitive);
        searchPatternController.bind(SearchPatternController.Option.WHOLE_WORDS, cbWholeWords);
        searchPatternController.addChangeListener(listener);
        validationStatus = null;
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        lblText = new javax.swing.JLabel();
        cbSearchPattern = new javax.swing.JComboBox();
        cbCaseSensitive = new javax.swing.JCheckBox();
        cbWholeWords = new javax.swing.JCheckBox();
        lblScope = new javax.swing.JLabel();
        cbScope = new javax.swing.JComboBox();
        lblFilename = new javax.swing.JLabel();
        cbFilename = new javax.swing.JComboBox();

        setPreferredSize(new java.awt.Dimension(470, 270));

        lblText.setLabelFor(cbSearchPattern);
        org.openide.awt.Mnemonics.setLocalizedText(lblText, org.openide.util.NbBundle.getMessage(CNDSearchPanel.class, "CNDSearchPanel.lblText.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(cbCaseSensitive, org.openide.util.NbBundle.getMessage(CNDSearchPanel.class, "CNDSearchPanel.cbCaseSensitive.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(cbWholeWords, org.openide.util.NbBundle.getMessage(CNDSearchPanel.class, "CNDSearchPanel.cbWholeWords.text")); // NOI18N

        lblScope.setLabelFor(cbScope);
        org.openide.awt.Mnemonics.setLocalizedText(lblScope, org.openide.util.NbBundle.getMessage(CNDSearchPanel.class, "CNDSearchPanel.lblScope.text")); // NOI18N

        lblFilename.setLabelFor(cbFilename);
        org.openide.awt.Mnemonics.setLocalizedText(lblFilename, org.openide.util.NbBundle.getMessage(CNDSearchPanel.class, "CNDSearchPanel.lblFilename.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(cbScope, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(cbFilename, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(cbSearchPattern, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(cbCaseSensitive)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(cbWholeWords))
                            .addComponent(lblText)
                            .addComponent(lblScope)
                            .addComponent(lblFilename))
                        .addGap(0, 181, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(lblText)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(cbSearchPattern, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(cbCaseSensitive)
                    .addComponent(cbWholeWords))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(lblScope)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(cbScope, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(lblFilename)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(cbFilename, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox cbCaseSensitive;
    private javax.swing.JComboBox cbFilename;
    private javax.swing.JComboBox cbScope;
    private javax.swing.JComboBox cbSearchPattern;
    private javax.swing.JCheckBox cbWholeWords;
    private javax.swing.JLabel lblFilename;
    private javax.swing.JLabel lblScope;
    private javax.swing.JLabel lblText;
    // End of variables declaration//GEN-END:variables

    public void addChangeListener(ChangeListener listener) {
        cs.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        cs.removeChangeListener(listener);
    }

    public String getFileName() {
        return fileNameController.getFileNamePattern();
    }

    public SearchInfo getSearchInfo() {
        return scopeController.getSearchInfo();
    }

    public ValidationStatus getValidationStatus() {
        if (validationStatus == null) {
            updateValidationStatus();
        }

        return validationStatus;
    }

    private void updateValidationStatus() {
        SearchPattern searchPattern = searchPatternController.getSearchPattern();
        String pattern = searchPattern.getSearchExpression();

        if (!validator.isSearchAllowed(scopeController.getSearchInfo())) {
            this.validationStatus = ValidationStatus.NOT_SUPPORTED;
        } else if (pattern.isEmpty() && getFileName().isEmpty()) {
            this.validationStatus = ValidationStatus.NO_PARAMS;
        } else {
            this.validationStatus = ValidationStatus.OK;
            try {
                Pattern.compile(pattern);
            } catch (Exception ex) {
                this.validationStatus = ValidationStatus.WRONG_REGEXPR;
            }
        }

        cs.fireChange();
    }

    private SearchScopeDefinition[] getAdditionalSearchScopes() {
        List<SearchScopeDefinition> result = new ArrayList<SearchScopeDefinition>();

        List<ExecutionEnvironment> recentConnections = ConnectionManager.getInstance().getRecentConnections();

        for (ExecutionEnvironment env : recentConnections) {
            SearchBrowseHostScope scope = new SearchBrowseHostScope(env);
            result.add(scope.getBrowseScope());
            result.add(scope.getLastScope());
        }

        return result.toArray(new SearchScopeDefinition[result.size()]);
    }

    public SearchPattern getSearchPattern() {
        return searchPatternController.getSearchPattern();
    }

    public void storeSettings() {
        SearchHistory.getDefault().add(getSearchPattern());
    }

    private class ChangesListener implements ChangeListener, DocumentListener, ActionListener  {

        @Override
        public void stateChanged(ChangeEvent e) {
            updateValidationStatus();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            updateValidationStatus();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            updateValidationStatus();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            updateValidationStatus();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            updateValidationStatus();
        }
    }

    public static class ValidationStatus {

        public static final ValidationStatus OK = new ValidationStatus(null);
        private static final ValidationStatus NO_PARAMS = new ValidationStatus(
                NbBundle.getMessage(CNDSearchPanel.class, "CNDSearchPanel.ValidationStatus.no_params")); // NOI18N
        private static final ValidationStatus WRONG_REGEXPR = new ValidationStatus(
                NbBundle.getMessage(CNDSearchPanel.class, "CNDSearchPanel.ValidationStatus.wrong_regexpr")); // NOI18N
        private static ValidationStatus NOT_SUPPORTED = new ValidationStatus(
                NbBundle.getMessage(CNDSearchPanel.class, "CNDSearchPanel.ValidationStatus.not_suppotred")); // NOI18N;
        public final String error;

        public ValidationStatus(String error) {
            this.error = error;
        }
    }
}
