/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2015 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2015 Sun Microsystems, Inc.
 */
package org.netbeans.modules.cnd.refactoring.ui;

import java.awt.Component;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.cnd.refactoring.api.InlineRefactoring;

/**
 *
 * @author Danila Sergeyev
 */
public class InlinePanel extends javax.swing.JPanel implements CustomRefactoringPanel {

    /**
     * Creates new form InlineRefactoring
     */
    public InlinePanel() {
        initComponents();
    }
    
    @Override
    public void initialize() {
        
    }
    
    @Override
    public Component getComponent() {
        return this;
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        changeScopeRadioButtons = new javax.swing.ButtonGroup();
        inPlaceRadioButton = new javax.swing.JRadioButton();
        inFileRadioButton = new javax.swing.JRadioButton();
        inProjectRadioButton = new javax.swing.JRadioButton();
        scopeLbl = new javax.swing.JLabel();

        setPreferredSize(new java.awt.Dimension(300, 118));

        changeScopeRadioButtons.add(inPlaceRadioButton);
        inPlaceRadioButton.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(inPlaceRadioButton, org.openide.util.NbBundle.getMessage(InlinePanel.class, "InlinePanel.inPlaceRadioButton.text")); // NOI18N

        changeScopeRadioButtons.add(inFileRadioButton);
        org.openide.awt.Mnemonics.setLocalizedText(inFileRadioButton, org.openide.util.NbBundle.getMessage(InlinePanel.class, "InlinePanel.inFileRadioButton.text")); // NOI18N

        changeScopeRadioButtons.add(inProjectRadioButton);
        org.openide.awt.Mnemonics.setLocalizedText(inProjectRadioButton, org.openide.util.NbBundle.getMessage(InlinePanel.class, "InlinePanel.inProjectRadioButton.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(scopeLbl, org.openide.util.NbBundle.getMessage(InlinePanel.class, "InlinePanel.scopeLbl.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(scopeLbl, javax.swing.GroupLayout.DEFAULT_SIZE, 276, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(12, 12, 12)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(inPlaceRadioButton)
                            .addComponent(inFileRadioButton)
                            .addComponent(inProjectRadioButton))
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(8, 8, 8)
                .addComponent(scopeLbl)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(inPlaceRadioButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(inFileRadioButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(inProjectRadioButton)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup changeScopeRadioButtons;
    private javax.swing.JRadioButton inFileRadioButton;
    private javax.swing.JRadioButton inPlaceRadioButton;
    private javax.swing.JRadioButton inProjectRadioButton;
    private javax.swing.JLabel scopeLbl;
    // End of variables declaration//GEN-END:variables

    protected InlineRefactoring.Apply getWhere() {
        if (changeScopeRadioButtons.isSelected(inFileRadioButton.getModel())) {
            return InlineRefactoring.Apply.IN_FILE;
        } else if (changeScopeRadioButtons.isSelected(inProjectRadioButton.getModel())) {
            return InlineRefactoring.Apply.IN_PROJECT;
        } else {
            return InlineRefactoring.Apply.IN_PLACE;
        }
    }
    
}
