MACRO(APPEND_FLAGS var flags)
  IF(NOT "${${var}}" MATCHES "${flags}")
    SET(${var} "${${var}} ${flags}")
    #MESSAGE(STATUS "INFO: ${var} changed to '${${var}}'")
  ENDIF(NOT "${${var}}" MATCHES "${flags}")
ENDMACRO(APPEND_FLAGS)


MACRO(REPLACE_FLAGS var these those)
  IF("${${var}}" MATCHES "${these}")
    STRING(REGEX REPLACE "${these}" "${those}" ${var} "${${var}}")
    #MESSAGE(STATUS "INFO: ${var} changed to '${${var}}'")
  ENDIF("${${var}}" MATCHES "${these}")
ENDMACRO(REPLACE_FLAGS)


MACRO(MSVC_FORCE_WARNING_LEVEL level)
  IF(MSVC)
    FOREACH(lang C CXX)
    FOREACH(suffix "" _DEBUG _MINSIZEREL _RELEASE _RELWITHDEBINFO)
      REPLACE_FLAGS("CMAKE_${lang}_FLAGS${suffix}" "/W[1-4]" "/W${level}")
    ENDFOREACH(suffix)
    ENDFOREACH(lang)
  ENDIF(MSVC)
ENDMACRO(MSVC_FORCE_WARNING_LEVEL)


MACRO(MSVC_TREAT_WARNINGS_AS_ERRORS)
  IF(MSVC)
    APPEND_FLAGS("CMAKE_C_FLAGS" "/WX")
    APPEND_FLAGS("CMAKE_CXX_FLAGS" "/WX")
  ENDIF(MSVC)
ENDMACRO(MSVC_TREAT_WARNINGS_AS_ERRORS)


MACRO(MSVC_LINK_TO_STATIC_CRT)
  IF(MSVC)
    FOREACH(lang C CXX)
    FOREACH(suffix "" _DEBUG _MINSIZEREL _RELEASE _RELWITHDEBINFO)
      REPLACE_FLAGS("CMAKE_${lang}_FLAGS${suffix}" "/MD" "/MT")
    ENDFOREACH(suffix)
    ENDFOREACH(lang)
  ENDIF(MSVC)
ENDMACRO(MSVC_LINK_TO_STATIC_CRT)


MACRO(MSVC_LINK_TO_DLL_CRT)
  IF(MSVC)
    FOREACH(lang C CXX)
    FOREACH(suffix "" _DEBUG _MINSIZEREL _RELEASE _RELWITHDEBINFO)
      REPLACE_FLAGS("CMAKE_${lang}_FLAGS${suffix}" "/MT" "/MD")
    ENDFOREACH(suffix)
    ENDFOREACH(lang)
  ENDIF(MSVC)
ENDMACRO(MSVC_LINK_TO_DLL_CRT)


MACRO(MSVC80_FORCE_MANIFEST_LINKER_FLAG)
  IF(MSVC80)
    APPEND_FLAGS("CMAKE_EXE_LINKER_FLAGS" "/MANIFEST")
    APPEND_FLAGS("CMAKE_MODULE_LINKER_FLAGS" "/MANIFEST")
    APPEND_FLAGS("CMAKE_SHARED_LINKER_FLAGS" "/MANIFEST")
  ENDIF(MSVC80)
ENDMACRO(MSVC80_FORCE_MANIFEST_LINKER_FLAG)
