/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef DROP_H
#define DROP_H
#include <Xm/Xm.h>
#include "mars.h"
#include "Drag.h"

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

#define DROP_ACTION_NOOP              0
#define DROP_ACTION_NAME_AND_CLASS    1
#define DROP_ACTION_DEFINITION   	  2
#define DROP_ACTION_RESOLVE           3
#define DROP_ACTION_ERROR            -1

typedef struct dropid {

	/* private */

	struct dropid *next;

	void   *data;
	int    state;
	int    batch;

	/* public */

	svc     *s;             /* communication handle */
	char    *service;       /* remote service */
	int     count;          /* -> Icon count */
	boolean sender;

	DragCallbackStruct *cb; /* All the callbacks */

	/* Target must fill, source can read ... */

	int      action;        /* <-> Action requested from source */
	request *header;        /* <-> Drop header       ( Will be freed) */
	request *mode;          /* <-> Drop traget state ( Will be freed) */
	request *context;       /* <-> Drop target info  ( Will be freed) */

} dropid;

typedef void (*DropProc)(Widget,dropid*,void*);

void RegisterDropSource(svc*,Widget,DropProc,void*);
void RegisterDropTarget(svc*,Widget,DropProc,void*);
DragCallbackStruct *DropObjectFromSource(Widget,XEvent*,Position,Position,
	Dimension,Dimension, DragDrawProc,XtPointer);


#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif
