
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileTextVisitorAttributes.h
    \brief Definition of TextVisitor Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef TextVisitorAttributes_H
#define TextVisitorAttributes_H

#include "magics.h"
#include "Colour.h"
namespace magics {

class XmlNode;
class TextVisitorAttributes 
{
public:
//  --  constructor
    TextVisitorAttributes();
    
//  --  destructor
    virtual ~TextVisitorAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const TextVisitorAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	bool html_;
	int count_;
	string line1_;
	string line2_;
	string line3_;
	string line4_;
	string line5_;
	string line6_;
	string line7_;
	string line8_;
	string line9_;
	string line10_;
	int first_;
	string font_;
	string font_style_;
	string font_dimension_;
	string orientation_;
	bool automatic_;
	stringarray lines_;
	string mode_;
	double x_;
	double y_;
	double width_;
	double height_;
	bool blanking_;
	bool border_;
	int border_thickness_;
	string character1_;
	string character2_;
	string character3_;
	string character4_;
	string character5_;
	string character6_;
	string character7_;
	string character8_;
	string character9_;
	string character10_;
	int integer1_;
	int integer2_;
	int integer3_;
	int integer4_;
	int integer5_;
	int integer6_;
	int integer7_;
	int integer8_;
	int integer9_;
	int integer10_;
	double real1_;
	double real2_;
	double real3_;
	double real4_;
	double real5_;
	double real6_;
	double real7_;
	double real8_;
	double real9_;
	double real10_;
	double height_ratio_1_;
	double height_ratio_2_;
	double height_ratio_3_;
	double height_ratio_4_;
	double height_ratio_5_;
	double height_ratio_6_;
	double height_ratio_7_;
	double height_ratio_8_;
	double height_ratio_9_;
	double height_ratio_10_;
	string parameter_escape_;
	doublearray height_ratios_;
	unique_ptr<Colour> font_colour_;
	Justification justification_;
	LineStyle border_line_style_;
	unique_ptr<Colour> border_colour_;
	 

private:
	friend ostream& operator<<(ostream& s,const TextVisitorAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

