
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file XLogarithmicCoordinateAttributes.h
    \\brief Definition of XLogarithmicCoordinate Attributes class.

    This file is automatically generated.
    Do Not Edit!

*/

#include "MagRequest.h"
#include "XLogarithmicCoordinateWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "MagicsGlobal.h"

using namespace magics;



XLogarithmicCoordinateWrapper::XLogarithmicCoordinateWrapper(): xlogarithmiccoordinate_(new XLogarithmicCoordinate())


{


	
	XCoordinateWrapper::object(xlogarithmiccoordinate_);
	

}
XLogarithmicCoordinateWrapper::XLogarithmicCoordinateWrapper(XLogarithmicCoordinate* xlogarithmiccoordinate): xlogarithmiccoordinate_(xlogarithmiccoordinate)
{

	
	XCoordinateWrapper::object(xlogarithmiccoordinate_);
	
}

XLogarithmicCoordinateWrapper::~XLogarithmicCoordinateWrapper()
{

}

void XLogarithmicCoordinateWrapper::set(const MagRequest& request)
{

	

	XCoordinateWrapper::set(request);
	

	if  (request.countValues("X_MIN") ) {
		double min_value = request("X_MIN");
		xlogarithmiccoordinate_->min_ = min_value;
		}
	if  (request.countValues("X_MAX") ) {
		double max_value = request("X_MAX");
		xlogarithmiccoordinate_->max_ = max_value;
		}
	if  (request.countValues("X_AUTOMATIC_REVERSE") ) {
		string reverse_value = request("X_AUTOMATIC_REVERSE");
		
		xlogarithmiccoordinate_->reverse_ = MagTranslator<string, bool>()(reverse_value);
		
		}
	
	
	if  (request.countValues("X_AUTOMATIC") ) {
		string automatic_value = request("X_AUTOMATIC");
		xlogarithmiccoordinate_->automatic_ = MagTranslator<string, AxisAutomaticSetting>()(automatic_value);
	}
		
	
}

void XLogarithmicCoordinateWrapper::print(ostream& out)  const
{
	out << "XLogarithmicCoordinateWrapper[]";
}



