with Ada.Text_IO;           use Ada.Text_IO;
with GNATCOLL.Utils;        use GNATCOLL.Utils;
with Ada.Strings.Unbounded; use Ada.Strings.Unbounded;
with GNAT.Strings;          use GNAT.Strings;

procedure Split is
   Str : constant String := "a" & ASCII.LF & ASCII.LF & "b";
   Str2 : constant String := "a" & ASCII.LF & ASCII.LF & "b" & ASCII.LF;
   Str3 : constant String := "a" & ASCII.LF & ASCII.LF & "b" & ASCII.LF & ASCII.LF;

   procedure Test (Name : String; S : String; Omit : Boolean);
   procedure Test (Name : String; S : String; Omit : Boolean) is
      Result : String_List_Access := Split
          (S, ASCII.LF, Omit_Empty_Lines => Omit);
      Result2 : Unbounded_String_Array := Split
          (S, ASCII.LF, Omit_Empty_Lines => Omit);
   begin
      Put_Line ("===== " & Name & " (with Str, Omit=" & Omit'Img
                & ") ====");
      for R in Result'Range loop
         Put_Line (R'Img & " => " & Result (R).all);
      end loop;
      Free (Result);

      Put_Line ("===== " & Name & " (with Unbounded, Omit=" & Omit'Img
                & ") ====");
      for R in Result2'Range loop
         Put_Line (R'Img & " => " & To_String (Result2 (R)));
      end loop;
   end Test;

begin
   Test ("Str", Str, Omit => False);
   Test ("Str", Str, Omit => True);
   New_Line;
   Test ("Str2", Str2, Omit => False);
   Test ("Str2", Str2, Omit => True);
   New_Line;
   Test ("Str3", Str3, Omit => False);
   Test ("Str3", Str3, Omit => True);
   New_Line;
   Test ("Empty", "", Omit => False);
   Test ("Empty", "", Omit => True);
end Split;
