#ifdef WIN32
#ifndef __cplusplus
#error Please compile with a C++ compiler.
#endif
#endif

#if defined(USE_WINDOWS_GDIPLUS)
#include <Windows.h>
#include <GdiPlus.h>

#pragma comment(lib, "gdiplus.lib")
#else
#include <GdiPlusFlat.h>
#endif

#if defined(USE_WINDOWS_GDIPLUS)
using namespace Gdiplus;
using namespace DllExports;
#endif

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include "testhelpers.h"

static const char *file = "temp_asset.emf";
static WCHAR wFile[] = {'t', 'e', 'm', 'p', '_', 'a', 's', 's', 'e', 't', '.', 'e', 'm', 'f', 0};
GpImage *image;

#define createFile(buffer, expectedStatus) \
{ \
	GpStatus status; \
	FILE *f = fopen (file, "wb+"); \
	assert (f); \
	fwrite ((void *) buffer, sizeof (BYTE), sizeof (buffer), f); \
	fclose (f); \
 \
	status = GdipLoadImageFromFile (wFile, &image); \
	assertEqualInt (status, expectedStatus); \
}

#define createFileSuccess(buffer, x, y, width, height, dimensionWidth, dimensionHeight) \
{ \
	createFile (buffer, Ok); \
	verifyMetafile (image, emfRawFormat, x, y, width, height, dimensionWidth, dimensionHeight) \
	GdipDisposeImage (image); \
}

static void test_valid ()
{
	BYTE simpleHeader[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */   0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,

		/* EMR_EOF */       0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE headerExtension1[] = {
		/* EMR_HEADER */     0x01, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00,
		/* Bounds */         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */          0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */      0x20, 0x45, 0x4D, 0x46,
		/* Version */        0x00, 0x00, 0x01, 0x00,
		/* Bytes */          0x78, 0x00, 0x00, 0x00,
		/* Records */        0x02, 0x00, 0x00, 0x00,
		/* Handles */        0x01, 0x00,
		/* Reserved */       0x00, 0x00,
		/* nDescription */   0x00, 0x00, 0x00, 0x00,
		/* offDescription*/  0x00, 0x00, 0x00, 0x00,
		/* palEntries */     0x00, 0x00, 0x00, 0x00,
		/* Device */         0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */    0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,
		/* cbPixelFormat */  0x00, 0x00, 0x00, 0x00,
		/* offPixelFormat */ 0x00, 0x00, 0x00, 0x00,
		/* bOpenGL */        0x00, 0x00, 0x00, 0x00,

		/* EMR_EOF */        0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE headerExtension2[] = {
		/* EMR_HEADER */     0x01, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,
		/* Bounds */         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */          0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */      0x20, 0x45, 0x4D, 0x46,
		/* Version */        0x00, 0x00, 0x01, 0x00,
		/* Bytes */          0x80, 0x00, 0x00, 0x00,
		/* Records */        0x02, 0x00, 0x00, 0x00,
		/* Handles */        0x01, 0x00,
		/* Reserved */       0x00, 0x00,
		/* nDescription */   0x00, 0x00, 0x00, 0x00,
		/* offDescription*/  0x00, 0x00, 0x00, 0x00,
		/* palEntries */     0x00, 0x00, 0x00, 0x00,
		/* Device */         0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */    0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,
		/* cbPixelFormat */  0x00, 0x00, 0x00, 0x00,
		/* offPixelFormat */ 0x00, 0x00, 0x00, 0x00,
		/* bOpenGL */        0x00, 0x00, 0x00, 0x00,
		/* Micrometers */    0xC0, 0x4B, 0x03, 0x00, 0xD8, 0x41, 0x04, 0x00,

		/* EMR_EOF */        0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE zeroHeaderSize[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */   0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,

		/* EMR_EOF */       0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE smallHeaderSize[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x54, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */   0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,

		/* EMR_EOF */       0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE zeroBoundsWidth[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */   0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,

		/* EMR_EOF */       0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE zeroBoundsHeight[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */   0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,

		/* EMR_EOF */       0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE negativeWidth[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xB1, 0x03, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xD2, 0x00, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */   0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,

		/* EMR_EOF */       0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE zeroFrameWidth[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */   0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,

		/* EMR_EOF */       0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE zeroFrameHeight[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */   0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,

		/* EMR_EOF */       0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE zeroVersion[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x00, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */   0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,

		/* EMR_EOF */       0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE bytesEqualToHeaderSize[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x58, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */   0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE largeRecords[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0xFF, 0xFF, 0xFF, 0xFF,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */   0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,

		/* EMR_EOF */       0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE largeHandles[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0xFF, 0xFF,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */   0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,

		/* EMR_EOF */       0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE nonZeroReserved[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0xFF, 0xFF,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */   0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,

		/* EMR_EOF */       0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE invalidDescription[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x6D, 0x00, 0x00, 0x00,
		/* offDescription*/ 0xFF, 0xFF, 0xFF, 0xFF,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */   0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,

		/* EMR_EOF */       0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE invalidPalEntries[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0xFF, 0xFF, 0xFF, 0xFF,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */   0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,

		/* EMR_EOF */       0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE shortMillimetres[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */   0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00
	};
	BYTE invalidPixelFormat[] = {
		/* EMR_HEADER */     0x01, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00,
		/* Bounds */         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */          0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */      0x20, 0x45, 0x4D, 0x46,
		/* Version */        0x00, 0x00, 0x01, 0x00,
		/* Bytes */          0x78, 0x00, 0x00, 0x00,
		/* Records */        0x02, 0x00, 0x00, 0x00,
		/* Handles */        0x01, 0x00,
		/* Reserved */       0x00, 0x00,
		/* nDescription */   0x00, 0x00, 0x00, 0x00,
		/* offDescription*/  0x00, 0x00, 0x00, 0x00,
		/* palEntries */     0x00, 0x00, 0x00, 0x00,
		/* Device */         0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */    0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,
		/* cbPixelFormat */  0x6D, 0x00, 0x00, 0x00,
		/* offPixelFormat */ 0xFF, 0xFF, 0xFF, 0xFF,
		/* bOpenGL */        0x00, 0x00, 0x00, 0x00,

		/* EMR_EOF */        0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE invalidOpenGL[] = {
		/* EMR_HEADER */     0x01, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00,
		/* Bounds */         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */          0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */      0x20, 0x45, 0x4D, 0x46,
		/* Version */        0x00, 0x00, 0x01, 0x00,
		/* Bytes */          0x78, 0x00, 0x00, 0x00,
		/* Records */        0x02, 0x00, 0x00, 0x00,
		/* Handles */        0x01, 0x00,
		/* Reserved */       0x00, 0x00,
		/* nDescription */   0x00, 0x00, 0x00, 0x00,
		/* offDescription*/  0x00, 0x00, 0x00, 0x00,
		/* palEntries */     0x00, 0x00, 0x00, 0x00,
		/* Device */         0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */    0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,
		/* cbPixelFormat */  0x6D, 0x00, 0x00, 0x00,
		/* offPixelFormat */ 0x00, 0x00, 0x00, 0x00,
		/* bOpenGL */        0xFF, 0xFF, 0xFF, 0xFF,

		/* EMR_EOF */        0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE zeroMicrometresWidth[] = {
		/* EMR_HEADER */     0x01, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,
		/* Bounds */         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */          0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */      0x20, 0x45, 0x4D, 0x46,
		/* Version */        0x00, 0x00, 0x01, 0x00,
		/* Bytes */          0x80, 0x00, 0x00, 0x00,
		/* Records */        0x02, 0x00, 0x00, 0x00,
		/* Handles */        0x01, 0x00,
		/* Reserved */       0x00, 0x00,
		/* nDescription */   0x00, 0x00, 0x00, 0x00,
		/* offDescription*/  0x00, 0x00, 0x00, 0x00,
		/* palEntries */     0x00, 0x00, 0x00, 0x00,
		/* Device */         0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */    0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,
		/* cbPixelFormat */  0x00, 0x00, 0x00, 0x00,
		/* offPixelFormat */ 0x00, 0x00, 0x00, 0x00,
		/* bOpenGL */        0x00, 0x00, 0x00, 0x00,
		/* Micrometers */    0x00, 0x00, 0x00, 0x00, 0xD8, 0x41, 0x04, 0x00,

		/* EMR_EOF */        0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE zeroMicrometresHeight[] = {
		/* EMR_HEADER */     0x01, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,
		/* Bounds */         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */          0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */      0x20, 0x45, 0x4D, 0x46,
		/* Version */        0x00, 0x00, 0x01, 0x00,
		/* Bytes */          0x80, 0x00, 0x00, 0x00,
		/* Records */        0x02, 0x00, 0x00, 0x00,
		/* Handles */        0x01, 0x00,
		/* Reserved */       0x00, 0x00,
		/* nDescription */   0x00, 0x00, 0x00, 0x00,
		/* offDescription*/  0x00, 0x00, 0x00, 0x00,
		/* palEntries */     0x00, 0x00, 0x00, 0x00,
		/* Device */         0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */    0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,
		/* cbPixelFormat */  0x00, 0x00, 0x00, 0x00,
		/* offPixelFormat */ 0x00, 0x00, 0x00, 0x00,
		/* bOpenGL */        0x00, 0x00, 0x00, 0x00,
		/* Micrometers */    0xC0, 0x4B, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,

		/* EMR_EOF */        0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE noRecords[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x70, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */   0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE noCbPixelFormat[] = {
		/* EMR_HEADER */     0x01, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00,
		/* Bounds */         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */          0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */      0x20, 0x45, 0x4D, 0x46,
		/* Version */        0x00, 0x00, 0x01, 0x00,
		/* Bytes */          0x78, 0x00, 0x00, 0x00,
		/* Records */        0x02, 0x00, 0x00, 0x00,
		/* Handles */        0x01, 0x00,
		/* Reserved */       0x00, 0x00,
		/* nDescription */   0x00, 0x00, 0x00, 0x00,
		/* offDescription*/  0x00, 0x00, 0x00, 0x00,
		/* palEntries */     0x00, 0x00, 0x00, 0x00,
		/* Device */         0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */    0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE shortCbPixelFormat[] = {
		/* EMR_HEADER */     0x01, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00,
		/* Bounds */         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */          0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */      0x20, 0x45, 0x4D, 0x46,
		/* Version */        0x00, 0x00, 0x01, 0x00,
		/* Bytes */          0x78, 0x00, 0x00, 0x00,
		/* Records */        0x02, 0x00, 0x00, 0x00,
		/* Handles */        0x01, 0x00,
		/* Reserved */       0x00, 0x00,
		/* nDescription */   0x00, 0x00, 0x00, 0x00,
		/* offDescription*/  0x00, 0x00, 0x00, 0x00,
		/* palEntries */     0x00, 0x00, 0x00, 0x00,
		/* Device */         0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */    0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,
		/* cbPixelFormat */  0x00, 0x00, 0x00
	};
	BYTE noOffPixelFormat[] = {
		/* EMR_HEADER */     0x01, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00,
		/* Bounds */         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */          0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */      0x20, 0x45, 0x4D, 0x46,
		/* Version */        0x00, 0x00, 0x01, 0x00,
		/* Bytes */          0x78, 0x00, 0x00, 0x00,
		/* Records */        0x02, 0x00, 0x00, 0x00,
		/* Handles */        0x01, 0x00,
		/* Reserved */       0x00, 0x00,
		/* nDescription */   0x00, 0x00, 0x00, 0x00,
		/* offDescription*/  0x00, 0x00, 0x00, 0x00,
		/* palEntries */     0x00, 0x00, 0x00, 0x00,
		/* Device */         0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */    0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,
		/* cbPixelFormat */  0x00, 0x00, 0x00, 0x00,
	};
	BYTE shortOffPixelFormat[] = {
		/* EMR_HEADER */     0x01, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00,
		/* Bounds */         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */          0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */      0x20, 0x45, 0x4D, 0x46,
		/* Version */        0x00, 0x00, 0x01, 0x00,
		/* Bytes */          0x78, 0x00, 0x00, 0x00,
		/* Records */        0x02, 0x00, 0x00, 0x00,
		/* Handles */        0x01, 0x00,
		/* Reserved */       0x00, 0x00,
		/* nDescription */   0x00, 0x00, 0x00, 0x00,
		/* offDescription*/  0x00, 0x00, 0x00, 0x00,
		/* palEntries */     0x00, 0x00, 0x00, 0x00,
		/* Device */         0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */    0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,
		/* cbPixelFormat */  0x00, 0x00, 0x00, 0x00,
		/* offPixelFormat */ 0x00, 0x00, 0x00
	};
	BYTE noOpenGL[] = {
		/* EMR_HEADER */     0x01, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00,
		/* Bounds */         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */          0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */      0x20, 0x45, 0x4D, 0x46,
		/* Version */        0x00, 0x00, 0x01, 0x00,
		/* Bytes */          0x78, 0x00, 0x00, 0x00,
		/* Records */        0x02, 0x00, 0x00, 0x00,
		/* Handles */        0x01, 0x00,
		/* Reserved */       0x00, 0x00,
		/* nDescription */   0x00, 0x00, 0x00, 0x00,
		/* offDescription*/  0x00, 0x00, 0x00, 0x00,
		/* palEntries */     0x00, 0x00, 0x00, 0x00,
		/* Device */         0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */    0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,
		/* cbPixelFormat */  0x00, 0x00, 0x00, 0x00,
		/* offPixelFormat */ 0x00, 0x00, 0x00, 0x00,
	};
	BYTE shortOpenGL[] = {
		/* EMR_HEADER */     0x01, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00,
		/* Bounds */         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */          0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */      0x20, 0x45, 0x4D, 0x46,
		/* Version */        0x00, 0x00, 0x01, 0x00,
		/* Bytes */          0x78, 0x00, 0x00, 0x00,
		/* Records */        0x02, 0x00, 0x00, 0x00,
		/* Handles */        0x01, 0x00,
		/* Reserved */       0x00, 0x00,
		/* nDescription */   0x00, 0x00, 0x00, 0x00,
		/* offDescription*/  0x00, 0x00, 0x00, 0x00,
		/* palEntries */     0x00, 0x00, 0x00, 0x00,
		/* Device */         0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */    0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,
		/* cbPixelFormat */  0x00, 0x00, 0x00, 0x00,
		/* offPixelFormat */ 0x00, 0x00, 0x00, 0x00,
		/* bOpenGL */        0x00, 0x00, 0x00
	};
	BYTE noMicrometers[] = {
		/* EMR_HEADER */     0x01, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,
		/* Bounds */         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */          0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */      0x20, 0x45, 0x4D, 0x46,
		/* Version */        0x00, 0x00, 0x01, 0x00,
		/* Bytes */          0x80, 0x00, 0x00, 0x00,
		/* Records */        0x02, 0x00, 0x00, 0x00,
		/* Handles */        0x01, 0x00,
		/* Reserved */       0x00, 0x00,
		/* nDescription */   0x00, 0x00, 0x00, 0x00,
		/* offDescription*/  0x00, 0x00, 0x00, 0x00,
		/* palEntries */     0x00, 0x00, 0x00, 0x00,
		/* Device */         0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */    0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,
		/* cbPixelFormat */  0x00, 0x00, 0x00, 0x00,
		/* offPixelFormat */ 0x00, 0x00, 0x00, 0x00,
		/* bOpenGL */        0x00, 0x00, 0x00, 0x00
	};
	BYTE shortMicrometers[] = {
		/* EMR_HEADER */     0x01, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,
		/* Bounds */         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */          0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */      0x20, 0x45, 0x4D, 0x46,
		/* Version */        0x00, 0x00, 0x01, 0x00,
		/* Bytes */          0x80, 0x00, 0x00, 0x00,
		/* Records */        0x02, 0x00, 0x00, 0x00,
		/* Handles */        0x01, 0x00,
		/* Reserved */       0x00, 0x00,
		/* nDescription */   0x00, 0x00, 0x00, 0x00,
		/* offDescription*/  0x00, 0x00, 0x00, 0x00,
		/* palEntries */     0x00, 0x00, 0x00, 0x00,
		/* Device */         0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */    0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,
		/* cbPixelFormat */  0x00, 0x00, 0x00, 0x00,
		/* offPixelFormat */ 0x00, 0x00, 0x00, 0x00,
		/* bOpenGL */        0x00, 0x00, 0x00, 0x00,
		/* Micrometers */    0xC0, 0x4B, 0x03, 0x00, 0xD8, 0x41, 0x04
	};
	BYTE tooLargeFileSize[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x00, 0x01, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */   0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,

		/* EMR_EOF */       0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};

	createFileSuccess (simpleHeader, 14, 20, 50, 18, 750, 216);
	createFileSuccess (headerExtension1, 14, 20, 50, 18, 750, 216);
	createFileSuccess (headerExtension2, 14, 20, 50, 18, 750, 216);
	createFileSuccess (zeroHeaderSize, 14, 20, 50, 18, 750, 216);
	createFileSuccess (smallHeaderSize, 14, 20, 50, 18, 750, 216);
	createFileSuccess (zeroBoundsWidth, 14, 20, 50, 18, 750, 216);
	createFileSuccess (zeroBoundsHeight, 14, 20, 50, 18, 750, 216);
	createFileSuccess (negativeWidth, 63, 20, -48, 18, -720, 216);
	createFileSuccess (zeroFrameWidth, 0, 20, 1, 18, 15, 216);
	createFileSuccess (zeroFrameHeight, 14, 0, 50, 1, 750, 12);
	createFileSuccess (zeroVersion, 14, 20, 50, 18, 750, 216);
	createFileSuccess (bytesEqualToHeaderSize, 14, 20, 50, 18, 750, 216);
	createFileSuccess (largeRecords, 14, 20, 50, 18, 750, 216);
	createFileSuccess (largeHandles, 14, 20, 50, 18, 750, 216);
	createFileSuccess (nonZeroReserved, 14, 20, 50, 18, 750, 216);
	createFileSuccess (invalidDescription, 14, 20, 50, 18, 750, 216);
	createFileSuccess (invalidPalEntries, 14, 20, 50, 18, 750, 216);
	createFileSuccess (shortMillimetres, 14, 20, 50, 18, 750, 216);
	createFileSuccess (invalidPixelFormat, 14, 20, 50, 18, 750, 216);
	createFileSuccess (invalidOpenGL, 14, 20, 50, 18, 750, 216);
	createFileSuccess (zeroMicrometresWidth, 14, 20, 50, 18, 750, 216);
	createFileSuccess (zeroMicrometresHeight, 14, 20, 50, 18, 750, 216);
	createFileSuccess (noRecords, 14, 20, 50, 18, 750, 216);
	createFileSuccess (noCbPixelFormat, 14, 20, 50, 18, 750, 216);
	createFileSuccess (shortCbPixelFormat, 14, 20, 50, 18, 750, 216);
	createFileSuccess (noOffPixelFormat, 14, 20, 50, 18, 750, 216);
	createFileSuccess (shortOffPixelFormat, 14, 20, 50, 18, 750, 216);
	createFileSuccess (noOpenGL, 14, 20, 50, 18, 750, 216);
	createFileSuccess (shortOpenGL, 14, 20, 50, 18, 750, 216);
	createFileSuccess (noMicrometers, 14, 20, 50, 18, 750, 216);
	createFileSuccess (shortMicrometers, 14, 20, 50, 18, 750, 216);
	createFileSuccess (tooLargeFileSize, 14, 20, 50, 18, 750, 216);
}

static void test_invalidHeader()
{
	BYTE shortType[] = {
		/* EMR_HEADER */ 0x01, 0x00, 0x00
	};
	BYTE noSize[] = {
		/* EMR_HEADER */ 0x01, 0x00, 0x00, 0x00
	};
	BYTE shortSize[] = {
		/* EMR_HEADER */ 0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00
	};
	BYTE noBounds[] = {
		/* EMR_HEADER */ 0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00
	};
	BYTE shortBounds[] = {
		/* EMR_HEADER */ 0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00
	};
	BYTE noFrame[] = {
		/* EMR_HEADER */ 0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00
	};
	BYTE shortFrame[] = {
		/* EMR_HEADER */ 0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */      0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00
	};
	BYTE noSignature[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00
	};
	BYTE shortSignature[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D
	};
	BYTE noVersion[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46
	};
	BYTE shortVersion[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01
	};
	BYTE noBytes[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00
	};
	BYTE shortBytes[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00
	};
	BYTE noRecords[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00
	};
	BYTE shortRecords[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00
	};
	BYTE noHandles[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00
	};
	BYTE shortHandles[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01
	};
	BYTE noReserved[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00
	};
	BYTE shortReserved[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00
	};
	BYTE noNDescription[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00
	};
	BYTE shortNDescription[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00
	};
	BYTE noOffDescription[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00
	};
	BYTE shortOffDescription[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00
	};
	BYTE noPalEntries[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00
	};
	BYTE shortPalEntries[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00
	};
	BYTE noDevice[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
	};
	BYTE shortDevice[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00
	};
	BYTE noMillimetres[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00
	};

	createFile (shortType, OutOfMemory);
	createFile (noSize, OutOfMemory);
	createFile (shortSize, OutOfMemory);
	createFile (noBounds, OutOfMemory);
	createFile (shortBounds, OutOfMemory);
	createFile (noFrame, OutOfMemory);
	createFile (shortFrame, OutOfMemory);
	createFile (noSignature, OutOfMemory);
	createFile (shortSignature, OutOfMemory);
	createFile (noVersion, OutOfMemory);
	createFile (shortVersion, OutOfMemory);
	createFile (noBytes, OutOfMemory);
	createFile (shortBytes, OutOfMemory);
	createFile (noRecords, OutOfMemory);
	createFile (shortRecords, OutOfMemory);
	createFile (noHandles, OutOfMemory);
	createFile (shortHandles, OutOfMemory);
	createFile (noReserved, OutOfMemory);
	createFile (shortReserved, OutOfMemory);
	createFile (noNDescription, OutOfMemory);
	createFile (shortNDescription, OutOfMemory);
	createFile (noOffDescription, OutOfMemory);
	createFile (shortOffDescription, OutOfMemory);
	createFile (noPalEntries, OutOfMemory);
	createFile (shortPalEntries, OutOfMemory);
	createFile (noDevice, OutOfMemory);
	createFile (shortDevice, OutOfMemory);
	createFile (noMillimetres, OutOfMemory);
	createFile (shortDevice, OutOfMemory);
}

static void test_invalidData ()
{
	BYTE invalidType[] = {
		/* EMR_HEADER */    0x00, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */   0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,

		/* EMR_EOF */       0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE largeHeaderSize[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0xCD, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */   0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,

		/* EMR_EOF */       0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE negativeHeight[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */   0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,

		/* EMR_EOF */       0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE invalidSignature[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x00, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */   0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,

		/* EMR_EOF */       0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE zeroBytes[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x00, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */   0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,

		/* EMR_EOF */       0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE bytesSmallerThanHeaderSize[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x54, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */   0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,

		/* EMR_EOF */       0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE bytesNotDivisibleBy4[] = {
		/* EMR_HEADER */    0x00, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6E, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */   0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,

		/* EMR_EOF */       0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE zeroRecords[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x00, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */   0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,

		/* EMR_EOF */       0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE oneRecord[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x01, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */   0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,

		/* EMR_EOF */       0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE zeroHandles[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x00, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */   0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,

		/* EMR_EOF */       0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE zeroDeviceWidth[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0x00, 0x00, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */   0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,

		/* EMR_EOF */       0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE zeroDeviceHeight[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x01, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		/* Millimetres */   0xD8, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,

		/* EMR_EOF */       0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE zeroMillimetresWidth[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x00, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */   0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00,

		/* EMR_EOF */       0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};
	BYTE zeroMillimetresHeight[] = {
		/* EMR_HEADER */    0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		/* Bounds */        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00,
		/* Frame */         0xD2, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xB1, 0x03, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00,
		/* Signature */     0x20, 0x45, 0x4D, 0x46,
		/* Version */       0x00, 0x00, 0x01, 0x00,
		/* Bytes */         0x6C, 0x00, 0x00, 0x00,
		/* Records */       0x02, 0x00, 0x00, 0x00,
		/* Handles */       0x00, 0x00,
		/* Reserved */      0x00, 0x00,
		/* nDescription */  0x00, 0x00, 0x00, 0x00,
		/* offDescription*/ 0x00, 0x00, 0x00, 0x00,
		/* palEntries */    0x00, 0x00, 0x00, 0x00,
		/* Device */        0xA0, 0x05, 0x00, 0x00, 0x84, 0x03, 0x00, 0x00,
		/* Millimetres */   0xD8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

		/* EMR_EOF */       0x0E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00
	};

	createFile (invalidType, OutOfMemory);
	createFile (largeHeaderSize, OutOfMemory);
	createFile (negativeHeight, OutOfMemory);
	createFile (invalidSignature, OutOfMemory);
	createFile (zeroBytes, OutOfMemory);
	createFile (bytesSmallerThanHeaderSize, OutOfMemory);
	createFile (bytesNotDivisibleBy4, OutOfMemory);
	createFile (zeroRecords, OutOfMemory);
	createFile (oneRecord, OutOfMemory);
	createFile (zeroHandles, OutOfMemory);
	createFile (zeroDeviceWidth, OutOfMemory);
	createFile (zeroDeviceHeight, OutOfMemory);
	createFile (zeroMillimetresWidth, OutOfMemory);
	createFile (zeroMillimetresHeight, OutOfMemory);
}

int
main (int argc, char**argv)
{
	STARTUP;

	test_valid ();
	test_invalidHeader ();
	test_invalidData ();

	deleteFile (file);

	SHUTDOWN;
	return 0;
}
