#if !defined (__NULLPOINTEREXCEPTION_HPP)
#define __NULLPOINTEREXCEPTION_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   


#if !defined IN_COMMON_HPP
   #error NullPointerException.hpp is included by Common.hpp only.
#endif

namespace corelinux
{


   DECLARE_CLASS( NullPointerException );

   /**
   NullPointerException is the base exception type for NullPointer. All
   NullPointer exceptions derive from this.
   */

   class NullPointerException : public Exception
   {
   
   public:
   
                        /**
                        Default Constructor
                        @param why describes why the exception was thrown
                        @param file The source module throwing the exception
                        @param line The line of source throwing the exception
                        @param severity The Exception::Severity of the Exception
                        @param outOfMemory An out of memory indicator
                        */

                        NullPointerException
                        (
                           CharCptr why,
                           CharCptr file,
                           LineNum  line,
                           Severity severity = Exception::CONTINUABLE,
                           bool     outOfMemory = false 
                        );

                        /**
                        Default Constructor
                        @param file The source module throwing the exception
                        @param line The line of source throwing the exception
                        @param severity The Exception::Severity of the Exception
                        @param outOfMemory An out of memory indicator
                        */

                        NullPointerException
                        (
                           CharCptr file,
                           LineNum  line,
                           Severity severity = Exception::CONTINUABLE,
                           bool     outOfMemory = false 
                        );
   
                        /**
                        Copy constructor
                        @param NullPointerException const reference
                        */
                     
                        NullPointerException( NullPointerExceptionCref );
   
                        /// Virtual Destructor
   
      virtual           ~NullPointerException( void );
   
         //
         // Operator overloads
         //
   
               /**
               Assignment operator overload
               @param  NullPointerException const reference
               @return NullPointerException reference to self
               */
            
               NullPointerExceptionRef   operator=( NullPointerExceptionCref );
            
               /**
               Equality operator overload
               @param NullPointerException const reference
               @return true if equal, false otherwise
               */

               bool           operator==( NullPointerExceptionCref ) const;
            
         //
         // Accessor methods
         //
   
            
         //
         // Mutator methods
         //
   
   
   protected:

                        /**
                        NullPointerException must have at least
                        a location..
                        Default constructor is not allowed.
                        */   
                     
                        NullPointerException( void );
   };

}


#endif  // !defined __NULLPOINTEREXCEPTION_HPP

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/05/06 12:44:06 $
   $Locker:  $
*/



