/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.dom;

import org.apache.xalan.xsltc.DOM;
import org.apache.xalan.xsltc.Translet;
import org.apache.xalan.xsltc.dom.NodeCounter;
import org.apache.xml.dtm.DTMAxisIterator;

public abstract class AnyNodeCounter
extends NodeCounter {
    public AnyNodeCounter(Translet translet, DOM document, DTMAxisIterator iterator) {
        super(translet, document, iterator);
    }

    public NodeCounter setStartNode(int node) {
        this._node = node;
        this._nodeType = this._document.getExpandedTypeID(node);
        return this;
    }

    public String getCounter() {
        int result;
        if (this._value != Integer.MIN_VALUE) {
            result = this._value;
        } else {
            int next = this._node;
            int root = this._document.getDocument();
            result = 0;
            while (next >= root && !this.matchesFrom(next)) {
                if (this.matchesCount(next)) {
                    ++result;
                }
                --next;
            }
        }
        return this.formatNumbers(result);
    }

    public static NodeCounter getDefaultNodeCounter(Translet translet, DOM document, DTMAxisIterator iterator) {
        return new DefaultAnyNodeCounter(translet, document, iterator);
    }

    static class DefaultAnyNodeCounter
    extends AnyNodeCounter {
        public DefaultAnyNodeCounter(Translet translet, DOM document, DTMAxisIterator iterator) {
            super(translet, document, iterator);
        }

        public String getCounter() {
            int result;
            if (this._value != Integer.MIN_VALUE) {
                result = this._value;
            } else {
                int next = this._node;
                result = 0;
                int ntype = this._document.getExpandedTypeID(this._node);
                int root = this._document.getDocument();
                while (next >= 0) {
                    if (ntype == this._document.getExpandedTypeID(next)) {
                        ++result;
                    }
                    if (next == root) break;
                    --next;
                }
            }
            return this.formatNumbers(result);
        }
    }
}

