; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX1
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2,AVX2-SLOW
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2,AVX2-FAST-ALL
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2,AVX2-FAST-PERLANE
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512bw,+avx512vl | FileCheck %s --check-prefixes=AVX512

; These patterns are produced by LoopVectorizer for interleaved loads.

define void @load_i32_stride6_vf2(<12 x i32>* %in.vec, <2 x i32>* %out.vec0, <2 x i32>* %out.vec1, <2 x i32>* %out.vec2, <2 x i32>* %out.vec3, <2 x i32>* %out.vec4, <2 x i32>* %out.vec5) nounwind {
; SSE-LABEL: load_i32_stride6_vf2:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa 16(%rdi), %xmm1
; SSE-NEXT:    movdqa 32(%rdi), %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[2,3,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[2,3,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm0[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm2[0],xmm5[1],xmm2[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm3[0],xmm6[1],xmm3[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[2,3,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm1[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm3[0],xmm1[1],xmm3[1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm7 = xmm7[0],xmm2[0],xmm7[1],xmm2[1]
; SSE-NEXT:    movq %xmm0, (%rsi)
; SSE-NEXT:    movq %xmm4, (%rdx)
; SSE-NEXT:    movq %xmm5, (%rcx)
; SSE-NEXT:    movq %xmm6, (%r8)
; SSE-NEXT:    movq %xmm1, (%r9)
; SSE-NEXT:    movq %xmm7, (%rax)
; SSE-NEXT:    retq
;
; AVX1-LABEL: load_i32_stride6_vf2:
; AVX1:       # %bb.0:
; AVX1-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-NEXT:    vmovaps (%rdi), %xmm0
; AVX1-NEXT:    vmovaps 16(%rdi), %xmm1
; AVX1-NEXT:    vmovaps 32(%rdi), %xmm2
; AVX1-NEXT:    vpermilps {{.*#+}} xmm3 = xmm1[2,2,3,3]
; AVX1-NEXT:    vblendps {{.*#+}} xmm3 = xmm0[0],xmm3[1],xmm0[2,3]
; AVX1-NEXT:    vblendps {{.*#+}} xmm4 = xmm0[0,1],xmm1[2,3]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm4 = xmm4[1,3,2,3]
; AVX1-NEXT:    vblendps {{.*#+}} xmm5 = xmm2[0,1],xmm0[2,3]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm5 = xmm5[2,0,2,3]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; AVX1-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2,3]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm6 = xmm2[2,2,3,3]
; AVX1-NEXT:    vblendps {{.*#+}} xmm6 = xmm1[0],xmm6[1],xmm1[2,3]
; AVX1-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm2[2,3]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[1,3,2,3]
; AVX1-NEXT:    vmovlps %xmm3, (%rsi)
; AVX1-NEXT:    vmovlps %xmm4, (%rdx)
; AVX1-NEXT:    vmovlps %xmm5, (%rcx)
; AVX1-NEXT:    vmovlps %xmm0, (%r8)
; AVX1-NEXT:    vmovlps %xmm6, (%r9)
; AVX1-NEXT:    vmovlps %xmm1, (%rax)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_i32_stride6_vf2:
; AVX2:       # %bb.0:
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX2-NEXT:    vmovaps (%rdi), %xmm1
; AVX2-NEXT:    vmovaps 16(%rdi), %xmm2
; AVX2-NEXT:    vmovaps 32(%rdi), %xmm3
; AVX2-NEXT:    vpermilps {{.*#+}} xmm4 = xmm2[2,2,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} xmm4 = xmm1[0],xmm4[1],xmm1[2,3]
; AVX2-NEXT:    vblendps {{.*#+}} xmm2 = xmm1[0,1],xmm2[2,3]
; AVX2-NEXT:    vpermilps {{.*#+}} xmm2 = xmm2[1,3,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} xmm5 = xmm3[0,1],xmm1[2,3]
; AVX2-NEXT:    vpermilps {{.*#+}} xmm5 = xmm5[2,0,2,3]
; AVX2-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[3,3,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0],xmm3[1],xmm1[2,3]
; AVX2-NEXT:    vmovaps {{.*#+}} xmm3 = <4,2,u,u>
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX2-NEXT:    vpermps %ymm0, %ymm3, %ymm3
; AVX2-NEXT:    vmovaps {{.*#+}} xmm6 = <5,3,u,u>
; AVX2-NEXT:    vpermps %ymm0, %ymm6, %ymm0
; AVX2-NEXT:    vmovlps %xmm4, (%rsi)
; AVX2-NEXT:    vmovlps %xmm2, (%rdx)
; AVX2-NEXT:    vmovlps %xmm5, (%rcx)
; AVX2-NEXT:    vmovlps %xmm1, (%r8)
; AVX2-NEXT:    vmovlps %xmm3, (%r9)
; AVX2-NEXT:    vmovlps %xmm0, (%rax)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: load_i32_stride6_vf2:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX512-NEXT:    vmovaps (%rdi), %xmm1
; AVX512-NEXT:    vmovaps 16(%rdi), %xmm2
; AVX512-NEXT:    vmovaps 32(%rdi), %xmm3
; AVX512-NEXT:    vpermilps {{.*#+}} xmm4 = xmm2[2,2,3,3]
; AVX512-NEXT:    vblendps {{.*#+}} xmm4 = xmm1[0],xmm4[1],xmm1[2,3]
; AVX512-NEXT:    vblendps {{.*#+}} xmm2 = xmm1[0,1],xmm2[2,3]
; AVX512-NEXT:    vpermilps {{.*#+}} xmm2 = xmm2[1,3,2,3]
; AVX512-NEXT:    vblendps {{.*#+}} xmm5 = xmm3[0,1],xmm1[2,3]
; AVX512-NEXT:    vpermilps {{.*#+}} xmm5 = xmm5[2,0,2,3]
; AVX512-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[3,3,3,3]
; AVX512-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0],xmm3[1],xmm1[2,3]
; AVX512-NEXT:    vmovaps {{.*#+}} xmm3 = <4,2,u,u>
; AVX512-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX512-NEXT:    vpermps %ymm0, %ymm3, %ymm3
; AVX512-NEXT:    vmovaps {{.*#+}} xmm6 = <5,3,u,u>
; AVX512-NEXT:    vpermps %ymm0, %ymm6, %ymm0
; AVX512-NEXT:    vmovlps %xmm4, (%rsi)
; AVX512-NEXT:    vmovlps %xmm2, (%rdx)
; AVX512-NEXT:    vmovlps %xmm5, (%rcx)
; AVX512-NEXT:    vmovlps %xmm1, (%r8)
; AVX512-NEXT:    vmovlps %xmm3, (%r9)
; AVX512-NEXT:    vmovlps %xmm0, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %wide.vec = load <12 x i32>, <12 x i32>* %in.vec, align 32

  %strided.vec0 = shufflevector <12 x i32> %wide.vec, <12 x i32> poison, <2 x i32> <i32 0, i32 6>
  %strided.vec1 = shufflevector <12 x i32> %wide.vec, <12 x i32> poison, <2 x i32> <i32 1, i32 7>
  %strided.vec2 = shufflevector <12 x i32> %wide.vec, <12 x i32> poison, <2 x i32> <i32 2, i32 8>
  %strided.vec3 = shufflevector <12 x i32> %wide.vec, <12 x i32> poison, <2 x i32> <i32 3, i32 9>
  %strided.vec4 = shufflevector <12 x i32> %wide.vec, <12 x i32> poison, <2 x i32> <i32 4, i32 10>
  %strided.vec5 = shufflevector <12 x i32> %wide.vec, <12 x i32> poison, <2 x i32> <i32 5, i32 11>

  store <2 x i32> %strided.vec0, <2 x i32>* %out.vec0, align 32
  store <2 x i32> %strided.vec1, <2 x i32>* %out.vec1, align 32
  store <2 x i32> %strided.vec2, <2 x i32>* %out.vec2, align 32
  store <2 x i32> %strided.vec3, <2 x i32>* %out.vec3, align 32
  store <2 x i32> %strided.vec4, <2 x i32>* %out.vec4, align 32
  store <2 x i32> %strided.vec5, <2 x i32>* %out.vec5, align 32

  ret void
}

define void @load_i32_stride6_vf4(<24 x i32>* %in.vec, <4 x i32>* %out.vec0, <4 x i32>* %out.vec1, <4 x i32>* %out.vec2, <4 x i32>* %out.vec3, <4 x i32>* %out.vec4, <4 x i32>* %out.vec5) nounwind {
; SSE-LABEL: load_i32_stride6_vf4:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa 80(%rdi), %xmm9
; SSE-NEXT:    movdqa 64(%rdi), %xmm0
; SSE-NEXT:    movdqa (%rdi), %xmm4
; SSE-NEXT:    movdqa 16(%rdi), %xmm12
; SSE-NEXT:    movdqa 48(%rdi), %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm12[2,3,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm4[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm11 = xmm4[2,3,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm8[0],xmm4[1],xmm8[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm0[2,2,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm8[0],xmm1[1],xmm8[1]
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm4[0],xmm1[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm12[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm10 = xmm10[0],xmm4[0],xmm10[1],xmm4[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm0[2,3,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm3[2,2,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm3[2,3,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm8[0],xmm3[1],xmm8[1]
; SSE-NEXT:    movdqa 32(%rdi), %xmm7
; SSE-NEXT:    movsd {{.*#+}} xmm3 = xmm10[0],xmm3[1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm11 = xmm11[0],xmm7[0],xmm11[1],xmm7[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm9[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE-NEXT:    movsd {{.*#+}} xmm4 = xmm11[0],xmm4[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm7[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm2[0],xmm5[1],xmm2[1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm9[0],xmm6[1],xmm9[1]
; SSE-NEXT:    movsd {{.*#+}} xmm6 = xmm5[0],xmm6[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm7[2,3,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm12[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm12 = xmm12[0],xmm2[0],xmm12[1],xmm2[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm9[2,2,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm8[0],xmm2[1],xmm8[1]
; SSE-NEXT:    movsd {{.*#+}} xmm2 = xmm12[0],xmm2[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm7[0],xmm5[1],xmm7[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm9[2,3,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm7[0],xmm0[1],xmm7[1]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm5[0],xmm0[1]
; SSE-NEXT:    movapd %xmm1, (%rsi)
; SSE-NEXT:    movapd %xmm3, (%rdx)
; SSE-NEXT:    movapd %xmm4, (%rcx)
; SSE-NEXT:    movapd %xmm6, (%r8)
; SSE-NEXT:    movapd %xmm2, (%r9)
; SSE-NEXT:    movapd %xmm0, (%rax)
; SSE-NEXT:    retq
;
; AVX1-LABEL: load_i32_stride6_vf4:
; AVX1:       # %bb.0:
; AVX1-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX1-NEXT:    vmovaps (%rdi), %ymm1
; AVX1-NEXT:    vblendps {{.*#+}} ymm2 = ymm1[0,1,2,3],ymm0[4,5],ymm1[6,7]
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm3
; AVX1-NEXT:    vblendps {{.*#+}} xmm4 = xmm2[0,1],xmm3[2,3]
; AVX1-NEXT:    vshufps {{.*#+}} xmm4 = xmm4[0,2],xmm3[0,3]
; AVX1-NEXT:    vmovaps 64(%rdi), %xmm5
; AVX1-NEXT:    vinsertps {{.*#+}} xmm8 = xmm4[0,1,2],xmm5[2]
; AVX1-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[1,0],xmm3[3,0]
; AVX1-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,2],xmm3[1,3]
; AVX1-NEXT:    vblendps {{.*#+}} xmm9 = xmm2[0,1,2],xmm5[3]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vshufps {{.*#+}} xmm3 = xmm0[2,0],xmm1[2,3]
; AVX1-NEXT:    vmovaps 80(%rdi), %xmm6
; AVX1-NEXT:    vinsertps {{.*#+}} xmm3 = xmm3[0,1,2],xmm6[0]
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[3,1],xmm1[3,3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1,2],xmm6[1]
; AVX1-NEXT:    vmovaps 32(%rdi), %xmm1
; AVX1-NEXT:    vpermilps {{.*#+}} xmm7 = xmm1[2,2,3,3]
; AVX1-NEXT:    vmovaps 16(%rdi), %xmm4
; AVX1-NEXT:    vblendps {{.*#+}} xmm7 = xmm4[0],xmm7[1],xmm4[2,3]
; AVX1-NEXT:    vblendps {{.*#+}} xmm2 = xmm5[0,1],xmm6[2,3]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm2 = xmm2[0,1,0,2]
; AVX1-NEXT:    vblendps {{.*#+}} xmm2 = xmm7[0,1],xmm2[2,3]
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm5 = xmm5[0],zero,xmm5[1],zero
; AVX1-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,5],xmm6[6,7]
; AVX1-NEXT:    vblendps {{.*#+}} xmm1 = xmm4[0,1],xmm1[2,3]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[1,3,2,3]
; AVX1-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm5[2,3]
; AVX1-NEXT:    vmovaps %xmm8, (%rsi)
; AVX1-NEXT:    vmovaps %xmm9, (%rdx)
; AVX1-NEXT:    vmovaps %xmm3, (%rcx)
; AVX1-NEXT:    vmovaps %xmm0, (%r8)
; AVX1-NEXT:    vmovaps %xmm2, (%r9)
; AVX1-NEXT:    vmovaps %xmm1, (%rax)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_i32_stride6_vf4:
; AVX2:       # %bb.0:
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-NEXT:    vmovdqa (%rdi), %ymm1
; AVX2-NEXT:    vmovdqa 32(%rdi), %ymm2
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm0 = <0,6,4,u>
; AVX2-NEXT:    vpblendd {{.*#+}} ymm3 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX2-NEXT:    vpermd %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vmovdqa 64(%rdi), %xmm4
; AVX2-NEXT:    vpshufd {{.*#+}} xmm5 = xmm4[2,2,2,2]
; AVX2-NEXT:    vpblendd {{.*#+}} xmm8 = xmm0[0,1,2],xmm5[3]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm5 = <1,7,5,u>
; AVX2-NEXT:    vpermd %ymm3, %ymm5, %ymm3
; AVX2-NEXT:    vpblendd {{.*#+}} xmm3 = xmm3[0,1,2],xmm4[3]
; AVX2-NEXT:    vmovdqa (%rdi), %xmm5
; AVX2-NEXT:    vpshufd {{.*#+}} xmm6 = xmm5[2,3,2,3]
; AVX2-NEXT:    vpshufd {{.*#+}} ymm7 = ymm2[0,0,2,3,4,4,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0],ymm7[1,2,3],ymm6[4],ymm7[5,6,7]
; AVX2-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,3,2,3]
; AVX2-NEXT:    vmovdqa 80(%rdi), %xmm7
; AVX2-NEXT:    vpbroadcastd %xmm7, %xmm0
; AVX2-NEXT:    vpblendd {{.*#+}} xmm0 = xmm6[0,1,2],xmm0[3]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[3,3,3,3]
; AVX2-NEXT:    vpshufd {{.*#+}} ymm6 = ymm2[0,1,3,3,4,5,7,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0],ymm6[1,2,3],ymm5[4],ymm6[5,6,7]
; AVX2-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,3,2,3]
; AVX2-NEXT:    vpbroadcastd 84(%rdi), %xmm6
; AVX2-NEXT:    vpblendd {{.*#+}} xmm5 = xmm5[0,1,2],xmm6[3]
; AVX2-NEXT:    vpblendd {{.*#+}} xmm6 = xmm4[0,1],xmm7[2,3]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[0,1,0,2]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm9 = <4,2,u,u>
; AVX2-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5],ymm2[6,7]
; AVX2-NEXT:    vpermd %ymm1, %ymm9, %ymm2
; AVX2-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],xmm6[2,3]
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm4 = xmm4[0],zero,xmm4[1],zero
; AVX2-NEXT:    vpblendd {{.*#+}} xmm4 = xmm4[0,1,2],xmm7[3]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm6 = <5,3,u,u>
; AVX2-NEXT:    vpermd %ymm1, %ymm6, %ymm1
; AVX2-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],xmm4[2,3]
; AVX2-NEXT:    vmovdqa %xmm8, (%rsi)
; AVX2-NEXT:    vmovdqa %xmm3, (%rdx)
; AVX2-NEXT:    vmovdqa %xmm0, (%rcx)
; AVX2-NEXT:    vmovdqa %xmm5, (%r8)
; AVX2-NEXT:    vmovdqa %xmm2, (%r9)
; AVX2-NEXT:    vmovdqa %xmm1, (%rax)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: load_i32_stride6_vf4:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512-NEXT:    vmovdqa (%rdi), %xmm2
; AVX512-NEXT:    vmovdqa 16(%rdi), %xmm0
; AVX512-NEXT:    vmovdqa 32(%rdi), %xmm1
; AVX512-NEXT:    vmovdqa 48(%rdi), %xmm3
; AVX512-NEXT:    vpextrd $2, %xmm0, %eax
; AVX512-NEXT:    vpinsrd $1, %eax, %xmm2, %xmm4
; AVX512-NEXT:    vmovd %xmm3, %eax
; AVX512-NEXT:    vpinsrd $2, %eax, %xmm4, %xmm4
; AVX512-NEXT:    vmovdqa 64(%rdi), %xmm5
; AVX512-NEXT:    vpextrd $2, %xmm5, %eax
; AVX512-NEXT:    vpinsrd $3, %eax, %xmm4, %xmm8
; AVX512-NEXT:    vpextrd $3, %xmm0, %eax
; AVX512-NEXT:    vpshufd {{.*#+}} xmm6 = xmm2[1,1,1,1]
; AVX512-NEXT:    vpinsrd $1, %eax, %xmm6, %xmm6
; AVX512-NEXT:    vpextrd $1, %xmm3, %eax
; AVX512-NEXT:    vpinsrd $2, %eax, %xmm6, %xmm6
; AVX512-NEXT:    vpblendd {{.*#+}} xmm6 = xmm6[0,1,2],xmm5[3]
; AVX512-NEXT:    vpbroadcastd 8(%rdi), %xmm7
; AVX512-NEXT:    vmovd %xmm1, %eax
; AVX512-NEXT:    vpinsrd $1, %eax, %xmm7, %xmm7
; AVX512-NEXT:    vpblendd {{.*#+}} xmm7 = xmm7[0,1],xmm3[2],xmm7[3]
; AVX512-NEXT:    vmovdqa 80(%rdi), %xmm4
; AVX512-NEXT:    vmovd %xmm4, %eax
; AVX512-NEXT:    vpinsrd $3, %eax, %xmm7, %xmm7
; AVX512-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[3,3,3,3]
; AVX512-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0],xmm1[1],xmm2[2,3]
; AVX512-NEXT:    vpextrd $3, %xmm3, %eax
; AVX512-NEXT:    vpinsrd $2, %eax, %xmm2, %xmm2
; AVX512-NEXT:    vpextrd $1, %xmm4, %eax
; AVX512-NEXT:    vpinsrd $3, %eax, %xmm2, %xmm2
; AVX512-NEXT:    vpextrd $2, %xmm1, %eax
; AVX512-NEXT:    vpinsrd $1, %eax, %xmm0, %xmm3
; AVX512-NEXT:    vmovd %xmm5, %eax
; AVX512-NEXT:    vpinsrd $2, %eax, %xmm3, %xmm3
; AVX512-NEXT:    vpextrd $2, %xmm4, %eax
; AVX512-NEXT:    vpinsrd $3, %eax, %xmm3, %xmm3
; AVX512-NEXT:    vpextrd $3, %xmm1, %eax
; AVX512-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX512-NEXT:    vpinsrd $1, %eax, %xmm0, %xmm0
; AVX512-NEXT:    vpextrd $1, %xmm5, %eax
; AVX512-NEXT:    vpinsrd $2, %eax, %xmm0, %xmm0
; AVX512-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0,1,2],xmm4[3]
; AVX512-NEXT:    vmovdqa %xmm8, (%rsi)
; AVX512-NEXT:    vmovdqa %xmm6, (%rdx)
; AVX512-NEXT:    vmovdqa %xmm7, (%rcx)
; AVX512-NEXT:    vmovdqa %xmm2, (%r8)
; AVX512-NEXT:    vmovdqa %xmm3, (%r9)
; AVX512-NEXT:    vmovdqa %xmm0, (%r10)
; AVX512-NEXT:    retq
  %wide.vec = load <24 x i32>, <24 x i32>* %in.vec, align 32

  %strided.vec0 = shufflevector <24 x i32> %wide.vec, <24 x i32> poison, <4 x i32> <i32 0, i32 6, i32 12, i32 18>
  %strided.vec1 = shufflevector <24 x i32> %wide.vec, <24 x i32> poison, <4 x i32> <i32 1, i32 7, i32 13, i32 19>
  %strided.vec2 = shufflevector <24 x i32> %wide.vec, <24 x i32> poison, <4 x i32> <i32 2, i32 8, i32 14, i32 20>
  %strided.vec3 = shufflevector <24 x i32> %wide.vec, <24 x i32> poison, <4 x i32> <i32 3, i32 9, i32 15, i32 21>
  %strided.vec4 = shufflevector <24 x i32> %wide.vec, <24 x i32> poison, <4 x i32> <i32 4, i32 10, i32 16, i32 22>
  %strided.vec5 = shufflevector <24 x i32> %wide.vec, <24 x i32> poison, <4 x i32> <i32 5, i32 11, i32 17, i32 23>

  store <4 x i32> %strided.vec0, <4 x i32>* %out.vec0, align 32
  store <4 x i32> %strided.vec1, <4 x i32>* %out.vec1, align 32
  store <4 x i32> %strided.vec2, <4 x i32>* %out.vec2, align 32
  store <4 x i32> %strided.vec3, <4 x i32>* %out.vec3, align 32
  store <4 x i32> %strided.vec4, <4 x i32>* %out.vec4, align 32
  store <4 x i32> %strided.vec5, <4 x i32>* %out.vec5, align 32

  ret void
}

define void @load_i32_stride6_vf8(<48 x i32>* %in.vec, <8 x i32>* %out.vec0, <8 x i32>* %out.vec1, <8 x i32>* %out.vec2, <8 x i32>* %out.vec3, <8 x i32>* %out.vec4, <8 x i32>* %out.vec5) nounwind {
; SSE-LABEL: load_i32_stride6_vf8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa 144(%rdi), %xmm10
; SSE-NEXT:    movdqa 160(%rdi), %xmm14
; SSE-NEXT:    movdqa 96(%rdi), %xmm11
; SSE-NEXT:    movdqa 112(%rdi), %xmm5
; SSE-NEXT:    movdqa 64(%rdi), %xmm7
; SSE-NEXT:    movdqa (%rdi), %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 16(%rdi), %xmm2
; SSE-NEXT:    movdqa 48(%rdi), %xmm12
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[2,3,2,3]
; SSE-NEXT:    movdqa %xmm2, %xmm8
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm4[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm4[2,3,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm7[2,2,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm12[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm1[0],xmm6[1],xmm1[1]
; SSE-NEXT:    movsd {{.*#+}} xmm6 = xmm4[0],xmm6[1]
; SSE-NEXT:    movapd %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm5, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm13 = xmm5[2,3,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm11[1,1,1,1]
; SSE-NEXT:    movdqa %xmm11, %xmm1
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm13[0],xmm1[1],xmm13[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm14[2,2,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm15 = xmm10[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm15 = xmm15[0],xmm6[0],xmm15[1],xmm6[1]
; SSE-NEXT:    movsd {{.*#+}} xmm15 = xmm1[0],xmm15[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm8[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm7[2,3,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm12[2,2,3,3]
; SSE-NEXT:    movdqa %xmm12, %xmm13
; SSE-NEXT:    punpckldq {{.*#+}} xmm13 = xmm13[0],xmm1[0],xmm13[1],xmm1[1]
; SSE-NEXT:    movsd {{.*#+}} xmm13 = xmm2[0],xmm13[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm4[3,3,3,3]
; SSE-NEXT:    movdqa %xmm4, %xmm7
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm1[0],xmm5[1],xmm1[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm14[2,3,2,3]
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    movdqa %xmm10, %xmm9
; SSE-NEXT:    punpckldq {{.*#+}} xmm9 = xmm9[0],xmm1[0],xmm9[1],xmm1[1]
; SSE-NEXT:    movdqa 80(%rdi), %xmm10
; SSE-NEXT:    movsd {{.*#+}} xmm9 = xmm5[0],xmm9[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm10[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm1[0],xmm6[1],xmm1[1]
; SSE-NEXT:    movdqa 32(%rdi), %xmm4
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; SSE-NEXT:    movsd {{.*#+}} xmm6 = xmm3[0],xmm6[1]
; SSE-NEXT:    movapd %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[2,2,3,3]
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    movdqa 176(%rdi), %xmm8
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm8[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm2[0],xmm5[1],xmm2[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm11[2,3,2,3]
; SSE-NEXT:    movdqa 128(%rdi), %xmm3
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; SSE-NEXT:    movsd {{.*#+}} xmm5 = xmm0[0],xmm5[1]
; SSE-NEXT:    pshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm4[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm6[0],xmm0[1],xmm6[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm12 = xmm12[2,3,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm12 = xmm12[0],xmm10[0],xmm12[1],xmm10[1]
; SSE-NEXT:    movsd {{.*#+}} xmm12 = xmm0[0],xmm12[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm11[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm3[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm6[0],xmm0[1],xmm6[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm11 = xmm1[2,3,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm11 = xmm11[0],xmm8[0],xmm11[1],xmm8[1]
; SSE-NEXT:    movsd {{.*#+}} xmm11 = xmm0[0],xmm11[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[2,3,2,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm2, %xmm6
; SSE-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm0[0],xmm6[1],xmm0[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm10[2,2,3,3]
; SSE-NEXT:    pshufd $80, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm6[0],xmm1[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[2,3,2,3]
; SSE-NEXT:    movdqa %xmm7, %xmm6
; SSE-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm0[0],xmm6[1],xmm0[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm8[2,2,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm14[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm7[0],xmm0[1],xmm7[1]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm6[0],xmm0[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm2[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm4[0],xmm6[1],xmm4[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm10[2,3,2,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    punpckldq {{.*#+}} xmm7 = xmm7[0],xmm4[0],xmm7[1],xmm4[1]
; SSE-NEXT:    movsd {{.*#+}} xmm7 = xmm6[0],xmm7[1]
; SSE-NEXT:    pshufd $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = mem[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm8[2,3,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm14 = xmm14[0],xmm2[0],xmm14[1],xmm2[1]
; SSE-NEXT:    movsd {{.*#+}} xmm14 = xmm4[0],xmm14[1]
; SSE-NEXT:    movapd %xmm15, 16(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, (%rsi)
; SSE-NEXT:    movapd %xmm9, 16(%rdx)
; SSE-NEXT:    movapd %xmm13, (%rdx)
; SSE-NEXT:    movapd %xmm5, 16(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, (%rcx)
; SSE-NEXT:    movapd %xmm11, 16(%r8)
; SSE-NEXT:    movapd %xmm12, (%r8)
; SSE-NEXT:    movapd %xmm0, 16(%r9)
; SSE-NEXT:    movapd %xmm1, (%r9)
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movapd %xmm14, 16(%rax)
; SSE-NEXT:    movapd %xmm7, (%rax)
; SSE-NEXT:    retq
;
; AVX1-LABEL: load_i32_stride6_vf8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-NEXT:    vmovaps 128(%rdi), %ymm10
; AVX1-NEXT:    vmovaps 160(%rdi), %ymm4
; AVX1-NEXT:    vmovaps 32(%rdi), %ymm9
; AVX1-NEXT:    vmovaps (%rdi), %ymm7
; AVX1-NEXT:    vmovaps 96(%rdi), %ymm0
; AVX1-NEXT:    vmovaps 64(%rdi), %ymm1
; AVX1-NEXT:    vinsertf128 $1, 96(%rdi), %ymm1, %ymm5
; AVX1-NEXT:    vshufps {{.*#+}} ymm2 = ymm0[2,0],ymm5[0,0],ymm0[6,4],ymm5[4,4]
; AVX1-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[2,0],ymm5[2,2],ymm2[6,4],ymm5[6,6]
; AVX1-NEXT:    vblendps {{.*#+}} ymm8 = ymm7[0,1,2,3],ymm9[4,5],ymm7[6,7]
; AVX1-NEXT:    vextractf128 $1, %ymm8, %xmm6
; AVX1-NEXT:    vblendps {{.*#+}} xmm3 = xmm8[0,1],xmm6[2,3]
; AVX1-NEXT:    vshufps {{.*#+}} xmm3 = xmm3[0,2],xmm6[0,3]
; AVX1-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1,2],ymm2[3,4,5],ymm3[6,7]
; AVX1-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1,2,3],ymm10[4,5],ymm4[6,7]
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm3[2,3,0,1]
; AVX1-NEXT:    vshufps {{.*#+}} ymm12 = ymm11[2,0],ymm3[0,0],ymm11[6,4],ymm3[4,4]
; AVX1-NEXT:    vpermilps {{.*#+}} ymm12 = ymm12[0,1,2,0,4,5,6,4]
; AVX1-NEXT:    vblendps {{.*#+}} ymm13 = ymm2[0,1,2,3,4,5],ymm12[6,7]
; AVX1-NEXT:    vshufps {{.*#+}} ymm12 = ymm0[3,0],ymm5[1,0],ymm0[7,4],ymm5[5,4]
; AVX1-NEXT:    vshufps {{.*#+}} ymm5 = ymm12[2,0],ymm5[2,3],ymm12[6,4],ymm5[6,7]
; AVX1-NEXT:    vshufps {{.*#+}} xmm2 = xmm8[1,0],xmm6[3,0]
; AVX1-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,2],xmm6[1,3]
; AVX1-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2],ymm5[3,4,5],ymm2[6,7]
; AVX1-NEXT:    vshufps {{.*#+}} ymm3 = ymm11[3,0],ymm3[1,0],ymm11[7,4],ymm3[5,4]
; AVX1-NEXT:    vpermilps {{.*#+}} ymm3 = ymm3[0,1,2,0,4,5,6,4]
; AVX1-NEXT:    vblendps {{.*#+}} ymm8 = ymm2[0,1,2,3,4,5],ymm3[6,7]
; AVX1-NEXT:    vblendps {{.*#+}} ymm2 = ymm10[0,1,2,3],ymm4[4,5],ymm10[6,7]
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm2[2,3,0,1]
; AVX1-NEXT:    vshufps {{.*#+}} ymm6 = ymm3[0,0],ymm2[2,0],ymm3[4,4],ymm2[6,4]
; AVX1-NEXT:    vblendps {{.*#+}} ymm7 = ymm9[0,1],ymm7[2,3],ymm9[4,5,6,7]
; AVX1-NEXT:    vextractf128 $1, %ymm7, %xmm5
; AVX1-NEXT:    vshufps {{.*#+}} xmm9 = xmm7[2,0],xmm5[2,3]
; AVX1-NEXT:    vshufps {{.*#+}} ymm11 = ymm0[2,1],ymm1[2,0],ymm0[6,5],ymm1[6,4]
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm11[2,3,0,1]
; AVX1-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2],ymm11[3,4],ymm9[5,6,7]
; AVX1-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3,4],ymm6[5,6,7]
; AVX1-NEXT:    vshufps {{.*#+}} ymm2 = ymm3[0,1],ymm2[3,1],ymm3[4,5],ymm2[7,5]
; AVX1-NEXT:    vshufps {{.*#+}} xmm3 = xmm7[3,1],xmm5[3,3]
; AVX1-NEXT:    vshufps {{.*#+}} ymm5 = ymm0[3,1],ymm1[2,1],ymm0[7,5],ymm1[6,5]
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm5[2,3,0,1]
; AVX1-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2],ymm5[3,4],ymm3[5,6,7]
; AVX1-NEXT:    vblendps {{.*#+}} ymm11 = ymm3[0,1,2,3,4],ymm2[5,6,7]
; AVX1-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1],ymm10[2,3],ymm4[4,5,6,7]
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm3[2,3,0,1]
; AVX1-NEXT:    vshufps {{.*#+}} ymm5 = ymm3[2,0],ymm4[0,0],ymm3[6,4],ymm4[4,4]
; AVX1-NEXT:    vshufps {{.*#+}} ymm5 = ymm4[0,2],ymm5[2,0],ymm4[4,6],ymm5[6,4]
; AVX1-NEXT:    vmovaps 32(%rdi), %xmm7
; AVX1-NEXT:    vpermilps {{.*#+}} xmm6 = xmm7[2,2,3,3]
; AVX1-NEXT:    vmovaps 16(%rdi), %xmm2
; AVX1-NEXT:    vblendps {{.*#+}} xmm6 = xmm2[0],xmm6[1],xmm2[2,3]
; AVX1-NEXT:    vmovapd 80(%rdi), %xmm10
; AVX1-NEXT:    vshufpd {{.*#+}} ymm12 = ymm10[1],ymm1[0],ymm10[2],ymm1[2]
; AVX1-NEXT:    vshufps {{.*#+}} ymm12 = ymm0[0,1],ymm12[2,0],ymm0[4,5],ymm12[6,4]
; AVX1-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1],ymm12[2,3,4,5,6,7]
; AVX1-NEXT:    vblendps {{.*#+}} ymm5 = ymm6[0,1,2,3,4],ymm5[5,6,7]
; AVX1-NEXT:    vshufps {{.*#+}} ymm3 = ymm3[3,0],ymm4[1,0],ymm3[7,4],ymm4[5,4]
; AVX1-NEXT:    vshufps {{.*#+}} ymm3 = ymm4[0,3],ymm3[2,0],ymm4[4,7],ymm3[6,4]
; AVX1-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0,1],xmm7[2,3]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm2 = xmm2[1,3,2,3]
; AVX1-NEXT:    vshufps {{.*#+}} ymm1 = ymm10[3,1],ymm1[1,3],ymm10[7,5],ymm1[5,7]
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,1],ymm1[2,0],ymm0[5,5],ymm1[6,4]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3,4,5,6,7]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm3[5,6,7]
; AVX1-NEXT:    vmovaps %ymm13, (%rsi)
; AVX1-NEXT:    vmovaps %ymm8, (%rdx)
; AVX1-NEXT:    vmovaps %ymm9, (%rcx)
; AVX1-NEXT:    vmovaps %ymm11, (%r8)
; AVX1-NEXT:    vmovaps %ymm5, (%r9)
; AVX1-NEXT:    vmovaps %ymm0, (%rax)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: load_i32_stride6_vf8:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-SLOW-NEXT:    vmovaps 128(%rdi), %ymm0
; AVX2-SLOW-NEXT:    vmovaps 160(%rdi), %ymm1
; AVX2-SLOW-NEXT:    vmovaps 96(%rdi), %ymm5
; AVX2-SLOW-NEXT:    vmovaps (%rdi), %ymm3
; AVX2-SLOW-NEXT:    vmovaps 32(%rdi), %ymm4
; AVX2-SLOW-NEXT:    vmovaps 64(%rdi), %ymm6
; AVX2-SLOW-NEXT:    vmovaps {{.*#+}} xmm2 = <0,6,4,u>
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm7 = ymm3[0,1,2,3],ymm4[4,5],ymm3[6,7]
; AVX2-SLOW-NEXT:    vpermps %ymm7, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm6[0,1],ymm5[0,1]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm9 = ymm8[0,1,2,2,4,5,6,6]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm10 = ymm5[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0],ymm10[1],ymm9[2,3,4],ymm10[5],ymm9[6,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2],ymm9[3,4,5],ymm2[6,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm9 = ymm1[0,1,2,3],ymm0[4,5],ymm1[6,7]
; AVX2-SLOW-NEXT:    vbroadcastsd {{.*#+}} ymm10 = [8589934596,8589934596,8589934596,8589934596]
; AVX2-SLOW-NEXT:    vpermps %ymm9, %ymm10, %ymm10
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm10[6,7]
; AVX2-SLOW-NEXT:    vmovaps {{.*#+}} xmm10 = <1,7,5,u>
; AVX2-SLOW-NEXT:    vpermps %ymm7, %ymm10, %ymm7
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm8 = ymm8[1,1,2,3,5,5,6,7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm10 = ymm5[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0],ymm10[1],ymm8[2,3,4],ymm10[5],ymm8[6,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2],ymm8[3,4,5],ymm7[6,7]
; AVX2-SLOW-NEXT:    vbroadcastsd {{.*#+}} ymm8 = [12884901893,12884901893,12884901893,12884901893]
; AVX2-SLOW-NEXT:    vpermps %ymm9, %ymm8, %ymm8
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3,4,5],ymm8[6,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm8 = ymm6[0,1],ymm5[2,3],ymm6[4,5],ymm5[6,7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm8 = ymm8[2,0,2,3,6,4,6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[0,2,0,3]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm9 = ymm3[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm10 = ymm4[0,0,2,3,4,4,6,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0],ymm10[1,2,3],ymm9[4],ymm10[5,6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[0,3,2,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm8 = ymm9[0,1,2],ymm8[3,4],ymm9[5,6,7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm9 = ymm1[0,0,0,0,4,4,4,4]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm10 = ymm0[0,0,2,3,4,4,6,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0,1,2],ymm9[3],ymm10[4,5,6],ymm9[7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[0,1,0,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2,3,4],ymm9[5,6,7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm9 = ymm5[3,3,3,3,7,7,7,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0],ymm6[1],ymm9[2,3,4],ymm6[5],ymm9[6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[0,2,0,3]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm10 = ymm3[3,3,3,3,7,7,7,7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm11 = ymm4[0,1,3,3,4,5,7,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0],ymm11[1,2,3],ymm10[4],ymm11[5,6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[0,3,2,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0,1,2],ymm9[3,4],ymm10[5,6,7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm10 = ymm1[0,1,0,1,4,5,4,5]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm11 = ymm0[0,1,3,3,4,5,7,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm10 = ymm11[0,1,2],ymm10[3],ymm11[4,5,6],ymm10[7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[0,1,0,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3,4],ymm10[5,6,7]
; AVX2-SLOW-NEXT:    vmovaps 80(%rdi), %xmm10
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm5 = ymm6[0,1,2,3],ymm5[4,5,6,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm6 = ymm5[0,1],ymm10[2,3],ymm5[4,5],ymm10[6,7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm6 = ymm6[0,1,0,2,4,5,4,6]
; AVX2-SLOW-NEXT:    vmovaps {{.*#+}} xmm11 = <4,2,u,u>
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1,2,3],ymm3[4,5],ymm4[6,7]
; AVX2-SLOW-NEXT:    vpermps %ymm3, %ymm11, %ymm4
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm6[2,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5,6,7]
; AVX2-SLOW-NEXT:    vbroadcastf128 {{.*#+}} ymm1 = [0,2,0,6,0,2,0,6]
; AVX2-SLOW-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-SLOW-NEXT:    vpermps %ymm0, %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm1 = ymm4[0,1,2,3,4],ymm1[5,6,7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm4 = ymm5[1,1,1,1,5,5,5,5]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2],ymm10[3],ymm4[4,5,6],ymm10[7]
; AVX2-SLOW-NEXT:    vmovaps {{.*#+}} xmm5 = <5,3,u,u>
; AVX2-SLOW-NEXT:    vpermps %ymm3, %ymm5, %ymm3
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm4[2,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vbroadcastf128 {{.*#+}} ymm4 = [0,3,1,7,0,3,1,7]
; AVX2-SLOW-NEXT:    # ymm4 = mem[0,1,0,1]
; AVX2-SLOW-NEXT:    vpermps %ymm0, %ymm4, %ymm0
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0,1,2,3,4],ymm0[5,6,7]
; AVX2-SLOW-NEXT:    vmovaps %ymm2, (%rsi)
; AVX2-SLOW-NEXT:    vmovaps %ymm7, (%rdx)
; AVX2-SLOW-NEXT:    vmovaps %ymm8, (%rcx)
; AVX2-SLOW-NEXT:    vmovaps %ymm9, (%r8)
; AVX2-SLOW-NEXT:    vmovaps %ymm1, (%r9)
; AVX2-SLOW-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: load_i32_stride6_vf8:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-ALL-NEXT:    vmovaps 128(%rdi), %ymm0
; AVX2-FAST-ALL-NEXT:    vmovaps 160(%rdi), %ymm1
; AVX2-FAST-ALL-NEXT:    vmovaps 96(%rdi), %ymm5
; AVX2-FAST-ALL-NEXT:    vmovaps (%rdi), %ymm3
; AVX2-FAST-ALL-NEXT:    vmovaps 32(%rdi), %ymm4
; AVX2-FAST-ALL-NEXT:    vmovaps 64(%rdi), %ymm6
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} xmm2 = <0,6,4,u>
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm7 = ymm3[0,1,2,3],ymm4[4,5],ymm3[6,7]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm7, %ymm2, %ymm2
; AVX2-FAST-ALL-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm6[0,1],ymm5[0,1]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm9 = ymm8[0,1,2,2,4,5,6,6]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm10 = ymm5[2,2,2,2,6,6,6,6]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0],ymm10[1],ymm9[2,3,4],ymm10[5],ymm9[6,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2],ymm9[3,4,5],ymm2[6,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm9 = ymm1[0,1,2,3],ymm0[4,5],ymm1[6,7]
; AVX2-FAST-ALL-NEXT:    vbroadcastsd {{.*#+}} ymm10 = [8589934596,8589934596,8589934596,8589934596]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm9, %ymm10, %ymm10
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm10[6,7]
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} xmm10 = <1,7,5,u>
; AVX2-FAST-ALL-NEXT:    vpermps %ymm7, %ymm10, %ymm7
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm8 = ymm8[1,1,2,3,5,5,6,7]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm10 = ymm5[2,3,2,3,6,7,6,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0],ymm10[1],ymm8[2,3,4],ymm10[5],ymm8[6,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2],ymm8[3,4,5],ymm7[6,7]
; AVX2-FAST-ALL-NEXT:    vbroadcastsd {{.*#+}} ymm8 = [12884901893,12884901893,12884901893,12884901893]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm9, %ymm8, %ymm8
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3,4,5],ymm8[6,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm8 = ymm6[0,1],ymm5[2,3],ymm6[4,5],ymm5[6,7]
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm9 = <u,u,u,4,2,u,u,u>
; AVX2-FAST-ALL-NEXT:    vpermps %ymm8, %ymm9, %ymm8
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm9 = ymm3[2,3,2,3,6,7,6,7]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm10 = ymm4[0,0,2,3,4,4,6,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0],ymm10[1,2,3],ymm9[4],ymm10[5,6,7]
; AVX2-FAST-ALL-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[0,3,2,3]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm8 = ymm9[0,1,2],ymm8[3,4],ymm9[5,6,7]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm9 = ymm1[0,0,0,0,4,4,4,4]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm10 = ymm0[0,0,2,3,4,4,6,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0,1,2],ymm9[3],ymm10[4,5,6],ymm9[7]
; AVX2-FAST-ALL-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[0,1,0,3]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2,3,4],ymm9[5,6,7]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm9 = ymm5[3,3,3,3,7,7,7,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0],ymm6[1],ymm9[2,3,4],ymm6[5],ymm9[6,7]
; AVX2-FAST-ALL-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[0,2,0,3]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm10 = ymm3[3,3,3,3,7,7,7,7]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm11 = ymm4[0,1,3,3,4,5,7,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0],ymm11[1,2,3],ymm10[4],ymm11[5,6,7]
; AVX2-FAST-ALL-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[0,3,2,3]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0,1,2],ymm9[3,4],ymm10[5,6,7]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm10 = ymm1[0,1,0,1,4,5,4,5]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm11 = ymm0[0,1,3,3,4,5,7,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm10 = ymm11[0,1,2],ymm10[3],ymm11[4,5,6],ymm10[7]
; AVX2-FAST-ALL-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[0,1,0,3]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3,4],ymm10[5,6,7]
; AVX2-FAST-ALL-NEXT:    vmovaps 80(%rdi), %xmm10
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm5 = ymm6[0,1,2,3],ymm5[4,5,6,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm6 = ymm5[0,1],ymm10[2,3],ymm5[4,5],ymm10[6,7]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm6 = ymm6[0,1,0,2,4,5,4,6]
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} xmm11 = <4,2,u,u>
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1,2,3],ymm3[4,5],ymm4[6,7]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm3, %ymm11, %ymm4
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm6[2,3,4,5,6,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5,6,7]
; AVX2-FAST-ALL-NEXT:    vbroadcastf128 {{.*#+}} ymm1 = [0,2,0,6,0,2,0,6]
; AVX2-FAST-ALL-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm1
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm1 = ymm4[0,1,2,3,4],ymm1[5,6,7]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm4 = ymm5[1,1,1,1,5,5,5,5]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2],ymm10[3],ymm4[4,5,6],ymm10[7]
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} xmm5 = <5,3,u,u>
; AVX2-FAST-ALL-NEXT:    vpermps %ymm3, %ymm5, %ymm3
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm4[2,3,4,5,6,7]
; AVX2-FAST-ALL-NEXT:    vbroadcastf128 {{.*#+}} ymm4 = [0,3,1,7,0,3,1,7]
; AVX2-FAST-ALL-NEXT:    # ymm4 = mem[0,1,0,1]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm0, %ymm4, %ymm0
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0,1,2,3,4],ymm0[5,6,7]
; AVX2-FAST-ALL-NEXT:    vmovaps %ymm2, (%rsi)
; AVX2-FAST-ALL-NEXT:    vmovaps %ymm7, (%rdx)
; AVX2-FAST-ALL-NEXT:    vmovaps %ymm8, (%rcx)
; AVX2-FAST-ALL-NEXT:    vmovaps %ymm9, (%r8)
; AVX2-FAST-ALL-NEXT:    vmovaps %ymm1, (%r9)
; AVX2-FAST-ALL-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-FAST-ALL-NEXT:    vzeroupper
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: load_i32_stride6_vf8:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-PERLANE-NEXT:    vmovaps 128(%rdi), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovaps 160(%rdi), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovaps 96(%rdi), %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovaps (%rdi), %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovaps 32(%rdi), %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovaps 64(%rdi), %ymm6
; AVX2-FAST-PERLANE-NEXT:    vmovaps {{.*#+}} xmm2 = <0,6,4,u>
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm7 = ymm3[0,1,2,3],ymm4[4,5],ymm3[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermps %ymm7, %ymm2, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm6[0,1],ymm5[0,1]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm9 = ymm8[0,1,2,2,4,5,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm10 = ymm5[2,2,2,2,6,6,6,6]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0],ymm10[1],ymm9[2,3,4],ymm10[5],ymm9[6,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2],ymm9[3,4,5],ymm2[6,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm9 = ymm1[0,1,2,3],ymm0[4,5],ymm1[6,7]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd {{.*#+}} ymm10 = [8589934596,8589934596,8589934596,8589934596]
; AVX2-FAST-PERLANE-NEXT:    vpermps %ymm9, %ymm10, %ymm10
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm10[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps {{.*#+}} xmm10 = <1,7,5,u>
; AVX2-FAST-PERLANE-NEXT:    vpermps %ymm7, %ymm10, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm8 = ymm8[1,1,2,3,5,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm10 = ymm5[2,3,2,3,6,7,6,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0],ymm10[1],ymm8[2,3,4],ymm10[5],ymm8[6,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2],ymm8[3,4,5],ymm7[6,7]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd {{.*#+}} ymm8 = [12884901893,12884901893,12884901893,12884901893]
; AVX2-FAST-PERLANE-NEXT:    vpermps %ymm9, %ymm8, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3,4,5],ymm8[6,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm8 = ymm6[0,1],ymm5[2,3],ymm6[4,5],ymm5[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm8 = ymm8[2,0,2,3,6,4,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[0,2,0,3]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm9 = ymm3[2,3,2,3,6,7,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm10 = ymm4[0,0,2,3,4,4,6,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0],ymm10[1,2,3],ymm9[4],ymm10[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[0,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm8 = ymm9[0,1,2],ymm8[3,4],ymm9[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm9 = ymm1[0,0,0,0,4,4,4,4]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm10 = ymm0[0,0,2,3,4,4,6,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0,1,2],ymm9[3],ymm10[4,5,6],ymm9[7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[0,1,0,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2,3,4],ymm9[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm9 = ymm5[3,3,3,3,7,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0],ymm6[1],ymm9[2,3,4],ymm6[5],ymm9[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[0,2,0,3]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm10 = ymm3[3,3,3,3,7,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm11 = ymm4[0,1,3,3,4,5,7,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0],ymm11[1,2,3],ymm10[4],ymm11[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[0,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0,1,2],ymm9[3,4],ymm10[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm10 = ymm1[0,1,0,1,4,5,4,5]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm11 = ymm0[0,1,3,3,4,5,7,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm10 = ymm11[0,1,2],ymm10[3],ymm11[4,5,6],ymm10[7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[0,1,0,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3,4],ymm10[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps 80(%rdi), %xmm10
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm5 = ymm6[0,1,2,3],ymm5[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm6 = ymm5[0,1],ymm10[2,3],ymm5[4,5],ymm10[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm6 = ymm6[0,1,0,2,4,5,4,6]
; AVX2-FAST-PERLANE-NEXT:    vmovaps {{.*#+}} xmm11 = <4,2,u,u>
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1,2,3],ymm3[4,5],ymm4[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermps %ymm3, %ymm11, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm6[2,3,4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastf128 {{.*#+}} ymm1 = [0,2,0,6,0,2,0,6]
; AVX2-FAST-PERLANE-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpermps %ymm0, %ymm1, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm1 = ymm4[0,1,2,3,4],ymm1[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm4 = ymm5[1,1,1,1,5,5,5,5]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2],ymm10[3],ymm4[4,5,6],ymm10[7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps {{.*#+}} xmm5 = <5,3,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpermps %ymm3, %ymm5, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm4[2,3,4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastf128 {{.*#+}} ymm4 = [0,3,1,7,0,3,1,7]
; AVX2-FAST-PERLANE-NEXT:    # ymm4 = mem[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpermps %ymm0, %ymm4, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0,1,2,3,4],ymm0[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm2, (%rsi)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm7, (%rdx)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm8, (%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm9, (%r8)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm1, (%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512-LABEL: load_i32_stride6_vf8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovdqu64 (%rdi), %zmm2
; AVX512-NEXT:    vmovdqu64 64(%rdi), %zmm3
; AVX512-NEXT:    vmovdqa 128(%rdi), %ymm0
; AVX512-NEXT:    vmovdqa 160(%rdi), %ymm1
; AVX512-NEXT:    vpblendd {{.*#+}} ymm4 = ymm1[0,1,2,3],ymm0[4,5],ymm1[6,7]
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm5 = <0,6,12,18,24,30,u,u>
; AVX512-NEXT:    vpermi2d %zmm3, %zmm2, %zmm5
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm6 = [0,1,2,3,4,5,12,10]
; AVX512-NEXT:    vpermi2d %ymm4, %ymm5, %ymm6
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm5 = <1,7,13,19,25,31,u,u>
; AVX512-NEXT:    vpermi2d %zmm3, %zmm2, %zmm5
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm7 = [0,1,2,3,4,5,13,11]
; AVX512-NEXT:    vpermi2d %ymm4, %ymm5, %ymm7
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm4 = <u,u,u,u,u,0,6,12>
; AVX512-NEXT:    vpermi2d %ymm1, %ymm0, %ymm4
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm5 = <2,8,14,20,26,u,u,u>
; AVX512-NEXT:    vpermi2d %zmm3, %zmm2, %zmm5
; AVX512-NEXT:    vpblendd {{.*#+}} ymm4 = ymm5[0,1,2,3,4],ymm4[5,6,7]
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm5 = <u,u,u,u,u,1,7,13>
; AVX512-NEXT:    vpermi2d %ymm1, %ymm0, %ymm5
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm8 = <3,9,15,21,27,u,u,u>
; AVX512-NEXT:    vpermi2d %zmm3, %zmm2, %zmm8
; AVX512-NEXT:    vpblendd {{.*#+}} ymm5 = ymm8[0,1,2,3,4],ymm5[5,6,7]
; AVX512-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5,6,7]
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm1 = <20,26,0,6,12,u,u,u>
; AVX512-NEXT:    vpermi2d %zmm2, %zmm3, %zmm1
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm8 = [0,1,2,3,4,10,8,14]
; AVX512-NEXT:    vpermi2d %ymm0, %ymm1, %ymm8
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm1 = <21,27,1,7,13,u,u,u>
; AVX512-NEXT:    vpermi2d %zmm2, %zmm3, %zmm1
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,1,2,3,4,11,9,15]
; AVX512-NEXT:    vpermi2d %ymm0, %ymm1, %ymm2
; AVX512-NEXT:    vmovdqa %ymm6, (%rsi)
; AVX512-NEXT:    vmovdqa %ymm7, (%rdx)
; AVX512-NEXT:    vmovdqa %ymm4, (%rcx)
; AVX512-NEXT:    vmovdqa %ymm5, (%r8)
; AVX512-NEXT:    vmovdqa %ymm8, (%r9)
; AVX512-NEXT:    vmovdqa %ymm2, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %wide.vec = load <48 x i32>, <48 x i32>* %in.vec, align 32

  %strided.vec0 = shufflevector <48 x i32> %wide.vec, <48 x i32> poison, <8 x i32> <i32 0, i32 6, i32 12, i32 18, i32 24, i32 30, i32 36, i32 42>
  %strided.vec1 = shufflevector <48 x i32> %wide.vec, <48 x i32> poison, <8 x i32> <i32 1, i32 7, i32 13, i32 19, i32 25, i32 31, i32 37, i32 43>
  %strided.vec2 = shufflevector <48 x i32> %wide.vec, <48 x i32> poison, <8 x i32> <i32 2, i32 8, i32 14, i32 20, i32 26, i32 32, i32 38, i32 44>
  %strided.vec3 = shufflevector <48 x i32> %wide.vec, <48 x i32> poison, <8 x i32> <i32 3, i32 9, i32 15, i32 21, i32 27, i32 33, i32 39, i32 45>
  %strided.vec4 = shufflevector <48 x i32> %wide.vec, <48 x i32> poison, <8 x i32> <i32 4, i32 10, i32 16, i32 22, i32 28, i32 34, i32 40, i32 46>
  %strided.vec5 = shufflevector <48 x i32> %wide.vec, <48 x i32> poison, <8 x i32> <i32 5, i32 11, i32 17, i32 23, i32 29, i32 35, i32 41, i32 47>

  store <8 x i32> %strided.vec0, <8 x i32>* %out.vec0, align 32
  store <8 x i32> %strided.vec1, <8 x i32>* %out.vec1, align 32
  store <8 x i32> %strided.vec2, <8 x i32>* %out.vec2, align 32
  store <8 x i32> %strided.vec3, <8 x i32>* %out.vec3, align 32
  store <8 x i32> %strided.vec4, <8 x i32>* %out.vec4, align 32
  store <8 x i32> %strided.vec5, <8 x i32>* %out.vec5, align 32

  ret void
}

define void @load_i32_stride6_vf16(<96 x i32>* %in.vec, <16 x i32>* %out.vec0, <16 x i32>* %out.vec1, <16 x i32>* %out.vec2, <16 x i32>* %out.vec3, <16 x i32>* %out.vec4, <16 x i32>* %out.vec5) nounwind {
; SSE-LABEL: load_i32_stride6_vf16:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $376, %rsp # imm = 0x178
; SSE-NEXT:    movdqa 144(%rdi), %xmm9
; SSE-NEXT:    movdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 160(%rdi), %xmm8
; SSE-NEXT:    movdqa 96(%rdi), %xmm12
; SSE-NEXT:    movdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 112(%rdi), %xmm10
; SSE-NEXT:    movdqa 240(%rdi), %xmm11
; SSE-NEXT:    movdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 256(%rdi), %xmm7
; SSE-NEXT:    movdqa 192(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 208(%rdi), %xmm1
; SSE-NEXT:    movdqa 64(%rdi), %xmm6
; SSE-NEXT:    movdqa (%rdi), %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 16(%rdi), %xmm14
; SSE-NEXT:    movdqa 48(%rdi), %xmm5
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm14[2,3,2,3]
; SSE-NEXT:    movdqa %xmm14, (%rsp) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm4, %xmm3
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm6[2,2,3,3]
; SSE-NEXT:    movdqa %xmm6, %xmm15
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm2[0],xmm6[1],xmm2[1]
; SSE-NEXT:    movsd {{.*#+}} xmm6 = xmm3[0],xmm6[1]
; SSE-NEXT:    movapd %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[2,3,2,3]
; SSE-NEXT:    movdqa %xmm1, %xmm13
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm7[2,2,3,3]
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm11[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm2[0],xmm6[1],xmm2[1]
; SSE-NEXT:    movsd {{.*#+}} xmm6 = xmm3[0],xmm6[1]
; SSE-NEXT:    movapd %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm10[2,3,2,3]
; SSE-NEXT:    movdqa %xmm10, %xmm11
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm12, %xmm3
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm8[2,2,3,3]
; SSE-NEXT:    movdqa %xmm8, %xmm6
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm9[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm3[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 288(%rdi), %xmm9
; SSE-NEXT:    movdqa 304(%rdi), %xmm10
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm10[2,3,2,3]
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm9, %xmm4
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; SSE-NEXT:    movdqa 336(%rdi), %xmm12
; SSE-NEXT:    movdqa 352(%rdi), %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm5[2,2,3,3]
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm12[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm3[0],xmm1[1],xmm3[1]
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm4[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm8[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm14[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm15[2,3,2,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm3[0],xmm0[1]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm13[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm7[2,3,2,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm7, %xmm0
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm3[0],xmm0[1]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm13[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm11[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm6[2,3,2,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm6, %xmm0
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm3[0],xmm0[1]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm9[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm10[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm5[2,3,2,3]
; SSE-NEXT:    movdqa %xmm12, %xmm0
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm3[0],xmm0[1]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[2,2,3,3]
; SSE-NEXT:    movdqa 80(%rdi), %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; SSE-NEXT:    movdqa %xmm8, %xmm14
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm8[2,3,2,3]
; SSE-NEXT:    movdqa 32(%rdi), %xmm4
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; SSE-NEXT:    movdqa %xmm4, %xmm5
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm3[0],xmm0[1]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[2,2,3,3]
; SSE-NEXT:    movdqa 272(%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[2,3,2,3]
; SSE-NEXT:    movdqa %xmm1, %xmm10
; SSE-NEXT:    movdqa 224(%rdi), %xmm4
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm3[0],xmm0[1]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm12[2,2,3,3]
; SSE-NEXT:    movdqa 368(%rdi), %xmm15
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm15[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm9[2,3,2,3]
; SSE-NEXT:    movdqa 320(%rdi), %xmm11
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm11[0],xmm3[1],xmm11[1]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm3[0],xmm0[1]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[2,2,3,3]
; SSE-NEXT:    movdqa 176(%rdi), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; SSE-NEXT:    movdqa %xmm13, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm13[2,3,2,3]
; SSE-NEXT:    movdqa 128(%rdi), %xmm8
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm8[0],xmm3[1],xmm8[1]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm3[0],xmm0[1]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm14[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm5[1,1,1,1]
; SSE-NEXT:    movdqa %xmm5, %xmm7
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; SSE-NEXT:    pshufd $238, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[2,3,2,3]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm10[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm4[1,1,1,1]
; SSE-NEXT:    movdqa %xmm4, %xmm14
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    pshufd $238, {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Folded Reload
; SSE-NEXT:    # xmm13 = mem[2,3,2,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    punpckldq {{.*#+}} xmm13 = xmm13[0],xmm3[0],xmm13[1],xmm3[1]
; SSE-NEXT:    movsd {{.*#+}} xmm13 = xmm0[0],xmm13[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm11[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm12 = xmm12[2,3,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm12 = xmm12[0],xmm15[0],xmm12[1],xmm15[1]
; SSE-NEXT:    movsd {{.*#+}} xmm12 = xmm0[0],xmm12[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[3,3,3,3]
; SSE-NEXT:    movdqa %xmm8, %xmm5
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm8[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    pshufd $238, {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Folded Reload
; SSE-NEXT:    # xmm10 = mem[2,3,2,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    punpckldq {{.*#+}} xmm10 = xmm10[0],xmm4[0],xmm10[1],xmm4[1]
; SSE-NEXT:    movsd {{.*#+}} xmm10 = xmm0[0],xmm10[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[2,3,2,3]
; SSE-NEXT:    movdqa (%rsp), %xmm1 # 16-byte Reload
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[2,2,3,3]
; SSE-NEXT:    pshufd $80, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Folded Reload
; SSE-NEXT:    # xmm8 = mem[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm8 = xmm8[0],xmm0[0],xmm8[1],xmm0[1]
; SSE-NEXT:    movsd {{.*#+}} xmm8 = xmm1[0],xmm8[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm14[2,3,2,3]
; SSE-NEXT:    movdqa %xmm14, %xmm7
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[2,2,3,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm9[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm0[0],xmm6[1],xmm0[1]
; SSE-NEXT:    movsd {{.*#+}} xmm6 = xmm1[0],xmm6[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm5[2,3,2,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm4[2,2,3,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm14[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm1[0],xmm5[1],xmm1[1]
; SSE-NEXT:    movsd {{.*#+}} xmm5 = xmm0[0],xmm5[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm11[2,3,2,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm4[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm0[0],xmm4[1],xmm0[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm15[2,2,3,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; SSE-NEXT:    movsd {{.*#+}} xmm3 = xmm4[0],xmm3[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm11[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm15[2,3,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; SSE-NEXT:    movapd %xmm0, %xmm11
; SSE-NEXT:    pshufd $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm7[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; SSE-NEXT:    pshufd $238, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[2,3,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm9 = xmm9[0],xmm2[0],xmm9[1],xmm2[1]
; SSE-NEXT:    movsd {{.*#+}} xmm9 = xmm1[0],xmm9[1]
; SSE-NEXT:    pshufd $85, (%rsp), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[1,1,1,1]
; SSE-NEXT:    pshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; SSE-NEXT:    pshufd $238, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[2,3,2,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    punpckldq {{.*#+}} xmm7 = xmm7[0],xmm2[0],xmm7[1],xmm2[1]
; SSE-NEXT:    movsd {{.*#+}} xmm7 = xmm1[0],xmm7[1]
; SSE-NEXT:    pshufd $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[1,1,1,1]
; SSE-NEXT:    pshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; SSE-NEXT:    pshufd $238, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[2,3,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm14 = xmm14[0],xmm2[0],xmm14[1],xmm2[1]
; SSE-NEXT:    movsd {{.*#+}} xmm14 = xmm1[0],xmm14[1]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, (%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rcx)
; SSE-NEXT:    movapd %xmm10, 16(%r8)
; SSE-NEXT:    movapd %xmm12, 48(%r8)
; SSE-NEXT:    movapd %xmm13, 32(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%r8)
; SSE-NEXT:    movapd %xmm3, 48(%r9)
; SSE-NEXT:    movapd %xmm5, 16(%r9)
; SSE-NEXT:    movapd %xmm6, 32(%r9)
; SSE-NEXT:    movapd %xmm8, (%r9)
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movapd %xmm14, 16(%rax)
; SSE-NEXT:    movapd %xmm7, (%rax)
; SSE-NEXT:    movapd %xmm9, 32(%rax)
; SSE-NEXT:    movapd %xmm11, 48(%rax)
; SSE-NEXT:    addq $376, %rsp # imm = 0x178
; SSE-NEXT:    retq
;
; AVX1-LABEL: load_i32_stride6_vf16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    subq $328, %rsp # imm = 0x148
; AVX1-NEXT:    vmovaps 96(%rdi), %ymm14
; AVX1-NEXT:    vmovaps 64(%rdi), %ymm6
; AVX1-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vmovaps 320(%rdi), %ymm2
; AVX1-NEXT:    vmovups %ymm2, (%rsp) # 32-byte Spill
; AVX1-NEXT:    vmovaps 352(%rdi), %ymm3
; AVX1-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vmovaps 224(%rdi), %ymm4
; AVX1-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vmovaps 192(%rdi), %ymm5
; AVX1-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vmovaps 288(%rdi), %ymm1
; AVX1-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vmovaps 256(%rdi), %ymm0
; AVX1-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vinsertf128 $1, 288(%rdi), %ymm0, %ymm9
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[2,0],ymm9[0,0],ymm1[6,4],ymm9[4,4]
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[2,0],ymm9[2,2],ymm0[6,4],ymm9[6,6]
; AVX1-NEXT:    vblendps {{.*#+}} ymm10 = ymm5[0,1,2,3],ymm4[4,5],ymm5[6,7]
; AVX1-NEXT:    vextractf128 $1, %ymm10, %xmm15
; AVX1-NEXT:    vblendps {{.*#+}} xmm1 = xmm10[0,1],xmm15[2,3]
; AVX1-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,2],xmm15[0,3]
; AVX1-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX1-NEXT:    vblendps {{.*#+}} ymm5 = ymm3[0,1,2,3],ymm2[4,5],ymm3[6,7]
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm5[2,3,0,1]
; AVX1-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vshufps {{.*#+}} ymm2 = ymm0[2,0],ymm5[0,0],ymm0[6,4],ymm5[4,4]
; AVX1-NEXT:    vpermilps {{.*#+}} ymm2 = ymm2[0,1,2,0,4,5,6,4]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm2[6,7]
; AVX1-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vinsertf128 $1, 96(%rdi), %ymm6, %ymm2
; AVX1-NEXT:    vshufps {{.*#+}} ymm1 = ymm14[2,0],ymm2[0,0],ymm14[6,4],ymm2[4,4]
; AVX1-NEXT:    vshufps {{.*#+}} ymm13 = ymm1[2,0],ymm2[2,2],ymm1[6,4],ymm2[6,6]
; AVX1-NEXT:    vmovaps 32(%rdi), %ymm11
; AVX1-NEXT:    vmovaps (%rdi), %ymm8
; AVX1-NEXT:    vblendps {{.*#+}} ymm3 = ymm8[0,1,2,3],ymm11[4,5],ymm8[6,7]
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm0
; AVX1-NEXT:    vblendps {{.*#+}} xmm7 = xmm3[0,1],xmm0[2,3]
; AVX1-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,2],xmm0[0,3]
; AVX1-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2],ymm13[3,4,5],ymm7[6,7]
; AVX1-NEXT:    vmovaps 128(%rdi), %ymm6
; AVX1-NEXT:    vmovaps 160(%rdi), %ymm12
; AVX1-NEXT:    vblendps {{.*#+}} ymm1 = ymm12[0,1,2,3],ymm6[4,5],ymm12[6,7]
; AVX1-NEXT:    vmovaps %ymm12, %ymm13
; AVX1-NEXT:    vmovups %ymm12, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm1[2,3,0,1]
; AVX1-NEXT:    vshufps {{.*#+}} ymm12 = ymm4[2,0],ymm1[0,0],ymm4[6,4],ymm1[4,4]
; AVX1-NEXT:    vpermilps {{.*#+}} ymm12 = ymm12[0,1,2,0,4,5,6,4]
; AVX1-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3,4,5],ymm12[6,7]
; AVX1-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vshufps {{.*#+}} ymm7 = ymm14[3,0],ymm2[1,0],ymm14[7,4],ymm2[5,4]
; AVX1-NEXT:    vshufps {{.*#+}} ymm2 = ymm7[2,0],ymm2[2,3],ymm7[6,4],ymm2[6,7]
; AVX1-NEXT:    vshufps {{.*#+}} xmm3 = xmm3[1,0],xmm0[3,0]
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm3[0,2],xmm0[1,3]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm2[3,4,5],ymm0[6,7]
; AVX1-NEXT:    vshufps {{.*#+}} ymm1 = ymm4[3,0],ymm1[1,0],ymm4[7,4],ymm1[5,4]
; AVX1-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[0,1,2,0,4,5,6,4]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Reload
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm12[3,0],ymm9[1,0],ymm12[7,4],ymm9[5,4]
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[2,0],ymm9[2,3],ymm0[6,4],ymm9[6,7]
; AVX1-NEXT:    vshufps {{.*#+}} xmm1 = xmm10[1,0],xmm15[3,0]
; AVX1-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,2],xmm15[1,3]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX1-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[3,0],ymm5[1,0],ymm1[7,4],ymm5[5,4]
; AVX1-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[0,1,2,0,4,5,6,4]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vblendps {{.*#+}} ymm1 = ymm11[0,1],ymm8[2,3],ymm11[4,5,6,7]
; AVX1-NEXT:    vmovaps %ymm14, %ymm9
; AVX1-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm14[2,1],ymm10[2,0],ymm14[6,5],ymm10[6,4]
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vshufps {{.*#+}} xmm3 = xmm1[2,0],xmm2[2,3]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0,1,2],ymm0[3,4],ymm3[5,6,7]
; AVX1-NEXT:    vblendps {{.*#+}} ymm3 = ymm6[0,1,2,3],ymm13[4,5],ymm6[6,7]
; AVX1-NEXT:    vmovaps %ymm6, %ymm14
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm3[2,3,0,1]
; AVX1-NEXT:    vshufps {{.*#+}} ymm5 = ymm4[0,0],ymm3[2,0],ymm4[4,4],ymm3[6,4]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm5[5,6,7]
; AVX1-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-NEXT:    vblendps $12, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm5 # 32-byte Folded Reload
; AVX1-NEXT:    # ymm5 = ymm0[0,1],mem[2,3],ymm0[4,5,6,7]
; AVX1-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Reload
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm12[2,1],ymm15[2,0],ymm12[6,5],ymm15[6,4]
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX1-NEXT:    vextractf128 $1, %ymm5, %xmm6
; AVX1-NEXT:    vshufps {{.*#+}} xmm7 = xmm5[2,0],xmm6[2,3]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm7[0,1,2],ymm0[3,4],ymm7[5,6,7]
; AVX1-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX1-NEXT:    vblendps $207, (%rsp), %ymm13, %ymm7 # 32-byte Folded Reload
; AVX1-NEXT:    # ymm7 = mem[0,1,2,3],ymm13[4,5],mem[6,7]
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm7[2,3,0,1]
; AVX1-NEXT:    vshufps {{.*#+}} ymm11 = ymm8[0,0],ymm7[2,0],ymm8[4,4],ymm7[6,4]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm11[5,6,7]
; AVX1-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vshufps {{.*#+}} ymm3 = ymm4[0,1],ymm3[3,1],ymm4[4,5],ymm3[7,5]
; AVX1-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[3,1],xmm2[3,3]
; AVX1-NEXT:    vshufps {{.*#+}} ymm2 = ymm9[3,1],ymm10[2,1],ymm9[7,5],ymm10[6,5]
; AVX1-NEXT:    vmovaps %ymm10, %ymm11
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3,0,1]
; AVX1-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2],ymm2[3,4],ymm1[5,6,7]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4],ymm3[5,6,7]
; AVX1-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vshufps {{.*#+}} ymm2 = ymm8[0,1],ymm7[3,1],ymm8[4,5],ymm7[7,5]
; AVX1-NEXT:    vshufps {{.*#+}} xmm3 = xmm5[3,1],xmm6[3,3]
; AVX1-NEXT:    vshufps {{.*#+}} ymm4 = ymm12[3,1],ymm15[2,1],ymm12[7,5],ymm15[6,5]
; AVX1-NEXT:    vmovaps %ymm12, %ymm10
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3,0,1]
; AVX1-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2],ymm4[3,4],ymm3[5,6,7]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0,1,2,3,4],ymm2[5,6,7]
; AVX1-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vblendps $243, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm2 # 32-byte Folded Reload
; AVX1-NEXT:    # ymm2 = mem[0,1],ymm14[2,3],mem[4,5,6,7]
; AVX1-NEXT:    vmovaps 32(%rdi), %xmm14
; AVX1-NEXT:    vpermilps {{.*#+}} xmm4 = xmm14[2,2,3,3]
; AVX1-NEXT:    vmovaps 16(%rdi), %xmm5
; AVX1-NEXT:    vblendps {{.*#+}} xmm4 = xmm5[0],xmm4[1],xmm5[2,3]
; AVX1-NEXT:    vmovapd 80(%rdi), %xmm6
; AVX1-NEXT:    vshufpd {{.*#+}} ymm7 = ymm6[1],ymm11[0],ymm6[2],ymm11[2]
; AVX1-NEXT:    vshufps {{.*#+}} ymm7 = ymm9[0,1],ymm7[2,0],ymm9[4,5],ymm7[6,4]
; AVX1-NEXT:    vmovaps %ymm9, %ymm12
; AVX1-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm7[2,3,4,5,6,7]
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm7 = ymm2[2,3,0,1]
; AVX1-NEXT:    vshufps {{.*#+}} ymm8 = ymm2[2,0],ymm7[0,0],ymm2[6,4],ymm7[4,4]
; AVX1-NEXT:    vshufps {{.*#+}} ymm8 = ymm7[0,2],ymm8[2,0],ymm7[4,6],ymm8[6,4]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0,1,2,3,4],ymm8[5,6,7]
; AVX1-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vblendps $12, (%rsp), %ymm13, %ymm4 # 32-byte Folded Reload
; AVX1-NEXT:    # ymm4 = ymm13[0,1],mem[2,3],ymm13[4,5,6,7]
; AVX1-NEXT:    vmovaps 224(%rdi), %xmm0
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[2,2,3,3]
; AVX1-NEXT:    vmovaps 208(%rdi), %xmm3
; AVX1-NEXT:    vblendps {{.*#+}} xmm1 = xmm3[0],xmm1[1],xmm3[2,3]
; AVX1-NEXT:    vmovapd 272(%rdi), %xmm8
; AVX1-NEXT:    vshufpd {{.*#+}} ymm9 = ymm8[1],ymm15[0],ymm8[2],ymm15[2]
; AVX1-NEXT:    vmovaps %ymm10, %ymm13
; AVX1-NEXT:    vshufps {{.*#+}} ymm9 = ymm10[0,1],ymm9[2,0],ymm10[4,5],ymm9[6,4]
; AVX1-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm9[2,3,4,5,6,7]
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm4[2,3,0,1]
; AVX1-NEXT:    vshufps {{.*#+}} ymm10 = ymm4[2,0],ymm9[0,0],ymm4[6,4],ymm9[4,4]
; AVX1-NEXT:    vshufps {{.*#+}} ymm10 = ymm9[0,2],ymm10[2,0],ymm9[4,6],ymm10[6,4]
; AVX1-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4],ymm10[5,6,7]
; AVX1-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[3,0],ymm7[1,0],ymm2[7,4],ymm7[5,4]
; AVX1-NEXT:    vshufps {{.*#+}} ymm2 = ymm7[0,3],ymm2[2,0],ymm7[4,7],ymm2[6,4]
; AVX1-NEXT:    vblendps {{.*#+}} xmm5 = xmm5[0,1],xmm14[2,3]
; AVX1-NEXT:    vshufps {{.*#+}} ymm6 = ymm6[3,1],ymm11[1,3],ymm6[7,5],ymm11[5,7]
; AVX1-NEXT:    vshufps {{.*#+}} ymm6 = ymm12[1,1],ymm6[2,0],ymm12[5,5],ymm6[6,4]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm5 = xmm5[1,3,2,3]
; AVX1-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1],ymm6[2,3,4,5,6,7]
; AVX1-NEXT:    vblendps {{.*#+}} ymm2 = ymm5[0,1,2,3,4],ymm2[5,6,7]
; AVX1-NEXT:    vshufps {{.*#+}} ymm4 = ymm4[3,0],ymm9[1,0],ymm4[7,4],ymm9[5,4]
; AVX1-NEXT:    vshufps {{.*#+}} ymm4 = ymm9[0,3],ymm4[2,0],ymm9[4,7],ymm4[6,4]
; AVX1-NEXT:    vblendps {{.*#+}} xmm0 = xmm3[0,1],xmm0[2,3]
; AVX1-NEXT:    vshufps {{.*#+}} ymm3 = ymm8[3,1],ymm15[1,3],ymm8[7,5],ymm15[5,7]
; AVX1-NEXT:    vshufps {{.*#+}} ymm3 = ymm13[1,1],ymm3[2,0],ymm13[5,5],ymm3[6,4]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[1,3,2,3]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm3[2,3,4,5,6,7]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm4[5,6,7]
; AVX1-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX1-NEXT:    vmovaps %ymm3, (%rsi)
; AVX1-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX1-NEXT:    vmovaps %ymm3, 32(%rsi)
; AVX1-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX1-NEXT:    vmovaps %ymm3, 32(%rdx)
; AVX1-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX1-NEXT:    vmovaps %ymm3, (%rdx)
; AVX1-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX1-NEXT:    vmovaps %ymm3, 32(%rcx)
; AVX1-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX1-NEXT:    vmovaps %ymm3, (%rcx)
; AVX1-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX1-NEXT:    vmovaps %ymm3, 32(%r8)
; AVX1-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX1-NEXT:    vmovaps %ymm3, (%r8)
; AVX1-NEXT:    vmovaps %ymm1, 32(%r9)
; AVX1-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-NEXT:    vmovaps %ymm1, (%r9)
; AVX1-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX1-NEXT:    vmovaps %ymm2, (%rax)
; AVX1-NEXT:    addq $328, %rsp # imm = 0x148
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: load_i32_stride6_vf16:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    subq $232, %rsp
; AVX2-SLOW-NEXT:    vmovaps 96(%rdi), %ymm8
; AVX2-SLOW-NEXT:    vmovaps 64(%rdi), %ymm3
; AVX2-SLOW-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovaps 320(%rdi), %ymm2
; AVX2-SLOW-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovaps 352(%rdi), %ymm0
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovaps 288(%rdi), %ymm7
; AVX2-SLOW-NEXT:    vmovaps 256(%rdi), %ymm1
; AVX2-SLOW-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovaps 224(%rdi), %ymm9
; AVX2-SLOW-NEXT:    vmovaps 192(%rdi), %ymm10
; AVX2-SLOW-NEXT:    vmovaps {{.*#+}} xmm4 = <0,6,4,u>
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm5 = ymm10[0,1,2,3],ymm9[4,5],ymm10[6,7]
; AVX2-SLOW-NEXT:    vpermps %ymm5, %ymm4, %ymm6
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm1[0,1],ymm7[0,1]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm12 = ymm11[0,1,2,2,4,5,6,6]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm13 = ymm7[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0],ymm13[1],ymm12[2,3,4],ymm13[5],ymm12[6,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2],ymm12[3,4,5],ymm6[6,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm4 = ymm0[0,1,2,3],ymm2[4,5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vbroadcastsd {{.*#+}} ymm2 = [8589934596,8589934596,8589934596,8589934596]
; AVX2-SLOW-NEXT:    vpermps %ymm4, %ymm2, %ymm12
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1,2,3,4,5],ymm12[6,7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm3[0,1],ymm8[0,1]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm12 = ymm6[0,1,2,2,4,5,6,6]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm13 = ymm8[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0],ymm13[1],ymm12[2,3,4],ymm13[5],ymm12[6,7]
; AVX2-SLOW-NEXT:    vmovaps (%rdi), %ymm14
; AVX2-SLOW-NEXT:    vmovaps 32(%rdi), %ymm15
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm14[0,1,2,3],ymm15[4,5],ymm14[6,7]
; AVX2-SLOW-NEXT:    vmovaps {{.*#+}} xmm1 = <0,6,4,u>
; AVX2-SLOW-NEXT:    vpermps %ymm0, %ymm1, %ymm13
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm3 = ymm13[0,1,2],ymm12[3,4,5],ymm13[6,7]
; AVX2-SLOW-NEXT:    vmovaps 128(%rdi), %ymm12
; AVX2-SLOW-NEXT:    vmovaps 160(%rdi), %ymm13
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm1 = ymm13[0,1,2,3],ymm12[4,5],ymm13[6,7]
; AVX2-SLOW-NEXT:    vpermps %ymm1, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1,2,3,4,5],ymm2[6,7]
; AVX2-SLOW-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm2 = ymm6[1,1,2,3,5,5,6,7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm3 = ymm8[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm3[1],ymm2[2,3,4],ymm3[5],ymm2[6,7]
; AVX2-SLOW-NEXT:    vmovaps {{.*#+}} xmm3 = <1,7,5,u>
; AVX2-SLOW-NEXT:    vpermps %ymm0, %ymm3, %ymm0
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm2[3,4,5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vbroadcastsd {{.*#+}} ymm2 = [12884901893,12884901893,12884901893,12884901893]
; AVX2-SLOW-NEXT:    vpermps %ymm1, %ymm2, %ymm1
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermps %ymm5, %ymm3, %ymm0
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm1 = ymm11[1,1,2,3,5,5,6,7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm3 = ymm7[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm3[1],ymm1[2,3,4],ymm3[5],ymm1[6,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4,5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vpermps %ymm4, %ymm2, %ymm1
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm14[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm1 = ymm15[0,0,2,3,4,4,6,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5,6,7]
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm1 = ymm6[0,1],ymm8[2,3],ymm6[4,5],ymm8[6,7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[2,0,2,3,6,4,6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,0,3]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,3,2,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm1 = ymm13[0,0,0,0,4,4,4,4]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm2 = ymm12[0,0,2,3,4,4,6,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2],ymm1[3],ymm2[4,5,6],ymm1[7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,0,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6,7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm10[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm1 = ymm9[0,0,2,3,4,4,6,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5,6,7]
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm1 = ymm5[0,1],ymm7[2,3],ymm5[4,5],ymm7[6,7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[2,0,2,3,6,4,6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,0,3]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,3,2,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm1 = ymm3[0,0,0,0,4,4,4,4]
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm2 = ymm4[0,0,2,3,4,4,6,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2],ymm1[3],ymm2[4,5,6],ymm1[7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,0,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6,7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm14[3,3,3,3,7,7,7,7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm1 = ymm15[0,1,3,3,4,5,7,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5,6,7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm1 = ymm8[3,3,3,3,7,7,7,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm6[1],ymm1[2,3,4],ymm6[5],ymm1[6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,0,3]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,3,2,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm1 = ymm13[0,1,0,1,4,5,4,5]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm2 = ymm12[0,1,3,3,4,5,7,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2],ymm1[3],ymm2[4,5,6],ymm1[7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,0,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6,7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm10[3,3,3,3,7,7,7,7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm1 = ymm9[0,1,3,3,4,5,7,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5,6,7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm1 = ymm7[3,3,3,3,7,7,7,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm5[1],ymm1[2,3,4],ymm5[5],ymm1[6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,0,3]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,3,2,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm1 = ymm3[0,1,0,1,4,5,4,5]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm2 = ymm4[0,1,3,3,4,5,7,7]
; AVX2-SLOW-NEXT:    vmovaps %ymm4, %ymm11
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2],ymm1[3],ymm2[4,5,6],ymm1[7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,0,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm2 = ymm9[0,1,2,3],ymm10[4,5],ymm9[6,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0,1,2,3],ymm7[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovaps 272(%rdi), %xmm5
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm1 = ymm4[0,1],ymm5[2,3],ymm4[4,5],ymm5[6,7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[0,1,0,2,4,5,4,6]
; AVX2-SLOW-NEXT:    vmovaps {{.*#+}} xmm7 = <4,2,u,u>
; AVX2-SLOW-NEXT:    vpermps %ymm2, %ymm7, %ymm9
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm1 = ymm9[0,1],ymm1[2,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm9 = ymm3[0,1],ymm11[2,3],ymm3[4,5,6,7]
; AVX2-SLOW-NEXT:    vbroadcastf128 {{.*#+}} ymm10 = [0,2,0,6,0,2,0,6]
; AVX2-SLOW-NEXT:    # ymm10 = mem[0,1,0,1]
; AVX2-SLOW-NEXT:    vpermps %ymm9, %ymm10, %ymm11
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4],ymm11[5,6,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm8 = ymm6[0,1,2,3],ymm8[4,5,6,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm11 = ymm15[0,1,2,3],ymm14[4,5],ymm15[6,7]
; AVX2-SLOW-NEXT:    vmovaps 80(%rdi), %xmm14
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm15 = ymm8[0,1],ymm14[2,3],ymm8[4,5],ymm14[6,7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm15 = ymm15[0,1,0,2,4,5,4,6]
; AVX2-SLOW-NEXT:    vpermps %ymm11, %ymm7, %ymm7
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1],ymm15[2,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm12 = ymm13[0,1],ymm12[2,3],ymm13[4,5,6,7]
; AVX2-SLOW-NEXT:    vpermps %ymm12, %ymm10, %ymm10
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3,4],ymm10[5,6,7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm4 = ymm4[1,1,1,1,5,5,5,5]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2],ymm5[3],ymm4[4,5,6],ymm5[7]
; AVX2-SLOW-NEXT:    vmovaps {{.*#+}} xmm5 = <5,3,u,u>
; AVX2-SLOW-NEXT:    vpermps %ymm2, %ymm5, %ymm2
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm4[2,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vbroadcastf128 {{.*#+}} ymm4 = [0,3,1,7,0,3,1,7]
; AVX2-SLOW-NEXT:    # ymm4 = mem[0,1,0,1]
; AVX2-SLOW-NEXT:    vpermps %ymm9, %ymm4, %ymm9
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4],ymm9[5,6,7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm8 = ymm8[1,1,1,1,5,5,5,5]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2],ymm14[3],ymm8[4,5,6],ymm14[7]
; AVX2-SLOW-NEXT:    vpermps %ymm11, %ymm5, %ymm5
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1],ymm8[2,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpermps %ymm12, %ymm4, %ymm4
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0,1,2,3,4],ymm4[5,6,7]
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm3, (%rsi)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm5, 32(%rsi)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm3, 32(%rdx)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm3, (%rdx)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm3, 32(%rcx)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm3, (%rcx)
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 32(%r8)
; AVX2-SLOW-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, (%r8)
; AVX2-SLOW-NEXT:    vmovaps %ymm1, 32(%r9)
; AVX2-SLOW-NEXT:    vmovaps %ymm7, (%r9)
; AVX2-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-SLOW-NEXT:    vmovaps %ymm2, 32(%rax)
; AVX2-SLOW-NEXT:    vmovaps %ymm4, (%rax)
; AVX2-SLOW-NEXT:    addq $232, %rsp
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: load_i32_stride6_vf16:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    subq $232, %rsp
; AVX2-FAST-ALL-NEXT:    vmovaps 96(%rdi), %ymm8
; AVX2-FAST-ALL-NEXT:    vmovaps 64(%rdi), %ymm1
; AVX2-FAST-ALL-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-ALL-NEXT:    vmovaps 320(%rdi), %ymm3
; AVX2-FAST-ALL-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-ALL-NEXT:    vmovaps 352(%rdi), %ymm0
; AVX2-FAST-ALL-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-ALL-NEXT:    vmovaps 288(%rdi), %ymm7
; AVX2-FAST-ALL-NEXT:    vmovaps 256(%rdi), %ymm2
; AVX2-FAST-ALL-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-ALL-NEXT:    vmovaps 224(%rdi), %ymm9
; AVX2-FAST-ALL-NEXT:    vmovaps 192(%rdi), %ymm10
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} xmm4 = <0,6,4,u>
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm5 = ymm10[0,1,2,3],ymm9[4,5],ymm10[6,7]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm5, %ymm4, %ymm6
; AVX2-FAST-ALL-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm2[0,1],ymm7[0,1]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm12 = ymm11[0,1,2,2,4,5,6,6]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm13 = ymm7[2,2,2,2,6,6,6,6]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0],ymm13[1],ymm12[2,3,4],ymm13[5],ymm12[6,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2],ymm12[3,4,5],ymm6[6,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm4 = ymm0[0,1,2,3],ymm3[4,5],ymm0[6,7]
; AVX2-FAST-ALL-NEXT:    vbroadcastsd {{.*#+}} ymm2 = [8589934596,8589934596,8589934596,8589934596]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm4, %ymm2, %ymm12
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1,2,3,4,5],ymm12[6,7]
; AVX2-FAST-ALL-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-ALL-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm1[0,1],ymm8[0,1]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm12 = ymm6[0,1,2,2,4,5,6,6]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm13 = ymm8[2,2,2,2,6,6,6,6]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0],ymm13[1],ymm12[2,3,4],ymm13[5],ymm12[6,7]
; AVX2-FAST-ALL-NEXT:    vmovaps (%rdi), %ymm14
; AVX2-FAST-ALL-NEXT:    vmovaps 32(%rdi), %ymm15
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm14[0,1,2,3],ymm15[4,5],ymm14[6,7]
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} xmm1 = <0,6,4,u>
; AVX2-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm13
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm3 = ymm13[0,1,2],ymm12[3,4,5],ymm13[6,7]
; AVX2-FAST-ALL-NEXT:    vmovaps 128(%rdi), %ymm12
; AVX2-FAST-ALL-NEXT:    vmovaps 160(%rdi), %ymm13
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm1 = ymm13[0,1,2,3],ymm12[4,5],ymm13[6,7]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm1, %ymm2, %ymm2
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1,2,3,4,5],ymm2[6,7]
; AVX2-FAST-ALL-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm2 = ymm6[1,1,2,3,5,5,6,7]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm3 = ymm8[2,3,2,3,6,7,6,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm3[1],ymm2[2,3,4],ymm3[5],ymm2[6,7]
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} xmm3 = <1,7,5,u>
; AVX2-FAST-ALL-NEXT:    vpermps %ymm0, %ymm3, %ymm0
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm2[3,4,5],ymm0[6,7]
; AVX2-FAST-ALL-NEXT:    vbroadcastsd {{.*#+}} ymm2 = [12884901893,12884901893,12884901893,12884901893]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm1, %ymm2, %ymm1
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FAST-ALL-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-ALL-NEXT:    vpermps %ymm5, %ymm3, %ymm0
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm1 = ymm11[1,1,2,3,5,5,6,7]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm3 = ymm7[2,3,2,3,6,7,6,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm3[1],ymm1[2,3,4],ymm3[5],ymm1[6,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4,5],ymm0[6,7]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm4, %ymm2, %ymm1
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FAST-ALL-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm14[2,3,2,3,6,7,6,7]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm1 = ymm15[0,0,2,3,4,4,6,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5,6,7]
; AVX2-FAST-ALL-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm1 = ymm6[0,1],ymm8[2,3],ymm6[4,5],ymm8[6,7]
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} ymm2 = [2,0,6,4,2,0,6,7]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm1, %ymm2, %ymm1
; AVX2-FAST-ALL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,3,2,3]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm1 = ymm13[0,0,0,0,4,4,4,4]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm3 = ymm12[0,0,2,3,4,4,6,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1,2],ymm1[3],ymm3[4,5,6],ymm1[7]
; AVX2-FAST-ALL-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,0,3]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6,7]
; AVX2-FAST-ALL-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-ALL-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1],ymm7[2,3],ymm5[4,5],ymm7[6,7]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm0, %ymm2, %ymm0
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm1 = ymm10[2,3,2,3,6,7,6,7]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm2 = ymm9[0,0,2,3,4,4,6,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2,3],ymm1[4],ymm2[5,6,7]
; AVX2-FAST-ALL-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,3,2,3]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4],ymm1[5,6,7]
; AVX2-FAST-ALL-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm1 = ymm3[0,0,0,0,4,4,4,4]
; AVX2-FAST-ALL-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm2 = ymm4[0,0,2,3,4,4,6,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2],ymm1[3],ymm2[4,5,6],ymm1[7]
; AVX2-FAST-ALL-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,0,3]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6,7]
; AVX2-FAST-ALL-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm14[3,3,3,3,7,7,7,7]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm1 = ymm15[0,1,3,3,4,5,7,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5,6,7]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm1 = ymm8[3,3,3,3,7,7,7,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm6[1],ymm1[2,3,4],ymm6[5],ymm1[6,7]
; AVX2-FAST-ALL-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,0,3]
; AVX2-FAST-ALL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,3,2,3]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm1 = ymm13[0,1,0,1,4,5,4,5]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm2 = ymm12[0,1,3,3,4,5,7,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2],ymm1[3],ymm2[4,5,6],ymm1[7]
; AVX2-FAST-ALL-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,0,3]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6,7]
; AVX2-FAST-ALL-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm0 = ymm10[3,3,3,3,7,7,7,7]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm1 = ymm9[0,1,3,3,4,5,7,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5,6,7]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm1 = ymm7[3,3,3,3,7,7,7,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm5[1],ymm1[2,3,4],ymm5[5],ymm1[6,7]
; AVX2-FAST-ALL-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,0,3]
; AVX2-FAST-ALL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,3,2,3]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm1 = ymm3[0,1,0,1,4,5,4,5]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm2 = ymm4[0,1,3,3,4,5,7,7]
; AVX2-FAST-ALL-NEXT:    vmovaps %ymm4, %ymm11
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2],ymm1[3],ymm2[4,5,6],ymm1[7]
; AVX2-FAST-ALL-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,0,3]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm2 = ymm9[0,1,2,3],ymm10[4,5],ymm9[6,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0,1,2,3],ymm7[4,5,6,7]
; AVX2-FAST-ALL-NEXT:    vmovaps 272(%rdi), %xmm5
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm1 = ymm4[0,1],ymm5[2,3],ymm4[4,5],ymm5[6,7]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[0,1,0,2,4,5,4,6]
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} xmm7 = <4,2,u,u>
; AVX2-FAST-ALL-NEXT:    vpermps %ymm2, %ymm7, %ymm9
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm1 = ymm9[0,1],ymm1[2,3,4,5,6,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm9 = ymm3[0,1],ymm11[2,3],ymm3[4,5,6,7]
; AVX2-FAST-ALL-NEXT:    vbroadcastf128 {{.*#+}} ymm10 = [0,2,0,6,0,2,0,6]
; AVX2-FAST-ALL-NEXT:    # ymm10 = mem[0,1,0,1]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm9, %ymm10, %ymm11
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4],ymm11[5,6,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm8 = ymm6[0,1,2,3],ymm8[4,5,6,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm11 = ymm15[0,1,2,3],ymm14[4,5],ymm15[6,7]
; AVX2-FAST-ALL-NEXT:    vmovaps 80(%rdi), %xmm14
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm15 = ymm8[0,1],ymm14[2,3],ymm8[4,5],ymm14[6,7]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm15 = ymm15[0,1,0,2,4,5,4,6]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm11, %ymm7, %ymm7
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1],ymm15[2,3,4,5,6,7]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm12 = ymm13[0,1],ymm12[2,3],ymm13[4,5,6,7]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm12, %ymm10, %ymm10
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3,4],ymm10[5,6,7]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm4 = ymm4[1,1,1,1,5,5,5,5]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2],ymm5[3],ymm4[4,5,6],ymm5[7]
; AVX2-FAST-ALL-NEXT:    vmovaps {{.*#+}} xmm5 = <5,3,u,u>
; AVX2-FAST-ALL-NEXT:    vpermps %ymm2, %ymm5, %ymm2
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm4[2,3,4,5,6,7]
; AVX2-FAST-ALL-NEXT:    vbroadcastf128 {{.*#+}} ymm4 = [0,3,1,7,0,3,1,7]
; AVX2-FAST-ALL-NEXT:    # ymm4 = mem[0,1,0,1]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm9, %ymm4, %ymm9
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4],ymm9[5,6,7]
; AVX2-FAST-ALL-NEXT:    vpermilps {{.*#+}} ymm8 = ymm8[1,1,1,1,5,5,5,5]
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2],ymm14[3],ymm8[4,5,6],ymm14[7]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm11, %ymm5, %ymm5
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1],ymm8[2,3,4,5,6,7]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm12, %ymm4, %ymm4
; AVX2-FAST-ALL-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0,1,2,3,4],ymm4[5,6,7]
; AVX2-FAST-ALL-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FAST-ALL-NEXT:    vmovaps %ymm5, (%rsi)
; AVX2-FAST-ALL-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FAST-ALL-NEXT:    vmovaps %ymm5, 32(%rsi)
; AVX2-FAST-ALL-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FAST-ALL-NEXT:    vmovaps %ymm5, 32(%rdx)
; AVX2-FAST-ALL-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FAST-ALL-NEXT:    vmovaps %ymm5, (%rdx)
; AVX2-FAST-ALL-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FAST-ALL-NEXT:    vmovaps %ymm3, 32(%rcx)
; AVX2-FAST-ALL-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FAST-ALL-NEXT:    vmovaps %ymm3, (%rcx)
; AVX2-FAST-ALL-NEXT:    vmovaps %ymm0, 32(%r8)
; AVX2-FAST-ALL-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-FAST-ALL-NEXT:    vmovaps %ymm0, (%r8)
; AVX2-FAST-ALL-NEXT:    vmovaps %ymm1, 32(%r9)
; AVX2-FAST-ALL-NEXT:    vmovaps %ymm7, (%r9)
; AVX2-FAST-ALL-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-ALL-NEXT:    vmovaps %ymm2, 32(%rax)
; AVX2-FAST-ALL-NEXT:    vmovaps %ymm4, (%rax)
; AVX2-FAST-ALL-NEXT:    addq $232, %rsp
; AVX2-FAST-ALL-NEXT:    vzeroupper
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: load_i32_stride6_vf16:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    subq $232, %rsp
; AVX2-FAST-PERLANE-NEXT:    vmovaps 96(%rdi), %ymm8
; AVX2-FAST-PERLANE-NEXT:    vmovaps 64(%rdi), %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovaps 320(%rdi), %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovaps 352(%rdi), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovaps 288(%rdi), %ymm7
; AVX2-FAST-PERLANE-NEXT:    vmovaps 256(%rdi), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovaps 224(%rdi), %ymm9
; AVX2-FAST-PERLANE-NEXT:    vmovaps 192(%rdi), %ymm10
; AVX2-FAST-PERLANE-NEXT:    vmovaps {{.*#+}} xmm4 = <0,6,4,u>
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm5 = ymm10[0,1,2,3],ymm9[4,5],ymm10[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermps %ymm5, %ymm4, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm1[0,1],ymm7[0,1]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm12 = ymm11[0,1,2,2,4,5,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm13 = ymm7[2,2,2,2,6,6,6,6]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0],ymm13[1],ymm12[2,3,4],ymm13[5],ymm12[6,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2],ymm12[3,4,5],ymm6[6,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm4 = ymm0[0,1,2,3],ymm2[4,5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd {{.*#+}} ymm2 = [8589934596,8589934596,8589934596,8589934596]
; AVX2-FAST-PERLANE-NEXT:    vpermps %ymm4, %ymm2, %ymm12
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1,2,3,4,5],ymm12[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm3[0,1],ymm8[0,1]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm12 = ymm6[0,1,2,2,4,5,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm13 = ymm8[2,2,2,2,6,6,6,6]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0],ymm13[1],ymm12[2,3,4],ymm13[5],ymm12[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps (%rdi), %ymm14
; AVX2-FAST-PERLANE-NEXT:    vmovaps 32(%rdi), %ymm15
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm14[0,1,2,3],ymm15[4,5],ymm14[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps {{.*#+}} xmm1 = <0,6,4,u>
; AVX2-FAST-PERLANE-NEXT:    vpermps %ymm0, %ymm1, %ymm13
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm3 = ymm13[0,1,2],ymm12[3,4,5],ymm13[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps 128(%rdi), %ymm12
; AVX2-FAST-PERLANE-NEXT:    vmovaps 160(%rdi), %ymm13
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm1 = ymm13[0,1,2,3],ymm12[4,5],ymm13[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermps %ymm1, %ymm2, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1,2,3,4,5],ymm2[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm2 = ymm6[1,1,2,3,5,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm3 = ymm8[2,3,2,3,6,7,6,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm3[1],ymm2[2,3,4],ymm3[5],ymm2[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps {{.*#+}} xmm3 = <1,7,5,u>
; AVX2-FAST-PERLANE-NEXT:    vpermps %ymm0, %ymm3, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm2[3,4,5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd {{.*#+}} ymm2 = [12884901893,12884901893,12884901893,12884901893]
; AVX2-FAST-PERLANE-NEXT:    vpermps %ymm1, %ymm2, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermps %ymm5, %ymm3, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm1 = ymm11[1,1,2,3,5,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm3 = ymm7[2,3,2,3,6,7,6,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm3[1],ymm1[2,3,4],ymm3[5],ymm1[6,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4,5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermps %ymm4, %ymm2, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm0 = ymm14[2,3,2,3,6,7,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm1 = ymm15[0,0,2,3,4,4,6,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm1 = ymm6[0,1],ymm8[2,3],ymm6[4,5],ymm8[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[2,0,2,3,6,4,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,0,3]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm1 = ymm13[0,0,0,0,4,4,4,4]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm2 = ymm12[0,0,2,3,4,4,6,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2],ymm1[3],ymm2[4,5,6],ymm1[7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,0,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm0 = ymm10[2,3,2,3,6,7,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm1 = ymm9[0,0,2,3,4,4,6,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm1 = ymm5[0,1],ymm7[2,3],ymm5[4,5],ymm7[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[2,0,2,3,6,4,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,0,3]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm1 = ymm3[0,0,0,0,4,4,4,4]
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm2 = ymm4[0,0,2,3,4,4,6,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2],ymm1[3],ymm2[4,5,6],ymm1[7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,0,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm0 = ymm14[3,3,3,3,7,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm1 = ymm15[0,1,3,3,4,5,7,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm1 = ymm8[3,3,3,3,7,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm6[1],ymm1[2,3,4],ymm6[5],ymm1[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,0,3]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm1 = ymm13[0,1,0,1,4,5,4,5]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm2 = ymm12[0,1,3,3,4,5,7,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2],ymm1[3],ymm2[4,5,6],ymm1[7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,0,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm0 = ymm10[3,3,3,3,7,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm1 = ymm9[0,1,3,3,4,5,7,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm1 = ymm7[3,3,3,3,7,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm5[1],ymm1[2,3,4],ymm5[5],ymm1[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,0,3]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm1 = ymm3[0,1,0,1,4,5,4,5]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm2 = ymm4[0,1,3,3,4,5,7,7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm4, %ymm11
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2],ymm1[3],ymm2[4,5,6],ymm1[7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,0,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm2 = ymm9[0,1,2,3],ymm10[4,5],ymm9[6,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0,1,2,3],ymm7[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps 272(%rdi), %xmm5
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm1 = ymm4[0,1],ymm5[2,3],ymm4[4,5],ymm5[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[0,1,0,2,4,5,4,6]
; AVX2-FAST-PERLANE-NEXT:    vmovaps {{.*#+}} xmm7 = <4,2,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpermps %ymm2, %ymm7, %ymm9
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm1 = ymm9[0,1],ymm1[2,3,4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm9 = ymm3[0,1],ymm11[2,3],ymm3[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastf128 {{.*#+}} ymm10 = [0,2,0,6,0,2,0,6]
; AVX2-FAST-PERLANE-NEXT:    # ymm10 = mem[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpermps %ymm9, %ymm10, %ymm11
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4],ymm11[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm8 = ymm6[0,1,2,3],ymm8[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm11 = ymm15[0,1,2,3],ymm14[4,5],ymm15[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps 80(%rdi), %xmm14
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm15 = ymm8[0,1],ymm14[2,3],ymm8[4,5],ymm14[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm15 = ymm15[0,1,0,2,4,5,4,6]
; AVX2-FAST-PERLANE-NEXT:    vpermps %ymm11, %ymm7, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1],ymm15[2,3,4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm12 = ymm13[0,1],ymm12[2,3],ymm13[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermps %ymm12, %ymm10, %ymm10
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3,4],ymm10[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm4 = ymm4[1,1,1,1,5,5,5,5]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2],ymm5[3],ymm4[4,5,6],ymm5[7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps {{.*#+}} xmm5 = <5,3,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpermps %ymm2, %ymm5, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm4[2,3,4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastf128 {{.*#+}} ymm4 = [0,3,1,7,0,3,1,7]
; AVX2-FAST-PERLANE-NEXT:    # ymm4 = mem[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpermps %ymm9, %ymm4, %ymm9
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4],ymm9[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm8 = ymm8[1,1,1,1,5,5,5,5]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2],ymm14[3],ymm8[4,5,6],ymm14[7]
; AVX2-FAST-PERLANE-NEXT:    vpermps %ymm11, %ymm5, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1],ymm8[2,3,4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermps %ymm12, %ymm4, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0,1,2,3,4],ymm4[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm3, (%rsi)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm5, 32(%rsi)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm3, 32(%rdx)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm3, (%rdx)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm3, 32(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm3, (%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 32(%r8)
; AVX2-FAST-PERLANE-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, (%r8)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm1, 32(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm7, (%r9)
; AVX2-FAST-PERLANE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm2, 32(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm4, (%rax)
; AVX2-FAST-PERLANE-NEXT:    addq $232, %rsp
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512-LABEL: load_i32_stride6_vf16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovdqu64 320(%rdi), %zmm0
; AVX512-NEXT:    vmovdqu64 256(%rdi), %zmm1
; AVX512-NEXT:    vmovdqu64 (%rdi), %zmm3
; AVX512-NEXT:    vmovdqu64 64(%rdi), %zmm4
; AVX512-NEXT:    vmovdqu64 128(%rdi), %zmm5
; AVX512-NEXT:    vmovdqu64 192(%rdi), %zmm6
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [0,6,12,0,0,0,20,26,0,6,12,0,0,0,20,26]
; AVX512-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2d %zmm5, %zmm6, %zmm7
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm2 = <0,6,12,18,24,30,u,u>
; AVX512-NEXT:    vpermi2d %zmm4, %zmm3, %zmm2
; AVX512-NEXT:    movb $56, %dil
; AVX512-NEXT:    kmovd %edi, %k2
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm2 {%k2}
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [0,0,0,2,8,14,20,26,0,0,0,2,8,14,20,26]
; AVX512-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2d %zmm0, %zmm1, %zmm7
; AVX512-NEXT:    movw $-2048, %di # imm = 0xF800
; AVX512-NEXT:    kmovd %edi, %k1
; AVX512-NEXT:    vmovdqa32 %zmm7, %zmm2 {%k1}
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [1,7,13,0,0,0,21,27,1,7,13,0,0,0,21,27]
; AVX512-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2d %zmm5, %zmm6, %zmm8
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm7 = <1,7,13,19,25,31,u,u>
; AVX512-NEXT:    vpermi2d %zmm4, %zmm3, %zmm7
; AVX512-NEXT:    vmovdqa64 %zmm8, %zmm7 {%k2}
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [0,0,0,3,9,15,21,27,0,0,0,3,9,15,21,27]
; AVX512-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2d %zmm0, %zmm1, %zmm8
; AVX512-NEXT:    vmovdqa32 %zmm8, %zmm7 {%k1}
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm8 = <2,8,14,20,26,u,u,u>
; AVX512-NEXT:    vpermi2d %zmm4, %zmm3, %zmm8
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [18,24,30,0,0,0,6,12,18,24,30,0,0,0,6,12]
; AVX512-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2d %zmm6, %zmm5, %zmm9
; AVX512-NEXT:    movw $31, %di
; AVX512-NEXT:    kmovd %edi, %k2
; AVX512-NEXT:    vmovdqa32 %zmm8, %zmm9 {%k2}
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [0,0,0,20,26,0,6,12,0,0,0,20,26,0,6,12]
; AVX512-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2d %zmm1, %zmm0, %zmm8
; AVX512-NEXT:    vmovdqa32 %zmm8, %zmm9 {%k1}
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm8 = <3,9,15,21,27,u,u,u>
; AVX512-NEXT:    vpermi2d %zmm4, %zmm3, %zmm8
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm10 = [19,25,31,0,0,1,7,13,19,25,31,0,0,1,7,13]
; AVX512-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2d %zmm6, %zmm5, %zmm10
; AVX512-NEXT:    vmovdqa32 %zmm8, %zmm10 {%k2}
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [0,0,0,21,27,1,7,13,0,0,0,21,27,1,7,13]
; AVX512-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2d %zmm1, %zmm0, %zmm8
; AVX512-NEXT:    vmovdqa32 %zmm8, %zmm10 {%k1}
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [20,26,0,0,0,2,8,14,20,26,0,0,0,2,8,14]
; AVX512-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2d %zmm6, %zmm5, %zmm8
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm11 = <20,26,0,6,12,u,u,u>
; AVX512-NEXT:    vpermi2d %zmm3, %zmm4, %zmm11
; AVX512-NEXT:    movw $992, %di # imm = 0x3E0
; AVX512-NEXT:    kmovd %edi, %k1
; AVX512-NEXT:    vmovdqa32 %zmm8, %zmm11 {%k1}
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [0,0,0,6,12,18,24,30,0,0,0,6,12,18,24,30]
; AVX512-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2d %zmm0, %zmm1, %zmm8
; AVX512-NEXT:    movb $-32, %dil
; AVX512-NEXT:    kmovd %edi, %k2
; AVX512-NEXT:    vmovdqa64 %zmm8, %zmm11 {%k2}
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [21,27,0,0,0,3,9,15,21,27,0,0,0,3,9,15]
; AVX512-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2d %zmm6, %zmm5, %zmm8
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm5 = <21,27,1,7,13,u,u,u>
; AVX512-NEXT:    vpermi2d %zmm3, %zmm4, %zmm5
; AVX512-NEXT:    vmovdqa32 %zmm8, %zmm5 {%k1}
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,0,1,7,13,19,25,31,0,0,1,7,13,19,25,31]
; AVX512-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2d %zmm0, %zmm1, %zmm3
; AVX512-NEXT:    vmovdqa64 %zmm3, %zmm5 {%k2}
; AVX512-NEXT:    vmovdqu64 %zmm2, (%rsi)
; AVX512-NEXT:    vmovdqu64 %zmm7, (%rdx)
; AVX512-NEXT:    vmovdqu64 %zmm9, (%rcx)
; AVX512-NEXT:    vmovdqu64 %zmm10, (%r8)
; AVX512-NEXT:    vmovdqu64 %zmm11, (%r9)
; AVX512-NEXT:    vmovdqu64 %zmm5, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %wide.vec = load <96 x i32>, <96 x i32>* %in.vec, align 32

  %strided.vec0 = shufflevector <96 x i32> %wide.vec, <96 x i32> poison, <16 x i32> <i32 0, i32 6, i32 12, i32 18, i32 24, i32 30, i32 36, i32 42, i32 48, i32 54, i32 60, i32 66, i32 72, i32 78, i32 84, i32 90>
  %strided.vec1 = shufflevector <96 x i32> %wide.vec, <96 x i32> poison, <16 x i32> <i32 1, i32 7, i32 13, i32 19, i32 25, i32 31, i32 37, i32 43, i32 49, i32 55, i32 61, i32 67, i32 73, i32 79, i32 85, i32 91>
  %strided.vec2 = shufflevector <96 x i32> %wide.vec, <96 x i32> poison, <16 x i32> <i32 2, i32 8, i32 14, i32 20, i32 26, i32 32, i32 38, i32 44, i32 50, i32 56, i32 62, i32 68, i32 74, i32 80, i32 86, i32 92>
  %strided.vec3 = shufflevector <96 x i32> %wide.vec, <96 x i32> poison, <16 x i32> <i32 3, i32 9, i32 15, i32 21, i32 27, i32 33, i32 39, i32 45, i32 51, i32 57, i32 63, i32 69, i32 75, i32 81, i32 87, i32 93>
  %strided.vec4 = shufflevector <96 x i32> %wide.vec, <96 x i32> poison, <16 x i32> <i32 4, i32 10, i32 16, i32 22, i32 28, i32 34, i32 40, i32 46, i32 52, i32 58, i32 64, i32 70, i32 76, i32 82, i32 88, i32 94>
  %strided.vec5 = shufflevector <96 x i32> %wide.vec, <96 x i32> poison, <16 x i32> <i32 5, i32 11, i32 17, i32 23, i32 29, i32 35, i32 41, i32 47, i32 53, i32 59, i32 65, i32 71, i32 77, i32 83, i32 89, i32 95>

  store <16 x i32> %strided.vec0, <16 x i32>* %out.vec0, align 32
  store <16 x i32> %strided.vec1, <16 x i32>* %out.vec1, align 32
  store <16 x i32> %strided.vec2, <16 x i32>* %out.vec2, align 32
  store <16 x i32> %strided.vec3, <16 x i32>* %out.vec3, align 32
  store <16 x i32> %strided.vec4, <16 x i32>* %out.vec4, align 32
  store <16 x i32> %strided.vec5, <16 x i32>* %out.vec5, align 32

  ret void
}
