/* 
 *  Linux Letters and Numbers
 *  By Kirk Ismay, <captain@netidea.com> 
 * 
 *  Based on my daughters favorite game, Larry's Letters and Numbers.
 *  This is a Linux replacement, as the original was written for Windows. 
 *  I have made several improvements too.*/

#include "lletters.h"

char * lln_sound_dir;
/* Change by Lalo Martins, Feb 27 1999: */
char * lln_image_dir;
/* end change by Lalo Martins, Feb 27 1999 */

int lln_ignore = FALSE; /* Paul Keinzle */

void
delete_event (GtkWidget * widget, GdkEvent * event, gpointer * data)
{
  gdk_key_repeat_restore ();
  gtk_main_quit ();
}

int
retransmit_press (GtkWidget * widget, GdkEventButton * event, gpointer * data)
{
  if ((event->button == 2) || (event->button == 3)) {
     /* retransmit as if button 1 did it */
    gtk_button_pressed(GTK_BUTTON(widget));
    return TRUE; /* We're done, don't do any more */
  } else {
    return FALSE; /* Don't retransmit button 1 messages */
  }
}

int
retransmit_release (GtkWidget * widget, GdkEventButton * event, gpointer * data)
{
  if ( (event->button == 2) || (event->button == 3)) {
     /* retransmit as if button 1 did it */
    gtk_button_released(GTK_BUTTON(widget));
    return TRUE; /* We're done, don't do any more */
  } else {
    return FALSE; /* Don't retransmit button 1  messages */
  }
}

int
get_keystroke (GtkWidget * widget, GdkEventKey * event, gpointer * data)
{
  gint key = event->keyval;
  gint esc_key = 65307;
  gint enter_key = 65293;

  if (lln_ignore) return TRUE;

  if ((int) data == 1)
    {//Close popup window first if any key is pressed
      lln_ignore = FALSE;
      gtk_widget_destroy (widget);
    }

  if (key == esc_key) { 
    gdk_key_repeat_restore ();
    gtk_main_quit();
  }
  if (isascii(key)) {
    if (isalpha(key)) {
      lln_show_letter (widget, (gpointer) toupper(key));
    }
    else if (isdigit(key) && key != '0') { 
      lln_show_number (widget, (gpointer) (key-48));
    }
  }

  return TRUE;
}

int
main (int argc, char *argv[])
{
  gint x, z, i;
  gchar buf[40];
  /* Change by Lalo Martins, Feb 27 1999: */
  gchar *lang, *rc_file;
  struct stat statbuf;
  /* end change by Lalo Martins, Feb 27 1999 */
  GtkWidget *window;
  GtkWidget *button;
  GtkWidget *label;
  GtkWidget *box1, *box2, *box3, *box4;
  GtkWidget *vbox;

/* Begin change JPV - 1999/03/06 */
  textdomain("linux-letters-and-numbers");
/* End change JPV - 1999/03/06 */

  gtk_init (&argc, &argv);
  gdk_imlib_init(); 
  gdk_key_repeat_disable ();

  /* Change by Lalo Martins, Feb 27 1999: */
  lang = getenv ("LANG");
  if (lang)
  {
/* Begin change JPV - 1999/03/06 */
    printf (_("Found LANG=`%s'\n"), lang);
/* End change JPV - 1999/03/06 */
    asprintf (&lln_image_dir, "%s/lletters/%s/images/", DATADIR, lang);
    /* Set soundfile directory. Kirk Ismay */
    asprintf (&lln_sound_dir, "%s/lletters/%s/sounds/", DATADIR, lang);
    if (stat (lln_image_dir, &statbuf)) {
      /* if $LANG-specific dir doesn't exist... */
      asprintf (&lln_image_dir, "%s/lletters/images/", DATADIR);
      /* Set soundfile directory. Kirk Ismay */
      asprintf (&lln_sound_dir, "%s/lletters/sounds/", DATADIR);
    }
  }
  else {
    asprintf (&lln_image_dir, "%s/lletters/images/", DATADIR);
    /* Set soundfile directory. Kirk Ismay */
    asprintf (&lln_sound_dir, "%s/lletters/sounds/", DATADIR);
  }
  /* Begin change JPV - 1999/03/06 */
  printf (_("Using `%s' for image dir\n"), lln_image_dir);
  /* End change JPV - 1999/03/06 */
  /* end change by Lalo Martins, Feb 27 1999 */
#ifdef SOUND
  printf (_("Using `%s' for sound dir\n"), lln_sound_dir);
#else
  printf (_("Sound disabled"));
#endif

  /* Load and parse the Global RC file */
  asprintf (&rc_file, "%s/lletters/lln.rc", DATADIR);
  gtk_rc_parse (rc_file);

  /* Load and parse the user's RC file */
  asprintf (&rc_file, "%s/.llnrc", g_get_home_dir());

  if (lln_check_file (rc_file) == TRUE) {
    gtk_rc_parse (rc_file);
  }

  /* create a new window */
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (window, "main_window");
  gtk_window_set_default_size (GTK_WINDOW (window), MAIN_X, MAIN_Y);

/* Begin change JPV - 1999/03/06 */
  gtk_window_set_title (GTK_WINDOW (window), _("Linux Letters and Numbers"));
/* End change JPV - 1999/03/06 */
  gtk_window_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);

  gtk_signal_connect (GTK_OBJECT (window), "key_press_event",
		      GTK_SIGNAL_FUNC (get_keystroke), (gpointer) 0);
  gtk_signal_connect (GTK_OBJECT (window), "key_release_event",
		      GTK_SIGNAL_FUNC (get_keystroke), (gpointer) 0);
  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		      GTK_SIGNAL_FUNC (delete_event), NULL);

  /* sets the border width of the window. */
  gtk_container_border_width (GTK_CONTAINER (window), 25);

  /* we create boxes to pack widgets into */
  vbox = gtk_vbox_new (FALSE, 0);
  box1 = gtk_hbox_new (TRUE, 0);
  box2 = gtk_hbox_new (TRUE, 0);
  box3 = gtk_hbox_new (TRUE, 0);
  box4 = gtk_hbox_new (TRUE, 0);

  /* put the box into the main window. */
  gtk_container_add (GTK_CONTAINER (window), vbox);
  /* put the horizontal boxes into the vertical one */
  gtk_box_pack_start (GTK_BOX (vbox), box1, TRUE, TRUE, 5);
  gtk_box_pack_start (GTK_BOX (vbox), box2, TRUE, TRUE, 5);
  gtk_box_pack_start (GTK_BOX (vbox), box3, TRUE, TRUE, 5);
  gtk_box_pack_start (GTK_BOX (vbox), box4, TRUE, TRUE, 5);
  /* Make a row of numbers */
  i = 1;
  while (i <= 9)
    {
      button = gtk_button_new ();
 
      sprintf (buf, "%d", i);
      label = gtk_label_new (buf);
      gtk_widget_set_name (label, "main_label");

      gtk_container_add (GTK_CONTAINER (button), label);
 
      gtk_box_pack_start (GTK_BOX (box1), button, TRUE, TRUE, 5);

      /* Now when the button is clicked, we call the "show_number" function
       *        * with a pointer to the letter as it's argument */
      gtk_signal_connect (GTK_OBJECT (button), "button_press_event",
			  GTK_SIGNAL_FUNC (retransmit_press), button);
      gtk_signal_connect (GTK_OBJECT (button), "button_release_event",
			  GTK_SIGNAL_FUNC (retransmit_release), button);
      gtk_signal_connect (GTK_OBJECT (button), "clicked",
			  GTK_SIGNAL_FUNC (lln_show_number), (gpointer) i);
      i++;
    }

  /* Make 3 rows of letters */
  x = 'A';
  z = 'Z';
  while (x <= z)
    {
      sprintf (buf, "%c", x);


      /* creates a new button with a label. */
      button = gtk_button_new ();

      label = gtk_label_new (buf);
      gtk_widget_set_name  (label, "main_label");


      gtk_container_add (GTK_CONTAINER (button), label);
      gtk_signal_connect (GTK_OBJECT (button), "button_press_event",
			  GTK_SIGNAL_FUNC (retransmit_press), button);
      gtk_signal_connect (GTK_OBJECT (button), "button_release_event",
			  GTK_SIGNAL_FUNC (retransmit_release), button);
      gtk_signal_connect (GTK_OBJECT (button), "clicked",
			  GTK_SIGNAL_FUNC (lln_show_letter), (gpointer) x);

      if (x <= 'I')
	gtk_box_pack_start (GTK_BOX (box2), button, TRUE, TRUE, 5);
      else if (x <= 'Q')
	gtk_box_pack_start (GTK_BOX (box3), button, TRUE, TRUE, 5);
      else
	gtk_box_pack_start (GTK_BOX (box4), button, TRUE, TRUE, 5);

      x++;
    }

  gtk_widget_show_all (window);

  gtk_main ();

  return 0;
}









