/* Copyright 2017 R. Thomas
 * Copyright 2017 Quarkslab
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef LIEF_PE_COMCTL32_DLL_LOOKUP_H_
#define LIEF_PE_COMCTL32_DLL_LOOKUP_H_

#include <map>

namespace LIEF {
namespace PE {

static const std::map<uint32_t, const char*> comctl32_dll_lookup {
    { 0x0191, "AddMRUStringW"            },
    { 0x00cf, "AttachScrollBars"         },
    { 0x00d2, "CCEnableScrollBar"        },
    { 0x00d1, "CCGetScrollInfo"          },
    { 0x00d0, "CCSetScrollInfo"          },
    { 0x0190, "CreateMRUListW"           },
    { 0x0008, "CreateMappedBitmap"       },
    { 0x000c, "CreatePropertySheetPage"  },
    { 0x0013, "CreatePropertySheetPageA" },
    { 0x0014, "CreatePropertySheetPageW" },
    { 0x0015, "CreateStatusWindow"       },
    { 0x0006, "CreateStatusWindowA"      },
    { 0x0016, "CreateStatusWindowW"      },
    { 0x0007, "CreateToolbar"            },
    { 0x0017, "CreateToolbarEx"          },
    { 0x0010, "CreateUpDownControl"      },
    { 0x014b, "DPA_Clone"                },
    { 0x0148, "DPA_Create"               },
    { 0x0154, "DPA_CreateEx"             },
    { 0x0151, "DPA_DeleteAllPtrs"        },
    { 0x0150, "DPA_DeletePtr"            },
    { 0x0149, "DPA_Destroy"              },
    { 0x0182, "DPA_DestroyCallback"      },
    { 0x0181, "DPA_EnumCallback"         },
    { 0x014c, "DPA_GetPtr"               },
    { 0x014d, "DPA_GetPtrIndex"          },
    { 0x015b, "DPA_GetSize"              },
    { 0x014a, "DPA_Grow"                 },
    { 0x014e, "DPA_InsertPtr"            },
    { 0x0009, "DPA_LoadStream"           },
    { 0x000b, "DPA_Merge"                },
    { 0x000a, "DPA_SaveStream"           },
    { 0x0153, "DPA_Search"               },
    { 0x014f, "DPA_SetPtr"               },
    { 0x0152, "DPA_Sort"                 },
    { 0x0157, "DSA_Clone"                },
    { 0x0140, "DSA_Create"               },
    { 0x0147, "DSA_DeleteAllItems"       },
    { 0x0146, "DSA_DeleteItem"           },
    { 0x0141, "DSA_Destroy"              },
    { 0x0184, "DSA_DestroyCallback"      },
    { 0x0183, "DSA_EnumCallback"         },
    { 0x0142, "DSA_GetItem"              },
    { 0x0143, "DSA_GetItemPtr"           },
    { 0x015c, "DSA_GetSize"              },
    { 0x0144, "DSA_InsertItem"           },
    { 0x0145, "DSA_SetItem"              },
    { 0x015a, "DSA_Sort"                 },
    { 0x019d, "DefSubclassProc"          },
    { 0x0018, "DestroyPropertySheetPage" },
    { 0x00ce, "DetachScrollBars"         },
    { 0x0019, "DllGetVersion"            },
    { 0x001a, "DllInstall"               },
    { 0x000f, "DrawInsert"               },
    { 0x00c9, "DrawScrollBar"            },
    { 0x001b, "DrawShadowText"           },
    { 0x00c8, "DrawSizeBox"              },
    { 0x001c, "DrawStatusText"           },
    { 0x0005, "DrawStatusTextA"          },
    { 0x001d, "DrawStatusTextW"          },
    { 0x0193, "EnumMRUListW"             },
    { 0x001e, "FlatSB_EnableScrollBar"   },
    { 0x001f, "FlatSB_GetScrollInfo"     },
    { 0x0020, "FlatSB_GetScrollPos"      },
    { 0x0021, "FlatSB_GetScrollProp"     },
    { 0x0022, "FlatSB_GetScrollPropPtr"  },
    { 0x0023, "FlatSB_GetScrollRange"    },
    { 0x0024, "FlatSB_SetScrollInfo"     },
    { 0x0025, "FlatSB_SetScrollPos"      },
    { 0x0026, "FlatSB_SetScrollProp"     },
    { 0x0027, "FlatSB_SetScrollRange"    },
    { 0x0028, "FlatSB_ShowScrollBar"     },
    { 0x0098, "FreeMRUList"              },
    { 0x0004, "GetEffectiveClientRect"   },
    { 0x0029, "GetMUILanguage"           },
    { 0x019b, "GetWindowSubclass"        },
    { 0x002a, "HIMAGELIST_QueryInterface" },
    { 0x00cd, "HandleScrollCmd"          },
    { 0x002b, "ImageList_Add"            },
    { 0x002c, "ImageList_AddIcon"        },
    { 0x002d, "ImageList_AddMasked"      },
    { 0x002e, "ImageList_BeginDrag"      },
    { 0x002f, "ImageList_CoCreateInstance" },
    { 0x0030, "ImageList_Copy"           },
    { 0x0031, "ImageList_Create"         },
    { 0x0032, "ImageList_Destroy"        },
    { 0x0033, "ImageList_DestroyShared"  },
    { 0x0034, "ImageList_DragEnter"      },
    { 0x0035, "ImageList_DragLeave"      },
    { 0x0036, "ImageList_DragMove"       },
    { 0x0037, "ImageList_DragShowNolock" },
    { 0x0038, "ImageList_Draw"           },
    { 0x0039, "ImageList_DrawEx"         },
    { 0x003a, "ImageList_DrawIndirect"   },
    { 0x003b, "ImageList_Duplicate"      },
    { 0x003c, "ImageList_EndDrag"        },
    { 0x003d, "ImageList_GetBkColor"     },
    { 0x003e, "ImageList_GetDragImage"   },
    { 0x003f, "ImageList_GetFlags"       },
    { 0x0040, "ImageList_GetIcon"        },
    { 0x0041, "ImageList_GetIconSize"    },
    { 0x0042, "ImageList_GetImageCount"  },
    { 0x0043, "ImageList_GetImageInfo"   },
    { 0x0044, "ImageList_GetImageRect"   },
    { 0x0045, "ImageList_LoadImage"      },
    { 0x0046, "ImageList_LoadImageA"     },
    { 0x004b, "ImageList_LoadImageW"     },
    { 0x004c, "ImageList_Merge"          },
    { 0x004d, "ImageList_Read"           },
    { 0x004e, "ImageList_ReadEx"         },
    { 0x004f, "ImageList_Remove"         },
    { 0x0050, "ImageList_Replace"        },
    { 0x0051, "ImageList_ReplaceIcon"    },
    { 0x0052, "ImageList_Resize"         },
    { 0x0053, "ImageList_SetBkColor"     },
    { 0x0054, "ImageList_SetDragCursorImage" },
    { 0x0055, "ImageList_SetFilter"      },
    { 0x0056, "ImageList_SetFlags"       },
    { 0x0057, "ImageList_SetIconSize"    },
    { 0x0058, "ImageList_SetImageCount"  },
    { 0x0059, "ImageList_SetOverlayImage" },
    { 0x005a, "ImageList_Write"          },
    { 0x005b, "ImageList_WriteEx"        },
    { 0x0011, "InitCommonControls"       },
    { 0x005c, "InitCommonControlsEx"     },
    { 0x005d, "InitMUILanguage"          },
    { 0x005e, "InitializeFlatSB"         },
    { 0x000e, "LBItemFromPt"             },
    { 0x017c, "LoadIconMetric"           },
    { 0x017d, "LoadIconWithScaleDown"    },
    { 0x000d, "MakeDragList"             },
    { 0x0002, "MenuHelp"                 },
    { 0x005f, "PropertySheet"            },
    { 0x0060, "PropertySheetA"           },
    { 0x0061, "PropertySheetW"           },
    { 0x018a, "QuerySystemGestureStatus" },
    { 0x0062, "RegisterClassNameW"       },
    { 0x019c, "RemoveWindowSubclass"     },
    { 0x00cc, "ScrollBar_Menu"           },
    { 0x00cb, "ScrollBar_MouseMove"      },
    { 0x019a, "SetWindowSubclass"        },
    { 0x0003, "ShowHideMenuCtl"          },
    { 0x00ca, "SizeBoxHwnd"              },
    { 0x00ec, "Str_SetPtrW"              },
    { 0x0158, "TaskDialog"               },
    { 0x0159, "TaskDialogIndirect"       },
    { 0x0063, "UninitializeFlatSB"       },
    { 0x0064, "_TrackMouseEvent"         },
};


}
}

#endif

