
#if !defined( _INITIALIZE_STRUCTURE_) 
#define  _INITIALIZE_STRUCTURE_
#endif
#include <sys/time.h>
#include <pwd.h>
#include <unistd.h>
#include <sys/types.h>
#include "getError.h"
int FIRST_TIME_LOG=0;




void GetErrorMess(const char* ApplicName, const char* logMess,char* errMessg, int errnum) 
{
  if(errnum==0)
  {
	sprintf(errMessg,"NO_ERROR in %s",ApplicName);
  }
  else
  {
	sprintf(errMessg,"ERROR in %s : %s",ApplicName,logMess);
  }
}

int null_charptr(char* ptr_name)
{
	int value_ptr=0;
	if(ptr_name==NULL)
		value_ptr=-1;

	return value_ptr;

}
//return vale when doing a select for return values or buffer too small: security issue, len_attributevalue (=length using strlen)
void Format_output(int output_oraclecode, char* attribute_value, char* logmessage, char separator)
{
	//std::cout << "output_oraclecode" << output_oraclecode<< std::endl;
	switch(output_oraclecode)
	{
		case 0:
			strcpy(logmessage,"NO_ERROR");
			return;
		case -2:
			strcpy(logmessage,"ERROR:length of return greater than actual output, value can't put in signed short");
			sprintf(attribute_value,"ERROR_BUFFER_TOOSMALL%c",separator);
			return;
		case -1:
			strcpy(logmessage,"NULL_VALUE");
			sprintf(attribute_value,"NULL%c",separator);
			return;
		default:
			sprintf(logmessage,"ERROR:length of return greater than actual output you need %d",output_oraclecode);
			sprintf(attribute_value,"ERROR_BUFFER_TOOSMALL%c",separator);
			return;
	}
	
			

}

void MinStringLength(int &actual_len)
{
	if(actual_len<MINSTRINGLEN)
		actual_len=MINSTRINGLEN;
}

void WriteToLogFile(char* appliName, char* statement)
{
	
	FILE *f1; 
	char col_stmt[200];
	int rescode=0;
	char ErrMess[1000];
	struct timeval tv;
	struct timezone tz;
	struct tm *tm;
	gettimeofday(&tv, &tz);
	tm=localtime(&tv.tv_sec);
	//std::cout<<"first time is ="<<FIRST_TIME_LOG<<std::endl;
	//std::cout<<"logfile ="<<logfilename<<std::endl;
	if(FIRST_TIME_LOG==0)
	{
		char username[100];
		char hostname[100];
		int len_host=101;
		rescode=getTerminalName( hostname, len_host, ErrMess);
		if(rescode==0)
		{
			rescode=getLoginUser( username,len_host,ErrMess);
			if(rescode!=0)
			{
				strcpy(username,"username_notfound");
			}
		}
		else
		{
			strcpy(hostname,"hostname_notfound");
		}
		f1 = fopen (logfilename, "w+t");  
		if (f1==NULL)
		{
			strcpy(col_stmt,"Could not create the log file ");
			GetErrorMess(appliName,col_stmt,ErrMess,1);
			std::cout<<"ErrMess"<<std::endl;
			exit(-1);
			
		}

		FIRST_TIME_LOG=1;
		rescode=fprintf(f1,"Log file generated by user %s from machine %s at %02d/%02d/%02d  %d:%02d:%02d %d \n",username,hostname,tm->tm_mday, tm->tm_mon + 1, tm->tm_year % 100, tm->tm_hour, tm->tm_min,tm->tm_sec, tv.tv_usec);// need to add the date
	
		

	}
	else
	{
		f1 = fopen (logfilename, "at");  //check how to append
		if (f1==NULL)
		{
			strcpy(col_stmt,"Could not open the log file  ");
			GetErrorMess(appliName,col_stmt,ErrMess,1);
			std::cout<<"ErrMess"<<std::endl;
			rescode=-1;
			exit(-1);
		}
	}
	//std::cout<<"logfile ="<<logfilename<<std::endl;
	rescode=fprintf(f1,"At %02d/%02d/%02d %d:%02d:%02d %d, %s : %s \n",tm->tm_mday, tm->tm_mon + 1, tm->tm_year % 100, tm->tm_hour, tm->tm_min,tm->tm_sec, tv.tv_usec, appliName,statement);// need to add the date
	
	fclose(f1);

}
void ErrorExit(const char* FctName,const char* logMess,char* ErrMess, int errnum) 
{ 
	if(errnum==0)
	{
		sprintf(ErrMess, "NO_ERROR in %s",FctName);
	}
	else
	{
		sprintf(ErrMess,"ERROR in %s : %s ",FctName,logMess);
	}
}

int getTerminalName(char* hostname,int len_host,char* ErrorMess)
{
	int res=0;
	int  bufCharCount =len_host;
	if( gethostname( hostname, bufCharCount )!=0)
	  {
		  ErrorExit("getTerminalName", "Not successful",ErrorMess,1);
		  strcpy(hostname,"ERROR_IN_GETTING_HOST_NAME");
		res=-1;
	  }
	else
		  ErrorExit("getTerminalName", "Not successful",ErrorMess,0);
		
	return res;
}

int getLoginUser(char* username,int len_host,char* ErrorMess)
{
	int res=0;
	int bufCharCount = len_host;
	int rescode=0;

	uid_t curUserId=getuid();
	// get the information describing the user with this userID
	struct passwd *userData=getpwuid(curUserId);
	if (userData==0) 
	{
		ErrorExit("getLoginUser ","Not Successful ",ErrorMess,1);
		strcpy(username,"ERROR_IN_GETTING_LOGIN_NAME ");
		res=-1;
	}
	// extract the user name from this record:
	strcpy(username,userData->pw_name);
	ErrorExit("getLoginUser "," ",ErrorMess,0);
	return res;
}


