/*
 * TestLaTeXDrawPoint2D.java
 */
package junit.test;

import junit.framework.TestCase;
import latexDraw.util.LaTeXDrawPoint2D;

import org.junit.Test;

/** 
 * This class contains tests the methods of the class <code>LaTeXDrawPoint2D</code>.<br>
 * <br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 * 
 * <br>
 * 12/23/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class TestLaTeXDrawPoint2D extends TestCase
{

	@Test
	public void testEquals()
	{
		LaTeXDrawPoint2D p1 = new LaTeXDrawPoint2D();
		LaTeXDrawPoint2D p2 = new LaTeXDrawPoint2D();
		LaTeXDrawPoint2D p3 = new LaTeXDrawPoint2D(1,0);
		LaTeXDrawPoint2D p4 = new LaTeXDrawPoint2D(1,1);
		
		assertTrue(p1.equals(p2, 0));
		assertFalse(p1.equals(p3, 0));
		assertFalse(p4.equals(p3, 0));
		assertFalse(p4.equals(null, 0));
		
		p1.x = 1./3.;
		p2.x = 1./3.;
		
		assertTrue(p1.equals(p2, 0));
		
		p1.x = Math.PI;
		p2.x = Math.PI;
		
		assertTrue(p1.equals(p2, 0));
	}
	
	
	
	@Test
	public void testGetMiddlePoint()
	{
		LaTeXDrawPoint2D p1 = new LaTeXDrawPoint2D();
		LaTeXDrawPoint2D p2 = new LaTeXDrawPoint2D();
		LaTeXDrawPoint2D p3 = new LaTeXDrawPoint2D(1,1);
		LaTeXDrawPoint2D p4 = new LaTeXDrawPoint2D(0.5,0.5);
		
		assertTrue(p1.getMiddlePoint(p2).equals(p1, 0));
		assertTrue(p1.getMiddlePoint(p3).equals(p4, 0));
		
		p3.x = 1./3.;
		p4.x = 1./6.;
		assertTrue(p1.getMiddlePoint(p3).equals(p4, 0));
		assertFalse(p1.getMiddlePoint(p4).equals(p1, 0));
	}
	
	
	
	@Test
	public void testMove()
	{
		LaTeXDrawPoint2D p1 = new LaTeXDrawPoint2D();
		LaTeXDrawPoint2D p2 = new LaTeXDrawPoint2D(-12, 65);
		LaTeXDrawPoint2D p3 = new LaTeXDrawPoint2D();
		LaTeXDrawPoint2D p4 = new LaTeXDrawPoint2D();
		
		p1.move(p2, p3);
		p4.x = p3.x - p2.x;
		p4.y = p3.y - p2.y;
		assertTrue(p1.equals(p4, 0));
		
		p1.move(p3, p3);
		assertTrue(p1.equals(p1));
		assertFalse(p1.equals(p2));
	}
	
	
	
	@Test
	public void testVerticalSymmetry()
	{
		LaTeXDrawPoint2D p1 = new LaTeXDrawPoint2D(-1, 0);
		LaTeXDrawPoint2D p2 = new LaTeXDrawPoint2D(-1, 0);
		LaTeXDrawPoint2D o = new LaTeXDrawPoint2D();
		LaTeXDrawPoint2D res;
		
		res = new LaTeXDrawPoint2D(p1.verticalSymmetry(o));
		assertTrue(res.equals(p2, 0));
		p1.y = 3;
		p2.y = -3;
		res = new LaTeXDrawPoint2D(p1.verticalSymmetry(o));
		assertTrue(res.equals(p2, 0));
	}
	
	
	
	@Test
	public void testHorizontalSymmetry()
	{
		LaTeXDrawPoint2D p1 = new LaTeXDrawPoint2D(0, 1);
		LaTeXDrawPoint2D p2 = new LaTeXDrawPoint2D(0, 1);
		LaTeXDrawPoint2D o = new LaTeXDrawPoint2D();
		LaTeXDrawPoint2D res;
		
		res = new LaTeXDrawPoint2D(p1.horizontalSymmetry(o));
		assertTrue(res.equals(p2, 0));
		p1.x = 3;
		p2.x = -3;
		res = new LaTeXDrawPoint2D(p1.horizontalSymmetry(o));
		assertTrue(res.equals(p2, 0));
	}
	
	
	
	@Test
	public void testCentralSymmetry()
	{
		LaTeXDrawPoint2D p1 = new LaTeXDrawPoint2D(1, 1);
		LaTeXDrawPoint2D p2 = new LaTeXDrawPoint2D(-1, -1);
		LaTeXDrawPoint2D o = new LaTeXDrawPoint2D();
		LaTeXDrawPoint2D res;
		
		res = new LaTeXDrawPoint2D(p1.centralSymmetry(o));
		assertTrue(res.equals(p2, 0));
		p1.x = 3;
		p2.x = -3;
		res = new LaTeXDrawPoint2D(p1.centralSymmetry(o));
		assertTrue(res.equals(p2, 0));
	}
	
	
	
	@Test
	public void testRotatePoint()
	{
		LaTeXDrawPoint2D p1 = new LaTeXDrawPoint2D(1, 0);
		LaTeXDrawPoint2D p2 = new LaTeXDrawPoint2D(0, 1);
		LaTeXDrawPoint2D o = new LaTeXDrawPoint2D();
		LaTeXDrawPoint2D res;
		
		res = new LaTeXDrawPoint2D(p1.rotatePoint(o, Math.PI/2.));
		assertTrue(res.equals(p2, 0));
		res = new LaTeXDrawPoint2D(p1.rotatePoint(o, 2*Math.PI+Math.PI/2.));
		assertTrue(res.equals(p2, 0));
		res = new LaTeXDrawPoint2D(p1.rotatePoint(o, -3.*Math.PI/2.));
		assertTrue(res.equals(p2, 0));
		p2.x = -1;
		p2.y = 0;
		res = new LaTeXDrawPoint2D(p1.rotatePoint(o, Math.PI));
		assertTrue(res.equals(p2, 0));
		res = new LaTeXDrawPoint2D(p1.rotatePoint(o, 2*Math.PI+Math.PI));
		assertTrue(res.equals(p2, 0));
		res = new LaTeXDrawPoint2D(p1.rotatePoint(o, -Math.PI));
		assertTrue(res.equals(p2, 0));
		p2.x = 0;
		p2.y = -1;
		res = new LaTeXDrawPoint2D(p1.rotatePoint(o, 3.*Math.PI/2.));
		assertTrue(res.equals(p2, 0));
		res = new LaTeXDrawPoint2D(p1.rotatePoint(o, 2*Math.PI+3.*Math.PI/2.));
		assertTrue(res.equals(p2, 0));
		res = new LaTeXDrawPoint2D(p1.rotatePoint(o, -Math.PI/2.));
		assertTrue(res.equals(p2, 0));
		p2.x = 1;
		p2.y = 0;
		res = new LaTeXDrawPoint2D(p1.rotatePoint(o, 2.*Math.PI));
		assertTrue(res.equals(p2, 0));
		res = new LaTeXDrawPoint2D(p1.rotatePoint(o, 4.*Math.PI));
		assertTrue(res.equals(p2, 0));
		res = new LaTeXDrawPoint2D(p1.rotatePoint(o, 0.));
		assertTrue(res.equals(p2, 0));
		res = new LaTeXDrawPoint2D(p1.rotatePoint(o, -2.*Math.PI));
		assertTrue(res.equals(p2, 0));
	}
}




