// Code generated by genlib2. DO NOT EDIT.

package tensor

import (
	"testing"
	"testing/quick"
)

func TestAdd(t *testing.T) {
	iden := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Adder)
		we = we || !ok

		ret, err := Add(a, b)
		if err, retEarly := qcErrCheck(t, "Add", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(iden, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Add failed: %v", err)
	}

}
func TestSub(t *testing.T) {
	inv := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Suber)
		we = we || !ok

		ret, err := Sub(a, b)
		if err, retEarly := qcErrCheck(t, "Sub", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = Add(ret, b, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(inv, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Sub failed: %v", err)
	}
}
func TestMul(t *testing.T) {
	iden := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		b.Memset(identityVal(1, a.t))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Muler)
		we = we || !ok

		ret, err := Mul(a, b)
		if err, retEarly := qcErrCheck(t, "Mul", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(iden, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Mul failed: %v", err)
	}

}
func TestDiv(t *testing.T) {
	inv := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		b.Memset(identityVal(1, a.t))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Diver)
		we = we || !ok

		ret, err := Div(a, b)
		if err, retEarly := qcErrCheck(t, "Div", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = Mul(ret, b, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(inv, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Div failed: %v", err)
	}
}
func TestPow(t *testing.T) {
	iden := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		b.Memset(identityVal(1, a.t))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, floatcmplxTypes, complexTypes)
		_, ok := a.Engine().(Power)
		we = we || !ok

		ret, err := Pow(a, b)
		if err, retEarly := qcErrCheck(t, "Pow", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(iden, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Pow failed: %v", err)
	}

}
func TestAdd_unsafe(t *testing.T) {
	iden := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Adder)
		we = we || !ok

		ret, err := Add(a, b, UseUnsafe())
		if err, retEarly := qcErrCheck(t, "Add", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if ret != a {
			t.Errorf("Expected ret to be the same as a")
			return false
		}

		return true
	}
	if err := quick.Check(iden, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Add failed: %v", err)
	}

}
func TestSub_unsafe(t *testing.T) {
	inv := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Suber)
		we = we || !ok

		ret, err := Sub(a, b, UseUnsafe())
		if err, retEarly := qcErrCheck(t, "Sub", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = Add(ret, b, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if ret != a {
			t.Errorf("Expected ret to be the same as a")
			return false
		}

		return true
	}
	if err := quick.Check(inv, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Sub failed: %v", err)
	}
}
func TestMul_unsafe(t *testing.T) {
	iden := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		b.Memset(identityVal(1, a.t))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Muler)
		we = we || !ok

		ret, err := Mul(a, b, UseUnsafe())
		if err, retEarly := qcErrCheck(t, "Mul", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if ret != a {
			t.Errorf("Expected ret to be the same as a")
			return false
		}

		return true
	}
	if err := quick.Check(iden, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Mul failed: %v", err)
	}

}
func TestDiv_unsafe(t *testing.T) {
	inv := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		b.Memset(identityVal(1, a.t))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Diver)
		we = we || !ok

		ret, err := Div(a, b, UseUnsafe())
		if err, retEarly := qcErrCheck(t, "Div", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = Mul(ret, b, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if ret != a {
			t.Errorf("Expected ret to be the same as a")
			return false
		}

		return true
	}
	if err := quick.Check(inv, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Div failed: %v", err)
	}
}
func TestPow_unsafe(t *testing.T) {
	iden := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		b.Memset(identityVal(1, a.t))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, floatcmplxTypes, complexTypes)
		_, ok := a.Engine().(Power)
		we = we || !ok

		ret, err := Pow(a, b, UseUnsafe())
		if err, retEarly := qcErrCheck(t, "Pow", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if ret != a {
			t.Errorf("Expected ret to be the same as a")
			return false
		}

		return true
	}
	if err := quick.Check(iden, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Pow failed: %v", err)
	}

}
func TestAdd_reuse(t *testing.T) {
	iden := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		reuse := New(Of(a.t), WithShape(a.Shape().Clone()...))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Adder)
		we = we || !ok

		ret, err := Add(a, b, WithReuse(reuse))
		if err, retEarly := qcErrCheck(t, "Add", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}
	if err := quick.Check(iden, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Add failed: %v", err)
	}

}
func TestSub_reuse(t *testing.T) {
	inv := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		reuse := New(Of(a.t), WithShape(a.Shape().Clone()...))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Suber)
		we = we || !ok

		ret, err := Sub(a, b, WithReuse(reuse))
		if err, retEarly := qcErrCheck(t, "Sub", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = Add(ret, b, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}
	if err := quick.Check(inv, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Sub failed: %v", err)
	}
}
func TestMul_reuse(t *testing.T) {
	iden := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		b.Memset(identityVal(1, a.t))
		reuse := New(Of(a.t), WithShape(a.Shape().Clone()...))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Muler)
		we = we || !ok

		ret, err := Mul(a, b, WithReuse(reuse))
		if err, retEarly := qcErrCheck(t, "Mul", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}
	if err := quick.Check(iden, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Mul failed: %v", err)
	}

}
func TestDiv_reuse(t *testing.T) {
	inv := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		b.Memset(identityVal(1, a.t))
		reuse := New(Of(a.t), WithShape(a.Shape().Clone()...))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Diver)
		we = we || !ok

		ret, err := Div(a, b, WithReuse(reuse))
		if err, retEarly := qcErrCheck(t, "Div", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = Mul(ret, b, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}
	if err := quick.Check(inv, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Div failed: %v", err)
	}
}
func TestPow_reuse(t *testing.T) {
	iden := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		b.Memset(identityVal(1, a.t))
		reuse := New(Of(a.t), WithShape(a.Shape().Clone()...))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, floatcmplxTypes, complexTypes)
		_, ok := a.Engine().(Power)
		we = we || !ok

		ret, err := Pow(a, b, WithReuse(reuse))
		if err, retEarly := qcErrCheck(t, "Pow", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}
	if err := quick.Check(iden, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Pow failed: %v", err)
	}

}
func TestAdd_incr(t *testing.T) {
	iden := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		incr := New(Of(a.t), WithShape(a.Shape().Clone()...))
		correct := a.Clone().(*Dense)
		incr.Memset(identityVal(100, a.t))
		correct.Add(incr, UseUnsafe())
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Adder)
		we = we || !ok

		ret, err := Add(a, b, WithIncr(incr))
		if err, retEarly := qcErrCheck(t, "Add", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(iden, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Add failed: %v", err)
	}

}
func TestSub_incr(t *testing.T) {
	inv := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		incr := New(Of(a.t), WithShape(a.Shape().Clone()...))
		correct := a.Clone().(*Dense)
		incr.Memset(identityVal(100, a.t))
		correct.Add(incr, UseUnsafe())
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Suber)
		we = we || !ok

		ret, err := Sub(a, b, WithIncr(incr))
		if err, retEarly := qcErrCheck(t, "Sub", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = Add(ret, b, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(inv, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Sub failed: %v", err)
	}
}
func TestMul_incr(t *testing.T) {
	iden := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		b.Memset(identityVal(1, a.t))
		incr := New(Of(a.t), WithShape(a.Shape().Clone()...))
		correct := a.Clone().(*Dense)
		incr.Memset(identityVal(100, a.t))
		correct.Add(incr, UseUnsafe())
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Muler)
		we = we || !ok

		ret, err := Mul(a, b, WithIncr(incr))
		if err, retEarly := qcErrCheck(t, "Mul", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(iden, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Mul failed: %v", err)
	}

}
func TestDiv_incr(t *testing.T) {
	inv := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		b.Memset(identityVal(1, a.t))
		incr := New(Of(a.t), WithShape(a.Shape().Clone()...))
		correct := a.Clone().(*Dense)
		incr.Memset(identityVal(100, a.t))
		correct.Add(incr, UseUnsafe())
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Diver)
		we = we || !ok

		ret, err := Div(a, b, WithIncr(incr))
		if err, retEarly := qcErrCheck(t, "Div", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = Mul(ret, b, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(inv, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Div failed: %v", err)
	}
}
func TestPow_incr(t *testing.T) {
	iden := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		b.Memset(identityVal(1, a.t))
		incr := New(Of(a.t), WithShape(a.Shape().Clone()...))
		correct := a.Clone().(*Dense)
		incr.Memset(identityVal(100, a.t))
		correct.Add(incr, UseUnsafe())
		we, willFailEq := willerr(a, floatcmplxTypes, complexTypes)
		_, ok := a.Engine().(Power)
		we = we || !ok

		ret, err := Pow(a, b, WithIncr(incr))
		if err, retEarly := qcErrCheck(t, "Pow", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(iden, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Pow failed: %v", err)
	}

}
func TestAddScalar(t *testing.T) {
	iden1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(0, q.t)

		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Adder)
		we = we || !ok

		ret, err := Add(a, b)
		if err, retEarly := qcErrCheck(t, "Add", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}

	if err := quick.Check(iden1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Add (tensor as left, scalar as right) failed: %v", err)
	}

	iden2 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(0, q.t)
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Adder)
		we = we || !ok

		ret, err := Add(b, a)
		if err, retEarly := qcErrCheck(t, "Add", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(iden2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Add (scalar as left, tensor as right) failed: %v", err)
	}

	type Foo int
	wt1 := func(a *Dense) bool {
		b := Foo(0)
		ret, err := Add(a, b)
		if err == nil {
			return false
		}
		_ = ret
		return true
	}
	if err := quick.Check(wt1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("WrongType test for Add (tensor as left, scalar as right) failed: %v", err)
	}

	wt2 := func(a *Dense) bool {
		b := Foo(0)
		ret, err := Add(b, a)
		if err == nil {
			return false
		}
		_ = ret
		return true
	}
	if err := quick.Check(wt2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("WrongType test for Add (tensor as right, scalar as left) failed: %v", err)
	}
}
func TestSubScalar(t *testing.T) {
	inv1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(0, q.t)

		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, unsignedTypes)
		_, ok := q.Engine().(Suber)
		we = we || !ok

		ret, err := Sub(a, b)
		if err, retEarly := qcErrCheck(t, "SubVS", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = Add(ret, b, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(inv1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Sub (tensor as left, scalar as right) failed: %v", err)
	}

	inv2 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(0, q.t)
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, unsignedTypes)
		_, ok := q.Engine().(Suber)
		we = we || !ok

		ret, err := Sub(b, a)
		if err, retEarly := qcErrCheck(t, "SubSV", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = Sub(b, ret, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(inv2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Sub (scalar as left, tensor as right) failed: %v", err)
	}
	type Foo int
	wt1 := func(a *Dense) bool {
		b := Foo(0)
		ret, err := Sub(a, b)
		if err == nil {
			return false
		}
		_ = ret
		return true
	}
	if err := quick.Check(wt1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("WrongType test for Sub (tensor as left, scalar as right) failed: %v", err)
	}

	wt2 := func(a *Dense) bool {
		b := Foo(0)
		ret, err := Sub(b, a)
		if err == nil {
			return false
		}
		_ = ret
		return true
	}
	if err := quick.Check(wt2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("WrongType test for Sub (tensor as right, scalar as left) failed: %v", err)
	}
}
func TestMulScalar(t *testing.T) {
	iden1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)

		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Muler)
		we = we || !ok

		ret, err := Mul(a, b)
		if err, retEarly := qcErrCheck(t, "Mul", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}

	if err := quick.Check(iden1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Mul (tensor as left, scalar as right) failed: %v", err)
	}

	iden2 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Muler)
		we = we || !ok

		ret, err := Mul(b, a)
		if err, retEarly := qcErrCheck(t, "Mul", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(iden2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Mul (scalar as left, tensor as right) failed: %v", err)
	}

	type Foo int
	wt1 := func(a *Dense) bool {
		b := Foo(0)
		ret, err := Mul(a, b)
		if err == nil {
			return false
		}
		_ = ret
		return true
	}
	if err := quick.Check(wt1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("WrongType test for Mul (tensor as left, scalar as right) failed: %v", err)
	}

	wt2 := func(a *Dense) bool {
		b := Foo(0)
		ret, err := Mul(b, a)
		if err == nil {
			return false
		}
		_ = ret
		return true
	}
	if err := quick.Check(wt2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("WrongType test for Mul (tensor as right, scalar as left) failed: %v", err)
	}
}
func TestDivScalar(t *testing.T) {
	inv1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)

		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Diver)
		we = we || !ok

		ret, err := Div(a, b)
		if err, retEarly := qcErrCheck(t, "DivVS", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = Mul(ret, b, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(inv1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Div (tensor as left, scalar as right) failed: %v", err)
	}

	type Foo int
	wt1 := func(a *Dense) bool {
		b := Foo(0)
		ret, err := Div(a, b)
		if err == nil {
			return false
		}
		_ = ret
		return true
	}
	if err := quick.Check(wt1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("WrongType test for Div (tensor as left, scalar as right) failed: %v", err)
	}

	wt2 := func(a *Dense) bool {
		b := Foo(0)
		ret, err := Div(b, a)
		if err == nil {
			return false
		}
		_ = ret
		return true
	}
	if err := quick.Check(wt2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("WrongType test for Div (tensor as right, scalar as left) failed: %v", err)
	}
}
func TestPowScalar(t *testing.T) {
	iden1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)

		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, floatcmplxTypes, complexTypes)
		_, ok := q.Engine().(Power)
		we = we || !ok

		ret, err := Pow(a, b)
		if err, retEarly := qcErrCheck(t, "Pow", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}

	if err := quick.Check(iden1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Pow (tensor as left, scalar as right) failed: %v", err)
	}

	type Foo int
	wt1 := func(a *Dense) bool {
		b := Foo(0)
		ret, err := Pow(a, b)
		if err == nil {
			return false
		}
		_ = ret
		return true
	}
	if err := quick.Check(wt1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("WrongType test for Pow (tensor as left, scalar as right) failed: %v", err)
	}

	wt2 := func(a *Dense) bool {
		b := Foo(0)
		ret, err := Pow(b, a)
		if err == nil {
			return false
		}
		_ = ret
		return true
	}
	if err := quick.Check(wt2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("WrongType test for Pow (tensor as right, scalar as left) failed: %v", err)
	}
}
func TestAddScalar_unsafe(t *testing.T) {
	iden1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(0, q.t)

		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Adder)
		we = we || !ok

		ret, err := Add(a, b, UseUnsafe())
		if err, retEarly := qcErrCheck(t, "Add", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if ret != a {
			t.Errorf("Expected ret to be the same as a")
			return false
		}

		return true
	}

	if err := quick.Check(iden1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Add (tensor as left, scalar as right) failed: %v", err)
	}

	iden2 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(0, q.t)
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Adder)
		we = we || !ok

		ret, err := Add(b, a, UseUnsafe())
		if err, retEarly := qcErrCheck(t, "Add", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if ret != a {
			t.Errorf("Expected ret to be the same as a")
			return false
		}

		return true
	}
	if err := quick.Check(iden2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Add (scalar as left, tensor as right) failed: %v", err)
	}

}
func TestSubScalar_unsafe(t *testing.T) {
	inv1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(0, q.t)

		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, unsignedTypes)
		_, ok := q.Engine().(Suber)
		we = we || !ok

		ret, err := Sub(a, b, UseUnsafe())
		if err, retEarly := qcErrCheck(t, "SubVS", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = Add(ret, b, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if ret != a {
			t.Errorf("Expected ret to be the same as a")
			return false
		}

		return true
	}
	if err := quick.Check(inv1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Sub (tensor as left, scalar as right) failed: %v", err)
	}

	inv2 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(0, q.t)
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, unsignedTypes)
		_, ok := q.Engine().(Suber)
		we = we || !ok

		ret, err := Sub(b, a, UseUnsafe())
		if err, retEarly := qcErrCheck(t, "SubSV", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = Sub(b, ret, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if ret != a {
			t.Errorf("Expected ret to be the same as a")
			return false
		}

		return true
	}
	if err := quick.Check(inv2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Sub (scalar as left, tensor as right) failed: %v", err)
	}
}
func TestMulScalar_unsafe(t *testing.T) {
	iden1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)

		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Muler)
		we = we || !ok

		ret, err := Mul(a, b, UseUnsafe())
		if err, retEarly := qcErrCheck(t, "Mul", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if ret != a {
			t.Errorf("Expected ret to be the same as a")
			return false
		}

		return true
	}

	if err := quick.Check(iden1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Mul (tensor as left, scalar as right) failed: %v", err)
	}

	iden2 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Muler)
		we = we || !ok

		ret, err := Mul(b, a, UseUnsafe())
		if err, retEarly := qcErrCheck(t, "Mul", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if ret != a {
			t.Errorf("Expected ret to be the same as a")
			return false
		}

		return true
	}
	if err := quick.Check(iden2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Mul (scalar as left, tensor as right) failed: %v", err)
	}

}
func TestDivScalar_unsafe(t *testing.T) {
	inv1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)

		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Diver)
		we = we || !ok

		ret, err := Div(a, b, UseUnsafe())
		if err, retEarly := qcErrCheck(t, "DivVS", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = Mul(ret, b, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if ret != a {
			t.Errorf("Expected ret to be the same as a")
			return false
		}

		return true
	}
	if err := quick.Check(inv1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Div (tensor as left, scalar as right) failed: %v", err)
	}

}
func TestPowScalar_unsafe(t *testing.T) {
	iden1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)

		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, floatcmplxTypes, complexTypes)
		_, ok := q.Engine().(Power)
		we = we || !ok

		ret, err := Pow(a, b, UseUnsafe())
		if err, retEarly := qcErrCheck(t, "Pow", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if ret != a {
			t.Errorf("Expected ret to be the same as a")
			return false
		}

		return true
	}

	if err := quick.Check(iden1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Pow (tensor as left, scalar as right) failed: %v", err)
	}

}
func TestAddScalar_reuse(t *testing.T) {
	iden1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(0, q.t)
		reuse := New(Of(a.t), WithShape(a.Shape().Clone()...))

		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Adder)
		we = we || !ok

		ret, err := Add(a, b, WithReuse(reuse))
		if err, retEarly := qcErrCheck(t, "Add", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}

	if err := quick.Check(iden1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Add (tensor as left, scalar as right) failed: %v", err)
	}

	iden2 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(0, q.t)
		reuse := New(Of(a.t), WithShape(a.Shape().Clone()...))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Adder)
		we = we || !ok

		ret, err := Add(b, a, WithReuse(reuse))
		if err, retEarly := qcErrCheck(t, "Add", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}
	if err := quick.Check(iden2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Add (scalar as left, tensor as right) failed: %v", err)
	}

}
func TestSubScalar_reuse(t *testing.T) {
	inv1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(0, q.t)
		reuse := New(Of(a.t), WithShape(a.Shape().Clone()...))

		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, unsignedTypes)
		_, ok := q.Engine().(Suber)
		we = we || !ok

		ret, err := Sub(a, b, WithReuse(reuse))
		if err, retEarly := qcErrCheck(t, "SubVS", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = Add(ret, b, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}
	if err := quick.Check(inv1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Sub (tensor as left, scalar as right) failed: %v", err)
	}

	inv2 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(0, q.t)
		reuse := New(Of(a.t), WithShape(a.Shape().Clone()...))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, unsignedTypes)
		_, ok := q.Engine().(Suber)
		we = we || !ok

		ret, err := Sub(b, a, WithReuse(reuse))
		if err, retEarly := qcErrCheck(t, "SubSV", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = Sub(b, ret, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}
	if err := quick.Check(inv2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Sub (scalar as left, tensor as right) failed: %v", err)
	}
}
func TestMulScalar_reuse(t *testing.T) {
	iden1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)
		reuse := New(Of(a.t), WithShape(a.Shape().Clone()...))

		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Muler)
		we = we || !ok

		ret, err := Mul(a, b, WithReuse(reuse))
		if err, retEarly := qcErrCheck(t, "Mul", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}

	if err := quick.Check(iden1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Mul (tensor as left, scalar as right) failed: %v", err)
	}

	iden2 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)
		reuse := New(Of(a.t), WithShape(a.Shape().Clone()...))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Muler)
		we = we || !ok

		ret, err := Mul(b, a, WithReuse(reuse))
		if err, retEarly := qcErrCheck(t, "Mul", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}
	if err := quick.Check(iden2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Mul (scalar as left, tensor as right) failed: %v", err)
	}

}
func TestDivScalar_reuse(t *testing.T) {
	inv1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)
		reuse := New(Of(a.t), WithShape(a.Shape().Clone()...))

		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Diver)
		we = we || !ok

		ret, err := Div(a, b, WithReuse(reuse))
		if err, retEarly := qcErrCheck(t, "DivVS", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = Mul(ret, b, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}
	if err := quick.Check(inv1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Div (tensor as left, scalar as right) failed: %v", err)
	}

}
func TestPowScalar_reuse(t *testing.T) {
	iden1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)
		reuse := New(Of(a.t), WithShape(a.Shape().Clone()...))

		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, floatcmplxTypes, complexTypes)
		_, ok := q.Engine().(Power)
		we = we || !ok

		ret, err := Pow(a, b, WithReuse(reuse))
		if err, retEarly := qcErrCheck(t, "Pow", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}

	if err := quick.Check(iden1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Pow (tensor as left, scalar as right) failed: %v", err)
	}

}
func TestAddScalar_incr(t *testing.T) {
	iden1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(0, q.t)
		incr := New(Of(a.t), WithShape(a.Shape().Clone()...))

		correct := a.Clone().(*Dense)
		incr.Memset(identityVal(100, a.t))
		correct.Add(incr, UseUnsafe())
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Adder)
		we = we || !ok

		ret, err := Add(a, b, WithIncr(incr))
		if err, retEarly := qcErrCheck(t, "Add", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}

	if err := quick.Check(iden1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Add (tensor as left, scalar as right) failed: %v", err)
	}

	iden2 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(0, q.t)
		incr := New(Of(a.t), WithShape(a.Shape().Clone()...))
		correct := a.Clone().(*Dense)
		incr.Memset(identityVal(100, a.t))
		correct.Add(incr, UseUnsafe())
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Adder)
		we = we || !ok

		ret, err := Add(b, a, WithIncr(incr))
		if err, retEarly := qcErrCheck(t, "Add", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(iden2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Add (scalar as left, tensor as right) failed: %v", err)
	}

}
func TestSubScalar_incr(t *testing.T) {
	inv1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(0, q.t)
		incr := New(Of(a.t), WithShape(a.Shape().Clone()...))

		correct := a.Clone().(*Dense)
		incr.Memset(identityVal(100, a.t))
		correct.Add(incr, UseUnsafe())
		we, willFailEq := willerr(a, numberTypes, unsignedTypes)
		_, ok := q.Engine().(Suber)
		we = we || !ok

		ret, err := Sub(a, b, WithIncr(incr))
		if err, retEarly := qcErrCheck(t, "SubVS", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = Add(ret, b, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(inv1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Sub (tensor as left, scalar as right) failed: %v", err)
	}

}
func TestMulScalar_incr(t *testing.T) {
	iden1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)
		incr := New(Of(a.t), WithShape(a.Shape().Clone()...))

		correct := a.Clone().(*Dense)
		incr.Memset(identityVal(100, a.t))
		correct.Add(incr, UseUnsafe())
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Muler)
		we = we || !ok

		ret, err := Mul(a, b, WithIncr(incr))
		if err, retEarly := qcErrCheck(t, "Mul", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}

	if err := quick.Check(iden1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Mul (tensor as left, scalar as right) failed: %v", err)
	}

	iden2 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)
		incr := New(Of(a.t), WithShape(a.Shape().Clone()...))
		correct := a.Clone().(*Dense)
		incr.Memset(identityVal(100, a.t))
		correct.Add(incr, UseUnsafe())
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Muler)
		we = we || !ok

		ret, err := Mul(b, a, WithIncr(incr))
		if err, retEarly := qcErrCheck(t, "Mul", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(iden2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Mul (scalar as left, tensor as right) failed: %v", err)
	}

}
func TestDivScalar_incr(t *testing.T) {
	inv1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)
		incr := New(Of(a.t), WithShape(a.Shape().Clone()...))

		correct := a.Clone().(*Dense)
		incr.Memset(identityVal(100, a.t))
		correct.Add(incr, UseUnsafe())
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Diver)
		we = we || !ok

		ret, err := Div(a, b, WithIncr(incr))
		if err, retEarly := qcErrCheck(t, "DivVS", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = Mul(ret, b, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(inv1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Div (tensor as left, scalar as right) failed: %v", err)
	}

}
func TestPowScalar_incr(t *testing.T) {
	iden1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)
		incr := New(Of(a.t), WithShape(a.Shape().Clone()...))

		correct := a.Clone().(*Dense)
		incr.Memset(identityVal(100, a.t))
		correct.Add(incr, UseUnsafe())
		we, willFailEq := willerr(a, floatcmplxTypes, complexTypes)
		_, ok := q.Engine().(Power)
		we = we || !ok

		ret, err := Pow(a, b, WithIncr(incr))
		if err, retEarly := qcErrCheck(t, "Pow", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}

	if err := quick.Check(iden1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Pow (tensor as left, scalar as right) failed: %v", err)
	}

}
