
import math

import glitch, glitch.glut
from glitch.limbo.blend import Blend
from glitch.cairo.draw import CairoTexture

class Chequer(CairoTexture):
    def draw_cairo(self, cr):
        w = self.width / 10
        h = self.height / 10

        for y in xrange(10):
            for x in xrange(10):
                if (x + y) % 2 == 0:
                    cr.set_source_rgba(0.5, 0.5, 0.5, 0.7)
                else:
                    cr.set_source_rgba(0.8, 0.8, 0.8, 0.7)

                cr.move_to(x * w, y * h)
                cr.rel_line_to(w, 0)
                cr.rel_line_to(0, h)
                cr.rel_line_to(-w, 0)
                cr.rel_line_to(0, -0)
                cr.fill()

class Circles(CairoTexture):
    def draw_cairo(self, cr):
        c1 = (1.0, 0.7, 0.7)
        c2 = (1.0, 1.0, 0.7)
        c3 = (0.7, 1.0, 1.0)

        rmax = int(max(self.width, self.height) / math.sqrt(2))

        for i, r in enumerate(xrange(rmax, 0, -int(rmax / 5))):
            cr.set_source_rgb(*(c1, c2, c3)[i % 3])
            cr.arc(self.width / 2, self.height / 2, r, 0, 2 * math.pi)
            cr.fill()

if __name__ == '__main__':
    o1 = glitch.Translate(-0.25, 0, 0, children=[
        glitch.Rotate(20, 0, 1, 0, children=[
            glitch.ApplyTexture(Chequer(400, 400), children=[
                glitch.TexturedSquare()])])])
    o2 = glitch.Translate(0.25, 0, -0.5, children=[
        glitch.Rotate(20, 0, -1, 0, children=[
            glitch.ApplyTexture(Circles(400, 400), children=[
                glitch.TexturedSquare()])])])

    # XXX: Scene manually sorted farthest first.
    camera = glitch.glut.GLUTCamera(eye=[0, 0.75, 2.0], children=[
        Blend(children=[o2, o1])])
    camera.run()

