#############################################################################
##
#W  atlasprm.g           GAP 4 package AtlasRep                 Thomas Breuer
##
#Y  Copyright (C)  2001,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
##
##  This file is the primary file of the GAP interface for the
##  Atlas of Group Representations.
##  It contains the data that is needed to access the representations and
##  straight line programs.
##
##  This file is the only one in the AtlasRep package that must be changed
##  when new information is added to the database.
##


#############################################################################
##
##  Establish the bijection between the group names used in the filenames of
##  the ATLAS database and the names used to access the groups in GAP.
##

# names that are not really supported (but we want to avoid error messages)

# alternating and related groups
AGR.GNAN("A5","A5");
AGR.GNAN("A5.2","S5");
AGR.GNAN("2.A5","2A5");
AGR.GNAN("2.A5.2","2S5");
AGR.GNAN("Isoclinic(2.A5.2)","2S5i");
AGR.GNAN("A6","A6");
AGR.GNAN("2.A6","2A6");
AGR.GNAN("3.A6","3A6");
AGR.GNAN("6.A6","6A6");
AGR.GNAN("A6.2_1","S6");
AGR.GNAN("A6.2_2","PGL29");
AGR.GNAN("A6.2_3","M10");
AGR.GNAN("A6.2^2","A6V4");
AGR.GNAN("2.A6.2_1","2S6");
AGR.GNAN("3.A6.2_1","3S6");
AGR.GNAN("6.A6.2_1","6S6");
AGR.GNAN("A7","A7");
AGR.GNAN("A7.2","S7");
AGR.GNAN("2.A7","2A7");
AGR.GNAN("2.A7.2","2S7");
AGR.GNAN("Isoclinic(2.A7.2)","2S7i");
AGR.GNAN("3.A7","3A7");
AGR.GNAN("3.A7.2","3S7");
AGR.GNAN("6.A7","6A7");
AGR.GNAN("6.A7.2","6S7");
AGR.GNAN("A8","A8");
AGR.GNAN("A8.2","S8");
AGR.GNAN("2.A8","2A8");
AGR.GNAN("2.A8.2","2S8");
AGR.GNAN("Isoclinic(2.A8.2)","2S8i");
AGR.GNAN("A9","A9");
AGR.GNAN("A9.2","S9");
AGR.GNAN("2.A9","2A9");
AGR.GNAN("2.A9.2","2S9");
AGR.GNAN("A10","A10");
AGR.GNAN("A10.2","S10");
AGR.GNAN("2.A10","2A10");
AGR.GNAN("2.A10.2","2S10");
AGR.GNAN("A11","A11");
AGR.GNAN("A11.2","S11");
AGR.GNAN("2.A11","2A11");
AGR.GNAN("2.A11.2","2S11");
AGR.GNAN("A12","A12");
AGR.GNAN("A12.2","S12");
AGR.GNAN("2.A12","2A12");
AGR.GNAN("2.A12.2","2S12");
AGR.GNAN("A13","A13");
AGR.GNAN("A13.2","S13");
AGR.GNAN("2.A13","2A13");
AGR.GNAN("2.A13.2","2S13");
AGR.GNAN("A14","A14");
AGR.GNAN("A14.2","S14");
AGR.GNAN("2.A14","2A14");
AGR.GNAN("2.A14.2","2S14");
AGR.GNAN("Isoclinic(2.A14.2)","2S14i");
AGR.GNAN("A15","A15");
AGR.GNAN("A15.2","S15");
AGR.GNAN("A16","A16");
AGR.GNAN("A16.2","S16");
AGR.GNAN("A17","A17");
AGR.GNAN("A17.2","S17");
AGR.GNAN("A18","A18");
AGR.GNAN("A18.2","S18");
AGR.GNAN("A19","A19");
AGR.GNAN("A19.2","S19");
AGR.GNAN("A20","A20");
AGR.GNAN("A20.2","S20");
AGR.GNAN("A21","A21");
AGR.GNAN("A21.2","S21");
AGR.GNAN("A22","A22");
AGR.GNAN("A22.2","S22");
AGR.GNAN("A23","A23");
AGR.GNAN("A23.2","S23");
AGR.GNAN("M20","M20");
AGR.GNAN("2aM20","2aM20");
AGR.GNAN("2bM20","2bM20");
AGR.GNAN("2cM20","2cM20");
AGR.GNAN("4bM20","4bM20");

# symplectic and related groups
AGR.GNAN("S4(4)","S44");
AGR.GNAN("S4(4).2","S44d2");
AGR.GNAN("S4(4).4","S44d4");
AGR.GNAN("S4(5)","S45");
AGR.GNAN("S4(5).2","S45d2");
AGR.GNAN("2.S4(5)","2S45");
AGR.GNAN("S4(7)","S47");
AGR.GNAN("S4(7).2","S47d2");
AGR.GNAN("2.S4(7)","2S47");
AGR.GNAN("2.S4(7).2","2S47d2");
AGR.GNAN("S4(9)","S49");
AGR.GNAN("2.S4(9)","2S49");
AGR.GNAN("S4(11)","S411");
AGR.GNAN("2.S4(11)","2S411");
AGR.GNAN("S4(13)","S413");
AGR.GNAN("2.S4(13)","2S413");
AGR.GNAN("S4(17)","S417");
AGR.GNAN("2.S4(17)","2S417");
AGR.GNAN("S4(19)","S419");
AGR.GNAN("2.S4(19)","2S419");
AGR.GNAN("S6(2)","S62");
AGR.GNAN("2.S6(2)","2S62");
AGR.GNAN("S6(3)","S63");
AGR.GNAN("S6(3).2","S63d2");
AGR.GNAN("2.S6(3)","2S63");
AGR.GNAN("2.S6(3).2","2S63d2");
AGR.GNAN("S6(5)","S65");
AGR.GNAN("S8(2)","S82");
AGR.GNAN("S8(3)","S83");
AGR.GNAN("S10(2)","S102");

# orthogonal and related groups
AGR.GNAN("O7(3)","O73");
AGR.GNAN("O7(3).2","O73d2");
AGR.GNAN("2.O7(3)","2O73");
AGR.GNAN("2.O7(3).2","2O73d2");
AGR.GNAN("3.O7(3)","3O73");
AGR.GNAN("3.O7(3).2","3O73d2");
AGR.GNAN("6.O7(3)","6O73");
AGR.GNAN("6.O7(3).2","6O73d2");
AGR.GNAN("O8-(2)","O8m2");
AGR.GNAN("O8-(2).2","O8m2d2");
AGR.GNAN("O8+(2)","O8p2");
AGR.GNAN("O8+(2).2","O8p2d2");
AGR.GNAN("O8+(2).3","O8p2d3");
AGR.GNAN("2.O8+(2)","2O8p2");
AGR.GNAN("2.O8+(2).2","2O8p2d2");
AGR.GNAN("O8-(3)","O8m3");
AGR.GNAN("O8-(3).2_1","O8m3d2a");
AGR.GNAN("O8-(3).2_2","O8m3d2b");
AGR.GNAN("O8-(3).2_3","O8m3d2c");
AGR.GNAN("O8-(3).2^2","O8m3V4");
AGR.GNAN("O8-(3).D8","O8m3D8"); # a double cover of `O8-(3).2^2'
AGR.GNAN("2.O8-(3)","2O8m3");
AGR.GNAN("2.O8-(3).2_1","2O8m3d2a");
AGR.GNAN("O8+(3)","O8p3");
AGR.GNAN("O8+(3).S4","O8p3S4");
AGR.GNAN("2.O8+(3)","2O8p3");
AGR.GNAN("2^2.O8+(3).S4","4O8p3S4");
AGR.GNAN("O9(3)","O93");
AGR.GNAN("O9(3).2","O93d2");
AGR.GNAN("2.O9(3)","2O93");
AGR.GNAN("2.O9(3).2","2O93d2");
AGR.GNAN("O10-(2)","O10m2");
AGR.GNAN("O10-(2).2","O10m2d2");
AGR.GNAN("O10+(2)","O10p2");
AGR.GNAN("O10+(2).2","O10p2d2");

# projective special unitary and related groups
AGR.GNAN("U3(3)","U33");
AGR.GNAN("U3(3).2","U33d2");
AGR.GNAN("U3(4)","U34");
AGR.GNAN("U3(4).2","U34d2");
AGR.GNAN("U3(4).4","U34d4");
AGR.GNAN("U3(5)","U35");
AGR.GNAN("U3(5).2","U35d2");
AGR.GNAN("U3(5).3","U35d3");
AGR.GNAN("U3(7)","U37");
AGR.GNAN("U3(8)","U38");
AGR.GNAN("U3(8).2","U38d2");
AGR.GNAN("U3(8).3_1","U38d3a");
AGR.GNAN("U3(8).3_2","U38d3b");
AGR.GNAN("U3(8).3_3","U38d3c");
AGR.GNAN("U3(8).6","U38d6");
AGR.GNAN("U3(8).3^2","U38E9");
AGR.GNAN("U3(8).S3","U38S3");
AGR.GNAN("U3(8).(S3x3)","U38S3x3");
AGR.GNAN("3.U3(8)","3U38");
AGR.GNAN("U3(9)","U39");
AGR.GNAN("U3(11)","U311");
AGR.GNAN("U3(11).2","U311d2");
AGR.GNAN("3.U3(11)","3U311");
AGR.GNAN("3.U3(11).2","3U311d2");
AGR.GNAN("U3(13)","U313");
AGR.GNAN("U3(16)","U316");
AGR.GNAN("U4(2)","U42");
AGR.GNAN("U4(2).2","U42d2");
AGR.GNAN("2.U4(2)","2U42");
AGR.GNAN("2.U4(2).2","2U42d2");
AGR.GNAN("U4(3)","U43");
AGR.GNAN("U4(3).2_1","U43d21");
AGR.GNAN("U4(3).2_2","U43d22");
AGR.GNAN("U4(3).2_3","U43d23");
AGR.GNAN("U4(3).4","U43d4");
AGR.GNAN("U4(3).D8","U43D8");
AGR.GNAN("2.U4(3).D8","2U43D8");
AGR.GNAN("3^2.U4(3).D8","9U43D8");
AGR.GNAN("U4(4)","U44");
AGR.GNAN("U4(5)","U45");
AGR.GNAN("U5(2)","U52");
AGR.GNAN("U5(2).2","U52d2");
AGR.GNAN("U5(3)","U53");
AGR.GNAN("U5(4)","U54");
AGR.GNAN("U6(2)","U62");
AGR.GNAN("U6(2).2","U62d2");
AGR.GNAN("U6(2).3","U62d3");
AGR.GNAN("U6(2).S3","U62S3");
AGR.GNAN("2.U6(2)","2U62");
AGR.GNAN("3.U6(2)","3U62");
AGR.GNAN("6.U6(2)","6U62");
AGR.GNAN("2^2.U6(2)","4U62");
AGR.GNAN("(2^2x3).U6(2)","12U62");
AGR.GNAN("U6(3)","U63");
AGR.GNAN("U7(2)","U72");
AGR.GNAN("2^14.U7(2)","214U72");
AGR.GNAN("U8(2)","U82");

# exceptional and related groups
AGR.GNAN("E6(2)","E62");
AGR.GNAN("E6(4)","E64");
AGR.GNAN("E6(4).2","E64d2");
AGR.GNAN("3.E6(4)","3E64");
AGR.GNAN("3.E6(4).2","3E64d2");
AGR.GNAN("E7(2)","E72");
AGR.GNAN("E7(4)","E74");
AGR.GNAN("E8(2)","E82");
AGR.GNAN("E8(5)","E85");
AGR.GNAN("F4(2)","F42");
AGR.GNAN("F4(2).2","F42d2");
AGR.GNAN("2.F4(2)","2F42");
AGR.GNAN("2.F4(2).2","2F42d2");
AGR.GNAN("2.(2xF4(2)).2","2F42d4i");
AGR.GNAN("G2(3)","G23");
AGR.GNAN("G2(3).2","G23d2");
AGR.GNAN("3.G2(3)","3G23");
AGR.GNAN("3.G2(3).2","3G23d2");
AGR.GNAN("G2(4)","G24");
AGR.GNAN("G2(4).2","G24d2");
AGR.GNAN("2.G2(4)","2G24");
AGR.GNAN("2.G2(4).2","2G24d2");
AGR.GNAN("Isoclinic(2.G2(4).2)","2G24d2i");
AGR.GNAN("G2(5)","G25");
AGR.GNAN("R(27)","R27");
AGR.GNAN("R(27).3","R27d3");
AGR.GNAN("Sz(32)","Sz32");
AGR.GNAN("Sz(32).5","Sz32d5");
AGR.GNAN("Sz(8)","Sz8");
AGR.GNAN("Sz(8).3","Sz8d3");
AGR.GNAN("2.Sz(8)","2Sz8");
AGR.GNAN("2^2.Sz(8).3","4Sz8d3");

# twisted and related groups
AGR.GNAN("3D4(2)","TD42");
AGR.GNAN("3D4(2).3","TD42d3");
AGR.GNAN("3D4(3)","TD43");
AGR.GNAN("2E6(2)","TE62");
AGR.GNAN("2E6(2).2","TE62d2");
AGR.GNAN("2E6(2).3","TE62d3");
AGR.GNAN("2E6(2).S3","TE62S3");
AGR.GNAN("2.2E6(2)","2TE62");
AGR.GNAN("2.2E6(2).2","2TE62d2");
AGR.GNAN("2^2.2E6(2)","4TE62");
AGR.GNAN("3.2E6(2)","3TE62");
AGR.GNAN("3.2E6(2).2","3TE62d2");
AGR.GNAN("3.2E6(2).3","3TE62d3");
AGR.GNAN("3.2E6(2).S3","3TE62S3");
AGR.GNAN("2F4(2)'","TF42");
AGR.GNAN("2F4(2)'.2","TF42d2");

# projective special linear and related groups
AGR.GNAN("L2(8)","L28");
AGR.GNAN("L2(8).3","L28d3");
AGR.GNAN("L2(11)","L211");
AGR.GNAN("L2(11).2","L211d2");
AGR.GNAN("2.L2(11)","2L211");
AGR.GNAN("L2(13)","L213");
AGR.GNAN("L2(13).2","L213d2");
AGR.GNAN("2.L2(13)","2L213");
AGR.GNAN("2.L2(13).2","2L213d2");
AGR.GNAN("L2(16)","L216");
AGR.GNAN("L2(16).2","L216d2");
AGR.GNAN("L2(16).4","L216d4");
AGR.GNAN("L2(17)","L217");
AGR.GNAN("L2(17).2","L217d2");
AGR.GNAN("2.L2(17)","2L217");
AGR.GNAN("2.L2(17).2","2L217d2");
AGR.GNAN("L2(19)","L219");
AGR.GNAN("L2(19).2","L219d2");
AGR.GNAN("2.L2(19)","2L219");
AGR.GNAN("Isoclinic(2.L2(19).2)","2L219d2i");
AGR.GNAN("L2(23)","L223");
AGR.GNAN("L2(23).2","L223d2");
AGR.GNAN("2.L2(23)","2L223");
AGR.GNAN("Isoclinic(2.L2(23).2)","2L223d2i");
AGR.GNAN("L2(25)","L225");
AGR.GNAN("L2(25).2_1","L225d21");
AGR.GNAN("L2(25).2_2","L225d22");
AGR.GNAN("L2(25).2_3","L225d23");
AGR.GNAN("2.L2(25)","2L225");
AGR.GNAN("L2(27)","L227");
AGR.GNAN("L2(27).2","L227d2");
AGR.GNAN("L2(27).3","L227d3");
AGR.GNAN("L2(27).6","L227d6");
AGR.GNAN("2.L2(27)","2L227");
AGR.GNAN("L2(29)","L229");
AGR.GNAN("L2(29).2","L229d2");
AGR.GNAN("2.L2(29)","2L229");
AGR.GNAN("L2(31)","L231");
AGR.GNAN("L2(31).2","L231d2");
AGR.GNAN("2.L2(31)","2L231");
AGR.GNAN("L2(32)","L232");
AGR.GNAN("L2(32).5","L232d5");
AGR.GNAN("L2(37)","L237");
AGR.GNAN("2.L2(37)","2L237");
AGR.GNAN("L2(41)","L241");
AGR.GNAN("2.L2(41)","2L241");
AGR.GNAN("L2(43)","L243");
AGR.GNAN("2.L2(43)","2L243");
AGR.GNAN("L2(47)","L247");
AGR.GNAN("2.L2(47)","2L247");
AGR.GNAN("L2(49)","L249");
AGR.GNAN("2.L2(49)","2L249");
AGR.GNAN("L2(53)","L253");
AGR.GNAN("2.L2(53)","2L253");
AGR.GNAN("L2(59)","L259");
AGR.GNAN("2.L2(59)","2L259");
AGR.GNAN("L2(61)","L261");
AGR.GNAN("2.L2(61)","2L261");
AGR.GNAN("L2(64)","L264");
AGR.GNAN("L2(67)","L267");
AGR.GNAN("2.L2(67)","2L267");
AGR.GNAN("L2(71)","L271");
AGR.GNAN("2.L2(71)","2L271");
AGR.GNAN("L2(73)","L273");
AGR.GNAN("2.L2(73)","2L273");
AGR.GNAN("L2(79)","L279");
AGR.GNAN("2.L2(79)","2L279");
AGR.GNAN("L2(81)","L281");
AGR.GNAN("L2(83)","L283");
AGR.GNAN("2.L2(83)","2L283");
AGR.GNAN("L2(89)","L289");
AGR.GNAN("2.L2(89)","2L289");
AGR.GNAN("L2(97)","L297");
AGR.GNAN("2.L2(97)","2L297");
AGR.GNAN("L2(101)","L2101");
AGR.GNAN("2.L2(101)","2L2101");
AGR.GNAN("L2(103)","L2103");
AGR.GNAN("2.L2(103)","2L2103");
AGR.GNAN("L2(107)","L2107");
AGR.GNAN("2.L2(107)","2L2107");
AGR.GNAN("L2(109)","L2109");
AGR.GNAN("2.L2(109)","2L2109");
AGR.GNAN("L2(113)","L2113");
AGR.GNAN("2.L2(113)","2L2113");
AGR.GNAN("L2(127)","L2127");
AGR.GNAN("2.L2(127)","2L2127");
AGR.GNAN("2.L2(131)","2L2131");
AGR.GNAN("L2(128)","L2128");
AGR.GNAN("L2(131)","L2131");
AGR.GNAN("L2(137)","L2137");
AGR.GNAN("2.L2(137)","2L2137");
AGR.GNAN("L2(139)","L2139");
AGR.GNAN("2.L2(139)","2L2139");
AGR.GNAN("L2(149)","L2149");
AGR.GNAN("2.L2(149)","2L2149");
AGR.GNAN("L2(151)","L2151");
AGR.GNAN("2.L2(151)","2L2151");
AGR.GNAN("L2(157)","L2157");
AGR.GNAN("2.L2(157)","2L2157");
AGR.GNAN("L2(163)","L2163");
AGR.GNAN("2.L2(163)","2L2163");
AGR.GNAN("L2(167)","L2167");
AGR.GNAN("2.L2(167)","2L2167");
AGR.GNAN("L2(173)","L2173");
AGR.GNAN("2.L2(173)","2L2173");
AGR.GNAN("L2(179)","L2179");
AGR.GNAN("2.L2(179)","2L2179");
AGR.GNAN("L2(181)","L2181");
AGR.GNAN("2.L2(181)","2L2181");
AGR.GNAN("L2(191)","L2191");
AGR.GNAN("2.L2(191)","2L2191");
AGR.GNAN("L2(193)","L2193");
AGR.GNAN("2.L2(193)","2L2193");
AGR.GNAN("L2(197)","L2197");
AGR.GNAN("2.L2(197)","2L2197");
AGR.GNAN("L2(199)","L2199");
AGR.GNAN("2.L2(199)","2L2199");
AGR.GNAN("L2(211)","L2211");
AGR.GNAN("2.L2(211)","2L2211");
AGR.GNAN("L2(223)","L2223");
AGR.GNAN("2.L2(223)","2L2223");
AGR.GNAN("L2(227)","L2227");
AGR.GNAN("2.L2(227)","2L2227");
AGR.GNAN("L2(229)","L2229");
AGR.GNAN("2.L2(229)","2L2229");
AGR.GNAN("L2(233)","L2233");
AGR.GNAN("2.L2(233)","2L2233");
AGR.GNAN("L2(239)","L2239");
AGR.GNAN("2.L2(239)","2L2239");
AGR.GNAN("L2(241)","L2241");
AGR.GNAN("2.L2(241)","2L2241");
AGR.GNAN("L3(2)","L27");
AGR.GNAN("L3(2).2","L27d2");
AGR.GNAN("2.L3(2)","2L27");
AGR.GNAN("2.L3(2).2","2L27d2");
AGR.GNAN("Isoclinic(2.L3(2).2)","2L27d2i");
AGR.GNAN("L3(3)","L33");
AGR.GNAN("L3(3).2","L33d2");
AGR.GNAN("L3(4)","L34");
AGR.GNAN("L3(4).2_1","L34d2a");
AGR.GNAN("L3(4).2_2","L34d2b");
AGR.GNAN("L3(4).2_3","L34d2c");
AGR.GNAN("L3(4).3","L34d3");
AGR.GNAN("L3(4).6","L34d6");
AGR.GNAN("L3(4).2^2","L34V4");
AGR.GNAN("L3(4).D12","L34D12");
AGR.GNAN("2.L3(4)","2L34");
AGR.GNAN("2.L3(4).2_1","2L34d2a");
AGR.GNAN("3.L3(4)","3L34");
AGR.GNAN("3.L3(4).2_1","3L34d2a");
AGR.GNAN("2^2.L3(4)","4L34");
AGR.GNAN("2^2.L3(4).2_2","4L34d2b");
AGR.GNAN("4_1.L3(4)","4aL34");
AGR.GNAN("4_1.L3(4).2_1","4aL34d2a");
AGR.GNAN("4_2.L3(4)","4bL34");
AGR.GNAN("4_2.L3(4).2_1","4bL34d2a");
AGR.GNAN("6.L3(4)","6L34");
AGR.GNAN("6.L3(4).2_1","6L34d2a");
AGR.GNAN("12_1.L3(4)","12aL34");
AGR.GNAN("12_1.L3(4).2_1","12aL34d2a");
AGR.GNAN("12_2.L3(4)","12bL34");
AGR.GNAN("12_2.L3(4).2_1","12bL34d2a");
AGR.GNAN("L3(5)","L35");
AGR.GNAN("L3(5).2","L35d2");
AGR.GNAN("L3(7)","L37");
AGR.GNAN("L3(7).2","L37d2");
AGR.GNAN("L3(7).3","L37d3");
AGR.GNAN("3.L3(7)","3L37");
AGR.GNAN("3.L3(7).2","3L37d2");
AGR.GNAN("L3(8)","L38");
AGR.GNAN("L3(8).2","L38d2");
AGR.GNAN("L3(8).3","L38d3");
AGR.GNAN("L3(8).6","L38d6");
AGR.GNAN("L3(9)","L39");
AGR.GNAN("L3(9).2_1","L39d21");
AGR.GNAN("L3(9).2_2","L39d22");
AGR.GNAN("L3(9).2_3","L39d23");
AGR.GNAN("L3(11)","L311");
AGR.GNAN("L3(13)","L313");
AGR.GNAN("L4(3)","L43");
AGR.GNAN("L4(3).2_1","L43d21");
AGR.GNAN("L4(3).2_2","L43d22");
AGR.GNAN("L4(3).2_3","L43d23");
AGR.GNAN("L4(4)","L44");
AGR.GNAN("L4(5)","L45");
AGR.GNAN("L5(2)","L52");
AGR.GNAN("L5(2).2","L52d2");
AGR.GNAN("L5(3)","L53");
AGR.GNAN("L6(2)","L62");
AGR.GNAN("L6(2).2","L62d2");
AGR.GNAN("L7(2)","L72");
AGR.GNAN("L7(2).2","L72d2");
AGR.GNAN("2^4.A8","24A8");
AGR.GNAN("2^5.L5(2)","25L52");
AGR.GNAN("5^3.L3(5)","53L35");

# sporadic simple and related groups
AGR.GNAN("B","B");
AGR.GNAN("2.B","2B");
AGR.GNAN("Co1","Co1");
AGR.GNAN("2.Co1","2Co1");
AGR.GNAN("Co2","Co2");
AGR.GNAN("Co3","Co3");
AGR.GNAN("Fi22","F22");
AGR.GNAN("Fi22.2","F22d2");
AGR.GNAN("2.Fi22","2F22");
AGR.GNAN("2.Fi22.2","2F22d2");
AGR.GNAN("Isoclinic(2.Fi22.2)","2F22d2i");
AGR.GNAN("3.Fi22","3F22");
AGR.GNAN("3.Fi22.2","3F22d2");
AGR.GNAN("6.Fi22","6F22");
AGR.GNAN("6.Fi22.2","6F22d2");
AGR.GNAN("Isoclinic(6.Fi22.2)","6F22d2i");
AGR.GNAN("Fi23","F23");
AGR.GNAN("3.Fi24'","3F24");
AGR.GNAN("3.Fi24'.2","3F24d2");
AGR.GNAN("Fi24'","F24");
AGR.GNAN("Fi24'.2","F24d2");
AGR.GNAN("HN","HN");
AGR.GNAN("HN.2","HNd2");
AGR.GNAN("HS","HS");
AGR.GNAN("HS.2","HSd2");
AGR.GNAN("2.HS","2HS");
AGR.GNAN("2.HS.2","2HSd2");
AGR.GNAN("Isoclinic(2.HS.2)","2HSd2i");
AGR.GNAN("He","He");
AGR.GNAN("He.2","Hed2");
AGR.GNAN("J1","J1");
AGR.GNAN("J2","J2");
AGR.GNAN("J2.2","J2d2");
AGR.GNAN("2.J2","2J2");
AGR.GNAN("2.J2.2","2J2d2");
AGR.GNAN("Isoclinic(2.J2.2)","2J2d2i");
AGR.GNAN("J3","J3");
AGR.GNAN("J3.2","J3d2");
AGR.GNAN("3.J3","3J3");
AGR.GNAN("3.J3.2","3J3d2");
AGR.GNAN("J4","J4");
AGR.GNAN("Ly","Ly");
AGR.GNAN("M","M");
AGR.GNAN("M11","M11");
AGR.GNAN("M12","M12");
AGR.GNAN("M12.2","M12d2");
AGR.GNAN("2.M12","2M12");
AGR.GNAN("2.M12.2","2M12d2");
AGR.GNAN("Isoclinic(2.M12.2)","2M12d2i");
AGR.GNAN("M22","M22");
AGR.GNAN("M22.2","M22d2");
AGR.GNAN("2.M22","2M22");
AGR.GNAN("2.M22.2","2M22d2");
AGR.GNAN("Isoclinic(2.M22.2)","2M22d2i");
AGR.GNAN("3.M22","3M22");
AGR.GNAN("3.M22.2","3M22d2");
AGR.GNAN("4.M22","4M22");
AGR.GNAN("4.M22.2","4M22d2");
AGR.GNAN("Isoclinic(4.M22.2)","4M22d2i");
AGR.GNAN("6.M22","6M22");
AGR.GNAN("6.M22.2","6M22d2");
AGR.GNAN("Isoclinic(6.M22.2)","6M22d2i");
AGR.GNAN("12.M22","12M22");
AGR.GNAN("12.M22.2","12M22d2");
AGR.GNAN("Isoclinic(12.M22.2)","12M22d2i");
AGR.GNAN("M23","M23");
AGR.GNAN("M24","M24");
AGR.GNAN("McL","McL");
AGR.GNAN("McL.2","McLd2");
AGR.GNAN("3.McL","3McL");
AGR.GNAN("3.McL.2","3McLd2");
AGR.GNAN("ON","ON");
AGR.GNAN("ON.2","ONd2");
AGR.GNAN("ON.4","ONd4");
AGR.GNAN("3.ON","3ON");
AGR.GNAN("3.ON.2","3ONd2");
AGR.GNAN("Ru","Ru");
AGR.GNAN("2.Ru","2Ru");
AGR.GNAN("Suz","Suz");
AGR.GNAN("Suz.2","Suzd2");
AGR.GNAN("2.Suz","2Suz");
AGR.GNAN("2.Suz.2","2Suzd2");
AGR.GNAN("Isoclinic(2.Suz.2)","2Suzd2i");
AGR.GNAN("3.Suz","3Suz");
AGR.GNAN("3.Suz.2","3Suzd2");
AGR.GNAN("6.Suz","6Suz");
AGR.GNAN("6.Suz.2","6Suzd2");
AGR.GNAN("Isoclinic(6.Suz.2)","6Suzd2i");
AGR.GNAN("Th","Th");

# maximal subgroups of the Monster
AGR.GNAN("2^(1+24).Co1","Mmax2");
AGR.GNAN("2^2.2E6(2).S3","Mmax4");
AGR.GNAN("2^(10+16).O10+(2)","Mmax5");
AGR.GNAN("2^(2+11+22).(M24xS3)","Mmax6");
AGR.GNAN("3^(1+12):6.Suz.2","M3max7");
AGR.GNAN("3^(1+12):2.Suz.2","Mmax7");
AGR.GNAN("2^(5+10+20).(S3xL5(2))","Mmax8");
AGR.GNAN("S3xTh","Mmax9");
AGR.GNAN("2^[39].(L3(2)x3.S6)","Mmax10");
AGR.GNAN("3^8.O8-(3).2_3","Mmax11");
AGR.GNAN("(D10xHN).2","Mmax12");
AGR.GNAN("(3^2:2xO8+(3)).S4","Mmax13");
AGR.GNAN("3^(2+5+10).(M11x2S4)","Mmax14");
AGR.GNAN("3^(3+2+6+6):(L3(3)xSD16)","Mmax15");
AGR.GNAN("3^(2+6+6):(L3(3)xSD16)","Mmax15q1");
AGR.GNAN("3^(6+6):(L3(3)xSD16)","Mmax15q2");
AGR.GNAN("3^6:(L3(3)xSD16)","Mmax15q3");
AGR.GNAN("5^(1+6):2.J2.4","Mmax16");
AGR.GNAN("(7:3xHe):2","Mmax17");
AGR.GNAN("(A5xA12):2","Mmax18");
AGR.GNAN("5^(3+3).(2xL3(5))","Mmax19");
AGR.GNAN("(A6xA6xA6).(2xS4)","Mmax20");
AGR.GNAN("(A5xU3(8):3):2","Mmax21");
AGR.GNAN("5^(2+2+4):(S3xGL2(5))","Mmax22");
AGR.GNAN("(L3(2)xS4(4):2).2","Mmax23");
AGR.GNAN("7^(1+4):(3x2.S7)","Mmax24");
AGR.GNAN("(5^2:[2^4]xU3(5)).S3","Mmax25");
AGR.GNAN("(L2(11)xM12):2","Mmax26");
AGR.GNAN("(A7x(A5xA5).4).2","Mmax27");
AGR.GNAN("5^4:(3x2.L2(25)).2","Mmax28");
AGR.GNAN("7^(2+1+2):GL2(7)","Mmax29");
AGR.GNAN("M11xA6.2^2","Mmax30");
AGR.GNAN("(S5xS5xS5):S3","Mmax31");
AGR.GNAN("(L2(11)xL2(11)):4","Mmax32");
AGR.GNAN("13^2:2.L2(13).4","Mmax33");
AGR.GNAN("(7^2:(3x2A4)xL2(7)).2","Mmax34");
AGR.GNAN("(13:6xL3(3)).2","Mmax35");
AGR.GNAN("13^(1+2):(3x4S4)","Mmax36");
AGR.GNAN("11^2:(5x2A5)","Mmax39");
AGR.GNAN("7^2:2.L2(7)","Mmax41");
AGR.GNAN("41:40","Mmax43");

# miscellaneous groups
AGR.GNAN("W(F4)","WF4");


#############################################################################
##
##  Bind the list of names in display order.
##
AGR.SetGAPnamesSortDisp();


#############################################################################
##
##  Store group orders.
##
AGR.GRS("(13:6xL3(3)).2",876096);
AGR.GRS("(2^2x3).U6(2)",110361968640);
AGR.GRS("(3^2:2xO8+(3)).S4",2139341679820800);
AGR.GRS("(5^2:[2^4]xU3(5)).S3",302400000);
AGR.GRS("(7:3xHe):2",169276262400);
AGR.GRS("(7^2:(3x2A4)xL2(7)).2",1185408);
AGR.GRS("(A5xA12):2",28740096000);
AGR.GRS("(A5xU3(8):3):2",1985679360);
AGR.GRS("(A6xA6xA6).(2xS4)",2239488000);
AGR.GRS("(A7x(A5xA5).4).2",72576000);
AGR.GRS("(D10xHN).2",5460618240000000);
AGR.GRS("(L2(11)xL2(11)):4",1742400);
AGR.GRS("(L2(11)xM12):2",125452800);
AGR.GRS("(L3(2)xS4(4):2).2",658022400);
AGR.GRS("(S5xS5xS5):S3",10368000);
AGR.GRS("11^2:(5x2A5)",72600);
AGR.GRS("12.M22",5322240);
AGR.GRS("12.M22.2",10644480);
AGR.GRS("12_1.L3(4)",241920);
AGR.GRS("12_1.L3(4).2_1",483840);
AGR.GRS("12_2.L3(4)",241920);
AGR.GRS("12_2.L3(4).2_1",483840);
AGR.GRS("13^(1+2):(3x4S4)",632736);
AGR.GRS("13^2:2.L2(13).4",1476384);
AGR.GRS("2.(2xF4(2)).2",26489012826931200);
AGR.GRS("2.2E6(2)",153064959367549707878400);
AGR.GRS("2.2E6(2).2",306129918735099415756800);
AGR.GRS("2.A10",3628800);
AGR.GRS("2.A10.2",7257600);
AGR.GRS("2.A11",39916800);
AGR.GRS("2.A11.2",79833600);
AGR.GRS("2.A12",479001600);
AGR.GRS("2.A12.2",958003200);
AGR.GRS("2.A13",6227020800);
AGR.GRS("2.A13.2",12454041600);
AGR.GRS("2.A14",87178291200);
AGR.GRS("2.A14.2",174356582400);
AGR.GRS("2.A5",120);
AGR.GRS("2.A5.2",240);
AGR.GRS("2.A6",720);
AGR.GRS("2.A6.2_1",1440);
AGR.GRS("2.A7",5040);
AGR.GRS("2.A7.2",10080);
AGR.GRS("2.A8",40320);
AGR.GRS("2.A8.2",80640);
AGR.GRS("2.A9",362880);
AGR.GRS("2.A9.2",725760);
AGR.GRS("2.B",8309562962452852382355161088000000);
AGR.GRS("2.Co1",8315553613086720000);
AGR.GRS("2.F4(2)",6622253206732800);
AGR.GRS("2.F4(2).2",13244506413465600);
AGR.GRS("2.Fi22",129123503308800);
AGR.GRS("2.Fi22.2",258247006617600);
AGR.GRS("2.G2(4)",503193600);
AGR.GRS("2.G2(4).2",1006387200);
AGR.GRS("2.HS",88704000);
AGR.GRS("2.HS.2",177408000);
AGR.GRS("2.J2",1209600);
AGR.GRS("2.J2.2",2419200);
AGR.GRS("2.L2(101)",1030200);
AGR.GRS("2.L2(103)",1092624);
AGR.GRS("2.L2(107)",1224936);
AGR.GRS("2.L2(109)",1294920);
AGR.GRS("2.L2(11)",1320);
AGR.GRS("2.L2(113)",1442784);
AGR.GRS("2.L2(127)",2048256);
AGR.GRS("2.L2(13)",2184);
AGR.GRS("2.L2(13).2",4368);
AGR.GRS("2.L2(131)",2247960);
AGR.GRS("2.L2(137)",2571216);
AGR.GRS("2.L2(139)",2685480);
AGR.GRS("2.L2(149)",3307800);
AGR.GRS("2.L2(151)",3442800);
AGR.GRS("2.L2(157)",3869736);
AGR.GRS("2.L2(163)",4330584);
AGR.GRS("2.L2(167)",4657296);
AGR.GRS("2.L2(17)",4896);
AGR.GRS("2.L2(17).2",9792);
AGR.GRS("2.L2(173)",5177544);
AGR.GRS("2.L2(179)",5735160);
AGR.GRS("2.L2(181)",5929560);
AGR.GRS("2.L2(19)",6840);
AGR.GRS("2.L2(191)",6967680);
AGR.GRS("2.L2(193)",7188864);
AGR.GRS("2.L2(197)",7645176);
AGR.GRS("2.L2(199)",7880400);
AGR.GRS("2.L2(211)",9393720);
AGR.GRS("2.L2(223)",11089344);
AGR.GRS("2.L2(227)",11696856);
AGR.GRS("2.L2(229)",12008760);
AGR.GRS("2.L2(23)",12144);
AGR.GRS("2.L2(233)",12649104);
AGR.GRS("2.L2(239)",13651680);
AGR.GRS("2.L2(241)",13997280);
AGR.GRS("2.L2(25)",15600);
AGR.GRS("2.L2(27)",19656);
AGR.GRS("2.L2(29)",24360);
AGR.GRS("2.L2(31)",29760);
AGR.GRS("2.L2(37)",50616);
AGR.GRS("2.L2(41)",68880);
AGR.GRS("2.L2(43)",79464);
AGR.GRS("2.L2(47)",103776);
AGR.GRS("2.L2(49)",117600);
AGR.GRS("2.L2(53)",148824);
AGR.GRS("2.L2(59)",205320);
AGR.GRS("2.L2(61)",226920);
AGR.GRS("2.L2(67)",300696);
AGR.GRS("2.L2(71)",357840);
AGR.GRS("2.L2(73)",388944);
AGR.GRS("2.L2(79)",492960);
AGR.GRS("2.L2(83)",571704);
AGR.GRS("2.L2(89)",704880);
AGR.GRS("2.L2(97)",912576);
AGR.GRS("2.L3(2)",336);
AGR.GRS("2.L3(2).2",672);
AGR.GRS("2.L3(4)",40320);
AGR.GRS("2.L3(4).2_1",80640);
AGR.GRS("2.M12",190080);
AGR.GRS("2.M12.2",380160);
AGR.GRS("2.M22",887040);
AGR.GRS("2.M22.2",1774080);
AGR.GRS("2.O7(3)",9170703360);
AGR.GRS("2.O7(3).2",18341406720);
AGR.GRS("2.O8+(2)",348364800);
AGR.GRS("2.O8+(2).2",696729600);
AGR.GRS("2.O8+(3)",9904359628800);
AGR.GRS("2.O8-(3)",20303937239040);
AGR.GRS("2.O8-(3).2_1",40607874478080);
AGR.GRS("2.O9(3)",131569513308979200);
AGR.GRS("2.O9(3).2",263139026617958400);
AGR.GRS("2.Ru",291852288000);
AGR.GRS("2.S4(11)",25721308800);
AGR.GRS("2.S4(13)",137037962880);
AGR.GRS("2.S4(17)",2008994088960);
AGR.GRS("2.S4(19)",6114035779200);
AGR.GRS("2.S4(5)",9360000);
AGR.GRS("2.S4(7)",276595200);
AGR.GRS("2.S4(7).2",553190400);
AGR.GRS("2.S4(9)",3443212800);
AGR.GRS("2.S6(2)",2903040);
AGR.GRS("2.S6(3)",9170703360);
AGR.GRS("2.S6(3).2",18341406720);
AGR.GRS("2.Suz",896690995200);
AGR.GRS("2.Suz.2",1793381990400);
AGR.GRS("2.Sz(8)",58240);
AGR.GRS("2.U4(2)",51840);
AGR.GRS("2.U4(2).2",103680);
AGR.GRS("2.U4(3).D8",52254720);
AGR.GRS("2.U6(2)",18393661440);
AGR.GRS("2E6(2)",76532479683774853939200);
AGR.GRS("2E6(2).2",153064959367549707878400);
AGR.GRS("2E6(2).3",229597439051324561817600);
AGR.GRS("2E6(2).S3",459194878102649123635200);
AGR.GRS("2F4(2)'",17971200);
AGR.GRS("2F4(2)'.2",35942400);
AGR.GRS("2^(1+24).Co1",139511839126336328171520000);
AGR.GRS("2^(10+16).O10+(2)",1577011055923770163200);
AGR.GRS("2^(2+11+22).(M24xS3)",50472333605150392320);
AGR.GRS("2^(5+10+20).(S3xL5(2))",2061452360684666880);
AGR.GRS("2^14.U7(2)",3732063900024176640);
AGR.GRS("2^2.2E6(2)",306129918735099415756800);
AGR.GRS("2^2.2E6(2).S3",1836779512410596494540800);
AGR.GRS("2^2.L3(4)",80640);
AGR.GRS("2^2.L3(4).2_2",161280);
AGR.GRS("2^2.O8+(3).S4",475409262182400);
AGR.GRS("2^2.Sz(8).3",349440);
AGR.GRS("2^2.U6(2)",36787322880);
AGR.GRS("2^4.A8",322560);
AGR.GRS("2^5.L5(2)",319979520);
AGR.GRS("2^[39].(L3(2)x3.S6)",199495389743677440);
AGR.GRS("2aM20",1920);
AGR.GRS("2bM20",1920);
AGR.GRS("2cM20",1920);
AGR.GRS("3.2E6(2)",229597439051324561817600);
AGR.GRS("3.2E6(2).2",459194878102649123635200);
AGR.GRS("3.2E6(2).3",688792317153973685452800);
AGR.GRS("3.2E6(2).S3",1377584634307947370905600);
AGR.GRS("3.A6",1080);
AGR.GRS("3.A6.2_1",2160);
AGR.GRS("3.A7",7560);
AGR.GRS("3.A7.2",15120);
AGR.GRS("3.E6(4)",85528710781342640103833619055142765466746880000);
AGR.GRS("3.E6(4).2",171057421562685280207667238110285530933493760000);
AGR.GRS("3.Fi22",193685254963200);
AGR.GRS("3.Fi22.2",387370509926400);
AGR.GRS("3.Fi24'",3765617127571985163878400);
AGR.GRS("3.Fi24'.2",7531234255143970327756800);
AGR.GRS("3.G2(3)",12737088);
AGR.GRS("3.G2(3).2",25474176);
AGR.GRS("3.J3",150698880);
AGR.GRS("3.J3.2",301397760);
AGR.GRS("3.L3(4)",60480);
AGR.GRS("3.L3(4).2_1",120960);
AGR.GRS("3.L3(7)",5630688);
AGR.GRS("3.L3(7).2",11261376);
AGR.GRS("3.M22",1330560);
AGR.GRS("3.M22.2",2661120);
AGR.GRS("3.McL",2694384000);
AGR.GRS("3.McL.2",5388768000);
AGR.GRS("3.O7(3)",13756055040);
AGR.GRS("3.O7(3).2",27512110080);
AGR.GRS("3.ON",1382446517760);
AGR.GRS("3.ON.2",2764893035520);
AGR.GRS("3.Suz",1345036492800);
AGR.GRS("3.Suz.2",2690072985600);
AGR.GRS("3.U3(11)",212747040);
AGR.GRS("3.U3(11).2",425494080);
AGR.GRS("3.U3(8)",16547328);
AGR.GRS("3.U6(2)",27590492160);
AGR.GRS("3D4(2)",211341312);
AGR.GRS("3D4(2).3",634023936);
AGR.GRS("3D4(3)",20560831566912);
AGR.GRS("3^(1+12):2.Suz.2",2859230155080499200);
AGR.GRS("3^(1+12):6.Suz.2",8577690465241497600);
AGR.GRS("3^(2+5+10).(M11x2S4)",49093924366080);
AGR.GRS("3^(2+6+6):(L3(3)xSD16)",429778462464);
AGR.GRS("3^(3+2+6+6):(L3(3)xSD16)",11604018486528);
AGR.GRS("3^(6+6):(L3(3)xSD16)",47753162496);
AGR.GRS("3^2.U4(3).D8",235146240);
AGR.GRS("3^6:(L3(3)xSD16)",65505024);
AGR.GRS("3^8.O8-(3).2_3",133214132225341440);
AGR.GRS("4.M22",1774080);
AGR.GRS("4.M22.2",3548160);
AGR.GRS("41:40",1640);
AGR.GRS("4_1.L3(4)",80640);
AGR.GRS("4_1.L3(4).2_1",161280);
AGR.GRS("4_2.L3(4)",80640);
AGR.GRS("4_2.L3(4).2_1",161280);
AGR.GRS("4bM20",3840);
AGR.GRS("5^(1+6):2.J2.4",378000000000);
AGR.GRS("5^(2+2+4):(S3xGL2(5))",1125000000);
AGR.GRS("5^(3+3).(2xL3(5))",11625000000);
AGR.GRS("5^3.L3(5)",46500000);
AGR.GRS("5^4:(3x2.L2(25)).2",58500000);
AGR.GRS("6.A6",2160);
AGR.GRS("6.A6.2_1",4320);
AGR.GRS("6.A7",15120);
AGR.GRS("6.A7.2",30240);
AGR.GRS("6.Fi22",387370509926400);
AGR.GRS("6.Fi22.2",774741019852800);
AGR.GRS("6.L3(4)",120960);
AGR.GRS("6.L3(4).2_1",241920);
AGR.GRS("6.M22",2661120);
AGR.GRS("6.M22.2",5322240);
AGR.GRS("6.O7(3)",27512110080);
AGR.GRS("6.O7(3).2",55024220160);
AGR.GRS("6.Suz",2690072985600);
AGR.GRS("6.Suz.2",5380145971200);
AGR.GRS("6.U6(2)",55180984320);
AGR.GRS("7^(1+4):(3x2.S7)",508243680);
AGR.GRS("7^(2+1+2):GL2(7)",33882912);
AGR.GRS("7^2:2.L2(7)",16464);
AGR.GRS("A10",1814400);
AGR.GRS("A10.2",3628800);
AGR.GRS("A11",19958400);
AGR.GRS("A11.2",39916800);
AGR.GRS("A12",239500800);
AGR.GRS("A12.2",479001600);
AGR.GRS("A13",3113510400);
AGR.GRS("A13.2",6227020800);
AGR.GRS("A14",43589145600);
AGR.GRS("A14.2",87178291200);
AGR.GRS("A15",653837184000);
AGR.GRS("A15.2",1307674368000);
AGR.GRS("A16",10461394944000);
AGR.GRS("A16.2",20922789888000);
AGR.GRS("A17",177843714048000);
AGR.GRS("A17.2",355687428096000);
AGR.GRS("A18",3201186852864000);
AGR.GRS("A18.2",6402373705728000);
AGR.GRS("A19",60822550204416000);
AGR.GRS("A19.2",121645100408832000);
AGR.GRS("A20",1216451004088320000);
AGR.GRS("A20.2",2432902008176640000);
AGR.GRS("A21",25545471085854720000);
AGR.GRS("A21.2",51090942171709440000);
AGR.GRS("A22",562000363888803840000);
AGR.GRS("A22.2",1124000727777607680000);
AGR.GRS("A23",12926008369442488320000);
AGR.GRS("A23.2",25852016738884976640000);
AGR.GRS("A5",60);
AGR.GRS("A5.2",120);
AGR.GRS("A6",360);
AGR.GRS("A6.2^2",1440);
AGR.GRS("A6.2_1",720);
AGR.GRS("A6.2_2",720);
AGR.GRS("A6.2_3",720);
AGR.GRS("A7",2520);
AGR.GRS("A7.2",5040);
AGR.GRS("A8",20160);
AGR.GRS("A8.2",40320);
AGR.GRS("A9",181440);
AGR.GRS("A9.2",362880);
AGR.GRS("B",4154781481226426191177580544000000);
AGR.GRS("Co1",4157776806543360000);
AGR.GRS("Co2",42305421312000);
AGR.GRS("Co3",495766656000);
AGR.GRS("E6(2)",214841575522005575270400);
AGR.GRS("E6(4)",28509570260447546701277873018380921822248960000);
AGR.GRS("E6(4).2",57019140520895093402555746036761843644497920000);
AGR.GRS("E7(2)",337804753143634806261388190614085595079991692242467651576160959909068800000);
AGR.GRS("E7(4)",191797292142671717754639757897512906421357507604216557533558287598236977154127870984484770345340348298409697395609822849492217656441474908160000000000);
AGR.GRS("E8(2)",337804753143634806261388190614085595079991692242467651576160959909068800000);
AGR.GRS("E8(5)",212241934165081789939135106539938909320143178249948373703932419194549992287718687106371625640393677463164945340423628294956870377063751220703125000000000000000000000000000000);
AGR.GRS("F4(2)",3311126603366400);
AGR.GRS("F4(2).2",6622253206732800);
AGR.GRS("Fi22",64561751654400);
AGR.GRS("Fi22.2",129123503308800);
AGR.GRS("Fi23",4089470473293004800);
AGR.GRS("Fi24'",1255205709190661721292800);
AGR.GRS("Fi24'.2",2510411418381323442585600);
AGR.GRS("G2(3)",4245696);
AGR.GRS("G2(3).2",8491392);
AGR.GRS("G2(4)",251596800);
AGR.GRS("G2(4).2",503193600);
AGR.GRS("G2(5)",5859000000);
AGR.GRS("HN",273030912000000);
AGR.GRS("HN.2",546061824000000);
AGR.GRS("HS",44352000);
AGR.GRS("HS.2",88704000);
AGR.GRS("He",4030387200);
AGR.GRS("He.2",8060774400);
AGR.GRS("Isoclinic(12.M22.2)",10644480);
AGR.GRS("Isoclinic(2.A14.2)",174356582400);
AGR.GRS("Isoclinic(2.A5.2)",240);
AGR.GRS("Isoclinic(2.A7.2)",10080);
AGR.GRS("Isoclinic(2.A8.2)",80640);
AGR.GRS("Isoclinic(2.Fi22.2)",258247006617600);
AGR.GRS("Isoclinic(2.G2(4).2)",1006387200);
AGR.GRS("Isoclinic(2.HS.2)",177408000);
AGR.GRS("Isoclinic(2.J2.2)",2419200);
AGR.GRS("Isoclinic(2.L2(19).2)",13680);
AGR.GRS("Isoclinic(2.L2(23).2)",24288);
AGR.GRS("Isoclinic(2.L3(2).2)",672);
AGR.GRS("Isoclinic(2.M12.2)",380160);
AGR.GRS("Isoclinic(2.M22.2)",1774080);
AGR.GRS("Isoclinic(2.Suz.2)",1793381990400);
AGR.GRS("Isoclinic(4.M22.2)",3548160);
AGR.GRS("Isoclinic(6.Fi22.2)",774741019852800);
AGR.GRS("Isoclinic(6.M22.2)",5322240);
AGR.GRS("Isoclinic(6.Suz.2)",5380145971200);
AGR.GRS("J1",175560);
AGR.GRS("J2",604800);
AGR.GRS("J2.2",1209600);
AGR.GRS("J3",50232960);
AGR.GRS("J3.2",100465920);
AGR.GRS("J4",86775571046077562880);
AGR.GRS("L2(101)",515100);
AGR.GRS("L2(103)",546312);
AGR.GRS("L2(107)",612468);
AGR.GRS("L2(109)",647460);
AGR.GRS("L2(11)",660);
AGR.GRS("L2(11).2",1320);
AGR.GRS("L2(113)",721392);
AGR.GRS("L2(127)",1024128);
AGR.GRS("L2(128)",2097024);
AGR.GRS("L2(13)",1092);
AGR.GRS("L2(13).2",2184);
AGR.GRS("L2(131)",1123980);
AGR.GRS("L2(137)",1285608);
AGR.GRS("L2(139)",1342740);
AGR.GRS("L2(149)",1653900);
AGR.GRS("L2(151)",1721400);
AGR.GRS("L2(157)",1934868);
AGR.GRS("L2(16)",4080);
AGR.GRS("L2(16).2",8160);
AGR.GRS("L2(16).4",16320);
AGR.GRS("L2(163)",2165292);
AGR.GRS("L2(167)",2328648);
AGR.GRS("L2(17)",2448);
AGR.GRS("L2(17).2",4896);
AGR.GRS("L2(173)",2588772);
AGR.GRS("L2(179)",2867580);
AGR.GRS("L2(181)",2964780);
AGR.GRS("L2(19)",3420);
AGR.GRS("L2(19).2",6840);
AGR.GRS("L2(191)",3483840);
AGR.GRS("L2(193)",3594432);
AGR.GRS("L2(197)",3822588);
AGR.GRS("L2(199)",3940200);
AGR.GRS("L2(211)",4696860);
AGR.GRS("L2(223)",5544672);
AGR.GRS("L2(227)",5848428);
AGR.GRS("L2(229)",6004380);
AGR.GRS("L2(23)",6072);
AGR.GRS("L2(23).2",12144);
AGR.GRS("L2(233)",6324552);
AGR.GRS("L2(239)",6825840);
AGR.GRS("L2(241)",6998640);
AGR.GRS("L2(25)",7800);
AGR.GRS("L2(25).2_1",15600);
AGR.GRS("L2(25).2_2",15600);
AGR.GRS("L2(25).2_3",15600);
AGR.GRS("L2(27)",9828);
AGR.GRS("L2(27).2",19656);
AGR.GRS("L2(27).3",29484);
AGR.GRS("L2(27).6",58968);
AGR.GRS("L2(29)",12180);
AGR.GRS("L2(29).2",24360);
AGR.GRS("L2(31)",14880);
AGR.GRS("L2(31).2",29760);
AGR.GRS("L2(32)",32736);
AGR.GRS("L2(32).5",163680);
AGR.GRS("L2(37)",25308);
AGR.GRS("L2(41)",34440);
AGR.GRS("L2(43)",39732);
AGR.GRS("L2(47)",51888);
AGR.GRS("L2(49)",58800);
AGR.GRS("L2(53)",74412);
AGR.GRS("L2(59)",102660);
AGR.GRS("L2(61)",113460);
AGR.GRS("L2(64)",262080);
AGR.GRS("L2(67)",150348);
AGR.GRS("L2(71)",178920);
AGR.GRS("L2(73)",194472);
AGR.GRS("L2(79)",246480);
AGR.GRS("L2(8)",504);
AGR.GRS("L2(8).3",1512);
AGR.GRS("L2(81)",265680);
AGR.GRS("L2(83)",285852);
AGR.GRS("L2(89)",352440);
AGR.GRS("L2(97)",456288);
AGR.GRS("L3(11)",212427600);
AGR.GRS("L3(13)",270178272);
AGR.GRS("L3(2)",168);
AGR.GRS("L3(2).2",336);
AGR.GRS("L3(3)",5616);
AGR.GRS("L3(3).2",11232);
AGR.GRS("L3(4)",20160);
AGR.GRS("L3(4).2^2",80640);
AGR.GRS("L3(4).2_1",40320);
AGR.GRS("L3(4).2_2",40320);
AGR.GRS("L3(4).2_3",40320);
AGR.GRS("L3(4).3",60480);
AGR.GRS("L3(4).6",120960);
AGR.GRS("L3(4).D12",241920);
AGR.GRS("L3(5)",372000);
AGR.GRS("L3(5).2",744000);
AGR.GRS("L3(7)",1876896);
AGR.GRS("L3(7).2",3753792);
AGR.GRS("L3(7).3",5630688);
AGR.GRS("L3(8)",16482816);
AGR.GRS("L3(8).2",32965632);
AGR.GRS("L3(8).3",49448448);
AGR.GRS("L3(8).6",98896896);
AGR.GRS("L3(9)",42456960);
AGR.GRS("L3(9).2_1",84913920);
AGR.GRS("L3(9).2_2",84913920);
AGR.GRS("L3(9).2_3",84913920);
AGR.GRS("L4(3)",6065280);
AGR.GRS("L4(3).2_1",12130560);
AGR.GRS("L4(3).2_2",12130560);
AGR.GRS("L4(3).2_3",12130560);
AGR.GRS("L4(4)",987033600);
AGR.GRS("L4(5)",7254000000);
AGR.GRS("L5(2)",9999360);
AGR.GRS("L5(2).2",19998720);
AGR.GRS("L5(3)",237783237120);
AGR.GRS("L6(2)",20158709760);
AGR.GRS("L6(2).2",40317419520);
AGR.GRS("L7(2)",163849992929280);
AGR.GRS("L7(2).2",327699985858560);
AGR.GRS("Ly",51765179004000000);
AGR.GRS("M",808017424794512875886459904961710757005754368000000000);
AGR.GRS("M11",7920);
AGR.GRS("M11xA6.2^2",11404800);
AGR.GRS("M12",95040);
AGR.GRS("M12.2",190080);
AGR.GRS("M20",960);
AGR.GRS("M22",443520);
AGR.GRS("M22.2",887040);
AGR.GRS("M23",10200960);
AGR.GRS("M24",244823040);
AGR.GRS("McL",898128000);
AGR.GRS("McL.2",1796256000);
AGR.GRS("O10+(2)",23499295948800);
AGR.GRS("O10+(2).2",46998591897600);
AGR.GRS("O10-(2)",25015379558400);
AGR.GRS("O10-(2).2",50030759116800);
AGR.GRS("O7(3)",4585351680);
AGR.GRS("O7(3).2",9170703360);
AGR.GRS("O8+(2)",174182400);
AGR.GRS("O8+(2).2",348364800);
AGR.GRS("O8+(2).3",522547200);
AGR.GRS("O8+(3)",4952179814400);
AGR.GRS("O8+(3).S4",118852315545600);
AGR.GRS("O8-(2)",197406720);
AGR.GRS("O8-(2).2",394813440);
AGR.GRS("O8-(3)",10151968619520);
AGR.GRS("O8-(3).2^2",40607874478080);
AGR.GRS("O8-(3).2_1",20303937239040);
AGR.GRS("O8-(3).2_2",20303937239040);
AGR.GRS("O8-(3).2_3",20303937239040);
AGR.GRS("O8-(3).D8",81215748956160);
AGR.GRS("O9(3)",65784756654489600);
AGR.GRS("O9(3).2",131569513308979200);
AGR.GRS("ON",460815505920);
AGR.GRS("ON.2",921631011840);
AGR.GRS("ON.4",1843262023680);
AGR.GRS("R(27)",10073444472);
AGR.GRS("R(27).3",30220333416);
AGR.GRS("Ru",145926144000);
AGR.GRS("S10(2)",24815256521932800);
AGR.GRS("S3xTh",544475663327232000);
AGR.GRS("S4(11)",12860654400);
AGR.GRS("S4(13)",68518981440);
AGR.GRS("S4(17)",1004497044480);
AGR.GRS("S4(19)",3057017889600);
AGR.GRS("S4(4)",979200);
AGR.GRS("S4(4).2",1958400);
AGR.GRS("S4(4).4",3916800);
AGR.GRS("S4(5)",4680000);
AGR.GRS("S4(5).2",9360000);
AGR.GRS("S4(7)",138297600);
AGR.GRS("S4(7).2",276595200);
AGR.GRS("S4(9)",1721606400);
AGR.GRS("S6(2)",1451520);
AGR.GRS("S6(3)",4585351680);
AGR.GRS("S6(3).2",9170703360);
AGR.GRS("S6(5)",228501000000000);
AGR.GRS("S8(2)",47377612800);
AGR.GRS("S8(3)",65784756654489600);
AGR.GRS("Suz",448345497600);
AGR.GRS("Suz.2",896690995200);
AGR.GRS("Sz(32)",32537600);
AGR.GRS("Sz(32).5",162688000);
AGR.GRS("Sz(8)",29120);
AGR.GRS("Sz(8).3",87360);
AGR.GRS("Th",90745943887872000);
AGR.GRS("U3(11)",70915680);
AGR.GRS("U3(11).2",141831360);
AGR.GRS("U3(13)",811273008);
AGR.GRS("U3(16)",4279234560);
AGR.GRS("U3(3)",6048);
AGR.GRS("U3(3).2",12096);
AGR.GRS("U3(4)",62400);
AGR.GRS("U3(4).2",124800);
AGR.GRS("U3(4).4",249600);
AGR.GRS("U3(5)",126000);
AGR.GRS("U3(5).2",252000);
AGR.GRS("U3(5).3",378000);
AGR.GRS("U3(7)",5663616);
AGR.GRS("U3(8)",5515776);
AGR.GRS("U3(8).(S3x3)",99283968);
AGR.GRS("U3(8).2",11031552);
AGR.GRS("U3(8).3^2",49641984);
AGR.GRS("U3(8).3_1",16547328);
AGR.GRS("U3(8).3_2",16547328);
AGR.GRS("U3(8).3_3",16547328);
AGR.GRS("U3(8).6",33094656);
AGR.GRS("U3(8).S3",33094656);
AGR.GRS("U3(9)",42573600);
AGR.GRS("U4(2)",25920);
AGR.GRS("U4(2).2",51840);
AGR.GRS("U4(3)",3265920);
AGR.GRS("U4(3).2_1",6531840);
AGR.GRS("U4(3).2_2",6531840);
AGR.GRS("U4(3).2_3",6531840);
AGR.GRS("U4(3).4",13063680);
AGR.GRS("U4(3).D8",26127360);
AGR.GRS("U4(4)",1018368000);
AGR.GRS("U4(5)",14742000000);
AGR.GRS("U5(2)",13685760);
AGR.GRS("U5(2).2",27371520);
AGR.GRS("U5(3)",258190571520);
AGR.GRS("U5(4)",53443952640000);
AGR.GRS("U6(2)",9196830720);
AGR.GRS("U6(2).2",18393661440);
AGR.GRS("U6(2).3",27590492160);
AGR.GRS("U6(2).S3",55180984320);
AGR.GRS("U6(3)",22837472432087040);
AGR.GRS("U7(2)",227787103272960);
AGR.GRS("U8(2)",7434971050829414400);
AGR.GRS("W(F4)",1152);


#############################################################################
##
##  Store numbers of classes of maximal subgroups.
##
AGR.MXN("(2^2x3).U6(2)",16);
AGR.MXN("12.M22",8);
AGR.MXN("12.M22.2",7);
AGR.MXN("12_1.L3(4)",9);
AGR.MXN("12_1.L3(4).2_1",10);
AGR.MXN("12_2.L3(4)",9);
AGR.MXN("12_2.L3(4).2_1",10);
AGR.MXN("2.A10",7);
AGR.MXN("2.A10.2",8);
AGR.MXN("2.A11",7);
AGR.MXN("2.A11.2",7);
AGR.MXN("2.A12",11);
AGR.MXN("2.A12.2",11);
AGR.MXN("2.A13",9);
AGR.MXN("2.A13.2",8);
AGR.MXN("2.A5",3);
AGR.MXN("2.A5.2",4);
AGR.MXN("2.A6",5);
AGR.MXN("2.A6.2_1",6);
AGR.MXN("2.A7",5);
AGR.MXN("2.A7.2",5);
AGR.MXN("2.A8",6);
AGR.MXN("2.A8.2",7);
AGR.MXN("2.A9",8);
AGR.MXN("2.A9.2",7);
AGR.MXN("2.B",30);
AGR.MXN("2.Co1",22);
AGR.MXN("2.Fi22",14);
AGR.MXN("2.Fi22.2",13);
AGR.MXN("2.G2(4)",8);
AGR.MXN("2.HS",12);
AGR.MXN("2.HS.2",10);
AGR.MXN("2.J2",9);
AGR.MXN("2.J2.2",10);
AGR.MXN("2.L2(11)",4);
AGR.MXN("2.L2(13)",4);
AGR.MXN("2.L2(13).2",5);
AGR.MXN("2.L2(17)",5);
AGR.MXN("2.L2(19)",5);
AGR.MXN("2.L2(23)",5);
AGR.MXN("2.L2(25)",5);
AGR.MXN("2.L2(27)",4);
AGR.MXN("2.L2(29)",5);
AGR.MXN("2.L2(31)",7);
AGR.MXN("2.L2(49)",7);
AGR.MXN("2.L3(2)",3);
AGR.MXN("2.L3(2).2",4);
AGR.MXN("2.L3(4)",9);
AGR.MXN("2.L3(4).2_1",10);
AGR.MXN("2.M12",11);
AGR.MXN("2.M12.2",9);
AGR.MXN("2.M22",8);
AGR.MXN("2.M22.2",7);
AGR.MXN("2.O7(3)",15);
AGR.MXN("2.O8+(2)",17);
AGR.MXN("2.O8+(3)",27);
AGR.MXN("2.Ru",15);
AGR.MXN("2.S4(5)",8);
AGR.MXN("2.S6(2)",8);
AGR.MXN("2.S6(3)",11);
AGR.MXN("2.Suz",17);
AGR.MXN("2.Suz.2",16);
AGR.MXN("2.Sz(8)",4);
AGR.MXN("2.U4(2)",5);
AGR.MXN("2.U4(2).2",6);
AGR.MXN("2.U6(2)",16);
AGR.MXN("2F4(2)'",8);
AGR.MXN("2F4(2)'.2",7);
AGR.MXN("2^2.L3(4)",9);
AGR.MXN("2^2.L3(4).2_2",6);
AGR.MXN("2^2.Sz(8).3",5);
AGR.MXN("2^2.U6(2)",16);
AGR.MXN("3.A6",5);
AGR.MXN("3.A6.2_1",6);
AGR.MXN("3.A7",5);
AGR.MXN("3.A7.2",5);
AGR.MXN("3.Fi22",14);
AGR.MXN("3.Fi22.2",13);
AGR.MXN("3.Fi24'",25);
AGR.MXN("3.Fi24'.2",21);
AGR.MXN("3.G2(3)",10);
AGR.MXN("3.G2(3).2",6);
AGR.MXN("3.J3",9);
AGR.MXN("3.J3.2",9);
AGR.MXN("3.L3(4)",9);
AGR.MXN("3.L3(4).2_1",10);
AGR.MXN("3.L3(7)",8);
AGR.MXN("3.M22",8);
AGR.MXN("3.M22.2",7);
AGR.MXN("3.McL",12);
AGR.MXN("3.McL.2",10);
AGR.MXN("3.O7(3)",15);
AGR.MXN("3.ON",13);
AGR.MXN("3.ON.2",10);
AGR.MXN("3.Suz",17);
AGR.MXN("3.Suz.2",16);
AGR.MXN("3.U3(11)",11);
AGR.MXN("3.U3(8)",7);
AGR.MXN("3.U6(2)",16);
AGR.MXN("3D4(2)",9);
AGR.MXN("4.M22",8);
AGR.MXN("4.M22.2",7);
AGR.MXN("4_1.L3(4)",9);
AGR.MXN("4_1.L3(4).2_1",10);
AGR.MXN("4_2.L3(4)",9);
AGR.MXN("4_2.L3(4).2_1",10);
AGR.MXN("6.A6",5);
AGR.MXN("6.A6.2_1",6);
AGR.MXN("6.A7",5);
AGR.MXN("6.A7.2",5);
AGR.MXN("6.Fi22",14);
AGR.MXN("6.Fi22.2",13);
AGR.MXN("6.L3(4)",9);
AGR.MXN("6.L3(4).2_1",10);
AGR.MXN("6.M22",8);
AGR.MXN("6.M22.2",7);
AGR.MXN("6.O7(3)",15);
AGR.MXN("6.Suz",17);
AGR.MXN("6.Suz.2",16);
AGR.MXN("6.U6(2)",16);
AGR.MXN("A10",7);
AGR.MXN("A10.2",8);
AGR.MXN("A11",7);
AGR.MXN("A11.2",7);
AGR.MXN("A12",11);
AGR.MXN("A12.2",11);
AGR.MXN("A13",9);
AGR.MXN("A13.2",8);
AGR.MXN("A5",3);
AGR.MXN("A5.2",4);
AGR.MXN("A6",5);
AGR.MXN("A6.2^2",6);
AGR.MXN("A6.2_1",6);
AGR.MXN("A6.2_2",4);
AGR.MXN("A6.2_3",4);
AGR.MXN("A7",5);
AGR.MXN("A7.2",5);
AGR.MXN("A8",6);
AGR.MXN("A8.2",7);
AGR.MXN("A9",8);
AGR.MXN("A9.2",7);
AGR.MXN("B",30);
AGR.MXN("Co1",22);
AGR.MXN("Co2",11);
AGR.MXN("Co3",14);
AGR.MXN("Fi22",14);
AGR.MXN("Fi22.2",13);
AGR.MXN("Fi23",14);
AGR.MXN("Fi24'",25);
AGR.MXN("Fi24'.2",21);
AGR.MXN("G2(3)",10);
AGR.MXN("G2(3).2",6);
AGR.MXN("G2(4)",8);
AGR.MXN("HN",14);
AGR.MXN("HN.2",13);
AGR.MXN("HS",12);
AGR.MXN("HS.2",10);
AGR.MXN("He",11);
AGR.MXN("He.2",12);
AGR.MXN("Isoclinic(12.M22.2)",7);
AGR.MXN("Isoclinic(2.A5.2)",4);
AGR.MXN("Isoclinic(2.A7.2)",5);
AGR.MXN("Isoclinic(2.A8.2)",7);
AGR.MXN("Isoclinic(2.Fi22.2)",13);
AGR.MXN("Isoclinic(2.HS.2)",10);
AGR.MXN("Isoclinic(2.J2.2)",10);
AGR.MXN("Isoclinic(2.L3(2).2)",4);
AGR.MXN("Isoclinic(2.M12.2)",9);
AGR.MXN("Isoclinic(2.M22.2)",7);
AGR.MXN("Isoclinic(2.Suz.2)",16);
AGR.MXN("Isoclinic(4.M22.2)",7);
AGR.MXN("Isoclinic(6.Fi22.2)",13);
AGR.MXN("Isoclinic(6.M22.2)",7);
AGR.MXN("Isoclinic(6.Suz.2)",16);
AGR.MXN("J1",7);
AGR.MXN("J2",9);
AGR.MXN("J2.2",10);
AGR.MXN("J3",9);
AGR.MXN("J3.2",9);
AGR.MXN("J4",13);
AGR.MXN("L2(101)",5);
AGR.MXN("L2(103)",5);
AGR.MXN("L2(107)",4);
AGR.MXN("L2(109)",5);
AGR.MXN("L2(11)",4);
AGR.MXN("L2(11).2",5);
AGR.MXN("L2(113)",5);
AGR.MXN("L2(13)",4);
AGR.MXN("L2(13).2",5);
AGR.MXN("L2(16)",4);
AGR.MXN("L2(16).2",5);
AGR.MXN("L2(16).4",5);
AGR.MXN("L2(17)",5);
AGR.MXN("L2(19)",5);
AGR.MXN("L2(23)",5);
AGR.MXN("L2(25)",5);
AGR.MXN("L2(25).2_2",6);
AGR.MXN("L2(27)",4);
AGR.MXN("L2(29)",5);
AGR.MXN("L2(31)",7);
AGR.MXN("L2(32)",3);
AGR.MXN("L2(32).5",4);
AGR.MXN("L2(37)",4);
AGR.MXN("L2(41)",7);
AGR.MXN("L2(43)",4);
AGR.MXN("L2(47)",5);
AGR.MXN("L2(49)",7);
AGR.MXN("L2(53)",4);
AGR.MXN("L2(59)",5);
AGR.MXN("L2(61)",5);
AGR.MXN("L2(64)",5);
AGR.MXN("L2(67)",4);
AGR.MXN("L2(71)",7);
AGR.MXN("L2(73)",5);
AGR.MXN("L2(79)",7);
AGR.MXN("L2(8)",3);
AGR.MXN("L2(8).3",4);
AGR.MXN("L2(81)",5);
AGR.MXN("L2(83)",4);
AGR.MXN("L2(89)",7);
AGR.MXN("L2(97)",5);
AGR.MXN("L3(11)",6);
AGR.MXN("L3(2)",3);
AGR.MXN("L3(2).2",4);
AGR.MXN("L3(3)",4);
AGR.MXN("L3(3).2",5);
AGR.MXN("L3(4)",9);
AGR.MXN("L3(4).2^2",8);
AGR.MXN("L3(4).2_1",10);
AGR.MXN("L3(4).2_2",6);
AGR.MXN("L3(4).2_3",6);
AGR.MXN("L3(4).3",5);
AGR.MXN("L3(4).6",6);
AGR.MXN("L3(4).D12",8);
AGR.MXN("L3(5)",5);
AGR.MXN("L3(7)",8);
AGR.MXN("L3(8)",5);
AGR.MXN("L3(9)",7);
AGR.MXN("L4(3)",8);
AGR.MXN("L5(2)",5);
AGR.MXN("Ly",9);
AGR.MXN("M11",5);
AGR.MXN("M12",11);
AGR.MXN("M12.2",9);
AGR.MXN("M22",8);
AGR.MXN("M22.2",7);
AGR.MXN("M23",7);
AGR.MXN("M24",9);
AGR.MXN("McL",12);
AGR.MXN("McL.2",10);
AGR.MXN("O7(3)",15);
AGR.MXN("O8+(2)",17);
AGR.MXN("O8+(3)",27);
AGR.MXN("O8-(2)",8);
AGR.MXN("ON",13);
AGR.MXN("ON.2",10);
AGR.MXN("Ru",15);
AGR.MXN("S4(4)",7);
AGR.MXN("S4(4).2",8);
AGR.MXN("S4(5)",8);
AGR.MXN("S6(2)",8);
AGR.MXN("S6(3)",11);
AGR.MXN("S8(2)",11);
AGR.MXN("Suz",17);
AGR.MXN("Suz.2",16);
AGR.MXN("Sz(32)",4);
AGR.MXN("Sz(8)",4);
AGR.MXN("Sz(8).3",5);
AGR.MXN("Th",16);
AGR.MXN("U3(11)",11);
AGR.MXN("U3(3)",4);
AGR.MXN("U3(3).2",5);
AGR.MXN("U3(4)",4);
AGR.MXN("U3(4).2",5);
AGR.MXN("U3(5)",8);
AGR.MXN("U3(5).2",6);
AGR.MXN("U3(5).3",6);
AGR.MXN("U3(7)",5);
AGR.MXN("U3(8)",7);
AGR.MXN("U3(9)",5);
AGR.MXN("U4(2)",5);
AGR.MXN("U4(2).2",6);
AGR.MXN("U4(3)",16);
AGR.MXN("U4(3).2_1",13);
AGR.MXN("U4(3).2_3",11);
AGR.MXN("U5(2)",6);
AGR.MXN("U6(2)",16);


#############################################################################
##
##  Store orders of maximal subgroups.
##
AGR.MXO("(2^2x3).U6(2)",[164229120,159252480,123863040,78382080,78382080,78382080,17694720,17418240,17418240,17418240,5322240,5322240,5322240,1866240,1119744,483840]);
AGR.MXO("12.M22",[241920,69120,30240,30240,23040,16128,8640,7920]);
AGR.MXO("12.M22.2",[5322240,483840,138240,46080,32256,17280,15840]);
AGR.MXO("12_1.L3(4)",[11520,11520,4320,4320,4320,2016,2016,2016,864]);
AGR.MXO("12_1.L3(4).2_1",[241920,8640,8640,8640,4608,4032,4032,4032,1728,1440]);
AGR.MXO("12_2.L3(4)",[11520,11520,4320,4320,4320,2016,2016,2016,864]);
AGR.MXO("12_2.L3(4).2_1",[241920,8640,8640,8640,4608,4032,4032,4032,1728,1440]);
AGR.MXO("2.2E6(2)",[,,6622253206732800,6622253206732800,6622253206732800,,129123503308800,129123503308800,129123503308800]);
AGR.MXO("2.A10",[362880,80640,30240,28800,17280,3840,1440]);
AGR.MXO("2.A10.2",[3628800,725760,161280,60480,57600,34560,7680,2880]);
AGR.MXO("2.A11",[3628800,725760,241920,120960,86400,15840,15840]);
AGR.MXO("2.A11.2",[39916800,7257600,1451520,483840,241920,172800,220]);
AGR.MXO("2.A12",[39916800,7257600,2177280,1036800,967680,604800,190080,190080,82944,46080,31104]);
AGR.MXO("2.A12.2",[479001600,79833600,14515200,4354560,2073600,1935360,1209600,165888,92160,62208,2640]);
AGR.MXO("2.A13",[479001600,79833600,21772800,8709120,4838400,3628800,11232,11232,156]);
AGR.MXO("2.A13.2",[6227020800,958003200,159667200,43545600,17418240,9676800,7257600,312]);
AGR.MXO("2.A14.2",[,12454041600]);
AGR.MXO("2.A5",[24,20,12]);
AGR.MXO("2.A5.2",[120,48,40,24]);
AGR.MXO("2.A6",[120,120,72,48,48]);
AGR.MXO("2.A6.2_1",[720,240,240,144,96,96]);
AGR.MXO("2.A7",[720,336,336,240,144]);
AGR.MXO("2.A7.2",[5040,1440,480,288,84]);
AGR.MXO("2.A8",[5040,2688,2688,1440,1152,720]);
AGR.MXO("2.A8.2",[40320,10080,2880,2304,1440,768,672]);
AGR.MXO("2.A9",[40320,10080,4320,3024,3024,2880,1296,432]);
AGR.MXO("2.A9.2",[362880,80640,20160,8640,5760,2592,864]);
AGR.MXO("2.B",[612259837470198831513600,709767191322427392000,8178940946586009600,3179457774039859200,181491887775744000,52978025653862400,45717693482926080,21473462090465280,1549482039705600,1385384650997760,1092123648000000,237704631091200,261213880320,3762339840,3548160000,1725235200,408146688,212889600,116121600,93000000,48000000,4147200,576000,235200,29760,15840,11232,9792,2640,2162]);
AGR.MXO("2.Co1",[84610842624000,5380145971200,1002795171840,991533312000,178362777600,110361968640,12076646400,3963617280,1698693120,470292480,277136640,145152000,50388480,8709120,5038848,2177280,1693440,288000,120000,120000,7056,6000]);
AGR.MXO("2.F4(2)",[95126814720,95126814720,94755225600,94755225600]);
AGR.MXO("2.Fi22",[36787322880,9170703360,9170703360,2090188800,908328960,185794560,106168320,78382080,35942400,35389440,10077696,7257600,7257600,190080]);
AGR.MXO("2.Fi22.2",[129123503308800,73574645760,4180377600,1816657920,371589120,212336640,156764160,71884800,70778880,50388480,20155392,16982784,380160]);
AGR.MXO("2.G2(4)",[1209600,368640,368640,249600,241920,24192,7200,2184]);
AGR.MXO("2.G2(4).2",[503193600,2419200]);
AGR.MXO("2.HS",[887040,504000,504000,80640,80640,23040,21504,15840,15840,15360,5760,2400]);
AGR.MXO("2.HS.2",[88704000,1774080,161280,161280,46080,43008,30720,11520,8000,4800]);
AGR.MXO("2.J2",[12096,4320,3840,2304,1440,1200,672,600,120]);
AGR.MXO("2.J2.2",[1209600,24192,8640,7680,4608,2880,2400,1344,1200,240]);
AGR.MXO("2.L2(11)",[120,120,110,24]);
AGR.MXO("2.L2(13)",[156,28,24,24]);
AGR.MXO("2.L2(13).2",[2184,312,56,48,48]);
AGR.MXO("2.L2(17)",[272,48,48,36,32]);
AGR.MXO("2.L2(17).2",[,544]);
AGR.MXO("2.L2(19)",[342,120,120,40,36]);
AGR.MXO("2.L2(23)",[506,48,48,48,44]);
AGR.MXO("2.L2(25)",[600,240,240,52,48]);
AGR.MXO("2.L2(27)",[702,56,52,24]);
AGR.MXO("2.L2(29)",[812,120,120,60,56]);
AGR.MXO("2.L2(31)",[930,120,120,64,60,48,48]);
AGR.MXO("2.L2(49)",[2352,672,672,120,120,100,96]);
AGR.MXO("2.L3(2)",[48,48,42]);
AGR.MXO("2.L3(2).2",[336,84,32,24]);
AGR.MXO("2.L3(4)",[1920,1920,720,720,720,336,336,336,144]);
AGR.MXO("2.L3(4).2_1",[40320,1440,1440,1440,768,672,672,672,288,240]);
AGR.MXO("2.M12",[15840,15840,2880,2880,1320,864,864,480,384,384,144]);
AGR.MXO("2.M12.2",[190080,2640,2640,960,768,768,432,288,240]);
AGR.MXO("2.M22",[40320,11520,5040,5040,3840,2688,1440,1320]);
AGR.MXO("2.M22.2",[887040,80640,23040,7680,5376,2880,2640]);
AGR.MXO("2.O7(3)",[26127360,25194240,24261120,8491392,8491392,8188128,2903040,2903040,2519424,725760,725760,414720,322560,34560,27648]);
AGR.MXO("2.O8+(2)",[2903040,2903040,2903040,2580480,2580480,2580480,362880,362880,362880,311040,311040,311040,221184,31104,28800,28800,28800]);
AGR.MXO("2.O8+(2).2",[,5806080]);
AGR.MXO("2.O8+(3)",[9170703360,9170703360,9170703360,9170703360,9170703360,9170703360,8843178240,8843178240,8843178240,348364800,348364800,348364800,348364800,272097792,52254720,52254720,52254720,1244160,1244160,1244160,1244160,1244160,1244160,1036800,1036800,1036800,663552]);
AGR.MXO("2.O8-(3)",[,18341406720,18341406720,,,,2488320,2488320,1062720]);
AGR.MXO("2.Ru",[71884800,1548288,698880,688128,504000,491520,62400,40320,24360,24000,8640,8000,4368,2880,2400]);
AGR.MXO("2.S4(5)",[60000,60000,31200,28800,1920,1440,960,720]);
AGR.MXO("2.S6(2)",[103680,80640,46080,24192,21504,9216,8640,3024]);
AGR.MXO("2.S6(3)",[25194240,8188128,2519424,1244160,82944,58968,48384,22464,2184,2184,120]);
AGR.MXO("2.S6(3).2",[50388480]);
AGR.MXO("2.Suz",[503193600,39191040,27371520,6635520,3849120,2419200,2211840,967680,737280,380160,279936,86400,51840,22464,22464,15600,5040]);
AGR.MXO("2.Suz.2",[896690995200,1006387200,78382080,54743040,13271040,7698240,4838400,4423680,1935360,1474560,760320,559872,172800,103680,31200,10080]);
AGR.MXO("2.Sz(8)",[896,104,40,28]);
AGR.MXO("2.U4(2)",[1920,1440,1296,1296,1152]);
AGR.MXO("2.U4(2).2",[51840,3840,2880,2592,2592,2304]);
AGR.MXO("2.U6(2)",[27371520,26542080,20643840,13063680,13063680,13063680,2949120,2903040,2903040,2903040,887040,887040,887040,311040,186624,80640]);
AGR.MXO("2E6(2)",[,,3311126603366400,3311126603366400,3311126603366400,,64561751654400,64561751654400,64561751654400]);
AGR.MXO("2F4(2)'",[11232,11232,10240,7800,6144,1440,1440,1200]);
AGR.MXO("2F4(2)'.2",[17971200,20480,15600,12288,2400,432,156]);
AGR.MXO("2^2.2E6(2)",[,,13244506413465600,13244506413465600,13244506413465600,,258247006617600,258247006617600,258247006617600]);
AGR.MXO("2^2.L3(4)",[3840,3840,1440,1440,1440,672,672,672,288]);
AGR.MXO("2^2.L3(4).2_2",[80640,7680,7680,2880,1344,576]);
AGR.MXO("2^2.Sz(8).3",[116480,5376,624,240,168]);
AGR.MXO("2^2.U6(2)",[54743040,53084160,41287680,26127360,26127360,26127360,5898240,5806080,5806080,5806080,1774080,1774080,1774080,622080,373248,161280]);
AGR.MXO("3.2E6(2)",[,,9933379810099200,9933379810099200,9933379810099200,,193685254963200,193685254963200,193685254963200]);
AGR.MXO("3.A6",[180,180,108,72,72]);
AGR.MXO("3.A6.2_1",[1080,360,360,216,144,144]);
AGR.MXO("3.A7",[1080,504,504,360,216]);
AGR.MXO("3.A7.2",[7560,2160,720,432,126]);
AGR.MXO("3.Fi22",[55180984320,13756055040,13756055040,3135283200,1362493440,278691840,159252480,117573120,53913600,53084160,15116544,10886400,10886400,285120]);
AGR.MXO("3.Fi22.2",[193685254963200,110361968640,6270566400,2724986880,557383680,318504960,235146240,107827200,106168320,75582720,30233088,25474176,570240]);
AGR.MXO("3.Fi24'",[12268411419879014400,774741019852800,267417709977600,75046138675200,30084492372480,14546347960320,1504192757760,662171811840,481579499520,53722307808,41324852160,37623398400,24182323200,24182323200,5945425920,5945425920,458535168,65318400,1632960,317520,36288,36288,6552,6552,1218]);
AGR.MXO("3.Fi24'.2",[3765617127571985163878400,24536822839758028800,1549482039705600,534835419955200,150092277350400,60168984744960,29092695920640,3008385515520,1324343623680,963158999040,107444615616,82649704320,75246796800,11890851840,11890851840,917070336,130636800,3265920,635040,74088,2436]);
AGR.MXO("3.G2(3)",[36288,36288,34992,34992,33696,33696,4536,4032,3276,1728]);
AGR.MXO("3.G2(3).2",[12737088,17496,9072,8064,6552,3456]);
AGR.MXO("3.J3",[24480,10260,10260,8640,7344,6480,5832,5760,3456]);
AGR.MXO("3.J3.2",[150698880,48960,17280,14688,12960,11664,11520,6912,1026]);
AGR.MXO("3.L3(4)",[2880,2880,1080,1080,1080,504,504,504,216]);
AGR.MXO("3.L3(4).2_1",[60480,2160,2160,2160,1152,1008,1008,1008,432,360]);
AGR.MXO("3.L3(7)",[98784,98784,1008,1008,1008,216,216,171]);
AGR.MXO("3.M22",[60480,17280,7560,7560,5760,4032,2160,1980]);
AGR.MXO("3.M22.2",[1330560,120960,34560,11520,8064,4320,3960]);
AGR.MXO("3.McL",[9797760,1330560,1330560,378000,174960,174960,120960,120960,120960,120960,23760,9000]);
AGR.MXO("3.McL.2",[2694384000,19595520,756000,349920,349920,241920,241920,47520,18000,6912]);
AGR.MXO("3.O7(3)",[39191040,37791360,36391680,12737088,12737088,12282192,4354560,4354560,3779136,1088640,1088640,622080,483840,51840,41472]);
AGR.MXO("3.ON",[11261376,11261376,526680,483840,77760,77760,44640,44640,32256,23760,23760,7560,7560]);
AGR.MXO("3.ON.2",[1382446517760,1053360,967680,155520,155520,64512,49392,2790,2160,1008]);
AGR.MXO("3.Suz",[754790400,58786560,41057280,9953280,5773680,3628800,3317760,1451520,1105920,570240,419904,129600,77760,33696,33696,23400,7560]);
AGR.MXO("3.Suz.2",[1345036492800,1509580800,117573120,82114560,19906560,11547360,7257600,6635520,2903040,2211840,1140480,839808,259200,155520,46800,15120]);
AGR.MXO("3.U3(11)",[159720,15840,3960,3960,3960,1080,1080,1080,864,333,216]);
AGR.MXO("3.U3(8)",[32256,4536,648,648,648,486,171]);
AGR.MXO("3.U6(2)",[41057280,39813120,30965760,19595520,19595520,19595520,4423680,4354560,4354560,4354560,1330560,1330560,1330560,466560,279936,120960]);
AGR.MXO("3D4(2)",[258048,86016,12096,3024,2352,1296,1176,216,52]);
AGR.MXO("3D4(2).3",[211341312]);
AGR.MXO("4.M22",[80640,23040,10080,10080,7680,5376,2880,2640]);
AGR.MXO("4.M22.2",[1774080,161280,46080,15360,10752,5760,5280]);
AGR.MXO("4_1.L3(4)",[3840,3840,1440,1440,1440,672,672,672,288]);
AGR.MXO("4_1.L3(4).2_1",[80640,2880,2880,2880,1536,1344,1344,1344,576,480]);
AGR.MXO("4_2.L3(4)",[3840,3840,1440,1440,1440,672,672,672,288]);
AGR.MXO("4_2.L3(4).2_1",[80640,2880,2880,2880,1536,1344,1344,1344,576,480]);
AGR.MXO("5^3.L3(5)",[]);
AGR.MXO("6.A6",[360,360,216,144,144]);
AGR.MXO("6.A6.2_1",[2160,720,720,432,288,288]);
AGR.MXO("6.A7",[2160,1008,1008,720,432]);
AGR.MXO("6.A7.2",[15120,4320,1440,864,252]);
AGR.MXO("6.Fi22",[110361968640,27512110080,27512110080,6270566400,2724986880,557383680,318504960,235146240,107827200,106168320,30233088,21772800,21772800,570240]);
AGR.MXO("6.Fi22.2",[387370509926400,220723937280,12541132800,5449973760,1114767360,637009920,470292480,215654400,212336640,151165440,60466176,50948352,1140480]);
AGR.MXO("6.L3(4)",[5760,5760,2160,2160,2160,1008,1008,1008,432]);
AGR.MXO("6.L3(4).2_1",[120960,4320,4320,4320,2304,2016,2016,2016,864,720]);
AGR.MXO("6.M22",[120960,34560,15120,15120,11520,8064,4320,3960]);
AGR.MXO("6.M22.2",[2661120,241920,69120,23040,16128,8640,7920]);
AGR.MXO("6.O7(3)",[78382080,75582720,72783360,25474176,25474176,24564384,8709120,8709120,7558272,2177280,2177280,1244160,967680,103680,82944]);
AGR.MXO("6.Suz",[1509580800,117573120,82114560,19906560,11547360,7257600,6635520,2903040,2211840,1140480,839808,259200,155520,67392,67392,46800,15120]);
AGR.MXO("6.Suz.2",[2690072985600,3019161600,235146240,164229120,39813120,23094720,14515200,13271040,5806080,4423680,2280960,1679616,518400,311040,93600,30240]);
AGR.MXO("6.U6(2)",[82114560,79626240,61931520,39191040,39191040,39191040,8847360,8709120,8709120,8709120,2661120,2661120,2661120,933120,559872,241920]);
AGR.MXO("A10",[181440,40320,15120,14400,8640,1920,720]);
AGR.MXO("A10.2",[1814400,362880,80640,30240,28800,17280,3840,1440]);
AGR.MXO("A11",[1814400,362880,120960,60480,43200,7920,7920]);
AGR.MXO("A11.2",[19958400,3628800,725760,241920,120960,86400,110]);
AGR.MXO("A12",[19958400,3628800,1088640,518400,483840,302400,95040,95040,41472,23040,15552]);
AGR.MXO("A12.2",[239500800,39916800,7257600,2177280,1036800,967680,604800,82944,46080,31104,1320]);
AGR.MXO("A13",[239500800,39916800,10886400,4354560,2419200,1814400,5616,5616,78]);
AGR.MXO("A13.2",[3113510400,479001600,79833600,21772800,8709120,4838400,3628800,156]);
AGR.MXO("A14",[3113510400]);
AGR.MXO("A14.2",[,6227020800]);
AGR.MXO("A5",[12,10,6]);
AGR.MXO("A5.2",[60,24,20,12]);
AGR.MXO("A6",[60,60,36,24,24]);
AGR.MXO("A6.2^2",[720,720,720,144,40,32]);
AGR.MXO("A6.2_1",[360,120,120,72,48,48]);
AGR.MXO("A6.2_2",[360,72,20,16]);
AGR.MXO("A6.2_3",[360,72,20,16]);
AGR.MXO("A7",[360,168,168,120,72]);
AGR.MXO("A7.2",[2520,720,240,144,42]);
AGR.MXO("A8",[2520,1344,1344,720,576,360]);
AGR.MXO("A8.2",[20160,5040,1440,1152,720,384,336]);
AGR.MXO("A9",[20160,5040,2160,1512,1512,1440,648,216]);
AGR.MXO("A9.2",[181440,40320,10080,4320,2880,1296,432]);
AGR.MXO("B",[306129918735099415756800,354883595661213696000,4089470473293004800,1589728887019929600,90745943887872000,26489012826931200,22858846741463040,10736731045232640,774741019852800,692692325498880,546061824000000,118852315545600,130606940160,1881169920,1774080000,862617600,204073344,106444800,58060800,46500000,24000000,2073600,288000,117600,14880,7920,5616,4896,1320,1081]);
AGR.MXO("Co1",[42305421312000,2690072985600,501397585920,495766656000,89181388800,55180984320,6038323200,1981808640,849346560,235146240,138568320,72576000,25194240,4354560,2519424,1088640,846720,144000,60000,60000,3528,3000]);
AGR.MXO("Co2",[18393661440,908328960,898128000,743178240,88704000,41287680,26127360,11796480,10200960,933120,12000]);
AGR.MXO("Co3",[1796256000,44352000,13063680,10200960,3849120,2903040,756000,699840,322560,241920,190080,27648,9072,1440]);
AGR.MXO("F4(2)",[47563407360,47563407360,47377612800,47377612800]);
AGR.MXO("Fi22",[18393661440,4585351680,4585351680,1045094400,454164480,92897280,53084160,39191040,17971200,17694720,5038848,3628800,3628800,95040]);
AGR.MXO("Fi22.2",[64561751654400,36787322880,2090188800,908328960,185794560,106168320,78382080,35942400,35389440,25194240,10077696,8491392,190080]);
AGR.MXO("Fi23",[129123503308800,29713078886400,73574645760,47377612800,27512110080,20891566080,3265173504,663238368,479001600,318504960,247726080,34836480,3916800,6072]);
AGR.MXO("Fi24'",[4089470473293004800,258247006617600,89139236659200,25015379558400,10028164124160,4848782653440,501397585920,220723937280,160526499840,17907435936,13774950720,12541132800,8060774400,8060774400,1981808640,1981808640,152845056,21772800,544320,105840,12096,12096,2184,2184,406]);
AGR.MXO("Fi24'.2",[1255205709190661721292800,8178940946586009600,516494013235200,178278473318400,50030759116800,20056328248320,9697565306880,1002795171840,441447874560,321052999680,35814871872,27549901440,25082265600,3963617280,3963617280,305690112,43545600,1088640,211680,24696,812]);
AGR.MXO("G2(3)",[12096,12096,11664,11664,11232,11232,1512,1344,1092,576]);
AGR.MXO("G2(3).2",[4245696,5832,3024,2688,2184,1152]);
AGR.MXO("G2(4)",[604800,184320,184320,124800,120960,12096,3600,1092]);
AGR.MXO("G2(4).2",[251596800,1209600]);
AGR.MXO("G2(5)",[1500000,1500000,756000,744000,14400,12096,1344]);
AGR.MXO("HN",[239500800,177408000,16547328,3686400,2520000,2000000,1658880,1036800,1032192,750000,190080,190080,93312,58320]);
AGR.MXO("HN.2",[273030912000000,479001600,354816000,33094656,7372800,5040000,4000000,3317760,2073600,2064384,1500000,186624,116640]);
AGR.MXO("HS",[443520,252000,252000,40320,40320,11520,10752,7920,7920,7680,2880,1200]);
AGR.MXO("HS.2",[44352000,887040,80640,80640,23040,21504,15360,5760,4000,2400]);
AGR.MXO("He",[1958400,483840,138240,138240,21504,16464,15120,6174,4032,3528,1200]);
AGR.MXO("He.2",[4030387200,3916800,967680,43008,32928,30240,28800,18432,12348,8064,7056,2400]);
AGR.MXO("Isoclinic(12.M22.2)",[5322240,483840,138240,46080,32256,17280,15840]);
AGR.MXO("Isoclinic(2.A14.2)",[,12454041600]);
AGR.MXO("Isoclinic(2.A5.2)",[120,48,40,24]);
AGR.MXO("Isoclinic(2.A7.2)",[5040,1440,480,288,84]);
AGR.MXO("Isoclinic(2.A8.2)",[40320,10080,2880,2304,1440,768,672]);
AGR.MXO("Isoclinic(2.Fi22.2)",[129123503308800,73574645760,4180377600,1816657920,371589120,212336640,156764160,71884800,70778880,50388480,20155392,16982784,380160]);
AGR.MXO("Isoclinic(2.G2(4).2)",[503193600,2419200]);
AGR.MXO("Isoclinic(2.HS.2)",[88704000,1774080,161280,161280,46080,43008,30720,11520,8000,4800]);
AGR.MXO("Isoclinic(2.J2.2)",[1209600,24192,8640,7680,4608,2880,2400,1344,1200,240]);
AGR.MXO("Isoclinic(2.L2(19).2)",[,684]);
AGR.MXO("Isoclinic(2.L3(2).2)",[336,84,32,24]);
AGR.MXO("Isoclinic(2.M12.2)",[190080,2640,2640,960,768,768,432,288,240]);
AGR.MXO("Isoclinic(2.M22.2)",[887040,80640,23040,7680,5376,2880,2640]);
AGR.MXO("Isoclinic(2.Suz.2)",[896690995200,1006387200,78382080,54743040,13271040,7698240,4838400,4423680,1935360,1474560,760320,559872,172800,103680,31200,10080]);
AGR.MXO("Isoclinic(4.M22.2)",[1774080,161280,46080,15360,10752,5760,5280]);
AGR.MXO("Isoclinic(6.Fi22.2)",[387370509926400,220723937280,12541132800,5449973760,1114767360,637009920,470292480,215654400,212336640,151165440,60466176,50948352,1140480]);
AGR.MXO("Isoclinic(6.M22.2)",[2661120,241920,69120,23040,16128,8640,7920]);
AGR.MXO("Isoclinic(6.Suz.2)",[2690072985600,3019161600,235146240,164229120,39813120,23094720,14515200,13271040,5806080,4423680,2280960,1679616,518400,311040,93600,30240]);
AGR.MXO("J1",[660,168,120,114,110,60,42]);
AGR.MXO("J2",[6048,2160,1920,1152,720,600,336,300,60]);
AGR.MXO("J2.2",[604800,12096,4320,3840,2304,1440,1200,672,600,120]);
AGR.MXO("J3",[8160,3420,3420,2880,2448,2160,1944,1920,1152]);
AGR.MXO("J3.2",[50232960,16320,5760,4896,4320,3888,3840,2304,342]);
AGR.MXO("J4",[501397585920,21799895040,10239344640,660602880,141831360,887040,319440,163680,12144,6048,812,602,444]);
AGR.MXO("L2(101)",[5050,102,100,60,60]);
AGR.MXO("L2(103)",[5253,104,102,24,24]);
AGR.MXO("L2(107)",[5671,108,106,12]);
AGR.MXO("L2(109)",[5886,110,108,60,60]);
AGR.MXO("L2(11)",[60,60,55,12]);
AGR.MXO("L2(11).2",[660,110,24,24,20]);
AGR.MXO("L2(113)",[6328,114,112,24,24]);
AGR.MXO("L2(13)",[78,14,12,12]);
AGR.MXO("L2(13).2",[1092,156,28,24,24]);
AGR.MXO("L2(16)",[240,60,34,30]);
AGR.MXO("L2(16).2",[4080,480,120,68,60]);
AGR.MXO("L2(16).4",[8160,960,240,136,120]);
AGR.MXO("L2(17)",[136,24,24,18,16]);
AGR.MXO("L2(17).2",[,272]);
AGR.MXO("L2(19)",[171,60,60,20,18]);
AGR.MXO("L2(19).2",[,342]);
AGR.MXO("L2(23)",[253,24,24,24,22]);
AGR.MXO("L2(25)",[300,120,120,26,24]);
AGR.MXO("L2(25).2_2",[7800,600,240,240,52,48]);
AGR.MXO("L2(27)",[351,28,26,12]);
AGR.MXO("L2(29)",[406,60,60,30,28]);
AGR.MXO("L2(29).2",[,812]);
AGR.MXO("L2(31)",[465,60,60,32,30,24,24]);
AGR.MXO("L2(32)",[992,66,62]);
AGR.MXO("L2(32).5",[32736,4960,330,310]);
AGR.MXO("L2(37)",[666,38,36,12]);
AGR.MXO("L2(41)",[820,60,60,42,40,24,24]);
AGR.MXO("L2(43)",[903,44,42,12]);
AGR.MXO("L2(47)",[1081,48,46,24,24]);
AGR.MXO("L2(49)",[1176,336,336,60,60,50,48]);
AGR.MXO("L2(53)",[1378,54,52,12]);
AGR.MXO("L2(59)",[1711,60,60,60,58]);
AGR.MXO("L2(61)",[1830,62,60,60,60]);
AGR.MXO("L2(64)",[4032,504,130,126,60]);
AGR.MXO("L2(67)",[2211,68,66,12]);
AGR.MXO("L2(71)",[2485,72,70,60,60,24,24]);
AGR.MXO("L2(73)",[2628,74,72,24,24]);
AGR.MXO("L2(79)",[3081,80,78,60,60,24,24]);
AGR.MXO("L2(8)",[56,18,14]);
AGR.MXO("L2(8).3",[504,168,54,42]);
AGR.MXO("L2(81)",[3240,720,720,82,80]);
AGR.MXO("L2(83)",[3403,84,82,12]);
AGR.MXO("L2(89)",[3916,90,88,60,60,24,24]);
AGR.MXO("L2(97)",[4656,98,96,24,24]);
AGR.MXO("L3(11)",[1597200,1597200,1320,600,399,168]);
AGR.MXO("L3(2)",[24,24,21]);
AGR.MXO("L3(2).2",[168,42,16,12]);
AGR.MXO("L3(3)",[432,432,39,24]);
AGR.MXO("L3(3).2",[5616,216,96,78,48]);
AGR.MXO("L3(4)",[960,960,360,360,360,168,168,168,72]);
AGR.MXO("L3(4).2^2",[40320,40320,40320,1440,768,672,288,240]);
AGR.MXO("L3(4).2_1",[20160,720,720,720,384,336,336,336,144,120]);
AGR.MXO("L3(4).2_2",[20160,1920,1920,720,336,144]);
AGR.MXO("L3(4).2_3",[20160,720,384,336,144,120]);
AGR.MXO("L3(4).3",[20160,2880,2880,216,63]);
AGR.MXO("L3(4).6",[60480,40320,1152,432,360,126]);
AGR.MXO("L3(4).D12",[120960,120960,120960,80640,2304,864,720,252]);
AGR.MXO("L3(5)",[12000,12000,120,96,93]);
AGR.MXO("L3(5).2",[372000,4000,960,240,192,186]);
AGR.MXO("L3(7)",[32928,32928,336,336,336,72,72,57]);
AGR.MXO("L3(8)",[225792,225792,294,219,168]);
AGR.MXO("L3(8).2",[16482816]);
AGR.MXO("L3(8).3",[16482816,677376,677376,882,657,504]);
AGR.MXO("L3(8).6",[49448448,32965632,150528,21168,1764,1314,1008]);
AGR.MXO("L3(9)",[466560,466560,6048,5616,720,384,273]);
AGR.MXO("L4(3)",[151632,151632,51840,51840,46656,2880,720,576]);
AGR.MXO("L5(2)",[322560,322560,64512,64512,155]);
AGR.MXO("L5(2).2",[9999360]);
AGR.MXO("L7(2).2",[163849992929280]);
AGR.MXO("Ly",[5859000000,5388768000,46500000,39916800,9000000,3849120,699840,1474,666]);
AGR.MXO("M",[8309562962452852382355161088000000,139511839126336328171520000,7531234255143970327756800,1836779512410596494540800,,,,,544475663327232000,,,,,,,378000000000,,,,,,,,508243680,,,72576000,,,,,,,,,632736,,,72600,,,,1640]);
AGR.MXO("M11",[720,660,144,120,48]);
AGR.MXO("M12",[7920,7920,1440,1440,660,432,432,240,192,192,72]);
AGR.MXO("M12.2",[95040,1320,1320,480,384,384,216,144,120]);
AGR.MXO("M22",[20160,5760,2520,2520,1920,1344,720,660]);
AGR.MXO("M22.2",[443520,40320,11520,3840,2688,1440,1320]);
AGR.MXO("M23",[443520,40320,40320,20160,7920,5760,253]);
AGR.MXO("M24",[10200960,887040,322560,190080,138240,120960,64512,6072,168]);
AGR.MXO("McL",[3265920,443520,443520,126000,58320,58320,40320,40320,40320,40320,7920,3000]);
AGR.MXO("McL.2",[898128000,6531840,252000,116640,116640,80640,80640,15840,6000,2304]);
AGR.MXO("O10+(2)",[47377612800,44590694400,10239344640,10239344640]);
AGR.MXO("O10-(2)",[50536120320]);
AGR.MXO("O7(3)",[13063680,12597120,12130560,4245696,4245696,4094064,1451520,1451520,1259712,362880,362880,207360,161280,17280,13824]);
AGR.MXO("O8+(2)",[1451520,1451520,1451520,1290240,1290240,1290240,181440,181440,181440,155520,155520,155520,110592,15552,14400,14400,14400]);
AGR.MXO("O8+(2).2",[,2903040]);
AGR.MXO("O8+(3)",[4585351680,4585351680,4585351680,4585351680,4585351680,4585351680,4421589120,4421589120,4421589120,174182400,174182400,174182400,174182400,136048896,26127360,26127360,26127360,622080,622080,622080,622080,622080,622080,518400,518400,518400,331776]);
AGR.MXO("O8-(2)",[1658880,1451520,258048,184320,120960,8160,4320,168]);
AGR.MXO("O8-(3)",[,9170703360,9170703360,,,,1244160,1244160,531360]);
AGR.MXO("O8-(3).2_1",[,,18341406720,18341406720,,,97044480,,,1062720]);
AGR.MXO("ON",[3753792,3753792,175560,161280,25920,25920,14880,14880,10752,7920,7920,2520,2520]);
AGR.MXO("ON.2",[460815505920,351120,322560,51840,51840,21504,16464,930,720,336]);
AGR.MXO("R(27)",[511758,19656,1512,222,168,114]);
AGR.MXO("R(27).3",[10073444472,1535274,,,666,168]);
AGR.MXO("Ru",[35942400,774144,349440,344064,252000,245760,31200,20160,12180,12000,4320,4000,2184,1440,1200]);
AGR.MXO("S4(4)",[11520,11520,8160,8160,7200,7200,720]);
AGR.MXO("S4(4).2",[979200,23040,23040,16320,16320,14400,14400,1440]);
AGR.MXO("S4(5)",[30000,30000,15600,14400,960,720,480,360]);
AGR.MXO("S6(2)",[51840,40320,23040,12096,10752,4608,4320,1512]);
AGR.MXO("S6(3)",[12597120,4094064,1259712,622080,41472,29484,24192,11232,1092,1092,60]);
AGR.MXO("S6(3).2",[25194240]);
AGR.MXO("S8(2)",[394813440,348364800,185794560,20643840,8847360,8709120,4128768,3628800,1958400,1036800,2448]);
AGR.MXO("Suz",[251596800,19595520,13685760,3317760,1924560,1209600,1105920,483840,368640,190080,139968,43200,25920,11232,11232,7800,2520]);
AGR.MXO("Suz.2",[448345497600,503193600,39191040,27371520,6635520,3849120,2419200,2211840,967680,737280,380160,279936,86400,51840,15600,5040]);
AGR.MXO("Sz(32)",[31744,164,100,62]);
AGR.MXO("Sz(8)",[448,52,20,14]);
AGR.MXO("Sz(8).3",[29120,1344,156,60,42]);
AGR.MXO("Th",[634023936,319979520,92897280,33094656,25474176,944784,944784,349920,12000,12000,7056,6840,5616,720,465,120]);
AGR.MXO("U3(11)",[53240,5280,1320,1320,1320,360,360,360,288,111,72]);
AGR.MXO("U3(3)",[216,168,96,96]);
AGR.MXO("U3(3).2",[6048,432,336,192,192]);
AGR.MXO("U3(4)",[960,300,150,39]);
AGR.MXO("U3(4).2",[62400,1920,600,300,78]);
AGR.MXO("U3(4).4",[124800,3840,1200,600,156]);
AGR.MXO("U3(5)",[2520,2520,2520,1000,720,720,720,240]);
AGR.MXO("U3(5).2",[126000,5040,2000,1440,480,336]);
AGR.MXO("U3(5).3",[126000,3000,720,216,216,63]);
AGR.MXO("U3(7)",[16464,2688,384,336,129]);
AGR.MXO("U3(8)",[10752,1512,216,216,216,162,57]);
AGR.MXO("U3(9)",[58320,7200,720,600,219]);
AGR.MXO("U4(2)",[960,720,648,648,576]);
AGR.MXO("U4(2).2",[25920,1920,1440,1296,1296,1152]);
AGR.MXO("U4(3)",[29160,25920,25920,20160,20160,11664,6048,5760,5760,2520,2520,2520,2520,1152,720,720]);
AGR.MXO("U4(3).2_1",[3265920,58320,51840,51840,40320,40320,23328,12096,11520,11520,2304,1440,1440]);
AGR.MXO("U4(3).2_3",[3265920,58320,40320,40320,23328,12096,2304,1440,1440,1440,768]);
AGR.MXO("U5(2)",[82944,77760,46080,9720,3888,660]);
AGR.MXO("U5(2).2",[13685760,165888,155520,92160,19440,,1320]);
AGR.MXO("U6(2)",[13685760,13271040,10321920,6531840,6531840,6531840,1474560,1451520,1451520,1451520,443520,443520,443520,155520,93312,40320]);
AGR.MXO("U6(2).2",[,27371520,,,,,,887040]);
AGR.MXO("U7(2)",[84085309440,82771476480,,,,,3674160]);


#############################################################################
##
##  Store structures of maximal subgroups.
##
AGR.MXS("(2^2x3).U6(2)",[,,"2^10:6.L3(4)","2x6_1.U4(3).2_2","2x6_1.U4(3).2_2","2x6_1.U4(3).2_2",,"2^2x3xS6(2)","2^2x3xS6(2)","2^2x3xS6(2)","2x6.M22","2x6.M22","2x6.M22"]);
AGR.MXS("12.M22",["12_1.L3(4)","2.2^5:3A6","2.(2x3.A7)","2.(2x3.A7)","3x2.(2^5:S5)","3x2.(2x2^3:L3(2))","(4x3.A6).2_3","3x2.(2xL2(11))"]);
AGR.MXS("2.2E6(2)",[,,"2xF4(2)","2.F4(2)","2.F4(2)",,"2xFi22","2.Fi22","2.Fi22"]);
AGR.MXS("2.A10",["2.A9","Isoclinic(2.A8.2)","(2.A7x3).2","2.(A5xA5).4","2.(A6xA4).2","2^(1+4).S5","M10x2"]);
AGR.MXS("2.A11",["2.A10","Isoclinic(2.A9.2)","(2.A8x3).2","2.(A7xA4).2","2.(A6xA5).2","2xM11","2xM11"]);
AGR.MXS("2.A12",[,,,,,,"2.M12","2.M12"]);
AGR.MXS("2.A5",["2.L2(3)","2.D10","2.S3"]);
AGR.MXS("2.A6",["2.A5","2.A5","3^2:8","2.S4","2.S4"]);
AGR.MXS("2.A7",["2.A6","2.L3(2)","2.L3(2)","Isoclinic(2.A5.2)","(2.A4x3).2"]);
AGR.MXS("2.A8",["2.A7","2^(1+3):L3(2)","2^(1+3):L3(2)","2.A6.2_1","2(A4xA4).2^2","(2.A5x3).2"]);
AGR.MXS("2.A9",["2.A8","Isoclinic(2.A7.2)","(2.A6x3).2_1","2xL2(8).3","2xL2(8).3","2.(A5xA4).2","(2x3^3).S4","2x3^2:2A4"]);
AGR.MXS("2.B",["2^2.2E6(2).2",,"2xFi23",,"2xTh",,,,"(S3x2.Fi22).2",,,,,,,,,,,,,,,,,"2xM11",,,,"2x47:23"]);
AGR.MXS("2.Co1",[,,"2.2^11:M24"]);
AGR.MXS("2.Fi22",[,"2xO7(3)","2xO7(3)","O8+(2):S3x2","2^11.M22",,,"S3x2.U4(3).2_2"]);
AGR.MXS("2.G2(4)",["2.J2","2.2^(2+8).(3xA5)","2.2^(4+6).(A5x3)","Isoclinic(2xU3(4).2)","Isoclinic(6.L3(4).2_3)","Isoclinic(2xU3(3).2)","2.A5xA5","2.L2(13)"]);
AGR.MXS("2.HS",["2.M22","Isoclinic(U3(5).2x2)","Isoclinic(U3(5).2x2)","Isoclinic(2.L3(4).2_1)","Isoclinic(S8x2)","2.2^4.S6","2.4^3.L3(2)","2xM11","2xM11","2.4.2^4.S5","2.(2xA6.2^2)","5:4x2.A5"]);
AGR.MXS("2.HS.2",[,,,,,,,,"5^(1+2)_+:[2^6]"]);
AGR.MXS("2.J2",["2xU3(3)","(2x3.A6).2","2^(1+4)_-:2A5","2^(3+4):(3xS3)","2A4xA5","2A5xD10","(2xL3(2)).2","2.(5^2:D12)","2.A5"]);
AGR.MXS("2.J2.2",[,"Isoclinic(2xU3(3).2)",,,,,"(2.A5xD10).2"]);
AGR.MXS("2.L2(11)",["2.A5","2.A5","2x11:5","2.(S3x2)"]);
AGR.MXS("2.L2(13)",["(2x13).6","2.D14","2.D12","2.L2(3)"]);
AGR.MXS("2.L2(17)",["(2x17).8","2.S4","2.S4","2.D18","2.D16"]);
AGR.MXS("2.L2(19)",["2x19:9","2.A5","2.A5","2.D20","2.D18"]);
AGR.MXS("2.L2(23)",["2x23:11","2.S4","2.S4","2.D24","2.D22"]);
AGR.MXS("2.L2(25)",["(2x5^2).12","Isoclinic(2.A5.2)","Isoclinic(2.A5.2)","2.D26","2.D24"]);
AGR.MXS("2.L2(27)",["2x3^3:13","2.D28","2.D26","2.L2(3)"]);
AGR.MXS("2.L2(29)",["(2x29).14","2.A5","2.A5","2.D30","2.D28"]);
AGR.MXS("2.L2(31)",["2x31:15","2.A5","2.A5","2.D32","2.D30","2.S4","2.S4"]);
AGR.MXS("2.L3(2)",["2.S4","2.S4","2x7:3"]);
AGR.MXS("2.L3(4)",["2^5:A5","2^5:A5","2xA6","2xA6","2xA6","2xL3(2)","2xL3(2)","2xL3(2)","Isoclinic(2x3^2:Q8)"]);
AGR.MXS("2.M12",["2xM11","2xM11","A6.D8","A6.D8","2.L2(11)","2x3^2.2.S4","2x3^2.2.S4","4Y(2xA5):2","(2xQ8).S4","2.(4^2:D12)","2.A4xS3"]);
AGR.MXS("2.M12.2",[,"2xL2(11).2"]);
AGR.MXS("2.M22",["2.L3(4)","2^5:A6","2xA7","2xA7","2^5:S5","2x2^3:L3(2)","(2xA6).2_3","2xL2(11)"]);
AGR.MXS("2.O7(3)",["4.U4(3).2_2","(2x3^5).U4(2).2","2.L4(3).2_2","2xG2(3)","2xG2(3)","2x3^(3+3):L3(3)","2.S6(2)","2.S6(2)","2.3^(1+6)_+.(2A4xA4).2","Isoclinic(2.A9.2)","Isoclinic(2.A9.2)","2.(2^2xU4(2)).2","2^(1+6)_+:A7","2.(S6xS4)","2.(A4x2(A4xA4).2).2"]);
AGR.MXS("2.O8+(2)",["2xS6(2)","2.S6(2)","2.S6(2)","2^7.A8","2^(1+6)_+.A8","2^(1+6)_+.A8","2xA9","2.A9","2.A9","(6xU4(2)):2","(3x2.U4(2)):2","2.O8+(2)M11","2.2^(1+8)_+:(S3xS3xS3)","(2x3^4:2^3).S4","(A5xA5).(2x4)","2.(A5xA5).2^2","2.(A5xA5).2^2"]);
AGR.MXS("2.Ru",["(2x2F4(2)').2","2.2^6:u3(3):2","2.(2^2xSz(8)):3","2.2^3+8:L3(2)",,"2.2.2^4+6:S5"]);
AGR.MXS("2.S6(2)",["2.U4(2).2","Isoclinic(2.A8.2)","2.(2^5:S6)","2xU3(3).2","2.2^6.L3(2)","2^2.[2^6].(S3xS3)","2.(S3xS6)","L2(8):3x2"]);
AGR.MXS("2.Suz",["2.G2(4)","Isoclinic(6_2.U4(3).2_3')","2xU5(2)","2.2^(1+6)_-.U4(2)","2x3^5:M11","2.J2.2","(2.2^4.2^6):3A6","2.(A4xL3(4)).2","2.(2^(2+8):(A5xS3))","Isoclinic(2.M12.2)","2.(3^(2+4):2(A4x2^2).2)","(A6x2.A5).2","(3^2:4x2.A6).2","(2xL3(3)).2","(2xL3(3)).2","2.L2(25)","2.A7"]);
AGR.MXS("2.Sz(8)",["2.2^(3+3):7","2x13:4","2x5:4","2xD14"]);
AGR.MXS("2.U4(2)",["2.(2^4:A5)","2.A6.2_1","2x3^(1+2)+:2A4","(2x3^3).S4","2.(2.(A4xA4).2)"]);
AGR.MXS("2.U4(2).2",["2.U4(2)","2.(2^4:S5)","2.(S6x2)","2.(3^3:(S4x2))","2.(3^(1+2)+:2S4)","2.(2.(A4xA4).2.2)"]);
AGR.MXS("2.U6(2)",["2xU5(2)","2.2^(1+8)_+:U4(2)","2^10:L3(4)","2xU4(3).2_2","2.U4(3).2_2","2.U4(3).2_2","2.2^(4+8):(S3xA5)","2xS6(2)","2xS6(2)","2xS6(2)","2xM22","2.M22","2.M22","2xS3xU4(2)","2.(3^(1+4).[2^7.3])","2.L3(4).2_1"]);
AGR.MXS("2E6(2)",[,,"F4(2)","F4(2)","F4(2)",,"Fi22","Fi22","Fi22"]);
AGR.MXS("2F4(2)'",["L3(3).2","L3(3).2","2.[2^8]:5:4","L2(25)","2^2.[2^8]:S3","A6.2^2","A6.2^2","5^2:4A4"]);
AGR.MXS("2F4(2)'.2",["2F4(2)'","2.[2^9]:5:4","L2(25).2_3","2^2.[2^9]:S3","5^2:4S4","3^(1+2):SD16","13:12"]);
AGR.MXS("2^2.2E6(2)",[,,"2x2.F4(2)","2x2.F4(2)","2x2.F4(2)",,"2x2.Fi22","2x2.Fi22","2x2.Fi22"]);
AGR.MXS("2^2.L3(4)",["2^6.A5","2^6.A5","2^2xA6","2^2xA6","2^2xA6","2^2xL2(7)","2^2xL2(7)","2^2xL2(7)","2^2.(3^2:Q8)"]);
AGR.MXS("2^2.L3(4).2_2",["2^2.L3(4)","2^2.2^4.S5","2^2.2^4.S5","2^2.S6","2^2.(L2(7)x2)","2^2.(3^2:Q8.2)"]);
AGR.MXS("2^2.U6(2)",[,,"2^10:2.L3(4)","2x2.U4(3).2_2","2x2.U4(3).2_2","2x2.U4(3).2_2",,"2^2xS6(2)","2^2xS6(2)","2^2xS6(2)","2x2.M22","2x2.M22","2x2.M22"]);
AGR.MXS("3.2E6(2)",[,,"3xF4(2)","3xF4(2)","3xF4(2)",,"3.Fi22","3.Fi22","3.Fi22"]);
AGR.MXS("3.A6",["3xA5","3xA5","3^(1+2):4","3xS4","3xS4"]);
AGR.MXS("3.A7",["3.A6","3xL3(2)","3xL3(2)","3xA5.2","3.(A4x3):2"]);
AGR.MXS("3.Fi22",[,,,"3xO8+(2):S3","2^10:3M22"]);
AGR.MXS("3.Fi24'",["3xFi23"]);
AGR.MXS("3.Fi24'.2",[,,"(S3x2.Fi22).2"]);
AGR.MXS("3.G2(3)",["3xU3(3).2","3xU3(3).2","3.(3^(1+2)+x3^2):2S4","3.(3^(1+2)+x3^2):2S4","3xL3(3).2","3xL3(3).2","3xL2(8).3","3x2^3.L3(2)","3xL2(13)","3.2^(1+4)+:3^2.2"]);
AGR.MXS("3.J3",[,,,"3x2^4:(3xA5)"]);
AGR.MXS("3.L3(4)",["3x2^4:A5","3x2^4:A5","3.A6","3.A6","3.A6","3xL3(2)","3xL3(2)","3xL3(2)","3^(1+2)_+:Q8"]);
AGR.MXS("3.L3(7)",["3x7^2:2.L2(7).2","3x7^2:2.L2(7).2","3xL3(2).2","3xL3(2).2","3xL3(2).2","3.(A4x3):2","3^(1+2)_+:Q8","3x19:3"]);
AGR.MXS("3.M22",["3.L3(4)","2^4:3A6","3.A7","3.A7","3x2^4:S5","3x2^3:L3(2)","3.A6.2_3","3xL2(11)"]);
AGR.MXS("3.McL",["3_2.U4(3)","3.M22","3.M22","3.U3(5)","3.3^(1+4):2S5","3.3^4:M10","3xL3(4).2_2","3x2.A8","3.2^4:A7","3.2^4:A7","3xM11","3x5^(1+2):3:8"]);
AGR.MXS("3.McL.2",[,,,"3.3^(1+4):4S5"]);
AGR.MXS("3.O7(3)",["6_1.U4(3).2_2","3.3^5:U4(2):2","3xL4(3).2_2","3.G2(3)","3.G2(3)","3.(3^(3+3):L3(3))","3xS6(2)","3xS6(2)","3.3^(1+6)_+.(2A4xA4).2","3xS9","3xS9","3x(2^2xU4(2)):2","2^6:3A7","3xS6xS4","3.(A4x2(A4xA4).2).2"]);
AGR.MXS("3.ON",[,,,,"3.(3^2:4xA6).2","3^(1+4)_+:2^(1+4)_-D10"]);
AGR.MXS("3.Suz",["3xG2(4)","3^2.U4(3).2_3'","3xU5(2)","3x2^(1+6)_-.U4(2)","3^6.M11","3xJ2.2","3x2^(4+6).3A6","(A4x3.L3(4)).2","3x2^(2+8):(A5xS3)","3xM12.2","3.3^(2+4):2(A4x2^2).2","(3.A6xA5):2","(3^(1+2):4xA6).2","3xL3(3).2","3xL3(3).2","3xL2(25)","3.A7"]);
AGR.MXS("3.Suz.2",["3.Suz","(3xG2(4)).2","3^2.U4(3).(2^2)_(133)","(3xU5(2)).2","(3x2^(1+6)_-.U4(2)).2","3^6:(M11x2)","S3xJ2.2","(3x2^(4+6):3A6).2","(A4x3.L3(4).2_3).2","(3x2^(2+8):(A5xS3)).2","S3xM12.2","3.3^(2+4):2(S4xD8)","(3.A6.2_2xA5):2","(3^(1+2):8xA6).2","(3xL2(25)).2_2","3.A7.2"]);
AGR.MXS("3.U6(2)",["3xU5(2)","3x2^(1+8)_+:U4(2)","2^9:3.L3(4)","3_1.U4(3).2_2","3_1.U4(3).2_2","3_1.U4(3).2_2","3x2^(4+8):(S3xA5)","3xS6(2)","3xS6(2)","3xS6(2)","3.M22","3.M22","3.M22","3xS3xU4(2)","3.(3^(1+4).[2^7.3])","3.L3(4).2_1"]);
AGR.MXS("3D4(2)",[,,"U3(3).2",,,,,,"13:4"]);
AGR.MXS("3D4(2).3",["3D4(2)"]);
AGR.MXS("4.M22",["4_1.L3(4)","2.2^5:A6","2.(2xA7)","2.(2xA7)","2.(2^5:S5)","2.(2x2^3:L3(2))","(4xA6).2_3","2.(2xL2(11))"]);
AGR.MXS("6.A6",["3x2.A5","3x2.A5","3^(1+2)_+:8","3x2.S4","3x2.S4"]);
AGR.MXS("6.A7",["6.A6","3x2.L3(2)","3x2.L3(2)","3xIsoclinic(2.A5.2)","6.(A4x3).2"]);
AGR.MXS("6.Fi22",[,"2x3.O7(3)","2x3.O7(3)","6xO8+(2):S3","2^11.3M22"]);
AGR.MXS("6.L3(4)",[,,,,,,"6xL3(2)","6xL3(2)"]);
AGR.MXS("6.M22",["6.L3(4)","2^5:3A6","2x(3.A7)","2x(3.A7)","3x2^5:S5","6x2^3:L3(2)","(2x3.A6).2_3","6xL2(11)"]);
AGR.MXS("6.M22.2",[,"6.L3(4).2_2"]);
AGR.MXS("6.O7(3)",["12_1.U4(3).2_2","6.(3^5:U4(2):2)","3x2.L4(3).2_2","2x3.G2(3)","2x3.G2(3)","2x3.(3^(3+3):L3(3))","3x2.S6(2)","3x2.S6(2)","6.3^(1+6)_+.(2A4xA4).2","3xIsoclinic(2.A9.2)","3xIsoclinic(2.A9.2)","3x2.(2^2xU4(2)).2","2^(1+6)_+:3A7","3x2.(S6xS4)","6.(A4x2(A4xA4).2).2"]);
AGR.MXS("6.Suz",["3x2.G2(4)","Isoclinic((3^2x2).U4(3).2_3')","6xU5(2)","3x2.2^(1+6)_-.U4(2)","2x3^6.M11","3x2.J2.2","3x(2.2^4.2^6):3A6","2.(A4x3.L3(4)).2","3x2.(2^(2+8):(A5xS3))","3xIsoclinic(2.M12.2)","6.(3^(2+4):2(A4x2^2).2)","(3.A6x2.A5).2","(3^(1+2):4x2.A6).2","3x(2xL3(3)).2","3x(2xL3(3)).2","3x2.L2(25)","6.A7"]);
AGR.MXS("6.U6(2)",["6xU5(2)","3x2.2^(1+8)_+:U4(2)","2^10:3.L3(4)","2x3_1.U4(3).2_2","6_1.U4(3).2_2","6_1.U4(3).2_2","3x2.2^(4+8):(S3xA5)","6xS6(2)","6xS6(2)","6xS6(2)","2x3.M22","6.M22","6.M22","6xS3xU4(2)","6.(3^(1+4).[2^7.3])","6.L3(4).2_1"]);
AGR.MXS("A10",["A9","A8.2","(A7x3).2","(A5xA5):4","(A6xA4).2","2^5:S5","A6.2_3"]);
AGR.MXS("A10.2",["A10","A9.2","S8x2","S7xS3","(S5xS5):2","S6xS4","2^5:S5","A6.2^2"]);
AGR.MXS("A11",["A10","A9.2","(A8x3).2","(A7xA4):2","(A6xA5):2","M11","M11"]);
AGR.MXS("A11.2",["A11","A10.2","S9x2","S8xS3","S7xS4","S6xS5","11:10"]);
AGR.MXS("A12",["A11","A10.2","(A9x3):2","(A6xA6):2^2","(A8xA4):2","(A7xA5):2","M12","M12","2^6:3^3:S4","2^5:S6","3^4:2^3.S4"]);
AGR.MXS("A13",["A12","A11.2","(A10x3):2","(A9xA4):2","(A8xA5):2","(A7xA6):2","L3(3)","L3(3)","13:6"]);
AGR.MXS("A13.2",["A13","A12.2","S11x2","S10xS3","S9xS4","S8xS5","S7xS6","13:12"]);
AGR.MXS("A14",["A13"]);
AGR.MXS("A14.2",[,"A13.2"]);
AGR.MXS("A5",["A4","D10","S3"]);
AGR.MXS("A5.2",["A5","S4","5:4","S3x2"]);
AGR.MXS("A6",["A5","A5","3^2:4","S4","S4"]);
AGR.MXS("A6.2_1",["A6","A5.2","A5.2","3^2:D8","2xS4","S4x2"]);
AGR.MXS("A7",["A6","L3(2)","L3(2)","A5.2","(A4x3):2"]);
AGR.MXS("A7.2",["A7","A6.2_1","2xS5","S4xS3","7:6"]);
AGR.MXS("A8",["A7","2^3:L3(2)","2^3:L3(2)","A6.2_1","2^4:(S3xS3)","(A5x3):2"]);
AGR.MXS("A8.2",["A8","A7.2","S6x2","(S4xS4):2","S5xS3","2^4:S4","L3(2).2"]);
AGR.MXS("A9",["A8","A7.2","(3xA6).2_1","L2(8).3","L2(8).3","(A4xA5):2","3^3.S4","3^2:2A4"]);
AGR.MXS("A9.2",["A9","A8.2","S7x2","S3xS6","S5xS4","3^3:(S4x2)","3^2.2.S4"]);
AGR.MXS("B",["2.2E6(2).2","2^(1+22).Co2","Fi23","2^(9+16).S8(2)","Th","(2^2xF4(2)):2","2^(2+10+20).(M22.2xS3)","[2^30].L5(2)","S3xFi22.2","[2^35].(S5xL3(2))","HN.2","O8+(3).S4","3^(1+8).2^(1+6).U4(2).2","(3^2:D8xU4(3).2^2).2","5:4xHS.2","S4x2F4(2)'.2","3^2.3^3.3^6.(S4x2S4)","A5.2xM22.2","(S6xL3(4).2).2","5^3.L3(5)","5^(1+4).2^(1+4).A5.4","(S6xS6).4","5^2:4S4xS5","L2(49).2_3","L2(31)","M11","L3(3)","L2(17).2","L2(11).2","47:23"]);
AGR.MXS("Co1",["Co2","3.Suz.2","2^11:M24","Co3","2^(1+8)+.O8+(2)","U6(2).3.2","(A4xG2(4)):2","2^(2+12):(A8xS3)","2^(4+12).(S3x3S6)","3^2.U4(3).D8","3^6:2M12","(A5xJ2):2","3^(1+4).2U4(2).2","(A6xU3(3)):2","3^(3+4):2(S4xS4)","A9xS3","(A7xL2(7)):2","(D10x(A5xA5).2).2","5^(1+2):GL2(5)","5^3:(4xA5).2","7^2:(3x2A4)","5^2:2A5"]);
AGR.MXS("Co2",["U6(2).2","2^10:M22:2","McL","2^(1+8)_+:S6(2)","HS.2","(2^(1+6)_+x2^4).A8","U4(3).D8","2^(4+10)(S5xS3)","M23","3^(1+4)_+:2^(1+4)_-.S5","5^(1+2):4S4"]);
AGR.MXS("Co3",["McL.2","HS","U4(3).(2^2)_(133)","M23","3^5:(2xM11)","2.S6(2)","U3(5).3.2","3^(1+4)_+:4S6","2^4.A8","L3(4).D12","2xM12","2^2.[2^7.3^2].S3","S3xL2(8).3","A4xS5"]);
AGR.MXS("F4(2)",["(2^(1+8)x2^6):S6(2)","(2^(1+8)x2^6):S6(2)","S8(2)","S8(2)"]);
AGR.MXS("Fi22",["2.U6(2)","O7(3)","O7(3)","O8+(2).3.2","2^10:M22","2^6:S6(2)","(2x2^(1+8)):U4(2):2","S3xU4(3).2_2","2F4(2)'","2^(5+8):(S3xA6)","3^(1+6):2^(3+4):3^2:2","A10.2","A10.2","M12"]);
AGR.MXS("Fi22.2",["Fi22","2.U6(2).2","O8+(2):S3x2","2^10:M22:2","2^7:S6(2)","(2x2^(1+8)):(U4(2):2x2)","S3xU4(3).(2^2)_(122)","2F4(2)'.2","2^(5+8):(S3xS6)","3^5:(2xU4(2).2)","3^(1+6)_+:2^(3+4):(S3xS3)","G2(3).2","M12.2"]);
AGR.MXS("Fi23",["2.Fi22","O8+(3).3.2","2^2.U6(2).2","S8(2)","S3xO7(3)","2^11.M23","3^(1+8).2^(1+6).3^(1+2).2S4","3^3.[3^7].(2xL3(3))","A12.2","(2^2x2^(1+8)).(3xU4(2)).2","2^(6+8):(A7xS3)","S4xS6(2)","S4(4).4","L2(23)"]);
AGR.MXS("Fi24'",["Fi23","2.Fi22.2","(3xO8+(3):3):2","O10-(2)","3^7.O7(3)","3^(1+10):U5(2):2","2^11.M24","2^2.U6(2).3.2","2^(1+12).3_1.U4(3).2_2'","3^3.[3^10].GL3(3)","3^2.3^4.3^8.(A5x2A4).2","(A4xO8+(2).3).2","He.2","He.2","2^(3+12).(L3(2)xA6)","2^(6+8).(S3xA8)","(3^2:2xG2(3)).2","(A5xA9):2","A6xL2(8):3","7:6xA7","U3(3).2","U3(3).2","L2(13).2","L2(13).2","29:14"]);
AGR.MXS("Fi24'.2",["F3+","2xFi23","2^2.Fi22.2","S3xO8+(3):S3","O10-(2).2","3^7.O7(3):2","3^(1+10):(2xU5(2):2)","2^12.M24","2^2.U6(2):S3x2","2^(1+12)_+.3_1.U4(3).2^2_(122)","3^3.[3^10].(L3(3)x2^2)","3^2.3^4.3^8.(S5x2S4)","S4xO8+(2):S3","2^(3+12).(L3(2)xS6)","2^(7+8).(S3xA8)","(S3xS3xG2(3)):2","S5xS9","S6xL2(8):3","7:6xS7","7^(1+2)_+:(6xS3).2","29:28"]);
AGR.MXS("G2(3)",["U3(3).2","U3(3).2","(3^(1+2)+x3^2):2S4","(3^(1+2)+x3^2):2S4","L3(3).2","L3(3).2","L2(8).3","2^3.L3(2)","L2(13)","2^(1+4)+:3^2.2"]);
AGR.MXS("G2(3).2",["G2(3)","3^2.(3x3^(1+2)+):D8","L2(8):3x2","2^3.L3(2):2","L2(13).2","2^(1+4)+.(S3xS3)"]);
AGR.MXS("G2(4)",["J2","2^(2+8):(3xA5)","2^(4+6):(A5x3)","U3(4).2","3.L3(4).2_3","U3(3).2","A5xA5","L2(13)"]);
AGR.MXS("G2(4).2",["G2(4)","J2.2"]);
AGR.MXS("G2(5)",["5^(1+4):GL(2,5)",,"3.U3(5).2","L3(5).2","2.(A5xA5).2","U3(3).2","2^3.L3(2)"]);
AGR.MXS("HN",["A12","2.HS.2","U3(8).3_1","2^(1+8).(A5xA5).2","(D10xU3(5)).2","5^(1+4):2^(1+4).5.4","2^6.U4(2)","(A6xA6).D8","2^3.2^2.2^6.(3xL3(2))","5^2.5.5^2.4A5","M12.2","M12.2","3^4:2(A4xA4).4","3^(1+4):4A5"]);
AGR.MXS("HN.2",["HN","A12.2","4.HS.2","U3(8).6","2^(1+8)_+.(A5xA5).2^2","5:4xU3(5):2","5^(1+4)_+:(4Y2^(1+4)_-.5.4)","2^6.U4(2).2","(S6xS6).2^2","2^3.2^2.2^6.(S3xL3(2))","5^2.5.5^2.4S5","3^4:2(S4xS4).2","3^(1+4)_+:4S5"]);
AGR.MXS("HS",["M22","U3(5).2","U3(5).2","L3(4).2_1","A8.2","2^4.S6","4^3:L3(2)","M11","M11","4.2^4.S5","2xA6.2^2","5:4xA5"]);
AGR.MXS("HS.2",["HS","M22.2","L3(4).2^2","S8x2","2^5.S6","4^3:(L3(2)x2)","2^(1+6)_+:S5","(2xA6.2^2).2","5^(1+2)_+:[2^5]","5:4xS5"]);
AGR.MXS("He",["S4(4).2","2^2.L3(4).S3","2^6:3.S6","2^6:3.S6","2^(1+6)_+.L3(2)","7^2:2L2(7)","3.A7.2","7^(1+2):(S3x3)","S4xL3(2)","7:3xL3(2)","5^2:4A4"]);
AGR.MXS("He.2",["He","S4(4).4","2^2.L3(4).D12","2^(1+6)_+.L3(2).2","7^2:2.L2(7).2","3.S7x2","(S5xS5):2","2^(4+4).(S3xS3).2","7^(1+2):(S3x6)","S4xL3(2).2","7:6xL3(2)","5^2:4S4"]);
AGR.MXS("J1",["L2(11)","2^3.7.3","2xA5","19:6","11:10","D6xD10","7:6"]);
AGR.MXS("J2",["U3(3)","3.A6.2_2","2^(1+4)_-:A5","2^(2+4):(3xS3)","A4xA5","A5xD10","L3(2).2","5^2:D12","A5"]);
AGR.MXS("J2.2",["J2","U3(3).2","3.A6.2^2","2^(1+4).S5","2^(2+4):(S3xS3)","(A4xA5):2","(A5xD10).2","L3(2).2x2","5^2:(4xS3)","A5.2"]);
AGR.MXS("J3",["L2(16).2","L2(19)","L2(19)","2^4:(3xA5)","L2(17)","(3xA6):2_2","3^2.3^(1+2):8","2^(1+4)_-:A5","2^(2+4):(3xS3)"]);
AGR.MXS("J3.2",["J3","L2(16).4","2^4:(3xA5).2","L2(17)x2","(3xM10):2","3^2.3^(1+2):8.2","2^(1+4).S5","2^(2+4):(S3xS3)","19:18"]);
AGR.MXS("J4",["2^11:M24","2^(1+12)_+.3M22.2","2^10:L5(2)","2^(3+12).(S5xL3(2))","U3(11).2","M22.2","11+^(1+2):(5x2S4)","L2(32).5","L2(23).2","U3(3)","29:28","43:14","37:12"]);
AGR.MXS("L2(109)",["109:54","D110","D108","A5","A5"]);
AGR.MXS("L2(11)",["A5","A5","11:5","S3x2"]);
AGR.MXS("L2(11).2",["L2(11)","11:10","D24","S4","D20"]);
AGR.MXS("L2(113)",["113:56","D114","D112","S4","S4"]);
AGR.MXS("L2(13)",["13:6","D14","S3x2","A4"]);
AGR.MXS("L2(16).2",[,,,,"D6xD10"]);
AGR.MXS("L2(17)",["17:8","S4","S4","D18","D16"]);
AGR.MXS("L2(17).2",[,"17:16"]);
AGR.MXS("L2(19)",["19:9","A5","A5","D20","D18"]);
AGR.MXS("L2(19).2",[,"19:18"]);
AGR.MXS("L2(23)",["23:11","S4","S4","D24","D22"]);
AGR.MXS("L2(25)",["5^2:12","A5.2","A5.2","D26","D24"]);
AGR.MXS("L2(27)",["3^3:13","D28","D26","A4"]);
AGR.MXS("L2(29)",["29:14","A5","A5","D30","D28"]);
AGR.MXS("L2(29).2",[,"29:28"]);
AGR.MXS("L2(31)",["31:15","A5","A5","D32","D30","S4","S4"]);
AGR.MXS("L3(11)",["11^2:(5x2L2(11).2)","11^2:(5x2L2(11).2)","L2(11).2","10^2:S3","133:3","L3(2)"]);
AGR.MXS("L3(2)",["S4","S4","7:3"]);
AGR.MXS("L3(3)",["3^2.2.S4","3^2.2.S4","13:3","S4"]);
AGR.MXS("L3(4)",["2^4:A5","2^4:A5","A6","A6","A6","L3(2)","L3(2)","L3(2)","3^2:Q8"]);
AGR.MXS("L3(4).D12",["L3(4).3.2_3","L3(4).6","L3(4).3.2_2","L3(4).2^2","2^(2+4):(S3xS3)","2x3^2.2.S4","S5xS3","S3x7:6"]);
AGR.MXS("L3(5)",["5^2:4S5","5^2:4S5","A5.2","4^2:S3","31:3"]);
AGR.MXS("L3(7)",["7^2:2.L2(7).2","7^2:2.L2(7).2","L3(2).2","L3(2).2","L3(2).2","(A4x3):2","3^2:Q8","19:3"]);
AGR.MXS("L3(8)",["2^6:(7xL2(8))","2^6:(7xL2(8))","7^2:S3","73:3","L3(2)"]);
AGR.MXS("L3(9)",["3^4:GL2(9)","3^4:GL2(9)","U3(3)","L3(3)","A6.2_2","8^2:S3","91:3"]);
AGR.MXS("L4(3)",["3^3:L3(3)","3^3:L3(3)","U4(2).2","U4(2).2","3^4:2(A4xA4).2","(4xA6):2","A6.2_2","S4xS4"]);
AGR.MXS("L5(2)",["2^4:A8","2^4:A8","2^6:(L3(2)xS3)","2^6:(L3(2)xS3)","31:5"]);
AGR.MXS("L5(2).2",["L5(2)"]);
AGR.MXS("L7(2).2",["L7(2)"]);
AGR.MXS("Ly",["G2(5)","3.McL.2","5^3.L3(5)","2.A11","5^(1+4):4S6","3^5:(2xM11)","3^(2+4):2A5.D8","67:22","37:18"]);
AGR.MXS("M",["2.B","2^(1+24).Co1","3.F3+.2","2^2.2E6(2).3.2",,,,,"S3xTh",,,,,,,"5^(1+6):2.J2.4",,,,,,,,"7^(1+4):(3x2.S7)",,,"(A7x(A5xA5):2^2):2",,,,,,,,,"13^(1+2):(3x4S4)",,,"11^2:(5x2.A5)",,,,"41:40"]);
AGR.MXS("M11",["A6.2_3","L2(11)","3^2:Q8.2","A5.2","2.S4"]);
AGR.MXS("M12",["M11","M11","A6.2^2","A6.2^2","L2(11)","3^2.2.S4","3^2.2.S4","2xS5","M8.S4","4^2:D12","A4xS3"]);
AGR.MXS("M12.2",["M12","L2(11).2","L2(11).2","(2^2xA5):2","D8.(S4x2)","4^2:D12.2","3^(1+2):D8","S4xS3","A5.2"]);
AGR.MXS("M22",["L3(4)","2^4:A6","A7","A7","2^4:S5","2^3:L3(2)","A6.2_3","L2(11)"]);
AGR.MXS("M22.2",["M22","L3(4).2_2","2^4:S6","2^5:S5","2x2^3:L3(2)","A6.2^2","L2(11).2"]);
AGR.MXS("M23",["M22","L3(4).2_2","2^4:A7","A8","M11","2^4:(3xA5).2","23:11"]);
AGR.MXS("M24",["M23","M22.2","2^4:A8","M12.2","2^6:3.S6","L3(4).3.2_2","2^6:(L3(2)xS3)","L2(23)","L3(2)"]);
AGR.MXS("McL",["U4(3)","M22","M22","U3(5)","3^(1+4):2S5","3^4:M10","L3(4).2_2","2.A8","2^4:A7","2^4:A7","M11","5^(1+2):3:8"]);
AGR.MXS("McL.2",["McL","U4(3).2_3","U3(5).2","3^(1+4):4S5","3^4:(M10x2)","L3(4).2^2","Isoclinic(2.A8.2)","2xM11","5^(1+2):(24:2)","2^(2+4):(S3xS3)"]);
AGR.MXS("O10+(2)",["S8(2)","2^8:O8+(2)","2^10:L5(2)"]);
AGR.MXS("O10-(2)",["2^8:O8-(2)"]);
AGR.MXS("O7(3)",["2.U4(3).2_2","3^5:U4(2):2","L4(3).2_2","G2(3)","G2(3)","3^(3+3):L3(3)","S6(2)","S6(2)","3^(1+6)_+:(2A4xA4).2","A9.2","A9.2","(2^2xU4(2)):2","2^6:A7","S6xS4","(A4x2(A4xA4).2).2"]);
AGR.MXS("O8+(2)",["S6(2)","S6(2)","S6(2)","2^6:A8","2^6:A8","2^6:A8","A9","A9","A9","(3xU4(2)):2","(3xU4(2)):2","(3xU4(2)):2","2^(1+8)_+:(S3xS3xS3)","3^4:2^3.S4","(A5xA5):2^2","(A5xA5):2^2","(A5xA5):2^2"]);
AGR.MXS("O8+(2).2",[,"2xS6(2)"]);
AGR.MXS("O8+(3)",["O7(3)","O7(3)","O7(3)","O7(3)","O7(3)","O7(3)","3^6:L4(3)","3^6:L4(3)","3^6:L4(3)","O8+(2)","O8+(2)","O8+(2)","O8+(2)","3^(1+8)_+:2(A4xA4xA4).2","2.U4(3).(2^2)_(122)","2.U4(3).(2^2)_(122)","2.U4(3).(2^2)_(122)","(A4xU4(2)):2","(A4xU4(2)):2","(A4xU4(2)):2","(A4xU4(2)):2","(A4xU4(2)):2","(A4xU4(2)):2","(A6xA6):2^2","(A6xA6):2^2","(A6xA6):2^2","2((A4wr2^2):2)"]);
AGR.MXS("O8-(2)",["2^6:U4(2)"]);
AGR.MXS("O8-(3)",[,"O7(3).2","O7(3).2",,,,"S4xU4(2).2","S4xU4(2).2","L2(81).2_1"]);
AGR.MXS("O8-(3).2_1",[,,"O7(3).2x2","O7(3).2x2",,,"D8xL4(3).2_2",,,"L2(81).4_1"]);
AGR.MXS("ON",["L3(7).2","L3(7).2","J1","4_2.L3(4).2_1","(3^2:4xA6).2","3^4:2^(1+4)D10","L2(31)","L2(31)","4^3.L3(2)","M11","M11","A7","A7"]);
AGR.MXS("ON.2",["ON","J1x2","4_2.L3(4).(2^2)_(12*3)","(3^2:4xA6).2^2","3^4:2^(1+4).(5:4)","4^3.(L3(2)x2)","7^(1+2)_+:(3xD16)","31:30","A6.2_2","L3(2).2"]);
AGR.MXS("Ru",["2F4(2)'.2","(2^6:U3(3)):2","(2^2xSz(8)):3","2^3+8:L3(2)","U3(5).2","2.2^(4+6):S5","L2(25).2^2","A8","L2(29)","5^2:4S5","3.A6.2^2","5^1+2:(2^5)","L2(13).2","A6.2^2","5:4xA5"]);
AGR.MXS("S4(4)",["2^6:(3xA5)","2^6:(3xA5)","L2(16).2","L2(16).2","(A5xA5):2","(A5xA5):2","A6.2_1"]);
AGR.MXS("S4(4).2",["S4(4)","2^6:(3xA5):2","2^6:(3xA5):2","L2(16).4","L2(16).4","(A5xA5):2^2","(A5xA5):2^2","S6x2"]);
AGR.MXS("S4(5)",["5^(1+2)+:4A5","5^3:(2xA5).2","L2(25).2_2","2.(A5xA5).2","2^4:A5","S5xS3","(2^2xA5):2","A6"]);
AGR.MXS("S6(2)",["U4(2).2","A8.2","2^5:S6","U3(3).2","2^6:L3(2)","2.[2^6]:(S3xS3)","S3xS6","L2(8).3"]);
AGR.MXS("S6(3)",["3^(1+4).2U4(2)","3^6:L3(3)","3^(3+4):2(S4xA4)","2.(A4xU4(2))","2^(2+6):3^3:S3","L2(27).3","2xU3(3).2","L3(3).2","L2(13)","L2(13)","A5"]);
AGR.MXS("S6(3).2",["3^(1+4).2U4(2).2"]);
AGR.MXS("S8(2)",["O8-(2).2","O8+(2).2","2^7:S6(2)","2^10.A8","2^(3+8):(S3xS6)","S3xS6(2)","2^(6+6):(S3xL3(2))","A10.2","S4(4).2","(S6xS6):2","L2(17)"]);
AGR.MXS("Suz",["G2(4)","3_2.U4(3).2_3'","U5(2)","2^(1+6)_-.U4(2)","3^5:M11","J2.2","2^(4+6):3A6","(A4xL3(4)):2_1","2^(2+8):(A5xS3)","M12.2","3^(2+4):2(A4x2^2).2","(A6xA5).2","(3^2:4xA6).2","L3(3).2","L3(3).2","L2(25)","A7"]);
AGR.MXS("Suz.2",["Suz","G2(4).2","3_2.U4(3).(2^2)_(133)","U5(2).2","2^(1+6)_-.U4(2).2","3^5:(M11x2)","J2.2x2","2^(4+6):3S6","(A4xL3(4):2_3):2","2^(2+8):(S5xS3)","M12.2x2","3^(2+4):2(S4xD8)","(A6:2_2xA5).2","(3^2:8xA6).2","L2(25).2_2","A7.2"]);
AGR.MXS("Sz(32)",["2^(5+5):31","41:4","25:4","D62"]);
AGR.MXS("Sz(8)",["2^(3+3):7","13:4","5:4","D14"]);
AGR.MXS("Sz(8).3",["Sz(8)","2^(3+3):7:3","13:12","5:4x3","7:6"]);
AGR.MXS("Th",["3D4(2).3","2^5.L5(2)","2^(1+8)_+.A9","U3(8).6","(3xG2(3)):2","[3^9].2S4","3^2.[3^7].2S4","3^5:2S6","5^(1+2):4S4","5^2:4S5","7^2:(3x2S4)","L2(19).2","L3(3)","A6.2_3","31:15","A5.2"]);
AGR.MXS("U3(11)",["11^(1+2)+:40","2(L2(11)x2).2","L2(11).2","L2(11).2","L2(11).2","A6","A6","A6","(4^2x3):S3","37:3","3^2:Q8"]);
AGR.MXS("U3(3).2",["U3(3)","3^(1+2):SD16","L3(2).2","2^(1+4).S3","4^2:D12"]);
AGR.MXS("U3(4)",["2^(2+4):15","5xA5","5^2:S3","13:3"]);
AGR.MXS("U3(4).2",["U3(4)","2^(2+4):(3xD10)","A5xD10","5^2:D12","13:6"]);
AGR.MXS("U3(5)",["A7","A7","A7","5^(1+2)+:8","A6.2_3","A6.2_3","A6.2_3","2.A5.2"]);
AGR.MXS("U3(5).2",["U3(5)","A7.2","5^(1+2):(8.2)","A6.2^2","2S5.2","L3(2).2"]);
AGR.MXS("U3(5).3",["U3(5)","5^(1+2)+:24","3x2S5","3^2:2A4","6^2:S3","7:3x3"]);
AGR.MXS("U3(7)",["7^(1+2):48","2(L2(7)x4).2","8^2:S3","L3(2).2","43:3"]);
AGR.MXS("U3(8)",["2^(3+6):21","3xL2(8)","3^2:2A4","3^2:2A4","3^2:2A4","(9x3).S3","19:3"]);
AGR.MXS("U3(9)",["3^(2+4):80","5xIsoclinic(2.A6.2_2)","A6.2_2","10^2:S3","73:3"]);
AGR.MXS("U4(2)",["2^4:A5","A6.2_1","3^(1+2)+:2A4","3^3:S4","2.(A4xA4).2"]);
AGR.MXS("U4(2).2",["U4(2)","2^5:S5","S6x2","3^(1+2)+:2S4","3^3:(S4x2)","W(F4)"]);
AGR.MXS("U4(3)",["3^4:A6","U4(2)","U4(2)","L3(4)","L3(4)","3^(1+4)_+.2S4","U3(3)","2^4:A6","2^4:A6","A7","A7","A7","A7","2(A4xA4).2^2","A6.2_3","A6.2_3"]);
AGR.MXS("U4(3).2_1",["U4(3)","3^4:(2xA6)","U4(2).2","U4(2).2","L3(4).2_2","L3(4).2_2","3^(1+4)+.4S4","2xU3(3)","2^4.S6","2^4.S6","4(A4xA4).4","A6.2^2","A6.2^2"]);
AGR.MXS("U4(3).2_3",["U4(3)","3^4:M10","L3(4).2_3","L3(4).2_1","3^(1+4):4S4","U3(3).2","2(A4xA4).4.2","M10x2","A6.2^2","A6.2^2","(4^2x2)S4"]);
AGR.MXS("U5(2)",["2^(1+6):3^(1+2):2A4","3xU4(2)","2^(4+4):(3xA5)","3^4:S5","S3x3^(1+2)+:2A4","L2(11)"]);
AGR.MXS("U6(2)",["U5(2)","2^(1+8)_+:U4(2)","2^9.L3(4)","U4(3).2_2","U4(3).2_2","U4(3).2_2","2^(4+8):(S3xA5)","S6(2)","S6(2)","S6(2)","M22","M22","M22","S3xU4(2)","3^(1+4).2^(1+1+2+2).S3","L3(4).2_1"]);
AGR.MXS("U6(2).2",[,"U5(2).2",,,,,,"M22.2"]);


#############################################################################
##
##  Store information about generators of kernels.
##
AGR.KERPRG("12.M22",[1,"M22",[[1,1,2,1],[3,1,3,1],[2,-1],[1,1,5,1],[4,1,6,1],[[7,5]]]]);
AGR.KERPRG("12.M22.2",[1,"M22.2",[[1,1,2,1],[3,1,2,1],[1,-1,2,-1,1,1,2,1],[3,1,3,1],[4,1,4,1],[6,1,7,1],[[8,3],[5,4]]]]);
AGR.KERPRG("12_1.L3(4)",[1,"L3(4)",[[1,1,2,1],[2,1,1,1],[1,1,4,1],[3,1,5,1],[2,2],[7,1,1,1],[2,-1],[9,1,3,1],[8,1,10,1],[6,1,11,1],[1,1,7,1],[3,1,13,1],[9,1,1,1],[1,1,15,1],[2,1,3,1],[16,1,17,1],[14,1,18,1],[12,1,19,1],[13,1,16,1],[17,1,13,1],[21,1,22,1],[1,1,9,1],[24,1,5,1],[4,1,7,1],[26,1,24,1],[25,1,27,1],[23,1,28,1],[[20,1,29,1]]]]);
AGR.KERPRG("12_2.L3(4)",[1,"L3(4)",[[1,1,2,1],[2,1,1,1],[1,1,4,1],[3,1,5,1],[2,2],[7,1,1,1],[2,-1],[9,1,3,1],[8,1,10,1],[6,1,11,1],[1,1,7,1],[3,1,13,1],[9,1,1,1],[1,1,15,1],[2,1,3,1],[16,1,17,1],[14,1,18,1],[12,1,19,1],[13,1,16,1],[17,1,13,1],[21,1,22,1],[1,1,9,1],[24,1,5,1],[4,1,7,1],[26,1,24,1],[25,1,27,1],[23,1,28,1],[[20,1,29,1]]]]);
AGR.KERPRG("2.A14.2",[1,"A14.2",[[2,1,1,1],[1,1,3,1],[3,2],[4,1,5,1],[1,1,2,1],[2,1,7,1],[7,2],[8,1,9,1],[6,1,10,1],[[11,2]]]]);
AGR.KERPRG("2.A5",[1,"A5",[[[1,2]]]]);
AGR.KERPRG("2.A5.2",[1,"A5.2",[[[2,4]]]]);
AGR.KERPRG("2.A6",[1,"A6",[[[1,2]]]]);
AGR.KERPRG("2.A6.2_1",[1,"A6.2_1",[[1,1,2,1],[[3,6]]]]);
AGR.KERPRG("2.Fi22",[1,"Fi22",[[1,1,2,1],[3,1,2,1],[[4,21]]]]);
AGR.KERPRG("2.Fi22.2",[1,"Fi22.2",[[1,-1,2,-1,1,1,2,1],[[3,3]]]]);
AGR.KERPRG("2.HS",[1,"HS",[[1,1,2,1],[3,1,2,1],[[4,10]]]]);
AGR.KERPRG("2.HS.2",[1,"HS.2",[[1,-1,2,-1,1,1,2,1],[[3,3]]]]);
AGR.KERPRG("2.J2",[1,"J2",[[[1,2]]]]);
AGR.KERPRG("2.L2(11)",[1,"L2(11)",[[[1,2]]]]);
AGR.KERPRG("2.L3(2)",[1,"L3(2)",[[[1,2]]]]);
AGR.KERPRG("2.L3(2).2",[1,"L3(2).2",[[[1,2]]]]);
AGR.KERPRG("2.L3(4)",[1,"L3(4)",[[1,1,2,1],[2,1,1,1],[1,1,4,1],[3,1,5,1],[2,2],[7,1,1,1],[2,-1],[9,1,3,1],[8,1,10,1],[6,1,11,1],[1,1,7,1],[3,1,13,1],[9,1,1,1],[1,1,15,1],[2,1,3,1],[16,1,17,1],[14,1,18,1],[12,1,19,1],[13,1,16,1],[17,1,13,1],[21,1,22,1],[1,1,9,1],[24,1,5,1],[4,1,7,1],[26,1,24,1],[25,1,27,1],[23,1,28,1],[[20,1,29,1]]]]);
AGR.KERPRG("2.M12",[1,"M12",[[[2,3]]]]);
AGR.KERPRG("2.M12.2",[1,"M12.2",[[1,1,2,1],[[3,12]]]]);
AGR.KERPRG("2.M22",[1,"M22",[[1,1,2,1],[3,1,3,1],[2,-1],[1,1,5,1],[4,1,6,1],[[7,5]]]]);
AGR.KERPRG("2.M22.2",[1,"M22.2",[[1,1,2,1],[3,1,2,1],[3,1,3,1],[4,1,4,1],[5,1,6,1],[[7,3]]]]);
AGR.KERPRG("2.S6(2)",[1,"S6(2)",[[[1,2]]]]);
AGR.KERPRG("2.Sz(8)",[1,"Sz(8)",[[2,1,1,1],[1,1,3,1],[2,2],[5,1,1,1],[4,1,6,1],[2,-1],[1,1,2,1],[8,1,9,1],[6,1,10,1],[7,1,11,1],[1,1,5,1],[13,2],[8,1,1,1],[1,1,15,1],[3,1,5,1],[16,1,17,1],[14,1,18,1],[12,1,19,1],[13,1,16,1],[17,1,13,1],[21,1,22,1],[1,1,8,1],[13,1,24,1],[18,1,25,1],[23,1,26,1],[[20,1,27,1]]]]);
AGR.KERPRG("2.U4(2)",[1,"U4(2)",[[1,-1],[2,-1],[3,1,4,1],[5,2],[1,1,2,1],[7,2],[6,1,8,1],[[9,2]]]]);
AGR.KERPRG("2^2.Sz(8).3",[1,"Sz(8).3",[[1,-1],[3,1,2,1],[2,-1],[3,1,5,1],[4,1,6,1],[2,1,3,1],[3,1,8,1],[6,1,9,1],[7,1,10,1],[5,1,3,1],[12,2],[2,1,6,1],[8,1,14,1],[13,1,15,1],[11,1,16,1],[1,1,2,1],[1,1,5,1],[18,1,19,1],[2,1,1,1],[1,1,21,1],[19,1,22,1],[20,1,23,1],[5,1,1,1],[21,1,25,1],[2,1,19,1],[21,1,27,1],[26,1,28,1],[24,1,29,1],[17,1,30,1],[[1,1,2,1],3],[[2,1,1,1],4],[[1,1,4,1],5],[[3,1,5,1],6],[[2,1,3,1],7],[[7,1,5,1],8],[[6,1,8,1],9],[[2,-1],10],[[1,1,10,1],11],[[2,1,11,1],12],[[10,1,1,1],13],[[1,1,13,1],14],[[12,1,14,1],15],[[10,1,11,1],16],[[16,1,5,1],17],[[15,1,17,1],18],[[9,1,18,1],19],[[4,1,7,1],20],[[14,1,7,1],21],[[20,1,21,1],22],[[5,1,16,1],23],[[14,1,16,1],24],[[23,1,24,1],25],[[22,1,25,1],26],[[19,1,26,1],27],[[31,1],[27,1]]]]);
AGR.KERPRG("3.A6",[1,"A6",[[1,1,2,1],[[3,5]]]]);
AGR.KERPRG("3.A6.2_1",[1,"A6.2_1",[[1,1,2,1],[2,1,3,1],[1,-1,4,-1,1,1,4,1],[[5,2]]]]);
AGR.KERPRG("3.Fi22",[1,"Fi22",[[1,1,2,1],[[3,11]]]]);
AGR.KERPRG("3.Fi22.2",[1,"Fi22.2",[[1,1,2,1],[2,-1],[1,1,4,1],[5,1,4,1],[3,1,6,1],[7,1,4,1],[[8,8]]]]);
AGR.KERPRG("3.G2(3)",[1,"G2(3)",[[1,1,2,1],[3,1,3,1],[3,3],[2,-1],[1,1,6,1],[5,1,7,1],[8,1,8,1],[9,1,4,1],[10,1,7,1],[11,1,7,1],[[12,2]]]]);
AGR.KERPRG("3.J3",[1,"J3",[[1,1,2,1],[3,2],[2,1,1,1],[1,1,5,1],[3,1,6,1],[4,1,7,1],[2,1,3,1],[5,1,9,1],[10,1,7,1],[8,1,11,1],[5,2],[13,1,10,1],[7,1,10,1],[14,1,15,1],[[12,1,16,1]]]]);
AGR.KERPRG("3.J3.2",[1,"J3.2",[[1,-1],[2,-1],[4,1,3,1],[3,1,5,1],[2,1,3,1],[7,2],[6,1,8,1],[3,1,4,1],[4,1,10,1],[10,2],[11,1,12,1],[9,1,13,1],[2,1,1,1],[1,1,15,1],[15,2],[16,1,17,1],[1,1,4,1],[2,1,19,1],[1,1,2,1],[19,1,21,1],[20,1,22,1],[18,1,23,1],[14,1,24,1],[[25,2]]]]);
AGR.KERPRG("3.L3(4)",[1,"L3(4)",[[2,1,1,1],[1,1,3,1],[3,2],[4,1,5,1],[1,1,2,1],[2,1,7,1],[7,2],[8,1,9,1],[[6,1,10,1]]]]);
AGR.KERPRG("3.M22",[1,"M22",[[1,1,2,1],[[3,11]]]]);
AGR.KERPRG("3.M22.2",[1,"M22.2",[[1,-1,2,-1,1,1,2,1],[[3,4]]]]);
AGR.KERPRG("3.McL",[1,"McL",[[1,1,2,1],[[3,11]]]]);
AGR.KERPRG("3.McL.2",[1,"McL.2",[[1,1,2,1],[2,-1],[1,1,4,1],[3,1,5,1],[2,1,6,1],[7,1,1,1],[8,1,8,1],[9,1,2,1],[5,1,5,1],[10,1,11,1],[[1,-1,12,-1,1,1,12,1]]]]);
AGR.KERPRG("3.U3(8)",[1,"U3(8)",[[1,1,2,1],[3,3],[2,-1],[1,1,5,1],[4,1,6,1],[7,3],[8,1,6,1],[9,1,3,1],[6,3],[10,1,11,1],[12,1,3,1],[13,1,6,1],[[14,1,6,1]]]]);
AGR.KERPRG("4.M22",[1,"M22",[[1,1,2,1],[3,1,3,1],[2,-1],[1,1,5,1],[4,1,6,1],[[7,5]]]]);
AGR.KERPRG("4.M22.2",[1,"M22.2",[[1,1,2,1],[3,1,2,1],[3,1,3,1],[4,1,4,1],[5,1,6,1],[[7,3]]]]);
AGR.KERPRG("4_1.L3(4)",[1,"L3(4)",[[1,1,2,1],[2,1,1,1],[1,1,4,1],[3,1,5,1],[2,2],[7,1,1,1],[2,-1],[9,1,3,1],[8,1,10,1],[6,1,11,1],[1,1,7,1],[3,1,13,1],[9,1,1,1],[1,1,15,1],[2,1,3,1],[16,1,17,1],[14,1,18,1],[12,1,19,1],[13,1,16,1],[17,1,13,1],[21,1,22,1],[1,1,9,1],[24,1,5,1],[4,1,7,1],[26,1,24,1],[25,1,27,1],[23,1,28,1],[[20,1,29,1]]]]);
AGR.KERPRG("4_2.L3(4)",[1,"L3(4)",[[1,1,2,1],[2,1,1,1],[1,1,4,1],[3,1,5,1],[2,2],[7,1,1,1],[2,-1],[9,1,3,1],[8,1,10,1],[6,1,11,1],[1,1,7,1],[3,1,13,1],[9,1,1,1],[1,1,15,1],[2,1,3,1],[16,1,17,1],[14,1,18,1],[12,1,19,1],[13,1,16,1],[17,1,13,1],[21,1,22,1],[1,1,9,1],[24,1,5,1],[4,1,7,1],[26,1,24,1],[25,1,27,1],[23,1,28,1],[[20,1,29,1]]]]);
AGR.KERPRG("6.A6",[1,"A6",[[1,1,2,1],[[3,5],[1,2]]]]);
AGR.KERPRG("6.A6.2_1",[1,"A6.2_1",[[1,1,2,1],[2,1,3,1],[1,-1,4,-1,1,1,4,1],[[5,2]]]]);
AGR.KERPRG("6.Fi22",[1,"2.Fi22",[[1,1,2,1],[2,1,1,1],[1,1,4,1],[3,1,5,1],[2,1,3,1],[7,1,5,1],[6,1,8,1],[4,1,7,1],[5,1,7,1],[10,1,11,1],[[9,1,12,1]]]]);
AGR.KERPRG("6.Fi22",[1,"Fi22",[[1,1,2,1],[3,1,2,1],[[3,11],[4,21]]]]);
AGR.KERPRG("6.Fi22.2",[1,"3.Fi22.2",[[1,-1],[2,-1],[4,1,1,1],[3,1,5,1],[3,1,4,1],[2,1,7,1],[6,1,8,1],[2,1,3,1],[1,1,10,1],[1,1,2,1],[4,1,12,1],[11,1,13,1],[[9,1,14,1]]]]);
AGR.KERPRG("6.Fi22.2",[1,"Fi22.2",[[1,1,2,1],[1,-1,2,-1,1,1,2,1],[2,-1],[1,1,5,1],[6,1,5,1],[3,1,7,1],[8,1,5,1],[[9,8],[4,3]]]]);
AGR.KERPRG("6.L3(4)",[1,"L3(4)",[[1,1,2,1],[2,1,1,1],[1,1,4,1],[3,1,5,1],[2,2],[7,1,1,1],[2,-1],[9,1,3,1],[8,1,10,1],[6,1,11,1],[1,1,7,1],[3,1,13,1],[9,1,1,1],[1,1,15,1],[2,1,3,1],[16,1,17,1],[14,1,18,1],[12,1,19,1],[13,1,16,1],[17,1,13,1],[21,1,22,1],[1,1,9,1],[24,1,5,1],[4,1,7,1],[26,1,24,1],[25,1,27,1],[23,1,28,1],[[20,1,29,1]]]]);
AGR.KERPRG("6.M22",[1,"M22",[[1,1,2,1],[3,1,3,1],[2,-1],[1,1,5,1],[4,1,6,1],[[7,5]]]]);
AGR.KERPRG("6.M22.2",[1,"M22.2",[[1,1,2,1],[3,1,2,1],[1,-1,2,-1,1,1,2,1],[3,1,3,1],[4,1,4,1],[6,1,7,1],[[5,4],[8,3]]]]);
AGR.KERPRG("Isoclinic(2.A14.2)",[1,"A14.2",[[[1,2]]]]);
AGR.KERPRG("Isoclinic(2.A5.2)",[1,"A5.2",[[[1,2]]]]);
AGR.KERPRG("Isoclinic(2.L3(2).2)",[1,"L3(2).2",[[1,1,2,1],[[3,8]]]]);
AGR.KERPRG("Isoclinic(2.M12.2)",[1,"M12.2",[[[1,2]]]]);


#############################################################################
##
##  In the following, the table of contents is built
##  using `AGR.GRP' and `AGR.TOC'.
##  This part of the file is created by the function
##  `StringOfAtlasTableOfContents',
##  do not edit below this line!
##

# 2A10
AGR.GRP("alt","A10","2A10");
AGR.TOC("matff","2A10G1-f3r16B0.m",[133558569,7751303]);
AGR.TOC("matff","2A10G1-f5r8B0.m",[-66877760,-10441825]);
AGR.TOC("matff","2A10G1-f5r56B0.m",[106114504,-34223356]);
AGR.TOC("matff","2A10G1-f7r16B0.m",[-17220168,-70753499]);

# A10
AGR.GRP("alt","A10","A10");
AGR.TOC("perm","A10G1-p10B0.m",[-71915152,-73743375]);
AGR.TOC("perm","A10G1-p45B0.m",[-93592591,-129651627]);
AGR.TOC("perm","A10G1-p120B0.m",[-50460702,13210237]);
AGR.TOC("perm","A10G1-p126B0.m",[106657390,2967288]);
AGR.TOC("perm","A10G1-p210B0.m",[-16598970,-21414041]);
AGR.TOC("perm","A10G1-p945B0.m",[-111054132,-8787620]);
AGR.TOC("perm","A10G1-p2520B0.m",[-5920330,-5194892]);
AGR.TOC("matff","A10G1-f2r8B0.m",[-61586491,-36854292]);
AGR.TOC("matff","A10G1-f2r16B0.m",[120160813,-8096924]);
AGR.TOC("matff","A10G1-f2r26B0.m",[-127808259,51214305]);
AGR.TOC("matff","A10G1-f2r48B0.m",[-40159069,69033293]);
AGR.TOC("matff","A10G1-f2r64aB0.m",[102693129,-74620347]);
AGR.TOC("matff","A10G1-f2r64bB0.m",[-41003654,-56409287]);
AGR.TOC("matff","A10G1-f2r160B0.m",[-108474931,53236873]);
AGR.TOC("matff","A10G1-f2r198B0.m",[-105966471,-118468514]);
AGR.TOC("matff","A10G1-f2r200B0.m",[-8656884,-35106257]);
AGR.TOC("matff","A10G1-f3r9B0.m",[53453595,12047353]);
AGR.TOC("matff","A10G1-f3r34B0.m",[116362581,125729281]);
AGR.TOC("matff","A10G1-f3r36B0.m",[106455816,-64542057]);
AGR.TOC("matff","A10G1-f3r41B0.m",[14653233,-29570979]);
AGR.TOC("matff","A10G1-f3r84B0.m",[94415076,14658731]);
AGR.TOC("matff","A10G1-f3r90B0.m",[78489388,-59686310]);
AGR.TOC("matff","A10G1-f3r126B0.m",[-78356361,-85812365]);
AGR.TOC("matff","A10G1-f3r224B0.m",[1648760,856544]);
AGR.TOC("matff","A10G1-f3r279B0.m",[-116520136,28162794]);
AGR.TOC("matff","A10G1-f3r567B0.m",[91011213,-74458450]);
AGR.TOC("matff","A10G1-f4r384aB0.m",[-123207845,39275593]);
AGR.TOC("matff","A10G1-f5r8B0.m",[27026655,56661990]);
AGR.TOC("matff","A10G1-f5r28B0.m",[-90587278,80332445]);
AGR.TOC("matff","A10G1-f5r34B0.m",[98789892,-75428680]);
AGR.TOC("matff","A10G1-f5r35aB0.m",[-119474236,-52956779]);
AGR.TOC("matff","A10G1-f5r35bB0.m",[-53484651,-10489273]);
AGR.TOC("matff","A10G1-f5r35cB0.m",[11802060,-95818840]);
AGR.TOC("matff","A10G1-f5r55B0.m",[82888492,-102206841]);
AGR.TOC("matff","A10G1-f5r56B0.m",[114319833,-105781281]);
AGR.TOC("matff","A10G1-f5r75B0.m",[81229174,-32299609]);
AGR.TOC("matff","A10G1-f5r133aB0.m",[-70040930,-96735440]);
AGR.TOC("matff","A10G1-f5r133bB0.m",[51493024,-129195790]);
AGR.TOC("matff","A10G1-f5r155B0.m",[92717858,102394010]);
AGR.TOC("matff","A10G1-f5r160B0.m",[49454731,-48474287]);
AGR.TOC("matff","A10G1-f5r217B0.m",[-56235224,15247604]);
AGR.TOC("matff","A10G1-f5r225B0.m",[-8190879,-97782454]);
AGR.TOC("matff","A10G1-f5r300B0.m",[52787442,-91676435]);
AGR.TOC("matff","A10G1-f5r350B0.m",[46749588,-77482077]);
AGR.TOC("matff","A10G1-f5r450B0.m",[-117440006,132712395]);
AGR.TOC("matff","A10G1-f5r525B0.m",[75956453,29937350]);
AGR.TOC("matff","A10G1-f7r9B0.m",[65794752,-108123775]);
AGR.TOC("matff","A10G1-f7r35B0.m",[68087422,-120300608]);
AGR.TOC("matff","A10G1-f7r36B0.m",[-110628719,-116256108]);
AGR.TOC("matff","A10G1-f7r66B0.m",[18002903,71997331]);
AGR.TOC("matff","A10G1-f7r84B0.m",[6021581,68325023]);
AGR.TOC("matff","A10G1-f7r89B0.m",[112847925,110296210]);
AGR.TOC("matff","A10G1-f7r124B0.m",[100318150,-86258861]);
AGR.TOC("matff","A10G1-f7r126B0.m",[6788301,77348841]);
AGR.TOC("matff","A10G1-f7r315B0.m",[103282695,-131481983]);
AGR.TOC("matint","A10G1-Zr9B0.g",[-98891693]);
AGR.TOC("matint","A10G1-Zr35B0.g",[-32813966]);
AGR.TOC("matint","A10G1-Zr36B0.g",[-96721693]);
AGR.TOC("matint","A10G1-Zr42B0.g",[-42808704]);
AGR.TOC("matint","A10G1-Zr75B0.g",[-39718615]);
AGR.TOC("matint","A10G1-Zr84B0.g",[-72574348]);
AGR.TOC("matint","A10G1-Zr90B0.g",[92280715]);
AGR.TOC("matint","A10G1-Zr126B0.g",[-95054011]);
AGR.TOC("matint","A10G1-Zr160B0.g",[130677506]);
AGR.TOC("matint","A10G1-Zr210B0.g",[-50324182]);
AGR.TOC("matint","A10G1-Zr224aB0.g",[14449435]);
AGR.TOC("matint","A10G1-Zr224bB0.g",[9722007]);
AGR.TOC("matint","A10G1-Zr225B0.g",[92776450]);
AGR.TOC("check","A10G1-check1",[-65939754]);

# S10
AGR.GRP("alt","A10","S10");
AGR.TOC("perm","S10G1-p10B0.m",[102663828,111534310]);

# 2A11
AGR.GRP("alt","A11","2A11");
AGR.TOC("perm","2A11G1-p5040B0.m",[10338093,35097820]);
AGR.TOC("matff","2A11G1-f3r16aB0.m",[123701682,33852482]);
AGR.TOC("matff","2A11G1-f3r16bB0.m",[123701682,59228723]);
AGR.TOC("matff","2A11G1-f3r144B0.m",[-116903691,64591009]);
AGR.TOC("matff","2A11G1-f5r16aB0.m",[-32608610,80948254]);
AGR.TOC("matff","2A11G1-f5r16bB0.m",[-32608610,-113956471]);
AGR.TOC("matff","2A11G1-f5r56aB0.m",[-4539481,-34223356]);
AGR.TOC("matff","2A11G1-f5r56bB0.m",[-118415370,-34223356]);
AGR.TOC("matff","2A11G1-f7r32B0.m",[46215404,-49071614]);
AGR.TOC("matff","2A11G1-f7r144B0.m",[30881969,-49107182]);
AGR.TOC("matff","2A11G1-f11r16B0.m",[58396455,-65921882]);
AGR.TOC("matff","2A11G1-f11r128B0.m",[114324617,-72745045]);
AGR.TOC("matff","2A11G1-f49r16aB0.m",[11117236,19201506]);
AGR.TOC("matff","2A11G1-f49r16bB0.m",[11117236,-96707409]);

# 2S11
AGR.GRP("alt","A11","2S11");
AGR.TOC("matff","2S11G1-f3r32B0.m",[-49041992,-17616148]);
AGR.TOC("matff","2S11G1-f5r32B0.m",[121729623,-29237387]);
AGR.TOC("matff","2S11G1-f7r32B0.m",[52776906,-56309454]);
AGR.TOC("matff","2S11G1-f11r16B0.m",[43570399,99053214]);

# A11
AGR.GRP("alt","A11","A11");
AGR.TOC("perm","A11G1-p11B0.m",[-122422017,-50694995]);
AGR.TOC("perm","A11G1-p55B0.m",[-57050664,-129624707]);
AGR.TOC("perm","A11G1-p165B0.m",[-18343151,-94008167]);
AGR.TOC("perm","A11G1-p330B0.m",[91822824,134140254]);
AGR.TOC("perm","A11G1-p462B0.m",[-56401454,11231997]);
AGR.TOC("perm","A11G1-p2520aB0.m",[105442601,37888423]);
AGR.TOC("perm","A11G1-p2520bB0.m",[72615956,-84822869]);
AGR.TOC("matff","A11G1-f2r10B0.m",[48163131,5174220]);
AGR.TOC("matff","A11G1-f2r32B0.m",[117207733,-97550131]);
AGR.TOC("matff","A11G1-f2r44B0.m",[-46914518,-72072210]);
AGR.TOC("matff","A11G1-f2r100B0.m",[-128987094,-105207191]);
AGR.TOC("matff","A11G1-f2r144B0.m",[-2485893,114401636]);
AGR.TOC("matff","A11G1-f2r164B0.m",[-79537173,-81254819]);
AGR.TOC("matff","A11G1-f2r186B0.m",[-52751286,111580947]);
AGR.TOC("matff","A11G1-f2r198B0.m",[-2524017,-12277084]);
AGR.TOC("matff","A11G1-f2r416B0.m",[-15467113,-22612587]);
AGR.TOC("matff","A11G1-f2r848B0.m",[55633855,-13433644]);
AGR.TOC("matff","A11G1-f3r10B0.m",[34106404,11555461]);
AGR.TOC("matff","A11G1-f3r34B0.m",[61022628,95804131]);
AGR.TOC("matff","A11G1-f3r45B0.m",[-130379009,62508909]);
AGR.TOC("matff","A11G1-f3r109B0.m",[-41552477,63109273]);
AGR.TOC("matff","A11G1-f3r120B0.m",[-9761398,-30517684]);
AGR.TOC("matff","A11G1-f3r126aB0.m",[35299060,-55406114]);
AGR.TOC("matff","A11G1-f3r126bB0.m",[78437011,-77493126]);
AGR.TOC("matff","A11G1-f3r131B0.m",[84327974,84262247]);
AGR.TOC("matff","A11G1-f4r16aB0.m",[18792134,-62212692]);
AGR.TOC("matff","A11G1-f4r16bB0.m",[18792134,46533207]);
AGR.TOC("matff","A11G1-f4r584aB0.m",[8633406,11959365]);
AGR.TOC("matff","A11G1-f5r10B0.m",[-94207968,42329417]);
AGR.TOC("matff","A11G1-f5r43B0.m",[34567817,73351777]);
AGR.TOC("matff","A11G1-f5r45B0.m",[73321059,-120290804]);
AGR.TOC("matff","A11G1-f5r55B0.m",[28166287,41124467]);
AGR.TOC("matff","A11G1-f5r89B0.m",[86657222,-77993041]);
AGR.TOC("matff","A11G1-f5r110B0.m",[-70012073,89366508]);
AGR.TOC("matff","A11G1-f5r120B0.m",[-76119583,126633378]);
AGR.TOC("matff","A11G1-f7r10B0.m",[39992086,112310009]);
AGR.TOC("matff","A11G1-f7r44B0.m",[36269917,-84016762]);
AGR.TOC("matff","A11G1-f7r45B0.m",[66954439,-20316453]);
AGR.TOC("matff","A11G1-f7r66B0.m",[-108604335,-125185286]);
AGR.TOC("matff","A11G1-f11r9B0.m",[112234857,49850484]);
AGR.TOC("matff","A11G1-f11r36B0.m",[-20142313,14189331]);
AGR.TOC("matff","A11G1-f11r44B0.m",[52850788,29978961]);
AGR.TOC("matff","A11G1-f11r84B0.m",[36508214,39409034]);
AGR.TOC("matint","A11G1-Zr10B0.g",[23979533]);
AGR.TOC("matint","A11G1-Zr44B0.g",[-14246691]);
AGR.TOC("matint","A11G1-Zr45B0.g",[29857511]);
AGR.TOC("matint","A11G1-Zr110B0.g",[-52829325]);
AGR.TOC("matint","A11G1-Zr120B0.g",[-23105539]);
AGR.TOC("matint","A11G1-Zr132B0.g",[-67485169]);
AGR.TOC("matint","A11G1-Zr165B0.g",[23994767]);
AGR.TOC("matint","A11G1-Zr210B0.g",[-7633503]);
AGR.TOC("matint","A11G1-Zr231B0.g",[128797722]);
AGR.TOC("matint","A11G1-Zr252B0.g",[28693334]);
AGR.TOC("check","A11G1-check1",[-31402064]);

# S11
AGR.GRP("alt","A11","S11");
AGR.TOC("perm","S11G1-p11B0.m",[-62830795,90530455]);
AGR.TOC("matff","S11G1-f2r32B0.m",[36065907,-112645797]);

# 2A12
AGR.GRP("alt","A12","2A12");
AGR.TOC("matff","2A12G1-f3r16aB0.m",[-64225267,-54027246]);
AGR.TOC("matff","2A12G1-f3r16bB0.m",[-86938792,-126991049]);
AGR.TOC("matff","2A12G1-f5r32B0.m",[-61034870,62977689]);
AGR.TOC("matff","2A12G1-f7r32B0.m",[-103270775,5956786]);
AGR.TOC("matff","2A12G1-f11r32B0.m",[-109039991,95544775]);

# A12
AGR.GRP("alt","A12","A12");
AGR.TOC("perm","A12G1-p12B0.m",[-123345274,-118831963]);
AGR.TOC("perm","A12G1-p66B0.m",[-25246166,-18460354]);
AGR.TOC("perm","A12G1-p220B0.m",[-102069043,-40443727]);
AGR.TOC("perm","A12G1-p462B0.m",[-22764326,-42034140]);
AGR.TOC("perm","A12G1-p495B0.m",[-90795333,9383447]);
AGR.TOC("perm","A12G1-p792B0.m",[-26141474,90886507]);
AGR.TOC("perm","A12G1-p2520B0.m",[48232624,-111485628]);
AGR.TOC("matff","A12G1-f2r10B0.m",[-81984500,14420913]);
AGR.TOC("matff","A12G1-f2r44B0.m",[32152614,60375361]);
AGR.TOC("matff","A12G1-f2r100B0.m",[9829805,64944733]);
AGR.TOC("matff","A12G1-f3r10B0.m",[16812218,79853924]);
AGR.TOC("matff","A12G1-f3r45B0.m",[-45141217,110111869]);
AGR.TOC("matff","A12G1-f3r54B0.m",[-84738990,37226419]);
AGR.TOC("matff","A12G1-f4r16aB0.m",[76799659,-45499329]);
AGR.TOC("matff","A12G1-f4r16bB0.m",[119703462,-105516986]);
AGR.TOC("matff","A12G1-f5r11B0.m",[-67336691,-27340083]);
AGR.TOC("matff","A12G1-f5r43B0.m",[-20910589,119812772]);
AGR.TOC("matff","A12G1-f5r55B0.m",[-99652203,73739525]);
AGR.TOC("matff","A12G1-f5r89B0.m",[-53617829,85057506]);
AGR.TOC("matint","A12G1-Zr11B0.g",[125437313]);
AGR.TOC("matint","A12G1-Zr54B0.g",[103173145]);
AGR.TOC("matint","A12G1-Zr55B0.g",[12195196]);
AGR.TOC("matint","A12G1-Zr132B0.g",[-36047765]);
AGR.TOC("matint","A12G1-Zr154B0.g",[-52095196]);
AGR.TOC("matint","A12G1-Zr165B0.g",[-131843682]);
AGR.TOC("check","A12G1-check1",[-99479890]);

# S12
AGR.GRP("alt","A12","S12");
AGR.TOC("perm","S12G1-p12B0.m",[-42350936,107123575]);
AGR.TOC("perm","S12G1-p66B0.m",[40785526,93619813]);
AGR.TOC("perm","S12G1-p220B0.m",[57884109,89270239]);
AGR.TOC("perm","S12G1-p462B0.m",[-63147022,118662304]);
AGR.TOC("perm","S12G1-p495B0.m",[-6958359,-14984501]);
AGR.TOC("perm","S12G1-p792B0.m",[-24933435,65045476]);
AGR.TOC("perm","S12G1-p5040B0.m",[54692524,99626862]);
AGR.TOC("perm","S12G1-p5775B0.m",[-124106606,125652062]);
AGR.TOC("perm","S12G1-p10395B0.m",[-51610573,116378558]);
AGR.TOC("perm","S12G1-p15400B0.m",[-27006440,-21026234]);

# 2A13
AGR.GRP("alt","A13","2A13");
AGR.TOC("matff","2A13G1-f3r32aB0.m",[-48438656,-25967573]);
AGR.TOC("matff","2A13G1-f3r32bB0.m",[-72547795,-25967573]);
AGR.TOC("matff","2A13G1-f5r64B0.m",[106073587,32410936]);
AGR.TOC("matff","2A13G1-f7r64B0.m",[-25551508,44236352]);
AGR.TOC("matff","2A13G1-f11r64B0.m",[-117015385,78148566]);
AGR.TOC("matff","2A13G1-f13r32B0.m",[-58209584,-114347263]);
AGR.TOC("matff","2A13G1-f25r32aB0.m",[33870497,-25996768]);
AGR.TOC("matff","2A13G1-f25r32bB0.m",[-40107349,28570305]);
AGR.TOC("matff","2A13G1-f49r32aB0.m",[76294439,-63889848]);
AGR.TOC("matff","2A13G1-f49r32bB0.m",[35826406,-15518357]);
AGR.TOC("matff","2A13G1-f121r32aB0.m",[50881057,-130550372]);
AGR.TOC("matff","2A13G1-f121r32bB0.m",[50881057,-63982107]);

# A13
AGR.GRP("alt","A13","A13");
AGR.TOC("perm","A13G1-p13B0.m",[-97296261,-13656475]);
AGR.TOC("perm","A13G1-p78B0.m",[-25415461,119064830]);
AGR.TOC("matff","A13G1-f2r64B0.m",[-47634882,-104269804]);
AGR.TOC("matff","A13G1-f4r32aB0.m",[36325004,73236876]);
AGR.TOC("matff","A13G1-f4r32bB0.m",[90761494,82555595]);
AGR.TOC("matint","A13G1-Zr12B0.g",[120728346]);
AGR.TOC("matint","A13G1-Zr65B0.g",[2800773]);
AGR.TOC("matint","A13G1-Zr66B0.g",[28881576]);
AGR.TOC("matint","A13G1-Zr208B0.g",[-107534939]);
AGR.TOC("matint","A13G1-Zr220B0.g",[-88134109]);
AGR.TOC("check","A13G1-check1",[-17573913]);

# S13
AGR.GRP("alt","A13","S13");
AGR.TOC("perm","S13G1-p13B0.m",[-80071545,-100550140]);
AGR.TOC("perm","S13G1-p78B0.m",[53059074,122538641]);

# 2A14
AGR.GRP("alt","A14","2A14");
AGR.TOC("matff","2A14G1-f3r64B0.m",[-16434801,4266919]);
AGR.TOC("matff","2A14G1-f5r64B0.m",[55006074,-121179705]);
AGR.TOC("matff","2A14G1-f7r64B0.m",[35153212,-38253902]);
AGR.TOC("matff","2A14G1-f11r64B0.m",[-131121960,126664026]);
AGR.TOC("matff","2A14G1-f13r64B0.m",[53258278,-9137520]);
AGR.TOC("matff","2A14G1-f49r32aB0.m",[125306939,129831096]);
AGR.TOC("matff","2A14G1-f49r32bB0.m",[87690389,-48370874]);
AGR.TOC("pres","2A14G1-P1",[-109066728]);

# 2S14
AGR.GRP("alt","A14","2S14");
AGR.TOC("matff","2S14G1-f7r64B0.m",[-112425554,-57571696]);
AGR.TOC("pres","2S14G1-P1",[-94902193]);

# 2S14i
AGR.GRP("alt","A14","2S14i");
AGR.TOC("matff","2S14iG1-f7r64B0.m",[-57982903,108923491]);
AGR.TOC("pres","2S14iG1-P1",[-41871223]);

# A14
AGR.GRP("alt","A14","A14");
AGR.TOC("perm","A14G1-p14B0.m",[-129399038,14924943]);
AGR.TOC("perm","A14G1-p91B0.m",[-26777249,-82433735]);
AGR.TOC("perm","A14G1-p364B0.m",[-114206197,47209148]);
AGR.TOC("perm","A14G1-p1001B0.m",[-25420623,-45498004]);
AGR.TOC("perm","A14G1-p1716B0.m",[90522554,-15099649]);
AGR.TOC("perm","A14G1-p2002B0.m",[-88811657,80740978]);
AGR.TOC("perm","A14G1-p3003B0.m",[-17346905,64146685]);
AGR.TOC("matff","A14G1-f2r12B0.m",[90619692,-106206654]);
AGR.TOC("matff","A14G1-f2r64aB0.m",[-108438381,132295344]);
AGR.TOC("matff","A14G1-f2r64bB0.m",[-4604054,-42310637]);
AGR.TOC("matff","A14G1-f3r13B0.m",[-62501190,-113003570]);
AGR.TOC("matff","A14G1-f3r64B0.m",[-129854222,-101838416]);
AGR.TOC("matff","A14G1-f3r78B0.m",[106153952,59090292]);
AGR.TOC("matff","A14G1-f5r13B0.m",[-9447070,-22406909]);
AGR.TOC("matff","A14G1-f5r77B0.m",[-52183881,86223200]);
AGR.TOC("matff","A14G1-f5r78B0.m",[96776073,-98672972]);
AGR.TOC("matff","A14G1-f7r12B0.m",[8322888,20382436]);
AGR.TOC("matff","A14G1-f7r66B0.m",[-29578574,127399051]);
AGR.TOC("matff","A14G1-f7r77B0.m",[-123136507,109828362]);
AGR.TOC("matff","A14G1-f11r13B0.m",[-40579482,7070752]);
AGR.TOC("matff","A14G1-f11r77B0.m",[66192550,-81887409]);
AGR.TOC("matff","A14G1-f11r78B0.m",[-8359030,-83684564]);
AGR.TOC("matff","A14G1-f13r13B0.m",[85339373,-51256802]);
AGR.TOC("matff","A14G1-f13r76B0.m",[-50909455,-106745514]);
AGR.TOC("matff","A14G1-f13r78B0.m",[-4870702,69045892]);
AGR.TOC("matint","A14G1-Zr13B0.g",[-70843676]);
AGR.TOC("matint","A14G1-Zr77B0.g",[-2326548]);
AGR.TOC("matint","A14G1-Zr78B0.g",[89991440]);
AGR.TOC("check","A14G1-check1",[-67998098]);
AGR.TOC("pres","A14G1-P1",[86181627]);

# S14
AGR.GRP("alt","A14","S14");
AGR.TOC("perm","S14G1-p14B0.m",[-2670655,14924943]);
AGR.TOC("perm","S14G1-p91B0.m",[133786030,110984109]);
AGR.TOC("perm","S14G1-p364B0.m",[-130142219,-94014842]);
AGR.TOC("perm","S14G1-p1001B0.m",[-120548559,116913207]);
AGR.TOC("perm","S14G1-p1716B0.m",[14478156,-103414251]);
AGR.TOC("perm","S14G1-p2002B0.m",[-121582665,25702096]);
AGR.TOC("perm","S14G1-p3003B0.m",[-72022249,4619522]);
AGR.TOC("matff","S14G1-f2r12B0.m",[-40558018,-8180169]);
AGR.TOC("matff","S14G1-f2r64aB0.m",[54153929,83763681]);
AGR.TOC("matff","S14G1-f2r64bB0.m",[-117643475,-15897979]);
AGR.TOC("matff","S14G1-f7r12B0.m",[-30708602,1214955]);
AGR.TOC("pres","S14G1-P1",[14473659]);

# A15
AGR.GRP("alt","A15","A15");
AGR.TOC("perm","A15G1-p15B0.m",[-71373987,-72340264]);
AGR.TOC("perm","A15G1-p105B0.m",[13694315,27801421]);
AGR.TOC("perm","A15G1-p455B0.m",[-133728447,14431303]);
AGR.TOC("perm","A15G1-p1365B0.m",[19949471,-88212599]);
AGR.TOC("matint","A15G1-Zr14B0.g",[134144892]);
AGR.TOC("matint","A15G1-Zr90B0.g",[123203884]);
AGR.TOC("matint","A15G1-Zr91B0.g",[-108993267]);
AGR.TOC("matint","A15G1-Zr350B0.g",[-119131883]);
AGR.TOC("matint","A15G1-Zr364B0.g",[60710542]);
AGR.TOC("check","A15G1-check1",[24354086]);

# S15
AGR.GRP("alt","A15","S15");
AGR.TOC("perm","S15G1-p15B0.m",[72860604,90003980]);
AGR.TOC("perm","S15G1-p105B0.m",[-124686931,27357604]);
AGR.TOC("perm","S15G1-p455B0.m",[54418637,-21074702]);
AGR.TOC("perm","S15G1-p1365B0.m",[-32162156,93524484]);
AGR.TOC("matint","S15G1-Zr14B0.g",[112766668]);
AGR.TOC("matint","S15G1-Zr90B0.g",[128405560]);
AGR.TOC("matint","S15G1-Zr91B0.g",[20728690]);
AGR.TOC("matint","S15G1-Zr350B0.g",[72073042]);
AGR.TOC("matint","S15G1-Zr364B0.g",[112379418]);

# A16
AGR.GRP("alt","A16","A16");
AGR.TOC("perm","A16G1-p16B0.m",[122952804,-376850]);
AGR.TOC("perm","A16G1-p120B0.m",[-90432449,36585236]);
AGR.TOC("perm","A16G1-p560B0.m",[31215885,-80762672]);
AGR.TOC("perm","A16G1-p1820B0.m",[35966948,-38081813]);
AGR.TOC("matint","A16G1-Zr15B0.g",[115743485]);
AGR.TOC("matint","A16G1-Zr104B0.g",[-131498831]);
AGR.TOC("matint","A16G1-Zr105B0.g",[71513223]);
AGR.TOC("matint","A16G1-Zr440B0.g",[-8453117]);
AGR.TOC("matint","A16G1-Zr455B0.g",[55220984]);
AGR.TOC("check","A16G1-check1",[-36113085]);

# S16
AGR.GRP("alt","A16","S16");
AGR.TOC("perm","S16G1-p16B0.m",[-9052479,-376850]);
AGR.TOC("perm","S16G1-p120B0.m",[102407611,36585236]);
AGR.TOC("perm","S16G1-p560B0.m",[-63521346,-80762672]);
AGR.TOC("perm","S16G1-p1820B0.m",[131083269,-38081813]);
AGR.TOC("matint","S16G1-Zr15B0.g",[-13874193]);
AGR.TOC("matint","S16G1-Zr104B0.g",[24464107]);
AGR.TOC("matint","S16G1-Zr105B0.g",[39264249]);
AGR.TOC("matint","S16G1-Zr440B0.g",[78269769]);
AGR.TOC("matint","S16G1-Zr455B0.g",[-15698641]);

# A17
AGR.GRP("alt","A17","A17");
AGR.TOC("perm","A17G1-p17B0.m",[55351626,60559978]);
AGR.TOC("perm","A17G1-p136B0.m",[69276995,-78469100]);
AGR.TOC("perm","A17G1-p680B0.m",[-59984195,4367016]);
AGR.TOC("perm","A17G1-p2380B0.m",[-80483879,1460987]);
AGR.TOC("matint","A17G1-Zr16B0.g",[-93582348]);
AGR.TOC("matint","A17G1-Zr119B0.g",[69974062]);
AGR.TOC("matint","A17G1-Zr120B0.g",[-78478323]);
AGR.TOC("matint","A17G1-Zr544B0.g",[6475277]);
AGR.TOC("matint","A17G1-Zr560B0.g",[99141318]);
AGR.TOC("check","A17G1-check1",[70828487]);

# S17
AGR.GRP("alt","A17","S17");
AGR.TOC("perm","S17G1-p17B0.m",[28856792,45464758]);
AGR.TOC("perm","S17G1-p136B0.m",[131391594,583899]);
AGR.TOC("perm","S17G1-p680B0.m",[-127764983,101324677]);
AGR.TOC("perm","S17G1-p2380B0.m",[-91386534,105407015]);
AGR.TOC("matint","S17G1-Zr16B0.g",[-73625956]);
AGR.TOC("matint","S17G1-Zr119B0.g",[106578774]);
AGR.TOC("matint","S17G1-Zr120B0.g",[-124042535]);
AGR.TOC("matint","S17G1-Zr544B0.g",[68206623]);
AGR.TOC("matint","S17G1-Zr560B0.g",[53861249]);

# A18
AGR.GRP("alt","A18","A18");
AGR.TOC("perm","A18G1-p18B0.m",[-66217662,84223876]);
AGR.TOC("perm","A18G1-p153B0.m",[46570468,20559424]);
AGR.TOC("perm","A18G1-p816B0.m",[42103723,-82034077]);
AGR.TOC("perm","A18G1-p3060B0.m",[-53262680,-88231425]);
AGR.TOC("matint","A18G1-Zr17B0.g",[-34881287]);
AGR.TOC("matint","A18G1-Zr135B0.g",[-51082799]);
AGR.TOC("matint","A18G1-Zr136B0.g",[-93500730]);
AGR.TOC("check","A18G1-check1",[49129175]);

# S18
AGR.GRP("alt","A18","S18");
AGR.TOC("perm","S18G1-p18B0.m",[122696316,84223876]);
AGR.TOC("perm","S18G1-p153B0.m",[-34063429,20559424]);
AGR.TOC("perm","S18G1-p816B0.m",[16262271,-82034077]);
AGR.TOC("perm","S18G1-p3060B0.m",[-32850440,-88231425]);
AGR.TOC("matint","S18G1-Zr17B0.g",[99043014]);
AGR.TOC("matint","S18G1-Zr135B0.g",[91940979]);
AGR.TOC("matint","S18G1-Zr136B0.g",[83030198]);

# A19
AGR.GRP("alt","A19","A19");
AGR.TOC("perm","A19G1-p19B0.m",[77980294,63481327]);
AGR.TOC("perm","A19G1-p171B0.m",[104846560,83307267]);
AGR.TOC("perm","A19G1-p969B0.m",[-23455783,105705335]);
AGR.TOC("matint","A19G1-Zr18B0.g",[111598795]);
AGR.TOC("matint","A19G1-Zr152B0.g",[-34032615]);
AGR.TOC("matint","A19G1-Zr153B0.g",[-113410101]);
AGR.TOC("check","A19G1-check1",[-132931747]);

# S19
AGR.GRP("alt","A19","S19");
AGR.TOC("perm","S19G1-p19B0.m",[-133164478,84036778]);
AGR.TOC("perm","S19G1-p171B0.m",[47420814,-126074704]);
AGR.TOC("perm","S19G1-p969B0.m",[-64268110,117844450]);
AGR.TOC("matint","S19G1-Zr18B0.g",[-86577001]);
AGR.TOC("matint","S19G1-Zr152B0.g",[91970872]);
AGR.TOC("matint","S19G1-Zr153B0.g",[-20026772]);

# A20
AGR.GRP("alt","A20","A20");
AGR.TOC("perm","A20G1-p20B0.m",[48720353,-84131166]);
AGR.TOC("perm","A20G1-p190B0.m",[-162219,37732335]);
AGR.TOC("matint","A20G1-Zr19B0.g",[36852471]);
AGR.TOC("matint","A20G1-Zr170B0.g",[-29615783]);
AGR.TOC("matint","A20G1-Zr171B0.g",[-108958182]);
AGR.TOC("check","A20G1-check1",[-64749125]);

# S20
AGR.GRP("alt","A20","S20");
AGR.TOC("perm","S20G1-p20B0.m",[-22765070,-84131166]);
AGR.TOC("perm","S20G1-p190B0.m",[108406054,37732335]);
AGR.TOC("matint","S20G1-Zr19B0.g",[115694204]);
AGR.TOC("matint","S20G1-Zr170B0.g",[-99115043]);
AGR.TOC("matint","S20G1-Zr171B0.g",[-72088388]);

# A21
AGR.GRP("alt","A21","A21");
AGR.TOC("perm","A21G1-p21B0.m",[-106243427,32500336]);
AGR.TOC("perm","A21G1-p210B0.m",[-18096588,39181620]);
AGR.TOC("matint","A21G1-Zr20B0.g",[-29256843]);
AGR.TOC("matint","A21G1-Zr189B0.g",[115969211]);
AGR.TOC("matint","A21G1-Zr190B0.g",[-17524123]);
AGR.TOC("check","A21G1-check1",[-14702897]);

# S21
AGR.GRP("alt","A21","S21");
AGR.TOC("perm","S21G1-p21B0.m",[-47866677,-64381325]);
AGR.TOC("perm","S21G1-p210B0.m",[-47844635,127254386]);
AGR.TOC("matint","S21G1-Zr20B0.g",[11337534]);
AGR.TOC("matint","S21G1-Zr189B0.g",[-74240563]);
AGR.TOC("matint","S21G1-Zr190B0.g",[26185586]);

# A22
AGR.GRP("alt","A22","A22");
AGR.TOC("perm","A22G1-p22B0.m",[105416884,-75538739]);
AGR.TOC("perm","A22G1-p231B0.m",[30814105,-26069360]);
AGR.TOC("matint","A22G1-Zr21B0.g",[91357961]);
AGR.TOC("matint","A22G1-Zr209B0.g",[115062681]);
AGR.TOC("matint","A22G1-Zr210B0.g",[88330207]);
AGR.TOC("check","A22G1-check1",[121099186]);

# S22
AGR.GRP("alt","A22","S22");
AGR.TOC("perm","S22G1-p22B0.m",[91382033,-75538739]);
AGR.TOC("perm","S22G1-p231B0.m",[-86852209,-26069360]);
AGR.TOC("matint","S22G1-Zr21B0.g",[82882729]);
AGR.TOC("matint","S22G1-Zr209B0.g",[38577085]);
AGR.TOC("matint","S22G1-Zr210B0.g",[-50153160]);

# A23
AGR.GRP("alt","A23","A23");
AGR.TOC("perm","A23G1-p23B0.m",[-26635344,-79765368]);
AGR.TOC("perm","A23G1-p253B0.m",[-43572899,-9303116]);
AGR.TOC("matint","A23G1-Zr22B0.g",[-48900386]);
AGR.TOC("matint","A23G1-Zr230B0.g",[54170784]);
AGR.TOC("matint","A23G1-Zr231B0.g",[-127813778]);
AGR.TOC("check","A23G1-check1",[15692441]);

# S23
AGR.GRP("alt","A23","S23");
AGR.TOC("perm","S23G1-p23B0.m",[-25964400,73432144]);
AGR.TOC("perm","S23G1-p253B0.m",[-105428455,-96220929]);
AGR.TOC("matint","S23G1-Zr22B0.g",[-70091375]);
AGR.TOC("matint","S23G1-Zr230B0.g",[-116716590]);
AGR.TOC("matint","S23G1-Zr231B0.g",[-20002267]);

# 2A5
AGR.GRP("alt","A5","2A5");
AGR.TOC("perm","2A5G1-p24B0.m",[-30277832,64338760]);
AGR.TOC("perm","2A5G1-p40B0.m",[103308845,13304977]);
AGR.TOC("matff","2A5G1-f2r8B0.m",[-125765411,64897650]);
AGR.TOC("matff","2A5G1-f2r9B0.m",[-29568269,132445224]);
AGR.TOC("matff","2A5G1-f2r10B0.m",[47305319,-73484398]);
AGR.TOC("matff","2A5G1-f3r4B0.m",[12103382,-106445221]);
AGR.TOC("matff","2A5G1-f3r6B0.m",[75322658,103965206]);
AGR.TOC("matff","2A5G1-f4r5aB0.m",[58242329,47190084]);
AGR.TOC("matff","2A5G1-f4r5bB0.m",[-133306443,47190084]);
AGR.TOC("matff","2A5G1-f5r2B0.m",[-71107343,23495800]);
AGR.TOC("matff","2A5G1-f5r4B0.m",[-56856843,77384174]);
AGR.TOC("matff","2A5G1-f7r4aB0.m",[21980736,46839911]);
AGR.TOC("matff","2A5G1-f7r4bB0.m",[21980736,12748624]);
AGR.TOC("matff","2A5G1-f7r6B0.m",[91729598,112748688]);
AGR.TOC("matff","2A5G1-f9r2aB0.m",[19554613,-109536747]);
AGR.TOC("matff","2A5G1-f9r2bB0.m",[25071709,-109536747]);
AGR.TOC("matff","2A5G1-f49r2aB0.m",[38536789,3772828]);
AGR.TOC("matff","2A5G1-f49r2bB0.m",[-41831557,120171565]);
AGR.TOC("matint","2A5G1-Zr8bB0.g",[-67529844]);
AGR.TOC("matint","2A5G1-Zr12B0.g",[-38359014]);
AGR.TOC("matalg","2A5G1-Ar2aB0.g",[-114960339]);
AGR.TOC("matalg","2A5G1-Ar4aB0.g",[-11066115]);
AGR.TOC("matalg","2A5G1-Ar4aB2.g",[-73445728]);
AGR.TOC("matalg","2A5G1-Ar6B0.g",[-47602621]);
AGR.TOC("matalg","2A5G1-Ar6B1.g",[58558068]);
AGR.TOC("quat","2A5G1-Hr1aB0.g",[-18010219]);
AGR.TOC("pres","2A5G1-P1",[74027444]);

# 2S5
AGR.GRP("alt","A5","2S5");
AGR.TOC("perm","2S5G1-p40aB0.m",[10665173,54144337]);
AGR.TOC("perm","2S5G1-p40bB0.m",[-88101206,-46300861]);
AGR.TOC("perm","2S5G1-p48B0.m",[-59922120,-99099063]);
AGR.TOC("matff","2S5G1-f3r4B0.m",[-34606504,-58385427]);
AGR.TOC("matff","2S5G1-f3r6B0.m",[16290966,-31658096]);
AGR.TOC("matff","2S5G1-f5r4bB0.m",[-55819744,-5592801]);
AGR.TOC("matff","2S5G1-f5r8B0.m",[36619933,-56080989]);
AGR.TOC("matff","2S5G1-f25r2B0.m",[-62890617,123148176]);
AGR.TOC("matff","2S5G1-f25r4aB0.m",[121947140,66663831]);
AGR.TOC("matint","2S5G1-Zr8aB0.g",[-19513480]);
AGR.TOC("matalg","2S5G1-Ar4bB0.g",[-69335290]);
AGR.TOC("pres","2S5G1-P1",[31126296]);

# 2S5i
AGR.GRP("alt","A5","2S5i");
AGR.TOC("perm","2S5iG1-p48B0.m",[85389509,-85207509]);
AGR.TOC("perm","2S5iG1-p80B0.m",[-14760622,-113949850]);
AGR.TOC("matff","2S5iG1-f3r4B0.m",[12103382,-58183915]);
AGR.TOC("matff","2S5iG1-f3r12B0.m",[-113956411,-27894887]);
AGR.TOC("matff","2S5iG1-f5r4bB0.m",[-66889965,121965102]);
AGR.TOC("matff","2S5iG1-f5r8B0.m",[-41209421,30862683]);
AGR.TOC("matff","2S5iG1-f9r6B0.m",[-117080397,10693481]);
AGR.TOC("matff","2S5iG1-f25r2B0.m",[-105183709,-122321201]);
AGR.TOC("matff","2S5iG1-f25r4aB0.m",[80569340,-124369574]);
AGR.TOC("matalg","2S5iG1-Ar4aB1.g",[-34484899]);
AGR.TOC("matalg","2S5iG1-Ar4aB2.g",[-121430132]);
AGR.TOC("pres","2S5iG1-P1",[-114755440]);

# A5
AGR.GRP("alt","A5","A5");
AGR.TOC("perm","A5G1-p5B0.m",[105959871,-132194423]);
AGR.TOC("perm","A5G1-p6B0.m",[61180058,-37293998]);
AGR.TOC("perm","A5G1-p10B0.m",[87876035,-33658054]);
AGR.TOC("matff","A5G1-f2r4aB0.m",[-59700458,75574133]);
AGR.TOC("matff","A5G1-f2r4bB0.m",[132574147,-75334780]);
AGR.TOC("matff","A5G1-f3r4B0.m",[-100741745,113839718]);
AGR.TOC("matff","A5G1-f3r6B0.m",[-3808571,3567420]);
AGR.TOC("matff","A5G1-f4r2aB0.m",[-3370782,9122982]);
AGR.TOC("matff","A5G1-f4r2bB0.m",[-3099071,9122982]);
AGR.TOC("matff","A5G1-f5r3B0.m",[-120405886,-65129013]);
AGR.TOC("matff","A5G1-f5r5B0.m",[64884321,130032791]);
AGR.TOC("matff","A5G1-f9r3aB0.m",[132629049,-68817283]);
AGR.TOC("matff","A5G1-f9r3bB0.m",[-10391103,-68817283]);
AGR.TOC("matint","A5G1-Zr4B0.g",[61808604]);
AGR.TOC("matint","A5G1-Zr5B0.g",[-8793917]);
AGR.TOC("matint","A5G1-Zr6B0.g",[-110398703]);
AGR.TOC("matalg","A5G1-Ar3aB0.g",[-4330172]);
AGR.TOC("matalg","A5G1-Ar3bB0.g",[35818313]);
AGR.TOC("maxes","A5G1-max1W1",[109910985]);
AGR.TOC("maxes","A5G1-max2W1",[98771752]);
AGR.TOC("maxes","A5G1-max3W1",[-110887951]);
AGR.TOC("check","A5G1-check1",[133214225]);
AGR.TOC("pres","A5G1-P1",[133214225]);

# S5
AGR.GRP("alt","A5","S5");
AGR.TOC("perm","S5G1-p5B0.m",[-3581724,115937465]);
AGR.TOC("perm","S5G1-p6B0.m",[122731789,-79969449]);
AGR.TOC("perm","S5G1-p10B0.m",[-78039502,-18399926]);
AGR.TOC("matff","S5G1-f2r4aB0.m",[83842337,117840626]);
AGR.TOC("matff","S5G1-f2r4bB0.m",[82015106,-40261038]);
AGR.TOC("matff","S5G1-f3r4B0.m",[127122134,-89443331]);
AGR.TOC("matff","S5G1-f3r6B0.m",[-83885626,-57029490]);
AGR.TOC("matff","S5G1-f5r3B0.m",[-62063879,-111834091]);
AGR.TOC("matff","S5G1-f5r5B0.m",[-22534346,-120846077]);
AGR.TOC("maxes","S5G1-max1W1",[-18484748]);
AGR.TOC("maxes","S5G1-max2W1",[31931707]);
AGR.TOC("maxes","S5G1-max3W1",[53299536]);
AGR.TOC("maxes","S5G1-max4W1",[-25589380]);
AGR.TOC("pres","S5G1-P1",[-98868399]);

# 2A6
AGR.GRP("alt","A6","2A6");
AGR.TOC("perm","2A6G1-p80B0.m",[102258790,74608568]);
AGR.TOC("perm","2A6G1-p144B0.m",[-96347,125801886]);
AGR.TOC("perm","2A6G1-p240aB0.m",[-79548168,126895587]);
AGR.TOC("perm","2A6G1-p240bB0.m",[-106514159,-132986516]);
AGR.TOC("matff","2A6G1-f3r4B0.m",[-4837021,-103499355]);
AGR.TOC("matff","2A6G1-f3r12B0.m",[-22045868,1768922]);
AGR.TOC("matff","2A6G1-f5r4aB0.m",[17900096,-96541165]);
AGR.TOC("matff","2A6G1-f5r4bB0.m",[20381152,-96541165]);
AGR.TOC("matff","2A6G1-f5r20B0.m",[120797580,2598400]);
AGR.TOC("matff","2A6G1-f9r2aB0.m",[23246590,-65195923]);
AGR.TOC("matff","2A6G1-f9r2bB0.m",[-56273788,114713757]);
AGR.TOC("matff","2A6G1-f9r6aB0.m",[-117080397,-111824609]);
AGR.TOC("matff","2A6G1-f9r6bB0.m",[-117080397,-20471860]);
AGR.TOC("matff","2A6G1-f25r10aB0.m",[-106085167,-113549865]);
AGR.TOC("matff","2A6G1-f25r10bB0.m",[98754305,120285871]);
AGR.TOC("matalg","2A6G1-Ar4B0.g",[-48048172]);
AGR.TOC("matalg","2A6G1-Ar4aB0.g",[-114223694]);
AGR.TOC("quat","2A6G1-Hr2aB0.g",[14366986]);

# 2S6
AGR.GRP("alt","A6","2S6");
AGR.TOC("perm","2S6G1-p80B0.m",[-1465137,-39728472]);
AGR.TOC("perm","2S6G1-p240aB0.m",[-85923730,26420057]);
AGR.TOC("perm","2S6G1-p288B0.m",[116924951,-58411499]);

# 3A6
AGR.GRP("alt","A6","3A6");
AGR.TOC("perm","3A6G1-p18aB0.m",[-27169755,-63884696]);
AGR.TOC("perm","3A6G1-p18bB0.m",[-70831422,109435138]);
AGR.TOC("perm","3A6G1-p45aB0.m",[95875628,133741471]);
AGR.TOC("perm","3A6G1-p45bB0.m",[31154063,-131269737]);
AGR.TOC("matff","3A6G1-f2r6aB0.m",[35911271,-9468330]);
AGR.TOC("matff","3A6G1-f2r6bB0.m",[128164886,-101302677]);
AGR.TOC("matff","3A6G1-f2r18B0.m",[-83402555,103762049]);
AGR.TOC("matff","3A6G1-f4r3aB0.m",[-61163955,62487747]);
AGR.TOC("matff","3A6G1-f4r3bB0.m",[-61163955,-113407058]);
AGR.TOC("matff","3A6G1-f4r9aB0.m",[26373939,-119266416]);
AGR.TOC("matff","3A6G1-f5r6bB0.m",[-91892596,-21844883]);
AGR.TOC("matff","3A6G1-f5r12B0.m",[132796687,9613992]);
AGR.TOC("matff","3A6G1-f5r30B0.m",[90929713,-6591506]);
AGR.TOC("matff","3A6G1-f25r3aB0.m",[-11515690,-123381946]);
AGR.TOC("matff","3A6G1-f25r6aB0.m",[-30624642,-31855788]);
AGR.TOC("matff","3A6G1-f25r15aB0.m",[8408375,84491105]);
AGR.TOC("matalg","3A6G1-Ar3aB0.g",[98594020]);
AGR.TOC("matalg","3A6G1-Ar6B0.g",[46743497]);
AGR.TOC("matalg","3A6G1-Ar9B0.g",[19237101]);
AGR.TOC("matalg","3A6G1-Ar15B0.g",[62264135]);

# 3S6
AGR.GRP("alt","A6","3S6");
AGR.TOC("perm","3S6G1-p18aB0.m",[-90192914,58018384]);
AGR.TOC("perm","3S6G1-p18bB0.m",[48380330,-74100289]);
AGR.TOC("perm","3S6G1-p45aB0.m",[-36171649,-98566559]);
AGR.TOC("perm","3S6G1-p45bB0.m",[-63653841,-22560631]);

# 6A6
AGR.GRP("alt","A6","6A6");
AGR.TOC("perm","6A6G1-p432B0.m",[-70482918,5910727]);
AGR.TOC("perm","6A6G1-p720aB0.m",[-117987490,78745458]);
AGR.TOC("matff","6A6G1-f5r12aB0.m",[82266534,63801793]);
AGR.TOC("matff","6A6G1-f5r12bB0.m",[-16318809,-103450023]);
AGR.TOC("matff","6A6G1-f9r6aB0.m",[-117080397,10712547]);
AGR.TOC("matff","6A6G1-f25r6aB0.m",[41241241,54241311]);
AGR.TOC("matff","6A6G1-f25r6bB0.m",[114239719,-49023241]);
AGR.TOC("matalg","6A6G1-Ar12B0.g",[-59710906]);

# 6S6
AGR.GRP("alt","A6","6S6");
AGR.TOC("perm","6S6G1-p720aB0.m",[-101534071,-77411625]);

# A6
AGR.GRP("alt","A6","A6");
AGR.TOC("perm","A6G1-p6aB0.m",[108706813,-115759144]);
AGR.TOC("perm","A6G1-p6bB0.m",[108706813,57093098]);
AGR.TOC("perm","A6G1-p10B0.m",[-27365038,76650249]);
AGR.TOC("perm","A6G1-p15aB0.m",[-109444696,-87928583]);
AGR.TOC("perm","A6G1-p15bB0.m",[-45631178,-128595033]);
AGR.TOC("matff","A6G1-f2r4aB0.m",[63125127,-51233355]);
AGR.TOC("matff","A6G1-f2r4bB0.m",[63125127,23017655]);
AGR.TOC("matff","A6G1-f2r16B0.m",[130984727,-39278407]);
AGR.TOC("matff","A6G1-f3r4B0.m",[25891732,-79587657]);
AGR.TOC("matff","A6G1-f3r6B0.m",[-98179095,-67444461]);
AGR.TOC("matff","A6G1-f3r9B0.m",[-66167021,-116095810]);
AGR.TOC("matff","A6G1-f4r8aB0.m",[117735458,-32704661]);
AGR.TOC("matff","A6G1-f4r8bB0.m",[-76667929,125393531]);
AGR.TOC("matff","A6G1-f5r5aB0.m",[26341713,-58803941]);
AGR.TOC("matff","A6G1-f5r5bB0.m",[-92415994,96195433]);
AGR.TOC("matff","A6G1-f5r8B0.m",[-2848528,-41002382]);
AGR.TOC("matff","A6G1-f5r10B0.m",[-103629574,30708049]);
AGR.TOC("matff","A6G1-f9r3aB0.m",[44653245,-127453367]);
AGR.TOC("matff","A6G1-f9r3bB0.m",[44653245,14779569]);
AGR.TOC("matint","A6G1-Zr5aB0.g",[100719862]);
AGR.TOC("matint","A6G1-Zr5bB0.g",[125657418]);
AGR.TOC("matint","A6G1-Zr9B0.g",[133517606]);
AGR.TOC("matint","A6G1-Zr10B0.g",[-74571095]);
AGR.TOC("matint","A6G1-Zr16B0.g",[-116806540]);
AGR.TOC("matalg","A6G1-Ar8aB0.g",[107672848]);
AGR.TOC("matalg","A6G1-Ar8bB0.g",[30517665]);
AGR.TOC("maxes","A6G1-max1W1",[-67607570]);
AGR.TOC("maxes","A6G1-max2W1",[98771752]);
AGR.TOC("maxes","A6G1-max3W1",[69578701]);
AGR.TOC("maxes","A6G1-max4W1",[-45430912]);
AGR.TOC("maxes","A6G1-max5W1",[42879257]);
AGR.TOC("check","A6G1-check1",[-102434184]);
AGR.TOC("pres","A6G1-P1",[-76021888]);

# A6V4
AGR.GRP("alt","A6","A6V4");
AGR.TOC("perm","A6V4G1-p10B0.m",[6106500,-82871957]);
AGR.TOC("pres","A6V4G1-P1",[-62980510]);

# M10
AGR.GRP("alt","A6","M10");
AGR.TOC("perm","M10G1-p10B0.m",[-60216384,-124930269]);
AGR.TOC("pres","M10G1-P1",[-14890401]);

# PGL29
AGR.GRP("alt","A6","PGL29");
AGR.TOC("perm","PGL29G1-p10B0.m",[126537996,81841962]);
AGR.TOC("pres","PGL29G1-P1",[-132346814]);

# S6
AGR.GRP("alt","A6","S6");
AGR.TOC("perm","S6G1-p6aB0.m",[-20005392,79150440]);
AGR.TOC("perm","S6G1-p6bB0.m",[-80081315,79150440]);
AGR.TOC("perm","S6G1-p10B0.m",[-54706016,-57924782]);
AGR.TOC("perm","S6G1-p15aB0.m",[86959444,-59558044]);
AGR.TOC("perm","S6G1-p15bB0.m",[-94758333,-91650995]);
AGR.TOC("maxes","S6G1-max1W1",[83513557]);
AGR.TOC("maxes","S6G1-max2W1",[18748601]);
AGR.TOC("maxes","S6G1-max3W1",[-115734862]);
AGR.TOC("maxes","S6G1-max4W1",[-67607570]);
AGR.TOC("maxes","S6G1-max5W1",[-9427421]);
AGR.TOC("maxes","S6G1-max6W1",[-67032013]);
AGR.TOC("pres","S6G1-P1",[-111049475]);

# 2A7
AGR.GRP("alt","A7","2A7");
AGR.TOC("perm","2A7G1-p240B0.m",[-3292094,-27737806]);
AGR.TOC("matff","2A7G1-f3r8B0.m",[115125557,-39989792]);
AGR.TOC("matff","2A7G1-f3r12B0.m",[-51516234,122247886]);
AGR.TOC("matff","2A7G1-f3r36B0.m",[-85449470,81866542]);
AGR.TOC("matff","2A7G1-f5r8B0.m",[-30079117,-64273702]);
AGR.TOC("matff","2A7G1-f5r20aB0.m",[-94735395,75374541]);
AGR.TOC("matff","2A7G1-f5r20bB0.m",[-106463668,-19719920]);
AGR.TOC("matff","2A7G1-f5r28B0.m",[106917999,91869630]);
AGR.TOC("matff","2A7G1-f7r4B0.m",[-72947581,-67923820]);
AGR.TOC("matff","2A7G1-f7r14aB0.m",[-59913607,-114720184]);
AGR.TOC("matff","2A7G1-f7r14bB0.m",[98740750,32016585]);
AGR.TOC("matff","2A7G1-f7r16B0.m",[75299246,-132793868]);
AGR.TOC("matff","2A7G1-f7r20B0.m",[-47034929,87271692]);
AGR.TOC("matff","2A7G1-f9r4aB0.m",[116086381,-66800019]);
AGR.TOC("matff","2A7G1-f9r4bB0.m",[116086381,-100788072]);
AGR.TOC("matff","2A7G1-f9r6aB0.m",[-48413873,-43569541]);
AGR.TOC("matff","2A7G1-f9r6bB0.m",[-8353157,96784847]);
AGR.TOC("matff","2A7G1-f25r4aB0.m",[-72664095,-38260269]);
AGR.TOC("matff","2A7G1-f25r4bB0.m",[-72664095,14497210]);
AGR.TOC("matff","2A7G1-f25r14aB0.m",[-31393230,46387995]);
AGR.TOC("matff","2A7G1-f25r14bB0.m",[54681285,9308579]);
AGR.TOC("matalg","2A7G1-Ar4aB0.g",[-92207492]);
AGR.TOC("matalg","2A7G1-Ar4bB0.g",[-32729037]);
AGR.TOC("matalg","2A7G1-Ar20aB0.g",[-123007004]);

# 2S7
AGR.GRP("alt","A7","2S7");
AGR.TOC("matff","2S7G1-f7r8B0.m",[-53522252,18330038]);
AGR.TOC("matff","2S7G1-f7r28B0.m",[-67980920,-35536298]);
AGR.TOC("matff","2S7G1-f7r32B0.m",[-60511241,106583422]);
AGR.TOC("matff","2S7G1-f7r40B0.m",[-44545978,16262383]);
AGR.TOC("matff","2S7G1-f49r4aB0.m",[-15044674,-73437953]);
AGR.TOC("matff","2S7G1-f49r16aB0.m",[22960962,-41454301]);
AGR.TOC("matff","2S7G1-f49r20aB0.m",[-54171207,-27657892]);

# 2S7i
AGR.GRP("alt","A7","2S7i");
AGR.TOC("matff","2S7iG1-f3r8B0.m",[49999329,107284394]);
AGR.TOC("matff","2S7iG1-f3r12B0.m",[-3646128,-101443637]);
AGR.TOC("matff","2S7iG1-f3r36aB0.m",[75934216,13394983]);
AGR.TOC("matff","2S7iG1-f5r8B0.m",[-41209421,-94422757]);
AGR.TOC("matff","2S7iG1-f5r20B0.m",[-49647592,55460638]);
AGR.TOC("matff","2S7iG1-f5r28B0.m",[-16367108,-67711016]);
AGR.TOC("matff","2S7iG1-f5r40B0.m",[60330914,-73388851]);
AGR.TOC("matff","2S7iG1-f7r4aB0.m",[-128946870,-89499747]);
AGR.TOC("matff","2S7iG1-f7r16aB0.m",[-66493890,43278977]);
AGR.TOC("matff","2S7iG1-f7r20aB0.m",[-110432753,-19780159]);
AGR.TOC("matff","2S7iG1-f7r28B0.m",[-50217382,32343475]);
AGR.TOC("matff","2S7iG1-f25r20aB0.m",[33577121,-84897365]);

# 3A7
AGR.GRP("alt","A7","3A7");
AGR.TOC("perm","3A7G1-p45aB0.m",[109537525,96508581]);
AGR.TOC("perm","3A7G1-p45bB0.m",[-114892068,76407987]);
AGR.TOC("perm","3A7G1-p63B0.m",[129538451,-52215497]);
AGR.TOC("perm","3A7G1-p315B0.m",[-134162246,-86486884]);
AGR.TOC("matff","3A7G1-f2r12B0.m",[-53202595,30729675]);
AGR.TOC("matff","3A7G1-f2r30B0.m",[90337719,-90141803]);
AGR.TOC("matff","3A7G1-f2r48aB0.m",[75326183,-33290497]);
AGR.TOC("matff","3A7G1-f2r48bB0.m",[-67009732,-70678928]);
AGR.TOC("matff","3A7G1-f4r6B0.m",[81090800,-50669809]);
AGR.TOC("matff","3A7G1-f4r15B0.m",[-24520496,86249362]);
AGR.TOC("matff","3A7G1-f4r24aB0.m",[-51291230,34490550]);
AGR.TOC("matff","3A7G1-f4r24bB0.m",[-101760030,-13124942]);
AGR.TOC("matff","3A7G1-f5r6B0.m",[75634132,74423159]);
AGR.TOC("matff","3A7G1-f5r12B0.m",[-104662262,69216411]);
AGR.TOC("matff","3A7G1-f5r30aB0.m",[121631521,110288714]);
AGR.TOC("matff","3A7G1-f5r30bB0.m",[19349938,123165985]);
AGR.TOC("matff","3A7G1-f5r36B0.m",[-40143423,7979341]);
AGR.TOC("matff","3A7G1-f5r42B0.m",[-77405396,54456798]);
AGR.TOC("matff","3A7G1-f7r6B0.m",[-91983465,62064904]);
AGR.TOC("matff","3A7G1-f7r9B0.m",[98614202,94446836]);
AGR.TOC("matff","3A7G1-f7r15B0.m",[64305697,-124550272]);
AGR.TOC("matff","3A7G1-f7r21aB0.m",[6811668,-29096036]);
AGR.TOC("matff","3A7G1-f7r21bB0.m",[-57960020,2288264]);
AGR.TOC("matff","3A7G1-f25r3B0.m",[30211216,101026231]);
AGR.TOC("matff","3A7G1-f25r6B0.m",[57090120,-35828918]);
AGR.TOC("matff","3A7G1-f25r15aB0.m",[-87407590,46689140]);
AGR.TOC("matff","3A7G1-f25r15bB0.m",[62478524,-57683497]);
AGR.TOC("matff","3A7G1-f25r18B0.m",[-87517950,-119078156]);
AGR.TOC("matff","3A7G1-f25r21B0.m",[116472,-74374020]);
AGR.TOC("matalg","3A7G1-Ar6B0.g",[-33810209]);
AGR.TOC("matalg","3A7G1-Ar15aB0.g",[96656692]);
AGR.TOC("matalg","3A7G1-Ar15bB0.g",[-107010826]);
AGR.TOC("matalg","3A7G1-Ar21aB0.g",[-83149149]);
AGR.TOC("matalg","3A7G1-Ar21bB0.g",[-51578621]);

# 3S7
AGR.GRP("alt","A7","3S7");
AGR.TOC("perm","3S7G1-p63B0.m",[31377868,111851509]);
AGR.TOC("perm","3S7G1-p90B0.m",[-107847473,2297321]);
AGR.TOC("matff","3S7G1-f2r12B0.m",[26970840,-9365810]);
AGR.TOC("matff","3S7G1-f2r30B0.m",[36334749,-43735233]);
AGR.TOC("matff","3S7G1-f2r96B0.m",[-34473643,57899234]);
AGR.TOC("matff","3S7G1-f5r6B0.m",[-66460916,-115373300]);
AGR.TOC("matff","3S7G1-f5r12B0.m",[43656458,14004214]);
AGR.TOC("matff","3S7G1-f5r30aB0.m",[-121607974,-20499580]);
AGR.TOC("matff","3S7G1-f5r30bB0.m",[-13003126,-28767831]);
AGR.TOC("matff","3S7G1-f5r36B0.m",[-47119799,109713215]);
AGR.TOC("matff","3S7G1-f5r42B0.m",[-25680175,62700243]);
AGR.TOC("matff","3S7G1-f7r12B0.m",[8273416,-83410363]);
AGR.TOC("matff","3S7G1-f7r18B0.m",[88355389,71668127]);
AGR.TOC("matff","3S7G1-f7r30B0.m",[110311840,-13780991]);
AGR.TOC("matff","3S7G1-f7r42aB0.m",[71229562,-110145426]);
AGR.TOC("matff","3S7G1-f7r42bB0.m",[98955354,114297898]);

# 6A7
AGR.GRP("alt","A7","6A7");
AGR.TOC("perm","6A7G1-p720B0.m",[131742494,-73083657]);
AGR.TOC("matff","6A7G1-f5r12aB0.m",[74207849,63560487]);
AGR.TOC("matff","6A7G1-f5r12bB0.m",[125659785,-53997618]);
AGR.TOC("matff","6A7G1-f5r24B0.m",[80969030,37253661]);
AGR.TOC("matff","6A7G1-f5r48B0.m",[42213017,109752579]);
AGR.TOC("matff","6A7G1-f7r6aB0.m",[96246682,39543939]);
AGR.TOC("matff","6A7G1-f7r6bB0.m",[34691837,-20531271]);
AGR.TOC("matff","6A7G1-f7r24B0.m",[-102605978,106048389]);
AGR.TOC("matff","6A7G1-f25r6aB0.m",[100353712,-121631318]);
AGR.TOC("matff","6A7G1-f25r6bB0.m",[-58835053,85206624]);
AGR.TOC("matff","6A7G1-f25r12B0.m",[-36169651,-100389795]);
AGR.TOC("matff","6A7G1-f25r24B0.m",[-19086814,-55349400]);

# 6S7
AGR.GRP("alt","A7","6S7");
AGR.TOC("matff","6S7G1-f7r12B0.m",[-44861699,25585244]);
AGR.TOC("matff","6S7G1-f7r48B0.m",[109965908,-114636847]);

# A7
AGR.GRP("alt","A7","A7");
AGR.TOC("perm","A7G1-p7B0.m",[45602091,-40128812]);
AGR.TOC("matff","A7G1-f2r4aB0.m",[-75334780,133359621]);
AGR.TOC("matff","A7G1-f2r4bB0.m",[-75334780,110723042]);
AGR.TOC("matff","A7G1-f2r6B0.m",[-96431038,-96670665]);
AGR.TOC("matff","A7G1-f2r14B0.m",[88404425,-132995512]);
AGR.TOC("matff","A7G1-f2r20B0.m",[-59840360,43050535]);
AGR.TOC("matff","A7G1-f3r6B0.m",[-56494866,89026618]);
AGR.TOC("matff","A7G1-f3r13B0.m",[-1113830,116073952]);
AGR.TOC("matff","A7G1-f3r15B0.m",[-121714200,40692474]);
AGR.TOC("matff","A7G1-f3r20B0.m",[-132035023,-82990016]);
AGR.TOC("matff","A7G1-f5r6B0.m",[62597910,133847596]);
AGR.TOC("matff","A7G1-f5r8B0.m",[-67278705,117637163]);
AGR.TOC("matff","A7G1-f5r13B0.m",[-119963451,-120598875]);
AGR.TOC("matff","A7G1-f5r15B0.m",[116088850,86554021]);
AGR.TOC("matff","A7G1-f5r20B0.m",[-129342836,-87512862]);
AGR.TOC("matff","A7G1-f5r35B0.m",[-74142229,31639714]);
AGR.TOC("matff","A7G1-f7r5B0.m",[81664664,66608321]);
AGR.TOC("matff","A7G1-f7r10B0.m",[-39370106,-111817133]);
AGR.TOC("matff","A7G1-f7r14aB0.m",[77736448,5408238]);
AGR.TOC("matff","A7G1-f7r14bB0.m",[51566638,59386993]);
AGR.TOC("matff","A7G1-f7r21B0.m",[44369962,-60628903]);
AGR.TOC("matff","A7G1-f7r35B0.m",[73079771,77988626]);
AGR.TOC("matff","A7G1-f9r10aB0.m",[-2625794,89301035]);
AGR.TOC("matff","A7G1-f9r10bB0.m",[62947657,130497263]);
AGR.TOC("matff","A7G1-f25r10aB0.m",[98832882,52957486]);
AGR.TOC("matff","A7G1-f25r10bB0.m",[-62846906,86891132]);
AGR.TOC("matint","A7G1-Zr6B0.g",[48360344]);
AGR.TOC("matint","A7G1-Zr14aB0.g",[24892537]);
AGR.TOC("matint","A7G1-Zr14bB0.g",[-22139103]);
AGR.TOC("matint","A7G1-Zr15B0.g",[-112180996]);
AGR.TOC("matint","A7G1-Zr20B0.g",[-28988261]);
AGR.TOC("matint","A7G1-Zr21B0.g",[-29742041]);
AGR.TOC("matint","A7G1-Zr35B0.g",[22518441]);
AGR.TOC("maxes","A7G1-max1W1",[70334159]);
AGR.TOC("maxes","A7G1-max2W1",[-99809336]);
AGR.TOC("check","A7G1-check1",[-63044540]);

# S7
AGR.GRP("alt","A7","S7");
AGR.TOC("perm","S7G1-p7B0.m",[-124593203,67443889]);
AGR.TOC("perm","S7G1-p21B0.m",[-121904583,105902254]);
AGR.TOC("perm","S7G1-p30B0.m",[53165691,-63950219]);
AGR.TOC("perm","S7G1-p35B0.m",[-68600957,-72406246]);
AGR.TOC("perm","S7G1-p120B0.m",[92158314,118472449]);
AGR.TOC("matff","S7G1-f2r6B0.m",[-22260173,-133387572]);
AGR.TOC("matff","S7G1-f2r8B0.m",[-115100505,62527455]);
AGR.TOC("matff","S7G1-f2r14B0.m",[65384245,74515664]);
AGR.TOC("matff","S7G1-f2r20B0.m",[119920235,-124672320]);
AGR.TOC("matff","S7G1-f3r6aB0.m",[-117937890,-131742766]);
AGR.TOC("matff","S7G1-f3r13aB0.m",[71390686,-62222796]);
AGR.TOC("matff","S7G1-f3r15aB0.m",[-127891226,40566345]);
AGR.TOC("matff","S7G1-f3r20B0.m",[-21513772,-52594721]);
AGR.TOC("matff","S7G1-f5r6aB0.m",[-128822608,73110986]);
AGR.TOC("matff","S7G1-f5r8aB0.m",[-116058506,105279481]);
AGR.TOC("matff","S7G1-f5r13aB0.m",[59726521,-39695657]);
AGR.TOC("matff","S7G1-f5r15aB0.m",[-104102442,129350008]);
AGR.TOC("matff","S7G1-f5r20B0.m",[88841578,-3367921]);
AGR.TOC("matff","S7G1-f5r35aB0.m",[-121898027,-26417368]);
AGR.TOC("matff","S7G1-f7r5aB0.m",[-86252045,-31938807]);
AGR.TOC("matff","S7G1-f7r10aB0.m",[-68463391,-40306517]);
AGR.TOC("matff","S7G1-f7r14aB0.m",[46054514,-125849128]);
AGR.TOC("matff","S7G1-f7r14bB0.m",[23987557,13911761]);
AGR.TOC("matff","S7G1-f7r21aB0.m",[35754486,-86587203]);
AGR.TOC("matff","S7G1-f7r35aB0.m",[70139229,-63087248]);
AGR.TOC("maxes","S7G1-max1W1",[-14717004]);
AGR.TOC("maxes","S7G1-max2W1",[19547313]);
AGR.TOC("maxes","S7G1-max3W1",[98162325]);
AGR.TOC("maxes","S7G1-max4W1",[-81647236]);
AGR.TOC("maxes","S7G1-max5W1",[111003326]);

# 2A8
AGR.GRP("alt","A8","2A8");
AGR.TOC("perm","2A8G1-p240aB0.m",[-96287219,100052245]);
AGR.TOC("perm","2A8G1-p240bB0.m",[-102533315,44761083]);
AGR.TOC("perm","2A8G1-p240cB0.m",[-98336336,26503074]);
AGR.TOC("matff","2A8G1-f3r8B0.m",[110104467,103157578]);
AGR.TOC("matff","2A8G1-f3r48aB0.m",[-18748067,-87137760]);
AGR.TOC("matff","2A8G1-f3r48bB0.m",[-51957761,4460697]);
AGR.TOC("matff","2A8G1-f5r8B0.m",[-13016887,68445041]);
AGR.TOC("matff","2A8G1-f5r48aB0.m",[-41187856,-68860196]);
AGR.TOC("matff","2A8G1-f5r48bB0.m",[-71781049,11730666]);
AGR.TOC("matff","2A8G1-f5r64B0.m",[46702969,55553521]);
AGR.TOC("matff","2A8G1-f7r8B0.m",[-94094131,120686910]);
AGR.TOC("matff","2A8G1-f7r16B0.m",[-35990194,-13511402]);
AGR.TOC("matff","2A8G1-f7r48B0.m",[55558781,17701250]);
AGR.TOC("matff","2A8G1-f7r56aB0.m",[123021175,34024872]);
AGR.TOC("matff","2A8G1-f7r56bB0.m",[-944491,-5197282]);
AGR.TOC("matff","2A8G1-f7r112B0.m",[-10708772,86832890]);
AGR.TOC("matff","2A8G1-f9r24aB0.m",[-58804603,44796249]);
AGR.TOC("matff","2A8G1-f9r24bB0.m",[-27097110,-15444090]);
AGR.TOC("matff","2A8G1-f25r24aB0.m",[-86181411,71073867]);
AGR.TOC("matff","2A8G1-f25r24bB0.m",[120078495,26625097]);
AGR.TOC("matff","2A8G1-f25r32aB0.m",[1555143,4015084]);
AGR.TOC("matff","2A8G1-f25r32bB0.m",[133809283,133818942]);
AGR.TOC("matff","2A8G1-f49r56cB0.m",[36895777,31221483]);
AGR.TOC("matff","2A8G1-f49r56dB0.m",[11478413,58925510]);
AGR.TOC("matint","2A8G1-Zr8B0.g",[-127813824]);
AGR.TOC("matmodn","2A8G1-Z4r4aB0.g",[-25748035]);

# A8
AGR.GRP("alt","A8","A8");
AGR.TOC("perm","A8G1-p8B0.m",[-4527126,-126533380]);
AGR.TOC("perm","A8G1-p15aB0.m",[41717428,-65350234]);
AGR.TOC("perm","A8G1-p15bB0.m",[33188186,73649104]);
AGR.TOC("matff","A8G1-f2r4aB0.m",[-75334780,-96547203]);
AGR.TOC("matff","A8G1-f2r4bB0.m",[-75334780,-66578106]);
AGR.TOC("matff","A8G1-f2r6B0.m",[-99095227,-29863203]);
AGR.TOC("matff","A8G1-f2r14B0.m",[64744832,-32768114]);
AGR.TOC("matff","A8G1-f2r20aB0.m",[87872891,48406533]);
AGR.TOC("matff","A8G1-f2r20bB0.m",[127589419,-3907050]);
AGR.TOC("matff","A8G1-f2r64B0.m",[86715581,-47507203]);
AGR.TOC("matint","A8G1-Zr7B0.g",[44944099]);
AGR.TOC("matint","A8G1-Zr14B0.g",[6569637]);
AGR.TOC("matint","A8G1-Zr20B0.g",[119136527]);
AGR.TOC("matint","A8G1-Zr21aB0.g",[-35592612]);
AGR.TOC("matint","A8G1-Zr28B0.g",[-20315578]);
AGR.TOC("matint","A8G1-Zr35B0.g",[66933826]);
AGR.TOC("matint","A8G1-Zr42B0.g",[-132523549]);
AGR.TOC("matint","A8G1-Zr56B0.g",[-119222824]);
AGR.TOC("matint","A8G1-Zr64B0.g",[-109047313]);
AGR.TOC("matint","A8G1-Zr70B0.g",[-74724874]);
AGR.TOC("matint","A8G1-Zr90B0.g",[34617594]);
AGR.TOC("check","A8G1-check1",[39317844]);

# S8
AGR.GRP("alt","A8","S8");
AGR.TOC("perm","S8G1-p8B0.m",[123141729,85477392]);
AGR.TOC("matff","S8G1-f2r6B0.m",[-22260173,-22867308]);
AGR.TOC("matff","S8G1-f2r8B0.m",[84946852,-9458717]);
AGR.TOC("matff","S8G1-f2r14B0.m",[-123417179,-87483402]);
AGR.TOC("matff","S8G1-f2r40B0.m",[48676847,4116683]);
AGR.TOC("matff","S8G1-f2r64B0.m",[51117359,-72788269]);

# 2A9
AGR.GRP("alt","A9","2A9");
AGR.TOC("matff","2A9G1-f3r8B0.m",[-104094197,-8981692]);
AGR.TOC("matff","2A9G1-f3r48B0.m",[132400672,-55146633]);
AGR.TOC("matff","2A9G1-f3r104B0.m",[44601680,708409]);
AGR.TOC("matff","2A9G1-f5r8aB0.m",[-72343023,-34091804]);
AGR.TOC("matff","2A9G1-f5r8bB0.m",[-72343023,-36383995]);
AGR.TOC("matff","2A9G1-f7r8aB0.m",[-93937177,119155111]);
AGR.TOC("matff","2A9G1-f7r8bB0.m",[-93937177,63478918]);
AGR.TOC("matalg","2A9G1-Ar8aB0.g",[-112500735]);

# A9
AGR.GRP("alt","A9","A9");
AGR.TOC("perm","A9G1-p9B0.m",[116601334,-62323096]);
AGR.TOC("perm","A9G1-p36B0.m",[-32785314,-70178370]);
AGR.TOC("perm","A9G1-p84B0.m",[51265106,-49500979]);
AGR.TOC("perm","A9G1-p120aB0.m",[123417366,12990255]);
AGR.TOC("perm","A9G1-p120bB0.m",[-54926084,-114205725]);
AGR.TOC("perm","A9G1-p126B0.m",[19487375,-73084215]);
AGR.TOC("perm","A9G1-p280B0.m",[110225478,-24356222]);
AGR.TOC("perm","A9G1-p840B0.m",[118760487,43929662]);
AGR.TOC("matff","A9G1-f2r8aB0.m",[76766072,112609927]);
AGR.TOC("matff","A9G1-f2r8bB0.m",[102232623,14154429]);
AGR.TOC("matff","A9G1-f2r8cB0.m",[102232623,95743374]);
AGR.TOC("matff","A9G1-f2r20aB0.m",[-116012097,86559057]);
AGR.TOC("matff","A9G1-f2r20bB0.m",[11313813,86297175]);
AGR.TOC("matff","A9G1-f2r26B0.m",[-43555360,-29522564]);
AGR.TOC("matff","A9G1-f2r48B0.m",[111876087,125026724]);
AGR.TOC("matff","A9G1-f2r78B0.m",[93158443,111098730]);
AGR.TOC("matff","A9G1-f2r160B0.m",[-113196594,126317842]);
AGR.TOC("matff","A9G1-f3r7B0.m",[-46888880,122989205]);
AGR.TOC("matff","A9G1-f3r21B0.m",[97833906,-124795722]);
AGR.TOC("matff","A9G1-f3r27B0.m",[53360387,-110179385]);
AGR.TOC("matff","A9G1-f3r35B0.m",[-75914486,12943712]);
AGR.TOC("matff","A9G1-f3r41B0.m",[113272071,-72099926]);
AGR.TOC("matff","A9G1-f3r162B0.m",[-82012771,117328868]);
AGR.TOC("matff","A9G1-f3r189B0.m",[-100089248,-55976864]);
AGR.TOC("matff","A9G1-f5r8B0.m",[61715009,-104290189]);
AGR.TOC("matff","A9G1-f5r21B0.m",[-108469338,-14430805]);
AGR.TOC("matff","A9G1-f5r27B0.m",[-60285001,52677281]);
AGR.TOC("matff","A9G1-f5r28B0.m",[12673978,-10559459]);
AGR.TOC("matff","A9G1-f5r34B0.m",[43023049,-34704766]);
AGR.TOC("matff","A9G1-f5r35aB0.m",[-76520532,-97440845]);
AGR.TOC("matff","A9G1-f5r35bB0.m",[-62633215,-123969685]);
AGR.TOC("matff","A9G1-f5r56B0.m",[8891258,56683786]);
AGR.TOC("matff","A9G1-f5r83B0.m",[-27507312,-27462102]);
AGR.TOC("matff","A9G1-f5r105B0.m",[42461781,58200084]);
AGR.TOC("matff","A9G1-f5r120B0.m",[-119279049,47174249]);
AGR.TOC("matff","A9G1-f5r133B0.m",[-18727663,16676412]);
AGR.TOC("matff","A9G1-f5r134B0.m",[122853650,17410189]);
AGR.TOC("matff","A9G1-f7r8B0.m",[-45341592,39241079]);
AGR.TOC("matff","A9G1-f7r19B0.m",[-37669067,-88156896]);
AGR.TOC("matff","A9G1-f7r28B0.m",[-48096103,-37393314]);
AGR.TOC("matff","A9G1-f7r35aB0.m",[-103551900,-102253729]);
AGR.TOC("matff","A9G1-f7r35bB0.m",[-131920737,-22272726]);
AGR.TOC("matff","A9G1-f7r42B0.m",[-91817450,-81644783]);
AGR.TOC("matff","A9G1-f7r47B0.m",[120025081,-6775808]);
AGR.TOC("matff","A9G1-f7r56B0.m",[-267432,3717887]);
AGR.TOC("matff","A9G1-f7r84B0.m",[-56264078,58337040]);
AGR.TOC("matff","A9G1-f7r101B0.m",[83654551,65363130]);
AGR.TOC("matff","A9G1-f7r105B0.m",[118513256,80794670]);
AGR.TOC("matff","A9G1-f7r115B0.m",[75626264,4993916]);
AGR.TOC("matff","A9G1-f7r168B0.m",[94115553,-109033653]);
AGR.TOC("matff","A9G1-f7r189B0.m",[126789110,111104490]);
AGR.TOC("matff","A9G1-f49r21aB0.m",[-57219481,58294530]);
AGR.TOC("matff","A9G1-f49r21bB0.m",[113250307,-86761156]);
AGR.TOC("matint","A9G1-Zr8B0.g",[-113036087]);
AGR.TOC("matint","A9G1-Zr27B0.g",[-114160116]);
AGR.TOC("matint","A9G1-Zr28B0.g",[-116816341]);
AGR.TOC("matint","A9G1-Zr35aB0.g",[19143040]);
AGR.TOC("matint","A9G1-Zr35bB0.g",[-127084087]);
AGR.TOC("matint","A9G1-Zr42B0.g",[90871834]);
AGR.TOC("matint","A9G1-Zr48B0.g",[94101296]);
AGR.TOC("matint","A9G1-Zr56B0.g",[-105813169]);
AGR.TOC("matint","A9G1-Zr84B0.g",[-106644844]);
AGR.TOC("matint","A9G1-Zr105B0.g",[-75292765]);
AGR.TOC("matint","A9G1-Zr120B0.g",[33650659]);
AGR.TOC("matint","A9G1-Zr162B0.g",[11215876]);
AGR.TOC("matint","A9G1-Zr168B0.g",[-43654782]);
AGR.TOC("matint","A9G1-Zr189B0.g",[-7898273]);
AGR.TOC("matint","A9G1-Zr216B0.g",[-36845553]);
AGR.TOC("check","A9G1-check1",[66671310]);

# S9
AGR.GRP("alt","A9","S9");
AGR.TOC("perm","S9G1-p9B0.m",[122091756,24861253]);

# O10m2
AGR.GRP("clas","O10m2","O10m2");
AGR.TOC("perm","O10m2G1-p495B0.m",[-28308088,-22761395]);
AGR.TOC("perm","O10m2G1-p528B0.m",[70479596,-62621089]);
AGR.TOC("matff","O10m2G1-f2r10B0.m",[-91875246,-117747323]);
AGR.TOC("matff","O10m2G1-f2r44B0.m",[-36564213,114587901]);
AGR.TOC("matff","O10m2G1-f2r100B0.m",[92769221,-44362353]);
AGR.TOC("matff","O10m2G1-f2r164B0.m",[18230970,48739712]);
AGR.TOC("matff","O10m2G1-f2r670B0.m",[61340105,69740282]);
AGR.TOC("matff","O10m2G1-f4r16aB0.m",[61178056,-5229430]);
AGR.TOC("matff","O10m2G1-f4r16bB0.m",[128197535,31596352]);
AGR.TOC("matint","O10m2G1-Zr154B0.g",[-57005457]);
AGR.TOC("matint","O10m2G1-Zr187B0.g",[-100202868]);

# O10m2d2
AGR.GRP("clas","O10m2","O10m2d2");
AGR.TOC("perm","O10m2d2G1-p495B0.m",[82167210,-72434757]);
AGR.TOC("perm","O10m2d2G1-p528B0.m",[-117006734,-28217316]);
AGR.TOC("perm","O10m2d2G1-p104448B0.m",[50997897,113123073]);
AGR.TOC("matff","O10m2d2G1-f2r10B0.m",[-2306716,-13453481]);
AGR.TOC("matff","O10m2d2G1-f2r32B0.m",[32911303,-129767206]);
AGR.TOC("matff","O10m2d2G1-f2r44B0.m",[-104143658,103914544]);
AGR.TOC("matff","O10m2d2G1-f2r100B0.m",[100488452,-14739345]);
AGR.TOC("matff","O10m2d2G1-f2r164B0.m",[-75666222,-60099061]);
AGR.TOC("matff","O10m2d2G1-f2r670B0.m",[-126418327,88563704]);

# O10p2
AGR.GRP("clas","O10p2","O10p2");
AGR.TOC("perm","O10p2G1-p496B0.m",[44844370,37744812]);
AGR.TOC("perm","O10p2G1-p527B0.m",[-115724540,71638127]);
AGR.TOC("perm","O10p2G1-p2295aB0.m",[38660726,-113571137]);
AGR.TOC("perm","O10p2G1-p2295bB0.m",[-48288307,-4515067]);
AGR.TOC("perm","O10p2G1-p19840B0.m",[-55658699,-102645640]);
AGR.TOC("perm","O10p2G1-p23715B0.m",[-19740974,108222650]);
AGR.TOC("perm","O10p2G1-p39680B0.m",[-6853718,-83381012]);
AGR.TOC("matff","O10p2G1-f2r10B0.m",[1103290,23925280]);
AGR.TOC("matff","O10p2G1-f2r16aB0.m",[-120091825,-123583018]);
AGR.TOC("matff","O10p2G1-f2r16bB0.m",[-12069847,-35735047]);
AGR.TOC("matff","O10p2G1-f2r44B0.m",[110527978,-100120992]);
AGR.TOC("matff","O10p2G1-f2r100B0.m",[-30089365,57879096]);
AGR.TOC("matff","O10p2G1-f2r144aB0.m",[110645650,29636318]);
AGR.TOC("matff","O10p2G1-f2r144bB0.m",[-30221860,44280011]);
AGR.TOC("matff","O10p2G1-f2r164B0.m",[-22042842,30232047]);
AGR.TOC("matff","O10p2G1-f2r320B0.m",[75333417,129740052]);
AGR.TOC("matff","O10p2G1-f2r416aB0.m",[-108205687,102236385]);
AGR.TOC("matff","O10p2G1-f2r416bB0.m",[101254524,51323514]);
AGR.TOC("matff","O10p2G1-f2r670B0.m",[-130973724,2357046]);
AGR.TOC("matff","O10p2G1-f3r155B0.m",[17052865,-30642849]);
AGR.TOC("matff","O10p2G1-f3r185B0.m",[108681429,77852925]);
AGR.TOC("matff","O10p2G1-f3r868B0.m",[-18367210,-8755148]);
AGR.TOC("matint","O10p2G1-Zr155B0.g",[97641513]);
AGR.TOC("matint","O10p2G1-Zr186B0.g",[-108863655]);
AGR.TOC("maxes","O10p2G1-max1W1",[-101864758]);
AGR.TOC("maxes","O10p2G1-max2W1",[-92187776]);
AGR.TOC("maxes","O10p2G1-max3W1",[38781566]);
AGR.TOC("maxes","O10p2G1-max4W1",[35823876]);
AGR.TOC("out","O10p2G1-aW1",[-14956717]);

# O10p2d2
AGR.GRP("clas","O10p2","O10p2d2");
AGR.TOC("perm","O10p2d2G1-p496B0.m",[126131529,-42810830]);
AGR.TOC("perm","O10p2d2G1-p527B0.m",[109880158,41785888]);
AGR.TOC("perm","O10p2d2G1-p4590B0.m",[-109285430,6021856]);
AGR.TOC("matff","O10p2d2G1-f2r10B0.m",[98286660,84434027]);
AGR.TOC("matff","O10p2d2G1-f2r32B0.m",[-30928128,-93439691]);
AGR.TOC("matff","O10p2d2G1-f2r44B0.m",[104439943,58205560]);
AGR.TOC("matff","O10p2d2G1-f2r100B0.m",[-11949612,133828120]);
AGR.TOC("matff","O10p2d2G1-f2r164B0.m",[-83317851,-96030590]);
AGR.TOC("matff","O10p2d2G1-f2r288B0.m",[-33354065,41077158]);
AGR.TOC("matff","O10p2d2G1-f2r320B0.m",[-105116064,-3698751]);
AGR.TOC("matff","O10p2d2G1-f2r670B0.m",[74131930,11768729]);
AGR.TOC("matff","O10p2d2G1-f2r832B0.m",[-29701783,115777543]);
AGR.TOC("pres","O10p2d2G1-P1",[-125096160]);

# 2O73
AGR.GRP("clas","O73","2O73");
AGR.TOC("perm","2O73G1-p2160B0.m",[-52076683,-20333004]);
AGR.TOC("matff","2O73G1-f3r8B0.m",[127365476,25520583]);

# 3O73
AGR.GRP("clas","O73","3O73");
AGR.TOC("matff","3O73G1-f4r27aB0.m",[-46449646,-117029484]);

# 3O73d2
AGR.GRP("clas","O73","3O73d2");
AGR.TOC("matff","3O73d2G1-f2r54B0.m",[-90690899,22318719]);

# O73
AGR.GRP("clas","O73","O73");
AGR.TOC("perm","O73G1-p351B0.m",[82717158,59833498]);
AGR.TOC("perm","O73G1-p364B0.m",[44293817,98554937]);
AGR.TOC("perm","O73G1-p378B0.m",[87776874,53481543]);
AGR.TOC("perm","O73G1-p1080aB0.m",[-42599020,-36616958]);
AGR.TOC("perm","O73G1-p1080bB0.m",[132529762,60964145]);
AGR.TOC("perm","O73G1-p1120B0.m",[126618791,36524551]);
AGR.TOC("perm","O73G1-p3640B0.m",[-110156981,121387707]);
AGR.TOC("matff","O73G1-f2r78B0.m",[6999211,89780880]);
AGR.TOC("matff","O73G1-f2r90B0.m",[-23762673,39638601]);
AGR.TOC("matff","O73G1-f2r104B0.m",[-89855475,46063845]);
AGR.TOC("matff","O73G1-f2r260aB0.m",[-99269314,702557]);
AGR.TOC("matff","O73G1-f2r260bB0.m",[-99269314,-47011243]);
AGR.TOC("matff","O73G1-f3r7B0.m",[-73121160,-21443771]);
AGR.TOC("matff","O73G1-f3r21B0.m",[82240744,21396837]);
AGR.TOC("matff","O73G1-f3r27B0.m",[-47629963,-128106566]);
AGR.TOC("matff","O73G1-f3r35B0.m",[23866511,-48444403]);
AGR.TOC("matff","O73G1-f3r63B0.m",[99738307,-113235112]);
AGR.TOC("matff","O73G1-f3r189aB0.m",[32603443,35965043]);
AGR.TOC("matff","O73G1-f3r309B0.m",[82194057,63427926]);
AGR.TOC("matff","O73G1-f5r78B0.m",[51985420,113524193]);
AGR.TOC("matff","O73G1-f7r78B0.m",[-46420014,-13996426]);
AGR.TOC("matff","O73G1-f13r78B0.m",[-59693717,-91113521]);
AGR.TOC("matint","O73G1-Zr78B0.g",[-90841402]);
AGR.TOC("matint","O73G1-Zr91B0.g",[-89128615]);
AGR.TOC("matint","O73G1-Zr105B0.g",[-101644473]);
AGR.TOC("matint","O73G1-Zr168B0.g",[66310041]);
AGR.TOC("matint","O73G1-Zr182B0.g",[25658348]);
AGR.TOC("matint","O73G1-Zr195B0.g",[131461461]);

# O73d2
AGR.GRP("clas","O73","O73d2");
AGR.TOC("perm","O73d2G1-p351B0.m",[-10725195,127224107]);
AGR.TOC("matff","O73d2G1-f2r78B0.m",[-54160091,89711834]);
AGR.TOC("matff","O73d2G1-f3r7B0.m",[-40632628,119474507]);

# O8m2
AGR.GRP("clas","O8m2","O8m2");
AGR.TOC("perm","O8m2G1-p119B0.m",[-24365065,-85295695]);
AGR.TOC("perm","O8m2G1-p136B0.m",[-84196655,23106023]);
AGR.TOC("perm","O8m2G1-p765B0.m",[81333754,-50808634]);
AGR.TOC("perm","O8m2G1-p1071B0.m",[133774932,-90078008]);
AGR.TOC("perm","O8m2G1-p1632B0.m",[-99000947,-108986222]);
AGR.TOC("perm","O8m2G1-p24192B0.m",[-126775412,28682284]);
AGR.TOC("perm","O8m2G1-p45696B0.m",[130548056,-93532377]);
AGR.TOC("matff","O8m2G1-f2r8B0.m",[-87980185,127418639]);
AGR.TOC("matff","O8m2G1-f2r26B0.m",[67804363,-130270035]);
AGR.TOC("matff","O8m2G1-f2r48B0.m",[-14063248,4273112]);
AGR.TOC("matff","O8m2G1-f3r34B0.m",[-29666937,92656759]);
AGR.TOC("matff","O8m2G1-f3r50B0.m",[-15689624,-98254103]);
AGR.TOC("matff","O8m2G1-f4r8bB0.m",[-13058890,-119239206]);
AGR.TOC("matff","O8m2G1-f4r8cB0.m",[70013215,-12653524]);
AGR.TOC("matff","O8m2G1-f4r48bB0.m",[-80990745,-24164226]);
AGR.TOC("matff","O8m2G1-f4r48cB0.m",[97513962,82777957]);
AGR.TOC("matff","O8m2G1-f5r34B0.m",[15034639,90818541]);
AGR.TOC("matff","O8m2G1-f5r51B0.m",[125362755,88918352]);
AGR.TOC("matff","O8m2G1-f5r84B0.m",[-111056563,24817596]);
AGR.TOC("matff","O8m2G1-f7r33B0.m",[44085251,37064396]);
AGR.TOC("matff","O8m2G1-f7r51B0.m",[87717115,-65218449]);
AGR.TOC("matff","O8m2G1-f7r84B0.m",[-58834030,96414922]);
AGR.TOC("matff","O8m2G1-f17r34B0.m",[-122498723,-76593032]);
AGR.TOC("matff","O8m2G1-f17r51B0.m",[-19701269,38579551]);
AGR.TOC("matff","O8m2G1-f17r83B0.m",[70197507,91520986]);
AGR.TOC("matint","O8m2G1-Zr34B0.g",[12291934]);
AGR.TOC("matint","O8m2G1-Zr51B0.g",[114705452]);
AGR.TOC("matint","O8m2G1-Zr84B0.g",[-49115406]);
AGR.TOC("matint","O8m2G1-Zr204aB0.g",[-545048]);
AGR.TOC("matint","O8m2G1-Zr204bB0.g",[90706063]);
AGR.TOC("cyclic","O8m2G1-cycW1",[75038654]);
AGR.TOC("cyc2ccl","O8m2G1cycW1-cclsW1",[-130617321]);

# O8m2d2
AGR.GRP("clas","O8m2","O8m2d2");
AGR.TOC("perm","O8m2d2G1-p119B0.m",[-6041009,115888367]);
AGR.TOC("matff","O8m2d2G1-f2r8B0.m",[46258515,-78987090]);
AGR.TOC("matff","O8m2d2G1-f3r34B0.m",[-120358158,-35720310]);
AGR.TOC("matff","O8m2d2G1-f3r50B0.m",[-81409905,-77731908]);
AGR.TOC("cyclic","O8m2d2G1-cycW1",[84687561]);
AGR.TOC("cyc2ccl","O8m2d2G1cycW1-cclsW1",[112814052]);

# 2O8m3
AGR.GRP("clas","O8m3","2O8m3");
AGR.TOC("matff","2O8m3G1-f3r16B0.m",[-47700701,134124282]);
AGR.TOC("matff","2O8m3G1-f9r8aB0.m",[-98620704,-118542521]);
AGR.TOC("matff","2O8m3G1-f9r8bB0.m",[4224939,-14594253]);

# 2O8m3d2a
AGR.GRP("clas","O8m3","2O8m3d2a");
AGR.TOC("matff","2O8m3d2aG1-f3r16B0.m",[-51454663,-42616726]);

# O8m3
AGR.GRP("clas","O8m3","O8m3");
AGR.TOC("perm","O8m3G1-p1066B0.m",[-37177084,99457625]);
AGR.TOC("matff","O8m3G1-f3r8B0.m",[-35438651,20098849]);
AGR.TOC("matint","O8m3G1-Zr246B0.g",[-58311842]);

# O8m3D8
AGR.GRP("clas","O8m3","O8m3D8");
AGR.TOC("matff","O8m3D8G1-f3r8B0.m",[119493405,9420304]);

# O8m3V4
AGR.GRP("clas","O8m3","O8m3V4");
AGR.TOC("perm","O8m3V4G1-p1066B0.m",[-125437571,-83299227]);
AGR.TOC("matff","O8m3V4G1-f3r16B0.m",[-21513338,-61914400]);

# O8m3d2a
AGR.GRP("clas","O8m3","O8m3d2a");
AGR.TOC("perm","O8m3d2aG1-p1066B0.m",[101936687,-112453392]);
AGR.TOC("matff","O8m3d2aG1-f3r8B0.m",[30174304,84036930]);

# O8m3d2c
AGR.GRP("clas","O8m3","O8m3d2c");
AGR.TOC("perm","O8m3d2cG1-p1066B0.m",[50468861,-130105713]);
AGR.TOC("perm","O8m3d2cG2-p1066B0.m",[42767122,-112906276]);
AGR.TOC("matff","O8m3d2cG1-f3r8aB0.m",[16162087,-12619273]);

# O8p2
AGR.GRP("clas","O8p2","O8p2");
AGR.TOC("matint","O8p2G1-Zr28B0.g",[-80118051]);
AGR.TOC("matint","O8p2G1-Zr35aB0.g",[-26379578]);
AGR.TOC("matint","O8p2G1-Zr35bB0.g",[-117206642]);
AGR.TOC("matint","O8p2G1-Zr35cB0.g",[123375245]);
AGR.TOC("matint","O8p2G1-Zr50B0.g",[130935801]);
AGR.TOC("matint","O8p2G1-Zr84aB0.g",[62823799]);
AGR.TOC("matint","O8p2G1-Zr84bB0.g",[-90117537]);
AGR.TOC("matint","O8p2G1-Zr84cB0.g",[-34245370]);
AGR.TOC("matint","O8p2G1-Zr175B0.g",[98193599]);
AGR.TOC("matint","O8p2G1-Zr210B0.g",[107071400]);
AGR.TOC("matint","O8p2G1-Zr210aB0.g",[-77879394]);
AGR.TOC("matint","O8p2G1-Zr210bB0.g",[-61543489]);
AGR.TOC("matint","O8p2G1-Zr210cB0.g",[-67812962]);

# O8p2d2
AGR.GRP("clas","O8p2","O8p2d2");
AGR.TOC("pres","O8p2d2G1-P1",[115334752]);

# 2O8p3
AGR.GRP("clas","O8p3","2O8p3");
AGR.TOC("perm","2O8p3G1-p2160aB0.m",[104589607,120500317]);
AGR.TOC("perm","2O8p3G1-p2160bB0.m",[-59887176,-111333114]);
AGR.TOC("perm","2O8p3G1-p2240B0.m",[-29160158,-93829527]);
AGR.TOC("matff","2O8p3G1-f3r8B0.m",[126054580,-51595733]);
AGR.TOC("matff","2O8p3G1-f3r56B0.m",[34510739,42120628]);
AGR.TOC("matff","2O8p3G1-f3r104B0.m",[112739598,125768182]);
AGR.TOC("matff","2O8p3G1-f3r224aB0.m",[53015969,-35489900]);
AGR.TOC("matff","2O8p3G1-f3r224bB0.m",[-46687382,107828721]);
AGR.TOC("matff","2O8p3G1-f3r384B0.m",[-87738697,93596151]);

# 4O8p3S4
AGR.GRP("clas","O8p3","4O8p3S4");
AGR.TOC("matff","4O8p3S4G2-f3r24B0.m",[-37088614,-5932360]);

# O8p3
AGR.GRP("clas","O8p3","O8p3");
AGR.TOC("perm","O8p3G1-p1080aB0.m",[76405715,119208768]);
AGR.TOC("perm","O8p3G1-p1080bB0.m",[-68159021,33166699]);
AGR.TOC("perm","O8p3G1-p1080cB0.m",[17260632,51712891]);
AGR.TOC("perm","O8p3G1-p1080dB0.m",[-125607236,-30759303]);
AGR.TOC("perm","O8p3G1-p1080eB0.m",[74691432,-55283348]);
AGR.TOC("perm","O8p3G1-p1080fB0.m",[54228347,106065431]);
AGR.TOC("perm","O8p3G1-p1120aB0.m",[52313105,-86975260]);
AGR.TOC("perm","O8p3G1-p1120bB0.m",[-121913929,-24963882]);
AGR.TOC("perm","O8p3G1-p1120cB0.m",[96067467,51334109]);
AGR.TOC("perm","O8p3G1-p28431aB0.m",[48610439,-17098280]);
AGR.TOC("perm","O8p3G1-p28431bB0.m",[102357116,-2915723]);
AGR.TOC("perm","O8p3G1-p28431cB0.m",[-95236754,131710927]);
AGR.TOC("perm","O8p3G1-p28431dB0.m",[103757910,-111662481]);
AGR.TOC("perm","O8p3G1-p36400B0.m",[55974738,124609534]);
AGR.TOC("matff","O8p3G1-f2r298B0.m",[-80048270,12965683]);
AGR.TOC("matff","O8p3G1-f3r28B0.m",[-38352800,-50831561]);
AGR.TOC("matff","O8p3G1-f3r35aB0.m",[-12113194,-122443902]);
AGR.TOC("matff","O8p3G1-f3r35bB0.m",[-38499650,86939687]);
AGR.TOC("matff","O8p3G1-f3r35cB0.m",[-49437023,-57407446]);
AGR.TOC("matff","O8p3G1-f3r195B0.m",[-81944772,-115100921]);
AGR.TOC("matff","O8p3G1-f3r322B0.m",[-110644111,-106498308]);
AGR.TOC("matff","O8p3G1-f3r518aB0.m",[90564527,13554317]);
AGR.TOC("matff","O8p3G1-f3r518bB0.m",[24959864,-28716903]);
AGR.TOC("matff","O8p3G1-f3r518cB0.m",[-90638633,-117911955]);
AGR.TOC("matff","O8p3G1-f3r567aB0.m",[86810431,652709]);
AGR.TOC("matff","O8p3G1-f3r567bB0.m",[-18854913,10740889]);
AGR.TOC("matff","O8p3G1-f3r567cB0.m",[-72848256,116897648]);
AGR.TOC("matff","O8p3G1-f5r300B0.m",[-96518534,58939546]);
AGR.TOC("matff","O8p3G1-f7r299B0.m",[49912950,109610342]);
AGR.TOC("matff","O8p3G1-f13r300B0.m",[-110252186,49072647]);
AGR.TOC("maxes","O8p3G1-max1W1",[2216648]);
AGR.TOC("maxes","O8p3G1-max2W1",[-28575246]);
AGR.TOC("maxes","O8p3G1-max7W1",[57517580]);
AGR.TOC("maxes","O8p3G1-max10W1",[-15154337]);
AGR.TOC("maxes","O8p3G1-max11W1",[-131676141]);
AGR.TOC("maxes","O8p3G1-max12W1",[41998115]);
AGR.TOC("maxes","O8p3G1-max13W1",[-129259704]);

# O8p3S4
AGR.GRP("clas","O8p3","O8p3S4");
AGR.TOC("perm","O8p3S4G2-p3360B0.m",[-73519604,92311368]);
AGR.TOC("perm","O8p3S4G2-p6480B0.m",[-96733550,-79748109]);

# 2O93
AGR.GRP("clas","O93","2O93");
AGR.TOC("matff","2O93G1-f3r16B0.m",[-95326868,58590017]);

# 2O93d2
AGR.GRP("clas","O93","2O93d2");
AGR.TOC("matff","2O93d2G1-f3r16B0.m",[77369705,47492252]);

# O93
AGR.GRP("clas","O93","O93");
AGR.TOC("matff","O93G1-f3r9B0.m",[129442029,88034840]);

# O93d2
AGR.GRP("clas","O93","O93d2");
AGR.TOC("matff","O93d2G1-f3r9B0.m",[-79044930,88034840]);

# S102
AGR.GRP("clas","S102","S102");
AGR.TOC("perm","S102G1-p496B0.m",[19286218,-67519190]);
AGR.TOC("perm","S102G1-p528B0.m",[-38467752,-50310250]);
AGR.TOC("perm","S102G1-p992B0.m",[-12757228,-113671661]);
AGR.TOC("perm","S102G1-p1023B0.m",[98443786,53485020]);
AGR.TOC("perm","S102G1-p1056B0.m",[71933464,-92710051]);
AGR.TOC("matff","S102G1-f2r10B0.m",[124085043,-13453481]);
AGR.TOC("matff","S102G1-f2r32B0.m",[-49264749,-91273828]);
AGR.TOC("matff","S102G1-f2r44B0.m",[36644287,91403710]);
AGR.TOC("matff","S102G1-f2r100B0.m",[-132339785,-133660920]);
AGR.TOC("matff","S102G1-f2r164B0.m",[-107118642,102810791]);
AGR.TOC("matff","S102G1-f3r155B0.m",[-92478285,76933694]);
AGR.TOC("matff","S102G1-f5r155B0.m",[4586104,-94557375]);
AGR.TOC("matff","S102G1-f7r155B0.m",[29485763,62763193]);
AGR.TOC("matff","S102G1-f11r155B0.m",[8136867,88782646]);
AGR.TOC("matff","S102G1-f17r155B0.m",[63442455,-63872646]);
AGR.TOC("matff","S102G1-f31r155B0.m",[87124238,112546228]);
AGR.TOC("matint","S102G1-Zr155B0.g",[108190402]);
AGR.TOC("matint","S102G1-Zr187B0.g",[93560770]);
AGR.TOC("matint","S102G1-Zr341B0.g",[48503668]);
AGR.TOC("find","S102G1-find1",[129550160]);
AGR.TOC("check","S102G1-check1",[-13486801]);
AGR.TOC("pres","S102G1-P1",[-55394161]);

# 2S411
AGR.GRP("clas","S411","2S411");
AGR.TOC("matff","2S411G1-f11r4B0.m",[-62133377,-81234251]);

# S411
AGR.GRP("clas","S411","S411");
AGR.TOC("matint","S411G1-Zr122B0.g",[50315406]);

# 2S413
AGR.GRP("clas","S413","2S413");
AGR.TOC("matff","2S413G1-f13r4B0.m",[-26262853,11056926]);

# S413
AGR.GRP("clas","S413","S413");
AGR.TOC("matint","S413G1-Zr170B0.g",[77408384]);

# 2S417
AGR.GRP("clas","S417","2S417");
AGR.TOC("matff","2S417G1-f17r4B0.m",[-81277635,125804584]);

# S417
AGR.GRP("clas","S417","S417");
AGR.TOC("matint","S417G1-Zr290B0.g",[-72216373]);
AGR.TOC("find","S417G1-find1",[-18889750]);
AGR.TOC("check","S417G1-check1",[72575667]);

# 2S419
AGR.GRP("clas","S419","2S419");
AGR.TOC("matff","2S419G1-f19r4B0.m",[64679712,-133457148]);

# S419
AGR.GRP("clas","S419","S419");
AGR.TOC("matint","S419G1-Zr362B0.g",[48497725]);

# S44
AGR.GRP("clas","S44","S44");
AGR.TOC("perm","S44G1-p85aB0.m",[-4049736,98956541]);
AGR.TOC("perm","S44G1-p120bB0.m",[-55160714,-5595531]);
AGR.TOC("matff","S44G1-f3r18B0.m",[114490907,99206197]);
AGR.TOC("matff","S44G1-f4r4cB0.m",[-66916166,-36229155]);
AGR.TOC("matff","S44G1-f5r18B0.m",[98095481,96944879]);
AGR.TOC("matff","S44G1-f5r33bB0.m",[20921094,104905736]);
AGR.TOC("matff","S44G1-f17r18B0.m",[8287404,24636442]);
AGR.TOC("matint","S44G1-Zr18B0.g",[-92216193]);
AGR.TOC("matint","S44G1-Zr34aB0.g",[-114599776]);
AGR.TOC("matint","S44G1-Zr34bB0.g",[31318568]);
AGR.TOC("matint","S44G1-Zr50B0.g",[82053304]);
AGR.TOC("matint","S44G1-Zr50aB0.g",[127917418]);
AGR.TOC("matint","S44G1-Zr85B0.g",[-60331055]);
AGR.TOC("matint","S44G1-Zr85aB0.g",[-55355440]);
AGR.TOC("matint","S44G1-Zr85bB0.g",[-87893036]);
AGR.TOC("matint","S44G1-Zr102B0.g",[-132149009]);
AGR.TOC("matint","S44G1-Zr102aB0.g",[-16877799]);
AGR.TOC("matint","S44G1-Zr102bB0.g",[-74561258]);
AGR.TOC("matint","S44G1-Zr153B0.g",[15162004]);
AGR.TOC("matint","S44G1-Zr408aB0.g",[-23986942]);
AGR.TOC("matint","S44G1-Zr408bB0.g",[-41782718]);
AGR.TOC("matint","S44G1-Zr900B0.g",[-56344576]);
AGR.TOC("matalg","S44G1-Ar51aB0.g",[-128202902]);
AGR.TOC("matalg","S44G1-Ar51bB0.g",[-131177657]);
AGR.TOC("matalg","S44G1-Ar204aB0.g",[13435942]);
AGR.TOC("matalg","S44G1-Ar204bB0.g",[-111688591]);
AGR.TOC("maxes","S44G1-max1W1",[-110197138]);
AGR.TOC("maxes","S44G1-max2W1",[60156120]);
AGR.TOC("maxes","S44G1-max3W1",[64975797]);
AGR.TOC("maxes","S44G1-max4W1",[-4819000]);
AGR.TOC("maxes","S44G1-max5W1",[-40888439]);
AGR.TOC("maxes","S44G1-max6W1",[49264090]);
AGR.TOC("maxes","S44G1-max7W1",[41124433]);
AGR.TOC("check","S44G1-check1",[25741154]);

# S44d2
AGR.GRP("clas","S44","S44d2");
AGR.TOC("matff","S44d2G1-f2r8aB0.m",[84946852,69419253]);

# S44d4
AGR.GRP("clas","S44","S44d4");
AGR.TOC("perm","S44d4G1-p170B0.m",[40288287,-41064186]);
AGR.TOC("matff","S44d4G1-f2r16B0.m",[14450064,-31042563]);

# 2S45
AGR.GRP("clas","S45","2S45");
AGR.TOC("perm","2S45G1-p624B0.m",[22743163,-27127675]);
AGR.TOC("matff","2S45G1-f5r4B0.m",[88096190,36430521]);

# S45
AGR.GRP("clas","S45","S45");
AGR.TOC("perm","S45G1-p156aB0.m",[-53395980,-100717682]);
AGR.TOC("perm","S45G1-p156bB0.m",[-72278991,40973879]);
AGR.TOC("perm","S45G1-p300B0.m",[-110880512,66617936]);
AGR.TOC("perm","S45G1-p325B0.m",[41580917,-93531917]);
AGR.TOC("matff","S45G1-f4r12aB0.m",[-16820011,-122202833]);
AGR.TOC("matff","S45G1-f5r5B0.m",[-132964163,87158107]);
AGR.TOC("matff","S45G1-f9r13B0.m",[-64769881,16766469]);
AGR.TOC("matint","S45G1-Zr40B0.g",[-38090816]);
AGR.TOC("matint","S45G1-Zr65aB0.g",[-39598817]);
AGR.TOC("matint","S45G1-Zr65bB0.g",[114339701]);
AGR.TOC("matint","S45G1-Zr90B0.g",[-20169873]);
AGR.TOC("matint","S45G1-Zr104aB0.g",[76838380]);
AGR.TOC("matint","S45G1-Zr104bB0.g",[-9158621]);
AGR.TOC("matint","S45G1-Zr104cB0.g",[-116564476]);
AGR.TOC("matint","S45G1-Zr130B0.g",[83528461]);
AGR.TOC("matint","S45G1-Zr156B0.g",[-22613123]);
AGR.TOC("matint","S45G1-Zr416B0.g",[-132297784]);
AGR.TOC("matalg","S45G1-Ar13aB0.g",[82785093]);
AGR.TOC("matalg","S45G1-Ar13bB0.g",[17930268]);
AGR.TOC("maxes","S45G1-max1W1",[-72800046]);
AGR.TOC("maxes","S45G1-max2W1",[-110892584]);
AGR.TOC("maxes","S45G1-max3W1",[1319277]);
AGR.TOC("maxes","S45G1-max4W1",[92563265]);
AGR.TOC("maxes","S45G1-max5W1",[-57392860]);
AGR.TOC("maxes","S45G1-max6W1",[19135983]);
AGR.TOC("maxes","S45G1-max7W1",[-11057337]);
AGR.TOC("maxes","S45G1-max8W1",[25577408]);
AGR.TOC("check","S45G1-check1",[-128114345]);

# S45d2
AGR.GRP("clas","S45","S45d2");
AGR.TOC("matff","S45d2G1-f2r24B0.m",[28899340,92326707]);
AGR.TOC("matff","S45d2G1-f2r40B0.m",[78563714,19245896]);
AGR.TOC("matff","S45d2G1-f2r64B0.m",[-11818053,88475813]);
AGR.TOC("matff","S45d2G1-f2r104aB0.m",[-31202775,-4732993]);
AGR.TOC("matff","S45d2G1-f2r104bB0.m",[-45827951,-77407041]);
AGR.TOC("matff","S45d2G1-f3r26B0.m",[-84226306,-131226197]);
AGR.TOC("matff","S45d2G1-f5r5B0.m",[22450810,28252478]);

# 2S47
AGR.GRP("clas","S47","2S47");
AGR.TOC("matff","2S47G1-f7r4B0.m",[-41072448,25081416]);

# 2S47d2
AGR.GRP("clas","S47","2S47d2");
AGR.TOC("matff","2S47d2G1-f7r4B0.m",[-9937153,25081416]);

# S47
AGR.GRP("clas","S47","S47");
AGR.TOC("perm","S47G1-p400aB0.m",[8389418,-67580392]);
AGR.TOC("perm","S47G1-p400bB0.m",[-63101719,-88778677]);
AGR.TOC("perm","S47G1-p1176B0.m",[-81024524,58885869]);
AGR.TOC("perm","S47G1-p1225B0.m",[1082744,-130482058]);
AGR.TOC("matff","S47G1-f7r5B0.m",[14910708,-106883497]);
AGR.TOC("matint","S47G1-Zr126B0.g",[-83694360]);
AGR.TOC("matint","S47G1-Zr175aB0.g",[127121412]);
AGR.TOC("matint","S47G1-Zr175bB0.g",[90115848]);
AGR.TOC("matint","S47G1-Zr224B0.g",[110716248]);
AGR.TOC("matalg","S47G1-Ar25aB0.g",[18948981]);
AGR.TOC("matalg","S47G1-Ar25bB0.g",[-8439203]);
AGR.TOC("check","S47G1-check1",[-116457689]);

# S47d2
AGR.GRP("clas","S47","S47d2");
AGR.TOC("perm","S47d2G1-p400aB0.m",[109276459,71668262]);
AGR.TOC("perm","S47d2G1-p400bB0.m",[17015866,-56639780]);
AGR.TOC("matff","S47d2G1-f7r5B0.m",[55105936,-106883497]);

# 2S49
AGR.GRP("clas","S49","2S49");
AGR.TOC("matff","2S49G1-f9r4B0.m",[71948431,7962193]);

# S49
AGR.GRP("clas","S49","S49");
AGR.TOC("matint","S49G1-Zr41aB0.g",[13872774]);
AGR.TOC("matint","S49G1-Zr41bB0.g",[-48292814]);
AGR.TOC("check","S49G1-check1",[49518488]);

# 2S62
AGR.GRP("clas","S62","2S62");
AGR.TOC("perm","2S62G1-p240aB0.m",[-56416490,105375861]);
AGR.TOC("perm","2S62G1-p240bB0.m",[-54217874,-60810975]);
AGR.TOC("perm","2S62G1-p480B0.m",[-14522420,-52304442]);
AGR.TOC("perm","2S62G1-p1920B0.m",[-92122712,-128892606]);
AGR.TOC("perm","2S62G1-p2160B0.m",[45205904,-45822516]);
AGR.TOC("matff","2S62G1-f3r8B0.m",[-44566694,-103259130]);
AGR.TOC("matff","2S62G1-f3r48B0.m",[-79973475,-86413405]);
AGR.TOC("matff","2S62G1-f3r56aB0.m",[-41596615,50826804]);
AGR.TOC("matff","2S62G1-f3r56bB0.m",[-89693038,-32511580]);
AGR.TOC("matff","2S62G1-f3r104B0.m",[101455940,101636538]);
AGR.TOC("matff","2S62G1-f3r272B0.m",[105650268,-120256780]);
AGR.TOC("matint","2S62G1-Zr8B0.g",[11283237]);
AGR.TOC("pres","2S62G1-P1",[35544777]);

# S62
AGR.GRP("clas","S62","S62");
AGR.TOC("perm","S62G1-p28B0.m",[110976306,76931350]);
AGR.TOC("perm","S62G1-p36B0.m",[48803935,71864601]);
AGR.TOC("perm","S62G1-p56B0.m",[-59385519,-91987812]);
AGR.TOC("perm","S62G1-p63B0.m",[-107037313,69320616]);
AGR.TOC("perm","S62G1-p72B0.m",[60101593,21113958]);
AGR.TOC("perm","S62G1-p120B0.m",[-65949187,-39483980]);
AGR.TOC("perm","S62G1-p126B0.m",[77733787,61299713]);
AGR.TOC("perm","S62G1-p135B0.m",[133224275,-56905045]);
AGR.TOC("perm","S62G1-p240B0.m",[14429414,108846365]);
AGR.TOC("perm","S62G1-p288B0.m",[112742404,-128942657]);
AGR.TOC("perm","S62G1-p315B0.m",[-4879533,-105655093]);
AGR.TOC("perm","S62G1-p336B0.m",[46625581,96365145]);
AGR.TOC("perm","S62G1-p378aB0.m",[91351044,-22337672]);
AGR.TOC("perm","S62G1-p378bB0.m",[121182969,80992080]);
AGR.TOC("perm","S62G1-p960B0.m",[73213424,-115372799]);
AGR.TOC("matff","S62G1-f2r6B0.m",[19312218,-22867308]);
AGR.TOC("matff","S62G1-f2r8B0.m",[39687452,69277150]);
AGR.TOC("matff","S62G1-f2r14B0.m",[-39020736,19866721]);
AGR.TOC("matff","S62G1-f2r48B0.m",[-129537517,119805676]);
AGR.TOC("matff","S62G1-f2r64B0.m",[130963387,-97154552]);
AGR.TOC("matff","S62G1-f2r112B0.m",[-37025041,115526766]);
AGR.TOC("matff","S62G1-f2r512B0.m",[-42832724,-21227198]);
AGR.TOC("matff","S62G1-f3r7B0.m",[-39696685,-56075794]);
AGR.TOC("matff","S62G1-f3r14B0.m",[84246854,-122001009]);
AGR.TOC("matff","S62G1-f3r21B0.m",[-71040565,54822646]);
AGR.TOC("matff","S62G1-f3r27B0.m",[61965192,-133825964]);
AGR.TOC("matff","S62G1-f3r34B0.m",[-84696386,-15969451]);
AGR.TOC("matff","S62G1-f3r35B0.m",[83314843,-58488375]);
AGR.TOC("matff","S62G1-f3r49B0.m",[-81505603,76099653]);
AGR.TOC("matff","S62G1-f3r91B0.m",[-61382880,118495085]);
AGR.TOC("matff","S62G1-f3r98B0.m",[-92225131,-98952991]);
AGR.TOC("matff","S62G1-f3r189aB0.m",[-94283157,28028612]);
AGR.TOC("matff","S62G1-f3r189bB0.m",[31083669,51585246]);
AGR.TOC("matff","S62G1-f3r189cB0.m",[-101055873,-58489210]);
AGR.TOC("matff","S62G1-f3r196B0.m",[13250675,-109876925]);
AGR.TOC("matff","S62G1-f3r405B0.m",[-55323738,86907721]);
AGR.TOC("matint","S62G1-Zr7B0.g",[129664427]);
AGR.TOC("matint","S62G1-Zr15B0.g",[-82755504]);
AGR.TOC("matint","S62G1-Zr21aB0.g",[55698598]);
AGR.TOC("matint","S62G1-Zr21bB0.g",[16632315]);
AGR.TOC("matint","S62G1-Zr27B0.g",[116794220]);
AGR.TOC("matint","S62G1-Zr35aB0.g",[-53184680]);
AGR.TOC("matint","S62G1-Zr35bB0.g",[-96769678]);
AGR.TOC("matint","S62G1-Zr56B0.g",[-118308605]);
AGR.TOC("matint","S62G1-Zr70B0.g",[116739536]);
AGR.TOC("matint","S62G1-Zr84B0.g",[34354222]);
AGR.TOC("matint","S62G1-Zr105aB0.g",[44180138]);
AGR.TOC("matint","S62G1-Zr105bB0.g",[16356187]);
AGR.TOC("matint","S62G1-Zr105cB0.g",[-122949576]);
AGR.TOC("matint","S62G1-Zr120B0.g",[-88554122]);
AGR.TOC("matint","S62G1-Zr168B0.g",[-109579451]);
AGR.TOC("matint","S62G1-Zr189aB0.g",[-76413044]);
AGR.TOC("matint","S62G1-Zr189bB0.g",[-130727757]);
AGR.TOC("matint","S62G1-Zr189cB0.g",[-127006297]);
AGR.TOC("matint","S62G1-Zr210aB0.g",[-8691854]);
AGR.TOC("matint","S62G1-Zr210bB0.g",[31690294]);
AGR.TOC("matint","S62G1-Zr216B0.g",[-8956410]);
AGR.TOC("maxes","S62G1-max1W1",[65571750]);
AGR.TOC("maxes","S62G1-max2W1",[-94856361]);
AGR.TOC("maxes","S62G1-max3W1",[-20640548]);
AGR.TOC("maxes","S62G1-max4W1",[78361775]);
AGR.TOC("maxes","S62G1-max5W1",[2207467]);
AGR.TOC("maxes","S62G1-max6W1",[-120723562]);
AGR.TOC("maxes","S62G1-max7W1",[-37873323]);
AGR.TOC("maxes","S62G1-max8W1",[117469055]);
AGR.TOC("classes","S62G1-cclsW1",[122548041]);
AGR.TOC("cyclic","S62G1-cycW1",[71238045]);
AGR.TOC("cyc2ccl","S62G1cycW1-cclsW1",[-58490974]);
AGR.TOC("check","S62G1-check1",[25881517]);
AGR.TOC("pres","S62G1-P1",[-109008602]);

# 2S63
AGR.GRP("clas","S63","2S63");
AGR.TOC("matff","2S63G1-f3r6B0.m",[126789964,91588475]);

# 2S63d2
AGR.GRP("clas","S63","2S63d2");
AGR.TOC("perm","2S63d2G1-p728B0.m",[73132286,100183245]);
AGR.TOC("matff","2S63d2G1-f3r6B0.m",[25224878,-106581972]);

# S63
AGR.GRP("clas","S63","S63");
AGR.TOC("perm","S63G1-p364B0.m",[-118604311,-16543820]);
AGR.TOC("perm","S63G1-p1120B0.m",[-104841187,46945405]);
AGR.TOC("perm","S63G1-p3640B0.m",[112776586,-63120543]);
AGR.TOC("perm","S63G1-p7371B0.m",[-117628514,52928025]);
AGR.TOC("matff","S63G1-f2r78B0.m",[-75626185,14759642]);
AGR.TOC("matff","S63G1-f4r13aB0.m",[127110748,-48089272]);
AGR.TOC("matff","S63G1-f7r13aB0.m",[46515349,10052906]);
AGR.TOC("matff","S63G1-f25r13aB0.m",[124735498,59699487]);
AGR.TOC("matint","S63G1-Zr105B0.g",[-14551475]);
AGR.TOC("matint","S63G1-Zr168B0.g",[-118187547]);
AGR.TOC("matint","S63G1-Zr195B0.g",[-42398291]);
AGR.TOC("matalg","S63G1-Ar13aB0.g",[89649931]);
AGR.TOC("matalg","S63G1-Ar13bB0.g",[23578946]);
AGR.TOC("matalg","S63G1-Ar78B0.g",[-103564578]);
AGR.TOC("matalg","S63G1-Ar91aB0.g",[110472391]);
AGR.TOC("matalg","S63G1-Ar91bB0.g",[-74436229]);
AGR.TOC("maxes","S63G1-max1W1",[65463392]);
AGR.TOC("maxes","S63G1-max2W1",[-64140193]);
AGR.TOC("maxes","S63G1-max4W1",[38624687]);
AGR.TOC("maxes","S63G1-max5W1",[68902133]);
AGR.TOC("maxes","S63G1-max6W1",[-11400556]);
AGR.TOC("maxes","S63G1-max7W1",[3923366]);
AGR.TOC("maxes","S63G1-max8W1",[-54178902]);
AGR.TOC("maxes","S63G1-max9W1",[32541909]);
AGR.TOC("maxes","S63G1-max10W1",[-8454259]);
AGR.TOC("maxes","S63G1-max11W1",[-79997220]);

# S63d2
AGR.GRP("clas","S63","S63d2");
AGR.TOC("perm","S63d2G1-p364B0.m",[-132668143,-95553371]);
AGR.TOC("perm","S63d2G1-p1120B0.m",[-28676748,-78532620]);
AGR.TOC("perm","S63d2G1-p3640B0.m",[-65079509,113173068]);
AGR.TOC("perm","S63d2G1-p7371B0.m",[-88145812,-44758761]);
AGR.TOC("matff","S63d2G1-f2r26B0.m",[6007477,10315021]);
AGR.TOC("matff","S63d2G1-f3r13B0.m",[32905713,123187964]);

# S65
AGR.GRP("clas","S65","S65");
AGR.TOC("perm","S65G1-p3906B0.m",[102938262,-63570841]);

# S82
AGR.GRP("clas","S82","S82");
AGR.TOC("perm","S82G1-p120B0.m",[123689100,68180547]);
AGR.TOC("perm","S82G1-p136B0.m",[100902606,-92322247]);
AGR.TOC("perm","S82G1-p240B0.m",[-14798042,-44832011]);
AGR.TOC("perm","S82G1-p255B0.m",[6989233,-25131992]);
AGR.TOC("perm","S82G1-p272B0.m",[12328305,56946681]);
AGR.TOC("perm","S82G1-p2295B0.m",[60858670,133484843]);
AGR.TOC("perm","S82G1-p5355B0.m",[-8308181,-120195795]);
AGR.TOC("matff","S82G1-f2r8B0.m",[56786564,-7169716]);
AGR.TOC("matff","S82G1-f2r16B0.m",[42863545,40375752]);
AGR.TOC("matff","S82G1-f2r26B0.m",[-23871571,-36710350]);
AGR.TOC("matff","S82G1-f2r48B0.m",[-44393766,36116544]);
AGR.TOC("matff","S82G1-f3r35B0.m",[75102353,85985046]);
AGR.TOC("matff","S82G1-f3r50B0.m",[128010346,-94475218]);
AGR.TOC("matff","S82G1-f5r35B0.m",[111491901,6342229]);
AGR.TOC("matff","S82G1-f5r51B0.m",[-2439101,80588667]);
AGR.TOC("matff","S82G1-f7r35B0.m",[-121858343,9682389]);
AGR.TOC("matff","S82G1-f7r51B0.m",[-31942209,67026475]);
AGR.TOC("matff","S82G1-f17r35B0.m",[58019619,70088272]);
AGR.TOC("matff","S82G1-f17r51B0.m",[106285395,57981536]);
AGR.TOC("matint","S82G1-Zr35B0.g",[49754726]);
AGR.TOC("matint","S82G1-Zr51B0.g",[20525784]);
AGR.TOC("matint","S82G1-Zr85B0.g",[89705460]);
AGR.TOC("matint","S82G1-Zr119B0.g",[2402187]);
AGR.TOC("matint","S82G1-Zr135B0.g",[-26481830]);

# S83
AGR.GRP("clas","S83","S83");
AGR.TOC("perm","S83G1-p3280B0.m",[84149580,48280183]);

# 3U311
AGR.GRP("clas","U311","3U311");
AGR.TOC("matff","3U311G1-f121r3aB0.m",[54120386,43906884]);

# 3U311d2
AGR.GRP("clas","U311","3U311d2");
AGR.TOC("matff","3U311d2G1-f11r6B0.m",[113731019,-118688209]);

# U311
AGR.GRP("clas","U311","U311");
AGR.TOC("perm","U311G1-p1332B0.m",[-2399457,108019957]);
AGR.TOC("matff","U311G1-f2r110B0.m",[101216104,41258540]);
AGR.TOC("matff","U311G1-f2r370aB0.m",[-130658650,107378127]);
AGR.TOC("matff","U311G1-f2r370bB0.m",[-9111653,98555252]);
AGR.TOC("matff","U311G1-f2r370cB0.m",[-12366454,-40179653]);
AGR.TOC("matff","U311G1-f11r8B0.m",[46418923,50858867]);
AGR.TOC("matff","U311G1-f121r10aB0.m",[-64091698,117096846]);
AGR.TOC("matint","U311G1-Zr111aB0.g",[115143204]);
AGR.TOC("maxes","U311G1-max1W1",[-20720980]);

# U311d2
AGR.GRP("clas","U311","U311d2");
AGR.TOC("perm","U311d2G1-p1332B0.m",[26476675,126722475]);
AGR.TOC("matff","U311d2G1-f2r110B0.m",[99013278,-64869391]);
AGR.TOC("matff","U311d2G1-f11r8B0.m",[-41729110,95592306]);

# U313
AGR.GRP("clas","U313","U313");
AGR.TOC("perm","U313G1-p2198B0.m",[-30735975,124277298]);

# U316
AGR.GRP("clas","U316","U316");
AGR.TOC("perm","U316G1-p4097B0.m",[18404542,-121295681]);

# U33
AGR.GRP("clas","U33","U33");
AGR.TOC("perm","U33G1-p28B0.m",[-55034865,68928245]);
AGR.TOC("perm","U33G1-p36B0.m",[-61978097,99471259]);
AGR.TOC("perm","U33G1-p63aB0.m",[-37936934,30232937]);
AGR.TOC("perm","U33G1-p63bB0.m",[64607497,-91496811]);
AGR.TOC("matff","U33G1-f2r6B0.m",[43979968,-57852349]);
AGR.TOC("matff","U33G1-f2r14B0.m",[-27564002,-65762614]);
AGR.TOC("matff","U33G1-f2r32aB0.m",[-15599009,-66073448]);
AGR.TOC("matff","U33G1-f2r32bB0.m",[30375039,71109397]);
AGR.TOC("matff","U33G1-f3r7B0.m",[34161718,-131142386]);
AGR.TOC("matff","U33G1-f3r27B0.m",[91599748,110775764]);
AGR.TOC("matff","U33G1-f7r6B0.m",[-76570342,-90208870]);
AGR.TOC("matff","U33G1-f7r7aB0.m",[-22429220,71209399]);
AGR.TOC("matff","U33G1-f7r14B0.m",[94291011,-47916281]);
AGR.TOC("matff","U33G1-f7r21aB0.m",[121566276,29184447]);
AGR.TOC("matff","U33G1-f7r26B0.m",[109924252,130651646]);
AGR.TOC("matff","U33G1-f9r3bB0.m",[52521419,-95620519]);
AGR.TOC("matff","U33G1-f9r6bB0.m",[71383686,62175400]);
AGR.TOC("matff","U33G1-f9r15bB0.m",[121556602,40972269]);
AGR.TOC("matff","U33G1-f49r7bB0.m",[11390124,13143680]);
AGR.TOC("matff","U33G1-f49r21bB0.m",[2731335,-42935579]);
AGR.TOC("matff","U33G1-f49r28aB0.m",[-46082945,-65806978]);
AGR.TOC("matint","U33G1-Zr7aB0.g",[92550962]);
AGR.TOC("matint","U33G1-Zr14aB0.g",[-106033864]);
AGR.TOC("matint","U33G1-Zr14bB0.g",[-58543616]);
AGR.TOC("matint","U33G1-Zr21aB0.g",[-102667114]);
AGR.TOC("matint","U33G1-Zr27B0.g",[-108905857]);
AGR.TOC("matint","U33G1-Zr42B0.g",[124882003]);
AGR.TOC("matint","U33G1-Zr56B0.g",[-18347513]);
AGR.TOC("matint","U33G1-Zr64B0.g",[83283541]);
AGR.TOC("matalg","U33G1-Ar6B0.g",[-20268958]);
AGR.TOC("matalg","U33G1-Ar7bB0.g",[-131813230]);
AGR.TOC("matalg","U33G1-Ar7cB0.g",[-53716445]);
AGR.TOC("matalg","U33G1-Ar21bB0.g",[81149260]);
AGR.TOC("matalg","U33G1-Ar21cB0.g",[-27355280]);
AGR.TOC("matalg","U33G1-Ar28aB0.g",[50662159]);
AGR.TOC("matalg","U33G1-Ar28bB0.g",[72291775]);
AGR.TOC("maxes","U33G1-max1W1",[131314018]);
AGR.TOC("maxes","U33G1-max2W1",[-40241296]);
AGR.TOC("maxes","U33G1-max4W1",[124599054]);

# U33d2
AGR.GRP("clas","U33","U33d2");
AGR.TOC("perm","U33d2G1-p63bB0.m",[9178498,132963313]);
AGR.TOC("matff","U33d2G1-f2r6B0.m",[-60926122,-82690472]);
AGR.TOC("matff","U33d2G1-f2r14B0.m",[64470523,22539985]);
AGR.TOC("matff","U33d2G1-f2r64B0.m",[77046502,-89597728]);
AGR.TOC("matff","U33d2G1-f3r6B0.m",[-3081183,93673730]);
AGR.TOC("matff","U33d2G1-f3r7B0.m",[37685085,71166098]);
AGR.TOC("matff","U33d2G1-f3r12B0.m",[-86930532,-69681254]);
AGR.TOC("matff","U33d2G1-f3r27B0.m",[55274905,101901216]);
AGR.TOC("matff","U33d2G1-f3r30B0.m",[122666219,125434467]);
AGR.TOC("maxes","U33d2G1-max1W1",[-62131944]);

# U34
AGR.GRP("clas","U34","U34");
AGR.TOC("perm","U34G1-p65B0.m",[17360683,-78425434]);
AGR.TOC("perm","U34G1-p208B0.m",[80086357,75227372]);
AGR.TOC("perm","U34G1-p416B0.m",[40674578,-88371304]);
AGR.TOC("perm","U34G1-p1600B0.m",[30233884,-36051796]);
AGR.TOC("matff","U34G1-f2r12B0.m",[-10900053,78847107]);
AGR.TOC("matff","U34G1-f2r16B0.m",[14396154,-41955931]);
AGR.TOC("matff","U34G1-f2r36B0.m",[46976384,-17325910]);
AGR.TOC("matff","U34G1-f2r64B0.m",[-118982544,-64223435]);
AGR.TOC("matff","U34G1-f2r96B0.m",[-104284810,-124835199]);
AGR.TOC("matff","U34G1-f3r12B0.m",[132589348,-122397110]);
AGR.TOC("matff","U34G1-f3r52eB0.m",[-97982728,-41106856]);
AGR.TOC("matff","U34G1-f3r64B0.m",[78225616,28949721]);
AGR.TOC("matff","U34G1-f3r75aB0.m",[-80476965,-127074761]);
AGR.TOC("matff","U34G1-f3r75bB0.m",[86181596,3348273]);
AGR.TOC("matff","U34G1-f3r75cB0.m",[11829454,-73864367]);
AGR.TOC("matff","U34G1-f3r75dB0.m",[75538121,28085319]);
AGR.TOC("matff","U34G1-f3r78B0.m",[100243216,-48886087]);
AGR.TOC("matff","U34G1-f3r208B0.m",[42907974,-68495142]);
AGR.TOC("matff","U34G1-f4r6aB0.m",[-85023623,93249437]);
AGR.TOC("matff","U34G1-f4r6bB0.m",[-81819623,-69612063]);
AGR.TOC("matff","U34G1-f4r8aB0.m",[-116176095,-1687181]);
AGR.TOC("matff","U34G1-f4r8bB0.m",[-116176095,25980700]);
AGR.TOC("matff","U34G1-f4r18aB0.m",[123734973,-46092691]);
AGR.TOC("matff","U34G1-f4r18bB0.m",[-93008733,-28725164]);
AGR.TOC("matff","U34G1-f4r48aB0.m",[17578155,11361404]);
AGR.TOC("matff","U34G1-f4r48bB0.m",[76888578,81472606]);
AGR.TOC("matff","U34G1-f5r12B0.m",[-103789801,-34994288]);
AGR.TOC("matff","U34G1-f5r39B0.m",[-123208157,96692618]);
AGR.TOC("matff","U34G1-f5r65B0.m",[-127352607,-60913270]);
AGR.TOC("matff","U34G1-f5r300B0.m",[32081092,72335547]);
AGR.TOC("matff","U34G1-f13r12B0.m",[62408048,-109610137]);
AGR.TOC("matff","U34G1-f13r52eB0.m",[54514785,103012193]);
AGR.TOC("matff","U34G1-f13r63B0.m",[53184444,-72868675]);
AGR.TOC("matff","U34G1-f13r65aB0.m",[-78103605,66500438]);
AGR.TOC("matff","U34G1-f13r78B0.m",[113968884,-115040216]);
AGR.TOC("matff","U34G1-f13r208B0.m",[-108736538,67866]);
AGR.TOC("matff","U34G1-f13r260B0.m",[50602510,103112632]);
AGR.TOC("matff","U34G1-f16r3aB0.m",[122874177,-27123872]);
AGR.TOC("matff","U34G1-f16r3bB0.m",[81574912,-27123872]);
AGR.TOC("matff","U34G1-f16r3cB0.m",[-126807937,-27123872]);
AGR.TOC("matff","U34G1-f16r3dB0.m",[-109357799,-27123872]);
AGR.TOC("matff","U34G1-f16r9aB0.m",[-46965852,84366801]);
AGR.TOC("matff","U34G1-f16r9bB0.m",[-18686435,-119537219]);
AGR.TOC("matff","U34G1-f16r9cB0.m",[38986822,69465137]);
AGR.TOC("matff","U34G1-f16r9dB0.m",[77726640,-84914934]);
AGR.TOC("matff","U34G1-f16r24aB0.m",[-119569304,132348686]);
AGR.TOC("matff","U34G1-f16r24bB0.m",[-100531866,-8097523]);
AGR.TOC("matff","U34G1-f16r24cB0.m",[4021513,219792]);
AGR.TOC("matff","U34G1-f16r24dB0.m",[-40412631,13980730]);
AGR.TOC("matff","U34G1-f25r150aB0.m",[-99531352,-98030002]);
AGR.TOC("matff","U34G1-f25r150bB0.m",[69937018,21914643]);
AGR.TOC("matint","U34G1-Zr64B0.g",[-49267710]);
AGR.TOC("matint","U34G1-Zr65aB0.g",[-57596787]);
AGR.TOC("matint","U34G1-Zr260B0.g",[-72588755]);
AGR.TOC("matint","U34G1-Zr300B0.g",[87311619]);
AGR.TOC("matalg","U34G1-Ar12B0.g",[55185181]);
AGR.TOC("matalg","U34G1-Ar13aB0.g",[117438729]);
AGR.TOC("matalg","U34G1-Ar13bB0.g",[58046395]);
AGR.TOC("matalg","U34G1-Ar13cB0.g",[16609006]);
AGR.TOC("matalg","U34G1-Ar13dB0.g",[67909373]);
AGR.TOC("matalg","U34G1-Ar52aB0.g",[-104934326]);
AGR.TOC("matalg","U34G1-Ar52bB0.g",[24197759]);
AGR.TOC("matalg","U34G1-Ar52cB0.g",[-82220219]);
AGR.TOC("matalg","U34G1-Ar52dB0.g",[-116015156]);
AGR.TOC("maxes","U34G1-max1W1",[53933446]);
AGR.TOC("maxes","U34G1-max2W1",[96452593]);
AGR.TOC("maxes","U34G1-max3W1",[-95177580]);
AGR.TOC("maxes","U34G1-max4W1",[60732284]);
AGR.TOC("out","U34G1-a4W1",[-70979454]);
AGR.TOC("pres","U34G1-P1",[75167543]);

# U34d2
AGR.GRP("clas","U34","U34d2");
AGR.TOC("perm","U34d2G1-p65B0.m",[-70734908,-37630935]);
AGR.TOC("perm","U34d2G1-p208B0.m",[83117313,20247513]);
AGR.TOC("perm","U34d2G1-p416B0.m",[1886698,126129251]);
AGR.TOC("perm","U34d2G1-p1600B0.m",[-104360745,-53360206]);
AGR.TOC("maxes","U34d2G1-max1W1",[-120957511]);
AGR.TOC("maxes","U34d2G1-max2W1",[-23763886]);
AGR.TOC("maxes","U34d2G1-max3W1",[-91366119]);
AGR.TOC("maxes","U34d2G1-max4W1",[79541912]);
AGR.TOC("maxes","U34d2G1-max5W1",[125232883]);
AGR.TOC("pres","U34d2G1-P1",[132977188]);

# U34d4
AGR.GRP("clas","U34","U34d4");
AGR.TOC("perm","U34d4G1-p65B0.m",[51089587,-21751821]);
AGR.TOC("perm","U34d4G1-p208B0.m",[117524311,84671893]);
AGR.TOC("perm","U34d4G1-p416B0.m",[123189927,-3060560]);
AGR.TOC("perm","U34d4G1-p1600B0.m",[101360521,-121654012]);
AGR.TOC("matff","U34d4G1-f2r12B0.m",[-35230972,-5909819]);
AGR.TOC("matff","U34d4G1-f2r16B0.m",[-99589815,16092554]);
AGR.TOC("matff","U34d4G1-f2r36B0.m",[-115096760,116994797]);
AGR.TOC("matff","U34d4G1-f2r64B0.m",[81737749,110839647]);
AGR.TOC("matff","U34d4G1-f2r96B0.m",[111876370,14679376]);
AGR.TOC("matff","U34d4G1-f3r24aB0.m",[-71815523,74229437]);
AGR.TOC("matff","U34d4G1-f3r52B0.m",[-125141463,-64454306]);
AGR.TOC("matff","U34d4G1-f3r64aB0.m",[-27767191,3232557]);
AGR.TOC("matff","U34d4G1-f3r78aB0.m",[-51157972,-22461437]);
AGR.TOC("matff","U34d4G1-f3r208B0.m",[70447454,58683363]);
AGR.TOC("matff","U34d4G1-f3r300B0.m",[44269910,-18762582]);
AGR.TOC("matff","U34d4G1-f5r12aB0.m",[-20838787,25813836]);
AGR.TOC("matff","U34d4G1-f5r39aB0.m",[-132884508,-90704902]);
AGR.TOC("matff","U34d4G1-f5r65aB0.m",[-7273387,-110405782]);
AGR.TOC("matff","U34d4G1-f5r300B0.m",[-91650518,81153656]);
AGR.TOC("matff","U34d4G1-f9r12aB0.m",[-62172830,-103676483]);
AGR.TOC("matff","U34d4G1-f13r12aB0.m",[-49033489,-113664744]);
AGR.TOC("matff","U34d4G1-f13r52B0.m",[32269842,20947821]);
AGR.TOC("matff","U34d4G1-f13r63aB0.m",[39589624,93730429]);
AGR.TOC("matff","U34d4G1-f13r65aB0.m",[32323730,-34684119]);
AGR.TOC("matff","U34d4G1-f13r78aB0.m",[7163539,-77413724]);
AGR.TOC("matff","U34d4G1-f13r208B0.m",[41810714,-58248165]);
AGR.TOC("matff","U34d4G1-f13r260B0.m",[115061945,-79350074]);
AGR.TOC("maxes","U34d4G1-max1W1",[-84053764]);
AGR.TOC("maxes","U34d4G1-max2W1",[58465529]);
AGR.TOC("maxes","U34d4G1-max3W1",[-104565319]);
AGR.TOC("maxes","U34d4G1-max4W1",[93887266]);
AGR.TOC("maxes","U34d4G1-max5W1",[58892799]);
AGR.TOC("pres","U34d4G1-P1",[91031702]);

# U35
AGR.GRP("clas","U35","U35");
AGR.TOC("perm","U35G1-p50B0.m",[79377838,90517095]);
AGR.TOC("matint","U35G1-Zr21B0.g",[2647315]);
AGR.TOC("matint","U35G1-Zr28aB0.g",[79144312]);
AGR.TOC("matint","U35G1-Zr28bB0.g",[-127954516]);
AGR.TOC("matint","U35G1-Zr28cB0.g",[-39999797]);
AGR.TOC("matint","U35G1-Zr84B0.g",[-8847763]);
AGR.TOC("matint","U35G1-Zr105B0.g",[-102955911]);
AGR.TOC("matint","U35G1-Zr125B0.g",[-6373310]);
AGR.TOC("matint","U35G1-Zr126aB0.g",[35920565]);
AGR.TOC("matint","U35G1-Zr252B0.g",[83372172]);
AGR.TOC("matint","U35G1-Zr288B0.g",[87573476]);
AGR.TOC("pres","U35G1-P1",[33059216]);

# U35d2
AGR.GRP("clas","U35","U35d2");
AGR.TOC("perm","U35d2G1-p50B0.m",[1867987,597831]);
AGR.TOC("perm","U35d2G1-p126B0.m",[57933489,-90868789]);
AGR.TOC("perm","U35d2G1-p175B0.m",[-30143206,2795820]);
AGR.TOC("perm","U35d2G1-p525B0.m",[52287825,117985980]);
AGR.TOC("perm","U35d2G1-p750B0.m",[-61520747,-22238562]);
AGR.TOC("matff","U35d2G1-f2r20B0.m",[-51431499,91228414]);
AGR.TOC("matff","U35d2G1-f2r28B0.m",[-122141611,93684727]);
AGR.TOC("matff","U35d2G1-f2r56B0.m",[-86578170,-2680064]);
AGR.TOC("matff","U35d2G1-f2r104B0.m",[114461795,-73415614]);
AGR.TOC("matff","U35d2G1-f2r288B0.m",[59152440,42208940]);
AGR.TOC("matff","U35d2G1-f3r20aB0.m",[-62988035,19241242]);
AGR.TOC("matff","U35d2G1-f3r21aB0.m",[-15314504,-74114415]);
AGR.TOC("matff","U35d2G1-f3r28aB0.m",[96837566,94831662]);
AGR.TOC("matff","U35d2G1-f3r56B0.m",[33744891,-36563831]);
AGR.TOC("matff","U35d2G1-f3r84aB0.m",[-56302550,-113576911]);
AGR.TOC("matff","U35d2G1-f3r126aB0.m",[-965303,-96109392]);
AGR.TOC("matff","U35d2G1-f3r252B0.m",[-133280960,121913998]);
AGR.TOC("matff","U35d2G1-f3r288B0.m",[47530646,-33166197]);
AGR.TOC("matff","U35d2G1-f5r8aB0.m",[-25753737,-36465240]);
AGR.TOC("matff","U35d2G1-f5r19aB0.m",[95135359,-5952651]);
AGR.TOC("matff","U35d2G1-f5r20B0.m",[-9118427,76229517]);
AGR.TOC("matff","U35d2G1-f5r63aB0.m",[46850613,133206102]);
AGR.TOC("matff","U35d2G1-f5r70B0.m",[119713154,-92650635]);
AGR.TOC("matff","U35d2G1-f5r125aB0.m",[-3874360,-11879661]);
AGR.TOC("matff","U35d2G1-f7r20aB0.m",[25578130,49668197]);
AGR.TOC("matff","U35d2G1-f7r21aB0.m",[30911428,-51107732]);
AGR.TOC("matff","U35d2G1-f7r28aB0.m",[121141020,-27438654]);
AGR.TOC("matff","U35d2G1-f7r56B0.m",[-65748988,108569363]);
AGR.TOC("matff","U35d2G1-f7r84aB0.m",[-128249178,-55277512]);
AGR.TOC("matff","U35d2G1-f7r105aB0.m",[-9389598,115008169]);
AGR.TOC("matff","U35d2G1-f7r124aB0.m",[-72369292,-84501320]);
AGR.TOC("matff","U35d2G1-f7r126aB0.m",[43195759,54173438]);
AGR.TOC("matff","U35d2G1-f7r252B0.m",[108946009,113476800]);
AGR.TOC("maxes","U35d2G1-max2W1",[-103678865]);
AGR.TOC("maxes","U35d2G1-max2W2",[-10329946]);
AGR.TOC("maxes","U35d2G1-max3W1",[20496299]);
AGR.TOC("maxes","U35d2G1-max4W1",[-120526082]);
AGR.TOC("maxes","U35d2G1-max5W1",[96452593]);
AGR.TOC("maxes","U35d2G1-max6W1",[42882023]);
AGR.TOC("pres","U35d2G1-P1",[100875407]);

# U37
AGR.GRP("clas","U37","U37");
AGR.TOC("perm","U37G1-p344B0.m",[31043946,-47100693]);
AGR.TOC("perm","U37G1-p688B0.m",[-127237955,72593137]);
AGR.TOC("perm","U37G1-p1032B0.m",[-73970263,-89133614]);
AGR.TOC("perm","U37G1-p1376B0.m",[124823241,73198391]);
AGR.TOC("perm","U37G1-p2064B0.m",[-76288734,1970699]);
AGR.TOC("perm","U37G1-p2107B0.m",[83952628,103638671]);
AGR.TOC("perm","U37G1-p14749B0.m",[-56081576,-114148754]);
AGR.TOC("perm","U37G1-p16856B0.m",[43093642,39183080]);
AGR.TOC("perm","U37G1-p43904B0.m",[-64386534,119104327]);
AGR.TOC("matff","U37G1-f2r42B0.m",[-55818718,638323]);
AGR.TOC("matff","U37G1-f2r258B0.m",[80235784,-27537996]);
AGR.TOC("matff","U37G1-f2r344B0.m",[-62120321,110461212]);
AGR.TOC("matff","U37G1-f3r42B0.m",[87877314,-117514730]);
AGR.TOC("matff","U37G1-f3r43aB0.m",[-87211028,20612456]);
AGR.TOC("matff","U37G1-f7r6cB0.m",[-82725300,91503278]);
AGR.TOC("matff","U37G1-f7r8B0.m",[8670882,-42599195]);
AGR.TOC("matff","U37G1-f7r12B0.m",[112552939,66100615]);
AGR.TOC("matff","U37G1-f7r20B0.m",[-37672248,-3974413]);
AGR.TOC("matff","U37G1-f7r27B0.m",[80204890,2243363]);
AGR.TOC("matff","U37G1-f7r30aB0.m",[-111337443,106525141]);
AGR.TOC("matff","U37G1-f7r30bB0.m",[-12708814,53781897]);
AGR.TOC("matff","U37G1-f7r37B0.m",[-93467555,-92816406]);
AGR.TOC("matff","U37G1-f7r42cB0.m",[-83217450,117281295]);
AGR.TOC("matff","U37G1-f7r48B0.m",[-87749695,48539204]);
AGR.TOC("matff","U37G1-f43r42B0.m",[-32288733,-88899808]);
AGR.TOC("matff","U37G1-f43r43aB0.m",[-36187826,130510881]);
AGR.TOC("matint","U37G1-Zr43aB0.g",[101009663]);
AGR.TOC("maxes","U37G1-max1W1",[-97795468]);
AGR.TOC("maxes","U37G1-max2W1",[-56630200]);
AGR.TOC("maxes","U37G1-max3W1",[-2253449]);
AGR.TOC("maxes","U37G1-max4W1",[-84578960]);
AGR.TOC("maxes","U37G1-max5W1",[49417287]);
AGR.TOC("out","U37G1-aW1",[8247317]);
AGR.TOC("pres","U37G1-P1",[28359484]);

# 3U38
AGR.GRP("clas","U38","3U38");
AGR.TOC("perm","3U38G1-p4617B0.m",[104686114,-82412374]);
AGR.TOC("perm","3U38G1-p32832B0.m",[-70568696,48614352]);
AGR.TOC("matff","3U38G1-f64r3aB0.m",[-127003918,115807546]);

# U38
AGR.GRP("clas","U38","U38");
AGR.TOC("perm","U38G1-p513B0.m",[-79915265,-97999790]);
AGR.TOC("perm","U38G1-p3648B0.m",[-132855599,94913045]);
AGR.TOC("matff","U38G1-f3r56B0.m",[60901416,80285885]);
AGR.TOC("matint","U38G1-Zr114B0.g",[70366208]);
AGR.TOC("matint","U38G1-Zr133aB0.g",[67465534]);
AGR.TOC("matint","U38G1-Zr133bB0.g",[85793258]);
AGR.TOC("matint","U38G1-Zr133cB0.g",[131204949]);
AGR.TOC("pres","U38G1-P1",[114437562]);

# U38E9
AGR.GRP("clas","U38","U38E9");
AGR.TOC("perm","U38E9G1-p513B0.m",[-51718153,-7172068]);
AGR.TOC("perm","U38E9G1-p3648B0.m",[108918084,96674272]);

# U38S3
AGR.GRP("clas","U38","U38S3");
AGR.TOC("perm","U38S3G1-p513B0.m",[120040864,-107603928]);
AGR.TOC("perm","U38S3G1-p3648B0.m",[129298163,-32640650]);

# U38S3x3
AGR.GRP("clas","U38","U38S3x3");
AGR.TOC("perm","U38S3x3G1-p513B0.m",[-7604460,-27922153]);
AGR.TOC("perm","U38S3x3G1-p3648B0.m",[14100675,72779990]);

# U38d2
AGR.GRP("clas","U38","U38d2");
AGR.TOC("perm","U38d2G1-p513B0.m",[-12428198,-114715963]);
AGR.TOC("perm","U38d2G1-p3648B0.m",[-102954589,7496962]);

# U38d3a
AGR.GRP("clas","U38","U38d3a");
AGR.TOC("perm","U38d3aG1-p513B0.m",[-17023673,-55556744]);
AGR.TOC("perm","U38d3aG1-p3648B0.m",[-26653670,27700646]);

# U38d3b
AGR.GRP("clas","U38","U38d3b");
AGR.TOC("perm","U38d3bG1-p513B0.m",[-64368159,-37104193]);
AGR.TOC("perm","U38d3bG1-p3648B0.m",[46031347,66020914]);

# U38d3c
AGR.GRP("clas","U38","U38d3c");
AGR.TOC("perm","U38d3cG1-p513B0.m",[66125187,78421743]);
AGR.TOC("perm","U38d3cG1-p3648B0.m",[81885800,-100513959]);

# U38d6
AGR.GRP("clas","U38","U38d6");
AGR.TOC("perm","U38d6G1-p513B0.m",[-46074225,-23985724]);
AGR.TOC("perm","U38d6G1-p3648B0.m",[-67800605,10871735]);
AGR.TOC("matff","U38d6G1-f2r24B0.m",[-43169189,106439536]);
AGR.TOC("matff","U38d6G1-f2r54aB0.m",[-99197856,-22696828]);
AGR.TOC("matff","U38d6G1-f2r54bB0.m",[-9921731,109048484]);
AGR.TOC("matff","U38d6G1-f2r192B0.m",[116361037,-84768179]);
AGR.TOC("matff","U38d6G1-f2r432B0.m",[-126811112,-101025286]);
AGR.TOC("matff","U38d6G1-f2r512B0.m",[21383515,128345998]);
AGR.TOC("matff","U38d6G1-f3r56aB0.m",[118935035,111312033]);
AGR.TOC("matff","U38d6G1-f3r133aB0.m",[32879324,48179807]);
AGR.TOC("matff","U38d6G1-f3r266B0.m",[25864402,-106835609]);

# U39
AGR.GRP("clas","U39","U39");
AGR.TOC("perm","U39G1-p730B0.m",[-6720510,103605478]);
AGR.TOC("matint","U39G1-Zr73aB0.g",[116063303]);

# 2U42
AGR.GRP("clas","U42","2U42");
AGR.TOC("perm","2U42G1-p80B0.m",[-39324070,104832028]);
AGR.TOC("perm","2U42G1-p240B0.m",[-112092215,107794298]);
AGR.TOC("matff","2U42G1-f3r4B0.m",[-44010817,48225622]);
AGR.TOC("matff","2U42G1-f3r16B0.m",[30238368,-84270813]);
AGR.TOC("matff","2U42G1-f3r40B0.m",[114570034,68590057]);
AGR.TOC("matint","2U42G1-Zr8B0.g",[116145303]);
AGR.TOC("matalg","2U42G1-Ar4aB0.g",[128648158]);
AGR.TOC("matalg","2U42G1-Ar4bB0.g",[-14476162]);
AGR.TOC("matalg","2U42G1-Ar20aB0.g",[-45988034]);
AGR.TOC("matalg","2U42G1-Ar20bB0.g",[62493463]);
AGR.TOC("matalg","2U42G1-Ar20cB0.g",[87714701]);
AGR.TOC("matalg","2U42G1-Ar36aB0.g",[16848127]);
AGR.TOC("matalg","2U42G1-Ar36bB0.g",[-17484990]);
AGR.TOC("matalg","2U42G1-Ar60bB0.g",[87834552]);

# 2U42d2
AGR.GRP("clas","U42","2U42d2");
AGR.TOC("perm","2U42d2G1-p240B0.m",[-56416490,121403924]);
AGR.TOC("matff","2U42d2G1-f3r4B0.m",[12103382,-127646183]);

# U42
AGR.GRP("clas","U42","U42");
AGR.TOC("perm","U42G1-p27B0.m",[58456782,129640804]);
AGR.TOC("perm","U42G1-p36B0.m",[19673844,-123531209]);
AGR.TOC("perm","U42G1-p40aB0.m",[308248,-7687680]);
AGR.TOC("perm","U42G1-p40bB0.m",[15659949,-23378134]);
AGR.TOC("perm","U42G1-p45B0.m",[-75817052,-31383110]);
AGR.TOC("matff","U42G1-f3r5B0.m",[56126559,96526580]);
AGR.TOC("matff","U42G1-f3r10B0.m",[-75248600,-93817985]);
AGR.TOC("matff","U42G1-f3r14B0.m",[-38066968,-37259744]);
AGR.TOC("matff","U42G1-f3r25B0.m",[3033636,118025163]);
AGR.TOC("matff","U42G1-f3r81B0.m",[36994169,6807225]);
AGR.TOC("matff","U42G1-f4r4aB0.m",[-64634504,-79998674]);
AGR.TOC("matff","U42G1-f5r6B0.m",[-57231786,-115938955]);
AGR.TOC("matff","U42G1-f25r5aB0.m",[-118167804,38155024]);
AGR.TOC("matff","U42G1-f25r10bB0.m",[29324164,106311246]);
AGR.TOC("matint","U42G1-Zr6B0.g",[31490574]);
AGR.TOC("matint","U42G1-Zr15aB0.g",[103762178]);
AGR.TOC("matint","U42G1-Zr15bB0.g",[9414185]);
AGR.TOC("matint","U42G1-Zr20B0.g",[-63236352]);
AGR.TOC("matint","U42G1-Zr24B0.g",[-74726964]);
AGR.TOC("matint","U42G1-Zr30aB0.g",[-118104298]);
AGR.TOC("matint","U42G1-Zr60B0.g",[124718455]);
AGR.TOC("matint","U42G1-Zr64B0.g",[-102877132]);
AGR.TOC("matint","U42G1-Zr80B0.g",[-70317204]);
AGR.TOC("matint","U42G1-Zr81B0.g",[38380259]);
AGR.TOC("matalg","U42G1-Ar5aB0.g",[57904430]);
AGR.TOC("matalg","U42G1-Ar5bB0.g",[56439648]);
AGR.TOC("matalg","U42G1-Ar10B0.g",[-48475808]);
AGR.TOC("matalg","U42G1-Ar10aB0.g",[-33665179]);
AGR.TOC("matalg","U42G1-Ar10bB0.g",[-42222926]);
AGR.TOC("matalg","U42G1-Ar30bB0.g",[-88351826]);
AGR.TOC("matalg","U42G1-Ar30cB0.g",[-96100782]);
AGR.TOC("matalg","U42G1-Ar40aB0.g",[-113995891]);
AGR.TOC("matalg","U42G1-Ar40bB0.g",[53751750]);
AGR.TOC("matalg","U42G1-Ar45aB0.g",[-98981155]);
AGR.TOC("matalg","U42G1-Ar45bB0.g",[47258373]);
AGR.TOC("cyclic","U42G1-cycW1",[-28178722]);
AGR.TOC("cyc2ccl","U42G1cycW1-cclsW1",[-82022088]);
AGR.TOC("check","U42G1-check1",[-87969859]);
AGR.TOC("pres","U42G1-P1",[-132148842]);

# U42d2
AGR.GRP("clas","U42","U42d2");
AGR.TOC("perm","U42d2G1-p27B0.m",[-114100809,181996]);
AGR.TOC("perm","U42d2G1-p36B0.m",[-91912608,88502930]);
AGR.TOC("perm","U42d2G1-p40aB0.m",[111542634,-1687551]);
AGR.TOC("perm","U42d2G1-p40bB0.m",[-17644916,-39248668]);
AGR.TOC("perm","U42d2G1-p45B0.m",[-87067104,-112303585]);
AGR.TOC("matff","U42d2G1-f2r6B0.m",[133436379,-52124901]);
AGR.TOC("matff","U42d2G1-f2r8B0.m",[84946852,9312127]);
AGR.TOC("matff","U42d2G1-f2r14B0.m",[-111373697,-8180035]);
AGR.TOC("matff","U42d2G1-f2r40B0.m",[19725664,-103780895]);
AGR.TOC("matff","U42d2G1-f2r64B0.m",[53719255,-56861084]);
AGR.TOC("matff","U42d2G1-f3r5B0.m",[-19187541,-45518448]);
AGR.TOC("cyclic","U42d2G1-cycW1",[-133495148]);
AGR.TOC("cyc2ccl","U42d2G1cycW1-cclsW1",[78750868]);

# 2U43D8
AGR.GRP("clas","U43","2U43D8");
AGR.TOC("matff","2U43D8G1-f3r6B0.m",[132445977,-90933685]);

# 9U43D8
AGR.GRP("clas","U43","9U43D8");
AGR.TOC("perm","9U43D8G1-p756aB0.m",[-129320174,104731858]);
AGR.TOC("perm","9U43D8G1-p756bB0.m",[128140108,68787497]);
AGR.TOC("perm","9U43D8G1-p972B0.m",[-112946109,-20072829]);

# U43
AGR.GRP("clas","U43","U43");
AGR.TOC("matint","U43G1-Zr21B0.g",[-92150417]);
AGR.TOC("matint","U43G1-Zr35aB0.g",[-93457197]);
AGR.TOC("matint","U43G1-Zr35bB0.g",[-131185618]);
AGR.TOC("matint","U43G1-Zr90B0.g",[85869769]);
AGR.TOC("matint","U43G1-Zr140B0.g",[-90197400]);
AGR.TOC("matint","U43G1-Zr189B0.g",[101640512]);
AGR.TOC("matint","U43G1-Zr210B0.g",[-95686246]);

# U43D8
AGR.GRP("clas","U43","U43D8");
AGR.TOC("perm","U43D8G1-p112B0.m",[52549505,-113190149]);
AGR.TOC("perm","U43D8G1-p252B0.m",[95175289,-24127842]);
AGR.TOC("perm","U43D8G1-p280B0.m",[97473667,-96483440]);
AGR.TOC("perm","U43D8G1-p324B0.m",[97941105,55769944]);
AGR.TOC("perm","U43D8G1-p540B0.m",[-8901183,88748754]);
AGR.TOC("perm","U43D8G1-p1134B0.m",[-2081105,24138224]);
AGR.TOC("perm","U43D8G1-p2835B0.m",[-21040280,117093823]);
AGR.TOC("perm","U43D8G1-p4536B0.m",[110265871,1420758]);
AGR.TOC("perm","U43D8G1-p5184B0.m",[-90710487,24022025]);
AGR.TOC("perm","U43D8G1-p8505B0.m",[77730787,43511748]);
AGR.TOC("perm","U43D8G1-p9072B0.m",[96704231,-108398996]);

# U44
AGR.GRP("clas","U44","U44");
AGR.TOC("perm","U44G1-p325B0.m",[-4568984,73773116]);
AGR.TOC("perm","U44G1-p1040B0.m",[26493434,-35888713]);
AGR.TOC("perm","U44G1-p1105B0.m",[102738037,87270221]);
AGR.TOC("perm","U44G1-p3264B0.m",[31163023,114008471]);
AGR.TOC("matint","U44G1-Zr52B0.g",[-81459854]);
AGR.TOC("matint","U44G1-Zr442B0.g",[-118351305]);
AGR.TOC("find","U44G1-find1",[-82272203]);
AGR.TOC("check","U44G1-check1",[-73579303]);

# U45
AGR.GRP("clas","U45","U45");
AGR.TOC("perm","U45G1-p756B0.m",[-34242500,118724930]);
AGR.TOC("perm","U45G1-p1575B0.m",[99242668,-121336230]);
AGR.TOC("matint","U45G1-Zr105B0.g",[73661285]);

# U52
AGR.GRP("clas","U52","U52");
AGR.TOC("perm","U52G1-p165B0.m",[-50299563,36084085]);
AGR.TOC("perm","U52G1-p176B0.m",[-19765875,-57819741]);
AGR.TOC("perm","U52G1-p297B0.m",[-120967324,-31238974]);
AGR.TOC("perm","U52G1-p1408B0.m",[29397990,64478573]);
AGR.TOC("perm","U52G1-p3520B0.m",[-7059345,-99124557]);
AGR.TOC("perm","U52G1-p20736B0.m",[1158517,-47289782]);
AGR.TOC("matff","U52G1-f2r24B0.m",[-6646933,95181238]);
AGR.TOC("matff","U52G1-f2r74B0.m",[5774261,9017299]);
AGR.TOC("matff","U52G1-f3r10B0.m",[51319165,95596744]);
AGR.TOC("matff","U52G1-f3r44B0.m",[57556832,114394891]);
AGR.TOC("matff","U52G1-f3r55B0.m",[73293070,85776857]);
AGR.TOC("matff","U52G1-f3r100B0.m",[62413950,64452365]);
AGR.TOC("matff","U52G1-f3r110B0.m",[116424182,-110537773]);
AGR.TOC("matff","U52G1-f4r5aB0.m",[45995285,109882313]);
AGR.TOC("matff","U52G1-f4r5bB0.m",[-126049394,109882313]);
AGR.TOC("matff","U52G1-f4r10aB0.m",[120911867,-98434121]);
AGR.TOC("matff","U52G1-f4r10bB0.m",[95858797,-29754316]);
AGR.TOC("matff","U52G1-f5r43B0.m",[109287581,133998303]);
AGR.TOC("matff","U52G1-f5r55aB0.m",[-22699903,43452043]);
AGR.TOC("matff","U52G1-f5r120B0.m",[71232364,-62887381]);
AGR.TOC("matff","U52G1-f5r176B0.m",[105144500,-121086734]);
AGR.TOC("matff","U52G1-f11r44B0.m",[-41592242,-133398667]);
AGR.TOC("matff","U52G1-f11r119B0.m",[-92389899,-74596812]);
AGR.TOC("matff","U52G1-f11r176B0.m",[-80326188,70745456]);
AGR.TOC("matint","U52G1-Zr55B0.g",[-29897748]);
AGR.TOC("matint","U52G1-Zr120B0.g",[-18796342]);
AGR.TOC("matint","U52G1-Zr165B0.g",[-51719883]);
AGR.TOC("matint","U52G1-Zr176B0.g",[-18425186]);
AGR.TOC("matalg","U52G1-Ar66aB0.g",[-49682746]);
AGR.TOC("matalg","U52G1-Ar66bB0.g",[130473718]);
AGR.TOC("maxes","U52G1-max1W1",[119806179]);
AGR.TOC("maxes","U52G1-max2W1",[87667606]);
AGR.TOC("maxes","U52G1-max2W2",[-19990869]);
AGR.TOC("maxes","U52G1-max3W1",[-83076794]);
AGR.TOC("maxes","U52G1-max4W1",[-95177580]);
AGR.TOC("maxes","U52G1-max6W1",[-112979582]);
AGR.TOC("cyclic","U52G1-cycW1",[118088632]);
AGR.TOC("cyc2ccl","U52G1cycW1-cclsW1",[114777033]);
AGR.TOC("out","U52G1-aW1",[-13861810]);
AGR.TOC("out","U52G1-aW2",[11605644]);
AGR.TOC("pres","U52G1-P1",[46614605]);

# U52d2
AGR.GRP("clas","U52","U52d2");
AGR.TOC("perm","U52d2G1-p165B0.m",[-57172460,20622447]);
AGR.TOC("perm","U52d2G1-p176B0.m",[33610714,-17129253]);
AGR.TOC("perm","U52d2G1-p297B0.m",[108956803,74418339]);
AGR.TOC("perm","U52d2G1-p1408B0.m",[28425851,85558444]);
AGR.TOC("perm","U52d2G1-p3520B0.m",[90434701,73097833]);
AGR.TOC("perm","U52d2G1-p20736B0.m",[22897081,-85641987]);
AGR.TOC("matff","U52d2G1-f2r10B0.m",[18378846,132190822]);
AGR.TOC("matff","U52d2G1-f2r20B0.m",[-21669052,-23087583]);
AGR.TOC("matff","U52d2G1-f2r24B0.m",[101180288,-62246288]);
AGR.TOC("matff","U52d2G1-f2r74B0.m",[85329492,-115838053]);
AGR.TOC("matff","U52d2G1-f2r80aB0.m",[-74360706,39943991]);
AGR.TOC("matff","U52d2G1-f2r80bB0.m",[-1356498,-96956770]);
AGR.TOC("matff","U52d2G1-f2r320B0.m",[-3086314,-108864461]);
AGR.TOC("matff","U52d2G1-f2r560B0.m",[97547576,85138825]);
AGR.TOC("matff","U52d2G1-f2r1024B0.m",[-86621839,-121614257]);
AGR.TOC("matff","U52d2G1-f3r10aB0.m",[-1510800,24690676]);
AGR.TOC("maxes","U52d2G1-max1W1",[-60089510]);
AGR.TOC("maxes","U52d2G1-max1W2",[-108620177]);
AGR.TOC("maxes","U52d2G1-max2W1",[-51320160]);
AGR.TOC("maxes","U52d2G1-max3W1",[1858877]);
AGR.TOC("maxes","U52d2G1-max4W1",[76528039]);
AGR.TOC("maxes","U52d2G1-max5W1",[29377135]);
AGR.TOC("maxes","U52d2G1-max7W1",[66340331]);
AGR.TOC("cyclic","U52d2G1-cycW1",[67412]);
AGR.TOC("cyc2ccl","U52d2G1cycW1-cclsW1",[54543807]);
AGR.TOC("switch","U52d2G2-G1W1",[27934901]);
AGR.TOC("pres","U52d2G1-P1",[40350727]);

# U53
AGR.GRP("clas","U53","U53");
AGR.TOC("matff","U53G1-f3r10cB0.m",[-71294271,53460609]);
AGR.TOC("matff","U53G1-f3r20B0.m",[-76446202,79411588]);
AGR.TOC("matff","U53G1-f3r24B0.m",[-1304893,68462119]);
AGR.TOC("matff","U53G1-f3r30cB0.m",[35003819,112652284]);
AGR.TOC("matff","U53G1-f3r51B0.m",[-21579018,61524488]);
AGR.TOC("matff","U53G1-f9r5aB0.m",[-69792451,-20114666]);
AGR.TOC("matff","U53G1-f9r5bB0.m",[-63271252,-20114666]);
AGR.TOC("matff","U53G1-f9r10aB0.m",[133158952,58876621]);
AGR.TOC("matff","U53G1-f9r10bB0.m",[-7853167,58876621]);
AGR.TOC("matff","U53G1-f9r15aB0.m",[77460563,79938136]);
AGR.TOC("matff","U53G1-f9r15bB0.m",[33945483,79938136]);
AGR.TOC("matff","U53G1-f9r30aB0.m",[-98129367,34398421]);
AGR.TOC("matff","U53G1-f9r30bB0.m",[28155437,-125271146]);
AGR.TOC("maxes","U53G1-max2W1",[-94856361]);
AGR.TOC("out","U53G1-a2W1",[-58177742]);

# U54
AGR.GRP("clas","U54","U54");
AGR.TOC("perm","U54G1-p17425B0.m",[-36397966,129390617]);
AGR.TOC("perm","U54G1-p52480B0.m",[-77574392,72052412]);

# 12U62
AGR.GRP("clas","U62","12U62");
AGR.TOC("perm","12U62G1-p4704B0.m",[-101774785,-95425735]);
AGR.TOC("perm","12U62G1-p8064B0.m",[86938306,-50833643]);
AGR.TOC("matff","12U62G1-f4r27aB0.m",[10613592,50813522]);

# 2U62
AGR.GRP("clas","U62","2U62");
AGR.TOC("perm","2U62G1-p1344B0.m",[-96746660,-8098938]);
AGR.TOC("perm","2U62G1-p2816aB0.m",[-9919004,73998730]);
AGR.TOC("perm","2U62G1-p2816bB0.m",[-65197888,-2928696]);
AGR.TOC("perm","2U62G1-p5632B0.m",[95706354,53705238]);
AGR.TOC("perm","2U62G1-p12672aB0.m",[-19489142,-92387753]);
AGR.TOC("perm","2U62G1-p12672bB0.m",[64419162,17018190]);
AGR.TOC("perm","2U62G1-p12672cB0.m",[-117738472,100063194]);
AGR.TOC("perm","2U62G1-p41472B0.m",[44143153,-113061034]);
AGR.TOC("matff","2U62G1-f3r56B0.m",[80171047,119446349]);
AGR.TOC("matff","2U62G1-f3r120B0.m",[-70082088,46151118]);
AGR.TOC("matff","2U62G1-f3r560B0.m",[-40708738,89515918]);
AGR.TOC("matff","2U62G1-f5r56B0.m",[-14793534,-37421698]);
AGR.TOC("matff","2U62G1-f5r176B0.m",[-114775302,-93260331]);
AGR.TOC("matff","2U62G1-f5r616B0.m",[-21861757,102388853]);
AGR.TOC("matff","2U62G1-f7r56B0.m",[-64594542,128023405]);
AGR.TOC("matff","2U62G1-f7r176B0.m",[-88318705,-13645495]);
AGR.TOC("matff","2U62G1-f7r616B0.m",[125102474,104459903]);
AGR.TOC("matff","2U62G1-f11r56B0.m",[27908730,-27439099]);
AGR.TOC("matff","2U62G1-f11r176B0.m",[104896756,108616862]);
AGR.TOC("matff","2U62G1-f11r616B0.m",[116387240,49510959]);

# 3U62
AGR.GRP("clas","U62","3U62");
AGR.TOC("perm","3U62G1-p2016B0.m",[-83499844,-94106975]);
AGR.TOC("perm","3U62G1-p2079B0.m",[-15617918,-121099217]);
AGR.TOC("perm","3U62G1-p18711B0.m",[85159923,-15080646]);
AGR.TOC("perm","3U62G1-p19008aB0.m",[-8352431,-6985881]);
AGR.TOC("perm","3U62G1-p19008bB0.m",[-84404157,-104255419]);
AGR.TOC("perm","3U62G1-p19008cB0.m",[-36518996,-52242740]);
AGR.TOC("matff","3U62G1-f4r6aB0.m",[98156764,23845688]);
AGR.TOC("matff","3U62G1-f4r15aB0.m",[15785005,-119828598]);
AGR.TOC("matff","3U62G1-f4r84aB0.m",[102028100,35105847]);
AGR.TOC("matff","3U62G1-f4r90aB0.m",[-95435698,-133163104]);
AGR.TOC("matff","3U62G1-f4r204aB0.m",[127497171,-12364456]);
AGR.TOC("matff","3U62G1-f4r384aB0.m",[119710625,-25413606]);
AGR.TOC("matff","3U62G1-f4r720aB0.m",[1216663,-109097078]);
AGR.TOC("matff","3U62G1-f4r924aB0.m",[-127560878,-32752002]);
AGR.TOC("matff","3U62G1-f7r21aB0.m",[-72638662,80390354]);
AGR.TOC("matff","3U62G1-f7r210aB0.m",[37197289,87961912]);
AGR.TOC("matff","3U62G1-f7r231aB0.m",[29301549,122118319]);
AGR.TOC("matff","3U62G1-f7r462aB0.m",[89063052,17828650]);
AGR.TOC("matff","3U62G1-f25r21aB0.m",[-22125326,90478363]);
AGR.TOC("matff","3U62G1-f25r210aB0.m",[131289013,-130678392]);
AGR.TOC("matff","3U62G1-f25r231aB0.m",[47200870,92356985]);
AGR.TOC("matff","3U62G1-f25r462aB0.m",[-93859674,-71746983]);
AGR.TOC("matff","3U62G1-f121r21aB0.m",[108763121,21124389]);
AGR.TOC("matff","3U62G1-f121r210aB0.m",[-83006052,74898468]);
AGR.TOC("matff","3U62G1-f121r231aB0.m",[-21409946,34760549]);
AGR.TOC("matff","3U62G1-f121r462aB0.m",[113570485,-34512749]);

# 4U62
AGR.GRP("clas","U62","4U62");
AGR.TOC("perm","4U62G1-p2688B0.m",[35396781,38634506]);

# 6U62
AGR.GRP("clas","U62","6U62");
AGR.TOC("perm","6U62G1-p4032B0.m",[119668217,104174186]);
AGR.TOC("perm","6U62G1-p38016aB0.m",[115315823,-103442961]);
AGR.TOC("perm","6U62G1-p38016bB0.m",[28138103,109024887]);
AGR.TOC("perm","6U62G1-p38016cB0.m",[-83291309,-17325938]);
AGR.TOC("matff","6U62G1-f4r27aB0.m",[53592681,50813522]);
AGR.TOC("matff","6U62G1-f7r120aB0.m",[4292338,-72363337]);
AGR.TOC("matff","6U62G1-f25r120aB0.m",[80043281,32783906]);
AGR.TOC("matff","6U62G1-f121r120aB0.m",[-76844812,95611100]);

# U62
AGR.GRP("clas","U62","U62");
AGR.TOC("perm","U62G1-p672B0.m",[41883832,-119342788]);
AGR.TOC("perm","U62G1-p693B0.m",[80011075,132849486]);
AGR.TOC("perm","U62G1-p891B0.m",[-33758355,-102095511]);
AGR.TOC("perm","U62G1-p1408aB0.m",[29635917,-100794787]);
AGR.TOC("perm","U62G1-p1408bB0.m",[-124057494,18833616]);
AGR.TOC("perm","U62G1-p1408cB0.m",[98628886,-49782471]);
AGR.TOC("perm","U62G1-p2816aB0.m",[29758525,110670709]);
AGR.TOC("perm","U62G1-p2816bB0.m",[-128527360,-82297667]);
AGR.TOC("perm","U62G1-p2816cB0.m",[-25922293,-50806016]);
AGR.TOC("perm","U62G1-p6237B0.m",[21756798,90148872]);
AGR.TOC("perm","U62G1-p6336aB0.m",[60773858,-2454776]);
AGR.TOC("perm","U62G1-p6336bB0.m",[-67876781,-101214989]);
AGR.TOC("perm","U62G1-p6336cB0.m",[71320140,-7943165]);
AGR.TOC("perm","U62G1-p12474B0.m",[660171,-128953529]);
AGR.TOC("perm","U62G1-p20736aB0.m",[-113743555,-86287740]);
AGR.TOC("perm","U62G1-p20736bB0.m",[4689720,128093826]);
AGR.TOC("perm","U62G1-p20736cB0.m",[-61281304,-38305200]);
AGR.TOC("perm","U62G1-p59136B0.m",[-34349507,111415438]);
AGR.TOC("matff","U62G1-f2r20B0.m",[78929209,67521214]);
AGR.TOC("matff","U62G1-f2r34B0.m",[-40302981,118770259]);
AGR.TOC("matff","U62G1-f2r140B0.m",[42892782,-19795048]);
AGR.TOC("matff","U62G1-f2r154B0.m",[131435381,-103954879]);
AGR.TOC("matff","U62G1-f2r400B0.m",[-85949792,-94085068]);
AGR.TOC("matff","U62G1-f3r21B0.m",[-4669439,-19190277]);
AGR.TOC("matff","U62G1-f3r210B0.m",[100369997,93157187]);
AGR.TOC("matff","U62G1-f3r229B0.m",[49933568,-21740528]);
AGR.TOC("matff","U62G1-f3r364B0.m",[106636200,-134035568]);
AGR.TOC("matff","U62G1-f4r70aB0.m",[35930765,75285548]);
AGR.TOC("matff","U62G1-f4r70bB0.m",[126649385,114789385]);
AGR.TOC("matff","U62G1-f4r896aB0.m",[-95558439,13902304]);
AGR.TOC("matff","U62G1-f5r22B0.m",[-42318656,-51119679]);
AGR.TOC("matff","U62G1-f5r231B0.m",[-35969322,-112008815]);
AGR.TOC("matff","U62G1-f5r252B0.m",[26531882,67559014]);
AGR.TOC("matff","U62G1-f5r440B0.m",[85455555,125018485]);
AGR.TOC("matff","U62G1-f5r616B0.m",[-3067103,-110616148]);
AGR.TOC("matff","U62G1-f7r22B0.m",[-9800171,-117014354]);
AGR.TOC("matff","U62G1-f7r231B0.m",[123139749,-39714473]);
AGR.TOC("matff","U62G1-f7r252B0.m",[49291300,-82033320]);
AGR.TOC("matff","U62G1-f7r439B0.m",[22238893,67944875]);
AGR.TOC("matff","U62G1-f7r616B0.m",[40565128,129478709]);
AGR.TOC("matff","U62G1-f11r22B0.m",[105876888,-46394941]);
AGR.TOC("matff","U62G1-f11r231B0.m",[-121637817,16844877]);
AGR.TOC("matff","U62G1-f11r251B0.m",[-50485223,42023145]);
AGR.TOC("matff","U62G1-f11r440B0.m",[38620526,44520621]);
AGR.TOC("matff","U62G1-f11r616B0.m",[58444823,-65919906]);
AGR.TOC("matint","U62G1-Zr22B0.g",[-132792550]);
AGR.TOC("matint","U62G1-Zr231B0.g",[60313821]);
AGR.TOC("maxes","U62G1-max1W1",[77681157]);
AGR.TOC("maxes","U62G1-max1W2",[21370323]);
AGR.TOC("maxes","U62G1-max2W1",[-41489840]);
AGR.TOC("maxes","U62G1-max3W1",[20129642]);
AGR.TOC("maxes","U62G1-max4W1",[91124264]);
AGR.TOC("maxes","U62G1-max4W2",[-47760827]);
AGR.TOC("maxes","U62G1-max5W1",[-42471960]);
AGR.TOC("maxes","U62G1-max6W1",[44978555]);
AGR.TOC("maxes","U62G1-max7W1",[-119865794]);
AGR.TOC("maxes","U62G1-max8W1",[-63428706]);
AGR.TOC("maxes","U62G1-max8W2",[47859679]);
AGR.TOC("maxes","U62G1-max9W1",[49438861]);
AGR.TOC("maxes","U62G1-max10W1",[-17519713]);
AGR.TOC("maxes","U62G1-max11W1",[24632921]);
AGR.TOC("maxes","U62G1-max11W2",[132654305]);
AGR.TOC("maxes","U62G1-max12W1",[-132834885]);
AGR.TOC("maxes","U62G1-max13W1",[-57911926]);
AGR.TOC("maxes","U62G1-max14W1",[-118829535]);
AGR.TOC("maxes","U62G1-max15W1",[-51744826]);
AGR.TOC("maxes","U62G1-max16W1",[-31621045]);
AGR.TOC("out","U62G1-a2W1",[-25509507]);
AGR.TOC("out","U62G1-a3W1",[101719534]);

# U62S3
AGR.GRP("clas","U62","U62S3");
AGR.TOC("perm","U62S3G1-p693B0.m",[82931017,-51445734]);
AGR.TOC("perm","U62S3G1-p891B0.m",[44994054,66645969]);
AGR.TOC("matff","U62S3G1-f2r20B0.m",[32957911,131281838]);
AGR.TOC("matff","U62S3G1-f2r34B0.m",[-19555964,74226004]);
AGR.TOC("matff","U62S3G1-f2r140a0B0.m",[-26001990,54006778]);
AGR.TOC("matff","U62S3G1-f2r140a1B0.m",[-129943537,44969268]);
AGR.TOC("matff","U62S3G1-f2r140a2B0.m",[-119325519,30594248]);
AGR.TOC("matff","U62S3G1-f2r154B0.m",[-44721626,97175721]);
AGR.TOC("matff","U62S3G1-f2r400B0.m",[-110153808,70135791]);
AGR.TOC("matff","U62S3G1-f3r21aB0.m",[100541190,-70773790]);
AGR.TOC("matff","U62S3G1-f3r210aB0.m",[59581404,-112108450]);
AGR.TOC("matff","U62S3G1-f3r229aB0.m",[-110893949,82946128]);
AGR.TOC("matff","U62S3G1-f3r364aB0.m",[-115141451,-120136105]);
AGR.TOC("matff","U62S3G1-f5r22aB0.m",[127745745,58859989]);
AGR.TOC("matff","U62S3G1-f7r22aB0.m",[-83283114,78672814]);
AGR.TOC("matff","U62S3G1-f11r22aB0.m",[-94587495,14032]);

# U62d2
AGR.GRP("clas","U62","U62d2");
AGR.TOC("perm","U62d2G1-p672B0.m",[-25523369,12654911]);
AGR.TOC("perm","U62d2G1-p693B0.m",[-115660627,-7137007]);
AGR.TOC("perm","U62d2G1-p891B0.m",[129866173,15020256]);
AGR.TOC("perm","U62d2G1-p1408B0.m",[-78375109,3254482]);
AGR.TOC("perm","U62d2G1-p6237B0.m",[59767995,-91383161]);
AGR.TOC("perm","U62d2G1-p6336B0.m",[-21183900,40576140]);
AGR.TOC("perm","U62d2G1-p20736B0.m",[-9581899,25873638]);
AGR.TOC("matff","U62d2G1-f2r20B0.m",[-53547535,85421330]);
AGR.TOC("matff","U62d2G1-f2r34B0.m",[85750725,23928042]);
AGR.TOC("matff","U62d2G1-f2r140B0.m",[36696581,-80935705]);
AGR.TOC("matff","U62d2G1-f2r154B0.m",[121526487,55009857]);
AGR.TOC("matff","U62d2G1-f2r400B0.m",[-111007494,-131218683]);
AGR.TOC("matff","U62d2G1-f3r21aB0.m",[-13517125,63540903]);
AGR.TOC("matff","U62d2G1-f3r210aB0.m",[38097441,-67797225]);
AGR.TOC("matff","U62d2G1-f3r229aB0.m",[89141837,54570259]);
AGR.TOC("matff","U62d2G1-f3r364aB0.m",[-53381445,-12684210]);
AGR.TOC("matff","U62d2G1-f5r22aB0.m",[108599543,71473481]);
AGR.TOC("matff","U62d2G1-f7r22aB0.m",[-31038767,-17393281]);
AGR.TOC("matff","U62d2G1-f11r22aB0.m",[-18994369,16334399]);

# U63
AGR.GRP("clas","U63","U63");
AGR.TOC("perm","U63G1-p22204B0.m",[-129387006,-85296839]);
AGR.TOC("perm","U63G1-p44226B0.m",[-5726477,107460429]);

# U72
AGR.GRP("clas","U72","U72");
AGR.TOC("perm","U72G1-p2709B0.m",[70182082,94994402]);
AGR.TOC("perm","U72G1-p2752B0.m",[-58626643,56927715]);
AGR.TOC("matff","U72G1-f4r7aB0.m",[13572893,38482878]);
AGR.TOC("matff","U72G1-f4r7bB0.m",[100370941,86400664]);
AGR.TOC("maxes","U72G1-max1W1",[22904209]);
AGR.TOC("maxes","U72G1-max2W1",[-126405096]);
AGR.TOC("maxes","U72G1-max7W1",[-13017910]);
AGR.TOC("out","U72G1-a2W1",[-14956717]);
AGR.TOC("pres","U72G1-P1",[130497806]);

# U82
AGR.GRP("clas","U82","U82");
AGR.TOC("perm","U82G1-p10880B0.m",[-125558626,-28447926]);
AGR.TOC("perm","U82G1-p10965B0.m",[97819035,-129611467]);

# E62
AGR.GRP("exc","E62","E62");
AGR.TOC("matff","E62G0-f2r27aB0.m",[-70297767,-96163256]);
AGR.TOC("matff","E62G1-f2r27aB0.m",[-73318547,-70297767]);
AGR.TOC("matff","E62G0-f2r27bB0.m",[-68668655,69131024]);
AGR.TOC("matff","E62G1-f2r27bB0.m",[-42383541,-68668655]);
AGR.TOC("matff","E62G0-f2r78B0.m",[-4960328,48265225]);
AGR.TOC("matff","E62G1-f2r78B0.m",[-25397445,20657147]);
AGR.TOC("switch","E62G0-G1W1",[64513689]);

# 3E64
AGR.GRP("exc","E64","3E64");
AGR.TOC("matff","3E64G0-f4r27B0.m",[-57084589,-124036119]);

# 3E64d2
AGR.GRP("exc","E64","3E64d2");
AGR.TOC("matff","3E64d2G0-f4r54B0.m",[29419197,-64150288]);

# E64
AGR.GRP("exc","E64","E64");
AGR.TOC("matff","E64G0-f4r78B0.m",[-132528501,61287473]);

# E72
AGR.GRP("exc","E72","E72");
AGR.TOC("matff","E72G0-f2r56B0.m",[-10834863,91921389]);
AGR.TOC("matff","E72G0-f2r132B0.m",[26817200,-121290106]);

# E74
AGR.GRP("exc","E74","E74");
AGR.TOC("matff","E74G0-f4r56aB0.m",[22134173,-120967594]);
AGR.TOC("matff","E74G0-f4r132aB0.m",[-81050650,-36328227]);
AGR.TOC("matff","E74G0-f4r248aB0.m",[-97730409,-25650350]);

# E82
AGR.GRP("exc","E82","E82");
AGR.TOC("matff","E82G0-f2r248B0.m",[-49071027,61315514]);
AGR.TOC("matff","E82G1-f2r248B0.m",[96667557,-105591188,110839232,-68636897,-25809603,-71748353,-199247,87987784,50344029]);

# E85
AGR.GRP("exc","E85","E85");
AGR.TOC("matff","E85G0-f5r248B0.m",[-93455430,-64034859]);

# 2F42
AGR.GRP("exc","F42","2F42");
AGR.TOC("perm","2F42G1-p139776B0.m",[-43833682,-50779955]);
AGR.TOC("matff","2F42G1-f3r52B0.m",[-119545741,51871965]);
AGR.TOC("matff","2F42G1-f3r2380B0.m",[-19179090,-6048453]);
AGR.TOC("matff","2F42G1-f5r52B0.m",[7798019,-110626250]);
AGR.TOC("matff","2F42G1-f37r52B0.m",[103071728,-98691494]);
AGR.TOC("matint","2F42G1-Zr52B0.g",[-104964656]);

# 2F42d2
AGR.GRP("exc","F42","2F42d2");
AGR.TOC("matff","2F42d2G1-f25r52B0.m",[-129910373,79093558]);

# 2F42d4i
AGR.GRP("exc","F42","2F42d4i");
AGR.TOC("matff","2F42d4iG1-f5r52B0.m",[-51144607,52466815]);

# F42
AGR.GRP("exc","F42","F42");
AGR.TOC("perm","F42G1-p69888aB0.m",[-69475917,-84190098]);
AGR.TOC("matff","F42G1-f2r26aB0.m",[87092000,-122290764]);
AGR.TOC("maxes","F42G1-max3W1",[88368943]);
AGR.TOC("out","F42G1-aW1",[-12804023]);

# F42d2
AGR.GRP("exc","F42","F42d2");
AGR.TOC("matff","F42d2G1-f2r52B0.m",[-130699985,-57245789]);

# 3G23
AGR.GRP("exc","G23","3G23");
AGR.TOC("perm","3G23G1-p1134B0.m",[-34025902,37530367]);
AGR.TOC("matff","3G23G1-f4r27B0.m",[37994813,131397011]);
AGR.TOC("matff","3G23G1-f7r27B0.m",[-87624442,95048033]);
AGR.TOC("matff","3G23G1-f13r27B0.m",[61117322,-70520800]);

# 3G23d2
AGR.GRP("exc","G23","3G23d2");
AGR.TOC("matff","3G23d2G1-f2r54B0.m",[76280437,92930197]);

# G23
AGR.GRP("exc","G23","G23");
AGR.TOC("matff","G23G1-f2r14B0.m",[86434273,-43037825]);
AGR.TOC("matff","G23G1-f2r78B0.m",[35032665,-63417450]);
AGR.TOC("matff","G23G1-f2r90aB0.m",[69935322,-78029905]);
AGR.TOC("matff","G23G1-f2r90bB0.m",[-23279448,19285845]);
AGR.TOC("matff","G23G1-f2r90cB0.m",[-84439532,14115789]);
AGR.TOC("matff","G23G1-f2r378B0.m",[51818618,71716851]);
AGR.TOC("matff","G23G1-f3r7aB0.m",[-82008745,-123787747]);
AGR.TOC("matff","G23G1-f3r7bB0.m",[37685085,20210123]);
AGR.TOC("matff","G23G1-f3r27aB0.m",[-99882363,-16674426]);
AGR.TOC("matff","G23G1-f3r27bB0.m",[-118117076,92962773]);
AGR.TOC("matff","G23G1-f3r49B0.m",[9924097,56775392]);
AGR.TOC("matff","G23G1-f3r189aB0.m",[-79955435,-95389552]);
AGR.TOC("matff","G23G1-f3r189bB0.m",[71038188,-112373668]);
AGR.TOC("matff","G23G1-f3r729B0.m",[-134099399,25104360]);
AGR.TOC("matff","G23G1-f4r64aB0.m",[83734468,46041958]);
AGR.TOC("matint","G23G1-Zr14B0.g",[-125439079]);
AGR.TOC("matint","G23G1-Zr78B0.g",[-15372865]);
AGR.TOC("matint","G23G1-Zr91aB0.g",[-64622020]);
AGR.TOC("matint","G23G1-Zr91bB0.g",[-22531406]);
AGR.TOC("matint","G23G1-Zr91cB0.g",[18002893]);
AGR.TOC("matint","G23G1-Zr104B0.g",[-28104291]);
AGR.TOC("matint","G23G1-Zr128B0.g",[-42573218]);
AGR.TOC("matint","G23G1-Zr168B0.g",[-23126590]);
AGR.TOC("matint","G23G1-Zr182aB0.g",[-1602808]);
AGR.TOC("matint","G23G1-Zr182bB0.g",[-15191443]);
AGR.TOC("maxes","G23G1-max1W1",[18720622]);
AGR.TOC("maxes","G23G1-max2W1",[-17309167]);
AGR.TOC("maxes","G23G1-max3W1",[-85688773]);
AGR.TOC("maxes","G23G1-max4W1",[-102351042]);
AGR.TOC("maxes","G23G1-max5W1",[-66384110]);
AGR.TOC("maxes","G23G1-max6W1",[-13544917]);
AGR.TOC("maxes","G23G1-max7W1",[38209968]);
AGR.TOC("maxes","G23G1-max8W1",[-64232439]);
AGR.TOC("maxes","G23G1-max9W1",[123477709]);
AGR.TOC("maxes","G23G1-max10W1",[52528300]);
AGR.TOC("cyclic","G23G1-cycW1",[36668268]);
AGR.TOC("cyc2ccl","G23G1cycW1-cclsW1",[-89533622]);
AGR.TOC("out","G23G1-aW1",[22691057]);
AGR.TOC("pres","G23G1-P1",[-94264700]);

# G23d2
AGR.GRP("exc","G23","G23d2");
AGR.TOC("perm","G23d2G1-p756B0.m",[42478542,51190038]);
AGR.TOC("matff","G23d2G1-f2r14B0.m",[109031783,12990791]);
AGR.TOC("matff","G23d2G1-f3r14B0.m",[73912942,80930425]);
AGR.TOC("matff","G23d2G1-f7r14B0.m",[123985256,-80651691]);
AGR.TOC("matff","G23d2G1-f13r14B0.m",[98088004,548769]);
AGR.TOC("matff","G23d2G1-f13r434aB0.m",[74284224,37219817]);
AGR.TOC("matalg","G23d2G1-Ar14B0.g",[117470773]);
AGR.TOC("cyclic","G23d2G1-cycW1",[37643139]);
AGR.TOC("cyc2ccl","G23d2G1cycW1-cclsW1",[65429839]);

# 2G24
AGR.GRP("exc","G24","2G24");
AGR.TOC("matff","2G24G1-f3r12B0.m",[-67944567,-70203068]);
AGR.TOC("matff","2G24G1-f5r12B0.m",[104442327,66070846]);
AGR.TOC("matff","2G24G1-f5r92B0.m",[55965017,73607009]);
AGR.TOC("matff","2G24G1-f7r12B0.m",[125615336,-4580527]);
AGR.TOC("matff","2G24G1-f13r12B0.m",[-28440236,51252205]);
AGR.TOC("matalg","2G24G1-Ar12B0.g",[51673463]);

# 2G24d2
AGR.GRP("exc","G24","2G24d2");
AGR.TOC("matff","2G24d2G1-f7r12B0.m",[-121289401,-94829410]);
AGR.TOC("matff","2G24d2G1-f9r12B0.m",[2580368,-42882399]);
AGR.TOC("matff","2G24d2G1-f25r12B0.m",[-89736189,-64347559]);
AGR.TOC("matff","2G24d2G1-f169r12B0.m",[-77376727,-39618687]);

# 2G24d2i
AGR.GRP("exc","G24","2G24d2i");
AGR.TOC("matff","2G24d2iG1-f3r12B0.m",[-47661060,-125365015]);

# G24
AGR.GRP("exc","G24","G24");
AGR.TOC("perm","G24G1-p416B0.m",[51929690,-126223003]);
AGR.TOC("perm","G24G1-p1365aB0.m",[-115158810,123111142]);
AGR.TOC("perm","G24G1-p1365bB0.m",[-616460,-44852760]);
AGR.TOC("perm","G24G1-p2016B0.m",[-42357015,39146207]);
AGR.TOC("perm","G24G1-p2080B0.m",[-71294971,42600740]);
AGR.TOC("perm","G24G1-p20800B0.m",[40526408,109930642]);
AGR.TOC("matff","G24G1-f2r36B0.m",[-69550858,-88757509]);
AGR.TOC("matff","G24G1-f2r196B0.m",[-36645448,68701707]);
AGR.TOC("matff","G24G1-f3r64B0.m",[-61178871,47389179]);
AGR.TOC("matff","G24G1-f3r78B0.m",[56754631,88353235]);
AGR.TOC("matff","G24G1-f3r286B0.m",[-16456749,82354631]);
AGR.TOC("matff","G24G1-f4r6aB0.m",[-8236036,128010787]);
AGR.TOC("matff","G24G1-f4r6bB0.m",[-112136579,-68650117]);
AGR.TOC("matff","G24G1-f4r14aB0.m",[-118197343,86712798]);
AGR.TOC("matff","G24G1-f4r14bB0.m",[-116763231,71178845]);
AGR.TOC("matff","G24G1-f4r64aB0.m",[-7261211,21213869]);
AGR.TOC("matff","G24G1-f4r64bB0.m",[-17269228,-73693460]);
AGR.TOC("matff","G24G1-f4r84aB0.m",[6140054,-24586477]);
AGR.TOC("matff","G24G1-f4r84bB0.m",[34461358,-26016054]);
AGR.TOC("matff","G24G1-f4r384aB0.m",[-82553044,-122520759]);
AGR.TOC("matff","G24G1-f4r896aB0.m",[95398693,-63990656]);
AGR.TOC("matff","G24G1-f5r65B0.m",[-127754414,76430054]);
AGR.TOC("matff","G24G1-f5r78B0.m",[59900505,126954124]);
AGR.TOC("matff","G24G1-f5r350B0.m",[49463148,69419323]);
AGR.TOC("matff","G24G1-f5r363aB0.m",[75975508,-74691309]);
AGR.TOC("matff","G24G1-f5r650B0.m",[-50931554,98893669]);
AGR.TOC("matff","G24G1-f7r65B0.m",[20281126,107078106]);
AGR.TOC("matff","G24G1-f7r78B0.m",[14130029,-11324105]);
AGR.TOC("matff","G24G1-f13r65B0.m",[95368012,125051968]);
AGR.TOC("matff","G24G1-f13r78B0.m",[29876060,-63293875]);
AGR.TOC("matint","G24G1-Zr65B0.g",[-108898852]);
AGR.TOC("matint","G24G1-Zr78B0.g",[102360278]);
AGR.TOC("matint","G24G1-Zr350B0.g",[61213744]);
AGR.TOC("maxes","G24G1-max1W1",[-32570630]);
AGR.TOC("maxes","G24G1-max2W1",[-67243668]);
AGR.TOC("maxes","G24G1-max3W1",[-120914341]);
AGR.TOC("maxes","G24G1-max4W1",[-110962718]);
AGR.TOC("maxes","G24G1-max5W1",[-111848634]);
AGR.TOC("maxes","G24G1-max6W1",[123150437]);
AGR.TOC("maxes","G24G1-max7W1",[57286674]);
AGR.TOC("maxes","G24G1-max8W1",[-76130921]);
AGR.TOC("cyclic","G24G1-cycW1",[-125358015]);
AGR.TOC("cyc2ccl","G24G1cycW1-cclsW1",[73001604]);
AGR.TOC("out","G24G1-aW1",[-50874917]);

# G24d2
AGR.GRP("exc","G24","G24d2");
AGR.TOC("matff","G24d2G1-f2r12B0.m",[53559400,10770446]);
AGR.TOC("matff","G24d2G1-f2r28B0.m",[125029957,133176954]);
AGR.TOC("matff","G24d2G1-f2r36B0.m",[4814614,-66949677]);
AGR.TOC("matff","G24d2G1-f2r128B0.m",[-115232965,-25353254]);
AGR.TOC("matff","G24d2G1-f2r168B0.m",[-128954098,-65897249]);
AGR.TOC("matff","G24d2G1-f2r196B0.m",[-85543658,-1871408]);
AGR.TOC("matff","G24d2G1-f2r768B0.m",[-96415813,-49469578]);
AGR.TOC("matff","G24d2G1-f3r64B0.m",[-119948435,-17965086]);
AGR.TOC("matff","G24d2G1-f5r65B0.m",[-48774137,-119676318]);
AGR.TOC("matff","G24d2G1-f13r65B0.m",[-18511590,120275590]);
AGR.TOC("maxes","G24d2G1-max1W1",[-121379964]);
AGR.TOC("cyclic","G24d2G1-cycW1",[109593526]);
AGR.TOC("cyc2ccl","G24d2G1cycW1-cclsW1",[15196885]);

# G25
AGR.GRP("exc","G25","G25");
AGR.TOC("perm","G25G1-p3906aB0.m",[-46431010,61004361]);
AGR.TOC("perm","G25G1-p3906bB0.m",[96097769,-18195913]);
AGR.TOC("perm","G25G1-p7750B0.m",[31797774,-26503741]);
AGR.TOC("perm","G25G1-p7875B0.m",[38818423,-40529780]);
AGR.TOC("matff","G25G1-f2r124B0.m",[92148540,79477694]);
AGR.TOC("matff","G25G1-f3r124B0.m",[9277469,-110639435]);
AGR.TOC("matff","G25G1-f3r651B0.m",[-12979976,-77711058]);
AGR.TOC("matff","G25G1-f5r7B0.m",[-87260318,-71210308]);
AGR.TOC("matff","G25G1-f5r14B0.m",[-21734629,-122434885]);
AGR.TOC("matff","G25G1-f5r27B0.m",[129030369,-36682541]);
AGR.TOC("matff","G25G1-f5r64B0.m",[64732108,58156458]);
AGR.TOC("matff","G25G1-f5r77aB0.m",[73899891,-59347764]);
AGR.TOC("matff","G25G1-f5r77bB0.m",[22873994,-70431269]);
AGR.TOC("matff","G25G1-f5r97B0.m",[-112735515,68491092]);
AGR.TOC("matff","G25G1-f5r182B0.m",[-49451491,-111747915]);
AGR.TOC("matff","G25G1-f5r189B0.m",[92584953,-111884055]);
AGR.TOC("matff","G25G1-f5r196B0.m",[133353185,128963607]);
AGR.TOC("matff","G25G1-f5r371B0.m",[-85524619,-89118573]);
AGR.TOC("matff","G25G1-f5r469B0.m",[80896235,37618159]);
AGR.TOC("matff","G25G1-f5r483B0.m",[36818705,-14747997]);
AGR.TOC("matff","G25G1-f5r721B0.m",[83883746,106891019]);
AGR.TOC("matff","G25G1-f5r792B0.m",[6111574,-111486014]);
AGR.TOC("maxes","G25G1-max1W1",[116756554]);
AGR.TOC("maxes","G25G1-max2W1",[-62289962]);
AGR.TOC("maxes","G25G1-max3W1",[120656499]);
AGR.TOC("maxes","G25G1-max4W1",[111454099]);
AGR.TOC("maxes","G25G1-max5W1",[-103005232]);
AGR.TOC("maxes","G25G1-max6W1",[-45312413]);
AGR.TOC("maxes","G25G1-max7W1",[-59368457]);
AGR.TOC("cyc2ccl","G25G1cycW1-cclsW1",[-73931334]);

# R27
AGR.GRP("exc","R27","R27");
AGR.TOC("perm","R27G1-p19684B0.m",[88111870,99184963]);
AGR.TOC("matff","R27G1-f2r702B0.m",[26647838,24903191]);
AGR.TOC("matff","R27G1-f27r7aB0.m",[-131893556,-92458544]);
AGR.TOC("maxes","R27G1-max1W1",[-86545949]);
AGR.TOC("maxes","R27G1-max2W1",[131433428]);
AGR.TOC("maxes","R27G1-max3W1",[-20101048]);
AGR.TOC("maxes","R27G1-max4W1",[-9024597]);
AGR.TOC("maxes","R27G1-max5W1",[111943722]);
AGR.TOC("maxes","R27G1-max6W1",[27654707]);
AGR.TOC("cyclic","R27G1-cycW1",[73942379]);
AGR.TOC("cyc2ccl","R27G1cycW1-cclsW1",[43823151]);
AGR.TOC("out","R27G1-a3W1",[-43269740]);

# R27d3
AGR.GRP("exc","R27","R27d3");
AGR.TOC("perm","R27d3G1-p19684B0.m",[64026943,29236333]);
AGR.TOC("matff","R27d3G1-f2r702B0.m",[-20100123,-116928782]);
AGR.TOC("matff","R27d3G1-f3r21B0.m",[116304889,96169159]);
AGR.TOC("matff","R27d3G1-f4r741B0.m",[-133120577,-27931998]);
AGR.TOC("maxes","R27d3G1-max1W1",[69723780]);
AGR.TOC("maxes","R27d3G1-max2W1",[-101788691]);
AGR.TOC("maxes","R27d3G1-max5W1",[-132658566]);
AGR.TOC("maxes","R27d3G1-max6W1",[48349980]);
AGR.TOC("cyclic","R27d3G1-cycW1",[59432872]);
AGR.TOC("switch","R27d3G2-G1W1",[-63317196]);

# Sz32
AGR.GRP("exc","Sz32","Sz32");
AGR.TOC("perm","Sz32G1-p1025B0.m",[-74943283,-38599391]);
AGR.TOC("perm","Sz32G1-p198400B0.m",[-110250955,-38848881]);
AGR.TOC("matff","Sz32G1-f5r124aB0.m",[-85113157,34261390]);
AGR.TOC("matff","Sz32G1-f32r4aB0.m",[-39583783,77480269]);
AGR.TOC("matff","Sz32G1-f41r124bB0.m",[-21014751,125604766]);
AGR.TOC("maxes","Sz32G1-max1W1",[25385764]);
AGR.TOC("maxes","Sz32G1-max2W1",[8659865]);
AGR.TOC("maxes","Sz32G1-max3W1",[-86222599]);
AGR.TOC("maxes","Sz32G1-max4W1",[-64659392]);
AGR.TOC("cyclic","Sz32G1-cycW1",[119938586]);
AGR.TOC("cyc2ccl","Sz32G1cycW1-cclsW1",[51030262]);

# Sz32d5
AGR.GRP("exc","Sz32","Sz32d5");
AGR.TOC("perm","Sz32d5G1-p1025B0.m",[-17269389,84602614]);
AGR.TOC("matff","Sz32d5G1-f2r20B0.m",[40805757,-50580400]);
AGR.TOC("matff","Sz32d5G1-f5r124B0.m",[-311161,-5295501]);
AGR.TOC("matff","Sz32d5G1-f5r248B0.m",[-9152643,-78092594]);
AGR.TOC("matff","Sz32d5G1-f41r124B0.m",[88762614,98369594]);
AGR.TOC("cyclic","Sz32d5G1-cycW1",[67817474]);

# 2Sz8
AGR.GRP("exc","Sz8","2Sz8");
AGR.TOC("perm","2Sz8G1-p1040B0.m",[33264941,27987108]);
AGR.TOC("matff","2Sz8G1-f2r128B0.m",[92649122,89231077]);
AGR.TOC("matff","2Sz8G1-f5r8B0.m",[124580415,2446579]);
AGR.TOC("matff","2Sz8G1-f7r40B0.m",[-56647718,-17769151]);
AGR.TOC("matff","2Sz8G1-f13r16B0.m",[-89521920,16445770]);
AGR.TOC("matff","2Sz8G1-f13r24B0.m",[35347373,-120126973]);
AGR.TOC("pres","2Sz8G1-P1",[90075528]);

# 4Sz8d3
AGR.GRP("exc","Sz8","4Sz8d3");
AGR.TOC("perm","4Sz8d3G1-p2080B0.m",[-2101264,70462745]);
AGR.TOC("matff","4Sz8d3G1-f7r120B0.m",[-95140584,47871236]);
AGR.TOC("matff","4Sz8d3G1-f13r48B0.m",[41418737,-71622098]);
AGR.TOC("pres","4Sz8d3G1-P1",[-128061809]);

# Sz8
AGR.GRP("exc","Sz8","Sz8");
AGR.TOC("perm","Sz8G1-p65B0.m",[-26581639,38161388]);
AGR.TOC("perm","Sz8G1-p520B0.m",[-56882349,-114530139]);
AGR.TOC("perm","Sz8G1-p560B0.m",[123310580,-17176368]);
AGR.TOC("perm","Sz8G1-p1456B0.m",[-9198948,90911383]);
AGR.TOC("perm","Sz8G1-p2080B0.m",[75808414,82588160]);
AGR.TOC("matff","Sz8G1-f2r64B0.m",[-79065595,-38559232]);
AGR.TOC("matff","Sz8G1-f5r14aB0.m",[10635806,-121759694]);
AGR.TOC("matff","Sz8G1-f5r14bB0.m",[61058488,109021804]);
AGR.TOC("matff","Sz8G1-f5r35aB0.m",[-59828866,131000197]);
AGR.TOC("matff","Sz8G1-f5r35bB0.m",[-130041963,122519422]);
AGR.TOC("matff","Sz8G1-f5r35cB0.m",[37522945,44869422]);
AGR.TOC("matff","Sz8G1-f5r63B0.m",[-73238756,-16410445]);
AGR.TOC("matff","Sz8G1-f5r195B0.m",[22203286,-13340200]);
AGR.TOC("matff","Sz8G1-f7r64B0.m",[-123808239,-124110480]);
AGR.TOC("matff","Sz8G1-f7r91B0.m",[-67586149,-983233]);
AGR.TOC("matff","Sz8G1-f7r105B0.m",[38624629,-102965256]);
AGR.TOC("matff","Sz8G1-f8r4aB0.m",[-123386786,113139979]);
AGR.TOC("matff","Sz8G1-f8r16aB0.m",[-13412516,102615520]);
AGR.TOC("matff","Sz8G1-f13r14aB0.m",[-66344243,-33179604]);
AGR.TOC("matff","Sz8G1-f13r14bB0.m",[47820803,-115122686]);
AGR.TOC("matff","Sz8G1-f13r35B0.m",[101418339,31923402]);
AGR.TOC("matff","Sz8G1-f13r65aB0.m",[-40648355,49826080]);
AGR.TOC("matff","Sz8G1-f13r65bB0.m",[-47835996,38687356]);
AGR.TOC("matff","Sz8G1-f13r65cB0.m",[52255716,31097004]);
AGR.TOC("matff","Sz8G1-f13r91B0.m",[-64703317,-94406067]);
AGR.TOC("matff","Sz8G1-f49r14aB0.m",[37509277,17651471]);
AGR.TOC("matff","Sz8G1-f125r65aB0.m",[-10776260,-22856988]);
AGR.TOC("matff","Sz8G1-f125r65bB0.m",[-45427874,81182393]);
AGR.TOC("matff","Sz8G1-f125r65cB0.m",[41924281,21885908]);
AGR.TOC("matint","Sz8G1-Zr64B0.g",[-54004418]);
AGR.TOC("matint","Sz8G1-Zr91B0.g",[109141593]);
AGR.TOC("matalg","Sz8G1-Ar14aB0.g",[-8303044]);
AGR.TOC("matalg","Sz8G1-Ar14bB0.g",[32973316]);
AGR.TOC("matalg","Sz8G1-Ar65aB0.g",[39839717]);
AGR.TOC("matalg","Sz8G1-Ar65bB0.g",[-97321434]);
AGR.TOC("matalg","Sz8G1-Ar65cB0.g",[104586205]);
AGR.TOC("maxes","Sz8G1-max1W1",[-106792446]);
AGR.TOC("maxes","Sz8G1-max2W1",[-36021094]);
AGR.TOC("maxes","Sz8G1-max3W1",[-25404543]);
AGR.TOC("maxes","Sz8G1-max4W1",[-30852836]);
AGR.TOC("classes","Sz8G1-cclsW1",[1795836]);
AGR.TOC("cyclic","Sz8G1-cycW1",[63506842]);
AGR.TOC("out","Sz8G1-a3W1",[102410782]);
AGR.TOC("pres","Sz8G1-P1",[-36123627]);
AGR.TOC("pres","Sz8G1-P2",[-92624787]);

# Sz8d3
AGR.GRP("exc","Sz8","Sz8d3");
AGR.TOC("perm","Sz8d3G1-p65B0.m",[18689327,-130297361]);
AGR.TOC("perm","Sz8d3G1-p520B0.m",[-134036275,-37527552]);
AGR.TOC("perm","Sz8d3G1-p560B0.m",[29082476,-77011387]);
AGR.TOC("perm","Sz8d3G1-p1456B0.m",[30603744,103276534]);
AGR.TOC("perm","Sz8d3G1-p2080B0.m",[-117851698,-120267967]);
AGR.TOC("matff","Sz8d3G1-f2r12B0.m",[-7393420,51938477]);
AGR.TOC("matff","Sz8d3G1-f2r48B0.m",[89758950,-102260227]);
AGR.TOC("matff","Sz8d3G1-f2r64B0.m",[5582233,-10305271]);
AGR.TOC("matff","Sz8d3G1-f5r14B0.m",[128338057,43680009]);
AGR.TOC("matff","Sz8d3G1-f5r63B0.m",[17291923,36419726]);
AGR.TOC("matff","Sz8d3G1-f5r105B0.m",[-39927249,36852902]);
AGR.TOC("matff","Sz8d3G1-f5r195B0.m",[8609772,-123588745]);
AGR.TOC("matff","Sz8d3G1-f13r14B0.m",[-33472415,68968455]);
AGR.TOC("matff","Sz8d3G1-f49r14B0.m",[-33148388,114852150]);
AGR.TOC("maxes","Sz8d3G1-max1W1",[23585294]);
AGR.TOC("maxes","Sz8d3G1-max1W2",[56024232]);
AGR.TOC("maxes","Sz8d3G1-max2W1",[-106795528]);
AGR.TOC("maxes","Sz8d3G1-max3W1",[-85586222]);
AGR.TOC("maxes","Sz8d3G1-max4W1",[45488179]);
AGR.TOC("maxes","Sz8d3G1-max5W1",[110343436]);
AGR.TOC("classes","Sz8d3G1-cclsW1",[29754915]);
AGR.TOC("cyclic","Sz8d3G1-cycW1",[94183098]);
AGR.TOC("switch","Sz8d3G2-G1W1",[-92862509]);
AGR.TOC("pres","Sz8d3G1-P1",[124335026]);

# TD42
AGR.GRP("exc","TD42","TD42");
AGR.TOC("perm","TD42G1-p819B0.m",[-10501305,-99061254]);
AGR.TOC("matff","TD42G1-f2r26B0.m",[6861405,27316309]);
AGR.TOC("matff","TD42G1-f3r25B0.m",[-111344188,-71017228]);
AGR.TOC("matff","TD42G1-f3r52B0.m",[25673339,-110318590]);
AGR.TOC("matff","TD42G1-f3r196B0.m",[-56202347,82705611]);
AGR.TOC("matff","TD42G1-f3r324B0.m",[44026544,-132500728]);
AGR.TOC("matff","TD42G1-f3r441B0.m",[-12427530,16658292]);
AGR.TOC("matff","TD42G1-f3r1053B0.m",[-98355828,-121741633]);
AGR.TOC("matff","TD42G1-f7r26B0.m",[-20015577,34677534]);
AGR.TOC("matff","TD42G1-f7r298B0.m",[-68795028,-97476619]);
AGR.TOC("matff","TD42G1-f8r8aB0.m",[93622710,-33344479]);
AGR.TOC("matff","TD42G1-f13r26B0.m",[-30054543,96988669]);
AGR.TOC("matff","TD42G1-f27r351aB0.m",[-69567476,-46875777]);
AGR.TOC("matff","TD42G1-f27r351bB0.m",[52698257,-13710506]);
AGR.TOC("matff","TD42G1-f27r351cB0.m",[24139637,82594114]);
AGR.TOC("matint","TD42G1-Zr26B0.g",[-82811700]);
AGR.TOC("matint","TD42G1-Zr52B0.g",[58692512]);
AGR.TOC("matint","TD42G1-Zr196B0.g",[116322165]);
AGR.TOC("maxes","TD42G1-max1W1",[108517232]);
AGR.TOC("maxes","TD42G1-max2W1",[-61427847]);
AGR.TOC("maxes","TD42G1-max3W1",[71768213]);
AGR.TOC("maxes","TD42G1-max4W1",[24910469]);
AGR.TOC("maxes","TD42G1-max5W1",[-39788286]);
AGR.TOC("maxes","TD42G1-max6W1",[3858362]);
AGR.TOC("maxes","TD42G1-max7W1",[-92433715]);
AGR.TOC("maxes","TD42G1-max8W1",[-21999476]);
AGR.TOC("maxes","TD42G1-max9W1",[72478709]);
AGR.TOC("cyclic","TD42G1-cycW1",[109498448]);
AGR.TOC("cyc2ccl","TD42G1cycW1-cclsW1",[-110910802]);
AGR.TOC("out","TD42G1-a3W1",[79559950]);

# TD42d3
AGR.GRP("exc","TD42","TD42d3");
AGR.TOC("matff","TD42d3G1-f2r24B0.m",[97460247,-38233255]);
AGR.TOC("matff","TD42d3G1-f2r26B0.m",[51230031,-77205005]);
AGR.TOC("matff","TD42d3G1-f2r144B0.m",[18107385,-117405903]);
AGR.TOC("matff","TD42d3G1-f2r246aB0.m",[92665502,-106689310]);
AGR.TOC("matff","TD42d3G1-f2r480B0.m",[45254823,20144904]);
AGR.TOC("matff","TD42d3G1-f3r52B0.m",[-71771377,-89200195]);
AGR.TOC("matff","TD42d3G1-f3r196B0.m",[-89122273,-65715266]);
AGR.TOC("matff","TD42d3G1-f7r26aB0.m",[37443700,77984633]);
AGR.TOC("matff","TD42d3G1-f7r52aB0.m",[31761421,84408856]);
AGR.TOC("matff","TD42d3G1-f7r273aB0.m",[125689997,30751760]);
AGR.TOC("matff","TD42d3G1-f7r298aB0.m",[75265722,76184115]);
AGR.TOC("matff","TD42d3G1-f7r467aB0.m",[-63050505,47319765]);
AGR.TOC("matff","TD42d3G1-f13r26aB0.m",[119078174,21186735]);
AGR.TOC("maxes","TD42d3G1-max4W1",[-80145308]);
AGR.TOC("cyclic","TD42d3G1-cycW1",[-33183597]);
AGR.TOC("cyc2ccl","TD42d3G1cycW1-cclsW1",[-90186984]);

# TD43
AGR.GRP("exc","TD43","TD43");
AGR.TOC("perm","TD43G1-p26572B0.m",[-88074186,-38786018]);
AGR.TOC("matff","TD43G1-f2r218B0.m",[104905526,75727876]);
AGR.TOC("matff","TD43G1-f27r8aB0.m",[-125396163,-72636897]);

# 2TE62
AGR.GRP("exc","TE62","2TE62");
AGR.TOC("matff","2TE62G1-f2r1704B0.m",[98176133,73659634]);

# 2TE62d2
AGR.GRP("exc","TE62","2TE62d2");
AGR.TOC("matff","2TE62d2G1-f2r1705B0.m",[132074392,7708207]);
AGR.TOC("matff","2TE62d2G1-f3r2432B0.m",[31810249,-22770249]);

# 3TE62
AGR.GRP("exc","TE62","3TE62");
AGR.TOC("matff","3TE62G1-f4r27B0.m",[-89255860,-93293123]);

# 3TE62S3
AGR.GRP("exc","TE62","3TE62S3");
AGR.TOC("matff","3TE62S3G0-f2r54B0.m",[131898693,-116462187]);

# 3TE62d2
AGR.GRP("exc","TE62","3TE62d2");
AGR.TOC("matff","3TE62d2G1-f2r54B0.m",[35844574,-6779317]);

# 3TE62d3
AGR.GRP("exc","TE62","3TE62d3");
AGR.TOC("matff","3TE62d3G0-f4r27B0.m",[-8598482,-129967937]);

# 4TE62
AGR.GRP("exc","TE62","4TE62");
AGR.TOC("matff","4TE62G1-f2r1706B0.m",[-28003667,20498628]);

# TE62
AGR.GRP("exc","TE62","TE62");
AGR.TOC("matff","TE62G1-f2r78B0.m",[29106086,-122397655]);
AGR.TOC("matff","TE62G1-f2r1705aB0.m",[83016690,-94650971]);
AGR.TOC("out","TE62G1-a2W1",[-59453278]);
AGR.TOC("out","TE62G1-a3W1",[63184971]);

# TE62S3
AGR.GRP("exc","TE62","TE62S3");
AGR.TOC("matff","TE62S3G0-f2r78B0.m",[83222518,90809456]);

# TE62d2
AGR.GRP("exc","TE62","TE62d2");
AGR.TOC("matff","TE62d2G1-f2r78B0.m",[82064475,124956596]);
AGR.TOC("matff","TE62d2G1-f3r1938B0.m",[31851186,55531837]);

# TE62d3
AGR.GRP("exc","TE62","TE62d3");
AGR.TOC("matff","TE62d3G0-f2r78B0.m",[83222518,106730798]);

# TF42
AGR.GRP("exc","TF42","TF42");
AGR.TOC("perm","TF42G1-p1600B0.m",[-37211084,-38897253]);
AGR.TOC("perm","TF42G1-p1755B0.m",[58998439,70853112]);
AGR.TOC("perm","TF42G1-p2304B0.m",[-120477733,-29507280]);
AGR.TOC("perm","TF42G1-p2925B0.m",[68358721,-45087045]);
AGR.TOC("perm","TF42G1-p12480B0.m",[-23470927,51049576]);
AGR.TOC("perm","TF42G1-p14976B0.m",[121478237,-76779913]);
AGR.TOC("matff","TF42G1-f2r26B0.m",[-14435114,-113292396]);
AGR.TOC("matff","TF42G1-f2r246B0.m",[-19232979,82932839]);
AGR.TOC("matff","TF42G1-f3r26aB0.m",[-54455119,-36800145]);
AGR.TOC("matff","TF42G1-f3r26bB0.m",[53486701,-2015262]);
AGR.TOC("matff","TF42G1-f3r54B0.m",[-111305949,-116611254]);
AGR.TOC("matff","TF42G1-f3r77B0.m",[-80577335,116951646]);
AGR.TOC("matff","TF42G1-f3r124aB0.m",[-54985865,132715076]);
AGR.TOC("matff","TF42G1-f3r124bB0.m",[95513912,-73639791]);
AGR.TOC("matff","TF42G1-f4r2048aB0.m",[-101207181,23217347]);
AGR.TOC("matff","TF42G1-f5r27aB0.m",[79127454,-62374549]);
AGR.TOC("matff","TF42G1-f5r27bB0.m",[27989765,75490599]);
AGR.TOC("matff","TF42G1-f5r52B0.m",[8121505,-80695927]);
AGR.TOC("matff","TF42G1-f5r78B0.m",[-89209549,-12947059]);
AGR.TOC("matff","TF42G1-f5r218B0.m",[-120317877,-60225010]);
AGR.TOC("matff","TF42G1-f9r27aB0.m",[58474367,105018797]);
AGR.TOC("matff","TF42G1-f9r27bB0.m",[69866060,113452040]);
AGR.TOC("matff","TF42G1-f13r27aB0.m",[-25896573,-59272896]);
AGR.TOC("matff","TF42G1-f13r27bB0.m",[6846205,93819061]);
AGR.TOC("matff","TF42G1-f13r52B0.m",[-67021491,-93909355]);
AGR.TOC("matff","TF42G1-f13r78B0.m",[-67757828,45547291]);
AGR.TOC("matff","TF42G1-f25r26aB0.m",[72243187,102875993]);
AGR.TOC("matff","TF42G1-f25r26bB0.m",[-118084756,-103588755]);
AGR.TOC("matff","TF42G1-f25r109aB0.m",[-816843,-102780292]);
AGR.TOC("matff","TF42G1-f25r109bB0.m",[68604401,71301559]);
AGR.TOC("matff","TF42G1-f169r26B0.m",[89078598,14639889]);
AGR.TOC("matint","TF42G1-Zr52B0.g",[47940272]);
AGR.TOC("matint","TF42G1-Zr78B0.g",[-46120530]);
AGR.TOC("maxes","TF42G1-max1W1",[-52963060]);
AGR.TOC("maxes","TF42G1-max2W1",[-21832158]);
AGR.TOC("maxes","TF42G1-max3W1",[-31485219]);
AGR.TOC("maxes","TF42G1-max4W1",[45633895]);
AGR.TOC("maxes","TF42G1-max5W1",[-2996082]);
AGR.TOC("maxes","TF42G1-max6W1",[-10856115]);
AGR.TOC("maxes","TF42G1-max7W1",[-18055979]);
AGR.TOC("maxes","TF42G1-max8W1",[-74592193]);
AGR.TOC("cyclic","TF42G1-cycW1",[112883162]);
AGR.TOC("cyc2ccl","TF42G1cycW1-cclsW1",[105460752]);
AGR.TOC("pres","TF42G1-P1",[-124990063]);

# TF42d2
AGR.GRP("exc","TF42","TF42d2");
AGR.TOC("perm","TF42d2G1-p1755B0.m",[-52088433,-100606049]);
AGR.TOC("perm","TF42d2G1-p2304B0.m",[70494450,115546319]);
AGR.TOC("matff","TF42d2G1-f2r26B0.m",[-38675641,-39644523]);
AGR.TOC("matff","TF42d2G1-f2r246B0.m",[97755809,71082518]);
AGR.TOC("matff","TF42d2G1-f3r52B0.m",[124402546,-54811053]);
AGR.TOC("matff","TF42d2G1-f3r77B0.m",[-109209670,113053227]);
AGR.TOC("matff","TF42d2G1-f5r27B0.m",[6496008,128767148]);
AGR.TOC("matff","TF42d2G1-f5r52B0.m",[24617056,99357518]);
AGR.TOC("matff","TF42d2G1-f5r78B0.m",[-91803490,-110346379]);
AGR.TOC("matff","TF42d2G1-f5r218B0.m",[106581594,-105082374]);
AGR.TOC("matff","TF42d2G1-f13r27aB0.m",[-71944661,-5801480]);
AGR.TOC("matff","TF42d2G1-f13r27bB0.m",[35975952,-60429928]);
AGR.TOC("matff","TF42d2G1-f13r78B0.m",[30775775,-60970092]);
AGR.TOC("matff","TF42d2G1-f13r1374B0.m",[72048076,-47464220]);
AGR.TOC("maxes","TF42d2G1-max1W1",[72641225]);
AGR.TOC("pres","TF42d2G1-P1",[69865752]);

# 2L2101
AGR.GRP("lin","L2101","2L2101");
AGR.TOC("matalg","2L2101G1-Ar102aB0.g",[37573240]);

# L2101
AGR.GRP("lin","L2101","L2101");
AGR.TOC("matint","L2101G1-Zr101B0.g",[133076037]);
AGR.TOC("matalg","L2101G1-Ar102aB0.g",[123113277]);
AGR.TOC("maxes","L2101G1-max1W1",[77543199]);
AGR.TOC("maxes","L2101G1-max2W1",[50083925]);
AGR.TOC("maxes","L2101G1-max3W1",[75530552]);
AGR.TOC("maxes","L2101G1-max4W1",[-85356476]);
AGR.TOC("maxes","L2101G1-max5W1",[20202362]);
AGR.TOC("out","L2101G1-a2W1",[108609048]);

# 2L2103
AGR.GRP("lin","L2103","2L2103");
AGR.TOC("matalg","2L2103G1-Ar104aB0.g",[91016307]);

# L2103
AGR.GRP("lin","L2103","L2103");
AGR.TOC("matint","L2103G1-Zr103B0.g",[124419151]);
AGR.TOC("matalg","L2103G1-Ar104aB0.g",[84974515]);
AGR.TOC("maxes","L2103G1-max1W1",[1168567]);
AGR.TOC("maxes","L2103G1-max2W1",[98771752]);
AGR.TOC("maxes","L2103G1-max3W1",[117428427]);
AGR.TOC("maxes","L2103G1-max4W1",[-15214501]);
AGR.TOC("maxes","L2103G1-max5W1",[-42252537]);
AGR.TOC("out","L2103G1-a2W1",[-10449653]);

# 2L2107
AGR.GRP("lin","L2107","2L2107");
AGR.TOC("matalg","2L2107G1-Ar108aB0.g",[41610451]);

# L2107
AGR.GRP("lin","L2107","L2107");
AGR.TOC("matint","L2107G1-Zr107B0.g",[15234824]);
AGR.TOC("matalg","L2107G1-Ar108aB0.g",[74687386]);
AGR.TOC("maxes","L2107G1-max1W1",[-77221955]);
AGR.TOC("maxes","L2107G1-max2W1",[50083925]);
AGR.TOC("maxes","L2107G1-max3W1",[117428427]);
AGR.TOC("maxes","L2107G1-max4W1",[-15986133]);
AGR.TOC("out","L2107G1-a2W1",[70000060]);

# 2L2109
AGR.GRP("lin","L2109","2L2109");
AGR.TOC("matalg","2L2109G1-Ar110aB0.g",[60416506]);

# L2109
AGR.GRP("lin","L2109","L2109");
AGR.TOC("matint","L2109G1-Zr109B0.g",[-25735107]);
AGR.TOC("matalg","L2109G1-Ar110aB0.g",[-45121876]);
AGR.TOC("maxes","L2109G1-max1W1",[-9769840]);
AGR.TOC("maxes","L2109G1-max2W1",[-52742966]);
AGR.TOC("maxes","L2109G1-max3W1",[20196712]);
AGR.TOC("maxes","L2109G1-max4W1",[-33392236]);
AGR.TOC("maxes","L2109G1-max5W1",[-95740597]);
AGR.TOC("out","L2109G1-a2W1",[-68559136]);

# 2L211
AGR.GRP("lin","L211","2L211");
AGR.TOC("matff","2L211G1-f11r2B0.m",[117641548,74616249]);
AGR.TOC("matff","2L211G1-f11r4B0.m",[-109242231,56040120]);
AGR.TOC("matff","2L211G1-f11r6B0.m",[52557305,-55918315]);
AGR.TOC("matff","2L211G1-f11r8B0.m",[45283555,-83694066]);
AGR.TOC("matff","2L211G1-f11r10B0.m",[-89819765,75567976]);

# L211
AGR.GRP("lin","L211","L211");
AGR.TOC("perm","L211G1-p11aB0.m",[-123271105,38306543]);
AGR.TOC("perm","L211G1-p11bB0.m",[-123271105,-97689525]);
AGR.TOC("perm","L211G1-p12B0.m",[-118120972,-27478863]);
AGR.TOC("perm","L211G1-p55B0.m",[107363984,-70942041]);
AGR.TOC("matff","L211G1-f2r10B0.m",[75057919,-104988621]);
AGR.TOC("matff","L211G1-f2r10bB0.m",[38955196,127675444]);
AGR.TOC("matff","L211G1-f2r24B0.m",[-78731294,-81476966]);
AGR.TOC("matff","L211G1-f3r5aB0.m",[-18170891,-41767362]);
AGR.TOC("matff","L211G1-f3r5bB0.m",[-29296439,5263909]);
AGR.TOC("matff","L211G1-f3r10B0.m",[-60642449,-82170516]);
AGR.TOC("matff","L211G1-f3r24B0.m",[-112790947,866855]);
AGR.TOC("matff","L211G1-f4r5aB0.m",[-5236219,-90340470]);
AGR.TOC("matff","L211G1-f4r5bB0.m",[13882788,46901805]);
AGR.TOC("matff","L211G1-f4r12aB0.m",[104289404,-23317320]);
AGR.TOC("matff","L211G1-f4r12bB0.m",[104289404,-122438266]);
AGR.TOC("matff","L211G1-f5r5aB0.m",[-81550380,-131523481]);
AGR.TOC("matff","L211G1-f5r5bB0.m",[-22534346,41800212]);
AGR.TOC("matff","L211G1-f5r10aB0.m",[117734711,82239949]);
AGR.TOC("matff","L211G1-f5r10bB0.m",[119720900,44516691]);
AGR.TOC("matff","L211G1-f5r11B0.m",[122075473,-83625436]);
AGR.TOC("matff","L211G1-f9r12aB0.m",[-127642448,-73986554]);
AGR.TOC("matff","L211G1-f9r12bB0.m",[84450683,-61805314]);
AGR.TOC("matff","L211G1-f11r3B0.m",[-126750382,-73939341]);
AGR.TOC("matff","L211G1-f11r5B0.m",[49307670,69480485]);
AGR.TOC("matff","L211G1-f11r7B0.m",[86809882,-124515293]);
AGR.TOC("matff","L211G1-f11r9B0.m",[75379312,53671949]);
AGR.TOC("matff","L211G1-f11r11B0.m",[-13081487,-16982456]);
AGR.TOC("matint","L211G1-Zr10aB0.g",[96612861]);
AGR.TOC("matint","L211G1-Zr10bB0.g",[-43431548]);
AGR.TOC("matint","L211G1-Zr10cB0.g",[-47896152]);
AGR.TOC("matint","L211G1-Zr11B0.g",[-2935033]);
AGR.TOC("matalg","L211G1-Ar5aB0.g",[-134129477]);
AGR.TOC("matalg","L211G1-Ar5bB0.g",[-10868109]);
AGR.TOC("matalg","L211G1-Ar12aB0.g",[27330559]);
AGR.TOC("matalg","L211G1-Ar12bB0.g",[16381729]);
AGR.TOC("maxes","L211G1-max1W1",[-121742273]);
AGR.TOC("maxes","L211G1-max2W1",[69578701]);
AGR.TOC("maxes","L211G1-max3W1",[1157952]);
AGR.TOC("maxes","L211G1-max4W1",[-119009509]);
AGR.TOC("cyclic","L211G1-cycW1",[-123110936]);
AGR.TOC("cyc2ccl","L211G1cycW1-cclsW1",[-37044661]);
AGR.TOC("check","L211G1-check1",[100335170]);
AGR.TOC("pres","L211G1-P1",[94801920]);

# L211d2
AGR.GRP("lin","L211","L211d2");
AGR.TOC("perm","L211d2G1-p12B0.m",[85376259,78759073]);
AGR.TOC("perm","L211d2G1-p22B0.m",[81251837,-32416322]);
AGR.TOC("perm","L211d2G1-p55aB0.m",[2562443,-64825489]);
AGR.TOC("perm","L211d2G1-p55bB0.m",[-60945265,-71912953]);
AGR.TOC("perm","L211d2G1-p66B0.m",[102861998,46609527]);
AGR.TOC("matff","L211d2G1-f2r10aB0.m",[-104455060,13626008]);
AGR.TOC("matff","L211d2G1-f2r10bB0.m",[-64156113,112772673]);
AGR.TOC("matff","L211d2G1-f4r12aB0.m",[-113262497,39895390]);
AGR.TOC("matff","L211d2G1-f4r12bB0.m",[99408470,-26459309]);
AGR.TOC("matff","L211d2G1-f11r3B0.m",[105616142,51353074]);
AGR.TOC("matff","L211d2G1-f11r5B0.m",[-40684042,69480485]);
AGR.TOC("matff","L211d2G1-f11r7B0.m",[23007475,120910396]);
AGR.TOC("matff","L211d2G1-f11r9B0.m",[47008813,122974778]);
AGR.TOC("matff","L211d2G1-f11r11B0.m",[-83346262,-127633464]);
AGR.TOC("maxes","L211d2G1-max1W1",[-125255449]);
AGR.TOC("maxes","L211d2G1-max2W1",[-111690704]);
AGR.TOC("maxes","L211d2G1-max3W1",[-121742273]);
AGR.TOC("maxes","L211d2G1-max4W1",[35382633]);
AGR.TOC("maxes","L211d2G1-max5W1",[-69908688]);
AGR.TOC("cyclic","L211d2G1-cycW1",[-77013908]);
AGR.TOC("cyc2ccl","L211d2G1cycW1-cclsW1",[-95306297]);
AGR.TOC("check","L211d2G1-check1",[-13733630]);
AGR.TOC("pres","L211d2G1-P1",[90675863]);

# 2L2113
AGR.GRP("lin","L2113","2L2113");
AGR.TOC("matalg","2L2113G1-Ar114aB0.g",[19005607]);

# L2113
AGR.GRP("lin","L2113","L2113");
AGR.TOC("matint","L2113G1-Zr113B0.g",[-17556175]);
AGR.TOC("matalg","L2113G1-Ar114aB0.g",[-29967839]);
AGR.TOC("maxes","L2113G1-max1W1",[65275271]);
AGR.TOC("maxes","L2113G1-max2W1",[-41665027]);
AGR.TOC("maxes","L2113G1-max3W1",[40679634]);
AGR.TOC("maxes","L2113G1-max4W1",[70293248]);
AGR.TOC("maxes","L2113G1-max5W1",[7846482]);
AGR.TOC("out","L2113G1-a2W1",[-31749984]);

# 2L2127
AGR.GRP("lin","L2127","2L2127");
AGR.TOC("matalg","2L2127G1-Ar128aB0.g",[64922225]);

# L2127
AGR.GRP("lin","L2127","L2127");
AGR.TOC("matint","L2127G1-Zr127B0.g",[108137535]);
AGR.TOC("matalg","L2127G1-Ar128aB0.g",[-34498964]);
AGR.TOC("maxes","L2127G1-max1W1",[-6184603]);
AGR.TOC("maxes","L2127G1-max2W1",[98771752]);
AGR.TOC("maxes","L2127G1-max3W1",[-52742966]);
AGR.TOC("maxes","L2127G1-max4W1",[-81542613]);
AGR.TOC("maxes","L2127G1-max5W1",[-99847805]);
AGR.TOC("out","L2127G1-a2W1",[64553547]);

# L2128
AGR.GRP("lin","L2128","L2128");
AGR.TOC("matint","L2128G1-Zr128B0.g",[-77487496]);
AGR.TOC("matalg","L2128G1-Ar129aB0.g",[43545524]);

# 2L213
AGR.GRP("lin","L213","2L213");
AGR.TOC("matff","2L213G1-f3r6aB0.m",[75322658,-28442581]);
AGR.TOC("matff","2L213G1-f3r6bB0.m",[-21583259,-66373345]);
AGR.TOC("matff","2L213G1-f3r14B0.m",[88377861,-102827991]);
AGR.TOC("matff","2L213G1-f7r14aB0.m",[-67537133,108203959]);
AGR.TOC("matff","2L213G1-f13r2B0.m",[98225255,13324548]);
AGR.TOC("matff","2L213G1-f13r4B0.m",[-123327193,-131294325]);
AGR.TOC("matff","2L213G1-f13r6B0.m",[77060268,4717066]);
AGR.TOC("matff","2L213G1-f13r8B0.m",[98600107,-4412184]);
AGR.TOC("matff","2L213G1-f13r10B0.m",[-112678870,-54337710]);
AGR.TOC("matff","2L213G1-f13r12B0.m",[-10521917,-39316113]);
AGR.TOC("matff","2L213G1-f27r12aB0.m",[-28729506,5105077]);
AGR.TOC("matff","2L213G1-f27r12bB0.m",[-5973322,47284698]);
AGR.TOC("matff","2L213G1-f27r12cB0.m",[-62161460,26516967]);
AGR.TOC("matff","2L213G1-f49r6aB0.m",[-35361606,71477118]);
AGR.TOC("matff","2L213G1-f49r6bB0.m",[-35361606,41211266]);
AGR.TOC("matff","2L213G1-f49r14bB0.m",[44782079,-15650922]);
AGR.TOC("matff","2L213G1-f49r14cB0.m",[109663018,39620947]);

# 2L213d2
AGR.GRP("lin","L213","2L213d2");
AGR.TOC("matff","2L213d2G1-f3r12aB0.m",[100717735,-74660203]);

# L213
AGR.GRP("lin","L213","L213");
AGR.TOC("perm","L213G1-p14B0.m",[-91947287,82787547]);
AGR.TOC("matff","L213G1-f2r14B0.m",[81634284,117900590]);
AGR.TOC("matff","L213G1-f3r13B0.m",[-42206942,-74309834]);
AGR.TOC("matff","L213G1-f4r6aB0.m",[65000190,89312086]);
AGR.TOC("matff","L213G1-f4r6bB0.m",[65000190,-122360638]);
AGR.TOC("matff","L213G1-f7r12B0.m",[-22464759,-111035448]);
AGR.TOC("matff","L213G1-f8r12aB0.m",[-23961287,-122239881]);
AGR.TOC("matff","L213G1-f8r12bB0.m",[15467192,110047527]);
AGR.TOC("matff","L213G1-f8r12cB0.m",[81786641,81442952]);
AGR.TOC("matff","L213G1-f13r3B0.m",[63481373,105550590]);
AGR.TOC("matff","L213G1-f13r5B0.m",[-39086473,41661632]);
AGR.TOC("matff","L213G1-f13r7B0.m",[-113197285,-129463306]);
AGR.TOC("matff","L213G1-f13r9B0.m",[127113446,64877555]);
AGR.TOC("matff","L213G1-f13r11B0.m",[53072034,3244024]);
AGR.TOC("matff","L213G1-f13r13B0.m",[104578255,-42907957]);
AGR.TOC("matint","L213G1-Zr13B0.g",[123011361]);
AGR.TOC("matint","L213G1-Zr14aB0.g",[-123871088]);
AGR.TOC("matint","L213G1-Zr14bB0.g",[-105815349]);
AGR.TOC("matint","L213G1-Zr14cB0.g",[-7881673]);
AGR.TOC("matint","L213G1-Zr36B0.g",[83179307]);
AGR.TOC("matalg","L213G1-Ar12aB0.g",[-59203708]);
AGR.TOC("matalg","L213G1-Ar12bB0.g",[120191936]);
AGR.TOC("matalg","L213G1-Ar12cB0.g",[20003507]);
AGR.TOC("cyclic","L213G1-cycW1",[-122829237]);
AGR.TOC("cyc2ccl","L213G1cycW1-cclsW1",[98128951]);
AGR.TOC("out","L213G1-a2W1",[-84768428]);
AGR.TOC("check","L213G1-check1",[114923626]);

# L213d2
AGR.GRP("lin","L213","L213d2");
AGR.TOC("perm","L213d2G1-p14B0.m",[-19041356,-77302057]);
AGR.TOC("perm","L213d2G1-p78B0.m",[-115427218,-95892825]);
AGR.TOC("perm","L213d2G1-p91aB0.m",[13099628,-115148298]);
AGR.TOC("matff","L213d2G1-f2r12aB0.m",[10533130,29850182]);
AGR.TOC("matff","L213d2G1-f2r14B0.m",[-22148341,84612921]);
AGR.TOC("matff","L213d2G1-f13r3aB0.m",[-43727987,36597755]);
AGR.TOC("cyclic","L213d2G1-cycW1",[93407541]);
AGR.TOC("cyc2ccl","L213d2G1cycW1-cclsW1",[-61538061]);

# 2L2131
AGR.GRP("lin","L2131","2L2131");
AGR.TOC("matalg","2L2131G1-Ar132aB0.g",[65865488]);

# L2131
AGR.GRP("lin","L2131","L2131");
AGR.TOC("matint","L2131G1-Zr131B0.g",[-68982411]);
AGR.TOC("matalg","L2131G1-Ar132aB0.g",[104797209]);
AGR.TOC("maxes","L2131G1-max1W1",[66564897]);
AGR.TOC("maxes","L2131G1-max2W1",[-52742966]);
AGR.TOC("maxes","L2131G1-max3W1",[98771752]);
AGR.TOC("maxes","L2131G1-max4W1",[-97155444]);
AGR.TOC("maxes","L2131G1-max5W1",[82760492]);
AGR.TOC("out","L2131G1-a2W1",[79429276]);

# 2L2137
AGR.GRP("lin","L2137","2L2137");
AGR.TOC("matalg","2L2137G1-Ar138aB0.g",[-16526672]);

# L2137
AGR.GRP("lin","L2137","L2137");
AGR.TOC("matint","L2137G1-Zr137B0.g",[40430567]);
AGR.TOC("matalg","L2137G1-Ar138aB0.g",[117152392]);
AGR.TOC("maxes","L2137G1-max1W1",[-40146201]);
AGR.TOC("maxes","L2137G1-max2W1",[98771752]);
AGR.TOC("maxes","L2137G1-max3W1",[75295270]);
AGR.TOC("maxes","L2137G1-max4W1",[-102190056]);
AGR.TOC("maxes","L2137G1-max5W1",[-42658397]);
AGR.TOC("out","L2137G1-a2W1",[-102504060]);

# 2L2139
AGR.GRP("lin","L2139","2L2139");
AGR.TOC("matalg","2L2139G1-Ar140aB0.g",[-126063759]);

# L2139
AGR.GRP("lin","L2139","L2139");
AGR.TOC("matint","L2139G1-Zr139B0.g",[-129819005]);
AGR.TOC("matalg","L2139G1-Ar140aB0.g",[22634312]);
AGR.TOC("maxes","L2139G1-max1W1",[35356411]);
AGR.TOC("maxes","L2139G1-max2W1",[-52742966]);
AGR.TOC("maxes","L2139G1-max3W1",[-120005548]);
AGR.TOC("maxes","L2139G1-max4W1",[90241214]);
AGR.TOC("maxes","L2139G1-max5W1",[59236432]);
AGR.TOC("out","L2139G1-a2W1",[18854625]);

# 2L2149
AGR.GRP("lin","L2149","2L2149");
AGR.TOC("matalg","2L2149G1-Ar150aB0.g",[-11696483]);

# L2149
AGR.GRP("lin","L2149","L2149");
AGR.TOC("matint","L2149G1-Zr149B0.g",[102968573]);
AGR.TOC("matalg","L2149G1-Ar150aB0.g",[-37170719]);
AGR.TOC("maxes","L2149G1-max1W1",[-66969697]);
AGR.TOC("maxes","L2149G1-max2W1",[-52742966]);
AGR.TOC("maxes","L2149G1-max3W1",[-133853492]);
AGR.TOC("maxes","L2149G1-max4W1",[-87873653]);
AGR.TOC("maxes","L2149G1-max5W1",[47288309]);
AGR.TOC("out","L2149G1-a2W1",[-7907886]);

# 2L2151
AGR.GRP("lin","L2151","2L2151");
AGR.TOC("matalg","2L2151G1-Ar152aB0.g",[-90245408]);

# L2151
AGR.GRP("lin","L2151","L2151");
AGR.TOC("matint","L2151G1-Zr151B0.g",[119951693]);
AGR.TOC("matalg","L2151G1-Ar152aB0.g",[53971443]);
AGR.TOC("maxes","L2151G1-max1W1",[-6133708]);
AGR.TOC("maxes","L2151G1-max2W1",[117428427]);
AGR.TOC("maxes","L2151G1-max3W1",[-52742966]);
AGR.TOC("maxes","L2151G1-max4W1",[122228493]);
AGR.TOC("maxes","L2151G1-max5W1",[-33391375]);
AGR.TOC("maxes","L2151G1-max6W1",[113371709]);
AGR.TOC("maxes","L2151G1-max7W1",[-99321456]);
AGR.TOC("out","L2151G1-a2W1",[52782258]);

# 2L2157
AGR.GRP("lin","L2157","2L2157");
AGR.TOC("matalg","2L2157G1-Ar158aB0.g",[61720223]);

# L2157
AGR.GRP("lin","L2157","L2157");
AGR.TOC("matint","L2157G1-Zr157B0.g",[9690336]);
AGR.TOC("matalg","L2157G1-Ar158aB0.g",[-104420675]);
AGR.TOC("maxes","L2157G1-max1W1",[32840683]);
AGR.TOC("maxes","L2157G1-max2W1",[98771752]);
AGR.TOC("maxes","L2157G1-max3W1",[-64843294]);
AGR.TOC("maxes","L2157G1-max4W1",[94147488]);
AGR.TOC("out","L2157G1-a2W1",[48223269]);

# L216
AGR.GRP("lin","L216","L216");
AGR.TOC("perm","L216G1-p17B0.m",[-25860833,85122705]);
AGR.TOC("matff","L216G1-f3r16B0.m",[113301689,128988142]);
AGR.TOC("matff","L216G1-f5r16B0.m",[13115658,23713490]);
AGR.TOC("matff","L216G1-f9r17aB0.m",[-121570067,-7482952]);
AGR.TOC("matff","L216G1-f9r17bB0.m",[-51916978,-114933949]);
AGR.TOC("matff","L216G1-f16r2aB0.m",[-97704224,-81575292]);
AGR.TOC("matff","L216G1-f17r15B0.m",[-30169332,56986142]);
AGR.TOC("matff","L216G1-f17r17B0.m",[-113610380,-12549422]);
AGR.TOC("matff","L216G1-f17r34B0.m",[61736652,73455961]);
AGR.TOC("matff","L216G1-f17r68B0.m",[-62662568,-59797617]);
AGR.TOC("matint","L216G1-Zr16B0.g",[-24057002]);
AGR.TOC("matint","L216G1-Zr17aB0.g",[113536300]);
AGR.TOC("matint","L216G1-Zr34B0.g",[91957897]);
AGR.TOC("matint","L216G1-Zr68B0.g",[-22096638]);
AGR.TOC("matint","L216G1-Zr120B0.g",[51019731]);
AGR.TOC("cyclic","L216G1-cycW1",[107163383]);
AGR.TOC("cyc2ccl","L216G1cycW1-cclsW1",[-123323472]);
AGR.TOC("out","L216G1-a2W1",[-12944666]);
AGR.TOC("out","L216G1-a4W1",[-100971246]);
AGR.TOC("check","L216G1-check1",[62665234]);

# L216d2
AGR.GRP("lin","L216","L216d2");
AGR.TOC("matff","L216d2G1-f4r4aB0.m",[-47692808,15333732]);
AGR.TOC("cyclic","L216d2G1-cycW1",[-48808806]);
AGR.TOC("cyc2ccl","L216d2G1cycW1-cclsW1",[32833683]);

# L216d4
AGR.GRP("lin","L216","L216d4");
AGR.TOC("matff","L216d4G1-f2r8aB0.m",[84946852,63609119]);
AGR.TOC("matff","L216d4G1-f2r8bB0.m",[100647892,-43619498]);
AGR.TOC("matff","L216d4G1-f2r16aB0.m",[11242384,24314152]);
AGR.TOC("matff","L216d4G1-f2r16bB0.m",[21535900,-45929875]);
AGR.TOC("matff","L216d4G1-f2r32B0.m",[55087905,-27851192]);
AGR.TOC("matff","L216d4G1-f3r16aB0.m",[43948758,-10148193]);
AGR.TOC("matff","L216d4G1-f5r16aB0.m",[-28597828,130368598]);
AGR.TOC("matff","L216d4G1-f5r17aB0.m",[98773480,108401653]);
AGR.TOC("matff","L216d4G1-f9r60aB0.m",[37571756,-14947100]);
AGR.TOC("matff","L216d4G1-f9r60bB0.m",[-61514124,69703825]);
AGR.TOC("matff","L216d4G1-f17r15aB0.m",[88941287,-15835311]);
AGR.TOC("matff","L216d4G1-f17r17aB0.m",[-71828116,-16990703]);
AGR.TOC("matff","L216d4G1-f17r34aB0.m",[-25415718,82510637]);
AGR.TOC("matff","L216d4G1-f17r68B0.m",[117656541,101172947]);
AGR.TOC("matff","L216d4G1-f25r60aB0.m",[-89876973,-104154660]);
AGR.TOC("matff","L216d4G1-f25r60bB0.m",[-69261645,1618576]);
AGR.TOC("cyclic","L216d4G1-cycW1",[-74070453]);
AGR.TOC("cyc2ccl","L216d4G1cycW1-cclsW1",[-22952011]);

# 2L2163
AGR.GRP("lin","L2163","2L2163");
AGR.TOC("matalg","2L2163G1-Ar164aB0.g",[-120858578]);

# L2163
AGR.GRP("lin","L2163","L2163");
AGR.TOC("matint","L2163G1-Zr163B0.g",[44887671]);
AGR.TOC("matalg","L2163G1-Ar164aB0.g",[56363135]);
AGR.TOC("maxes","L2163G1-max1W1",[-88602553]);
AGR.TOC("maxes","L2163G1-max2W1",[98771752]);
AGR.TOC("maxes","L2163G1-max3W1",[48045372]);
AGR.TOC("maxes","L2163G1-max4W1",[54062706]);
AGR.TOC("out","L2163G1-a2W1",[33372122]);

# 2L2167
AGR.GRP("lin","L2167","2L2167");
AGR.TOC("matalg","2L2167G1-Ar168aB0.g",[-30977759]);

# L2167
AGR.GRP("lin","L2167","L2167");
AGR.TOC("matint","L2167G1-Zr167B0.g",[-106781249]);
AGR.TOC("matalg","L2167G1-Ar168aB0.g",[52761382]);
AGR.TOC("maxes","L2167G1-max1W1",[33227458]);
AGR.TOC("maxes","L2167G1-max2W1",[98771752]);
AGR.TOC("maxes","L2167G1-max3W1",[50083925]);
AGR.TOC("maxes","L2167G1-max4W1",[-63379587]);
AGR.TOC("maxes","L2167G1-max5W1",[-114911979]);
AGR.TOC("out","L2167G1-a2W1",[65102054]);

# 2L217
AGR.GRP("lin","L217","2L217");
AGR.TOC("matff","2L217G1-f9r8aB0.m",[-117166958,82074942]);
AGR.TOC("matff","2L217G1-f9r8bB0.m",[47065598,29939158]);
AGR.TOC("matff","2L217G1-f17r2B0.m",[6911536,-105322369]);
AGR.TOC("matff","2L217G1-f17r4B0.m",[-63603009,22696976]);
AGR.TOC("matff","2L217G1-f17r6B0.m",[-78288000,-95930391]);
AGR.TOC("matff","2L217G1-f17r8B0.m",[36976965,-51146083]);
AGR.TOC("matff","2L217G1-f17r10B0.m",[-106402184,-86725200]);
AGR.TOC("matff","2L217G1-f17r12B0.m",[-128860262,42509507]);
AGR.TOC("matff","2L217G1-f17r14B0.m",[133839744,-115025145]);
AGR.TOC("matff","2L217G1-f17r16B0.m",[112291201,-77293894]);

# 2L217d2
AGR.GRP("lin","L217","2L217d2");
AGR.TOC("matff","2L217d2G1-f3r16B0.m",[6443587,-21386643]);

# L217
AGR.GRP("lin","L217","L217");
AGR.TOC("perm","L217G1-p18B0.m",[-82912537,-44582286]);
AGR.TOC("matff","L217G1-f2r8aB0.m",[56350420,11326923]);
AGR.TOC("matff","L217G1-f2r8bB0.m",[-66251727,-119035891]);
AGR.TOC("matff","L217G1-f2r16aB0.m",[32575162,38548666]);
AGR.TOC("matff","L217G1-f2r48B0.m",[109629411,52173616]);
AGR.TOC("matff","L217G1-f3r16B0.m",[-97474409,89597038]);
AGR.TOC("matff","L217G1-f3r18aB0.m",[89711830,132717007]);
AGR.TOC("matff","L217G1-f8r16bB0.m",[3907726,-34647212]);
AGR.TOC("matff","L217G1-f8r16cB0.m",[56979279,76992993]);
AGR.TOC("matff","L217G1-f8r16dB0.m",[-91570608,-109962938]);
AGR.TOC("matff","L217G1-f9r9aB0.m",[3048714,57103623]);
AGR.TOC("matff","L217G1-f9r9bB0.m",[123383675,-83522426]);
AGR.TOC("matff","L217G1-f9r18bB0.m",[97688817,-88837865]);
AGR.TOC("matff","L217G1-f9r18cB0.m",[88953815,-96918747]);
AGR.TOC("matff","L217G1-f17r3B0.m",[128164355,-54485786]);
AGR.TOC("matff","L217G1-f17r5B0.m",[62752732,26959766]);
AGR.TOC("matff","L217G1-f17r7B0.m",[130133111,7735069]);
AGR.TOC("matff","L217G1-f17r9B0.m",[21224908,-33407977]);
AGR.TOC("matff","L217G1-f17r11B0.m",[26808255,-48153806]);
AGR.TOC("matff","L217G1-f17r13B0.m",[-26821318,-28503130]);
AGR.TOC("matff","L217G1-f17r15B0.m",[112207389,89241698]);
AGR.TOC("matff","L217G1-f17r17B0.m",[11803114,124459896]);
AGR.TOC("matint","L217G1-Zr16aB0.g",[107256525]);
AGR.TOC("matint","L217G1-Zr17B0.g",[1797083]);
AGR.TOC("matint","L217G1-Zr18aB0.g",[-127855891]);
AGR.TOC("matint","L217G1-Zr18dB0.g",[90751802]);
AGR.TOC("matint","L217G1-Zr48B0.g",[78630971]);
AGR.TOC("matalg","L217G1-Ar9aB0.g",[125287525]);
AGR.TOC("matalg","L217G1-Ar9bB0.g",[-115193717]);
AGR.TOC("cyclic","L217G1-cycW1",[-14106864]);
AGR.TOC("cyc2ccl","L217G1cycW1-cclsW1",[71146108]);
AGR.TOC("check","L217G1-check1",[10441786]);

# L217d2
AGR.GRP("lin","L217","L217d2");
AGR.TOC("perm","L217d2G1-p18B0.m",[2840279,5131224]);
AGR.TOC("matff","L217d2G1-f17r3B0.m",[-28835866,-54485786]);

# 2L2173
AGR.GRP("lin","L2173","2L2173");
AGR.TOC("matalg","2L2173G1-Ar174aB0.g",[-129123955]);

# L2173
AGR.GRP("lin","L2173","L2173");
AGR.TOC("matint","L2173G1-Zr173B0.g",[105934329]);
AGR.TOC("matalg","L2173G1-Ar174aB0.g",[-77683382]);
AGR.TOC("maxes","L2173G1-max1W1",[-22144534]);
AGR.TOC("maxes","L2173G1-max2W1",[98771752]);
AGR.TOC("maxes","L2173G1-max3W1",[-71547031]);
AGR.TOC("maxes","L2173G1-max4W1",[130757558]);
AGR.TOC("out","L2173G1-a2W1",[67011312]);

# 2L2179
AGR.GRP("lin","L2179","2L2179");
AGR.TOC("matalg","2L2179G1-Ar180aB0.g",[10497490]);

# L2179
AGR.GRP("lin","L2179","L2179");
AGR.TOC("matint","L2179G1-Zr179B0.g",[81046310]);
AGR.TOC("matalg","L2179G1-Ar180aB0.g",[-16440052]);
AGR.TOC("maxes","L2179G1-max1W1",[109829600]);
AGR.TOC("maxes","L2179G1-max2W1",[-131103847]);
AGR.TOC("maxes","L2179G1-max3W1",[98771752]);
AGR.TOC("maxes","L2179G1-max4W1",[-30556931]);
AGR.TOC("maxes","L2179G1-max5W1",[33600339]);
AGR.TOC("out","L2179G1-a2W1",[18592174]);

# 2L2181
AGR.GRP("lin","L2181","2L2181");
AGR.TOC("matalg","2L2181G1-Ar182aB0.g",[87379586]);

# L2181
AGR.GRP("lin","L2181","L2181");
AGR.TOC("matint","L2181G1-Zr181B0.g",[71734082]);
AGR.TOC("matalg","L2181G1-Ar182aB0.g",[82987358]);
AGR.TOC("maxes","L2181G1-max1W1",[89346661]);
AGR.TOC("maxes","L2181G1-max2W1",[-52742966]);
AGR.TOC("maxes","L2181G1-max3W1",[-131103847]);
AGR.TOC("maxes","L2181G1-max4W1",[50625176]);
AGR.TOC("maxes","L2181G1-max5W1",[74954710]);
AGR.TOC("out","L2181G1-a2W1",[92056087]);

# 2L219
AGR.GRP("lin","L219","2L219");
AGR.TOC("perm","2L219G1-p40B0.m",[-75425328,-81015716]);
AGR.TOC("matff","2L219G1-f19r2B0.m",[-60529181,-81596629]);

# 2L219d2i
AGR.GRP("lin","L219","2L219d2i");
AGR.TOC("matff","2L219d2iG1-f3r20B0.m",[-38183413,93404023]);
AGR.TOC("matff","2L219d2iG1-f5r20B0.m",[-481012,89842831]);
AGR.TOC("matff","2L219d2iG1-f19r2aB0.m",[-60529181,-81596629]);

# L219
AGR.GRP("lin","L219","L219");
AGR.TOC("perm","L219G1-p20B0.m",[24659231,-127711181]);
AGR.TOC("perm","L219G1-p57aB0.m",[-101429737,-69344254]);
AGR.TOC("perm","L219G1-p57bB0.m",[17296078,-64512583]);
AGR.TOC("perm","L219G1-p171B0.m",[39319466,88018783]);
AGR.TOC("perm","L219G1-p190B0.m",[-37790883,-8623862]);
AGR.TOC("matff","L219G1-f2r20aB0.m",[20881578,-27015445]);
AGR.TOC("matff","L219G1-f3r19B0.m",[-94940412,121630950]);
AGR.TOC("matff","L219G1-f4r9aB0.m",[73176383,53415654]);
AGR.TOC("matff","L219G1-f4r9bB0.m",[62934163,70154052]);
AGR.TOC("matff","L219G1-f4r18aB0.m",[-100210374,125716156]);
AGR.TOC("matff","L219G1-f4r18bB0.m",[27209702,-62352810]);
AGR.TOC("matff","L219G1-f5r9aB0.m",[77195259,99472639]);
AGR.TOC("matff","L219G1-f5r9bB0.m",[36693084,17693932]);
AGR.TOC("matff","L219G1-f5r18B0.m",[-31242791,-50234523]);
AGR.TOC("matff","L219G1-f5r20aB0.m",[-119786862,-22803290]);
AGR.TOC("matff","L219G1-f8r20bB0.m",[55505572,-68483928]);
AGR.TOC("matff","L219G1-f8r20cB0.m",[116520881,82160962]);
AGR.TOC("matff","L219G1-f8r20dB0.m",[-81452471,-59801255]);
AGR.TOC("matff","L219G1-f9r9aB0.m",[86818836,71785157]);
AGR.TOC("matff","L219G1-f9r9bB0.m",[58361913,-79182132]);
AGR.TOC("matff","L219G1-f9r18aB0.m",[35351054,69514466]);
AGR.TOC("matff","L219G1-f9r18bB0.m",[95590865,-45009283]);
AGR.TOC("matff","L219G1-f9r18cB0.m",[20882251,106600166]);
AGR.TOC("matff","L219G1-f9r18dB0.m",[-17358616,9069780]);
AGR.TOC("matff","L219G1-f19r3B0.m",[-60856921,103602966]);
AGR.TOC("matff","L219G1-f19r5B0.m",[55888539,-52479113]);
AGR.TOC("matff","L219G1-f19r7B0.m",[-76314715,-97982965]);
AGR.TOC("matff","L219G1-f19r9B0.m",[42106921,-61184509]);
AGR.TOC("matff","L219G1-f19r11B0.m",[102860803,102059262]);
AGR.TOC("matff","L219G1-f19r13B0.m",[-42137490,94275844]);
AGR.TOC("matff","L219G1-f19r15B0.m",[-5968738,31335985]);
AGR.TOC("matff","L219G1-f19r17B0.m",[34260504,95947345]);
AGR.TOC("matff","L219G1-f19r19B0.m",[-8457876,110671936]);
AGR.TOC("matff","L219G1-f125r20bB0.m",[119940297,-57104473]);
AGR.TOC("matff","L219G1-f125r20cB0.m",[-65838906,-95399319]);
AGR.TOC("matff","L219G1-f125r20dB0.m",[-68813039,104603257]);
AGR.TOC("matint","L219G1-Zr18eB0.g",[-25045864]);
AGR.TOC("matint","L219G1-Zr19B0.g",[49324283]);
AGR.TOC("matint","L219G1-Zr20aB0.g",[-16623570]);
AGR.TOC("matint","L219G1-Zr36aB0.g",[-70545514]);
AGR.TOC("cyclic","L219G1-cycW1",[72229979]);
AGR.TOC("cyc2ccl","L219G1cycW1-cclsW1",[28530659]);
AGR.TOC("check","L219G1-check1",[-109615390]);

# L219d2
AGR.GRP("lin","L219","L219d2");
AGR.TOC("perm","L219d2G1-p20B0.m",[32900850,28964096]);
AGR.TOC("perm","L219d2G1-p114B0.m",[12605773,-51667208]);
AGR.TOC("perm","L219d2G1-p171B0.m",[-108133167,51706554]);
AGR.TOC("perm","L219d2G1-p190B0.m",[-88414015,-96889267]);
AGR.TOC("perm","L219d2G1-p285B0.m",[-19098413,-73672204]);
AGR.TOC("matff","L219d2G1-f19r3B0.m",[57976465,-111736354]);
AGR.TOC("cyclic","L219d2G1-cycW1",[-32424274]);
AGR.TOC("cyc2ccl","L219d2G1cycW1-cclsW1",[98016748]);

# 2L2191
AGR.GRP("lin","L2191","2L2191");
AGR.TOC("matalg","2L2191G1-Ar192aB0.g",[-10297209]);

# L2191
AGR.GRP("lin","L2191","L2191");
AGR.TOC("matint","L2191G1-Zr191B0.g",[-91342354]);
AGR.TOC("matalg","L2191G1-Ar192aB0.g",[-102131257]);
AGR.TOC("maxes","L2191G1-max1W1",[130684941]);
AGR.TOC("maxes","L2191G1-max2W1",[36772814]);
AGR.TOC("maxes","L2191G1-max3W1",[98771752]);
AGR.TOC("maxes","L2191G1-max4W1",[-122498485]);
AGR.TOC("maxes","L2191G1-max5W1",[113353462]);
AGR.TOC("maxes","L2191G1-max6W1",[4673722]);
AGR.TOC("maxes","L2191G1-max7W1",[124194537]);
AGR.TOC("out","L2191G1-a2W1",[55431083]);

# 2L2193
AGR.GRP("lin","L2193","2L2193");
AGR.TOC("matalg","2L2193G1-Ar194aB0.g",[73212136]);

# L2193
AGR.GRP("lin","L2193","L2193");
AGR.TOC("matint","L2193G1-Zr193B0.g",[71143513]);
AGR.TOC("matalg","L2193G1-Ar194aB0.g",[121194653]);
AGR.TOC("maxes","L2193G1-max1W1",[40907293]);
AGR.TOC("maxes","L2193G1-max2W1",[98771752]);
AGR.TOC("maxes","L2193G1-max3W1",[-67796260]);
AGR.TOC("maxes","L2193G1-max4W1",[-127210880]);
AGR.TOC("maxes","L2193G1-max5W1",[-118162825]);
AGR.TOC("out","L2193G1-a2W1",[-106805706]);

# 2L2197
AGR.GRP("lin","L2197","2L2197");
AGR.TOC("matalg","2L2197G1-Ar198aB0.g",[73927374]);

# L2197
AGR.GRP("lin","L2197","L2197");
AGR.TOC("matint","L2197G1-Zr197B0.g",[45557225]);
AGR.TOC("matalg","L2197G1-Ar198aB0.g",[39544976]);
AGR.TOC("maxes","L2197G1-max1W1",[-130931367]);
AGR.TOC("maxes","L2197G1-max2W1",[98771752]);
AGR.TOC("maxes","L2197G1-max3W1",[-67796260]);
AGR.TOC("maxes","L2197G1-max4W1",[14286554]);
AGR.TOC("out","L2197G1-a2W1",[130181147]);

# 2L2199
AGR.GRP("lin","L2199","2L2199");
AGR.TOC("matalg","2L2199G1-Ar200aB0.g",[-53439677]);

# L2199
AGR.GRP("lin","L2199","L2199");
AGR.TOC("matint","L2199G1-Zr199B0.g",[-87031562]);
AGR.TOC("matalg","L2199G1-Ar200aB0.g",[47081617]);
AGR.TOC("maxes","L2199G1-max1W1",[-93257757]);
AGR.TOC("maxes","L2199G1-max2W1",[-67796260]);
AGR.TOC("maxes","L2199G1-max3W1",[117428427]);
AGR.TOC("maxes","L2199G1-max4W1",[62034043]);
AGR.TOC("maxes","L2199G1-max5W1",[-116874112]);
AGR.TOC("maxes","L2199G1-max6W1",[-119648840]);
AGR.TOC("maxes","L2199G1-max7W1",[-48148985]);
AGR.TOC("out","L2199G1-a2W1",[76695252]);

# 2L2211
AGR.GRP("lin","L2211","2L2211");
AGR.TOC("matalg","2L2211G1-Ar212aB0.g",[18814386]);

# L2211
AGR.GRP("lin","L2211","L2211");
AGR.TOC("matint","L2211G1-Zr211B0.g",[-45535114]);
AGR.TOC("matalg","L2211G1-Ar212aB0.g",[29682330]);
AGR.TOC("maxes","L2211G1-max1W1",[-108408867]);
AGR.TOC("maxes","L2211G1-max2W1",[-52742966]);
AGR.TOC("maxes","L2211G1-max3W1",[116070154]);
AGR.TOC("maxes","L2211G1-max4W1",[23166390]);
AGR.TOC("maxes","L2211G1-max5W1",[122228493]);
AGR.TOC("out","L2211G1-a2W1",[120263037]);

# 2L2223
AGR.GRP("lin","L2223","2L2223");
AGR.TOC("matalg","2L2223G1-Ar224aB0.g",[-116181226]);

# L2223
AGR.GRP("lin","L2223","L2223");
AGR.TOC("matint","L2223G1-Zr223B0.g",[-55905370]);
AGR.TOC("matalg","L2223G1-Ar224aB0.g",[41299812]);
AGR.TOC("maxes","L2223G1-max1W1",[113347374]);
AGR.TOC("maxes","L2223G1-max2W1",[98771752]);
AGR.TOC("maxes","L2223G1-max3W1",[-69257965]);
AGR.TOC("maxes","L2223G1-max4W1",[-117428229]);
AGR.TOC("maxes","L2223G1-max5W1",[-132949589]);
AGR.TOC("out","L2223G1-a2W1",[52038676]);

# 2L2227
AGR.GRP("lin","L2227","2L2227");
AGR.TOC("matalg","2L2227G1-Ar228aB0.g",[-75199876]);

# L2227
AGR.GRP("lin","L2227","L2227");
AGR.TOC("matint","L2227G1-Zr227B0.g",[-105151178]);
AGR.TOC("matalg","L2227G1-Ar228aB0.g",[91148488]);
AGR.TOC("maxes","L2227G1-max1W1",[-105429437]);
AGR.TOC("maxes","L2227G1-max2W1",[98771752]);
AGR.TOC("maxes","L2227G1-max3W1",[56925867]);
AGR.TOC("maxes","L2227G1-max4W1",[114147158]);
AGR.TOC("out","L2227G1-a2W1",[-17717185]);

# 2L2229
AGR.GRP("lin","L2229","2L2229");
AGR.TOC("matalg","2L2229G1-Ar230aB0.g",[-18137049]);

# L2229
AGR.GRP("lin","L2229","L2229");
AGR.TOC("matint","L2229G1-Zr229B0.g",[69447815]);
AGR.TOC("matalg","L2229G1-Ar230aB0.g",[21643362]);
AGR.TOC("maxes","L2229G1-max1W1",[54102063]);
AGR.TOC("maxes","L2229G1-max2W1",[117428427]);
AGR.TOC("maxes","L2229G1-max3W1",[-116933033]);
AGR.TOC("maxes","L2229G1-max4W1",[-125460422]);
AGR.TOC("maxes","L2229G1-max5W1",[67274427]);
AGR.TOC("out","L2229G1-a2W1",[-29606974]);

# 2L223
AGR.GRP("lin","L223","2L223");
AGR.TOC("matff","2L223G1-f23r2B0.m",[20525409,47643517]);

# 2L223d2i
AGR.GRP("lin","L223","2L223d2i");
AGR.TOC("matff","2L223d2iG1-f23r2B0.m",[-88491394,61181965]);

# L223
AGR.GRP("lin","L223","L223");
AGR.TOC("perm","L223G1-p24B0.m",[76120275,68802602]);
AGR.TOC("matff","L223G1-f2r11aB0.m",[127094156,70571462]);
AGR.TOC("matff","L223G1-f2r11bB0.m",[5360375,129551938]);
AGR.TOC("matff","L223G1-f2r22B0.m",[-50133270,-13738710]);
AGR.TOC("matff","L223G1-f3r22aB0.m",[-77636210,64274321]);
AGR.TOC("matff","L223G1-f11r23B0.m",[42514454,-134050268]);
AGR.TOC("matff","L223G1-f23r3B0.m",[42791262,95823127]);
AGR.TOC("matff","L223G1-f23r5B0.m",[54370750,-24744185]);
AGR.TOC("matff","L223G1-f23r7B0.m",[-132549125,-25900974]);
AGR.TOC("matff","L223G1-f23r9B0.m",[92736657,-6223120]);
AGR.TOC("matff","L223G1-f23r11B0.m",[-59046279,16148792]);
AGR.TOC("matff","L223G1-f23r13B0.m",[-32965346,-4509189]);
AGR.TOC("matff","L223G1-f23r15B0.m",[54984976,-41337166]);
AGR.TOC("matff","L223G1-f23r17B0.m",[61549106,35129088]);
AGR.TOC("matff","L223G1-f23r19B0.m",[-83435925,-110939099]);
AGR.TOC("matff","L223G1-f23r21B0.m",[52870456,24920826]);
AGR.TOC("matff","L223G1-f23r23B0.m",[-9561815,-92041134]);
AGR.TOC("matff","L223G1-f32r24aB0.m",[21647014,14511678]);
AGR.TOC("matff","L223G1-f32r24bB0.m",[-87307691,-46855468]);
AGR.TOC("matff","L223G1-f32r24cB0.m",[-5789075,107108233]);
AGR.TOC("matff","L223G1-f32r24dB0.m",[-9505617,76119520]);
AGR.TOC("matff","L223G1-f32r24eB0.m",[-121899485,-39499865]);
AGR.TOC("matint","L223G1-Zr22aB0.g",[5829416]);
AGR.TOC("matint","L223G1-Zr22bB0.g",[39581756]);
AGR.TOC("matint","L223G1-Zr22cB0.g",[-5464384]);
AGR.TOC("matint","L223G1-Zr23B0.g",[-71592096]);
AGR.TOC("matalg","L223G1-Ar24aB0.g",[-94070094]);
AGR.TOC("matalg","L223G1-Ar24bB0.g",[-86537748]);
AGR.TOC("matalg","L223G1-Ar24cB0.g",[-109907336]);
AGR.TOC("matalg","L223G1-Ar24dB0.g",[1617625]);
AGR.TOC("matalg","L223G1-Ar24eB0.g",[86827308]);
AGR.TOC("cyclic","L223G1-cycW1",[-23018766]);
AGR.TOC("cyc2ccl","L223G1cycW1-cclsW1",[79564962]);
AGR.TOC("out","L223G1-a2W1",[-11046668]);
AGR.TOC("check","L223G1-check1",[117306255]);

# L223d2
AGR.GRP("lin","L223","L223d2");
AGR.TOC("matff","L223d2G1-f2r22aB0.m",[36563733,98146872]);
AGR.TOC("matff","L223d2G1-f23r3aB0.m",[-9004677,95823127]);
AGR.TOC("cyclic","L223d2G1-cycW1",[-117792659]);
AGR.TOC("cyc2ccl","L223d2G1cycW1-cclsW1",[-132898044]);

# 2L2233
AGR.GRP("lin","L2233","2L2233");
AGR.TOC("matalg","2L2233G1-Ar234aB0.g",[12717719]);

# L2233
AGR.GRP("lin","L2233","L2233");
AGR.TOC("matint","L2233G1-Zr233B0.g",[23663299]);
AGR.TOC("matalg","L2233G1-Ar234aB0.g",[-98686418]);
AGR.TOC("maxes","L2233G1-max1W1",[-18098890]);
AGR.TOC("maxes","L2233G1-max2W1",[-67796260]);
AGR.TOC("maxes","L2233G1-max3W1",[75295270]);
AGR.TOC("maxes","L2233G1-max4W1",[19437309]);
AGR.TOC("maxes","L2233G1-max5W1",[102198882]);
AGR.TOC("out","L2233G1-a2W1",[-76737931]);

# 2L2239
AGR.GRP("lin","L2239","2L2239");
AGR.TOC("matalg","2L2239G1-Ar240aB0.g",[53428341]);

# L2239
AGR.GRP("lin","L2239","L2239");
AGR.TOC("matint","L2239G1-Zr239B0.g",[-49774087]);
AGR.TOC("matalg","L2239G1-Ar240aB0.g",[-35140575]);
AGR.TOC("maxes","L2239G1-max1W1",[68942726]);
AGR.TOC("maxes","L2239G1-max2W1",[-15392302]);
AGR.TOC("maxes","L2239G1-max3W1",[98771752]);
AGR.TOC("maxes","L2239G1-max4W1",[-16533216]);
AGR.TOC("maxes","L2239G1-max5W1",[26047827]);
AGR.TOC("maxes","L2239G1-max6W1",[-98880500]);
AGR.TOC("maxes","L2239G1-max7W1",[-87747962]);
AGR.TOC("out","L2239G1-a2W1",[-31181278]);

# 2L2241
AGR.GRP("lin","L2241","2L2241");
AGR.TOC("matalg","2L2241G1-Ar242aB0.g",[22113801]);

# L2241
AGR.GRP("lin","L2241","L2241");
AGR.TOC("matint","L2241G1-Zr241B0.g",[6537985]);
AGR.TOC("matalg","L2241G1-Ar242aB0.g",[365622]);
AGR.TOC("maxes","L2241G1-max1W1",[127178033]);
AGR.TOC("maxes","L2241G1-max2W1",[117428427]);
AGR.TOC("maxes","L2241G1-max3W1",[-94813412]);
AGR.TOC("maxes","L2241G1-max4W1",[-116097452]);
AGR.TOC("maxes","L2241G1-max5W1",[-118162825]);
AGR.TOC("maxes","L2241G1-max6W1",[41454643]);
AGR.TOC("maxes","L2241G1-max7W1",[-46947725]);
AGR.TOC("out","L2241G1-a2W1",[-35280200]);

# L225
AGR.GRP("lin","L225","L225");
AGR.TOC("check","L225G1-check1",[-20561499]);

# 2L227
AGR.GRP("lin","L227","2L227");
AGR.TOC("matff","2L227G1-f27r2aB0.m",[75706202,42063428]);
AGR.TOC("matff","2L227G1-f27r2bB0.m",[75706202,-32514381]);
AGR.TOC("matff","2L227G1-f27r2cB0.m",[75706202,-90015011]);

# L227
AGR.GRP("lin","L227","L227");
AGR.TOC("perm","L227G1-p28B0.m",[80361327,10779391]);
AGR.TOC("matff","L227G1-f3r27B0.m",[-64273145,112755293]);
AGR.TOC("matff","L227G1-f4r13aB0.m",[-121151895,113499759]);
AGR.TOC("matff","L227G1-f4r13bB0.m",[-12358225,-97200516]);
AGR.TOC("matff","L227G1-f7r26B0.m",[81983579,-62100947]);
AGR.TOC("matff","L227G1-f13r27B0.m",[102008149,20812941]);
AGR.TOC("matff","L227G1-f27r3aB0.m",[-27948298,-12834033]);
AGR.TOC("matint","L227G1-Zr26gB0.g",[-108736083]);
AGR.TOC("matint","L227G1-Zr27B0.g",[81578255]);
AGR.TOC("matint","L227G1-Zr78aB0.g",[-94962840]);
AGR.TOC("matalg","L227G1-Ar13aB0.g",[-42975513]);
AGR.TOC("matalg","L227G1-Ar13bB0.g",[4935682]);
AGR.TOC("matalg","L227G1-Ar28aB0.g",[86924695]);
AGR.TOC("matalg","L227G1-Ar28bB0.g",[123708070]);
AGR.TOC("matalg","L227G1-Ar28cB0.g",[44486067]);
AGR.TOC("matalg","L227G1-Ar28dB0.g",[-1314465]);
AGR.TOC("matalg","L227G1-Ar28eB0.g",[97815284]);
AGR.TOC("matalg","L227G1-Ar28fB0.g",[32000090]);
AGR.TOC("cyclic","L227G1-cycW1",[67164295]);
AGR.TOC("cyc2ccl","L227G1cycW1-cclsW1",[-63635297]);
AGR.TOC("check","L227G1-check1",[80991801]);

# 2L229
AGR.GRP("lin","L229","2L229");
AGR.TOC("matff","2L229G1-f29r2B0.m",[-125331227,-113293998]);

# L229
AGR.GRP("lin","L229","L229");
AGR.TOC("perm","L229G1-p30B0.m",[-59680209,-19128626]);
AGR.TOC("matff","L229G1-f3r28aB0.m",[-27683415,120560509]);
AGR.TOC("matff","L229G1-f4r14aB0.m",[24400041,93494808]);
AGR.TOC("matff","L229G1-f4r14bB0.m",[-8336532,-128257369]);
AGR.TOC("matff","L229G1-f5r28bB0.m",[11970703,117973494]);
AGR.TOC("matff","L229G1-f7r29B0.m",[7912619,-57977568]);
AGR.TOC("matff","L229G1-f29r3B0.m",[112522078,-128962994]);
AGR.TOC("matff","L229G1-f29r5B0.m",[52274017,2980410]);
AGR.TOC("matff","L229G1-f29r7B0.m",[-3967008,40635278]);
AGR.TOC("matff","L229G1-f29r9B0.m",[6327751,-26682292]);
AGR.TOC("matff","L229G1-f29r11B0.m",[88346290,35523613]);
AGR.TOC("matff","L229G1-f29r13B0.m",[-57278166,-40446496]);
AGR.TOC("matff","L229G1-f29r15B0.m",[-13769556,-20566652]);
AGR.TOC("matff","L229G1-f29r17B0.m",[-26087738,-36837746]);
AGR.TOC("matff","L229G1-f29r19B0.m",[-71985042,-103709323]);
AGR.TOC("matff","L229G1-f29r21B0.m",[-53552726,-52380600]);
AGR.TOC("matff","L229G1-f29r23B0.m",[-119150534,38421866]);
AGR.TOC("matff","L229G1-f29r25B0.m",[-36299723,132251793]);
AGR.TOC("matff","L229G1-f29r27B0.m",[100195319,74359202]);
AGR.TOC("matff","L229G1-f29r29B0.m",[25221275,-121973737]);
AGR.TOC("matint","L229G1-Zr28aB0.g",[-14464513]);
AGR.TOC("matint","L229G1-Zr29B0.g",[108424046]);
AGR.TOC("matint","L229G1-Zr30gB0.g",[89059266]);
AGR.TOC("matint","L229G1-Zr56B0.g",[47191282]);
AGR.TOC("matint","L229G1-Zr112B0.g",[-21499082]);
AGR.TOC("matalg","L229G1-Ar30aB0.g",[36512456]);
AGR.TOC("matalg","L229G1-Ar30bB0.g",[80372223]);
AGR.TOC("matalg","L229G1-Ar30cB0.g",[-10466386]);
AGR.TOC("matalg","L229G1-Ar30dB0.g",[-19659925]);
AGR.TOC("matalg","L229G1-Ar30eB0.g",[-97848110]);
AGR.TOC("matalg","L229G1-Ar30fB0.g",[-52616644]);
AGR.TOC("cyclic","L229G1-cycW1",[82677982]);
AGR.TOC("cyc2ccl","L229G1cycW1-cclsW1",[21083482]);
AGR.TOC("check","L229G1-check1",[-111997689]);

# 2L231
AGR.GRP("lin","L231","2L231");
AGR.TOC("matff","2L231G1-f5r16aB0.m",[-81178967,94350757]);
AGR.TOC("matff","2L231G1-f31r2B0.m",[-80955541,-50941493]);
AGR.TOC("matalg","2L231G1-Ar32aB0.g",[-28048748]);

# L231
AGR.GRP("lin","L231","L231");
AGR.TOC("perm","L231G1-p32B0.m",[-106514309,-46309048]);
AGR.TOC("matff","L231G1-f2r15aB0.m",[-97111509,129903836]);
AGR.TOC("matff","L231G1-f2r15bB0.m",[-69292298,-50625580]);
AGR.TOC("matff","L231G1-f2r32B0.m",[-35052800,908728]);
AGR.TOC("matff","L231G1-f3r31B0.m",[-96095478,-95643115]);
AGR.TOC("matff","L231G1-f4r32bB0.m",[-104132881,74423793]);
AGR.TOC("matff","L231G1-f4r32cB0.m",[128095051,-12635082]);
AGR.TOC("matff","L231G1-f5r31B0.m",[-14484728,-112300853]);
AGR.TOC("matff","L231G1-f16r32dB0.m",[78688671,-97781633]);
AGR.TOC("matff","L231G1-f16r32eB0.m",[-70334799,-32855008]);
AGR.TOC("matff","L231G1-f16r32fB0.m",[115548558,62487969]);
AGR.TOC("matff","L231G1-f16r32gB0.m",[64981303,26938370]);
AGR.TOC("matff","L231G1-f31r3B0.m",[-22989219,-87408481]);
AGR.TOC("matff","L231G1-f31r31B0.m",[-120420305,-62570553]);
AGR.TOC("matint","L231G1-Zr30aB0.g",[93007295]);
AGR.TOC("matint","L231G1-Zr30hB0.g",[-59663303]);
AGR.TOC("matint","L231G1-Zr31B0.g",[13607483]);
AGR.TOC("matint","L231G1-Zr32aB0.g",[-34239155]);
AGR.TOC("matint","L231G1-Zr60B0.g",[-27228077]);
AGR.TOC("matint","L231G1-Zr120B0.g",[82286628]);
AGR.TOC("matalg","L231G1-Ar32aB0.g",[-62988969]);
AGR.TOC("matalg","L231G1-Ar32bB0.g",[-26331784]);
AGR.TOC("matalg","L231G1-Ar32cB0.g",[-60422937]);
AGR.TOC("matalg","L231G1-Ar32dB0.g",[19214858]);
AGR.TOC("matalg","L231G1-Ar32eB0.g",[69092363]);
AGR.TOC("matalg","L231G1-Ar32fB0.g",[-82047763]);
AGR.TOC("matalg","L231G1-Ar32gB0.g",[-119324733]);
AGR.TOC("cyclic","L231G1-cycW1",[90904383]);
AGR.TOC("cyc2ccl","L231G1cycW1-cclsW1",[-82679199]);
AGR.TOC("check","L231G1-check1",[96645892]);

# L231d2
AGR.GRP("lin","L231","L231d2");
AGR.TOC("matff","L231d2G1-f2r30B0.m",[51861420,36234284]);

# L232
AGR.GRP("lin","L232","L232");
AGR.TOC("perm","L232G1-p33B0.m",[-70610589,-23599884]);
AGR.TOC("perm","L232G1-p496B0.m",[45274093,56723380]);
AGR.TOC("perm","L232G1-p528B0.m",[-127338279,-48095320]);
AGR.TOC("matff","L232G1-f3r31aB0.m",[-31088571,40473858]);
AGR.TOC("matff","L232G1-f11r31bB0.m",[-52046501,89586769]);
AGR.TOC("matff","L232G1-f31r32B0.m",[-74620170,83684745]);
AGR.TOC("matff","L232G1-f32r2aB0.m",[-109179637,120506087]);
AGR.TOC("matint","L232G1-Zr31aB0.g",[27710295]);
AGR.TOC("matint","L232G1-Zr32B0.g",[111975507]);
AGR.TOC("matint","L232G1-Zr155B0.g",[65682418]);
AGR.TOC("matint","L232G1-Zr310B0.g",[63940929]);
AGR.TOC("matalg","L232G1-Ar33aB0.g",[-111213769]);
AGR.TOC("matalg","L232G1-Ar33bB0.g",[22767814]);
AGR.TOC("matalg","L232G1-Ar33cB0.g",[-85912419]);
AGR.TOC("matalg","L232G1-Ar33dB0.g",[-44472014]);
AGR.TOC("matalg","L232G1-Ar33eB0.g",[-15557684]);
AGR.TOC("matalg","L232G1-Ar33fB0.g",[-20780673]);
AGR.TOC("matalg","L232G1-Ar33gB0.g",[42896350]);
AGR.TOC("matalg","L232G1-Ar33hB0.g",[-81704627]);
AGR.TOC("matalg","L232G1-Ar33iB0.g",[41774250]);
AGR.TOC("matalg","L232G1-Ar33jB0.g",[-56211343]);
AGR.TOC("matalg","L232G1-Ar33kB0.g",[-26257869]);
AGR.TOC("matalg","L232G1-Ar33lB0.g",[18695087]);
AGR.TOC("matalg","L232G1-Ar33mB0.g",[111516653]);
AGR.TOC("matalg","L232G1-Ar33nB0.g",[85174962]);
AGR.TOC("matalg","L232G1-Ar33oB0.g",[89580754]);
AGR.TOC("maxes","L232G1-max1W1",[-56055657]);
AGR.TOC("maxes","L232G1-max1W2",[-39704409]);
AGR.TOC("maxes","L232G1-max2W1",[-74379041]);
AGR.TOC("maxes","L232G1-max3W1",[42337161]);
AGR.TOC("cyclic","L232G1-cycW1",[-108617330]);
AGR.TOC("cyc2ccl","L232G1cycW1-cclsW1",[-13687969]);
AGR.TOC("out","L232G1-a5W1",[4839686]);
AGR.TOC("check","L232G1-check1",[96645892]);
AGR.TOC("pres","L232G1-P1",[16857565]);

# L232d5
AGR.GRP("lin","L232","L232d5");
AGR.TOC("perm","L232d5G1-p33B0.m",[-68814625,-109729061]);
AGR.TOC("perm","L232d5G1-p496B0.m",[-105897021,66623301]);
AGR.TOC("perm","L232d5G1-p528B0.m",[-63593694,-4668264]);
AGR.TOC("matff","L232d5G1-f2r10B0.m",[-123808131,-66336957]);
AGR.TOC("matff","L232d5G1-f2r20aB0.m",[-15600981,-113963396]);
AGR.TOC("matff","L232d5G1-f2r20bB0.m",[47088464,101469067]);
AGR.TOC("matff","L232d5G1-f2r32B0.m",[16902110,85940192]);
AGR.TOC("matff","L232d5G1-f2r40aB0.m",[-23723692,52369402]);
AGR.TOC("matff","L232d5G1-f2r40bB0.m",[37826496,-71703658]);
AGR.TOC("matff","L232d5G1-f2r80B0.m",[-114768504,120819740]);
AGR.TOC("maxes","L232d5G1-max1W1",[-52518619]);
AGR.TOC("maxes","L232d5G1-max2W1",[-127703617]);
AGR.TOC("maxes","L232d5G1-max2W2",[-57343816]);
AGR.TOC("maxes","L232d5G1-max3W1",[-101607447]);
AGR.TOC("maxes","L232d5G1-max3W2",[86690101]);
AGR.TOC("maxes","L232d5G1-max4W1",[108007369]);
AGR.TOC("maxes","L232d5G1-max4W2",[-106959951]);
AGR.TOC("cyclic","L232d5G1-cycW1",[-32484246]);
AGR.TOC("cyc2ccl","L232d5G1cycW1-cclsW1",[-12705239]);
AGR.TOC("pres","L232d5G1-P1",[496753]);

# 2L237
AGR.GRP("lin","L237","2L237");
AGR.TOC("matalg","2L237G1-Ar38aB0.g",[33468955]);

# L237
AGR.GRP("lin","L237","L237");
AGR.TOC("matint","L237G1-Zr37B0.g",[100462660]);
AGR.TOC("matalg","L237G1-Ar38aB0.g",[116545177]);
AGR.TOC("maxes","L237G1-max1W1",[-112251965]);
AGR.TOC("maxes","L237G1-max2W1",[10136136]);
AGR.TOC("maxes","L237G1-max3W1",[116070154]);
AGR.TOC("maxes","L237G1-max4W1",[-119731353]);
AGR.TOC("out","L237G1-a2W1",[86831153]);

# 2L241
AGR.GRP("lin","L241","2L241");
AGR.TOC("matalg","2L241G1-Ar42aB0.g",[104729683]);

# L241
AGR.GRP("lin","L241","L241");
AGR.TOC("matint","L241G1-Zr41B0.g",[-99645838]);
AGR.TOC("matalg","L241G1-Ar42aB0.g",[24947099]);
AGR.TOC("maxes","L241G1-max1W1",[125471130]);
AGR.TOC("maxes","L241G1-max2W1",[123151682]);
AGR.TOC("maxes","L241G1-max3W1",[-122498485]);
AGR.TOC("maxes","L241G1-max4W1",[1635502]);
AGR.TOC("maxes","L241G1-max5W1",[-67796260]);
AGR.TOC("maxes","L241G1-max6W1",[27978879]);
AGR.TOC("maxes","L241G1-max7W1",[57715274]);
AGR.TOC("out","L241G1-a2W1",[-56097386]);

# 2L243
AGR.GRP("lin","L243","2L243");
AGR.TOC("matalg","2L243G1-Ar44aB0.g",[128833873]);

# L243
AGR.GRP("lin","L243","L243");
AGR.TOC("matint","L243G1-Zr43B0.g",[44941007]);
AGR.TOC("matalg","L243G1-Ar44aB0.g",[-95515231]);
AGR.TOC("maxes","L243G1-max1W1",[13335009]);
AGR.TOC("maxes","L243G1-max2W1",[98771752]);
AGR.TOC("maxes","L243G1-max3W1",[117428427]);
AGR.TOC("maxes","L243G1-max4W1",[-9461404]);
AGR.TOC("out","L243G1-a2W1",[-10085270]);

# 2L247
AGR.GRP("lin","L247","2L247");
AGR.TOC("matalg","2L247G1-Ar48aB0.g",[-133856404]);

# L247
AGR.GRP("lin","L247","L247");
AGR.TOC("matint","L247G1-Zr47B0.g",[-93776649]);
AGR.TOC("matalg","L247G1-Ar48aB0.g",[31045833]);
AGR.TOC("maxes","L247G1-max1W1",[-21036514]);
AGR.TOC("maxes","L247G1-max2W1",[-24594494]);
AGR.TOC("maxes","L247G1-max3W1",[78402499]);
AGR.TOC("maxes","L247G1-max4W1",[-69820517]);
AGR.TOC("maxes","L247G1-max5W1",[-64733339]);
AGR.TOC("out","L247G1-a2W1",[-106932889]);

# 2L249
AGR.GRP("lin","L249","2L249");
AGR.TOC("matff","2L249G1-f49r2aB0.m",[-77738721,120171565]);
AGR.TOC("matff","2L249G1-f49r2bB0.m",[24508966,120171565]);

# L249
AGR.GRP("lin","L249","L249");
AGR.TOC("perm","L249G1-p50B0.m",[-91986412,-11622404]);
AGR.TOC("perm","L249G1-p175aB0.m",[82820976,-52998298]);
AGR.TOC("perm","L249G1-p175bB0.m",[-3702127,92475894]);
AGR.TOC("perm","L249G1-p980aB0.m",[-111963204,92359707]);
AGR.TOC("perm","L249G1-p980bB0.m",[-38368951,18194715]);
AGR.TOC("perm","L249G1-p1176B0.m",[63754546,24318233]);
AGR.TOC("perm","L249G1-p1225B0.m",[43354204,-52302880]);
AGR.TOC("matff","L249G1-f7r4B0.m",[-122976295,97785542]);
AGR.TOC("matff","L249G1-f49r3aB0.m",[91372809,-5684836]);
AGR.TOC("matff","L249G1-f49r3bB0.m",[-94098923,-5684836]);

# 2L253
AGR.GRP("lin","L253","2L253");
AGR.TOC("matalg","2L253G1-Ar54aB0.g",[-8928569]);

# L253
AGR.GRP("lin","L253","L253");
AGR.TOC("matint","L253G1-Zr53B0.g",[-57528958]);
AGR.TOC("matalg","L253G1-Ar54aB0.g",[115889911]);
AGR.TOC("maxes","L253G1-max1W1",[-7949675]);
AGR.TOC("maxes","L253G1-max2W1",[98771752]);
AGR.TOC("maxes","L253G1-max3W1",[-24016757]);
AGR.TOC("maxes","L253G1-max4W1",[-116097452]);
AGR.TOC("out","L253G1-a2W1",[94828721]);

# 2L259
AGR.GRP("lin","L259","2L259");
AGR.TOC("matalg","2L259G1-Ar60aB0.g",[-38231059]);

# L259
AGR.GRP("lin","L259","L259");
AGR.TOC("matint","L259G1-Zr59B0.g",[96414974]);
AGR.TOC("matalg","L259G1-Ar60aB0.g",[-119040621]);
AGR.TOC("maxes","L259G1-max1W1",[-34200159]);
AGR.TOC("maxes","L259G1-max2W1",[-39026047]);
AGR.TOC("maxes","L259G1-max3W1",[125670029]);
AGR.TOC("maxes","L259G1-max4W1",[42071166]);
AGR.TOC("maxes","L259G1-max5W1",[98771752]);
AGR.TOC("out","L259G1-a2W1",[5441557]);

# 2L261
AGR.GRP("lin","L261","2L261");
AGR.TOC("matalg","2L261G1-Ar62aB0.g",[-65154804]);

# L261
AGR.GRP("lin","L261","L261");
AGR.TOC("matint","L261G1-Zr61B0.g",[-28535708]);
AGR.TOC("matalg","L261G1-Ar62aB0.g",[13639090]);
AGR.TOC("maxes","L261G1-max1W1",[-113761705]);
AGR.TOC("maxes","L261G1-max2W1",[-29424071]);
AGR.TOC("maxes","L261G1-max3W1",[-55103260]);
AGR.TOC("maxes","L261G1-max4W1",[5504545]);
AGR.TOC("maxes","L261G1-max5W1",[61663348]);
AGR.TOC("out","L261G1-a2W1",[-73494788]);

# L264
AGR.GRP("lin","L264","L264");
AGR.TOC("matint","L264G1-Zr64B0.g",[3637152]);
AGR.TOC("matalg","L264G1-Ar65aB0.g",[-74990346]);

# 2L267
AGR.GRP("lin","L267","2L267");
AGR.TOC("matalg","2L267G1-Ar68aB0.g",[-119110097]);

# L267
AGR.GRP("lin","L267","L267");
AGR.TOC("matint","L267G1-Zr67B0.g",[-31103119]);
AGR.TOC("matalg","L267G1-Ar68aB0.g",[50464254]);
AGR.TOC("maxes","L267G1-max1W1",[13301311]);
AGR.TOC("maxes","L267G1-max2W1",[98771752]);
AGR.TOC("maxes","L267G1-max3W1",[-69257965]);
AGR.TOC("maxes","L267G1-max4W1",[94646780]);
AGR.TOC("out","L267G1-a2W1",[-61305413]);

# 2L27
AGR.GRP("lin","L27","2L27");
AGR.TOC("perm","2L27G1-p16B0.m",[18937788,101534527]);
AGR.TOC("perm","2L27G1-p48B0.m",[50784854,-62607311]);
AGR.TOC("perm","2L27G1-p112B0.m",[23813295,-74617714]);
AGR.TOC("perm","2L27G1-p336B0.m",[101513021,-12129824]);
AGR.TOC("matff","2L27G1-f3r8B0.m",[-85360600,-64362510]);
AGR.TOC("matff","2L27G1-f3r12B0.m",[-56959780,82402903]);
AGR.TOC("matff","2L27G1-f7r2B0.m",[-72031738,-39354210]);
AGR.TOC("matff","2L27G1-f7r4B0.m",[21980736,12031682]);
AGR.TOC("matff","2L27G1-f7r6B0.m",[91729598,73771373]);
AGR.TOC("matff","2L27G1-f9r4aB0.m",[-69280753,99960906]);
AGR.TOC("matff","2L27G1-f9r4bB0.m",[-69280753,29931299]);
AGR.TOC("matff","2L27G1-f9r6aB0.m",[-117080397,-39431188]);
AGR.TOC("matff","2L27G1-f9r6bB0.m",[-117080397,-27343019]);
AGR.TOC("pres","2L27G1-P1",[-134105252]);

# 2L27d2
AGR.GRP("lin","L27","2L27d2");
AGR.TOC("perm","2L27d2G1-p32B0.m",[59442930,-77912855]);
AGR.TOC("perm","2L27d2G1-p96B0.m",[-118100123,122469431]);
AGR.TOC("perm","2L27d2G1-p224B0.m",[52859140,-112075309]);
AGR.TOC("perm","2L27d2G1-p672B0.m",[32144421,-129823791]);

# 2L27d2i
AGR.GRP("lin","L27","2L27d2i");
AGR.TOC("perm","2L27d2iG1-p16aB0.m",[96723553,17491636]);
AGR.TOC("perm","2L27d2iG1-p16bB0.m",[-130035598,-86840059]);
AGR.TOC("perm","2L27d2iG1-p32B0.m",[67977434,-131909209]);
AGR.TOC("perm","2L27d2iG1-p48aB0.m",[3733480,-129643461]);
AGR.TOC("perm","2L27d2iG1-p48bB0.m",[81498658,81743050]);
AGR.TOC("perm","2L27d2iG1-p96B0.m",[107847702,7110135]);
AGR.TOC("perm","2L27d2iG1-p112aB0.m",[32537100,87239194]);
AGR.TOC("perm","2L27d2iG1-p112bB0.m",[121272550,43905256]);
AGR.TOC("perm","2L27d2iG1-p224B0.m",[27253918,-71331726]);
AGR.TOC("perm","2L27d2iG1-p336B0.m",[38024782,-77639069]);
AGR.TOC("perm","2L27d2iG1-p672B0.m",[46016725,81318152]);

# L27
AGR.GRP("lin","L27","L27");
AGR.TOC("perm","L27G1-p7aB0.m",[49217095,41912584]);
AGR.TOC("perm","L27G1-p7bB0.m",[80135519,-49134850]);
AGR.TOC("perm","L27G1-p8B0.m",[-23286895,26136506]);
AGR.TOC("perm","L27G1-p14aB0.m",[88769167,-127152366]);
AGR.TOC("perm","L27G1-p14bB0.m",[106114946,-82319708]);
AGR.TOC("perm","L27G1-p21B0.m",[-34366470,119619994]);
AGR.TOC("perm","L27G1-p24B0.m",[21098421,64062395]);
AGR.TOC("perm","L27G1-p28B0.m",[13997879,-1537989]);
AGR.TOC("perm","L27G1-p42aB0.m",[95380373,-13080864]);
AGR.TOC("perm","L27G1-p42bB0.m",[-47718257,-110106684]);
AGR.TOC("perm","L27G1-p42cB0.m",[-89859222,78718510]);
AGR.TOC("perm","L27G1-p56B0.m",[-36452036,97078584]);
AGR.TOC("perm","L27G1-p84B0.m",[-105372602,132791931]);
AGR.TOC("perm","L27G1-p168B0.m",[-48007814,133832626]);
AGR.TOC("matff","L27G1-f2r3aB0.m",[57914838,26346105]);
AGR.TOC("matff","L27G1-f2r3bB0.m",[-119253757,26346105]);
AGR.TOC("matff","L27G1-f2r8B0.m",[126279998,17700283]);
AGR.TOC("matff","L27G1-f3r6aB0.m",[121874030,-17226445]);
AGR.TOC("matff","L27G1-f3r6bB0.m",[100466148,3567420]);
AGR.TOC("matff","L27G1-f3r7B0.m",[15516596,-73787096]);
AGR.TOC("matff","L27G1-f7r3B0.m",[29749878,-61433424]);
AGR.TOC("matff","L27G1-f7r5B0.m",[-62739065,-104202378]);
AGR.TOC("matff","L27G1-f7r7B0.m",[-133836350,7636822]);
AGR.TOC("matff","L27G1-f9r3aB0.m",[44653245,-122746370]);
AGR.TOC("matff","L27G1-f9r3bB0.m",[44653245,-64615968]);
AGR.TOC("matint","L27G1-Zr6aB0.g",[-113349301]);
AGR.TOC("matint","L27G1-Zr6bB0.g",[107121157]);
AGR.TOC("matint","L27G1-Zr7B0.g",[-123920082]);
AGR.TOC("matint","L27G1-Zr8B0.g",[-31448454]);
AGR.TOC("matalg","L27G1-Ar3aB0.g",[-66771044]);
AGR.TOC("matalg","L27G1-Ar3bB0.g",[-49583138]);
AGR.TOC("maxes","L27G1-max1W1",[-112559531]);
AGR.TOC("maxes","L27G1-max1W2",[4811487]);
AGR.TOC("maxes","L27G1-max1W3",[22686636]);
AGR.TOC("maxes","L27G1-max2W1",[38083598]);
AGR.TOC("maxes","L27G1-max2W2",[-79295356]);
AGR.TOC("maxes","L27G1-max2W3",[109910985]);
AGR.TOC("maxes","L27G1-max3W1",[16690830]);
AGR.TOC("maxes","L27G1-max3W2",[37289573]);
AGR.TOC("maxes","L27G1-max3W3",[-129158900]);
AGR.TOC("check","L27G1-check1",[80991801]);
AGR.TOC("pres","L27G1-P1",[59758955]);

# L27d2
AGR.GRP("lin","L27","L27d2");
AGR.TOC("perm","L27d2G1-p8B0.m",[-5510263,21540190]);
AGR.TOC("perm","L27d2G1-p14B0.m",[90997888,-132691774]);
AGR.TOC("perm","L27d2G1-p16B0.m",[5407018,102638737]);
AGR.TOC("perm","L27d2G1-p21B0.m",[56049192,65425389]);
AGR.TOC("perm","L27d2G1-p24B0.m",[103365845,-91778750]);
AGR.TOC("perm","L27d2G1-p28B0.m",[-44303605,-10360032]);
AGR.TOC("perm","L27d2G1-p28bB0.m",[106513626,107773132]);
AGR.TOC("perm","L27d2G1-p42aB0.m",[-59490654,-121061376]);
AGR.TOC("perm","L27d2G1-p42bB0.m",[-68642179,-62328167]);
AGR.TOC("perm","L27d2G1-p42cB0.m",[11888379,95168154]);
AGR.TOC("perm","L27d2G1-p48B0.m",[71422658,-129643461]);
AGR.TOC("perm","L27d2G1-p56aB0.m",[-122228810,-64038626]);
AGR.TOC("perm","L27d2G1-p56bB0.m",[32936262,-47352246]);
AGR.TOC("perm","L27d2G1-p56cB0.m",[-99171114,-70888439]);
AGR.TOC("perm","L27d2G1-p84aB0.m",[-87023985,-19484267]);
AGR.TOC("perm","L27d2G1-p84bB0.m",[103075831,77267518]);
AGR.TOC("perm","L27d2G1-p84cB0.m",[131447996,-129413916]);
AGR.TOC("perm","L27d2G1-p112B0.m",[-35409806,-128129373]);
AGR.TOC("perm","L27d2G1-p168aB0.m",[-74183466,-76560744]);
AGR.TOC("perm","L27d2G1-p168bB0.m",[-11485800,8931352]);
AGR.TOC("perm","L27d2G1-p336B0.m",[-50384223,-36708116]);
AGR.TOC("maxes","L27d2G1-max1W1",[12326768]);
AGR.TOC("maxes","L27d2G1-max1W2",[-60147278]);
AGR.TOC("maxes","L27d2G1-max2W1",[-77560180]);
AGR.TOC("maxes","L27d2G1-max3W1",[-122443526]);
AGR.TOC("maxes","L27d2G1-max4W1",[-92766075]);
AGR.TOC("switch","L27d2G2-G1W1",[126156494]);
AGR.TOC("switch","L27d2G2-G1W2",[-227752]);
AGR.TOC("pres","L27d2G1-P1",[122585497]);

# 2L271
AGR.GRP("lin","L271","2L271");
AGR.TOC("matalg","2L271G1-Ar72aB0.g",[97573070]);

# L271
AGR.GRP("lin","L271","L271");
AGR.TOC("matint","L271G1-Zr71B0.g",[-29765968]);
AGR.TOC("matalg","L271G1-Ar72aB0.g",[-132705831]);
AGR.TOC("maxes","L271G1-max1W1",[-107506999]);
AGR.TOC("maxes","L271G1-max2W1",[-120005548]);
AGR.TOC("maxes","L271G1-max3W1",[98771752]);
AGR.TOC("maxes","L271G1-max4W1",[-115302759]);
AGR.TOC("maxes","L271G1-max5W1",[19142927]);
AGR.TOC("maxes","L271G1-max6W1",[-46171502]);
AGR.TOC("maxes","L271G1-max7W1",[-69705092]);
AGR.TOC("out","L271G1-a2W1",[-41215106]);

# 2L273
AGR.GRP("lin","L273","2L273");
AGR.TOC("matalg","2L273G1-Ar74aB0.g",[128545564]);

# L273
AGR.GRP("lin","L273","L273");
AGR.TOC("matint","L273G1-Zr73B0.g",[-105856654]);
AGR.TOC("matalg","L273G1-Ar74aB0.g",[14924052]);
AGR.TOC("maxes","L273G1-max1W1",[-6680566]);
AGR.TOC("maxes","L273G1-max2W1",[98771752]);
AGR.TOC("maxes","L273G1-max3W1",[-67796260]);
AGR.TOC("maxes","L273G1-max4W1",[23166390]);
AGR.TOC("maxes","L273G1-max5W1",[-34569730]);
AGR.TOC("out","L273G1-a2W1",[105324938]);

# 2L279
AGR.GRP("lin","L279","2L279");
AGR.TOC("matalg","2L279G1-Ar80aB0.g",[95725530]);

# L279
AGR.GRP("lin","L279","L279");
AGR.TOC("matint","L279G1-Zr79B0.g",[41641260]);
AGR.TOC("matalg","L279G1-Ar80aB0.g",[14169819]);
AGR.TOC("maxes","L279G1-max1W1",[61294765]);
AGR.TOC("maxes","L279G1-max2W1",[-67796260]);
AGR.TOC("maxes","L279G1-max3W1",[98771752]);
AGR.TOC("maxes","L279G1-max4W1",[33653711]);
AGR.TOC("maxes","L279G1-max5W1",[-11273025]);
AGR.TOC("maxes","L279G1-max6W1",[-122498485]);
AGR.TOC("maxes","L279G1-max7W1",[113353462]);
AGR.TOC("out","L279G1-a2W1",[24283469]);

# L28
AGR.GRP("lin","L28","L28");
AGR.TOC("perm","L28G1-p9B0.m",[-85991161,61165666]);
AGR.TOC("perm","L28G1-p28B0.m",[35669448,-782094]);
AGR.TOC("perm","L28G1-p36B0.m",[25709402,47214261]);
AGR.TOC("matff","L28G1-f2r6B0.m",[-60926122,-98268904]);
AGR.TOC("matff","L28G1-f2r8B0.m",[126279998,68611850]);
AGR.TOC("matff","L28G1-f2r12B0.m",[106294607,108107010]);
AGR.TOC("matff","L28G1-f3r7B0.m",[27407714,7853667]);
AGR.TOC("matff","L28G1-f3r27B0.m",[-107460493,-64525869]);
AGR.TOC("matff","L28G1-f7r7aB0.m",[40749817,-128421700]);
AGR.TOC("matff","L28G1-f7r8B0.m",[83678633,-26931561]);
AGR.TOC("matff","L28G1-f7r21B0.m",[47260477,-109705151]);
AGR.TOC("matff","L28G1-f8r2aB0.m",[-131892916,-38250632]);
AGR.TOC("matff","L28G1-f8r2bB0.m",[45556983,-38250632]);
AGR.TOC("matff","L28G1-f8r2cB0.m",[50328380,-38250632]);
AGR.TOC("matff","L28G1-f8r4aB0.m",[-123386786,-87209001]);
AGR.TOC("matff","L28G1-f8r4bB0.m",[-123386786,-55301343]);
AGR.TOC("matff","L28G1-f8r4cB0.m",[-123386786,-80612404]);
AGR.TOC("matff","L28G1-f27r9aB0.m",[84356960,99001269]);
AGR.TOC("matff","L28G1-f27r9bB0.m",[-48094539,-37326664]);
AGR.TOC("matff","L28G1-f27r9cB0.m",[-87327260,-86458705]);
AGR.TOC("matint","L28G1-Zr7aB0.g",[110656383]);
AGR.TOC("matint","L28G1-Zr8B0.g",[-51612611]);
AGR.TOC("matint","L28G1-Zr27B0.g",[-114310636]);
AGR.TOC("matalg","L28G1-Ar7bB0.g",[20710480]);
AGR.TOC("matalg","L28G1-Ar7cB0.g",[106609871]);
AGR.TOC("matalg","L28G1-Ar7dB0.g",[101983880]);
AGR.TOC("matalg","L28G1-Ar9aB0.g",[-93920251]);
AGR.TOC("matalg","L28G1-Ar9bB0.g",[64986437]);
AGR.TOC("matalg","L28G1-Ar9cB0.g",[87023092]);
AGR.TOC("maxes","L28G1-max1W1",[21105475]);
AGR.TOC("maxes","L28G1-max2W1",[98771752]);
AGR.TOC("maxes","L28G1-max3W1",[-22453665]);
AGR.TOC("classes","L28G1-cclsW1",[-56266870]);
AGR.TOC("cyclic","L28G1-cycW1",[-65903386]);
AGR.TOC("cyc2ccl","L28G1cycW1-cclsW1",[-15352628]);
AGR.TOC("check","L28G1-check1",[80991801]);

# L28d3
AGR.GRP("lin","L28","L28d3");
AGR.TOC("perm","L28d3G1-p9B0.m",[-124930224,95862760]);
AGR.TOC("perm","L28d3G1-p28B0.m",[-11347864,-3092846]);
AGR.TOC("perm","L28d3G1-p36B0.m",[-57133671,18170332]);
AGR.TOC("matff","L28d3G1-f2r6B0.m",[117978225,97958503]);
AGR.TOC("matff","L28d3G1-f2r8B0.m",[126279998,-16426250]);
AGR.TOC("matff","L28d3G1-f2r12B0.m",[-88309005,-97581577]);
AGR.TOC("matff","L28d3G1-f3r7B0.m",[-76107375,95107976]);
AGR.TOC("matff","L28d3G1-f3r27B0.m",[24644973,-94767526]);
AGR.TOC("matff","L28d3G1-f7r7B0.m",[134048538,-25835967]);
AGR.TOC("matff","L28d3G1-f7r8B0.m",[-27681234,-117458693]);
AGR.TOC("matff","L28d3G1-f7r21B0.m",[131726451,47314828]);
AGR.TOC("matint","L28d3G1-Zr7B0.g",[32732428]);
AGR.TOC("matint","L28d3G1-Zr8B0.g",[76066356]);
AGR.TOC("matint","L28d3G1-Zr21B0.g",[-3741690]);
AGR.TOC("matint","L28d3G1-Zr27B0.g",[-20687523]);
AGR.TOC("classes","L28d3G1-cclsW1",[-104837138]);
AGR.TOC("cyclic","L28d3G1-cycW1",[-60225110]);
AGR.TOC("cyc2ccl","L28d3G1cycW1-cclsW1",[68710271]);

# 2L283
AGR.GRP("lin","L283","2L283");
AGR.TOC("matalg","2L283G1-Ar84aB0.g",[-96591429]);

# L283
AGR.GRP("lin","L283","L283");
AGR.TOC("matint","L283G1-Zr83B0.g",[133196235]);
AGR.TOC("matalg","L283G1-Ar84aB0.g",[-70217405]);
AGR.TOC("maxes","L283G1-max1W1",[-49666001]);
AGR.TOC("maxes","L283G1-max2W1",[98771752]);
AGR.TOC("maxes","L283G1-max3W1",[-69257965]);
AGR.TOC("maxes","L283G1-max4W1",[75963915]);
AGR.TOC("out","L283G1-a2W1",[6146545]);

# 2L289
AGR.GRP("lin","L289","2L289");
AGR.TOC("matalg","2L289G1-Ar90aB0.g",[32588927]);

# L289
AGR.GRP("lin","L289","L289");
AGR.TOC("matint","L289G1-Zr89B0.g",[-34493501]);
AGR.TOC("matalg","L289G1-Ar90aB0.g",[35540176]);
AGR.TOC("maxes","L289G1-max1W1",[103741336]);
AGR.TOC("maxes","L289G1-max2W1",[117428427]);
AGR.TOC("maxes","L289G1-max3W1",[21738060]);
AGR.TOC("maxes","L289G1-max4W1",[-33392236]);
AGR.TOC("maxes","L289G1-max5W1",[41806923]);
AGR.TOC("maxes","L289G1-max6W1",[90241214]);
AGR.TOC("maxes","L289G1-max7W1",[-73311858]);
AGR.TOC("out","L289G1-a2W1",[-13827601]);

# 2L297
AGR.GRP("lin","L297","2L297");
AGR.TOC("matalg","2L297G1-Ar98aB0.g",[-34210]);

# L297
AGR.GRP("lin","L297","L297");
AGR.TOC("matint","L297G1-Zr97B0.g",[58929255]);
AGR.TOC("matalg","L297G1-Ar98aB0.g",[-119272150]);
AGR.TOC("maxes","L297G1-max1W1",[57251414]);
AGR.TOC("maxes","L297G1-max2W1",[-109559907]);
AGR.TOC("maxes","L297G1-max3W1",[-67796260]);
AGR.TOC("maxes","L297G1-max4W1",[50625176]);
AGR.TOC("maxes","L297G1-max5W1",[49198845]);
AGR.TOC("out","L297G1-a2W1",[20248882]);

# L311
AGR.GRP("lin","L311","L311");
AGR.TOC("perm","L311G1-p133B0.m",[-48892957,-54007987]);
AGR.TOC("matff","L311G1-f2r132B0.m",[15127738,-75727431]);
AGR.TOC("matff","L311G1-f3r132B0.m",[-92319162,76425779]);
AGR.TOC("matff","L311G1-f5r132B0.m",[-60819095,100091130]);
AGR.TOC("matff","L311G1-f7r131B0.m",[72618050,62147603]);
AGR.TOC("matff","L311G1-f11r3aB0.m",[51353074,-84399793]);
AGR.TOC("matff","L311G1-f19r131B0.m",[-109101582,-13175777]);
AGR.TOC("matint","L311G1-Zr132B0.g",[17593353]);
AGR.TOC("matint","L311G1-Zr133aB0.g",[-47865131]);
AGR.TOC("matint","L311G1-Zr532aB0.g",[106335786]);
AGR.TOC("matint","L311G1-Zr532bB0.g",[-78067212]);
AGR.TOC("matalg","L311G1-Ar133bB0.g",[29634126]);
AGR.TOC("matalg","L311G1-Ar133cB0.g",[-4007399]);
AGR.TOC("matalg","L311G1-Ar133dB0.g",[-22194624]);
AGR.TOC("matalg","L311G1-Ar133eB0.g",[103312800]);
AGR.TOC("matalg","L311G1-Ar133fB0.g",[65719361]);
AGR.TOC("matalg","L311G1-Ar133gB0.g",[-101751351]);
AGR.TOC("matalg","L311G1-Ar133hB0.g",[-114688021]);
AGR.TOC("matalg","L311G1-Ar133iB0.g",[130526841]);
AGR.TOC("check","L311G1-check1",[-61231635]);

# L313
AGR.GRP("lin","L313","L313");
AGR.TOC("perm","L313G1-p183aB0.m",[-579457,21211168]);
AGR.TOC("perm","L313G1-p183bB0.m",[-60482435,-35517122]);
AGR.TOC("matint","L313G1-Zr182B0.g",[-111175614]);
AGR.TOC("matint","L313G1-Zr183aB0.g",[-132862379]);
AGR.TOC("matint","L313G1-Zr366B0.g",[93062962]);
AGR.TOC("matalg","L313G1-Ar183bB0.g",[33423423]);
AGR.TOC("matalg","L313G1-Ar183cB0.g",[-83074833]);
AGR.TOC("check","L313G1-check1",[97550448]);

# L33
AGR.GRP("lin","L33","L33");
AGR.TOC("perm","L33G1-p13aB0.m",[-116463163,121751560]);
AGR.TOC("perm","L33G1-p13bB0.m",[122362027,96305341]);
AGR.TOC("perm","L33G1-p144B0.m",[132953030,-79314437]);
AGR.TOC("perm","L33G1-p234B0.m",[46906834,-97222146]);
AGR.TOC("matff","L33G1-f2r12B0.m",[-68369210,-99704100]);
AGR.TOC("matff","L33G1-f2r26B0.m",[-6487394,-93166295]);
AGR.TOC("matff","L33G1-f3r3aB0.m",[-125015203,-1845232]);
AGR.TOC("matff","L33G1-f3r3bB0.m",[22004189,-1845232]);
AGR.TOC("matff","L33G1-f3r6aB0.m",[87395281,20238276]);
AGR.TOC("matff","L33G1-f3r6bB0.m",[48358129,-10098283]);
AGR.TOC("matff","L33G1-f3r7B0.m",[14693066,22845843]);
AGR.TOC("matff","L33G1-f3r15aB0.m",[47943582,73867703]);
AGR.TOC("matff","L33G1-f3r15bB0.m",[125984071,123092749]);
AGR.TOC("matff","L33G1-f3r27B0.m",[42310481,17373410]);
AGR.TOC("matff","L33G1-f13r11B0.m",[-23612432,-121029381]);
AGR.TOC("matff","L33G1-f13r13B0.m",[54078889,-94309608]);
AGR.TOC("matff","L33G1-f13r16B0.m",[-124556057,-43232758]);
AGR.TOC("matff","L33G1-f13r26aB0.m",[-45703789,51535145]);
AGR.TOC("matff","L33G1-f13r39B0.m",[52819509,-116280565]);
AGR.TOC("matff","L33G1-f16r16aB0.m",[86287709,-95936991]);
AGR.TOC("matff","L33G1-f169r26bB0.m",[15772447,10196970]);
AGR.TOC("matff","L33G1-f169r26cB0.m",[86757413,-11766465]);
AGR.TOC("matint","L33G1-Zr12B0.g",[61457421]);
AGR.TOC("matint","L33G1-Zr13B0.g",[-92468055]);
AGR.TOC("matint","L33G1-Zr26aB0.g",[84455157]);
AGR.TOC("matint","L33G1-Zr27B0.g",[-29774170]);
AGR.TOC("matint","L33G1-Zr39B0.g",[27098987]);
AGR.TOC("matint","L33G1-Zr52B0.g",[-133915197]);
AGR.TOC("matint","L33G1-Zr64B0.g",[123632852]);
AGR.TOC("matalg","L33G1-Ar26bB0.g",[-84589093]);
AGR.TOC("matalg","L33G1-Ar26cB0.g",[59595839]);
AGR.TOC("check","L33G1-check1",[128356795]);

# L33d2
AGR.GRP("lin","L33","L33d2");
AGR.TOC("perm","L33d2G1-p26B0.m",[5090655,58529217]);
AGR.TOC("perm","L33d2G1-p52B0.m",[-99210540,91863820]);
AGR.TOC("perm","L33d2G1-p117B0.m",[83812796,-69780241]);
AGR.TOC("perm","L33d2G1-p144B0.m",[86756571,98651988]);
AGR.TOC("perm","L33d2G1-p234B0.m",[37009871,-49456502]);
AGR.TOC("matff","L33d2G1-f2r12B0.m",[19003538,118353708]);
AGR.TOC("matff","L33d2G1-f2r26B0.m",[-56283482,-35124799]);
AGR.TOC("matff","L33d2G1-f3r6B0.m",[-88688062,-45156628]);
AGR.TOC("matff","L33d2G1-f3r7aB0.m",[-60557545,-118441876]);
AGR.TOC("matff","L33d2G1-f3r12B0.m",[-53009047,-14672641]);
AGR.TOC("matff","L33d2G1-f3r27aB0.m",[-2091504,-37614992]);
AGR.TOC("matff","L33d2G1-f3r30B0.m",[13802191,-64168086]);
AGR.TOC("matff","L33d2G1-f4r32aB0.m",[-27072300,-22301723]);
AGR.TOC("matff","L33d2G1-f4r32bB0.m",[9376398,-83334069]);
AGR.TOC("matff","L33d2G1-f13r11a1B0.m",[-133399472,104386340]);
AGR.TOC("matff","L33d2G1-f13r13a1B0.m",[127185765,-13976792]);
AGR.TOC("matff","L33d2G1-f13r16a1B0.m",[39120435,7620644]);
AGR.TOC("matff","L33d2G1-f13r26a1B0.m",[58994423,-71875203]);
AGR.TOC("matff","L33d2G1-f13r39a1B0.m",[-117604088,17820792]);
AGR.TOC("matff","L33d2G1-f13r52B0.m",[75404613,-112415009]);

# 12aL34
AGR.GRP("lin","L34","12aL34");
AGR.TOC("perm","12aL34G1-p1440B0.m",[-93057487,34381739]);

# 12aL34d2a
AGR.GRP("lin","L34","12aL34d2a");
AGR.TOC("matff","12aL34d2aG1-f7r48aB0.m",[26622177,109214358]);
AGR.TOC("matff","12aL34d2aG1-f7r96aB0.m",[92172142,115704419]);
AGR.TOC("matff","12aL34d2aG1-f7r96bB0.m",[-127705810,4045644]);
AGR.TOC("matff","12aL34d2aG1-f25r48aB0.m",[-79141338,44899819]);
AGR.TOC("matff","12aL34d2aG1-f25r48bB0.m",[14928352,18052982]);
AGR.TOC("matff","12aL34d2aG1-f25r240aB0.m",[121261647,72933608]);

# 12bL34
AGR.GRP("lin","L34","12bL34");
AGR.TOC("perm","12bL34G1-p1440B0.m",[6654670,-47327527]);
AGR.TOC("matff","12bL34G1-f49r12aB0.m",[120731387,-43948989]);
AGR.TOC("matff","12bL34G1-f49r36aB0.m",[6624692,-72871409]);
AGR.TOC("matff","12bL34G1-f49r48aB0.m",[103614293,42100855]);
AGR.TOC("matff","12bL34G1-f49r84aB0.m",[3517396,-122669699]);

# 12bL34d2a
AGR.GRP("lin","L34","12bL34d2a");
AGR.TOC("matff","12bL34d2aG1-f7r24aB0.m",[-90380968,87401413]);
AGR.TOC("matff","12bL34d2aG1-f7r72aB0.m",[56903652,-2055551]);
AGR.TOC("matff","12bL34d2aG1-f7r96aB0.m",[35078056,-127832242]);
AGR.TOC("matff","12bL34d2aG1-f7r168aB0.m",[-69235645,73296186]);
AGR.TOC("matff","12bL34d2aG1-f25r72aB0.m",[14083533,70706734]);
AGR.TOC("matff","12bL34d2aG1-f25r96aB0.m",[-127862077,-102790773]);
AGR.TOC("matff","12bL34d2aG1-f25r120aB0.m",[73397176,-75291982]);
AGR.TOC("matff","12bL34d2aG1-f25r120bB0.m",[-68375584,53552761]);

# 2L34
AGR.GRP("lin","L34","2L34");
AGR.TOC("perm","2L34G1-p112aB0.m",[-68974259,-52791464]);
AGR.TOC("perm","2L34G1-p112bB0.m",[-41101872,-125401681]);
AGR.TOC("perm","2L34G1-p112cB0.m",[-5706690,-120729682]);
AGR.TOC("perm","2L34G1-p240aB0.m",[-41074538,22004999]);
AGR.TOC("perm","2L34G1-p240bB0.m",[81289321,77816372]);
AGR.TOC("perm","2L34G1-p240cB0.m",[15130538,96479366]);
AGR.TOC("matff","2L34G1-f3r6B0.m",[-103893736,-86081679]);
AGR.TOC("matff","2L34G1-f3r20B0.m",[-93569944,-87382685]);
AGR.TOC("matff","2L34G1-f3r36B0.m",[-80756428,41508285]);
AGR.TOC("matff","2L34G1-f3r44B0.m",[41478190,-18743104]);
AGR.TOC("matff","2L34G1-f3r90B0.m",[88287177,-81736530]);
AGR.TOC("matff","2L34G1-f5r20B0.m",[-89299589,-58349063]);
AGR.TOC("matff","2L34G1-f5r28B0.m",[-399631,116739406]);
AGR.TOC("matff","2L34G1-f5r36B0.m",[115657892,-23166152]);
AGR.TOC("matff","2L34G1-f5r70B0.m",[-101817162,124450490]);
AGR.TOC("matff","2L34G1-f5r90B0.m",[105022990,-88409173]);
AGR.TOC("matff","2L34G1-f7r10B0.m",[84112006,27474894]);
AGR.TOC("matff","2L34G1-f7r26B0.m",[-116585591,116151908]);
AGR.TOC("matff","2L34G1-f7r56B0.m",[79622507,-86309451]);
AGR.TOC("matff","2L34G1-f7r64B0.m",[-24493087,-33578946]);
AGR.TOC("matff","2L34G1-f7r70B0.m",[127847176,83424766]);
AGR.TOC("matff","2L34G1-f9r10aB0.m",[-25247569,128716654]);
AGR.TOC("matff","2L34G1-f9r10bB0.m",[-103159260,-97045998]);
AGR.TOC("matff","2L34G1-f9r22aB0.m",[22903972,116243796]);
AGR.TOC("matff","2L34G1-f9r22bB0.m",[-58222286,54549056]);
AGR.TOC("matff","2L34G1-f25r10aB0.m",[-88992821,67489201]);
AGR.TOC("matff","2L34G1-f25r10bB0.m",[-105440074,96200235]);
AGR.TOC("matff","2L34G1-f49r28aB0.m",[1310270,-62148044]);
AGR.TOC("matff","2L34G1-f49r28bB0.m",[124811287,-54950694]);

# 2L34d2a
AGR.GRP("lin","L34","2L34d2a");
AGR.TOC("matff","2L34d2aG1-f3r20aB0.m",[116117247,-57691655]);
AGR.TOC("matff","2L34d2aG1-f3r36aB0.m",[-77445395,-24387511]);
AGR.TOC("matff","2L34d2aG1-f3r44aB0.m",[45409821,121155019]);
AGR.TOC("matff","2L34d2aG1-f5r20aB0.m",[110311293,-1882364]);
AGR.TOC("matff","2L34d2aG1-f5r28aB0.m",[47061633,-116857533]);
AGR.TOC("matff","2L34d2aG1-f5r36aB0.m",[-67885411,-67746345]);
AGR.TOC("matff","2L34d2aG1-f7r10aB0.m",[100312708,4134229]);
AGR.TOC("matff","2L34d2aG1-f7r26aB0.m",[80948327,-21554207]);
AGR.TOC("matff","2L34d2aG1-f7r56aB0.m",[-120340992,-42176093]);
AGR.TOC("matff","2L34d2aG1-f7r64aB0.m",[106918930,34999708]);
AGR.TOC("matff","2L34d2aG1-f7r70aB0.m",[19892965,88403861]);
AGR.TOC("matff","2L34d2aG1-f9r6aB0.m",[-45904163,-91173218]);
AGR.TOC("matff","2L34d2aG1-f9r90aB0.m",[-48863604,-36608392]);
AGR.TOC("matff","2L34d2aG1-f25r70aB0.m",[-115392312,-50364781]);
AGR.TOC("matff","2L34d2aG1-f25r90aB0.m",[-104079389,-35438474]);

# 3L34
AGR.GRP("lin","L34","3L34");
AGR.TOC("perm","3L34G1-p63aB0.m",[-84404742,-70798544]);
AGR.TOC("perm","3L34G1-p63bB0.m",[-112558804,-13333446]);
AGR.TOC("perm","3L34G1-p360aB0.m",[-56841669,-51949901]);
AGR.TOC("perm","3L34G1-p360bB0.m",[87942575,15177202]);
AGR.TOC("perm","3L34G1-p360cB0.m",[-99761475,53988323]);
AGR.TOC("matff","3L34G1-f2r6aB0.m",[-65706201,-101302677]);
AGR.TOC("matff","3L34G1-f2r6bB0.m",[16308329,63335887]);
AGR.TOC("matff","3L34G1-f2r18B0.m",[22226930,-25662078]);
AGR.TOC("matff","3L34G1-f2r48aB0.m",[-66044074,33257764]);
AGR.TOC("matff","3L34G1-f2r48bB0.m",[-116513251,2548963]);
AGR.TOC("matff","3L34G1-f4r3aB0.m",[-97328602,65174037]);
AGR.TOC("matff","3L34G1-f4r3bB0.m",[11933003,65174037]);
AGR.TOC("matff","3L34G1-f4r9aB0.m",[-123373201,86769374]);
AGR.TOC("matff","3L34G1-f4r24aB0.m",[128439733,-19119772]);
AGR.TOC("matff","3L34G1-f4r24bB0.m",[36344684,-59800273]);
AGR.TOC("matff","3L34G1-f5r42B0.m",[85695935,-130342706]);
AGR.TOC("matff","3L34G1-f7r15aB0.m",[79081745,514114]);
AGR.TOC("matff","3L34G1-f7r15bB0.m",[8581692,126454307]);
AGR.TOC("matff","3L34G1-f7r15cB0.m",[-114513189,114145279]);
AGR.TOC("matff","3L34G1-f7r21aB0.m",[24467152,23770871]);
AGR.TOC("matff","3L34G1-f7r84aB0.m",[75155492,99817923]);
AGR.TOC("matff","3L34G1-f7r126aB0.m",[-36594705,-111037250]);
AGR.TOC("matff","3L34G1-f25r21aB0.m",[-17385074,112933939]);
AGR.TOC("matff","3L34G1-f49r63aB0.m",[67855398,47781720]);
AGR.TOC("matff","3L34G1-f49r63bB0.m",[21904644,126831464]);

# 3L34d2a
AGR.GRP("lin","L34","3L34d2a");
AGR.TOC("matff","3L34d2aG1-f4r6aB0.m",[101016393,-133212309]);
AGR.TOC("matff","3L34d2aG1-f4r9aB0.m",[-95539509,-73330707]);
AGR.TOC("matff","3L34d2aG1-f4r48aB0.m",[-71828641,-87874767]);
AGR.TOC("matff","3L34d2aG1-f7r15aB0.m",[11348637,127771694]);
AGR.TOC("matff","3L34d2aG1-f7r15bB0.m",[26041056,-109115907]);
AGR.TOC("matff","3L34d2aG1-f7r15cB0.m",[43912746,-17513682]);
AGR.TOC("matff","3L34d2aG1-f7r21aB0.m",[58637017,-5764544]);
AGR.TOC("matff","3L34d2aG1-f7r126aB0.m",[56179507,132628587]);
AGR.TOC("matff","3L34d2aG1-f25r15aB0.m",[-46743145,94716397]);
AGR.TOC("matff","3L34d2aG1-f25r15bB0.m",[-36577252,58600418]);
AGR.TOC("matff","3L34d2aG1-f25r15cB0.m",[62050075,-79592725]);
AGR.TOC("matff","3L34d2aG1-f25r21aB0.m",[-96589924,-38419168]);
AGR.TOC("matff","3L34d2aG1-f25r63aB0.m",[-35259848,-68482160]);
AGR.TOC("matff","3L34d2aG1-f25r90aB0.m",[-112263163,40609361]);

# 4aL34
AGR.GRP("lin","L34","4aL34");
AGR.TOC("perm","4aL34G1-p224B0.m",[-29322817,-112140598]);
AGR.TOC("perm","4aL34G1-p480B0.m",[107820567,38862527]);

# 4aL34d2a
AGR.GRP("lin","L34","4aL34d2a");
AGR.TOC("matff","4aL34d2aG1-f3r16aB0.m",[46427716,16766612]);
AGR.TOC("matff","4aL34d2aG1-f3r16bB0.m",[-95213894,-53996788]);
AGR.TOC("matff","4aL34d2aG1-f3r48aB0.m",[-125471684,-15470402]);
AGR.TOC("matff","4aL34d2aG1-f3r48bB0.m",[-125471684,-15470402]);
AGR.TOC("matff","4aL34d2aG1-f3r80aB0.m",[117868899,-114418461]);
AGR.TOC("matff","4aL34d2aG1-f5r16aB0.m",[-77788676,52337679]);
AGR.TOC("matff","4aL34d2aG1-f5r112aB0.m",[-44260037,57153121]);
AGR.TOC("matff","4aL34d2aG1-f7r16aB0.m",[105949035,-27886191]);
AGR.TOC("matff","4aL34d2aG1-f7r16bB0.m",[15027655,123470029]);
AGR.TOC("matff","4aL34d2aG1-f7r112aB0.m",[120149916,-29136110]);
AGR.TOC("matff","4aL34d2aG1-f7r128aB0.m",[28457933,-84063692]);
AGR.TOC("matff","4aL34d2aG1-f25r160aB0.m",[94975212,-18542833]);

# 4bL34
AGR.GRP("lin","L34","4bL34");
AGR.TOC("perm","4bL34G1-p224B0.m",[4075530,-126540461]);
AGR.TOC("perm","4bL34G1-p480B0.m",[993474,-12612935]);
AGR.TOC("matff","4bL34G1-f3r8B0.m",[-54825854,-94825055]);
AGR.TOC("matff","4bL34G1-f3r32B0.m",[-18133199,-18991413]);
AGR.TOC("matff","4bL34G1-f3r56aB0.m",[17247428,-133536447]);
AGR.TOC("matff","4bL34G1-f3r56bB0.m",[88017518,-102653945]);
AGR.TOC("matff","4bL34G1-f3r72B0.m",[51891685,-72809012]);
AGR.TOC("matff","4bL34G1-f3r120B0.m",[-16253618,-91930404]);
AGR.TOC("matff","4bL34G1-f5r20aB0.m",[130948648,76660542]);
AGR.TOC("matff","4bL34G1-f5r28aB0.m",[-9788569,-60703200]);
AGR.TOC("matff","4bL34G1-f5r36aB0.m",[119489141,-132304597]);
AGR.TOC("matff","4bL34G1-f5r160aB0.m",[-119862924,-26192627]);
AGR.TOC("matff","4bL34G1-f7r40B0.m",[70560512,60215626]);
AGR.TOC("matff","4bL34G1-f7r56aB0.m",[97013262,-79743414]);
AGR.TOC("matff","4bL34G1-f7r56bB0.m",[36361797,86437892]);
AGR.TOC("matff","4bL34G1-f7r72B0.m",[40325760,11787007]);
AGR.TOC("matff","4bL34G1-f7r88B0.m",[131279819,90124935]);
AGR.TOC("matff","4bL34G1-f9r4aB0.m",[25816187,-57490078]);
AGR.TOC("matff","4bL34G1-f9r16aB0.m",[40512013,-9608413]);
AGR.TOC("matff","4bL34G1-f9r28aB0.m",[49153070,-61801576]);
AGR.TOC("matff","4bL34G1-f9r28bB0.m",[127076227,-35727580]);
AGR.TOC("matff","4bL34G1-f9r36aB0.m",[-129263542,775946]);
AGR.TOC("matff","4bL34G1-f9r60aB0.m",[16520345,64352643]);
AGR.TOC("matff","4bL34G1-f25r80aB0.m",[-35370227,-56481398]);
AGR.TOC("matff","4bL34G1-f25r80bB0.m",[125494459,26057263]);
AGR.TOC("matff","4bL34G1-f49r20aB0.m",[-451666,-97316739]);
AGR.TOC("matff","4bL34G1-f49r28aB0.m",[-50186719,-44902445]);
AGR.TOC("matff","4bL34G1-f49r28bB0.m",[97249965,131233241]);
AGR.TOC("matff","4bL34G1-f49r36aB0.m",[61905462,-6951638]);
AGR.TOC("matff","4bL34G1-f49r44aB0.m",[27974262,-88322029]);

# 4bL34d2a
AGR.GRP("lin","L34","4bL34d2a");
AGR.TOC("matff","4bL34d2aG1-f3r8aB0.m",[102848125,-122573398]);
AGR.TOC("matff","4bL34d2aG1-f3r32aB0.m",[132207655,24814268]);
AGR.TOC("matff","4bL34d2aG1-f3r56aB0.m",[116001063,-114911263]);
AGR.TOC("matff","4bL34d2aG1-f3r56bB0.m",[78698101,-19003998]);
AGR.TOC("matff","4bL34d2aG1-f3r72aB0.m",[-23570692,-970393]);
AGR.TOC("matff","4bL34d2aG1-f3r120aB0.m",[-111067857,12708432]);
AGR.TOC("matff","4bL34d2aG1-f5r40aB0.m",[131962590,61002952]);
AGR.TOC("matff","4bL34d2aG1-f5r56aB0.m",[93085107,-85515727]);
AGR.TOC("matff","4bL34d2aG1-f5r72aB0.m",[-54606187,-117119289]);
AGR.TOC("matff","4bL34d2aG1-f7r40aB0.m",[-82490410,64417307]);
AGR.TOC("matff","4bL34d2aG1-f7r56aB0.m",[-119575217,-97663691]);
AGR.TOC("matff","4bL34d2aG1-f7r56bB0.m",[-82308316,-113181878]);
AGR.TOC("matff","4bL34d2aG1-f7r72aB0.m",[33321922,-46364155]);
AGR.TOC("matff","4bL34d2aG1-f7r88aB0.m",[24921739,-87479774]);
AGR.TOC("matff","4bL34d2aG1-f25r160aB0.m",[59696593,-11162019]);

# 6L34
AGR.GRP("lin","L34","6L34");
AGR.TOC("perm","6L34G1-p720aB0.m",[-28192485,26893988]);
AGR.TOC("perm","6L34G1-p720bB0.m",[-125662981,-3873538]);
AGR.TOC("perm","6L34G1-p720cB0.m",[1794908,123135054]);
AGR.TOC("matalg","6L34G1-Ar6aB0.g",[85836385]);

# 6L34d2a
AGR.GRP("lin","L34","6L34d2a");
AGR.TOC("matff","6L34d2aG1-f7r6aB0.m",[79827435,-76787641]);
AGR.TOC("matff","6L34d2aG1-f7r36aB0.m",[-4007073,-17197499]);
AGR.TOC("matff","6L34d2aG1-f7r54aB0.m",[-67804259,-129518022]);
AGR.TOC("matff","6L34d2aG1-f7r84aB0.m",[30627110,77959264]);
AGR.TOC("matff","6L34d2aG1-f25r6aB0.m",[61179572,-78383424]);
AGR.TOC("matff","6L34d2aG1-f25r36aB0.m",[104612967,-64413333]);
AGR.TOC("matff","6L34d2aG1-f25r90aB0.m",[15442327,41972559]);
AGR.TOC("matff","6L34d2aG1-f25r120aB0.m",[-64557383,-50608452]);

# L34
AGR.GRP("lin","L34","L34");
AGR.TOC("perm","L34G1-p21aB0.m",[-19004952,5499543]);
AGR.TOC("perm","L34G1-p21bB0.m",[91845683,-54944712]);
AGR.TOC("perm","L34G1-p56aB0.m",[-8900666,-118975031]);
AGR.TOC("perm","L34G1-p56bB0.m",[50383895,-34790052]);
AGR.TOC("perm","L34G1-p56cB0.m",[-86656563,-100194267]);
AGR.TOC("perm","L34G1-p120aB0.m",[-72559214,27979987]);
AGR.TOC("perm","L34G1-p120bB0.m",[-55561320,-1516803]);
AGR.TOC("perm","L34G1-p120cB0.m",[-57007187,101354069]);
AGR.TOC("perm","L34G1-p280B0.m",[98810647,-94695118]);
AGR.TOC("matff","L34G1-f2r9aB0.m",[-98758327,-117475382]);
AGR.TOC("matff","L34G1-f2r9bB0.m",[-63412790,110073486]);
AGR.TOC("matff","L34G1-f2r16B0.m",[46169480,-95413981]);
AGR.TOC("matff","L34G1-f2r64B0.m",[51000356,-26817579]);
AGR.TOC("matff","L34G1-f3r15aB0.m",[-39614754,-121811673]);
AGR.TOC("matff","L34G1-f3r15bB0.m",[-112371543,-1531556]);
AGR.TOC("matff","L34G1-f3r15cB0.m",[113919011,67993071]);
AGR.TOC("matff","L34G1-f3r19B0.m",[102198987,105678252]);
AGR.TOC("matff","L34G1-f3r90B0.m",[51410400,84508933]);
AGR.TOC("matff","L34G1-f3r126B0.m",[3481951,64876651]);
AGR.TOC("matff","L34G1-f4r8aB0.m",[-75135557,38900111]);
AGR.TOC("matff","L34G1-f4r8bB0.m",[-75135557,2656064]);
AGR.TOC("matff","L34G1-f5r20B0.m",[-43817290,-113432271]);
AGR.TOC("matff","L34G1-f5r35aB0.m",[-89364701,74136444]);
AGR.TOC("matff","L34G1-f5r35bB0.m",[-52643649,7141410]);
AGR.TOC("matff","L34G1-f5r35cB0.m",[-128692603,52387688]);
AGR.TOC("matff","L34G1-f5r63B0.m",[-105250897,-19347820]);
AGR.TOC("matff","L34G1-f5r90B0.m",[-47031751,107440221]);
AGR.TOC("matff","L34G1-f7r19B0.m",[124793693,83774943]);
AGR.TOC("matff","L34G1-f7r35aB0.m",[60130429,-22094752]);
AGR.TOC("matff","L34G1-f7r35bB0.m",[105679957,97686809]);
AGR.TOC("matff","L34G1-f7r35cB0.m",[-60559294,79512400]);
AGR.TOC("matff","L34G1-f7r45B0.m",[47592897,30522697]);
AGR.TOC("matff","L34G1-f7r126B0.m",[41002667,32973004]);
AGR.TOC("matff","L34G1-f9r45aB0.m",[93201630,-127294177]);
AGR.TOC("matff","L34G1-f9r45bB0.m",[49557081,53141546]);
AGR.TOC("matff","L34G1-f9r63aB0.m",[112292721,2777151]);
AGR.TOC("matff","L34G1-f9r63bB0.m",[-89774031,103770877]);
AGR.TOC("matff","L34G1-f25r45aB0.m",[-44775022,120011673]);
AGR.TOC("matff","L34G1-f25r45bB0.m",[-29632890,103603502]);
AGR.TOC("matff","L34G1-f49r63aB0.m",[124259526,30413281]);
AGR.TOC("matff","L34G1-f49r63bB0.m",[21372363,-97700157]);
AGR.TOC("matint","L34G1-Zr20B0.g",[-122023731]);
AGR.TOC("matint","L34G1-Zr35aB0.g",[-113551123]);
AGR.TOC("matint","L34G1-Zr35bB0.g",[-828219]);
AGR.TOC("matint","L34G1-Zr35cB0.g",[-25424988]);
AGR.TOC("matint","L34G1-Zr64B0.g",[13550568]);
AGR.TOC("matalg","L34G1-Ar63aB0.g",[118391189]);
AGR.TOC("matalg","L34G1-Ar63bB0.g",[125483016]);
AGR.TOC("maxes","L34G1-max1W1",[68080085]);
AGR.TOC("maxes","L34G1-max2W1",[5685288]);
AGR.TOC("maxes","L34G1-max3W1",[118140116]);
AGR.TOC("maxes","L34G1-max6W1",[130740388]);
AGR.TOC("maxes","L34G1-max7W1",[-9220339]);
AGR.TOC("maxes","L34G1-max8W1",[125238819]);
AGR.TOC("maxes","L34G1-max9W1",[-108213754]);
AGR.TOC("maxstd","L34G1max6W1-L27G1W1",[74292380]);
AGR.TOC("maxstd","L34G1max7W1-L27G1W1",[74292380]);
AGR.TOC("maxstd","L34G1max8W1-L27G1W1",[74292380]);
AGR.TOC("check","L34G1-check1",[27117774]);
AGR.TOC("pres","L34G1-P1",[-49235946]);

# L34d2a
AGR.GRP("lin","L34","L34d2a");
AGR.TOC("matff","L34d2aG1-f2r16aB0.m",[83547602,116479864]);
AGR.TOC("matff","L34d2aG1-f2r18aB0.m",[-25080438,-59240269]);
AGR.TOC("matff","L34d2aG1-f2r64aB0.m",[69288851,95225700]);
AGR.TOC("matff","L34d2aG1-f3r15aB0.m",[-61111317,101842957]);
AGR.TOC("matff","L34d2aG1-f3r15bB0.m",[-128709375,-54183738]);
AGR.TOC("matff","L34d2aG1-f3r15cB0.m",[76310770,-121510502]);
AGR.TOC("matff","L34d2aG1-f3r19aB0.m",[-51740278,41392306]);
AGR.TOC("matff","L34d2aG1-f3r90aB0.m",[56189202,55127644]);
AGR.TOC("matff","L34d2aG1-f3r126aB0.m",[81734399,-58995213]);
AGR.TOC("matff","L34d2aG1-f5r20aB0.m",[31455135,131197524]);
AGR.TOC("matff","L34d2aG1-f5r35aB0.m",[-43784368,119001465]);
AGR.TOC("matff","L34d2aG1-f5r35bB0.m",[-111004812,29887541]);
AGR.TOC("matff","L34d2aG1-f5r35cB0.m",[-51473521,23444213]);
AGR.TOC("matff","L34d2aG1-f5r63aB0.m",[-112065891,-65873907]);
AGR.TOC("matff","L34d2aG1-f5r90aB0.m",[-119791052,16467379]);
AGR.TOC("matff","L34d2aG1-f7r19aB0.m",[-101848977,23107928]);
AGR.TOC("matff","L34d2aG1-f7r35aB0.m",[-527302,56621053]);
AGR.TOC("matff","L34d2aG1-f7r35bB0.m",[-95054765,35790184]);
AGR.TOC("matff","L34d2aG1-f7r35cB0.m",[-95865379,23720152]);
AGR.TOC("matff","L34d2aG1-f7r45aB0.m",[110810312,-98005062]);
AGR.TOC("matff","L34d2aG1-f7r126aB0.m",[82279213,126072812]);
AGR.TOC("cyclic","L34d2aG1-cycW1",[-96567863]);

# L35
AGR.GRP("lin","L35","L35");
AGR.TOC("perm","L35G1-p31aB0.m",[-54392845,-57877261]);
AGR.TOC("perm","L35G1-p31bB0.m",[-87497619,-74211641]);
AGR.TOC("matff","L35G1-f5r3aB0.m",[-65129013,15896462]);
AGR.TOC("matff","L35G1-f5r3bB0.m",[-65129013,-40061844]);
AGR.TOC("matff","L35G1-f5r8B0.m",[32399140,85142332]);
AGR.TOC("matint","L35G1-Zr30B0.g",[-27425429]);
AGR.TOC("matint","L35G1-Zr31aB0.g",[99159689]);
AGR.TOC("matint","L35G1-Zr124aB0.g",[-115205541]);
AGR.TOC("matint","L35G1-Zr124bB0.g",[30557051]);
AGR.TOC("matint","L35G1-Zr125B0.g",[100061240]);
AGR.TOC("matint","L35G1-Zr155aB0.g",[39857228]);
AGR.TOC("matint","L35G1-Zr186B0.g",[50412205]);
AGR.TOC("matalg","L35G1-Ar31bB0.g",[8369273]);
AGR.TOC("matalg","L35G1-Ar31cB0.g",[-71316675]);
AGR.TOC("matalg","L35G1-Ar124cB0.g",[-124331976]);
AGR.TOC("matalg","L35G1-Ar124dB0.g",[-114482122]);
AGR.TOC("matalg","L35G1-Ar124eB0.g",[-115304669]);
AGR.TOC("matalg","L35G1-Ar124fB0.g",[2324575]);
AGR.TOC("matalg","L35G1-Ar124gB0.g",[62362134]);
AGR.TOC("matalg","L35G1-Ar124hB0.g",[88306887]);
AGR.TOC("matalg","L35G1-Ar124iB0.g",[-83924311]);
AGR.TOC("matalg","L35G1-Ar124jB0.g",[-35732927]);
AGR.TOC("matalg","L35G1-Ar155bB0.g",[96893498]);
AGR.TOC("matalg","L35G1-Ar155cB0.g",[49785947]);
AGR.TOC("switch","L35G1-G2W1",[4135392]);
AGR.TOC("switch","L35G2-G1W1",[-116206338]);
AGR.TOC("check","L35G1-check1",[-74963282]);
AGR.TOC("pres","L35G1-P1",[90517883]);
AGR.TOC("pres","L35G2-P1",[97980954]);

# L35d2
AGR.GRP("lin","L35","L35d2");
AGR.TOC("perm","L35d2G1-p62B0.m",[-29681502,-49152859]);
AGR.TOC("perm","L35d2G1-p186B0.m",[65566167,-13349652]);
AGR.TOC("perm","L35d2G1-p775B0.m",[-2342518,-86305942]);
AGR.TOC("perm","L35d2G1-p3100B0.m",[-88459429,-121823863]);
AGR.TOC("perm","L35d2G1-p3875B0.m",[-128735761,1363702]);
AGR.TOC("perm","L35d2G1-p4000B0.m",[27219291,109028642]);
AGR.TOC("matff","L35d2G1-f5r6B0.m",[-104077410,-32872059]);
AGR.TOC("matff","L35d2G1-f5r8B0.m",[-98916020,-122589078]);
AGR.TOC("maxes","L35d2G1-max1W1",[94732269]);
AGR.TOC("maxes","L35d2G1-max2W1",[53483340]);
AGR.TOC("maxes","L35d2G1-max3W1",[-77535957]);
AGR.TOC("maxes","L35d2G1-max4W1",[-19947795]);
AGR.TOC("maxes","L35d2G1-max5W1",[131867145]);
AGR.TOC("maxes","L35d2G1-max6W1",[-53044737]);
AGR.TOC("pres","L35d2G1-P1",[111773918]);

# 3L37
AGR.GRP("lin","L37","3L37");
AGR.TOC("matff","3L37G1-f7r3B0.m",[-100717365,-108175928]);

# 3L37d2
AGR.GRP("lin","L37","3L37d2");

# L37
AGR.GRP("lin","L37","L37");
AGR.TOC("perm","L37G1-p57B0.m",[-53038011,-87729305]);
AGR.TOC("matff","L37G1-f2r152aB0.m",[-72199675,67264246]);
AGR.TOC("matff","L37G1-f3r55B0.m",[-74161474,-22493683]);
AGR.TOC("matff","L37G1-f3r57B0.m",[-47437722,-74326569]);
AGR.TOC("matff","L37G1-f3r96aB0.m",[26591279,71358592]);
AGR.TOC("matff","L37G1-f3r96bB0.m",[-32809021,70784477]);
AGR.TOC("matff","L37G1-f3r96cB0.m",[95784301,-41545820]);
AGR.TOC("matff","L37G1-f3r342aB0.m",[52549423,-121195267]);
AGR.TOC("matff","L37G1-f3r399B0.m",[132962784,32272895]);
AGR.TOC("matff","L37G1-f7r8B0.m",[58422518,-51802315]);
AGR.TOC("matff","L37G1-f7r10aB0.m",[131217716,6719232]);
AGR.TOC("matff","L37G1-f7r10bB0.m",[-80359230,-77685974]);
AGR.TOC("matff","L37G1-f7r27B0.m",[21222778,570050]);
AGR.TOC("matint","L37G1-Zr56B0.g",[-46471591]);
AGR.TOC("matint","L37G1-Zr57B0.g",[113079095]);
AGR.TOC("matint","L37G1-Zr152aB0.g",[11399823]);
AGR.TOC("matint","L37G1-Zr152bB0.g",[102789999]);
AGR.TOC("matint","L37G1-Zr152cB0.g",[16428520]);
AGR.TOC("cyclic","L37G1-cycW1",[5762964]);
AGR.TOC("cyc2ccl","L37G1cycW1-cclsW1",[22298259]);
AGR.TOC("check","L37G1-check1",[-77065997]);

# L37d2
AGR.GRP("lin","L37","L37d2");
AGR.TOC("matff","L37d2G1-f2r56B0.m",[33892259,-118271238]);
AGR.TOC("matff","L37d2G1-f2r152B0.m",[-32632257,-100690645]);
AGR.TOC("matff","L37d2G1-f2r342B0.m",[56091536,-12504703]);
AGR.TOC("matff","L37d2G1-f3r55B0.m",[-71443487,-95752462]);
AGR.TOC("matff","L37d2G1-f3r57B0.m",[39141964,-36264033]);
AGR.TOC("matff","L37d2G1-f3r96B0.m",[-131123640,-26072740]);
AGR.TOC("matff","L37d2G1-f3r192B0.m",[-93380539,-87395286]);
AGR.TOC("matff","L37d2G1-f3r399B0.m",[-95030787,104673177]);
AGR.TOC("matff","L37d2G1-f7r8B0.m",[-122290111,-122282756]);
AGR.TOC("matff","L37d2G1-f7r20B0.m",[-30006785,-54694979]);
AGR.TOC("matff","L37d2G1-f7r27B0.m",[-10239772,42092568]);
AGR.TOC("matff","L37d2G1-f7r37B0.m",[110185839,-101415274]);
AGR.TOC("matff","L37d2G1-f7r56B0.m",[86717133,99591761]);
AGR.TOC("matff","L37d2G1-f7r70B0.m",[62370012,-82953269]);
AGR.TOC("matff","L37d2G1-f7r308B0.m",[-75186577,82686741]);
AGR.TOC("matff","L37d2G1-f7r343B0.m",[96956716,-59783385]);
AGR.TOC("matff","L37d2G1-f9r342bB0.m",[-95252590,17365417]);
AGR.TOC("matff","L37d2G1-f9r342cB0.m",[11273536,-73143313]);
AGR.TOC("maxes","L37d2G1-max1W1",[18648327]);
AGR.TOC("maxes","L37d2G1-max2W1",[72713883]);
AGR.TOC("cyclic","L37d2G1-cycW1",[127772245]);
AGR.TOC("cyc2ccl","L37d2G1cycW1-cclsW1",[-12399487]);

# L38
AGR.GRP("lin","L38","L38");
AGR.TOC("perm","L38G1-p73aB0.m",[7367191,-115753490]);
AGR.TOC("perm","L38G1-p73bB0.m",[16360602,76307498]);
AGR.TOC("perm","L38G1-p56064B0.m",[-66463656,-89599168]);
AGR.TOC("perm","L38G1-p75264B0.m",[-4020599,-20343939]);
AGR.TOC("perm","L38G1-p98112B0.m",[35089548,56301880]);
AGR.TOC("matff","L38G1-f2r27B0.m",[53570555,130909346]);
AGR.TOC("matff","L38G1-f2r512B0.m",[107224380,37094558]);
AGR.TOC("matff","L38G1-f3r72B0.m",[73721626,53952558]);
AGR.TOC("matff","L38G1-f3r511B0.m",[35926319,-15545178]);
AGR.TOC("matff","L38G1-f7r72B0.m",[-11825976,-66298402]);
AGR.TOC("matff","L38G1-f7r511B0.m",[89673906,76603171]);
AGR.TOC("matff","L38G1-f7r512B0.m",[-87765186,104110734]);
AGR.TOC("matff","L38G1-f8r3B0.m",[-37144176,93598740]);
AGR.TOC("matff","L38G1-f8r8B0.m",[108810880,41630410]);
AGR.TOC("matff","L38G1-f8r9aB0.m",[34239993,52256508]);
AGR.TOC("matff","L38G1-f8r9bB0.m",[-93705188,52256508]);
AGR.TOC("matff","L38G1-f8r24aB0.m",[1402273,110477717]);
AGR.TOC("matff","L38G1-f8r24bB0.m",[131799401,-76136676]);
AGR.TOC("matff","L38G1-f8r27B0.m",[7847816,-72778508]);
AGR.TOC("matff","L38G1-f8r64B0.m",[-39084705,27917098]);
AGR.TOC("matff","L38G1-f8r72aB0.m",[-49992500,-101821875]);
AGR.TOC("matff","L38G1-f8r72bB0.m",[48760267,-126905198]);
AGR.TOC("matff","L38G1-f8r192B0.m",[-35474945,-62548250]);
AGR.TOC("matff","L38G1-f27r657B0.m",[-9549407,-43676573]);
AGR.TOC("matff","L38G1-f73r71B0.m",[126111976,36033445]);
AGR.TOC("matff","L38G1-f73r441B0.m",[-47921267,127739676]);
AGR.TOC("matff","L38G1-f73r511aB0.m",[31065741,56807328]);
AGR.TOC("matff","L38G1-f73r511bB0.m",[-134145805,-122352988]);
AGR.TOC("matff","L38G1-f343r511B0.m",[-100123551,19487879]);
AGR.TOC("matint","L38G1-Zr72B0.g",[128827179]);
AGR.TOC("matalg","L38G1-Ar73aB0.g",[-94769407]);
AGR.TOC("matalg","L38G1-Ar73bB0.g",[50723992]);
AGR.TOC("matalg","L38G1-Ar73cB0.g",[118152385]);
AGR.TOC("matalg","L38G1-Ar73dB0.g",[18131412]);
AGR.TOC("matalg","L38G1-Ar73eB0.g",[126115624]);
AGR.TOC("matalg","L38G1-Ar73fB0.g",[179255]);
AGR.TOC("maxes","L38G1-max1W1",[105383583]);
AGR.TOC("maxes","L38G1-max2W1",[-121773189]);
AGR.TOC("maxes","L38G1-max3W1",[-85409155]);
AGR.TOC("maxes","L38G1-max4W1",[-111328178]);
AGR.TOC("maxes","L38G1-max5W1",[101665901]);
AGR.TOC("cyclic","L38G1-cycW1",[-13426753]);
AGR.TOC("out","L38G1-a3W1",[-4207554]);
AGR.TOC("out","L38G1-a6W1",[-85703423]);
AGR.TOC("check","L38G1-check1",[98473383]);

# L38d2
AGR.GRP("lin","L38","L38d2");
AGR.TOC("perm","L38d2G1-p146B0.m",[-94955132,-112292624]);
AGR.TOC("perm","L38d2G1-p657B0.m",[30435745,-34395041]);
AGR.TOC("perm","L38d2G1-p4672B0.m",[66223655,-50929470]);
AGR.TOC("perm","L38d2G1-p56064B0.m",[104547485,-129071911]);
AGR.TOC("perm","L38d2G1-p75264B0.m",[40691055,-35873055]);
AGR.TOC("perm","L38d2G1-p98112B0.m",[-81730120,-26656673]);
AGR.TOC("matff","L38d2G1-f2r54B0.m",[98557351,-23750355]);
AGR.TOC("matff","L38d2G1-f3r511B0.m",[-98897088,-98980956]);
AGR.TOC("matff","L38d2G1-f7r72B0.m",[9067370,-7943961]);
AGR.TOC("matff","L38d2G1-f7r512B0.m",[-79802053,102557660]);
AGR.TOC("matff","L38d2G1-f8r6B0.m",[-128895817,52766612]);
AGR.TOC("matff","L38d2G1-f8r8B0.m",[76285973,-92596710]);
AGR.TOC("matff","L38d2G1-f8r18aB0.m",[-90517385,-90105844]);
AGR.TOC("matff","L38d2G1-f8r18bB0.m",[39866721,-33916835]);
AGR.TOC("matff","L38d2G1-f8r48aB0.m",[-91069851,-114504242]);
AGR.TOC("matff","L38d2G1-f8r48bB0.m",[-81874300,60040123]);
AGR.TOC("matff","L38d2G1-f8r54B0.m",[-4260607,124828731]);
AGR.TOC("matff","L38d2G1-f8r64B0.m",[-122276359,116666796]);
AGR.TOC("matff","L38d2G1-f8r144aB0.m",[78652322,-42452376]);
AGR.TOC("matff","L38d2G1-f8r144bB0.m",[43008911,-91466156]);
AGR.TOC("matff","L38d2G1-f8r384B0.m",[-36200915,86527981]);
AGR.TOC("matff","L38d2G1-f9r72B0.m",[109248692,109968207]);
AGR.TOC("matff","L38d2G1-f73r71B0.m",[-119484075,-61189104]);
AGR.TOC("matff","L38d2G1-f73r441B0.m",[124710465,-85261250]);
AGR.TOC("matff","L38d2G1-f73r511aB0.m",[74045684,6998139]);
AGR.TOC("matff","L38d2G1-f73r511bB0.m",[-127060099,127704476]);
AGR.TOC("maxes","L38d2G1-max1W1",[-104229436]);
AGR.TOC("cyclic","L38d2G1-cycW1",[-127124674]);

# L38d3
AGR.GRP("lin","L38","L38d3");
AGR.TOC("perm","L38d3G1-p73aB0.m",[60158583,41378416]);
AGR.TOC("perm","L38d3G1-p73bB0.m",[64492430,73623080]);
AGR.TOC("perm","L38d3G1-p219aB0.m",[-52379589,-131711006]);
AGR.TOC("perm","L38d3G1-p219bB0.m",[-33738630,22308821]);
AGR.TOC("perm","L38d3G1-p56064B0.m",[38408933,43181430]);
AGR.TOC("perm","L38d3G1-p75264B0.m",[-28778762,-122715979]);
AGR.TOC("perm","L38d3G1-p98112B0.m",[109114039,4300594]);
AGR.TOC("matff","L38d3G1-f2r9B0.m",[-20084484,101484140]);
AGR.TOC("matff","L38d3G1-f2r24B0.m",[-55806868,80681738]);
AGR.TOC("matff","L38d3G1-f2r27aB0.m",[-51526903,45097681]);
AGR.TOC("matff","L38d3G1-f2r27bB0.m",[-15053373,-48460799]);
AGR.TOC("matff","L38d3G1-f2r27cB0.m",[37582657,38692959]);
AGR.TOC("matff","L38d3G1-f2r72aB0.m",[63869636,-19582455]);
AGR.TOC("matff","L38d3G1-f2r72bB0.m",[-3653919,117200050]);
AGR.TOC("matff","L38d3G1-f2r81B0.m",[-30896926,-28846440]);
AGR.TOC("matff","L38d3G1-f2r192B0.m",[6107990,106607000]);
AGR.TOC("matff","L38d3G1-f2r216aB0.m",[-26503866,49500718]);
AGR.TOC("matff","L38d3G1-f2r216bB0.m",[47670388,86661620]);
AGR.TOC("matff","L38d3G1-f2r576B0.m",[85301581,132157423]);
AGR.TOC("matff","L38d3G1-f3r72B0.m",[-58390532,-42192185]);
AGR.TOC("matff","L38d3G1-f3r511B0.m",[-33656045,-21320385]);
AGR.TOC("matff","L38d3G1-f7r72B0.m",[32023300,38080482]);
AGR.TOC("matff","L38d3G1-f7r511B0.m",[126996729,-76266671]);
AGR.TOC("matff","L38d3G1-f7r512B0.m",[95227596,-108324848]);
AGR.TOC("matff","L38d3G1-f73r71B0.m",[22143677,126112509]);
AGR.TOC("matff","L38d3G1-f73r441B0.m",[61959137,-38741676]);
AGR.TOC("matff","L38d3G1-f73r511aB0.m",[-72104415,5739869]);
AGR.TOC("maxes","L38d3G1-max1W1",[-90168709]);
AGR.TOC("maxes","L38d3G1-max2W1",[115911000]);
AGR.TOC("maxes","L38d3G1-max3W1",[-40477011]);
AGR.TOC("maxes","L38d3G1-max4W1",[-87098269]);
AGR.TOC("maxes","L38d3G1-max5W1",[122880442]);
AGR.TOC("maxes","L38d3G1-max6W1",[-32492270]);
AGR.TOC("cyclic","L38d3G1-cycW1",[132160406]);

# L38d6
AGR.GRP("lin","L38","L38d6");
AGR.TOC("perm","L38d6G1-p438B0.m",[36979974,-129349004]);
AGR.TOC("perm","L38d6G1-p657B0.m",[-121018827,89574532]);
AGR.TOC("perm","L38d6G1-p4672B0.m",[-16396462,-121176168]);
AGR.TOC("perm","L38d6G1-p56064B0.m",[-11875828,-89403590]);
AGR.TOC("perm","L38d6G1-p75264B0.m",[-55307927,28998015]);
AGR.TOC("perm","L38d6G1-p98112B0.m",[-84935205,-27579668]);
AGR.TOC("matff","L38d6G1-f2r18B0.m",[-97825654,112002520]);
AGR.TOC("matff","L38d6G1-f2r24B0.m",[18149513,-94429235]);
AGR.TOC("matff","L38d6G1-f2r54aB0.m",[37299043,43647713]);
AGR.TOC("matff","L38d6G1-f2r54bB0.m",[35348036,-30831590]);
AGR.TOC("matff","L38d6G1-f2r144aB0.m",[103814136,3817046]);
AGR.TOC("matff","L38d6G1-f2r144bB0.m",[69562980,-50032280]);
AGR.TOC("matff","L38d6G1-f2r162B0.m",[113830665,-112260504]);
AGR.TOC("matff","L38d6G1-f2r192B0.m",[62204946,36556265]);
AGR.TOC("matff","L38d6G1-f2r432aB0.m",[73951256,-67106930]);
AGR.TOC("matff","L38d6G1-f2r432bB0.m",[115376089,-96173383]);
AGR.TOC("matff","L38d6G1-f2r512B0.m",[65776895,66541066]);
AGR.TOC("matff","L38d6G1-f2r1152B0.m",[-117654589,10646833]);
AGR.TOC("matff","L38d6G1-f3r511B0.m",[-49219385,-46592666]);
AGR.TOC("matff","L38d6G1-f7r72B0.m",[-73502741,-62173098]);
AGR.TOC("matff","L38d6G1-f7r511B0.m",[73478384,22560211]);
AGR.TOC("matff","L38d6G1-f7r512B0.m",[-77529684,10596156]);
AGR.TOC("matff","L38d6G1-f9r72B0.m",[-39098903,81571638]);
AGR.TOC("matff","L38d6G1-f73r71B0.m",[18945244,-94167432]);
AGR.TOC("matff","L38d6G1-f73r441B0.m",[36170806,-132016127]);
AGR.TOC("matff","L38d6G1-f73r511aB0.m",[-54022418,-24968416]);
AGR.TOC("maxes","L38d6G1-max1W1",[71490578]);
AGR.TOC("maxes","L38d6G1-max2W1",[-72072915]);
AGR.TOC("maxes","L38d6G1-max3W1",[117563145]);
AGR.TOC("maxes","L38d6G1-max4W1",[119177432]);
AGR.TOC("maxes","L38d6G1-max5W1",[26193617]);
AGR.TOC("maxes","L38d6G1-max6W1",[-85632843]);
AGR.TOC("maxes","L38d6G1-max7W1",[-20516977]);
AGR.TOC("cyclic","L38d6G1-cycW1",[-57509535]);

# L39
AGR.GRP("lin","L39","L39");
AGR.TOC("check","L39G1-check1",[-106025308]);

# L43
AGR.GRP("lin","L43","L43");
AGR.TOC("matint","L43G1-Zr26aB0.g",[-105586726]);
AGR.TOC("matint","L43G1-Zr26bB0.g",[14322428]);
AGR.TOC("matint","L43G1-Zr39B0.g",[-70747561]);
AGR.TOC("matint","L43G1-Zr52B0.g",[-117944432]);
AGR.TOC("matint","L43G1-Zr65aB0.g",[-43462609]);
AGR.TOC("matint","L43G1-Zr65bB0.g",[-79044824]);
AGR.TOC("matint","L43G1-Zr90B0.g",[-18794102]);
AGR.TOC("matint","L43G1-Zr234aB0.g",[115038350]);
AGR.TOC("matint","L43G1-Zr234bB0.g",[98732953]);
AGR.TOC("check","L43G1-check1",[-9877145]);

# L44
AGR.GRP("lin","L44","L44");
AGR.TOC("perm","L44G1-p85aB0.m",[-78273433,-83054224]);
AGR.TOC("perm","L44G1-p85bB0.m",[75764047,62341714]);
AGR.TOC("matint","L44G1-Zr84B0.g",[-41981437]);
AGR.TOC("matint","L44G1-Zr378B0.g",[9827047]);
AGR.TOC("matalg","L44G1-Ar85aB0.g",[65051230]);
AGR.TOC("matalg","L44G1-Ar85bB0.g",[-113492586]);
AGR.TOC("check","L44G1-check1",[22160128]);

# L45
AGR.GRP("lin","L45","L45");
AGR.TOC("perm","L45G1-p156aB0.m",[-52631321,-95640334]);
AGR.TOC("perm","L45G1-p156bB0.m",[87402899,82141888]);
AGR.TOC("matint","L45G1-Zr155B0.g",[-91636964]);
AGR.TOC("check","L45G1-check1",[-37437899]);

# L52
AGR.GRP("lin","L52","L52");
AGR.TOC("perm","L52G1-p31aB0.m",[44238159,-87456268]);
AGR.TOC("perm","L52G1-p155aB0.m",[20058840,906581]);
AGR.TOC("matff","L52G1-f2r5aB0.m",[117659138,34509354]);
AGR.TOC("matff","L52G1-f2r5bB0.m",[-7972919,68408550]);
AGR.TOC("matff","L52G1-f2r10aB0.m",[3800244,26474245]);
AGR.TOC("matff","L52G1-f2r10bB0.m",[-88519981,-80446320]);
AGR.TOC("matff","L52G1-f2r24B0.m",[96000672,88562428]);
AGR.TOC("matff","L52G1-f3r30B0.m",[54484155,64998207]);
AGR.TOC("matff","L52G1-f3r124B0.m",[25519913,59619982]);
AGR.TOC("matff","L52G1-f3r155B0.m",[-29387753,6992274]);
AGR.TOC("matff","L52G1-f5r30B0.m",[-114958227,27900155]);
AGR.TOC("matff","L52G1-f5r123B0.m",[-67781272,-58943096]);
AGR.TOC("matff","L52G1-f5r155B0.m",[97509981,46816609]);
AGR.TOC("matff","L52G1-f5r280B0.m",[-72093412,35289805]);
AGR.TOC("matff","L52G1-f7r30B0.m",[-122678498,-14639435]);
AGR.TOC("matff","L52G1-f7r94B0.m",[-8976263,-117502687]);
AGR.TOC("matff","L52G1-f7r280B0.m",[-20429654,41591762]);
AGR.TOC("matff","L52G1-f31r29B0.m",[121603472,75143693]);
AGR.TOC("matff","L52G1-f31r251B0.m",[110733005,-84251252]);
AGR.TOC("matint","L52G1-Zr30B0.g",[-5567868]);
AGR.TOC("matint","L52G1-Zr124B0.g",[-78209188]);
AGR.TOC("matint","L52G1-Zr155B0.g",[95433535]);
AGR.TOC("matint","L52G1-Zr217B0.g",[26459850]);
AGR.TOC("cyclic","L52G1-cycW1",[-15004991]);
AGR.TOC("cyc2ccl","L52G1cycW1-cclsW1",[101753667]);
AGR.TOC("check","L52G1-check1",[-5009189]);

# L52d2
AGR.GRP("lin","L52","L52d2");
AGR.TOC("perm","L52d2G1-p62B0.m",[-110495248,24684736]);
AGR.TOC("matff","L52d2G1-f2r10B0.m",[-126659050,118473857]);
AGR.TOC("matff","L52d2G1-f2r20B0.m",[3041509,-90924842]);
AGR.TOC("matff","L52d2G1-f2r24B0.m",[-92098935,2494118]);
AGR.TOC("matff","L52d2G1-f7r30aB0.m",[-119049059,87841622]);
AGR.TOC("matff","L52d2G1-f9r30aB0.m",[-35934743,-122816189]);
AGR.TOC("matff","L52d2G1-f25r30aB0.m",[129061717,-92741289]);
AGR.TOC("matff","L52d2G1-f31r29aB0.m",[-113552599,2445580]);
AGR.TOC("matalg","L52d2G1-Ar30B0.g",[-37178541]);
AGR.TOC("maxes","L52d2G1-max1W1",[64292511]);

# L53
AGR.GRP("lin","L53","L53");
AGR.TOC("check","L53G1-check1",[50844511]);

# L62
AGR.GRP("lin","L62","L62");
AGR.TOC("perm","L62G1-p63aB0.m",[88896673,60670713]);
AGR.TOC("matff","L62G1-f2r6aB0.m",[-18349149,132247211]);
AGR.TOC("matff","L62G1-f2r6bB0.m",[-127940522,-133387572]);
AGR.TOC("matff","L62G1-f2r15aB0.m",[-11382353,16344018]);
AGR.TOC("matff","L62G1-f2r15bB0.m",[36753227,-42154093]);
AGR.TOC("matff","L62G1-f2r20B0.m",[101082495,77405590]);
AGR.TOC("matff","L62G1-f2r34B0.m",[17695666,128732707]);
AGR.TOC("matff","L62G1-f2r70aB0.m",[-115887284,96029470]);
AGR.TOC("matff","L62G1-f2r84aB0.m",[36055239,21517382]);
AGR.TOC("matff","L62G1-f2r90aB0.m",[49552181,33888329]);
AGR.TOC("matff","L62G1-f2r154B0.m",[82795165,47912135]);
AGR.TOC("matff","L62G1-f2r204aB0.m",[-84134028,-22417203]);
AGR.TOC("matff","L62G1-f2r384aB0.m",[-112402423,-120497343]);
AGR.TOC("matff","L62G1-f2r400B0.m",[79892765,-66409544]);
AGR.TOC("matff","L62G1-f2r720aB0.m",[-40159375,17120413]);
AGR.TOC("matff","L62G1-f2r896aB0.m",[-33608139,61740883]);
AGR.TOC("matff","L62G1-f2r924aB0.m",[-51063019,-3036]);
AGR.TOC("matff","L62G1-f3r61B0.m",[113049745,113592053]);
AGR.TOC("matff","L62G1-f3r527aB0.m",[-123708430,116705172]);
AGR.TOC("matff","L62G1-f3r651aB0.m",[37700750,12005168]);
AGR.TOC("matff","L62G1-f5r62B0.m",[-32477555,-29104907]);
AGR.TOC("matff","L62G1-f7r61B0.m",[-49899997,-21319927]);
AGR.TOC("matff","L62G1-f31r62B0.m",[-18369723,-76443513]);
AGR.TOC("matint","L62G1-Zr62B0.g",[-43664004]);
AGR.TOC("matint","L62G1-Zr217B0.g",[-120280005]);
AGR.TOC("check","L62G1-check1",[-128056177]);

# L62d2
AGR.GRP("lin","L62","L62d2");
AGR.TOC("perm","L62d2G1-p126B0.m",[126561460,38194790]);
AGR.TOC("matff","L62d2G1-f2r12B0.m",[132741796,-10840949]);
AGR.TOC("matff","L62d2G1-f2r20B0.m",[63412771,120657148]);
AGR.TOC("matff","L62d2G1-f2r30B0.m",[129967205,29144201]);
AGR.TOC("matff","L62d2G1-f2r34B0.m",[42781856,39923097]);
AGR.TOC("matff","L62d2G1-f2r140B0.m",[-54481917,129496710]);
AGR.TOC("matff","L62d2G1-f2r154B0.m",[104291628,106847649]);
AGR.TOC("matff","L62d2G1-f2r168B0.m",[87080003,30041208]);
AGR.TOC("matff","L62d2G1-f2r180B0.m",[68264575,-43768955]);
AGR.TOC("matff","L62d2G1-f2r400B0.m",[120328526,56733634]);
AGR.TOC("matff","L62d2G1-f2r408B0.m",[72093766,-74055339]);
AGR.TOC("matff","L62d2G1-f2r768B0.m",[33911161,67412604]);
AGR.TOC("matff","L62d2G1-f3r61B0.m",[-52454721,76464843]);
AGR.TOC("matff","L62d2G1-f7r61B0.m",[73505777,58322991]);

# L72
AGR.GRP("lin","L72","L72");
AGR.TOC("perm","L72G1-p127aB0.m",[-81383982,38034596]);
AGR.TOC("perm","L72G1-p127bB0.m",[7090850,-108392131]);
AGR.TOC("matff","L72G1-f2r7aB0.m",[-21330232,42560205]);
AGR.TOC("matff","L72G1-f2r7bB0.m",[-97306786,42560205]);
AGR.TOC("matff","L72G1-f2r21aB0.m",[-110457920,-16494750]);
AGR.TOC("matff","L72G1-f2r21bB0.m",[-68616319,-16494750]);
AGR.TOC("matff","L72G1-f2r35aB0.m",[9604646,-31340289]);
AGR.TOC("matff","L72G1-f2r35bB0.m",[-1733234,-31340289]);
AGR.TOC("matff","L72G1-f2r48B0.m",[128664083,90971411]);
AGR.TOC("matff","L72G1-f2r112aB0.m",[-18523005,113454681]);
AGR.TOC("matff","L72G1-f2r112bB0.m",[-2928804,34502407]);
AGR.TOC("matff","L72G1-f2r133aB0.m",[22712273,91837444]);
AGR.TOC("matff","L72G1-f2r133bB0.m",[-47371223,-82210044]);
AGR.TOC("matff","L72G1-f2r175aB0.m",[7545761,100567812]);
AGR.TOC("matff","L72G1-f2r175bB0.m",[124609280,35504851]);
AGR.TOC("matff","L72G1-f2r224aB0.m",[-4018295,36839543]);
AGR.TOC("matff","L72G1-f2r224bB0.m",[110699823,34836376]);
AGR.TOC("matff","L72G1-f2r392aB0.m",[-91126508,-60396410]);
AGR.TOC("matff","L72G1-f2r448aB0.m",[-102435570,-55158398]);
AGR.TOC("matff","L72G1-f2r448bB0.m",[-53014318,76675874]);
AGR.TOC("matff","L72G1-f2r469aB0.m",[106152181,33246968]);
AGR.TOC("matff","L72G1-f2r469bB0.m",[-64785497,116098298]);
AGR.TOC("matff","L72G1-f2r707aB0.m",[-121664307,-108999944]);
AGR.TOC("matff","L72G1-f2r707bB0.m",[-43898171,-1112464]);
AGR.TOC("matff","L72G1-f2r736aB0.m",[-100708947,24441535]);
AGR.TOC("matint","L72G1-Zr126B0.g",[-48092626]);
AGR.TOC("out","L72G1-aW1",[-14956717]);
AGR.TOC("check","L72G1-check1",[-44571660]);

# L72d2
AGR.GRP("lin","L72","L72d2");
AGR.TOC("perm","L72d2G2-p254B0.m",[82273786,126367704]);
AGR.TOC("matff","L72d2G2-f2r14B0.m",[-14888879,30789301]);
AGR.TOC("matff","L72d2G2-f2r42B0.m",[-118494604,35019580]);
AGR.TOC("matff","L72d2G2-f2r48B0.m",[71599376,48686250]);
AGR.TOC("matff","L72d2G2-f2r70B0.m",[-110150944,90502739]);
AGR.TOC("matff","L72d2G2-f2r224B0.m",[40466252,79118537]);
AGR.TOC("matff","L72d2G2-f2r266B0.m",[-82984030,41079968]);
AGR.TOC("matff","L72d2G2-f2r350B0.m",[25363888,6300827]);
AGR.TOC("matff","L72d2G2-f2r392B0.m",[67965109,46704526]);
AGR.TOC("matff","L72d2G2-f2r448B0.m",[104723254,-42979047]);
AGR.TOC("matff","L72d2G2-f2r736B0.m",[-30023214,-90205025]);
AGR.TOC("matff","L72d2G2-f2r896B0.m",[-65268227,80724372]);
AGR.TOC("matff","L72d2G2-f2r938B0.m",[26957333,91326988]);
AGR.TOC("maxes","L72d2G2-max1W1",[91749811]);

# 214U72
AGR.GRP("misc","214U72","214U72");
AGR.TOC("perm","214U72G1-p10836B0.m",[101662355,-20448920]);
AGR.TOC("pres","214U72G1-P1",[-44795026]);

# 24A8
AGR.GRP("misc","24A8","24A8");
AGR.TOC("perm","24A8G1-p30B0.m",[71903128,37028289]);
AGR.TOC("perm","24A8G1-p128B0.m",[103142313,-97409976]);
AGR.TOC("matff","24A8G1-f2r11aB0.m",[99167621,26151815]);
AGR.TOC("matff","24A8G1-f2r11bB0.m",[-12820998,-93726766]);
AGR.TOC("matff","24A8G1-f3r15B0.m",[26869337,-133096812]);
AGR.TOC("matff","24A8G1-f5r15B0.m",[-27766627,-32279966]);
AGR.TOC("matff","24A8G1-f7r15B0.m",[7718146,-65885648]);
AGR.TOC("matint","24A8G1-Zr15B0.g",[79329566]);
AGR.TOC("pres","24A8G1-P1",[-4293007]);

# 25L52
AGR.GRP("misc","25L52","25L52");
AGR.TOC("perm","25L52G1-p7440aB0.m",[-111345195,36618894]);
AGR.TOC("perm","25L52G1-p7440bB0.m",[74024818,130615649]);
AGR.TOC("perm","25L52G1-p7440cB0.m",[-31888628,114305088]);
AGR.TOC("matff","25L52G1-f2r69aB0.m",[-100207434,-56556235]);
AGR.TOC("matff","25L52G1-f3r248B0.m",[39814315,-98948311]);
AGR.TOC("matff","25L52G1-f5r248B0.m",[48991917,-40151386]);
AGR.TOC("matff","25L52G1-f7r248B0.m",[123338324,-14974429]);
AGR.TOC("matff","25L52G1-f31r248B0.m",[112307036,-133345712]);
AGR.TOC("matint","25L52G1-Zr248B0.g",[32894565]);
AGR.TOC("pres","25L52G1-P1",[108336715]);

# 53L35
AGR.GRP("misc","53L35","53L35");
AGR.TOC("perm","53L35G2-p3875aB0.m",[98472640,-119922207]);
AGR.TOC("perm","53L35G2-p3875bB0.m",[111738352,7685159]);
AGR.TOC("perm","53L35G2-p4650B0.m",[116192969,-34288265]);
AGR.TOC("matff","53L35G2-f2r620B0.m",[117097329,-9236051]);
AGR.TOC("matff","53L35G2-f5r16aB0.m",[10221874,-86572601]);
AGR.TOC("switch","53L35G2-G1W1",[46907032]);
AGR.TOC("pres","53L35G2-P1",[101915599]);

# 2aM20
AGR.GRP("misc","M20","2aM20");
AGR.TOC("perm","2aM20G1-p12aB0.m",[62651319,-781632]);
AGR.TOC("perm","2aM20G1-p12bB0.m",[-88792816,-83421660]);
AGR.TOC("perm","2aM20G1-p20aB0.m",[11182399,-103525736]);
AGR.TOC("perm","2aM20G1-p20bB0.m",[37746633,-55981603]);
AGR.TOC("matint","2aM20G1-Zr6aB0.g",[-21861718]);
AGR.TOC("matint","2aM20G1-Zr6bB0.g",[95627447]);
AGR.TOC("matint","2aM20G1-Zr10aB0.g",[101100456]);
AGR.TOC("matint","2aM20G1-Zr10bB0.g",[73269269]);
AGR.TOC("matint","2aM20G1-Zr20B0.g",[49785939]);
AGR.TOC("matint","2aM20G1-Zr24B0.g",[87943307]);
AGR.TOC("matalg","2aM20G1-Ar12aB0.g",[-21550680]);
AGR.TOC("matalg","2aM20G1-Ar12bB0.g",[-8721855]);
AGR.TOC("matalg","2aM20G1-Ar12bB1.g",[-74282503]);

# 2bM20
AGR.GRP("misc","M20","2bM20");
AGR.TOC("perm","2bM20G1-p120aB0.m",[79963263,51514372]);

# 2cM20
AGR.GRP("misc","M20","2cM20");
AGR.TOC("perm","2cM20G1-p24B0.m",[69804398,100937538]);

# 4bM20
AGR.GRP("misc","M20","4bM20");
AGR.TOC("matalg","4bM20G1-Ar4aB0.g",[67976289]);
AGR.TOC("matalg","4bM20G1-Ar4aB1.g",[-45128870]);
AGR.TOC("matalg","4bM20G1-Ar20aB0.g",[116840853]);

# M20
AGR.GRP("misc","M20","M20");
AGR.TOC("perm","M20G1-p20aB0.m",[93460434,46892430]);
AGR.TOC("perm","M20G1-p20bB0.m",[35523536,22123653]);
AGR.TOC("perm","M20G1-p20cB0.m",[-90558672,-105944800]);
AGR.TOC("perm","M20G1-p20dB0.m",[55711193,78780772]);

# WF4
AGR.GRP("misc","WF4","WF4");
AGR.TOC("switch","WF4G1-G2W1",[-19840031]);
AGR.TOC("switch","WF4G2-G1W1",[-41178304]);

# B
AGR.GRP("spor","B","B");
AGR.TOC("matff","BG1-f2r4370B0.m",[22338679,9574104]);
AGR.TOC("matff","BG1-f3r4371B0.m",[-126623526,56117614]);
AGR.TOC("matff","BG1-f5r4371B0.m",[24387158,97293413]);
AGR.TOC("maxes","BG1-max1W1",[-23309410]);
AGR.TOC("maxes","BG1-max2W1",[130363232]);
AGR.TOC("maxes","BG1-max3W1",[65186353]);
AGR.TOC("maxes","BG1-max4W1",[112679756]);
AGR.TOC("maxes","BG1-max5W1",[70078050]);
AGR.TOC("maxes","BG1-max6W1",[-10240842]);
AGR.TOC("maxes","BG1-max7W1",[-95778125]);
AGR.TOC("maxes","BG1-max8W1",[-114561485]);
AGR.TOC("maxes","BG1-max9W1",[-64713162]);
AGR.TOC("maxes","BG1-max11W1",[-127479522]);
AGR.TOC("maxes","BG1-max13W1",[-65568147]);
AGR.TOC("maxes","BG1-max15W1",[105462971]);
AGR.TOC("maxes","BG1-max16W1",[8946418]);
AGR.TOC("maxes","BG1-max21W1",[82234366]);
AGR.TOC("maxes","BG1-max30W1",[110825337]);
AGR.TOC("cyclic","BG1-cycW1",[-35716530]);
AGR.TOC("find","BG1-find1",[-3578940]);
AGR.TOC("check","BG1-check1",[-68324730]);

# 2Co1
AGR.GRP("spor","Co1","2Co1");
AGR.TOC("perm","2Co1G1-p196560B0.m",[96415798,-69323281]);
AGR.TOC("matff","2Co1G1-f3r24B0.m",[-119030063,-130928121]);
AGR.TOC("matff","2Co1G1-f5r24B0.m",[-83812180,42833524]);
AGR.TOC("matff","2Co1G1-f7r24B0.m",[115296415,56216790]);
AGR.TOC("matff","2Co1G1-f11r24B0.m",[19082682,66033957]);
AGR.TOC("matff","2Co1G1-f13r24B0.m",[-111666123,108123541]);
AGR.TOC("matff","2Co1G1-f23r24B0.m",[88456885,65617027]);

# Co1
AGR.GRP("spor","Co1","Co1");
AGR.TOC("perm","Co1G1-p98280B0.m",[24079381,103472469]);
AGR.TOC("matff","Co1G1-f2r24B0.m",[16454603,-78294134]);
AGR.TOC("matff","Co1G1-f2r274B0.m",[-107262491,33000833]);
AGR.TOC("matff","Co1G1-f3r276B0.m",[-57677093,-99619174]);
AGR.TOC("matff","Co1G1-f3r298B0.m",[-76486186,64745408]);
AGR.TOC("matff","Co1G1-f5r276B0.m",[-105083684,37119347]);
AGR.TOC("matff","Co1G1-f5r299B0.m",[53433007,20960457]);
AGR.TOC("matff","Co1G1-f7r276B0.m",[-88453631,-96574878]);
AGR.TOC("matff","Co1G1-f7r299B0.m",[34613385,36463682]);
AGR.TOC("matff","Co1G1-f11r276B0.m",[-44418337,5438777]);
AGR.TOC("matff","Co1G1-f11r299B0.m",[36501426,-57769629]);
AGR.TOC("matff","Co1G1-f13r276B0.m",[-118172147,-25718111]);
AGR.TOC("matff","Co1G1-f13r299B0.m",[44995352,111058082]);
AGR.TOC("matff","Co1G1-f23r276B0.m",[-89714154,-2462119]);
AGR.TOC("matff","Co1G1-f23r299B0.m",[-42410101,-35172656]);
AGR.TOC("maxes","Co1G1-max1W1",[-69842982]);
AGR.TOC("maxes","Co1G1-max2W1",[-42577851]);
AGR.TOC("maxes","Co1G1-max3W1",[29824571]);
AGR.TOC("maxes","Co1G1-max4W1",[60576186]);
AGR.TOC("maxes","Co1G1-max5W1",[114366811]);
AGR.TOC("maxes","Co1G1-max6W1",[-59185387]);
AGR.TOC("cyclic","Co1G1-cycW1",[-31434513]);
AGR.TOC("find","Co1G1-find1",[-106430356]);
AGR.TOC("check","Co1G1-check1",[34503407]);

# Co2
AGR.GRP("spor","Co2","Co2");
AGR.TOC("perm","Co2G1-p2300B0.m",[-68977590,58232971]);
AGR.TOC("perm","Co2G1-p4600B0.m",[-96460373,-98916563]);
AGR.TOC("matff","Co2G1-f2r22B0.m",[-54309341,-74421533]);
AGR.TOC("matff","Co2G1-f2r24B0.m",[73783853,29191204]);
AGR.TOC("matff","Co2G1-f2r230B0.m",[-75568974,26428654]);
AGR.TOC("matff","Co2G1-f2r748aB0.m",[29333647,96025108]);
AGR.TOC("matff","Co2G1-f2r748bB0.m",[-49568317,-76673767]);
AGR.TOC("matff","Co2G1-f3r23B0.m",[-119021965,-88874426]);
AGR.TOC("matff","Co2G1-f3r253B0.m",[-97217736,48922294]);
AGR.TOC("matff","Co2G1-f3r275B0.m",[-83554978,-71118237]);
AGR.TOC("matff","Co2G1-f5r23B0.m",[-103186525,3819505]);
AGR.TOC("matff","Co2G1-f5r253B0.m",[111518393,-29520466]);
AGR.TOC("matff","Co2G1-f5r275B0.m",[8519041,125012307]);
AGR.TOC("matff","Co2G1-f7r23B0.m",[-25660649,-107582364]);
AGR.TOC("matff","Co2G1-f7r253B0.m",[-13423944,-36779946]);
AGR.TOC("matff","Co2G1-f7r275B0.m",[116483568,6268174]);
AGR.TOC("matff","Co2G1-f11r23B0.m",[-14178919,-32787383]);
AGR.TOC("matff","Co2G1-f11r253B0.m",[-70822799,30995569]);
AGR.TOC("matff","Co2G1-f11r275B0.m",[-41272403,-123816874]);
AGR.TOC("matff","Co2G1-f23r23B0.m",[-15909867,113781741]);
AGR.TOC("matff","Co2G1-f23r253B0.m",[17672728,-82152779]);
AGR.TOC("matff","Co2G1-f23r274B0.m",[6001910,70254650]);
AGR.TOC("matint","Co2G1-Zr23B0.g",[-130083053]);
AGR.TOC("maxes","Co2G1-max1W1",[93481466]);
AGR.TOC("maxes","Co2G1-max1W2",[27705387]);
AGR.TOC("maxes","Co2G1-max2W1",[-45537986]);
AGR.TOC("maxes","Co2G1-max3W1",[18205426]);
AGR.TOC("maxes","Co2G1-max4W1",[-36718201]);
AGR.TOC("maxes","Co2G1-max5W1",[56120055]);
AGR.TOC("maxes","Co2G1-max6W1",[-104533060]);
AGR.TOC("maxes","Co2G1-max7W1",[1295619]);
AGR.TOC("maxes","Co2G1-max8W1",[123959784]);
AGR.TOC("maxes","Co2G1-max9W1",[-34639062]);
AGR.TOC("maxes","Co2G1-max10W1",[6064278]);
AGR.TOC("maxes","Co2G1-max11W1",[-41695303]);
AGR.TOC("cyclic","Co2G1-cycW1",[88608625]);
AGR.TOC("cyc2ccl","Co2G1cycW1-cclsW1",[-19670829]);
AGR.TOC("find","Co2G1-find1",[-84924881]);
AGR.TOC("check","Co2G1-check1",[-66751243]);
AGR.TOC("pres","Co2G1-P1",[128912454]);

# Co3
AGR.GRP("spor","Co3","Co3");
AGR.TOC("perm","Co3G1-p276B0.m",[14582085,-90782896]);
AGR.TOC("perm","Co3G1-p552B0.m",[-2683827,-15482699]);
AGR.TOC("perm","Co3G1-p11178B0.m",[61831036,-5901219]);
AGR.TOC("perm","Co3G1-p37950B0.m",[107359696,-31625813]);
AGR.TOC("perm","Co3G1-p48600B0.m",[67942847,24481707]);
AGR.TOC("perm","Co3G1-p128800B0.m",[96644160,-97082857]);
AGR.TOC("matff","Co3G1-f2r22B0.m",[-99639671,-25341638]);
AGR.TOC("matff","Co3G1-f2r230B0.m",[57395912,27550237]);
AGR.TOC("matff","Co3G1-f3r22B0.m",[7767996,-98496962]);
AGR.TOC("matff","Co3G1-f3r126aB0.m",[33697170,-7230725]);
AGR.TOC("matff","Co3G1-f3r126bB0.m",[89222635,-133975717]);
AGR.TOC("matff","Co3G1-f3r231aB0.m",[-85181500,33307552]);
AGR.TOC("matff","Co3G1-f3r231bB0.m",[-128218667,53213596]);
AGR.TOC("matff","Co3G1-f3r770aB0.m",[3916846,23268085]);
AGR.TOC("matff","Co3G1-f3r770bB0.m",[29336149,-5986270]);
AGR.TOC("matff","Co3G1-f4r896aB0.m",[121896551,-127775391]);
AGR.TOC("matff","Co3G1-f5r23B0.m",[-123447962,35769919]);
AGR.TOC("matff","Co3G1-f5r230B0.m",[-123551581,-97913685]);
AGR.TOC("matff","Co3G1-f5r253B0.m",[-83370110,-18097492]);
AGR.TOC("matff","Co3G1-f5r275B0.m",[-109041971,52099922]);
AGR.TOC("matff","Co3G1-f5r896bB0.m",[92235095,-1699054]);
AGR.TOC("matff","Co3G1-f7r23B0.m",[-111077282,118209855]);
AGR.TOC("matff","Co3G1-f7r253aB0.m",[-70514219,85872691]);
AGR.TOC("matff","Co3G1-f7r253bB0.m",[123245056,-95958002]);
AGR.TOC("matff","Co3G1-f7r275B0.m",[-112894711,-9483951]);
AGR.TOC("matff","Co3G1-f11r23B0.m",[-72428323,-12096837]);
AGR.TOC("matff","Co3G1-f11r253aB0.m",[31289485,-69770237]);
AGR.TOC("matff","Co3G1-f11r253bB0.m",[-103946322,33707076]);
AGR.TOC("matff","Co3G1-f11r275B0.m",[-29543137,102931089]);
AGR.TOC("matff","Co3G1-f11r896B0.m",[102751052,-107518067]);
AGR.TOC("matff","Co3G1-f23r23B0.m",[4706214,-31841620]);
AGR.TOC("matff","Co3G1-f23r253aB0.m",[-96285288,86032464]);
AGR.TOC("matff","Co3G1-f23r253bB0.m",[-110052111,111491396]);
AGR.TOC("matff","Co3G1-f23r274B0.m",[126519047,-81971889]);
AGR.TOC("matff","Co3G1-f23r896bB0.m",[-27578092,109234992]);
AGR.TOC("matff","Co3G1-f49r896aB0.m",[18940849,-48431705]);
AGR.TOC("matint","Co3G1-Zr23B0.g",[-117550955]);
AGR.TOC("maxes","Co3G1-max1W1",[34723362]);
AGR.TOC("maxes","Co3G1-max2W1",[56133327]);
AGR.TOC("maxes","Co3G1-max3W1",[53815989]);
AGR.TOC("maxes","Co3G1-max4W1",[-30650499]);
AGR.TOC("maxes","Co3G1-max5W1",[128309913]);
AGR.TOC("maxes","Co3G1-max6W1",[-128645195]);
AGR.TOC("maxes","Co3G1-max7W1",[-60889528]);
AGR.TOC("maxes","Co3G1-max8W1",[77677694]);
AGR.TOC("maxes","Co3G1-max9W1",[-118689150]);
AGR.TOC("maxes","Co3G1-max10W1",[-75692053]);
AGR.TOC("maxes","Co3G1-max11W1",[58775119]);
AGR.TOC("maxes","Co3G1-max12W1",[-37663486]);
AGR.TOC("maxes","Co3G1-max12W2",[-2138577]);
AGR.TOC("maxes","Co3G1-max13W1",[-17315091]);
AGR.TOC("maxes","Co3G1-max14W1",[-28030005]);
AGR.TOC("maxes","Co3G1-max14W2",[73664607]);
AGR.TOC("cyclic","Co3G1-cycW1",[54960889]);
AGR.TOC("cyc2ccl","Co3G1cycW1-cclsW1",[-89036463]);
AGR.TOC("find","Co3G1-find1",[-51775057]);
AGR.TOC("check","Co3G1-check1",[78322190]);

# 2F22
AGR.GRP("spor","F22","2F22");
AGR.TOC("perm","2F22G1-p28160B0.m",[-88132950,-90185326]);
AGR.TOC("perm","2F22G1-p123552B0.m",[-38471060,6945723]);
AGR.TOC("matff","2F22G1-f3r176aB0.m",[-67510771,17530026]);
AGR.TOC("matff","2F22G1-f5r352B0.m",[130371429,35452046]);
AGR.TOC("matff","2F22G1-f7r352B0.m",[-108835620,89735486]);
AGR.TOC("matff","2F22G1-f11r352B0.m",[-105641125,80175210]);
AGR.TOC("matff","2F22G1-f13r352B0.m",[-19356946,58859946]);
AGR.TOC("pres","2F22G1-P1",[-11319988]);

# 2F22d2
AGR.GRP("spor","F22","2F22d2");
AGR.TOC("perm","2F22d2G1-p56320B0.m",[76652605,2337280]);
AGR.TOC("matff","2F22d2G1-f3r352B0.m",[130547494,120956446]);

# 3F22
AGR.GRP("spor","F22","3F22");
AGR.TOC("perm","3F22G1-p185328B0.m",[16928294,88751270]);
AGR.TOC("matff","3F22G1-f4r27aB0.m",[54271746,25048988]);
AGR.TOC("matff","3F22G1-f7r351aB0.m",[-107454340,-29445358]);

# 3F22d2
AGR.GRP("spor","F22","3F22d2");
AGR.TOC("perm","3F22d2G1-p185328B0.m",[-17081867,-43586215]);
AGR.TOC("matff","3F22d2G1-f2r54B0.m",[-44189973,-132306928]);
AGR.TOC("matff","3F22d2G1-f7r702B0.m",[91703397,-29428399]);
AGR.TOC("pres","3F22d2G1-P1",[65265659]);

# F22
AGR.GRP("spor","F22","F22");
AGR.TOC("perm","F22G1-p3510B0.m",[88013596,112000128]);
AGR.TOC("perm","F22G1-p14080bB0.m",[-9736640,43017714]);
AGR.TOC("perm","F22G1-p61776B0.m",[-69687014,28989532]);
AGR.TOC("perm","F22G1-p142155B0.m",[-64459092,-100815434]);
AGR.TOC("perm","F22G1-p694980B0.m",[-12910822,6552950]);
AGR.TOC("matff","F22G1-f2r78B0.m",[-109087521,86079833]);
AGR.TOC("matff","F22G1-f2r350B0.m",[53992322,44682214]);
AGR.TOC("matff","F22G1-f2r572B0.m",[-56558559,-83410488]);
AGR.TOC("matff","F22G1-f3r77B0.m",[58601014,-70924339]);
AGR.TOC("matff","F22G1-f3r351B0.m",[112711273,-97010383]);
AGR.TOC("matff","F22G1-f3r924B0.m",[20017076,62757725]);
AGR.TOC("matff","F22G1-f5r78B0.m",[51985420,2099863]);
AGR.TOC("matff","F22G1-f5r428B0.m",[132955030,41517148]);
AGR.TOC("matff","F22G1-f7r78B0.m",[-46420014,73444335]);
AGR.TOC("matff","F22G1-f7r429B0.m",[36025548,-23873812]);
AGR.TOC("matff","F22G1-f11r78B0.m",[-66379967,-31535389]);
AGR.TOC("matff","F22G1-f11r429B0.m",[80858669,-90269841]);
AGR.TOC("matff","F22G1-f13r78B0.m",[-59693717,-34590081]);
AGR.TOC("matff","F22G1-f13r429B0.m",[-86809294,105048163]);
AGR.TOC("matint","F22G1-Zr78B0.g",[3581979]);
AGR.TOC("maxes","F22G1-max1W1",[49457212]);
AGR.TOC("maxes","F22G1-max2W1",[-133744913]);
AGR.TOC("maxes","F22G1-max3W1",[-127391878]);
AGR.TOC("maxes","F22G1-max3W2",[-17534642]);
AGR.TOC("maxes","F22G1-max4W1",[-97469408]);
AGR.TOC("maxes","F22G1-max5W1",[-72007604]);
AGR.TOC("maxes","F22G1-max6W1",[-69093545]);
AGR.TOC("maxes","F22G1-max7W1",[71881397]);
AGR.TOC("maxes","F22G1-max8W1",[40347112]);
AGR.TOC("maxes","F22G1-max9W1",[98121755]);
AGR.TOC("maxes","F22G1-max10W1",[2329153]);
AGR.TOC("maxes","F22G1-max11W1",[-54590247]);
AGR.TOC("maxes","F22G1-max12W1",[132206444]);
AGR.TOC("maxes","F22G1-max13W2",[-30231311]);
AGR.TOC("maxes","F22G1-max13W1",[-32889192]);
AGR.TOC("maxes","F22G1-max14W1",[-59341090]);
AGR.TOC("cyclic","F22G1-cycW1",[38092830]);
AGR.TOC("find","F22G1-find1",[-119041567]);
AGR.TOC("check","F22G1-check1",[-84596773]);
AGR.TOC("pres","F22G1-P1",[-130721090]);

# F22d2
AGR.GRP("spor","F22","F22d2");
AGR.TOC("perm","F22d2G1-p3510B0.m",[122813462,7896709]);
AGR.TOC("matff","F22d2G1-f2r78B0.m",[95541956,-2293655]);
AGR.TOC("matff","F22d2G1-f2r350B0.m",[47684515,44646509]);
AGR.TOC("matff","F22d2G1-f2r572B0.m",[14778819,85403442]);
AGR.TOC("matff","F22d2G1-f2r1352B0.m",[20201205,74325336]);
AGR.TOC("matff","F22d2G1-f3r77aB0.m",[-76901730,61376488]);
AGR.TOC("matff","F22d2G1-f3r351B0.m",[-26721206,113304381]);
AGR.TOC("matff","F22d2G1-f3r924B0.m",[-20939834,-50311868]);
AGR.TOC("matff","F22d2G1-f5r78aB0.m",[128701136,-12166168]);
AGR.TOC("matff","F22d2G1-f5r428aB0.m",[-39131120,27681453]);
AGR.TOC("matff","F22d2G1-f7r78aB0.m",[-103001035,83371722]);
AGR.TOC("matff","F22d2G1-f7r429aB0.m",[115701320,-42249272]);
AGR.TOC("matff","F22d2G1-f11r78aB0.m",[-89871349,83293156]);
AGR.TOC("matff","F22d2G1-f11r429aB0.m",[49800099,6814782]);
AGR.TOC("matff","F22d2G1-f13r78aB0.m",[32289635,7349185]);
AGR.TOC("matff","F22d2G1-f13r429aB0.m",[127523643,-99866267]);
AGR.TOC("matint","F22d2G1-Zr78B0.g",[-5867682]);
AGR.TOC("maxes","F22d2G1-max1W1",[47591772]);
AGR.TOC("maxes","F22d2G1-max2W1",[-75205594]);
AGR.TOC("maxes","F22d2G1-max2W2",[-25527906]);
AGR.TOC("maxes","F22d2G1-max13W1",[63356964]);
AGR.TOC("find","F22d2G1-find1",[-29977100]);
AGR.TOC("check","F22d2G1-check1",[-21731301]);
AGR.TOC("pres","F22d2G1-P1",[56631505]);

# F23
AGR.GRP("spor","F23","F23");
AGR.TOC("perm","F23G1-p31671B0.m",[-109867621,-116920938]);
AGR.TOC("perm","F23G1-p137632B0.m",[-58299166,-108210543]);
AGR.TOC("perm","F23G1-p275264B0.m",[22664129,111673749]);
AGR.TOC("matff","F23G1-f2r782B0.m",[-45195278,-43838607]);
AGR.TOC("matff","F23G1-f2r1494B0.m",[-110910446,97103140]);
AGR.TOC("matff","F23G1-f3r253B0.m",[-29528849,99728135]);
AGR.TOC("matff","F23G1-f3r528B0.m",[-66608829,21448579]);
AGR.TOC("matff","F23G1-f5r782B0.m",[51442495,-35280106]);
AGR.TOC("matff","F23G1-f7r782B0.m",[94890358,97085917]);
AGR.TOC("matff","F23G1-f11r782B0.m",[113804675,14847872]);
AGR.TOC("matff","F23G1-f13r782B0.m",[-105224962,-31673757]);
AGR.TOC("matff","F23G1-f17r782B0.m",[-114471874,84914826]);
AGR.TOC("matff","F23G1-f23r782B0.m",[-134202733,-5142396]);
AGR.TOC("maxes","F23G1-max1W1",[-33074811]);
AGR.TOC("maxes","F23G1-max1W2",[63247261]);
AGR.TOC("maxes","F23G1-max2W1",[53548333]);
AGR.TOC("maxes","F23G1-max3W1",[92061685]);
AGR.TOC("maxes","F23G1-max4W1",[37397470]);
AGR.TOC("maxes","F23G1-max5W1",[-60568749]);
AGR.TOC("maxes","F23G1-max6W1",[64555088]);
AGR.TOC("maxes","F23G1-max9W1",[-54739683]);
AGR.TOC("maxes","F23G1-max10W1",[100950719]);
AGR.TOC("maxes","F23G1-max13W1",[21543454]);
AGR.TOC("maxes","F23G1-max14W1",[-6392675]);
AGR.TOC("cyclic","F23G1-cycW1",[-11430007]);
AGR.TOC("find","F23G1-find1",[49638304]);
AGR.TOC("check","F23G1-check1",[-28390111]);

# 3F24
AGR.GRP("spor","F24","3F24");
AGR.TOC("perm","3F24G1-p920808B0.m",[98989796,-62509770]);
AGR.TOC("matff","3F24G1-f4r783B0.m",[124251776,-55444228]);

# 3F24d2
AGR.GRP("spor","F24","3F24d2");
AGR.TOC("perm","3F24d2G1-p920808B0.m",[-125621829,-90081066]);
AGR.TOC("matff","3F24d2G1-f2r1566B0.m",[-51370379,-95716454]);

# F24
AGR.GRP("spor","F24","F24");
AGR.TOC("perm","F24G1-p306936B0.m",[54361344,-1810691]);
AGR.TOC("matff","F24G1-f2r3774B0.m",[66627348,120763364]);
AGR.TOC("matff","F24G1-f3r781B0.m",[-48772183,52620792]);
AGR.TOC("cyclic","F24G1-cycW1",[117407279]);
AGR.TOC("find","F24G1-find1",[36442676]);
AGR.TOC("check","F24G1-check1",[-118382915]);

# F24d2
AGR.GRP("spor","F24","F24d2");
AGR.TOC("perm","F24d2G1-p306936B0.m",[72541106,80284157]);
AGR.TOC("matff","F24d2G1-f3r781B0.m",[121745779,-36600171]);
AGR.TOC("maxes","F24d2G1-max1W1",[105412985]);
AGR.TOC("maxes","F24d2G1-max2W1",[-79295356]);
AGR.TOC("maxes","F24d2G1-max3W1",[93793339]);
AGR.TOC("maxes","F24d2G1-max4W1",[37390223]);
AGR.TOC("maxes","F24d2G1-max5W1",[-59017189]);
AGR.TOC("maxes","F24d2G1-max6W1",[-29653284]);
AGR.TOC("maxes","F24d2G1-max7W1",[54933709]);
AGR.TOC("maxes","F24d2G1-max8W1",[-76471747]);
AGR.TOC("maxes","F24d2G1-max9W1",[-115734141]);
AGR.TOC("maxes","F24d2G1-max10W1",[-107781352]);
AGR.TOC("maxes","F24d2G1-max11W1",[-84235325]);
AGR.TOC("maxes","F24d2G1-max12W1",[-112949748]);
AGR.TOC("maxes","F24d2G1-max13W1",[112375260]);
AGR.TOC("maxes","F24d2G1-max14W1",[107469716]);
AGR.TOC("maxes","F24d2G1-max15W1",[-48530803]);
AGR.TOC("maxes","F24d2G1-max16W1",[-121777928]);
AGR.TOC("maxes","F24d2G1-max17W1",[-111665551]);
AGR.TOC("maxes","F24d2G1-max18W1",[91832835]);
AGR.TOC("maxes","F24d2G1-max19W1",[-22571481]);
AGR.TOC("maxes","F24d2G1-max20W1",[2941626]);
AGR.TOC("maxes","F24d2G1-max21W1",[93208374]);
AGR.TOC("find","F24d2G1-find1",[61593130]);
AGR.TOC("check","F24d2G1-check1",[118274771]);

# HN
AGR.GRP("spor","HN","HN");
AGR.TOC("perm","HNG1-p1140000B0.m",[32853933,21005903]);
AGR.TOC("matff","HNG1-f2r760B0.m",[89062086,-16714142]);
AGR.TOC("matff","HNG1-f3r760B0.m",[-61491120,-129545822]);
AGR.TOC("matff","HNG1-f4r132aB0.m",[5151139,78849289]);
AGR.TOC("matff","HNG1-f4r132bB0.m",[41933222,-63692317]);
AGR.TOC("matff","HNG1-f4r133B0.m",[13138870,13634501]);
AGR.TOC("matff","HNG1-f4r2650aB0.m",[64027517,-54387001]);
AGR.TOC("matff","HNG1-f5r133B0.m",[-115607691,-38092195]);
AGR.TOC("matff","HNG1-f5r626B0.m",[70397839,113456339]);
AGR.TOC("matff","HNG1-f5r627B0.m",[-115025766,118011978]);
AGR.TOC("matff","HNG1-f7r760B0.m",[-123533355,79509308]);
AGR.TOC("matff","HNG1-f9r133aB0.m",[106063587,-109722313]);
AGR.TOC("matff","HNG1-f9r133bB0.m",[-86995469,110203185]);
AGR.TOC("matff","HNG1-f11r133aB0.m",[84956559,-14832941]);
AGR.TOC("matff","HNG1-f11r133bB0.m",[84956559,-119008248]);
AGR.TOC("matff","HNG1-f11r760B0.m",[-112060195,-121414820]);
AGR.TOC("matff","HNG1-f19r133aB0.m",[-25046747,-122833758]);
AGR.TOC("matff","HNG1-f19r133bB0.m",[-25046747,-8020480]);
AGR.TOC("matff","HNG1-f19r760B0.m",[30072934,-6664215]);
AGR.TOC("matff","HNG1-f49r133aB0.m",[-80497250,40264194]);
AGR.TOC("matff","HNG1-f49r133bB0.m",[-80497250,-130083872]);
AGR.TOC("maxes","HNG1-max1W1",[-79453819]);
AGR.TOC("maxes","HNG1-max2W1",[-48664089]);
AGR.TOC("maxes","HNG1-max3W1",[-108500642]);
AGR.TOC("maxes","HNG1-max4W1",[33191023]);
AGR.TOC("maxes","HNG1-max5W1",[-124464431]);
AGR.TOC("maxes","HNG1-max6W1",[125139500]);
AGR.TOC("maxes","HNG1-max7W1",[34088059]);
AGR.TOC("maxes","HNG1-max10W1",[86039496]);
AGR.TOC("maxes","HNG1-max11W1",[-130398866]);
AGR.TOC("maxes","HNG1-max12W1",[22691996]);
AGR.TOC("maxes","HNG1-max14W1",[106083458]);
AGR.TOC("cyclic","HNG1-cycW1",[41419292]);
AGR.TOC("cyc2ccl","HNG1cycW1-cclsW1",[-75748754]);
AGR.TOC("out","HNG1-a2W1",[127399345]);
AGR.TOC("find","HNG1-find1",[114642738]);
AGR.TOC("check","HNG1-check1",[107996829]);

# HNd2
AGR.GRP("spor","HN","HNd2");
AGR.TOC("matff","HNd2G1-f2r264B0.m",[-86337838,-74967666]);
AGR.TOC("matff","HNd2G1-f5r133B0.m",[107967366,114052582]);
AGR.TOC("maxes","HNd2G1-max1W1",[-59380275]);
AGR.TOC("maxes","HNd2G1-max2W1",[72220095]);
AGR.TOC("maxes","HNd2G1-max3W1",[19789101]);
AGR.TOC("maxes","HNd2G1-max4W1",[-120415217]);
AGR.TOC("maxes","HNd2G1-max5W1",[16567717]);
AGR.TOC("maxes","HNd2G1-max6W1",[27118928]);
AGR.TOC("maxes","HNd2G1-max7W1",[-1853532]);
AGR.TOC("maxes","HNd2G1-max8W1",[-113484495]);
AGR.TOC("maxes","HNd2G1-max9W1",[-36214413]);
AGR.TOC("maxes","HNd2G1-max10W1",[-126901570]);
AGR.TOC("maxes","HNd2G1-max11W1",[-84047681]);
AGR.TOC("maxes","HNd2G1-max12W1",[-109478497]);
AGR.TOC("maxes","HNd2G1-max13W1",[-131778850]);
AGR.TOC("find","HNd2G1-find1",[12123121]);
AGR.TOC("check","HNd2G1-check1",[-133434122]);

# 2HS
AGR.GRP("spor","HS","2HS");
AGR.TOC("perm","2HSG1-p704B0.m",[-109395951,117522876]);
AGR.TOC("perm","2HSG1-p4400B0.m",[14211745,-21341170]);
AGR.TOC("perm","2HSG1-p11200aB0.m",[-25662951,-72671730]);
AGR.TOC("matff","2HSG1-f3r56B0.m",[29617857,-84040410]);
AGR.TOC("matff","2HSG1-f3r440B0.m",[8458115,7091735]);
AGR.TOC("matff","2HSG1-f5r28bB0.m",[49997548,-8152916]);
AGR.TOC("matff","2HSG1-f5r120bB0.m",[-102064132,-17454221]);
AGR.TOC("matff","2HSG1-f5r440bB0.m",[21530211,33485463]);
AGR.TOC("matff","2HSG1-f7r56B0.m",[-16827217,-94324586]);
AGR.TOC("matff","2HSG1-f9r176bB0.m",[53472414,7717663]);
AGR.TOC("matff","2HSG1-f11r56B0.m",[-55817406,-9356149]);

# 2HSd2
AGR.GRP("spor","HS","2HSd2");
AGR.TOC("perm","2HSd2G1-p1408B0.m",[55485644,-85765607]);
AGR.TOC("matff","2HSd2G1-f3r112B0.m",[66532271,-45075769]);
AGR.TOC("matff","2HSd2G1-f5r56B0.m",[-37364297,11008849]);
AGR.TOC("matff","2HSd2G1-f9r56B0.m",[6322774,-130822293]);

# HS
AGR.GRP("spor","HS","HS");
AGR.TOC("perm","HSG1-p100B0.m",[-124787112,8830718]);
AGR.TOC("perm","HSG1-p176bB0.m",[-42157961,-64664893]);
AGR.TOC("perm","HSG1-p1100aB0.m",[62778996,-3021590]);
AGR.TOC("perm","HSG1-p1100bB0.m",[-58500379,-71383282]);
AGR.TOC("perm","HSG1-p3850B0.m",[46018718,-78720855]);
AGR.TOC("perm","HSG1-p4125B0.m",[5512571,-33882361]);
AGR.TOC("perm","HSG1-p5600aB0.m",[120562511,41623182]);
AGR.TOC("perm","HSG1-p15400B0.m",[99971444,-24579578]);
AGR.TOC("matff","HSG1-f2r20B0.m",[-110839928,73283444]);
AGR.TOC("matff","HSG1-f2r56B0.m",[3192799,69839091]);
AGR.TOC("matff","HSG1-f2r132B0.m",[115944678,64036296]);
AGR.TOC("matff","HSG1-f2r518B0.m",[-97262203,110789378]);
AGR.TOC("matff","HSG1-f2r1000B0.m",[66717808,-9856755]);
AGR.TOC("matff","HSG1-f3r22B0.m",[93991114,-14968607]);
AGR.TOC("matff","HSG1-f3r49aB0.m",[70877444,68387699]);
AGR.TOC("matff","HSG1-f3r49bB0.m",[22097890,-38965013]);
AGR.TOC("matff","HSG1-f3r77B0.m",[76092415,-11040903]);
AGR.TOC("matff","HSG1-f3r154aB0.m",[-14900053,-100838819]);
AGR.TOC("matff","HSG1-f3r154bB0.m",[68524548,101006348]);
AGR.TOC("matff","HSG1-f3r154cB0.m",[-51597134,73553996]);
AGR.TOC("matff","HSG1-f3r231B0.m",[-95965145,-14427037]);
AGR.TOC("matff","HSG1-f3r321B0.m",[-110835348,10032473]);
AGR.TOC("matff","HSG1-f3r693B0.m",[40448458,-133341140]);
AGR.TOC("matff","HSG1-f3r748B0.m",[-96691003,-131491770]);
AGR.TOC("matff","HSG1-f3r770aB0.m",[47339280,-117561384]);
AGR.TOC("matff","HSG1-f3r825B0.m",[68382465,104127473]);
AGR.TOC("matff","HSG1-f4r896aB0.m",[-30617770,103602086]);
AGR.TOC("matff","HSG1-f4r896bB0.m",[-95673772,4228568]);
AGR.TOC("matff","HSG1-f5r21B0.m",[-18043664,7995456]);
AGR.TOC("matff","HSG1-f5r55B0.m",[-32048849,-47336091]);
AGR.TOC("matff","HSG1-f5r98B0.m",[6191487,99758067]);
AGR.TOC("matff","HSG1-f5r133aB0.m",[18544119,-110577111]);
AGR.TOC("matff","HSG1-f5r133bB0.m",[-124542697,97466202]);
AGR.TOC("matff","HSG1-f5r175B0.m",[32636695,9681624]);
AGR.TOC("matff","HSG1-f5r210B0.m",[-3911328,97387527]);
AGR.TOC("matff","HSG1-f5r280aB0.m",[131594969,76134971]);
AGR.TOC("matff","HSG1-f5r518B0.m",[66778477,79548322]);
AGR.TOC("matff","HSG1-f5r650B0.m",[-89578289,50539996]);
AGR.TOC("matff","HSG1-f7r22B0.m",[-53162324,69175635]);
AGR.TOC("matff","HSG1-f7r77B0.m",[99238916,-36447346]);
AGR.TOC("matff","HSG1-f7r154aB0.m",[-7838882,101761107]);
AGR.TOC("matff","HSG1-f7r154bB0.m",[18760360,-66895717]);
AGR.TOC("matff","HSG1-f7r154cB0.m",[89744760,-126726394]);
AGR.TOC("matff","HSG1-f7r175B0.m",[-127648497,-10424629]);
AGR.TOC("matff","HSG1-f7r231B0.m",[98380256,-72328589]);
AGR.TOC("matff","HSG1-f7r605B0.m",[78865187,56877599]);
AGR.TOC("matff","HSG1-f7r693B0.m",[-74626881,-14425913]);
AGR.TOC("matff","HSG1-f7r770aB0.m",[-100706960,50439108]);
AGR.TOC("matff","HSG1-f7r770bB0.m",[112584500,111883459]);
AGR.TOC("matff","HSG1-f7r770cB0.m",[54727166,107839077]);
AGR.TOC("matff","HSG1-f7r803B0.m",[48999068,62525531]);
AGR.TOC("matff","HSG1-f11r22B0.m",[-103902786,131567279]);
AGR.TOC("matff","HSG1-f11r77B0.m",[105194963,34738593]);
AGR.TOC("matff","HSG1-f11r154aB0.m",[-94042976,1152264]);
AGR.TOC("matff","HSG1-f11r154bB0.m",[-63804252,-112522132]);
AGR.TOC("matff","HSG1-f11r154cB0.m",[-52658718,117648488]);
AGR.TOC("matff","HSG1-f11r174B0.m",[-79918725,-36530971]);
AGR.TOC("matff","HSG1-f11r231B0.m",[74378860,133955725]);
AGR.TOC("matff","HSG1-f11r693B0.m",[-53293843,-114165050]);
AGR.TOC("matff","HSG1-f11r770aB0.m",[-120037254,-54798718]);
AGR.TOC("matff","HSG1-f11r825B0.m",[-100355329,70421451]);
AGR.TOC("matff","HSG1-f11r854B0.m",[18463814,49643143]);
AGR.TOC("matff","HSG1-f11r896B0.m",[-25794072,-94267541]);
AGR.TOC("matff","HSG1-f49r896aB0.m",[-14346934,-87503340]);
AGR.TOC("matff","HSG1-f49r896bB0.m",[58422987,37738098]);
AGR.TOC("matff","HSG1-f121r770bB0.m",[97874222,96924629]);
AGR.TOC("matff","HSG1-f121r770cB0.m",[-117482532,46080873]);
AGR.TOC("matint","HSG1-Zr22B0.g",[2134773]);
AGR.TOC("matint","HSG1-Zr77B0.g",[-33461269]);
AGR.TOC("matint","HSG1-Zr154aB0.g",[128622008]);
AGR.TOC("matint","HSG1-Zr154bB0.g",[100889216]);
AGR.TOC("matint","HSG1-Zr154cB0.g",[52141046]);
AGR.TOC("matint","HSG1-Zr175B0.g",[-51974944]);
AGR.TOC("matint","HSG1-Zr231B0.g",[-799773]);
AGR.TOC("maxes","HSG1-max1W1",[-109670816]);
AGR.TOC("maxes","HSG1-max2W1",[77618700]);
AGR.TOC("maxes","HSG1-max3W1",[-131481863]);
AGR.TOC("maxes","HSG1-max4W1",[90334987]);
AGR.TOC("maxes","HSG1-max5W1",[125851852]);
AGR.TOC("maxes","HSG1-max6W1",[24989805]);
AGR.TOC("maxes","HSG1-max7W1",[60122846]);
AGR.TOC("maxes","HSG1-max8W1",[-80926385]);
AGR.TOC("maxes","HSG1-max9W1",[23183641]);
AGR.TOC("maxes","HSG1-max10W1",[-105738670]);
AGR.TOC("maxes","HSG1-max11W1",[-60962218]);
AGR.TOC("maxes","HSG1-max12W1",[129901534]);
AGR.TOC("cyclic","HSG1-cycW1",[27005916]);
AGR.TOC("cyc2ccl","HSG1cycW1-cclsW1",[-101829552]);
AGR.TOC("find","HSG1-find1",[-117818194]);
AGR.TOC("check","HSG1-check1",[18230266]);
AGR.TOC("pres","HSG1-P1",[89705474]);

# HSd2
AGR.GRP("spor","HS","HSd2");
AGR.TOC("perm","HSd2G1-p100B0.m",[-70324210,128569599]);
AGR.TOC("perm","HSd2G1-p352B0.m",[20999653,-109343943]);
AGR.TOC("perm","HSd2G1-p1100bB0.m",[-36595103,-2164206]);
AGR.TOC("perm","HSd2G1-p15400B0.m",[-14950196,-23862648]);
AGR.TOC("matff","HSd2G1-f2r20B0.m",[50037167,62072647]);
AGR.TOC("matff","HSd2G1-f2r22B0.m",[-9022325,-84815465]);
AGR.TOC("matff","HSd2G1-f2r56B0.m",[-21312538,119898817]);
AGR.TOC("matff","HSd2G1-f2r132B0.m",[-79665966,38128389]);
AGR.TOC("matff","HSd2G1-f2r518B0.m",[27012098,-78258800]);
AGR.TOC("matff","HSd2G1-f2r1000B0.m",[55224993,-20500465]);
AGR.TOC("matff","HSd2G1-f2r1408B0.m",[20027516,71784186]);
AGR.TOC("matff","HSd2G1-f2r1792B0.m",[47687018,-54149205]);
AGR.TOC("matff","HSd2G1-f3r22aB0.m",[98820765,4908381]);
AGR.TOC("matff","HSd2G1-f3r77aB0.m",[-25698705,17484980]);
AGR.TOC("matff","HSd2G1-f3r98aB0.m",[111392664,-61530638]);
AGR.TOC("matff","HSd2G1-f3r154aB0.m",[58277522,47474792]);
AGR.TOC("matff","HSd2G1-f3r231aB0.m",[99163037,86674182]);
AGR.TOC("matff","HSd2G1-f3r308aB0.m",[-117803754,7897029]);
AGR.TOC("matff","HSd2G1-f3r321aB0.m",[-37439220,-119136134]);
AGR.TOC("matff","HSd2G1-f3r693aB0.m",[-125727427,42412744]);
AGR.TOC("matff","HSd2G1-f3r748aB0.m",[-66305284,-54277114]);
AGR.TOC("matff","HSd2G1-f3r825aB0.m",[-26332833,123665127]);
AGR.TOC("matff","HSd2G1-f5r21aB0.m",[134122114,-39570726]);
AGR.TOC("matff","HSd2G1-f5r55aB0.m",[126444372,-71029769]);
AGR.TOC("matff","HSd2G1-f5r98aB0.m",[-19242410,46975984]);
AGR.TOC("matff","HSd2G1-f5r175aB0.m",[70650798,-55617375]);
AGR.TOC("matff","HSd2G1-f5r210aB0.m",[5604664,-82291763]);
AGR.TOC("matff","HSd2G1-f5r266aB0.m",[-121107292,-6080807]);
AGR.TOC("matff","HSd2G1-f5r518aB0.m",[-18803550,83470924]);
AGR.TOC("matff","HSd2G1-f5r560aB0.m",[-58629522,36792176]);
AGR.TOC("matff","HSd2G1-f5r650aB0.m",[-68196296,90913941]);
AGR.TOC("matff","HSd2G1-f7r22aB0.m",[48179117,73635985]);
AGR.TOC("matff","HSd2G1-f7r77aB0.m",[47363847,72878837]);
AGR.TOC("matff","HSd2G1-f7r154aB0.m",[-66777681,-132469520]);
AGR.TOC("matff","HSd2G1-f7r175aB0.m",[104627848,-59932879]);
AGR.TOC("matff","HSd2G1-f7r231aB0.m",[18774316,91260845]);
AGR.TOC("matff","HSd2G1-f7r308aB0.m",[96893028,-32303931]);
AGR.TOC("matff","HSd2G1-f7r605aB0.m",[26180019,71343374]);
AGR.TOC("matff","HSd2G1-f7r693B0.m",[-27097572,-17105054]);
AGR.TOC("matff","HSd2G1-f7r693aB0.m",[-89214575,-97072913]);
AGR.TOC("matff","HSd2G1-f7r770aB0.m",[96355805,-74428817]);
AGR.TOC("matff","HSd2G1-f7r803B0.m",[-46471106,18374938]);
AGR.TOC("matff","HSd2G1-f7r803aB0.m",[-39679207,-81368234]);
AGR.TOC("matff","HSd2G1-f11r22aB0.m",[-8259291,43508426]);
AGR.TOC("matff","HSd2G1-f11r77aB0.m",[-114093728,-53560645]);
AGR.TOC("matff","HSd2G1-f11r154aB0.m",[-42206112,-121821089]);
AGR.TOC("matff","HSd2G1-f11r174aB0.m",[63123284,121047128]);
AGR.TOC("matff","HSd2G1-f11r231aB0.m",[33514654,103434208]);
AGR.TOC("matff","HSd2G1-f11r308aB0.m",[-62014948,80454524]);
AGR.TOC("matff","HSd2G1-f11r693aB0.m",[22869622,-81673636]);
AGR.TOC("matff","HSd2G1-f11r770aB0.m",[16456349,8338033]);
AGR.TOC("matff","HSd2G1-f11r825aB0.m",[-54693786,-2601188]);
AGR.TOC("matff","HSd2G1-f11r854aB0.m",[89627605,-71298439]);
AGR.TOC("matff","HSd2G1-f11r896aB0.m",[-30365885,-116863938]);
AGR.TOC("maxes","HSd2G1-max1W1",[53167711]);
AGR.TOC("maxes","HSd2G1-max2W1",[-43880811]);
AGR.TOC("maxes","HSd2G1-max2W2",[-79295356]);
AGR.TOC("maxes","HSd2G1-max3W1",[-70581250]);
AGR.TOC("maxes","HSd2G1-max4W1",[82720027]);
AGR.TOC("maxes","HSd2G1-max4W2",[52422575]);
AGR.TOC("maxes","HSd2G1-max5W1",[-33881454]);
AGR.TOC("maxes","HSd2G1-max6W1",[-10734996]);
AGR.TOC("maxes","HSd2G1-max6W2",[87024687]);
AGR.TOC("maxes","HSd2G1-max7W1",[-124919375]);
AGR.TOC("maxes","HSd2G1-max8W1",[103553007]);
AGR.TOC("maxes","HSd2G1-max9W1",[-89255059]);
AGR.TOC("maxes","HSd2G1-max10W1",[98808984]);
AGR.TOC("find","HSd2G1-find1",[89130556]);
AGR.TOC("check","HSd2G1-check1",[-127212098]);
AGR.TOC("pres","HSd2G1-P1",[66598625]);

# He
AGR.GRP("spor","He","He");
AGR.TOC("perm","HeG1-p2058B0.m",[41643635,18077559]);
AGR.TOC("perm","HeG1-p8330B0.m",[-105415688,105842469]);
AGR.TOC("perm","HeG1-p29155B0.m",[-118796776,34096499]);
AGR.TOC("perm","HeG1-p244800B0.m",[33926117,19883176]);
AGR.TOC("matff","HeG1-f2r51B0.m",[54261715,93379919]);
AGR.TOC("matff","HeG1-f2r101B0.m",[128079215,-86715223]);
AGR.TOC("matff","HeG1-f2r246B0.m",[120635934,-89233606]);
AGR.TOC("matff","HeG1-f2r680B0.m",[-22851184,-61142644]);
AGR.TOC("matff","HeG1-f3r679B0.m",[-78652892,27940980]);
AGR.TOC("matff","HeG1-f5r104B0.m",[-5533390,-130515768]);
AGR.TOC("matff","HeG1-f5r680B0.m",[105609709,34895690]);
AGR.TOC("matff","HeG1-f7r50B0.m",[44448945,47371851]);
AGR.TOC("matff","HeG1-f7r153B0.m",[112176717,103563499]);
AGR.TOC("matff","HeG1-f7r426B0.m",[-51572347,-60147689]);
AGR.TOC("matff","HeG1-f7r798B0.m",[-65040027,-82579779]);
AGR.TOC("matff","HeG1-f9r51B0.m",[-87086101,3088062]);
AGR.TOC("matff","HeG1-f9r153aB0.m",[-116818601,115738898]);
AGR.TOC("matff","HeG1-f9r153bB0.m",[77633223,-70400496]);
AGR.TOC("matff","HeG1-f17r102B0.m",[3315927,-127149239]);
AGR.TOC("matff","HeG1-f17r306B0.m",[128990050,-87629342]);
AGR.TOC("matff","HeG1-f17r680B0.m",[51071750,-66766558]);
AGR.TOC("matff","HeG1-f25r51B0.m",[-17775458,-18096052]);
AGR.TOC("matff","HeG1-f25r153aB0.m",[-97341369,46064468]);
AGR.TOC("matff","HeG1-f25r153bB0.m",[123601479,-2193912]);
AGR.TOC("matff","HeG1-f25r925aB0.m",[-104334496,73025631]);
AGR.TOC("matff","HeG1-f25r925bB0.m",[-57226886,45741919]);
AGR.TOC("matint","HeG1-Zr102B0.g",[-111893033]);
AGR.TOC("maxes","HeG1-max1W1",[-43737733]);
AGR.TOC("maxes","HeG1-max2W1",[108117526]);
AGR.TOC("maxes","HeG1-max3W1",[-49949164]);
AGR.TOC("maxes","HeG1-max4W1",[-59289512]);
AGR.TOC("maxes","HeG1-max5W1",[-114225225]);
AGR.TOC("maxes","HeG1-max6W1",[78467075]);
AGR.TOC("maxes","HeG1-max7W1",[75076758]);
AGR.TOC("maxes","HeG1-max8W1",[14747238]);
AGR.TOC("maxes","HeG1-max9W1",[-90393776]);
AGR.TOC("maxes","HeG1-max10W1",[14033334]);
AGR.TOC("maxes","HeG1-max11W1",[4509856]);
AGR.TOC("cyclic","HeG1-cycW1",[104054059]);
AGR.TOC("out","HeG1-a2W1",[-124692776]);
AGR.TOC("find","HeG1-find1",[69669390]);
AGR.TOC("check","HeG1-check1",[9512126]);
AGR.TOC("pres","HeG1-P1",[-56250110]);

# Hed2
AGR.GRP("spor","He","Hed2");
AGR.TOC("perm","Hed2G1-p2058B0.m",[39787965,55630042]);
AGR.TOC("perm","Hed2G1-p8330B0.m",[-12875628,-124069945]);
AGR.TOC("matff","Hed2G1-f2r102B0.m",[128491948,-90059244]);
AGR.TOC("matff","Hed2G1-f2r202B0.m",[96817739,120850527]);
AGR.TOC("matff","Hed2G1-f2r492B0.m",[-4221368,-75050619]);
AGR.TOC("matff","Hed2G1-f2r680B0.m",[33151751,40011930]);
AGR.TOC("matff","Hed2G1-f3r102B0.m",[5013999,-47374312]);
AGR.TOC("matff","Hed2G1-f3r306aB0.m",[114920766,99957318]);
AGR.TOC("matff","Hed2G1-f3r679B0.m",[104816038,-29811480]);
AGR.TOC("matff","Hed2G1-f5r102B0.m",[-84552456,-42830816]);
AGR.TOC("matff","Hed2G1-f5r104aB0.m",[125317819,-23224809]);
AGR.TOC("matff","Hed2G1-f5r306aB0.m",[-59677416,-115950200]);
AGR.TOC("matff","Hed2G1-f5r680B0.m",[-27232831,-56698730]);
AGR.TOC("matff","Hed2G1-f7r50B0.m",[119854620,47601686]);
AGR.TOC("matff","Hed2G1-f7r153B0.m",[3483208,-66947991]);
AGR.TOC("matff","Hed2G1-f7r426B0.m",[-112614285,-41923149]);
AGR.TOC("matff","Hed2G1-f17r102B0.m",[-98678332,-10960323]);
AGR.TOC("matff","Hed2G1-f17r306aB0.m",[98194188,68830057]);
AGR.TOC("matff","Hed2G1-f17r680B0.m",[-80846352,5233036]);
AGR.TOC("maxes","Hed2G1-max1W1",[39571088]);
AGR.TOC("maxes","Hed2G1-max2W1",[86602080]);
AGR.TOC("maxes","Hed2G1-max2W2",[10926996]);
AGR.TOC("maxes","Hed2G1-max3W1",[-77901070]);
AGR.TOC("maxes","Hed2G1-max3W2",[-5889445]);
AGR.TOC("maxes","Hed2G1-max4W1",[46137349]);
AGR.TOC("maxes","Hed2G1-max4W2",[1777236]);
AGR.TOC("maxes","Hed2G1-max5W1",[78201159]);
AGR.TOC("maxes","Hed2G1-max6W1",[82572966]);
AGR.TOC("maxes","Hed2G1-max6W2",[-66410105]);
AGR.TOC("maxes","Hed2G1-max7W1",[-105158792]);
AGR.TOC("maxes","Hed2G1-max8W1",[43276992]);
AGR.TOC("maxes","Hed2G1-max9W1",[9241607]);
AGR.TOC("maxes","Hed2G1-max10W2",[131303494]);
AGR.TOC("maxes","Hed2G1-max10W1",[-128311249]);
AGR.TOC("maxes","Hed2G1-max11W1",[15765194]);
AGR.TOC("maxes","Hed2G1-max12W1",[126119732]);
AGR.TOC("find","Hed2G1-find1",[-5635868]);
AGR.TOC("check","Hed2G1-check1",[-9689119]);

# J1
AGR.GRP("spor","J1","J1");
AGR.TOC("perm","J1G1-p266B0.m",[22177126,-62974675]);
AGR.TOC("perm","J1G1-p1045B0.m",[-120206893,102168794]);
AGR.TOC("perm","J1G1-p1463B0.m",[-133715393,113823357]);
AGR.TOC("perm","J1G1-p1540B0.m",[75810120,-100787024]);
AGR.TOC("perm","J1G1-p1596B0.m",[101588624,-117563900]);
AGR.TOC("perm","J1G1-p2926B0.m",[81845562,-20014759]);
AGR.TOC("perm","J1G1-p4180B0.m",[-15995841,-28833662]);
AGR.TOC("matff","J1G1-f2r20B0.m",[-61004905,-87815118]);
AGR.TOC("matff","J1G1-f2r76aB0.m",[-101133014,5768976]);
AGR.TOC("matff","J1G1-f2r76bB0.m",[38608532,58707824]);
AGR.TOC("matff","J1G1-f2r112aB0.m",[-27762922,-39231978]);
AGR.TOC("matff","J1G1-f2r112bB0.m",[103022738,-30663498]);
AGR.TOC("matff","J1G1-f2r360B0.m",[71735870,-78934514]);
AGR.TOC("matff","J1G1-f3r76aB0.m",[47213066,109189926]);
AGR.TOC("matff","J1G1-f3r76bB0.m",[-13438726,-63081483]);
AGR.TOC("matff","J1G1-f3r112B0.m",[85516695,-115922964]);
AGR.TOC("matff","J1G1-f3r133B0.m",[55526379,109722479]);
AGR.TOC("matff","J1G1-f3r154B0.m",[-84775452,-97075575]);
AGR.TOC("matff","J1G1-f3r360B0.m",[-87211897,-121913277]);
AGR.TOC("matff","J1G1-f4r56aB0.m",[-5126658,50178985]);
AGR.TOC("matff","J1G1-f4r56bB0.m",[-106154690,-67274114]);
AGR.TOC("matff","J1G1-f4r56cB0.m",[-130903651,-12932254]);
AGR.TOC("matff","J1G1-f4r56dB0.m",[52608449,-5497505]);
AGR.TOC("matff","J1G1-f5r56B0.m",[120075672,-81860207]);
AGR.TOC("matff","J1G1-f5r76aB0.m",[-93215905,90094060]);
AGR.TOC("matff","J1G1-f5r76bB0.m",[98338005,-111548749]);
AGR.TOC("matff","J1G1-f5r77B0.m",[111788951,-2181113]);
AGR.TOC("matff","J1G1-f5r133B0.m",[-101139042,115099859]);
AGR.TOC("matff","J1G1-f5r360B0.m",[79519794,34617868]);
AGR.TOC("matff","J1G1-f7r31B0.m",[107812230,81267576]);
AGR.TOC("matff","J1G1-f7r45B0.m",[55047694,92422382]);
AGR.TOC("matff","J1G1-f7r75B0.m",[46773029,13337192]);
AGR.TOC("matff","J1G1-f7r77aB0.m",[88926029,-52130458]);
AGR.TOC("matff","J1G1-f7r89B0.m",[-47541426,46151913]);
AGR.TOC("matff","J1G1-f7r112B0.m",[-49729601,126089261]);
AGR.TOC("matff","J1G1-f7r120B0.m",[-134146223,-74849221]);
AGR.TOC("matff","J1G1-f7r133aB0.m",[100942778,-34392406]);
AGR.TOC("matff","J1G1-f7r154B0.m",[105431024,132068788]);
AGR.TOC("matff","J1G1-f7r266B0.m",[26589642,-35226900]);
AGR.TOC("matff","J1G1-f8r120aB0.m",[364715,124623442]);
AGR.TOC("matff","J1G1-f8r120bB0.m",[-133644121,-80473656]);
AGR.TOC("matff","J1G1-f8r120cB0.m",[-49808271,88217072]);
AGR.TOC("matff","J1G1-f9r56aB0.m",[127228489,51925005]);
AGR.TOC("matff","J1G1-f9r56bB0.m",[-68571042,-29047888]);
AGR.TOC("matff","J1G1-f9r77aB0.m",[-56987250,131399361]);
AGR.TOC("matff","J1G1-f9r77bB0.m",[37261836,-33773054]);
AGR.TOC("matff","J1G1-f11r7B0.m",[-9911341,-80003292]);
AGR.TOC("matff","J1G1-f11r14B0.m",[-117124269,92507682]);
AGR.TOC("matff","J1G1-f11r27B0.m",[-89301207,46608694]);
AGR.TOC("matff","J1G1-f11r49B0.m",[123525147,5925104]);
AGR.TOC("matff","J1G1-f11r56B0.m",[134047400,-58386021]);
AGR.TOC("matff","J1G1-f11r64B0.m",[-131656409,-132788035]);
AGR.TOC("matff","J1G1-f11r69B0.m",[106677382,-85852958]);
AGR.TOC("matff","J1G1-f11r77aB0.m",[-36509359,-117909918]);
AGR.TOC("matff","J1G1-f11r77bB0.m",[-41736705,-16867885]);
AGR.TOC("matff","J1G1-f11r77cB0.m",[16146661,80770849]);
AGR.TOC("matff","J1G1-f11r106B0.m",[-103391839,124188868]);
AGR.TOC("matff","J1G1-f11r119B0.m",[-114730701,-131377448]);
AGR.TOC("matff","J1G1-f11r209B0.m",[30432323,-115220214]);
AGR.TOC("matff","J1G1-f19r22B0.m",[-8458095,123758142]);
AGR.TOC("matff","J1G1-f19r34B0.m",[57580925,-123237802]);
AGR.TOC("matff","J1G1-f19r43B0.m",[1561333,66803302]);
AGR.TOC("matff","J1G1-f19r55B0.m",[-109172623,14442210]);
AGR.TOC("matff","J1G1-f19r76aB0.m",[96251301,22067576]);
AGR.TOC("matff","J1G1-f19r76bB0.m",[-75763271,-90052991]);
AGR.TOC("matff","J1G1-f19r77B0.m",[5871029,48525857]);
AGR.TOC("matff","J1G1-f19r133aB0.m",[-116071157,79659262]);
AGR.TOC("matff","J1G1-f19r133bB0.m",[67214512,21683644]);
AGR.TOC("matff","J1G1-f19r133cB0.m",[30382290,71973032]);
AGR.TOC("matff","J1G1-f19r209B0.m",[-98745830,-14654175]);
AGR.TOC("matff","J1G1-f27r120aB0.m",[88849715,5601993]);
AGR.TOC("matff","J1G1-f27r120bB0.m",[95234762,128060063]);
AGR.TOC("matff","J1G1-f27r120cB0.m",[21394050,-47984428]);
AGR.TOC("matff","J1G1-f49r56aB0.m",[-82790943,55874968]);
AGR.TOC("matff","J1G1-f49r56bB0.m",[77714597,-126420712]);
AGR.TOC("matff","J1G1-f49r77bB0.m",[133603429,-13804032]);
AGR.TOC("matff","J1G1-f49r77cB0.m",[108616408,79439704]);
AGR.TOC("matff","J1G1-f49r133bB0.m",[-76280495,25191611]);
AGR.TOC("matff","J1G1-f49r133cB0.m",[-31063626,-88798497]);
AGR.TOC("matff","J1G1-f125r120aB0.m",[37110054,-12669843]);
AGR.TOC("matff","J1G1-f125r120bB0.m",[27805098,64057217]);
AGR.TOC("matff","J1G1-f125r120cB0.m",[36753518,132921276]);
AGR.TOC("matint","J1G1-Zr76aB0.g",[-132150391]);
AGR.TOC("matint","J1G1-Zr76bB0.g",[-56968292]);
AGR.TOC("matint","J1G1-Zr77aB0.g",[73320684]);
AGR.TOC("matint","J1G1-Zr112B0.g",[-31077060]);
AGR.TOC("matint","J1G1-Zr133aB0.g",[21656545]);
AGR.TOC("matint","J1G1-Zr154aB0.g",[83842088]);
AGR.TOC("matint","J1G1-Zr209B0.g",[-94084326]);
AGR.TOC("matint","J1G1-Zr266B0.g",[133600103]);
AGR.TOC("matint","J1G1-Zr360B0.g",[-130775594]);
AGR.TOC("maxes","J1G1-max1W1",[51538739]);
AGR.TOC("maxes","J1G1-max2W1",[-6041435]);
AGR.TOC("maxes","J1G1-max3W1",[-79963239]);
AGR.TOC("maxes","J1G1-max4W1",[-89881442]);
AGR.TOC("maxes","J1G1-max5W1",[15588260]);
AGR.TOC("maxes","J1G1-max6W1",[134073476]);
AGR.TOC("maxes","J1G1-max7W1",[74139840]);
AGR.TOC("cyclic","J1G1-cycW1",[17461109]);
AGR.TOC("cyc2ccl","J1G1cycW1-cclsW1",[122928561]);
AGR.TOC("maxstd","J1G1max1W1-L211G1W1",[-69103036]);
AGR.TOC("find","J1G1-find1",[-31682906]);
AGR.TOC("check","J1G1-check1",[123542188]);
AGR.TOC("pres","J1G1-P1",[62438344]);

# 2J2
AGR.GRP("spor","J2","2J2");
AGR.TOC("perm","2J2G1-p200B0.m",[123577781,41593846]);
AGR.TOC("perm","2J2G1-p1120B0.m",[-25117804,-26395146]);
AGR.TOC("matff","2J2G1-f3r14B0.m",[-113897243,-32814486]);
AGR.TOC("matff","2J2G1-f3r216B0.m",[14072415,-110234086]);
AGR.TOC("matff","2J2G1-f3r236B0.m",[20660607,10073248]);
AGR.TOC("matff","2J2G1-f5r6B0.m",[99799920,91333344]);
AGR.TOC("matff","2J2G1-f5r14B0.m",[83051864,126204854]);
AGR.TOC("matff","2J2G1-f5r50aB0.m",[-50527262,-97192412]);
AGR.TOC("matff","2J2G1-f5r50bB0.m",[129810320,104344437]);
AGR.TOC("matff","2J2G1-f5r56B0.m",[109189996,-127833587]);
AGR.TOC("matff","2J2G1-f5r64B0.m",[75626446,87298219]);
AGR.TOC("matff","2J2G1-f7r14B0.m",[-10597658,-86610093]);
AGR.TOC("matff","2J2G1-f9r6aB0.m",[67698531,-117556776]);
AGR.TOC("matff","2J2G1-f9r36aB0.m",[73184048,-23355679]);
AGR.TOC("matff","2J2G1-f9r50bB0.m",[-69229760,100172887]);
AGR.TOC("matff","2J2G1-f9r126bB0.m",[-118127278,69519271]);
AGR.TOC("matff","2J2G1-f49r6aB0.m",[-120102143,36160691]);
AGR.TOC("matff","2J2G1-f49r50bB0.m",[109335687,-28211937]);
AGR.TOC("matff","2J2G1-f49r58aB0.m",[87250507,56426501]);
AGR.TOC("pres","2J2G1-P1",[50736212]);
AGR.TOC("pres","2J2G1-P2",[95313741]);

# 2J2d2
AGR.GRP("spor","J2","2J2d2");
AGR.TOC("matff","2J2d2G1-f3r12B0.m",[97169803,118884350]);
AGR.TOC("matff","2J2d2G1-f3r72B0.m",[-54956834,74771712]);
AGR.TOC("matff","2J2d2G1-f3r100B0.m",[-28016138,85900205]);
AGR.TOC("matff","2J2d2G1-f3r216aB0.m",[99016969,6068394]);
AGR.TOC("matff","2J2d2G1-f3r252B0.m",[-17267583,51118333]);
AGR.TOC("matff","2J2d2G1-f5r100aB0.m",[-54001130,34060243]);
AGR.TOC("matff","2J2d2G1-f7r12B0.m",[54206582,91013231]);
AGR.TOC("matff","2J2d2G1-f7r14aB0.m",[111764479,82142631]);
AGR.TOC("matff","2J2d2G1-f7r100aB0.m",[-815702,10811702]);
AGR.TOC("matff","2J2d2G1-f7r112aB0.m",[-112067511,-87122879]);
AGR.TOC("matff","2J2d2G1-f7r116aB0.m",[-104312720,-1307904]);
AGR.TOC("matff","2J2d2G1-f7r252aB0.m",[3333699,33300818]);
AGR.TOC("matff","2J2d2G1-f7r336bB0.m",[-105320077,-76943839]);
AGR.TOC("matff","2J2d2G1-f7r350aB0.m",[63381314,-68247947]);
AGR.TOC("matff","2J2d2G1-f9r14bB0.m",[36762831,-132406626]);
AGR.TOC("matff","2J2d2G1-f9r236aB0.m",[-31790249,74937544]);
AGR.TOC("matff","2J2d2G1-f25r6aB0.m",[-132439171,1975945]);
AGR.TOC("matff","2J2d2G1-f25r14aB0.m",[6732991,29876443]);
AGR.TOC("matff","2J2d2G1-f25r56aB0.m",[-59725962,-5563607]);
AGR.TOC("matff","2J2d2G1-f25r64aB0.m",[99815101,24146284]);
AGR.TOC("matff","2J2d2G1-f25r190aB0.m",[62791918,105317228]);
AGR.TOC("matff","2J2d2G1-f25r202aB0.m",[97700598,-22294908]);
AGR.TOC("matff","2J2d2G1-f25r350aB0.m",[-111317796,-69843330]);
AGR.TOC("matff","2J2d2G1-f49r84aB0.m",[77278470,5597725]);
AGR.TOC("matff","2J2d2G1-f49r252bB0.m",[-32776114,-74356372]);
AGR.TOC("pres","2J2d2G1-P1",[-81649202]);

# 2J2d2i
AGR.GRP("spor","J2","2J2d2i");
AGR.TOC("pres","2J2d2iG1-P1",[-124109267]);

# J2
AGR.GRP("spor","J2","J2");
AGR.TOC("perm","J2G1-p100B0.m",[-10604214,76926874]);
AGR.TOC("perm","J2G1-p280B0.m",[103019629,129543628]);
AGR.TOC("perm","J2G1-p315B0.m",[-98296456,116940015]);
AGR.TOC("perm","J2G1-p525B0.m",[39161370,50068086]);
AGR.TOC("perm","J2G1-p840B0.m",[-2392939,-63559507]);
AGR.TOC("perm","J2G1-p1008B0.m",[107917219,44185964]);
AGR.TOC("perm","J2G1-p1800B0.m",[88439984,-83344771]);
AGR.TOC("matff","J2G1-f2r36B0.m",[79421504,-69325762]);
AGR.TOC("matff","J2G1-f2r84B0.m",[75413503,-102216560]);
AGR.TOC("matff","J2G1-f2r160B0.m",[28629833,126740221]);
AGR.TOC("matff","J2G1-f3r36B0.m",[-73894682,-94149424]);
AGR.TOC("matff","J2G1-f3r63B0.m",[-21093812,-56023244]);
AGR.TOC("matff","J2G1-f3r90B0.m",[-40992173,51864398]);
AGR.TOC("matff","J2G1-f3r133B0.m",[-119378602,44663767]);
AGR.TOC("matff","J2G1-f3r225B0.m",[80778398,-129737568]);
AGR.TOC("matff","J2G1-f4r6aB0.m",[-48659567,19296333]);
AGR.TOC("matff","J2G1-f4r14aB0.m",[-78197249,-86246293]);
AGR.TOC("matff","J2G1-f4r64aB0.m",[-100350507,-91732982]);
AGR.TOC("matff","J2G1-f5r14B0.m",[-24495182,62143285]);
AGR.TOC("matff","J2G1-f5r21B0.m",[-101700739,129331869]);
AGR.TOC("matff","J2G1-f5r41B0.m",[46482597,55653243]);
AGR.TOC("matff","J2G1-f5r70B0.m",[-24973080,126135372]);
AGR.TOC("matff","J2G1-f5r85B0.m",[60126257,36436769]);
AGR.TOC("matff","J2G1-f5r90B0.m",[108529232,-1189698]);
AGR.TOC("matff","J2G1-f5r175B0.m",[93698590,-86300113]);
AGR.TOC("matff","J2G1-f5r189B0.m",[64786394,-55336423]);
AGR.TOC("matff","J2G1-f5r225B0.m",[51793378,-25188973]);
AGR.TOC("matff","J2G1-f5r300B0.m",[97176457,125598365]);
AGR.TOC("matff","J2G1-f7r36B0.m",[94807847,-43954787]);
AGR.TOC("matff","J2G1-f7r63B0.m",[113327264,-89095941]);
AGR.TOC("matff","J2G1-f7r89B0.m",[93098055,-64430197]);
AGR.TOC("matff","J2G1-f7r101B0.m",[-43267214,-43718865]);
AGR.TOC("matff","J2G1-f7r124B0.m",[-31655958,29964592]);
AGR.TOC("matff","J2G1-f7r126B0.m",[-69882593,52764208]);
AGR.TOC("matff","J2G1-f7r175B0.m",[-7612451,56568397]);
AGR.TOC("matff","J2G1-f7r199B0.m",[130106760,72724572]);
AGR.TOC("matff","J2G1-f7r336B0.m",[-66986634,-12666334]);
AGR.TOC("matff","J2G1-f9r13aB0.m",[-82599678,19475396]);
AGR.TOC("matff","J2G1-f9r21aB0.m",[40398440,-105932054]);
AGR.TOC("matff","J2G1-f9r57aB0.m",[72550823,-123729265]);
AGR.TOC("matff","J2G1-f9r189aB0.m",[-80903080,-38830383]);
AGR.TOC("matff","J2G1-f49r14aB0.m",[-83144889,-132137217]);
AGR.TOC("matff","J2G1-f49r21aB0.m",[-93151165,8425597]);
AGR.TOC("matff","J2G1-f49r70aB0.m",[35895714,-122041372]);
AGR.TOC("matff","J2G1-f49r189aB0.m",[133245420,25430127]);
AGR.TOC("matff","J2G1-f49r224bB0.m",[81013272,1711563]);
AGR.TOC("matint","J2G1-Zr28B0.g",[-130022761]);
AGR.TOC("matint","J2G1-Zr36B0.g",[-20614194]);
AGR.TOC("matint","J2G1-Zr42B0.g",[31145687]);
AGR.TOC("matint","J2G1-Zr63B0.g",[-89620674]);
AGR.TOC("matint","J2G1-Zr90B0.g",[60260154]);
AGR.TOC("matint","J2G1-Zr126B0.g",[-110181652]);
AGR.TOC("matint","J2G1-Zr140B0.g",[-100307717]);
AGR.TOC("matint","J2G1-Zr160B0.g",[-7897565]);
AGR.TOC("matint","J2G1-Zr175B0.g",[-95385399]);
AGR.TOC("matint","J2G1-Zr225B0.g",[-74398693]);
AGR.TOC("matint","J2G1-Zr378B0.g",[85432049]);
AGR.TOC("matint","J2G1-Zr448B0.g",[111047571]);
AGR.TOC("matalg","J2G1-Ar14aB0.g",[-119892054]);
AGR.TOC("matalg","J2G1-Ar14bB0.g",[116541793]);
AGR.TOC("matalg","J2G1-Ar21aB0.g",[66352371]);
AGR.TOC("matalg","J2G1-Ar21bB0.g",[-106545175]);
AGR.TOC("maxes","J2G1-max1W1",[71503277]);
AGR.TOC("maxes","J2G1-max2W1",[-28428383]);
AGR.TOC("maxes","J2G1-max3W1",[63333853]);
AGR.TOC("maxes","J2G1-max4W1",[100660452]);
AGR.TOC("maxes","J2G1-max5W1",[-58932873]);
AGR.TOC("maxes","J2G1-max6W1",[-63852235]);
AGR.TOC("maxes","J2G1-max7W1",[-19546984]);
AGR.TOC("maxes","J2G1-max8W1",[15473541]);
AGR.TOC("maxes","J2G1-max9W1",[43284530]);
AGR.TOC("cyclic","J2G1-cycW1",[115291828]);
AGR.TOC("cyc2ccl","J2G1cycW1-cclsW1",[-131927518]);
AGR.TOC("find","J2G1-find1",[-113443300]);
AGR.TOC("check","J2G1-check1",[79820866]);
AGR.TOC("pres","J2G1-P1",[75328306]);
AGR.TOC("pres","J2G1-P2",[89317847]);

# J2d2
AGR.GRP("spor","J2","J2d2");
AGR.TOC("perm","J2d2G1-p100B0.m",[79614429,-121551062]);
AGR.TOC("matff","J2d2G1-f2r12B0.m",[50254151,-133240252]);
AGR.TOC("matff","J2d2G1-f2r28B0.m",[-96028902,102432156]);
AGR.TOC("matff","J2d2G1-f2r36B0.m",[-70271936,10793456]);
AGR.TOC("matff","J2d2G1-f2r84B0.m",[-2485093,65970594]);
AGR.TOC("matff","J2d2G1-f2r128B0.m",[-65498530,-20810824]);
AGR.TOC("matff","J2d2G1-f2r160B0.m",[13476252,-37245155]);
AGR.TOC("matff","J2d2G1-f3r26B0.m",[76485463,98100511]);
AGR.TOC("matff","J2d2G1-f3r36aB0.m",[46652214,98816800]);
AGR.TOC("matff","J2d2G1-f3r42B0.m",[80885786,-102033025]);
AGR.TOC("matff","J2d2G1-f3r63aB0.m",[-133703228,114272230]);
AGR.TOC("matff","J2d2G1-f3r90aB0.m",[131811586,30969873]);
AGR.TOC("matff","J2d2G1-f3r114B0.m",[59108908,-9938196]);
AGR.TOC("matff","J2d2G1-f3r133aB0.m",[84075448,37730824]);
AGR.TOC("matff","J2d2G1-f3r225aB0.m",[-39220154,-130617020]);
AGR.TOC("matff","J2d2G1-f3r378B0.m",[90745239,100731880]);
AGR.TOC("matff","J2d2G1-f5r14aB0.m",[119575197,78985578]);
AGR.TOC("matff","J2d2G1-f5r21aB0.m",[-95090773,18994822]);
AGR.TOC("matff","J2d2G1-f5r41aB0.m",[104699912,115133213]);
AGR.TOC("matff","J2d2G1-f5r70aB0.m",[17740820,-79331532]);
AGR.TOC("matff","J2d2G1-f5r85aB0.m",[128785100,44563005]);
AGR.TOC("matff","J2d2G1-f5r90aB0.m",[-44848211,29854069]);
AGR.TOC("matff","J2d2G1-f5r175aB0.m",[-27628356,38889573]);
AGR.TOC("matff","J2d2G1-f5r189aB0.m",[-4423560,-30106510]);
AGR.TOC("matff","J2d2G1-f5r225aB0.m",[-120959546,27919126]);
AGR.TOC("matff","J2d2G1-f5r300aB0.m",[-70109772,-101527760]);
AGR.TOC("matff","J2d2G1-f7r28B0.m",[-68684266,-47870332]);
AGR.TOC("matff","J2d2G1-f7r28aB0.m",[-78979492,-41376050]);
AGR.TOC("matff","J2d2G1-f7r36aB0.m",[126296679,-7392050]);
AGR.TOC("matff","J2d2G1-f7r42aB0.m",[78130173,41747469]);
AGR.TOC("matff","J2d2G1-f7r63aB0.m",[-55496811,-113221109]);
AGR.TOC("matff","J2d2G1-f7r89aB0.m",[18923317,107278480]);
AGR.TOC("matff","J2d2G1-f7r101aB0.m",[132601761,33448972]);
AGR.TOC("matff","J2d2G1-f7r124aB0.m",[25830938,-104474321]);
AGR.TOC("matff","J2d2G1-f7r126aB0.m",[39401259,-63972050]);
AGR.TOC("matff","J2d2G1-f7r140aB0.m",[-89259952,98564683]);
AGR.TOC("matff","J2d2G1-f7r175aB0.m",[64538401,-130093289]);
AGR.TOC("matff","J2d2G1-f7r199aB0.m",[-110342124,4074968]);
AGR.TOC("matff","J2d2G1-f7r378aB0.m",[-116455614,-21324846]);
AGR.TOC("matff","J2d2G1-f7r448aB0.m",[118611765,-72803788]);
AGR.TOC("matff","J2d2G1-f49r336aB0.m",[-23714968,-84309371]);
AGR.TOC("maxes","J2d2G1-max1W1",[-51694456]);
AGR.TOC("maxes","J2d2G1-max2W2",[-30559536]);
AGR.TOC("maxes","J2d2G1-max2W1",[23063257]);
AGR.TOC("maxes","J2d2G1-max3W1",[111958377]);
AGR.TOC("maxes","J2d2G1-max3W2",[-21586291]);
AGR.TOC("maxes","J2d2G1-max4W1",[132837173]);
AGR.TOC("maxes","J2d2G1-max5W1",[78799086]);
AGR.TOC("maxes","J2d2G1-max6W1",[-73379527]);
AGR.TOC("maxes","J2d2G1-max7W1",[19473530]);
AGR.TOC("maxes","J2d2G1-max8W2",[-30055709]);
AGR.TOC("maxes","J2d2G1-max8W1",[-83304134]);
AGR.TOC("maxes","J2d2G1-max9W1",[-26512083]);
AGR.TOC("maxes","J2d2G1-max10W1",[50336895]);
AGR.TOC("maxes","J2d2G1-max10W2",[-115145540]);
AGR.TOC("cyclic","J2d2G1-cycW1",[-77809268]);
AGR.TOC("find","J2d2G1-find1",[63922423]);
AGR.TOC("check","J2d2G1-check1",[113278913]);

# 3J3
AGR.GRP("spor","J3","3J3");
AGR.TOC("matff","3J3G1-f4r9aB0.m",[5706396,-35558374]);
AGR.TOC("matff","3J3G1-f4r18aB0.m",[43277515,4750208]);
AGR.TOC("matff","3J3G1-f4r18bB0.m",[-130770368,71718454]);
AGR.TOC("matff","3J3G1-f4r126aB0.m",[17655829,10977322]);
AGR.TOC("matff","3J3G1-f4r153aB0.m",[-86667489,69354272]);
AGR.TOC("matff","3J3G1-f4r153bB0.m",[105863765,-99696278]);
AGR.TOC("matff","3J3G1-f4r324aB0.m",[120672405,22266670]);
AGR.TOC("matff","3J3G1-f4r720aB0.m",[28389114,90385026]);
AGR.TOC("matff","3J3G1-f4r1008aB0.m",[-64314065,-67617738]);
AGR.TOC("matff","3J3G1-f5r36B0.m",[102625935,-11945867]);
AGR.TOC("matff","3J3G1-f17r36aB0.m",[-51234880,68470238]);
AGR.TOC("matff","3J3G1-f17r36bB0.m",[51033368,12468464]);
AGR.TOC("matff","3J3G1-f17r342aB0.m",[-5781739,-45542491]);
AGR.TOC("matff","3J3G1-f17r648aB0.m",[-133504337,-14109488]);
AGR.TOC("matff","3J3G1-f19r18aB0.m",[-13218369,-54533917]);
AGR.TOC("matff","3J3G1-f19r18bB0.m",[71768792,-33082416]);
AGR.TOC("matff","3J3G1-f25r18B0.m",[-22348714,74615936]);
AGR.TOC("matff","3J3G1-f25r153B0.m",[-46297630,-38642240]);
AGR.TOC("matff","3J3G1-f25r171aB0.m",[819518,-42644410]);
AGR.TOC("pres","3J3G1-P1",[94181161]);
AGR.TOC("pres","3J3G1-P2",[97697866]);

# 3J3d2
AGR.GRP("spor","J3","3J3d2");
AGR.TOC("matff","3J3d2G1-f2r18B0.m",[-71834125,97014104]);

# J3
AGR.GRP("spor","J3","J3");
AGR.TOC("perm","J3G1-p6156B0.m",[-6997746,114293647]);
AGR.TOC("perm","J3G1-p14688aB0.m",[83603351,101939310]);
AGR.TOC("perm","J3G1-p14688bB0.m",[108341248,2451612]);
AGR.TOC("perm","J3G1-p17442B0.m",[130030449,-27264281]);
AGR.TOC("perm","J3G1-p20520B0.m",[-108660079,-106583523]);
AGR.TOC("perm","J3G1-p23256B0.m",[107077962,125529650]);
AGR.TOC("perm","J3G1-p25840B0.m",[93937982,27658851]);
AGR.TOC("perm","J3G1-p26163B0.m",[-76971561,46022270]);
AGR.TOC("perm","J3G1-p43605B0.m",[-25523132,90042139]);
AGR.TOC("matff","J3G1-f2r80B0.m",[-114855153,-63500987]);
AGR.TOC("matff","J3G1-f2r244B0.m",[96929110,40003984]);
AGR.TOC("matff","J3G1-f2r248B0.m",[-5581136,-102087980]);
AGR.TOC("matff","J3G1-f2r966B0.m",[-21628489,-81419317]);
AGR.TOC("matff","J3G1-f3r324B0.m",[-121653249,-48968634]);
AGR.TOC("matff","J3G1-f3r934B0.m",[21180256,9353944]);
AGR.TOC("matff","J3G1-f4r78bB0.m",[130683410,-49146325]);
AGR.TOC("matff","J3G1-f4r84aB0.m",[97268024,90323773]);
AGR.TOC("matff","J3G1-f4r322aB0.m",[-94596495,-83869187]);
AGR.TOC("matff","J3G1-f5r85aB0.m",[-29570850,-22625474]);
AGR.TOC("matff","J3G1-f5r323B0.m",[20586886,-63936535]);
AGR.TOC("matff","J3G1-f5r646B0.m",[38468934,-19638553]);
AGR.TOC("matff","J3G1-f5r816B0.m",[-38226666,33164345]);
AGR.TOC("matff","J3G1-f9r18bB0.m",[-114161524,3130286]);
AGR.TOC("matff","J3G1-f9r84bB0.m",[131054028,43504610]);
AGR.TOC("matff","J3G1-f9r153bB0.m",[74571268,-72197498]);
AGR.TOC("matff","J3G1-f17r85bB0.m",[69355264,79827344]);
AGR.TOC("matff","J3G1-f17r324B0.m",[1501502,47098677]);
AGR.TOC("matff","J3G1-f17r379B0.m",[-18078186,-100804918]);
AGR.TOC("matff","J3G1-f17r646cB0.m",[33779740,-35096697]);
AGR.TOC("matff","J3G1-f17r761B0.m",[-24827989,-30157498]);
AGR.TOC("matff","J3G1-f17r816B0.m",[49783141,-44417889]);
AGR.TOC("matff","J3G1-f17r836B0.m",[67110042,-103596482]);
AGR.TOC("matff","J3G1-f17r1292B0.m",[-25034150,-70852400]);
AGR.TOC("matff","J3G1-f19r85B0.m",[-116269633,124397448]);
AGR.TOC("matff","J3G1-f19r110B0.m",[-14149257,-72994069]);
AGR.TOC("matff","J3G1-f19r214B0.m",[112808376,63056856]);
AGR.TOC("matff","J3G1-f19r323aB0.m",[-56308585,122734075]);
AGR.TOC("matff","J3G1-f19r646aB0.m",[32723177,57321757]);
AGR.TOC("matff","J3G1-f19r706B0.m",[124798330,-118385496]);
AGR.TOC("matff","J3G1-f19r919B0.m",[117468015,76233284]);
AGR.TOC("matff","J3G1-f19r1001B0.m",[-71775894,32124539]);
AGR.TOC("matint","J3G1-Zr170B0.g",[5010871]);
AGR.TOC("maxes","J3G1-max1W1",[101439354]);
AGR.TOC("maxes","J3G1-max2W1",[78445967]);
AGR.TOC("maxes","J3G1-max3W1",[-59984060]);
AGR.TOC("maxes","J3G1-max4W1",[1926870]);
AGR.TOC("maxes","J3G1-max5W1",[126899098]);
AGR.TOC("maxes","J3G1-max6W1",[62944102]);
AGR.TOC("maxes","J3G1-max7W1",[115657958]);
AGR.TOC("maxes","J3G1-max8W1",[49123027]);
AGR.TOC("maxes","J3G1-max9W1",[-44554009]);
AGR.TOC("cyclic","J3G1-cycW1",[59511997]);
AGR.TOC("cyc2ccl","J3G1cycW1-cclsW1",[3912495]);
AGR.TOC("find","J3G1-find1",[84468241]);
AGR.TOC("check","J3G1-check1",[131719718]);
AGR.TOC("pres","J3G1-P1",[6588741]);

# J3d2
AGR.GRP("spor","J3","J3d2");
AGR.TOC("perm","J3d2G1-p6156B0.m",[11729589,-119672344]);
AGR.TOC("matff","J3d2G1-f2r80aB0.m",[-129818312,-84930763]);
AGR.TOC("matff","J3d2G1-f2r156aB0.m",[-35325545,7697295]);
AGR.TOC("matff","J3d2G1-f2r168aB0.m",[-69077590,124597600]);
AGR.TOC("matff","J3d2G1-f2r244aB0.m",[100974568,111207289]);
AGR.TOC("matff","J3d2G1-f2r644aB0.m",[31198995,-77464786]);
AGR.TOC("matff","J3d2G1-f2r966aB0.m",[-36421548,-25821412]);
AGR.TOC("matff","J3d2G1-f3r36B0.m",[31764118,43883456]);
AGR.TOC("matff","J3d2G1-f3r36aB0.m",[99684431,109585689]);
AGR.TOC("matff","J3d2G1-f3r168aB0.m",[-615510,-7899195]);
AGR.TOC("matff","J3d2G1-f3r306aB0.m",[-65318316,-88972481]);
AGR.TOC("matff","J3d2G1-f3r324aB0.m",[-91579146,-112188732]);
AGR.TOC("matff","J3d2G1-f3r934aB0.m",[103410483,111489511]);
AGR.TOC("matff","J3d2G1-f5r170aB0.m",[126235142,-44861301]);
AGR.TOC("matff","J3d2G1-f5r323bB0.m",[11663668,-31895383]);
AGR.TOC("matff","J3d2G1-f5r646aB0.m",[83386032,-54626814]);
AGR.TOC("matff","J3d2G1-f5r816aB0.m",[-54694986,110817765]);
AGR.TOC("matff","J3d2G1-f17r170aB0.m",[-20712877,15840937]);
AGR.TOC("matff","J3d2G1-f17r324aB0.m",[-121994210,13113504]);
AGR.TOC("matff","J3d2G1-f17r379aB0.m",[8150753,-6344132]);
AGR.TOC("matff","J3d2G1-f17r646aB0.m",[1825660,100643838]);
AGR.TOC("matff","J3d2G1-f17r836aB0.m",[-6609325,64870910]);
AGR.TOC("matff","J3d2G1-f19r85aB0.m",[42726302,-85827259]);
AGR.TOC("matff","J3d2G1-f19r110aB0.m",[33474962,61327975]);
AGR.TOC("matff","J3d2G1-f19r214aB0.m",[86168827,45997897]);
AGR.TOC("matff","J3d2G1-f19r214bB0.m",[-14898486,-70381615]);
AGR.TOC("matff","J3d2G1-f19r646aB0.m",[-75020622,36753805]);
AGR.TOC("matff","J3d2G1-f19r706aB0.m",[39748629,-88787685]);
AGR.TOC("matff","J3d2G1-f19r919aB0.m",[69365981,-131623696]);
AGR.TOC("matff","J3d2G1-f19r1001aB0.m",[-93762295,55734533]);
AGR.TOC("matff","J3d2G1-f19r1214aB0.m",[91332265,-83777443]);
AGR.TOC("maxes","J3d2G1-max1W1",[43765696]);
AGR.TOC("maxes","J3d2G1-max1W2",[51647767]);
AGR.TOC("maxes","J3d2G1-max2W1",[12604146]);
AGR.TOC("maxes","J3d2G1-max2W2",[-47456261]);
AGR.TOC("maxes","J3d2G1-max3W1",[-83635088]);
AGR.TOC("maxes","J3d2G1-max3W2",[-56061537]);
AGR.TOC("maxes","J3d2G1-max4W1",[42497159]);
AGR.TOC("maxes","J3d2G1-max4W2",[13243978]);
AGR.TOC("maxes","J3d2G1-max4W3",[122658637]);
AGR.TOC("maxes","J3d2G1-max5W1",[44354392]);
AGR.TOC("maxes","J3d2G1-max5W2",[100303569]);
AGR.TOC("maxes","J3d2G1-max6W1",[34236532]);
AGR.TOC("maxes","J3d2G1-max6W2",[-13239779]);
AGR.TOC("maxes","J3d2G1-max7W1",[-63149480]);
AGR.TOC("maxes","J3d2G1-max7W2",[110046694]);
AGR.TOC("maxes","J3d2G1-max8W1",[52645162]);
AGR.TOC("maxes","J3d2G1-max8W2",[-23404220]);
AGR.TOC("maxes","J3d2G1-max9W1",[-61130598]);
AGR.TOC("maxes","J3d2G1-max9W2",[-84682738]);
AGR.TOC("cyclic","J3d2G1-cycW1",[-22222726]);
AGR.TOC("find","J3d2G1-find1",[-62481230]);
AGR.TOC("check","J3d2G1-check1",[-29141963]);
AGR.TOC("pres","J3d2G1-P1",[79692095]);

# J4
AGR.GRP("spor","J4","J4");
AGR.TOC("matff","J4G1-f2r112B0.m",[-65652010,73342411]);
AGR.TOC("matff","J4G1-f2r1220aB0.m",[6701669,71684102]);
AGR.TOC("matff","J4G1-f11r1333B0.m",[89088292,102950801]);
AGR.TOC("maxes","J4G1-max1W1",[46104539]);
AGR.TOC("maxes","J4G1-max2W1",[2832080]);
AGR.TOC("maxes","J4G1-max3W1",[-125358074]);
AGR.TOC("maxes","J4G1-max4W1",[-107364696]);
AGR.TOC("maxes","J4G1-max5W1",[-29842207]);
AGR.TOC("maxes","J4G1-max6W1",[-34916600]);
AGR.TOC("maxes","J4G1-max7W1",[-25028404]);
AGR.TOC("maxes","J4G1-max8W1",[-34180489]);
AGR.TOC("maxes","J4G1-max9W1",[-27356525]);
AGR.TOC("maxes","J4G1-max10W1",[-61874604]);
AGR.TOC("maxes","J4G1-max11W1",[93074183]);
AGR.TOC("maxes","J4G1-max12W1",[109847687]);
AGR.TOC("maxes","J4G1-max13W1",[69852070]);
AGR.TOC("cyclic","J4G1-cycW1",[11528942]);
AGR.TOC("switch","J4G1-G2W1",[1835111]);
AGR.TOC("find","J4G1-find1",[47331454]);
AGR.TOC("check","J4G1-check1",[94551580]);

# Ly
AGR.GRP("spor","Ly","Ly");
AGR.TOC("matff","LyG1-f3r651B0.m",[10566154,103166968]);
AGR.TOC("matff","LyG1-f4r2480B0.m",[34218313,18008839]);
AGR.TOC("matff","LyG1-f5r111B0.m",[88507392,25634025]);
AGR.TOC("matff","LyG1-f5r517B0.m",[-5960997,-106607566]);
AGR.TOC("matff","LyG1-f5r2480aB0.m",[80368824,-54706907]);
AGR.TOC("matff","LyG1-f5r2480bB0.m",[-29935409,-96272542]);
AGR.TOC("maxes","LyG1-max1W1",[84121637]);
AGR.TOC("maxes","LyG1-max2W1",[-65521363]);
AGR.TOC("maxes","LyG1-max3W1",[-14876375]);
AGR.TOC("maxes","LyG1-max4W1",[36673662]);
AGR.TOC("maxes","LyG1-max5W1",[123699800]);
AGR.TOC("maxes","LyG1-max6W1",[-67283536]);
AGR.TOC("maxes","LyG1-max7W1",[-98954415]);
AGR.TOC("maxes","LyG1-max8W1",[-13258558]);
AGR.TOC("maxes","LyG1-max9W1",[33311056]);
AGR.TOC("cyclic","LyG1-cycW1",[-35173790]);
AGR.TOC("cyc2ccl","LyG1cycW1-cclsW1",[-40764659]);
AGR.TOC("find","LyG1-find1",[-93251550]);
AGR.TOC("check","LyG1-check1",[53141382]);

# M
AGR.GRP("spor","M","M");
AGR.TOC("find","MG1-find1",[-31705853]);
AGR.TOC("check","MG1-check1",[-44568560]);

# M3max7
AGR.GRP("spor","M","M3max7");
AGR.TOC("matff","M3max7G0-f3r38B0.m",[-97335535,130920706,-68939516,63018560]);

# Mmax10
AGR.GRP("spor","M","Mmax10");
AGR.TOC("perm","Mmax10G0-p1032192B0.m",[18677102,-120278726]);

# Mmax11
AGR.GRP("spor","M","Mmax11");
AGR.TOC("perm","Mmax11G0-p805896B0.m",[80835450,17005428]);
AGR.TOC("matff","Mmax11G0-f3r204B0.m",[-68979527,97267981]);

# Mmax12
AGR.GRP("spor","M","Mmax12");
AGR.TOC("matff","Mmax12G0-f5r135B0.m",[-41923899,-68468649]);

# Mmax13
AGR.GRP("spor","M","Mmax13");
AGR.TOC("perm","Mmax13G0-p3369B0.m",[-124454153,-118539307]);

# Mmax14
AGR.GRP("spor","M","Mmax14");
AGR.TOC("perm","Mmax14G0-p34992B0.m",[36007341,16238952]);
AGR.TOC("perm","Mmax14G0-p69984B0.m",[-19023274,21953817]);

# Mmax15
AGR.GRP("spor","M","Mmax15");
AGR.TOC("perm","Mmax15G0-p85293B0.m",[45592030,24658568]);
AGR.TOC("perm","Mmax15G0-p113724B0.m",[8153441,-11541249]);
AGR.TOC("perm","Mmax15G0-p227448B0.m",[-117512269,18905903]);

# Mmax15q1
AGR.GRP("spor","M","Mmax15q1");
AGR.TOC("perm","Mmax15q1G0-p6561B0.m",[55971037,-89489113]);

# Mmax15q2
AGR.GRP("spor","M","Mmax15q2");
AGR.TOC("perm","Mmax15q2G0-p1404B0.m",[4489106,-73235772]);

# Mmax15q3
AGR.GRP("spor","M","Mmax15q3");
AGR.TOC("perm","Mmax15q3G0-p108B0.m",[94046920,-133086079]);

# Mmax16
AGR.GRP("spor","M","Mmax16");
AGR.TOC("perm","Mmax16G0-p78125B0.m",[-123466697,-18135321]);
AGR.TOC("matff","Mmax16G0-f5r8B0.m",[-129008619,-80013105]);

# Mmax17
AGR.GRP("spor","M","Mmax17");
AGR.TOC("perm","Mmax17G0-p2065B0.m",[-24577210,3845541]);

# Mmax18
AGR.GRP("spor","M","Mmax18");
AGR.TOC("perm","Mmax18G0-p17B0.m",[-96374399,84665195]);

# Mmax19
AGR.GRP("spor","M","Mmax19");
AGR.TOC("perm","Mmax19G0-p7750B0.m",[9717373,-57055253]);
AGR.TOC("perm","Mmax19G0-p46500B0.m",[32384318,25040051]);
AGR.TOC("perm","Mmax19G0-p96875B0.m",[-78036431,91495778]);
AGR.TOC("matff","Mmax19G0-f5r46B0.m",[-128678362,85752621]);

# Mmax20
AGR.GRP("spor","M","Mmax20");
AGR.TOC("perm","Mmax20G0-p30B0.m",[20272089,-84261147]);

# Mmax21
AGR.GRP("spor","M","Mmax21");
AGR.TOC("perm","Mmax21G0-p518B0.m",[26532979,-91226104]);
AGR.TOC("perm","Mmax21G0-p3653B0.m",[64063784,113703956]);
AGR.TOC("matff","Mmax21G0-f2r28B0.m",[-26612517,-65459450]);

# Mmax22
AGR.GRP("spor","M","Mmax22");
AGR.TOC("perm","Mmax22G0-p750B0.m",[57129072,7477813]);
AGR.TOC("perm","Mmax22G0-p15625B0.m",[-116581289,-57343609]);

# Mmax23
AGR.GRP("spor","M","Mmax23");
AGR.TOC("perm","Mmax23G0-p184B0.m",[-13866898,-55917792]);
AGR.TOC("perm","Mmax23G0-p524B0.m",[127804996,-76894010]);
AGR.TOC("matff","Mmax23G0-f2r22B0.m",[77850203,-95111381]);

# Mmax24
AGR.GRP("spor","M","Mmax24");
AGR.TOC("perm","Mmax24G0-p16807B0.m",[-96132444,56610806]);
AGR.TOC("matff","Mmax24G0-f7r6B0.m",[-61000562,23163086]);

# Mmax25
AGR.GRP("spor","M","Mmax25");
AGR.TOC("perm","Mmax25G0-p151B0.m",[4610688,-7957974]);

# Mmax26
AGR.GRP("spor","M","Mmax26");
AGR.TOC("perm","Mmax26G0-p36B0.m",[-78507803,6093542]);

# Mmax27
AGR.GRP("spor","M","Mmax27");
AGR.TOC("perm","Mmax27G0-p17B0.m",[14263291,22525490]);

# Mmax28
AGR.GRP("spor","M","Mmax28");
AGR.TOC("perm","Mmax28G0-p625B0.m",[-127973830,34552176]);
AGR.TOC("matff","Mmax28G0-f5r5B0.m",[89882878,77104098]);

# Mmax29
AGR.GRP("spor","M","Mmax29");
AGR.TOC("perm","Mmax29G0-p392B0.m",[-17293048,74987613]);
AGR.TOC("perm","Mmax29G0-p2401B0.m",[-78383939,123860282]);
AGR.TOC("matff","Mmax29G0-f7r7B0.m",[112461751,-115478207]);

# Mmax30
AGR.GRP("spor","M","Mmax30");
AGR.TOC("perm","Mmax30G0-p21B0.m",[-97695841,20991856]);

# Mmax31
AGR.GRP("spor","M","Mmax31");
AGR.TOC("perm","Mmax31G0-p15B0.m",[-40663314,111091613]);

# Mmax32
AGR.GRP("spor","M","Mmax32");
AGR.TOC("perm","Mmax32G0-p24B0.m",[60571607,112921406]);

# Mmax33
AGR.GRP("spor","M","Mmax33");
AGR.TOC("perm","Mmax33G0-p169B0.m",[93753111,15633434]);
AGR.TOC("matff","Mmax33G0-f13r3B0.m",[27954821,-122983683]);

# Mmax34
AGR.GRP("spor","M","Mmax34");
AGR.TOC("perm","Mmax34G0-p57B0.m",[-43311648,73396022]);

# Mmax35
AGR.GRP("spor","M","Mmax35");
AGR.TOC("perm","Mmax35G0-p39B0.m",[-9590504,97350065]);

# Mmax36
AGR.GRP("spor","M","Mmax36");
AGR.TOC("perm","Mmax36G0-p2197B0.m",[83587471,-26703514]);
AGR.TOC("matff","Mmax36G0-f13r4B0.m",[-99724456,-47703948]);

# Mmax39
AGR.GRP("spor","M","Mmax39");
AGR.TOC("perm","Mmax39G0-p121B0.m",[-18318182,-28117149]);
AGR.TOC("matff","Mmax39G0-f11r3B0.m",[-39573731,-15426602]);

# Mmax4
AGR.GRP("spor","M","Mmax4");
AGR.TOC("matff","Mmax4G0-f2r1708B0.m",[-90172041,-56342351]);

# Mmax41
AGR.GRP("spor","M","Mmax41");
AGR.TOC("perm","Mmax41G0-p49B0.m",[110691146,79808877]);
AGR.TOC("matff","Mmax41G0-f7r3B0.m",[-60576044,65702456]);

# Mmax43
AGR.GRP("spor","M","Mmax43");
AGR.TOC("perm","Mmax43G0-p41B0.m",[-31842605,-77703055]);

# Mmax6
AGR.GRP("spor","M","Mmax6");
AGR.TOC("perm","Mmax6G0-p294912B0.m",[88770226,29440698]);

# Mmax7
AGR.GRP("spor","M","Mmax7");
AGR.TOC("matff","Mmax7G0-f3r78B0.m",[-60481712,-11921347,-87256435]);

# Mmax9
AGR.GRP("spor","M","Mmax9");
AGR.TOC("matff","Mmax9G0-f2r250B0.m",[119882445,-110292395]);

# M11
AGR.GRP("spor","M11","M11");
AGR.TOC("perm","M11G1-p11B0.m",[-23242334,84686582]);
AGR.TOC("perm","M11G1-p12B0.m",[97614119,-100540349]);
AGR.TOC("perm","M11G1-p55B0.m",[-96772320,-36474778]);
AGR.TOC("perm","M11G1-p66B0.m",[9740518,133760186]);
AGR.TOC("perm","M11G1-p165B0.m",[110061815,-44393461]);
AGR.TOC("matff","M11G1-f2r10B0.m",[127264365,-86026089]);
AGR.TOC("matff","M11G1-f2r32B0.m",[-102853569,-48330032]);
AGR.TOC("matff","M11G1-f2r44B0.m",[-119533246,-45775323]);
AGR.TOC("matff","M11G1-f3r5aB0.m",[68650191,57900817]);
AGR.TOC("matff","M11G1-f3r5bB0.m",[74015297,130147793]);
AGR.TOC("matff","M11G1-f3r10aB0.m",[83366269,67157210]);
AGR.TOC("matff","M11G1-f3r10bB0.m",[128973873,33625375]);
AGR.TOC("matff","M11G1-f3r10cB0.m",[10369459,45060681]);
AGR.TOC("matff","M11G1-f3r24B0.m",[24068442,-125977934]);
AGR.TOC("matff","M11G1-f3r45B0.m",[1493310,-100498939]);
AGR.TOC("matff","M11G1-f4r16aB0.m",[125550197,-50883640]);
AGR.TOC("matff","M11G1-f4r16bB0.m",[21425449,53740060]);
AGR.TOC("matff","M11G1-f5r10aB0.m",[8511433,126827892]);
AGR.TOC("matff","M11G1-f5r11B0.m",[-133249663,83948554]);
AGR.TOC("matff","M11G1-f5r16aB0.m",[-51162984,129285556]);
AGR.TOC("matff","M11G1-f5r16bB0.m",[125703736,129424194]);
AGR.TOC("matff","M11G1-f5r20B0.m",[107484105,25865804]);
AGR.TOC("matff","M11G1-f5r45B0.m",[-39522961,130380806]);
AGR.TOC("matff","M11G1-f5r55B0.m",[-88501284,-77523996]);
AGR.TOC("matff","M11G1-f11r9B0.m",[-12680777,119649168]);
AGR.TOC("matff","M11G1-f11r10aB0.m",[114488862,-54564471]);
AGR.TOC("matff","M11G1-f11r10bB0.m",[78585948,-35885917]);
AGR.TOC("matff","M11G1-f11r11B0.m",[-47486067,25146697]);
AGR.TOC("matff","M11G1-f11r16B0.m",[96969304,64712245]);
AGR.TOC("matff","M11G1-f11r44B0.m",[102913891,-120563489]);
AGR.TOC("matff","M11G1-f11r55B0.m",[24089776,-77958630]);
AGR.TOC("matff","M11G1-f25r10bB0.m",[-128941494,-19184706]);
AGR.TOC("matff","M11G1-f25r10cB0.m",[87488062,-91620163]);
AGR.TOC("matint","M11G1-Zr10aB0.g",[42919820]);
AGR.TOC("matint","M11G1-Zr11B0.g",[63654078]);
AGR.TOC("matint","M11G1-Zr20B0.g",[41705437]);
AGR.TOC("matint","M11G1-Zr32B0.g",[-61588475]);
AGR.TOC("matint","M11G1-Zr44B0.g",[12272531]);
AGR.TOC("matint","M11G1-Zr45B0.g",[85806096]);
AGR.TOC("matint","M11G1-Zr55B0.g",[2315188]);
AGR.TOC("matalg","M11G1-Ar10bB0.g",[-69763370]);
AGR.TOC("matalg","M11G1-Ar10cB0.g",[55047378]);
AGR.TOC("maxes","M11G1-max1W1",[-87639153]);
AGR.TOC("maxes","M11G1-max2W1",[31931707]);
AGR.TOC("maxes","M11G1-max3W1",[-22285271]);
AGR.TOC("maxes","M11G1-max4W1",[-53275818]);
AGR.TOC("maxes","M11G1-max5W1",[81859818]);
AGR.TOC("classes","M11G1-cclsW1",[44035324]);
AGR.TOC("cyclic","M11G1-cycW1",[-119662999]);
AGR.TOC("cyc2ccl","M11G1cycW1-cclsW1",[-92464422]);
AGR.TOC("maxstd","M11G1max1W1-M10G1W1",[-93789632]);
AGR.TOC("maxstd","M11G1max2W1-L211G1W1",[-93789632]);
AGR.TOC("maxstd","M11G1max4W1-S5G1W1",[-93789632]);
AGR.TOC("find","M11G1-find1",[-66199957]);
AGR.TOC("check","M11G1-check1",[-12040319]);
AGR.TOC("pres","M11G1-P1",[-11084023]);

# 2M12
AGR.GRP("spor","M12","2M12");
AGR.TOC("perm","2M12G1-p24aB0.m",[-1273465,65254220]);
AGR.TOC("matff","2M12G1-f3r6bB0.m",[121578910,129273462]);
AGR.TOC("matff","2M12G1-f5r12B0.m",[-101075401,-1460971]);
AGR.TOC("matint","2M12G1-Zr12B0.g",[68025268]);
AGR.TOC("matint","2M12G1-Zr120B0.g",[-79235244]);
AGR.TOC("matint","2M12G1-Zr220B0.g",[-49629620]);
AGR.TOC("pres","2M12G1-P1",[-20608944]);

# 2M12d2
AGR.GRP("spor","M12","2M12d2");
AGR.TOC("perm","2M12d2G1-p48B0.m",[-30364446,-627565]);
AGR.TOC("matff","2M12d2G1-f3r10aB0.m",[-34996601,-118846721]);
AGR.TOC("matff","2M12d2G1-f3r10bB0.m",[-76717690,118738579]);
AGR.TOC("matff","2M12d2G1-f3r10cB0.m",[-35597745,-118495992]);
AGR.TOC("matff","2M12d2G1-f3r12B0.m",[60451266,-32378584]);
AGR.TOC("matff","2M12d2G1-f3r12aB0.m",[103057523,-62320936]);
AGR.TOC("matff","2M12d2G1-f3r88aB0.m",[-41083111,2706141]);
AGR.TOC("matff","2M12d2G1-f3r168aB0.m",[-67470713,-127337236]);
AGR.TOC("matff","2M12d2G1-f5r120bB0.m",[-82693885,-32740698]);
AGR.TOC("matff","2M12d2G1-f5r220aB0.m",[25416081,-95738572]);
AGR.TOC("matff","2M12d2G1-f5r320aB0.m",[-134190359,104982855]);
AGR.TOC("matff","2M12d2G1-f11r10aB0.m",[112952395,32411565]);
AGR.TOC("matff","2M12d2G1-f11r10bB0.m",[-64596746,-67029675]);
AGR.TOC("matff","2M12d2G1-f11r12aB0.m",[-127522320,-35727857]);
AGR.TOC("matff","2M12d2G1-f11r32aB0.m",[-105789088,-97647879]);
AGR.TOC("matff","2M12d2G1-f11r88aB0.m",[54914992,-126426826]);
AGR.TOC("matff","2M12d2G1-f11r108aB0.m",[-53667847,82216193]);
AGR.TOC("matff","2M12d2G1-f11r220aB0.m",[-8950103,-128269568]);
AGR.TOC("matff","2M12d2G1-f25r10aB0.m",[57623869,-87407490]);
AGR.TOC("matff","2M12d2G1-f25r10bB0.m",[57623869,15898170]);
AGR.TOC("matff","2M12d2G1-f25r12aB0.m",[125938463,123350688]);
AGR.TOC("matff","2M12d2G1-f25r32bB0.m",[63923528,-60675183]);

# M12
AGR.GRP("spor","M12","M12");
AGR.TOC("perm","M12G1-p12aB0.m",[-55292532,-11034135]);
AGR.TOC("perm","M12G1-p12bB0.m",[70136775,-42596378]);
AGR.TOC("perm","M12G1-p66aB0.m",[16716104,85280492]);
AGR.TOC("perm","M12G1-p66bB0.m",[16716104,-119705959]);
AGR.TOC("matff","M12G1-f2r10B0.m",[-86054196,-117728977]);
AGR.TOC("matff","M12G1-f2r44B0.m",[5391720,-62166224]);
AGR.TOC("matff","M12G1-f2r144B0.m",[101904902,53296002]);
AGR.TOC("matff","M12G1-f3r10aB0.m",[30472542,-78417955]);
AGR.TOC("matff","M12G1-f3r15bB0.m",[47152398,-27722653]);
AGR.TOC("matff","M12G1-f3r34B0.m",[117253362,13257774]);
AGR.TOC("matff","M12G1-f3r45aB0.m",[76737617,86109308]);
AGR.TOC("matff","M12G1-f3r45bB0.m",[47791811,116448062]);
AGR.TOC("matff","M12G1-f3r54B0.m",[19871925,-54650667]);
AGR.TOC("matff","M12G1-f3r99B0.m",[39128640,48059071]);
AGR.TOC("matff","M12G1-f4r16aB0.m",[-32139946,-84977167]);
AGR.TOC("matff","M12G1-f4r16bB0.m",[1105818,-114535987]);
AGR.TOC("matff","M12G1-f5r11aB0.m",[-671395,131486522]);
AGR.TOC("matff","M12G1-f5r16bB0.m",[-119459442,21159535]);
AGR.TOC("matff","M12G1-f5r45B0.m",[-9586441,100658622]);
AGR.TOC("matff","M12G1-f5r55aB0.m",[50494097,-122759986]);
AGR.TOC("matff","M12G1-f5r55cB0.m",[21533278,-123660069]);
AGR.TOC("matff","M12G1-f5r66B0.m",[98010649,-114174962]);
AGR.TOC("matff","M12G1-f5r78B0.m",[-130685797,93378717]);
AGR.TOC("matff","M12G1-f5r98B0.m",[126662635,-35501250]);
AGR.TOC("matff","M12G1-f5r120B0.m",[9595464,80432835]);
AGR.TOC("matff","M12G1-f11r11aB0.m",[117263727,-65625522]);
AGR.TOC("matff","M12G1-f11r16B0.m",[7038217,126342649]);
AGR.TOC("matff","M12G1-f11r29B0.m",[46845011,75944568]);
AGR.TOC("matff","M12G1-f11r53B0.m",[-22816443,-99210671]);
AGR.TOC("matff","M12G1-f11r55aB0.m",[78596492,112224851]);
AGR.TOC("matff","M12G1-f11r55cB0.m",[109913466,-103557516]);
AGR.TOC("matff","M12G1-f11r66B0.m",[-124182891,-60073630]);
AGR.TOC("matff","M12G1-f11r91B0.m",[-51340364,-33111912]);
AGR.TOC("matff","M12G1-f11r99B0.m",[-97513304,-119552486]);
AGR.TOC("matff","M12G1-f11r176B0.m",[122185646,-46090498]);
AGR.TOC("matint","M12G1-Zr11aB0.g",[-19460267]);
AGR.TOC("matint","M12G1-Zr11bB0.g",[-78777004]);
AGR.TOC("matint","M12G1-Zr32B0.g",[-78965106]);
AGR.TOC("matint","M12G1-Zr45B0.g",[-45893207]);
AGR.TOC("matint","M12G1-Zr54B0.g",[18721185]);
AGR.TOC("matint","M12G1-Zr55aB0.g",[-132387311]);
AGR.TOC("matint","M12G1-Zr55bB0.g",[22269619]);
AGR.TOC("matint","M12G1-Zr55cB0.g",[49013808]);
AGR.TOC("matint","M12G1-Zr66B0.g",[-49745577]);
AGR.TOC("matint","M12G1-Zr99B0.g",[127931032]);
AGR.TOC("matint","M12G1-Zr120B0.g",[-88353220]);
AGR.TOC("matint","M12G1-Zr144B0.g",[55976025]);
AGR.TOC("matint","M12G1-Zr176B0.g",[37102922]);
AGR.TOC("maxes","M12G1-max1W1",[-74887234]);
AGR.TOC("maxes","M12G1-max2W1",[-103508023]);
AGR.TOC("maxes","M12G1-max3W1",[-46947109]);
AGR.TOC("maxes","M12G1-max4W1",[122531757]);
AGR.TOC("maxes","M12G1-max5W1",[-72442915]);
AGR.TOC("maxes","M12G1-max6W1",[-115977755]);
AGR.TOC("maxes","M12G1-max7W1",[-7727314]);
AGR.TOC("maxes","M12G1-max8W1",[-25167283]);
AGR.TOC("maxes","M12G1-max9W1",[-119063057]);
AGR.TOC("maxes","M12G1-max9W2",[103098466]);
AGR.TOC("maxes","M12G1-max10W1",[21615072]);
AGR.TOC("maxes","M12G1-max11W1",[31496255]);
AGR.TOC("cyclic","M12G1-cycW1",[-43136937]);
AGR.TOC("cyc2ccl","M12G1cycW1-cclsW1",[-83580916]);
AGR.TOC("find","M12G1-find1",[114877484]);
AGR.TOC("check","M12G1-check1",[10112000]);
AGR.TOC("pres","M12G1-P1",[-104566534]);

# M12d2
AGR.GRP("spor","M12","M12d2");
AGR.TOC("perm","M12d2G1-p24B0.m",[85361421,36218677]);
AGR.TOC("matff","M12d2G1-f2r10B0.m",[-39183640,98958554]);
AGR.TOC("matff","M12d2G1-f2r32B0.m",[69559674,55891503]);
AGR.TOC("matff","M12d2G1-f2r44B0.m",[-114562868,54725308]);
AGR.TOC("matff","M12d2G1-f2r144B0.m",[119502516,-18771909]);
AGR.TOC("matff","M12d2G1-f3r20aB0.m",[-46752782,-108429068]);
AGR.TOC("matff","M12d2G1-f3r30aB0.m",[24169138,-130765309]);
AGR.TOC("matff","M12d2G1-f3r34aB0.m",[-130589788,-129061493]);
AGR.TOC("matff","M12d2G1-f3r45aB0.m",[-70607796,-57393951]);
AGR.TOC("matff","M12d2G1-f3r90aB0.m",[-55377240,-61327165]);
AGR.TOC("matff","M12d2G1-f3r99aB0.m",[-109489496,3522822]);
AGR.TOC("matff","M12d2G1-f5r22aB0.m",[-126221984,-74607577]);
AGR.TOC("matff","M12d2G1-f5r32aB0.m",[36044101,23981739]);
AGR.TOC("matff","M12d2G1-f5r45aB0.m",[-30491799,115673903]);
AGR.TOC("matff","M12d2G1-f5r55aB0.m",[-35236987,-31452685]);
AGR.TOC("matff","M12d2G1-f5r66aB0.m",[-33014102,-99933291]);
AGR.TOC("matff","M12d2G1-f5r78aB0.m",[-18026437,34364040]);
AGR.TOC("matff","M12d2G1-f5r98aB0.m",[22041299,-66452079]);
AGR.TOC("matff","M12d2G1-f5r110aB0.m",[-30352804,81435913]);
AGR.TOC("matff","M12d2G1-f9r54aB0.m",[32626589,25634529]);
AGR.TOC("matff","M12d2G1-f11r16aB0.m",[-36796290,-43495409]);
AGR.TOC("matff","M12d2G1-f11r22aB0.m",[-105783911,98859320]);
AGR.TOC("matff","M12d2G1-f11r29aB0.m",[11546275,96104565]);
AGR.TOC("matff","M12d2G1-f11r53aB0.m",[-103408143,55355629]);
AGR.TOC("matff","M12d2G1-f11r55aB0.m",[-78072260,-3025683]);
AGR.TOC("matff","M12d2G1-f11r66aB0.m",[-100452523,75555621]);
AGR.TOC("matff","M12d2G1-f11r91aB0.m",[22098706,56302525]);
AGR.TOC("matff","M12d2G1-f11r99aB0.m",[47013209,-19879758]);
AGR.TOC("matff","M12d2G1-f11r110aB0.m",[114279619,38742074]);
AGR.TOC("matff","M12d2G1-f11r176aB0.m",[-54368026,126683633]);
AGR.TOC("matff","M12d2G1-f25r120aB0.m",[-106674804,-45635490]);
AGR.TOC("maxes","M12d2G1-max2W1",[80704822]);
AGR.TOC("maxes","M12d2G1-max2W2",[-15618703]);
AGR.TOC("maxes","M12d2G1-max3W1",[-67457384]);
AGR.TOC("maxes","M12d2G1-max3W2",[-5625195]);
AGR.TOC("maxes","M12d2G1-max4W1",[52870876]);
AGR.TOC("maxes","M12d2G1-max5W1",[61547913]);
AGR.TOC("maxes","M12d2G1-max6W1",[77063171]);
AGR.TOC("maxes","M12d2G1-max7W1",[-81985076]);
AGR.TOC("maxes","M12d2G1-max8W1",[92948753]);
AGR.TOC("maxes","M12d2G1-max9W1",[-76208250]);
AGR.TOC("cyclic","M12d2G1-cycW1",[132557223]);
AGR.TOC("find","M12d2G1-find1",[-122825568]);
AGR.TOC("check","M12d2G1-check1",[-27876306]);
AGR.TOC("pres","M12d2G1-P1",[-133855910]);
AGR.TOC("pres","M12d2G1-P2",[-72708144]);

# 12M22
AGR.GRP("spor","M22","12M22");
AGR.TOC("perm","12M22G1-p31680aB0.m",[9906127,-59852062]);
AGR.TOC("matff","12M22G1-f25r48aB0.m",[-46557856,81641584]);
AGR.TOC("matff","12M22G1-f25r120aB0.m",[-125088758,-2506418]);
AGR.TOC("matff","12M22G1-f25r120bB0.m",[-78561283,-105812013]);
AGR.TOC("matff","12M22G1-f25r144aB0.m",[-29975526,-65673389]);
AGR.TOC("matff","12M22G1-f25r144bB0.m",[127272957,-130662528]);
AGR.TOC("matff","12M22G1-f25r336aB0.m",[-37713301,-105379825]);
AGR.TOC("matff","12M22G1-f49r120aB0.m",[-63290246,52705833]);
AGR.TOC("matff","12M22G1-f49r120bB0.m",[-79132900,108295515]);
AGR.TOC("matff","12M22G1-f49r144aB0.m",[-94406601,15940801]);
AGR.TOC("matff","12M22G1-f49r336aB0.m",[-51155111,-121195002]);
AGR.TOC("matff","12M22G1-f49r336bB0.m",[106595095,-123597501]);
AGR.TOC("matff","12M22G1-f121r24aB0.m",[-40536384,104596703]);
AGR.TOC("matff","12M22G1-f121r24bB0.m",[23328519,-48149838]);
AGR.TOC("matff","12M22G1-f121r96aB0.m",[-48948579,-80134011]);
AGR.TOC("matff","12M22G1-f121r120aB0.m",[-115277169,-72547597]);
AGR.TOC("matff","12M22G1-f121r120bB0.m",[8658388,-133539247]);
AGR.TOC("matff","12M22G1-f121r120cB0.m",[96485657,79917231]);
AGR.TOC("matff","12M22G1-f121r120dB0.m",[-30849462,-51073305]);
AGR.TOC("matff","12M22G1-f121r144aB0.m",[17917213,-112666056]);
AGR.TOC("matff","12M22G1-f121r144bB0.m",[-53370978,103893560]);
AGR.TOC("matff","12M22G1-f121r336aB0.m",[-42702128,-13658617]);

# 12M22d2
AGR.GRP("spor","M22","12M22d2");
AGR.TOC("matff","12M22d2G1-f11r48B0.m",[69671352,-16302678]);

# 2M22
AGR.GRP("spor","M22","2M22");
AGR.TOC("perm","2M22G1-p352aB0.m",[56143277,128925707]);
AGR.TOC("perm","2M22G1-p660B0.m",[95495599,37777135]);
AGR.TOC("matff","2M22G1-f3r56B0.m",[-61287125,109003991]);
AGR.TOC("matff","2M22G1-f3r120B0.m",[-121061359,115873279]);
AGR.TOC("matff","2M22G1-f3r126bB0.m",[121656924,94851182]);
AGR.TOC("matff","2M22G1-f3r210B0.m",[-115777653,74358765]);
AGR.TOC("matff","2M22G1-f5r28aB0.m",[125168210,-91335665]);
AGR.TOC("matff","2M22G1-f5r28bB0.m",[69803757,-17568613]);
AGR.TOC("matff","2M22G1-f5r120B0.m",[-56121636,101087527]);
AGR.TOC("matff","2M22G1-f5r210B0.m",[128119568,45453382]);
AGR.TOC("matff","2M22G1-f5r330B0.m",[16155567,122563512]);
AGR.TOC("matff","2M22G1-f5r440B0.m",[-33733768,-627019]);
AGR.TOC("matff","2M22G1-f7r10B0.m",[-22029031,84566230]);
AGR.TOC("matff","2M22G1-f7r56B0.m",[-91585793,-91433509]);
AGR.TOC("matff","2M22G1-f7r120B0.m",[-22293731,15728191]);
AGR.TOC("matff","2M22G1-f7r210B0.m",[-50099914,-99706141]);
AGR.TOC("matff","2M22G1-f7r252B0.m",[-129684483,12894509]);
AGR.TOC("matff","2M22G1-f7r308B0.m",[-24314328,-42732558]);
AGR.TOC("matff","2M22G1-f7r320B0.m",[-101701630,-30746747]);
AGR.TOC("matff","2M22G1-f9r10aB0.m",[17201638,-128074961]);
AGR.TOC("matff","2M22G1-f9r10bB0.m",[-95892414,102336354]);
AGR.TOC("matff","2M22G1-f9r154B0.m",[-116228794,83263333]);
AGR.TOC("matff","2M22G1-f11r10aB0.m",[-134098178,-53384331]);
AGR.TOC("matff","2M22G1-f11r10bB0.m",[-10782644,82512695]);
AGR.TOC("matff","2M22G1-f11r56B0.m",[106482032,-121137932]);
AGR.TOC("matff","2M22G1-f11r64B0.m",[22318679,-70253560]);
AGR.TOC("matff","2M22G1-f11r126B0.m",[-7631317,-11671494]);
AGR.TOC("matff","2M22G1-f11r308B0.m",[-54648878,128686514]);
AGR.TOC("matff","2M22G1-f11r330B0.m",[102617152,65024357]);
AGR.TOC("matff","2M22G1-f11r440B0.m",[28399241,-2102835]);
AGR.TOC("matff","2M22G1-f25r10aB0.m",[-98977995,-27415385]);
AGR.TOC("matff","2M22G1-f25r10bB0.m",[-99451378,5112945]);
AGR.TOC("matff","2M22G1-f25r126aB0.m",[-57218262,15084879]);
AGR.TOC("matff","2M22G1-f49r126aB0.m",[13107552,-131187163]);
AGR.TOC("matff","2M22G1-f49r126bB0.m",[131551529,-4166631]);
AGR.TOC("matff","2M22G1-f49r154aB0.m",[-121191028,-107331814]);
AGR.TOC("matff","2M22G1-f49r154bB0.m",[73554621,-61424212]);
AGR.TOC("matff","2M22G1-f121r154aB0.m",[-133974502,-84368600]);
AGR.TOC("matff","2M22G1-f121r154bB0.m",[-45934554,119466995]);
AGR.TOC("matint","2M22G1-Zr20B0.g",[-63673770]);
AGR.TOC("matint","2M22G1-Zr56B0.g",[-103613096]);
AGR.TOC("matint","2M22G1-Zr120B0.g",[-37007248]);
AGR.TOC("matint","2M22G1-Zr210B0.g",[114162666]);
AGR.TOC("matmodn","2M22G1-Z4r10aB0.g",[-20114809]);

# 2M22d2
AGR.GRP("spor","M22","2M22d2");
AGR.TOC("matff","2M22d2G1-f7r10aB0.m",[-89057001,-348588]);
AGR.TOC("matff","2M22d2G1-f9r10bB0.m",[-1432588,-125687051]);
AGR.TOC("matff","2M22d2G1-f11r10bB0.m",[66479975,-36612750]);
AGR.TOC("matff","2M22d2G1-f25r10bB0.m",[26926212,123375069]);

# 3M22
AGR.GRP("spor","M22","3M22");
AGR.TOC("perm","3M22G1-p693B0.m",[-90950774,-36534057]);
AGR.TOC("perm","3M22G1-p990B0.m",[88405894,15556203]);
AGR.TOC("perm","3M22G1-p2016B0.m",[42690420,-31772423]);
AGR.TOC("matff","3M22G1-f4r6aB0.m",[71234966,-87182868]);
AGR.TOC("matff","3M22G1-f4r15aB0.m",[132279547,39475398]);
AGR.TOC("matff","3M22G1-f4r45aB0.m",[23089284,-41495564]);
AGR.TOC("matff","3M22G1-f4r45bB0.m",[-92557253,-77110222]);
AGR.TOC("matff","3M22G1-f4r84aB0.m",[3098833,69483187]);
AGR.TOC("matff","3M22G1-f4r384aB0.m",[53704323,89379282]);
AGR.TOC("matff","3M22G1-f7r21aB0.m",[-29699237,-14040638]);
AGR.TOC("matff","3M22G1-f7r45aB0.m",[7805648,52649302]);
AGR.TOC("matff","3M22G1-f7r99aB0.m",[26796142,-65889647]);
AGR.TOC("matff","3M22G1-f7r210aB0.m",[-103908876,-11419203]);
AGR.TOC("matff","3M22G1-f7r210bB0.m",[7176595,94287278]);
AGR.TOC("matff","3M22G1-f7r231aB0.m",[93436445,35648684]);
AGR.TOC("matff","3M22G1-f7r231bB0.m",[133208162,52368388]);
AGR.TOC("matff","3M22G1-f7r285aB0.m",[-91260757,105658476]);
AGR.TOC("matff","3M22G1-f25r21aB0.m",[60937788,3361834]);
AGR.TOC("matff","3M22G1-f25r45aB0.m",[-43147185,-103043419]);
AGR.TOC("matff","3M22G1-f25r45bB0.m",[-9112148,70548030]);
AGR.TOC("matff","3M22G1-f25r78aB0.m",[118019622,-68687596]);
AGR.TOC("matff","3M22G1-f25r105aB0.m",[107285554,-73950486]);
AGR.TOC("matff","3M22G1-f25r105bB0.m",[-6246678,-49079695]);
AGR.TOC("matff","3M22G1-f25r153aB0.m",[85663391,-121210049]);
AGR.TOC("matff","3M22G1-f25r210aB0.m",[-105966657,10593901]);
AGR.TOC("matff","3M22G1-f25r231aB0.m",[8691771,-46254777]);
AGR.TOC("matff","3M22G1-f25r330aB0.m",[-131760822,-83048131]);
AGR.TOC("matff","3M22G1-f49r105aB0.m",[93962384,-67672397]);
AGR.TOC("matff","3M22G1-f49r105bB0.m",[-59095893,109124393]);
AGR.TOC("matff","3M22G1-f121r21aB0.m",[-39874224,-34796923]);
AGR.TOC("matff","3M22G1-f121r21a1B0.m",[17337245,-117197209]);
AGR.TOC("matff","3M22G1-f121r45aB0.m",[-76674299,2389962]);
AGR.TOC("matff","3M22G1-f121r45bB0.m",[-74576484,82056758]);
AGR.TOC("matff","3M22G1-f121r84aB0.m",[-25406504,-66805706]);
AGR.TOC("matff","3M22G1-f121r99aB0.m",[127801704,-93344375]);
AGR.TOC("matff","3M22G1-f121r210aB0.m",[-93910269,55722704]);
AGR.TOC("matff","3M22G1-f121r231aB0.m",[56839442,115186698]);
AGR.TOC("matff","3M22G1-f121r231bB0.m",[-24203685,23469173]);
AGR.TOC("matff","3M22G1-f121r330aB0.m",[124278958,96479011]);

# 3M22d2
AGR.GRP("spor","M22","3M22d2");
AGR.TOC("matff","3M22d2G1-f2r12B0.m",[6840548,-26232830]);

# 4M22
AGR.GRP("spor","M22","4M22");
AGR.TOC("perm","4M22G1-p4928aB0.m",[11585037,105129294]);
AGR.TOC("perm","4M22G1-p4928bB0.m",[61651366,86992085]);
AGR.TOC("matff","4M22G1-f5r160aB0.m",[-24431069,5648069]);
AGR.TOC("matff","4M22G1-f5r160bB0.m",[-91637796,108820756]);
AGR.TOC("matff","4M22G1-f5r560aB0.m",[49697557,42774244]);
AGR.TOC("matff","4M22G1-f9r56aB0.m",[-4511476,-85229496]);
AGR.TOC("matff","4M22G1-f9r56bB0.m",[-85284070,-63400015]);
AGR.TOC("matff","4M22G1-f9r64aB0.m",[11491563,-57962702]);
AGR.TOC("matff","4M22G1-f9r144aB0.m",[12095402,83939207]);
AGR.TOC("matff","4M22G1-f9r144bB0.m",[16268112,21905840]);
AGR.TOC("matff","4M22G1-f9r160aB0.m",[8089512,-50786849]);
AGR.TOC("matff","4M22G1-f9r160bB0.m",[-110141442,84589679]);
AGR.TOC("matff","4M22G1-f25r56aB0.m",[-64919639,110217711]);
AGR.TOC("matff","4M22G1-f25r56bB0.m",[-66086722,-42618990]);
AGR.TOC("matff","4M22G1-f25r88aB0.m",[-7028213,-55102756]);
AGR.TOC("matff","4M22G1-f25r88bB0.m",[-89593330,-14296138]);
AGR.TOC("matff","4M22G1-f49r16aB0.m",[-83990831,-17954821]);
AGR.TOC("matff","4M22G1-f49r56aB0.m",[104359104,-130972437]);
AGR.TOC("matff","4M22G1-f49r56bB0.m",[64863017,-25151610]);
AGR.TOC("matff","4M22G1-f49r144aB0.m",[32202062,110809734]);
AGR.TOC("matff","4M22G1-f49r160aB0.m",[10828994,61470740]);
AGR.TOC("matff","4M22G1-f49r560aB0.m",[-118236950,123907225]);
AGR.TOC("matff","4M22G1-f121r56aB0.m",[102752874,81508189]);
AGR.TOC("matff","4M22G1-f121r56bB0.m",[-50141594,117960335]);
AGR.TOC("matff","4M22G1-f121r144aB0.m",[-116885944,-57532000]);
AGR.TOC("matff","4M22G1-f121r144bB0.m",[32299598,-87521745]);
AGR.TOC("matff","4M22G1-f121r160aB0.m",[-112598365,-69807599]);
AGR.TOC("matff","4M22G1-f121r176aB0.m",[-77732242,38321848]);

# 4M22d2
AGR.GRP("spor","M22","4M22d2");
AGR.TOC("matff","4M22d2G1-f7r32B0.m",[95409404,100722998]);

# 6M22
AGR.GRP("spor","M22","6M22");
AGR.TOC("perm","6M22G1-p1980B0.m",[-34361411,-22911521]);
AGR.TOC("matff","6M22G1-f7r54aB0.m",[9967088,-85473402]);
AGR.TOC("matff","6M22G1-f7r66aB0.m",[28289005,20396332]);
AGR.TOC("matff","6M22G1-f7r210aB0.m",[21913981,-30012010]);
AGR.TOC("matff","6M22G1-f7r252aB0.m",[-55729871,46346398]);
AGR.TOC("matff","6M22G1-f7r330aB0.m",[-100871511,-28803112]);
AGR.TOC("matff","6M22G1-f7r420aB0.m",[-45585257,67096229]);
AGR.TOC("matff","6M22G1-f25r66aB0.m",[-75232219,-102853624]);
AGR.TOC("matff","6M22G1-f25r66bB0.m",[-97605414,66327552]);
AGR.TOC("matff","6M22G1-f25r120aB0.m",[-85156605,94909756]);
AGR.TOC("matff","6M22G1-f25r126aB0.m",[-7401864,65424553]);
AGR.TOC("matff","6M22G1-f25r126bB0.m",[62266197,-96560539]);
AGR.TOC("matff","6M22G1-f25r210aB0.m",[-13142946,4729517]);
AGR.TOC("matff","6M22G1-f25r210bB0.m",[84479748,23802815]);
AGR.TOC("matff","6M22G1-f25r210cB0.m",[121914827,-17204842]);
AGR.TOC("matff","6M22G1-f25r330aB0.m",[24086159,-70084100]);
AGR.TOC("matff","6M22G1-f49r126aB0.m",[-66544000,36901116]);
AGR.TOC("matff","6M22G1-f49r126bB0.m",[-36437176,-11649204]);
AGR.TOC("matff","6M22G1-f49r210bB0.m",[36277584,101781842]);
AGR.TOC("matff","6M22G1-f49r210cB0.m",[-104731780,-40717739]);
AGR.TOC("matff","6M22G1-f121r36aB0.m",[18342608,125425919]);
AGR.TOC("matff","6M22G1-f121r36a1B0.m",[-94823834,-17650354]);
AGR.TOC("matff","6M22G1-f121r66aB0.m",[7571032,-98520871]);
AGR.TOC("matff","6M22G1-f121r66bB0.m",[110495588,61939331]);
AGR.TOC("matff","6M22G1-f121r90aB0.m",[47082380,-107831827]);
AGR.TOC("matff","6M22G1-f121r120aB0.m",[-78977570,80520063]);
AGR.TOC("matff","6M22G1-f121r174aB0.m",[-26250212,-67037255]);
AGR.TOC("matff","6M22G1-f121r210aB0.m",[69887357,-53414700]);
AGR.TOC("matff","6M22G1-f121r330aB0.m",[-102575627,10806500]);

# 6M22d2
AGR.GRP("spor","M22","6M22d2");
AGR.TOC("matff","6M22d2G1-f11r72B0.m",[50152179,29673410]);

# M22
AGR.GRP("spor","M22","M22");
AGR.TOC("perm","M22G1-p22B0.m",[120088212,-117893933]);
AGR.TOC("perm","M22G1-p77B0.m",[-60412592,-39004054]);
AGR.TOC("perm","M22G1-p176aB0.m",[-117058973,-13255017]);
AGR.TOC("perm","M22G1-p176bB0.m",[-71876488,64385171]);
AGR.TOC("perm","M22G1-p231B0.m",[-100923681,-20737374]);
AGR.TOC("perm","M22G1-p330B0.m",[-67557036,23142407]);
AGR.TOC("perm","M22G1-p462aB0.m",[-65976175,23533673]);
AGR.TOC("perm","M22G1-p462bB0.m",[-59778880,95539211]);
AGR.TOC("perm","M22G1-p462cB0.m",[-49482222,52549893]);
AGR.TOC("perm","M22G1-p616B0.m",[-3074412,-115809031]);
AGR.TOC("perm","M22G1-p672B0.m",[7640483,-115001890]);
AGR.TOC("perm","M22G1-p770B0.m",[120630396,-32668057]);
AGR.TOC("matff","M22G1-f2r10aB0.m",[93955492,72279513]);
AGR.TOC("matff","M22G1-f2r10bB0.m",[-64432252,-10720956]);
AGR.TOC("matff","M22G1-f2r34B0.m",[109181802,69819591]);
AGR.TOC("matff","M22G1-f2r98B0.m",[20614323,-91349386]);
AGR.TOC("matff","M22G1-f3r21B0.m",[2319237,-40869995]);
AGR.TOC("matff","M22G1-f3r49aB0.m",[48294192,10182642]);
AGR.TOC("matff","M22G1-f3r49bB0.m",[123534207,114086963]);
AGR.TOC("matff","M22G1-f3r55B0.m",[6858684,37531924]);
AGR.TOC("matff","M22G1-f3r99B0.m",[108404973,-18754208]);
AGR.TOC("matff","M22G1-f3r210B0.m",[12080907,20988418]);
AGR.TOC("matff","M22G1-f3r231B0.m",[-122316352,101359885]);
AGR.TOC("matff","M22G1-f4r70aB0.m",[-61080913,5645990]);
AGR.TOC("matff","M22G1-f4r70bB0.m",[119680241,-57957631]);
AGR.TOC("matff","M22G1-f5r21B0.m",[95454839,98341706]);
AGR.TOC("matff","M22G1-f5r55B0.m",[86944414,-106029713]);
AGR.TOC("matff","M22G1-f5r98B0.m",[27831268,-45715352]);
AGR.TOC("matff","M22G1-f5r133B0.m",[-129991529,120806590]);
AGR.TOC("matff","M22G1-f5r210B0.m",[103633115,125473720]);
AGR.TOC("matff","M22G1-f5r280aB0.m",[-132987247,24183680]);
AGR.TOC("matff","M22G1-f5r385B0.m",[57398607,13638594]);
AGR.TOC("matff","M22G1-f7r21B0.m",[35391543,72293264]);
AGR.TOC("matff","M22G1-f7r45B0.m",[-109057607,114091080]);
AGR.TOC("matff","M22G1-f7r54B0.m",[40209085,53790651]);
AGR.TOC("matff","M22G1-f7r154B0.m",[-43277479,76833098]);
AGR.TOC("matff","M22G1-f7r210B0.m",[-115679524,-44095420]);
AGR.TOC("matff","M22G1-f7r231B0.m",[74317215,19149303]);
AGR.TOC("matff","M22G1-f7r385B0.m",[-22401150,-21936165]);
AGR.TOC("matff","M22G1-f9r45aB0.m",[-101961334,-50630745]);
AGR.TOC("matff","M22G1-f11r20B0.m",[-55748559,-113866179]);
AGR.TOC("matff","M22G1-f11r45aB0.m",[61322426,-118021428]);
AGR.TOC("matff","M22G1-f11r45bB0.m",[117900991,130808780]);
AGR.TOC("matff","M22G1-f11r55B0.m",[131181739,-110452977]);
AGR.TOC("matff","M22G1-f11r99B0.m",[-69355157,66661936]);
AGR.TOC("matff","M22G1-f11r154B0.m",[91700642,-11598460]);
AGR.TOC("matff","M22G1-f11r190B0.m",[-78747459,428544]);
AGR.TOC("matff","M22G1-f11r231B0.m",[-92735279,82232581]);
AGR.TOC("matff","M22G1-f11r385B0.m",[-4174418,39852578]);
AGR.TOC("matff","M22G1-f25r45aB0.m",[-32298545,-100748534]);
AGR.TOC("matff","M22G1-f49r280aB0.m",[63765143,54000780]);
AGR.TOC("matff","M22G1-f49r280bB0.m",[-110919489,-95232644]);
AGR.TOC("matint","M22G1-Zr21B0.g",[68782527]);
AGR.TOC("matint","M22G1-Zr55B0.g",[-98762146]);
AGR.TOC("matint","M22G1-Zr99B0.g",[-64451966]);
AGR.TOC("matint","M22G1-Zr154B0.g",[-78499440]);
AGR.TOC("matint","M22G1-Zr210B0.g",[-49657556]);
AGR.TOC("matint","M22G1-Zr231B0.g",[-75863010]);
AGR.TOC("maxes","M22G1-max1W1",[-108162340]);
AGR.TOC("maxes","M22G1-max2W1",[86468072]);
AGR.TOC("maxes","M22G1-max3W1",[66738939]);
AGR.TOC("maxes","M22G1-max4W1",[-72501701]);
AGR.TOC("maxes","M22G1-max5W1",[32962252]);
AGR.TOC("maxes","M22G1-max6W1",[-12409309]);
AGR.TOC("maxes","M22G1-max7W1",[122295071]);
AGR.TOC("maxes","M22G1-max7W2",[-54548400]);
AGR.TOC("maxes","M22G1-max8W1",[-43185300]);
AGR.TOC("cyclic","M22G1-cycW1",[75634248]);
AGR.TOC("cyclic","M22G1-cycW2",[79365136]);
AGR.TOC("cyc2ccl","M22G1cycW1-cclsW1",[-73021974]);
AGR.TOC("find","M22G1-find1",[-22929670]);
AGR.TOC("check","M22G1-check1",[-117375842]);
AGR.TOC("pres","M22G1-P1",[104320198]);

# M22d2
AGR.GRP("spor","M22","M22d2");
AGR.TOC("perm","M22d2G1-p22B0.m",[86602657,-110180846]);
AGR.TOC("perm","M22d2G1-p77B0.m",[11661714,-65509390]);
AGR.TOC("perm","M22d2G1-p231B0.m",[-1462911,-41392807]);
AGR.TOC("perm","M22d2G1-p330B0.m",[-59463654,-62454811]);
AGR.TOC("perm","M22d2G1-p352B0.m",[-11066693,124793148]);
AGR.TOC("perm","M22d2G1-p616B0.m",[-16850080,-113061237]);
AGR.TOC("perm","M22d2G1-p672B0.m",[-9473389,-30463793]);
AGR.TOC("matff","M22d2G1-f2r10aB0.m",[-90630307,-128468476]);
AGR.TOC("matff","M22d2G1-f2r10bB0.m",[17206676,63639932]);
AGR.TOC("matff","M22d2G1-f2r34B0.m",[-89926694,-127454121]);
AGR.TOC("matff","M22d2G1-f2r98B0.m",[84593793,107508647]);
AGR.TOC("matff","M22d2G1-f2r140B0.m",[67560328,41049421]);
AGR.TOC("matff","M22d2G1-f3r21aB0.m",[-92501974,-107109745]);
AGR.TOC("matff","M22d2G1-f3r55aB0.m",[-76213947,-10156798]);
AGR.TOC("matff","M22d2G1-f3r98B0.m",[59603673,6484183]);
AGR.TOC("matff","M22d2G1-f3r99aB0.m",[22980,-10081575]);
AGR.TOC("matff","M22d2G1-f3r210aB0.m",[-80001338,-131679871]);
AGR.TOC("matff","M22d2G1-f3r231aB0.m",[-133826445,-23325070]);
AGR.TOC("matff","M22d2G1-f5r21aB0.m",[-35842635,-17579168]);
AGR.TOC("matff","M22d2G1-f5r55aB0.m",[104666460,-133136627]);
AGR.TOC("matff","M22d2G1-f5r98aB0.m",[-15665933,10768741]);
AGR.TOC("matff","M22d2G1-f5r133aB0.m",[6631388,111796983]);
AGR.TOC("matff","M22d2G1-f5r210aB0.m",[-100109991,39935080]);
AGR.TOC("matff","M22d2G1-f5r385aB0.m",[19370917,75584038]);
AGR.TOC("matff","M22d2G1-f5r560B0.m",[-5741100,22721739]);
AGR.TOC("matff","M22d2G1-f7r21aB0.m",[-67112680,43045281]);
AGR.TOC("matff","M22d2G1-f7r45aB0.m",[2846321,-6133671]);
AGR.TOC("matff","M22d2G1-f7r54aB0.m",[-1166393,-37567711]);
AGR.TOC("matff","M22d2G1-f7r154aB0.m",[-106850501,-56652481]);
AGR.TOC("matff","M22d2G1-f7r210aB0.m",[-7605737,-77888289]);
AGR.TOC("matff","M22d2G1-f7r231aB0.m",[94268020,20313882]);
AGR.TOC("matff","M22d2G1-f7r385aB0.m",[79734490,-27768815]);
AGR.TOC("matff","M22d2G1-f7r560B0.m",[-92302801,42190990]);
AGR.TOC("matff","M22d2G1-f9r45aB0.m",[-32652339,-115868824]);
AGR.TOC("matff","M22d2G1-f9r45bB0.m",[-4373288,37153914]);
AGR.TOC("matff","M22d2G1-f11r20aB0.m",[-10228550,-28363284]);
AGR.TOC("matff","M22d2G1-f11r45aB0.m",[-115303832,7271263]);
AGR.TOC("matff","M22d2G1-f11r45bB0.m",[65584681,76308413]);
AGR.TOC("matff","M22d2G1-f11r55aB0.m",[-42280703,56446882]);
AGR.TOC("matff","M22d2G1-f11r99aB0.m",[78828095,-95138735]);
AGR.TOC("matff","M22d2G1-f11r154aB0.m",[-125684610,59549727]);
AGR.TOC("matff","M22d2G1-f11r190aB0.m",[130351633,-99707873]);
AGR.TOC("matff","M22d2G1-f11r231aB0.m",[-21953425,88673416]);
AGR.TOC("matff","M22d2G1-f11r385aB0.m",[14676131,-85493410]);
AGR.TOC("matff","M22d2G1-f25r45aB0.m",[23900540,-8771718]);
AGR.TOC("matff","M22d2G1-f25r45bB0.m",[29914508,120865664]);
AGR.TOC("maxes","M22d2G1-max1W1",[-28226023]);
AGR.TOC("maxes","M22d2G1-max1W2",[-24429373]);
AGR.TOC("maxes","M22d2G1-max2W1",[41701063]);
AGR.TOC("maxes","M22d2G1-max2W2",[96835542]);
AGR.TOC("maxes","M22d2G1-max3W1",[94478419]);
AGR.TOC("maxes","M22d2G1-max4W1",[56584143]);
AGR.TOC("maxes","M22d2G1-max5W1",[-47328183]);
AGR.TOC("maxes","M22d2G1-max5W2",[-33392236]);
AGR.TOC("maxes","M22d2G1-max6W1",[-134200980]);
AGR.TOC("maxes","M22d2G1-max7W1",[36093093]);
AGR.TOC("maxes","M22d2G1-max7W2",[42318604]);
AGR.TOC("cyclic","M22d2G1-cycW1",[-73012825]);
AGR.TOC("cyc2ccl","M22d2G1cycW1-cclsW1",[46889110]);
AGR.TOC("find","M22d2G1-find1",[-64593058]);
AGR.TOC("check","M22d2G1-check1",[32836613]);
AGR.TOC("pres","M22d2G1-P1",[-7009976]);

# M23
AGR.GRP("spor","M23","M23");
AGR.TOC("perm","M23G1-p23B0.m",[-100860468,134035545]);
AGR.TOC("perm","M23G1-p253aB0.m",[112730578,127077447]);
AGR.TOC("perm","M23G1-p253bB0.m",[24187844,-99879066]);
AGR.TOC("perm","M23G1-p506B0.m",[133932382,72600534]);
AGR.TOC("perm","M23G1-p1288B0.m",[-84395714,94531011]);
AGR.TOC("perm","M23G1-p1771B0.m",[-2600980,60172805]);
AGR.TOC("perm","M23G1-p40320B0.m",[-134072939,97361009]);
AGR.TOC("matff","M23G1-f2r11aB0.m",[92412226,99097621]);
AGR.TOC("matff","M23G1-f2r11bB0.m",[-75650132,-64182966]);
AGR.TOC("matff","M23G1-f2r44aB0.m",[-31974611,68547307]);
AGR.TOC("matff","M23G1-f2r44bB0.m",[39718097,-124066485]);
AGR.TOC("matff","M23G1-f2r120B0.m",[-113866580,-63331011]);
AGR.TOC("matff","M23G1-f2r220aB0.m",[-86962328,-81382235]);
AGR.TOC("matff","M23G1-f2r220bB0.m",[-115044176,-101407103]);
AGR.TOC("matff","M23G1-f2r252B0.m",[-110016101,-60073054]);
AGR.TOC("matff","M23G1-f3r22B0.m",[-36385545,-15448429]);
AGR.TOC("matff","M23G1-f3r104aB0.m",[-120194361,-100341681]);
AGR.TOC("matff","M23G1-f3r104bB0.m",[-100112989,-67853695]);
AGR.TOC("matff","M23G1-f3r231B0.m",[-59421394,66873842]);
AGR.TOC("matff","M23G1-f3r253B0.m",[115197826,-75226257]);
AGR.TOC("matff","M23G1-f3r770aB0.m",[-50745745,-127476955]);
AGR.TOC("matff","M23G1-f4r896aB0.m",[79604086,129778838]);
AGR.TOC("matff","M23G1-f4r896bB0.m",[1564561,-132647208]);
AGR.TOC("matff","M23G1-f5r22B0.m",[110977893,65082343]);
AGR.TOC("matff","M23G1-f5r230B0.m",[-17598208,-107309542]);
AGR.TOC("matff","M23G1-f5r231aB0.m",[66242910,-26415424]);
AGR.TOC("matff","M23G1-f5r231bB0.m",[-36703530,74201785]);
AGR.TOC("matff","M23G1-f5r896aB0.m",[-10230930,126936296]);
AGR.TOC("matff","M23G1-f7r22B0.m",[83749274,-81701398]);
AGR.TOC("matff","M23G1-f7r45B0.m",[119901626,31746262]);
AGR.TOC("matff","M23G1-f7r208B0.m",[-131498870,103553188]);
AGR.TOC("matff","M23G1-f7r231aB0.m",[73195829,-54497879]);
AGR.TOC("matff","M23G1-f7r990B0.m",[-132653617,119679425]);
AGR.TOC("matff","M23G1-f9r45bB0.m",[-127901148,-108530718]);
AGR.TOC("matff","M23G1-f9r990bB0.m",[116336332,122680284]);
AGR.TOC("matff","M23G1-f11r22B0.m",[54637034,6489040]);
AGR.TOC("matff","M23G1-f11r45bB0.m",[-51057705,-86906861]);
AGR.TOC("matff","M23G1-f11r229B0.m",[1224283,102271717]);
AGR.TOC("matff","M23G1-f11r231aB0.m",[75699015,37254489]);
AGR.TOC("matff","M23G1-f11r253B0.m",[-134189740,83294965]);
AGR.TOC("matff","M23G1-f11r806B0.m",[-102453078,96809740]);
AGR.TOC("matff","M23G1-f11r990aB0.m",[91508789,76517999]);
AGR.TOC("matff","M23G1-f23r21B0.m",[123156478,48784163]);
AGR.TOC("matff","M23G1-f23r45bB0.m",[54480828,15262719]);
AGR.TOC("matff","M23G1-f23r210B0.m",[98875790,-43341672]);
AGR.TOC("matff","M23G1-f23r230B0.m",[128932608,47573421]);
AGR.TOC("matff","M23G1-f23r231aB0.m",[13816289,11783324]);
AGR.TOC("matff","M23G1-f23r253B0.m",[70082102,86222539]);
AGR.TOC("matff","M23G1-f23r280B0.m",[-100486126,105888104]);
AGR.TOC("matff","M23G1-f23r665bB0.m",[-86565912,75506669]);
AGR.TOC("matff","M23G1-f25r45aB0.m",[-63651988,16529557]);
AGR.TOC("matff","M23G1-f25r770B0.m",[25945094,-121739652]);
AGR.TOC("matff","M23G1-f25r990aB0.m",[14490712,5435057]);
AGR.TOC("matff","M23G1-f49r231bB0.m",[112713982,62428033]);
AGR.TOC("matff","M23G1-f49r231cB0.m",[-46596743,-111079908]);
AGR.TOC("matff","M23G1-f49r770aB0.m",[48434943,101609634]);
AGR.TOC("matff","M23G1-f49r770bB0.m",[-7613774,-115624564]);
AGR.TOC("matff","M23G1-f49r896aB0.m",[-34287057,102026322]);
AGR.TOC("matff","M23G1-f49r896bB0.m",[38639819,109523786]);
AGR.TOC("matff","M23G1-f121r231bB0.m",[31844564,-73487081]);
AGR.TOC("matff","M23G1-f121r231cB0.m",[6220520,-118565449]);
AGR.TOC("matff","M23G1-f121r770aB0.m",[73486127,-76866322]);
AGR.TOC("matff","M23G1-f121r770bB0.m",[83161076,-16561573]);
AGR.TOC("matint","M23G1-Zr22B0.g",[-121440039]);
AGR.TOC("matint","M23G1-Zr230B0.g",[47145869]);
AGR.TOC("matint","M23G1-Zr231aB0.g",[-94915198]);
AGR.TOC("maxes","M23G1-max1W1",[-24165601]);
AGR.TOC("maxes","M23G1-max2W1",[-128505273]);
AGR.TOC("maxes","M23G1-max3W1",[103287015]);
AGR.TOC("maxes","M23G1-max4W1",[-125187000]);
AGR.TOC("maxes","M23G1-max5W1",[-28960133]);
AGR.TOC("maxes","M23G1-max6W1",[3238391]);
AGR.TOC("maxes","M23G1-max7W1",[-63572583]);
AGR.TOC("cyclic","M23G1-cycW1",[50189716]);
AGR.TOC("cyc2ccl","M23G1cycW1-cclsW1",[-116022309]);
AGR.TOC("find","M23G1-find1",[114090014]);
AGR.TOC("check","M23G1-check1",[-12184050]);
AGR.TOC("pres","M23G1-P1",[-101588990]);
AGR.TOC("pres","M23G1-P2",[-27167702]);

# M24
AGR.GRP("spor","M24","M24");
AGR.TOC("perm","M24G1-p24B0.m",[69729679,-50094784]);
AGR.TOC("perm","M24G1-p276B0.m",[-48137797,-71357401]);
AGR.TOC("perm","M24G1-p759B0.m",[-32835247,100541381]);
AGR.TOC("perm","M24G1-p1288B0.m",[-105109803,60825843]);
AGR.TOC("perm","M24G1-p1771B0.m",[-53290348,-40522722]);
AGR.TOC("perm","M24G1-p2024B0.m",[70785156,119340263]);
AGR.TOC("perm","M24G1-p3795B0.m",[-60516233,-49941219]);
AGR.TOC("matff","M24G1-f2r11aB0.m",[40272001,-97238947]);
AGR.TOC("matff","M24G1-f2r11bB0.m",[50964937,49863534]);
AGR.TOC("matff","M24G1-f2r44aB0.m",[22851199,6817130]);
AGR.TOC("matff","M24G1-f2r44bB0.m",[-95012821,82979184]);
AGR.TOC("matff","M24G1-f2r120B0.m",[-50819863,-33106966]);
AGR.TOC("matff","M24G1-f2r220aB0.m",[120862636,-82730718]);
AGR.TOC("matff","M24G1-f2r220bB0.m",[81903649,26327048]);
AGR.TOC("matff","M24G1-f2r252B0.m",[-71570037,-123764407]);
AGR.TOC("matff","M24G1-f2r320aB0.m",[-3286786,-9382849]);
AGR.TOC("matff","M24G1-f2r320bB0.m",[107335357,-56091905]);
AGR.TOC("matff","M24G1-f2r1242B0.m",[61922408,56953676]);
AGR.TOC("matff","M24G1-f2r1792B0.m",[-120675264,-7134767]);
AGR.TOC("matff","M24G1-f3r22B0.m",[121921842,107251646]);
AGR.TOC("matff","M24G1-f3r231B0.m",[-67248893,-41750420]);
AGR.TOC("matff","M24G1-f3r252B0.m",[36773800,10058429]);
AGR.TOC("matff","M24G1-f3r483B0.m",[129663509,42481818]);
AGR.TOC("matff","M24G1-f3r770aB0.m",[76706933,58962005]);
AGR.TOC("matff","M24G1-f3r770bB0.m",[-18902817,-1386993]);
AGR.TOC("matff","M24G1-f5r23B0.m",[-31286155,-100615534]);
AGR.TOC("matff","M24G1-f5r231B0.m",[-3104293,34489521]);
AGR.TOC("matff","M24G1-f5r252B0.m",[12668770,78103862]);
AGR.TOC("matff","M24G1-f5r253B0.m",[-61030374,68486059]);
AGR.TOC("matff","M24G1-f7r23B0.m",[-133527112,-110941087]);
AGR.TOC("matff","M24G1-f7r45B0.m",[89821164,-52784035]);
AGR.TOC("matff","M24G1-f7r252B0.m",[-89436205,-88594841]);
AGR.TOC("matff","M24G1-f7r253B0.m",[69344442,-54398731]);
AGR.TOC("matff","M24G1-f7r483B0.m",[32062896,-12902574]);
AGR.TOC("matff","M24G1-f7r990B0.m",[78507865,27503768]);
AGR.TOC("matff","M24G1-f9r45aB0.m",[-51030313,-121660802]);
AGR.TOC("matff","M24G1-f9r45bB0.m",[-26747836,74052103]);
AGR.TOC("matff","M24G1-f9r990bB0.m",[69846870,-53594523]);
AGR.TOC("matff","M24G1-f11r23B0.m",[-73893830,44738184]);
AGR.TOC("matff","M24G1-f11r45B0.m",[32491674,-78186603]);
AGR.TOC("matff","M24G1-f11r229B0.m",[-39363252,118511511]);
AGR.TOC("matff","M24G1-f11r253B0.m",[-2745752,86312317]);
AGR.TOC("matff","M24G1-f11r482B0.m",[-24340279,-1698726]);
AGR.TOC("matff","M24G1-f11r806B0.m",[-38662066,116782016]);
AGR.TOC("matff","M24G1-f11r990bB0.m",[71542649,-129337380]);
AGR.TOC("matff","M24G1-f23r23B0.m",[-80084667,88290511]);
AGR.TOC("matff","M24G1-f23r45B0.m",[-101350989,56417532]);
AGR.TOC("matff","M24G1-f23r231bB0.m",[74937308,-79336049]);
AGR.TOC("matff","M24G1-f23r251B0.m",[124453838,-82707878]);
AGR.TOC("matff","M24G1-f23r253B0.m",[-31154580,-5562077]);
AGR.TOC("matff","M24G1-f23r483B0.m",[80083472,-133029888]);
AGR.TOC("matff","M24G1-f23r770B0.m",[-71064977,68359404]);
AGR.TOC("matff","M24G1-f23r990bB0.m",[-100049652,-132065010]);
AGR.TOC("matff","M24G1-f25r45aB0.m",[93156266,17678669]);
AGR.TOC("matff","M24G1-f25r45bB0.m",[84076873,-99614928]);
AGR.TOC("matff","M24G1-f25r770aB0.m",[-77238967,27371362]);
AGR.TOC("matff","M24G1-f25r990aB0.m",[58142147,10133728]);
AGR.TOC("matff","M24G1-f49r231bB0.m",[26086794,-37182197]);
AGR.TOC("matff","M24G1-f49r770aB0.m",[118037837,-12074292]);
AGR.TOC("matff","M24G1-f121r231bB0.m",[-115996360,66090690]);
AGR.TOC("matff","M24G1-f121r770aB0.m",[-11753116,-9832376]);
AGR.TOC("matint","M24G1-Zr23B0.g",[-82579400]);
AGR.TOC("maxes","M24G1-max1W1",[-60251604]);
AGR.TOC("maxes","M24G1-max1W2",[111703741]);
AGR.TOC("maxes","M24G1-max2W1",[-74459771]);
AGR.TOC("maxes","M24G1-max3W1",[-108401652]);
AGR.TOC("maxes","M24G1-max4W1",[3804826]);
AGR.TOC("maxes","M24G1-max5W1",[2323602]);
AGR.TOC("maxes","M24G1-max6W1",[132682569]);
AGR.TOC("maxes","M24G1-max7W1",[76506186]);
AGR.TOC("maxes","M24G1-max8W1",[-102663899]);
AGR.TOC("maxes","M24G1-max9W1",[115203509]);
AGR.TOC("cyclic","M24G1-cycW1",[-56796942]);
AGR.TOC("cyc2ccl","M24G1cycW1-cclsW1",[9885207]);
AGR.TOC("find","M24G1-find1",[99762564]);
AGR.TOC("check","M24G1-check1",[-117805797]);
AGR.TOC("pres","M24G1-P1",[-19892668]);

# 3McL
AGR.GRP("spor","McL","3McL");
AGR.TOC("perm","3McLG1-p66825B0.m",[60936654,67493678]);
AGR.TOC("perm","3McLG1-p103950B0.m",[-50980231,-108548578]);
AGR.TOC("perm","3McLG1-p340200B0.m",[-67945854,-95815728]);
AGR.TOC("matff","3McLG1-f3r42B0.m",[99498753,-89665574]);
AGR.TOC("matff","3McLG1-f4r126aB0.m",[9748162,-38721246]);
AGR.TOC("matff","3McLG1-f4r396dB0.m",[85171231,126701593]);
AGR.TOC("matff","3McLG1-f25r45aB0.m",[-93885213,44318729]);
AGR.TOC("matff","3McLG1-f25r126aB0.m",[-62486368,-132035306]);
AGR.TOC("matff","3McLG1-f25r126bB0.m",[-63371139,69148948]);
AGR.TOC("matff","3McLG1-f25r153aB0.m",[68472864,47273268]);
AGR.TOC("matff","3McLG1-f25r639aB0.m",[-96966834,33763078]);
AGR.TOC("matff","3McLG1-f25r846aB0.m",[971973,-40293260]);
AGR.TOC("matff","3McLG1-f49r126aB0.m",[6910296,-99809787]);
AGR.TOC("matff","3McLG1-f49r126a1B0.m",[50224140,-62359271]);
AGR.TOC("matff","3McLG1-f49r126bB0.m",[81138596,82194185]);
AGR.TOC("matff","3McLG1-f49r126b1B0.m",[-121596870,-78979904]);
AGR.TOC("matff","3McLG1-f121r126aB0.m",[-65773772,110797052]);

# 3McLd2
AGR.GRP("spor","McL","3McLd2");
AGR.TOC("matff","3McLd2G1-f4r252aB0.m",[-69343368,40600993]);
AGR.TOC("matff","3McLd2G1-f5r90B0.m",[-394219,73863340]);
AGR.TOC("matff","3McLd2G1-f5r306B0.m",[-100747,12674032]);
AGR.TOC("matff","3McLd2G1-f5r1278B0.m",[110647295,-72472577]);

# McL
AGR.GRP("spor","McL","McL");
AGR.TOC("perm","McLG1-p275B0.m",[47898348,-128992295]);
AGR.TOC("perm","McLG1-p2025aB0.m",[-92438755,-89387202]);
AGR.TOC("perm","McLG1-p2025bB0.m",[-33910713,-67453834]);
AGR.TOC("perm","McLG1-p7128B0.m",[-108415507,128829357]);
AGR.TOC("perm","McLG1-p15400aB0.m",[-80528616,79619470]);
AGR.TOC("perm","McLG1-p15400bB0.m",[-20237023,-70709260]);
AGR.TOC("perm","McLG1-p22275aB0.m",[122489538,83932768]);
AGR.TOC("perm","McLG1-p22275bB0.m",[36151766,64738375]);
AGR.TOC("perm","McLG1-p22275cB0.m",[-79442166,331736]);
AGR.TOC("perm","McLG1-p22275dB0.m",[-75632286,66456356]);
AGR.TOC("perm","McLG1-p113400B0.m",[6999341,13472873]);
AGR.TOC("perm","McLG1-p299376B0.m",[-9479493,-2888638]);
AGR.TOC("matff","McLG1-f2r22B0.m",[-29801617,93282897]);
AGR.TOC("matff","McLG1-f2r230B0.m",[-90515213,123236950]);
AGR.TOC("matff","McLG1-f2r748aB0.m",[61620232,41476658]);
AGR.TOC("matff","McLG1-f2r748bB0.m",[11594131,-63342175]);
AGR.TOC("matff","McLG1-f3r21B0.m",[114054470,-28069582]);
AGR.TOC("matff","McLG1-f3r104aB0.m",[-10460225,35627935]);
AGR.TOC("matff","McLG1-f3r104bB0.m",[88537943,-74642905]);
AGR.TOC("matff","McLG1-f3r210B0.m",[-18678164,-77048027]);
AGR.TOC("matff","McLG1-f3r560B0.m",[-106270647,50354264]);
AGR.TOC("matff","McLG1-f4r896aB0.m",[-90586135,-115047387]);
AGR.TOC("matff","McLG1-f4r896bB0.m",[-68251794,-120220088]);
AGR.TOC("matff","McLG1-f5r21B0.m",[88783977,-75974823]);
AGR.TOC("matff","McLG1-f5r210B0.m",[-101587046,-93777169]);
AGR.TOC("matff","McLG1-f5r230B0.m",[7379395,60865678]);
AGR.TOC("matff","McLG1-f5r560B0.m",[4995570,-57381940]);
AGR.TOC("matff","McLG1-f5r896bB0.m",[-77830754,76324619]);
AGR.TOC("matff","McLG1-f7r22B0.m",[93285753,24448482]);
AGR.TOC("matff","McLG1-f7r231B0.m",[-73334366,-75104676]);
AGR.TOC("matff","McLG1-f7r252B0.m",[-133408383,-64954954]);
AGR.TOC("matff","McLG1-f9r605aB0.m",[15419571,-41576184]);
AGR.TOC("matff","McLG1-f9r605bB0.m",[-101100999,-12569507]);
AGR.TOC("matff","McLG1-f11r22B0.m",[37807153,-51356397]);
AGR.TOC("matff","McLG1-f11r231B0.m",[111051229,-24393693]);
AGR.TOC("matff","McLG1-f11r251B0.m",[-37005776,10578858]);
AGR.TOC("matff","McLG1-f11r896B0.m",[-85250757,106637974]);
AGR.TOC("matff","McLG1-f23r896bB0.m",[-23000891,-94948674]);
AGR.TOC("matff","McLG1-f25r1200aB0.m",[-28171956,83963976]);
AGR.TOC("matff","McLG1-f49r770aB0.m",[-123750876,103165319]);
AGR.TOC("matff","McLG1-f49r770bB0.m",[17458306,-14741153]);
AGR.TOC("matff","McLG1-f49r896aB0.m",[-10611582,-125807855]);
AGR.TOC("matff","McLG1-f49r896bB0.m",[80950651,88285278]);
AGR.TOC("matff","McLG1-f121r770aB0.m",[114719663,11727585]);
AGR.TOC("matff","McLG1-f121r770bB0.m",[-8445975,-26028394]);
AGR.TOC("matint","McLG1-Zr231B0.g",[-49278506]);
AGR.TOC("maxes","McLG1-max1W1",[19059882]);
AGR.TOC("maxes","McLG1-max2W1",[-62642271]);
AGR.TOC("maxes","McLG1-max3W1",[110409269]);
AGR.TOC("maxes","McLG1-max4W1",[35098666]);
AGR.TOC("maxes","McLG1-max5W1",[-55696958]);
AGR.TOC("maxes","McLG1-max6W1",[89156344]);
AGR.TOC("maxes","McLG1-max7W1",[-86705876]);
AGR.TOC("maxes","McLG1-max8W1",[73280981]);
AGR.TOC("maxes","McLG1-max9W1",[66232232]);
AGR.TOC("maxes","McLG1-max10W1",[75761973]);
AGR.TOC("maxes","McLG1-max11W1",[-31107947]);
AGR.TOC("maxes","McLG1-max12W1",[25223287]);
AGR.TOC("cyclic","McLG1-cycW1",[80099064]);
AGR.TOC("cyc2ccl","McLG1cycW1-cclsW1",[37704454]);
AGR.TOC("find","McLG1-find1",[-42473073]);
AGR.TOC("check","McLG1-check1",[90702923]);
AGR.TOC("pres","McLG1-P1",[-26372773]);

# McLd2
AGR.GRP("spor","McL","McLd2");
AGR.TOC("perm","McLd2G1-p275B0.m",[14870816,-60035920]);
AGR.TOC("perm","McLd2G1-p4050B0.m",[2540135,39919988]);
AGR.TOC("perm","McLd2G1-p7128B0.m",[26124040,60946723]);
AGR.TOC("perm","McLd2G1-p22275aB0.m",[84478906,-92915846]);
AGR.TOC("perm","McLd2G1-p44550B0.m",[30228915,66372087]);
AGR.TOC("matff","McLd2G1-f2r22B0.m",[8539527,3564557]);
AGR.TOC("matff","McLd2G1-f2r230aB0.m",[2931937,101506955]);
AGR.TOC("matff","McLd2G1-f2r1496aB0.m",[-30759426,104911468]);
AGR.TOC("matff","McLd2G1-f3r21aB0.m",[-49446994,51853136]);
AGR.TOC("matff","McLd2G1-f3r104aB0.m",[77300657,-53847227]);
AGR.TOC("matff","McLd2G1-f3r104bB0.m",[45648377,98839103]);
AGR.TOC("matff","McLd2G1-f3r210aB0.m",[114674039,52866468]);
AGR.TOC("matff","McLd2G1-f3r560aB0.m",[-109490635,-99608112]);
AGR.TOC("matff","McLd2G1-f5r21aB0.m",[80298400,-114334962]);
AGR.TOC("matff","McLd2G1-f5r210aB0.m",[696431,-23094537]);
AGR.TOC("matff","McLd2G1-f5r230aB0.m",[97104592,105161756]);
AGR.TOC("matff","McLd2G1-f5r560aB0.m",[-49219297,-39031070]);
AGR.TOC("matff","McLd2G1-f5r896aB0.m",[45641947,-75634287]);
AGR.TOC("matff","McLd2G1-f5r896bB0.m",[75500104,64305836]);
AGR.TOC("matff","McLd2G1-f7r22aB0.m",[-73156626,-131881739]);
AGR.TOC("matff","McLd2G1-f7r231aB0.m",[11393104,-63500764]);
AGR.TOC("matff","McLd2G1-f7r252aB0.m",[-22097052,-5180212]);
AGR.TOC("matff","McLd2G1-f11r22aB0.m",[-78162929,-67763669]);
AGR.TOC("matff","McLd2G1-f11r231aB0.m",[118374016,6657957]);
AGR.TOC("matff","McLd2G1-f11r251aB0.m",[53146173,-131950397]);
AGR.TOC("matff","McLd2G1-f11r896aB0.m",[58009627,-112706307]);
AGR.TOC("matff","McLd2G1-f49r896aB0.m",[73951333,70246501]);
AGR.TOC("maxes","McLd2G1-max1W1",[61006147]);
AGR.TOC("maxes","McLd2G1-max2W1",[84224117]);
AGR.TOC("maxes","McLd2G1-max3W1",[-82005936]);
AGR.TOC("maxes","McLd2G1-max4W1",[-17845375]);
AGR.TOC("maxes","McLd2G1-max5W1",[21634646]);
AGR.TOC("maxes","McLd2G1-max6W1",[-22213112]);
AGR.TOC("maxes","McLd2G1-max7W1",[73842512]);
AGR.TOC("maxes","McLd2G1-max7W2",[86102852]);
AGR.TOC("maxes","McLd2G1-max8W1",[128685854]);
AGR.TOC("maxes","McLd2G1-max8W2",[-96338819]);
AGR.TOC("maxes","McLd2G1-max9W1",[110274093]);
AGR.TOC("maxes","McLd2G1-max10W1",[48370239]);
AGR.TOC("cyclic","McLd2G1-cycW1",[-91022863]);
AGR.TOC("find","McLd2G1-find1",[-49966785]);
AGR.TOC("check","McLd2G1-check1",[-134019723]);
AGR.TOC("pres","McLd2G1-P1",[99955646]);

# 3ON
AGR.GRP("spor","ON","3ON");
AGR.TOC("perm","3ONG1-p368280B0.m",[99436862,-91608028]);
AGR.TOC("matff","3ONG1-f4r153B0.m",[-16268827,-103124065]);
AGR.TOC("matff","3ONG1-f7r45aB0.m",[29014787,31368259]);
AGR.TOC("matff","3ONG1-f7r45bB0.m",[-42391612,78013723]);

# 3ONd2
AGR.GRP("spor","ON","3ONd2");
AGR.TOC("perm","3ONd2G1-p736560B0.m",[-68689630,47782023]);
AGR.TOC("matff","3ONd2G1-f2r306B0.m",[-113541223,-48646281]);
AGR.TOC("matff","3ONd2G1-f7r90B0.m",[-8350529,94350551]);

# ON
AGR.GRP("spor","ON","ON");
AGR.TOC("perm","ONG1-p122760aB0.m",[130879699,5548962]);
AGR.TOC("matff","ONG1-f3r154B0.m",[38543454,103909362]);
AGR.TOC("matff","ONG1-f3r495B0.m",[-109943698,72387173]);
AGR.TOC("matff","ONG1-f3r684B0.m",[33722778,-62341476]);
AGR.TOC("matff","ONG1-f7r406B0.m",[-21559565,-81416063]);
AGR.TOC("matff","ONG1-f7r1618B0.m",[21602186,-42693064]);
AGR.TOC("matff","ONG1-f9r342aB0.m",[98458763,64167879]);
AGR.TOC("matff","ONG1-f9r342bB0.m",[-68492253,-107208061]);
AGR.TOC("matff","ONG1-f31r1869B0.m",[-52500805,27983940]);
AGR.TOC("maxes","ONG1-max1W1",[62944102]);
AGR.TOC("maxes","ONG1-max2W1",[43828776]);
AGR.TOC("maxes","ONG1-max3W1",[13338363]);
AGR.TOC("maxes","ONG1-max4W1",[8525863]);
AGR.TOC("maxes","ONG1-max5W1",[90069876]);
AGR.TOC("maxes","ONG1-max6W1",[34462054]);
AGR.TOC("maxes","ONG1-max7W1",[-90805441]);
AGR.TOC("maxes","ONG1-max8W1",[12382008]);
AGR.TOC("maxes","ONG1-max9W1",[-45861662]);
AGR.TOC("maxes","ONG1-max10W1",[-6113101]);
AGR.TOC("maxes","ONG1-max11W1",[55632949]);
AGR.TOC("maxes","ONG1-max12W1",[114468286]);
AGR.TOC("maxes","ONG1-max13W1",[-19450717]);
AGR.TOC("cyclic","ONG1-cycW1",[126303448]);
AGR.TOC("find","ONG1-find1",[-88306264]);
AGR.TOC("check","ONG1-check1",[67315863]);

# ONd2
AGR.GRP("spor","ON","ONd2");
AGR.TOC("perm","ONd2G1-p245520B0.m",[-42709158,30093434]);
AGR.TOC("matff","ONd2G1-f3r684B0.m",[59153414,-77686939]);
AGR.TOC("matff","ONd2G1-f3r990B0.m",[20383107,-30244925]);
AGR.TOC("matff","ONd2G1-f7r406B0.m",[-104236411,79672753]);
AGR.TOC("matff","ONd2G1-f7r1618B0.m",[94353914,92795391]);
AGR.TOC("matff","ONd2G1-f9r154B0.m",[-52358288,-121686221]);
AGR.TOC("matff","ONd2G1-f31r1869B0.m",[-15179195,-20224881]);
AGR.TOC("maxes","ONd2G1-max1W1",[87423786]);
AGR.TOC("maxes","ONd2G1-max2W1",[-132443113]);
AGR.TOC("maxes","ONd2G1-max3W1",[-63240888]);
AGR.TOC("maxes","ONd2G1-max4W1",[-67521683]);
AGR.TOC("maxes","ONd2G1-max5W1",[-120270312]);
AGR.TOC("maxes","ONd2G1-max6W1",[-124644877]);
AGR.TOC("maxes","ONd2G1-max7W1",[-105999166]);
AGR.TOC("maxes","ONd2G1-max8W1",[73256546]);
AGR.TOC("maxes","ONd2G1-max9W1",[-109711177]);
AGR.TOC("maxes","ONd2G1-max10W1",[91475306]);
AGR.TOC("check","ONd2G1-check1",[101930093]);

# ONd4
AGR.GRP("spor","ON","ONd4");
AGR.TOC("matff","ONd4G1-f3r154B0.m",[6087572,-92368074]);

# 2Ru
AGR.GRP("spor","Ru","2Ru");
AGR.TOC("perm","2RuG1-p16240B0.m",[-41672100,8217618]);
AGR.TOC("matff","2RuG1-f3r56B0.m",[-10365513,-78441559]);
AGR.TOC("matff","2RuG1-f5r28B0.m",[-75745528,51862955]);
AGR.TOC("matff","2RuG1-f5r912B0.m",[113987106,92551439]);
AGR.TOC("matff","2RuG1-f7r56B0.m",[60360641,-75246280]);
AGR.TOC("matff","2RuG1-f9r28B0.m",[92102602,-26481667]);
AGR.TOC("matff","2RuG1-f13r28B0.m",[52986574,97176965]);
AGR.TOC("matff","2RuG1-f29r28B0.m",[-86811570,-19732864]);
AGR.TOC("matff","2RuG1-f49r28B0.m",[-64130671,74771777]);

# Ru
AGR.GRP("spor","Ru","Ru");
AGR.TOC("perm","RuG1-p4060B0.m",[-53954577,-28356413]);
AGR.TOC("matff","RuG1-f2r28B0.m",[8731502,77315986]);
AGR.TOC("matff","RuG1-f2r376B0.m",[98838040,-77528473]);
AGR.TOC("matff","RuG1-f2r1246B0.m",[-10088876,103662524]);
AGR.TOC("matff","RuG1-f3r406B0.m",[-121033876,100514665]);
AGR.TOC("matff","RuG1-f3r783B0.m",[96110003,111822503]);
AGR.TOC("matff","RuG1-f5r133B0.m",[89406776,-26001685]);
AGR.TOC("matff","RuG1-f5r273B0.m",[115408136,-86832564]);
AGR.TOC("matff","RuG1-f5r378B0.m",[-51204044,111676142]);
AGR.TOC("matff","RuG1-f5r783B0.m",[31677180,96341162]);
AGR.TOC("matff","RuG1-f7r406B0.m",[124785085,102458493]);
AGR.TOC("matff","RuG1-f7r782B0.m",[19079994,25060169]);
AGR.TOC("matff","RuG1-f9r378B0.m",[131439757,-82258119]);
AGR.TOC("matff","RuG1-f13r378B0.m",[93152021,121995687]);
AGR.TOC("matff","RuG1-f13r406B0.m",[-132506753,9597583]);
AGR.TOC("matff","RuG1-f13r783B0.m",[-7052092,127225028]);
AGR.TOC("matff","RuG1-f29r378B0.m",[44132576,74752841]);
AGR.TOC("matff","RuG1-f29r406B0.m",[-38870625,-18279730]);
AGR.TOC("matff","RuG1-f29r783B0.m",[25821631,-2668956]);
AGR.TOC("matff","RuG1-f49r378B0.m",[-32894027,-9333064]);
AGR.TOC("maxes","RuG1-max1W1",[-75578155]);
AGR.TOC("maxes","RuG1-max1W2",[-129092743]);
AGR.TOC("maxes","RuG1-max2W2",[108886564]);
AGR.TOC("maxes","RuG1-max2W1",[-52387943]);
AGR.TOC("maxes","RuG1-max3W1",[-70042632]);
AGR.TOC("maxes","RuG1-max3W2",[127581494]);
AGR.TOC("maxes","RuG1-max4W2",[7612106]);
AGR.TOC("maxes","RuG1-max4W1",[5060269]);
AGR.TOC("maxes","RuG1-max5W1",[50048439]);
AGR.TOC("maxes","RuG1-max5W2",[-43399221]);
AGR.TOC("maxes","RuG1-max6W2",[-123299778]);
AGR.TOC("maxes","RuG1-max6W1",[-59823619]);
AGR.TOC("maxes","RuG1-max7W1",[67169891]);
AGR.TOC("maxes","RuG1-max7W2",[43762211]);
AGR.TOC("maxes","RuG1-max8W2",[51544408]);
AGR.TOC("maxes","RuG1-max8W1",[118175684]);
AGR.TOC("maxes","RuG1-max9W1",[-77505058]);
AGR.TOC("maxes","RuG1-max9W2",[-95757028]);
AGR.TOC("maxes","RuG1-max9W3",[70927804]);
AGR.TOC("maxes","RuG1-max10W1",[-64639884]);
AGR.TOC("maxes","RuG1-max10W2",[26896137]);
AGR.TOC("maxes","RuG1-max11W1",[-75133302]);
AGR.TOC("maxes","RuG1-max11W2",[105886580]);
AGR.TOC("maxes","RuG1-max12W1",[-131392469]);
AGR.TOC("maxes","RuG1-max12W2",[-27483953]);
AGR.TOC("maxes","RuG1-max13W1",[127833708]);
AGR.TOC("maxes","RuG1-max13W2",[101693928]);
AGR.TOC("maxes","RuG1-max14W1",[53460971]);
AGR.TOC("maxes","RuG1-max14W2",[-112917650]);
AGR.TOC("maxes","RuG1-max15W3",[-68154847]);
AGR.TOC("maxes","RuG1-max15W1",[59301912]);
AGR.TOC("maxes","RuG1-max15W2",[-17090852]);
AGR.TOC("classes","RuG1-cclsW1",[127501587]);
AGR.TOC("cyclic","RuG1-cycW1",[-126643575]);
AGR.TOC("maxstd","RuG1max9W2-L229G1W1",[-43443220]);
AGR.TOC("find","RuG1-find1",[52057267]);
AGR.TOC("check","RuG1-check1",[-30550431]);

# 2Suz
AGR.GRP("spor","Suz","2Suz");
AGR.TOC("perm","2SuzG1-p65520B0.m",[100499361,-17563632]);
AGR.TOC("matff","2SuzG1-f3r12B0.m",[-27396965,-130567168]);
AGR.TOC("matff","2SuzG1-f3r208B0.m",[-10246112,71400972]);
AGR.TOC("matff","2SuzG1-f3r352B0.m",[-88992129,72842831]);

# 2Suzd2
AGR.GRP("spor","Suz","2Suzd2");
AGR.TOC("matff","2Suzd2G1-f3r12aB0.m",[-3895471,-130567168]);

# 3Suz
AGR.GRP("spor","Suz","3Suz");
AGR.TOC("perm","3SuzG1-p5346B0.m",[-76176506,86470514]);
AGR.TOC("perm","3SuzG1-p98280B0.m",[53377107,9551332]);
AGR.TOC("perm","3SuzG1-p405405B0.m",[45794222,-32826998]);
AGR.TOC("matff","3SuzG1-f4r12aB0.m",[104289404,-97338178]);
AGR.TOC("matff","3SuzG1-f4r66aB0.m",[82458020,39793555]);
AGR.TOC("matff","3SuzG1-f4r429aB0.m",[-61260387,-55759488]);
AGR.TOC("matff","3SuzG1-f4r825aB0.m",[67351605,15291413]);
AGR.TOC("matff","3SuzG1-f4r825bB0.m",[125193684,-42083462]);
AGR.TOC("matff","3SuzG1-f25r66aB0.m",[69419571,40407784]);

# 3Suzd2
AGR.GRP("spor","Suz","3Suzd2");
AGR.TOC("perm","3Suzd2G1-p5346B0.m",[-19010047,86470514]);
AGR.TOC("matff","3Suzd2G1-f2r24B0.m",[44158235,-91947292]);
AGR.TOC("matff","3Suzd2G1-f5r132B0.m",[24890922,74028927]);
AGR.TOC("matff","3Suzd2G1-f7r132B0.m",[117434516,-37228764]);
AGR.TOC("matff","3Suzd2G1-f11r132B0.m",[-58076262,-47418246]);

# 6Suz
AGR.GRP("spor","Suz","6Suz");
AGR.TOC("perm","6SuzG1-p196560B0.m",[-95904469,-67046241]);
AGR.TOC("matff","6SuzG1-f7r12aB0.m",[-82762128,-47015058]);
AGR.TOC("matff","6SuzG1-f13r12aB0.m",[12391134,-67351534]);
AGR.TOC("matff","6SuzG1-f25r12aB0.m",[-91997322,132100624]);

# 6Suzd2
AGR.GRP("spor","Suz","6Suzd2");
AGR.TOC("matff","6Suzd2G1-f3r24B0.m",[-67857734,-58600215]);
AGR.TOC("matff","6Suzd2G1-f5r24B0.m",[-112852769,-18855249]);
AGR.TOC("matff","6Suzd2G1-f11r24B0.m",[46107370,85173164]);

# Suz
AGR.GRP("spor","Suz","Suz");
AGR.TOC("perm","SuzG1-p1782B0.m",[82893022,51463088]);
AGR.TOC("perm","SuzG1-p22880B0.m",[-45414207,72022853]);
AGR.TOC("perm","SuzG1-p32760B0.m",[-36637758,68776003]);
AGR.TOC("perm","SuzG1-p135135B0.m",[-65616209,-86572635]);
AGR.TOC("perm","SuzG1-p232960B0.m",[11347220,105131424]);
AGR.TOC("perm","SuzG1-p370656B0.m",[2182352,-118767183]);
AGR.TOC("perm","SuzG1-p405405B0.m",[105067735,100713240]);
AGR.TOC("matff","SuzG1-f2r142B0.m",[8357366,6920144]);
AGR.TOC("matff","SuzG1-f2r638B0.m",[4074312,106364657]);
AGR.TOC("matff","SuzG1-f3r64B0.m",[50365357,-54063209]);
AGR.TOC("matff","SuzG1-f3r78B0.m",[-92014561,35230543]);
AGR.TOC("matff","SuzG1-f3r286B0.m",[60274666,-70924388]);
AGR.TOC("matff","SuzG1-f3r429B0.m",[-49101968,-91628171]);
AGR.TOC("matff","SuzG1-f3r649B0.m",[-19946195,30163779]);
AGR.TOC("matff","SuzG1-f4r110aB0.m",[-109919096,-62082606]);
AGR.TOC("matff","SuzG1-f4r572aB0.m",[-95643378,32758517]);
AGR.TOC("matff","SuzG1-f4r572bB0.m",[-104417257,-95066640]);
AGR.TOC("matff","SuzG1-f5r143B0.m",[74394469,-38271034]);
AGR.TOC("matff","SuzG1-f5r363B0.m",[89885945,39063479]);
AGR.TOC("matff","SuzG1-f5r780B0.m",[132266614,-19359649]);
AGR.TOC("matff","SuzG1-f7r143B0.m",[105634339,28653126]);
AGR.TOC("matff","SuzG1-f7r364B0.m",[-74055301,-21058343]);
AGR.TOC("matff","SuzG1-f7r780B0.m",[112681667,-113939536]);
AGR.TOC("matff","SuzG1-f11r143B0.m",[-18320833,-74534883]);
AGR.TOC("matff","SuzG1-f11r364B0.m",[53490611,108496215]);
AGR.TOC("matff","SuzG1-f11r779B0.m",[-65750084,-98455485]);
AGR.TOC("matff","SuzG1-f13r143B0.m",[66190938,96991043]);
AGR.TOC("matff","SuzG1-f13r364B0.m",[74414593,-31777157]);
AGR.TOC("matff","SuzG1-f13r780B0.m",[-81127443,54737132]);
AGR.TOC("matint","SuzG1-Zr143B0.g",[89311105]);
AGR.TOC("maxes","SuzG1-max1W1",[-68768193]);
AGR.TOC("maxes","SuzG1-max2W1",[-108601749]);
AGR.TOC("maxes","SuzG1-max3W1",[-77948579]);
AGR.TOC("maxes","SuzG1-max4W1",[-36690020]);
AGR.TOC("maxes","SuzG1-max5W1",[40680439]);
AGR.TOC("maxes","SuzG1-max6W1",[24938473]);
AGR.TOC("maxes","SuzG1-max7W1",[-4080847]);
AGR.TOC("maxes","SuzG1-max8W1",[-133098394]);
AGR.TOC("maxes","SuzG1-max9W1",[-28786936]);
AGR.TOC("maxes","SuzG1-max10W1",[76923768]);
AGR.TOC("maxes","SuzG1-max11W1",[-37002406]);
AGR.TOC("maxes","SuzG1-max12W1",[-5356944]);
AGR.TOC("maxes","SuzG1-max13W1",[111038819]);
AGR.TOC("maxes","SuzG1-max14W1",[129646128]);
AGR.TOC("maxes","SuzG1-max15W1",[-85715848]);
AGR.TOC("maxes","SuzG1-max16W1",[-51955785]);
AGR.TOC("maxes","SuzG1-max17W1",[40310031]);
AGR.TOC("cyclic","SuzG1-cycW1",[107929098]);
AGR.TOC("out","SuzG1-a2W1",[16469656]);
AGR.TOC("out","SuzG1-a2W2",[-107369804]);
AGR.TOC("find","SuzG1-find1",[14760334]);
AGR.TOC("check","SuzG1-check1",[81413483]);

# Suzd2
AGR.GRP("spor","Suz","Suzd2");
AGR.TOC("perm","Suzd2G1-p1782B0.m",[-71919329,51463088]);
AGR.TOC("matff","Suzd2G1-f3r64aB0.m",[-90913076,-54063209]);
AGR.TOC("matff","Suzd2G1-f5r143aB0.m",[11496573,83112486]);
AGR.TOC("matff","Suzd2G1-f7r143aB0.m",[-107656145,-91209592]);
AGR.TOC("matff","Suzd2G1-f11r143aB0.m",[62231233,-74534883]);
AGR.TOC("maxes","Suzd2G1-max1W1",[43070058]);
AGR.TOC("maxes","Suzd2G1-max2W2",[36172803]);
AGR.TOC("maxes","Suzd2G1-max2W1",[-95676410]);
AGR.TOC("maxes","Suzd2G1-max3W1",[94233840]);
AGR.TOC("maxes","Suzd2G1-max4W1",[2475767]);
AGR.TOC("maxes","Suzd2G1-max5W2",[-129129167]);
AGR.TOC("maxes","Suzd2G1-max5W1",[26815149]);
AGR.TOC("maxes","Suzd2G1-max6W1",[22464709]);
AGR.TOC("maxes","Suzd2G1-max7W1",[131499830]);
AGR.TOC("maxes","Suzd2G1-max7W2",[103360853]);
AGR.TOC("maxes","Suzd2G1-max8W1",[-92936899]);
AGR.TOC("maxes","Suzd2G1-max8W2",[-104913286]);
AGR.TOC("maxes","Suzd2G1-max9W1",[33878153]);
AGR.TOC("maxes","Suzd2G1-max10W1",[-22801521]);
AGR.TOC("maxes","Suzd2G1-max11W1",[-106160515]);
AGR.TOC("maxes","Suzd2G1-max11W2",[-26338511]);
AGR.TOC("maxes","Suzd2G1-max12W1",[123474922]);
AGR.TOC("maxes","Suzd2G1-max13W1",[-88908553]);
AGR.TOC("maxes","Suzd2G1-max13W2",[17072729]);
AGR.TOC("maxes","Suzd2G1-max14W1",[118227933]);
AGR.TOC("maxes","Suzd2G1-max15W1",[-82644616]);
AGR.TOC("maxes","Suzd2G1-max16W1",[-129217850]);
AGR.TOC("maxes","Suzd2G1-max16W2",[62477926]);
AGR.TOC("find","Suzd2G1-find1",[-3302032]);
AGR.TOC("check","Suzd2G1-check1",[54766116]);

# Th
AGR.GRP("spor","Th","Th");
AGR.TOC("matff","ThG1-f2r248B0.m",[37434506,-68904843]);
AGR.TOC("matff","ThG1-f3r248B0.m",[-60944342,46058358]);
AGR.TOC("matff","ThG1-f3r3875B0.m",[13659990,-72730650]);
AGR.TOC("matff","ThG1-f5r248B0.m",[48991917,-128748049]);
AGR.TOC("matff","ThG1-f7r248B0.m",[123338324,34822469]);
AGR.TOC("matff","ThG1-f13r248B0.m",[-64490935,-8767165]);
AGR.TOC("matff","ThG1-f19r248B0.m",[12847805,-68708149]);
AGR.TOC("matff","ThG1-f31r248B0.m",[112307036,-111237321]);
AGR.TOC("maxes","ThG1-max1W1",[-15425179]);
AGR.TOC("maxes","ThG1-max2W1",[93806918]);
AGR.TOC("maxes","ThG1-max3W1",[-55978438]);
AGR.TOC("maxes","ThG1-max4W1",[110343436]);
AGR.TOC("maxes","ThG1-max4W2",[133062282]);
AGR.TOC("maxes","ThG1-max5W1",[2816244]);
AGR.TOC("maxes","ThG1-max6W1",[69845358]);
AGR.TOC("maxes","ThG1-max7W1",[73444571]);
AGR.TOC("maxes","ThG1-max8W1",[-104649732]);
AGR.TOC("maxes","ThG1-max9W1",[24676676]);
AGR.TOC("maxes","ThG1-max10W1",[3060244]);
AGR.TOC("maxes","ThG1-max11W1",[-58445008]);
AGR.TOC("maxes","ThG1-max12W1",[-92730481]);
AGR.TOC("maxes","ThG1-max13W1",[61196644]);
AGR.TOC("maxes","ThG1-max14W1",[11298405]);
AGR.TOC("maxes","ThG1-max14W2",[-74495271]);
AGR.TOC("maxes","ThG1-max15W2",[-97506952]);
AGR.TOC("maxes","ThG1-max15W1",[43001311]);
AGR.TOC("maxes","ThG1-max16W1",[7045374]);
AGR.TOC("cyclic","ThG1-cycW1",[-112362289]);
AGR.TOC("maxstd","ThG1max14W1-M10G1W1",[-67607570]);
AGR.TOC("find","ThG1-find1",[-54609116]);
AGR.TOC("check","ThG1-check1",[69410453]);


#############################################################################
##
##  What follows now are the representation dependent additional data.
##  They must be read after the notification of the representations,
##  in order to give us a chance to check the existence of the underlying
##  representation.
##


#############################################################################
##
##  Store info about compatibility of generators with those of factor groups.
##
AGR.STDCOMP("(2^2x3).U6(2)",[1,"U6(2)",1,true]);
AGR.STDCOMP("12.M22",[1,"M22",1,true]);
AGR.STDCOMP("12.M22.2",[1,"M22.2",1,true]);
AGR.STDCOMP("12_1.L3(4)",[1,"L3(4)",1,true]);
AGR.STDCOMP("12_2.L3(4)",[1,"L3(4)",1,true]);
AGR.STDCOMP("2.A11",[1,"A11",1,true]);
AGR.STDCOMP("2.A14.2",[1,"A14.2",1,true]);
AGR.STDCOMP("2.A5",[1,"A5",1,true]);
AGR.STDCOMP("2.A5.2",[1,"A5.2",1,true]);
AGR.STDCOMP("2.A6",[1,"A6",1,true]);
AGR.STDCOMP("2.A6.2_1",[1,"A6.2_1",1,true]);
AGR.STDCOMP("2.A7",[1,"A7",1,true]);
AGR.STDCOMP("2.A8",[1,"A8",1,true]);
AGR.STDCOMP("2.Fi22",[1,"Fi22",1,true]);
AGR.STDCOMP("2.Fi22.2",[1,"Fi22.2",1,true]);
AGR.STDCOMP("2.HS",[1,"HS",1,true]);
AGR.STDCOMP("2.HS.2",[1,"HS.2",1,true]);
AGR.STDCOMP("2.J2",[1,"J2",1,true]);
AGR.STDCOMP("2.L2(11)",[1,"L2(11)",1,true]);
AGR.STDCOMP("2.L3(2)",[1,"L3(2)",1,true]);
AGR.STDCOMP("2.L3(2).2",[1,"L3(2).2",1,true]);
AGR.STDCOMP("2.L3(4)",[1,"L3(4)",1,true]);
AGR.STDCOMP("2.M12",[1,"M12",1,true]);
AGR.STDCOMP("2.M12.2",[1,"M12.2",1,true]);
AGR.STDCOMP("2.M22",[1,"M22",1,true]);
AGR.STDCOMP("2.M22.2",[1,"M22.2",1,true]);
AGR.STDCOMP("2.S6(2)",[1,"S6(2)",1,true]);
AGR.STDCOMP("2.Sz(8)",[1,"Sz(8)",1,true]);
AGR.STDCOMP("2.U4(2)",[1,"U4(2)",1,true]);
AGR.STDCOMP("2^2.Sz(8).3",[1,"Sz(8).3",1,true]);
AGR.STDCOMP("3.A6",[1,"A6",1,true]);
AGR.STDCOMP("3.A6.2_1",[1,"A6.2_1",1,true]);
AGR.STDCOMP("3.Fi22",[1,"Fi22",1,true]);
AGR.STDCOMP("3.Fi22.2",[1,"Fi22.2",1,true]);
AGR.STDCOMP("3.G2(3)",[1,"G2(3)",1,true]);
AGR.STDCOMP("3.J3",[1,"J3",1,true]);
AGR.STDCOMP("3.J3.2",[1,"J3.2",1,true]);
AGR.STDCOMP("3.L3(4)",[1,"L3(4)",1,true]);
AGR.STDCOMP("3.M22",[1,"M22",1,true]);
AGR.STDCOMP("3.M22.2",[1,"M22.2",1,true]);
AGR.STDCOMP("3.McL",[1,"McL",1,true]);
AGR.STDCOMP("3.McL.2",[1,"McL.2",1,true]);
AGR.STDCOMP("3.U3(8)",[1,"U3(8)",1,true]);
AGR.STDCOMP("4.M22",[1,"M22",1,true]);
AGR.STDCOMP("4.M22.2",[1,"M22.2",1,true]);
AGR.STDCOMP("4_1.L3(4)",[1,"L3(4)",1,true]);
AGR.STDCOMP("4_2.L3(4)",[1,"L3(4)",1,true]);
AGR.STDCOMP("5^3.L3(5)",[2,"L3(5)",1,false]);
AGR.STDCOMP("6.A6",[1,"A6",1,true]);
AGR.STDCOMP("6.A6.2_1",[1,"A6.2_1",1,true]);
AGR.STDCOMP("6.Fi22",[1,"2.Fi22",1,true]);
AGR.STDCOMP("6.Fi22",[1,"Fi22",1,true]);
AGR.STDCOMP("6.Fi22.2",[1,"3.Fi22.2",1,true]);
AGR.STDCOMP("6.Fi22.2",[1,"Fi22.2",1,true]);
AGR.STDCOMP("6.L3(4)",[1,"L3(4)",1,true]);
AGR.STDCOMP("6.M22",[1,"M22",1,true]);
AGR.STDCOMP("6.M22.2",[1,"M22.2",1,true]);
AGR.STDCOMP("Isoclinic(2.A14.2)",[1,"A14.2",1,true]);
AGR.STDCOMP("Isoclinic(2.A5.2)",[1,"A5.2",1,true]);
AGR.STDCOMP("Isoclinic(2.L3(2).2)",[1,"L3(2).2",1,true]);
AGR.STDCOMP("Isoclinic(2.M12.2)",[1,"M12.2",1,true]);


#############################################################################
##
##  Store information about the rings over which characteristic zero
##  representations are written if known.
##  Note that the filenames do not contain this information,
##  so it has to be stored explicitly.
##
AGR.RNG("2A5G1-Ar2aB0","Field([E(5)])");
AGR.RNG("2A5G1-Ar4aB0","Field([Sqrt(-1)])");
AGR.RNG("2A5G1-Ar4aB2","Field([Sqrt(-6)])");
AGR.RNG("2A5G1-Ar6B0","Field([Sqrt(-1)])");
AGR.RNG("2A5G1-Ar6B1","Field([Sqrt(-3)])");
AGR.RNG("2A5G1-Hr1aB0","QuaternionAlgebra([Sqrt(5)])");
AGR.RNG("2A6G1-Ar4B0","Field([Sqrt(-3)])");
AGR.RNG("2A6G1-Ar4aB0","Field([Sqrt(-3)])");
AGR.RNG("2A6G1-Hr2aB0","QuaternionAlgebra([Sqrt(3)])");
AGR.RNG("2A7G1-Ar20aB0","Field([Sqrt(-7)])");
AGR.RNG("2A7G1-Ar4aB0","Field([Sqrt(-7)])");
AGR.RNG("2A7G1-Ar4bB0","Field([Sqrt(-7)])");
AGR.RNG("2A9G1-Ar8aB0","Field([E(7)])");
AGR.RNG("2G24G1-Ar12B0","Field([Sqrt(-1)])");
AGR.RNG("2L2101G1-Ar102aB0","Field([E(100)])");
AGR.RNG("2L2103G1-Ar104aB0","Field([E(51)])");
AGR.RNG("2L2107G1-Ar108aB0","Field([E(53)])");
AGR.RNG("2L2109G1-Ar110aB0","Field([E(108)])");
AGR.RNG("2L2113G1-Ar114aB0","Field([E(112)])");
AGR.RNG("2L2127G1-Ar128aB0","Field([E(63)])");
AGR.RNG("2L2131G1-Ar132aB0","Field([E(65)])");
AGR.RNG("2L2137G1-Ar138aB0","Field([E(136)])");
AGR.RNG("2L2139G1-Ar140aB0","Field([E(69)])");
AGR.RNG("2L2149G1-Ar150aB0","Field([E(148)])");
AGR.RNG("2L2151G1-Ar152aB0","Field([E(75)])");
AGR.RNG("2L2157G1-Ar158aB0","Field([E(156)])");
AGR.RNG("2L2163G1-Ar164aB0","Field([E(81)])");
AGR.RNG("2L2167G1-Ar168aB0","Field([E(83)])");
AGR.RNG("2L2173G1-Ar174aB0","Field([E(172)])");
AGR.RNG("2L2179G1-Ar180aB0","Field([E(89)])");
AGR.RNG("2L2181G1-Ar182aB0","Field([E(180)])");
AGR.RNG("2L2191G1-Ar192aB0","Field([E(95)])");
AGR.RNG("2L2193G1-Ar194aB0","Field([E(192)])");
AGR.RNG("2L2197G1-Ar198aB0","Field([E(196)])");
AGR.RNG("2L2199G1-Ar200aB0","Field([E(99)])");
AGR.RNG("2L2211G1-Ar212aB0","Field([E(105)])");
AGR.RNG("2L2223G1-Ar224aB0","Field([E(111)])");
AGR.RNG("2L2227G1-Ar228aB0","Field([E(113)])");
AGR.RNG("2L2229G1-Ar230aB0","Field([E(228)])");
AGR.RNG("2L2233G1-Ar234aB0","Field([E(232)])");
AGR.RNG("2L2239G1-Ar240aB0","Field([E(119)])");
AGR.RNG("2L2241G1-Ar242aB0","Field([E(240)])");
AGR.RNG("2L231G1-Ar32aB0","Field([E(15)])");
AGR.RNG("2L237G1-Ar38aB0","Field([E(36)])");
AGR.RNG("2L241G1-Ar42aB0","Field([E(40)])");
AGR.RNG("2L243G1-Ar44aB0","Field([E(21)])");
AGR.RNG("2L247G1-Ar48aB0","Field([E(23)])");
AGR.RNG("2L253G1-Ar54aB0","Field([E(52)])");
AGR.RNG("2L259G1-Ar60aB0","Field([E(29)])");
AGR.RNG("2L261G1-Ar62aB0","Field([E(60)])");
AGR.RNG("2L267G1-Ar68aB0","Field([E(33)])");
AGR.RNG("2L271G1-Ar72aB0","Field([E(35)])");
AGR.RNG("2L273G1-Ar74aB0","Field([E(72)])");
AGR.RNG("2L279G1-Ar80aB0","Field([E(39)])");
AGR.RNG("2L283G1-Ar84aB0","Field([E(41)])");
AGR.RNG("2L289G1-Ar90aB0","Field([E(88)])");
AGR.RNG("2L297G1-Ar98aB0","Field([E(96)])");
AGR.RNG("2S5G1-Ar4bB0","Field([Sqrt(-3)])");
AGR.RNG("2S5iG1-Ar4aB1","Field([Sqrt(-2)])");
AGR.RNG("2S5iG1-Ar4aB2","Field([Sqrt(-5)])");
AGR.RNG("2U42G1-Ar20aB0","Field([Sqrt(-3)])");
AGR.RNG("2U42G1-Ar20bB0","Field([Sqrt(-3)])");
AGR.RNG("2U42G1-Ar20cB0","Field([Sqrt(-3)])");
AGR.RNG("2U42G1-Ar36aB0","Field([Sqrt(-3)])");
AGR.RNG("2U42G1-Ar36bB0","Field([Sqrt(-3)])");
AGR.RNG("2U42G1-Ar4aB0","Field([Sqrt(-3)])");
AGR.RNG("2U42G1-Ar4bB0","Field([Sqrt(-3)])");
AGR.RNG("2U42G1-Ar60bB0","Field([Sqrt(-3)])");
AGR.RNG("2aM20G1-Ar12aB0","Field([Sqrt(5)])");
AGR.RNG("2aM20G1-Ar12bB0","Field([Sqrt(5)])");
AGR.RNG("2aM20G1-Ar12bB1","Field([Sqrt(5)])");
AGR.RNG("3A6G1-Ar15B0","Field([EY(15,1)])");
AGR.RNG("3A6G1-Ar3aB0","Field([EY(15,1)])");
AGR.RNG("3A6G1-Ar6B0","Field([Sqrt(-3)])");
AGR.RNG("3A6G1-Ar9B0","Field([Sqrt(-3)])");
AGR.RNG("3A7G1-Ar15aB0","Field([Sqrt(-3)])");
AGR.RNG("3A7G1-Ar15bB0","Field([Sqrt(-3)])");
AGR.RNG("3A7G1-Ar21aB0","Field([Sqrt(-3)])");
AGR.RNG("3A7G1-Ar21bB0","Field([Sqrt(-3)])");
AGR.RNG("3A7G1-Ar6B0","Field([Sqrt(-3)])");
AGR.RNG("4bM20G1-Ar20aB0","Field([Sqrt(-1)])");
AGR.RNG("4bM20G1-Ar4aB0","Field([Sqrt(-1)])");
AGR.RNG("4bM20G1-Ar4aB1","Field([Sqrt(-1)])");
AGR.RNG("6A6G1-Ar12B0","Field([EY(15,1)])");
AGR.RNG("6L34G1-Ar6aB0","Field([Sqrt(-3)])");
AGR.RNG("A5G1-Ar3aB0","Field([Sqrt(5)])");
AGR.RNG("A5G1-Ar3bB0","Field([Sqrt(5)])");
AGR.RNG("A6G1-Ar8aB0","Field([Sqrt(5)])");
AGR.RNG("A6G1-Ar8bB0","Field([Sqrt(5)])");
AGR.RNG("G23d2G1-Ar14B0","Field([Sqrt(-3)])");
AGR.RNG("J2G1-Ar14aB0","Field([Sqrt(5)])");
AGR.RNG("J2G1-Ar14bB0","Field([Sqrt(5)])");
AGR.RNG("J2G1-Ar21aB0","Field([Sqrt(5)])");
AGR.RNG("J2G1-Ar21bB0","Field([Sqrt(5)])");
AGR.RNG("L2101G1-Ar102aB0","Field([E(25)])");
AGR.RNG("L2103G1-Ar104aB0","Field([E(51)])");
AGR.RNG("L2107G1-Ar108aB0","Field([E(53)])");
AGR.RNG("L2109G1-Ar110aB0","Field([E(27)])");
AGR.RNG("L2113G1-Ar114aB0","Field([E(56)])");
AGR.RNG("L211G1-Ar12aB0","Field([E(5)])");
AGR.RNG("L211G1-Ar12bB0","Field([E(5)])");
AGR.RNG("L211G1-Ar5aB0","Field([Sqrt(-11)])");
AGR.RNG("L211G1-Ar5bB0","Field([Sqrt(-11)])");
AGR.RNG("L2127G1-Ar128aB0","Field([E(63)])");
AGR.RNG("L2128G1-Ar129aB0","Field([E(127)])");
AGR.RNG("L2131G1-Ar132aB0","Field([E(65)])");
AGR.RNG("L2137G1-Ar138aB0","Field([E(68)])");
AGR.RNG("L2139G1-Ar140aB0","Field([E(69)])");
AGR.RNG("L213G1-Ar12aB0","Field([EY(7)])");
AGR.RNG("L213G1-Ar12bB0","Field([EY(7)])");
AGR.RNG("L213G1-Ar12cB0","Field([EY(7)])");
AGR.RNG("L2149G1-Ar150aB0","Field([E(37)])");
AGR.RNG("L2151G1-Ar152aB0","Field([E(75)])");
AGR.RNG("L2157G1-Ar158aB0","Field([E(39)])");
AGR.RNG("L2163G1-Ar164aB0","Field([E(81)])");
AGR.RNG("L2167G1-Ar168aB0","Field([E(83)])");
AGR.RNG("L2173G1-Ar174aB0","Field([E(43)])");
AGR.RNG("L2179G1-Ar180aB0","Field([E(89)])");
AGR.RNG("L217G1-Ar9aB0","Field([Sqrt(17)])");
AGR.RNG("L217G1-Ar9bB0","Field([Sqrt(17)])");
AGR.RNG("L2181G1-Ar182aB0","Field([E(45)])");
AGR.RNG("L2191G1-Ar192aB0","Field([E(95)])");
AGR.RNG("L2193G1-Ar194aB0","Field([E(96)])");
AGR.RNG("L2197G1-Ar198aB0","Field([E(49)])");
AGR.RNG("L2199G1-Ar200aB0","Field([E(99)])");
AGR.RNG("L2211G1-Ar212aB0","Field([E(105)])");
AGR.RNG("L2223G1-Ar224aB0","Field([E(111)])");
AGR.RNG("L2227G1-Ar228aB0","Field([E(113)])");
AGR.RNG("L2229G1-Ar230aB0","Field([E(57)])");
AGR.RNG("L2233G1-Ar234aB0","Field([E(116)])");
AGR.RNG("L2239G1-Ar240aB0","Field([E(119)])");
AGR.RNG("L223G1-Ar24aB0","Field([E(11)])");
AGR.RNG("L223G1-Ar24bB0","Field([E(11)])");
AGR.RNG("L223G1-Ar24cB0","Field([E(11)])");
AGR.RNG("L223G1-Ar24dB0","Field([E(11)])");
AGR.RNG("L223G1-Ar24eB0","Field([E(11)])");
AGR.RNG("L2241G1-Ar242aB0","Field([E(120)])");
AGR.RNG("L227G1-Ar13aB0","Field([Sqrt(-3)])");
AGR.RNG("L227G1-Ar13bB0","Field([Sqrt(-3)])");
AGR.RNG("L227G1-Ar28aB0","Field([E(13)])");
AGR.RNG("L227G1-Ar28bB0","Field([E(13)])");
AGR.RNG("L227G1-Ar28cB0","Field([E(13)])");
AGR.RNG("L227G1-Ar28dB0","Field([E(13)])");
AGR.RNG("L227G1-Ar28eB0","Field([E(13)])");
AGR.RNG("L227G1-Ar28fB0","Field([E(13)])");
AGR.RNG("L229G1-Ar30aB0","Field([E(7)])");
AGR.RNG("L229G1-Ar30bB0","Field([E(7)])");
AGR.RNG("L229G1-Ar30cB0","Field([E(7)])");
AGR.RNG("L229G1-Ar30dB0","Field([E(7)])");
AGR.RNG("L229G1-Ar30eB0","Field([E(7)])");
AGR.RNG("L229G1-Ar30fB0","Field([E(7)])");
AGR.RNG("L231G1-Ar32aB0","Field([E(15)])");
AGR.RNG("L231G1-Ar32bB0","Field([E(5)])");
AGR.RNG("L231G1-Ar32cB0","Field([E(5)])");
AGR.RNG("L231G1-Ar32dB0","Field([E(15)])");
AGR.RNG("L231G1-Ar32eB0","Field([E(15)])");
AGR.RNG("L231G1-Ar32fB0","Field([E(15)])");
AGR.RNG("L231G1-Ar32gB0","Field([E(15)])");
AGR.RNG("L232G1-Ar33aB0","Field([E(31)])");
AGR.RNG("L232G1-Ar33bB0","Field([E(31)])");
AGR.RNG("L232G1-Ar33cB0","Field([E(31)])");
AGR.RNG("L232G1-Ar33dB0","Field([E(31)])");
AGR.RNG("L232G1-Ar33eB0","Field([E(31)])");
AGR.RNG("L232G1-Ar33fB0","Field([E(31)])");
AGR.RNG("L232G1-Ar33gB0","Field([E(31)])");
AGR.RNG("L232G1-Ar33hB0","Field([E(31)])");
AGR.RNG("L232G1-Ar33iB0","Field([E(31)])");
AGR.RNG("L232G1-Ar33jB0","Field([E(31)])");
AGR.RNG("L232G1-Ar33kB0","Field([E(31)])");
AGR.RNG("L232G1-Ar33lB0","Field([E(31)])");
AGR.RNG("L232G1-Ar33mB0","Field([E(31)])");
AGR.RNG("L232G1-Ar33nB0","Field([E(31)])");
AGR.RNG("L232G1-Ar33oB0","Field([E(31)])");
AGR.RNG("L237G1-Ar38aB0","Field([E(9)])");
AGR.RNG("L241G1-Ar42aB0","Field([E(20)])");
AGR.RNG("L243G1-Ar44aB0","Field([E(21)])");
AGR.RNG("L247G1-Ar48aB0","Field([E(23)])");
AGR.RNG("L253G1-Ar54aB0","Field([E(13)])");
AGR.RNG("L259G1-Ar60aB0","Field([E(29)])");
AGR.RNG("L261G1-Ar62aB0","Field([E(15)])");
AGR.RNG("L264G1-Ar65aB0","Field([E(63)])");
AGR.RNG("L267G1-Ar68aB0","Field([E(33)])");
AGR.RNG("L271G1-Ar72aB0","Field([E(35)])");
AGR.RNG("L273G1-Ar74aB0","Field([E(36)])");
AGR.RNG("L279G1-Ar80aB0","Field([E(39)])");
AGR.RNG("L27G1-Ar3aB0","Field([Sqrt(-7)])");
AGR.RNG("L27G1-Ar3bB0","Field([Sqrt(-7)])");
AGR.RNG("L283G1-Ar84aB0","Field([E(41)])");
AGR.RNG("L289G1-Ar90aB0","Field([E(44)])");
AGR.RNG("L28G1-Ar7bB0","Field([EY(9)])");
AGR.RNG("L28G1-Ar7cB0","Field([EY(9)])");
AGR.RNG("L28G1-Ar7dB0","Field([EY(9)])");
AGR.RNG("L28G1-Ar9aB0","Field([EY(7)])");
AGR.RNG("L28G1-Ar9bB0","Field([EY(7)])");
AGR.RNG("L28G1-Ar9cB0","Field([EY(7)])");
AGR.RNG("L297G1-Ar98aB0","Field([E(48)])");
AGR.RNG("L311G1-Ar133bB0","Field([E(5)])");
AGR.RNG("L311G1-Ar133cB0","Field([E(5)])");
AGR.RNG("L311G1-Ar133dB0","Field([E(5)])");
AGR.RNG("L311G1-Ar133eB0","Field([E(5)])");
AGR.RNG("L311G1-Ar133fB0","Field([E(5)])");
AGR.RNG("L311G1-Ar133gB0","Field([E(5)])");
AGR.RNG("L311G1-Ar133hB0","Field([E(5)])");
AGR.RNG("L311G1-Ar133iB0","Field([E(5)])");
AGR.RNG("L313G1-Ar183bB0","Field([Sqrt(-1)])");
AGR.RNG("L313G1-Ar183cB0","Field([Sqrt(-1)])");
AGR.RNG("L33G1-Ar26bB0","Field([Sqrt(-2)])");
AGR.RNG("L33G1-Ar26cB0","Field([Sqrt(-2)])");
AGR.RNG("L34G1-Ar63aB0","Field([Sqrt(5)])");
AGR.RNG("L34G1-Ar63bB0","Field([Sqrt(5)])");
AGR.RNG("L35G1-Ar124cB0","Field([Sqrt(-1)])");
AGR.RNG("L35G1-Ar124dB0","Field([Sqrt(-1)])");
AGR.RNG("L35G1-Ar124eB0","Field([Sqrt(-1)])");
AGR.RNG("L35G1-Ar124fB0","Field([Sqrt(-1)])");
AGR.RNG("L35G1-Ar124gB0","Field([E(24)])");
AGR.RNG("L35G1-Ar124hB0","Field([E(24)])");
AGR.RNG("L35G1-Ar124iB0","Field([E(24)])");
AGR.RNG("L35G1-Ar124jB0","Field([E(24)])");
AGR.RNG("L35G1-Ar155bB0","Field([Sqrt(-1)])");
AGR.RNG("L35G1-Ar155cB0","Field([Sqrt(-1)])");
AGR.RNG("L35G1-Ar31bB0","Field([Sqrt(-1)])");
AGR.RNG("L35G1-Ar31cB0","Field([Sqrt(-1)])");
AGR.RNG("L38G1-Ar73aB0","Field([E(7)])");
AGR.RNG("L38G1-Ar73bB0","Field([E(7)])");
AGR.RNG("L38G1-Ar73cB0","Field([E(7)])");
AGR.RNG("L38G1-Ar73dB0","Field([E(7)])");
AGR.RNG("L38G1-Ar73eB0","Field([E(7)])");
AGR.RNG("L38G1-Ar73fB0","Field([E(7)])");
AGR.RNG("L44G1-Ar85aB0","Field([Sqrt(-3)])");
AGR.RNG("L44G1-Ar85bB0","Field([Sqrt(-3)])");
AGR.RNG("L52d2G1-Ar30B0","Field([Sqrt(2)])");
AGR.RNG("M11G1-Ar10bB0","Field([Sqrt(-2)])");
AGR.RNG("M11G1-Ar10cB0","Field([Sqrt(-2)])");
AGR.RNG("S44G1-Ar204aB0","Field([Sqrt(5)])");
AGR.RNG("S44G1-Ar204bB0","Field([Sqrt(5)])");
AGR.RNG("S44G1-Ar51aB0","Field([Sqrt(5)])");
AGR.RNG("S44G1-Ar51bB0","Field([Sqrt(5)])");
AGR.RNG("S45G1-Ar13aB0","Field([Sqrt(5)])");
AGR.RNG("S45G1-Ar13bB0","Field([Sqrt(5)])");
AGR.RNG("S47G1-Ar25aB0","Field([Sqrt(-7)])");
AGR.RNG("S47G1-Ar25bB0","Field([Sqrt(-7)])");
AGR.RNG("S63G1-Ar13aB0","Field([Sqrt(-3)])");
AGR.RNG("S63G1-Ar13bB0","Field([Sqrt(-3)])");
AGR.RNG("S63G1-Ar78B0","Field([Sqrt(-3)])");
AGR.RNG("S63G1-Ar91aB0","Field([Sqrt(-3)])");
AGR.RNG("S63G1-Ar91bB0","Field([Sqrt(-3)])");
AGR.RNG("Sz8G1-Ar14aB0","Field([Sqrt(-1)])");
AGR.RNG("Sz8G1-Ar14bB0","Field([Sqrt(-1)])");
AGR.RNG("Sz8G1-Ar65aB0","Field([E(7)])");
AGR.RNG("Sz8G1-Ar65bB0","Field([E(7)])");
AGR.RNG("Sz8G1-Ar65cB0","Field([E(7)])");
AGR.RNG("U33G1-Ar21bB0","Field([Sqrt(-1)])");
AGR.RNG("U33G1-Ar21cB0","Field([Sqrt(-1)])");
AGR.RNG("U33G1-Ar28aB0","Field([Sqrt(-1)])");
AGR.RNG("U33G1-Ar28bB0","Field([Sqrt(-1)])");
AGR.RNG("U33G1-Ar6B0","Field([Sqrt(-1)])");
AGR.RNG("U33G1-Ar7bB0","Field([Sqrt(-1)])");
AGR.RNG("U33G1-Ar7cB0","Field([Sqrt(-1)])");
AGR.RNG("U34G1-Ar12B0","Field([E(13)])");
AGR.RNG("U34G1-Ar13aB0","Field([E(5)])");
AGR.RNG("U34G1-Ar13bB0","Field([E(5)])");
AGR.RNG("U34G1-Ar13cB0","Field([E(5)])");
AGR.RNG("U34G1-Ar13dB0","Field([E(5)])");
AGR.RNG("U34G1-Ar52aB0","Field([E(5)])");
AGR.RNG("U34G1-Ar52bB0","Field([E(5)])");
AGR.RNG("U34G1-Ar52cB0","Field([E(5)])");
AGR.RNG("U34G1-Ar52dB0","Field([E(5)])");
AGR.RNG("U42G1-Ar10B0","Field([Sqrt(-3)])");
AGR.RNG("U42G1-Ar10aB0","Field([Sqrt(-3)])");
AGR.RNG("U42G1-Ar10bB0","Field([Sqrt(-3)])");
AGR.RNG("U42G1-Ar30bB0","Field([Sqrt(-3)])");
AGR.RNG("U42G1-Ar30cB0","Field([Sqrt(-3)])");
AGR.RNG("U42G1-Ar40aB0","Field([Sqrt(-3)])");
AGR.RNG("U42G1-Ar40bB0","Field([Sqrt(-3)])");
AGR.RNG("U42G1-Ar45aB0","Field([Sqrt(-3)])");
AGR.RNG("U42G1-Ar45bB0","Field([Sqrt(-3)])");
AGR.RNG("U42G1-Ar5aB0","Field([Sqrt(-3)])");
AGR.RNG("U42G1-Ar5bB0","Field([Sqrt(-3)])");
AGR.RNG("U52G1-Ar66aB0","Field([Sqrt(-3)])");
AGR.RNG("U52G1-Ar66bB0","Field([Sqrt(-3)])");


#############################################################################
##
##  Store information which straight line programs for restricting to maximal
##  subgroups of a group can be used also for restricting to maximal
##  subgroups of downward extensions.
##
AGR.TOCEXT("12M22",1,1,["M22G1-max1W1"]);
AGR.TOCEXT("12M22",1,2,["M22G1-max2W1"]);
AGR.TOCEXT("12M22",1,3,["M22G1-max3W1"]);
AGR.TOCEXT("12M22",1,4,["M22G1-max4W1"]);
AGR.TOCEXT("12M22",1,5,["M22G1-max5W1","M22"]);
AGR.TOCEXT("12M22",1,6,["M22G1-max6W1","M22"]);
AGR.TOCEXT("12M22",1,7,["M22G1-max7W1"]);
AGR.TOCEXT("12M22",1,8,["M22G1-max8W1","M22"]);
AGR.TOCEXT("12aL34",1,1,["L34G1-max1W1"]);
AGR.TOCEXT("12aL34",1,2,["L34G1-max2W1"]);
AGR.TOCEXT("12aL34",1,3,["L34G1-max3W1","L3(4)"]);
AGR.TOCEXT("12aL34",1,6,["L34G1-max6W1","L3(4)"]);
AGR.TOCEXT("12aL34",1,7,["L34G1-max7W1","L3(4)"]);
AGR.TOCEXT("12aL34",1,8,["L34G1-max8W1","L3(4)"]);
AGR.TOCEXT("12aL34",1,9,["L34G1-max9W1"]);
AGR.TOCEXT("12bL34",1,1,["L34G1-max1W1"]);
AGR.TOCEXT("12bL34",1,2,["L34G1-max2W1"]);
AGR.TOCEXT("12bL34",1,3,["L34G1-max3W1","L3(4)"]);
AGR.TOCEXT("12bL34",1,6,["L34G1-max6W1","L3(4)"]);
AGR.TOCEXT("12bL34",1,7,["L34G1-max7W1","L3(4)"]);
AGR.TOCEXT("12bL34",1,8,["L34G1-max8W1","L3(4)"]);
AGR.TOCEXT("12bL34",1,9,["L34G1-max9W1"]);
AGR.TOCEXT("2A5",1,1,["A5G1-max1W1"]);
AGR.TOCEXT("2A5",1,2,["A5G1-max2W1"]);
AGR.TOCEXT("2A5",1,3,["A5G1-max3W1"]);
AGR.TOCEXT("2A6",1,1,["A6G1-max1W1"]);
AGR.TOCEXT("2A6",1,2,["A6G1-max2W1"]);
AGR.TOCEXT("2A6",1,3,["A6G1-max3W1"]);
AGR.TOCEXT("2A6",1,4,["A6G1-max4W1"]);
AGR.TOCEXT("2A6",1,5,["A6G1-max5W1"]);
AGR.TOCEXT("2F22",1,1,["F22G1-max1W1"]);
AGR.TOCEXT("2F22",1,10,["F22G1-max10W1"]);
AGR.TOCEXT("2F22",1,11,["F22G1-max11W1"]);
AGR.TOCEXT("2F22",1,12,["F22G1-max12W1","Fi22"]);
AGR.TOCEXT("2F22",1,13,["F22G1-max13W2","Fi22"]);
AGR.TOCEXT("2F22",1,14,["F22G1-max14W1","Fi22"]);
AGR.TOCEXT("2F22",1,2,["F22G1-max2W1"]);
AGR.TOCEXT("2F22",1,3,["F22G1-max3W1"]);
AGR.TOCEXT("2F22",1,4,["F22G1-max4W1","Fi22"]);
AGR.TOCEXT("2F22",1,5,["F22G1-max5W1"]);
AGR.TOCEXT("2F22",1,6,["F22G1-max6W1"]);
AGR.TOCEXT("2F22",1,7,["F22G1-max7W1"]);
AGR.TOCEXT("2F22",1,8,["F22G1-max8W1"]);
AGR.TOCEXT("2F22",1,9,["F22G1-max9W1","Fi22"]);
AGR.TOCEXT("2F22d2",1,1,["F22d2G1-max1W1"]);
AGR.TOCEXT("2F22d2",1,13,["F22d2G1-max13W1"]);
AGR.TOCEXT("2F22d2",1,2,["F22d2G1-max2W1"]);
AGR.TOCEXT("2HS",1,1,["HSG1-max1W1"]);
AGR.TOCEXT("2HS",1,10,["HSG1-max10W1"]);
AGR.TOCEXT("2HS",1,11,["HSG1-max11W1"]);
AGR.TOCEXT("2HS",1,12,["HSG1-max12W1"]);
AGR.TOCEXT("2HS",1,2,["HSG1-max2W1"]);
AGR.TOCEXT("2HS",1,3,["HSG1-max3W1"]);
AGR.TOCEXT("2HS",1,4,["HSG1-max4W1"]);
AGR.TOCEXT("2HS",1,5,["HSG1-max5W1"]);
AGR.TOCEXT("2HS",1,6,["HSG1-max6W1"]);
AGR.TOCEXT("2HS",1,7,["HSG1-max7W1"]);
AGR.TOCEXT("2HS",1,8,["HSG1-max8W1","HS"]);
AGR.TOCEXT("2HS",1,9,["HSG1-max9W1","HS"]);
AGR.TOCEXT("2HSd2",1,1,["HSd2G1-max1W1"]);
AGR.TOCEXT("2HSd2",1,10,["HSd2G1-max10W1"]);
AGR.TOCEXT("2HSd2",1,2,["HSd2G1-max2W1"]);
AGR.TOCEXT("2HSd2",1,3,["HSd2G1-max3W1"]);
AGR.TOCEXT("2HSd2",1,4,["HSd2G1-max4W1"]);
AGR.TOCEXT("2HSd2",1,5,["HSd2G1-max5W1"]);
AGR.TOCEXT("2HSd2",1,6,["HSd2G1-max6W1"]);
AGR.TOCEXT("2HSd2",1,7,["HSd2G1-max7W1"]);
AGR.TOCEXT("2HSd2",1,8,["HSd2G1-max8W1"]);
AGR.TOCEXT("2HSd2",1,9,["HSd2G1-max9W1"]);
AGR.TOCEXT("2J2",1,1,["J2G1-max1W1","J2"]);
AGR.TOCEXT("2J2",1,2,["J2G1-max2W1"]);
AGR.TOCEXT("2J2",1,3,["J2G1-max3W1"]);
AGR.TOCEXT("2J2",1,4,["J2G1-max4W1"]);
AGR.TOCEXT("2J2",1,5,["J2G1-max5W1"]);
AGR.TOCEXT("2J2",1,6,["J2G1-max6W1"]);
AGR.TOCEXT("2J2",1,7,["J2G1-max7W1"]);
AGR.TOCEXT("2J2",1,8,["J2G1-max8W1"]);
AGR.TOCEXT("2J2",1,9,["J2G1-max9W1"]);
AGR.TOCEXT("2L27",1,1,["L27G1-max1W1"]);
AGR.TOCEXT("2L27",1,2,["L27G1-max2W1"]);
AGR.TOCEXT("2L27",1,3,["L27G1-max3W1","L3(2)"]);
AGR.TOCEXT("2L27d2",1,1,["L27d2G1-max1W1"]);
AGR.TOCEXT("2L27d2",1,2,["L27d2G1-max2W1"]);
AGR.TOCEXT("2L27d2",1,3,["L27d2G1-max3W1"]);
AGR.TOCEXT("2L27d2",1,4,["L27d2G1-max4W1"]);
AGR.TOCEXT("2L27d2i",1,1,["L27d2G1-max1W1"]);
AGR.TOCEXT("2L27d2i",1,2,["L27d2G1-max2W1","L3(2).2"]);
AGR.TOCEXT("2L27d2i",1,3,["L27d2G1-max3W1"]);
AGR.TOCEXT("2L27d2i",1,4,["L27d2G1-max4W1"]);
AGR.TOCEXT("2L34",1,1,["L34G1-max1W1"]);
AGR.TOCEXT("2L34",1,2,["L34G1-max2W1"]);
AGR.TOCEXT("2L34",1,3,["L34G1-max3W1","L3(4)"]);
AGR.TOCEXT("2L34",1,6,["L34G1-max6W1","L3(4)"]);
AGR.TOCEXT("2L34",1,7,["L34G1-max7W1"]);
AGR.TOCEXT("2L34",1,8,["L34G1-max8W1"]);
AGR.TOCEXT("2L34",1,9,["L34G1-max9W1"]);
AGR.TOCEXT("2M12",1,1,["M12G1-max1W1","M12"]);
AGR.TOCEXT("2M12",1,10,["M12G1-max10W1"]);
AGR.TOCEXT("2M12",1,11,["M12G1-max11W1"]);
AGR.TOCEXT("2M12",1,2,["M12G1-max2W1","M12"]);
AGR.TOCEXT("2M12",1,3,["M12G1-max3W1"]);
AGR.TOCEXT("2M12",1,4,["M12G1-max4W1"]);
AGR.TOCEXT("2M12",1,5,["M12G1-max5W1"]);
AGR.TOCEXT("2M12",1,6,["M12G1-max6W1"]);
AGR.TOCEXT("2M12",1,7,["M12G1-max7W1"]);
AGR.TOCEXT("2M12",1,8,["M12G1-max8W1"]);
AGR.TOCEXT("2M12",1,9,["M12G1-max9W1"]);
AGR.TOCEXT("2M12d2",1,2,["M12d2G1-max2W1","M12.2"]);
AGR.TOCEXT("2M12d2",1,3,["M12d2G1-max3W1"]);
AGR.TOCEXT("2M12d2",1,4,["M12d2G1-max4W1"]);
AGR.TOCEXT("2M12d2",1,5,["M12d2G1-max5W1"]);
AGR.TOCEXT("2M12d2",1,6,["M12d2G1-max6W1"]);
AGR.TOCEXT("2M12d2",1,7,["M12d2G1-max7W1","M12.2"]);
AGR.TOCEXT("2M12d2",1,8,["M12d2G1-max8W1"]);
AGR.TOCEXT("2M12d2",1,9,["M12d2G1-max9W1"]);
AGR.TOCEXT("2M22",1,1,["M22G1-max1W1"]);
AGR.TOCEXT("2M22",1,2,["M22G1-max2W1"]);
AGR.TOCEXT("2M22",1,3,["M22G1-max3W1"]);
AGR.TOCEXT("2M22",1,4,["M22G1-max4W1"]);
AGR.TOCEXT("2M22",1,5,["M22G1-max5W1"]);
AGR.TOCEXT("2M22",1,6,["M22G1-max6W1"]);
AGR.TOCEXT("2M22",1,7,["M22G1-max7W1"]);
AGR.TOCEXT("2M22",1,8,["M22G1-max8W1"]);
AGR.TOCEXT("2M22d2",1,1,["M22d2G1-max1W1"]);
AGR.TOCEXT("2M22d2",1,2,["M22d2G1-max2W1"]);
AGR.TOCEXT("2M22d2",1,3,["M22d2G1-max3W1"]);
AGR.TOCEXT("2M22d2",1,4,["M22d2G1-max4W1"]);
AGR.TOCEXT("2M22d2",1,5,["M22d2G1-max5W1"]);
AGR.TOCEXT("2M22d2",1,6,["M22d2G1-max6W1"]);
AGR.TOCEXT("2M22d2",1,7,["M22d2G1-max7W1","M22.2"]);
AGR.TOCEXT("2S5",1,1,["S5G1-max1W1"]);
AGR.TOCEXT("2S5",1,2,["S5G1-max2W1"]);
AGR.TOCEXT("2S5",1,3,["S5G1-max3W1"]);
AGR.TOCEXT("2S5",1,4,["S5G1-max4W1"]);
AGR.TOCEXT("2S5i",1,1,["S5G1-max1W1"]);
AGR.TOCEXT("2S5i",1,2,["S5G1-max2W1"]);
AGR.TOCEXT("2S5i",1,3,["S5G1-max3W1"]);
AGR.TOCEXT("2S5i",1,4,["S5G1-max4W1"]);
AGR.TOCEXT("2S6",1,1,["S6G1-max1W1"]);
AGR.TOCEXT("2S6",1,2,["S6G1-max2W1"]);
AGR.TOCEXT("2S6",1,3,["S6G1-max3W1"]);
AGR.TOCEXT("2S6",1,4,["S6G1-max4W1"]);
AGR.TOCEXT("2S6",1,5,["S6G1-max5W1"]);
AGR.TOCEXT("2S6",1,6,["S6G1-max6W1"]);
AGR.TOCEXT("2S62",1,1,["S62G1-max1W1"]);
AGR.TOCEXT("2S62",1,2,["S62G1-max2W1"]);
AGR.TOCEXT("2S62",1,3,["S62G1-max3W1"]);
AGR.TOCEXT("2S62",1,4,["S62G1-max4W1","S6(2)"]);
AGR.TOCEXT("2S62",1,5,["S62G1-max5W1"]);
AGR.TOCEXT("2S62",1,6,["S62G1-max6W1"]);
AGR.TOCEXT("2S62",1,7,["S62G1-max7W1"]);
AGR.TOCEXT("2S62",1,8,["S62G1-max8W1","S6(2)"]);
AGR.TOCEXT("2Sz8",1,1,["Sz8G1-max1W1"]);
AGR.TOCEXT("2Sz8",1,2,["Sz8G1-max2W1"]);
AGR.TOCEXT("2Sz8",1,3,["Sz8G1-max3W1"]);
AGR.TOCEXT("2Sz8",1,4,["Sz8G1-max4W1","Sz(8)"]);
AGR.TOCEXT("3A6",1,1,["A6G1-max1W1"]);
AGR.TOCEXT("3A6",1,2,["A6G1-max2W1"]);
AGR.TOCEXT("3A6",1,3,["A6G1-max3W1"]);
AGR.TOCEXT("3A6",1,4,["A6G1-max4W1"]);
AGR.TOCEXT("3A6",1,5,["A6G1-max5W1"]);
AGR.TOCEXT("3G23",1,1,["G23G1-max1W1","G2(3)"]);
AGR.TOCEXT("3G23",1,10,["G23G1-max10W1"]);
AGR.TOCEXT("3G23",1,2,["G23G1-max2W1","G2(3)"]);
AGR.TOCEXT("3G23",1,3,["G23G1-max3W1"]);
AGR.TOCEXT("3G23",1,4,["G23G1-max4W1"]);
AGR.TOCEXT("3G23",1,5,["G23G1-max5W1"]);
AGR.TOCEXT("3G23",1,6,["G23G1-max6W1"]);
AGR.TOCEXT("3G23",1,7,["G23G1-max7W1","G2(3)"]);
AGR.TOCEXT("3G23",1,8,["G23G1-max8W1"]);
AGR.TOCEXT("3G23",1,9,["G23G1-max9W1"]);
AGR.TOCEXT("3L34",1,1,["L34G1-max1W1"]);
AGR.TOCEXT("3L34",1,2,["L34G1-max2W1"]);
AGR.TOCEXT("3L34",1,3,["L34G1-max3W1"]);
AGR.TOCEXT("3L34",1,6,["L34G1-max6W1","L3(4)"]);
AGR.TOCEXT("3L34",1,7,["L34G1-max7W1","L3(4)"]);
AGR.TOCEXT("3L34",1,8,["L34G1-max8W1","L3(4)"]);
AGR.TOCEXT("3L34",1,9,["L34G1-max9W1"]);
AGR.TOCEXT("3M22",1,1,["M22G1-max1W1"]);
AGR.TOCEXT("3M22",1,2,["M22G1-max2W1"]);
AGR.TOCEXT("3M22",1,3,["M22G1-max3W1"]);
AGR.TOCEXT("3M22",1,4,["M22G1-max4W1"]);
AGR.TOCEXT("3M22",1,5,["M22G1-max5W1","M22"]);
AGR.TOCEXT("3M22",1,6,["M22G1-max6W1","M22"]);
AGR.TOCEXT("3M22",1,7,["M22G1-max7W1"]);
AGR.TOCEXT("3M22",1,8,["M22G1-max8W1","M22"]);
AGR.TOCEXT("3M22d2",1,1,["M22d2G1-max1W1"]);
AGR.TOCEXT("3M22d2",1,2,["M22d2G1-max2W1"]);
AGR.TOCEXT("3M22d2",1,3,["M22d2G1-max3W1"]);
AGR.TOCEXT("3M22d2",1,4,["M22d2G1-max4W1"]);
AGR.TOCEXT("3M22d2",1,5,["M22d2G1-max5W1","M22.2"]);
AGR.TOCEXT("3M22d2",1,6,["M22d2G1-max6W1"]);
AGR.TOCEXT("3M22d2",1,7,["M22d2G1-max7W1","M22.2"]);
AGR.TOCEXT("3McL",1,1,["McLG1-max1W1"]);
AGR.TOCEXT("3McL",1,10,["McLG1-max10W1"]);
AGR.TOCEXT("3McL",1,11,["McLG1-max11W1","McL"]);
AGR.TOCEXT("3McL",1,12,["McLG1-max12W1"]);
AGR.TOCEXT("3McL",1,2,["McLG1-max2W1"]);
AGR.TOCEXT("3McL",1,3,["McLG1-max3W1"]);
AGR.TOCEXT("3McL",1,4,["McLG1-max4W1"]);
AGR.TOCEXT("3McL",1,5,["McLG1-max5W1"]);
AGR.TOCEXT("3McL",1,6,["McLG1-max6W1"]);
AGR.TOCEXT("3McL",1,7,["McLG1-max7W1"]);
AGR.TOCEXT("3McL",1,8,["McLG1-max8W1","McL"]);
AGR.TOCEXT("3McL",1,9,["McLG1-max9W1"]);
AGR.TOCEXT("3McLd2",1,1,["McLd2G1-max1W1"]);
AGR.TOCEXT("3McLd2",1,10,["McLd2G1-max10W1"]);
AGR.TOCEXT("3McLd2",1,2,["McLd2G1-max2W1"]);
AGR.TOCEXT("3McLd2",1,3,["McLd2G1-max3W1"]);
AGR.TOCEXT("3McLd2",1,4,["McLd2G1-max4W1"]);
AGR.TOCEXT("3McLd2",1,5,["McLd2G1-max5W1"]);
AGR.TOCEXT("3McLd2",1,6,["McLd2G1-max6W1"]);
AGR.TOCEXT("3McLd2",1,7,["McLd2G1-max7W1"]);
AGR.TOCEXT("3McLd2",1,8,["McLd2G1-max8W1"]);
AGR.TOCEXT("3McLd2",1,9,["McLd2G1-max9W1"]);
AGR.TOCEXT("3S6",1,1,["S6G1-max1W1"]);
AGR.TOCEXT("3S6",1,2,["S6G1-max2W1","A6.2_1"]);
AGR.TOCEXT("3S6",1,3,["S6G1-max3W1","A6.2_1"]);
AGR.TOCEXT("3S6",1,4,["S6G1-max4W1"]);
AGR.TOCEXT("3S6",1,5,["S6G1-max5W1","A6.2_1"]);
AGR.TOCEXT("3S6",1,6,["S6G1-max6W1","A6.2_1"]);
AGR.TOCEXT("4M22",1,1,["M22G1-max1W1"]);
AGR.TOCEXT("4M22",1,2,["M22G1-max2W1"]);
AGR.TOCEXT("4M22",1,3,["M22G1-max3W1"]);
AGR.TOCEXT("4M22",1,4,["M22G1-max4W1"]);
AGR.TOCEXT("4M22",1,5,["M22G1-max5W1"]);
AGR.TOCEXT("4M22",1,6,["M22G1-max6W1"]);
AGR.TOCEXT("4M22",1,7,["M22G1-max7W1"]);
AGR.TOCEXT("4M22",1,8,["M22G1-max8W1"]);
AGR.TOCEXT("4Sz8d3",1,1,["Sz8d3G1-max1W1"]);
AGR.TOCEXT("4Sz8d3",1,2,["Sz8d3G1-max2W1"]);
AGR.TOCEXT("4Sz8d3",1,3,["Sz8d3G1-max3W1"]);
AGR.TOCEXT("4Sz8d3",1,4,["Sz8d3G1-max4W1","Sz(8).3"]);
AGR.TOCEXT("4Sz8d3",1,5,["Sz8d3G1-max5W1"]);
AGR.TOCEXT("4aL34",1,1,["L34G1-max1W1"]);
AGR.TOCEXT("4aL34",1,2,["L34G1-max2W1"]);
AGR.TOCEXT("4aL34",1,3,["L34G1-max3W1","L3(4)"]);
AGR.TOCEXT("4aL34",1,6,["L34G1-max6W1","L3(4)"]);
AGR.TOCEXT("4aL34",1,7,["L34G1-max7W1"]);
AGR.TOCEXT("4aL34",1,8,["L34G1-max8W1"]);
AGR.TOCEXT("4aL34",1,9,["L34G1-max9W1"]);
AGR.TOCEXT("4bL34",1,1,["L34G1-max1W1"]);
AGR.TOCEXT("4bL34",1,2,["L34G1-max2W1"]);
AGR.TOCEXT("4bL34",1,3,["L34G1-max3W1","L3(4)"]);
AGR.TOCEXT("4bL34",1,6,["L34G1-max6W1","L3(4)"]);
AGR.TOCEXT("4bL34",1,7,["L34G1-max7W1"]);
AGR.TOCEXT("4bL34",1,8,["L34G1-max8W1"]);
AGR.TOCEXT("4bL34",1,9,["L34G1-max9W1"]);
AGR.TOCEXT("6A6",1,1,["A6G1-max1W1"]);
AGR.TOCEXT("6A6",1,2,["A6G1-max2W1"]);
AGR.TOCEXT("6A6",1,3,["A6G1-max3W1"]);
AGR.TOCEXT("6A6",1,4,["A6G1-max4W1"]);
AGR.TOCEXT("6A6",1,5,["A6G1-max5W1"]);
AGR.TOCEXT("6L34",1,1,["L34G1-max1W1"]);
AGR.TOCEXT("6L34",1,2,["L34G1-max2W1"]);
AGR.TOCEXT("6L34",1,3,["L34G1-max3W1","L3(4)"]);
AGR.TOCEXT("6L34",1,6,["L34G1-max6W1","L3(4)"]);
AGR.TOCEXT("6L34",1,7,["L34G1-max7W1","L3(4)"]);
AGR.TOCEXT("6L34",1,8,["L34G1-max8W1","L3(4)"]);
AGR.TOCEXT("6L34",1,9,["L34G1-max9W1"]);
AGR.TOCEXT("6M22",1,1,["M22G1-max1W1"]);
AGR.TOCEXT("6M22",1,2,["M22G1-max2W1"]);
AGR.TOCEXT("6M22",1,3,["M22G1-max3W1"]);
AGR.TOCEXT("6M22",1,4,["M22G1-max4W1"]);
AGR.TOCEXT("6M22",1,5,["M22G1-max5W1","M22"]);
AGR.TOCEXT("6M22",1,6,["M22G1-max6W1","M22"]);
AGR.TOCEXT("6M22",1,7,["M22G1-max7W1"]);
AGR.TOCEXT("6M22",1,8,["M22G1-max8W1","M22"]);
AGR.TOCEXT("6M22d2",1,1,["M22d2G1-max1W1"]);
AGR.TOCEXT("6M22d2",1,2,["M22d2G1-max2W1"]);
AGR.TOCEXT("6M22d2",1,3,["M22d2G1-max3W1"]);
AGR.TOCEXT("6M22d2",1,4,["M22d2G1-max4W1"]);
AGR.TOCEXT("6M22d2",1,5,["M22d2G1-max5W1","M22.2"]);
AGR.TOCEXT("6M22d2",1,6,["M22d2G1-max6W1"]);
AGR.TOCEXT("6M22d2",1,7,["M22d2G1-max7W1","M22.2"]);
AGR.TOCEXT("6S6",1,1,["S6G1-max1W1"]);
AGR.TOCEXT("6S6",1,2,["S6G1-max2W1","A6.2_1"]);
AGR.TOCEXT("6S6",1,3,["S6G1-max3W1","A6.2_1"]);
AGR.TOCEXT("6S6",1,4,["S6G1-max4W1"]);
AGR.TOCEXT("6S6",1,5,["S6G1-max5W1","A6.2_1"]);
AGR.TOCEXT("6S6",1,6,["S6G1-max6W1","A6.2_1"]);


#############################################################################
##
##  Store information about the point stabilizers of permutation
##  representations if known.
##  Note that the filenames do not contain this information,
##  so it has to be stored explicitly.
##
AGR.API("12M22G1-p31680aB0",[1,256,"imprim","L3(2) < 3x2.(2^3:L3(2)x2)"]);
AGR.API("12U62G1-p4704B0",[0,[2016,2688]]);
AGR.API("12U62G1-p8064B0",[1,19,"imprim","U5(2) < 2^2x3xU5(2)"]);
AGR.API("12aL34G1-p1440B0",[1,28,"imprim","L2(7) < 12xL2(7)"]);
AGR.API("12bL34G1-p1440B0",[1,34,"imprim","L2(7) < 12xL2(7)"]);
AGR.API("24A8G1-p128B0",[1,4,"imprim","A7 < 2^4:A7"]);
AGR.API("24A8G1-p30B0",[1,3,"imprim","4^3:L3(2) < 2^4.2^3.L3(2)"]);
AGR.API("2A11G1-p5040B0",[1,8,"imprim","M11 < 2xM11"]);
AGR.API("2A5G1-p24B0",[1,8,"imprim","5 < 2.D10"]);
AGR.API("2A5G1-p40B0",[1,16,"imprim","3 < 2.S3"]);
AGR.API("2A6G1-p144B0",[1,32,"imprim","5 < 2.A5"]);
AGR.API("2A6G1-p240aB0",[1,88,"imprim","3 < 3^2:8"]);
AGR.API("2A6G1-p240bB0",[1,88,"imprim","3 < 3^2:8"]);
AGR.API("2A6G1-p80B0",[1,16,"imprim","3^2 < 3^2:8"]);
AGR.API("2A7G1-p240B0",[1,20,"imprim","7:3 < 2.L3(2)"]);
AGR.API("2A8G1-p240aB0",[1,10,"imprim","L3(2) < 2^(1+3):L3(2)"]);
AGR.API("2A8G1-p240bB0",[1,7,"imprim","2^3:7:3 < 2^(1+3):L3(2)"]);
AGR.API("2A8G1-p240cB0",[1,7,"imprim","2^3:7:3 < 2^(1+3):L3(2)"]);
AGR.API("2Co1G1-p196560B0",[1,7,"imprim","Co2 < 2xCo2"]);
AGR.API("2F22G1-p123552B0",[1,6,"imprim","O8+(2):S3 < O8+(2):S3x2"]);
AGR.API("2F22G1-p28160B0",[1,5,"imprim","O7(3) < 2xO7(3)"]);
AGR.API("2F22d2G1-p56320B0",[1,9,"imprim","O7(3) < 2xO7(3)"]);
AGR.API("2F42G1-p139776B0",[1,9,"imprim","S8(2) < 2xS8(2)"]);
AGR.API("2HSG1-p11200aB0",[1,16,"imprim","M11 < 2xM11"]);
AGR.API("2HSG1-p4400B0",[1,13,"imprim","A8 < Isoclinic(S8x2)"]);
AGR.API("2HSG1-p704B0",[1,6,"imprim","U3(5) < Isoclinic(U3(5).2x2)"]);
AGR.API("2HSd2G1-p1408B0",[1,11,"imprim","U3(5) < U3(5).2"]);
AGR.API("2J2G1-p1120B0",[1,20,"imprim","3.A6 < (2x3.A6).2"]);
AGR.API("2J2G1-p200B0",[1,5,"imprim","U3(3) < 2xU3(3)"]);
AGR.API("2L219G1-p40B0",[1,4,"imprim","19:9 < 2x19:9"]);
AGR.API("2L27G1-p112B0",[1,40,"imprim","3 < 2x7:3"]);
AGR.API("2L27G1-p16B0",[1,4,"imprim","7:3 < 2x7:3"]);
AGR.API("2L27G1-p336B0",[1,336,"imprim","1 < 2x7:3"]);
AGR.API("2L27G1-p48B0",[1,12,"imprim","7 < 2x7:3"]);
AGR.API("2L27d2G1-p224B0",[1,80,"imprim","3 < 2.L2(7)"]);
AGR.API("2L27d2G1-p32B0",[1,8,"imprim","7:3 < 2.L2(7)"]);
AGR.API("2L27d2G1-p672B0",[1,672,"imprim","1 < 2.L2(7)"]);
AGR.API("2L27d2G1-p96B0",[1,24,"imprim","7 < 2.L2(7)"]);
AGR.API("2L27d2iG1-p112aB0",[1,23,"imprim","S3 < 2.D12"]);
AGR.API("2L27d2iG1-p112bB0",[1,21,"imprim","6 < 2x7:6"]);
AGR.API("2L27d2iG1-p16aB0",[1,3,"imprim","7:6 < 2x7:6"]);
AGR.API("2L27d2iG1-p16bB0",[1,3,"imprim","7:6 < 2x7:6"]);
AGR.API("2L27d2iG1-p224B0",[1,80,"imprim","3 < 2.L2(7)"]);
AGR.API("2L27d2iG1-p32B0",[1,8,"imprim","7:3 < 2.L2(7)"]);
AGR.API("2L27d2iG1-p336B0",[1,171,"imprim","2 < 2.D12"]);
AGR.API("2L27d2iG1-p48aB0",[1,9,"imprim","D14 < 2x7:6"]);
AGR.API("2L27d2iG1-p48bB0",[1,9,"imprim","D14 < 2x7:6"]);
AGR.API("2L27d2iG1-p672B0",[1,672,"imprim","1 < 2.L2(7)"]);
AGR.API("2L27d2iG1-p96B0",[1,24,"imprim","7 < 2.L2(7)"]);
AGR.API("2L34G1-p112aB0",[1,6,"imprim","A6 < 2xA6"]);
AGR.API("2L34G1-p112bB0",[1,5,"imprim","A6 < 2xA6"]);
AGR.API("2L34G1-p112cB0",[1,5,"imprim","A6 < 2xA6"]);
AGR.API("2L34G1-p240aB0",[1,8,"imprim","L2(7) < 2xL2(7)"]);
AGR.API("2L34G1-p240bB0",[1,7,"imprim","L2(7) < 2xL2(7)"]);
AGR.API("2L34G1-p240cB0",[1,7,"imprim","L2(7) < 2xL2(7)"]);
AGR.API("2M12G1-p24aB0",[1,3,"imprim","M11 < 2xM11"]);
AGR.API("2M12d2G1-p48B0",[1,5,"imprim","M11 < 2.M12"]);
AGR.API("2M22G1-p352aB0",[1,5,"imprim","A7 < 2xA7"]);
AGR.API("2M22G1-p660B0",[1,7,"imprim","2^3:L3(2) < 2x2^3:L3(2)"]);
AGR.API("2O73G1-p2160B0",[1,5,"imprim","G2(3) < 2xG2(3)"]);
AGR.API("2O8p3G1-p2160aB0",[1,5,"imprim","O7(3) < 2xO7(3)"]);
AGR.API("2O8p3G1-p2160bB0",[1,5,"imprim","O7(3) < 2xO7(3)"]);
AGR.API("2O8p3G1-p2240B0",[1,5,"imprim","3^6:L4(3) < 2x3^6:L4(3)"]);
AGR.API("2RuG1-p16240B0",[1,9,"imprim","2F4(2)' < Isoclinic(2F4(2)'.2x2)"]);
AGR.API("2S45G1-p624B0",[1,9,"imprim","5^(1+2)_+:2A5 < 5^(1+2)_+:(4x2.A5)"]);
AGR.API("2S5G1-p40aB0",[1,11,"imprim","S3 < 2.S4"]);
AGR.API("2S5G1-p40bB0",[1,9,"imprim","6 < 2.(2xS3)"]);
AGR.API("2S5G1-p48B0",[1,16,"imprim","5 < 2.A5"]);
AGR.API("2S5iG1-p48B0",[1,16,"imprim","5 < 2.A5"]);
AGR.API("2S5iG1-p80B0",[1,32,"imprim","3 < 2.A5"]);
AGR.API("2S62G1-p1920B0",[1,10,"imprim","L2(8).3 < 2xL2(8).3"]);
AGR.API("2S62G1-p2160B0",[1,13,"imprim","2^3.L3(2) < 2^7.L3(2)"]);
AGR.API("2S62G1-p240aB0",[1,4,"imprim","U3(3).2 < 2xU3(3).2"]);
AGR.API("2S62G1-p240bB0",[1,5,"imprim","U3(3).2 < 2xU3(3).2"]);
AGR.API("2S62G1-p480B0",[1,8,"imprim","U3(3) < 2xU3(3).2"]);
AGR.API("2S63d2G1-p728B0",[1,4,"imprim","3^(1+4)_+:2U4(2) < 2x3^(1+4)_+:2U4(2)"]);
AGR.API("2S6G1-p240aB0",[1,56,"imprim","S3 < 2.S5"]);
AGR.API("2S6G1-p288B0",[1,64,"imprim","5 < 2.S5"]);
AGR.API("2S6G1-p80B0",[1,10,"imprim","3xS3 < 3^2:QD16"]);
AGR.API("2SuzG1-p65520B0",[1,10,"imprim","U5(2) < 2xU5(2)"]);
AGR.API("2Sz8G1-p1040B0",[1,23,"imprim","2^3:7 < 2^(4+3):7"]);
AGR.API("2U42G1-p240B0",[1,9,"imprim","3^(1+2)_+:Q8 < 2x3^(1+2)_+:2A4"]);
AGR.API("2U42G1-p80B0",[1,5,"imprim","3^(1+2)_+:2A4 < 2x3^(1+2)_+:2A4"]);
AGR.API("2U42d2G1-p240B0",[1,6,"imprim","3^(1+2)_+:QD16 < 2x3^(1+2)_+:2S4"]);
AGR.API("2U62G1-p12672aB0",[1,7,"imprim","S6(2) < 2xS6(2)"]);
AGR.API("2U62G1-p12672bB0",[1,6,"imprim","S6(2) < 2xS6(2)"]);
AGR.API("2U62G1-p12672cB0",[1,6,"imprim","S6(2) < 2xS6(2)"]);
AGR.API("2U62G1-p1344B0",[1,5,"imprim","U5(2) < 2xU5(2)"]);
AGR.API("2U62G1-p2816aB0",[1,5,"imprim","U4(3).2_2 < 2xU4(3).2_2"]);
AGR.API("2U62G1-p2816bB0",[1,5,"imprim","U4(3).2_2 < 2xU4(3).2_2"]);
AGR.API("2U62G1-p41472B0",[1,15,"imprim","M22 < 2xM22"]);
AGR.API("2U62G1-p5632B0",[1,9,"imprim","U4(3) < 2xU4(3).2_2"]);
AGR.API("2aM20G1-p12aB0",[1,3,"imprim","2^4:D10 < 2x2^4:D10"]);
AGR.API("2aM20G1-p12bB0",[1,3,"imprim","2^4:D10 < 2x2^4:D10"]);
AGR.API("2aM20G1-p20aB0",[1,4,"imprim","2^4:S3 < 2x2^4:S3"]);
AGR.API("2aM20G1-p20bB0",[1,4,"imprim","2^4:S3 < 2x2^4:S3"]);
AGR.API("2bM20G1-p120aB0",[1,64,"imprim","2^4 < 2^5.A4"]);
AGR.API("2cM20G1-p24B0",[1,6,"imprim","2^4:5 < 2x2^4:5"]);
AGR.API("3A6G1-p18aB0",[1,4,"imprim","A5 < 3xA5"]);
AGR.API("3A6G1-p18bB0",[1,4,"imprim","A5 < 3xA5"]);
AGR.API("3A6G1-p45aB0",[1,7,"imprim","S4 < 3xS4"]);
AGR.API("3A6G1-p45bB0",[1,7,"imprim","S4 < 3xS4"]);
AGR.API("3A7G1-p315B0",[1,28,"imprim","S4 < 3.A6"]);
AGR.API("3A7G1-p45aB0",[1,4,"imprim","L2(7) < 3xL2(7)"]);
AGR.API("3A7G1-p45bB0",[1,4,"imprim","L2(7) < 3xL2(7)"]);
AGR.API("3A7G1-p63B0",[1,7,"imprim","S5 < 3xS5"]);
AGR.API("3F22G1-p185328B0",[1,10,"imprim","O8+(2):S3 < 3xO8+(2):S3"]);
AGR.API("3F22d2G1-p185328B0",[1,7,"imprim","O8+(2):S3x2 < S3xO8+(2):S3"]);
AGR.API("3F24G1-p920808B0",[1,7,"imprim","Fi23 < 3xFi23"]);
AGR.API("3F24d2G1-p920808B0",[1,5,"imprim","Fi23x2 < Fi23xS3"]);
AGR.API("3G23G1-p1134B0",[1,8,"imprim","L3(3).2 < 3xL3(3).2"]);
AGR.API("3L34G1-p360aB0",[1,10,"imprim","L2(7) < 3xL2(7)"]);
AGR.API("3L34G1-p360bB0",[1,10,"imprim","L2(7) < 3xL2(7)"]);
AGR.API("3L34G1-p360cB0",[1,10,"imprim","L2(7) < 3xL2(7)"]);
AGR.API("3L34G1-p63aB0",[1,4,"imprim","2^4:A5 < 3x2^4:A5"]);
AGR.API("3L34G1-p63bB0",[1,4,"imprim","2^4:A5 < 3x2^4:A5"]);
AGR.API("3M22G1-p2016B0",[1,16,"imprim","L2(11) < 3xL2(11)"]);
AGR.API("3M22G1-p693B0",[1,10,"imprim","2^4:S5 < 3x2^4:S5"]);
AGR.API("3M22G1-p990B0",[1,13,"imprim","2^3:L3(2) < 3x2^3:L3(2)"]);
AGR.API("3McLG1-p103950B0",[1,36,"imprim","U4(2) < 3_2.U4(3)"]);
AGR.API("3McLG1-p340200B0",[1,111,"imprim","M11 < 3xM11"]);
AGR.API("3McLG1-p66825B0",[1,14,"imprim","2.A8 < 3x2.A8"]);
AGR.API("3ONG1-p368280B0",[1,11,"imprim","L3(7).2 < 3xL3(7).2"]);
AGR.API("3ONd2G1-p736560B0",[1,19,"imprim","L3(7).2 < 3.ON"]);
AGR.API("3S6G1-p18aB0",[1,3,"imprim","S5 < (3xA5):2"]);
AGR.API("3S6G1-p18bB0",[1,3,"imprim","S5 < (3xA5):2"]);
AGR.API("3S6G1-p45aB0",[1,5,"imprim","S4x2 < S4xS3"]);
AGR.API("3S6G1-p45bB0",[1,5,"imprim","S4x2 < S4xS3"]);
AGR.API("3S7G1-p63B0",[1,5,"imprim","S5x2 < S5xS3"]);
AGR.API("3S7G1-p90B0",[1,8,"imprim","L2(7) < 3.A7"]);
AGR.API("3SuzG1-p405405B0",[1,23,"imprim","2^(1+6)_-.U4(2) < 3x2^(1+6)_-.U4(2)"]);
AGR.API("3SuzG1-p5346B0",[1,7,"imprim","G2(4) < 3xG2(4)"]);
AGR.API("3SuzG1-p98280B0",[1,14,"imprim","U5(2) < 3xU5(2)"]);
AGR.API("3Suzd2G1-p5346B0",[1,5,"imprim","G2(4).2 < (3xG2(4)).2"]);
AGR.API("3U38G1-p32832B0",[1,145,"imprim","L2(8) < 9xL2(8)"]);
AGR.API("3U38G1-p4617B0",[1,18,"imprim","2^(3+6):7 < 2^(3+6):63"]);
AGR.API("3U62G1-p18711B0",[1,11,"imprim","2^(4+8):(S3xA5) < 3x2^(4+8):(S3xA5)"]);
AGR.API("3U62G1-p19008aB0",[1,10,"imprim","S6(2) < 3xS6(2)"]);
AGR.API("3U62G1-p19008bB0",[1,10,"imprim","S6(2) < 3xS6(2)"]);
AGR.API("3U62G1-p19008cB0",[1,10,"imprim","S6(2) < 3xS6(2)"]);
AGR.API("3U62G1-p2016B0",[1,7,"imprim","U5(2) < 3xU5(2)"]);
AGR.API("3U62G1-p2079B0",[1,7,"imprim","2^(1+8)_+:U4(2) < 3x2^(1+8)_+:U4(2)"]);
AGR.API("4M22G1-p4928aB0",[1,40,"imprim","A6 < 4_1.L3(4)"]);
AGR.API("4M22G1-p4928bB0",[1,40,"imprim","A6 < (4xA6).2_3"]);
AGR.API("4Sz8d3G1-p2080B0",[1,19,"imprim","2^3:7:3 < 2^2.2^(3+3):7:3"]);
AGR.API("4U62G1-p2688B0",[1,9,"imprim","U5(2) < 2^2xU5(2)"]);
AGR.API("4aL34G1-p224B0",[1,8,"imprim","A6 < 4xA6"]);
AGR.API("4aL34G1-p480B0",[1,12,"imprim","L2(7) < 4xL2(7)"]);
AGR.API("4bL34G1-p224B0",[1,10,"imprim","A6 < 4xA6"]);
AGR.API("4bL34G1-p480B0",[1,14,"imprim","L2(7) < 4xL2(7)"]);
AGR.API("6A6G1-p432B0",[1,96,"imprim","5 < 3x2.A5"]);
AGR.API("6A6G1-p720aB0",[1,248,"imprim","3 < 3x2.A5"]);
AGR.API("6A7G1-p720B0",[1,44,"imprim","7:3 < 3x2.L3(2)"]);
AGR.API("6L34G1-p720aB0",[1,20,"imprim","L2(7) < 6xL2(7)"]);
AGR.API("6L34G1-p720bB0",[1,17,"imprim","L2(7) < 6xL2(7)"]);
AGR.API("6L34G1-p720cB0",[1,17,"imprim","L2(7) < 6xL2(7)"]);
AGR.API("6M22G1-p1980B0",[1,17,"imprim","2^3:L3(2) < 6x2^3:L3(2)"]);
AGR.API("6S6G1-p720aB0",[1,136,"imprim","S3 < (3x2.A5):2"]);
AGR.API("6SuzG1-p196560B0",[1,26,"imprim","U5(2) < 6xU5(2)"]);
AGR.API("6U62G1-p38016aB0",[1,17,"imprim","S6(2) < 6xS6(2)"]);
AGR.API("6U62G1-p38016bB0",[1,14,"imprim","S6(2) < 6xS6(2)"]);
AGR.API("6U62G1-p38016cB0",[1,14,"imprim","S6(2) < 6xS6(2)"]);
AGR.API("6U62G1-p4032B0",[1,11,"imprim","U5(2) < 6xU5(2)"]);
AGR.API("A10G1-p10B0",[8,2,"prim","A9",1]);
AGR.API("A10G1-p120B0",[1,4,"prim","(A7x3):2",3]);
AGR.API("A10G1-p126B0",[1,3,"prim","(A5xA5):4",4]);
AGR.API("A10G1-p210B0",[1,5,"prim","(A6xA4):2",5]);
AGR.API("A10G1-p2520B0",[1,12,"prim","A6.2_3",7]);
AGR.API("A10G1-p45B0",[1,3,"prim","S8",2]);
AGR.API("A10G1-p945B0",[1,7,"prim","2^4:S5",6]);
AGR.API("A11G1-p11B0",[9,2,"prim","A10",1]);
AGR.API("A11G1-p165B0",[1,4,"prim","(A8x3):2",3]);
AGR.API("A11G1-p2520aB0",[1,5,"prim","M11",6]);
AGR.API("A11G1-p2520bB0",[1,5,"prim","M11",7]);
AGR.API("A11G1-p330B0",[1,5,"prim","(A7xA4):2",4]);
AGR.API("A11G1-p462B0",[1,6,"prim","(A6xA5):2",5]);
AGR.API("A11G1-p55B0",[1,3,"prim","S9",2]);
AGR.API("A12G1-p12B0",[10,2,"prim","A11",1]);
AGR.API("A12G1-p220B0",[1,4,"prim","(A9x3):2",3]);
AGR.API("A12G1-p2520B0",[1,4,"prim","M12",7]);
AGR.API("A12G1-p462B0",[1,4,"prim","(A6xA6):2^2",4]);
AGR.API("A12G1-p495B0",[1,5,"prim","(A8xA4):2",5]);
AGR.API("A12G1-p66B0",[1,3,"prim","S10",2]);
AGR.API("A12G1-p792B0",[1,6,"prim","(A7xA5):2",6]);
AGR.API("A13G1-p13B0",[11,2,"prim","A12",1]);
AGR.API("A13G1-p78B0",[1,3,"prim","S11",2]);
AGR.API("A14G1-p1001B0",[1,5,"prim","(A10xA4):2",4]);
AGR.API("A14G1-p14B0",[12,2,"prim","A13",1]);
AGR.API("A14G1-p1716B0",[1,4,"prim","(A7xA7):2^2",5]);
AGR.API("A14G1-p2002B0",[1,6,"prim","(A9xA5):2",6]);
AGR.API("A14G1-p3003B0",[1,7,"prim","(A8xA6):2",7]);
AGR.API("A14G1-p364B0",[1,4,"prim","(A11x3):2",3]);
AGR.API("A14G1-p91B0",[1,3,"prim","S12",2]);
AGR.API("A15G1-p105B0",[1,3,"prim","S13",2]);
AGR.API("A15G1-p1365B0",[1,5,"prim","(A11xA4):2",4]);
AGR.API("A15G1-p15B0",[13,2,"prim","A14",1]);
AGR.API("A15G1-p455B0",[1,4,"prim","(A12x3):2",3]);
AGR.API("A16G1-p120B0",[1,3,"prim","S14",2]);
AGR.API("A16G1-p16B0",[14,2,"prim","A15",1]);
AGR.API("A16G1-p1820B0",[1,5,"prim","(A12xA4):2",4]);
AGR.API("A16G1-p560B0",[1,4,"prim","(A13x3):2",3]);
AGR.API("A17G1-p136B0",[1,3,"prim","S15",2]);
AGR.API("A17G1-p17B0",[15,2,"prim","A16",1]);
AGR.API("A17G1-p2380B0",[1,5,"prim","(A13xA4):2",4]);
AGR.API("A17G1-p680B0",[1,4,"prim","(A14x3):2",3]);
AGR.API("A18G1-p153B0",[1,3,"prim","S16",2]);
AGR.API("A18G1-p18B0",[16,2,"prim","A17",1]);
AGR.API("A18G1-p3060B0",[1,5,"prim","(A14xA4):2",4]);
AGR.API("A18G1-p816B0",[1,4,"prim","(A15x3):2",3]);
AGR.API("A19G1-p171B0",[1,3,"prim","S17",2]);
AGR.API("A19G1-p19B0",[17,2,"prim","A18",1]);
AGR.API("A19G1-p969B0",[1,4,"prim","(A16x3):2",3]);
AGR.API("A20G1-p190B0",[1,3,"prim","S18",2]);
AGR.API("A20G1-p20B0",[18,2,"prim","A19",1]);
AGR.API("A21G1-p210B0",[1,3,"prim","S19",2]);
AGR.API("A21G1-p21B0",[19,2,"prim","A20",1]);
AGR.API("A22G1-p22B0",[20,2,"prim","A21",1]);
AGR.API("A22G1-p231B0",[1,3,"prim","S20",2]);
AGR.API("A23G1-p23B0",[21,2,"prim","A22",1]);
AGR.API("A23G1-p253B0",[1,3,"prim","S21",2]);
AGR.API("A5G1-p10B0",[1,3,"prim","S3",3]);
AGR.API("A5G1-p5B0",[3,2,"prim","A4",1]);
AGR.API("A5G1-p6B0",[2,2,"prim","D10",2]);
AGR.API("A6G1-p10B0",[2,2,"prim","3^2:4",3]);
AGR.API("A6G1-p15aB0",[1,3,"prim","S4",4]);
AGR.API("A6G1-p15bB0",[1,3,"prim","S4",5]);
AGR.API("A6G1-p6aB0",[4,2,"prim","A5",1]);
AGR.API("A6G1-p6bB0",[4,2,"prim","A5",2]);
AGR.API("A6V4G1-p10B0",[3,2,"prim","3^2:Q8.2",4]);
AGR.API("A7G1-p7B0",[5,2,"prim","A6",1]);
AGR.API("A8G1-p15aB0",[2,2,"prim","2^3:L3(2)",2]);
AGR.API("A8G1-p15bB0",[2,2,"prim","2^3:L3(2)",3]);
AGR.API("A8G1-p8B0",[6,2,"prim","A7",1]);
AGR.API("A9G1-p120aB0",[1,3,"prim","L2(8):3",4]);
AGR.API("A9G1-p120bB0",[1,3,"prim","L2(8):3",5]);
AGR.API("A9G1-p126B0",[1,5,"prim","(A5xA4):2",6]);
AGR.API("A9G1-p280B0",[1,5,"prim","3^3:S4",7]);
AGR.API("A9G1-p36B0",[1,3,"prim","S7",2]);
AGR.API("A9G1-p840B0",[1,12,"prim","3^2:2A4",8]);
AGR.API("A9G1-p84B0",[1,4,"prim","(A6x3):2_1",3]);
AGR.API("A9G1-p9B0",[7,2,"prim","A8",1]);
AGR.API("Co1G1-p98280B0",[1,4,"prim","Co2",1]);
AGR.API("Co2G1-p2300B0",[1,3,"prim","U6(2).2",1]);
AGR.API("Co2G1-p4600B0",[1,5,"imprim","U6(2) < U6(2).2"]);
AGR.API("Co3G1-p11178B0",[1,5,"prim","HS",2]);
AGR.API("Co3G1-p128800B0",[1,6,"prim","3^5:(2xM11)",5]);
AGR.API("Co3G1-p276B0",[2,2,"prim","McL.2",1]);
AGR.API("Co3G1-p37950B0",[1,8,"prim","U4(3).(2^2)_{133}",3]);
AGR.API("Co3G1-p48600B0",[1,8,"prim","M23",4]);
AGR.API("Co3G1-p552B0",[1,4,"imprim","McL < McL.2"]);
AGR.API("F22G1-p14080bB0",[1,3,"prim","O7(3)",3]);
AGR.API("F22G1-p142155B0",[1,8,"prim","2^10:M22",5]);
AGR.API("F22G1-p3510B0",[1,3,"prim","2.U6(2)",1]);
AGR.API("F22G1-p61776B0",[1,4,"prim","O8+(2):S3",4]);
AGR.API("F22G1-p694980B0",[1,10,"prim","2^6:S6(2)",6]);
AGR.API("F22d2G1-p3510B0",[1,3,"prim","2.U6(2).2",2]);
AGR.API("F23G1-p137632B0",[1,3,"prim","O8+(3):S3",2]);
AGR.API("F23G1-p275264B0",[1,5,"imprim","O8+(3).3 < O8+(3):S3"]);
AGR.API("F23G1-p31671B0",[1,3,"prim","2.Fi22",1]);
AGR.API("F24G1-p306936B0",[1,3,"prim","Fi23",1]);
AGR.API("F24d2G1-p306936B0",[1,3,"prim","Fi23x2",2]);
AGR.API("F42G1-p69888aB0",[1,5,"prim","S8(2)",3]);
AGR.API("G23d2G1-p756B0",[1,6,"imprim","L3(3) < L3(3):2"]);
AGR.API("G24G1-p1365aB0",[1,4,"prim","2^(2+8):(3xA5)",2]);
AGR.API("G24G1-p1365bB0",[1,4,"prim","2^(4+6):(A5x3)",3]);
AGR.API("G24G1-p2016B0",[1,3,"prim","U3(4).2",4]);
AGR.API("G24G1-p20800B0",[1,14,"prim","U3(3).2",6]);
AGR.API("G24G1-p2080B0",[1,4,"prim","3.L3(4).2_3",5]);
AGR.API("G24G1-p416B0",[1,3,"prim","J2",1]);
AGR.API("G25G1-p3906aB0",[1,4,"prim","5^(1+4)_+:GL(2,5)",1]);
AGR.API("G25G1-p3906bB0",[1,4,"prim","5^(2+3):GL2(5)",2]);
AGR.API("G25G1-p7750B0",[1,4,"prim","3.U3(5).2",3]);
AGR.API("G25G1-p7875B0",[1,5,"prim","L3(5).2",4]);
AGR.API("HNG1-p1140000B0",[1,12,"prim","A12",1]);
AGR.API("HSG1-p100B0",[1,3,"prim","M22",1]);
AGR.API("HSG1-p1100aB0",[1,5,"prim","L3(4).2_1",4]);
AGR.API("HSG1-p1100bB0",[1,5,"prim","A8.2",5]);
AGR.API("HSG1-p15400B0",[1,27,"prim","2xA6.2^2",11]);
AGR.API("HSG1-p176bB0",[2,2,"prim","U3(5):2",3]);
AGR.API("HSG1-p3850B0",[1,12,"prim","2^4.S6",6]);
AGR.API("HSG1-p4125B0",[1,9,"prim","4^3:L3(2)",7]);
AGR.API("HSG1-p5600aB0",[1,9,"prim","M11",8]);
AGR.API("HSd2G1-p100B0",[1,3,"prim","M22.2",2]);
AGR.API("HSd2G1-p1100bB0",[1,5,"prim","S8x2",4]);
AGR.API("HSd2G1-p15400B0",[1,20,"prim","(2xA6.2^2).2",8]);
AGR.API("HSd2G1-p352B0",[1,4,"imprim","U3(5).2 < HS"]);
AGR.API("HeG1-p2058B0",[1,5,"prim","S4(4):2",1]);
AGR.API("HeG1-p244800B0",[1,36,"prim","7^2:2L2(7)",6]);
AGR.API("HeG1-p29155B0",[1,12,"prim","2^6:3.S6",3]);
AGR.API("HeG1-p8330B0",[1,7,"prim","2^2.L3(4).S3",2]);
AGR.API("Hed2G1-p2058B0",[1,4,"prim","S4(4):4",2]);
AGR.API("Hed2G1-p8330B0",[1,6,"prim","2^2.L3(4).D12",3]);
AGR.API("J1G1-p1045B0",[1,11,"prim","2^3:7:3",2]);
AGR.API("J1G1-p1463B0",[1,22,"prim","2xA5",3]);
AGR.API("J1G1-p1540B0",[1,21,"prim","19:6",4]);
AGR.API("J1G1-p1596B0",[1,19,"prim","11:10",5]);
AGR.API("J1G1-p266B0",[1,5,"prim","L2(11)",1]);
AGR.API("J1G1-p2926B0",[1,67,"prim","D6xD10",6]);
AGR.API("J1G1-p4180B0",[1,107,"prim","7:6",7]);
AGR.API("J2G1-p1008B0",[1,11,"prim","A5xD10",6]);
AGR.API("J2G1-p100B0",[1,3,"prim","U3(3)",1]);
AGR.API("J2G1-p1800B0",[1,18,"prim","L3(2).2",7]);
AGR.API("J2G1-p280B0",[1,4,"prim","3.A6.2_2",2]);
AGR.API("J2G1-p315B0",[1,6,"prim","2^(1+4)_-:A5",3]);
AGR.API("J2G1-p525B0",[1,6,"prim","2^(2+4):(3xS3)",4]);
AGR.API("J2G1-p840B0",[1,7,"prim","A4xA5",5]);
AGR.API("J2d2G1-p100B0",[1,3,"prim","U3(3).2",2]);
AGR.API("J3G1-p14688aB0",[1,14,"prim","L2(19)",2]);
AGR.API("J3G1-p14688bB0",[1,14,"prim","L2(19)",3]);
AGR.API("J3G1-p17442B0",[1,19,"prim","2^4:(3xA5)",4]);
AGR.API("J3G1-p20520B0",[1,22,"prim","L2(17)",5]);
AGR.API("J3G1-p23256B0",[1,28,"prim","(3xA6):2_2",6]);
AGR.API("J3G1-p25840B0",[1,20,"prim","3^2.3^(1+2)_+:8",7]);
AGR.API("J3G1-p26163B0",[1,27,"prim","2^(1+4)_-:A5",8]);
AGR.API("J3G1-p43605B0",[1,57,"prim","2^(2+4).(3xS3)",9]);
AGR.API("J3G1-p6156B0",[1,8,"prim","L2(16).2",1]);
AGR.API("J3d2G1-p6156B0",[1,7,"prim","L2(16).4",2]);
AGR.API("L211G1-p11aB0",[2,2,"prim","A5",1]);
AGR.API("L211G1-p11bB0",[2,2,"prim","A5",2]);
AGR.API("L211G1-p12B0",[2,2,"prim","11:5",3]);
AGR.API("L211G1-p55B0",[1,9,"prim","S3x2",4]);
AGR.API("L211d2G1-p12B0",[3,2,"prim","11:10",2]);
AGR.API("L211d2G1-p22B0",[1,4,"imprim","A5 < L2(11)"]);
AGR.API("L211d2G1-p55aB0",[1,6,"prim","D24",3]);
AGR.API("L211d2G1-p55bB0",[1,6,"prim","S4",4]);
AGR.API("L211d2G1-p66B0",[1,7,"prim","D20",5]);
AGR.API("L213G1-p14B0",[2,2,"prim","13:6",1]);
AGR.API("L213d2G1-p14B0",[3,2,"prim","13:12",2]);
AGR.API("L213d2G1-p78B0",[1,7,"prim","D28",3]);
AGR.API("L213d2G1-p91aB0",[1,8,"prim","D24",4]);
AGR.API("L216G1-p17B0",[3,2,"prim","2^4:15",1]);
AGR.API("L217G1-p18B0",[2,2,"prim","17:8",1]);
AGR.API("L217d2G1-p18B0",[3,2,"prim","17:16",2]);
AGR.API("L219G1-p171B0",[1,15,"prim","D20",4]);
AGR.API("L219G1-p190B0",[1,16,"prim","D18",5]);
AGR.API("L219G1-p20B0",[2,2,"prim","19:9",1]);
AGR.API("L219G1-p57aB0",[1,4,"prim","A5",2]);
AGR.API("L219G1-p57bB0",[1,4,"prim","A5",3]);
AGR.API("L219d2G1-p114B0",[1,8,"imprim","A5 < L2(19)"]);
AGR.API("L219d2G1-p171B0",[1,10,"prim","D40",3]);
AGR.API("L219d2G1-p190B0",[1,11,"prim","D36",4]);
AGR.API("L219d2G1-p20B0",[3,2,"prim","19:18",2]);
AGR.API("L219d2G1-p285B0",[1,18,"prim","S4",5]);
AGR.API("L223G1-p24B0",[2,2,"prim","23:11",1]);
AGR.API("L227G1-p28B0",[2,2,"prim","3^3:13",1]);
AGR.API("L229G1-p30B0",[2,2,"prim","29:14",1]);
AGR.API("L231G1-p32B0",[2,2,"prim","31:15",1]);
AGR.API("L232G1-p33B0",[3,2,"prim","2^5:31",1]);
AGR.API("L232G1-p496B0",[1,16,"prim","D66",2]);
AGR.API("L232G1-p528B0",[1,17,"prim","D62",3]);
AGR.API("L232d5G1-p33B0",[3,2,"prim","2^5:31:5",2]);
AGR.API("L232d5G1-p496B0",[1,4,"prim","33:10",3]);
AGR.API("L232d5G1-p528B0",[1,5,"prim","31:10",4]);
AGR.API("L249G1-p1176B0",[1,36,"prim","D50",6]);
AGR.API("L249G1-p1225B0",[1,39,"prim","D48",7]);
AGR.API("L249G1-p175aB0",[1,5,"prim","L3(2).2",2]);
AGR.API("L249G1-p175bB0",[1,5,"prim","L3(2).2",3]);
AGR.API("L249G1-p50B0",[2,2,"prim","7^2:24",1]);
AGR.API("L249G1-p980aB0",[1,24,"prim","A5",4]);
AGR.API("L249G1-p980bB0",[1,24,"prim","A5",5]);
AGR.API("L27G1-p14aB0",[1,3,"imprim","A4 < S4"]);
AGR.API("L27G1-p14bB0",[1,3,"imprim","A4 < S4"]);
AGR.API("L27G1-p168B0",[1,168,"imprim","1 < S4"]);
AGR.API("L27G1-p21B0",[1,6,"imprim","D8 < S4"]);
AGR.API("L27G1-p24B0",[1,6,"imprim","7 < 7:3"]);
AGR.API("L27G1-p28B0",[1,7,"imprim","S3 < S4"]);
AGR.API("L27G1-p42aB0",[1,15,"imprim","2^2 < S4"]);
AGR.API("L27G1-p42bB0",[1,15,"imprim","2^2 < S4"]);
AGR.API("L27G1-p42cB0",[1,12,"imprim","4 < S4"]);
AGR.API("L27G1-p56B0",[1,20,"imprim","3 < S4"]);
AGR.API("L27G1-p7aB0",[2,2,"prim","S4",1]);
AGR.API("L27G1-p7bB0",[2,2,"prim","S4",2]);
AGR.API("L27G1-p84B0",[1,44,"imprim","2 < S4"]);
AGR.API("L27G1-p8B0",[2,2,"prim","7:3",3]);
AGR.API("L27d2G1-p112B0",[1,40,"imprim","3 < 7:3"]);
AGR.API("L27d2G1-p14B0",[1,4,"imprim","S4 < L2(7)"]);
AGR.API("L27d2G1-p168aB0",[1,88,"imprim","2 < S4"]);
AGR.API("L27d2G1-p168bB0",[1,87,"imprim","2 < D12"]);
AGR.API("L27d2G1-p16B0",[1,4,"imprim","7:3 < 7:6"]);
AGR.API("L27d2G1-p21B0",[1,4,"prim","D16",3]);
AGR.API("L27d2G1-p24B0",[1,6,"imprim","D14 < 7:6"]);
AGR.API("L27d2G1-p28B0",[1,5,"prim","D12",4]);
AGR.API("L27d2G1-p28bB0",[1,6,"imprim","A4 < S4"]);
AGR.API("L27d2G1-p336B0",[1,336,"imprim","1 < L2(7)"]);
AGR.API("L27d2G1-p42aB0",[1,12,"imprim","D8 < S4"]);
AGR.API("L27d2G1-p42bB0",[1,9,"imprim","D8 < D16"]);
AGR.API("L27d2G1-p42cB0",[1,7,"imprim","8 < D16"]);
AGR.API("L27d2G1-p48B0",[1,12,"imprim","7 < 7:6"]);
AGR.API("L27d2G1-p56aB0",[1,14,"imprim","S3 < S4"]);
AGR.API("L27d2G1-p56bB0",[1,13,"imprim","S3 < D12"]);
AGR.API("L27d2G1-p56cB0",[1,11,"imprim","6 < D12"]);
AGR.API("L27d2G1-p84aB0",[1,30,"imprim","2^2 < S4"]);
AGR.API("L27d2G1-p84bB0",[1,25,"imprim","2^2 < D12"]);
AGR.API("L27d2G1-p84cB0",[1,24,"imprim","4 < S4"]);
AGR.API("L27d2G1-p8B0",[3,2,"prim","7:6",2]);
AGR.API("L28G1-p28B0",[1,4,"prim","D18",2]);
AGR.API("L28G1-p36B0",[1,5,"prim","D14",3]);
AGR.API("L28G1-p9B0",[3,2,"prim","2^3:7",1]);
AGR.API("L28d3G1-p28B0",[2,2,"prim","9:6",3]);
AGR.API("L28d3G1-p36B0",[1,3,"prim","7:6",4]);
AGR.API("L28d3G1-p9B0",[3,2,"prim","2^3:7:3",2]);
AGR.API("L311G1-p133B0",[2,2,"prim","11^2:(5x2L2(11).2)",1]);
AGR.API("L313G1-p183aB0",[2,2,"prim","13^2:GL(2,13)",1]);
AGR.API("L313G1-p183bB0",[2,2,"prim","13^2:GL(2,13)",2]);
AGR.API("L33G1-p13aB0",[2,2,"prim","3^2:2S4",1]);
AGR.API("L33G1-p13bB0",[2,2,"prim","3^2:2S4",2]);
AGR.API("L33G1-p144B0",[1,8,"prim","13:3",3]);
AGR.API("L33G1-p234B0",[1,18,"prim","S4",4]);
AGR.API("L33d2G1-p117B0",[1,6,"prim","2S4:2",3]);
AGR.API("L33d2G1-p144B0",[1,6,"prim","13:6",4]);
AGR.API("L33d2G1-p234B0",[1,12,"prim","S4x2",5]);
AGR.API("L33d2G1-p26B0",[1,4,"imprim","3^2:2S4 < L3(3)"]);
AGR.API("L33d2G1-p52B0",[1,4,"prim","3^(1+2)_+:D8",2]);
AGR.API("L34G1-p120aB0",[1,4,"prim","L3(2)",6]);
AGR.API("L34G1-p120bB0",[1,4,"prim","L3(2)",7]);
AGR.API("L34G1-p120cB0",[1,4,"prim","L3(2)",8]);
AGR.API("L34G1-p21aB0",[2,2,"prim","2^4:A5",1]);
AGR.API("L34G1-p21bB0",[2,2,"prim","2^4:A5",2]);
AGR.API("L34G1-p280B0",[1,8,"prim","3^2:Q8",9]);
AGR.API("L34G1-p56aB0",[1,3,"prim","A6",3]);
AGR.API("L34G1-p56bB0",[1,3,"prim","A6",4]);
AGR.API("L34G1-p56cB0",[1,3,"prim","A6",5]);
AGR.API("L35G1-p31aB0",[2,2,"prim","5^2:GL2(5)",1]);
AGR.API("L35G1-p31bB0",[2,2,"prim","5^2:GL2(5)",2]);
AGR.API("L35d2G1-p186B0",[1,4,"prim","5^(1+2)_+:[2^5]",2]);
AGR.API("L35d2G1-p3100B0",[1,32,"prim","S5x2",4]);
AGR.API("L35d2G1-p3875B0",[1,35,"prim","4^2:D12",5]);
AGR.API("L35d2G1-p4000B0",[1,35,"prim","31:6",6]);
AGR.API("L35d2G1-p62B0",[1,4,"imprim","5^2:GL2(5) < L3(5)"]);
AGR.API("L35d2G1-p775B0",[1,8,"prim","4S5.2",3]);
AGR.API("L37G1-p57B0",[2,2,"prim","7^2:2.L2(7).2",1]);
AGR.API("L38G1-p56064B0",[1,220,"prim","7^2:S3",3]);
AGR.API("L38G1-p73aB0",[2,2,"prim","2^6:(7xL2(8))",1]);
AGR.API("L38G1-p73bB0",[2,2,"prim","2^6:(7xL2(8))",2]);
AGR.API("L38G1-p75264B0",[1,372,"prim","73:3",4]);
AGR.API("L38G1-p98112B0",[1,653,"prim","L3(2)",5]);
AGR.API("L38d2G1-p146B0",[1,4,"imprim","2^6:(7xL2(8)) < L3(8)"]);
AGR.API("L38d2G1-p4672B0",[1,11,"prim","D14xL2(8)",3]);
AGR.API("L38d2G1-p56064B0",[1,125,"prim","7^2:D12",4]);
AGR.API("L38d2G1-p657B0",[1,4,"prim","2^(3+6):7^2:2",2]);
AGR.API("L38d2G1-p75264B0",[1,216,"prim","73:6",5]);
AGR.API("L38d2G1-p98112B0",[1,335,"prim","L2(7).2",6]);
AGR.API("L38d3G1-p219aB0",[1,6,"imprim","2^6:(7xL2(8)) < 2^6:(7xL2(8)):3"]);
AGR.API("L38d3G1-p219bB0",[1,6,"imprim","2^6:(7xL2(8)) < 2^6:(7xL2(8)):3"]);
AGR.API("L38d3G1-p56064B0",[1,80,"prim","7^2:(3xS3)",4]);
AGR.API("L38d3G1-p73aB0",[2,2,"prim","2^6:(7xL2(8)):3",2]);
AGR.API("L38d3G1-p73bB0",[2,2,"prim","2^6:(7xL2(8)):3",3]);
AGR.API("L38d3G1-p75264B0",[1,126,"prim","73:9",5]);
AGR.API("L38d3G1-p98112B0",[1,381,"imprim","L2(8) < 2^6:(7xL2(8)):3"]);
AGR.API("L38d6G1-p438B0",[1,12,"imprim","2^6:(7xL2(8)) < L3(8)"]);
AGR.API("L38d6G1-p4672B0",[1,7,"prim","(D14xL2(8)):3",3]);
AGR.API("L38d6G1-p56064B0",[1,47,"prim","7^2:(6xS3)",4]);
AGR.API("L38d6G1-p657B0",[1,4,"prim","2^(3+6):7^2:6",2]);
AGR.API("L38d6G1-p75264B0",[1,74,"prim","73:18",5]);
AGR.API("L38d6G1-p98112B0",[1,119,"prim","L2(7).2x3",6]);
AGR.API("L44G1-p85aB0",[2,2,"prim","2^6:GL(3,4)",1]);
AGR.API("L44G1-p85bB0",[2,2,"prim","2^6:GL(3,4)",2]);
AGR.API("L45G1-p156aB0",[2,2,"prim","5^3:L3(5)",1]);
AGR.API("L45G1-p156bB0",[2,2,"prim","5^3:L3(5)",2]);
AGR.API("L52G1-p155aB0",[1,3,"prim","2^6:(S3xL3(2))",3]);
AGR.API("L52G1-p31aB0",[2,2,"prim","2^4:L4(2)",1]);
AGR.API("L52d2G1-p62B0",[1,4,"imprim","2^4:L4(2) < L5(2)"]);
AGR.API("L62G1-p63aB0",[2,2,"prim","2^5:L5(2)",1]);
AGR.API("L62d2G1-p126B0",[1,4,"imprim","2^5:L5(2) < L6(2)"]);
AGR.API("L72G1-p127aB0",[2,2,"prim","2^6:L6(2)",1]);
AGR.API("L72G1-p127bB0",[2,2,"prim","2^6:L6(2)",1]);
AGR.API("L72d2G2-p254B0",[1,4,"imprim","2^6:L6(2) < L7(2)"]);
AGR.API("M10G1-p10B0",[3,2,"prim","3^2:Q8",2]);
AGR.API("M11G1-p11B0",[4,2,"prim","A6.2_3",1]);
AGR.API("M11G1-p12B0",[3,2,"prim","L2(11)",2]);
AGR.API("M11G1-p165B0",[1,8,"prim","2.S4",5]);
AGR.API("M11G1-p55B0",[1,3,"prim","3^2:Q8.2",3]);
AGR.API("M11G1-p66B0",[1,4,"prim","S5",4]);
AGR.API("M12G1-p12aB0",[5,2,"prim","M11",1]);
AGR.API("M12G1-p12bB0",[5,2,"prim","M11",2]);
AGR.API("M12G1-p66aB0",[1,3,"prim","A6.2^2",3]);
AGR.API("M12G1-p66bB0",[1,3,"prim","A6.2^2",4]);
AGR.API("M12d2G1-p24B0",[1,3,"imprim","M11 < M12"]);
AGR.API("M20G1-p20aB0",[1,3,"imprim","2^4:3 < 2^4:A4"]);
AGR.API("M20G1-p20bB0",[1,3,"imprim","4^2:3 < 2^4:A4"]);
AGR.API("M20G1-p20cB0",[1,3,"imprim","4^2:3 < 2^4:A4"]);
AGR.API("M20G1-p20dB0",[1,3,"imprim","4^2:3 < 2^4:A4"]);
AGR.API("M22G1-p176aB0",[1,3,"prim","A7",3]);
AGR.API("M22G1-p176bB0",[1,3,"prim","A7",4]);
AGR.API("M22G1-p22B0",[3,2,"prim","L3(4)",1]);
AGR.API("M22G1-p231B0",[1,4,"prim","2^4:S5",5]);
AGR.API("M22G1-p330B0",[1,5,"prim","2^3:L3(2)",6]);
AGR.API("M22G1-p462aB0",[1,5,"imprim","2^4:A5 < 2^4:A6"]);
AGR.API("M22G1-p462bB0",[1,8,"imprim","2^4:A5 < L3(4), 2^4:S5"]);
AGR.API("M22G1-p462cB0",[1,8,"imprim","2^4:A5 < L3(4), 2^4:A6"]);
AGR.API("M22G1-p616B0",[1,5,"prim","A6.2_3",7]);
AGR.API("M22G1-p672B0",[1,6,"prim","L2(11)",8]);
AGR.API("M22G1-p770B0",[1,9,"imprim","(A4xA4):4 < 2^4:A6"]);
AGR.API("M22G1-p77B0",[1,3,"prim","2^4:A6",2]);
AGR.API("M22d2G1-p22B0",[3,2,"prim","L3(4).2_2",2]);
AGR.API("M22d2G1-p231B0",[1,4,"prim","2^5:S5",4]);
AGR.API("M22d2G1-p330B0",[1,5,"prim","2x2^3:L3(2)",5]);
AGR.API("M22d2G1-p352B0",[1,6,"imprim","A7 < M22"]);
AGR.API("M22d2G1-p616B0",[1,5,"prim","A6.2^2",6]);
AGR.API("M22d2G1-p672B0",[1,6,"prim","L2(11).2",7]);
AGR.API("M22d2G1-p77B0",[1,3,"prim","2^4:S6",3]);
AGR.API("M23G1-p1288B0",[1,4,"prim","M11",5]);
AGR.API("M23G1-p1771B0",[1,8,"prim","2^4:(3xA5):2",6]);
AGR.API("M23G1-p23B0",[4,2,"prim","M22",1]);
AGR.API("M23G1-p253aB0",[1,3,"prim","L3(4).2_2",2]);
AGR.API("M23G1-p253bB0",[1,3,"prim","2^4:A7",3]);
AGR.API("M23G1-p40320B0",[1,164,"prim","23:11",7]);
AGR.API("M23G1-p506B0",[1,4,"prim","A8",4]);
AGR.API("M24G1-p1288B0",[1,3,"prim","M12.2",4]);
AGR.API("M24G1-p1771B0",[1,4,"prim","2^6:3.S6",5]);
AGR.API("M24G1-p2024B0",[1,5,"prim","L3(4).S3",6]);
AGR.API("M24G1-p24B0",[5,2,"prim","M23",1]);
AGR.API("M24G1-p276B0",[1,3,"prim","M22.2",2]);
AGR.API("M24G1-p3795B0",[1,5,"prim","2^6:(L3(2)xS3)",7]);
AGR.API("M24G1-p759B0",[1,4,"prim","2^4:A8",3]);
AGR.API("McLG1-p113400B0",[1,39,"prim","M11",11]);
AGR.API("McLG1-p15400aB0",[1,5,"prim","3^(1+4)_+:2S5",5]);
AGR.API("McLG1-p15400bB0",[1,10,"prim","3^4:M10",6]);
AGR.API("McLG1-p2025aB0",[1,4,"prim","M22",2]);
AGR.API("McLG1-p2025bB0",[1,4,"prim","M22",3]);
AGR.API("McLG1-p22275aB0",[1,13,"prim","L3(4).2_2",7]);
AGR.API("McLG1-p22275bB0",[1,6,"prim","2.A8",8]);
AGR.API("McLG1-p22275cB0",[1,13,"prim","2^4:A7",10]);
AGR.API("McLG1-p22275dB0",[1,13,"prim","2^4:A7",9]);
AGR.API("McLG1-p275B0",[1,3,"prim","U4(3)",1]);
AGR.API("McLG1-p299376B0",[1,114,"prim","5^(1+2)_+:3:8",12]);
AGR.API("McLG1-p7128B0",[1,5,"prim","U3(5)",4]);
AGR.API("McLd2G1-p22275aB0",[1,11,"prim","L3(4).2^2",6]);
AGR.API("McLd2G1-p275B0",[1,3,"prim","U4(3).2_3",2]);
AGR.API("McLd2G1-p4050B0",[1,8,"imprim","M22 < McL"]);
AGR.API("McLd2G1-p44550B0",[1,26,"imprim","2^4:A7 < McL"]);
AGR.API("McLd2G1-p7128B0",[1,5,"prim","U3(5).2",3]);
AGR.API("Mmax13G0-p3369B0",[0,[9,3360]]);
AGR.API("Mmax15q1G0-p6561B0",[1,4,"imprim","3^6:(L3(3)xSD16) < 3^(2+6):(L3(3)xSD16)"]);
AGR.API("Mmax15q2G0-p1404B0",[1,10,"imprim","3^(5+4):(3^2.2.S4x2^2) < 3^(6+6):(3^2.2.S4xSD16)"]);
AGR.API("Mmax15q3G0-p108B0",[1,4,"imprim","2x3^3.(L3(3)x2) < 3^6:(L3(3)xD8)"]);
AGR.API("Mmax16G0-p78125B0",[1,6,"imprim","2.J2.4 < (5x2.J2).4"]);
AGR.API("Mmax17G0-p2065B0",[0,[7,2058]]);
AGR.API("Mmax18G0-p17B0",[0,[5,12]]);
AGR.API("Mmax19G0-p46500B0",[1,115,"imprim","5^(2+2).(2x5^2:(4x2)) < 5^(3+3).(2x5^2:GL2(5))"]);
AGR.API("Mmax19G0-p7750B0",[1,7,"imprim","5^(2+3).GL2(5) < 5^(3+3).(2x5^2:GL2(5))"]);
AGR.API("Mmax19G0-p96875B0",[1,28,"imprim","5^3.(2xGL2(5)) < 5^(3+3).(2x5^2:GL2(5))"]);
AGR.API("Mmax20G0-p30B0",[1,3,"imprim","(A6xA6x3^2:4).(2xD8) < (A6xA6xA6).(2xD8)"]);
AGR.API("Mmax21G0-p3653B0",[0,[5,3648]]);
AGR.API("Mmax21G0-p518B0",[0,[5,513]]);
AGR.API("Mmax22G0-p15625B0",[1,9,"imprim","5^2:(S3xGL2(5)) < 5^4:(S3xGL2(5))"]);
AGR.API("Mmax22G0-p750B0",[1,5,"imprim","5^(3+2):(S3x4x5:4) < 5^(2+2+4):(S3x4x5:4)"]);
AGR.API("Mmax23G0-p184B0",[0,[14,170]]);
AGR.API("Mmax23G0-p524B0",[0,[14,510]]);
AGR.API("Mmax24G0-p16807B0",[1,8,"imprim","3x2.S7 < (7:3x2.A7).2"]);
AGR.API("Mmax25G0-p151B0",[0,[25,126]]);
AGR.API("Mmax26G0-p36B0",[0,[12,24]]);
AGR.API("Mmax27G0-p17B0",[0,[7,10]]);
AGR.API("Mmax28G0-p625B0",[2,2,"prim","(3x2.L2(25)).2","???"]);
AGR.API("Mmax29G0-p2401B0",[1,5,"imprim","(7:3xSL2(7)):2 < 7^3:GL2(7)"]);
AGR.API("Mmax29G0-p392B0",[1,4,"imprim","7^(1+2)_+:(6x7:6) < 7^(2+1+2):(6x7:6)"]);
AGR.API("Mmax30G0-p21B0",[0,[10,11]]);
AGR.API("Mmax31G0-p15B0",[1,3,"imprim","S4x(S5xS5):2 < S5x(S5xS5):2"]);
AGR.API("Mmax32G0-p24B0",[1,3,"imprim","(L2(11)x11:5):2 < (L2(11)xL2(11)):2"]);
AGR.API("Mmax33G0-p169B0",[2,2,"prim","2.L2(13).4","???"]);
AGR.API("Mmax34G0-p57B0",[0,[8,49]]);
AGR.API("Mmax35G0-p39B0",[0,[13,26]]);
AGR.API("Mmax36G0-p2197B0",[1,11,"imprim","3x4S4 < (13x4S4):3"]);
AGR.API("Mmax39G0-p121B0",[2,2,"prim","5x2A5",5]);
AGR.API("Mmax41G0-p49B0",[2,2,"prim","2.L2(7)",4]);
AGR.API("Mmax43G0-p41B0",[2,2,"prim","40",3]);
AGR.API("O10m2G1-p495B0",[1,3,"prim","2^8:O8-(2)",1]);
AGR.API("O10m2G1-p528B0",[1,3,"prim","S8(2)",2]);
AGR.API("O10m2d2G1-p104448B0",[1,6,"prim","S12",8]);
AGR.API("O10m2d2G1-p495B0",[1,3,"prim","2^8:O8-(2):2",2]);
AGR.API("O10m2d2G1-p528B0",[1,3,"prim","S8(2)x2",3]);
AGR.API("O10p2G1-p19840B0",[1,5,"prim","(3xO8-(2)):2",5]);
AGR.API("O10p2G1-p2295aB0",[1,3,"prim","2^10:L5(2)",3]);
AGR.API("O10p2G1-p2295bB0",[1,3,"prim","2^10:L5(2)",4]);
AGR.API("O10p2G1-p23715B0",[1,6,"prim","2^(1+12)_+:(S3xA8)",6]);
AGR.API("O10p2G1-p39680B0",[1,8,"imprim","3xO8-(2)"]);
AGR.API("O10p2G1-p496B0",[1,3,"prim","S8(2)",1]);
AGR.API("O10p2G1-p527B0",[1,3,"prim","2^8:O8+(2)",2]);
AGR.API("O10p2d2G1-p4590B0",[1,6,"imprim","2^10:L5(2) < O10+(2)"]);
AGR.API("O10p2d2G1-p496B0",[1,3,"prim","S8(2)x2",2]);
AGR.API("O10p2d2G1-p527B0",[1,3,"prim","2^8:O8+(2):2",3]);
AGR.API("O73G1-p1080aB0",[1,3,"prim","G2(3)",4]);
AGR.API("O73G1-p1080bB0",[1,3,"prim","G2(3)",5]);
AGR.API("O73G1-p1120B0",[1,4,"prim","3^(3+3):L3(3)",6]);
AGR.API("O73G1-p351B0",[1,3,"prim","2.U4(3).2_2",1]);
AGR.API("O73G1-p3640B0",[1,5,"prim","3^(1+6)_+:(2A4xA4).2",9]);
AGR.API("O73G1-p364B0",[1,3,"prim","3^5:U4(2):2",2]);
AGR.API("O73G1-p378B0",[1,3,"prim","L4(3).2_2",3]);
AGR.API("O73d2G1-p351B0",[1,3,"prim","2.U4(3).(2^2)_{122}",2]);
AGR.API("O8m2G1-p1071B0",[1,5,"prim","2^(1+8)_+:(S3xA5)",4]);
AGR.API("O8m2G1-p119B0",[1,3,"prim","2^6:U4(2)",1]);
AGR.API("O8m2G1-p136B0",[1,3,"prim","S6(2)",2]);
AGR.API("O8m2G1-p1632B0",[1,5,"prim","(3xA8):2",5]);
AGR.API("O8m2G1-p24192B0",[1,16,"prim","L2(16):2",6]);
AGR.API("O8m2G1-p45696B0",[1,47,"prim","(S3xS3xA5):2",7]);
AGR.API("O8m2G1-p765B0",[1,4,"prim","2^(3+6):(L3(2)x3)",3]);
AGR.API("O8m2d2G1-p119B0",[1,3,"prim","2^6:U4(2):2",2]);
AGR.API("O8m3G1-p1066B0",[1,3,"prim","3^6:2.U4(3).2",1]);
AGR.API("O8m3V4G1-p1066B0",[1,3,"prim","3^6:2.U4(3).D8",4]);
AGR.API("O8m3d2aG1-p1066B0",[1,3,"prim","3^6:2.U4(3).(2^2)_{122}",2]);
AGR.API("O8m3d2cG1-p1066B0",[1,3,"prim","3^6:2.U4(3).(2^2)_{133}",2]);
AGR.API("O8m3d2cG2-p1066B0",[1,3,"prim","3^6:2.U4(3).(2^2)_{133}",2]);
AGR.API("O8p3G1-p1080aB0",[1,3,"prim","O7(3)",1]);
AGR.API("O8p3G1-p1080bB0",[1,3,"prim","O7(3)",2]);
AGR.API("O8p3G1-p1080cB0",[1,3,"prim","O7(3)",3]);
AGR.API("O8p3G1-p1080dB0",[1,3,"prim","O7(3)",4]);
AGR.API("O8p3G1-p1080eB0",[1,3,"prim","O7(3)",5]);
AGR.API("O8p3G1-p1080fB0",[1,3,"prim","O7(3)",6]);
AGR.API("O8p3G1-p1120aB0",[1,3,"prim","3^6:L4(3)",7]);
AGR.API("O8p3G1-p1120bB0",[1,3,"prim","3^6:L4(3)",8]);
AGR.API("O8p3G1-p1120cB0",[1,3,"prim","3^6:L4(3)",9]);
AGR.API("O8p3G1-p28431aB0",[1,6,"prim","O8+(2)",10]);
AGR.API("O8p3G1-p28431bB0",[1,6,"prim","O8+(2)",11]);
AGR.API("O8p3G1-p28431cB0",[1,6,"prim","O8+(2)",12]);
AGR.API("O8p3G1-p28431dB0",[1,6,"prim","O8+(2)",13]);
AGR.API("O8p3G1-p36400B0",[1,7,"prim","3^(1+8)_+:2(A4xA4xA4).2",14]);
AGR.API("O8p3S4G2-p3360B0",[1,5,"imprim","3^6:L4(3).D8 < O8+(3).D8"]);
AGR.API("O8p3S4G2-p6480B0",[1,6,"imprim","O7(3).2x2 < O8+(3).(2^2)_{122}"]);
AGR.API("ONG1-p122760aB0",[1,5,"prim","L3(7).2",1]);
AGR.API("ONd2G1-p245520B0",[1,9,"imprim","L3(7).2 < ON"]);
AGR.API("PGL29G1-p10B0",[3,2,"prim","3^2:8",2]);
AGR.API("R27G1-p19684B0",[2,2,"prim","3^(3+6):26",1]);
AGR.API("R27d3G1-p19684B0",[2,2,"prim","3^(3+6):26:3",2]);
AGR.API("RuG1-p4060B0",[1,3,"prim","2F4(2)'.2",1]);
AGR.API("S102G1-p1023B0",[1,3,"prim","2^9.S8(2)",3]);
AGR.API("S102G1-p1056B0",[1,4,"imprim","O10+(2) < O10+(2).2"]);
AGR.API("S102G1-p496B0",[2,2,"prim","O10-(2).2",1]);
AGR.API("S102G1-p528B0",[2,2,"prim","O10+(2).2",2]);
AGR.API("S102G1-p992B0",[1,4,"imprim","O10-(2) < O10-(2).2"]);
AGR.API("S10G1-p10B0",[10,2,"prim","S9",2]);
AGR.API("S11G1-p11B0",[11,2,"prim","S10",2]);
AGR.API("S12G1-p10395B0",[1,11,"prim","2^5:S6",9]);
AGR.API("S12G1-p12B0",[12,2,"prim","S11",2]);
AGR.API("S12G1-p15400B0",[1,12,"prim","3^4:2^3.S4",10]);
AGR.API("S12G1-p220B0",[1,4,"prim","(A9x3):2",4]);
AGR.API("S12G1-p462B0",[1,4,"prim","(A6xA6):2^2",5]);
AGR.API("S12G1-p495B0",[1,5,"prim","(A8xA4):2",6]);
AGR.API("S12G1-p5040B0",[1,8,"imprim","M12 < A12"]);
AGR.API("S12G1-p5775B0",[1,9,"prim","2^6:3^3:S4",8]);
AGR.API("S12G1-p66B0",[1,3,"prim","S10",3]);
AGR.API("S12G1-p792B0",[1,6,"prim","(A7xA5):2",7]);
AGR.API("S13G1-p13B0",[13,2,"prim","S12",2]);
AGR.API("S13G1-p78B0",[1,3,"prim","S11x2",3]);
AGR.API("S14G1-p1001B0",[1,5,"prim","S10xS4",5]);
AGR.API("S14G1-p14B0",[14,2,"prim","S13",2]);
AGR.API("S14G1-p1716B0",[1,4,"prim","(S7xS7):2",6]);
AGR.API("S14G1-p2002B0",[1,6,"prim","S9xS5",7]);
AGR.API("S14G1-p3003B0",[1,7,"prim","S8xS6",8]);
AGR.API("S14G1-p364B0",[1,4,"prim","S11xS3",4]);
AGR.API("S14G1-p91B0",[1,3,"prim","S12x2",3]);
AGR.API("S15G1-p105B0",[1,3,"prim","S13x2",3]);
AGR.API("S15G1-p1365B0",[1,5,"prim","S11xS4",5]);
AGR.API("S15G1-p15B0",[15,2,"prim","S14",2]);
AGR.API("S15G1-p455B0",[1,4,"prim","S12xS3",4]);
AGR.API("S16G1-p120B0",[1,3,"prim","S14x2",3]);
AGR.API("S16G1-p16B0",[16,2,"prim","S15",2]);
AGR.API("S16G1-p1820B0",[1,5,"prim","S12xS4",5]);
AGR.API("S16G1-p560B0",[1,4,"prim","S13xS3",4]);
AGR.API("S17G1-p136B0",[1,3,"prim","S15x2",3]);
AGR.API("S17G1-p17B0",[17,2,"prim","S16",2]);
AGR.API("S17G1-p2380B0",[1,5,"prim","S13xS4",5]);
AGR.API("S17G1-p680B0",[1,4,"prim","S14xS3",4]);
AGR.API("S18G1-p153B0",[1,3,"prim","S16x2",3]);
AGR.API("S18G1-p18B0",[18,2,"prim","S17",2]);
AGR.API("S18G1-p3060B0",[1,5,"prim","S14xS4",5]);
AGR.API("S18G1-p816B0",[1,4,"prim","S15xS3",4]);
AGR.API("S19G1-p171B0",[1,3,"prim","S17x2",3]);
AGR.API("S19G1-p19B0",[19,2,"prim","S18",2]);
AGR.API("S19G1-p969B0",[1,4,"prim","S16xS3",4]);
AGR.API("S20G1-p190B0",[1,3,"prim","S18x2",3]);
AGR.API("S20G1-p20B0",[20,2,"prim","S19",2]);
AGR.API("S21G1-p210B0",[1,3,"prim","S19x2",3]);
AGR.API("S21G1-p21B0",[21,2,"prim","S20",2]);
AGR.API("S22G1-p22B0",[22,2,"prim","S21",2]);
AGR.API("S22G1-p231B0",[1,3,"prim","S20x2",3]);
AGR.API("S23G1-p23B0",[23,2,"prim","S22",2]);
AGR.API("S23G1-p253B0",[1,3,"prim","S21x2",3]);
AGR.API("S44G1-p120bB0",[1,3,"prim","L2(16):2",4]);
AGR.API("S44G1-p85aB0",[1,3,"prim","2^6:(3xA5)",1]);
AGR.API("S44d4G1-p170B0",[1,5,"imprim","2^6:(3xA5):2 < S4(4).2"]);
AGR.API("S45G1-p156aB0",[1,3,"prim","5^(1+2)_+:4A5",1]);
AGR.API("S45G1-p156bB0",[1,3,"prim","5^3:(2xA5).2",2]);
AGR.API("S45G1-p300B0",[1,4,"prim","L2(25):2_2",3]);
AGR.API("S45G1-p325B0",[1,4,"prim","2.(A5xA5).2",4]);
AGR.API("S47G1-p1176B0",[1,5,"prim","L2(49).2_2",3]);
AGR.API("S47G1-p1225B0",[1,5,"prim","2.(L2(7)xL2(7)).2",4]);
AGR.API("S47G1-p400aB0",[1,3,"prim","7^(1+2)_+.(3xSL(2,7))",1]);
AGR.API("S47G1-p400bB0",[1,3,"prim","7^3:(3xPGL(2,7))",2]);
AGR.API("S47d2G1-p400aB0",[1,3,"prim","7^(1+2)_+:GL(2,7)",1]);
AGR.API("S47d2G1-p400bB0",[1,3,"prim","7^3:(6xPGL(2,7))",2]);
AGR.API("S5G1-p10B0",[1,3,"prim","S3x2",4]);
AGR.API("S5G1-p5B0",[5,2,"prim","S4",2]);
AGR.API("S5G1-p6B0",[3,2,"prim","5:4",3]);
AGR.API("S62G1-p120B0",[1,3,"prim","U3(3):2",4]);
AGR.API("S62G1-p126B0",[1,5,"imprim","2^5:A6 < 2^5:S6"]);
AGR.API("S62G1-p135B0",[1,4,"prim","2^6:L3(2)",5]);
AGR.API("S62G1-p240B0",[1,5,"imprim","U3(3) < U3(3):2"]);
AGR.API("S62G1-p288B0",[1,5,"imprim","S7 < S8"]);
AGR.API("S62G1-p28B0",[2,2,"prim","U4(2).2",1]);
AGR.API("S62G1-p315B0",[1,5,"prim","2.[2^6]:(S3xS3)",6]);
AGR.API("S62G1-p336B0",[1,5,"prim","S3xS6",7]);
AGR.API("S62G1-p36B0",[2,2,"prim","S8",2]);
AGR.API("S62G1-p378aB0",[1,8,"imprim","2x2^4:S5 < 2^5:S6"]);
AGR.API("S62G1-p378bB0",[1,6,"imprim","2^5:S5 < 2^5:S6"]);
AGR.API("S62G1-p56B0",[1,4,"imprim","U4(2) < U4(2).2"]);
AGR.API("S62G1-p63B0",[1,3,"prim","2^5:S6",3]);
AGR.API("S62G1-p72B0",[1,4,"imprim","A8 < S8"]);
AGR.API("S62G1-p960B0",[1,6,"prim","L2(8).3",8]);
AGR.API("S63G1-p1120B0",[1,4,"prim","3^6:L3(3)",2]);
AGR.API("S63G1-p3640B0",[1,5,"prim","3^(3+4):2(S4xA4)",3]);
AGR.API("S63G1-p364B0",[1,3,"prim","3^(1+4)_+.2U4(2)",1]);
AGR.API("S63G1-p7371B0",[1,6,"prim","2.(A4xU4(2))",4]);
AGR.API("S63d2G1-p1120B0",[1,4,"prim","3^6:(L3(3)x2)",3]);
AGR.API("S63d2G1-p3640B0",[1,5,"prim","3^(3+4):2(S4xS4)",4]);
AGR.API("S63d2G1-p364B0",[1,3,"prim","3^(1+4)_+:2.U4(2).2",2]);
AGR.API("S63d2G1-p7371B0",[1,6,"prim","2(A4xU4(2)).2",5]);
AGR.API("S6G1-p10B0",[2,2,"prim","3^2:D8",4]);
AGR.API("S6G1-p15aB0",[1,3,"prim","S4x2",5]);
AGR.API("S6G1-p15bB0",[1,3,"prim","S4x2",6]);
AGR.API("S6G1-p6aB0",[6,2,"prim","A5.2",2]);
AGR.API("S6G1-p6bB0",[6,2,"prim","A5.2",3]);
AGR.API("S7G1-p120B0",[1,7,"prim","7:6",5]);
AGR.API("S7G1-p21B0",[1,3,"prim","S5x2",3]);
AGR.API("S7G1-p30B0",[1,4,"imprim","L2(7) < A7"]);
AGR.API("S7G1-p35B0",[1,4,"prim","S4xS3",4]);
AGR.API("S7G1-p7B0",[7,2,"prim","S6",2]);
AGR.API("S82G1-p120B0",[2,2,"prim","O8-(2).2",1]);
AGR.API("S82G1-p136B0",[2,2,"prim","O8+(2).2",2]);
AGR.API("S82G1-p2295B0",[1,5,"prim","2^10:A8",4]);
AGR.API("S82G1-p240B0",[1,4,"imprim","O8-(2) < O8-(2).2"]);
AGR.API("S82G1-p255B0",[1,3,"prim","2^7:S6(2)",3]);
AGR.API("S82G1-p272B0",[1,4,"imprim","O8+(2) < O8+(2).2"]);
AGR.API("S82G1-p5355B0",[1,6,"prim","2^(3+8):(S3xS6)",5]);
AGR.API("S8G1-p8B0",[8,2,"prim","S7",2]);
AGR.API("S9G1-p9B0",[9,2,"prim","S8",2]);
AGR.API("SuzG1-p135135B0",[1,9,"prim","2^(1+6)_-.U4(2)",4]);
AGR.API("SuzG1-p1782B0",[1,3,"prim","G2(4)",1]);
AGR.API("SuzG1-p22880B0",[1,5,"prim","3_2.U4(3).2_3'",2]);
AGR.API("SuzG1-p232960B0",[1,13,"prim","3^5:M11",5]);
AGR.API("SuzG1-p32760B0",[1,6,"prim","U5(2)",3]);
AGR.API("SuzG1-p370656B0",[1,15,"prim","J2:2",6]);
AGR.API("SuzG1-p405405B0",[1,13,"prim","2^(4+6):3A6",7]);
AGR.API("Suzd2G1-p1782B0",[1,3,"prim","G2(4):2",2]);
AGR.API("Sz32G1-p1025B0",[2,2,"prim","2^(5+5):31",1]);
AGR.API("Sz32G1-p198400B0",[1,1282,"prim","41:4",2]);
AGR.API("Sz32d5G1-p1025B0",[2,2,"prim","2^(5+5):31:5",2]);
AGR.API("Sz8G1-p1456B0",[1,79,"prim","5:4",3]);
AGR.API("Sz8G1-p2080B0",[1,165,"prim","D14",4]);
AGR.API("Sz8G1-p520B0",[1,12,"imprim","2^3:7 < 2^(3+3):7"]);
AGR.API("Sz8G1-p560B0",[1,17,"prim","13:4",2]);
AGR.API("Sz8G1-p65B0",[2,2,"prim","2^(3+3):7",1]);
AGR.API("Sz8d3G1-p1456B0",[1,27,"prim","5:4x3",4]);
AGR.API("Sz8d3G1-p2080B0",[1,59,"prim","7:6",5]);
AGR.API("Sz8d3G1-p520B0",[1,8,"imprim","2^3:7:3 < 2^(3+3):7:3"]);
AGR.API("Sz8d3G1-p560B0",[1,7,"prim","13:12",3]);
AGR.API("Sz8d3G1-p65B0",[2,2,"prim","2^(3+3):7:3",2]);
AGR.API("TD42G1-p819B0",[1,4,"prim","2^(1+8)_+:L2(8)",1]);
AGR.API("TF42G1-p12480B0",[1,24,"prim","A6.2^2",7]);
AGR.API("TF42G1-p14976B0",[1,25,"prim","5^2:4A4",8]);
AGR.API("TF42G1-p1600B0",[1,4,"prim","L3(3).2",1]);
AGR.API("TF42G1-p1755B0",[1,5,"prim","2.[2^8]:5:4",3]);
AGR.API("TF42G1-p2304B0",[1,7,"prim","L2(25)",4]);
AGR.API("TF42G1-p2925B0",[1,6,"prim","2^2.[2^8]:S3",5]);
AGR.API("TF42d2G1-p1755B0",[1,5,"prim","2.[2^9]:5:4",2]);
AGR.API("TF42d2G1-p2304B0",[1,6,"prim","L2(25).2_3",3]);
AGR.API("U311G1-p1332B0",[2,2,"prim","11^(1+2)_+:40",1]);
AGR.API("U311d2G1-p1332B0",[2,2,"prim","11^(1+2)_+:(5x8:2)",2]);
AGR.API("U313G1-p2198B0",[2,2,"prim","13^(1+2)_+:168",1]);
AGR.API("U316G1-p4097B0",[2,2,"prim","2^(4+8):255",1]);
AGR.API("U33G1-p28B0",[2,2,"prim","3^(1+2)_+:8",1]);
AGR.API("U33G1-p36B0",[1,4,"prim","L2(7)",2]);
AGR.API("U33G1-p63aB0",[1,4,"prim","4.S4",3]);
AGR.API("U33G1-p63bB0",[1,5,"prim","4^2:S3",4]);
AGR.API("U33d2G1-p63bB0",[1,4,"prim","4^2:D12",5]);
AGR.API("U34G1-p1600B0",[1,48,"prim","13:3",4]);
AGR.API("U34G1-p208B0",[1,5,"prim","5xA5",2]);
AGR.API("U34G1-p416B0",[1,9,"prim","5^2:S3",3]);
AGR.API("U34G1-p65B0",[2,2,"prim","2^(2+4):15",1]);
AGR.API("U34d2G1-p1600B0",[1,28,"prim","13:6",5]);
AGR.API("U34d2G1-p208B0",[1,5,"prim","A5xD10",3]);
AGR.API("U34d2G1-p416B0",[1,7,"prim","5^2:D12",4]);
AGR.API("U34d2G1-p65B0",[2,2,"prim","2^(2+4):(3xD10)",2]);
AGR.API("U34d4G1-p1600B0",[1,15,"prim","13:12",5]);
AGR.API("U34d4G1-p208B0",[1,4,"prim","(D10xA5).2",3]);
AGR.API("U34d4G1-p416B0",[1,5,"prim","5^2:(4xS3)",4]);
AGR.API("U34d4G1-p65B0",[2,2,"prim","2^(2+4):(3xD10).2",2]);
AGR.API("U35G1-p50B0",[1,3,"prim","A7",1]);
AGR.API("U35d2G1-p126B0",[2,2,"prim","5^(1+2)_+:8:2",3]);
AGR.API("U35d2G1-p175B0",[1,4,"prim","A6.2^2",4]);
AGR.API("U35d2G1-p50B0",[1,3,"prim","S7",2]);
AGR.API("U35d2G1-p525B0",[1,7,"prim","2S5.2",5]);
AGR.API("U35d2G1-p750B0",[1,9,"prim","L2(7).2",6]);
AGR.API("U37G1-p1032B0",[1,6,"imprim","7^(1+2):16 < 7^(1+2):48"]);
AGR.API("U37G1-p1376B0",[1,8,"imprim","7^(1+2):12 < 7^(1+2):48"]);
AGR.API("U37G1-p14749B0",[1,60,"prim","8^2:S3",3]);
AGR.API("U37G1-p16856B0",[1,114,"prim","L2(7):2",4]);
AGR.API("U37G1-p2064B0",[1,12,"imprim","7^(1+2):8 < 7^(1+2):48"]);
AGR.API("U37G1-p2107B0",[1,8,"prim","2(L2(7)x4).2",2]);
AGR.API("U37G1-p344B0",[2,2,"prim","7^(1+2):48",1]);
AGR.API("U37G1-p43904B0",[1,362,"prim","43:3",5]);
AGR.API("U37G1-p688B0",[1,4,"imprim","7^(1+2):24 < 7^(1+2):48"]);
AGR.API("U38E9G1-p3648B0",[1,5,"prim","(9xL2(8)):3",3]);
AGR.API("U38E9G1-p513B0",[2,2,"prim","2^(3+6):63:3",2]);
AGR.API("U38G1-p3648B0",[1,11,"prim","3xL2(8)",2]);
AGR.API("U38G1-p513B0",[2,2,"prim","2^(3+6):21",1]);
AGR.API("U38S3G1-p3648B0",[1,9,"prim","D18xL2(8)",4]);
AGR.API("U38S3G1-p513B0",[2,2,"prim","2^(3+6):(7xD18)",3]);
AGR.API("U38S3x3G1-p3648B0",[1,5,"prim","(D18xL2(8)):3",5]);
AGR.API("U38S3x3G1-p513B0",[2,2,"prim","2^(3+6):(7xD18):3",4]);
AGR.API("U38d2G1-p3648B0",[1,10,"prim","S3xL2(8)",3]);
AGR.API("U38d2G1-p513B0",[2,2,"prim","2^(3+6):(7xS3)",2]);
AGR.API("U38d3aG1-p3648B0",[1,7,"prim","3xL2(8):3",3]);
AGR.API("U38d3aG1-p513B0",[2,2,"prim","2^(3+6):(7:3x3)",2]);
AGR.API("U38d3bG1-p3648B0",[1,9,"prim","9xL2(8)",3]);
AGR.API("U38d3bG1-p513B0",[2,2,"prim","2^(3+6):63",2]);
AGR.API("U38d3cG1-p3648B0",[1,5,"prim","L2(8):9",3]);
AGR.API("U38d3cG1-p513B0",[2,2,"prim","2^(3+6):7:9",2]);
AGR.API("U38d6G1-p3648B0",[1,6,"prim","S3xL2(8):3",4]);
AGR.API("U38d6G1-p513B0",[2,2,"prim","2^(3+6):(7:3xS3)",3]);
AGR.API("U39G1-p730B0",[2,2,"prim","3^(2+4):80",1]);
AGR.API("U42G1-p27B0",[1,3,"prim","2^4:A5",1]);
AGR.API("U42G1-p36B0",[1,3,"prim","S6",2]);
AGR.API("U42G1-p40aB0",[1,3,"prim","3^(1+2)+:2A4",3]);
AGR.API("U42G1-p40bB0",[1,3,"prim","3^3:S4",4]);
AGR.API("U42G1-p45B0",[1,3,"prim","2.(A4xA4).2",5]);
AGR.API("U42d2G1-p27B0",[1,3,"prim","2^4:S5",2]);
AGR.API("U42d2G1-p36B0",[1,3,"prim","S6x2",3]);
AGR.API("U42d2G1-p40aB0",[1,3,"prim","3^(1+2)_+:2S4",4]);
AGR.API("U42d2G1-p40bB0",[1,3,"prim","3^3:(S4x2)",5]);
AGR.API("U42d2G1-p45B0",[1,3,"prim","2.(A4xA4).2^2",6]);
AGR.API("U43D8G1-p112B0",[1,3,"prim","3^4:(2xA6.2^2)",4]);
AGR.API("U43D8G1-p1134B0",[1,8,"imprim","2^5:S6 < U4(3).(2^2)_{122}"]);
AGR.API("U43D8G1-p252B0",[1,5,"imprim","U4(2).2x2 < U4(3).(2^2)_{122}"]);
AGR.API("U43D8G1-p280B0",[1,3,"prim","3^(1+4)_+.2^(1+4)_-.D12",5]);
AGR.API("U43D8G1-p2835B0",[1,9,"prim","4(S4xS4).2^2",7]);
AGR.API("U43D8G1-p324B0",[1,5,"imprim","L3(4):2^2 < U4(3).(2^2)_{133}"]);
AGR.API("U43D8G1-p4536B0",[1,15,"prim","(A6.2^2x2).2",8]);
AGR.API("U43D8G1-p5184B0",[1,17,"imprim","S7 < U4(3).(2^2)_{122}"]);
AGR.API("U43D8G1-p540B0",[1,4,"prim","(U3(3)x4):2",6]);
AGR.API("U43D8G1-p8505B0",[1,22,"prim","4^3.(2xS4)",9]);
AGR.API("U43D8G1-p9072B0",[1,24,"imprim","A6.2^2x2 < (A6.2^2x2).2"]);
AGR.API("U44G1-p1040B0",[1,5,"prim","S4(4)",2]);
AGR.API("U44G1-p1105B0",[1,3,"prim","2^(2+8):(15xA5)",3]);
AGR.API("U44G1-p325B0",[1,3,"prim","2^8:(3xL2(16))",1]);
AGR.API("U44G1-p3264B0",[1,5,"prim","5xU3(4)",4]);
AGR.API("U45G1-p1575B0",[1,4,"prim","S4(5).2",2]);
AGR.API("U45G1-p756B0",[1,3,"prim","5^4:(L2(25)x4)",1]);
AGR.API("U52G1-p1408B0",[1,7,"prim","3^4:S5",4]);
AGR.API("U52G1-p165B0",[1,3,"prim","2^(1+6):3^(1+2):2A4",1]);
AGR.API("U52G1-p176B0",[1,3,"prim","3xU4(2)",2]);
AGR.API("U52G1-p20736B0",[1,76,"prim","L2(11)",6]);
AGR.API("U52G1-p297B0",[1,3,"prim","2^(4+4):(3xA5)",3]);
AGR.API("U52G1-p3520B0",[1,12,"prim","S3x3^(1+2)+:2A4",5]);
AGR.API("U52d2G1-p1408B0",[1,6,"prim","3^4:(2xS5)",5]);
AGR.API("U52d2G1-p165B0",[1,3,"prim","2^(1+6)_-:3^(1+2)_+:2S4",2]);
AGR.API("U52d2G1-p176B0",[1,3,"prim","(3xU4(2)):2",3]);
AGR.API("U52d2G1-p20736B0",[1,43,"prim","L2(11).2",7]);
AGR.API("U52d2G1-p297B0",[1,3,"prim","2^(4+4):(3xA5):2",4]);
AGR.API("U52d2G1-p3520B0",[1,12,"prim","S3x3^(1+2)_+:2S4",6]);
AGR.API("U62G1-p12474B0",[1,8,"imprim","2^(4+8):(3xA5) < 2^(4+8):(S3xA5)"]);
AGR.API("U62G1-p1408aB0",[1,3,"prim","U4(3).2_2",4]);
AGR.API("U62G1-p1408bB0",[1,3,"prim","U4(3).2_2",5]);
AGR.API("U62G1-p1408cB0",[1,3,"prim","U4(3).2_2",6]);
AGR.API("U62G1-p20736aB0",[1,8,"prim","M22",11]);
AGR.API("U62G1-p20736bB0",[1,8,"prim","M22",12]);
AGR.API("U62G1-p20736cB0",[1,8,"prim","M22",13]);
AGR.API("U62G1-p2816aB0",[1,5,"imprim","U4(3) < U4(3).2_2"]);
AGR.API("U62G1-p2816bB0",[1,5,"imprim","U4(3) < U4(3).2_2"]);
AGR.API("U62G1-p2816cB0",[1,5,"imprim","U4(3) < U4(3).2_2"]);
AGR.API("U62G1-p59136B0",[1,15,"prim","S3xU4(2)",14]);
AGR.API("U62G1-p6237B0",[1,5,"prim","2^(4+8):(S3xA5)",7]);
AGR.API("U62G1-p6336aB0",[1,4,"prim","S6(2)",8]);
AGR.API("U62G1-p6336bB0",[1,4,"prim","S6(2)",9]);
AGR.API("U62G1-p6336cB0",[1,4,"prim","S6(2)",10]);
AGR.API("U62G1-p672B0",[1,3,"prim","U5(2)",1]);
AGR.API("U62G1-p693B0",[1,3,"prim","2^(1+8)_+:U4(2)",2]);
AGR.API("U62G1-p891B0",[1,4,"prim","2^9.L3(4)",3]);
AGR.API("U62S3G1-p693B0",[1,3,"prim","2^(1+8)_+:(U4(2)x3):2",4]);
AGR.API("U62S3G1-p891B0",[1,4,"prim","2^9.L3(4).S3",5]);
AGR.API("U62d2G1-p1408B0",[1,3,"prim","U4(3).(2^2)_{122}",5]);
AGR.API("U62d2G1-p20736B0",[1,8,"prim","M22.2",8]);
AGR.API("U62d2G1-p6237B0",[1,5,"prim","2^(4+8).(S3xS5)",6]);
AGR.API("U62d2G1-p6336B0",[1,4,"prim","S6(2)x2",7]);
AGR.API("U62d2G1-p672B0",[1,3,"prim","U5(2).2",2]);
AGR.API("U62d2G1-p693B0",[1,3,"prim","2^(1+8)_+:U4(2).2",3]);
AGR.API("U62d2G1-p891B0",[1,4,"prim","2^9.L3(4).2",4]);


#############################################################################
##
##  precomputed character data
##
AGR.CHAR("2F4(2)'","TF42G1-Zr52B0",0,[2,3],"26ab");
AGR.CHAR("2F4(2)'","TF42G1-Zr78B0",0,6,"78a");
AGR.CHAR("2F4(2)'","TF42G1-f13r27aB0",13,4,"27a");
AGR.CHAR("2F4(2)'","TF42G1-f13r27bB0",13,5,"27b");
AGR.CHAR("2F4(2)'","TF42G1-f13r52B0",13,[2,3],"26ab");
AGR.CHAR("2F4(2)'","TF42G1-f13r78B0",13,6,"78a");
AGR.CHAR("2F4(2)'","TF42G1-f169r26B0",13,2,"26a");
AGR.CHAR("2F4(2)'","TF42G1-f25r109aB0",5,7,"109a");
AGR.CHAR("2F4(2)'","TF42G1-f25r109bB0",5,8,"109b");
AGR.CHAR("2F4(2)'","TF42G1-f25r26aB0",5,2,"26a");
AGR.CHAR("2F4(2)'","TF42G1-f25r26bB0",5,3,"26b");
AGR.CHAR("2F4(2)'","TF42G1-f2r246B0",2,3,"246a");
AGR.CHAR("2F4(2)'","TF42G1-f2r26B0",2,2,"26a");
AGR.CHAR("2F4(2)'","TF42G1-f3r124aB0",3,7,"124a");
AGR.CHAR("2F4(2)'","TF42G1-f3r124bB0",3,8,"124b");
AGR.CHAR("2F4(2)'","TF42G1-f3r26aB0",3,2,"26a");
AGR.CHAR("2F4(2)'","TF42G1-f3r26bB0",3,3,"26b");
AGR.CHAR("2F4(2)'","TF42G1-f3r54B0",3,[4,5],"27ab");
AGR.CHAR("2F4(2)'","TF42G1-f3r77B0",3,6,"77a");
AGR.CHAR("2F4(2)'","TF42G1-f4r2048aB0",2,4,"2048a");
AGR.CHAR("2F4(2)'","TF42G1-f5r218B0",5,[7,8],"109ab");
AGR.CHAR("2F4(2)'","TF42G1-f5r27aB0",5,4,"27a");
AGR.CHAR("2F4(2)'","TF42G1-f5r27bB0",5,5,"27b");
AGR.CHAR("2F4(2)'","TF42G1-f5r52B0",5,[2,3],"26ab");
AGR.CHAR("2F4(2)'","TF42G1-f5r78B0",5,6,"78a");
AGR.CHAR("2F4(2)'","TF42G1-f9r27aB0",3,4,"27a");
AGR.CHAR("2F4(2)'","TF42G1-f9r27bB0",3,5,"27b");
AGR.CHAR("2F4(2)'","TF42G1-p12480B0",0,[1,6,[9,3],12,13,14,[15,2],16,17,18,19,21,22],"1a+78a+351a^3+624ab+650a+675a^2+702ab+1300ab+2048ab");
AGR.CHAR("2F4(2)'","TF42G1-p14976B0",0,[1,8,[9,2],12,13,14,[15,2],16,17,[18,2],[19,2],21,22],"1a+325a+351a^2+624ab+650a+675a^2+702ab+1300a^2b^2+2048ab");
AGR.CHAR("2F4(2)'","TF42G1-p1600B0",0,[1,9,12,13],"1a+351a+624ab");
AGR.CHAR("2F4(2)'","TF42G1-p1755B0",0,[1,6,9,14,15],"1a+78a+351a+650a+675a");
AGR.CHAR("2F4(2)'","TF42G1-p2304B0",0,[1,4,5,9,12,13,14],"1a+27ab+351a+624ab+650a");
AGR.CHAR("2F4(2)'","TF42G1-p2925B0",0,[1,9,12,13,14,15],"1a+351a+624ab+650a+675a");
AGR.CHAR("3D4(2)","TD42G1-Zr196B0",0,4,"196a");
AGR.CHAR("3D4(2)","TD42G1-Zr26B0",0,2,"26a");
AGR.CHAR("3D4(2)","TD42G1-Zr52B0",0,3,"52a");
AGR.CHAR("3D4(2)","TD42G1-f13r26B0",13,2,"26a");
AGR.CHAR("3D4(2)","TD42G1-f27r351aB0",3,6,"351a");
AGR.CHAR("3D4(2)","TD42G1-f27r351bB0",3,7,"351b");
AGR.CHAR("3D4(2)","TD42G1-f27r351cB0",3,8,"351c");
AGR.CHAR("3D4(2)","TD42G1-f2r26B0",2,5,"26a");
AGR.CHAR("3D4(2)","TD42G1-f3r1053B0",3,10,"1053a");
AGR.CHAR("3D4(2)","TD42G1-f3r196B0",3,4,"196a");
AGR.CHAR("3D4(2)","TD42G1-f3r25B0",3,2,"25a");
AGR.CHAR("3D4(2)","TD42G1-f3r324B0",3,5,"324a");
AGR.CHAR("3D4(2)","TD42G1-f3r441B0",3,9,"441a");
AGR.CHAR("3D4(2)","TD42G1-f3r52B0",3,3,"52a");
AGR.CHAR("3D4(2)","TD42G1-f7r26B0",7,2,"26a");
AGR.CHAR("3D4(2)","TD42G1-f7r298B0",7,6,"298a");
AGR.CHAR("3D4(2)","TD42G1-f8r8aB0",2,2,"8a");
AGR.CHAR("3D4(2)","TD42G1-p819B0",0,[1,2,6,10],"1a+26a+324a+468a");
AGR.CHAR("3D4(2).3","TD42d3G1-f13r26aB0",13,4);
AGR.CHAR("3D4(2).3","TD42d3G1-f2r144B0",2,8);
AGR.CHAR("3D4(2).3","TD42d3G1-f2r246aB0",2,10);
AGR.CHAR("3D4(2).3","TD42d3G1-f2r24B0",2,4);
AGR.CHAR("3D4(2).3","TD42d3G1-f2r26B0",2,5);
AGR.CHAR("3D4(2).3","TD42d3G1-f2r480B0",2,9);
AGR.CHAR("3D4(2).3","TD42d3G1-f3r196B0",3,4);
AGR.CHAR("3D4(2).3","TD42d3G1-f3r52B0",3,3);
AGR.CHAR("3D4(2).3","TD42d3G1-f7r26aB0",7,4);
AGR.CHAR("3D4(2).3","TD42d3G1-f7r273aB0",7,13);
AGR.CHAR("3D4(2).3","TD42d3G1-f7r298aB0",7,16);
AGR.CHAR("3D4(2).3","TD42d3G1-f7r467aB0",7,19);
AGR.CHAR("3D4(2).3","TD42d3G1-f7r52aB0",7,7);
AGR.CHAR("Co1","Co1G1-f11r276B0",11,2,"276a");
AGR.CHAR("Co1","Co1G1-f11r299B0",11,3,"299a");
AGR.CHAR("Co1","Co1G1-f13r276B0",13,2,"276a");
AGR.CHAR("Co1","Co1G1-f13r299B0",13,3,"299a");
AGR.CHAR("Co1","Co1G1-f23r276B0",23,2,"276a");
AGR.CHAR("Co1","Co1G1-f23r299B0",23,3,"299a");
AGR.CHAR("Co1","Co1G1-f7r276B0",7,2,"276a");
AGR.CHAR("Co1","Co1G1-f7r299B0",7,3,"299a");
AGR.CHAR("Co1","Co1G1-p98280B0",0,[1,3,6,10],"1a+299a+17250a+80730a");
AGR.CHAR("Co2","Co2G1-Zr23B0",0,2,"23a");
AGR.CHAR("Co2","Co2G1-f11r23B0",11,2,"23a");
AGR.CHAR("Co2","Co2G1-f11r253B0",11,3,"253a");
AGR.CHAR("Co2","Co2G1-f11r275B0",11,4,"275a");
AGR.CHAR("Co2","Co2G1-f23r23B0",23,2,"23a");
AGR.CHAR("Co2","Co2G1-f23r253B0",23,3,"253a");
AGR.CHAR("Co2","Co2G1-f23r274B0",23,4,"274a");
AGR.CHAR("Co2","Co2G1-f2r22B0",2,2,"22a");
AGR.CHAR("Co2","Co2G1-f2r230B0",2,3,"230a");
AGR.CHAR("Co2","Co2G1-f2r24B0",2,[[1,2],2],"1a^2+22a");
AGR.CHAR("Co2","Co2G1-f2r748aB0",2,4,"748a");
AGR.CHAR("Co2","Co2G1-f2r748bB0",2,5,"748b");
AGR.CHAR("Co2","Co2G1-f3r23B0",3,2,"23a");
AGR.CHAR("Co2","Co2G1-f3r253B0",3,3,"253a");
AGR.CHAR("Co2","Co2G1-f3r275B0",3,4,"275a");
AGR.CHAR("Co2","Co2G1-f5r23B0",5,2,"23a");
AGR.CHAR("Co2","Co2G1-f5r253B0",5,3,"253a");
AGR.CHAR("Co2","Co2G1-f5r275B0",5,4,"275a");
AGR.CHAR("Co2","Co2G1-f7r23B0",7,2,"23a");
AGR.CHAR("Co2","Co2G1-f7r253B0",7,3,"253a");
AGR.CHAR("Co2","Co2G1-f7r275B0",7,4,"275a");
AGR.CHAR("Co2","Co2G1-p2300B0",0,[1,4,6],"1a+275a+2024a");
AGR.CHAR("Co2","Co2G1-p4600B0",0,[1,2,4,6,7],"1a+23a+275a+2024a+2277a");
AGR.CHAR("Co3","Co3G1-Zr23B0",0,2,"23a");
AGR.CHAR("Co3","Co3G1-f11r23B0",11,2,"23a");
AGR.CHAR("Co3","Co3G1-f11r253aB0",11,3,"253a");
AGR.CHAR("Co3","Co3G1-f11r253bB0",11,4,"253b");
AGR.CHAR("Co3","Co3G1-f11r275B0",11,5,"275a");
AGR.CHAR("Co3","Co3G1-f11r896B0",11,6,"896a");
AGR.CHAR("Co3","Co3G1-f23r23B0",23,2,"23a");
AGR.CHAR("Co3","Co3G1-f23r253aB0",23,3,"253a");
AGR.CHAR("Co3","Co3G1-f23r253bB0",23,4,"253b");
AGR.CHAR("Co3","Co3G1-f23r274B0",23,5,"274a");
AGR.CHAR("Co3","Co3G1-f23r896bB0",23,7,"896b");
AGR.CHAR("Co3","Co3G1-f2r22B0",2,2,"22a");
AGR.CHAR("Co3","Co3G1-f2r230B0",2,3,"230a");
AGR.CHAR("Co3","Co3G1-f3r126aB0",3,3,"126a");
AGR.CHAR("Co3","Co3G1-f3r126bB0",3,4,"126b");
AGR.CHAR("Co3","Co3G1-f3r22B0",3,2,"22a");
AGR.CHAR("Co3","Co3G1-f3r231aB0",3,5,"231a");
AGR.CHAR("Co3","Co3G1-f3r231bB0",3,6,"231b");
AGR.CHAR("Co3","Co3G1-f3r770aB0",3,7,"770a");
AGR.CHAR("Co3","Co3G1-f3r770bB0",3,8,"770b");
AGR.CHAR("Co3","Co3G1-f49r896aB0",7,6,"896a");
AGR.CHAR("Co3","Co3G1-f4r896aB0",2,4,"896a");
AGR.CHAR("Co3","Co3G1-f5r230B0",5,3,"230a");
AGR.CHAR("Co3","Co3G1-f5r23B0",5,2,"23a");
AGR.CHAR("Co3","Co3G1-f5r253B0",5,4,"253a");
AGR.CHAR("Co3","Co3G1-f5r275B0",5,5,"275a");
AGR.CHAR("Co3","Co3G1-f5r896bB0",5,7,"896b");
AGR.CHAR("Co3","Co3G1-f7r23B0",7,2,"23a");
AGR.CHAR("Co3","Co3G1-f7r253aB0",7,3,"253a");
AGR.CHAR("Co3","Co3G1-f7r253bB0",7,4,"253b");
AGR.CHAR("Co3","Co3G1-f7r275B0",7,5,"275a");
AGR.CHAR("Co3","Co3G1-p11178B0",0,[1,2,5,9,15],"1a+23a+275a+2024a+8855a");
AGR.CHAR("Co3","Co3G1-p128800B0",0,[1,5,13,15,20,31],"1a+275a+5544a+8855a+23000a+91125a");
AGR.CHAR("Co3","Co3G1-p276B0",0,[1,5],"1a+275a");
AGR.CHAR("Co3","Co3G1-p37950B0",0,[1,[5,2],13,15,20],"1a+275a^2+5544a+8855a+23000a");
AGR.CHAR("Co3","Co3G1-p48600B0",0,[1,2,4,5,9,13,15,24],"1a+23a+253b+275a+2024a+5544a+8855a+31625c");
AGR.CHAR("Co3","Co3G1-p552B0",0,[1,2,4,5],"1a+23a+253b+275a");
AGR.CHAR("Fi22","F22G1-Zr78B0",0,2,"78a");
AGR.CHAR("Fi22","F22G1-f11r429B0",11,3,"429a");
AGR.CHAR("Fi22","F22G1-f11r78B0",11,2,"78a");
AGR.CHAR("Fi22","F22G1-f13r429B0",13,3,"429a");
AGR.CHAR("Fi22","F22G1-f13r78B0",13,2,"78a");
AGR.CHAR("Fi22","F22G1-f2r350B0",2,3,"350a");
AGR.CHAR("Fi22","F22G1-f2r572B0",2,4,"572a");
AGR.CHAR("Fi22","F22G1-f2r78B0",2,2,"78a");
AGR.CHAR("Fi22","F22G1-f3r351B0",3,3,"351a");
AGR.CHAR("Fi22","F22G1-f3r77B0",3,2,"77a");
AGR.CHAR("Fi22","F22G1-f3r924B0",3,4,"924a");
AGR.CHAR("Fi22","F22G1-f5r428B0",5,3,"428a");
AGR.CHAR("Fi22","F22G1-f5r78B0",5,2,"78a");
AGR.CHAR("Fi22","F22G1-f7r429B0",7,3,"429a");
AGR.CHAR("Fi22","F22G1-f7r78B0",7,2,"78a");
AGR.CHAR("Fi22","F22G1-p14080bB0",0,[1,3,9],"1a+429a+13650a");
AGR.CHAR("Fi22","F22G1-p142155B0",0,[1,2,3,5,7,10,11,17],"1a+78a+429a+1430a+3080a+30030a+32032a+75075a");
AGR.CHAR("Fi22","F22G1-p3510B0",0,[1,3,7],"1a+429a+3080a");
AGR.CHAR("Fi22","F22G1-p61776B0",0,[1,7,9,13],"1a+3080a+13650a+45045a");
AGR.CHAR("Fi22","F22G1-p694980B0",0,[1,3,5,7,9,10,13,17,25,28],"1a+429a+1430a+3080a+13650a+30030a+45045a+75075a+205920a+320320a");
AGR.CHAR("Fi23","F23G1-f11r782B0",11,2,"782a");
AGR.CHAR("Fi23","F23G1-f13r782B0",13,2,"782a");
AGR.CHAR("Fi23","F23G1-f2r1494B0",2,3,"1494a");
AGR.CHAR("Fi23","F23G1-f2r782B0",2,2,"782a");
AGR.CHAR("Fi23","F23G1-f5r782B0",5,2,"782a");
AGR.CHAR("Fi23","F23G1-f7r782B0",7,2,"782a");
AGR.CHAR("Fi23","F23G1-p137632B0",0,[1,6,8],"1a+30888a+106743a");
AGR.CHAR("Fi23","F23G1-p275264B0",0,[1,5,6,8,9],"1a+25806a+30888a+106743a+111826a");
AGR.CHAR("Fi23","F23G1-p31671B0",0,[1,2,6],"1a+782a+30888a");
AGR.CHAR("G2(3)","G23G1-Zr104B0",0,9,"104a");
AGR.CHAR("G2(3)","G23G1-Zr128B0",0,[3,4],"64ab");
AGR.CHAR("G2(3)","G23G1-Zr14B0",0,2,"14a");
AGR.CHAR("G2(3)","G23G1-Zr168B0",0,10,"168a");
AGR.CHAR("G2(3)","G23G1-Zr182aB0",0,11,"182a");
AGR.CHAR("G2(3)","G23G1-Zr182bB0",0,12,"182b");
AGR.CHAR("G2(3)","G23G1-Zr78B0",0,5,"78a");
AGR.CHAR("G2(3)","G23G1-Zr91aB0",0,6,"91a");
AGR.CHAR("G2(3)","G23G1-Zr91bB0",0,7,"91b");
AGR.CHAR("G2(3)","G23G1-Zr91cB0",0,8,"91c");
AGR.CHAR("G2(3)","G23G1-f2r14B0",2,2,"14a");
AGR.CHAR("G2(3)","G23G1-f2r378B0",2,9,"378a");
AGR.CHAR("G2(3)","G23G1-f2r78B0",2,5,"78a");
AGR.CHAR("G2(3)","G23G1-f2r90aB0",2,6,"90a");
AGR.CHAR("G2(3)","G23G1-f2r90bB0",2,7,"90b");
AGR.CHAR("G2(3)","G23G1-f2r90cB0",2,8,"90c");
AGR.CHAR("G2(3)","G23G1-f3r189aB0",3,7,"189a");
AGR.CHAR("G2(3)","G23G1-f3r189bB0",3,8,"189b");
AGR.CHAR("G2(3)","G23G1-f3r27aB0",3,5,"27b");
AGR.CHAR("G2(3)","G23G1-f3r27bB0",3,4,"27a");
AGR.CHAR("G2(3)","G23G1-f3r49B0",3,6,"49a");
AGR.CHAR("G2(3)","G23G1-f3r729B0",3,9,"729a");
AGR.CHAR("G2(3)","G23G1-f3r7aB0",3,2,"7a");
AGR.CHAR("G2(3)","G23G1-f3r7bB0",3,3,"7b");
AGR.CHAR("G2(3)","G23G1-f4r64aB0",2,3,"64a");
AGR.CHAR("G2(3).2","G23d2G1-Ar14B0",0,3);
AGR.CHAR("G2(3).2","G23d2G1-f13r14B0",13,3);
AGR.CHAR("G2(3).2","G23d2G1-f13r434aB0",13,21);
AGR.CHAR("G2(3).2","G23d2G1-f2r14B0",2,2);
AGR.CHAR("G2(3).2","G23d2G1-f3r14B0",3,3);
AGR.CHAR("G2(3).2","G23d2G1-f7r14B0",7,3);
AGR.CHAR("G2(3).2","G23d2G1-p756B0",0,[1,2,13,14,15,18]);
AGR.CHAR("G2(4)","G24G1-Zr350B0",0,6,"350a");
AGR.CHAR("G2(4)","G24G1-Zr65B0",0,2,"65a");
AGR.CHAR("G2(4)","G24G1-Zr78B0",0,3,"78a");
AGR.CHAR("G2(4)","G24G1-f13r65B0",13,2,"65a");
AGR.CHAR("G2(4)","G24G1-f13r78B0",13,3,"78a");
AGR.CHAR("G2(4)","G24G1-f2r196B0",2,11,"196a");
AGR.CHAR("G2(4)","G24G1-f2r36B0",2,6,"36a");
AGR.CHAR("G2(4)","G24G1-f3r286B0",3,4,"286a");
AGR.CHAR("G2(4)","G24G1-f3r64B0",3,2,"64a");
AGR.CHAR("G2(4)","G24G1-f3r78B0",3,3,"78a");
AGR.CHAR("G2(4)","G24G1-f4r14aB0",2,4,"14a");
AGR.CHAR("G2(4)","G24G1-f4r14bB0",2,5,"14b");
AGR.CHAR("G2(4)","G24G1-f4r384aB0",2,12,"384a");
AGR.CHAR("G2(4)","G24G1-f4r64aB0",2,7,"64a");
AGR.CHAR("G2(4)","G24G1-f4r64bB0",2,8,"64b");
AGR.CHAR("G2(4)","G24G1-f4r6aB0",2,2,"6a");
AGR.CHAR("G2(4)","G24G1-f4r6bB0",2,3,"6b");
AGR.CHAR("G2(4)","G24G1-f4r84aB0",2,10,"84b");
AGR.CHAR("G2(4)","G24G1-f4r84bB0",2,9,"84a");
AGR.CHAR("G2(4)","G24G1-f4r896aB0",2,14,"896a");
AGR.CHAR("G2(4)","G24G1-f5r350B0",5,6,"350a");
AGR.CHAR("G2(4)","G24G1-f5r363aB0",5,7,"363a");
AGR.CHAR("G2(4)","G24G1-f5r650B0",5,10,"650a");
AGR.CHAR("G2(4)","G24G1-f5r65B0",5,2,"65a");
AGR.CHAR("G2(4)","G24G1-f5r78B0",5,3,"78a");
AGR.CHAR("G2(4)","G24G1-f7r65B0",7,2,"65a");
AGR.CHAR("G2(4)","G24G1-f7r78B0",7,3,"78a");
AGR.CHAR("G2(4)","G24G1-p1365aB0",0,[1,6,7,10],"1a+350a+364a+650a");
AGR.CHAR("G2(4)","G24G1-p1365bB0",0,[1,6,8,10],"1a+350a+364b+650a");
AGR.CHAR("G2(4)","G24G1-p2016B0",0,[1,10,16],"1a+650a+1365a");
AGR.CHAR("G2(4)","G24G1-p20800B0",0,[1,2,[6,2],7,8,15,16,19,28,29,32],"1a+65a+350a^2+364ab+1300a+1365a+2925c+4096a+4160a+5460a");
AGR.CHAR("G2(4)","G24G1-p2080B0",0,[1,6,8,16],"1a+350a+364b+1365a");
AGR.CHAR("G2(4)","G24G1-p416B0",0,[1,2,6],"1a+65a+350a");
AGR.CHAR("G2(4).2","G24d2G1-f13r65B0",13,4);
AGR.CHAR("G2(4).2","G24d2G1-f2r128B0",2,5);
AGR.CHAR("G2(4).2","G24d2G1-f2r12B0",2,2);
AGR.CHAR("G2(4).2","G24d2G1-f2r168B0",2,6);
AGR.CHAR("G2(4).2","G24d2G1-f2r196B0",2,7);
AGR.CHAR("G2(4).2","G24d2G1-f2r28B0",2,3);
AGR.CHAR("G2(4).2","G24d2G1-f2r36B0",2,4);
AGR.CHAR("G2(4).2","G24d2G1-f2r768B0",2,8);
AGR.CHAR("G2(4).2","G24d2G1-f3r64B0",3,3);
AGR.CHAR("G2(4).2","G24d2G1-f5r65B0",5,4);
AGR.CHAR("HN","HNG1-f11r133aB0",11,2,"133a");
AGR.CHAR("HN","HNG1-f11r133bB0",11,3,"133b");
AGR.CHAR("HN","HNG1-f11r760B0",11,4,"760a");
AGR.CHAR("HN","HNG1-f19r133aB0",19,2,"133a");
AGR.CHAR("HN","HNG1-f19r133bB0",19,3,"133b");
AGR.CHAR("HN","HNG1-f19r760B0",19,4,"760a");
AGR.CHAR("HN","HNG1-f2r760B0",2,4,"760a");
AGR.CHAR("HN","HNG1-f3r760B0",3,4,"760a");
AGR.CHAR("HN","HNG1-f49r133aB0",7,2,"133a");
AGR.CHAR("HN","HNG1-f49r133bB0",7,3,"133b");
AGR.CHAR("HN","HNG1-f4r132aB0",2,2,"132a");
AGR.CHAR("HN","HNG1-f4r132bB0",2,3,"132b");
AGR.CHAR("HN","HNG1-f4r133B0",2,[1,2],"1a+132a");
AGR.CHAR("HN","HNG1-f4r2650aB0",2,6,"2650b");
AGR.CHAR("HN","HNG1-f5r133B0",5,2,"133a");
AGR.CHAR("HN","HNG1-f5r626B0",5,3,"626a");
AGR.CHAR("HN","HNG1-f5r627B0",5,[1,3],"1a+626a");
AGR.CHAR("HN","HNG1-f7r760B0",7,4,"760a");
AGR.CHAR("HN","HNG1-f9r133aB0",3,2,"133a");
AGR.CHAR("HN","HNG1-f9r133bB0",3,3,"133b");
AGR.CHAR("HN","HNG1-p1140000B0",0,[1,2,3,4,5,8,10,11,12,18,20,23],"1a+133ab+760a+3344a+8910a+16929a+35112ab+267520a+365750a+406296a");
AGR.CHAR("HS","HSG1-Zr154aB0",0,4,"154a");
AGR.CHAR("HS","HSG1-Zr154bB0",0,5,"154b");
AGR.CHAR("HS","HSG1-Zr154cB0",0,6,"154c");
AGR.CHAR("HS","HSG1-Zr175B0",0,7,"175a");
AGR.CHAR("HS","HSG1-Zr22B0",0,2,"22a");
AGR.CHAR("HS","HSG1-Zr231B0",0,8,"231a");
AGR.CHAR("HS","HSG1-Zr77B0",0,3,"77a");
AGR.CHAR("HS","HSG1-f11r154aB0",11,4,"154a");
AGR.CHAR("HS","HSG1-f11r154bB0",11,5,"154b");
AGR.CHAR("HS","HSG1-f11r154cB0",11,6,"154c");
AGR.CHAR("HS","HSG1-f11r174B0",11,7,"174a");
AGR.CHAR("HS","HSG1-f11r22B0",11,2,"22a");
AGR.CHAR("HS","HSG1-f11r231B0",11,8,"231a");
AGR.CHAR("HS","HSG1-f11r693B0",11,9,"693a");
AGR.CHAR("HS","HSG1-f11r770aB0",11,10,"770a");
AGR.CHAR("HS","HSG1-f11r77B0",11,3,"77a");
AGR.CHAR("HS","HSG1-f11r825B0",11,13,"825a");
AGR.CHAR("HS","HSG1-f11r854B0",11,14,"854a");
AGR.CHAR("HS","HSG1-f11r896B0",11,15,"896a");
AGR.CHAR("HS","HSG1-f121r770bB0",11,11,"770b");
AGR.CHAR("HS","HSG1-f121r770cB0",11,12,"770c");
AGR.CHAR("HS","HSG1-f2r1000B0",2,8,"1000a");
AGR.CHAR("HS","HSG1-f2r132B0",2,4,"132a");
AGR.CHAR("HS","HSG1-f2r20B0",2,2,"20a");
AGR.CHAR("HS","HSG1-f2r518B0",2,5,"518a");
AGR.CHAR("HS","HSG1-f2r56B0",2,3,"56a");
AGR.CHAR("HS","HSG1-f3r154aB0",3,6,"154a");
AGR.CHAR("HS","HSG1-f3r154bB0",3,7,"154b");
AGR.CHAR("HS","HSG1-f3r154cB0",3,8,"154c");
AGR.CHAR("HS","HSG1-f3r22B0",3,2,"22a");
AGR.CHAR("HS","HSG1-f3r231B0",3,9,"231a");
AGR.CHAR("HS","HSG1-f3r321B0",3,10,"321a");
AGR.CHAR("HS","HSG1-f3r49aB0",3,3,"49a");
AGR.CHAR("HS","HSG1-f3r49bB0",3,4,"49b");
AGR.CHAR("HS","HSG1-f3r693B0",3,11,"693a");
AGR.CHAR("HS","HSG1-f3r748B0",3,12,"748a");
AGR.CHAR("HS","HSG1-f3r770aB0",3,13,"770a");
AGR.CHAR("HS","HSG1-f3r77B0",3,5,"77a");
AGR.CHAR("HS","HSG1-f3r825B0",3,15,"825a");
AGR.CHAR("HS","HSG1-f49r896aB0",7,15,"896a");
AGR.CHAR("HS","HSG1-f49r896bB0",7,16,"896b");
AGR.CHAR("HS","HSG1-f4r896aB0",2,6,"896a");
AGR.CHAR("HS","HSG1-f4r896bB0",2,7,"896b");
AGR.CHAR("HS","HSG1-f5r133aB0",5,5,"133a");
AGR.CHAR("HS","HSG1-f5r133bB0",5,6,"133b");
AGR.CHAR("HS","HSG1-f5r175B0",5,7,"175a");
AGR.CHAR("HS","HSG1-f5r210B0",5,8,"210a");
AGR.CHAR("HS","HSG1-f5r21B0",5,2,"21a");
AGR.CHAR("HS","HSG1-f5r280aB0",5,9,"280a");
AGR.CHAR("HS","HSG1-f5r518B0",5,11,"518a");
AGR.CHAR("HS","HSG1-f5r55B0",5,3,"55a");
AGR.CHAR("HS","HSG1-f5r650B0",5,12,"650a");
AGR.CHAR("HS","HSG1-f5r98B0",5,4,"98a");
AGR.CHAR("HS","HSG1-f7r154aB0",7,4,"154a");
AGR.CHAR("HS","HSG1-f7r154bB0",7,5,"154b");
AGR.CHAR("HS","HSG1-f7r154cB0",7,6,"154c");
AGR.CHAR("HS","HSG1-f7r175B0",7,7,"175a");
AGR.CHAR("HS","HSG1-f7r22B0",7,2,"22a");
AGR.CHAR("HS","HSG1-f7r231B0",7,8,"231a");
AGR.CHAR("HS","HSG1-f7r605B0",7,9,"605a");
AGR.CHAR("HS","HSG1-f7r693B0",7,10,"693a");
AGR.CHAR("HS","HSG1-f7r770aB0",7,11,"770a");
AGR.CHAR("HS","HSG1-f7r770bB0",7,12,"770b");
AGR.CHAR("HS","HSG1-f7r770cB0",7,13,"770c");
AGR.CHAR("HS","HSG1-f7r77B0",7,3,"77a");
AGR.CHAR("HS","HSG1-f7r803B0",7,14,"803a");
AGR.CHAR("HS","HSG1-p100B0",0,[1,2,3],"1a+22a+77a");
AGR.CHAR("HS","HSG1-p1100aB0",0,[1,2,3,7,13],"1a+22a+77a+175a+825a");
AGR.CHAR("HS","HSG1-p1100bB0",0,[1,3,4,7,9],"1a+77a+154a+175a+693a");
AGR.CHAR("HS","HSG1-p15400B0",0,[1,3,4,[7,3],[9,2],13,14,15,16,17,18,19,[22,2]],"1a+77a+154a+175a^3+693a^2+825a+896ab+1056a+1386a+1408a+1750a+2520a^2");
AGR.CHAR("HS","HSG1-p176bB0",0,[1,7],"1a+175a");
AGR.CHAR("HS","HSG1-p3850B0",0,[1,2,[3,2],4,7,9,10,13,16],"1a+22a+77a^2+154a+175a+693a+770a+825a+1056a");
AGR.CHAR("HS","HSG1-p4125B0",0,[1,2,3,4,7,9,10,13,18],"1a+22a+77a+154a+175a+693a+770a+825a+1408a");
AGR.CHAR("HS","HSG1-p5600aB0",0,[1,2,3,5,7,10,13,16,22],"1a+22a+77a+154b+175a+770a+825a+1056a+2520a");
AGR.CHAR("He","HeG1-Zr102B0",0,[2,3],"51ab");
AGR.CHAR("He","HeG1-f17r102B0",17,[2,3],"51ab");
AGR.CHAR("He","HeG1-f17r306B0",17,[4,5],"153ab");
AGR.CHAR("He","HeG1-f17r680B0",17,6,"680a");
AGR.CHAR("He","HeG1-f2r680B0",2,8,"680a");
AGR.CHAR("He","HeG1-f3r679B0",3,6,"679a");
AGR.CHAR("He","HeG1-f5r680B0",5,7,"680a");
AGR.CHAR("He","HeG1-f7r153B0",7,3,"153a");
AGR.CHAR("He","HeG1-f7r426B0",7,4,"426a");
AGR.CHAR("He","HeG1-f7r50B0",7,2,"50a");
AGR.CHAR("He","HeG1-f7r798B0",7,5,"798a");
AGR.CHAR("He","HeG1-p2058B0",0,[1,2,3,6,9],"1a+51ab+680a+1275a");
AGR.CHAR("He","HeG1-p244800B0",0,[1,4,5,12,13,14,[15,2],16,[19,2],[22,2],23,24,[26,2],[27,2],[28,2],29,30,31],"1a+153ab+1920a+4080a+4352a+6272a^2+6528a+7650a^2+10880a^2+11475ab+13720a^2+14400a^2+17493a^2+20825a+21504ab");
AGR.CHAR("He","HeG1-p29155B0",0,[1,2,3,6,[9,2],12,14,19,25],"1a+51ab+680a+1275a^2+1920a+4352a+7650a+11900a");
AGR.CHAR("He","HeG1-p8330B0",0,[1,2,3,6,9,12,14],"1a+51ab+680a+1275a+1920a+4352a");
AGR.CHAR("J1","J1G1-Zr112B0",0,[2,3],"56ab");
AGR.CHAR("J1","J1G1-Zr133aB0",0,12,"133a");
AGR.CHAR("J1","J1G1-Zr154aB0",0,[7,8],"77bc");
AGR.CHAR("J1","J1G1-Zr209B0",0,15,"209a");
AGR.CHAR("J1","J1G1-Zr266B0",0,[13,14],"133bc");
AGR.CHAR("J1","J1G1-Zr360B0",0,[9,10,11],"120abc");
AGR.CHAR("J1","J1G1-Zr76aB0",0,4,"76a");
AGR.CHAR("J1","J1G1-Zr76bB0",0,5,"76b");
AGR.CHAR("J1","J1G1-Zr77aB0",0,6,"77a");
AGR.CHAR("J1","J1G1-f11r106B0",11,12,"106a");
AGR.CHAR("J1","J1G1-f11r119B0",11,13,"119a");
AGR.CHAR("J1","J1G1-f11r14B0",11,3,"14a");
AGR.CHAR("J1","J1G1-f11r209B0",11,14,"209a");
AGR.CHAR("J1","J1G1-f11r27B0",11,4,"27a");
AGR.CHAR("J1","J1G1-f11r49B0",11,5,"49a");
AGR.CHAR("J1","J1G1-f11r56B0",11,6,"56a");
AGR.CHAR("J1","J1G1-f11r64B0",11,7,"64a");
AGR.CHAR("J1","J1G1-f11r69B0",11,8,"69a");
AGR.CHAR("J1","J1G1-f11r77aB0",11,9,"77a");
AGR.CHAR("J1","J1G1-f11r77bB0",11,10,"77b");
AGR.CHAR("J1","J1G1-f11r77cB0",11,11,"77c");
AGR.CHAR("J1","J1G1-f11r7B0",11,2,"7a");
AGR.CHAR("J1","J1G1-f125r120aB0",5,6,"120a");
AGR.CHAR("J1","J1G1-f125r120bB0",5,7,"120b");
AGR.CHAR("J1","J1G1-f125r120cB0",5,8,"120c");
AGR.CHAR("J1","J1G1-f19r133aB0",19,9,"133a");
AGR.CHAR("J1","J1G1-f19r133bB0",19,10,"133b");
AGR.CHAR("J1","J1G1-f19r133cB0",19,11,"133c");
AGR.CHAR("J1","J1G1-f19r209B0",19,12,"209a");
AGR.CHAR("J1","J1G1-f19r22B0",19,2,"22a");
AGR.CHAR("J1","J1G1-f19r34B0",19,3,"34a");
AGR.CHAR("J1","J1G1-f19r43B0",19,4,"43a");
AGR.CHAR("J1","J1G1-f19r55B0",19,5,"55a");
AGR.CHAR("J1","J1G1-f19r76aB0",19,6,"76a");
AGR.CHAR("J1","J1G1-f19r76bB0",19,7,"76b");
AGR.CHAR("J1","J1G1-f19r77B0",19,8,"77a");
AGR.CHAR("J1","J1G1-f27r120aB0",3,8,"120a");
AGR.CHAR("J1","J1G1-f27r120bB0",3,9,"120b");
AGR.CHAR("J1","J1G1-f27r120cB0",3,10,"120c");
AGR.CHAR("J1","J1G1-f2r112aB0",2,[3,4],"56ab");
AGR.CHAR("J1","J1G1-f2r112bB0",2,[5,6],"56cd");
AGR.CHAR("J1","J1G1-f2r20B0",2,2,"20a");
AGR.CHAR("J1","J1G1-f2r360B0",2,[9,10,11],"120abc");
AGR.CHAR("J1","J1G1-f2r76aB0",2,7,"76a");
AGR.CHAR("J1","J1G1-f2r76bB0",2,8,"76b");
AGR.CHAR("J1","J1G1-f3r112B0",3,[2,3],"56ab");
AGR.CHAR("J1","J1G1-f3r133B0",3,11,"133a");
AGR.CHAR("J1","J1G1-f3r154B0",3,[6,7],"77ab");
AGR.CHAR("J1","J1G1-f3r360B0",3,[8,9,10],"120abc");
AGR.CHAR("J1","J1G1-f3r76aB0",3,4,"76a");
AGR.CHAR("J1","J1G1-f3r76bB0",3,5,"76b");
AGR.CHAR("J1","J1G1-f49r133bB0",7,13,"133b");
AGR.CHAR("J1","J1G1-f49r133cB0",7,14,"133c");
AGR.CHAR("J1","J1G1-f49r56aB0",7,4,"56a");
AGR.CHAR("J1","J1G1-f49r56bB0",7,5,"56b");
AGR.CHAR("J1","J1G1-f49r77bB0",7,8,"77b");
AGR.CHAR("J1","J1G1-f49r77cB0",7,9,"77c");
AGR.CHAR("J1","J1G1-f4r56aB0",2,3,"56a");
AGR.CHAR("J1","J1G1-f4r56bB0",2,4,"56b");
AGR.CHAR("J1","J1G1-f4r56cB0",2,5,"56c");
AGR.CHAR("J1","J1G1-f4r56dB0",2,6,"56d");
AGR.CHAR("J1","J1G1-f5r133B0",5,9,"133a");
AGR.CHAR("J1","J1G1-f5r360B0",5,[6,7,8],"120abc");
AGR.CHAR("J1","J1G1-f5r56B0",5,2,"56a");
AGR.CHAR("J1","J1G1-f5r76aB0",5,3,"76a");
AGR.CHAR("J1","J1G1-f5r76bB0",5,4,"76b");
AGR.CHAR("J1","J1G1-f5r77B0",5,5,"77a");
AGR.CHAR("J1","J1G1-f7r112B0",7,[4,5],"56ab");
AGR.CHAR("J1","J1G1-f7r120B0",7,11,"120a");
AGR.CHAR("J1","J1G1-f7r133aB0",7,12,"133a");
AGR.CHAR("J1","J1G1-f7r154B0",7,[8,9],"77bc");
AGR.CHAR("J1","J1G1-f7r266B0",7,[13,14],"133bc");
AGR.CHAR("J1","J1G1-f7r31B0",7,2,"31a");
AGR.CHAR("J1","J1G1-f7r45B0",7,3,"45a");
AGR.CHAR("J1","J1G1-f7r75B0",7,6,"75a");
AGR.CHAR("J1","J1G1-f7r77aB0",7,7,"77a");
AGR.CHAR("J1","J1G1-f7r89B0",7,10,"89a");
AGR.CHAR("J1","J1G1-f8r120aB0",2,9,"120a");
AGR.CHAR("J1","J1G1-f8r120bB0",2,10,"120b");
AGR.CHAR("J1","J1G1-f8r120cB0",2,11,"120c");
AGR.CHAR("J1","J1G1-f9r56aB0",3,2,"56a");
AGR.CHAR("J1","J1G1-f9r56bB0",3,3,"56b");
AGR.CHAR("J1","J1G1-f9r77aB0",3,6,"77a");
AGR.CHAR("J1","J1G1-f9r77bB0",3,7,"77b");
AGR.CHAR("J1","J1G1-p1045B0",0,[1,2,3,4,7,8,9,10,11,12,15],"1a+56ab+76a+77bc+120abc+133a+209a");
AGR.CHAR("J1","J1G1-p1463B0",0,[1,2,3,[4,2],[6,2],9,10,11,[12,2],[15,2]],"1a+56ab+76a^2+77a^2+120abc+133a^2+209a^2");
AGR.CHAR("J1","J1G1-p1540B0",0,[1,2,3,[4,2],6,7,8,9,10,11,[12,2],[15,2]],"1a+56ab+76a^2+77abc+120abc+133a^2+209a^2");
AGR.CHAR("J1","J1G1-p1596B0",0,[1,2,3,4,5,[6,2],9,10,11,12,13,14,[15,2]],"1a+56ab+76ab+77a^2+120abc+133abc+209a^2");
AGR.CHAR("J1","J1G1-p266B0",0,[1,2,3,4,6],"1a+56ab+76a+77a");
AGR.CHAR("J1","J1G1-p2926B0",0,[1,2,3,[4,3],[6,3],[9,2],[10,2],[11,2],[12,4],13,14,[15,4]],"1a+56ab+76a^3+77a^3+120a^2b^2c^2+133a^4bc+209a^4");
AGR.CHAR("J1","J1G1-p4180B0",0,[1,[2,2],[3,2],[4,3],5,[6,2],[7,2],[8,2],[9,3],[10,3],[11,3],[12,4],[13,2],[14,2],[15,5]],"1a+56a^2b^2+76a^3b+77a^2b^2c^2+120a^3b^3c^3+133a^4b^2c^2+209a^5");
AGR.CHAR("J2","J2G1-Ar14aB0",0,2,"14a");
AGR.CHAR("J2","J2G1-Ar14bB0",0,3,"14b");
AGR.CHAR("J2","J2G1-Ar21aB0",0,4,"21a");
AGR.CHAR("J2","J2G1-Ar21bB0",0,5,"21b");
AGR.CHAR("J2","J2G1-Zr126B0",0,11,"126a");
AGR.CHAR("J2","J2G1-Zr140B0",0,[8,9],"70ab");
AGR.CHAR("J2","J2G1-Zr160B0",0,12,"160a");
AGR.CHAR("J2","J2G1-Zr175B0",0,13,"175a");
AGR.CHAR("J2","J2G1-Zr225B0",0,18,"225a");
AGR.CHAR("J2","J2G1-Zr28B0",0,[2,3],"14ab");
AGR.CHAR("J2","J2G1-Zr36B0",0,6,"36a");
AGR.CHAR("J2","J2G1-Zr378B0",0,[14,15],"189ab");
AGR.CHAR("J2","J2G1-Zr42B0",0,[4,5],"21ab");
AGR.CHAR("J2","J2G1-Zr448B0",0,[16,17],"224ab");
AGR.CHAR("J2","J2G1-Zr63B0",0,7,"63a");
AGR.CHAR("J2","J2G1-Zr90B0",0,10,"90a");
AGR.CHAR("J2","J2G1-f2r160B0",2,10,"160a");
AGR.CHAR("J2","J2G1-f2r36B0",2,6,"36a");
AGR.CHAR("J2","J2G1-f2r84B0",2,9,"84a");
AGR.CHAR("J2","J2G1-f3r133B0",3,11,"133a");
AGR.CHAR("J2","J2G1-f3r225B0",3,14,"225a");
AGR.CHAR("J2","J2G1-f3r36B0",3,6,"36a");
AGR.CHAR("J2","J2G1-f3r63B0",3,9,"63a");
AGR.CHAR("J2","J2G1-f3r90B0",3,10,"90a");
AGR.CHAR("J2","J2G1-f49r14aB0",7,2,"14a");
AGR.CHAR("J2","J2G1-f49r189aB0",7,15,"189a");
AGR.CHAR("J2","J2G1-f49r21aB0",7,4,"21a");
AGR.CHAR("J2","J2G1-f49r224bB0",7,19,"224b");
AGR.CHAR("J2","J2G1-f49r70aB0",7,8,"70a");
AGR.CHAR("J2","J2G1-f4r14aB0",2,4,"14a");
AGR.CHAR("J2","J2G1-f4r64aB0",2,7,"64a");
AGR.CHAR("J2","J2G1-f4r6aB0",2,2,"6a");
AGR.CHAR("J2","J2G1-f5r14B0",5,2,"14a");
AGR.CHAR("J2","J2G1-f5r175B0",5,8,"175a");
AGR.CHAR("J2","J2G1-f5r189B0",5,9,"189a");
AGR.CHAR("J2","J2G1-f5r21B0",5,3,"21a");
AGR.CHAR("J2","J2G1-f5r225B0",5,10,"225a");
AGR.CHAR("J2","J2G1-f5r300B0",5,11,"300a");
AGR.CHAR("J2","J2G1-f5r41B0",5,4,"41a");
AGR.CHAR("J2","J2G1-f5r70B0",5,5,"70a");
AGR.CHAR("J2","J2G1-f5r85B0",5,6,"85a");
AGR.CHAR("J2","J2G1-f5r90B0",5,7,"90a");
AGR.CHAR("J2","J2G1-f7r101B0",7,11,"101a");
AGR.CHAR("J2","J2G1-f7r124B0",7,12,"124a");
AGR.CHAR("J2","J2G1-f7r126B0",7,13,"126a");
AGR.CHAR("J2","J2G1-f7r175B0",7,14,"175a");
AGR.CHAR("J2","J2G1-f7r199B0",7,17,"199a");
AGR.CHAR("J2","J2G1-f7r336B0",7,20,"336a");
AGR.CHAR("J2","J2G1-f7r36B0",7,6,"36a");
AGR.CHAR("J2","J2G1-f7r63B0",7,7,"63a");
AGR.CHAR("J2","J2G1-f7r89B0",7,10,"89a");
AGR.CHAR("J2","J2G1-f9r13aB0",3,2,"13a");
AGR.CHAR("J2","J2G1-f9r189aB0",3,12,"189a");
AGR.CHAR("J2","J2G1-f9r21aB0",3,4,"21a");
AGR.CHAR("J2","J2G1-f9r57aB0",3,7,"57a");
AGR.CHAR("J2","J2G1-p1008B0",0,[1,2,3,[10,2],11,12,18,19],"1a+14ab+90a^2+126a+160a+225a+288a");
AGR.CHAR("J2","J2G1-p100B0",0,[1,6,7],"1a+36a+63a");
AGR.CHAR("J2","J2G1-p1800B0",0,[1,6,[7,2],10,[11,2],12,13,19,[21,2]],"1a+36a+63a^2+90a+126a^2+160a+175a+288a+336a^2");
AGR.CHAR("J2","J2G1-p280B0",0,[1,7,10,11],"1a+63a+90a+126a");
AGR.CHAR("J2","J2G1-p315B0",0,[1,2,3,6,10,12],"1a+14ab+36a+90a+160a");
AGR.CHAR("J2","J2G1-p525B0",0,[1,6,7,10,12,13],"1a+36a+63a+90a+160a+175a");
AGR.CHAR("J2","J2G1-p840B0",0,[1,7,10,11,12,13,18],"1a+63a+90a+126a+160a+175a+225a");
AGR.CHAR("J2.2","J2d2G1-f2r128B0",2,5);
AGR.CHAR("J2.2","J2d2G1-f2r12B0",2,2);
AGR.CHAR("J2.2","J2d2G1-f2r160B0",2,7);
AGR.CHAR("J2.2","J2d2G1-f2r28B0",2,3);
AGR.CHAR("J2.2","J2d2G1-f2r36B0",2,4);
AGR.CHAR("J2.2","J2d2G1-f2r84B0",2,6);
AGR.CHAR("J2.2","J2d2G1-f3r114B0",3,7);
AGR.CHAR("J2.2","J2d2G1-f3r133aB0",3,12);
AGR.CHAR("J2.2","J2d2G1-f3r225aB0",3,15);
AGR.CHAR("J2.2","J2d2G1-f3r26B0",3,3);
AGR.CHAR("J2.2","J2d2G1-f3r36aB0",3,5);
AGR.CHAR("J2.2","J2d2G1-f3r378B0",3,14);
AGR.CHAR("J2.2","J2d2G1-f3r42B0",3,4);
AGR.CHAR("J2.2","J2d2G1-f3r63aB0",3,8);
AGR.CHAR("J2.2","J2d2G1-f3r90aB0",3,10);
AGR.CHAR("J2.2","J2d2G1-f49r336aB0",7,24);
AGR.CHAR("J2.2","J2d2G1-f5r14aB0",5,3);
AGR.CHAR("J2.2","J2d2G1-f5r175aB0",5,15);
AGR.CHAR("J2.2","J2d2G1-f5r189aB0",5,17);
AGR.CHAR("J2.2","J2d2G1-f5r21aB0",5,5);
AGR.CHAR("J2.2","J2d2G1-f5r225aB0",5,19);
AGR.CHAR("J2.2","J2d2G1-f5r300aB0",5,21);
AGR.CHAR("J2.2","J2d2G1-f5r41aB0",5,7);
AGR.CHAR("J2.2","J2d2G1-f5r70aB0",5,9);
AGR.CHAR("J2.2","J2d2G1-f5r85aB0",5,11);
AGR.CHAR("J2.2","J2d2G1-f5r90aB0",5,13);
AGR.CHAR("J2.2","J2d2G1-f7r101aB0",7,12);
AGR.CHAR("J2.2","J2d2G1-f7r124aB0",7,14);
AGR.CHAR("J2.2","J2d2G1-f7r126aB0",7,16);
AGR.CHAR("J2.2","J2d2G1-f7r140aB0",7,9);
AGR.CHAR("J2.2","J2d2G1-f7r175aB0",7,18);
AGR.CHAR("J2.2","J2d2G1-f7r199aB0",7,21);
AGR.CHAR("J2.2","J2d2G1-f7r28B0",7,3);
AGR.CHAR("J2.2","J2d2G1-f7r28aB0",7,3);
AGR.CHAR("J2.2","J2d2G1-f7r36aB0",7,5);
AGR.CHAR("J2.2","J2d2G1-f7r378aB0",7,20);
AGR.CHAR("J2.2","J2d2G1-f7r42aB0",7,4);
AGR.CHAR("J2.2","J2d2G1-f7r448aB0",7,23);
AGR.CHAR("J2.2","J2d2G1-f7r63aB0",7,7);
AGR.CHAR("J2.2","J2d2G1-f7r89aB0",7,10);
AGR.CHAR("J2.2","J2d2G1-p100B0",0,[1,5,7]);
AGR.CHAR("J3","J3G1-Zr170B0",0,[2,3],"85ab");
AGR.CHAR("J3","J3G1-f17r1292B0",17,[8,9],"646ab");
AGR.CHAR("J3","J3G1-f17r324B0",17,6,"324a");
AGR.CHAR("J3","J3G1-f17r379B0",17,7,"379a");
AGR.CHAR("J3","J3G1-f17r646cB0",17,[4,5],"323ab");
AGR.CHAR("J3","J3G1-f17r761B0",17,10,"761a");
AGR.CHAR("J3","J3G1-f17r816B0",17,11,"816a");
AGR.CHAR("J3","J3G1-f17r836B0",17,12,"836a");
AGR.CHAR("J3","J3G1-f17r85bB0",17,3,"85b");
AGR.CHAR("J3","J3G1-f19r1001B0",19,11,"1001a");
AGR.CHAR("J3","J3G1-f19r323aB0",19,5,"323a");
AGR.CHAR("J3","J3G1-f19r646aB0",19,7,"646a");
AGR.CHAR("J3","J3G1-f19r85B0",19,2,"85a");
AGR.CHAR("J3","J3G1-f19r919B0",19,10,"919a");
AGR.CHAR("J3","J3G1-f2r244B0",2,7,"244a");
AGR.CHAR("J3","J3G1-f2r248B0",2,[4,5,6],"80a+84ab");
AGR.CHAR("J3","J3G1-f2r80B0",2,4,"80a");
AGR.CHAR("J3","J3G1-f2r966B0",2,10,"966a");
AGR.CHAR("J3","J3G1-f3r324B0",3,8,"324a");
AGR.CHAR("J3","J3G1-f3r934B0",3,9,"934a");
AGR.CHAR("J3","J3G1-f4r322aB0",2,8,"322a");
AGR.CHAR("J3","J3G1-f4r78bB0",2,3,"78b");
AGR.CHAR("J3","J3G1-f4r84aB0",2,5,"84a");
AGR.CHAR("J3","J3G1-f5r323B0",5,4,"323a");
AGR.CHAR("J3","J3G1-f5r646B0",5,5,"646a");
AGR.CHAR("J3","J3G1-f5r816B0",5,6,"816a");
AGR.CHAR("J3","J3G1-f5r85aB0",5,2,"85a");
AGR.CHAR("J3","J3G1-f9r153bB0",3,7,"153b");
AGR.CHAR("J3","J3G1-f9r18bB0",3,3,"18b");
AGR.CHAR("J3","J3G1-f9r84bB0",3,5,"84b");
AGR.CHAR("J3","J3G1-p14688aB0",0,[1,2,3,[10,2],11,12,13,14,15,16,19],"1a+85ab+1140a^2+1215ab+1615a+1920abc+2432a");
AGR.CHAR("J3","J3G1-p14688bB0",0,[1,2,3,[10,2],11,12,13,14,15,16,19],"1a+85ab+1140a^2+1215ab+1615a+1920abc+2432a");
AGR.CHAR("J3","J3G1-p17442B0",0,[1,4,5,6,[9,2],[10,2],11,12,13,14,15,16,20],"1a+323ab+324a+816a^2+1140a^2+1215ab+1615a+1920abc+2754a");
AGR.CHAR("J3","J3G1-p20520B0",0,[1,2,3,6,[10,2],[11,2],[12,2],13,14,15,16,19,21],"1a+85ab+324a+1140a^2+1215a^2b^2+1615a+1920abc+2432a+3078a");
AGR.CHAR("J3","J3G1-p23256B0",0,[1,4,5,6,[10,3],[11,2],[12,2],13,14,15,16,17,18,20],"1a+323ab+324a+1140a^3+1215a^2b^2+1615a+1920abc+1938ab+2754a");
AGR.CHAR("J3","J3G1-p25840B0",0,[1,6,10,[11,2],[12,2],13,14,15,16,17,18,19,20,21],"1a+324a+1140a+1215a^2b^2+1615a+1920abc+1938ab+2432a+2754a+3078a");
AGR.CHAR("J3","J3G1-p26163B0",0,[1,4,5,6,[10,2],[11,2],[12,2],[13,2],14,15,16,17,18,19,20],"1a+323ab+324a+1140a^2+1215a^2b^2+1615a^2+1920abc+1938ab+2432a+2754a");
AGR.CHAR("J3","J3G1-p43605B0",0,[1,4,5,[6,2],[9,2],[10,3],[11,2],[12,2],[13,2],[14,2],[15,2],[16,2],17,18,19,[20,3],21],"1a+323ab+324a^2+816a^2+1140a^3+1215a^2b^2+1615a^2+1920a^2b^2c^2+1938ab+2432a+2754a^3+3078a");
AGR.CHAR("J3","J3G1-p6156B0",0,[1,4,5,6,10,11,12,13],"1a+323ab+324a+1140a+1215ab+1615a");
AGR.CHAR("J3.2","J3d2G1-f17r170aB0",17,3);
AGR.CHAR("J3.2","J3d2G1-f17r324aB0",17,5);
AGR.CHAR("J3.2","J3d2G1-f17r379aB0",17,7);
AGR.CHAR("J3.2","J3d2G1-f17r646aB0",17,4);
AGR.CHAR("J3.2","J3d2G1-f17r836aB0",17,14);
AGR.CHAR("J3.2","J3d2G1-f19r1001aB0",19,15);
AGR.CHAR("J3.2","J3d2G1-f19r110aB0",19,5);
AGR.CHAR("J3.2","J3d2G1-f19r1214aB0",19,19);
AGR.CHAR("J3.2","J3d2G1-f19r214aB0",19,7);
AGR.CHAR("J3.2","J3d2G1-f19r214bB0",19,8);
AGR.CHAR("J3.2","J3d2G1-f19r646aB0",19,9);
AGR.CHAR("J3.2","J3d2G1-f19r706aB0",19,11);
AGR.CHAR("J3.2","J3d2G1-f19r85aB0",19,3);
AGR.CHAR("J3.2","J3d2G1-f19r919aB0",19,13);
AGR.CHAR("J3.2","J3d2G1-f2r168aB0",2,4);
AGR.CHAR("J3.2","J3d2G1-f2r644aB0",2,6);
AGR.CHAR("J3.2","J3d2G1-f3r168aB0",3,4);
AGR.CHAR("J3.2","J3d2G1-f3r306aB0",3,5);
AGR.CHAR("J3.2","J3d2G1-f3r324aB0",3,6);
AGR.CHAR("J3.2","J3d2G1-f3r36B0",3,3);
AGR.CHAR("J3.2","J3d2G1-f3r36aB0",3,3);
AGR.CHAR("J3.2","J3d2G1-f3r934aB0",3,8);
AGR.CHAR("J3.2","J3d2G1-f5r170aB0",5,3);
AGR.CHAR("J3.2","J3d2G1-f5r323bB0",5,5);
AGR.CHAR("J3.2","J3d2G1-f5r646aB0",5,6);
AGR.CHAR("J3.2","J3d2G1-f5r816aB0",5,8);
AGR.CHAR("J3.2","J3d2G1-p6156B0",0,[1,4,6,10,13,15,16]);
AGR.CHAR("L2(11)","L211G1-Ar12aB0",0,7,"12a");
AGR.CHAR("L2(11)","L211G1-Ar12bB0",0,8,"12b");
AGR.CHAR("L2(11)","L211G1-Ar5aB0",0,2,"5a");
AGR.CHAR("L2(11)","L211G1-Ar5bB0",0,3,"5b");
AGR.CHAR("L2(11)","L211G1-Zr10aB0",0,4,"10a");
AGR.CHAR("L2(11)","L211G1-Zr10bB0",0,5,"10b");
AGR.CHAR("L2(11)","L211G1-Zr10cB0",0,[2,3],"5ab");
AGR.CHAR("L2(11)","L211G1-Zr11B0",0,6,"11a");
AGR.CHAR("L2(11)","L211G1-f11r11B0",11,6,"11a");
AGR.CHAR("L2(11)","L211G1-f11r3B0",11,2,"3a");
AGR.CHAR("L2(11)","L211G1-f11r5B0",11,3,"5a");
AGR.CHAR("L2(11)","L211G1-f11r7B0",11,4,"7a");
AGR.CHAR("L2(11)","L211G1-f11r9B0",11,5,"9a");
AGR.CHAR("L2(11)","L211G1-f2r10B0",2,4,"10a");
AGR.CHAR("L2(11)","L211G1-f2r10bB0",2,[2,3],"5ab");
AGR.CHAR("L2(11)","L211G1-f2r24B0",2,[5,6],"12ab");
AGR.CHAR("L2(11)","L211G1-f3r10B0",3,4,"10a");
AGR.CHAR("L2(11)","L211G1-f3r24B0",3,[5,6],"12ab");
AGR.CHAR("L2(11)","L211G1-f3r5aB0",3,2,"5a");
AGR.CHAR("L2(11)","L211G1-f3r5bB0",3,3,"5b");
AGR.CHAR("L2(11)","L211G1-f4r12aB0",2,5,"12a");
AGR.CHAR("L2(11)","L211G1-f4r12bB0",2,6,"12b");
AGR.CHAR("L2(11)","L211G1-f4r5aB0",2,2,"5a");
AGR.CHAR("L2(11)","L211G1-f4r5bB0",2,3,"5b");
AGR.CHAR("L2(11)","L211G1-f5r10aB0",5,4,"10a");
AGR.CHAR("L2(11)","L211G1-f5r10bB0",5,5,"10b");
AGR.CHAR("L2(11)","L211G1-f5r11B0",5,6,"11a");
AGR.CHAR("L2(11)","L211G1-f5r5aB0",5,2,"5a");
AGR.CHAR("L2(11)","L211G1-f5r5bB0",5,3,"5b");
AGR.CHAR("L2(11)","L211G1-f9r12aB0",3,5,"12a");
AGR.CHAR("L2(11)","L211G1-f9r12bB0",3,6,"12b");
AGR.CHAR("L2(11)","L211G1-p11aB0",0,[1,5],"1a+10b");
AGR.CHAR("L2(11)","L211G1-p11bB0",0,[1,5],"1a+10b");
AGR.CHAR("L2(11)","L211G1-p12B0",0,[1,6],"1a+11a");
AGR.CHAR("L2(11)","L211G1-p55B0",0,[1,2,3,[5,2],7,8],"1a+5ab+10b^2+12ab");
AGR.CHAR("L2(11).2","L211d2G1-f11r11B0",11,11);
AGR.CHAR("L2(11).2","L211d2G1-f11r3B0",11,3);
AGR.CHAR("L2(11).2","L211d2G1-f11r5B0",11,5);
AGR.CHAR("L2(11).2","L211d2G1-f11r7B0",11,7);
AGR.CHAR("L2(11).2","L211d2G1-f11r9B0",11,9);
AGR.CHAR("L2(11).2","L211d2G1-f2r10aB0",2,2);
AGR.CHAR("L2(11).2","L211d2G1-f2r10bB0",2,3);
AGR.CHAR("L2(11).2","L211d2G1-f4r12aB0",2,4);
AGR.CHAR("L2(11).2","L211d2G1-f4r12bB0",2,5);
AGR.CHAR("L2(11).2","L211d2G1-p12B0",0,[1,8]);
AGR.CHAR("L2(11).2","L211d2G1-p22B0",0,[1,2,6,7]);
AGR.CHAR("L2(11).2","L211d2G1-p55aB0",0,[1,4,6,7,10,12]);
AGR.CHAR("L2(11).2","L211d2G1-p55bB0",0,[1,3,6,7,10,12]);
AGR.CHAR("L2(11).2","L211d2G1-p66B0",0,[1,3,6,7,8,10,12]);
AGR.CHAR("L2(13)","L213G1-Ar12aB0",0,4,"12a");
AGR.CHAR("L2(13)","L213G1-Ar12bB0",0,5,"12b");
AGR.CHAR("L2(13)","L213G1-Ar12cB0",0,6,"12c");
AGR.CHAR("L2(13)","L213G1-Zr13B0",0,7,"13a");
AGR.CHAR("L2(13)","L213G1-Zr14aB0",0,8,"14a");
AGR.CHAR("L2(13)","L213G1-Zr14bB0",0,9,"14b");
AGR.CHAR("L2(13)","L213G1-Zr14cB0",0,[2,3],"7ab");
AGR.CHAR("L2(13)","L213G1-Zr36B0",0,[4,5,6],"12abc");
AGR.CHAR("L2(13)","L213G1-f13r11B0",13,6,"11a");
AGR.CHAR("L2(13)","L213G1-f13r13B0",13,7,"13a");
AGR.CHAR("L2(13)","L213G1-f13r3B0",13,2,"3a");
AGR.CHAR("L2(13)","L213G1-f13r5B0",13,3,"5a");
AGR.CHAR("L2(13)","L213G1-f13r7B0",13,4,"7a");
AGR.CHAR("L2(13)","L213G1-f13r9B0",13,5,"9a");
AGR.CHAR("L2(13)","L213G1-f2r14B0",2,7,"14a");
AGR.CHAR("L2(13)","L213G1-f3r13B0",3,7,"13a");
AGR.CHAR("L2(13)","L213G1-f4r6aB0",2,3,"6b");
AGR.CHAR("L2(13)","L213G1-f4r6bB0",2,2,"6a");
AGR.CHAR("L2(13)","L213G1-f7r12B0",7,4,"12a");
AGR.CHAR("L2(13)","L213G1-f8r12aB0",2,4,"12a");
AGR.CHAR("L2(13)","L213G1-f8r12bB0",2,5,"12b");
AGR.CHAR("L2(13)","L213G1-f8r12cB0",2,6,"12c");
AGR.CHAR("L2(13)","L213G1-p14B0",0,[1,7],"1a+13a");
AGR.CHAR("L2(13).2","L213d2G1-f13r3aB0",13,3);
AGR.CHAR("L2(13).2","L213d2G1-f2r12aB0",2,2);
AGR.CHAR("L2(13).2","L213d2G1-f2r14B0",2,6);
AGR.CHAR("L2(13).2","L213d2G1-p14B0",0,[1,11]);
AGR.CHAR("L2(13).2","L213d2G1-p78B0",0,[1,4,6,8,10,12,13]);
AGR.CHAR("L2(13).2","L213d2G1-p91aB0",0,[1,4,6,8,10,11,12,13]);
AGR.CHAR("L2(16)","L216G1-Zr120B0",0,[2,3,4,5,6,7,8,9],"15abcdefgh");
AGR.CHAR("L2(16)","L216G1-Zr16B0",0,10,"16a");
AGR.CHAR("L2(16)","L216G1-Zr17aB0",0,11,"17a");
AGR.CHAR("L2(16)","L216G1-Zr34B0",0,[12,13],"17bc");
AGR.CHAR("L2(16)","L216G1-Zr68B0",0,[14,15,16,17],"17defg");
AGR.CHAR("L2(16)","L216G1-f16r2aB0",2,2,"2a");
AGR.CHAR("L2(16)","L216G1-f17r15B0",17,2,"15a");
AGR.CHAR("L2(16)","L216G1-f17r17B0",17,3,"17a");
AGR.CHAR("L2(16)","L216G1-f17r34B0",17,[4,5],"17bc");
AGR.CHAR("L2(16)","L216G1-f17r68B0",17,[6,7,8,9],"17defg");
AGR.CHAR("L2(16)","L216G1-f3r16B0",3,10,"16a");
AGR.CHAR("L2(16)","L216G1-f5r16B0",5,10,"16a");
AGR.CHAR("L2(16)","L216G1-f9r17aB0",3,11,"17a");
AGR.CHAR("L2(16)","L216G1-f9r17bB0",3,12,"17b");
AGR.CHAR("L2(16)","L216G1-p17B0",0,[1,10],"1a+16a");
AGR.CHAR("L2(16).2","L216d2G1-f4r4aB0",2,2);
AGR.CHAR("L2(16).4","L216d4G1-f17r15aB0",17,5);
AGR.CHAR("L2(16).4","L216d4G1-f17r17aB0",17,9);
AGR.CHAR("L2(16).4","L216d4G1-f17r34aB0",17,13);
AGR.CHAR("L2(16).4","L216d4G1-f17r68B0",17,15);
AGR.CHAR("L2(16).4","L216d4G1-f25r60aB0",5,5);
AGR.CHAR("L2(16).4","L216d4G1-f25r60bB0",5,6);
AGR.CHAR("L2(16).4","L216d4G1-f2r16aB0",2,4);
AGR.CHAR("L2(16).4","L216d4G1-f2r16bB0",2,6);
AGR.CHAR("L2(16).4","L216d4G1-f2r32B0",2,5);
AGR.CHAR("L2(16).4","L216d4G1-f2r8aB0",2,2);
AGR.CHAR("L2(16).4","L216d4G1-f2r8bB0",2,3);
AGR.CHAR("L2(16).4","L216d4G1-f3r16aB0",3,7);
AGR.CHAR("L2(16).4","L216d4G1-f5r16aB0",5,7);
AGR.CHAR("L2(16).4","L216d4G1-f5r17aB0",5,11);
AGR.CHAR("L2(16).4","L216d4G1-f9r60aB0",3,5);
AGR.CHAR("L2(16).4","L216d4G1-f9r60bB0",3,6);
AGR.CHAR("L2(17)","L217G1-Ar9aB0",0,2,"9a");
AGR.CHAR("L2(17)","L217G1-Ar9bB0",0,3,"9b");
AGR.CHAR("L2(17)","L217G1-Zr16aB0",0,4,"16a");
AGR.CHAR("L2(17)","L217G1-Zr17B0",0,8,"17a");
AGR.CHAR("L2(17)","L217G1-Zr18aB0",0,9,"18a");
AGR.CHAR("L2(17)","L217G1-Zr18dB0",0,[2,3],"9ab");
AGR.CHAR("L2(17)","L217G1-Zr48B0",0,[5,6,7],"16bcd");
AGR.CHAR("L2(17)","L217G1-f17r11B0",17,6,"11a");
AGR.CHAR("L2(17)","L217G1-f17r13B0",17,7,"13a");
AGR.CHAR("L2(17)","L217G1-f17r15B0",17,8,"15a");
AGR.CHAR("L2(17)","L217G1-f17r17B0",17,9,"17a");
AGR.CHAR("L2(17)","L217G1-f17r3B0",17,2,"3a");
AGR.CHAR("L2(17)","L217G1-f17r5B0",17,3,"5a");
AGR.CHAR("L2(17)","L217G1-f17r7B0",17,4,"7a");
AGR.CHAR("L2(17)","L217G1-f17r9B0",17,5,"9a");
AGR.CHAR("L2(17)","L217G1-f2r16aB0",2,4,"16a");
AGR.CHAR("L2(17)","L217G1-f2r48B0",2,[5,6,7],"16bcd");
AGR.CHAR("L2(17)","L217G1-f2r8aB0",2,2,"8a");
AGR.CHAR("L2(17)","L217G1-f2r8bB0",2,3,"8b");
AGR.CHAR("L2(17)","L217G1-f3r16B0",3,4,"16a");
AGR.CHAR("L2(17)","L217G1-f3r18aB0",3,5,"18a");
AGR.CHAR("L2(17)","L217G1-f8r16bB0",2,5,"16b");
AGR.CHAR("L2(17)","L217G1-f8r16cB0",2,6,"16c");
AGR.CHAR("L2(17)","L217G1-f8r16dB0",2,7,"16d");
AGR.CHAR("L2(17)","L217G1-f9r18bB0",3,6,"18b");
AGR.CHAR("L2(17)","L217G1-f9r18cB0",3,7,"18c");
AGR.CHAR("L2(17)","L217G1-f9r9aB0",3,2,"9a");
AGR.CHAR("L2(17)","L217G1-f9r9bB0",3,3,"9b");
AGR.CHAR("L2(17)","L217G1-p18B0",0,[1,8],"1a+17a");
AGR.CHAR("L2(19)","L219G1-Zr18eB0",0,[2,3],"9ab");
AGR.CHAR("L2(19)","L219G1-Zr19B0",0,8,"19a");
AGR.CHAR("L2(19)","L219G1-Zr20aB0",0,9,"20a");
AGR.CHAR("L2(19)","L219G1-Zr36aB0",0,[4,5],"18ab");
AGR.CHAR("L2(19)","L219G1-f125r20bB0",5,6,"20b");
AGR.CHAR("L2(19)","L219G1-f125r20cB0",5,7,"20c");
AGR.CHAR("L2(19)","L219G1-f125r20dB0",5,8,"20d");
AGR.CHAR("L2(19)","L219G1-f19r11B0",19,6,"11a");
AGR.CHAR("L2(19)","L219G1-f19r13B0",19,7,"13a");
AGR.CHAR("L2(19)","L219G1-f19r15B0",19,8,"15a");
AGR.CHAR("L2(19)","L219G1-f19r17B0",19,9,"17a");
AGR.CHAR("L2(19)","L219G1-f19r19B0",19,10,"19a");
AGR.CHAR("L2(19)","L219G1-f19r3B0",19,2,"3a");
AGR.CHAR("L2(19)","L219G1-f19r5B0",19,3,"5a");
AGR.CHAR("L2(19)","L219G1-f19r7B0",19,4,"7a");
AGR.CHAR("L2(19)","L219G1-f19r9B0",19,5,"9a");
AGR.CHAR("L2(19)","L219G1-f2r20aB0",2,6,"20a");
AGR.CHAR("L2(19)","L219G1-f3r19B0",3,8,"19a");
AGR.CHAR("L2(19)","L219G1-f4r18aB0",2,4,"18a");
AGR.CHAR("L2(19)","L219G1-f4r18bB0",2,5,"18b");
AGR.CHAR("L2(19)","L219G1-f4r9aB0",2,2,"9a");
AGR.CHAR("L2(19)","L219G1-f4r9bB0",2,3,"9b");
AGR.CHAR("L2(19)","L219G1-f5r18B0",5,4,"18a");
AGR.CHAR("L2(19)","L219G1-f5r20aB0",5,5,"20a");
AGR.CHAR("L2(19)","L219G1-f5r9aB0",5,2,"9a");
AGR.CHAR("L2(19)","L219G1-f5r9bB0",5,3,"9b");
AGR.CHAR("L2(19)","L219G1-f8r20bB0",2,7,"20b");
AGR.CHAR("L2(19)","L219G1-f8r20cB0",2,8,"20c");
AGR.CHAR("L2(19)","L219G1-f8r20dB0",2,9,"20d");
AGR.CHAR("L2(19)","L219G1-f9r18aB0",3,4,"18a");
AGR.CHAR("L2(19)","L219G1-f9r18bB0",3,5,"18b");
AGR.CHAR("L2(19)","L219G1-f9r18cB0",3,6,"18c");
AGR.CHAR("L2(19)","L219G1-f9r18dB0",3,7,"18d");
AGR.CHAR("L2(19)","L219G1-f9r9aB0",3,2,"9a");
AGR.CHAR("L2(19)","L219G1-f9r9bB0",3,3,"9b");
AGR.CHAR("L2(19)","L219G1-p171B0",0,[1,2,3,[6,2],[7,2],9,10,11,12],"1a+9ab+18c^2d^2+20abcd");
AGR.CHAR("L2(19)","L219G1-p190B0",0,[1,2,3,[6,2],[7,2],8,9,10,11,12],"1a+9ab+18c^2d^2+19a+20abcd");
AGR.CHAR("L2(19)","L219G1-p20B0",0,[1,8],"1a+19a");
AGR.CHAR("L2(19)","L219G1-p57aB0",0,[1,6,7,9],"1a+18cd+20a");
AGR.CHAR("L2(19)","L219G1-p57bB0",0,[1,6,7,9],"1a+18cd+20a");
AGR.CHAR("L2(19).2","L219d2G1-f19r3B0",19,3);
AGR.CHAR("L2(19).2","L219d2G1-p114B0",0,[1,2,8,9,10,11,14,15]);
AGR.CHAR("L2(19).2","L219d2G1-p171B0",0,[1,3,8,9,10,11,14,16,18,20]);
AGR.CHAR("L2(19).2","L219d2G1-p190B0",0,[1,3,8,9,10,11,12,14,16,18,20]);
AGR.CHAR("L2(19).2","L219d2G1-p20B0",0,[1,12]);
AGR.CHAR("L2(19).2","L219d2G1-p285B0",0,[1,3,4,6,8,9,10,11,12,13,[14,2],15,16,18,20]);
AGR.CHAR("L2(23)","L223G1-Ar24aB0",0,10,"24a");
AGR.CHAR("L2(23)","L223G1-Ar24bB0",0,11,"24b");
AGR.CHAR("L2(23)","L223G1-Ar24cB0",0,12,"24c");
AGR.CHAR("L2(23)","L223G1-Ar24dB0",0,13,"24d");
AGR.CHAR("L2(23)","L223G1-Ar24eB0",0,14,"24e");
AGR.CHAR("L2(23)","L223G1-Zr22aB0",0,4,"22a");
AGR.CHAR("L2(23)","L223G1-Zr22bB0",0,5,"22b");
AGR.CHAR("L2(23)","L223G1-Zr22cB0",0,6,"22c");
AGR.CHAR("L2(23)","L223G1-Zr23B0",0,9,"23a");
AGR.CHAR("L2(23)","L223G1-f11r23B0",11,9,"23a");
AGR.CHAR("L2(23)","L223G1-f23r11B0",23,6,"11a");
AGR.CHAR("L2(23)","L223G1-f23r13B0",23,7,"13a");
AGR.CHAR("L2(23)","L223G1-f23r15B0",23,8,"15a");
AGR.CHAR("L2(23)","L223G1-f23r17B0",23,9,"17a");
AGR.CHAR("L2(23)","L223G1-f23r19B0",23,10,"19a");
AGR.CHAR("L2(23)","L223G1-f23r21B0",23,11,"21a");
AGR.CHAR("L2(23)","L223G1-f23r23B0",23,12,"23a");
AGR.CHAR("L2(23)","L223G1-f23r3B0",23,2,"3a");
AGR.CHAR("L2(23)","L223G1-f23r5B0",23,3,"5a");
AGR.CHAR("L2(23)","L223G1-f23r7B0",23,4,"7a");
AGR.CHAR("L2(23)","L223G1-f23r9B0",23,5,"9a");
AGR.CHAR("L2(23)","L223G1-f2r11aB0",2,2,"11a");
AGR.CHAR("L2(23)","L223G1-f2r11bB0",2,3,"11b");
AGR.CHAR("L2(23)","L223G1-f2r22B0",2,4,"22a");
AGR.CHAR("L2(23)","L223G1-f32r24aB0",2,5,"24a");
AGR.CHAR("L2(23)","L223G1-f32r24bB0",2,6,"24b");
AGR.CHAR("L2(23)","L223G1-f32r24cB0",2,7,"24c");
AGR.CHAR("L2(23)","L223G1-f32r24dB0",2,8,"24d");
AGR.CHAR("L2(23)","L223G1-f32r24eB0",2,9,"24e");
AGR.CHAR("L2(23)","L223G1-f3r22aB0",3,4,"22a");
AGR.CHAR("L2(23)","L223G1-p24B0",0,[1,9],"1a+23a");
AGR.CHAR("L2(23).2","L223d2G1-f23r3aB0",23,3);
AGR.CHAR("L2(23).2","L223d2G1-f2r22aB0",2,2);
AGR.CHAR("L2(27)","L227G1-Ar13aB0",0,2,"13a");
AGR.CHAR("L2(27)","L227G1-Ar13bB0",0,3,"13b");
AGR.CHAR("L2(27)","L227G1-Ar28aB0",0,11,"28a");
AGR.CHAR("L2(27)","L227G1-Ar28bB0",0,12,"28b");
AGR.CHAR("L2(27)","L227G1-Ar28cB0",0,13,"28c");
AGR.CHAR("L2(27)","L227G1-Ar28dB0",0,14,"28d");
AGR.CHAR("L2(27)","L227G1-Ar28eB0",0,15,"28e");
AGR.CHAR("L2(27)","L227G1-Ar28fB0",0,16,"28f");
AGR.CHAR("L2(27)","L227G1-Zr26gB0",0,[2,3],"13ab");
AGR.CHAR("L2(27)","L227G1-Zr27B0",0,10,"27a");
AGR.CHAR("L2(27)","L227G1-Zr78aB0",0,[4,5,6],"26abc");
AGR.CHAR("L2(27)","L227G1-f13r27B0",13,10,"27a");
AGR.CHAR("L2(27)","L227G1-f27r3aB0",3,2,"3a");
AGR.CHAR("L2(27)","L227G1-f3r27B0",3,14,"27a");
AGR.CHAR("L2(27)","L227G1-f4r13aB0",2,2,"13a");
AGR.CHAR("L2(27)","L227G1-f4r13bB0",2,3,"13b");
AGR.CHAR("L2(27)","L227G1-f7r26B0",7,4,"26a");
AGR.CHAR("L2(27)","L227G1-p28B0",0,[1,10],"1a+27a");
AGR.CHAR("L2(29)","L229G1-Ar30aB0",0,12,"30a");
AGR.CHAR("L2(29)","L229G1-Ar30bB0",0,13,"30b");
AGR.CHAR("L2(29)","L229G1-Ar30cB0",0,14,"30c");
AGR.CHAR("L2(29)","L229G1-Ar30dB0",0,15,"30d");
AGR.CHAR("L2(29)","L229G1-Ar30eB0",0,16,"30e");
AGR.CHAR("L2(29)","L229G1-Ar30fB0",0,17,"30f");
AGR.CHAR("L2(29)","L229G1-Zr112B0",0,[7,8,9,10],"28defg");
AGR.CHAR("L2(29)","L229G1-Zr28aB0",0,4,"28a");
AGR.CHAR("L2(29)","L229G1-Zr29B0",0,11,"29a");
AGR.CHAR("L2(29)","L229G1-Zr30gB0",0,[2,3],"15ab");
AGR.CHAR("L2(29)","L229G1-Zr56B0",0,[5,6],"28bc");
AGR.CHAR("L2(29)","L229G1-f29r11B0",29,6,"11a");
AGR.CHAR("L2(29)","L229G1-f29r13B0",29,7,"13a");
AGR.CHAR("L2(29)","L229G1-f29r15B0",29,8,"15a");
AGR.CHAR("L2(29)","L229G1-f29r17B0",29,9,"17a");
AGR.CHAR("L2(29)","L229G1-f29r19B0",29,10,"19a");
AGR.CHAR("L2(29)","L229G1-f29r21B0",29,11,"21a");
AGR.CHAR("L2(29)","L229G1-f29r23B0",29,12,"23a");
AGR.CHAR("L2(29)","L229G1-f29r25B0",29,13,"25a");
AGR.CHAR("L2(29)","L229G1-f29r27B0",29,14,"27a");
AGR.CHAR("L2(29)","L229G1-f29r29B0",29,15,"29a");
AGR.CHAR("L2(29)","L229G1-f29r3B0",29,2,"3a");
AGR.CHAR("L2(29)","L229G1-f29r5B0",29,3,"5a");
AGR.CHAR("L2(29)","L229G1-f29r7B0",29,4,"7a");
AGR.CHAR("L2(29)","L229G1-f29r9B0",29,5,"9a");
AGR.CHAR("L2(29)","L229G1-f3r28aB0",3,4,"28a");
AGR.CHAR("L2(29)","L229G1-f4r14aB0",2,2,"14a");
AGR.CHAR("L2(29)","L229G1-f4r14bB0",2,3,"14b");
AGR.CHAR("L2(29)","L229G1-f5r28bB0",5,5,"28b");
AGR.CHAR("L2(29)","L229G1-f7r29B0",7,11,"29a");
AGR.CHAR("L2(29)","L229G1-p30B0",0,[1,11],"1a+29a");
AGR.CHAR("L2(31)","L231G1-Ar32aB0",0,16,"32e");
AGR.CHAR("L2(31)","L231G1-Ar32bB0",0,13,"32b");
AGR.CHAR("L2(31)","L231G1-Ar32cB0",0,14,"32c");
AGR.CHAR("L2(31)","L231G1-Ar32dB0",0,15,"32d");
AGR.CHAR("L2(31)","L231G1-Ar32eB0",0,16,"32e");
AGR.CHAR("L2(31)","L231G1-Ar32fB0",0,17,"32f");
AGR.CHAR("L2(31)","L231G1-Ar32gB0",0,18,"32g");
AGR.CHAR("L2(31)","L231G1-Zr120B0",0,[7,8,9,10],"30defg");
AGR.CHAR("L2(31)","L231G1-Zr30aB0",0,4,"30a");
AGR.CHAR("L2(31)","L231G1-Zr30hB0",0,[2,3],"15ab");
AGR.CHAR("L2(31)","L231G1-Zr31B0",0,11,"31a");
AGR.CHAR("L2(31)","L231G1-Zr32aB0",0,12,"32a");
AGR.CHAR("L2(31)","L231G1-Zr60B0",0,[5,6],"30bc");
AGR.CHAR("L2(31)","L231G1-f16r32dB0",2,7,"32d");
AGR.CHAR("L2(31)","L231G1-f16r32eB0",2,8,"32e");
AGR.CHAR("L2(31)","L231G1-f16r32fB0",2,9,"32f");
AGR.CHAR("L2(31)","L231G1-f16r32gB0",2,10,"32g");
AGR.CHAR("L2(31)","L231G1-f2r15aB0",2,2,"15a");
AGR.CHAR("L2(31)","L231G1-f2r15bB0",2,3,"15b");
AGR.CHAR("L2(31)","L231G1-f2r32B0",2,4,"32a");
AGR.CHAR("L2(31)","L231G1-f31r31B0",31,16,"31a");
AGR.CHAR("L2(31)","L231G1-f31r3B0",31,2,"3a");
AGR.CHAR("L2(31)","L231G1-f3r31B0",3,11,"31a");
AGR.CHAR("L2(31)","L231G1-f4r32bB0",2,5,"32b");
AGR.CHAR("L2(31)","L231G1-f4r32cB0",2,6,"32c");
AGR.CHAR("L2(31)","L231G1-f5r31B0",5,11,"31a");
AGR.CHAR("L2(31)","L231G1-p32B0",0,[1,11],"1a+31a");
AGR.CHAR("L2(32)","L232G1-Ar33aB0",0,19,"33a");
AGR.CHAR("L2(32)","L232G1-Ar33bB0",0,20,"33b");
AGR.CHAR("L2(32)","L232G1-Ar33cB0",0,21,"33c");
AGR.CHAR("L2(32)","L232G1-Ar33dB0",0,22,"33d");
AGR.CHAR("L2(32)","L232G1-Ar33eB0",0,23,"33e");
AGR.CHAR("L2(32)","L232G1-Ar33fB0",0,24,"33f");
AGR.CHAR("L2(32)","L232G1-Ar33gB0",0,25,"33g");
AGR.CHAR("L2(32)","L232G1-Ar33hB0",0,26,"33h");
AGR.CHAR("L2(32)","L232G1-Ar33iB0",0,27,"33i");
AGR.CHAR("L2(32)","L232G1-Ar33jB0",0,28,"33j");
AGR.CHAR("L2(32)","L232G1-Ar33kB0",0,29,"33k");
AGR.CHAR("L2(32)","L232G1-Ar33lB0",0,30,"33l");
AGR.CHAR("L2(32)","L232G1-Ar33mB0",0,31,"33m");
AGR.CHAR("L2(32)","L232G1-Ar33nB0",0,32,"33n");
AGR.CHAR("L2(32)","L232G1-Ar33oB0",0,33,"33o");
AGR.CHAR("L2(32)","L232G1-Zr155B0",0,[3,4,5,6,7],"31bcdef");
AGR.CHAR("L2(32)","L232G1-Zr310B0",0,[8,9,10,11,12,13,14,15,16,17],"31ghijklmnop");
AGR.CHAR("L2(32)","L232G1-Zr31aB0",0,2,"31a");
AGR.CHAR("L2(32)","L232G1-Zr32B0",0,18,"32a");
AGR.CHAR("L2(32)","L232G1-f11r31bB0",11,3,"31b");
AGR.CHAR("L2(32)","L232G1-f31r32B0",31,18,"32a");
AGR.CHAR("L2(32)","L232G1-f32r2aB0",2,2,"2a");
AGR.CHAR("L2(32)","L232G1-f3r31aB0",3,2,"31a");
AGR.CHAR("L2(32)","L232G1-p33B0",0,[1,18],"1a+32a");
AGR.CHAR("L2(32)","L232G1-p496B0",0,[1,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33],"1a+33abcdefghijklmno");
AGR.CHAR("L2(32)","L232G1-p528B0",0,[1,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33],"1a+32a+33abcdefghijklmno");
AGR.CHAR("L2(32).5","L232d5G1-f2r10B0",2,6);
AGR.CHAR("L2(32).5","L232d5G1-f2r20aB0",2,7);
AGR.CHAR("L2(32).5","L232d5G1-f2r20bB0",2,8);
AGR.CHAR("L2(32).5","L232d5G1-f2r32B0",2,12);
AGR.CHAR("L2(32).5","L232d5G1-f2r40aB0",2,9);
AGR.CHAR("L2(32).5","L232d5G1-f2r40bB0",2,10);
AGR.CHAR("L2(32).5","L232d5G1-f2r80B0",2,11);
AGR.CHAR("L2(32).5","L232d5G1-p33B0",0,[1,14]);
AGR.CHAR("L2(32).5","L232d5G1-p496B0",0,[1,19,20,21]);
AGR.CHAR("L2(32).5","L232d5G1-p528B0",0,[1,14,19,20,21]);
AGR.CHAR("L2(8)","L28G1-Ar7bB0",0,3,"7b");
AGR.CHAR("L2(8)","L28G1-Ar7cB0",0,4,"7c");
AGR.CHAR("L2(8)","L28G1-Ar7dB0",0,5,"7d");
AGR.CHAR("L2(8)","L28G1-Ar9aB0",0,7,"9a");
AGR.CHAR("L2(8)","L28G1-Ar9bB0",0,8,"9b");
AGR.CHAR("L2(8)","L28G1-Ar9cB0",0,9,"9c");
AGR.CHAR("L2(8)","L28G1-Zr27B0",0,[7,8,9],"9abc");
AGR.CHAR("L2(8)","L28G1-Zr7aB0",0,2,"7a");
AGR.CHAR("L2(8)","L28G1-Zr8B0",0,6,"8a");
AGR.CHAR("L2(8)","L28G1-f27r9aB0",3,3,"9a");
AGR.CHAR("L2(8)","L28G1-f27r9bB0",3,4,"9b");
AGR.CHAR("L2(8)","L28G1-f27r9cB0",3,5,"9c");
AGR.CHAR("L2(8)","L28G1-f2r12B0",2,[5,6,7],"4abc");
AGR.CHAR("L2(8)","L28G1-f2r6B0",2,[2,3,4],"2abc");
AGR.CHAR("L2(8)","L28G1-f2r8B0",2,8,"8a");
AGR.CHAR("L2(8)","L28G1-f3r27B0",3,[3,4,5],"9abc");
AGR.CHAR("L2(8)","L28G1-f3r7B0",3,2,"7a");
AGR.CHAR("L2(8)","L28G1-f7r21B0",7,[3,4,5],"7bcd");
AGR.CHAR("L2(8)","L28G1-f7r7aB0",7,2,"7a");
AGR.CHAR("L2(8)","L28G1-f7r8B0",7,6,"8a");
AGR.CHAR("L2(8)","L28G1-f8r2aB0",2,2,"2a");
AGR.CHAR("L2(8)","L28G1-f8r2bB0",2,3,"2b");
AGR.CHAR("L2(8)","L28G1-f8r2cB0",2,4,"2c");
AGR.CHAR("L2(8)","L28G1-f8r4aB0",2,5,"4a");
AGR.CHAR("L2(8)","L28G1-f8r4bB0",2,6,"4b");
AGR.CHAR("L2(8)","L28G1-f8r4cB0",2,7,"4c");
AGR.CHAR("L2(8)","L28G1-p28B0",0,[1,7,8,9],"1a+9abc");
AGR.CHAR("L2(8)","L28G1-p36B0",0,[1,6,7,8,9],"1a+8a+9abc");
AGR.CHAR("L2(8)","L28G1-p9B0",0,[1,6],"1a+8a");
AGR.CHAR("L2(8).3","L28d3G1-Zr21B0",0,7);
AGR.CHAR("L2(8).3","L28d3G1-Zr27B0",0,11);
AGR.CHAR("L2(8).3","L28d3G1-Zr7B0",0,4);
AGR.CHAR("L2(8).3","L28d3G1-Zr8B0",0,8);
AGR.CHAR("L2(8).3","L28d3G1-f2r12B0",2,5);
AGR.CHAR("L2(8).3","L28d3G1-f2r6B0",2,4);
AGR.CHAR("L2(8).3","L28d3G1-f2r8B0",2,6);
AGR.CHAR("L2(8).3","L28d3G1-f3r27B0",3,3);
AGR.CHAR("L2(8).3","L28d3G1-f3r7B0",3,2);
AGR.CHAR("L2(8).3","L28d3G1-f7r21B0",7,7);
AGR.CHAR("L2(8).3","L28d3G1-f7r7B0",7,4);
AGR.CHAR("L2(8).3","L28d3G1-f7r8B0",7,8);
AGR.CHAR("L2(8).3","L28d3G1-p28B0",0,[1,11]);
AGR.CHAR("L2(8).3","L28d3G1-p36B0",0,[1,8,11]);
AGR.CHAR("L2(8).3","L28d3G1-p9B0",0,[1,8]);
AGR.CHAR("L3(4).2_1","L34d2aG1-f2r16aB0",2,2);
AGR.CHAR("L3(4).2_1","L34d2aG1-f2r18aB0",2,3);
AGR.CHAR("L3(4).2_1","L34d2aG1-f2r64aB0",2,4);
AGR.CHAR("L3(4).2_1","L34d2aG1-f3r126aB0",3,12);
AGR.CHAR("L3(4).2_1","L34d2aG1-f3r15aB0",3,3);
AGR.CHAR("L3(4).2_1","L34d2aG1-f3r15bB0",3,5);
AGR.CHAR("L3(4).2_1","L34d2aG1-f3r15cB0",3,7);
AGR.CHAR("L3(4).2_1","L34d2aG1-f3r19aB0",3,9);
AGR.CHAR("L3(4).2_1","L34d2aG1-f3r90aB0",3,11);
AGR.CHAR("L3(4).2_1","L34d2aG1-f5r20aB0",5,3);
AGR.CHAR("L3(4).2_1","L34d2aG1-f5r35aB0",5,5);
AGR.CHAR("L3(4).2_1","L34d2aG1-f5r35bB0",5,7);
AGR.CHAR("L3(4).2_1","L34d2aG1-f5r35cB0",5,9);
AGR.CHAR("L3(4).2_1","L34d2aG1-f5r63aB0",5,12);
AGR.CHAR("L3(4).2_1","L34d2aG1-f5r90aB0",5,11);
AGR.CHAR("L3(4).2_1","L34d2aG1-f7r126aB0",7,13);
AGR.CHAR("L3(4).2_1","L34d2aG1-f7r19aB0",7,3);
AGR.CHAR("L3(4).2_1","L34d2aG1-f7r35aB0",7,5);
AGR.CHAR("L3(4).2_1","L34d2aG1-f7r35bB0",7,7);
AGR.CHAR("L3(4).2_1","L34d2aG1-f7r35cB0",7,9);
AGR.CHAR("L3(4).2_1","L34d2aG1-f7r45aB0",7,11);
AGR.CHAR("L3(7)","L37G1-Zr152aB0",0,4,"152a");
AGR.CHAR("L3(7)","L37G1-Zr152bB0",0,5,"152b");
AGR.CHAR("L3(7)","L37G1-Zr152cB0",0,6,"152c");
AGR.CHAR("L3(7)","L37G1-Zr56B0",0,2,"56a");
AGR.CHAR("L3(7)","L37G1-Zr57B0",0,3,"57a");
AGR.CHAR("L3(7)","L37G1-f2r152aB0",2,3,"152a");
AGR.CHAR("L3(7)","L37G1-f3r342aB0",3,13,"342a");
AGR.CHAR("L3(7)","L37G1-f3r399B0",3,20,"399a");
AGR.CHAR("L3(7)","L37G1-f3r55B0",3,2,"55a");
AGR.CHAR("L3(7)","L37G1-f3r57B0",3,3,"57a");
AGR.CHAR("L3(7)","L37G1-f3r96aB0",3,4,"96a");
AGR.CHAR("L3(7)","L37G1-f3r96bB0",3,5,"96b");
AGR.CHAR("L3(7)","L37G1-f3r96cB0",3,6,"96c");
AGR.CHAR("L3(7)","L37G1-f7r10aB0",7,3,"10a");
AGR.CHAR("L3(7)","L37G1-f7r10bB0",7,4,"10b");
AGR.CHAR("L3(7)","L37G1-f7r27B0",7,5,"27a");
AGR.CHAR("L3(7)","L37G1-f7r8B0",7,2,"8a");
AGR.CHAR("L3(7)","L37G1-p57B0",0,[1,2],"1a+56a");
AGR.CHAR("L3(7).2","L37d2G1-f2r152B0",2,3);
AGR.CHAR("L3(7).2","L37d2G1-f2r342B0",2,8);
AGR.CHAR("L3(7).2","L37d2G1-f2r56B0",2,2);
AGR.CHAR("L3(7).2","L37d2G1-f3r192B0",3,9);
AGR.CHAR("L3(7).2","L37d2G1-f3r399B0",3,21);
AGR.CHAR("L3(7).2","L37d2G1-f3r55B0",3,3);
AGR.CHAR("L3(7).2","L37d2G1-f3r57B0",3,5);
AGR.CHAR("L3(7).2","L37d2G1-f3r96B0",3,7);
AGR.CHAR("L3(7).2","L37d2G1-f7r343B0",7,18);
AGR.CHAR("L3(7).2","L37d2G1-f7r56B0",7,8);
AGR.CHAR("L3(8)","L38G1-Zr72B0",0,2,"72a");
AGR.CHAR("L3(8)","L38G1-f2r27B0",2,35,"27a");
AGR.CHAR("L3(8)","L38G1-f2r512B0",2,64,"512a");
AGR.CHAR("L3(8)","L38G1-f343r511B0",7,28,"511b");
AGR.CHAR("L3(8)","L38G1-f3r511B0",3,33,"511a");
AGR.CHAR("L3(8)","L38G1-f3r72B0",3,2,"72a");
AGR.CHAR("L3(8)","L38G1-f73r441B0",73,9,"441a");
AGR.CHAR("L3(8)","L38G1-f73r511aB0",73,10,"511a");
AGR.CHAR("L3(8)","L38G1-f73r511bB0",73,11,"511b");
AGR.CHAR("L3(8)","L38G1-f73r71B0",73,2,"71a");
AGR.CHAR("L3(8)","L38G1-f7r511B0",7,27,"511a");
AGR.CHAR("L3(8)","L38G1-f7r512B0",7,31,"512a");
AGR.CHAR("L3(8)","L38G1-f7r72B0",7,2,"72a");
AGR.CHAR("L3(8)","L38G1-p56064B0",0,[1,[2,2],3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,[34,2],[35,2],[36,2],37,38,39,40,41,42,[43,2],[44,2],[45,2],[46,2],[47,2],[48,2],[49,2],[50,2],[51,2],[52,2],[53,2],[54,2],[55,2],[56,2],[57,2],[58,2],[59,2],[60,2],[61,2],[62,2],[63,2],[64,2],[65,2],[66,2],[67,2],[68,3],[69,3],[70,4],[71,4],[72,4]],"1a+72a^2+73abcdef+441abcdefghijklmnopqrstuvwx+511ab^2c^2d^2efghijk^2l^2m^2n^2o^2p^2q^2r^2s^2t^2u^2v^2w^2x^2y^2z^2(a')^2(b')^2+512a^2+584a^2b^2c^2d^2e^2f^2+657a^3b^3c^4d^4e^4");
AGR.CHAR("L3(8)","L38G1-p73aB0",0,[1,2],"1a+72a");
AGR.CHAR("L3(8)","L38G1-p73bB0",0,[1,2],"1a+72a");
AGR.CHAR("L3(8)","L38G1-p75264B0",0,[1,3,4,5,6,7,8,[9,2],[10,2],[11,2],[12,2],[13,2],[14,2],[15,2],[16,2],[17,2],[18,2],[19,2],[20,2],[21,2],[22,2],[23,2],[24,2],[25,2],[26,2],[27,2],[28,2],[29,2],[30,2],[31,2],[32,2],33,[34,3],[35,3],[36,3],37,38,39,40,41,42,[43,3],[44,3],[45,3],[46,3],[47,3],[48,3],[49,3],[50,3],[51,3],[52,3],[53,3],[54,3],[55,3],[56,3],[57,3],[58,3],[59,3],[60,3],[61,2],[62,2],[63,2],[64,2],[65,2],[66,2],[67,2],[68,3],[69,3],[70,3],[71,3],[72,3]],"1a+73abcdef+441a^2b^2c^2d^2e^2f^2g^2h^2i^2j^2k^2l^2m^2n^2o^2p^2q^2r^2s^2t^2u^2v^2w^2x^2+511ab^3c^3d^3efghijk^3l^3m^3n^3o^3p^3q^3r^3s^3t^3u^3v^3w^3x^3y^3z^3(a')^3(b')^3+512a^2+584a^2b^2c^2d^2e^2f^2+657a^3b^3c^3d^3e^3");
AGR.CHAR("L3(8)","L38G1-p98112B0",0,[1,[2,2],[3,2],[4,2],[5,2],[6,2],[7,2],[8,2],[9,2],[10,2],[11,2],[12,2],[13,2],[14,2],[15,2],[16,2],[17,2],[18,2],[19,2],[20,2],[21,2],[22,2],[23,2],[24,2],[25,2],[26,2],[27,2],[28,2],[29,2],[30,2],[31,2],[32,2],[33,2],[34,3],[35,3],[36,3],[37,2],[38,2],[39,2],[40,2],[41,2],[42,2],[43,3],[44,3],[45,3],[46,3],[47,3],[48,3],[49,3],[50,3],[51,3],[52,3],[53,3],[54,3],[55,3],[56,3],[57,3],[58,3],[59,3],[60,3],[61,3],[62,4],[63,4],[64,4],[65,4],[66,4],[67,4],[68,7],[69,7],[70,6],[71,6],[72,6]],"1a+72a^2+73a^2b^2c^2d^2e^2f^2+441a^2b^2c^2d^2e^2f^2g^2h^2i^2j^2k^2l^2m^2n^2o^2p^2q^2r^2s^2t^2u^2v^2w^2x^2+511a^2b^3c^3d^3e^2f^2g^2h^2i^2j^2k^3l^3m^3n^3o^3p^3q^3r^3s^3t^3u^3v^3w^3x^3y^3z^3(a')^3(b')^3+512a^3+584a^4b^4c^4d^4e^4f^4+657a^7b^7c^6d^6e^6");
AGR.CHAR("L3(8).2","L38d2G1-f2r54B0",2,20);
AGR.CHAR("L3(8).2","L38d2G1-f3r511B0",3,20);
AGR.CHAR("L3(8).2","L38d2G1-f73r511aB0",73,10);
AGR.CHAR("L3(8).2","L38d2G1-f7r512B0",7,25);
AGR.CHAR("L3(8).2","L38d2G1-p146B0",0,[1,2,3,4]);
AGR.CHAR("L3(8).2","L38d2G1-p4672B0",0,[1,3,4,20,22,24,26,40,46,48,50]);
AGR.CHAR("L3(8).2","L38d2G1-p56064B0",0,[1,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,[22,2],[24,2],[26,2],28,29,30,[31,2],[32,2],[33,2],[34,2],[35,2],[36,2],[37,2],[38,2],[39,2],[40,2],[42,2],[43,2],[44,2],[45,3],[46,3],47,[48,3],49,[50,3],51]);
AGR.CHAR("L3(8).2","L38d2G1-p657B0",0,[1,3,4,40]);
AGR.CHAR("L3(8).2","L38d2G1-p75264B0",0,[1,5,6,7,[8,2],[9,2],[10,2],[11,2],[12,2],[13,2],[14,2],[15,2],[16,2],[17,2],[18,2],[19,2],20,[22,3],[24,3],[26,3],28,29,30,[31,3],[32,3],[33,3],[34,3],[35,3],[36,3],[37,3],[38,3],[39,3],[40,2],[42,2],[43,2],[44,2],[45,3],[46,3],[48,3],[50,3]]);
AGR.CHAR("L3(8).2","L38d2G1-p98112B0",0,[1,3,4,[5,2],[6,2],[7,2],[8,2],[9,2],[10,2],[11,2],[12,2],[13,2],[14,2],[15,2],[16,2],[17,2],[18,2],[19,2],20,21,[22,2],23,[24,2],25,[26,2],27,[28,2],[29,2],[30,2],[31,3],[32,3],[33,3],[34,3],[35,3],[36,3],[37,3],[38,3],[39,3],[40,2],41,[42,4],[43,4],[44,4],[45,7],[46,4],[47,2],[48,4],[49,2],[50,4],[51,2]]);
AGR.CHAR("L3(8).3","L38d3G1-f2r192B0",2,23);
AGR.CHAR("L3(8).3","L38d3G1-f2r216aB0",2,24);
AGR.CHAR("L3(8).3","L38d3G1-f2r216bB0",2,26);
AGR.CHAR("L3(8).3","L38d3G1-f2r24B0",2,6);
AGR.CHAR("L3(8).3","L38d3G1-f2r27aB0",2,7);
AGR.CHAR("L3(8).3","L38d3G1-f2r27bB0",2,10);
AGR.CHAR("L3(8).3","L38d3G1-f2r27cB0",2,15);
AGR.CHAR("L3(8).3","L38d3G1-f2r576B0",2,28);
AGR.CHAR("L3(8).3","L38d3G1-f2r72aB0",2,11);
AGR.CHAR("L3(8).3","L38d3G1-f2r72bB0",2,13);
AGR.CHAR("L3(8).3","L38d3G1-f2r81B0",2,21);
AGR.CHAR("L3(8).3","L38d3G1-f2r9B0",2,4);
AGR.CHAR("L3(8).3","L38d3G1-f3r511B0",3,13);
AGR.CHAR("L3(8).3","L38d3G1-f3r72B0",3,2);
AGR.CHAR("L3(8).3","L38d3G1-f73r441B0",73,9);
AGR.CHAR("L3(8).3","L38d3G1-f73r511aB0",73,12);
AGR.CHAR("L3(8).3","L38d3G1-f73r71B0",73,4);
AGR.CHAR("L3(8).3","L38d3G1-f7r511B0",7,15);
AGR.CHAR("L3(8).3","L38d3G1-f7r512B0",7,19);
AGR.CHAR("L3(8).3","L38d3G1-f7r72B0",7,4);
AGR.CHAR("L3(8).3","L38d3G1-p219aB0",0,[1,2,3,4,5,6]);
AGR.CHAR("L3(8).3","L38d3G1-p219bB0",0,[1,2,3,4,5,6]);
AGR.CHAR("L3(8).3","L38d3G1-p56064B0",0,[1,[4,2],7,8,9,10,11,12,13,14,15,16,17,[20,2],21,22,[23,2],[24,2],[25,2],[26,2],[27,2],[28,2],[29,2],[32,2],[33,2],34,35,36,37,38,39,[40,4]]);
AGR.CHAR("L3(8).3","L38d3G1-p73aB0",0,[1,4]);
AGR.CHAR("L3(8).3","L38d3G1-p73bB0",0,[1,4]);
AGR.CHAR("L3(8).3","L38d3G1-p75264B0",0,[1,7,8,[9,2],[10,2],[11,2],[12,2],[13,2],[14,2],[15,2],[16,2],17,[20,3],21,22,[23,3],[24,3],[25,3],[26,3],[27,3],[28,3],30,31,[32,2],[33,2],34,35,36,37,38,39,[40,3]]);
AGR.CHAR("L3(8).3","L38d3G1-p98112B0",0,[1,2,3,[4,2],[5,2],[6,2],[7,6],[8,6],17,18,19,[20,3],[21,3],[22,3],[23,3],[24,3],[25,3],[26,3],[27,3],[28,3],29,30,31,[32,6],[33,6],[34,3],[35,3],[36,3],[37,3],[38,3],[39,3],[40,9]]);
AGR.CHAR("L3(8).6","L38d6G1-f2r1152B0",2,17);
AGR.CHAR("L3(8).6","L38d6G1-f2r144aB0",2,8);
AGR.CHAR("L3(8).6","L38d6G1-f2r144bB0",2,9);
AGR.CHAR("L3(8).6","L38d6G1-f2r162B0",2,13);
AGR.CHAR("L3(8).6","L38d6G1-f2r18B0",2,4);
AGR.CHAR("L3(8).6","L38d6G1-f2r192B0",2,14);
AGR.CHAR("L3(8).6","L38d6G1-f2r24B0",2,5);
AGR.CHAR("L3(8).6","L38d6G1-f2r432aB0",2,15);
AGR.CHAR("L3(8).6","L38d6G1-f2r432bB0",2,16);
AGR.CHAR("L3(8).6","L38d6G1-f2r512B0",2,18);
AGR.CHAR("L3(8).6","L38d6G1-f2r54aB0",2,6);
AGR.CHAR("L3(8).6","L38d6G1-f2r54bB0",2,7);
AGR.CHAR("L3(8).6","L38d6G1-f3r511B0",3,10);
AGR.CHAR("L3(8).6","L38d6G1-f73r511aB0",73,20);
AGR.CHAR("L3(8).6","L38d6G1-f7r511B0",7,17);
AGR.CHAR("L3(8).6","L38d6G1-f7r512B0",7,25);
AGR.CHAR("L3(8).6","L38d6G1-p438B0",0,[1,2,3,4,5,6,7,8,9,10,11,12]);
AGR.CHAR("L3(8).6","L38d6G1-p4672B0",0,[1,7,10,18,24,30,40]);
AGR.CHAR("L3(8).6","L38d6G1-p56064B0",0,[1,7,10,13,14,15,16,17,18,[24,2],26,[27,2],[28,2],[29,2],[30,2],[36,2],37,38,39,[40,3],41]);
AGR.CHAR("L3(8).6","L38d6G1-p657B0",0,[1,7,10,30]);
AGR.CHAR("L3(8).6","L38d6G1-p75264B0",0,[1,13,[14,2],[15,2],[16,2],[17,2],18,[24,3],26,[27,3],[28,3],[29,3],32,34,[36,2],37,38,39,[40,3]]);
AGR.CHAR("L3(8).6","L38d6G1-p98112B0",0,[1,7,10,[13,2],[14,2],[15,2],[16,2],[17,2],18,21,[24,2],25,[26,2],[27,3],[28,3],[29,3],[30,2],33,[36,4],[37,3],[38,2],[39,2],[40,4],[41,2]]);
AGR.CHAR("L5(2)","L52G1-Zr124B0",0,3,"124a");
AGR.CHAR("L5(2)","L52G1-Zr155B0",0,4,"155a");
AGR.CHAR("L5(2)","L52G1-Zr217B0",0,5,"217a");
AGR.CHAR("L5(2)","L52G1-Zr30B0",0,2,"30a");
AGR.CHAR("L5(2)","L52G1-f2r10aB0",2,4,"10a");
AGR.CHAR("L5(2)","L52G1-f2r10bB0",2,5,"10b");
AGR.CHAR("L5(2)","L52G1-f2r24B0",2,6,"24a");
AGR.CHAR("L5(2)","L52G1-f2r5aB0",2,2,"5a");
AGR.CHAR("L5(2)","L52G1-f2r5bB0",2,3,"5b");
AGR.CHAR("L5(2)","L52G1-f31r251B0",31,6,"251a");
AGR.CHAR("L5(2)","L52G1-f31r29B0",31,2,"29a");
AGR.CHAR("L5(2)","L52G1-f3r124B0",3,3,"124a");
AGR.CHAR("L5(2)","L52G1-f3r155B0",3,4,"155a");
AGR.CHAR("L5(2)","L52G1-f3r30B0",3,2,"30a");
AGR.CHAR("L5(2)","L52G1-f5r123B0",5,3,"123a");
AGR.CHAR("L5(2)","L52G1-f5r155B0",5,4,"155a");
AGR.CHAR("L5(2)","L52G1-f5r280B0",5,6,"280a");
AGR.CHAR("L5(2)","L52G1-f5r30B0",5,2,"30a");
AGR.CHAR("L5(2)","L52G1-f7r280B0",7,6,"280a");
AGR.CHAR("L5(2)","L52G1-f7r30B0",7,2,"30a");
AGR.CHAR("L5(2)","L52G1-f7r94B0",7,3,"94a");
AGR.CHAR("L5(2)","L52G1-p155aB0",0,[1,2,3],"1a+30a+124a");
AGR.CHAR("L5(2)","L52G1-p31aB0",0,[1,2],"1a+30a");
AGR.CHAR("M11","M11G1-Ar10bB0",0,3,"10b");
AGR.CHAR("M11","M11G1-Ar10cB0",0,4,"10c");
AGR.CHAR("M11","M11G1-Zr10aB0",0,2,"10a");
AGR.CHAR("M11","M11G1-Zr11B0",0,5,"11a");
AGR.CHAR("M11","M11G1-Zr20B0",0,[3,4],"10bc");
AGR.CHAR("M11","M11G1-Zr32B0",0,[6,7],"16ab");
AGR.CHAR("M11","M11G1-Zr44B0",0,8,"44a");
AGR.CHAR("M11","M11G1-Zr45B0",0,9,"45a");
AGR.CHAR("M11","M11G1-Zr55B0",0,10,"55a");
AGR.CHAR("M11","M11G1-f11r10aB0",11,3,"10a");
AGR.CHAR("M11","M11G1-f11r10bB0",11,4,"10b");
AGR.CHAR("M11","M11G1-f11r11B0",11,5,"11a");
AGR.CHAR("M11","M11G1-f11r16B0",11,6,"16a");
AGR.CHAR("M11","M11G1-f11r44B0",11,7,"44a");
AGR.CHAR("M11","M11G1-f11r55B0",11,8,"55a");
AGR.CHAR("M11","M11G1-f11r9B0",11,2,"9a");
AGR.CHAR("M11","M11G1-f25r10bB0",5,3,"10b");
AGR.CHAR("M11","M11G1-f25r10cB0",5,4,"10c");
AGR.CHAR("M11","M11G1-f2r10B0",2,2,"10a");
AGR.CHAR("M11","M11G1-f2r32B0",2,[3,4],"16ab");
AGR.CHAR("M11","M11G1-f2r44B0",2,5,"44a");
AGR.CHAR("M11","M11G1-f3r10aB0",3,4,"10a");
AGR.CHAR("M11","M11G1-f3r10bB0",3,5,"10b");
AGR.CHAR("M11","M11G1-f3r10cB0",3,6,"10c");
AGR.CHAR("M11","M11G1-f3r24B0",3,7,"24a");
AGR.CHAR("M11","M11G1-f3r45B0",3,8,"45a");
AGR.CHAR("M11","M11G1-f3r5aB0",3,2,"5a");
AGR.CHAR("M11","M11G1-f3r5bB0",3,3,"5b");
AGR.CHAR("M11","M11G1-f4r16aB0",2,3,"16a");
AGR.CHAR("M11","M11G1-f4r16bB0",2,4,"16b");
AGR.CHAR("M11","M11G1-f5r10aB0",5,2,"10a");
AGR.CHAR("M11","M11G1-f5r11B0",5,5,"11a");
AGR.CHAR("M11","M11G1-f5r16aB0",5,6,"16a");
AGR.CHAR("M11","M11G1-f5r16bB0",5,7,"16b");
AGR.CHAR("M11","M11G1-f5r20B0",5,[3,4],"10bc");
AGR.CHAR("M11","M11G1-f5r45B0",5,8,"45a");
AGR.CHAR("M11","M11G1-f5r55B0",5,9,"55a");
AGR.CHAR("M11","M11G1-p11B0",0,[1,2],"1a+10a");
AGR.CHAR("M11","M11G1-p12B0",0,[1,5],"1a+11a");
AGR.CHAR("M11","M11G1-p165B0",0,[1,2,5,[8,2],10],"1a+10a+11a+44a^2+55a");
AGR.CHAR("M11","M11G1-p55B0",0,[1,2,8],"1a+10a+44a");
AGR.CHAR("M11","M11G1-p66B0",0,[1,2,5,8],"1a+10a+11a+44a");
AGR.CHAR("M12","M12G1-Zr11aB0",0,2,"11a");
AGR.CHAR("M12","M12G1-Zr11bB0",0,3,"11b");
AGR.CHAR("M12","M12G1-Zr120B0",0,13,"120a");
AGR.CHAR("M12","M12G1-Zr144B0",0,14,"144a");
AGR.CHAR("M12","M12G1-Zr176B0",0,15,"176a");
AGR.CHAR("M12","M12G1-Zr32B0",0,[4,5],"16ab");
AGR.CHAR("M12","M12G1-Zr45B0",0,6,"45a");
AGR.CHAR("M12","M12G1-Zr54B0",0,7,"54a");
AGR.CHAR("M12","M12G1-Zr55aB0",0,8,"55a");
AGR.CHAR("M12","M12G1-Zr55bB0",0,9,"55b");
AGR.CHAR("M12","M12G1-Zr55cB0",0,10,"55c");
AGR.CHAR("M12","M12G1-Zr66B0",0,11,"66a");
AGR.CHAR("M12","M12G1-Zr99B0",0,12,"99a");
AGR.CHAR("M12","M12G1-f11r11aB0",11,2,"11a");
AGR.CHAR("M12","M12G1-f11r16B0",11,4,"16a");
AGR.CHAR("M12","M12G1-f11r176B0",11,13,"176a");
AGR.CHAR("M12","M12G1-f11r29B0",11,5,"29a");
AGR.CHAR("M12","M12G1-f11r53B0",11,6,"53a");
AGR.CHAR("M12","M12G1-f11r55aB0",11,7,"55a");
AGR.CHAR("M12","M12G1-f11r55cB0",11,9,"55c");
AGR.CHAR("M12","M12G1-f11r66B0",11,10,"66a");
AGR.CHAR("M12","M12G1-f11r91B0",11,11,"91a");
AGR.CHAR("M12","M12G1-f11r99B0",11,12,"99a");
AGR.CHAR("M12","M12G1-f2r10B0",2,2,"10a");
AGR.CHAR("M12","M12G1-f2r144B0",2,6,"144a");
AGR.CHAR("M12","M12G1-f2r44B0",2,5,"44a");
AGR.CHAR("M12","M12G1-f3r10aB0",3,2,"10a");
AGR.CHAR("M12","M12G1-f3r15bB0",3,5,"15b");
AGR.CHAR("M12","M12G1-f3r34B0",3,6,"34a");
AGR.CHAR("M12","M12G1-f3r45aB0",3,7,"45a");
AGR.CHAR("M12","M12G1-f3r45bB0",3,8,"45b");
AGR.CHAR("M12","M12G1-f3r54B0",3,10,"54a");
AGR.CHAR("M12","M12G1-f3r99B0",3,11,"99a");
AGR.CHAR("M12","M12G1-f4r16aB0",2,3,"16a");
AGR.CHAR("M12","M12G1-f4r16bB0",2,4,"16b");
AGR.CHAR("M12","M12G1-f5r11aB0",5,2,"11a");
AGR.CHAR("M12","M12G1-f5r120B0",5,13,"120a");
AGR.CHAR("M12","M12G1-f5r16bB0",5,5,"16b");
AGR.CHAR("M12","M12G1-f5r45B0",5,6,"45a");
AGR.CHAR("M12","M12G1-f5r55aB0",5,7,"55a");
AGR.CHAR("M12","M12G1-f5r55cB0",5,9,"55c");
AGR.CHAR("M12","M12G1-f5r66B0",5,10,"66a");
AGR.CHAR("M12","M12G1-f5r78B0",5,11,"78a");
AGR.CHAR("M12","M12G1-f5r98B0",5,12,"98a");
AGR.CHAR("M12","M12G1-p12aB0",0,[1,2],"1a+11a");
AGR.CHAR("M12","M12G1-p12bB0",0,[1,3],"1a+11b");
AGR.CHAR("M12","M12G1-p66aB0",0,[1,2,7],"1a+11a+54a");
AGR.CHAR("M12","M12G1-p66bB0",0,[1,3,7],"1a+11b+54a");
AGR.CHAR("M12.2","M12d2G1-f11r110aB0",11,12);
AGR.CHAR("M12.2","M12d2G1-f11r16aB0",11,4);
AGR.CHAR("M12.2","M12d2G1-f11r176aB0",11,19);
AGR.CHAR("M12.2","M12d2G1-f11r22aB0",11,3);
AGR.CHAR("M12.2","M12d2G1-f11r29aB0",11,6);
AGR.CHAR("M12.2","M12d2G1-f11r53aB0",11,8);
AGR.CHAR("M12.2","M12d2G1-f11r55aB0",11,10);
AGR.CHAR("M12.2","M12d2G1-f11r66aB0",11,13);
AGR.CHAR("M12.2","M12d2G1-f11r91aB0",11,15);
AGR.CHAR("M12.2","M12d2G1-f11r99aB0",11,17);
AGR.CHAR("M12.2","M12d2G1-f25r120aB0",5,16);
AGR.CHAR("M12.2","M12d2G1-f2r10B0",2,2);
AGR.CHAR("M12.2","M12d2G1-f2r144B0",2,5);
AGR.CHAR("M12.2","M12d2G1-f2r32B0",2,3);
AGR.CHAR("M12.2","M12d2G1-f2r44B0",2,4);
AGR.CHAR("M12.2","M12d2G1-f3r20aB0",3,3);
AGR.CHAR("M12.2","M12d2G1-f3r30aB0",3,4);
AGR.CHAR("M12.2","M12d2G1-f3r34aB0",3,5);
AGR.CHAR("M12.2","M12d2G1-f3r45aB0",3,7);
AGR.CHAR("M12.2","M12d2G1-f3r90aB0",3,9);
AGR.CHAR("M12.2","M12d2G1-f3r99aB0",3,12);
AGR.CHAR("M12.2","M12d2G1-f5r110aB0",5,9);
AGR.CHAR("M12.2","M12d2G1-f5r22aB0",5,3);
AGR.CHAR("M12.2","M12d2G1-f5r32aB0",5,4);
AGR.CHAR("M12.2","M12d2G1-f5r45aB0",5,5);
AGR.CHAR("M12.2","M12d2G1-f5r55aB0",5,7);
AGR.CHAR("M12.2","M12d2G1-f5r66aB0",5,10);
AGR.CHAR("M12.2","M12d2G1-f5r78aB0",5,12);
AGR.CHAR("M12.2","M12d2G1-f5r98aB0",5,14);
AGR.CHAR("M12.2","M12d2G1-f9r54aB0",3,10);
AGR.CHAR("M12.2","M12d2G1-p24B0",0,[1,2,3]);
AGR.CHAR("M22","M22G1-Zr154B0",0,7,"154a");
AGR.CHAR("M22","M22G1-Zr210B0",0,8,"210a");
AGR.CHAR("M22","M22G1-Zr21B0",0,2,"21a");
AGR.CHAR("M22","M22G1-Zr231B0",0,9,"231a");
AGR.CHAR("M22","M22G1-Zr55B0",0,5,"55a");
AGR.CHAR("M22","M22G1-Zr99B0",0,6,"99a");
AGR.CHAR("M22","M22G1-f11r154B0",11,7,"154a");
AGR.CHAR("M22","M22G1-f11r190B0",11,8,"190a");
AGR.CHAR("M22","M22G1-f11r20B0",11,2,"20a");
AGR.CHAR("M22","M22G1-f11r231B0",11,9,"231a");
AGR.CHAR("M22","M22G1-f11r385B0",11,10,"385a");
AGR.CHAR("M22","M22G1-f11r45aB0",11,3,"45a");
AGR.CHAR("M22","M22G1-f11r45bB0",11,4,"45b");
AGR.CHAR("M22","M22G1-f11r55B0",11,5,"55a");
AGR.CHAR("M22","M22G1-f11r99B0",11,6,"99a");
AGR.CHAR("M22","M22G1-f25r45aB0",5,3,"45a");
AGR.CHAR("M22","M22G1-f2r10aB0",2,2,"10a");
AGR.CHAR("M22","M22G1-f2r10bB0",2,3,"10b");
AGR.CHAR("M22","M22G1-f2r34B0",2,4,"34a");
AGR.CHAR("M22","M22G1-f2r98B0",2,7,"98a");
AGR.CHAR("M22","M22G1-f3r210B0",3,9,"210a");
AGR.CHAR("M22","M22G1-f3r21B0",3,2,"21a");
AGR.CHAR("M22","M22G1-f3r231B0",3,10,"231a");
AGR.CHAR("M22","M22G1-f3r49aB0",3,5,"49a");
AGR.CHAR("M22","M22G1-f3r49bB0",3,6,"49b");
AGR.CHAR("M22","M22G1-f3r55B0",3,7,"55a");
AGR.CHAR("M22","M22G1-f3r99B0",3,8,"99a");
AGR.CHAR("M22","M22G1-f49r280aB0",7,8,"280a");
AGR.CHAR("M22","M22G1-f49r280bB0",7,9,"280b");
AGR.CHAR("M22","M22G1-f4r70aB0",2,5,"70a");
AGR.CHAR("M22","M22G1-f4r70bB0",2,6,"70b");
AGR.CHAR("M22","M22G1-f5r133B0",5,7,"133a");
AGR.CHAR("M22","M22G1-f5r210B0",5,8,"210a");
AGR.CHAR("M22","M22G1-f5r21B0",5,2,"21a");
AGR.CHAR("M22","M22G1-f5r280aB0",5,9,"280a");
AGR.CHAR("M22","M22G1-f5r385B0",5,11,"385a");
AGR.CHAR("M22","M22G1-f5r55B0",5,5,"55a");
AGR.CHAR("M22","M22G1-f5r98B0",5,6,"98a");
AGR.CHAR("M22","M22G1-f7r154B0",7,5,"154a");
AGR.CHAR("M22","M22G1-f7r210B0",7,6,"210a");
AGR.CHAR("M22","M22G1-f7r21B0",7,2,"21a");
AGR.CHAR("M22","M22G1-f7r231B0",7,7,"231a");
AGR.CHAR("M22","M22G1-f7r385B0",7,10,"385a");
AGR.CHAR("M22","M22G1-f7r45B0",7,3,"45a");
AGR.CHAR("M22","M22G1-f7r54B0",7,4,"54a");
AGR.CHAR("M22","M22G1-f9r45aB0",3,3,"45a");
AGR.CHAR("M22","M22G1-p176aB0",0,[1,2,7],"1a+21a+154a");
AGR.CHAR("M22","M22G1-p176bB0",0,[1,2,7],"1a+21a+154a");
AGR.CHAR("M22","M22G1-p22B0",0,[1,2],"1a+21a");
AGR.CHAR("M22","M22G1-p231B0",0,[1,2,5,7],"1a+21a+55a+154a");
AGR.CHAR("M22","M22G1-p330B0",0,[1,2,5,6,7],"1a+21a+55a+99a+154a");
AGR.CHAR("M22","M22G1-p462aB0",0,[1,2,5,7,9],"1a+21a+55a+154a+231a");
AGR.CHAR("M22","M22G1-p462bB0",0,[1,[2,2],5,7,8],"1a+21a^2+55a+154a+210a");
AGR.CHAR("M22","M22G1-p462cB0",0,[1,[2,2],5,7,8],"1a+21a^2+55a+154a+210a");
AGR.CHAR("M22","M22G1-p616B0",0,[1,2,5,7,12],"1a+21a+55a+154a+385a");
AGR.CHAR("M22","M22G1-p672B0",0,[1,2,5,7,8,9],"1a+21a+55a+154a+210a+231a");
AGR.CHAR("M22","M22G1-p770B0",0,[1,2,[5,2],6,7,12],"1a+21a+55a^2+99a+154a+385a");
AGR.CHAR("M22","M22G1-p77B0",0,[1,2,5],"1a+21a+55a");
AGR.CHAR("M22.2","M22d2G1-f11r154aB0",11,13);
AGR.CHAR("M22.2","M22d2G1-f11r190aB0",11,15);
AGR.CHAR("M22.2","M22d2G1-f11r20aB0",11,3);
AGR.CHAR("M22.2","M22d2G1-f11r231aB0",11,17);
AGR.CHAR("M22.2","M22d2G1-f11r385aB0",11,19);
AGR.CHAR("M22.2","M22d2G1-f11r45aB0",11,5);
AGR.CHAR("M22.2","M22d2G1-f11r45bB0",11,7);
AGR.CHAR("M22.2","M22d2G1-f11r55aB0",11,9);
AGR.CHAR("M22.2","M22d2G1-f11r99aB0",11,11);
AGR.CHAR("M22.2","M22d2G1-f25r45aB0",5,5);
AGR.CHAR("M22.2","M22d2G1-f25r45bB0",5,7);
AGR.CHAR("M22.2","M22d2G1-f2r10aB0",2,2);
AGR.CHAR("M22.2","M22d2G1-f2r10bB0",2,3);
AGR.CHAR("M22.2","M22d2G1-f2r140B0",2,5);
AGR.CHAR("M22.2","M22d2G1-f2r34B0",2,4);
AGR.CHAR("M22.2","M22d2G1-f2r98B0",2,6);
AGR.CHAR("M22.2","M22d2G1-f3r210aB0",3,14);
AGR.CHAR("M22.2","M22d2G1-f3r21aB0",3,3);
AGR.CHAR("M22.2","M22d2G1-f3r231aB0",3,16);
AGR.CHAR("M22.2","M22d2G1-f3r55aB0",3,10);
AGR.CHAR("M22.2","M22d2G1-f3r98B0",3,9);
AGR.CHAR("M22.2","M22d2G1-f3r99aB0",3,12);
AGR.CHAR("M22.2","M22d2G1-f5r133aB0",5,13);
AGR.CHAR("M22.2","M22d2G1-f5r210aB0",5,15);
AGR.CHAR("M22.2","M22d2G1-f5r21aB0",5,3);
AGR.CHAR("M22.2","M22d2G1-f5r385aB0",5,18);
AGR.CHAR("M22.2","M22d2G1-f5r55aB0",5,9);
AGR.CHAR("M22.2","M22d2G1-f5r560B0",5,17);
AGR.CHAR("M22.2","M22d2G1-f5r98aB0",5,11);
AGR.CHAR("M22.2","M22d2G1-f7r154aB0",7,9);
AGR.CHAR("M22.2","M22d2G1-f7r210aB0",7,11);
AGR.CHAR("M22.2","M22d2G1-f7r21aB0",7,3);
AGR.CHAR("M22.2","M22d2G1-f7r231aB0",7,13);
AGR.CHAR("M22.2","M22d2G1-f7r385aB0",7,16);
AGR.CHAR("M22.2","M22d2G1-f7r45aB0",7,5);
AGR.CHAR("M22.2","M22d2G1-f7r54aB0",7,7);
AGR.CHAR("M22.2","M22d2G1-f7r560B0",7,15);
AGR.CHAR("M22.2","M22d2G1-f9r45aB0",3,5);
AGR.CHAR("M22.2","M22d2G1-f9r45bB0",3,7);
AGR.CHAR("M22.2","M22d2G1-p22B0",0,[1,3]);
AGR.CHAR("M22.2","M22d2G1-p231B0",0,[1,3,9,13]);
AGR.CHAR("M22.2","M22d2G1-p330B0",0,[1,3,9,11,13]);
AGR.CHAR("M22.2","M22d2G1-p352B0",0,[1,2,3,4,13,14]);
AGR.CHAR("M22.2","M22d2G1-p616B0",0,[1,3,9,13,20]);
AGR.CHAR("M22.2","M22d2G1-p672B0",0,[1,4,9,13,16,18]);
AGR.CHAR("M22.2","M22d2G1-p77B0",0,[1,3,9]);
AGR.CHAR("M23","M23G1-Zr22B0",0,2,"22a");
AGR.CHAR("M23","M23G1-Zr230B0",0,5,"230a");
AGR.CHAR("M23","M23G1-Zr231aB0",0,6,"231a");
AGR.CHAR("M23","M23G1-f11r229B0",11,5,"229a");
AGR.CHAR("M23","M23G1-f11r22B0",11,2,"22a");
AGR.CHAR("M23","M23G1-f11r231aB0",11,6,"231a");
AGR.CHAR("M23","M23G1-f11r253B0",11,9,"253a");
AGR.CHAR("M23","M23G1-f11r45bB0",11,4,"45b");
AGR.CHAR("M23","M23G1-f11r806B0",11,12,"806a");
AGR.CHAR("M23","M23G1-f11r990aB0",11,13,"990a");
AGR.CHAR("M23","M23G1-f121r231bB0",11,7,"231b");
AGR.CHAR("M23","M23G1-f121r231cB0",11,8,"231c");
AGR.CHAR("M23","M23G1-f121r770aB0",11,10,"770a");
AGR.CHAR("M23","M23G1-f121r770bB0",11,11,"770b");
AGR.CHAR("M23","M23G1-f23r210B0",23,5,"210a");
AGR.CHAR("M23","M23G1-f23r21B0",23,2,"21a");
AGR.CHAR("M23","M23G1-f23r230B0",23,6,"230a");
AGR.CHAR("M23","M23G1-f23r231aB0",23,7,"231a");
AGR.CHAR("M23","M23G1-f23r253B0",23,9,"253a");
AGR.CHAR("M23","M23G1-f23r280B0",23,10,"280a");
AGR.CHAR("M23","M23G1-f23r45bB0",23,4,"45b");
AGR.CHAR("M23","M23G1-f23r665bB0",23,13,"665b");
AGR.CHAR("M23","M23G1-f25r45aB0",5,4,"45b");
AGR.CHAR("M23","M23G1-f25r770B0",5,8,"770a");
AGR.CHAR("M23","M23G1-f25r990aB0",5,13,"990b");
AGR.CHAR("M23","M23G1-f2r11aB0",2,2,"11a");
AGR.CHAR("M23","M23G1-f2r11bB0",2,3,"11b");
AGR.CHAR("M23","M23G1-f2r120B0",2,6,"120a");
AGR.CHAR("M23","M23G1-f2r220aB0",2,7,"220a");
AGR.CHAR("M23","M23G1-f2r220bB0",2,8,"220b");
AGR.CHAR("M23","M23G1-f2r252B0",2,9,"252a");
AGR.CHAR("M23","M23G1-f2r44aB0",2,4,"44a");
AGR.CHAR("M23","M23G1-f2r44bB0",2,5,"44b");
AGR.CHAR("M23","M23G1-f3r104aB0",3,5,"104a");
AGR.CHAR("M23","M23G1-f3r104bB0",3,6,"104b");
AGR.CHAR("M23","M23G1-f3r22B0",3,2,"22a");
AGR.CHAR("M23","M23G1-f3r231B0",3,7,"231a");
AGR.CHAR("M23","M23G1-f3r253B0",3,8,"253a");
AGR.CHAR("M23","M23G1-f3r770aB0",3,9,"770a");
AGR.CHAR("M23","M23G1-f49r231bB0",7,6,"231b");
AGR.CHAR("M23","M23G1-f49r231cB0",7,7,"231c");
AGR.CHAR("M23","M23G1-f49r770aB0",7,8,"770a");
AGR.CHAR("M23","M23G1-f49r770bB0",7,9,"770b");
AGR.CHAR("M23","M23G1-f49r896aB0",7,10,"896a");
AGR.CHAR("M23","M23G1-f49r896bB0",7,11,"896b");
AGR.CHAR("M23","M23G1-f4r896aB0",2,10,"896a");
AGR.CHAR("M23","M23G1-f4r896bB0",2,11,"896b");
AGR.CHAR("M23","M23G1-f5r22B0",5,2,"22a");
AGR.CHAR("M23","M23G1-f5r230B0",5,5,"230a");
AGR.CHAR("M23","M23G1-f5r231aB0",5,6,"231a");
AGR.CHAR("M23","M23G1-f5r231bB0",5,7,"231b");
AGR.CHAR("M23","M23G1-f5r896aB0",5,10,"896a");
AGR.CHAR("M23","M23G1-f7r208B0",7,4,"208a");
AGR.CHAR("M23","M23G1-f7r22B0",7,2,"22a");
AGR.CHAR("M23","M23G1-f7r231aB0",7,5,"231a");
AGR.CHAR("M23","M23G1-f7r45B0",7,3,"45a");
AGR.CHAR("M23","M23G1-f7r990B0",7,12,"990a");
AGR.CHAR("M23","M23G1-f9r45bB0",3,4,"45b");
AGR.CHAR("M23","M23G1-f9r990bB0",3,12,"990b");
AGR.CHAR("M23","M23G1-p1288B0",0,[1,2,5,16],"1a+22a+230a+1035a");
AGR.CHAR("M23","M23G1-p1771B0",0,[1,2,[5,2],9,16],"1a+22a+230a^2+253a+1035a");
AGR.CHAR("M23","M23G1-p23B0",0,[1,2],"1a+22a");
AGR.CHAR("M23","M23G1-p253aB0",0,[1,2,5],"1a+22a+230a");
AGR.CHAR("M23","M23G1-p253bB0",0,[1,2,5],"1a+22a+230a");
AGR.CHAR("M23","M23G1-p40320B0",0,[1,3,4,6,7,8,9,[10,3],[11,3],[12,3],[13,3],[14,4],[15,4],[16,5],[17,8]],"1a+45ab+231abc+253a+770a^3b^3+896a^3b^3+990a^4b^4+1035a^5+2024a^8");
AGR.CHAR("M23","M23G1-p506B0",0,[1,2,5,9],"1a+22a+230a+253a");
AGR.CHAR("M24","M24G1-Zr23B0",0,2,"23a");
AGR.CHAR("M24","M24G1-f11r229B0",11,5,"229a");
AGR.CHAR("M24","M24G1-f11r23B0",11,2,"23a");
AGR.CHAR("M24","M24G1-f11r253B0",11,8,"253a");
AGR.CHAR("M24","M24G1-f11r45B0",11,3,"45a");
AGR.CHAR("M24","M24G1-f11r482B0",11,9,"482a");
AGR.CHAR("M24","M24G1-f11r806B0",11,12,"806a");
AGR.CHAR("M24","M24G1-f11r990bB0",11,14,"990b");
AGR.CHAR("M24","M24G1-f121r231bB0",11,7,"231b");
AGR.CHAR("M24","M24G1-f121r770aB0",11,10,"770a");
AGR.CHAR("M24","M24G1-f23r231bB0",23,6,"231b");
AGR.CHAR("M24","M24G1-f23r23B0",23,2,"23a");
AGR.CHAR("M24","M24G1-f23r251B0",23,7,"251a");
AGR.CHAR("M24","M24G1-f23r253B0",23,8,"253a");
AGR.CHAR("M24","M24G1-f23r45B0",23,3,"45a");
AGR.CHAR("M24","M24G1-f23r483B0",23,9,"483a");
AGR.CHAR("M24","M24G1-f23r770B0",23,10,"770a");
AGR.CHAR("M24","M24G1-f23r990bB0",23,12,"990b");
AGR.CHAR("M24","M24G1-f25r45aB0",5,3,"45a");
AGR.CHAR("M24","M24G1-f25r45bB0",5,4,"45b");
AGR.CHAR("M24","M24G1-f25r770aB0",5,8,"770a");
AGR.CHAR("M24","M24G1-f25r990aB0",5,10,"990a");
AGR.CHAR("M24","M24G1-f2r11aB0",2,2,"11a");
AGR.CHAR("M24","M24G1-f2r11bB0",2,3,"11b");
AGR.CHAR("M24","M24G1-f2r120B0",2,6,"120a");
AGR.CHAR("M24","M24G1-f2r1242B0",2,12,"1242a");
AGR.CHAR("M24","M24G1-f2r1792B0",2,13,"1792a");
AGR.CHAR("M24","M24G1-f2r220aB0",2,7,"220a");
AGR.CHAR("M24","M24G1-f2r220bB0",2,8,"220b");
AGR.CHAR("M24","M24G1-f2r252B0",2,9,"252a");
AGR.CHAR("M24","M24G1-f2r320aB0",2,10,"320a");
AGR.CHAR("M24","M24G1-f2r320bB0",2,11,"320b");
AGR.CHAR("M24","M24G1-f2r44aB0",2,4,"44a");
AGR.CHAR("M24","M24G1-f2r44bB0",2,5,"44b");
AGR.CHAR("M24","M24G1-f3r22B0",3,2,"22a");
AGR.CHAR("M24","M24G1-f3r231B0",3,5,"231a");
AGR.CHAR("M24","M24G1-f3r252B0",3,6,"252a");
AGR.CHAR("M24","M24G1-f3r483B0",3,7,"483a");
AGR.CHAR("M24","M24G1-f3r770aB0",3,8,"770a");
AGR.CHAR("M24","M24G1-f3r770bB0",3,9,"770b");
AGR.CHAR("M24","M24G1-f49r231bB0",7,5,"231b");
AGR.CHAR("M24","M24G1-f49r770aB0",7,9,"770a");
AGR.CHAR("M24","M24G1-f5r231B0",5,5,"231a");
AGR.CHAR("M24","M24G1-f5r23B0",5,2,"23a");
AGR.CHAR("M24","M24G1-f5r252B0",5,6,"252a");
AGR.CHAR("M24","M24G1-f5r253B0",5,7,"253a");
AGR.CHAR("M24","M24G1-f7r23B0",7,2,"23a");
AGR.CHAR("M24","M24G1-f7r252B0",7,6,"252a");
AGR.CHAR("M24","M24G1-f7r253B0",7,7,"253a");
AGR.CHAR("M24","M24G1-f7r45B0",7,3,"45a");
AGR.CHAR("M24","M24G1-f7r483B0",7,8,"483a");
AGR.CHAR("M24","M24G1-f7r990B0",7,11,"990a");
AGR.CHAR("M24","M24G1-f9r45aB0",3,3,"45a");
AGR.CHAR("M24","M24G1-f9r45bB0",3,4,"45b");
AGR.CHAR("M24","M24G1-f9r990bB0",3,11,"990b");
AGR.CHAR("M24","M24G1-p1288B0",0,[1,7,14],"1a+252a+1035a");
AGR.CHAR("M24","M24G1-p1771B0",0,[1,7,9,14],"1a+252a+483a+1035a");
AGR.CHAR("M24","M24G1-p2024B0",0,[1,2,7,9,17],"1a+23a+252a+483a+1265a");
AGR.CHAR("M24","M24G1-p24B0",0,[1,2],"1a+23a");
AGR.CHAR("M24","M24G1-p276B0",0,[1,2,7],"1a+23a+252a");
AGR.CHAR("M24","M24G1-p3795B0",0,[1,7,9,14,19],"1a+252a+483a+1035a+2024a");
AGR.CHAR("M24","M24G1-p759B0",0,[1,2,7,9],"1a+23a+252a+483a");
AGR.CHAR("McL","McLG1-Zr231B0",0,3,"231a");
AGR.CHAR("McL","McLG1-f11r22B0",11,2,"22a");
AGR.CHAR("McL","McLG1-f11r231B0",11,3,"231a");
AGR.CHAR("McL","McLG1-f11r251B0",11,4,"251a");
AGR.CHAR("McL","McLG1-f11r896B0",11,7,"896a");
AGR.CHAR("McL","McLG1-f121r770aB0",11,5,"770a");
AGR.CHAR("McL","McLG1-f121r770bB0",11,6,"770b");
AGR.CHAR("McL","McLG1-f23r896bB0",23,8,"896b");
AGR.CHAR("McL","McLG1-f25r1200aB0",5,8,"1200a");
AGR.CHAR("McL","McLG1-f2r22B0",2,2,"22a");
AGR.CHAR("McL","McLG1-f2r230B0",2,3,"230a");
AGR.CHAR("McL","McLG1-f2r748aB0",2,4,"748a");
AGR.CHAR("McL","McLG1-f2r748bB0",2,5,"748b");
AGR.CHAR("McL","McLG1-f3r104aB0",3,3,"104a");
AGR.CHAR("McL","McLG1-f3r104bB0",3,4,"104b");
AGR.CHAR("McL","McLG1-f3r210B0",3,5,"210a");
AGR.CHAR("McL","McLG1-f3r21B0",3,2,"21a");
AGR.CHAR("McL","McLG1-f3r560B0",3,6,"560a");
AGR.CHAR("McL","McLG1-f49r770aB0",7,5,"770a");
AGR.CHAR("McL","McLG1-f49r770bB0",7,6,"770b");
AGR.CHAR("McL","McLG1-f49r896aB0",7,7,"896a");
AGR.CHAR("McL","McLG1-f49r896bB0",7,8,"896b");
AGR.CHAR("McL","McLG1-f4r896aB0",2,6,"896a");
AGR.CHAR("McL","McLG1-f4r896bB0",2,7,"896b");
AGR.CHAR("McL","McLG1-f5r210B0",5,3,"210a");
AGR.CHAR("McL","McLG1-f5r21B0",5,2,"21a");
AGR.CHAR("McL","McLG1-f5r230B0",5,4,"230a");
AGR.CHAR("McL","McLG1-f5r560B0",5,5,"560a");
AGR.CHAR("McL","McLG1-f5r896bB0",5,7,"896b");
AGR.CHAR("McL","McLG1-f7r22B0",7,2,"22a");
AGR.CHAR("McL","McLG1-f7r231B0",7,3,"231a");
AGR.CHAR("McL","McLG1-f7r252B0",7,4,"252a");
AGR.CHAR("McL","McLG1-f9r605aB0",3,7,"605a");
AGR.CHAR("McL","McLG1-f9r605bB0",3,8,"605b");
AGR.CHAR("McL","McLG1-p113400B0",0,[1,2,[4,2],[9,3],[10,2],12,[14,2],18,19,[20,3],21,22,23,24],"1a+22a+252a^2+1750a^3+3520a^2+4500a+5103a^2+8250ab+9625a^3+9856ab+10395ab");
AGR.CHAR("McL","McLG1-p15400aB0",0,[1,4,12,14,15],"1a+252a+4500a+5103a+5544a");
AGR.CHAR("McL","McLG1-p15400bB0",0,[1,2,[4,2],9,10,12,14],"1a+22a+252a^2+1750a+3520a+4500a+5103a");
AGR.CHAR("McL","McLG1-p2025aB0",0,[1,2,4,9],"1a+22a+252a+1750a");
AGR.CHAR("McL","McLG1-p2025bB0",0,[1,2,4,9],"1a+22a+252a+1750a");
AGR.CHAR("McL","McLG1-p22275aB0",0,[1,2,[4,2],[9,2],10,14,20],"1a+22a+252a^2+1750a^2+3520a+5103a+9625a");
AGR.CHAR("McL","McLG1-p22275bB0",0,[1,4,9,14,15,20],"1a+252a+1750a+5103a+5544a+9625a");
AGR.CHAR("McL","McLG1-p22275cB0",0,[1,2,[4,2],[9,2],10,14,20],"1a+22a+252a^2+1750a^2+3520a+5103a+9625a");
AGR.CHAR("McL","McLG1-p22275dB0",0,[1,2,[4,2],[9,2],10,14,20],"1a+22a+252a^2+1750a^2+3520a+5103a+9625a");
AGR.CHAR("McL","McLG1-p275B0",0,[1,2,4],"1a+22a+252a");
AGR.CHAR("McL","McLG1-p299376B0",0,[1,4,7,8,9,10,[12,3],[13,2],[14,3],[15,2],[16,2],[17,2],[18,3],[19,3],[20,4],[21,2],[22,2],[23,4],[24,4]],"1a+252a+896ab+1750a+3520a+4500a^3+4752a^2+5103a^3+5544a^2+8019a^2b^2+8250a^3b^3+9625a^4+9856a^2b^2+10395a^4b^4");
AGR.CHAR("McL","McLG1-p7128B0",0,[1,2,4,9,14],"1a+22a+252a+1750a+5103a");
AGR.CHAR("McL.2","McLd2G1-f11r22aB0",11,3);
AGR.CHAR("McL.2","McLd2G1-f11r231aB0",11,5);
AGR.CHAR("McL.2","McLd2G1-f11r251aB0",11,7);
AGR.CHAR("McL.2","McLd2G1-f11r896aB0",11,10);
AGR.CHAR("McL.2","McLd2G1-f2r1496aB0",2,4);
AGR.CHAR("McL.2","McLd2G1-f2r22B0",2,2);
AGR.CHAR("McL.2","McLd2G1-f2r230aB0",2,3);
AGR.CHAR("McL.2","McLd2G1-f3r104aB0",3,5);
AGR.CHAR("McL.2","McLd2G1-f3r104bB0",3,7);
AGR.CHAR("McL.2","McLd2G1-f3r210aB0",3,9);
AGR.CHAR("McL.2","McLd2G1-f3r21aB0",3,3);
AGR.CHAR("McL.2","McLd2G1-f3r560aB0",3,11);
AGR.CHAR("McL.2","McLd2G1-f49r896aB0",7,10);
AGR.CHAR("McL.2","McLd2G1-f5r210aB0",5,5);
AGR.CHAR("McL.2","McLd2G1-f5r21aB0",5,3);
AGR.CHAR("McL.2","McLd2G1-f5r230aB0",5,7);
AGR.CHAR("McL.2","McLd2G1-f5r560aB0",5,9);
AGR.CHAR("McL.2","McLd2G1-f5r896aB0",5,11);
AGR.CHAR("McL.2","McLd2G1-f5r896bB0",5,13);
AGR.CHAR("McL.2","McLd2G1-f7r22aB0",7,3);
AGR.CHAR("McL.2","McLd2G1-f7r231aB0",7,5);
AGR.CHAR("McL.2","McLd2G1-f7r252aB0",7,7);
AGR.CHAR("McL.2","McLd2G1-p22275aB0",0,[1,3,[7,2],14,15,16,24,30]);
AGR.CHAR("McL.2","McLd2G1-p275B0",0,[1,3,7]);
AGR.CHAR("McL.2","McLd2G1-p4050B0",0,[1,2,3,4,7,8,14,15]);
AGR.CHAR("McL.2","McLd2G1-p44550B0",0,[1,2,3,4,[7,2],[8,2],[14,2],[15,2],16,17,24,25,30,31]);
AGR.CHAR("McL.2","McLd2G1-p7128B0",0,[1,4,7,14,24]);
AGR.CHAR("O8-(2)","O8m2G1-Zr204aB0",0,5,"204a");
AGR.CHAR("O8-(2)","O8m2G1-Zr204bB0",0,6,"204b");
AGR.CHAR("O8-(2)","O8m2G1-Zr34B0",0,2,"34a");
AGR.CHAR("O8-(2)","O8m2G1-Zr51B0",0,3,"51a");
AGR.CHAR("O8-(2)","O8m2G1-Zr84B0",0,4,"84a");
AGR.CHAR("O8-(2)","O8m2G1-f17r34B0",17,2,"34a");
AGR.CHAR("O8-(2)","O8m2G1-f17r51B0",17,3,"51a");
AGR.CHAR("O8-(2)","O8m2G1-f17r83B0",17,4,"83a");
AGR.CHAR("O8-(2)","O8m2G1-f2r26B0",2,5,"26a");
AGR.CHAR("O8-(2)","O8m2G1-f2r48B0",2,6,"48a");
AGR.CHAR("O8-(2)","O8m2G1-f2r8B0",2,2,"8a");
AGR.CHAR("O8-(2)","O8m2G1-f3r34B0",3,2,"34a");
AGR.CHAR("O8-(2)","O8m2G1-f3r50B0",3,3,"50a");
AGR.CHAR("O8-(2)","O8m2G1-f4r48bB0",2,7,"48b");
AGR.CHAR("O8-(2)","O8m2G1-f4r48cB0",2,8,"48c");
AGR.CHAR("O8-(2)","O8m2G1-f4r8bB0",2,3,"8b");
AGR.CHAR("O8-(2)","O8m2G1-f4r8cB0",2,4,"8c");
AGR.CHAR("O8-(2)","O8m2G1-f5r34B0",5,2,"34a");
AGR.CHAR("O8-(2)","O8m2G1-f5r51B0",5,3,"51a");
AGR.CHAR("O8-(2)","O8m2G1-f5r84B0",5,4,"84a");
AGR.CHAR("O8-(2)","O8m2G1-f7r33B0",7,2,"33a");
AGR.CHAR("O8-(2)","O8m2G1-f7r51B0",7,3,"51a");
AGR.CHAR("O8-(2)","O8m2G1-f7r84B0",7,4,"84a");
AGR.CHAR("O8-(2)","O8m2G1-p1071B0",0,[1,2,4,8,9],"1a+34a+84a+476ab");
AGR.CHAR("O8-(2)","O8m2G1-p119B0",0,[1,2,4],"1a+34a+84a");
AGR.CHAR("O8-(2)","O8m2G1-p136B0",0,[1,3,4],"1a+51a+84a");
AGR.CHAR("O8-(2)","O8m2G1-p1632B0",0,[1,3,4,8,13],"1a+51a+84a+476a+1020a");
AGR.CHAR("O8-(2)","O8m2G1-p24192B0",0,[1,2,3,8,9,10,11,12,13,14,23,24,33,34,37,38],"1a+34a+51a+476ab+595a+714ab+1020a+1071a+2142cd+2856ab+4284a+4760a");
AGR.CHAR("O8-(2)","O8m2G1-p45696B0",0,[1,2,3,[4,2],[8,2],[9,2],10,11,12,[13,3],14,[19,2],23,24,25,[33,2],34,[35,2],36,37,38],"1a+34a+51a+84a^2+476a^2b^2+595a+714ab+1020a^3+1071a+1344a^2+2142cd+2176a+2856a^2b+3264a^2+4096a+4284a+4760a");
AGR.CHAR("O8-(2)","O8m2G1-p765B0",0,[1,4,6,8],"1a+84a+204b+476a");
AGR.CHAR("O8-(2).2","O8m2d2G1-f3r34B0",3,3);
AGR.CHAR("O8-(2).2","O8m2d2G1-f3r50B0",3,5);
AGR.CHAR("O8-(2).2","O8m2d2G1-p119B0",0,[1,3,7]);
AGR.CHAR("ON","ONG1-f3r495B0",3,6,"495b");
AGR.CHAR("ON","ONG1-f3r684B0",3,[3,4],"342ab");
AGR.CHAR("ON","ONG1-p122760aB0",0,[1,2,7,9,11],"1a+10944a+26752a+32395b+52668a");
AGR.CHAR("R(27)","R27G1-f27r7aB0",3,2,"7a");
AGR.CHAR("R(27)","R27G1-f2r702B0",2,2,"702a");
AGR.CHAR("R(27)","R27G1-p19684B0",0,[1,20],"1a+19683a");
AGR.CHAR("R(27).3","R27d3G1-f2r702B0",2,4);
AGR.CHAR("R(27).3","R27d3G1-f3r21B0",3,2);
AGR.CHAR("R(27).3","R27d3G1-f4r741B0",2,12);
AGR.CHAR("R(27).3","R27d3G1-p19684B0",0,[1,34]);
AGR.CHAR("Ru","RuG1-f13r378B0",13,2,"378a");
AGR.CHAR("Ru","RuG1-f13r406B0",13,4,"406a");
AGR.CHAR("Ru","RuG1-f13r783B0",13,5,"783a");
AGR.CHAR("Ru","RuG1-f29r378B0",29,3,"378b");
AGR.CHAR("Ru","RuG1-f29r406B0",29,4,"406a");
AGR.CHAR("Ru","RuG1-f29r783B0",29,5,"783a");
AGR.CHAR("Ru","RuG1-f2r1246B0",2,4,"1246a");
AGR.CHAR("Ru","RuG1-f2r28B0",2,2,"28a");
AGR.CHAR("Ru","RuG1-f2r376B0",2,3,"376a");
AGR.CHAR("Ru","RuG1-f3r406B0",3,4,"406a");
AGR.CHAR("Ru","RuG1-f3r783B0",3,5,"783a");
AGR.CHAR("Ru","RuG1-f49r378B0",7,2,"378a");
AGR.CHAR("Ru","RuG1-f5r133B0",5,2,"133a");
AGR.CHAR("Ru","RuG1-f5r273B0",5,3,"273a");
AGR.CHAR("Ru","RuG1-f5r378B0",5,4,"378a");
AGR.CHAR("Ru","RuG1-f5r783B0",5,6,"783a");
AGR.CHAR("Ru","RuG1-f7r406B0",7,4,"406a");
AGR.CHAR("Ru","RuG1-f7r782B0",7,5,"782a");
AGR.CHAR("Ru","RuG1-f9r378B0",3,3,"378b");
AGR.CHAR("Ru","RuG1-p4060B0",0,[1,5,6],"1a+783a+3276a");
AGR.CHAR("S6(2)","S62G1-Zr105aB0",0,12,"105a");
AGR.CHAR("S6(2)","S62G1-Zr105bB0",0,13,"105b");
AGR.CHAR("S6(2)","S62G1-Zr105cB0",0,14,"105c");
AGR.CHAR("S6(2)","S62G1-Zr120B0",0,15,"120a");
AGR.CHAR("S6(2)","S62G1-Zr15B0",0,3,"15a");
AGR.CHAR("S6(2)","S62G1-Zr168B0",0,16,"168a");
AGR.CHAR("S6(2)","S62G1-Zr189aB0",0,17,"189a");
AGR.CHAR("S6(2)","S62G1-Zr189bB0",0,18,"189b");
AGR.CHAR("S6(2)","S62G1-Zr189cB0",0,19,"189c");
AGR.CHAR("S6(2)","S62G1-Zr210aB0",0,20,"210a");
AGR.CHAR("S6(2)","S62G1-Zr210bB0",0,21,"210b");
AGR.CHAR("S6(2)","S62G1-Zr216B0",0,22,"216a");
AGR.CHAR("S6(2)","S62G1-Zr21aB0",0,4,"21a");
AGR.CHAR("S6(2)","S62G1-Zr21bB0",0,5,"21b");
AGR.CHAR("S6(2)","S62G1-Zr27B0",0,6,"27a");
AGR.CHAR("S6(2)","S62G1-Zr35aB0",0,7,"35a");
AGR.CHAR("S6(2)","S62G1-Zr35bB0",0,8,"35b");
AGR.CHAR("S6(2)","S62G1-Zr56B0",0,9,"56a");
AGR.CHAR("S6(2)","S62G1-Zr70B0",0,10,"70a");
AGR.CHAR("S6(2)","S62G1-Zr7B0",0,2,"7a");
AGR.CHAR("S6(2)","S62G1-Zr84B0",0,11,"84a");
AGR.CHAR("S6(2)","S62G1-f2r112B0",2,7,"112a");
AGR.CHAR("S6(2)","S62G1-f2r14B0",2,4,"14a");
AGR.CHAR("S6(2)","S62G1-f2r48B0",2,5,"48a");
AGR.CHAR("S6(2)","S62G1-f2r512B0",2,8,"512a");
AGR.CHAR("S6(2)","S62G1-f2r64B0",2,6,"64a");
AGR.CHAR("S6(2)","S62G1-f2r6B0",2,2,"6a");
AGR.CHAR("S6(2)","S62G1-f2r8B0",2,3,"8a");
AGR.CHAR("S6(2)","S62G1-f3r14B0",3,3,"14a");
AGR.CHAR("S6(2)","S62G1-f3r189aB0",3,11,"189a");
AGR.CHAR("S6(2)","S62G1-f3r189bB0",3,12,"189b");
AGR.CHAR("S6(2)","S62G1-f3r189cB0",3,13,"189c");
AGR.CHAR("S6(2)","S62G1-f3r196B0",3,14,"196a");
AGR.CHAR("S6(2)","S62G1-f3r21B0",3,4,"21a");
AGR.CHAR("S6(2)","S62G1-f3r27B0",3,5,"27a");
AGR.CHAR("S6(2)","S62G1-f3r34B0",3,6,"34a");
AGR.CHAR("S6(2)","S62G1-f3r35B0",3,7,"35a");
AGR.CHAR("S6(2)","S62G1-f3r405B0",3,15,"405a");
AGR.CHAR("S6(2)","S62G1-f3r49B0",3,8,"49a");
AGR.CHAR("S6(2)","S62G1-f3r7B0",3,2,"7a");
AGR.CHAR("S6(2)","S62G1-f3r91B0",3,9,"91a");
AGR.CHAR("S6(2)","S62G1-f3r98B0",3,10,"98a");
AGR.CHAR("S6(2)","S62G1-p120B0",0,[1,7,11],"1a+35a+84a");
AGR.CHAR("S6(2)","S62G1-p126B0",0,[1,2,6,8,9],"1a+7a+27a+35b+56a");
AGR.CHAR("S6(2)","S62G1-p135B0",0,[1,3,8,11],"1a+15a+35b+84a");
AGR.CHAR("S6(2)","S62G1-p240B0",0,[1,3,7,11,14],"1a+15a+35a+84a+105c");
AGR.CHAR("S6(2)","S62G1-p288B0",0,[1,6,8,13,15],"1a+27a+35b+105b+120a");
AGR.CHAR("S6(2)","S62G1-p28B0",0,[1,6],"1a+27a");
AGR.CHAR("S6(2)","S62G1-p315B0",0,[1,6,8,11,16],"1a+27a+35b+84a+168a");
AGR.CHAR("S6(2)","S62G1-p336B0",0,[1,6,8,13,16],"1a+27a+35b+105b+168a");
AGR.CHAR("S6(2)","S62G1-p36B0",0,[1,8],"1a+35b");
AGR.CHAR("S6(2)","S62G1-p378aB0",0,[1,[6,2],8,15,16],"1a+27a^2+35b+120a+168a");
AGR.CHAR("S6(2)","S62G1-p378bB0",0,[1,3,6,8,11,22],"1a+15a+27a+35b+84a+216a");
AGR.CHAR("S6(2)","S62G1-p56B0",0,[1,2,5,6],"1a+7a+21b+27a");
AGR.CHAR("S6(2)","S62G1-p63B0",0,[1,6,8],"1a+27a+35b");
AGR.CHAR("S6(2)","S62G1-p72B0",0,[1,3,5,8],"1a+15a+21b+35b");
AGR.CHAR("S6(2)","S62G1-p960B0",0,[1,10,11,13,23,29],"1a+70a+84a+105b+280a+420a");
AGR.CHAR("Suz","SuzG1-Zr143B0",0,2,"143a");
AGR.CHAR("Suz","SuzG1-f11r143B0",11,2,"143a");
AGR.CHAR("Suz","SuzG1-f11r364B0",11,3,"364a");
AGR.CHAR("Suz","SuzG1-f11r779B0",11,4,"779a");
AGR.CHAR("Suz","SuzG1-f13r143B0",13,2,"143a");
AGR.CHAR("Suz","SuzG1-f13r364B0",13,3,"364a");
AGR.CHAR("Suz","SuzG1-f13r780B0",13,4,"780a");
AGR.CHAR("Suz","SuzG1-f2r142B0",2,4,"142a");
AGR.CHAR("Suz","SuzG1-f2r638B0",2,7,"638a");
AGR.CHAR("Suz","SuzG1-f3r286B0",3,4,"286a");
AGR.CHAR("Suz","SuzG1-f3r429B0",3,5,"429a");
AGR.CHAR("Suz","SuzG1-f3r649B0",3,6,"649a");
AGR.CHAR("Suz","SuzG1-f3r64B0",3,2,"64a");
AGR.CHAR("Suz","SuzG1-f3r78B0",3,3,"78a");
AGR.CHAR("Suz","SuzG1-f5r143B0",5,2,"143a");
AGR.CHAR("Suz","SuzG1-f5r363B0",5,3,"363a");
AGR.CHAR("Suz","SuzG1-f5r780B0",5,4,"780a");
AGR.CHAR("Suz","SuzG1-f7r143B0",7,2,"143a");
AGR.CHAR("Suz","SuzG1-f7r364B0",7,3,"364a");
AGR.CHAR("Suz","SuzG1-f7r780B0",7,4,"780a");
AGR.CHAR("Suz","SuzG1-p135135B0",0,[1,2,4,6,9,12,16,17,27],"1a+143a+780a+3432a+5940a+14300a+18954a+25025a+66560a");
AGR.CHAR("Suz","SuzG1-p1782B0",0,[1,4,5],"1a+780a+1001a");
AGR.CHAR("Suz","SuzG1-p22880B0",0,[1,3,4,9,15],"1a+364a+780a+5940a+15795a");
AGR.CHAR("Suz","SuzG1-p232960B0",0,[1,[3,2],9,11,12,13,14,15,23,33],"1a+364a^2+5940a+12012a+14300a+15015ab+15795a+54054a+100100a");
AGR.CHAR("Suz","SuzG1-p32760B0",0,[1,2,3,9,11,12],"1a+143a+364a+5940a+12012a+14300a");
AGR.CHAR("Suz","SuzG1-p370656B0",0,[1,[4,2],5,6,9,15,16,17,24,27,29,30],"1a+780a^2+1001a+3432a+5940a+15795a+18954a+25025a+64064a+66560a+79872a+88452a");
AGR.CHAR("Suz","SuzG1-p405405B0",0,[1,3,4,5,9,11,12,15,17,27,28,30,33],"1a+364a+780a+1001a+5940a+12012a+14300a+15795a+25025a+66560a+75075a+88452a+100100a");
AGR.CHAR("Sz(32)","Sz32G1-f41r124bB0",41,3,"124b");
AGR.CHAR("Sz(32)","Sz32G1-f5r124aB0",5,2,"124a");
AGR.CHAR("Sz(32)","Sz32G1-p1025B0",0,[1,14],"1a+1024a");
AGR.CHAR("Sz(32)","Sz32G1-p198400B0",0,[1,[4,6],[5,6],[6,6],[7,6],[8,6],[9,6],[10,6],[11,6],[12,6],[13,6],[14,6],[15,7],[16,7],[17,7],[18,7],[19,7],[20,7],[21,7],[22,7],[23,7],[24,7],[25,7],[26,7],[27,7],[28,7],[29,7],[30,5],[31,5],[32,5],[33,5],[34,5],[35,5]],"1a+775a^6b^6c^6d^6e^6f^6g^6h^6i^6j^6+1024a^6+1025a^7b^7c^7d^7e^7f^7g^7h^7i^7j^7k^7l^7m^7n^7o^7+1271a^5b^5c^5d^5e^5f^5");
AGR.CHAR("Sz(8)","Sz8G1-Ar14aB0",0,2,"14a");
AGR.CHAR("Sz(8)","Sz8G1-Ar14bB0",0,3,"14b");
AGR.CHAR("Sz(8)","Sz8G1-Ar65aB0",0,8,"65a");
AGR.CHAR("Sz(8)","Sz8G1-Ar65bB0",0,9,"65b");
AGR.CHAR("Sz(8)","Sz8G1-Ar65cB0",0,10,"65c");
AGR.CHAR("Sz(8)","Sz8G1-Zr64B0",0,7,"64a");
AGR.CHAR("Sz(8)","Sz8G1-Zr91B0",0,11,"91a");
AGR.CHAR("Sz(8)","Sz8G1-f125r65aB0",5,8,"65a");
AGR.CHAR("Sz(8)","Sz8G1-f125r65bB0",5,10,"65c");
AGR.CHAR("Sz(8)","Sz8G1-f125r65cB0",5,9,"65b");
AGR.CHAR("Sz(8)","Sz8G1-f13r14aB0",13,2,"14a");
AGR.CHAR("Sz(8)","Sz8G1-f13r14bB0",13,3,"14b");
AGR.CHAR("Sz(8)","Sz8G1-f13r35B0",13,4,"35a");
AGR.CHAR("Sz(8)","Sz8G1-f13r65aB0",13,5,"65a");
AGR.CHAR("Sz(8)","Sz8G1-f13r65bB0",13,6,"65b");
AGR.CHAR("Sz(8)","Sz8G1-f13r65cB0",13,7,"65c");
AGR.CHAR("Sz(8)","Sz8G1-f13r91B0",13,8,"91a");
AGR.CHAR("Sz(8)","Sz8G1-f2r64B0",2,8,"64a");
AGR.CHAR("Sz(8)","Sz8G1-f49r14aB0",7,2,"14a");
AGR.CHAR("Sz(8)","Sz8G1-f5r14aB0",5,2,"14a");
AGR.CHAR("Sz(8)","Sz8G1-f5r14bB0",5,3,"14b");
AGR.CHAR("Sz(8)","Sz8G1-f5r195B0",5,[8,9,10],"65abc");
AGR.CHAR("Sz(8)","Sz8G1-f5r35aB0",5,4,"35a");
AGR.CHAR("Sz(8)","Sz8G1-f5r35bB0",5,5,"35b");
AGR.CHAR("Sz(8)","Sz8G1-f5r35cB0",5,6,"35c");
AGR.CHAR("Sz(8)","Sz8G1-f5r63B0",5,7,"63a");
AGR.CHAR("Sz(8)","Sz8G1-f7r105B0",7,[4,5,6],"35abc");
AGR.CHAR("Sz(8)","Sz8G1-f7r64B0",7,7,"64a");
AGR.CHAR("Sz(8)","Sz8G1-f7r91B0",7,8,"91a");
AGR.CHAR("Sz(8)","Sz8G1-f8r16aB0",2,5,"16a");
AGR.CHAR("Sz(8)","Sz8G1-f8r4aB0",2,2,"4a");
AGR.CHAR("Sz(8)","Sz8G1-p1456B0",0,[1,[4,2],[5,2],[6,2],[7,3],[8,4],[9,4],[10,4],[11,3]],"1a+35a^2b^2c^2+64a^3+65a^4b^4c^4+91a^3");
AGR.CHAR("Sz(8)","Sz8G1-p2080B0",0,[1,[4,4],[5,4],[6,4],[7,5],[8,5],[9,5],[10,5],[11,4]],"1a+35a^4b^4c^4+64a^5+65a^5b^5c^5+91a^4");
AGR.CHAR("Sz(8)","Sz8G1-p520B0",0,[1,4,5,6,[7,2],8,9,10,11],"1a+35abc+64a^2+65abc+91a");
AGR.CHAR("Sz(8)","Sz8G1-p560B0",0,[1,4,5,6,7,[8,2],[9,2],[10,2]],"1a+35abc+64a+65a^2b^2c^2");
AGR.CHAR("Sz(8)","Sz8G1-p65B0",0,[1,7],"1a+64a");
AGR.CHAR("Sz(8).3","Sz8d3G1-f13r14B0",13,4);
AGR.CHAR("Sz(8).3","Sz8d3G1-f2r12B0",2,4);
AGR.CHAR("Sz(8).3","Sz8d3G1-f2r48B0",2,5);
AGR.CHAR("Sz(8).3","Sz8d3G1-f2r64B0",2,6);
AGR.CHAR("Sz(8).3","Sz8d3G1-f49r14B0",7,4);
AGR.CHAR("Sz(8).3","Sz8d3G1-f5r105B0",5,10);
AGR.CHAR("Sz(8).3","Sz8d3G1-f5r14B0",5,4);
AGR.CHAR("Sz(8).3","Sz8d3G1-f5r195B0",5,14);
AGR.CHAR("Sz(8).3","Sz8d3G1-f5r63B0",5,11);
AGR.CHAR("Sz(8).3","Sz8d3G1-p1456B0",0,[1,[10,2],11,12,13,[14,4],15,16,17]);
AGR.CHAR("Sz(8).3","Sz8d3G1-p2080B0",0,[1,[10,4],[11,3],12,13,[14,5],[15,2],16,17]);
AGR.CHAR("Sz(8).3","Sz8d3G1-p520B0",0,[1,10,[11,2],14,15]);
AGR.CHAR("Sz(8).3","Sz8d3G1-p560B0",0,[1,10,11,[14,2]]);
AGR.CHAR("Sz(8).3","Sz8d3G1-p65B0",0,[1,11]);
AGR.CHAR("Th","ThG1-f13r248B0",13,2,"248a");
AGR.CHAR("U4(2)","U42G1-Ar10B0",0,5,"10a");
AGR.CHAR("U4(2)","U42G1-Ar10aB0",0,5,"10a");
AGR.CHAR("U4(2)","U42G1-Ar10bB0",0,6,"10b");
AGR.CHAR("U4(2)","U42G1-Ar30bB0",0,12,"30b");
AGR.CHAR("U4(2)","U42G1-Ar30cB0",0,13,"30c");
AGR.CHAR("U4(2)","U42G1-Ar40aB0",0,14,"40a");
AGR.CHAR("U4(2)","U42G1-Ar40bB0",0,15,"40b");
AGR.CHAR("U4(2)","U42G1-Ar45aB0",0,16,"45a");
AGR.CHAR("U4(2)","U42G1-Ar45bB0",0,17,"45b");
AGR.CHAR("U4(2)","U42G1-Ar5aB0",0,2,"5a");
AGR.CHAR("U4(2)","U42G1-Ar5bB0",0,3,"5b");
AGR.CHAR("U4(2)","U42G1-Zr15aB0",0,7,"15a");
AGR.CHAR("U4(2)","U42G1-Zr15bB0",0,8,"15b");
AGR.CHAR("U4(2)","U42G1-Zr20B0",0,9,"20a");
AGR.CHAR("U4(2)","U42G1-Zr24B0",0,10,"24a");
AGR.CHAR("U4(2)","U42G1-Zr30aB0",0,11,"30a");
AGR.CHAR("U4(2)","U42G1-Zr60B0",0,18,"60a");
AGR.CHAR("U4(2)","U42G1-Zr64B0",0,19,"64a");
AGR.CHAR("U4(2)","U42G1-Zr6B0",0,4,"6a");
AGR.CHAR("U4(2)","U42G1-Zr80B0",0,[14,15],"40ab");
AGR.CHAR("U4(2)","U42G1-Zr81B0",0,20,"81a");
AGR.CHAR("U4(2)","U42G1-f25r10bB0",5,6,"10b");
AGR.CHAR("U4(2)","U42G1-f25r5aB0",5,2,"5a");
AGR.CHAR("U4(2)","U42G1-f3r10B0",3,3,"10a");
AGR.CHAR("U4(2)","U42G1-f3r14B0",3,4,"14a");
AGR.CHAR("U4(2)","U42G1-f3r25B0",3,5,"25a");
AGR.CHAR("U4(2)","U42G1-f3r5B0",3,2,"5a");
AGR.CHAR("U4(2)","U42G1-f3r81B0",3,6,"81a");
AGR.CHAR("U4(2)","U42G1-f4r4aB0",2,2,"4a");
AGR.CHAR("U4(2)","U42G1-f5r6B0",5,4,"6a");
AGR.CHAR("U4(2)","U42G1-p27B0",0,[1,4,9],"1a+6a+20a");
AGR.CHAR("U4(2)","U42G1-p36B0",0,[1,8,9],"1a+15b+20a");
AGR.CHAR("U4(2)","U42G1-p40aB0",0,[1,7,10],"1a+15a+24a");
AGR.CHAR("U4(2)","U42G1-p40bB0",0,[1,8,10],"1a+15b+24a");
AGR.CHAR("U4(2)","U42G1-p45B0",0,[1,9,10],"1a+20a+24a");
AGR.CHAR("U4(2).2","U42d2G1-f2r14B0",2,4);
AGR.CHAR("U4(2).2","U42d2G1-f2r40B0",2,5);
AGR.CHAR("U4(2).2","U42d2G1-f2r64B0",2,6);
AGR.CHAR("U4(2).2","U42d2G1-f2r6B0",2,3);
AGR.CHAR("U4(2).2","U42d2G1-f2r8B0",2,2);
AGR.CHAR("U4(2).2","U42d2G1-f3r5B0",3,3);
AGR.CHAR("U4(2).2","U42d2G1-p27B0",0,[1,4,11]);
AGR.CHAR("U4(2).2","U42d2G1-p36B0",0,[1,9,11]);
AGR.CHAR("U4(2).2","U42d2G1-p40aB0",0,[1,8,13]);
AGR.CHAR("U4(2).2","U42d2G1-p40bB0",0,[1,9,13]);
AGR.CHAR("U4(2).2","U42d2G1-p45B0",0,[1,11,13]);
AGR.CHAR("U5(2)","U52G1-Ar66aB0",0,9,"66a");
AGR.CHAR("U5(2)","U52G1-Ar66bB0",0,10,"66b");
AGR.CHAR("U5(2)","U52G1-Zr120B0",0,16,"120a");
AGR.CHAR("U5(2)","U52G1-Zr165B0",0,17,"165a");
AGR.CHAR("U5(2)","U52G1-Zr176B0",0,18,"176a");
AGR.CHAR("U5(2)","U52G1-Zr55B0",0,6,"55a");
AGR.CHAR("U5(2)","U52G1-f11r119B0",11,16,"119a");
AGR.CHAR("U5(2)","U52G1-f11r176B0",11,18,"176a");
AGR.CHAR("U5(2)","U52G1-f11r44B0",11,5,"44a");
AGR.CHAR("U5(2)","U52G1-f2r24B0",2,6,"24a");
AGR.CHAR("U5(2)","U52G1-f2r74B0",2,11,"74a");
AGR.CHAR("U5(2)","U52G1-f3r100B0",3,5,"100a");
AGR.CHAR("U5(2)","U52G1-f3r10B0",3,2,"10a");
AGR.CHAR("U5(2)","U52G1-f3r110B0",3,6,"110a");
AGR.CHAR("U5(2)","U52G1-f3r44B0",3,3,"44a");
AGR.CHAR("U5(2)","U52G1-f3r55B0",3,4,"55a");
AGR.CHAR("U5(2)","U52G1-f4r10aB0",2,4,"10a");
AGR.CHAR("U5(2)","U52G1-f4r10bB0",2,5,"10b");
AGR.CHAR("U5(2)","U52G1-f4r5aB0",2,2,"5a");
AGR.CHAR("U5(2)","U52G1-f4r5bB0",2,3,"5b");
AGR.CHAR("U5(2)","U52G1-f5r120B0",5,16,"120a");
AGR.CHAR("U5(2)","U52G1-f5r176B0",5,18,"176a");
AGR.CHAR("U5(2)","U52G1-f5r43B0",5,5,"43a");
AGR.CHAR("U5(2)","U52G1-f5r55aB0",5,6,"55a");
AGR.CHAR("U5(2)","U52G1-p1408B0",0,[1,6,9,10,16,28,35],"1a+55a+66ab+120a+440a+660a");
AGR.CHAR("U5(2)","U52G1-p165B0",0,[1,5,16],"1a+44a+120a");
AGR.CHAR("U5(2)","U52G1-p176B0",0,[1,6,16],"1a+55a+120a");
AGR.CHAR("U5(2)","U52G1-p20736B0",0,[1,3,4,6,[9,2],[10,2],14,15,16,[18,3],[21,2],[22,2],28,29,30,[31,2],[32,2],[35,3],36,37,[38,2],[39,2],[43,2],[44,2],[45,2],46,47],"1a+11ab+55a+66a^2b^2+110de+120a+176a^3+220c^2d^2+440abc+495a^2b^2+660a^3+704ab+880a^2b^2+990a^2b^2+1024a^2+1215ab");
AGR.CHAR("U5(2)","U52G1-p297B0",0,[1,16,18],"1a+120a+176a");
AGR.CHAR("U5(2)","U52G1-p3520B0",0,[1,5,6,[16,2],17,28,35,40,45],"1a+44a+55a+120a^2+165a+440a+660a+891a+1024a");
AGR.CHAR("U5(2).2","U52d2G1-f2r1024B0",2,10);
AGR.CHAR("U5(2).2","U52d2G1-f2r10B0",2,2);
AGR.CHAR("U5(2).2","U52d2G1-f2r20B0",2,3);
AGR.CHAR("U5(2).2","U52d2G1-f2r24B0",2,4);
AGR.CHAR("U5(2).2","U52d2G1-f2r320B0",2,8);
AGR.CHAR("U5(2).2","U52d2G1-f2r560B0",2,9);
AGR.CHAR("U5(2).2","U52d2G1-f2r74B0",2,7);
AGR.CHAR("U5(2).2","U52d2G1-f2r80aB0",2,5);
AGR.CHAR("U5(2).2","U52d2G1-f2r80bB0",2,6);
AGR.CHAR("U5(2).2","U52d2G1-f3r10aB0",3,4);
AGR.CHAR("U5(2).2","U52d2G1-p1408B0",0,[1,8,11,16,28,33]);
AGR.CHAR("U5(2).2","U52d2G1-p165B0",0,[1,6,16]);
AGR.CHAR("U5(2).2","U52d2G1-p176B0",0,[1,8,16]);
AGR.CHAR("U5(2).2","U52d2G1-p20736B0",0,[1,5,8,[11,2],15,16,[20,2],21,[23,2],28,30,[31,2],[33,2],34,35,[36,2],[40,2],[41,2],43]);
AGR.CHAR("U5(2).2","U52d2G1-p297B0",0,[1,16,20]);
AGR.CHAR("U5(2).2","U52d2G1-p3520B0",0,[1,6,8,[16,2],18,28,33,37,41]);


AtlasOfGroupRepresentationsInfo.TableOfContents.( "remote" ).lastupdated:=
  "25-Mar-2016, 13:25:41.000 UTC";

#############################################################################
##
#E

