// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file ComprehensiveTypeTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen.
 */

#include "ComprehensiveTypeTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>

#include "ComprehensiveType.hpp"


using namespace eprosima::fastdds::dds::xtypes;

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_PrimitivesStruct_type_identifier(
        TypeIdentifierPair& type_ids_PrimitivesStruct)
{

    ReturnCode_t return_code_PrimitivesStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_PrimitivesStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "PrimitivesStruct", type_ids_PrimitivesStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_PrimitivesStruct)
    {
        StructTypeFlag struct_flags_PrimitivesStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_PrimitivesStruct = "PrimitivesStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_PrimitivesStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_PrimitivesStruct;
        CompleteTypeDetail detail_PrimitivesStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_PrimitivesStruct, ann_custom_PrimitivesStruct, type_name_PrimitivesStruct.to_string());
        CompleteStructHeader header_PrimitivesStruct;
        header_PrimitivesStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_PrimitivesStruct);
        CompleteStructMemberSeq member_seq_PrimitivesStruct;
        {
            TypeIdentifierPair type_ids_my_bool;
            ReturnCode_t return_code_my_bool {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_bool =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_bool", type_ids_my_bool);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_bool)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_bool Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_bool = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_bool = 0x00000000;
            bool common_my_bool_ec {false};
            CommonStructMember common_my_bool {TypeObjectUtils::build_common_struct_member(member_id_my_bool, member_flags_my_bool, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_bool, common_my_bool_ec))};
            if (!common_my_bool_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_bool member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_bool = "my_bool";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_bool;
            ann_custom_PrimitivesStruct.reset();
            CompleteMemberDetail detail_my_bool = TypeObjectUtils::build_complete_member_detail(name_my_bool, member_ann_builtin_my_bool, ann_custom_PrimitivesStruct);
            CompleteStructMember member_my_bool = TypeObjectUtils::build_complete_struct_member(common_my_bool, detail_my_bool);
            TypeObjectUtils::add_complete_struct_member(member_seq_PrimitivesStruct, member_my_bool);
        }
        {
            TypeIdentifierPair type_ids_my_octet;
            ReturnCode_t return_code_my_octet {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_octet =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_my_octet);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_octet)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_octet Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_octet = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_octet = 0x00000001;
            bool common_my_octet_ec {false};
            CommonStructMember common_my_octet {TypeObjectUtils::build_common_struct_member(member_id_my_octet, member_flags_my_octet, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_octet, common_my_octet_ec))};
            if (!common_my_octet_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_octet member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_octet = "my_octet";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_octet;
            ann_custom_PrimitivesStruct.reset();
            CompleteMemberDetail detail_my_octet = TypeObjectUtils::build_complete_member_detail(name_my_octet, member_ann_builtin_my_octet, ann_custom_PrimitivesStruct);
            CompleteStructMember member_my_octet = TypeObjectUtils::build_complete_struct_member(common_my_octet, detail_my_octet);
            TypeObjectUtils::add_complete_struct_member(member_seq_PrimitivesStruct, member_my_octet);
        }
        {
            TypeIdentifierPair type_ids_my_char;
            ReturnCode_t return_code_my_char {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_char =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_char", type_ids_my_char);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_char)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_char Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_char = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_char = 0x00000002;
            bool common_my_char_ec {false};
            CommonStructMember common_my_char {TypeObjectUtils::build_common_struct_member(member_id_my_char, member_flags_my_char, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_char, common_my_char_ec))};
            if (!common_my_char_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_char member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_char = "my_char";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_char;
            ann_custom_PrimitivesStruct.reset();
            CompleteMemberDetail detail_my_char = TypeObjectUtils::build_complete_member_detail(name_my_char, member_ann_builtin_my_char, ann_custom_PrimitivesStruct);
            CompleteStructMember member_my_char = TypeObjectUtils::build_complete_struct_member(common_my_char, detail_my_char);
            TypeObjectUtils::add_complete_struct_member(member_seq_PrimitivesStruct, member_my_char);
        }
        {
            TypeIdentifierPair type_ids_my_wchar;
            ReturnCode_t return_code_my_wchar {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_wchar =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_wchar_t", type_ids_my_wchar);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_wchar)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_wchar Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_wchar = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_wchar = 0x00000003;
            bool common_my_wchar_ec {false};
            CommonStructMember common_my_wchar {TypeObjectUtils::build_common_struct_member(member_id_my_wchar, member_flags_my_wchar, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_wchar, common_my_wchar_ec))};
            if (!common_my_wchar_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_wchar member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_wchar = "my_wchar";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_wchar;
            ann_custom_PrimitivesStruct.reset();
            CompleteMemberDetail detail_my_wchar = TypeObjectUtils::build_complete_member_detail(name_my_wchar, member_ann_builtin_my_wchar, ann_custom_PrimitivesStruct);
            CompleteStructMember member_my_wchar = TypeObjectUtils::build_complete_struct_member(common_my_wchar, detail_my_wchar);
            TypeObjectUtils::add_complete_struct_member(member_seq_PrimitivesStruct, member_my_wchar);
        }
        {
            TypeIdentifierPair type_ids_my_long;
            ReturnCode_t return_code_my_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_my_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_long)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_long Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_long = 0x00000004;
            bool common_my_long_ec {false};
            CommonStructMember common_my_long {TypeObjectUtils::build_common_struct_member(member_id_my_long, member_flags_my_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_long, common_my_long_ec))};
            if (!common_my_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_long = "my_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_long;
            ann_custom_PrimitivesStruct.reset();
            CompleteMemberDetail detail_my_long = TypeObjectUtils::build_complete_member_detail(name_my_long, member_ann_builtin_my_long, ann_custom_PrimitivesStruct);
            CompleteStructMember member_my_long = TypeObjectUtils::build_complete_struct_member(common_my_long, detail_my_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_PrimitivesStruct, member_my_long);
        }
        {
            TypeIdentifierPair type_ids_my_ulong;
            ReturnCode_t return_code_my_ulong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_ulong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_my_ulong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_ulong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_ulong Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_ulong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_ulong = 0x00000005;
            bool common_my_ulong_ec {false};
            CommonStructMember common_my_ulong {TypeObjectUtils::build_common_struct_member(member_id_my_ulong, member_flags_my_ulong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_ulong, common_my_ulong_ec))};
            if (!common_my_ulong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_ulong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_ulong = "my_ulong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_ulong;
            ann_custom_PrimitivesStruct.reset();
            CompleteMemberDetail detail_my_ulong = TypeObjectUtils::build_complete_member_detail(name_my_ulong, member_ann_builtin_my_ulong, ann_custom_PrimitivesStruct);
            CompleteStructMember member_my_ulong = TypeObjectUtils::build_complete_struct_member(common_my_ulong, detail_my_ulong);
            TypeObjectUtils::add_complete_struct_member(member_seq_PrimitivesStruct, member_my_ulong);
        }
        {
            TypeIdentifierPair type_ids_my_int8;
            ReturnCode_t return_code_my_int8 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_int8 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int8_t", type_ids_my_int8);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_int8)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_int8 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_int8 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_int8 = 0x00000006;
            bool common_my_int8_ec {false};
            CommonStructMember common_my_int8 {TypeObjectUtils::build_common_struct_member(member_id_my_int8, member_flags_my_int8, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_int8, common_my_int8_ec))};
            if (!common_my_int8_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_int8 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_int8 = "my_int8";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_int8;
            ann_custom_PrimitivesStruct.reset();
            CompleteMemberDetail detail_my_int8 = TypeObjectUtils::build_complete_member_detail(name_my_int8, member_ann_builtin_my_int8, ann_custom_PrimitivesStruct);
            CompleteStructMember member_my_int8 = TypeObjectUtils::build_complete_struct_member(common_my_int8, detail_my_int8);
            TypeObjectUtils::add_complete_struct_member(member_seq_PrimitivesStruct, member_my_int8);
        }
        {
            TypeIdentifierPair type_ids_my_uint8;
            ReturnCode_t return_code_my_uint8 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_uint8 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint8_t", type_ids_my_uint8);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_uint8)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_uint8 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_uint8 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_uint8 = 0x00000007;
            bool common_my_uint8_ec {false};
            CommonStructMember common_my_uint8 {TypeObjectUtils::build_common_struct_member(member_id_my_uint8, member_flags_my_uint8, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_uint8, common_my_uint8_ec))};
            if (!common_my_uint8_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_uint8 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_uint8 = "my_uint8";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_uint8;
            ann_custom_PrimitivesStruct.reset();
            CompleteMemberDetail detail_my_uint8 = TypeObjectUtils::build_complete_member_detail(name_my_uint8, member_ann_builtin_my_uint8, ann_custom_PrimitivesStruct);
            CompleteStructMember member_my_uint8 = TypeObjectUtils::build_complete_struct_member(common_my_uint8, detail_my_uint8);
            TypeObjectUtils::add_complete_struct_member(member_seq_PrimitivesStruct, member_my_uint8);
        }
        {
            TypeIdentifierPair type_ids_my_short;
            ReturnCode_t return_code_my_short {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_my_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_short)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_short Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_short = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_short = 0x00000008;
            bool common_my_short_ec {false};
            CommonStructMember common_my_short {TypeObjectUtils::build_common_struct_member(member_id_my_short, member_flags_my_short, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_short, common_my_short_ec))};
            if (!common_my_short_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_short member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_short = "my_short";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_short;
            ann_custom_PrimitivesStruct.reset();
            CompleteMemberDetail detail_my_short = TypeObjectUtils::build_complete_member_detail(name_my_short, member_ann_builtin_my_short, ann_custom_PrimitivesStruct);
            CompleteStructMember member_my_short = TypeObjectUtils::build_complete_struct_member(common_my_short, detail_my_short);
            TypeObjectUtils::add_complete_struct_member(member_seq_PrimitivesStruct, member_my_short);
        }
        {
            TypeIdentifierPair type_ids_my_ushort;
            ReturnCode_t return_code_my_ushort {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_ushort =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_my_ushort);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_ushort)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_ushort Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_ushort = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_ushort = 0x00000009;
            bool common_my_ushort_ec {false};
            CommonStructMember common_my_ushort {TypeObjectUtils::build_common_struct_member(member_id_my_ushort, member_flags_my_ushort, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_ushort, common_my_ushort_ec))};
            if (!common_my_ushort_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_ushort member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_ushort = "my_ushort";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_ushort;
            ann_custom_PrimitivesStruct.reset();
            CompleteMemberDetail detail_my_ushort = TypeObjectUtils::build_complete_member_detail(name_my_ushort, member_ann_builtin_my_ushort, ann_custom_PrimitivesStruct);
            CompleteStructMember member_my_ushort = TypeObjectUtils::build_complete_struct_member(common_my_ushort, detail_my_ushort);
            TypeObjectUtils::add_complete_struct_member(member_seq_PrimitivesStruct, member_my_ushort);
        }
        {
            TypeIdentifierPair type_ids_my_longlong;
            ReturnCode_t return_code_my_longlong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_longlong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_my_longlong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_longlong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_longlong Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_longlong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_longlong = 0x0000000a;
            bool common_my_longlong_ec {false};
            CommonStructMember common_my_longlong {TypeObjectUtils::build_common_struct_member(member_id_my_longlong, member_flags_my_longlong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_longlong, common_my_longlong_ec))};
            if (!common_my_longlong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_longlong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_longlong = "my_longlong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_longlong;
            ann_custom_PrimitivesStruct.reset();
            CompleteMemberDetail detail_my_longlong = TypeObjectUtils::build_complete_member_detail(name_my_longlong, member_ann_builtin_my_longlong, ann_custom_PrimitivesStruct);
            CompleteStructMember member_my_longlong = TypeObjectUtils::build_complete_struct_member(common_my_longlong, detail_my_longlong);
            TypeObjectUtils::add_complete_struct_member(member_seq_PrimitivesStruct, member_my_longlong);
        }
        {
            TypeIdentifierPair type_ids_my_ulonglong;
            ReturnCode_t return_code_my_ulonglong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_ulonglong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint64_t", type_ids_my_ulonglong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_ulonglong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_ulonglong Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_ulonglong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_ulonglong = 0x0000000b;
            bool common_my_ulonglong_ec {false};
            CommonStructMember common_my_ulonglong {TypeObjectUtils::build_common_struct_member(member_id_my_ulonglong, member_flags_my_ulonglong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_ulonglong, common_my_ulonglong_ec))};
            if (!common_my_ulonglong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_ulonglong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_ulonglong = "my_ulonglong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_ulonglong;
            ann_custom_PrimitivesStruct.reset();
            CompleteMemberDetail detail_my_ulonglong = TypeObjectUtils::build_complete_member_detail(name_my_ulonglong, member_ann_builtin_my_ulonglong, ann_custom_PrimitivesStruct);
            CompleteStructMember member_my_ulonglong = TypeObjectUtils::build_complete_struct_member(common_my_ulonglong, detail_my_ulonglong);
            TypeObjectUtils::add_complete_struct_member(member_seq_PrimitivesStruct, member_my_ulonglong);
        }
        {
            TypeIdentifierPair type_ids_my_float;
            ReturnCode_t return_code_my_float {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_float =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_float", type_ids_my_float);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_float)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_float Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_float = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_float = 0x0000000c;
            bool common_my_float_ec {false};
            CommonStructMember common_my_float {TypeObjectUtils::build_common_struct_member(member_id_my_float, member_flags_my_float, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_float, common_my_float_ec))};
            if (!common_my_float_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_float member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_float = "my_float";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_float;
            ann_custom_PrimitivesStruct.reset();
            CompleteMemberDetail detail_my_float = TypeObjectUtils::build_complete_member_detail(name_my_float, member_ann_builtin_my_float, ann_custom_PrimitivesStruct);
            CompleteStructMember member_my_float = TypeObjectUtils::build_complete_struct_member(common_my_float, detail_my_float);
            TypeObjectUtils::add_complete_struct_member(member_seq_PrimitivesStruct, member_my_float);
        }
        {
            TypeIdentifierPair type_ids_my_double;
            ReturnCode_t return_code_my_double {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_double =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_double", type_ids_my_double);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_double)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_double Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_double = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_double = 0x0000000d;
            bool common_my_double_ec {false};
            CommonStructMember common_my_double {TypeObjectUtils::build_common_struct_member(member_id_my_double, member_flags_my_double, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_double, common_my_double_ec))};
            if (!common_my_double_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_double member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_double = "my_double";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_double;
            ann_custom_PrimitivesStruct.reset();
            CompleteMemberDetail detail_my_double = TypeObjectUtils::build_complete_member_detail(name_my_double, member_ann_builtin_my_double, ann_custom_PrimitivesStruct);
            CompleteStructMember member_my_double = TypeObjectUtils::build_complete_struct_member(common_my_double, detail_my_double);
            TypeObjectUtils::add_complete_struct_member(member_seq_PrimitivesStruct, member_my_double);
        }
        {
            TypeIdentifierPair type_ids_my_longdouble;
            ReturnCode_t return_code_my_longdouble {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_longdouble =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_longdouble", type_ids_my_longdouble);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_longdouble)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_longdouble Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_longdouble = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_longdouble = 0x0000000e;
            bool common_my_longdouble_ec {false};
            CommonStructMember common_my_longdouble {TypeObjectUtils::build_common_struct_member(member_id_my_longdouble, member_flags_my_longdouble, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_longdouble, common_my_longdouble_ec))};
            if (!common_my_longdouble_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_longdouble member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_longdouble = "my_longdouble";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_longdouble;
            ann_custom_PrimitivesStruct.reset();
            CompleteMemberDetail detail_my_longdouble = TypeObjectUtils::build_complete_member_detail(name_my_longdouble, member_ann_builtin_my_longdouble, ann_custom_PrimitivesStruct);
            CompleteStructMember member_my_longdouble = TypeObjectUtils::build_complete_struct_member(common_my_longdouble, detail_my_longdouble);
            TypeObjectUtils::add_complete_struct_member(member_seq_PrimitivesStruct, member_my_longdouble);
        }
        CompleteStructType struct_type_PrimitivesStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_PrimitivesStruct, header_PrimitivesStruct, member_seq_PrimitivesStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_PrimitivesStruct, type_name_PrimitivesStruct.to_string(), type_ids_PrimitivesStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "PrimitivesStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
void register_MyEnum_type_identifier(
        TypeIdentifierPair& type_ids_MyEnum)
{
    ReturnCode_t return_code_MyEnum {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MyEnum =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MyEnum", type_ids_MyEnum);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MyEnum)
    {
        EnumTypeFlag enum_flags_MyEnum = 0;
        BitBound bit_bound_MyEnum = 32;
        CommonEnumeratedHeader common_MyEnum = TypeObjectUtils::build_common_enumerated_header(bit_bound_MyEnum);
        QualifiedTypeName type_name_MyEnum = "MyEnum";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MyEnum;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MyEnum;
        CompleteTypeDetail detail_MyEnum = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MyEnum, ann_custom_MyEnum, type_name_MyEnum.to_string());
        CompleteEnumeratedHeader header_MyEnum = TypeObjectUtils::build_complete_enumerated_header(common_MyEnum, detail_MyEnum);
        CompleteEnumeratedLiteralSeq literal_seq_MyEnum;
        {
            EnumeratedLiteralFlag flags_A = TypeObjectUtils::build_enumerated_literal_flag(false);
            CommonEnumeratedLiteral common_A = TypeObjectUtils::build_common_enumerated_literal(0, flags_A);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_A;
            ann_custom_MyEnum.reset();
            MemberName name_A = "A";
            CompleteMemberDetail detail_A = TypeObjectUtils::build_complete_member_detail(name_A, member_ann_builtin_A, ann_custom_MyEnum);
            CompleteEnumeratedLiteral literal_A = TypeObjectUtils::build_complete_enumerated_literal(common_A, detail_A);
            TypeObjectUtils::add_complete_enumerated_literal(literal_seq_MyEnum, literal_A);
        }
        {
            EnumeratedLiteralFlag flags_B = TypeObjectUtils::build_enumerated_literal_flag(false);
            CommonEnumeratedLiteral common_B = TypeObjectUtils::build_common_enumerated_literal(1, flags_B);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_B;
            ann_custom_MyEnum.reset();
            MemberName name_B = "B";
            CompleteMemberDetail detail_B = TypeObjectUtils::build_complete_member_detail(name_B, member_ann_builtin_B, ann_custom_MyEnum);
            CompleteEnumeratedLiteral literal_B = TypeObjectUtils::build_complete_enumerated_literal(common_B, detail_B);
            TypeObjectUtils::add_complete_enumerated_literal(literal_seq_MyEnum, literal_B);
        }
        {
            EnumeratedLiteralFlag flags_C = TypeObjectUtils::build_enumerated_literal_flag(false);
            CommonEnumeratedLiteral common_C = TypeObjectUtils::build_common_enumerated_literal(2, flags_C);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_C;
            ann_custom_MyEnum.reset();
            MemberName name_C = "C";
            CompleteMemberDetail detail_C = TypeObjectUtils::build_complete_member_detail(name_C, member_ann_builtin_C, ann_custom_MyEnum);
            CompleteEnumeratedLiteral literal_C = TypeObjectUtils::build_complete_enumerated_literal(common_C, detail_C);
            TypeObjectUtils::add_complete_enumerated_literal(literal_seq_MyEnum, literal_C);
        }
        CompleteEnumeratedType enumerated_type_MyEnum = TypeObjectUtils::build_complete_enumerated_type(enum_flags_MyEnum, header_MyEnum,
                literal_seq_MyEnum);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_enumerated_type_object(enumerated_type_MyEnum, type_name_MyEnum.to_string(), type_ids_MyEnum))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "MyEnum already registered in TypeObjectRegistry for a different type.");
        }
    }
}void register_MyBitMask_type_identifier(
        TypeIdentifierPair& type_ids_MyBitMask)
{
    ReturnCode_t return_code_MyBitMask {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MyBitMask =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MyBitMask", type_ids_MyBitMask);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MyBitMask)
    {
        BitmaskTypeFlag bitmask_flags_MyBitMask = 0;
        BitBound bit_bound_MyBitMask = 28;
        CommonEnumeratedHeader common_MyBitMask = TypeObjectUtils::build_common_enumerated_header(bit_bound_MyBitMask, true);
        QualifiedTypeName type_name_MyBitMask = "MyBitMask";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MyBitMask;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MyBitMask;
        AppliedAnnotationSeq tmp_ann_custom_MyBitMask;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_MyBitMask;
        if (!tmp_ann_custom_MyBitMask.empty())
        {
            ann_custom_MyBitMask = tmp_ann_custom_MyBitMask;
        }

        CompleteTypeDetail detail_MyBitMask = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MyBitMask, ann_custom_MyBitMask, type_name_MyBitMask.to_string());
        CompleteEnumeratedHeader header_MyBitMask = TypeObjectUtils::build_complete_enumerated_header(common_MyBitMask, detail_MyBitMask, true);
        CompleteBitflagSeq flag_seq_MyBitMask;
        {
            uint16_t position_flag0 = 0;
            BitflagFlag flags_flag0 = 0;
            CommonBitflag common_flag0 = TypeObjectUtils::build_common_bitflag(position_flag0, flags_flag0);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_flag0;
            ann_custom_MyBitMask.reset();
            AppliedAnnotationSeq tmp_ann_custom_flag0;
            if (!tmp_ann_custom_flag0.empty())
            {
                ann_custom_MyBitMask = tmp_ann_custom_flag0;
            }
            MemberName name_flag0 = "flag0";
            CompleteMemberDetail detail_flag0 = TypeObjectUtils::build_complete_member_detail(name_flag0, member_ann_builtin_flag0, ann_custom_MyBitMask);
            CompleteBitflag bitflag_flag0 = TypeObjectUtils::build_complete_bitflag(common_flag0, detail_flag0);
            TypeObjectUtils::add_complete_bitflag(flag_seq_MyBitMask, bitflag_flag0);
        }
        {
            uint16_t position_flag1 = 1;
            BitflagFlag flags_flag1 = 0;
            CommonBitflag common_flag1 = TypeObjectUtils::build_common_bitflag(position_flag1, flags_flag1);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_flag1;
            ann_custom_MyBitMask.reset();
            MemberName name_flag1 = "flag1";
            CompleteMemberDetail detail_flag1 = TypeObjectUtils::build_complete_member_detail(name_flag1, member_ann_builtin_flag1, ann_custom_MyBitMask);
            CompleteBitflag bitflag_flag1 = TypeObjectUtils::build_complete_bitflag(common_flag1, detail_flag1);
            TypeObjectUtils::add_complete_bitflag(flag_seq_MyBitMask, bitflag_flag1);
        }
        {
            uint16_t position_flag2 = 2;
            BitflagFlag flags_flag2 = 0;
            CommonBitflag common_flag2 = TypeObjectUtils::build_common_bitflag(position_flag2, flags_flag2);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_flag2;
            ann_custom_MyBitMask.reset();
            MemberName name_flag2 = "flag2";
            CompleteMemberDetail detail_flag2 = TypeObjectUtils::build_complete_member_detail(name_flag2, member_ann_builtin_flag2, ann_custom_MyBitMask);
            CompleteBitflag bitflag_flag2 = TypeObjectUtils::build_complete_bitflag(common_flag2, detail_flag2);
            TypeObjectUtils::add_complete_bitflag(flag_seq_MyBitMask, bitflag_flag2);
        }
        {
            uint16_t position_flag26 = 26;
            BitflagFlag flags_flag26 = 0;
            CommonBitflag common_flag26 = TypeObjectUtils::build_common_bitflag(position_flag26, flags_flag26);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_flag26;
            ann_custom_MyBitMask.reset();
            AppliedAnnotationSeq tmp_ann_custom_flag26;
            if (!tmp_ann_custom_flag26.empty())
            {
                ann_custom_MyBitMask = tmp_ann_custom_flag26;
            }
            MemberName name_flag26 = "flag26";
            CompleteMemberDetail detail_flag26 = TypeObjectUtils::build_complete_member_detail(name_flag26, member_ann_builtin_flag26, ann_custom_MyBitMask);
            CompleteBitflag bitflag_flag26 = TypeObjectUtils::build_complete_bitflag(common_flag26, detail_flag26);
            TypeObjectUtils::add_complete_bitflag(flag_seq_MyBitMask, bitflag_flag26);
        }
        CompleteBitmaskType bitmask_type_MyBitMask = TypeObjectUtils::build_complete_bitmask_type(bitmask_flags_MyBitMask, header_MyBitMask, flag_seq_MyBitMask);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_bitmask_type_object(bitmask_type_MyBitMask,
                    type_name_MyBitMask.to_string(), type_ids_MyBitMask))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "MyBitMask already registered in TypeObjectRegistry for a different type.");
        }
    }
}void register_MyAliasedStruct_type_identifier(
        TypeIdentifierPair& type_ids_MyAliasedStruct)
{
    ReturnCode_t return_code_MyAliasedStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MyAliasedStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MyAliasedStruct", type_ids_MyAliasedStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MyAliasedStruct)
    {
        AliasTypeFlag alias_flags_MyAliasedStruct = 0;
        QualifiedTypeName type_name_MyAliasedStruct = "MyAliasedStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MyAliasedStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MyAliasedStruct;
        CompleteTypeDetail detail_MyAliasedStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MyAliasedStruct, ann_custom_MyAliasedStruct, type_name_MyAliasedStruct.to_string());
        CompleteAliasHeader header_MyAliasedStruct = TypeObjectUtils::build_complete_alias_header(detail_MyAliasedStruct);
        AliasMemberFlag related_flags_MyAliasedStruct = 0;
        return_code_MyAliasedStruct =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "PrimitivesStruct", type_ids_MyAliasedStruct);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_MyAliasedStruct)
        {
        ::register_PrimitivesStruct_type_identifier(type_ids_MyAliasedStruct);
        }
        bool common_MyAliasedStruct_ec {false};
        CommonAliasBody common_MyAliasedStruct {TypeObjectUtils::build_common_alias_body(related_flags_MyAliasedStruct,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_MyAliasedStruct, common_MyAliasedStruct_ec))};
        if (!common_MyAliasedStruct_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "MyAliasedStruct related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_MyAliasedStruct;
        ann_custom_MyAliasedStruct.reset();
        CompleteAliasBody body_MyAliasedStruct = TypeObjectUtils::build_complete_alias_body(common_MyAliasedStruct,
                member_ann_builtin_MyAliasedStruct, ann_custom_MyAliasedStruct);
        CompleteAliasType alias_type_MyAliasedStruct = TypeObjectUtils::build_complete_alias_type(alias_flags_MyAliasedStruct,
                header_MyAliasedStruct, body_MyAliasedStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_MyAliasedStruct,
                    type_name_MyAliasedStruct.to_string(), type_ids_MyAliasedStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "MyAliasedStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}

void register_MyAliasedEnum_type_identifier(
        TypeIdentifierPair& type_ids_MyAliasedEnum)
{
    ReturnCode_t return_code_MyAliasedEnum {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MyAliasedEnum =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MyAliasedEnum", type_ids_MyAliasedEnum);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MyAliasedEnum)
    {
        AliasTypeFlag alias_flags_MyAliasedEnum = 0;
        QualifiedTypeName type_name_MyAliasedEnum = "MyAliasedEnum";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MyAliasedEnum;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MyAliasedEnum;
        CompleteTypeDetail detail_MyAliasedEnum = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MyAliasedEnum, ann_custom_MyAliasedEnum, type_name_MyAliasedEnum.to_string());
        CompleteAliasHeader header_MyAliasedEnum = TypeObjectUtils::build_complete_alias_header(detail_MyAliasedEnum);
        AliasMemberFlag related_flags_MyAliasedEnum = 0;
        return_code_MyAliasedEnum =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "MyEnum", type_ids_MyAliasedEnum);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_MyAliasedEnum)
        {
        ::register_MyEnum_type_identifier(type_ids_MyAliasedEnum);
        }
        bool common_MyAliasedEnum_ec {false};
        CommonAliasBody common_MyAliasedEnum {TypeObjectUtils::build_common_alias_body(related_flags_MyAliasedEnum,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_MyAliasedEnum, common_MyAliasedEnum_ec))};
        if (!common_MyAliasedEnum_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "MyAliasedEnum related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_MyAliasedEnum;
        ann_custom_MyAliasedEnum.reset();
        CompleteAliasBody body_MyAliasedEnum = TypeObjectUtils::build_complete_alias_body(common_MyAliasedEnum,
                member_ann_builtin_MyAliasedEnum, ann_custom_MyAliasedEnum);
        CompleteAliasType alias_type_MyAliasedEnum = TypeObjectUtils::build_complete_alias_type(alias_flags_MyAliasedEnum,
                header_MyAliasedEnum, body_MyAliasedEnum);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_MyAliasedEnum,
                    type_name_MyAliasedEnum.to_string(), type_ids_MyAliasedEnum))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "MyAliasedEnum already registered in TypeObjectRegistry for a different type.");
        }
    }
}

void register_MyAliasedBoundedString_type_identifier(
        TypeIdentifierPair& type_ids_MyAliasedBoundedString)
{
    ReturnCode_t return_code_MyAliasedBoundedString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MyAliasedBoundedString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MyAliasedBoundedString", type_ids_MyAliasedBoundedString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MyAliasedBoundedString)
    {
        AliasTypeFlag alias_flags_MyAliasedBoundedString = 0;
        QualifiedTypeName type_name_MyAliasedBoundedString = "MyAliasedBoundedString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MyAliasedBoundedString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MyAliasedBoundedString;
        CompleteTypeDetail detail_MyAliasedBoundedString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MyAliasedBoundedString, ann_custom_MyAliasedBoundedString, type_name_MyAliasedBoundedString.to_string());
        CompleteAliasHeader header_MyAliasedBoundedString = TypeObjectUtils::build_complete_alias_header(detail_MyAliasedBoundedString);
        AliasMemberFlag related_flags_MyAliasedBoundedString = 0;
        return_code_MyAliasedBoundedString =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "anonymous_string_100", type_ids_MyAliasedBoundedString);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_MyAliasedBoundedString)
        {
            {
                SBound bound = static_cast<SBound>(100);
                StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                        TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                        "anonymous_string_100", type_ids_MyAliasedBoundedString))
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_string_100 already registered in TypeObjectRegistry for a different type.");
                }
            }
        }
        bool common_MyAliasedBoundedString_ec {false};
        CommonAliasBody common_MyAliasedBoundedString {TypeObjectUtils::build_common_alias_body(related_flags_MyAliasedBoundedString,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_MyAliasedBoundedString, common_MyAliasedBoundedString_ec))};
        if (!common_MyAliasedBoundedString_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "MyAliasedBoundedString related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_MyAliasedBoundedString;
        ann_custom_MyAliasedBoundedString.reset();
        CompleteAliasBody body_MyAliasedBoundedString = TypeObjectUtils::build_complete_alias_body(common_MyAliasedBoundedString,
                member_ann_builtin_MyAliasedBoundedString, ann_custom_MyAliasedBoundedString);
        CompleteAliasType alias_type_MyAliasedBoundedString = TypeObjectUtils::build_complete_alias_type(alias_flags_MyAliasedBoundedString,
                header_MyAliasedBoundedString, body_MyAliasedBoundedString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_MyAliasedBoundedString,
                    type_name_MyAliasedBoundedString.to_string(), type_ids_MyAliasedBoundedString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "MyAliasedBoundedString already registered in TypeObjectRegistry for a different type.");
        }
    }
}

void register_MyRecursiveAlias_type_identifier(
        TypeIdentifierPair& type_ids_MyRecursiveAlias)
{
    ReturnCode_t return_code_MyRecursiveAlias {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MyRecursiveAlias =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MyRecursiveAlias", type_ids_MyRecursiveAlias);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MyRecursiveAlias)
    {
        AliasTypeFlag alias_flags_MyRecursiveAlias = 0;
        QualifiedTypeName type_name_MyRecursiveAlias = "MyRecursiveAlias";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MyRecursiveAlias;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MyRecursiveAlias;
        CompleteTypeDetail detail_MyRecursiveAlias = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MyRecursiveAlias, ann_custom_MyRecursiveAlias, type_name_MyRecursiveAlias.to_string());
        CompleteAliasHeader header_MyRecursiveAlias = TypeObjectUtils::build_complete_alias_header(detail_MyRecursiveAlias);
        AliasMemberFlag related_flags_MyRecursiveAlias = 0;
        return_code_MyRecursiveAlias =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "MyAliasedEnum", type_ids_MyRecursiveAlias);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_MyRecursiveAlias)
        {
        ::register_MyAliasedEnum_type_identifier(type_ids_MyRecursiveAlias);
        }
        bool common_MyRecursiveAlias_ec {false};
        CommonAliasBody common_MyRecursiveAlias {TypeObjectUtils::build_common_alias_body(related_flags_MyRecursiveAlias,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_MyRecursiveAlias, common_MyRecursiveAlias_ec))};
        if (!common_MyRecursiveAlias_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "MyRecursiveAlias related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_MyRecursiveAlias;
        ann_custom_MyRecursiveAlias.reset();
        CompleteAliasBody body_MyRecursiveAlias = TypeObjectUtils::build_complete_alias_body(common_MyRecursiveAlias,
                member_ann_builtin_MyRecursiveAlias, ann_custom_MyRecursiveAlias);
        CompleteAliasType alias_type_MyRecursiveAlias = TypeObjectUtils::build_complete_alias_type(alias_flags_MyRecursiveAlias,
                header_MyRecursiveAlias, body_MyRecursiveAlias);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_MyRecursiveAlias,
                    type_name_MyRecursiveAlias.to_string(), type_ids_MyRecursiveAlias))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "MyRecursiveAlias already registered in TypeObjectRegistry for a different type.");
        }
    }
}

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_InnerUnion_type_identifier(
        TypeIdentifierPair& type_ids_InnerUnion)
{
    ReturnCode_t return_code_InnerUnion {eprosima::fastdds::dds::RETCODE_OK};
    return_code_InnerUnion =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "InnerUnion", type_ids_InnerUnion);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_InnerUnion)
    {
        UnionTypeFlag union_flags_InnerUnion = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_InnerUnion = "InnerUnion";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_InnerUnion;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_InnerUnion;
        CompleteTypeDetail detail_InnerUnion = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_InnerUnion, ann_custom_InnerUnion, type_name_InnerUnion.to_string());
        CompleteUnionHeader header_InnerUnion = TypeObjectUtils::build_complete_union_header(detail_InnerUnion);
        UnionDiscriminatorFlag member_flags_InnerUnion = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_InnerUnion =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int16_t", type_ids_InnerUnion);

        if (return_code_InnerUnion != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_InnerUnion;
        if (EK_COMPLETE == type_ids_InnerUnion.type_identifier1()._d() || TK_NONE == type_ids_InnerUnion.type_identifier2()._d())
        {
            common_InnerUnion = TypeObjectUtils::build_common_discriminator_member(member_flags_InnerUnion, type_ids_InnerUnion.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_InnerUnion.type_identifier2()._d())
        {
            common_InnerUnion = TypeObjectUtils::build_common_discriminator_member(member_flags_InnerUnion, type_ids_InnerUnion.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "InnerUnion discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_InnerUnion.reset();
        ann_custom_InnerUnion.reset();
        CompleteDiscriminatorMember discriminator_InnerUnion = TypeObjectUtils::build_complete_discriminator_member(common_InnerUnion,
                type_ann_builtin_InnerUnion, ann_custom_InnerUnion);
        CompleteUnionMemberSeq member_seq_InnerUnion;
        {
            return_code_InnerUnion =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "PrimitivesStruct", type_ids_InnerUnion);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_InnerUnion)
            {
            ::register_PrimitivesStruct_type_identifier(type_ids_InnerUnion);
            }
            UnionMemberFlag member_flags_first = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_first;
            TypeObjectUtils::add_union_case_label(label_seq_first, static_cast<int32_t>(0));
            MemberId member_id_first = 0x00000010;
            bool common_first_ec {false};
            CommonUnionMember common_first {TypeObjectUtils::build_common_union_member(member_id_first,
                    member_flags_first, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_InnerUnion,
                        common_first_ec), label_seq_first)};
            if (!common_first_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union first member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_first = "first";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_first;
            ann_custom_InnerUnion.reset();
            AppliedAnnotationSeq tmp_ann_custom_first;
            eprosima::fastcdr::optional<std::string> unit_first;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_first;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_first;
            eprosima::fastcdr::optional<std::string> hash_id_first;
            if (unit_first.has_value() || min_first.has_value() || max_first.has_value() || hash_id_first.has_value())
            {
                member_ann_builtin_first = TypeObjectUtils::build_applied_builtin_member_annotations(unit_first, min_first, max_first, hash_id_first);
            }
            if (!tmp_ann_custom_first.empty())
            {
                ann_custom_InnerUnion = tmp_ann_custom_first;
            }
            CompleteMemberDetail detail_first = TypeObjectUtils::build_complete_member_detail(name_first, member_ann_builtin_first, ann_custom_InnerUnion);
            CompleteUnionMember member_first = TypeObjectUtils::build_complete_union_member(common_first, detail_first);
            TypeObjectUtils::add_complete_union_member(member_seq_InnerUnion, member_first);
        }
        {
            return_code_InnerUnion =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_InnerUnion);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_InnerUnion)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "second Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_second = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false);
            UnionCaseLabelSeq label_seq_second;
            TypeObjectUtils::add_union_case_label(label_seq_second, static_cast<int32_t>(1));
            MemberId member_id_second = 0x00000011;
            bool common_second_ec {false};
            CommonUnionMember common_second {TypeObjectUtils::build_common_union_member(member_id_second,
                    member_flags_second, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_InnerUnion,
                        common_second_ec), label_seq_second)};
            if (!common_second_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union second member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_second = "second";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_second;
            ann_custom_InnerUnion.reset();
            CompleteMemberDetail detail_second = TypeObjectUtils::build_complete_member_detail(name_second, member_ann_builtin_second, ann_custom_InnerUnion);
            CompleteUnionMember member_second = TypeObjectUtils::build_complete_union_member(common_second, detail_second);
            TypeObjectUtils::add_complete_union_member(member_seq_InnerUnion, member_second);
        }
        CompleteUnionType union_type_InnerUnion = TypeObjectUtils::build_complete_union_type(union_flags_InnerUnion, header_InnerUnion, discriminator_InnerUnion,
                member_seq_InnerUnion);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_InnerUnion, type_name_InnerUnion.to_string(), type_ids_InnerUnion))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "InnerUnion already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ComplexUnion_type_identifier(
        TypeIdentifierPair& type_ids_ComplexUnion)
{
    ReturnCode_t return_code_ComplexUnion {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ComplexUnion =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ComplexUnion", type_ids_ComplexUnion);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ComplexUnion)
    {
        UnionTypeFlag union_flags_ComplexUnion = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ComplexUnion = "ComplexUnion";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ComplexUnion;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ComplexUnion;
        CompleteTypeDetail detail_ComplexUnion = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ComplexUnion, ann_custom_ComplexUnion, type_name_ComplexUnion.to_string());
        CompleteUnionHeader header_ComplexUnion = TypeObjectUtils::build_complete_union_header(detail_ComplexUnion);
        UnionDiscriminatorFlag member_flags_ComplexUnion = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_ComplexUnion =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int16_t", type_ids_ComplexUnion);

        if (return_code_ComplexUnion != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_ComplexUnion;
        if (EK_COMPLETE == type_ids_ComplexUnion.type_identifier1()._d() || TK_NONE == type_ids_ComplexUnion.type_identifier2()._d())
        {
            common_ComplexUnion = TypeObjectUtils::build_common_discriminator_member(member_flags_ComplexUnion, type_ids_ComplexUnion.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_ComplexUnion.type_identifier2()._d())
        {
            common_ComplexUnion = TypeObjectUtils::build_common_discriminator_member(member_flags_ComplexUnion, type_ids_ComplexUnion.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ComplexUnion discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_ComplexUnion.reset();
        ann_custom_ComplexUnion.reset();
        CompleteDiscriminatorMember discriminator_ComplexUnion = TypeObjectUtils::build_complete_discriminator_member(common_ComplexUnion,
                type_ann_builtin_ComplexUnion, ann_custom_ComplexUnion);
        CompleteUnionMemberSeq member_seq_ComplexUnion;
        {
            return_code_ComplexUnion =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_ComplexUnion);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_ComplexUnion)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "third Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_third = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_third;
            TypeObjectUtils::add_union_case_label(label_seq_third, static_cast<int32_t>(0));
            TypeObjectUtils::add_union_case_label(label_seq_third, static_cast<int32_t>(1));
            MemberId member_id_third = 0x00000001;
            bool common_third_ec {false};
            CommonUnionMember common_third {TypeObjectUtils::build_common_union_member(member_id_third,
                    member_flags_third, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_ComplexUnion,
                        common_third_ec), label_seq_third)};
            if (!common_third_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union third member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_third = "third";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_third;
            ann_custom_ComplexUnion.reset();
            CompleteMemberDetail detail_third = TypeObjectUtils::build_complete_member_detail(name_third, member_ann_builtin_third, ann_custom_ComplexUnion);
            CompleteUnionMember member_third = TypeObjectUtils::build_complete_union_member(common_third, detail_third);
            TypeObjectUtils::add_complete_union_member(member_seq_ComplexUnion, member_third);
        }
        {
            return_code_ComplexUnion =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerUnion", type_ids_ComplexUnion);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_ComplexUnion)
            {
            ::register_InnerUnion_type_identifier(type_ids_ComplexUnion);
            }
            UnionMemberFlag member_flags_fourth = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false);
            UnionCaseLabelSeq label_seq_fourth;
            MemberId member_id_fourth = 0x00000002;
            bool common_fourth_ec {false};
            CommonUnionMember common_fourth {TypeObjectUtils::build_common_union_member(member_id_fourth,
                    member_flags_fourth, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_ComplexUnion,
                        common_fourth_ec), label_seq_fourth)};
            if (!common_fourth_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union fourth member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_fourth = "fourth";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_fourth;
            ann_custom_ComplexUnion.reset();
            CompleteMemberDetail detail_fourth = TypeObjectUtils::build_complete_member_detail(name_fourth, member_ann_builtin_fourth, ann_custom_ComplexUnion);
            CompleteUnionMember member_fourth = TypeObjectUtils::build_complete_union_member(common_fourth, detail_fourth);
            TypeObjectUtils::add_complete_union_member(member_seq_ComplexUnion, member_fourth);
        }
        CompleteUnionType union_type_ComplexUnion = TypeObjectUtils::build_complete_union_type(union_flags_ComplexUnion, header_ComplexUnion, discriminator_ComplexUnion,
                member_seq_ComplexUnion);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_ComplexUnion, type_name_ComplexUnion.to_string(), type_ids_ComplexUnion))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ComplexUnion already registered in TypeObjectRegistry for a different type.");
        }
    }
}
void register_MyBitSet_type_identifier(
        TypeIdentifierPair& type_ids_MyBitSet)
{
    ReturnCode_t return_code_MyBitSet {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MyBitSet =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MyBitSet", type_ids_MyBitSet);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MyBitSet)
    {
        BitsetTypeFlag bitset_flags_MyBitSet = 0;
        QualifiedTypeName type_name_MyBitSet = "MyBitSet";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MyBitSet;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MyBitSet;
        CompleteTypeDetail detail_MyBitSet = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MyBitSet, ann_custom_MyBitSet, type_name_MyBitSet.to_string());
        CompleteBitsetHeader header_MyBitSet = TypeObjectUtils::build_complete_bitset_header(detail_MyBitSet);
        CompleteBitfieldSeq field_seq_MyBitSet;
        {
            uint16_t position_a = 0;
            BitsetMemberFlag flags_a = 0;
            uint8_t bitcount_a = 3;
            TypeKind holder_type_a = TK_UINT8;
            CommonBitfield common_a = TypeObjectUtils::build_common_bitfield(position_a, flags_a, bitcount_a, holder_type_a);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_a;
            ann_custom_MyBitSet.reset();
            MemberName name_a = "a";
            CompleteMemberDetail detail_a = TypeObjectUtils::build_complete_member_detail(name_a, member_ann_builtin_a, ann_custom_MyBitSet);
            CompleteBitfield bitfield_a = TypeObjectUtils::build_complete_bitfield(common_a, detail_a);
            TypeObjectUtils::add_complete_bitfield(field_seq_MyBitSet, bitfield_a);
        }
        {
            uint16_t position_b = 3;
            BitsetMemberFlag flags_b = 0;
            uint8_t bitcount_b = 1;
            TypeKind holder_type_b = TK_BOOLEAN;
            CommonBitfield common_b = TypeObjectUtils::build_common_bitfield(position_b, flags_b, bitcount_b, holder_type_b);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_b;
            ann_custom_MyBitSet.reset();
            MemberName name_b = "b";
            CompleteMemberDetail detail_b = TypeObjectUtils::build_complete_member_detail(name_b, member_ann_builtin_b, ann_custom_MyBitSet);
            CompleteBitfield bitfield_b = TypeObjectUtils::build_complete_bitfield(common_b, detail_b);
            TypeObjectUtils::add_complete_bitfield(field_seq_MyBitSet, bitfield_b);
        }
        {
            uint16_t position_c = 8;
            BitsetMemberFlag flags_c = 0;
            uint8_t bitcount_c = 10;
            TypeKind holder_type_c = TK_UINT16;
            CommonBitfield common_c = TypeObjectUtils::build_common_bitfield(position_c, flags_c, bitcount_c, holder_type_c);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_c;
            ann_custom_MyBitSet.reset();
            MemberName name_c = "c";
            CompleteMemberDetail detail_c = TypeObjectUtils::build_complete_member_detail(name_c, member_ann_builtin_c, ann_custom_MyBitSet);
            CompleteBitfield bitfield_c = TypeObjectUtils::build_complete_bitfield(common_c, detail_c);
            TypeObjectUtils::add_complete_bitfield(field_seq_MyBitSet, bitfield_c);
        }
        {
            uint16_t position_d = 18;
            BitsetMemberFlag flags_d = 0;
            uint8_t bitcount_d = 12;
            TypeKind holder_type_d = TK_INT16;
            CommonBitfield common_d = TypeObjectUtils::build_common_bitfield(position_d, flags_d, bitcount_d, holder_type_d);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_d;
            ann_custom_MyBitSet.reset();
            MemberName name_d = "d";
            CompleteMemberDetail detail_d = TypeObjectUtils::build_complete_member_detail(name_d, member_ann_builtin_d, ann_custom_MyBitSet);
            CompleteBitfield bitfield_d = TypeObjectUtils::build_complete_bitfield(common_d, detail_d);
            TypeObjectUtils::add_complete_bitfield(field_seq_MyBitSet, bitfield_d);
        }
        CompleteBitsetType bitset_type_MyBitSet = TypeObjectUtils::build_complete_bitset_type(bitset_flags_MyBitSet, header_MyBitSet, field_seq_MyBitSet);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_bitset_type_object(bitset_type_MyBitSet,
                    type_name_MyBitSet.to_string(), type_ids_MyBitSet))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "MyBitSet already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AllStruct_type_identifier(
        TypeIdentifierPair& type_ids_AllStruct)
{

    ReturnCode_t return_code_AllStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AllStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AllStruct", type_ids_AllStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AllStruct)
    {
        StructTypeFlag struct_flags_AllStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        return_code_AllStruct =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "PrimitivesStruct", type_ids_AllStruct);

        if (return_code_AllStruct != eprosima::fastdds::dds::RETCODE_OK)
        {
::register_PrimitivesStruct_type_identifier(type_ids_AllStruct);
        }
        QualifiedTypeName type_name_AllStruct = "AllStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AllStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AllStruct;
        CompleteTypeDetail detail_AllStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AllStruct, ann_custom_AllStruct, type_name_AllStruct.to_string());
        CompleteStructHeader header_AllStruct;
        if (EK_COMPLETE == type_ids_AllStruct.type_identifier1()._d())
        {
            header_AllStruct = TypeObjectUtils::build_complete_struct_header(type_ids_AllStruct.type_identifier1(), detail_AllStruct);
        }
        else if (EK_COMPLETE == type_ids_AllStruct.type_identifier2()._d())
        {
            header_AllStruct = TypeObjectUtils::build_complete_struct_header(type_ids_AllStruct.type_identifier2(), detail_AllStruct);
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AllStruct Structure: base_type TypeIdentifier registered in TypeObjectRegistry is inconsistent.");
            return;
        }
        CompleteStructMemberSeq member_seq_AllStruct;
        {
            TypeIdentifierPair type_ids_my_string;
            ReturnCode_t return_code_my_string {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_string =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_my_string);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_string)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_my_string))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_my_string = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_string = 0x0000000f;
            bool common_my_string_ec {false};
            CommonStructMember common_my_string {TypeObjectUtils::build_common_struct_member(member_id_my_string, member_flags_my_string, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_string, common_my_string_ec))};
            if (!common_my_string_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_string member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_string = "my_string";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_string;
            ann_custom_AllStruct.reset();
            CompleteMemberDetail detail_my_string = TypeObjectUtils::build_complete_member_detail(name_my_string, member_ann_builtin_my_string, ann_custom_AllStruct);
            CompleteStructMember member_my_string = TypeObjectUtils::build_complete_struct_member(common_my_string, detail_my_string);
            TypeObjectUtils::add_complete_struct_member(member_seq_AllStruct, member_my_string);
        }
        {
            TypeIdentifierPair type_ids_my_wstring;
            ReturnCode_t return_code_my_wstring {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_wstring =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_wstring_unbounded", type_ids_my_wstring);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_wstring)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_wstring_unbounded", type_ids_my_wstring, true))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_wstring_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_my_wstring = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_wstring = 0x00000010;
            bool common_my_wstring_ec {false};
            CommonStructMember common_my_wstring {TypeObjectUtils::build_common_struct_member(member_id_my_wstring, member_flags_my_wstring, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_wstring, common_my_wstring_ec))};
            if (!common_my_wstring_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_wstring member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_wstring = "my_wstring";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_wstring;
            ann_custom_AllStruct.reset();
            CompleteMemberDetail detail_my_wstring = TypeObjectUtils::build_complete_member_detail(name_my_wstring, member_ann_builtin_my_wstring, ann_custom_AllStruct);
            CompleteStructMember member_my_wstring = TypeObjectUtils::build_complete_struct_member(common_my_wstring, detail_my_wstring);
            TypeObjectUtils::add_complete_struct_member(member_seq_AllStruct, member_my_wstring);
        }
        {
            TypeIdentifierPair type_ids_my_bounded_string;
            ReturnCode_t return_code_my_bounded_string {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_bounded_string =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_41925", type_ids_my_bounded_string);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_bounded_string)
            {
                {
                    LBound bound = 41925;
                    StringLTypeDefn string_ldefn = TypeObjectUtils::build_string_l_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_l_string_type_identifier(string_ldefn,
                            "anonymous_string_41925", type_ids_my_bounded_string))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_41925 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_my_bounded_string = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_bounded_string = 0x00000011;
            bool common_my_bounded_string_ec {false};
            CommonStructMember common_my_bounded_string {TypeObjectUtils::build_common_struct_member(member_id_my_bounded_string, member_flags_my_bounded_string, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_bounded_string, common_my_bounded_string_ec))};
            if (!common_my_bounded_string_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_bounded_string member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_bounded_string = "my_bounded_string";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_bounded_string;
            ann_custom_AllStruct.reset();
            CompleteMemberDetail detail_my_bounded_string = TypeObjectUtils::build_complete_member_detail(name_my_bounded_string, member_ann_builtin_my_bounded_string, ann_custom_AllStruct);
            CompleteStructMember member_my_bounded_string = TypeObjectUtils::build_complete_struct_member(common_my_bounded_string, detail_my_bounded_string);
            TypeObjectUtils::add_complete_struct_member(member_seq_AllStruct, member_my_bounded_string);
        }
        {
            TypeIdentifierPair type_ids_my_bounded_wstring;
            ReturnCode_t return_code_my_bounded_wstring {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_bounded_wstring =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_wstring_20925", type_ids_my_bounded_wstring);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_bounded_wstring)
            {
                {
                    LBound bound = 20925;
                    StringLTypeDefn string_ldefn = TypeObjectUtils::build_string_l_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_l_string_type_identifier(string_ldefn,
                            "anonymous_wstring_20925", type_ids_my_bounded_wstring, true))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_wstring_20925 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_my_bounded_wstring = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_bounded_wstring = 0x00000012;
            bool common_my_bounded_wstring_ec {false};
            CommonStructMember common_my_bounded_wstring {TypeObjectUtils::build_common_struct_member(member_id_my_bounded_wstring, member_flags_my_bounded_wstring, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_bounded_wstring, common_my_bounded_wstring_ec))};
            if (!common_my_bounded_wstring_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_bounded_wstring member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_bounded_wstring = "my_bounded_wstring";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_bounded_wstring;
            ann_custom_AllStruct.reset();
            CompleteMemberDetail detail_my_bounded_wstring = TypeObjectUtils::build_complete_member_detail(name_my_bounded_wstring, member_ann_builtin_my_bounded_wstring, ann_custom_AllStruct);
            CompleteStructMember member_my_bounded_wstring = TypeObjectUtils::build_complete_struct_member(common_my_bounded_wstring, detail_my_bounded_wstring);
            TypeObjectUtils::add_complete_struct_member(member_seq_AllStruct, member_my_bounded_wstring);
        }
        {
            TypeIdentifierPair type_ids_my_enum;
            ReturnCode_t return_code_my_enum {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_enum =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "MyEnum", type_ids_my_enum);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_enum)
            {
            ::register_MyEnum_type_identifier(type_ids_my_enum);
            }
            StructMemberFlag member_flags_my_enum = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_enum = 0x00000013;
            bool common_my_enum_ec {false};
            CommonStructMember common_my_enum {TypeObjectUtils::build_common_struct_member(member_id_my_enum, member_flags_my_enum, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_enum, common_my_enum_ec))};
            if (!common_my_enum_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_enum member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_enum = "my_enum";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_enum;
            ann_custom_AllStruct.reset();
            CompleteMemberDetail detail_my_enum = TypeObjectUtils::build_complete_member_detail(name_my_enum, member_ann_builtin_my_enum, ann_custom_AllStruct);
            CompleteStructMember member_my_enum = TypeObjectUtils::build_complete_struct_member(common_my_enum, detail_my_enum);
            TypeObjectUtils::add_complete_struct_member(member_seq_AllStruct, member_my_enum);
        }
        {
            TypeIdentifierPair type_ids_my_bitmask;
            ReturnCode_t return_code_my_bitmask {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_bitmask =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "MyBitMask", type_ids_my_bitmask);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_bitmask)
            {
            ::register_MyBitMask_type_identifier(type_ids_my_bitmask);
            }
            StructMemberFlag member_flags_my_bitmask = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_bitmask = 0x00000014;
            bool common_my_bitmask_ec {false};
            CommonStructMember common_my_bitmask {TypeObjectUtils::build_common_struct_member(member_id_my_bitmask, member_flags_my_bitmask, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_bitmask, common_my_bitmask_ec))};
            if (!common_my_bitmask_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_bitmask member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_bitmask = "my_bitmask";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_bitmask;
            ann_custom_AllStruct.reset();
            CompleteMemberDetail detail_my_bitmask = TypeObjectUtils::build_complete_member_detail(name_my_bitmask, member_ann_builtin_my_bitmask, ann_custom_AllStruct);
            CompleteStructMember member_my_bitmask = TypeObjectUtils::build_complete_struct_member(common_my_bitmask, detail_my_bitmask);
            TypeObjectUtils::add_complete_struct_member(member_seq_AllStruct, member_my_bitmask);
        }
        {
            TypeIdentifierPair type_ids_my_aliased_struct;
            ReturnCode_t return_code_my_aliased_struct {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_aliased_struct =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "MyAliasedStruct", type_ids_my_aliased_struct);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_aliased_struct)
            {
            ::register_MyAliasedStruct_type_identifier(type_ids_my_aliased_struct);
            }
            StructMemberFlag member_flags_my_aliased_struct = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_aliased_struct = 0x00000015;
            bool common_my_aliased_struct_ec {false};
            CommonStructMember common_my_aliased_struct {TypeObjectUtils::build_common_struct_member(member_id_my_aliased_struct, member_flags_my_aliased_struct, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_aliased_struct, common_my_aliased_struct_ec))};
            if (!common_my_aliased_struct_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_aliased_struct member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_aliased_struct = "my_aliased_struct";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_aliased_struct;
            ann_custom_AllStruct.reset();
            CompleteMemberDetail detail_my_aliased_struct = TypeObjectUtils::build_complete_member_detail(name_my_aliased_struct, member_ann_builtin_my_aliased_struct, ann_custom_AllStruct);
            CompleteStructMember member_my_aliased_struct = TypeObjectUtils::build_complete_struct_member(common_my_aliased_struct, detail_my_aliased_struct);
            TypeObjectUtils::add_complete_struct_member(member_seq_AllStruct, member_my_aliased_struct);
        }
        {
            TypeIdentifierPair type_ids_my_aliased_enum;
            ReturnCode_t return_code_my_aliased_enum {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_aliased_enum =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "MyAliasedEnum", type_ids_my_aliased_enum);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_aliased_enum)
            {
            ::register_MyAliasedEnum_type_identifier(type_ids_my_aliased_enum);
            }
            StructMemberFlag member_flags_my_aliased_enum = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_aliased_enum = 0x00000016;
            bool common_my_aliased_enum_ec {false};
            CommonStructMember common_my_aliased_enum {TypeObjectUtils::build_common_struct_member(member_id_my_aliased_enum, member_flags_my_aliased_enum, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_aliased_enum, common_my_aliased_enum_ec))};
            if (!common_my_aliased_enum_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_aliased_enum member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_aliased_enum = "my_aliased_enum";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_aliased_enum;
            ann_custom_AllStruct.reset();
            CompleteMemberDetail detail_my_aliased_enum = TypeObjectUtils::build_complete_member_detail(name_my_aliased_enum, member_ann_builtin_my_aliased_enum, ann_custom_AllStruct);
            CompleteStructMember member_my_aliased_enum = TypeObjectUtils::build_complete_struct_member(common_my_aliased_enum, detail_my_aliased_enum);
            TypeObjectUtils::add_complete_struct_member(member_seq_AllStruct, member_my_aliased_enum);
        }
        {
            TypeIdentifierPair type_ids_my_aliased_bounded_string;
            ReturnCode_t return_code_my_aliased_bounded_string {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_aliased_bounded_string =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "MyAliasedBoundedString", type_ids_my_aliased_bounded_string);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_aliased_bounded_string)
            {
            ::register_MyAliasedBoundedString_type_identifier(type_ids_my_aliased_bounded_string);
            }
            StructMemberFlag member_flags_my_aliased_bounded_string = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_aliased_bounded_string = 0x00000017;
            bool common_my_aliased_bounded_string_ec {false};
            CommonStructMember common_my_aliased_bounded_string {TypeObjectUtils::build_common_struct_member(member_id_my_aliased_bounded_string, member_flags_my_aliased_bounded_string, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_aliased_bounded_string, common_my_aliased_bounded_string_ec))};
            if (!common_my_aliased_bounded_string_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_aliased_bounded_string member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_aliased_bounded_string = "my_aliased_bounded_string";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_aliased_bounded_string;
            ann_custom_AllStruct.reset();
            CompleteMemberDetail detail_my_aliased_bounded_string = TypeObjectUtils::build_complete_member_detail(name_my_aliased_bounded_string, member_ann_builtin_my_aliased_bounded_string, ann_custom_AllStruct);
            CompleteStructMember member_my_aliased_bounded_string = TypeObjectUtils::build_complete_struct_member(common_my_aliased_bounded_string, detail_my_aliased_bounded_string);
            TypeObjectUtils::add_complete_struct_member(member_seq_AllStruct, member_my_aliased_bounded_string);
        }
        {
            TypeIdentifierPair type_ids_my_recursive_alias;
            ReturnCode_t return_code_my_recursive_alias {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_recursive_alias =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "MyRecursiveAlias", type_ids_my_recursive_alias);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_recursive_alias)
            {
            ::register_MyRecursiveAlias_type_identifier(type_ids_my_recursive_alias);
            }
            StructMemberFlag member_flags_my_recursive_alias = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_recursive_alias = 0x00000018;
            bool common_my_recursive_alias_ec {false};
            CommonStructMember common_my_recursive_alias {TypeObjectUtils::build_common_struct_member(member_id_my_recursive_alias, member_flags_my_recursive_alias, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_recursive_alias, common_my_recursive_alias_ec))};
            if (!common_my_recursive_alias_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_recursive_alias member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_recursive_alias = "my_recursive_alias";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_recursive_alias;
            ann_custom_AllStruct.reset();
            CompleteMemberDetail detail_my_recursive_alias = TypeObjectUtils::build_complete_member_detail(name_my_recursive_alias, member_ann_builtin_my_recursive_alias, ann_custom_AllStruct);
            CompleteStructMember member_my_recursive_alias = TypeObjectUtils::build_complete_struct_member(common_my_recursive_alias, detail_my_recursive_alias);
            TypeObjectUtils::add_complete_struct_member(member_seq_AllStruct, member_my_recursive_alias);
        }
        {
            TypeIdentifierPair type_ids_bitmask_sequence;
            ReturnCode_t return_code_bitmask_sequence {eprosima::fastdds::dds::RETCODE_OK};
            return_code_bitmask_sequence =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_MyBitMask_unbounded", type_ids_bitmask_sequence);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_bitmask_sequence)
            {
                return_code_bitmask_sequence =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "MyBitMask", type_ids_bitmask_sequence);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_bitmask_sequence)
                {
                ::register_MyBitMask_type_identifier(type_ids_bitmask_sequence);
                }
                bool element_identifier_anonymous_sequence_MyBitMask_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_MyBitMask_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bitmask_sequence, element_identifier_anonymous_sequence_MyBitMask_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_MyBitMask_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_MyBitMask_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_bitmask_sequence.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_MyBitMask_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_MyBitMask_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_MyBitMask_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_MyBitMask_unbounded, element_flags_anonymous_sequence_MyBitMask_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_MyBitMask_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_MyBitMask_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_MyBitMask_unbounded", type_ids_bitmask_sequence))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_MyBitMask_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_bitmask_sequence = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_bitmask_sequence = 0x00000019;
            bool common_bitmask_sequence_ec {false};
            CommonStructMember common_bitmask_sequence {TypeObjectUtils::build_common_struct_member(member_id_bitmask_sequence, member_flags_bitmask_sequence, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bitmask_sequence, common_bitmask_sequence_ec))};
            if (!common_bitmask_sequence_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure bitmask_sequence member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_bitmask_sequence = "bitmask_sequence";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_bitmask_sequence;
            ann_custom_AllStruct.reset();
            CompleteMemberDetail detail_bitmask_sequence = TypeObjectUtils::build_complete_member_detail(name_bitmask_sequence, member_ann_builtin_bitmask_sequence, ann_custom_AllStruct);
            CompleteStructMember member_bitmask_sequence = TypeObjectUtils::build_complete_struct_member(common_bitmask_sequence, detail_bitmask_sequence);
            TypeObjectUtils::add_complete_struct_member(member_seq_AllStruct, member_bitmask_sequence);
        }
        {
            TypeIdentifierPair type_ids_enum_sequence;
            ReturnCode_t return_code_enum_sequence {eprosima::fastdds::dds::RETCODE_OK};
            return_code_enum_sequence =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_MyEnum_unbounded", type_ids_enum_sequence);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_enum_sequence)
            {
                return_code_enum_sequence =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "MyEnum", type_ids_enum_sequence);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_enum_sequence)
                {
                ::register_MyEnum_type_identifier(type_ids_enum_sequence);
                }
                bool element_identifier_anonymous_sequence_MyEnum_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_MyEnum_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_enum_sequence, element_identifier_anonymous_sequence_MyEnum_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_MyEnum_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_MyEnum_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_enum_sequence.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_MyEnum_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_MyEnum_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_MyEnum_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_MyEnum_unbounded, element_flags_anonymous_sequence_MyEnum_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_MyEnum_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_MyEnum_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_MyEnum_unbounded", type_ids_enum_sequence))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_MyEnum_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_enum_sequence = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_enum_sequence = 0x0000001a;
            bool common_enum_sequence_ec {false};
            CommonStructMember common_enum_sequence {TypeObjectUtils::build_common_struct_member(member_id_enum_sequence, member_flags_enum_sequence, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_enum_sequence, common_enum_sequence_ec))};
            if (!common_enum_sequence_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure enum_sequence member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_enum_sequence = "enum_sequence";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_enum_sequence;
            ann_custom_AllStruct.reset();
            CompleteMemberDetail detail_enum_sequence = TypeObjectUtils::build_complete_member_detail(name_enum_sequence, member_ann_builtin_enum_sequence, ann_custom_AllStruct);
            CompleteStructMember member_enum_sequence = TypeObjectUtils::build_complete_struct_member(common_enum_sequence, detail_enum_sequence);
            TypeObjectUtils::add_complete_struct_member(member_seq_AllStruct, member_enum_sequence);
        }
        {
            TypeIdentifierPair type_ids_short_sequence;
            ReturnCode_t return_code_short_sequence {eprosima::fastdds::dds::RETCODE_OK};
            return_code_short_sequence =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_int16_t_5", type_ids_short_sequence);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_short_sequence)
            {
                return_code_short_sequence =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_short_sequence);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_short_sequence)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_int16_t_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_int16_t_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_short_sequence, element_identifier_anonymous_sequence_int16_t_5_ec))};
                if (!element_identifier_anonymous_sequence_int16_t_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_int16_t_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_short_sequence.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_int16_t_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_int16_t_5 = 0;
                PlainCollectionHeader header_anonymous_sequence_int16_t_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_int16_t_5, element_flags_anonymous_sequence_int16_t_5);
                {
                    SBound bound = static_cast<SBound>(5);
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_int16_t_5, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_int16_t_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_int16_t_5", type_ids_short_sequence))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_int16_t_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_short_sequence = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_short_sequence = 0x0000001b;
            bool common_short_sequence_ec {false};
            CommonStructMember common_short_sequence {TypeObjectUtils::build_common_struct_member(member_id_short_sequence, member_flags_short_sequence, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_short_sequence, common_short_sequence_ec))};
            if (!common_short_sequence_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure short_sequence member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_short_sequence = "short_sequence";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_short_sequence;
            ann_custom_AllStruct.reset();
            CompleteMemberDetail detail_short_sequence = TypeObjectUtils::build_complete_member_detail(name_short_sequence, member_ann_builtin_short_sequence, ann_custom_AllStruct);
            CompleteStructMember member_short_sequence = TypeObjectUtils::build_complete_struct_member(common_short_sequence, detail_short_sequence);
            TypeObjectUtils::add_complete_struct_member(member_seq_AllStruct, member_short_sequence);
        }
        {
            TypeIdentifierPair type_ids_long_array;
            ReturnCode_t return_code_long_array {eprosima::fastdds::dds::RETCODE_OK};
            return_code_long_array =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int32_t_2_3_4", type_ids_long_array);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_long_array)
            {
                return_code_long_array =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_long_array);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_long_array)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int32_t_2_3_4_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int32_t_2_3_4 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_long_array, element_identifier_anonymous_array_int32_t_2_3_4_ec))};
                if (!element_identifier_anonymous_array_int32_t_2_3_4_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int32_t_2_3_4 = EK_COMPLETE;
                if (TK_NONE == type_ids_long_array.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int32_t_2_3_4 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int32_t_2_3_4 = 0;
                PlainCollectionHeader header_anonymous_array_int32_t_2_3_4 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int32_t_2_3_4, element_flags_anonymous_array_int32_t_2_3_4);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(2));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(3));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(4));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int32_t_2_3_4, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int32_t_2_3_4));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int32_t_2_3_4", type_ids_long_array))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int32_t_2_3_4 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_long_array = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_long_array = 0x0000001c;
            bool common_long_array_ec {false};
            CommonStructMember common_long_array {TypeObjectUtils::build_common_struct_member(member_id_long_array, member_flags_long_array, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_long_array, common_long_array_ec))};
            if (!common_long_array_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure long_array member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_long_array = "long_array";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_long_array;
            ann_custom_AllStruct.reset();
            CompleteMemberDetail detail_long_array = TypeObjectUtils::build_complete_member_detail(name_long_array, member_ann_builtin_long_array, ann_custom_AllStruct);
            CompleteStructMember member_long_array = TypeObjectUtils::build_complete_struct_member(common_long_array, detail_long_array);
            TypeObjectUtils::add_complete_struct_member(member_seq_AllStruct, member_long_array);
        }
        {
            TypeIdentifierPair type_ids_string_unbounded_map;
            ReturnCode_t return_code_string_unbounded_map {eprosima::fastdds::dds::RETCODE_OK};
            return_code_string_unbounded_map =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded", type_ids_string_unbounded_map);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_string_unbounded_map)
            {
                return_code_string_unbounded_map =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_string_unbounded", type_ids_string_unbounded_map);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_string_unbounded_map)
                {
                    {
                        SBound bound = 0;
                        StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                                "anonymous_string_unbounded", type_ids_string_unbounded_map))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_string_unbounded_map, element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded_ec))};
                if (!element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_string_unbounded_map =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_string_unbounded", type_ids_string_unbounded_map);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_string_unbounded_map)
                {
                    {
                        SBound bound = 0;
                        StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                                "anonymous_string_unbounded", type_ids_string_unbounded_map))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool key_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_string_unbounded_map, key_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded_ec))};
                if (!key_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded, element_flags_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded), key_flags_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded", type_ids_string_unbounded_map))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_anonymous_string_unbounded_anonymous_string_unbounded_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_string_unbounded_map = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_string_unbounded_map = 0x0000001d;
            bool common_string_unbounded_map_ec {false};
            CommonStructMember common_string_unbounded_map {TypeObjectUtils::build_common_struct_member(member_id_string_unbounded_map, member_flags_string_unbounded_map, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_string_unbounded_map, common_string_unbounded_map_ec))};
            if (!common_string_unbounded_map_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure string_unbounded_map member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_string_unbounded_map = "string_unbounded_map";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_string_unbounded_map;
            ann_custom_AllStruct.reset();
            CompleteMemberDetail detail_string_unbounded_map = TypeObjectUtils::build_complete_member_detail(name_string_unbounded_map, member_ann_builtin_string_unbounded_map, ann_custom_AllStruct);
            CompleteStructMember member_string_unbounded_map = TypeObjectUtils::build_complete_struct_member(common_string_unbounded_map, detail_string_unbounded_map);
            TypeObjectUtils::add_complete_struct_member(member_seq_AllStruct, member_string_unbounded_map);
        }
        {
            TypeIdentifierPair type_ids_string_alias_unbounded_map;
            ReturnCode_t return_code_string_alias_unbounded_map {eprosima::fastdds::dds::RETCODE_OK};
            return_code_string_alias_unbounded_map =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded", type_ids_string_alias_unbounded_map);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_string_alias_unbounded_map)
            {
                return_code_string_alias_unbounded_map =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "MyAliasedBoundedString", type_ids_string_alias_unbounded_map);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_string_alias_unbounded_map)
                {
                ::register_MyAliasedBoundedString_type_identifier(type_ids_string_alias_unbounded_map);
                }
                bool element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_string_alias_unbounded_map, element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded_ec))};
                if (!element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_string_alias_unbounded_map =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_string_unbounded", type_ids_string_alias_unbounded_map);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_string_alias_unbounded_map)
                {
                    {
                        SBound bound = 0;
                        StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                                "anonymous_string_unbounded", type_ids_string_alias_unbounded_map))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool key_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_string_alias_unbounded_map, key_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded_ec))};
                if (!key_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded, element_flags_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded), key_flags_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded", type_ids_string_alias_unbounded_map))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_anonymous_string_unbounded_anonymous_string_100_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_string_alias_unbounded_map = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_string_alias_unbounded_map = 0x0000001e;
            bool common_string_alias_unbounded_map_ec {false};
            CommonStructMember common_string_alias_unbounded_map {TypeObjectUtils::build_common_struct_member(member_id_string_alias_unbounded_map, member_flags_string_alias_unbounded_map, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_string_alias_unbounded_map, common_string_alias_unbounded_map_ec))};
            if (!common_string_alias_unbounded_map_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure string_alias_unbounded_map member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_string_alias_unbounded_map = "string_alias_unbounded_map";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_string_alias_unbounded_map;
            ann_custom_AllStruct.reset();
            CompleteMemberDetail detail_string_alias_unbounded_map = TypeObjectUtils::build_complete_member_detail(name_string_alias_unbounded_map, member_ann_builtin_string_alias_unbounded_map, ann_custom_AllStruct);
            CompleteStructMember member_string_alias_unbounded_map = TypeObjectUtils::build_complete_struct_member(common_string_alias_unbounded_map, detail_string_alias_unbounded_map);
            TypeObjectUtils::add_complete_struct_member(member_seq_AllStruct, member_string_alias_unbounded_map);
        }
        {
            TypeIdentifierPair type_ids_short_long_map;
            ReturnCode_t return_code_short_long_map {eprosima::fastdds::dds::RETCODE_OK};
            return_code_short_long_map =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int16_t_int32_t_2", type_ids_short_long_map);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_short_long_map)
            {
                return_code_short_long_map =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_short_long_map);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_short_long_map)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int16_t_int32_t_2_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int16_t_int32_t_2 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_short_long_map, element_identifier_anonymous_map_int16_t_int32_t_2_ec))};
                if (!element_identifier_anonymous_map_int16_t_int32_t_2_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_int32_t_2 inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_short_long_map =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_short_long_map);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_short_long_map)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int16_t_int32_t_2_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int16_t_int32_t_2 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_short_long_map, key_identifier_anonymous_map_int16_t_int32_t_2_ec))};
                if (!key_identifier_anonymous_map_int16_t_int32_t_2_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_int32_t_2 inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int16_t_int32_t_2 = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int16_t_int32_t_2->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_int32_t_2->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int16_t_int32_t_2->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_int32_t_2->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int16_t_int32_t_2->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_int32_t_2->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int16_t_int32_t_2->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_int32_t_2->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int16_t_int32_t_2->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_int32_t_2->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int16_t_int32_t_2->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_int32_t_2->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_int32_t_2->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int16_t_int32_t_2->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_int32_t_2->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_int32_t_2->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int16_t_int32_t_2 = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int16_t_int32_t_2 = 0;
                CollectionElementFlag key_flags_anonymous_map_int16_t_int32_t_2 = 0;
                PlainCollectionHeader header_anonymous_map_int16_t_int32_t_2 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int16_t_int32_t_2, element_flags_anonymous_map_int16_t_int32_t_2);
                {
                    SBound bound = static_cast<SBound>(2);
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int16_t_int32_t_2, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int16_t_int32_t_2), key_flags_anonymous_map_int16_t_int32_t_2,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int16_t_int32_t_2));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int16_t_int32_t_2", type_ids_short_long_map))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int16_t_int32_t_2 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_short_long_map = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_short_long_map = 0x0000001f;
            bool common_short_long_map_ec {false};
            CommonStructMember common_short_long_map {TypeObjectUtils::build_common_struct_member(member_id_short_long_map, member_flags_short_long_map, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_short_long_map, common_short_long_map_ec))};
            if (!common_short_long_map_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure short_long_map member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_short_long_map = "short_long_map";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_short_long_map;
            ann_custom_AllStruct.reset();
            CompleteMemberDetail detail_short_long_map = TypeObjectUtils::build_complete_member_detail(name_short_long_map, member_ann_builtin_short_long_map, ann_custom_AllStruct);
            CompleteStructMember member_short_long_map = TypeObjectUtils::build_complete_struct_member(common_short_long_map, detail_short_long_map);
            TypeObjectUtils::add_complete_struct_member(member_seq_AllStruct, member_short_long_map);
        }
        {
            TypeIdentifierPair type_ids_inner_union;
            ReturnCode_t return_code_inner_union {eprosima::fastdds::dds::RETCODE_OK};
            return_code_inner_union =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerUnion", type_ids_inner_union);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_inner_union)
            {
            ::register_InnerUnion_type_identifier(type_ids_inner_union);
            }
            StructMemberFlag member_flags_inner_union = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_inner_union = 0x00000020;
            bool common_inner_union_ec {false};
            CommonStructMember common_inner_union {TypeObjectUtils::build_common_struct_member(member_id_inner_union, member_flags_inner_union, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_inner_union, common_inner_union_ec))};
            if (!common_inner_union_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure inner_union member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_inner_union = "inner_union";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_inner_union;
            ann_custom_AllStruct.reset();
            CompleteMemberDetail detail_inner_union = TypeObjectUtils::build_complete_member_detail(name_inner_union, member_ann_builtin_inner_union, ann_custom_AllStruct);
            CompleteStructMember member_inner_union = TypeObjectUtils::build_complete_struct_member(common_inner_union, detail_inner_union);
            TypeObjectUtils::add_complete_struct_member(member_seq_AllStruct, member_inner_union);
        }
        {
            TypeIdentifierPair type_ids_complex_union;
            ReturnCode_t return_code_complex_union {eprosima::fastdds::dds::RETCODE_OK};
            return_code_complex_union =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "ComplexUnion", type_ids_complex_union);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_complex_union)
            {
            ::register_ComplexUnion_type_identifier(type_ids_complex_union);
            }
            StructMemberFlag member_flags_complex_union = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_complex_union = 0x00000021;
            bool common_complex_union_ec {false};
            CommonStructMember common_complex_union {TypeObjectUtils::build_common_struct_member(member_id_complex_union, member_flags_complex_union, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_complex_union, common_complex_union_ec))};
            if (!common_complex_union_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure complex_union member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_complex_union = "complex_union";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_complex_union;
            ann_custom_AllStruct.reset();
            CompleteMemberDetail detail_complex_union = TypeObjectUtils::build_complete_member_detail(name_complex_union, member_ann_builtin_complex_union, ann_custom_AllStruct);
            CompleteStructMember member_complex_union = TypeObjectUtils::build_complete_struct_member(common_complex_union, detail_complex_union);
            TypeObjectUtils::add_complete_struct_member(member_seq_AllStruct, member_complex_union);
        }
        {
            TypeIdentifierPair type_ids_my_bitset;
            ReturnCode_t return_code_my_bitset {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_bitset =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "MyBitSet", type_ids_my_bitset);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_bitset)
            {
            ::register_MyBitSet_type_identifier(type_ids_my_bitset);
            }
            StructMemberFlag member_flags_my_bitset = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_bitset = 0x00000022;
            bool common_my_bitset_ec {false};
            CommonStructMember common_my_bitset {TypeObjectUtils::build_common_struct_member(member_id_my_bitset, member_flags_my_bitset, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_bitset, common_my_bitset_ec))};
            if (!common_my_bitset_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_bitset member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_bitset = "my_bitset";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_bitset;
            ann_custom_AllStruct.reset();
            CompleteMemberDetail detail_my_bitset = TypeObjectUtils::build_complete_member_detail(name_my_bitset, member_ann_builtin_my_bitset, ann_custom_AllStruct);
            CompleteStructMember member_my_bitset = TypeObjectUtils::build_complete_struct_member(common_my_bitset, detail_my_bitset);
            TypeObjectUtils::add_complete_struct_member(member_seq_AllStruct, member_my_bitset);
        }
        CompleteStructType struct_type_AllStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_AllStruct, header_AllStruct, member_seq_AllStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AllStruct, type_name_AllStruct.to_string(), type_ids_AllStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AllStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ComprehensiveType_type_identifier(
        TypeIdentifierPair& type_ids_ComprehensiveType)
{

    ReturnCode_t return_code_ComprehensiveType {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ComprehensiveType =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ComprehensiveType", type_ids_ComprehensiveType);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ComprehensiveType)
    {
        StructTypeFlag struct_flags_ComprehensiveType = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ComprehensiveType = "ComprehensiveType";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ComprehensiveType;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ComprehensiveType;
        CompleteTypeDetail detail_ComprehensiveType = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ComprehensiveType, ann_custom_ComprehensiveType, type_name_ComprehensiveType.to_string());
        CompleteStructHeader header_ComprehensiveType;
        header_ComprehensiveType = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ComprehensiveType);
        CompleteStructMemberSeq member_seq_ComprehensiveType;
        {
            TypeIdentifierPair type_ids_index;
            ReturnCode_t return_code_index {eprosima::fastdds::dds::RETCODE_OK};
            return_code_index =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_index);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_index)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "index Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_index = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_index = 0x00000000;
            bool common_index_ec {false};
            CommonStructMember common_index {TypeObjectUtils::build_common_struct_member(member_id_index, member_flags_index, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_index, common_index_ec))};
            if (!common_index_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure index member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_index = "index";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_index;
            ann_custom_ComprehensiveType.reset();
            CompleteMemberDetail detail_index = TypeObjectUtils::build_complete_member_detail(name_index, member_ann_builtin_index, ann_custom_ComprehensiveType);
            CompleteStructMember member_index = TypeObjectUtils::build_complete_struct_member(common_index, detail_index);
            TypeObjectUtils::add_complete_struct_member(member_seq_ComprehensiveType, member_index);
        }
        {
            TypeIdentifierPair type_ids_inner_struct;
            ReturnCode_t return_code_inner_struct {eprosima::fastdds::dds::RETCODE_OK};
            return_code_inner_struct =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "AllStruct", type_ids_inner_struct);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_inner_struct)
            {
            ::register_AllStruct_type_identifier(type_ids_inner_struct);
            }
            StructMemberFlag member_flags_inner_struct = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_inner_struct = 0x00000001;
            bool common_inner_struct_ec {false};
            CommonStructMember common_inner_struct {TypeObjectUtils::build_common_struct_member(member_id_inner_struct, member_flags_inner_struct, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_inner_struct, common_inner_struct_ec))};
            if (!common_inner_struct_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure inner_struct member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_inner_struct = "inner_struct";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_inner_struct;
            ann_custom_ComprehensiveType.reset();
            CompleteMemberDetail detail_inner_struct = TypeObjectUtils::build_complete_member_detail(name_inner_struct, member_ann_builtin_inner_struct, ann_custom_ComprehensiveType);
            CompleteStructMember member_inner_struct = TypeObjectUtils::build_complete_struct_member(common_inner_struct, detail_inner_struct);
            TypeObjectUtils::add_complete_struct_member(member_seq_ComprehensiveType, member_inner_struct);
        }
        {
            TypeIdentifierPair type_ids_complex_sequence;
            ReturnCode_t return_code_complex_sequence {eprosima::fastdds::dds::RETCODE_OK};
            return_code_complex_sequence =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_AllStruct_unbounded", type_ids_complex_sequence);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_complex_sequence)
            {
                return_code_complex_sequence =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "AllStruct", type_ids_complex_sequence);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_complex_sequence)
                {
                ::register_AllStruct_type_identifier(type_ids_complex_sequence);
                }
                bool element_identifier_anonymous_sequence_AllStruct_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_AllStruct_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_complex_sequence, element_identifier_anonymous_sequence_AllStruct_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_AllStruct_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_AllStruct_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_complex_sequence.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_AllStruct_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_AllStruct_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_AllStruct_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_AllStruct_unbounded, element_flags_anonymous_sequence_AllStruct_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_AllStruct_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_AllStruct_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_AllStruct_unbounded", type_ids_complex_sequence))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_AllStruct_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_complex_sequence = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_complex_sequence = 0x00000002;
            bool common_complex_sequence_ec {false};
            CommonStructMember common_complex_sequence {TypeObjectUtils::build_common_struct_member(member_id_complex_sequence, member_flags_complex_sequence, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_complex_sequence, common_complex_sequence_ec))};
            if (!common_complex_sequence_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure complex_sequence member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_complex_sequence = "complex_sequence";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_complex_sequence;
            ann_custom_ComprehensiveType.reset();
            CompleteMemberDetail detail_complex_sequence = TypeObjectUtils::build_complete_member_detail(name_complex_sequence, member_ann_builtin_complex_sequence, ann_custom_ComprehensiveType);
            CompleteStructMember member_complex_sequence = TypeObjectUtils::build_complete_struct_member(common_complex_sequence, detail_complex_sequence);
            TypeObjectUtils::add_complete_struct_member(member_seq_ComprehensiveType, member_complex_sequence);
        }
        {
            TypeIdentifierPair type_ids_complex_array;
            ReturnCode_t return_code_complex_array {eprosima::fastdds::dds::RETCODE_OK};
            return_code_complex_array =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_AllStruct_2", type_ids_complex_array);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_complex_array)
            {
                return_code_complex_array =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "AllStruct", type_ids_complex_array);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_complex_array)
                {
                ::register_AllStruct_type_identifier(type_ids_complex_array);
                }
                bool element_identifier_anonymous_array_AllStruct_2_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_AllStruct_2 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_complex_array, element_identifier_anonymous_array_AllStruct_2_ec))};
                if (!element_identifier_anonymous_array_AllStruct_2_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_AllStruct_2 = EK_COMPLETE;
                if (TK_NONE == type_ids_complex_array.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_AllStruct_2 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_AllStruct_2 = 0;
                PlainCollectionHeader header_anonymous_array_AllStruct_2 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_AllStruct_2, element_flags_anonymous_array_AllStruct_2);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(2));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_AllStruct_2, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_AllStruct_2));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_AllStruct_2", type_ids_complex_array))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_AllStruct_2 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_complex_array = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_complex_array = 0x00000003;
            bool common_complex_array_ec {false};
            CommonStructMember common_complex_array {TypeObjectUtils::build_common_struct_member(member_id_complex_array, member_flags_complex_array, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_complex_array, common_complex_array_ec))};
            if (!common_complex_array_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure complex_array member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_complex_array = "complex_array";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_complex_array;
            ann_custom_ComprehensiveType.reset();
            CompleteMemberDetail detail_complex_array = TypeObjectUtils::build_complete_member_detail(name_complex_array, member_ann_builtin_complex_array, ann_custom_ComprehensiveType);
            CompleteStructMember member_complex_array = TypeObjectUtils::build_complete_struct_member(common_complex_array, detail_complex_array);
            TypeObjectUtils::add_complete_struct_member(member_seq_ComprehensiveType, member_complex_array);
        }
        {
            TypeIdentifierPair type_ids_complex_map;
            ReturnCode_t return_code_complex_map {eprosima::fastdds::dds::RETCODE_OK};
            return_code_complex_map =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int16_t_AllStruct_unbounded", type_ids_complex_map);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_complex_map)
            {
                return_code_complex_map =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "AllStruct", type_ids_complex_map);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_complex_map)
                {
                ::register_AllStruct_type_identifier(type_ids_complex_map);
                }
                bool element_identifier_anonymous_map_int16_t_AllStruct_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int16_t_AllStruct_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_complex_map, element_identifier_anonymous_map_int16_t_AllStruct_unbounded_ec))};
                if (!element_identifier_anonymous_map_int16_t_AllStruct_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_AllStruct_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_complex_map =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_complex_map);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_complex_map)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int16_t_AllStruct_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int16_t_AllStruct_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_complex_map, key_identifier_anonymous_map_int16_t_AllStruct_unbounded_ec))};
                if (!key_identifier_anonymous_map_int16_t_AllStruct_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_AllStruct_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int16_t_AllStruct_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int16_t_AllStruct_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_AllStruct_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int16_t_AllStruct_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_AllStruct_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int16_t_AllStruct_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_AllStruct_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int16_t_AllStruct_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_AllStruct_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int16_t_AllStruct_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_AllStruct_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int16_t_AllStruct_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_AllStruct_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_AllStruct_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int16_t_AllStruct_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_AllStruct_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_AllStruct_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int16_t_AllStruct_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int16_t_AllStruct_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int16_t_AllStruct_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int16_t_AllStruct_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int16_t_AllStruct_unbounded, element_flags_anonymous_map_int16_t_AllStruct_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int16_t_AllStruct_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int16_t_AllStruct_unbounded), key_flags_anonymous_map_int16_t_AllStruct_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int16_t_AllStruct_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int16_t_AllStruct_unbounded", type_ids_complex_map))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int16_t_AllStruct_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_complex_map = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_complex_map = 0x00000004;
            bool common_complex_map_ec {false};
            CommonStructMember common_complex_map {TypeObjectUtils::build_common_struct_member(member_id_complex_map, member_flags_complex_map, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_complex_map, common_complex_map_ec))};
            if (!common_complex_map_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure complex_map member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_complex_map = "complex_map";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_complex_map;
            ann_custom_ComprehensiveType.reset();
            CompleteMemberDetail detail_complex_map = TypeObjectUtils::build_complete_member_detail(name_complex_map, member_ann_builtin_complex_map, ann_custom_ComprehensiveType);
            CompleteStructMember member_complex_map = TypeObjectUtils::build_complete_struct_member(common_complex_map, detail_complex_map);
            TypeObjectUtils::add_complete_struct_member(member_seq_ComprehensiveType, member_complex_map);
        }
        CompleteStructType struct_type_ComprehensiveType = TypeObjectUtils::build_complete_struct_type(struct_flags_ComprehensiveType, header_ComprehensiveType, member_seq_ComprehensiveType);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ComprehensiveType, type_name_ComprehensiveType.to_string(), type_ids_ComprehensiveType))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ComprehensiveType already registered in TypeObjectRegistry for a different type.");
        }
    }
}

