/*
 * Decompiled with CFR 0.152.
 */
package org.adl.samplerte.client;

public class LMSErrorManager {
    private static String currentErrorCode;
    private static String[][] errors;

    static {
        errors = new String[][]{{"0", "No Error", "The previous LMS API Function call completed successfully."}, {"101", "General Exception", "An unspecified, unexpected exception has occured"}, {"201", "Invalid argument error", ""}, {"202", "Element cannot have children", ""}, {"203", "Element not an array - cannot have count", ""}, {"301", "Not initialized", "The LMS is not initialized."}, {"401", "Not implemented error", "The data model element in question was not implemented"}, {"402", "Invalid set value, element is a keyword", "Trying to set a reserved keyword in the data modelTrying to set a keyword (_count, _children, or _version) This is prohibited"}, {"403", "Element is read only", "Data Element is Read Only (Not Writeable)Cannot call LMSSetValue() for the element in question"}, {"404", "Element is write only", "Data Element is Write Only (Not Readable)Cannot call LMSGetValue() for the element in question"}, {"405", "Incorrect Data Type", "Invalid Type being used for setting elementThe type being used as the set value argument does not match that of the element being set"}};
    }

    public void LMSErrorManager() {
        currentErrorCode = "0";
    }

    public String GetCurrentErrorCode() {
        return currentErrorCode;
    }

    public void SetCurrentErrorCode(String code) {
        currentErrorCode = code != null && code != "" ? code : "0";
    }

    public void ClearCurrentErrorCode() {
        currentErrorCode = errors[0][0];
    }

    public String GetErrorDescription(String code) {
        if (code != null && code != "") {
            return this.GetErrorElement(code)[1];
        }
        return "";
    }

    public String GetErrorDiagnostic(String code) {
        if (code != null && code != "") {
            return this.GetErrorElement(code)[2];
        }
        return this.GetErrorElement(currentErrorCode)[2];
    }

    private String[] GetErrorElement(String code) {
        int i = 0;
        while (i < errors.length) {
            if (errors[i][0].equalsIgnoreCase(code)) {
                return errors[i];
            }
            ++i;
        }
        String[] tmp = new String[]{"", "", ""};
        return tmp;
    }
}

