/*

  Author:  Bob Dean
  Copyright (c) 1999, 2000


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public Licensse as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 */

#ifdef __cplusplus
extern "C"
{
#endif

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>
#include <limits.h>
#include <fcntl.h>
#include <signal.h>
#include <stdarg.h>
#include <sys/shm.h>
#include <glib.h>
#include <dbsoundcard.h>
#include <dbchannel.h>
#include <dbdebug.h>
#include <dbaudiolib.h>

#include "prototypes.h"

	extern local_channel * ch;

	extern int errno;
	extern int debug_level; /* declared in debug module */



	int DBAudio_Set_Channel_Type(enum channel_type_e type)
	{
		if (ch == NULL)  
		{
			errno = ERROR_NOT_INITIALIZED; 
			return FAILURE;
		}

		switch(type)
		{
		case PIPE_CHANNEL:
			Debug("DBAudioLib: Setting Channel type: PIPE CHANNEL");
			break;
			/* 	case SHM_CHANNEL: */
			/* 		Debug("DBAudioLib: Setting Channel type: SHM CHANNEL"); */
			break;
		default:
			errno = ERROR_BAD_CHANNELTYPE;
			return FAILURE;
		}

		ch->channel_type = type;

		return SUCCESS;
	}


	enum channel_type_e DBAudio_Get_Channel_Type()
	{
		if (ch == NULL)  
		{
			errno = ERROR_NOT_INITIALIZED; 
			return FAILURE;
		}

		return ch->channel_type;
	}



#ifdef __cplusplus
}
#endif
