DACS.QUICK(7)           DACS Miscellaneous Information           DACS.QUICK(7)



[1mNAME[0m
       dacs.quick - [1mDACS [22mQuick Start Tutorial

[1mDESCRIPTION[0m
       The purpose of [1mDACS [22mQuick Start is to explain, step-by-step, how to
       configure a very basic [1mDACS[22m-enabled web site from scratch so that you
       can try [1mDACS [22mwith minimal effort. We hope that by performing the entire
       example configuration yourself, you will gain a better understanding of
       how [1mDACS [22mworks and how to go about configuring it to meet your needs.
       By following along with some simple examples, you will create a
       completely stand-alone, single jurisdiction [1mDACS [22mfederation on one of
       your hosts. You will become familiar with some of the [1mDACS [22mutilities
       and web services. When you are done, you can simply delete a few
       directories to uninstall everything. The tutorial should take about 30
       minutes to complete the first time.

       After successfully completing Quick Start, you should understand [1mDACS[0m
       well enough that you can proceed to experiment with configuration and
       features, and perhaps use the example configuration as a starting point
       to meet your requirements.

       We do not provide much background or technical information about [1mDACS[0m
       here, or tell you how to set up a fully functional, production-quality
       [1mDACS [22msystem. You may find it worthwhile to review the [34m[1mFAQ[0m[1m[22m[1] before
       beginning, but if you're itching to get started right away you may do
       so. For technical details, please refer to the [34m[1mmanual pages[0m[1m[22m[2] and
       other documentation.

       We assume that you've got some hands-on experience configuring and
       using [1mApache[22m, although Quick Start tells you exactly what to do.  [4mTo[0m
       [4mavoid[24m [4mfrustrating[24m [4mproblems,[24m [4mwe[24m [4mrecommend[24m [4mthat[24m [4myou[24m [4mresist[24m [4mthe[24m [4mtemptation[0m
       [4mto[24m [4mstray[24m [4mfrom[24m [4mthe[24m [4minstructions[24m [4mexcept[24m [4mwhen[24m [4mindicated[24m. Experienced
       [1mApache [22madministrators may recognize the opportunity for some shortcuts,
       but since we're trying to keep things simple for a wide audience, we'd
       rather not get sidetracked by mentioning them. Likewise, experienced
       [1mDACS [22madministrators may recognize alternative ways - maybe even better
       ways - of doing things. But our goal is to get beginners started
       quickly, so we'll progress in small steps, explaining what is being
       done, and providing assurance that everything is correct so far. That
       way if you run into a problem, you should be able to isolate and fix it
       more easily.

       We'll assume that you've already obtained the [4mlatest[24m [4mversion[24m of [1mDACS[22m,
       unpacked it, and at least skimmed through [34m[1mdacs.readme(7)[0m[1m[22m[3] and
       [34m[1mdacs.install(7)[0m[1m[22m[4]. This document should have come from that version of
       [1mDACS[22m.

           [1mNote[0m
            1. You will be installing and configuring a basic [1mApache [22mserver
               ([1mhttpd[22m) as part of this tutorial. You may perform this
               installation on any supported platform, whether your desktop
               Unix host or some other host, such as a remote server. You will
               find the former somewhat easier and safer to do, so it is
               recommended when possible. If doing the installation on a
               particular host may expose the tutorial's web server to
               requests from the Internet, be sure to carefully consider the
               security implications and take appropriate precautions before
               proceeding. Nothing in the tutorial ought to make the host
               running the web server more vulnerable, but if you experiment
               with [1mDACS [22mon your own there could be unintended consequences.
               It is probably a good idea to stop [1mApache [22mwhen you are no
               longer using it.

            2. You will find it much easier to follow along if you use the
               HTML version of this document because it includes links that
               save you from having to type examples. Obviously these links
               will only work if you have configured the tutorial's
               environment. Some links from this document to other
               documentation point at the tutorial environment, so they will
               not function if that environment is not available. Also, your
               web browser must be capable of handling cookies and have that
               feature enabled.

            3. Make sure that this document came with the [1mDACS [22mrelease that
               you are working with.

            4. The Quick Start procedure has been performed successfully on
               FreeBSD and CentOS, but we expect it to work on most Unix-like
               systems. If you run into a problem, you should not proceed
               until you have fixed it.

            5. Depending on your environment, some tasks may need to be done
               as root (e.g., using [1msudo[22m). In particular, editing /etc/hosts
               and [1mDACS [22mconfiguration files, setting file ownership and
               permissions, and the [1mmake install [22mcommands are likely to need
               this. No program or web service used in the examples needs to
               run as root. Except for one or two optional [1mDACS [22mweb services,
               none of the [1mDACS [22mweb services needs to run set-uid or set-gid.

            6. Ordinarily, all [1mDACS[22m-related network communication [4mmust[24m be done
               over SSL. Setting up SSL appropriately is primarily [34m[1man Apache[0m
               [1m[34mconfiguration task[0m[1m[22m[5], requiring a server certificate; anyone
               who has done this before will likely understand what needs to
               be done after completing Quick Start. But to help keep this
               document simple and because our goal is not to create a
               production-quality [1mDACS [22minstallation, we will neither use SSL
               in the examples nor mention SSL again.

            7. It's a challenge to write instructions that will work
               everywhere, everytime, for everyone, so please accept our
               apologies for any deficiencies in this document. We are keen to
               improve it, so if you encounter any problems while trying this
               tutorial, or if you have any questions, please [34m[1mcontact us[0m[1m[22m[6].
               Our goal is to make it as easy as possible to get started with
               [1mDACS[22m.


       Quick Start Steps:

        1. Step 1: Install required third-party packages

        2. Step 2: Install and configure Apache

        3. Step 3: Build and install DACS

        4. Step 4: DACS-enable Apache

        5. Step 5: Do basic DACS configuration

        6. Step 6: Do basic Apache configuration for DACS

        7. Step 7: Test basic DACS services

        8. Step 8: Try DACS authentication

        9. Step 9: DACS-wrapping a web service

       10. Step 10: What's next?

       11. Step 11: Clean up

   [1mStep 1: Install required third-party packages[0m
       Obtain the versions of [34m[1mApache[0m[1m[22m[7], [34m[1mOpenSSL[0m[1m[22m[8], and [34m[1mExpat[0m[1m[22m[9] that are
       specified in [34m[1mdacs.install(7)[0m[1m[22m[4]. If your system already has suitable
       versions of [34m[1mOpenSSL[0m[1m[22m[8], and [34m[1mExpat[0m[1m[22m[9] installed, you may use them if you
       are comfortable deviating from these instructions; you may have to
       adjust paths that are used below, however. Detailed instructions have
       been provided for building [34m[1mOpenSSL[0m[1m[22m[10] and [34m[1mExpat[0m[1m[22m[11]. This document
       assumes that [1mApache [22m2.2 is being used; you may use 2.4 if you are able
       to adapt the instructions on your own.

       For the purposes of this exercise, those are the only third-party
       packages that you need, other than [1mgmake[22m, [1mGCC[22m, and the usual software
       development tools. Install [1mOpenSSL [22mand [1mExpat [22mnow; we will deal with
       [1mApache [22min the next step.

           [1mNote[0m
           We will assume that these packages are installed under /usr/local.
           If you installing elsewhere, be sure to adjust paths appropriately
           in the examples below.

           Some administrators prefer to use a particular file extension, such
           as ".cgi", for CGI executables. The easiest way to make [1mDACS[0m
           accommodate this is to pass the [1m--with-cgi-suffix [22mflag to [1mconfigure[0m
           (see [34m[1mdacs.install(7)[0m[1m[22m[4]). This results in the configuration
           variable [4m${Conf::dacs_cgi_bin_suffix}[24m being set to the suffix. In
           this document, we will assume that no special file extension is
           required.

   [1mStep 2: Install and configure Apache[0m
       Because you probably do not want to use a production web server for
       this exercise, so that we're on the same page to begin with, and to
       make it easier for you to clean up later, we'll build and install a
       fresh [1mApache [22mserver. It will be best if you start from scratch by
       unpacking an [1mApache [22mdistribution into a new directory, building and
       installing it, and then verifying that the default [1mApache [22mconfiguration
       works. We will install this [1mApache [22min /usr/local/apache-dacs so that it
       does not interfere with anything already on your system - you may
       change this path, but remember to make appropriate changes to the
       instructions that follow.

        1. From the root of the [1mApache [22mdistribution, you need to build [1mApache[22m.
           Review the [1mApache [22mINSTALL file. Unfortunately, there is no simple
           way to build [1mApache [22mthat will work on all platforms, so you will
           need to review the [34m[1mdetailed instructions[0m[1m[22m[12]. Then build and
           install [1mApache[22m.

           Do not configure any [1mApache [22mmodules or customizations. We want to
           create a vanilla web server. The path /usr/local/apache-dacs is
           being used to avoid any existing [1mApache [22minstallation; when you are
           finished with the tutorial, you will remove this directory.

        2. We will soon configure a virtual host for a (fake) domain name that
           we have reserved for this purpose, but first we must make
           dodgers.dacstest.dss.ca an alias for the host that will run [1mhttpd[22m.
           Choose one of the following two options:

            1. If you are installing [1mApache [22mon the same machine from which you
               are running your web browser, edit /etc/hosts as follows:

                   127.0.0.1     localhost dodgers.dacstest.dss.ca


            2. If you will be running your browser on a host different from
               where [1mApache [22mis running, you will need to add an alias in
               /etc/hosts for that host's IP address [4mon[24m [4mboth[24m [4mmachines[24m. The
               entry will have the format:

                   [4mhostip[24m       [4mhostname[24m dodgers.dacstest.dss.ca

               For example, on my system I used:

                   10.0.0.125     i7.dss.ca i7 dodgers.dacstest.dss.ca

               So the [4mhostip[24m I selected above is 10.0.0.125.

                   [1mNotes[0m
                    1. If your desktop is a Windows platform rather than
                       Unix-based, you will need to edit
                       C:\Windows\system32\drivers\etc\hosts or
                       C:\WINNT\system32\drivers\etc\hosts (or similar)
                       instead of /etc/hosts.

                    2. You can use the domain dodgers.dacstest.dss.ca and the
                       others in this document no matter where your host is
                       located. These domain names will not be visible outside
                       of the hosts on which you define them by hand.

                    3. After you have completed this exercise, please remember
                       to delete the aliases.
                   To verify the change, use [1mping[22m:

                       % ping dodgers.dacstest.dss.ca

                   (You may need to run it as /sbin/ping or something similar
                   on your system.)

                3. We need to make a few changes to [1mApache's [22mdefault
                   configuration, in case you are already running a web server
                   on this machine and as a first step towards some
                   customization that we will need shortly. We will add a
                   virtual host definition and do some initial set up for
                   [1mDACS[22m. Edit /usr/local/apache-dacs/conf/httpd.conf, advance
                   to the bottom of the file, and insert the text that appears
                   below:

                       # Permit access to the DACS documents
                       <Directory /usr/local/dacs/www/*>
                         Options Indexes FollowSymLinks
                         Order allow,deny
                         Allow from all
                       </Directory>

                       # Permit access
                       # Configure a virtual host and make the DACS documents available
                       Listen dodgers.dacstest.dss.ca:18123
                       <VirtualHost *:18123>
                         ServerName dodgers.dacstest.dss.ca:18123
                         DocumentRoot "/usr/local/apache-dacs/htdocs"
                         ErrorLog     "/usr/local/apache-dacs/logs/error_log"
                         TransferLog  "/usr/local/apache-dacs/logs/access_log"
                         ScriptAlias /cgi-bin/ "/usr/local/apache-dacs/cgi-bin/"

                         Alias /css       "/usr/local/dacs/www/css/"
                         Alias /dacs      "/usr/local/dacs/www/"
                         Alias /dtd-xsd   "/usr/local/dacs/www/dtd-xsd/"
                         Alias /examples  "/usr/local/dacs/www/examples/"
                         Alias /handlers  "/usr/local/dacs/www/handlers/"
                         Alias /infocards "/usr/local/dacs/www/infocards/"
                         Alias /man       "/usr/local/dacs/www/man/"
                         Alias /misc      "/usr/local/dacs/www/misc/"
                         Alias /mod       "/usr/local/dacs/www/mod/"
                       </VirtualHost>

                   This [34m[1mVirtualHost[0m[1m[22m[13] section is going to correspond to the
                   [1mDACS [22mjurisdiction that we will define shortly. The purpose
                   of the [34m[1mDirectory[0m[1m[22m[14] and [34m[1mAlias[0m[1m[22m[15] directives is to make
                   various web resources available without having to copy them
                   under your [34m[1mDocumentRoot[0m[1m[22m[16].

                       [1mNote[0m
                        1. In our examples, we use port 18123, which we're
                           guessing is unlikely to already be in use on your
                           machine. If you are unlucky and it is in use,
                           [1mApache [22mwill complain when you start it and you will
                           obviously need to select a different port number.
                           So that the examples will continue to work,
                           consider creating a copy of this document and
                           changing all occurrences of "18123" to the port
                           number you have selected. If available, commands
                           such as [34m[1mnetstat(1)[0m[1m[22m[17] and [34m[1msockstat(1)[0m[1m[22m[18] can tell
                           you which ports are currently in use. In the event
                           that you will be accessing your server from the
                           other side of a firewall (which is not recommended,
                           as previously mentioned), keep in mind that traffic
                           may not ordinarily be passed through on this port.

                        2. If you are already running [1mApache [22mon port 80 (the
                           default) or if you are not root whenever you run
                           [1mapachectl [22min any of the following steps, you must
                           comment out (or delete) all [34m[1mListen[0m[1m[22m[19] directives
                           for port 80 in httpd.conf. Therefore, comment out
                           all directives that look like any of the following:

                               Listen 80
                               Listen 0.0.0.0:80
                               Listen [::]:80


                    4. It is good practice to run [1mhttpd [22mas an unprivileged
                       user id and [1mApache [22mdoes this by default through the
                       [34m[1mUser[0m[1m[22m[20] directive in httpd.conf:

                           User nobody


                       [1mDACS [22mweb services are run as the same user id as [1mhttpd[22m,
                       but they must be able to read and sometimes write files
                       within the [1mDACS [22minstallation directory. These files
                       should not be readable or writable by other processes
                       or anyone other than a [1mDACS [22madministrator. Using
                       [34m[1mmod_suexec[0m[1m[22m[21] is one approach, but for the purpose of
                       this tutorial we want to keep things simple. Note that
                       setting [34m[1mUser[0m[1m[22m[20] (or [34m[1mGroup[0m[1m[22m[22]) to root is not a good
                       idea.

                       The [1mApache [22mdocumentation recommends setting up a new
                       group specifically for running the server, and we will
                       take this approach. We will assume in our examples that
                       this group is called www. You may need to create this
                       group (see [34m[1mgroup(5)[0m[1m[22m[23]) or you may already have a
                       different but suitable group name to use (e.g.,
                       webservd, _www, or daemon). Whatever group name you
                       choose, when [1mDACS [22mis installed in the next step you
                       will be prompted for this group id and you must make
                       the appropriate change to httpd.conf:

                           Group www

                       Because we will refer to this group name often in later
                       steps, save its name as the value of the shell variable
                       [4mdacsgroup[24m (we will use [1mcsh[22m/[1mtcsh [22msyntax - use the syntax
                       preferred by your shell):

                           % set dacsgroup=www


                           [1mNote[0m
                           Consider adding yourself to this group while you
                           are working on this tutorial because you will have
                           to do much less of the work as root. Remember to
                           logout and login again after adding yourself, and
                           verify the change using the [1mgroups [22mcommand.
                       Change the group id of files in the [1mApache [22minstallation
                       directory to this group and adjust permissions (you may
                       have to do this as root):

                           % chgrp -R $dacsgroup /usr/local/apache-dacs
                           % chmod -R g+w /usr/local/apache-dacs


                    5. As root, start your httpd...

                           # /usr/local/apache-dacs/bin/apachectl start

                       The reason you must do this as root is because it is
                       required by Apache's [34m[1mUser[0m[1m[22m[20] and [34m[1mGroup[0m[1m[22m[22] directives.

                    6. Use your favourite browser (or link fetcher, such as
                       [1mwget[22m) to verify that [1mApache [22mis serving content,
                       starting with this link:

                           [34m[1mhttp://dodgers.dacstest.dss.ca:18123[0m

                       If this fails, check again that your host has the
                       correct IP address for dodgers.dacstest.dss.ca. If you
                       are running your browser on a different host than
                       Apache, check for a networking or firewall related
                       problem (and try the browser on the same host as
                       Apache).

                           [1mNote[0m
                           It appears that CentOS disallows non-localhost
                           connection requests by default; to allow Apache to
                           receive non-localhost requests on CentOS, run (as
                           root):

                               # system-config-securitylevel

                           In the "Other ports" section of the "Firewall
                           Options", add port 18123 for protocol tcp. Once the
                           change is applied it is persistent, so remember to
                           remove the port from the list when you are finished
                           with this tutorial. Another option, if it is safe
                           to do so, is to totally disable the firewall. On
                           CentOS:

                               # service iptables stop

                           If you choose to do this you should either restart
                           the firewall when you are done ("[1mservice iptables[0m
                           [1mstart[22m") or reboot.

                           Another alternative, for CentOS and other systems,
                           is to use the appropriate command (e.g., [1miptables[22m,
                           [1mipfw[22m, or [1mpfctl[22m) to add a firewall rule to allow TCP
                           access to port 18123.

                    7. You should now check that your [1mhttpd [22mwas built
                       properly. First, make sure that [1mtest-cgi [22mis executable
                       (a CGI that is installed by [1mApache[22m):

                           % chmod 0750 /usr/local/apache-dacs/cgi-bin/test-cgi

                       And then invoke it:

                           [34m[1mhttp://dodgers.dacstest.dss.ca:18123/cgi-bin/test-cgi[0m

                       Look for the [4mSERVER_SOFTWARE[24m variable in its output and
                       ensure that its value shows the correct versions of
                       [1mApache[22m, [1mmod_ssl[22m, and [1mOpenSSL[22m; if you find something
                       unexpected, you probably didn't configure and/or
                       install [1mApache [22mor [1mOpenSSL [22mcorrectly.

                    8. You have confirmed that [1mApache [22mis properly installed,
                       so stop the web server:

                           % /usr/local/apache-dacs/bin/apachectl stop


   [1mStep 3: Build and install DACS[0m
       Now it is time to build and install the [1mDACS [22mutilities and web
       services. Make your working directory the src subdirectory of the [1mDACS[0m
       distribution.

        1. Build and install [1mDACS [22mweb services and utilities. You must use
           [1mgmake[22m, the GNU Make utility. Adjust the paths specified for [1mExpat[22m,
           [1mApache[22m, and [1mOpenSSL [22mas necessary. The [1mDACS [22minstallation directory
           must be writable to you and you must be able to set file user and
           group ownership (see below); you may need to be root.

               % ./configure --prefix=/usr/local/dacs \
                  --disable-shared --enable-static \
                  --enable-passwd-auth --disable-bdb \
                  --with-apache=/usr/local/apache-dacs \
                  --with-apache-apr=/usr/local/apache-dacs/apr-httpd \
                  --with-expat=/usr/local/expat-2.0.1 \
                  --with-ssl=/usr/local/openssl-1.0.1c
               % gmake

           If all goes well:

               % gmake install

           You can ignore any warnings about ACLs.

           You will be prompted for the user id and group id to be used for
           [1mDACS [22mfiles and directories. The group id you give should match the
           value you used for [1mApache's [22mGroup directive (that is, the value of
           [4m$dacsgroup[24m). The user id can be your user id; if it is not, you
           will need to do the upcoming install command (and some later
           commands) as root. You will need to do [1mgmake install [22mas root if
           your account has insufficient privileges to set the user and group
           ids that you specify. The installation procedure will remember your
           answers to the prompts; if you make a mistake or want to change
           them, do:

               % conftools/setaccess-sh reset

           and try [1mgmake install [22magain.

   [1mStep 4: DACS-enable Apache[0m
       We'll continue by installing the [34m[1mmod_auth_dacs[0m[1m[22m[24] module for [1mApache[22m.
       Make your working directory the apache subdirectory of the [1mDACS[0m
       distribution.

        1. Compile and install the [1mmod_auth_dacs [22mmodule. As earlier, you will
           need to do [1mgmake install [22mas root if your account has insufficient
           privileges to set the user and group ids that you specify.

               % gmake tag
               % gmake install

           If this succeeds, your [1mApache [34mhttpd.conf[0m[1m[22m[25] file should now
           contain the following directive:

               LoadModule auth_dacs_module modules/mod_auth_dacs.so

           Please check that this is so. If you cannot find that directive,
           add it manually near the part of httpd.conf that talks about the
           [34m[1mLoadModule[0m[1m[22m[26] directive.

        2. Start [1mApache [22magain (as root):



               # /usr/local/apache-dacs/bin/apachectl start

           and take another look at the [4mSERVER_SOFTWARE[24m variable:

               [34m[1mhttp://dodgers.dacstest.dss.ca:18123/cgi-bin/test-cgi[0m

           The [4mSERVER_SOFTWARE[24m variable ought to look the same as before,
           except it should now also mention [1mmod_auth_dacs[22m.

           Congratulations - you are now running a [1mDACS[22m-enabled web server!
           [1mDACS [22mis not configured to do anything at the moment, mind you, but
           your web server is now capable of [1mDACS[22m-wrapping web services. You
           should be able to view the [1mDACS [22mmanual pages served from the web
           server you just installed:

               [34m[1mhttp://dodgers.dacstest.dss.ca:18123/man[0m


   [1mStep 5: Do basic DACS configuration[0m
       Although your [1mApache [22mis now [1mDACS[22m-enabled, a little more configuration
       of both [1mDACS [22mand [1mApache [22mare necessary before you can do anything
       interesting. We'll continue by working with the [1mDACS [22mconfiguration (see
       [34m[1mdacs.conf(5)[0m[1m[22m[27]).

       We begin this step by defining a new [1mDACS [22mfederation that consists of
       one jurisdiction. We will call the new federation DACSTEST and
       associate it with the domain name dacstest.dss.ca. We will call our
       jurisdiction LA. Incidentally, the names that we are using in this
       tutorial for our federation and jurisdiction ("DACSTEST", "LA", and
       "dacstest.dss.ca") are not "special"; there's an underlying theme that
       should be apparent to any baseball fan but we could have chosen any
       syntactically valid names. The domain name for our jurisdiction
       (dodgers.dacstest.dss.ca) is only special in that it is a subdomain of
       dacstest.dss.ca; this must be the case for all jurisdictions in our
       example federation.

           [1mSecurity[0m
           All of the files and directories that we create in this and future
           steps must be readable by [1mDACS [22mweb services. This means that they
           must have their group ownership set to [4m$dacsgroup[24m and have group
           read and write permissions, as discussed earlier.

       We're going to be using a few long pathnames in this step and later on,
       so to help unclutter the instructions, and for your convenience, we
       will represent them as shell variables. For example, the pathname
       /usr/local/dacs/federations will be referred to as $feds and the
       pathname $feds/dacstest.dss.ca/LA will be $la. You may find it useful
       at this time to define the following variables in your shell using the
       particular syntax it prefers (we use [1mtcsh[22m):

           % set dacs=/usr/local/dacs
           % set bin=$dacs/bin
           % set feds=$dacs/federations
           % set la=$feds/dacstest.dss.ca/LA

       If you are using a compatible shell, such as [1mcsh[22m, you will then be able
       to copy and paste command lines and other text that follows in the
       tutorial.

           [1mTip[0m
           At this point you can use the [34m[1mdacsinit(1)[0m[1m[22m[28] program, found in the
           distribution's src directory, to perform the operations in this
           step for you. By default, the program uses the default paths that
           were established when [1mDACS [22mwas built and the example paths used in
           this step. When prompted, simply use the [1mdacsinit [22mdefault values
           (just hit Return/Enter), which should result in the same
           configuration as you would obtain by manually following the
           directions in this step.

           You can also use [1mdacsinit [22mto create a configuration for a
           federation with one very basic jurisdiction based on names of your
           choosing. You can later extend or customize this configuration
           manually. Also see [34m[1mInitial Configuration[0m[1m[22m[29].

       Although you can get away with having a single [1mDACS [22mconfiguration file
       on a host, we recommend a hierarchical organization. The file
       site.conf, although optional, holds standard default configuration
       directives as well as site-specific directives for all federations
       configured on this host. One or more files named dacs.conf can be used
       on a per-jurisdiction, per-federation, or per-host basis; that is, each
       jurisdiction on a host can have its own dacs.conf, or all (or some) of
       the jurisdictions on a host can share a dacs.conf, or everything can
       just be lumped into one dacs.conf. It's entirely up to you.

       When [1mconfigure [22mis run to build [1mDACS[22m, you can specify default locations
       for various configuration files, including site.conf and dacs.conf. We
       did not change the defaults when we built [1mDACS [22mabove, so our examples
       will use the default paths.

           [1mTip[0m
           We recommend that you always use the site.conf-std that comes with
           your [1mDACS [22mdistribution as your site.conf file and that you do not
           make any modifications to it, instead putting customizations in
           your dacs.conf file. This will make upgrades easier and less
           error-prone.

        1. Proceed by installing the default site configuration file as
           $feds/site.conf (recall that we defined the shell variables
           [34m[1mearlier[0m[1m[22m[30], and that you may have to be root to be able to install
           correctly):

               % install -c -g $dacsgroup -m 0640 $feds/site.conf-std $feds/site.conf


               [1mNote[0m
               If the [1minstall [22mcommand is unavailable on your system, you can
               use src/conftools/install-sh relative to your [1mDACS [22mdistribution
               directory. Or just use [1mcp [22m(or [1mmkdir[22m), [1mchgrp[22m, and [1mchmod[22m.

        2. Since we are not using SSL in this tutorial, edit $feds/site.conf
           and change the value of the [34m[1mSECURE_MODE[0m[1m[22m[31] directive to "off". For
           production use, the directive's value should always be "on":

               SECURE_MODE "off"


        3. It is convenient - though not required - to collect the
           configuration directives for all jurisdictions on this host in a
           single file. It's not unusual for a host to be associated with just
           one jurisdiction (and one federation), but this is certainly not
           always the case.

               % install -c -g $dacsgroup -m 0660 /dev/null $feds/dacs.conf


        4. We will create a directory where most of the files associated with
           our new federation will live:

               % install -d -g $dacsgroup -m 0770 $feds/dacstest.dss.ca


        5. And a subdirectory within it where most of the files associated
           with our new jurisdiction will live:

               % install -d -g $dacsgroup -m 0770 $la


        6. Create a directory where we will put access control rules (also
           called ACLs, access control lists, or simply rules) for our
           jurisdiction, and we also need an empty revocation file:

               % install -d -g $dacsgroup -m 0770 $la/acls
               % install -c -g $dacsgroup -m 0660 /dev/null $la/acls/revocations


        7. Create directories where we will put group definitions for our
           jurisdiction and define the membership of our federation:

               % install -d -g $dacsgroup -m 0770 $la/groups $la/groups/LA $la/groups/DACS
               % install -c -g $dacsgroup -m 0660 /dev/null $la/groups/DACS/jurisdictions.grp

           Paste the following text into the $la/groups/DACS/jurisdictions.grp
           file:

               <groups xmlns="http://dss.ca/dacs/v1.4">
                <group_definition jurisdiction="LA" name="jurisdictions"
                    mod_date="Tue, 14-Jun-2005 16:06:00 GMT" type="public">
                  <group_member jurisdiction="LA" name="LA Jurisdiction" type="meta"
                    alt_name="Test Jurisdiction for the LA Dodgers"
                    dacs_url="http://dodgers.dacstest.dss.ca:18123/cgi-bin/dacs"
                    authenticates="yes" prompts="no"/>
                </group_definition>
               </groups>

           (Remember to change 18123 if you are using a different port.) The
           purpose of jurisdictions.grp is to provide [1mDACS [22mwith information
           about the jurisdictions in this federation. All jurisdictions in a
           federation should use identical jurisdictions.grp files. We're not
           going to make much use of this in the tutorial, but if you add a
           jurisdiction or if any of this information changes,
           jurisdictions.grp would ordinarily be updated everywhere in your
           federation. For instance, if you were to add a jurisdiction to your
           federation, you should add another group_member element to the
           group_definition that describes the new jurisdiction, and then copy
           the updated jurisdictions.grp file to each jurisdiction. Please see
           [34m[1mdacs.groups(5)[0m[1m[22m[32] for additional information.

        8. We need some basic configuration directives for the jurisdiction
           LA. Paste the following text into the $feds/dacs.conf file:

               <Configuration xmlns="http://dss.ca/dacs/v1.4">

                <Default>
                  FEDERATION_DOMAIN "dacstest.dss.ca"
                  FEDERATION_NAME "DACSTEST"
                  LOG_LEVEL "info"
                </Default>

                <Jurisdiction uri="dodgers.dacstest.dss.ca">
                  JURISDICTION_NAME "LA"
                </Jurisdiction>

               </Configuration>


        9. And let's make this the default configuration file for [1mDACS[0m
           jurisdictions at this site:

               % rm -f $la/dacs.conf
               % ln -s $feds/dacs.conf $la/dacs.conf


       10. Now, let's ask [1mDACS [22mto display its configuration by running the
           [34m[1mdacsconf(1)[0m[1m[22m[33] utility:

               % $bin/dacsconf -uj LA -q

           This configuration is the result of merging the contents of
           $la/dacs.conf (which points to $feds/dacs.conf) and
           $feds/site.conf, with directives in the former file overriding
           directives in the latter.

       11. We must create encryption keys for this federation using the
           [34m[1mdacskey(1)[0m[1m[22m[34] utility:

               % install -c -g $dacsgroup -m 0640 /dev/null $feds/dacstest.dss.ca/federation_keyfile
               % $bin/dacskey -uj LA -q $feds/dacstest.dss.ca/federation_keyfile
               % ls -l $feds/dacstest.dss.ca/federation_keyfile

           We could not do this until after the jurisdiction had been
           configured because [1mdacskey [22mneeds to look at dacs.conf.

               [1mSecurity[0m
               [4mThe[24m [4mfederation[24m [4mkey[24m [4mfile[24m [4mmust[24m [4mbe[24m [4mkept[24m [4msecret[24m. Any person or
               process that can read the federation key file can create [1mDACS[0m
               identities. It should be readable [4monly[24m by its owner and [1mDACS[0m
               and [4mnot[24m readable by anyone else.

       12. Similarly, we should create encryption keys for our jurisdiction:

               % install -c -g $dacsgroup -m 0640 /dev/null $la/jurisdiction_keyfile
               % $bin/dacskey -uj LA -q $la/jurisdiction_keyfile
               % ls -l $la/jurisdiction_keyfile

           Like the federation keys, these keys must also be kept secret. But
           the jurisdiction keys are private to their jurisdiction and are not
           shared among federation members.

       13. Make sure that all of the files and directories starting with
           /usr/local/dacs have appropriate permissions, as discussed earlier.

           [1mNote[0m
           If you modify httpd.conf you must restart [1mApache [22mfor the changes to
           take effect. If you modify dacs.conf, site.conf, or any other [1mDACS[0m
           configuration file, the changes take effect immediately and do not
           require restarting [1mApache[22m.

   [1mStep 6: Do basic Apache configuration for DACS[0m
       Your [1mApache [22mis now [1mDACS[22m-enabled and we've configured [1mDACS[22m. Before we
       can do anything interesting we must make some changes to the [1mApache[0m
       configuration. We will begin by [1mDACS[22m-wrapping [1mDACS [22mweb services, which
       is required.

        1. Edit /usr/local/apache-dacs/conf/httpd.conf and locate the
           [34m[1mVirtualHost[0m[1m[22m[13] section that you added earlier. Inside that
           VirtualHost section and near its end, add the following text
           (remember to adjust paths as necessary):

               AddDACSAuth dacs-acs /usr/local/dacs/bin/dacs_acs "-t -v"
               SetDACSAuthMethod dacs-acs external
               SetDACSAuthConf dacs-acs "/usr/local/dacs/federations/dacs.conf"

               <Location /cgi-bin/dacs>
                 Require valid-user
               # Note: For Apache 2.4, instead use:
               # Require dacs-authz
                 Options ExecCGI
                 AuthType DACS
                 AuthDACS dacs-acs
               </Location>

           These directives configure the virtual host to [1mDACS[22m-wrap the
           contents of all URLs that fall under the /cgi-bin/dacs namespace.
           The first three directives tell [1mmod_auth_dacs [22mwhere to find the
           external [1mDACS [22maccess control program ([34m[1mdacs_acs(8)[0m[1m[22m[35]) and the [1mDACS[0m
           configuration file.

        2. Start (or restart) [1mApache [22mso that it uses its new configuration (as
           root):

               # /usr/local/apache-dacs/bin/apachectl restart


           [1mDACS [22mshould now be enforcing access control on the /cgi-bin/dacs
           part of the server's URL space.

        3. Check that you can still access [1mtest-cgi [22m(which you have not
           [1mDACS[22m-wrapped):

               [34m[1mhttp://dodgers.dacstest.dss.ca:18123/cgi-bin/test-cgi[0m


        4. Now, let's see what happens when we try to access [1mdacs_prenv[22m:

               [34m[1mhttp://dodgers.dacstest.dss.ca:18123/cgi-bin/dacs/dacs_prenv[0m[1m[22m[36]

           Apache should produce a "403 Forbidden" error, which causes [1mDACS [22mto
           display an "Access Denied by DACS" page (actually, it is the
           contents of the file /usr/local/dacs/www/handlers/acs_failed.html,
           which is set by the [34m[1mACS_ERROR_HANDLER[0m[1m[22m[37] directive in site.conf).
           This happens because the default rules do not grant access to
           [1mdacs_prenv[22m, so all access will be denied.

        5. To finish up this step, let's add a rule that will grant everyone
           access to [1mdacs_prenv[22m. Create $la/acls/acl-tutorial.0 with
           appropriate permissions:

               % install -c -g $dacsgroup -m 0660 /dev/null $la/acls/acl-tutorial.0

           and then paste the following text into it:

               <acl_rule status="enabled">
                 <services>
                   <service url_expr='"${Conf::dacs_cgi_bin_prefix}/dacs_prenv${Conf::dacs_cgi_bin_suffix}"'/>
                   <service url_expr='"${Conf::dacs_cgi_bin_prefix}/dacs_version${Conf::dacs_cgi_bin_suffix}"'/>
                 </services>

                 <rule order="allow,deny">
                   <allow>
                     user("any")
                   </allow>
                 </rule>
               </acl_rule>

           Whenever you add or change an access rule, you must rebuild the
           rule index for the jurisdiction:

               % $bin/dacsacl -uj LA -q -build
               % chgrp $dacsgroup $la/acls/INDEX

           It's currently only really necessary to run [1mdacsacl [22mif you add a
           rule or modify any part of a rule's services element, but this may
           change in a future release so just do it always. We make sure that
           the index file's group ID is correct.

           This time [1mdacs_prenv [22mshould work because our new rule grants access
           to everyone. Try it:

               [34m[1mhttp://dodgers.dacstest.dss.ca:18123/cgi-bin/dacs/dacs_prenv[0m[1m[22m[36]

           This output includes some new environment variables that are passed
           to all [1mDACS[22m-wrapped programs. These variables begin with "DACS_",
           such as [1mDACS_VERSION [22m- see [34m[1mdacs_acs(8)[0m[1m[22m[38] for additional
           information.

   [1mStep 7: Test basic DACS services[0m
       There's still not too much you can do at this point, but there are a
       few [1mDACS [22mservices that you can try. If one of these requests fails,
       take a look at the [1mDACS [22mlog files in the /usr/local/dacs/logs directory
       for clues. The most likely cause is incorrect permissions on a file or
       directory, or possibly you made an editing mistake.

        1. The [34m[1mdacs_version(8)[0m[1m[22m[39] web service displays various version
           information, naturally enough:

               [34m[1mhttp://dodgers.dacstest.dss.ca:18123/cgi-bin/dacs/dacs_version[0m


        2. The [34m[1mdacs_list_jurisdictions(8)[0m[1m[22m[40] web service displays information
           about jurisdictions:

               [34m[1mhttp://dodgers.dacstest.dss.ca:18123/cgi-bin/dacs/dacs_list_jurisdictions[0m

           You may recognize some of this material from the jurisdictions.grp
           file.

        3. We saw the [1mconf [22mutility earlier. We can get the same information
           from a web service:

               [34m[1mhttp://dodgers.dacstest.dss.ca:18123/cgi-bin/dacs/dacs_conf[0m

           Ooops! You should have been denied access to this web service. If
           you examine the default ACL (see [34m[1mdacs.acls(5)[0m[1m[22m[41]) for this web
           service, which can be found in /usr/local/dacs/acls/acl-conf.0, you
           might suspect that access to [1mdacs_conf [22mwill only be granted to
           identities that satisfy the expression "dacs_admin()" (see
           [34m[1mdacs.exprs(5)[0m[1m[22m[42]). And since you have not signed on to obtain a
           [1mDACS [22midentity, the ACL should deny access. After we do a little
           more [1mDACS [22mconfiguration work in the next step, we will give this
           another try.

   [1mStep 8: Try DACS authentication[0m
       It is possible to create accounts or identities specifically for [1mDACS[0m
       users. These identities are managed by the [34m[1mdacspasswd(1)[0m[1m[22m[43] utility
       (there are user accounts managed by other [1mDACS [22mcommands, but we will
       not discuss them here). Similar to [1mApache's [34mhtpasswd[0m[1m[22m[44] command, these
       accounts are "private" in that they are unrelated to any other
       identities you might have on your system, unless you tie them together.
       For example, we can create a [1mDACS [22midentity named "root" that has no
       relationship to a Unix system's superuser - perhaps you are creating a
       [1mDACS [22maccount for actor [34m[1mStephen Root[0m[1m[22m[45].

        1. We begin this step by creating an empty password file for
           [1mdacspasswd [22m(to ensure correct permissions). Then we create a [1mDACS[0m
           account for username "sandy".

               % install -c -g $dacsgroup -m 0660 /dev/null $la/passwd
               % $bin/dacspasswd -uj LA -q -a sandy

           You will be prompted for a password to assign to sandy's account.
           Choose any password you like as long as it is at least six
           characters long. You can change sandy's password by running this
           command again.

        2. Next, we edit $la/dacs.conf and add the following text in the
           Jurisdiction section for dodgers.dacstest.dss.ca:

               <Auth id="passwd">
                  URL \
               "http://dodgers.dacstest.dss.ca:18123/cgi-bin/dacs/local_passwd_authenticate"
                  STYLE "pass"
                  CONTROL "sufficient"
                </Auth>

           This configuration enables authentication (see
           [34m[1mdacs_authenticate(8)[0m[1m[22m[46]) for accounts managed by the [1mdacspasswd[0m
           utility. Check again that all files starting with /usr/local/dacs
           have appropriate permissions, as discussed earlier.

        3. We should now be able to authenticate ("login") as sandy by
           providing the password you set up earlier. If successful, your
           browser will be sent credentials (in an HTTP cookie) for the
           identity [1mDACS [22mcalls LA:sandy. Note that the cookies [1mDACS [22mcreates
           are deleted when your browser exits. Even if a cookie is not
           deleted, DACS credentials have a limited lifetime and will become
           useless when they expire.

           [1mDACS [22mcomes with examples of simple HTML login pages with which you
           can authenticate:

               [34m[1mhttp://dodgers.dacstest.dss.ca:18123/examples/login.html[0m

           Your browser must have JavaScript enabled to use this page. Select
           the jurisdiction (LA), enter the username (sandy) and password, and
           then click "Login". If all is well, you should see the "DACS
           Authentication Succeeded" page, which is the contents of
           /usr/local/dacs/www/handlers/auth_ok.html. Of course in a
           production environment you would write custom login and signout
           pages, or integrate the functionality with a portal or in whatever
           way you prefer for your site.

        4. Things get a bit more interesting now that you are able to
           authenticate. You can follow one link on the "DACS Authentication
           Succeeded" page to see your current credentials (using
           [34m[1mdacs_current_credentials[0m[1m[22m[47]) or another to visit a page that will
           allow you to signout ([34m[1mdacs_signout(8)[0m[1m[22m[48]) from all or some
           identities (you can also [34m[1minvoke dacs_signout directly[0m[1m[22m[49] to
           signout from all identities). If you signout, there will be a link
           that you can follow to login again.

        5. Now use [1mdacspasswd [22mto create another account:

               % $bin/dacspasswd -uj LA -q -a don

           If you are curious, you can take a peek at the password file, which
           we have configured to be $la/passwd.

           You can now authenticate as sandy or don. You can have more than
           one identity active at the same time (i.e., you could be signed on
           as both sandy [4mand[24m don), but this is disallowed by default; see
           [34m[1mACS_CREDENTIALS_LIMIT[0m[1m[22m[50] and [34m[1mAUTH_SINGLE_COOKIE[0m[1m[22m[51].

        6. Now that you're able to authenticate, let's have another try at
           running [1mdacs_conf [22m(recall you were not granted access to it
           earlier). We must first make one of the identities that you have
           created a [1mDACS [22madministrator identity. Edit $la/dacs.conf and add
           the following text in the Jurisdiction section for
           dodgers.dacstest.dss.ca (but [4mnot[24m within the Auth section):

               ADMIN_IDENTITY "LA:sandy"

           As you might assume, this confers special privileges to LA:sandy.

           Authenticate as sandy using the [34m[1mlogin page [0m[1m[22mand then try this link
           again (it should work this time):

               [34m[1mhttp://dodgers.dacstest.dss.ca:18123/cgi-bin/dacs/dacs_conf[0m

           If you [34m[1msignout[0m[1m[22m[52] as sandy, then [34m[1mauthenticate [0m[1m[22mas don, and try
           [34m[1mhttp://dodgers.dacstest.dss.ca:18123/cgi-bin/dacs/dacs_conf [0m[1m[22magain,
           you should be denied access.

        7. In an earlier step, you created an ACL ($la/acls/acl-tutorial.0)
           that grants access to [1mdacs_prenv [22mto any user, whether authenticated
           or not. Edit that rule and replace:

               user("any")

           with:

               user("auth")

           Try invoking [34m[1mdacs_prenv[0m[1m[22m[53] when you are not authenticated - you
           should be denied access. Now authenticate and try [34m[1mdacs_prenv[0m[1m[22m[53]
           again - it should work. Edit the rule again and replace:

               user("auth")

           with:


               user("LA:don")

           Now you should only be granted access if you've authenticated as
           the [1mDACS [22musername LA:don.

   [1mStep 9: DACS-wrapping a web service[0m
       To use [1mDACS [22mto control access to a resource, there are just a few
       things you need to do:

       +o   Make the URL space in which the resource lies within the scope of a
           [34m[1mLocation[0m[1m[22m[54] directive for the VirtualHost that corresponds to the
           [1mDACS [22mjurisdiction responsible for the resource.

       +o   Make an appropriate [1mDACS [22maccess control rule for the jurisdiction
           responsible for the URL space in which the resource lies.

       Basically, you have to configure [1mApache [22mto allow [1mDACS [22mto perform access
       control for the resource, and you have to configure [1mDACS [22mto enforce the
       selective access that you want. This is ordinarily both easy to do and
       something that is done infrequently because closely related resources
       are typically grouped together within the URL space you have defined
       (for example, all image files may be collected under /images in the URL
       space, related applications are collected somewhere under /cgi-bin, and
       so on) and because ACLs can be written with wildcard patterns that will
       match everything "under" a given URL space prefix.

           [1mSecurity[0m
           It is important to verify that all resources that you intend to be
           [1mDACS[22m-wrapped really are access controlled and that [1mDACS [22mcannot be
           bypassed (e.g., by using different URLs for the same resource). For
           instance, despite many improvements, getting [1mApache's [34mVirtual[0m
           [1m[34mHosts[0m[1m[22m[55] configured exactly as you require can be challenging -
           make sure that security cannot be bypassed through selection of a
           particular hostname or port number.

           Also, note that [1mDACS [22mperforms access control on resource names
           rather than on the resources themselves. This means that if a
           particular resource is known by multiple names, because of symbolic
           links, for example, then to correctly manage access to the resource
           all of its names must be [1mDACS[22m-wrapped.

   [1mStep 10: What's next?[0m
       Having successfully completed all of the previous steps, you should
       have a feel for some of the things that you can do with [1mDACS[22m. Of
       course, there's much more to [1mDACS [22mthan what we've covered. You should
       be capable of using the system you've configured to this point to try
       some things on your own. Here are a few ideas (in order of increasing
       difficulty):

       +o   Add a [1mDACS[22m-wrapped resource and experiment with access control
           rules. It might be a static web page or a CGI program. Remember
           that by default, your site-specific ACLs for the jurisdiction LA
           are files in the $la/acls directory. Review [34m[1mdacs.acls(5)[0m[1m[22m[56] before
           beginning.

       +o   Assign a few roles to [1mDACS [22muser sandy and modify an access control
           rule to consider roles when granting or denying access. Roles
           provide a convenient way to classify users so that access control
           rules can be concisely written to grant (or deny) access to a set
           of users that are related in some way. For example, you might
           assign some users to "students", some to "staff", and some to
           "faculty", and then write rules that reference those roles rather
           than individual [1mDACS [22musernames. Roles only have meaning with
           respect to how they are used in ACLs, so you can make up any
           syntactically valid words you want.

           Here are some hints to get you started. You'll need to do two
           things: assign roles to users and enable roles. Once enabled, your
           [1mDACS [22mwill look for roles in the file $la/roles. Each line of that
           file assigns roles to a user and consists of the username, a colon,
           and a comma-separated list of roles. For example:

               sandy:pitchers,retired-players
               don:pitchers,retired-players
               eric:pitchers,active-players
               cesar:infielders,active-players

           The other thing you'll need is some [1mDACS [22mconfiguration to enable
           roles. Add the following to the Jurisdiction section of dacs.conf:

               <Roles id="roles">
                 URL "http://dodgers.dacstest.dss.ca:18123/cgi-bin/dacs/local_roles"
               </Roles>

           Now you can create rules that depend on the user making the request
           having certain roles. For example, a rule can be written to grant
           access to a resource only if the user making the request has the
           role "pitchers" by using the predicate (see [34m[1mdacs.exprs(5)[0m[1m[22m[57]):

               user("%LA:pitchers")

           Or you can create a rule that will grant access only if the user
           has the roles "active-players" [4mand[24m "pitchers"; use the predicate:

               user("%LA:pitchers") and user("%LA:active-players")


       +o   If you create a [1mDACS [22maccount for a username that corresponds to a
           user on your system, you can configure [1mDACS [22mto assign roles to that
           user based on the Unix groups that she belongs to. This is very
           easy to do: instead of using [1mlocal_roles [22mas in the example above,
           use [1mlocal_unix_roles [22minstead. If you create a [1mDACS [22maccount for
           alice, for example, and the account "alice" has group membership on
           your system (see group(5)), then alice would authenticate using her
           [1mDACS [22mpassword and be assigned roles from her Unix group membership.

           Instead of using a [1mDACS [22maccount to authenticate alice, you can
           easily configure [1mDACS [22mto use alice's Unix password. The [1mDACS [22mmodule
           [1mlocal_unix_authenticate[22m, which must be installed set-uid root so
           that it can access passwords, provides this functionality.

       +o   Add a [1mDACS [22mjurisdiction named NY (yankees.dacstest.dss.ca) on the
           same host where you configured dodgers.dacstest.dss.ca. You do not
           have to configure authentication at the new jurisdiction. Notice
           that you can authenticate at dodgers.dacstest.dss.ca and then
           access resources at yankees.dacstest.dss.ca. This is "single
           sign-on".

       +o   Run [1mDACS [22mon an additional host. The procedure is basically the same
           as what you already did in this tutorial. Name the jurisdiction
           BOSTON and assign it the domain name redsox.dacstest.dss.ca. You
           won't be able to use the IP address 127.0.0.1 for this; you'll have
           to alias the domain names to the IP addresses of real interfaces
           and make the same changes to /etc/hosts on both hosts. You'll also
           have to use the identical federation_keyfile on both hosts (simply
           copy the file you've already made).

       +o   Configure a different (or additional) authentication method for
           your jurisdiction. See [34m[1mdacs_authenticate(8)[0m[1m[22m[58]. For the password
           style of authentication, you might try the NTLM authentication
           method. For a bit more of a challenge, see if you can make the expr
           or cert style of authentication work.

   [1mStep 11: Clean up[0m
       If you are done, you may want to do some clean up now. First, stop
       [1mApache[22m:

           # /usr/local/apache-dacs/bin/apachectl stop

       Next, delete dodgers.dacstest.dss.ca and any other domain names you
       created for this exercise from /etc/hosts. Delete any groups you
       created. Remove /usr/local/apache-dacs, /usr/local/dacs, and everything
       underneath them.

   [1mTroubleshooting[0m
       The first thing to do if you encounter a problem is to check that
       you've got the latest version of [1mDACS[22m; a newer version might fix your
       problem. Also, visit the [34m[1mPost-Release Notes[0m[1m[22m[59] area for your release
       in case a newer edition of this document is available or a bug fix has
       been posted.

       By default, the [1mDACS [22mlog files are put in the /usr/local/dacs/logs
       directory. If you encounter any problems or just want to see what's
       going on, examine the log files in that directory. Depending on the
       [1mDACS [34mLOG_LEVEL[0m[1m[22m[60] and [34m[1mLOG_FILTER[0m[1m[22m[61] directives in effect, log files
       can quickly become big. It is safe to delete them or truncate them at
       any time.

       In the event of problems, you should also take a look at the [1mApache[0m
       logs (in /usr/local/apache-dacs/logs).

       There are five main sources of problems:

        1. Typos (you got the spelling or punctuation incorrect, or didn't
           paste text correctly),

        2. File permissions are incorrect ([1mDACS [22mcannot read or write its files
           or directories),

        3. You didn't follow the instructions correctly (you skipped something
           or misunderstood something),

        4. You ran into unexpected platform dependencies, or

        5. We goofed.

       If you're sure the problem is either of the last two types, please
       [34m[1mcontact us[0m[1m[22m[6]. and tell us what happened. Be sure to mention which
       steps succeeded and which one failed.

[1mSEE ALSO[0m
       [34m[1mdacs(1)[0m[1m[22m[62], [34m[1mdacsinit(1)[0m[1m[22m[28], [34m[1mdacs.readme(7)[0m[1m[22m[3], [34m[1mdacs.install(7)[0m[1m[22m[4]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[63])

[1mCOPYING[0m
       Copyright (C) 2003-2013 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[64] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. FAQ
           http://dacs.dss.ca/faq.html

        2. manual pages
           http://dacs.dss.ca/man

        3. dacs.readme(7)
           http://dacs.dss.ca/man/dacs.readme.7.html

        4. dacs.install(7)
           http://dacs.dss.ca/man/dacs.install.7.html

        5. an Apache configuration task
           http://httpd.apache.org/docs-2.2/ssl/

        6. contact us
           http://www.dss.ca/contactus.html

        7. Apache
           http://httpd.apache.org

        8. OpenSSL
           http://www.openssl.org

        9. Expat
           http://sourceforge.net/projects/expat

       10. OpenSSL
           http://dacs.dss.ca/man/dacs.install.7.html#install-openssl

       11. Expat
           http://dacs.dss.ca/man/dacs.install.7.html#install-expat

       12. detailed instructions
           http://dacs.dss.ca/man/dacs.install.7.html#install-apache

       13. VirtualHost
           http://httpd.apache.org/docs-2.2/mod/core.html#virtualhost

       14. Directory
           http://httpd.apache.org/docs-2.2/mod/core.html#directory

       15. Alias
           http://httpd.apache.org/docs-2.2/mod/mod_alias.html#alias

       16. DocumentRoot
           http://httpd.apache.org/docs-2.2/mod/core.html#documentroot

       17. netstat(1)
           http://www.freebsd.org/cgi/man.cgi?query=netstat&apropos=0&sektion=1&manpath=FreeBSD+9.1-RELEASE&format=html

       18. sockstat(1)
           http://www.freebsd.org/cgi/man.cgi?query=sockstat&apropos=0&sektion=1&manpath=FreeBSD+9.1-RELEASE&format=html

       19. Listen
           http://httpd.apache.org/docs/2.0/mod/mpm_common.html#listen

       20. User
           http://httpd.apache.org/docs-2.2/mod/mpm_common.html#user

       21. mod_suexec
           http://httpd.apache.org/docs-2.2/mod/mod_suexec.html

       22. Group
           http://httpd.apache.org/docs-2.2/mod/mpm_common.html#group

       23. group(5)
           http://www.freebsd.org/cgi/man.cgi?query=group&apropos=0&sektion=5&manpath=FreeBSD+9.1-RELEASE&format=html

       24. [1mmod_auth_dacs[0m
           http://dacs.dss.ca/man/mod_auth_dacs.html

       25. httpd.conf
           file:///usr/local/apache-dacs/conf/httpd.conf

       26. LoadModule
           http://httpd.apache.org/docs-2.2/mod/mod_so.html#loadmodule

       27. dacs.conf(5)
           http://dodgers.dacstest.dss.ca:18123/man/dacs.conf.5.html

       28. dacsinit(1)
           http://dacs.dss.ca/man/dacsinit.1.html

       29. Initial Configuration
           http://dacs.dss.ca/man/dacs.install.7.html#initial_config

       30. earlier
           http://dacs.dss.ca/man/#var-defs

       31. SECURE_MODE
           http://dacs.dss.ca/man/dacs.conf.5.html#SECURE_MODE

       32. dacs.groups(5)
           http://dacs.dss.ca/man/dacs.groups.5.html#dacs_metadata

       33. [1mdacsconf(1)[0m
           http://dodgers.dacstest.dss.ca:18123/man/dacsconf.1.html

       34. [1mdacskey(1)[0m
           http://dodgers.dacstest.dss.ca:18123/man/dacskey.1.html

       35. [1mdacs_acs(8)[0m
           http://dodgers.dacstest.dss.ca:18123/man/dacs_acs.8.html

       36. http://dodgers.dacstest.dss.ca:18123/cgi-bin/dacs/dacs_prenv
           http://dodgers.dacstest.dss.ca:18123/cgi-bin/dacs/dacs_prenv?FORMAT=html

       37. ACS_ERROR_HANDLER
           http://dacs.dss.ca/man/dacs.conf.5.html#ACS_ERROR_HANDLER

       38. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html#exported_envars

       39. dacs_version(8)
           http://dodgers.dacstest.dss.ca:18123/man/dacs_version.8.html

       40. dacs_list_jurisdictions(8)
           http://dodgers.dacstest.dss.ca:18123/man/dacs_list_jurisdictions.8.html

       41. dacs.acls(5)
           http://dodgers.dacstest.dss.ca:18123/man/dacs.acls.5.html

       42. dacs.exprs(5)
           http://dodgers.dacstest.dss.ca:18123/man/dacs.exprs.5.html

       43. dacspasswd(1)
           http://dodgers.dacstest.dss.ca:18123/man/dacspasswd.1.html

       44. htpasswd
           http://httpd.apache.org/docs-2.2/programs/htpasswd.html

       45. Stephen Root
           http://us.imdb.com/name/nm0740535/

       46. dacs_authenticate(8)
           http://dodgers.dacstest.dss.ca:18123/man/dacs_authenticate.8.html

       47. dacs_current_credentials
           http://dodgers.dacstest.dss.ca:18123/cgi-bin/dacs/dacs_current_credentials

       48. dacs_signout(8)
           http://dodgers.dacstest.dss.ca:18123/man/dacs_signout.8.html

       49. invoke dacs_signout directly
           http://dodgers.dacstest.dss.ca:18123/cgi-bin/dacs/dacs_signout

       50. ACS_CREDENTIALS_LIMIT
           http://dacs.dss.ca/man/dacs.conf.5.html#ACS_CREDENTIALS_LIMIT

       51. AUTH_SINGLE_COOKIE
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_SINGLE_COOKIE

       52. signout
           http://dodgers.dacstest.dss.ca:18123/examples/signout.html

       53. dacs_prenv
           http://dodgers.dacstest.dss.ca:18123/cgi-bin/dacs/dacs_prenv

       54. Location
           http://httpd.apache.org/docs-2.2/mod/core.html#location

       55. Virtual Hosts
           http://httpd.apache.org/docs/2.2/vhosts/

       56. dacs.acls(5)
           http://dacs.dss.ca/man/dacs.acls.5.html

       57. dacs.exprs(5)
           http://dacs.dss.ca/man/dacs.exprs.5.html

       58. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

       59. Post-Release Notes
           http://dacs.dss.ca/download.html

       60. LOG_LEVEL
           http://dacs.dss.ca/man/dacs.conf.5.html#LOG_LEVEL

       61. LOG_FILTER
           http://dacs.dss.ca/man/dacs.conf.5.html#LOG_FILTER

       62. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

       63. www.dss.ca
           http://www.dss.ca

       64. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.28b                      03/01/2013                     DACS.QUICK(7)
