/*********************                                                        */
/*! \file module_template.cpp
 ** \verbatim
 ** Top contributors (to current version):
 **   Morgan Deters, Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2018 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Option template for option modules.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.cpp file.
 **/

#include "options/options_holder.h"

namespace CVC4 {

template <> const options::stringAbortLoop__option_t::type& Options::operator[](
    options::stringAbortLoop__option_t) const
{
  return d_holder->stringAbortLoop;
}
template <> bool Options::wasSetByUser(options::stringAbortLoop__option_t) const
{
  return d_holder->stringAbortLoop__setByUser__;
}
template <> const options::stringBinaryCsp__option_t::type& Options::operator[](
    options::stringBinaryCsp__option_t) const
{
  return d_holder->stringBinaryCsp;
}
template <> bool Options::wasSetByUser(options::stringBinaryCsp__option_t) const
{
  return d_holder->stringBinaryCsp__setByUser__;
}
template <> const options::stringCheckEntailLen__option_t::type& Options::operator[](
    options::stringCheckEntailLen__option_t) const
{
  return d_holder->stringCheckEntailLen;
}
template <> bool Options::wasSetByUser(options::stringCheckEntailLen__option_t) const
{
  return d_holder->stringCheckEntailLen__setByUser__;
}
template <> const options::stringEager__option_t::type& Options::operator[](
    options::stringEager__option_t) const
{
  return d_holder->stringEager;
}
template <> bool Options::wasSetByUser(options::stringEager__option_t) const
{
  return d_holder->stringEager__setByUser__;
}
template <> const options::stringEagerLen__option_t::type& Options::operator[](
    options::stringEagerLen__option_t) const
{
  return d_holder->stringEagerLen;
}
template <> bool Options::wasSetByUser(options::stringEagerLen__option_t) const
{
  return d_holder->stringEagerLen__setByUser__;
}
template <> const options::stringEIT__option_t::type& Options::operator[](
    options::stringEIT__option_t) const
{
  return d_holder->stringEIT;
}
template <> bool Options::wasSetByUser(options::stringEIT__option_t) const
{
  return d_holder->stringEIT__setByUser__;
}
template <> void Options::set(
    options::stringExp__option_t,
    const options::stringExp__option_t::type& x)
{
  d_holder->stringExp = x;
}
template <> const options::stringExp__option_t::type& Options::operator[](
    options::stringExp__option_t) const
{
  return d_holder->stringExp;
}
template <> bool Options::wasSetByUser(options::stringExp__option_t) const
{
  return d_holder->stringExp__setByUser__;
}
template <> void Options::set(
    options::stringFMF__option_t,
    const options::stringFMF__option_t::type& x)
{
  d_holder->stringFMF = x;
}
template <> const options::stringFMF__option_t::type& Options::operator[](
    options::stringFMF__option_t) const
{
  return d_holder->stringFMF;
}
template <> bool Options::wasSetByUser(options::stringFMF__option_t) const
{
  return d_holder->stringFMF__setByUser__;
}
template <> const options::stringGuessModel__option_t::type& Options::operator[](
    options::stringGuessModel__option_t) const
{
  return d_holder->stringGuessModel;
}
template <> bool Options::wasSetByUser(options::stringGuessModel__option_t) const
{
  return d_holder->stringGuessModel__setByUser__;
}
template <> const options::stringInferAsLemmas__option_t::type& Options::operator[](
    options::stringInferAsLemmas__option_t) const
{
  return d_holder->stringInferAsLemmas;
}
template <> bool Options::wasSetByUser(options::stringInferAsLemmas__option_t) const
{
  return d_holder->stringInferAsLemmas__setByUser__;
}
template <> const options::stringInferSym__option_t::type& Options::operator[](
    options::stringInferSym__option_t) const
{
  return d_holder->stringInferSym;
}
template <> bool Options::wasSetByUser(options::stringInferSym__option_t) const
{
  return d_holder->stringInferSym__setByUser__;
}
template <> const options::stringIgnNegMembership__option_t::type& Options::operator[](
    options::stringIgnNegMembership__option_t) const
{
  return d_holder->stringIgnNegMembership;
}
template <> bool Options::wasSetByUser(options::stringIgnNegMembership__option_t) const
{
  return d_holder->stringIgnNegMembership__setByUser__;
}
template <> const options::stringLazyPreproc__option_t::type& Options::operator[](
    options::stringLazyPreproc__option_t) const
{
  return d_holder->stringLazyPreproc;
}
template <> bool Options::wasSetByUser(options::stringLazyPreproc__option_t) const
{
  return d_holder->stringLazyPreproc__setByUser__;
}
template <> const options::stringLB__option_t::type& Options::operator[](
    options::stringLB__option_t) const
{
  return d_holder->stringLB;
}
template <> bool Options::wasSetByUser(options::stringLB__option_t) const
{
  return d_holder->stringLB__setByUser__;
}
template <> const options::stringLenGeqZ__option_t::type& Options::operator[](
    options::stringLenGeqZ__option_t) const
{
  return d_holder->stringLenGeqZ;
}
template <> bool Options::wasSetByUser(options::stringLenGeqZ__option_t) const
{
  return d_holder->stringLenGeqZ__setByUser__;
}
template <> const options::stringLenNorm__option_t::type& Options::operator[](
    options::stringLenNorm__option_t) const
{
  return d_holder->stringLenNorm;
}
template <> bool Options::wasSetByUser(options::stringLenNorm__option_t) const
{
  return d_holder->stringLenNorm__setByUser__;
}
template <> const options::stringLenPropCsp__option_t::type& Options::operator[](
    options::stringLenPropCsp__option_t) const
{
  return d_holder->stringLenPropCsp;
}
template <> bool Options::wasSetByUser(options::stringLenPropCsp__option_t) const
{
  return d_holder->stringLenPropCsp__setByUser__;
}
template <> const options::stringMinPrefixExplain__option_t::type& Options::operator[](
    options::stringMinPrefixExplain__option_t) const
{
  return d_holder->stringMinPrefixExplain;
}
template <> bool Options::wasSetByUser(options::stringMinPrefixExplain__option_t) const
{
  return d_holder->stringMinPrefixExplain__setByUser__;
}
template <> const options::stringOpt1__option_t::type& Options::operator[](
    options::stringOpt1__option_t) const
{
  return d_holder->stringOpt1;
}
template <> bool Options::wasSetByUser(options::stringOpt1__option_t) const
{
  return d_holder->stringOpt1__setByUser__;
}
template <> const options::stringOpt2__option_t::type& Options::operator[](
    options::stringOpt2__option_t) const
{
  return d_holder->stringOpt2;
}
template <> bool Options::wasSetByUser(options::stringOpt2__option_t) const
{
  return d_holder->stringOpt2__setByUser__;
}
template <> const options::stdPrintASCII__option_t::type& Options::operator[](
    options::stdPrintASCII__option_t) const
{
  return d_holder->stdPrintASCII;
}
template <> bool Options::wasSetByUser(options::stdPrintASCII__option_t) const
{
  return d_holder->stdPrintASCII__setByUser__;
}
template <> const options::stringProcessLoop__option_t::type& Options::operator[](
    options::stringProcessLoop__option_t) const
{
  return d_holder->stringProcessLoop;
}
template <> bool Options::wasSetByUser(options::stringProcessLoop__option_t) const
{
  return d_holder->stringProcessLoop__setByUser__;
}
template <> const options::stringRExplainLemmas__option_t::type& Options::operator[](
    options::stringRExplainLemmas__option_t) const
{
  return d_holder->stringRExplainLemmas;
}
template <> bool Options::wasSetByUser(options::stringRExplainLemmas__option_t) const
{
  return d_holder->stringRExplainLemmas__setByUser__;
}
template <> const options::stringSplitEmp__option_t::type& Options::operator[](
    options::stringSplitEmp__option_t) const
{
  return d_holder->stringSplitEmp;
}
template <> bool Options::wasSetByUser(options::stringSplitEmp__option_t) const
{
  return d_holder->stringSplitEmp__setByUser__;
}
template <> const options::stringUfReduct__option_t::type& Options::operator[](
    options::stringUfReduct__option_t) const
{
  return d_holder->stringUfReduct;
}
template <> bool Options::wasSetByUser(options::stringUfReduct__option_t) const
{
  return d_holder->stringUfReduct__setByUser__;
}


namespace options {

struct stringAbortLoop__option_t stringAbortLoop;
struct stringBinaryCsp__option_t stringBinaryCsp;
struct stringCheckEntailLen__option_t stringCheckEntailLen;
struct stringEager__option_t stringEager;
struct stringEagerLen__option_t stringEagerLen;
struct stringEIT__option_t stringEIT;
struct stringExp__option_t stringExp;
struct stringFMF__option_t stringFMF;
struct stringGuessModel__option_t stringGuessModel;
struct stringInferAsLemmas__option_t stringInferAsLemmas;
struct stringInferSym__option_t stringInferSym;
struct stringIgnNegMembership__option_t stringIgnNegMembership;
struct stringLazyPreproc__option_t stringLazyPreproc;
struct stringLB__option_t stringLB;
struct stringLenGeqZ__option_t stringLenGeqZ;
struct stringLenNorm__option_t stringLenNorm;
struct stringLenPropCsp__option_t stringLenPropCsp;
struct stringMinPrefixExplain__option_t stringMinPrefixExplain;
struct stringOpt1__option_t stringOpt1;
struct stringOpt2__option_t stringOpt2;
struct stdPrintASCII__option_t stdPrintASCII;
struct stringProcessLoop__option_t stringProcessLoop;
struct stringRExplainLemmas__option_t stringRExplainLemmas;
struct stringSplitEmp__option_t stringSplitEmp;
struct stringUfReduct__option_t stringUfReduct;


}  // namespace options
}  // namespace CVC4
