#include "sys"

#ifndef HAVE_STRNSTR
// [KK 2008-10-13] Got this from
// http://opengrok.creo.hu/dragonfly/xref/src/lib/libc/string/strnstr.c
// and it's of course for systems that don't have this lib function
// themselves
char *strnstr(const char *s, const char *find, size_t slen) {
    char c, sc;
    size_t len;

    if ((c = *find++) != '\0') {
	len = strlen(find);
	do {
	    do {
		if (slen < 1 || (sc = *s) == '\0')
		    return (0);
		--slen;
		++s;
	    } while (sc != c);
	    if (len > slen)
		return (0);
	} while (strncmp(s, find, len) != 0);
	s--;
    }
    return ( (char*) s);
}
#endif
