/**
 *    Copyright 2011 Peter Murray-Rust et. al.
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package org.xmlcml.cml.element;

import java.util.List;

import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Text;

import org.xmlcml.cml.base.CMLConstants;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLUtil;

/**
 * user-modifiable class supporting label. * autogenerated from schema use as a
 * shell which can be edited
 *
 */
public class CMLLabel extends AbstractLabel {

	/** namespaced element name.*/
	public final static String NS = C_E+TAG;

    /** used in fragment building
     *
     * @author pm286
     *
     */
    public enum Position {
        /** previous molecule */
        LEFT,
        /** next molecule */
        RIGHT,
        /** parent */
        PARENT;
    }
    /**
     * constructor.
     */
    public CMLLabel() {
    }

    /**
     * constructor.
     *
     * @param old
     */
    public CMLLabel(CMLLabel old) {
        super((AbstractLabel) old);

    }

    /**
     * copy node .
     *
     * @return Node
     */
    public Node copy() {
        return new CMLLabel(this);

    }

    /**
     * create new instance in context of parent, overridable by subclasses.
     *
     * @param parent
     *            parent of element to be constructed (ignored by default)
     * @return CMLLabel
     */
    public CMLElement makeElementInContext(Element parent) {
        return new CMLLabel();

    }

    /** gets value of a label child indicating how to join molecule.
     * only used in fragment builder
     * @param element
     * @param side
     * @return value of label
     */
    public static String getLabelValue(CMLElement element, Position side) {
        CMLLabel label = getLabel(element, side);
        return (label == null) ? null : label.getValue();
    }

    /** gets value of a label child indicating how to join molecule.
     * only used in fragment builder
     * @param element
     * @param side
     * @return label
     */
    public static CMLLabel getLabel(CMLElement element, Position side) {
        String dictRef = C_E+side;
        List<Node> nodeList = CMLUtil.getQueryNodes(
            element, CMLLabel.NS+"[@dictRef='"+dictRef+"']", CMLConstants.CML_XPATH);
        return (nodeList.size() == 0) ? null : (CMLLabel) nodeList.get(0);
    }

    /** sets value of a label child indicating how to join molecule.
     * only used in fragment builder
     * @param element
     * @param side
     * @param value
     */
    public static void setLabel(CMLElement element, Position side, String value) {
        CMLLabel label = getLabel(element, side);
        if (label == null) {
            label = new CMLLabel();
            element.appendChild(label);
            Text text = new Text(value);
            label.appendChild(text);
            label.setDictRef(C_E+side);
        } else {
            Text text = CMLUtil.getFirstTextDescendant(label);
            text.setValue(value);
        }
    }


    /** unsets label child indicating how to join molecule.
     * only used in fragment builder
     * @param element
     * @param side
     */
    public static void removeLabel(CMLElement element, Position side) {
        CMLLabel label = getLabel(element, side);
        if (label != null) {
            label.detach();
        }
    }


}

