/* === This file is part of Calamares - <https://calamares.io> ===
 *
 *   SPDX-FileCopyrightText: 2019-2020 Adriaan de Groot <groot@kde.org>
 *   SPDX-License-Identifier: GPL-3.0-or-later
 *
 *
 *   Calamares is Free Software: see the License-Identifier above.
 *
 *
 */

#ifndef UTILS_ENTROPY_H
#define UTILS_ENTROPY_H

#include "DllMacro.h"

#include <QByteArray>

namespace CalamaresUtils
{
/// @brief Which entropy source was actually used for the entropy.
enum class EntropySource
{
    None,  ///< Buffer is empty, no random data
    URandom,  ///< Read from /dev/urandom
    Twister  ///< Generated by pseudo-random
};

/** @brief Fill buffer @p b with exactly @p size random bytes
 *
 * The array is cleared and resized, then filled with 0xcb
 * "just in case", after which it is filled with random
 * bytes from a suitable source. Returns which source was used.
 */
DLLEXPORT EntropySource getEntropy( int size, QByteArray& b );

/** @brief Fill string @p s with exactly @p size random printable ASCII characters
 *
 * The characters are picked from a set of 64 (2^6). The string
 * contains 6 * size bits of entropy. * Returns which source was used.
 * @see getEntropy
 */
DLLEXPORT EntropySource getPrintableEntropy( int size, QString& s );
}  // namespace CalamaresUtils

#endif
