;; sdicf-client.el ---- -*- Emacs-Lisp -*- Library to search SDIC form dictionary.
;; $Id: sdicf-client.el,v 1.4 2002/07/02 11:17:46 tsuchiya Exp $

;; Copyright (C) 1998,99 TSUCHIYA Masatoshi <tsuchiya@namazu.org>

;; Author: TSUCHIYA Masatoshi <tsuchiya@namazu.org>
;; Keywords: dictionary

;; This file is part of SDIC.

;; SDIC is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.

;; SDIC is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SDIC; if not, write to the Free Software Foundation,
;; Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


;;; Commentary:

;; SDIC μ sdicf.el ѤƸ饤֥Ǥ


;;; Install:

;; (1) ŬڤʷѴơŬʾ( : /usr/dict/ )¸
;;     ƲѴѥץȤȤưʲ Perl ץȤ
;;     ѤǤޤ
;;
;;         gene.perl    - GENE95 
;;         edict.perl   - EDICT 
;;         eijirou.perl - ѼϺ
;;
;; (2) Ȥ褦ˤ sdic-eiwa-dictionary-list ޤ
;;      sdic-waei-dictionary-list ɲäƲ
;;
;;         (setq sdic-eiwa-dictionary-list
;;               (cons '(sdicf-client "/usr/dict/gene.dic") sdic-eiwa-dictionary-list))
;;
;;     ϼΤ褦ʹˤʤäƤޤ
;;
;;         (sdicf-client ե̾ (ץA A) (ץB B) ...)
;;
;;     ̤ʻ꤬פʾˤϡץϾάǤޤ
;;
;;         (sdicf-client ե̾)


;;; Options:

;; sdicf-client.el ФƻǤ륪ץϼ̤Ǥ
;;
;; coding-system
;;     δɤꤷޤάϡ
;;     sdic-default-coding-system ͤȤޤ
;;
;; title
;;     Υȥꤷޤάϡե 
;;     basename 򥿥ȥȤޤ
;;
;; add-keys-to-headword
;;     ƤθޤƸФ t ꤷƲ
;;     ±Ѽ򸡺ˡ겾̾ޤƽϤ
;;     Ѥޤ
;;
;; strategy
;;     sdicf.el ̤Ƽ򸡺 strategy ꤷޤά
;;     ϡsdicf.el μưȽˤäФ줿 strategy 
;;     ޤ


;;; Note;

;; sdicf.el  SDIC μ򸡺뤿Υ饤֥Ǥ줾
;; ΰ㤤ϼ̤Ǥ3 strategy ݡȤƤޤ
;;
;; `direct'
;;     ǡƥɤ߹Ǥ鸡Ԥޤ
;;     ɤɬפȤޤ󤬡̤Υ꤬ɬפˤʤޤ
;;
;; `grep'
;;     fgrep ѤƸԤޤ
;;
;; `array'
;;     array ѤƸԤޤ index file 
;;     ƤƤ鸡ԤޤΤǡ®˸ǽǤ
;;     index file ϼ3٤礭ˤʤޤ
;;
;; ŪϤμ򸡺 `grep' ŬǤ礦
;; 5MByte 礭ξ `array' Ѥθ٤Ȼפ
;; 
;;
;; SDIC μι¤ˤĤƤϡsdic.texi 򻲾ȤƤ


;;; 饤֥
(require 'sdic)
(require 'sdicf)
(provide 'sdicf-client)
(put 'sdicf-client 'version "2.0")
(put 'sdicf-client 'init-dictionary 'sdicf-client-init-dictionary)
(put 'sdicf-client 'open-dictionary 'sdicf-client-open-dictionary)
(put 'sdicf-client 'close-dictionary 'sdicf-client-close-dictionary)
(put 'sdicf-client 'search-entry 'sdicf-client-search-entry)
(put 'sdicf-client 'get-content 'sdicf-client-get-content)



;;;----------------------------------------------------------------------
;;;		
;;;----------------------------------------------------------------------

(defun sdicf-client-init-dictionary (file-name &rest option-list)
  "Function to initialize dictionary"
  (let ((dic (sdic-make-dictionary-symbol)))
    (if (file-readable-p (setq file-name (expand-file-name file-name)))
	(progn
	  (mapcar (lambda (c) (put dic (car c) (nth 1 c))) option-list)
	  (put dic 'file-name file-name)
	  (put dic 'identifier (concat "sdicf-client+" file-name))
	  (or (get dic 'title)
	      (put dic 'title (file-name-nondirectory file-name)))
	  (or (get dic 'coding-system)
	      (put dic 'coding-system sdic-default-coding-system))
	  dic)
      (error "Can't read dictionary: %s" (prin1-to-string file-name)))))


(defun sdicf-client-open-dictionary (dic)
  "Function to open dictionary"
  (if (put dic 'sdic-object
	   (sdicf-open (get dic 'file-name) (get dic 'coding-system) (get dic 'strategy)))
      dic))


(defun sdicf-client-close-dictionary (dic)
  "Function to close dictionary"
  (if (get dic 'sdic-object) (sdicf-close (get dic 'sdic-object))))


(defun sdicf-client-search-entry (dic string &optional search-type) "\
Function to search word with look or grep, and write results to current buffer.
search-type ͤˤäƼΤ褦ưѹ롣
    nil    : ׸
    t      : ׸
    lambda : ׸
    0      : ʸ
̤ȤƸĤäФ򥭡ȤʸƬ point ͤȤ
Ϣ֤
"
  (let ((case-fold-search t) list)
    (mapcar (if (get dic 'add-keys-to-headword)
		(lambda (entry)
		  (setq list (sdicf-entry-keywords entry))
		  (cons (if (= (length list) 1)
			    (car list)
			  (apply 'concat
				 (car list)
				 " "
				 (mapcar (lambda (s) (format "[%s]" s)) (cdr list))))
			entry))
	      (lambda (entry)
		(cons (sdicf-entry-headword entry) entry)))
	    (sdicf-search (get dic 'sdic-object)
			  (cond
			   ((not search-type) 'prefix)
			   ((eq search-type t) 'suffix)
			   ((eq search-type 'lambda) 'exact)
			   ((eq search-type 0) 'text)
			   (t (error "Illegal search method : %S" search-type)))
			  string))))


(defun sdicf-client-get-content (dic entry)
  (sdicf-entry-text entry))
