/*###############################################################################
# Linux Management Providers (LMP), EthernetPort provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#include "OpenDRIM_LANEndpointAccess.h"

static const string systemCreationClassName = "OpenDRIM_ComputerSystem";
static const string creationClassName = "OpenDRIM_LANEndpoint";
static string systemName;

int EthernetPort_OpenDRIM_LANEndpoint_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	CF_assert(CF_getSystemName(systemName, errorMessage));
	_L_;
	return OK;
}

int EthernetPort_OpenDRIM_LANEndpoint_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int EthernetPort_OpenDRIM_LANEndpoint_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_LANEndpoint>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	vector<string> eth_names;

	CF_assert(CF_getEthernetPortNames(eth_names, errorMessage));

	//Initialize an instance
	OpenDRIM_LANEndpoint instance;
	instance.setSystemCreationClassName(systemCreationClassName);
	instance.setSystemName(systemName);
	instance.setCreationClassName(creationClassName);

	for(unsigned int i=0;i<eth_names.size();i++)
	{
		if (!CF_startsWith(eth_names[i], "eth")) continue;

		instance.setName(eth_names[i]);
		if (discriminant == "ei")
			CF_assert(EthernetPort_OpenDRIM_LANEndpoint_populate(instance, errorMessage));
		result.push_back(instance);
	}
	_L_;
	return OK;
}

int EthernetPort_OpenDRIM_LANEndpoint_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_LANEndpoint& instance, const char** properties, string& errorMessage) {
	_E_;
	vector<string> eth_names;
	vector<string>::size_type index;

	CF_assert(CF_getEthernetPortNames(eth_names, errorMessage));

	if(	instance.SystemCreationClassName == systemCreationClassName &&
		instance.CreationClassName == creationClassName &&
		instance.SystemName == systemName &&
		CF_foundInList(instance.Name,eth_names,index))
	{
		CF_assert(EthernetPort_OpenDRIM_LANEndpoint_populate(instance, errorMessage));
	}
	else
	{
		errorMessage = "No instance";
		return NOT_FOUND;
	}
	_L_;
	return OK;
}

int EthernetPort_OpenDRIM_LANEndpoint_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_LANEndpoint& newInstance, const OpenDRIM_LANEndpoint& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int EthernetPort_OpenDRIM_LANEndpoint_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_LANEndpoint& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int EthernetPort_OpenDRIM_LANEndpoint_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_LANEndpoint& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int EthernetPort_OpenDRIM_LANEndpoint_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_LANEndpoint& instance, unsigned int& returnValue, const OpenDRIM_LANEndpoint_RequestStateChange_In& in, OpenDRIM_LANEndpoint_RequestStateChange_Out& out, string& errorMessage) {
	_E_;
	// Conditional requirement, so not yet supported
	_L_;
	return NOT_SUPPORTED;
}

int EthernetPort_OpenDRIM_LANEndpoint_BroadcastReset(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_LANEndpoint& instance, unsigned int& returnValue, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int EthernetPort_OpenDRIM_LANEndpoint_populate(OpenDRIM_LANEndpoint& instance, string& errorMessage) {
	_E_;
	/*
	 * Properties to fill from profile
	 * + Mandatory:
	 * [X] SystemCreationClassName  [KEY]
	 * [X] CreationClassName        [KEY]
	 * [X] SystemName               [KEY]
	 * [X] Name                     [KEY]
	 * [X] NameFormat
	 * [X] ProtocolIFType
	 * [X] MACAddress
	 * [X] RequestedState
	 * [X] EnabledState
	 * [X] ElementName
	 * + Optional:
	 * [-] LANID
	 * [-] AliasAddresses
	 * [-] GroupAddresses
	 * + Others:
	 * [X] LANType
	 */

	string macaddr;
	unsigned int enabledState;
	unsigned int index;

	instance.setNameFormat("network-interface-name");

	instance.setLANType(LEPT_ETHERNET);
	instance.setProtocolIFType(LEPIT_ETHERNET);

	// Setting the MAC Address
	CF_getHWaddress(instance.Name,macaddr,errorMessage);
	macaddr=CF_removeChar(macaddr,":\n");
	instance.setMACAddress(macaddr);

	// Setting RequestedState as Not applicable,
	// as far as the RequestStateChange method is Not Supported.
	// (see: Network Port Profile)
	instance.setRequestedState(RS_NOT_APPLICABLE);

	// Setting EnabledState
	CF_getEthEnabledState(instance.Name,enabledState,errorMessage);
	instance.setEnabledState(enabledState);

	// Setting the ElementName
	instance.setElementName("Ethernet Interface " + instance.Name + " LAN Endpoint");

	// Setting the ElementName
	index=instance.Name.find_first_of("0123456789");
	if(index!=string::npos)
		instance.setElementName("Ethernet Interface " +
								instance.Name.substr(index,instance.Name.length()-index) +
								" LAN Endpoint");
	else
		instance.setElementName("Ethernet Interface LAN Endpoint");
	_L_;
	return OK;
}
