/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.pinclone;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.debug.internal.ui.pinclone.PinCloneUtils;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.WorkbenchJob;

public final class ViewIDCounterManager {
    private static ViewIDCounterManager INSTANCE;
    private static boolean fInitialized;
    private boolean fShuttingDown = false;
    private final Map<String, Set<Integer>> viewIdToNextCounterMap = Collections.synchronizedMap(new HashMap());

    static {
        fInitialized = false;
    }

    private ViewIDCounterManager() {
        this.initListeners();
    }

    public static synchronized ViewIDCounterManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ViewIDCounterManager();
        }
        return INSTANCE;
    }

    public synchronized void init() {
        if (fInitialized) {
            return;
        }
        fInitialized = true;
        new WorkbenchJob("Initializing pinnable view"){
            {
                this.setSystem(true);
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbenchWindow[] windows;
                IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                int n = windows.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewReference[] viewRefs;
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    IViewReference[] iViewReferenceArray = viewRefs = window.getActivePage().getViewReferences();
                    int n3 = viewRefs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IViewReference viewRef = iViewReferenceArray[n4];
                        try {
                            IViewPart part;
                            if (PinCloneUtils.isClonedPart(viewRef)) {
                                String id = viewRef.getId();
                                String secondaryId = viewRef.getSecondaryId();
                                HashSet<Integer> secondaryIdSet = (HashSet<Integer>)ViewIDCounterManager.this.viewIdToNextCounterMap.get(id);
                                if (secondaryIdSet == null) {
                                    secondaryIdSet = new HashSet<Integer>();
                                    ViewIDCounterManager.this.viewIdToNextCounterMap.put(id, secondaryIdSet);
                                }
                                secondaryId = PinCloneUtils.decodeClonedPartSecondaryId(secondaryId);
                                secondaryIdSet.add(Integer.valueOf(secondaryId));
                            }
                            if ((part = viewRef.getView(false)) != null && PinCloneUtils.isClonedPart(part)) {
                                PinCloneUtils.setPartTitle(part);
                            }
                        }
                        catch (Exception e) {
                            CDebugUIPlugin.log(e);
                        }
                        ++n4;
                    }
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void initListeners() {
        try {
            IWorkbench wb = PlatformUI.getWorkbench();
            wb.addWorkbenchListener(new IWorkbenchListener(){

                public void postShutdown(IWorkbench workbench) {
                }

                public boolean preShutdown(IWorkbench workbench, boolean forced) {
                    ViewIDCounterManager.this.fShuttingDown = true;
                    return true;
                }
            });
            final IPartListener2 partListener = new IPartListener2(){

                public void partVisible(IWorkbenchPartReference partRef) {
                }

                public void partInputChanged(IWorkbenchPartReference partRef) {
                }

                public void partHidden(IWorkbenchPartReference partRef) {
                }

                public void partDeactivated(IWorkbenchPartReference partRef) {
                }

                public void partBroughtToTop(IWorkbenchPartReference partRef) {
                }

                public void partActivated(IWorkbenchPartReference partRef) {
                }

                public void partOpened(IWorkbenchPartReference partRef) {
                    IViewPart part;
                    if (partRef instanceof IViewReference && (part = ((IViewReference)partRef).getView(false)) != null && PinCloneUtils.isClonedPart(part)) {
                        PinCloneUtils.setPartTitle(part);
                    }
                }

                public void partClosed(IWorkbenchPartReference partRef) {
                    if (!ViewIDCounterManager.this.fShuttingDown) {
                        ViewIDCounterManager.this.recycleCounterId(partRef);
                    }
                }
            };
            IWorkbenchWindow[] iWorkbenchWindowArray = wb.getWorkbenchWindows();
            int n = iWorkbenchWindowArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow ww = iWorkbenchWindowArray[n2];
                ww.getPartService().addPartListener(partListener);
                ++n2;
            }
            wb.addWindowListener(new IWindowListener(){

                public void windowDeactivated(IWorkbenchWindow window) {
                }

                public void windowActivated(IWorkbenchWindow window) {
                }

                public void windowClosed(IWorkbenchWindow window) {
                }

                public void windowOpened(IWorkbenchWindow window) {
                    window.getPartService().addPartListener(partListener);
                }
            });
        }
        catch (Exception e) {
            CDebugUIPlugin.log(e);
        }
    }

    private void recycleCounterId(IWorkbenchPartReference partRef) {
        if (partRef instanceof IViewReference) {
            Set<Integer> secondaryIdSet;
            IViewReference viewRef = (IViewReference)partRef;
            IWorkbenchPart part = viewRef.getPart(false);
            if (!(part instanceof IViewPart) || !PinCloneUtils.isClonedPart((IViewPart)part)) {
                return;
            }
            String viewId = viewRef.getId();
            String secondaryId = viewRef.getSecondaryId();
            if (secondaryId != null && (secondaryIdSet = this.viewIdToNextCounterMap.get(viewId)) != null) {
                secondaryIdSet.remove(new Integer(PinCloneUtils.decodeClonedPartSecondaryId(secondaryId)));
            }
        }
    }

    public Integer getNextCounter(String viewId) {
        Set<Integer> secondaryIdSet = this.viewIdToNextCounterMap.get(viewId);
        if (secondaryIdSet == null) {
            secondaryIdSet = new HashSet<Integer>();
            this.viewIdToNextCounterMap.put(viewId, secondaryIdSet);
        }
        int i = 1;
        while (i < Integer.MAX_VALUE) {
            Integer next = new Integer(i);
            if (!secondaryIdSet.contains(next)) {
                secondaryIdSet.add(next);
                return next;
            }
            ++i;
        }
        return 0;
    }
}

