/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odaconsumer.ExceptionHandler;
import org.eclipse.birt.data.engine.odaconsumer.LogHelper;
import org.eclipse.datatools.connectivity.oda.IDriver;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaDriver;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;

class Driver {
    private String m_dataSourceDriverId;
    private ExtensionManifest m_driverConfig;
    private IDriver m_driverHelper;
    private static final String sm_className = Driver.class.getName();
    private static final String sm_loggerName = "org.eclipse.birt.data.engine.odaconsumer";
    private static LogHelper sm_logger = LogHelper.getInstance("org.eclipse.birt.data.engine.odaconsumer");

    Driver(String dataSourceElementId) {
        sm_logger.entering(sm_className, "Driver", dataSourceElementId);
        this.m_dataSourceDriverId = dataSourceElementId;
        sm_logger.exiting(sm_className, "Driver", this);
    }

    ExtensionManifest getExtensionConfig() throws DataException {
        ExtensionManifest driverManifest = this.getDriverExtensionConfig();
        assert (driverManifest != null);
        return driverManifest;
    }

    ExtensionManifest getDriverExtensionConfig() throws DataException {
        if (this.m_driverConfig != null) {
            return this.m_driverConfig;
        }
        this.findDataSourceExtensionConfig();
        assert (this.m_driverConfig != null);
        return this.m_driverConfig;
    }

    IDriver getDriverHelper() throws DataException {
        if (this.m_driverHelper == null) {
            this.m_driverHelper = this.createNewDriverHelper(null);
        }
        return this.m_driverHelper;
    }

    IDriver createNewDriverHelper(Map<?, ?> appContext) throws DataException {
        try {
            return new OdaDriver(this.getExtensionConfig(), appContext);
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "createNewDriverHelper(Map)", "Cannot get ODA data source driver helper.", ex);
            throw ExceptionHandler.newException("odaconsumer.OdaInitEntryNotFound", new Object[]{this.m_dataSourceDriverId}, ex);
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "createNewDriverHelper(Map)", "Cannot get ODA data source driver factory.", ex);
            throw ExceptionHandler.newException("odaconsumer.OdaInitEntryNotFound", new Object[]{this.m_dataSourceDriverId}, ex);
        }
    }

    private void findDataSourceExtensionConfig() throws DataException {
        this.m_driverConfig = null;
        this.m_driverConfig = this.doGetDriverManifest(this.m_dataSourceDriverId, true, true);
    }

    private ExtensionManifest doGetDriverManifest(String dataSourceDriverId, boolean useDtpExtPoint, boolean throwsIfNotFound) throws DataException {
        ManifestExplorer explorer = ManifestExplorer.getInstance();
        try {
            if (useDtpExtPoint) {
                return explorer.getExtensionManifest(dataSourceDriverId);
            }
            if (throwsIfNotFound) {
                throw new IllegalArgumentException(dataSourceDriverId);
            }
            return null;
        }
        catch (Exception ex) {
            if (useDtpExtPoint && ex instanceof IllegalArgumentException && !throwsIfNotFound) {
                return null;
            }
            return this.throwConfigException("doGetDriverManifest", dataSourceDriverId, ex);
        }
    }

    private ExtensionManifest throwConfigException(String methodName, String dataSourceDriverId, Throwable cause) throws DataException {
        sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot find or process the ODA data source extension configuration.", cause);
        throw ExceptionHandler.newException("odaconsumer.CannotProcessDriverConfig", new Object[]{dataSourceDriverId}, cause);
    }
}

