/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import java.util.function.Supplier;

public class Lazy<T> {
    private final Supplier<T> initializer;
    private boolean isInitialized = false;
    private T instance;

    public Lazy(Supplier<T> initializer) {
        this.initializer = initializer;
    }

    public synchronized T get() {
        if (!this.isInitialized) {
            this.instance = this.initializer.get();
            this.isInitialized = true;
        }
        return this.instance;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    @FunctionalInterface
    @Deprecated
    public static interface LazyInitializer<T>
    extends Supplier<T> {
        public T make();

        @Override
        default public T get() {
            return this.make();
        }
    }
}

