#!/bin/csh
#		drawgram <treefile> <type>
#	<type> = dat, xbm, ps, pdf, new, gif
# 'draw' the tree to a file using phylip program drawgram
#	"fontfile" must be in the current directory

# make a file with responses to drawgram interactive questions
# tree format to be Postscript

#    echo "L"         >  "drawgram.$$" # L - 'Laserwriter => Postscript'
#    echo "N"         >> "drawgram.$$" # N - No preview
#    echo "1"         >> "drawgram.$$" # Tree growth, toggle to horizontal
#    echo "2"         >> "drawgram.$$" # Style of tree
#    echo "P"         >> "drawgram.$$" # P for Phenogram style
#    echo "4"         >> "drawgram.$$" # Angle of labels
#    echo "90"        >> "drawgram.$$" # labels 90 degrees to the tree
#    echo "8"         >> "drawgram.$$" # Stem-length/tree-depth
#    echo "0"         >> "drawgram.$$" # 0 stem won't show
#    echo "Y"         >> "drawgram.$$" # Y(es) to accept choices 

unalias cp
unalias rm
unalias mv

setenv GS_LIB /opt/sfw/share/ghostscript
setenv LD_LIBRARY_PATH /usr/openwin/lib:/usr/dt/lib:/usr/lib:/usr/ucblib:/opt/sfw/lib:/usr/local/lib

set path = ($path /opt/sfw/bin)

if ( ! (-e $1) ) then
   echo "Content-type: text/html"
   echo ""
   echo "Tree file $1 not found"
   exit(-1)
endif

set clerr=`grep -c "failed to make a tree" $1`
if ( $clerr > 0) then
   echo "Content-type: text/html"
   echo ""
#  echo "Tree Error: clustalw failed to make a tree"
   echo "<PRE>"
   cat "$1"
   exit(-1)
endif

if ( ($#argv < 2) || ($2 == "dat")) then
   echo "Content-type: text/html"
   echo ""
   echo "<PRE>"
   cat "$1"
   exit(0)
endif

if ($2 == "new") then
   echo "Content-type: application/newick"
   echo ""
   cat "$1"
   exit(0)
endif

#  NOTE:  Used to "mv $1 treefile.$$" so it gets deleted at end, but if
#         do that user can't hit the tree button again
if ( -e "fontfile" ) then
   cp "$1" "treefile.$$"
   if ($2 == "ps" || $2 == "pdf") then
      set plotname = ../tmp/$$.ps
      ./drawgram $$ < "drawgram.ps.in" > /dev/null
   else
      set plotname = ../tmp/$$.xbm
      ./drawgram $$ < "drawgram.xbm.in" > /dev/null
   endif
   rm "treefile.$$"

   if ( -e "plotfile.$$" ) then
      mv plotfile.$$ $plotname
      if ($2 == "ps") then
         echo "Content-type: application/postscript"
         echo ""
         cat $plotname
      else
         if ($2 == "pdf") then
            echo "Content-type: application/pdf"
            echo ""
#           convert -sharpen 80 $plotname ../tmp/$$.pdf
            convert $plotname ../tmp/$$.pdf
            cat ../tmp/$$.pdf
#           cat $plotname | /muller/Acrobat3/bin/distill -noprefs -compatlevel 2.1
         else
            if ($2 == "gif") then
               echo "Content-type: image/gif"
               echo ""
#              convert -sharpen 80 $plotname ../tmp/$$.gif
               convert $plotname ../tmp/$$.gif
               cat ../tmp/$$.gif
            else
               echo "Content-type: image/x-xbitmap"
               echo ""
               cat $plotname
            endif
         endif
      endif
   else
      echo "Content-type: text/html"
      echo ""
      echo "Tree Error: drawgram produced no plotfile"
   endif
   rm -f *.$$ $plotname >& /dev/null
else
   echo Content-type: text/html
   echo
   echo "Tree Error: drawgram needs fontfile"
endif

exit(0)

