/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.client;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.UIObject;

public class UiBinderUtil {
    private static Element hiddenDiv;

    public static TempAttachment attachToDom(Element element) {
        UiBinderUtil.ensureHiddenDiv();
        Element origParent = element.getParentElement();
        Element origSibling = element.getNextSiblingElement();
        hiddenDiv.appendChild(element);
        return new TempAttachment(origParent, origSibling, element);
    }

    public static Element fromHtml(String html) {
        UiBinderUtil.ensureHiddenDiv();
        hiddenDiv.setInnerHTML(html);
        Element newbie = hiddenDiv.getFirstChildElement();
        UiBinderUtil.orphan(newbie);
        return newbie;
    }

    private static void ensureHiddenDiv() {
        if (hiddenDiv == null) {
            hiddenDiv = Document.get().createDivElement();
            UIObject.setVisible(hiddenDiv, false);
            RootPanel.getBodyElement().appendChild(hiddenDiv);
        }
    }

    private static void orphan(Node node) {
        node.getParentNode().removeChild(node);
    }

    private UiBinderUtil() {
    }

    public static class TempAttachment {
        private final Element element;
        private final Element origParent;
        private final Element origSibling;

        private TempAttachment(Element origParent, Element origSibling, Element element) {
            this.origParent = origParent;
            this.origSibling = origSibling;
            this.element = element;
        }

        public void detach() {
            if (this.origParent != null) {
                this.origParent.insertBefore(this.element, this.origSibling);
            } else {
                UiBinderUtil.orphan(this.element);
            }
        }
    }
}

