/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "km" locale.
 */
public class LocalizedNamesImpl_km extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "KH",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AG",
        "AI",
        "AN",
        "AQ",
        "AS",
        "AW",
        "AX",
        "BL",
        "BM",
        "BV",
        "CC",
        "CD",
        "CK",
        "CP",
        "CX",
        "DG",
        "EA",
        "EU",
        "FK",
        "FO",
        "GB",
        "GD",
        "GF",
        "GG",
        "GI",
        "GL",
        "GP",
        "GS",
        "GU",
        "HM",
        "IC",
        "IM",
        "IO",
        "JE",
        "KN",
        "KY",
        "LC",
        "ME",
        "MF",
        "MH",
        "MO",
        "MP",
        "MQ",
        "MS",
        "MV",
        "MW",
        "NC",
        "NF",
        "NR",
        "NU",
        "PF",
        "PM",
        "PN",
        "PW",
        "QO",
        "RE",
        "RS",
        "SB",
        "SH",
        "SJ",
        "SM",
        "ST",
        "TA",
        "TC",
        "TF",
        "TK",
        "TV",
        "UM",
        "VC",
        "VG",
        "VI",
        "VU",
        "WF",
        "YT",
        "KH",
        "CA",
        "QA",
        "CV",
        "CM",
        "KZ",
        "CG",
        "KM",
        "CI",
        "CR",
        "CO",
        "KE",
        "GR",
        "HR",
        "KI",
        "CU",
        "KW",
        "KG",
        "CN",
        "TD",
        "JP",
        "CL",
        "DK",
        "DM",
        "NA",
        "TZ",
        "TJ",
        "TO",
        "TG",
        "TW",
        "TH",
        "TL",
        "TN",
        "TM",
        "TR",
        "TT",
        "NI",
        "NE",
        "NG",
        "NZ",
        "NP",
        "NO",
        "BD",
        "BB",
        "FR",
        "BH",
        "BS",
        "BW",
        "BO",
        "BA",
        "BJ",
        "BZ",
        "BY",
        "BE",
        "PK",
        "PA",
        "PG",
        "PY",
        "PS",
        "PL",
        "PE",
        "BG",
        "BT",
        "BF",
        "BI",
        "BN",
        "BR",
        "PR",
        "PT",
        "FM",
        "MM",
        "MG",
        "MA",
        "ML",
        "MY",
        "MT",
        "MK",
        "MX",
        "MN",
        "MC",
        "MR",
        "MU",
        "MZ",
        "YE",
        "RW",
        "RO",
        "RU",
        "LI",
        "LT",
        "LB",
        "LR",
        "LY",
        "LU",
        "LS",
        "VN",
        "VE",
        "VA",
        "US",
        "KR",
        "CZ",
        "DO",
        "KP",
        "MD",
        "CF",
        "WS",
        "EH",
        "SG",
        "SC",
        "SO",
        "SR",
        "SZ",
        "SN",
        "SL",
        "CY",
        "SY",
        "SE",
        "SD",
        "LK",
        "SI",
        "SK",
        "CH",
        "HK",
        "HU",
        "HN",
        "NL",
        "HT",
        "JO",
        "GH",
        "GT",
        "GA",
        "GM",
        "GN",
        "GW",
        "GQ",
        "GY",
        "FI",
        "PH",
        "FJ",
        "GE",
        "JM",
        "ZM",
        "DJ",
        "ZW",
        "LV",
        "LA",
        "AO",
        "AD",
        "AM",
        "SA",
        "AL",
        "DZ",
        "DE",
        "AZ",
        "AF",
        "ZA",
        "AR",
        "AT",
        "OM",
        "AU",
        "IE",
        "EC",
        "ET",
        "AE",
        "ER",
        "EE",
        "ES",
        "EG",
        "SV",
        "IS",
        "IT",
        "IR",
        "IQ",
        "IL",
        "UA",
        "UY",
        "UG",
        "UZ",
        "IN",
        "ID",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AD", "អានដូរ៉ា");
    namesMap.put("AE", "អេមីរ៉ែទអារ៉ាប់រួម");
    namesMap.put("AF", "អាហ្វហ្គានីស្ថាន");
    namesMap.put("AL", "អាល់បានី");
    namesMap.put("AM", "អារមេនី");
    namesMap.put("AO", "អង់ហ្គោឡា");
    namesMap.put("AR", "អាហ្សង់ទីន");
    namesMap.put("AT", "អូទ្រីស");
    namesMap.put("AU", "អូស្ត្រាលី");
    namesMap.put("AZ", "អាហ៊្សែរបែហ្សង់");
    namesMap.put("BA", "បូស្ន៉ី");
    namesMap.put("BB", "បារបាដូស");
    namesMap.put("BD", "បង់ក្លាដេស្ហ");
    namesMap.put("BE", "បែលហ្ស៉ិក");
    namesMap.put("BF", "ប៊ូរគីណាហ្វាសូ");
    namesMap.put("BG", "ប៊ុលហ្គារី");
    namesMap.put("BH", "បារ៉ែន");
    namesMap.put("BI", "ប៊ូរុនឌី");
    namesMap.put("BJ", "បេណាំង");
    namesMap.put("BN", "ប៊្រុយណេ");
    namesMap.put("BO", "បូលីវី");
    namesMap.put("BR", "ប្រេស៊ីល");
    namesMap.put("BS", "បាហាម៉ា");
    namesMap.put("BT", "ប៊ូតាន");
    namesMap.put("BW", "បុតស្វាណា");
    namesMap.put("BY", "បេឡារុស្ស");
    namesMap.put("BZ", "បេលីហ្ស");
    namesMap.put("CA", "កាណាដា");
    namesMap.put("CF", "សាធារណរដ្ឋអាហ្វ្រិកកណ្ដាល");
    namesMap.put("CG", "កុងហ្គោ");
    namesMap.put("CH", "ស្វីស");
    namesMap.put("CI", "កូដឌីវ័រ");
    namesMap.put("CL", "ឈីលី");
    namesMap.put("CM", "កាមេរូន");
    namesMap.put("CN", "ចិន");
    namesMap.put("CO", "កូឡុំប៊ី");
    namesMap.put("CR", "កូស្តារីកា");
    namesMap.put("CU", "គុយបា");
    namesMap.put("CV", "កាបវែរ");
    namesMap.put("CY", "ស៉ីពរ៍");
    namesMap.put("CZ", "សាធារណរដ្ឋឆេក");
    namesMap.put("DE", "អាល្លឺម៉ង់");
    namesMap.put("DJ", "ហ្ស៉ីបូទី");
    namesMap.put("DK", "ដាណឺម៉ាក");
    namesMap.put("DM", "ដូមីនីកា");
    namesMap.put("DO", "សាធារណរដ្ឋដូមីនីកែន");
    namesMap.put("DZ", "អាល់ហ្សេរី");
    namesMap.put("EC", "អេក្វាឌ័រ");
    namesMap.put("EE", "អេស្តូនី");
    namesMap.put("EG", "អេហ្ស៉ីប");
    namesMap.put("EH", "សាហារ៉ាខាងលិច");
    namesMap.put("ER", "អេរីទ្រា");
    namesMap.put("ES", "អេស្ប៉ាញ");
    namesMap.put("ET", "អេត្យូពី");
    namesMap.put("FI", "ហ្វាំងឡង់");
    namesMap.put("FJ", "ហ្វ៉ីហ្ស៉ី");
    namesMap.put("FM", "មិក្រូនេស៊ី");
    namesMap.put("FR", "បារាំង");
    namesMap.put("GA", "ហ្គាបុង");
    namesMap.put("GE", "ហ្សកហ្ស៉ី");
    namesMap.put("GH", "ហ្កាណា");
    namesMap.put("GM", "ហ្គាំប៊ី");
    namesMap.put("GN", "ហ្គីណេ");
    namesMap.put("GQ", "ហ្គីណេអេក្វាទ័រ");
    namesMap.put("GR", "ក្រិច");
    namesMap.put("GT", "ហ្គាតេម៉ាឡា");
    namesMap.put("GW", "ហ្គីណេប៊ីសូ");
    namesMap.put("GY", "ហ្គីយ៉ាណា");
    namesMap.put("HK", "ហុងកុង");
    namesMap.put("HN", "ហុងឌួរ៉ាស់");
    namesMap.put("HR", "ក្រូអាស៊ី");
    namesMap.put("HT", "ហៃទី");
    namesMap.put("HU", "ហុងគ្រី");
    namesMap.put("ID", "ឥណ្ឌូនេស៊ី");
    namesMap.put("IE", "អៀរឡង់");
    namesMap.put("IL", "អ៊ីស្រាអែល");
    namesMap.put("IN", "ឥណ្ឌា");
    namesMap.put("IQ", "អ៊ីរ៉ាក់");
    namesMap.put("IR", "អ៊ីរ៉ង់");
    namesMap.put("IS", "អ៉ីស្លង់");
    namesMap.put("IT", "អ៊ីតាលី");
    namesMap.put("JM", "ហ្សាម៉ាអ៉ិគ");
    namesMap.put("JO", "ហ៊្សកដានី");
    namesMap.put("JP", "ជប៉ុន");
    namesMap.put("KE", "កេនយ៉ា");
    namesMap.put("KG", "គៀរហ្គីស្តង់");
    namesMap.put("KH", "កម្ពុជា");
    namesMap.put("KI", "គិរិបាទី");
    namesMap.put("KM", "កុំម៉ូរ៉ូស");
    namesMap.put("KP", "សាធារណរដ្ឋប្រជាធិបតេយ្យប្រជាមានិតកូរ៉េ");
    namesMap.put("KR", "សាធារណរដ្ឋកូរ៉េ");
    namesMap.put("KW", "គុយវ៉ែត");
    namesMap.put("KZ", "កាហ្សាក់ស្តាង់់");
    namesMap.put("LA", "ឡាវ");
    namesMap.put("LB", "លីបង់");
    namesMap.put("LI", "លិចទេនស្តែន");
    namesMap.put("LK", "ស្រីលង្កា");
    namesMap.put("LR", "លីបេរីយ៉ា");
    namesMap.put("LS", "លើសូតូ");
    namesMap.put("LT", "លីទុយអានី");
    namesMap.put("LU", "លុចហ្សំបួរ");
    namesMap.put("LV", "ឡាតវីយ៉ា");
    namesMap.put("LY", "លីប៊ី");
    namesMap.put("MA", "ម៉ារ៉ុក");
    namesMap.put("MC", "ម៉ូណាកូ");
    namesMap.put("MD", "សាធារណរដ្ឋម៉ុលដាវី");
    namesMap.put("MG", "ម៉ាដាហ្កាស្ការ");
    namesMap.put("MK", "ម៉ាសេដន");
    namesMap.put("ML", "ម៉ាលី");
    namesMap.put("MM", "មីយ៉ាន់ម៉ា");
    namesMap.put("MN", "ម៉ុងហ្គោលី");
    namesMap.put("MR", "ម៉ូរីតានី");
    namesMap.put("MT", "ម៉ាល់តា");
    namesMap.put("MU", "ម៉ូរីទុស");
    namesMap.put("MX", "ម៉ិចសិក");
    namesMap.put("MY", "ម៉ាលេស៉ី");
    namesMap.put("MZ", "ម៉ូហ្សាំប៊ិក");
    namesMap.put("NA", "ណាមីប៊ី");
    namesMap.put("NE", "នីហ្សេរ");
    namesMap.put("NG", "នីហ្សេរីយ៉ា");
    namesMap.put("NI", "នីការ៉ាហ្គ័រ");
    namesMap.put("NL", "ហូល្លង់");
    namesMap.put("NO", "ន័រវែស");
    namesMap.put("NP", "នេប៉ាល់");
    namesMap.put("NZ", "នូវែលហ្សេឡង់");
    namesMap.put("OM", "អូម៉ង់");
    namesMap.put("PA", "ប៉ាណាម៉ា");
    namesMap.put("PE", "ប៉េរូ");
    namesMap.put("PG", "ប៉ាពូអានូវែលហ្គីណេ");
    namesMap.put("PH", "ហ្វ៉ីលីពីន");
    namesMap.put("PK", "ប៉ាគីស្ថាន");
    namesMap.put("PL", "ប៉ូលូញ");
    namesMap.put("PR", "ព័រតូរីកូ");
    namesMap.put("PS", "ប៉ាលេស្ទីន");
    namesMap.put("PT", "ព័រទុយហ្កាល់");
    namesMap.put("PY", "ប៉ារ៉ាហ្គាយ");
    namesMap.put("QA", "កាតារ");
    namesMap.put("RO", "រូម៉ានី");
    namesMap.put("RU", "រូស្ស៊ី");
    namesMap.put("RW", "រវ៉ាន់ដា");
    namesMap.put("SA", "អារ៉ាប៊ីសាអ៊ូឌីត");
    namesMap.put("SC", "សីសែល");
    namesMap.put("SD", "ស៊ូដង់");
    namesMap.put("SE", "ស៊ុយអែដ");
    namesMap.put("SG", "សិង្ហបុរី");
    namesMap.put("SI", "ស្លូវេនី");
    namesMap.put("SK", "ស្លូវ៉ាគី");
    namesMap.put("SL", "សេរ៉ាឡេអូន");
    namesMap.put("SN", "សេនេហ្កាល់");
    namesMap.put("SO", "សូម៉ាលី");
    namesMap.put("SR", "សូរីណាម");
    namesMap.put("SV", "អែលសាល់វ៉ាឌ័រ");
    namesMap.put("SY", "ស៊ីរី");
    namesMap.put("SZ", "សូហ្ស៉ីឡង់");
    namesMap.put("TD", "ឆាដ");
    namesMap.put("TG", "តូហ្គូ");
    namesMap.put("TH", "ថៃ");
    namesMap.put("TJ", "តាដហ្ស៉ីគីស្តង់");
    namesMap.put("TL", "ទីម័រខាងកើត");
    namesMap.put("TM", "ទួគមេនីស្តង់");
    namesMap.put("TN", "ទុយនេស៊ី");
    namesMap.put("TO", "តុងហ្គា");
    namesMap.put("TR", "ទួរគី");
    namesMap.put("TT", "ទ្រីនីដាដនឹងតូបាហ្គោ");
    namesMap.put("TW", "តៃវ៉ាន់");
    namesMap.put("TZ", "តង់ហ្សានី");
    namesMap.put("UA", "អ៊ុយក្រែន");
    namesMap.put("UG", "អ៊ូហ្កង់ដា");
    namesMap.put("US", "សហរដ្ឋអាមេរិក");
    namesMap.put("UY", "អ៊ុយរុយហ្គាយ");
    namesMap.put("UZ", "អ៊ូហ្សបេគីស្តង់");
    namesMap.put("VA", "វ៉ាទីកង់");
    namesMap.put("VE", "វេនេហ្ស៊ុយឡា");
    namesMap.put("VN", "វៀតណាម");
    namesMap.put("WS", "សាមូអា");
    namesMap.put("YE", "យេមែន");
    namesMap.put("ZA", "អាហ្វ្រិកខាងត្បូង");
    namesMap.put("ZM", "ហ្សាំប៊ី");
    namesMap.put("ZW", "ហ្ស៊ីមបាបវ៉េ");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AD": "អានដូរ៉ា",
        "AE": "អេមីរ៉ែទអារ៉ាប់រួម",
        "AF": "អាហ្វហ្គានីស្ថាន",
        "AL": "អាល់បានី",
        "AM": "អារមេនី",
        "AO": "អង់ហ្គោឡា",
        "AR": "អាហ្សង់ទីន",
        "AT": "អូទ្រីស",
        "AU": "អូស្ត្រាលី",
        "AZ": "អាហ៊្សែរបែហ្សង់",
        "BA": "បូស្ន៉ី",
        "BB": "បារបាដូស",
        "BD": "បង់ក្លាដេស្ហ",
        "BE": "បែលហ្ស៉ិក",
        "BF": "ប៊ូរគីណាហ្វាសូ",
        "BG": "ប៊ុលហ្គារី",
        "BH": "បារ៉ែន",
        "BI": "ប៊ូរុនឌី",
        "BJ": "បេណាំង",
        "BN": "ប៊្រុយណេ",
        "BO": "បូលីវី",
        "BR": "ប្រេស៊ីល",
        "BS": "បាហាម៉ា",
        "BT": "ប៊ូតាន",
        "BW": "បុតស្វាណា",
        "BY": "បេឡារុស្ស",
        "BZ": "បេលីហ្ស",
        "CA": "កាណាដា",
        "CF": "សាធារណរដ្ឋអាហ្វ្រិកកណ្ដាល",
        "CG": "កុងហ្គោ",
        "CH": "ស្វីស",
        "CI": "កូដឌីវ័រ",
        "CL": "ឈីលី",
        "CM": "កាមេរូន",
        "CN": "ចិន",
        "CO": "កូឡុំប៊ី",
        "CR": "កូស្តារីកា",
        "CU": "គុយបា",
        "CV": "កាបវែរ",
        "CY": "ស៉ីពរ៍",
        "CZ": "សាធារណរដ្ឋឆេក",
        "DE": "អាល្លឺម៉ង់",
        "DJ": "ហ្ស៉ីបូទី",
        "DK": "ដាណឺម៉ាក",
        "DM": "ដូមីនីកា",
        "DO": "សាធារណរដ្ឋដូមីនីកែន",
        "DZ": "អាល់ហ្សេរី",
        "EC": "អេក្វាឌ័រ",
        "EE": "អេស្តូនី",
        "EG": "អេហ្ស៉ីប",
        "EH": "សាហារ៉ាខាងលិច",
        "ER": "អេរីទ្រា",
        "ES": "អេស្ប៉ាញ",
        "ET": "អេត្យូពី",
        "FI": "ហ្វាំងឡង់",
        "FJ": "ហ្វ៉ីហ្ស៉ី",
        "FM": "មិក្រូនេស៊ី",
        "FR": "បារាំង",
        "GA": "ហ្គាបុង",
        "GE": "ហ្សកហ្ស៉ី",
        "GH": "ហ្កាណា",
        "GM": "ហ្គាំប៊ី",
        "GN": "ហ្គីណេ",
        "GQ": "ហ្គីណេអេក្វាទ័រ",
        "GR": "ក្រិច",
        "GT": "ហ្គាតេម៉ាឡា",
        "GW": "ហ្គីណេប៊ីសូ",
        "GY": "ហ្គីយ៉ាណា",
        "HK": "ហុងកុង",
        "HN": "ហុងឌួរ៉ាស់",
        "HR": "ក្រូអាស៊ី",
        "HT": "ហៃទី",
        "HU": "ហុងគ្រី",
        "ID": "ឥណ្ឌូនេស៊ី",
        "IE": "អៀរឡង់",
        "IL": "អ៊ីស្រាអែល",
        "IN": "ឥណ្ឌា",
        "IQ": "អ៊ីរ៉ាក់",
        "IR": "អ៊ីរ៉ង់",
        "IS": "អ៉ីស្លង់",
        "IT": "អ៊ីតាលី",
        "JM": "ហ្សាម៉ាអ៉ិគ",
        "JO": "ហ៊្សកដានី",
        "JP": "ជប៉ុន",
        "KE": "កេនយ៉ា",
        "KG": "គៀរហ្គីស្តង់",
        "KH": "កម្ពុជា",
        "KI": "គិរិបាទី",
        "KM": "កុំម៉ូរ៉ូស",
        "KP": "សាធារណរដ្ឋប្រជាធិបតេយ្យប្រជាមានិតកូរ៉េ",
        "KR": "សាធារណរដ្ឋកូរ៉េ",
        "KW": "គុយវ៉ែត",
        "KZ": "កាហ្សាក់ស្តាង់់",
        "LA": "ឡាវ",
        "LB": "លីបង់",
        "LI": "លិចទេនស្តែន",
        "LK": "ស្រីលង្កា",
        "LR": "លីបេរីយ៉ា",
        "LS": "លើសូតូ",
        "LT": "លីទុយអានី",
        "LU": "លុចហ្សំបួរ",
        "LV": "ឡាតវីយ៉ា",
        "LY": "លីប៊ី",
        "MA": "ម៉ារ៉ុក",
        "MC": "ម៉ូណាកូ",
        "MD": "សាធារណរដ្ឋម៉ុលដាវី",
        "MG": "ម៉ាដាហ្កាស្ការ",
        "MK": "ម៉ាសេដន",
        "ML": "ម៉ាលី",
        "MM": "មីយ៉ាន់ម៉ា",
        "MN": "ម៉ុងហ្គោលី",
        "MR": "ម៉ូរីតានី",
        "MT": "ម៉ាល់តា",
        "MU": "ម៉ូរីទុស",
        "MX": "ម៉ិចសិក",
        "MY": "ម៉ាលេស៉ី",
        "MZ": "ម៉ូហ្សាំប៊ិក",
        "NA": "ណាមីប៊ី",
        "NE": "នីហ្សេរ",
        "NG": "នីហ្សេរីយ៉ា",
        "NI": "នីការ៉ាហ្គ័រ",
        "NL": "ហូល្លង់",
        "NO": "ន័រវែស",
        "NP": "នេប៉ាល់",
        "NZ": "នូវែលហ្សេឡង់",
        "OM": "អូម៉ង់",
        "PA": "ប៉ាណាម៉ា",
        "PE": "ប៉េរូ",
        "PG": "ប៉ាពូអានូវែលហ្គីណេ",
        "PH": "ហ្វ៉ីលីពីន",
        "PK": "ប៉ាគីស្ថាន",
        "PL": "ប៉ូលូញ",
        "PR": "ព័រតូរីកូ",
        "PS": "ប៉ាលេស្ទីន",
        "PT": "ព័រទុយហ្កាល់",
        "PY": "ប៉ារ៉ាហ្គាយ",
        "QA": "កាតារ",
        "RO": "រូម៉ានី",
        "RU": "រូស្ស៊ី",
        "RW": "រវ៉ាន់ដា",
        "SA": "អារ៉ាប៊ីសាអ៊ូឌីត",
        "SC": "សីសែល",
        "SD": "ស៊ូដង់",
        "SE": "ស៊ុយអែដ",
        "SG": "សិង្ហបុរី",
        "SI": "ស្លូវេនី",
        "SK": "ស្លូវ៉ាគី",
        "SL": "សេរ៉ាឡេអូន",
        "SN": "សេនេហ្កាល់",
        "SO": "សូម៉ាលី",
        "SR": "សូរីណាម",
        "SV": "អែលសាល់វ៉ាឌ័រ",
        "SY": "ស៊ីរី",
        "SZ": "សូហ្ស៉ីឡង់",
        "TD": "ឆាដ",
        "TG": "តូហ្គូ",
        "TH": "ថៃ",
        "TJ": "តាដហ្ស៉ីគីស្តង់",
        "TL": "ទីម័រខាងកើត",
        "TM": "ទួគមេនីស្តង់",
        "TN": "ទុយនេស៊ី",
        "TO": "តុងហ្គា",
        "TR": "ទួរគី",
        "TT": "ទ្រីនីដាដនឹងតូបាហ្គោ",
        "TW": "តៃវ៉ាន់",
        "TZ": "តង់ហ្សានី",
        "UA": "អ៊ុយក្រែន",
        "UG": "អ៊ូហ្កង់ដា",
        "US": "សហរដ្ឋអាមេរិក",
        "UY": "អ៊ុយរុយហ្គាយ",
        "UZ": "អ៊ូហ្សបេគីស្តង់",
        "VA": "វ៉ាទីកង់",
        "VE": "វេនេហ្ស៊ុយឡា",
        "VN": "វៀតណាម",
        "WS": "សាមូអា",
        "YE": "យេមែន",
        "ZA": "អាហ្វ្រិកខាងត្បូង",
        "ZM": "ហ្សាំប៊ី",
        "ZW": "ហ្ស៊ីមបាបវ៉េ"
    };
  }-*/;
}
