/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.canvas.client;

import com.google.gwt.canvas.dom.client.Context;
import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.CanvasElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.PartialSupport;
import com.google.gwt.user.client.ui.FocusWidget;

@PartialSupport
public class Canvas
extends FocusWidget {
    private static CanvasElementSupportDetector detector;

    public static Canvas createIfSupported() {
        if (detector == null) {
            detector = (CanvasElementSupportDetector)GWT.create(CanvasElementSupportDetector.class);
        }
        if (!detector.isSupportedCompileTime()) {
            return null;
        }
        CanvasElement element = Document.get().createCanvasElement();
        if (!CanvasElementSupportDetector.isSupportedRunTime(element)) {
            return null;
        }
        return new Canvas(element);
    }

    public static boolean isSupported() {
        if (detector == null) {
            detector = (CanvasElementSupportDetector)GWT.create(CanvasElementSupportDetector.class);
        }
        if (!detector.isSupportedCompileTime()) {
            return false;
        }
        CanvasElement element = Document.get().createCanvasElement();
        return CanvasElementSupportDetector.isSupportedRunTime(element);
    }

    private Canvas(CanvasElement element) {
        this.setElement(element);
    }

    public CanvasElement getCanvasElement() {
        return (CanvasElement)this.getElement().cast();
    }

    public Context getContext(String contextId) {
        return this.getCanvasElement().getContext(contextId);
    }

    public Context2d getContext2d() {
        return this.getCanvasElement().getContext2d();
    }

    public int getCoordinateSpaceHeight() {
        return this.getCanvasElement().getHeight();
    }

    public int getCoordinateSpaceWidth() {
        return this.getCanvasElement().getWidth();
    }

    public void setCoordinateSpaceHeight(int height) {
        this.getCanvasElement().setHeight(height);
    }

    public void setCoordinateSpaceWidth(int width) {
        this.getCanvasElement().setWidth(width);
    }

    public String toDataUrl() {
        return this.getCanvasElement().toDataUrl();
    }

    public String toDataUrl(String type) {
        return this.getCanvasElement().toDataUrl(type);
    }

    private static class CanvasElementSupportDetectedNo
    extends CanvasElementSupportDetector {
        private CanvasElementSupportDetectedNo() {
        }

        boolean isSupportedCompileTime() {
            return false;
        }
    }

    private static class CanvasElementSupportDetectedMaybe
    extends CanvasElementSupportDetector {
        private CanvasElementSupportDetectedMaybe() {
        }

        boolean isSupportedCompileTime() {
            return true;
        }
    }

    private static class CanvasElementSupportDetector {
        private CanvasElementSupportDetector() {
        }

        static native boolean isSupportedRunTime(CanvasElement var0);

        boolean isSupportedCompileTime() {
            return false;
        }
    }
}

