/* PhotoFileAdapter.c generated by valac 0.36.6, the Vala compiler
 * generated from PhotoFileAdapter.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/**/
/* PhotoFileAdapter*/
/**/
/* PhotoFileAdapter (and its immediate children, PhotoFileReader and PhotoFileWriter) are drivers*/
/* hiding details of reading and writing image files and their metadata.  They should keep*/
/* minimal state beyond the filename, if any stat at all.  In particular, they should avoid caching*/
/* values, especially the readers, as writers may be created at any time and invalidate that*/
/* information, unless the readers monitor the file for these changes.*/
/**/
/* PhotoFileAdapters should be entirely thread-safe.  They are not, however, responsible for*/
/* atomicity on the filesystem.*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gobject/gvaluecollector.h>


#define TYPE_PHOTO_FILE_ADAPTER (photo_file_adapter_get_type ())
#define PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter))
#define PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))
#define IS_PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_ADAPTER))
#define IS_PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_ADAPTER))
#define PHOTO_FILE_ADAPTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))

typedef struct _PhotoFileAdapter PhotoFileAdapter;
typedef struct _PhotoFileAdapterClass PhotoFileAdapterClass;
typedef struct _PhotoFileAdapterPrivate PhotoFileAdapterPrivate;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecPhotoFileAdapter ParamSpecPhotoFileAdapter;

#define TYPE_PHOTO_FILE_READER (photo_file_reader_get_type ())
#define PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReader))
#define PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))
#define IS_PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_READER))
#define IS_PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_READER))
#define PHOTO_FILE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))

typedef struct _PhotoFileReader PhotoFileReader;
typedef struct _PhotoFileReaderClass PhotoFileReaderClass;
typedef struct _PhotoFileReaderPrivate PhotoFileReaderPrivate;

#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define PHOTO_FILE_READER_TYPE_ROLE (photo_file_reader_role_get_type ())

#define TYPE_PHOTO_FILE_WRITER (photo_file_writer_get_type ())
#define PHOTO_FILE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_WRITER, PhotoFileWriter))
#define PHOTO_FILE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_WRITER, PhotoFileWriterClass))
#define IS_PHOTO_FILE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_WRITER))
#define IS_PHOTO_FILE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_WRITER))
#define PHOTO_FILE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_WRITER, PhotoFileWriterClass))

typedef struct _PhotoFileWriter PhotoFileWriter;
typedef struct _PhotoFileWriterClass PhotoFileWriterClass;
#define _photo_file_adapter_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_adapter_unref (var), NULL)))

#define TYPE_PHOTO_FILE_METADATA_WRITER (photo_file_metadata_writer_get_type ())
#define PHOTO_FILE_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriter))
#define PHOTO_FILE_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriterClass))
#define IS_PHOTO_FILE_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_METADATA_WRITER))
#define IS_PHOTO_FILE_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_METADATA_WRITER))
#define PHOTO_FILE_METADATA_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriterClass))

typedef struct _PhotoFileMetadataWriter PhotoFileMetadataWriter;
typedef struct _PhotoFileMetadataWriterClass PhotoFileMetadataWriterClass;
typedef struct _PhotoFileWriterPrivate PhotoFileWriterPrivate;

#define JPEG_TYPE_QUALITY (jpeg_quality_get_type ())
typedef struct _PhotoFileMetadataWriterPrivate PhotoFileMetadataWriterPrivate;

struct _PhotoFileAdapter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileAdapterPrivate * priv;
};

struct _PhotoFileAdapterClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileAdapter *self);
};

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

struct _PhotoFileAdapterPrivate {
	gchar* filepath;
	PhotoFileFormat file_format;
	GFile* file;
	GRecMutex __lock_file;
};

struct _ParamSpecPhotoFileAdapter {
	GParamSpec parent_instance;
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _PhotoFileReader {
	PhotoFileAdapter parent_instance;
	PhotoFileReaderPrivate * priv;
};

struct _PhotoFileReaderClass {
	PhotoFileAdapterClass parent_class;
	PhotoMetadata* (*read_metadata) (PhotoFileReader* self, GError** error);
	GdkPixbuf* (*unscaled_read) (PhotoFileReader* self, GError** error);
	GdkPixbuf* (*scaled_read) (PhotoFileReader* self, Dimensions* full, Dimensions* scaled, GError** error);
};

typedef enum  {
	PHOTO_FILE_READER_ROLE_DEFAULT,
	PHOTO_FILE_READER_ROLE_THUMBNAIL
} PhotoFileReaderRole;

struct _PhotoFileReaderPrivate {
	PhotoFileReaderRole role;
};

typedef enum  {
	PHOTO_FORMAT_ERROR_READ_ONLY
} PhotoFormatError;
#define PHOTO_FORMAT_ERROR photo_format_error_quark ()
typedef enum  {
	JPEG_QUALITY_LOW = 50,
	JPEG_QUALITY_MEDIUM = 75,
	JPEG_QUALITY_HIGH = 90,
	JPEG_QUALITY_MAXIMUM = 100
} JpegQuality;

struct _PhotoFileWriter {
	PhotoFileAdapter parent_instance;
	PhotoFileWriterPrivate * priv;
};

struct _PhotoFileWriterClass {
	PhotoFileAdapterClass parent_class;
	void (*write) (PhotoFileWriter* self, GdkPixbuf* pixbuf, JpegQuality quality, GError** error);
};

struct _PhotoFileMetadataWriter {
	PhotoFileAdapter parent_instance;
	PhotoFileMetadataWriterPrivate * priv;
};

struct _PhotoFileMetadataWriterClass {
	PhotoFileAdapterClass parent_class;
	void (*write_metadata) (PhotoFileMetadataWriter* self, PhotoMetadata* metadata, GError** error);
};


static gpointer photo_file_adapter_parent_class = NULL;
static gpointer photo_file_reader_parent_class = NULL;
static gpointer photo_file_writer_parent_class = NULL;
static gpointer photo_file_metadata_writer_parent_class = NULL;

gpointer photo_file_adapter_ref (gpointer instance);
void photo_file_adapter_unref (gpointer instance);
GParamSpec* param_spec_photo_file_adapter (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_file_adapter (GValue* value, gpointer v_object);
void value_take_photo_file_adapter (GValue* value, gpointer v_object);
gpointer value_get_photo_file_adapter (const GValue* value);
GType photo_file_adapter_get_type (void) G_GNUC_CONST;
GType photo_file_format_get_type (void) G_GNUC_CONST;
#define PHOTO_FILE_ADAPTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterPrivate))
enum  {
	PHOTO_FILE_ADAPTER_DUMMY_PROPERTY
};
PhotoFileAdapter* photo_file_adapter_construct (GType object_type, const gchar* filepath, PhotoFileFormat file_format);
gboolean photo_file_adapter_file_exists (PhotoFileAdapter* self);
gchar* photo_file_adapter_get_filepath (PhotoFileAdapter* self);
GFile* photo_file_adapter_get_file (PhotoFileAdapter* self);
PhotoFileFormat photo_file_adapter_get_file_format (PhotoFileAdapter* self);
static void photo_file_adapter_finalize (PhotoFileAdapter * obj);
GType photo_file_reader_get_type (void) G_GNUC_CONST;
gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_media_metadata (GValue* value, gpointer v_object);
void value_take_media_metadata (GValue* value, gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
GType photo_metadata_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
GType photo_file_reader_role_get_type (void) G_GNUC_CONST;
#define PHOTO_FILE_READER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PHOTO_FILE_READER, PhotoFileReaderPrivate))
enum  {
	PHOTO_FILE_READER_DUMMY_PROPERTY
};
PhotoFileReader* photo_file_reader_construct (GType object_type, const gchar* filepath, PhotoFileFormat file_format);
GType photo_file_writer_get_type (void) G_GNUC_CONST;
GQuark photo_format_error_quark (void);
PhotoFileWriter* photo_file_reader_create_writer (PhotoFileReader* self, GError** error);
PhotoFileWriter* photo_file_format_create_writer (PhotoFileFormat self, const gchar* filepath, GError** error);
GType photo_file_metadata_writer_get_type (void) G_GNUC_CONST;
PhotoFileMetadataWriter* photo_file_reader_create_metadata_writer (PhotoFileReader* self, GError** error);
PhotoFileMetadataWriter* photo_file_format_create_metadata_writer (PhotoFileFormat self, const gchar* filepath, GError** error);
PhotoMetadata* photo_file_reader_read_metadata (PhotoFileReader* self, GError** error);
static PhotoMetadata* photo_file_reader_real_read_metadata (PhotoFileReader* self, GError** error);
GdkPixbuf* photo_file_reader_unscaled_read (PhotoFileReader* self, GError** error);
static GdkPixbuf* photo_file_reader_real_unscaled_read (PhotoFileReader* self, GError** error);
GdkPixbuf* photo_file_reader_scaled_read (PhotoFileReader* self, Dimensions* full, Dimensions* scaled, GError** error);
static GdkPixbuf* photo_file_reader_real_scaled_read (PhotoFileReader* self, Dimensions* full, Dimensions* scaled, GError** error);
GdkPixbuf* resize_pixbuf (GdkPixbuf* pixbuf, Dimensions* resized, GdkInterpType interp);
void photo_file_reader_set_role (PhotoFileReader* self, PhotoFileReaderRole role);
PhotoFileReaderRole photo_file_reader_get_role (PhotoFileReader* self);
static void photo_file_reader_finalize (PhotoFileAdapter * obj);
GType jpeg_quality_get_type (void) G_GNUC_CONST;
enum  {
	PHOTO_FILE_WRITER_DUMMY_PROPERTY
};
PhotoFileWriter* photo_file_writer_construct (GType object_type, const gchar* filepath, PhotoFileFormat file_format);
PhotoFileReader* photo_file_writer_create_reader (PhotoFileWriter* self);
PhotoFileReader* photo_file_format_create_reader (PhotoFileFormat self, const gchar* filepath);
void photo_file_writer_write (PhotoFileWriter* self, GdkPixbuf* pixbuf, JpegQuality quality, GError** error);
static void photo_file_writer_real_write (PhotoFileWriter* self, GdkPixbuf* pixbuf, JpegQuality quality, GError** error);
enum  {
	PHOTO_FILE_METADATA_WRITER_DUMMY_PROPERTY
};
PhotoFileMetadataWriter* photo_file_metadata_writer_construct (GType object_type, const gchar* filepath, PhotoFileFormat file_format);
PhotoFileReader* photo_file_metadata_writer_create_reader (PhotoFileMetadataWriter* self);
void photo_file_metadata_writer_write_metadata (PhotoFileMetadataWriter* self, PhotoMetadata* metadata, GError** error);
static void photo_file_metadata_writer_real_write_metadata (PhotoFileMetadataWriter* self, PhotoMetadata* metadata, GError** error);


PhotoFileAdapter* photo_file_adapter_construct (GType object_type, const gchar* filepath, PhotoFileFormat file_format) {
	PhotoFileAdapter* self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	PhotoFileFormat _tmp2_;
#line 25 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_return_val_if_fail (filepath != NULL, NULL);
#line 25 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	self = (PhotoFileAdapter*) g_type_create_instance (object_type);
#line 26 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp0_ = filepath;
#line 26 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 26 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_g_free0 (self->priv->filepath);
#line 26 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	self->priv->filepath = _tmp1_;
#line 27 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp2_ = file_format;
#line 27 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	self->priv->file_format = _tmp2_;
#line 25 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	return self;
#line 298 "PhotoFileAdapter.c"
}


gboolean photo_file_adapter_file_exists (PhotoFileAdapter* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_;
#line 30 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_ADAPTER (self), FALSE);
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp0_ = self->priv->filepath;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp1_ = g_file_test (_tmp0_, G_FILE_TEST_IS_REGULAR);
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	result = _tmp1_;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	return result;
#line 316 "PhotoFileAdapter.c"
}


gchar* photo_file_adapter_get_filepath (PhotoFileAdapter* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 34 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_ADAPTER (self), NULL);
#line 35 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp0_ = self->priv->filepath;
#line 35 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 35 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	result = _tmp1_;
#line 35 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	return result;
#line 334 "PhotoFileAdapter.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 44 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	return self ? g_object_ref (self) : NULL;
#line 341 "PhotoFileAdapter.c"
}


GFile* photo_file_adapter_get_file (PhotoFileAdapter* self) {
	GFile* result = NULL;
	GFile* _result_ = NULL;
	GError * _inner_error_ = NULL;
#line 38 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_ADAPTER (self), NULL);
#line 351 "PhotoFileAdapter.c"
	{
		GFile* _tmp0_;
#line 40 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
		_tmp0_ = self->priv->file;
#line 40 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
		g_rec_mutex_lock (&self->priv->__lock_file);
#line 358 "PhotoFileAdapter.c"
		{
			GFile* _tmp1_;
			GFile* _tmp4_;
			GFile* _tmp5_;
#line 41 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
			_tmp1_ = self->priv->file;
#line 41 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
			if (_tmp1_ == NULL) {
#line 367 "PhotoFileAdapter.c"
				const gchar* _tmp2_;
				GFile* _tmp3_;
#line 42 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
				_tmp2_ = self->priv->filepath;
#line 42 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
				_tmp3_ = g_file_new_for_path (_tmp2_);
#line 42 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
				_g_object_unref0 (self->priv->file);
#line 42 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
				self->priv->file = _tmp3_;
#line 378 "PhotoFileAdapter.c"
			}
#line 44 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
			_tmp4_ = self->priv->file;
#line 44 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
			_tmp5_ = _g_object_ref0 (_tmp4_);
#line 44 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
			_g_object_unref0 (_result_);
#line 44 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
			_result_ = _tmp5_;
#line 388 "PhotoFileAdapter.c"
		}
		__finally28:
		{
			GFile* _tmp6_;
#line 40 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
			_tmp6_ = self->priv->file;
#line 40 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
			g_rec_mutex_unlock (&self->priv->__lock_file);
#line 397 "PhotoFileAdapter.c"
		}
#line 40 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 40 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
			_g_object_unref0 (_result_);
#line 40 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 40 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
			g_clear_error (&_inner_error_);
#line 40 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
			return NULL;
#line 409 "PhotoFileAdapter.c"
		}
	}
#line 47 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	result = _result_;
#line 47 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	return result;
#line 416 "PhotoFileAdapter.c"
}


PhotoFileFormat photo_file_adapter_get_file_format (PhotoFileAdapter* self) {
	PhotoFileFormat result = 0;
	PhotoFileFormat _tmp0_;
#line 50 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_ADAPTER (self), 0);
#line 51 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp0_ = self->priv->file_format;
#line 51 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	result = _tmp0_;
#line 51 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	return result;
#line 431 "PhotoFileAdapter.c"
}


static void value_photo_file_adapter_init (GValue* value) {
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	value->data[0].v_pointer = NULL;
#line 438 "PhotoFileAdapter.c"
}


static void value_photo_file_adapter_free_value (GValue* value) {
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	if (value->data[0].v_pointer) {
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
		photo_file_adapter_unref (value->data[0].v_pointer);
#line 447 "PhotoFileAdapter.c"
	}
}


static void value_photo_file_adapter_copy_value (const GValue* src_value, GValue* dest_value) {
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	if (src_value->data[0].v_pointer) {
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
		dest_value->data[0].v_pointer = photo_file_adapter_ref (src_value->data[0].v_pointer);
#line 457 "PhotoFileAdapter.c"
	} else {
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
		dest_value->data[0].v_pointer = NULL;
#line 461 "PhotoFileAdapter.c"
	}
}


static gpointer value_photo_file_adapter_peek_pointer (const GValue* value) {
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	return value->data[0].v_pointer;
#line 469 "PhotoFileAdapter.c"
}


static gchar* value_photo_file_adapter_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	if (collect_values[0].v_pointer) {
#line 476 "PhotoFileAdapter.c"
		PhotoFileAdapter * object;
		object = collect_values[0].v_pointer;
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
		if (object->parent_instance.g_class == NULL) {
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 483 "PhotoFileAdapter.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 487 "PhotoFileAdapter.c"
		}
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
		value->data[0].v_pointer = photo_file_adapter_ref (object);
#line 491 "PhotoFileAdapter.c"
	} else {
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
		value->data[0].v_pointer = NULL;
#line 495 "PhotoFileAdapter.c"
	}
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	return NULL;
#line 499 "PhotoFileAdapter.c"
}


static gchar* value_photo_file_adapter_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PhotoFileAdapter ** object_p;
	object_p = collect_values[0].v_pointer;
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	if (!object_p) {
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 510 "PhotoFileAdapter.c"
	}
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	if (!value->data[0].v_pointer) {
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
		*object_p = NULL;
#line 516 "PhotoFileAdapter.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
		*object_p = value->data[0].v_pointer;
#line 520 "PhotoFileAdapter.c"
	} else {
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
		*object_p = photo_file_adapter_ref (value->data[0].v_pointer);
#line 524 "PhotoFileAdapter.c"
	}
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	return NULL;
#line 528 "PhotoFileAdapter.c"
}


GParamSpec* param_spec_photo_file_adapter (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPhotoFileAdapter* spec;
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PHOTO_FILE_ADAPTER), NULL);
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	return G_PARAM_SPEC (spec);
#line 542 "PhotoFileAdapter.c"
}


gpointer value_get_photo_file_adapter (const GValue* value) {
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_ADAPTER), NULL);
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	return value->data[0].v_pointer;
#line 551 "PhotoFileAdapter.c"
}


void value_set_photo_file_adapter (GValue* value, gpointer v_object) {
	PhotoFileAdapter * old;
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_ADAPTER));
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	old = value->data[0].v_pointer;
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	if (v_object) {
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_FILE_ADAPTER));
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
		value->data[0].v_pointer = v_object;
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
		photo_file_adapter_ref (value->data[0].v_pointer);
#line 571 "PhotoFileAdapter.c"
	} else {
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
		value->data[0].v_pointer = NULL;
#line 575 "PhotoFileAdapter.c"
	}
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	if (old) {
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
		photo_file_adapter_unref (old);
#line 581 "PhotoFileAdapter.c"
	}
}


void value_take_photo_file_adapter (GValue* value, gpointer v_object) {
	PhotoFileAdapter * old;
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_ADAPTER));
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	old = value->data[0].v_pointer;
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	if (v_object) {
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_FILE_ADAPTER));
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
		value->data[0].v_pointer = v_object;
#line 600 "PhotoFileAdapter.c"
	} else {
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
		value->data[0].v_pointer = NULL;
#line 604 "PhotoFileAdapter.c"
	}
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	if (old) {
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
		photo_file_adapter_unref (old);
#line 610 "PhotoFileAdapter.c"
	}
}


static void photo_file_adapter_class_init (PhotoFileAdapterClass * klass) {
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	photo_file_adapter_parent_class = g_type_class_peek_parent (klass);
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	((PhotoFileAdapterClass *) klass)->finalize = photo_file_adapter_finalize;
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_type_class_add_private (klass, sizeof (PhotoFileAdapterPrivate));
#line 622 "PhotoFileAdapter.c"
}


static void photo_file_adapter_instance_init (PhotoFileAdapter * self) {
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	self->priv = PHOTO_FILE_ADAPTER_GET_PRIVATE (self);
#line 23 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_rec_mutex_init (&self->priv->__lock_file);
#line 23 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	self->priv->file = NULL;
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	self->ref_count = 1;
#line 635 "PhotoFileAdapter.c"
}


static void photo_file_adapter_finalize (PhotoFileAdapter * obj) {
	PhotoFileAdapter * self;
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter);
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_signal_handlers_destroy (self);
#line 21 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_g_free0 (self->priv->filepath);
#line 23 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_rec_mutex_clear (&self->priv->__lock_file);
#line 23 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_g_object_unref0 (self->priv->file);
#line 651 "PhotoFileAdapter.c"
}


GType photo_file_adapter_get_type (void) {
	static volatile gsize photo_file_adapter_type_id__volatile = 0;
	if (g_once_init_enter (&photo_file_adapter_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_photo_file_adapter_init, value_photo_file_adapter_free_value, value_photo_file_adapter_copy_value, value_photo_file_adapter_peek_pointer, "p", value_photo_file_adapter_collect_value, "p", value_photo_file_adapter_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PhotoFileAdapterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_file_adapter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoFileAdapter), 0, (GInstanceInitFunc) photo_file_adapter_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType photo_file_adapter_type_id;
		photo_file_adapter_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoFileAdapter", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&photo_file_adapter_type_id__volatile, photo_file_adapter_type_id);
	}
	return photo_file_adapter_type_id__volatile;
}


gpointer photo_file_adapter_ref (gpointer instance) {
	PhotoFileAdapter * self;
	self = instance;
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_atomic_int_inc (&self->ref_count);
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	return instance;
#line 676 "PhotoFileAdapter.c"
}


void photo_file_adapter_unref (gpointer instance) {
	PhotoFileAdapter * self;
	self = instance;
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
		PHOTO_FILE_ADAPTER_GET_CLASS (self)->finalize (self);
#line 20 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 689 "PhotoFileAdapter.c"
	}
}


GType photo_file_reader_role_get_type (void) {
	static volatile gsize photo_file_reader_role_type_id__volatile = 0;
	if (g_once_init_enter (&photo_file_reader_role_type_id__volatile)) {
		static const GEnumValue values[] = {{PHOTO_FILE_READER_ROLE_DEFAULT, "PHOTO_FILE_READER_ROLE_DEFAULT", "default"}, {PHOTO_FILE_READER_ROLE_THUMBNAIL, "PHOTO_FILE_READER_ROLE_THUMBNAIL", "thumbnail"}, {0, NULL, NULL}};
		GType photo_file_reader_role_type_id;
		photo_file_reader_role_type_id = g_enum_register_static ("PhotoFileReaderRole", values);
		g_once_init_leave (&photo_file_reader_role_type_id__volatile, photo_file_reader_role_type_id);
	}
	return photo_file_reader_role_type_id__volatile;
}


PhotoFileReader* photo_file_reader_construct (GType object_type, const gchar* filepath, PhotoFileFormat file_format) {
	PhotoFileReader* self = NULL;
	const gchar* _tmp0_;
	PhotoFileFormat _tmp1_;
#line 67 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_return_val_if_fail (filepath != NULL, NULL);
#line 68 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp0_ = filepath;
#line 68 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp1_ = file_format;
#line 68 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	self = (PhotoFileReader*) photo_file_adapter_construct (object_type, _tmp0_, _tmp1_);
#line 67 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	return self;
#line 720 "PhotoFileAdapter.c"
}


PhotoFileWriter* photo_file_reader_create_writer (PhotoFileReader* self, GError** error) {
	PhotoFileWriter* result = NULL;
	PhotoFileWriter* _tmp0_ = NULL;
	PhotoFileFormat _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	PhotoFileWriter* _tmp4_;
	PhotoFileWriter* _tmp5_;
	PhotoFileWriter* _tmp6_;
	GError * _inner_error_ = NULL;
#line 71 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_READER (self), NULL);
#line 72 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp1_ = photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 72 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp2_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 72 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp3_ = _tmp2_;
#line 72 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp4_ = photo_file_format_create_writer (_tmp1_, _tmp3_, &_inner_error_);
#line 72 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp5_ = _tmp4_;
#line 72 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_g_free0 (_tmp3_);
#line 72 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp0_ = _tmp5_;
#line 72 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 72 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
		if (_inner_error_->domain == PHOTO_FORMAT_ERROR) {
#line 72 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
			g_propagate_error (error, _inner_error_);
#line 72 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
			return NULL;
#line 758 "PhotoFileAdapter.c"
		} else {
#line 72 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 72 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
			g_clear_error (&_inner_error_);
#line 72 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
			return NULL;
#line 766 "PhotoFileAdapter.c"
		}
	}
#line 72 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp6_ = _tmp0_;
#line 72 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp0_ = NULL;
#line 72 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	result = _tmp6_;
#line 72 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_photo_file_adapter_unref0 (_tmp0_);
#line 72 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	return result;
#line 779 "PhotoFileAdapter.c"
}


PhotoFileMetadataWriter* photo_file_reader_create_metadata_writer (PhotoFileReader* self, GError** error) {
	PhotoFileMetadataWriter* result = NULL;
	PhotoFileMetadataWriter* _tmp0_ = NULL;
	PhotoFileFormat _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	PhotoFileMetadataWriter* _tmp4_;
	PhotoFileMetadataWriter* _tmp5_;
	PhotoFileMetadataWriter* _tmp6_;
	GError * _inner_error_ = NULL;
#line 75 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_READER (self), NULL);
#line 76 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp1_ = photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 76 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp2_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 76 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp3_ = _tmp2_;
#line 76 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp4_ = photo_file_format_create_metadata_writer (_tmp1_, _tmp3_, &_inner_error_);
#line 76 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp5_ = _tmp4_;
#line 76 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_g_free0 (_tmp3_);
#line 76 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp0_ = _tmp5_;
#line 76 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 76 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
		if (_inner_error_->domain == PHOTO_FORMAT_ERROR) {
#line 76 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
			g_propagate_error (error, _inner_error_);
#line 76 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
			return NULL;
#line 817 "PhotoFileAdapter.c"
		} else {
#line 76 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 76 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
			g_clear_error (&_inner_error_);
#line 76 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
			return NULL;
#line 825 "PhotoFileAdapter.c"
		}
	}
#line 76 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp6_ = _tmp0_;
#line 76 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp0_ = NULL;
#line 76 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	result = _tmp6_;
#line 76 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_photo_file_adapter_unref0 (_tmp0_);
#line 76 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	return result;
#line 838 "PhotoFileAdapter.c"
}


static PhotoMetadata* photo_file_reader_real_read_metadata (PhotoFileReader* self, GError** error) {
#line 79 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_critical ("Type `%s' does not implement abstract method `photo_file_reader_read_metadata'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 79 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	return NULL;
#line 847 "PhotoFileAdapter.c"
}


PhotoMetadata* photo_file_reader_read_metadata (PhotoFileReader* self, GError** error) {
#line 79 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_READER (self), NULL);
#line 79 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	return PHOTO_FILE_READER_GET_CLASS (self)->read_metadata (self, error);
#line 856 "PhotoFileAdapter.c"
}


static GdkPixbuf* photo_file_reader_real_unscaled_read (PhotoFileReader* self, GError** error) {
#line 81 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_critical ("Type `%s' does not implement abstract method `photo_file_reader_unscaled_read'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 81 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	return NULL;
#line 865 "PhotoFileAdapter.c"
}


GdkPixbuf* photo_file_reader_unscaled_read (PhotoFileReader* self, GError** error) {
#line 81 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_READER (self), NULL);
#line 81 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	return PHOTO_FILE_READER_GET_CLASS (self)->unscaled_read (self, error);
#line 874 "PhotoFileAdapter.c"
}


static GdkPixbuf* photo_file_reader_real_scaled_read (PhotoFileReader* self, Dimensions* full, Dimensions* scaled, GError** error) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_;
	Dimensions _tmp2_;
	GdkPixbuf* _tmp3_;
	GError * _inner_error_ = NULL;
#line 83 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_return_val_if_fail (full != NULL, NULL);
#line 83 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_return_val_if_fail (scaled != NULL, NULL);
#line 84 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp1_ = photo_file_reader_unscaled_read (self, &_inner_error_);
#line 84 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp0_ = _tmp1_;
#line 84 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 84 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
		g_propagate_error (error, _inner_error_);
#line 84 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
		return NULL;
#line 899 "PhotoFileAdapter.c"
	}
#line 84 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp2_ = *scaled;
#line 84 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp3_ = resize_pixbuf (_tmp0_, &_tmp2_, GDK_INTERP_BILINEAR);
#line 84 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	result = _tmp3_;
#line 84 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_g_object_unref0 (_tmp0_);
#line 84 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	return result;
#line 911 "PhotoFileAdapter.c"
}


GdkPixbuf* photo_file_reader_scaled_read (PhotoFileReader* self, Dimensions* full, Dimensions* scaled, GError** error) {
#line 83 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_READER (self), NULL);
#line 83 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	return PHOTO_FILE_READER_GET_CLASS (self)->scaled_read (self, full, scaled, error);
#line 920 "PhotoFileAdapter.c"
}


void photo_file_reader_set_role (PhotoFileReader* self, PhotoFileReaderRole role) {
	PhotoFileReaderRole _tmp0_;
#line 87 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_return_if_fail (IS_PHOTO_FILE_READER (self));
#line 88 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp0_ = role;
#line 88 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	self->priv->role = _tmp0_;
#line 932 "PhotoFileAdapter.c"
}


PhotoFileReaderRole photo_file_reader_get_role (PhotoFileReader* self) {
	PhotoFileReaderRole result = 0;
	PhotoFileReaderRole _tmp0_;
#line 91 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_READER (self), 0);
#line 92 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp0_ = self->priv->role;
#line 92 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	result = _tmp0_;
#line 92 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	return result;
#line 947 "PhotoFileAdapter.c"
}


static void photo_file_reader_class_init (PhotoFileReaderClass * klass) {
#line 59 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	photo_file_reader_parent_class = g_type_class_peek_parent (klass);
#line 59 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	((PhotoFileAdapterClass *) klass)->finalize = photo_file_reader_finalize;
#line 59 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_type_class_add_private (klass, sizeof (PhotoFileReaderPrivate));
#line 59 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	((PhotoFileReaderClass *) klass)->read_metadata = (PhotoMetadata* (*) (PhotoFileReader *, GError**)) photo_file_reader_real_read_metadata;
#line 59 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	((PhotoFileReaderClass *) klass)->unscaled_read = (GdkPixbuf* (*) (PhotoFileReader *, GError**)) photo_file_reader_real_unscaled_read;
#line 59 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	((PhotoFileReaderClass *) klass)->scaled_read = (GdkPixbuf* (*) (PhotoFileReader *, Dimensions*, Dimensions*, GError**)) photo_file_reader_real_scaled_read;
#line 964 "PhotoFileAdapter.c"
}


static void photo_file_reader_instance_init (PhotoFileReader * self) {
#line 59 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	self->priv = PHOTO_FILE_READER_GET_PRIVATE (self);
#line 65 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	self->priv->role = PHOTO_FILE_READER_ROLE_DEFAULT;
#line 973 "PhotoFileAdapter.c"
}


static void photo_file_reader_finalize (PhotoFileAdapter * obj) {
	PhotoFileReader * self;
#line 59 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_FILE_READER, PhotoFileReader);
#line 59 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	PHOTO_FILE_ADAPTER_CLASS (photo_file_reader_parent_class)->finalize (obj);
#line 983 "PhotoFileAdapter.c"
}


GType photo_file_reader_get_type (void) {
	static volatile gsize photo_file_reader_type_id__volatile = 0;
	if (g_once_init_enter (&photo_file_reader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PhotoFileReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_file_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoFileReader), 0, (GInstanceInitFunc) photo_file_reader_instance_init, NULL };
		GType photo_file_reader_type_id;
		photo_file_reader_type_id = g_type_register_static (TYPE_PHOTO_FILE_ADAPTER, "PhotoFileReader", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&photo_file_reader_type_id__volatile, photo_file_reader_type_id);
	}
	return photo_file_reader_type_id__volatile;
}


PhotoFileWriter* photo_file_writer_construct (GType object_type, const gchar* filepath, PhotoFileFormat file_format) {
	PhotoFileWriter* self = NULL;
	const gchar* _tmp0_;
	PhotoFileFormat _tmp1_;
#line 101 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_return_val_if_fail (filepath != NULL, NULL);
#line 102 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp0_ = filepath;
#line 102 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp1_ = file_format;
#line 102 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	self = (PhotoFileWriter*) photo_file_adapter_construct (object_type, _tmp0_, _tmp1_);
#line 101 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	return self;
#line 1013 "PhotoFileAdapter.c"
}


PhotoFileReader* photo_file_writer_create_reader (PhotoFileWriter* self) {
	PhotoFileReader* result = NULL;
	PhotoFileFormat _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	PhotoFileReader* _tmp3_;
	PhotoFileReader* _tmp4_;
#line 105 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_WRITER (self), NULL);
#line 106 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp0_ = photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 106 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp1_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 106 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp2_ = _tmp1_;
#line 106 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp3_ = photo_file_format_create_reader (_tmp0_, _tmp2_);
#line 106 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp4_ = _tmp3_;
#line 106 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_g_free0 (_tmp2_);
#line 106 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	result = _tmp4_;
#line 106 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	return result;
#line 1042 "PhotoFileAdapter.c"
}


static void photo_file_writer_real_write (PhotoFileWriter* self, GdkPixbuf* pixbuf, JpegQuality quality, GError** error) {
#line 109 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_critical ("Type `%s' does not implement abstract method `photo_file_writer_write'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 109 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	return;
#line 1051 "PhotoFileAdapter.c"
}


void photo_file_writer_write (PhotoFileWriter* self, GdkPixbuf* pixbuf, JpegQuality quality, GError** error) {
#line 109 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_return_if_fail (IS_PHOTO_FILE_WRITER (self));
#line 109 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	PHOTO_FILE_WRITER_GET_CLASS (self)->write (self, pixbuf, quality, error);
#line 1060 "PhotoFileAdapter.c"
}


static void photo_file_writer_class_init (PhotoFileWriterClass * klass) {
#line 100 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	photo_file_writer_parent_class = g_type_class_peek_parent (klass);
#line 100 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	((PhotoFileWriterClass *) klass)->write = (void (*) (PhotoFileWriter *, GdkPixbuf*, JpegQuality, GError**)) photo_file_writer_real_write;
#line 1069 "PhotoFileAdapter.c"
}


static void photo_file_writer_instance_init (PhotoFileWriter * self) {
}


GType photo_file_writer_get_type (void) {
	static volatile gsize photo_file_writer_type_id__volatile = 0;
	if (g_once_init_enter (&photo_file_writer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PhotoFileWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_file_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoFileWriter), 0, (GInstanceInitFunc) photo_file_writer_instance_init, NULL };
		GType photo_file_writer_type_id;
		photo_file_writer_type_id = g_type_register_static (TYPE_PHOTO_FILE_ADAPTER, "PhotoFileWriter", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&photo_file_writer_type_id__volatile, photo_file_writer_type_id);
	}
	return photo_file_writer_type_id__volatile;
}


PhotoFileMetadataWriter* photo_file_metadata_writer_construct (GType object_type, const gchar* filepath, PhotoFileFormat file_format) {
	PhotoFileMetadataWriter* self = NULL;
	const gchar* _tmp0_;
	PhotoFileFormat _tmp1_;
#line 117 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_return_val_if_fail (filepath != NULL, NULL);
#line 118 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp0_ = filepath;
#line 118 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp1_ = file_format;
#line 118 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	self = (PhotoFileMetadataWriter*) photo_file_adapter_construct (object_type, _tmp0_, _tmp1_);
#line 117 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	return self;
#line 1103 "PhotoFileAdapter.c"
}


PhotoFileReader* photo_file_metadata_writer_create_reader (PhotoFileMetadataWriter* self) {
	PhotoFileReader* result = NULL;
	PhotoFileFormat _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	PhotoFileReader* _tmp3_;
	PhotoFileReader* _tmp4_;
#line 121 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_METADATA_WRITER (self), NULL);
#line 122 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp0_ = photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 122 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp1_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 122 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp2_ = _tmp1_;
#line 122 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp3_ = photo_file_format_create_reader (_tmp0_, _tmp2_);
#line 122 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_tmp4_ = _tmp3_;
#line 122 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	_g_free0 (_tmp2_);
#line 122 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	result = _tmp4_;
#line 122 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	return result;
#line 1132 "PhotoFileAdapter.c"
}


static void photo_file_metadata_writer_real_write_metadata (PhotoFileMetadataWriter* self, PhotoMetadata* metadata, GError** error) {
#line 125 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_critical ("Type `%s' does not implement abstract method `photo_file_metadata_writer_write_metadata'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 125 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	return;
#line 1141 "PhotoFileAdapter.c"
}


void photo_file_metadata_writer_write_metadata (PhotoFileMetadataWriter* self, PhotoMetadata* metadata, GError** error) {
#line 125 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	g_return_if_fail (IS_PHOTO_FILE_METADATA_WRITER (self));
#line 125 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	PHOTO_FILE_METADATA_WRITER_GET_CLASS (self)->write_metadata (self, metadata, error);
#line 1150 "PhotoFileAdapter.c"
}


static void photo_file_metadata_writer_class_init (PhotoFileMetadataWriterClass * klass) {
#line 116 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	photo_file_metadata_writer_parent_class = g_type_class_peek_parent (klass);
#line 116 "/home/jens/Source/shotwell/src/photos/PhotoFileAdapter.vala"
	((PhotoFileMetadataWriterClass *) klass)->write_metadata = (void (*) (PhotoFileMetadataWriter *, PhotoMetadata*, GError**)) photo_file_metadata_writer_real_write_metadata;
#line 1159 "PhotoFileAdapter.c"
}


static void photo_file_metadata_writer_instance_init (PhotoFileMetadataWriter * self) {
}


GType photo_file_metadata_writer_get_type (void) {
	static volatile gsize photo_file_metadata_writer_type_id__volatile = 0;
	if (g_once_init_enter (&photo_file_metadata_writer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PhotoFileMetadataWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_file_metadata_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoFileMetadataWriter), 0, (GInstanceInitFunc) photo_file_metadata_writer_instance_init, NULL };
		GType photo_file_metadata_writer_type_id;
		photo_file_metadata_writer_type_id = g_type_register_static (TYPE_PHOTO_FILE_ADAPTER, "PhotoFileMetadataWriter", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&photo_file_metadata_writer_type_id__volatile, photo_file_metadata_writer_type_id);
	}
	return photo_file_metadata_writer_type_id__volatile;
}



