/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import java.awt.event.MouseEvent;
import java.util.List;
import org.jhotdraw.figures.BorderDecorator;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.ActionTool;
import org.jhotdraw.standard.DecoratorFigure;
import org.jhotdraw.standard.FigureEnumerator;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class BorderTool
extends ActionTool {
    public BorderTool(DrawingEditor drawingEditor) {
        super(drawingEditor);
    }

    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        this.setView((DrawingView)mouseEvent.getSource());
        if ((mouseEvent.getModifiers() & 2) == 0) {
            super.mouseDown(mouseEvent, n, n2);
        } else {
            Figure figure = this.drawing().findFigure(n, n2);
            if (figure != null && figure != figure.getDecoratedFigure()) {
                this.view().addToSelection(figure);
                this.reverseAction(figure);
            }
        }
    }

    public void action(Figure figure) {
        this.setUndoActivity(this.createUndoActivity());
        List list = CollectionsFactory.current().createList();
        list.add(figure);
        list.add(new BorderDecorator(figure));
        this.getUndoActivity().setAffectedFigures(new FigureEnumerator(list));
        ((UndoActivity)this.getUndoActivity()).replaceAffectedFigures();
    }

    public void reverseAction(Figure figure) {
        this.setUndoActivity(this.createUndoActivity());
        List list = CollectionsFactory.current().createList();
        list.add(figure);
        list.add(((DecoratorFigure)figure).peelDecoration());
        this.getUndoActivity().setAffectedFigures(new FigureEnumerator(list));
        ((UndoActivity)this.getUndoActivity()).replaceAffectedFigures();
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view());
    }

    public static class UndoActivity
    extends UndoableAdapter {
        public UndoActivity(DrawingView drawingView) {
            super(drawingView);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            this.getDrawingView().clearSelection();
            return this.replaceAffectedFigures();
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            this.getDrawingView().clearSelection();
            return this.replaceAffectedFigures();
        }

        public boolean replaceAffectedFigures() {
            FigureEnumeration figureEnumeration = this.getAffectedFigures();
            if (!figureEnumeration.hasNextFigure()) {
                return false;
            }
            Figure figure = figureEnumeration.nextFigure();
            if (!figureEnumeration.hasNextFigure()) {
                return false;
            }
            Figure figure2 = figureEnumeration.nextFigure();
            figure2 = this.getDrawingView().drawing().replace(figure, figure2);
            List list = CollectionsFactory.current().createList();
            list.add(figure2);
            list.add(figure);
            this.setAffectedFigures(new FigureEnumerator(list));
            return true;
        }
    }
}

