/* testcollection.c generated by valac 0.19.0.4-d6d4, the Vala compiler
 * generated from testcollection.vala, do not modify */

/* testcollection.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois, Julien Peeters
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Didier 'Ptitjes' Villevalois <ptitjes@free.fr>
 * 	Julien Peeters <contact@julienpeeters.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define GEE_TYPE_TEST_CASE (gee_test_case_get_type ())
#define GEE_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEST_CASE, GeeTestCase))
#define GEE_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEST_CASE, GeeTestCaseClass))
#define GEE_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEST_CASE))
#define GEE_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEST_CASE))
#define GEE_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEST_CASE, GeeTestCaseClass))

typedef struct _GeeTestCase GeeTestCase;
typedef struct _GeeTestCaseClass GeeTestCaseClass;
typedef struct _GeeTestCasePrivate GeeTestCasePrivate;

#define TYPE_COLLECTION_TESTS (collection_tests_get_type ())
#define COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECTION_TESTS, CollectionTests))
#define COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECTION_TESTS, CollectionTestsClass))
#define IS_COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECTION_TESTS))
#define IS_COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECTION_TESTS))
#define COLLECTION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECTION_TESTS, CollectionTestsClass))

typedef struct _CollectionTests CollectionTests;
typedef struct _CollectionTestsClass CollectionTestsClass;
typedef struct _CollectionTestsPrivate CollectionTestsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GeeTestCase {
	GObject parent_instance;
	GeeTestCasePrivate * priv;
};

struct _GeeTestCaseClass {
	GObjectClass parent_class;
	void (*set_up) (GeeTestCase* self);
	void (*tear_down) (GeeTestCase* self);
};

struct _CollectionTests {
	GeeTestCase parent_instance;
	CollectionTestsPrivate * priv;
	GeeCollection* test_collection;
};

struct _CollectionTestsClass {
	GeeTestCaseClass parent_class;
};

typedef void (*GeeTestCaseTestMethod) (void* user_data);

static gpointer collection_tests_parent_class = NULL;

GType gee_test_case_get_type (void) G_GNUC_CONST;
GType collection_tests_get_type (void) G_GNUC_CONST;
enum  {
	COLLECTION_TESTS_DUMMY_PROPERTY
};
CollectionTests* collection_tests_construct (GType object_type, const gchar* name);
GeeTestCase* gee_test_case_construct (GType object_type, const gchar* name);
void gee_test_case_add_test (GeeTestCase* self, const gchar* name, GeeTestCaseTestMethod test, void* test_target);
void collection_tests_test_type_correctness (CollectionTests* self);
static void _collection_tests_test_type_correctness_gee_test_case_test_method (gpointer self);
void collection_tests_test_iterator_returns_all_elements_once (CollectionTests* self);
static void _collection_tests_test_iterator_returns_all_elements_once_gee_test_case_test_method (gpointer self);
void collection_tests_test_mutable_iterator (CollectionTests* self);
static void _collection_tests_test_mutable_iterator_gee_test_case_test_method (gpointer self);
void collection_tests_test_contains_size_and_is_empty (CollectionTests* self);
static void _collection_tests_test_contains_size_and_is_empty_gee_test_case_test_method (gpointer self);
void collection_tests_test_add_remove (CollectionTests* self);
static void _collection_tests_test_add_remove_gee_test_case_test_method (gpointer self);
void collection_tests_test_clear (CollectionTests* self);
static void _collection_tests_test_clear_gee_test_case_test_method (gpointer self);
void collection_tests_test_add_all (CollectionTests* self);
static void _collection_tests_test_add_all_gee_test_case_test_method (gpointer self);
void collection_tests_test_contains_all (CollectionTests* self);
static void _collection_tests_test_contains_all_gee_test_case_test_method (gpointer self);
void collection_tests_test_remove_all (CollectionTests* self);
static void _collection_tests_test_remove_all_gee_test_case_test_method (gpointer self);
void collection_tests_test_retain_all (CollectionTests* self);
static void _collection_tests_test_retain_all_gee_test_case_test_method (gpointer self);
void collection_tests_test_to_array (CollectionTests* self);
static void _collection_tests_test_to_array_gee_test_case_test_method (gpointer self);
void collection_tests_test_gobject_properties (CollectionTests* self);
static void _collection_tests_test_gobject_properties_gee_test_case_test_method (gpointer self);
static void collection_tests_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _collection_tests_test_type_correctness_gee_test_case_test_method (gpointer self) {
	collection_tests_test_type_correctness (self);
}


static void _collection_tests_test_iterator_returns_all_elements_once_gee_test_case_test_method (gpointer self) {
	collection_tests_test_iterator_returns_all_elements_once (self);
}


static void _collection_tests_test_mutable_iterator_gee_test_case_test_method (gpointer self) {
	collection_tests_test_mutable_iterator (self);
}


static void _collection_tests_test_contains_size_and_is_empty_gee_test_case_test_method (gpointer self) {
	collection_tests_test_contains_size_and_is_empty (self);
}


static void _collection_tests_test_add_remove_gee_test_case_test_method (gpointer self) {
	collection_tests_test_add_remove (self);
}


static void _collection_tests_test_clear_gee_test_case_test_method (gpointer self) {
	collection_tests_test_clear (self);
}


static void _collection_tests_test_add_all_gee_test_case_test_method (gpointer self) {
	collection_tests_test_add_all (self);
}


static void _collection_tests_test_contains_all_gee_test_case_test_method (gpointer self) {
	collection_tests_test_contains_all (self);
}


static void _collection_tests_test_remove_all_gee_test_case_test_method (gpointer self) {
	collection_tests_test_remove_all (self);
}


static void _collection_tests_test_retain_all_gee_test_case_test_method (gpointer self) {
	collection_tests_test_retain_all (self);
}


static void _collection_tests_test_to_array_gee_test_case_test_method (gpointer self) {
	collection_tests_test_to_array (self);
}


static void _collection_tests_test_gobject_properties_gee_test_case_test_method (gpointer self) {
	collection_tests_test_gobject_properties (self);
}


CollectionTests* collection_tests_construct (GType object_type, const gchar* name) {
	CollectionTests * self = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	self = (CollectionTests*) gee_test_case_construct (object_type, _tmp0_);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] type correctness", _collection_tests_test_type_correctness_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] iterator returns all elements once", _collection_tests_test_iterator_returns_all_elements_once_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] mutable iterator", _collection_tests_test_mutable_iterator_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] contains, size and is_empty", _collection_tests_test_contains_size_and_is_empty_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] add and remove", _collection_tests_test_add_remove_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] clear", _collection_tests_test_clear_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] add_all", _collection_tests_test_add_all_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] contains_all", _collection_tests_test_contains_all_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] remove_all", _collection_tests_test_remove_all_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] retain_all", _collection_tests_test_retain_all_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] to_array", _collection_tests_test_to_array_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] GObject properties", _collection_tests_test_gobject_properties_gee_test_case_test_method, self);
	return self;
}


void collection_tests_test_type_correctness (CollectionTests* self) {
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GType _tmp2_;
	GType _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp1_ = self->test_collection;
	_tmp2_ = gee_iterable_get_element_type ((GeeIterable*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_assert (_tmp3_ == G_TYPE_STRING, "test_collection.element_type == typeof (string)");
}


void collection_tests_test_iterator_returns_all_elements_once (CollectionTests* self) {
	GeeCollection* _tmp0_;
	gboolean has_next = FALSE;
	GeeCollection* _tmp1_;
	GeeIterator* _tmp2_ = NULL;
	GeeIterator* iterator;
	GeeIterator* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GeeIterator* _tmp5_;
	gboolean _tmp6_ = FALSE;
	GeeIterator* _tmp7_;
	gboolean _tmp8_ = FALSE;
	GeeCollection* _tmp9_;
	gboolean _tmp10_ = FALSE;
	GeeCollection* _tmp11_;
	gboolean _tmp12_ = FALSE;
	GeeCollection* _tmp13_;
	gboolean _tmp14_ = FALSE;
	gboolean one_found;
	gboolean two_found;
	gboolean three_found;
	gboolean one_found_once;
	gboolean two_found_once;
	gboolean three_found_once;
	GeeCollection* _tmp15_;
	GeeIterator* _tmp16_ = NULL;
	GeeIterator* _tmp31_;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_;
	gboolean _tmp34_;
	GeeIterator* _tmp35_;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_;
	gboolean _tmp38_;
	gboolean _tmp39_;
	gboolean _tmp40_;
	gboolean _tmp41_;
	gboolean _tmp42_;
	GeeIterator* _tmp43_;
	gboolean _tmp44_ = FALSE;
	GeeIterator* _tmp59_;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp61_;
	gboolean _tmp62_;
	GeeIterator* _tmp63_;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp65_;
	gboolean _tmp66_;
	gboolean _tmp67_;
	gboolean _tmp68_;
	gboolean _tmp69_;
	gboolean _tmp70_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp1_ = self->test_collection;
	_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
	iterator = _tmp2_;
	_tmp3_ = iterator;
	_tmp4_ = gee_iterator_has_next (_tmp3_);
	_vala_assert (!_tmp4_, "! iterator.has_next ()");
	_tmp5_ = iterator;
	_tmp6_ = gee_iterator_next (_tmp5_);
	_vala_assert (!_tmp6_, "! iterator.next ()");
	_tmp7_ = iterator;
	_tmp8_ = gee_iterator_first (_tmp7_);
	_vala_assert (!_tmp8_, "! iterator.first ()");
	_tmp9_ = self->test_collection;
	_tmp10_ = gee_collection_add (_tmp9_, "one");
	_vala_assert (_tmp10_, "test_collection.add (\"one\")");
	_tmp11_ = self->test_collection;
	_tmp12_ = gee_collection_add (_tmp11_, "two");
	_vala_assert (_tmp12_, "test_collection.add (\"two\")");
	_tmp13_ = self->test_collection;
	_tmp14_ = gee_collection_add (_tmp13_, "three");
	_vala_assert (_tmp14_, "test_collection.add (\"three\")");
	one_found = FALSE;
	two_found = FALSE;
	three_found = FALSE;
	one_found_once = TRUE;
	two_found_once = TRUE;
	three_found_once = TRUE;
	_tmp15_ = self->test_collection;
	_tmp16_ = gee_iterable_iterator ((GeeIterable*) _tmp15_);
	_g_object_unref0 (iterator);
	iterator = _tmp16_;
	while (TRUE) {
		GeeIterator* _tmp17_;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_;
		GeeIterator* _tmp20_;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_;
		GeeIterator* _tmp23_;
		gpointer _tmp24_ = NULL;
		gchar* element;
		const gchar* _tmp25_;
		_tmp17_ = iterator;
		_tmp18_ = gee_iterator_has_next (_tmp17_);
		has_next = _tmp18_;
		_tmp19_ = has_next;
		_tmp20_ = iterator;
		_tmp21_ = gee_iterator_next (_tmp20_);
		_vala_assert (_tmp19_ == _tmp21_, "has_next == iterator.next ()");
		_tmp22_ = has_next;
		if (!_tmp22_) {
			break;
		}
		_tmp23_ = iterator;
		_tmp24_ = gee_iterator_get (_tmp23_);
		element = (gchar*) _tmp24_;
		_tmp25_ = element;
		if (g_strcmp0 (_tmp25_, "one") == 0) {
			gboolean _tmp26_;
			_tmp26_ = one_found;
			if (_tmp26_) {
				one_found_once = FALSE;
			}
			one_found = TRUE;
		} else {
			const gchar* _tmp27_;
			_tmp27_ = element;
			if (g_strcmp0 (_tmp27_, "two") == 0) {
				gboolean _tmp28_;
				_tmp28_ = two_found;
				if (_tmp28_) {
					two_found_once = FALSE;
				}
				two_found = TRUE;
			} else {
				const gchar* _tmp29_;
				_tmp29_ = element;
				if (g_strcmp0 (_tmp29_, "three") == 0) {
					gboolean _tmp30_;
					_tmp30_ = three_found;
					if (_tmp30_) {
						three_found_once = FALSE;
					}
					three_found = TRUE;
				}
			}
		}
		_g_free0 (element);
	}
	_tmp31_ = iterator;
	_tmp32_ = gee_iterator_has_next (_tmp31_);
	has_next = _tmp32_;
	_tmp33_ = has_next;
	_vala_assert (!_tmp33_, "! has_next");
	_tmp34_ = has_next;
	_tmp35_ = iterator;
	_tmp36_ = gee_iterator_next (_tmp35_);
	_vala_assert (_tmp34_ == _tmp36_, "has_next == iterator.next ()");
	_tmp37_ = one_found;
	_vala_assert (_tmp37_, "one_found");
	_tmp38_ = one_found_once;
	_vala_assert (_tmp38_, "one_found_once");
	_tmp39_ = two_found;
	_vala_assert (_tmp39_, "two_found");
	_tmp40_ = two_found_once;
	_vala_assert (_tmp40_, "two_found_once");
	_tmp41_ = three_found;
	_vala_assert (_tmp41_, "three_found");
	_tmp42_ = three_found_once;
	_vala_assert (_tmp42_, "three_found_once");
	_tmp43_ = iterator;
	_tmp44_ = gee_iterator_first (_tmp43_);
	_vala_assert (_tmp44_, "iterator.first ()");
	one_found = FALSE;
	two_found = FALSE;
	three_found = FALSE;
	one_found_once = TRUE;
	two_found_once = TRUE;
	three_found_once = TRUE;
	while (TRUE) {
		GeeIterator* _tmp45_;
		gpointer _tmp46_ = NULL;
		gchar* element;
		const gchar* _tmp47_;
		GeeIterator* _tmp53_;
		gboolean _tmp54_ = FALSE;
		gboolean _tmp55_;
		GeeIterator* _tmp56_;
		gboolean _tmp57_ = FALSE;
		gboolean _tmp58_;
		_tmp45_ = iterator;
		_tmp46_ = gee_iterator_get (_tmp45_);
		element = (gchar*) _tmp46_;
		_tmp47_ = element;
		if (g_strcmp0 (_tmp47_, "one") == 0) {
			gboolean _tmp48_;
			_tmp48_ = one_found;
			if (_tmp48_) {
				one_found_once = FALSE;
			}
			one_found = TRUE;
		} else {
			const gchar* _tmp49_;
			_tmp49_ = element;
			if (g_strcmp0 (_tmp49_, "two") == 0) {
				gboolean _tmp50_;
				_tmp50_ = two_found;
				if (_tmp50_) {
					two_found_once = FALSE;
				}
				two_found = TRUE;
			} else {
				const gchar* _tmp51_;
				_tmp51_ = element;
				if (g_strcmp0 (_tmp51_, "three") == 0) {
					gboolean _tmp52_;
					_tmp52_ = three_found;
					if (_tmp52_) {
						three_found_once = FALSE;
					}
					three_found = TRUE;
				}
			}
		}
		_tmp53_ = iterator;
		_tmp54_ = gee_iterator_has_next (_tmp53_);
		has_next = _tmp54_;
		_tmp55_ = has_next;
		_tmp56_ = iterator;
		_tmp57_ = gee_iterator_next (_tmp56_);
		_vala_assert (_tmp55_ == _tmp57_, "has_next == iterator.next ()");
		_tmp58_ = has_next;
		if (!_tmp58_) {
			_g_free0 (element);
			break;
		}
		_g_free0 (element);
	}
	_tmp59_ = iterator;
	_tmp60_ = gee_iterator_has_next (_tmp59_);
	has_next = _tmp60_;
	_tmp61_ = has_next;
	_vala_assert (!_tmp61_, "! has_next");
	_tmp62_ = has_next;
	_tmp63_ = iterator;
	_tmp64_ = gee_iterator_next (_tmp63_);
	_vala_assert (_tmp62_ == _tmp64_, "has_next == iterator.next ()");
	_tmp65_ = one_found;
	_vala_assert (_tmp65_, "one_found");
	_tmp66_ = one_found_once;
	_vala_assert (_tmp66_, "one_found_once");
	_tmp67_ = two_found;
	_vala_assert (_tmp67_, "two_found");
	_tmp68_ = two_found_once;
	_vala_assert (_tmp68_, "two_found_once");
	_tmp69_ = three_found;
	_vala_assert (_tmp69_, "three_found");
	_tmp70_ = three_found_once;
	_vala_assert (_tmp70_, "three_found_once");
	_g_object_unref0 (iterator);
}


void collection_tests_test_mutable_iterator (CollectionTests* self) {
	GeeCollection* _tmp0_;
	gboolean has_next = FALSE;
	GeeCollection* _tmp1_;
	GeeIterator* _tmp2_ = NULL;
	GeeIterator* iterator;
	GeeCollection* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GeeCollection* _tmp5_;
	gboolean _tmp6_ = FALSE;
	GeeCollection* _tmp7_;
	gboolean _tmp8_ = FALSE;
	gboolean one_found;
	gboolean two_found;
	gboolean three_found;
	gboolean one_found_once;
	gboolean two_found_once;
	gboolean three_found_once;
	GeeCollection* _tmp9_;
	GeeIterator* _tmp10_ = NULL;
	GeeIterator* _tmp26_;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_;
	gboolean _tmp29_;
	GeeIterator* _tmp30_;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_;
	gboolean _tmp33_;
	gboolean _tmp34_;
	gboolean _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	GeeIterator* _tmp38_;
	gboolean _tmp39_ = FALSE;
	GeeIterator* _tmp53_;
	gboolean _tmp54_ = FALSE;
	gboolean _tmp55_;
	gboolean _tmp56_;
	GeeIterator* _tmp57_;
	gboolean _tmp58_ = FALSE;
	gboolean _tmp59_;
	gboolean _tmp60_;
	gboolean _tmp61_;
	gboolean _tmp62_;
	gboolean _tmp63_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp1_ = self->test_collection;
	_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
	iterator = _tmp2_;
	_tmp3_ = self->test_collection;
	_tmp4_ = gee_collection_add (_tmp3_, "one");
	_vala_assert (_tmp4_, "test_collection.add (\"one\")");
	_tmp5_ = self->test_collection;
	_tmp6_ = gee_collection_add (_tmp5_, "two");
	_vala_assert (_tmp6_, "test_collection.add (\"two\")");
	_tmp7_ = self->test_collection;
	_tmp8_ = gee_collection_add (_tmp7_, "three");
	_vala_assert (_tmp8_, "test_collection.add (\"three\")");
	one_found = FALSE;
	two_found = FALSE;
	three_found = FALSE;
	one_found_once = TRUE;
	two_found_once = TRUE;
	three_found_once = TRUE;
	_tmp9_ = self->test_collection;
	_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
	_g_object_unref0 (iterator);
	iterator = _tmp10_;
	while (TRUE) {
		GeeIterator* _tmp11_;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_;
		GeeIterator* _tmp14_;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_;
		GeeIterator* _tmp17_;
		gpointer _tmp18_ = NULL;
		gchar* element;
		const gchar* _tmp19_;
		_tmp11_ = iterator;
		_tmp12_ = gee_iterator_has_next (_tmp11_);
		has_next = _tmp12_;
		_tmp13_ = has_next;
		_tmp14_ = iterator;
		_tmp15_ = gee_iterator_next (_tmp14_);
		_vala_assert (_tmp13_ == _tmp15_, "has_next == iterator.next ()");
		_tmp16_ = has_next;
		if (!_tmp16_) {
			break;
		}
		_tmp17_ = iterator;
		_tmp18_ = gee_iterator_get (_tmp17_);
		element = (gchar*) _tmp18_;
		_tmp19_ = element;
		if (g_strcmp0 (_tmp19_, "one") == 0) {
			gboolean _tmp20_;
			_tmp20_ = one_found;
			if (_tmp20_) {
				one_found_once = FALSE;
			}
			one_found = TRUE;
		} else {
			const gchar* _tmp21_;
			_tmp21_ = element;
			if (g_strcmp0 (_tmp21_, "two") == 0) {
				gboolean _tmp22_;
				GeeIterator* _tmp23_;
				_tmp22_ = two_found;
				if (_tmp22_) {
					two_found_once = FALSE;
				}
				two_found = TRUE;
				_tmp23_ = iterator;
				gee_iterator_remove (_tmp23_);
			} else {
				const gchar* _tmp24_;
				_tmp24_ = element;
				if (g_strcmp0 (_tmp24_, "three") == 0) {
					gboolean _tmp25_;
					_tmp25_ = three_found;
					if (_tmp25_) {
						three_found_once = FALSE;
					}
					three_found = TRUE;
				}
			}
		}
		_g_free0 (element);
	}
	_tmp26_ = iterator;
	_tmp27_ = gee_iterator_has_next (_tmp26_);
	has_next = _tmp27_;
	_tmp28_ = has_next;
	_vala_assert (!_tmp28_, "! has_next");
	_tmp29_ = has_next;
	_tmp30_ = iterator;
	_tmp31_ = gee_iterator_next (_tmp30_);
	_vala_assert (_tmp29_ == _tmp31_, "has_next == iterator.next ()");
	_tmp32_ = one_found;
	_vala_assert (_tmp32_, "one_found");
	_tmp33_ = one_found_once;
	_vala_assert (_tmp33_, "one_found_once");
	_tmp34_ = two_found;
	_vala_assert (_tmp34_, "two_found");
	_tmp35_ = two_found_once;
	_vala_assert (_tmp35_, "two_found_once");
	_tmp36_ = three_found;
	_vala_assert (_tmp36_, "three_found");
	_tmp37_ = three_found_once;
	_vala_assert (_tmp37_, "three_found_once");
	_tmp38_ = iterator;
	_tmp39_ = gee_iterator_first (_tmp38_);
	_vala_assert (_tmp39_, "iterator.first ()");
	one_found = FALSE;
	two_found = FALSE;
	three_found = FALSE;
	one_found_once = TRUE;
	two_found_once = TRUE;
	three_found_once = TRUE;
	while (TRUE) {
		GeeIterator* _tmp40_;
		gpointer _tmp41_ = NULL;
		gchar* element;
		const gchar* _tmp42_;
		GeeIterator* _tmp47_;
		gboolean _tmp48_ = FALSE;
		gboolean _tmp49_;
		GeeIterator* _tmp50_;
		gboolean _tmp51_ = FALSE;
		gboolean _tmp52_;
		_tmp40_ = iterator;
		_tmp41_ = gee_iterator_get (_tmp40_);
		element = (gchar*) _tmp41_;
		_tmp42_ = element;
		if (g_strcmp0 (_tmp42_, "one") == 0) {
			gboolean _tmp43_;
			_tmp43_ = one_found;
			if (_tmp43_) {
				one_found_once = FALSE;
			}
			one_found = TRUE;
		} else {
			const gchar* _tmp44_;
			_tmp44_ = element;
			if (g_strcmp0 (_tmp44_, "two") == 0) {
				two_found = TRUE;
			} else {
				const gchar* _tmp45_;
				_tmp45_ = element;
				if (g_strcmp0 (_tmp45_, "three") == 0) {
					gboolean _tmp46_;
					_tmp46_ = three_found;
					if (_tmp46_) {
						three_found_once = FALSE;
					}
					three_found = TRUE;
				}
			}
		}
		_tmp47_ = iterator;
		_tmp48_ = gee_iterator_has_next (_tmp47_);
		has_next = _tmp48_;
		_tmp49_ = has_next;
		_tmp50_ = iterator;
		_tmp51_ = gee_iterator_next (_tmp50_);
		_vala_assert (_tmp49_ == _tmp51_, "has_next == iterator.next ()");
		_tmp52_ = has_next;
		if (!_tmp52_) {
			_g_free0 (element);
			break;
		}
		_g_free0 (element);
	}
	_tmp53_ = iterator;
	_tmp54_ = gee_iterator_has_next (_tmp53_);
	has_next = _tmp54_;
	_tmp55_ = has_next;
	_vala_assert (!_tmp55_, "! has_next");
	_tmp56_ = has_next;
	_tmp57_ = iterator;
	_tmp58_ = gee_iterator_next (_tmp57_);
	_vala_assert (_tmp56_ == _tmp58_, "has_next == iterator.next ()");
	_tmp59_ = one_found;
	_vala_assert (_tmp59_, "one_found");
	_tmp60_ = one_found_once;
	_vala_assert (_tmp60_, "one_found_once");
	_tmp61_ = two_found;
	_vala_assert (!_tmp61_, "!two_found");
	_tmp62_ = three_found;
	_vala_assert (_tmp62_, "three_found");
	_tmp63_ = three_found_once;
	_vala_assert (_tmp63_, "three_found_once");
	_g_object_unref0 (iterator);
}


void collection_tests_test_contains_size_and_is_empty (CollectionTests* self) {
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeCollection* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GeeCollection* _tmp5_;
	gboolean _tmp6_ = FALSE;
	GeeCollection* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GeeCollection* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	GeeCollection* _tmp13_;
	gboolean _tmp14_ = FALSE;
	GeeCollection* _tmp15_;
	gboolean _tmp16_ = FALSE;
	GeeCollection* _tmp17_;
	gboolean _tmp18_ = FALSE;
	GeeCollection* _tmp19_;
	gboolean _tmp20_ = FALSE;
	GeeCollection* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	GeeCollection* _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	GeeCollection* _tmp27_;
	gboolean _tmp28_ = FALSE;
	GeeCollection* _tmp29_;
	gboolean _tmp30_ = FALSE;
	GeeCollection* _tmp31_;
	gboolean _tmp32_ = FALSE;
	GeeCollection* _tmp33_;
	gboolean _tmp34_ = FALSE;
	GeeCollection* _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	GeeCollection* _tmp38_;
	gboolean _tmp39_;
	gboolean _tmp40_;
	GeeCollection* _tmp41_;
	gboolean _tmp42_ = FALSE;
	GeeCollection* _tmp43_;
	gboolean _tmp44_ = FALSE;
	GeeCollection* _tmp45_;
	gboolean _tmp46_ = FALSE;
	GeeCollection* _tmp47_;
	gboolean _tmp48_ = FALSE;
	GeeCollection* _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	GeeCollection* _tmp52_;
	gboolean _tmp53_;
	gboolean _tmp54_;
	GeeCollection* _tmp55_;
	gboolean _tmp56_ = FALSE;
	GeeCollection* _tmp57_;
	gboolean _tmp58_ = FALSE;
	GeeCollection* _tmp59_;
	gboolean _tmp60_ = FALSE;
	GeeCollection* _tmp61_;
	gboolean _tmp62_ = FALSE;
	GeeCollection* _tmp63_;
	gint _tmp64_;
	gint _tmp65_;
	GeeCollection* _tmp66_;
	gboolean _tmp67_;
	gboolean _tmp68_;
	GeeCollection* _tmp69_;
	gboolean _tmp70_ = FALSE;
	GeeCollection* _tmp71_;
	gboolean _tmp72_ = FALSE;
	GeeCollection* _tmp73_;
	gboolean _tmp74_ = FALSE;
	GeeCollection* _tmp75_;
	gboolean _tmp76_ = FALSE;
	GeeCollection* _tmp77_;
	gint _tmp78_;
	gint _tmp79_;
	GeeCollection* _tmp80_;
	gboolean _tmp81_;
	gboolean _tmp82_;
	GeeCollection* _tmp83_;
	gboolean _tmp84_ = FALSE;
	GeeCollection* _tmp85_;
	gboolean _tmp86_ = FALSE;
	GeeCollection* _tmp87_;
	gboolean _tmp88_ = FALSE;
	GeeCollection* _tmp89_;
	gboolean _tmp90_ = FALSE;
	GeeCollection* _tmp91_;
	gint _tmp92_;
	gint _tmp93_;
	GeeCollection* _tmp94_;
	gboolean _tmp95_;
	gboolean _tmp96_;
	GeeCollection* _tmp97_;
	gboolean _tmp98_ = FALSE;
	GeeCollection* _tmp99_;
	gboolean _tmp100_ = FALSE;
	GeeCollection* _tmp101_;
	gboolean _tmp102_ = FALSE;
	GeeCollection* _tmp103_;
	gboolean _tmp104_ = FALSE;
	GeeCollection* _tmp105_;
	gint _tmp106_;
	gint _tmp107_;
	GeeCollection* _tmp108_;
	gboolean _tmp109_;
	gboolean _tmp110_;
	GeeCollection* _tmp111_;
	GeeCollection* _tmp112_;
	gboolean _tmp113_ = FALSE;
	GeeCollection* _tmp114_;
	gboolean _tmp115_ = FALSE;
	GeeCollection* _tmp116_;
	gboolean _tmp117_ = FALSE;
	GeeCollection* _tmp118_;
	gint _tmp119_;
	gint _tmp120_;
	GeeCollection* _tmp121_;
	gboolean _tmp122_;
	gboolean _tmp123_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp1_ = self->test_collection;
	_tmp2_ = gee_collection_contains (_tmp1_, "one");
	_vala_assert (!_tmp2_, "! test_collection.contains (\"one\")");
	_tmp3_ = self->test_collection;
	_tmp4_ = gee_collection_contains (_tmp3_, "two");
	_vala_assert (!_tmp4_, "! test_collection.contains (\"two\")");
	_tmp5_ = self->test_collection;
	_tmp6_ = gee_collection_contains (_tmp5_, "three");
	_vala_assert (!_tmp6_, "! test_collection.contains (\"three\")");
	_tmp7_ = self->test_collection;
	_tmp8_ = gee_collection_get_size (_tmp7_);
	_tmp9_ = _tmp8_;
	_vala_assert (_tmp9_ == 0, "test_collection.size == 0");
	_tmp10_ = self->test_collection;
	_tmp11_ = gee_collection_get_is_empty (_tmp10_);
	_tmp12_ = _tmp11_;
	_vala_assert (_tmp12_, "test_collection.is_empty");
	_tmp13_ = self->test_collection;
	_tmp14_ = gee_collection_add (_tmp13_, "one");
	_vala_assert (_tmp14_, "test_collection.add (\"one\")");
	_tmp15_ = self->test_collection;
	_tmp16_ = gee_collection_contains (_tmp15_, "one");
	_vala_assert (_tmp16_, "test_collection.contains (\"one\")");
	_tmp17_ = self->test_collection;
	_tmp18_ = gee_collection_contains (_tmp17_, "two");
	_vala_assert (!_tmp18_, "! test_collection.contains (\"two\")");
	_tmp19_ = self->test_collection;
	_tmp20_ = gee_collection_contains (_tmp19_, "three");
	_vala_assert (!_tmp20_, "! test_collection.contains (\"three\")");
	_tmp21_ = self->test_collection;
	_tmp22_ = gee_collection_get_size (_tmp21_);
	_tmp23_ = _tmp22_;
	_vala_assert (_tmp23_ == 1, "test_collection.size == 1");
	_tmp24_ = self->test_collection;
	_tmp25_ = gee_collection_get_is_empty (_tmp24_);
	_tmp26_ = _tmp25_;
	_vala_assert (!_tmp26_, "! test_collection.is_empty");
	_tmp27_ = self->test_collection;
	_tmp28_ = gee_collection_remove (_tmp27_, "one");
	_vala_assert (_tmp28_, "test_collection.remove (\"one\")");
	_tmp29_ = self->test_collection;
	_tmp30_ = gee_collection_contains (_tmp29_, "one");
	_vala_assert (!_tmp30_, "! test_collection.contains (\"one\")");
	_tmp31_ = self->test_collection;
	_tmp32_ = gee_collection_contains (_tmp31_, "two");
	_vala_assert (!_tmp32_, "! test_collection.contains (\"two\")");
	_tmp33_ = self->test_collection;
	_tmp34_ = gee_collection_contains (_tmp33_, "three");
	_vala_assert (!_tmp34_, "! test_collection.contains (\"three\")");
	_tmp35_ = self->test_collection;
	_tmp36_ = gee_collection_get_size (_tmp35_);
	_tmp37_ = _tmp36_;
	_vala_assert (_tmp37_ == 0, "test_collection.size == 0");
	_tmp38_ = self->test_collection;
	_tmp39_ = gee_collection_get_is_empty (_tmp38_);
	_tmp40_ = _tmp39_;
	_vala_assert (_tmp40_, "test_collection.is_empty");
	_tmp41_ = self->test_collection;
	_tmp42_ = gee_collection_add (_tmp41_, "one");
	_vala_assert (_tmp42_, "test_collection.add (\"one\")");
	_tmp43_ = self->test_collection;
	_tmp44_ = gee_collection_contains (_tmp43_, "one");
	_vala_assert (_tmp44_, "test_collection.contains (\"one\")");
	_tmp45_ = self->test_collection;
	_tmp46_ = gee_collection_contains (_tmp45_, "two");
	_vala_assert (!_tmp46_, "! test_collection.contains (\"two\")");
	_tmp47_ = self->test_collection;
	_tmp48_ = gee_collection_contains (_tmp47_, "three");
	_vala_assert (!_tmp48_, "! test_collection.contains (\"three\")");
	_tmp49_ = self->test_collection;
	_tmp50_ = gee_collection_get_size (_tmp49_);
	_tmp51_ = _tmp50_;
	_vala_assert (_tmp51_ == 1, "test_collection.size == 1");
	_tmp52_ = self->test_collection;
	_tmp53_ = gee_collection_get_is_empty (_tmp52_);
	_tmp54_ = _tmp53_;
	_vala_assert (!_tmp54_, "! test_collection.is_empty");
	_tmp55_ = self->test_collection;
	_tmp56_ = gee_collection_add (_tmp55_, "two");
	_vala_assert (_tmp56_, "test_collection.add (\"two\")");
	_tmp57_ = self->test_collection;
	_tmp58_ = gee_collection_contains (_tmp57_, "one");
	_vala_assert (_tmp58_, "test_collection.contains (\"one\")");
	_tmp59_ = self->test_collection;
	_tmp60_ = gee_collection_contains (_tmp59_, "two");
	_vala_assert (_tmp60_, "test_collection.contains (\"two\")");
	_tmp61_ = self->test_collection;
	_tmp62_ = gee_collection_contains (_tmp61_, "three");
	_vala_assert (!_tmp62_, "! test_collection.contains (\"three\")");
	_tmp63_ = self->test_collection;
	_tmp64_ = gee_collection_get_size (_tmp63_);
	_tmp65_ = _tmp64_;
	_vala_assert (_tmp65_ == 2, "test_collection.size == 2");
	_tmp66_ = self->test_collection;
	_tmp67_ = gee_collection_get_is_empty (_tmp66_);
	_tmp68_ = _tmp67_;
	_vala_assert (!_tmp68_, "! test_collection.is_empty");
	_tmp69_ = self->test_collection;
	_tmp70_ = gee_collection_add (_tmp69_, "three");
	_vala_assert (_tmp70_, "test_collection.add (\"three\")");
	_tmp71_ = self->test_collection;
	_tmp72_ = gee_collection_contains (_tmp71_, "one");
	_vala_assert (_tmp72_, "test_collection.contains (\"one\")");
	_tmp73_ = self->test_collection;
	_tmp74_ = gee_collection_contains (_tmp73_, "two");
	_vala_assert (_tmp74_, "test_collection.contains (\"two\")");
	_tmp75_ = self->test_collection;
	_tmp76_ = gee_collection_contains (_tmp75_, "three");
	_vala_assert (_tmp76_, "test_collection.contains (\"three\")");
	_tmp77_ = self->test_collection;
	_tmp78_ = gee_collection_get_size (_tmp77_);
	_tmp79_ = _tmp78_;
	_vala_assert (_tmp79_ == 3, "test_collection.size == 3");
	_tmp80_ = self->test_collection;
	_tmp81_ = gee_collection_get_is_empty (_tmp80_);
	_tmp82_ = _tmp81_;
	_vala_assert (!_tmp82_, "! test_collection.is_empty");
	_tmp83_ = self->test_collection;
	_tmp84_ = gee_collection_remove (_tmp83_, "two");
	_vala_assert (_tmp84_, "test_collection.remove (\"two\")");
	_tmp85_ = self->test_collection;
	_tmp86_ = gee_collection_contains (_tmp85_, "one");
	_vala_assert (_tmp86_, "test_collection.contains (\"one\")");
	_tmp87_ = self->test_collection;
	_tmp88_ = gee_collection_contains (_tmp87_, "two");
	_vala_assert (!_tmp88_, "! test_collection.contains (\"two\")");
	_tmp89_ = self->test_collection;
	_tmp90_ = gee_collection_contains (_tmp89_, "three");
	_vala_assert (_tmp90_, "test_collection.contains (\"three\")");
	_tmp91_ = self->test_collection;
	_tmp92_ = gee_collection_get_size (_tmp91_);
	_tmp93_ = _tmp92_;
	_vala_assert (_tmp93_ == 2, "test_collection.size == 2");
	_tmp94_ = self->test_collection;
	_tmp95_ = gee_collection_get_is_empty (_tmp94_);
	_tmp96_ = _tmp95_;
	_vala_assert (!_tmp96_, "! test_collection.is_empty");
	_tmp97_ = self->test_collection;
	_tmp98_ = gee_collection_remove (_tmp97_, "two");
	_vala_assert (!_tmp98_, "! test_collection.remove (\"two\")");
	_tmp99_ = self->test_collection;
	_tmp100_ = gee_collection_contains (_tmp99_, "one");
	_vala_assert (_tmp100_, "test_collection.contains (\"one\")");
	_tmp101_ = self->test_collection;
	_tmp102_ = gee_collection_contains (_tmp101_, "two");
	_vala_assert (!_tmp102_, "! test_collection.contains (\"two\")");
	_tmp103_ = self->test_collection;
	_tmp104_ = gee_collection_contains (_tmp103_, "three");
	_vala_assert (_tmp104_, "test_collection.contains (\"three\")");
	_tmp105_ = self->test_collection;
	_tmp106_ = gee_collection_get_size (_tmp105_);
	_tmp107_ = _tmp106_;
	_vala_assert (_tmp107_ == 2, "test_collection.size == 2");
	_tmp108_ = self->test_collection;
	_tmp109_ = gee_collection_get_is_empty (_tmp108_);
	_tmp110_ = _tmp109_;
	_vala_assert (!_tmp110_, "! test_collection.is_empty");
	_tmp111_ = self->test_collection;
	gee_collection_clear (_tmp111_);
	_tmp112_ = self->test_collection;
	_tmp113_ = gee_collection_contains (_tmp112_, "one");
	_vala_assert (!_tmp113_, "! test_collection.contains (\"one\")");
	_tmp114_ = self->test_collection;
	_tmp115_ = gee_collection_contains (_tmp114_, "two");
	_vala_assert (!_tmp115_, "! test_collection.contains (\"two\")");
	_tmp116_ = self->test_collection;
	_tmp117_ = gee_collection_contains (_tmp116_, "three");
	_vala_assert (!_tmp117_, "! test_collection.contains (\"three\")");
	_tmp118_ = self->test_collection;
	_tmp119_ = gee_collection_get_size (_tmp118_);
	_tmp120_ = _tmp119_;
	_vala_assert (_tmp120_ == 0, "test_collection.size == 0");
	_tmp121_ = self->test_collection;
	_tmp122_ = gee_collection_get_is_empty (_tmp121_);
	_tmp123_ = _tmp122_;
	_vala_assert (_tmp123_, "test_collection.is_empty");
}


void collection_tests_test_add_remove (CollectionTests* self) {
	GeeCollection* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar** _tmp40_ = NULL;
	gchar** to_add;
	gint to_add_length1;
	gint _to_add_size_;
	gint expected_size;
	gchar** _tmp41_;
	gint _tmp41__length1;
	GeeCollection* _tmp56_;
	gint _tmp57_;
	gint _tmp58_;
	gchar** _tmp59_;
	gint _tmp59__length1;
	gchar** _tmp60_;
	gint _tmp60__length1;
	gchar** _tmp65_;
	gint _tmp65__length1;
	GeeCollection* _tmp80_;
	gint _tmp81_;
	gint _tmp82_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp1_ = g_strdup ("one");
	_tmp2_ = g_strdup ("two");
	_tmp3_ = g_strdup ("three");
	_tmp4_ = g_strdup ("four");
	_tmp5_ = g_strdup ("five");
	_tmp6_ = g_strdup ("six");
	_tmp7_ = g_strdup ("seven");
	_tmp8_ = g_strdup ("eight");
	_tmp9_ = g_strdup ("nine");
	_tmp10_ = g_strdup ("ten");
	_tmp11_ = g_strdup ("eleven");
	_tmp12_ = g_strdup ("twelve");
	_tmp13_ = g_strdup ("thirteen");
	_tmp14_ = g_strdup ("fourteen");
	_tmp15_ = g_strdup ("fifteen");
	_tmp16_ = g_strdup ("sixteen");
	_tmp17_ = g_strdup ("seventeen");
	_tmp18_ = g_strdup ("eighteen");
	_tmp19_ = g_strdup ("nineteen");
	_tmp20_ = g_strdup ("twenty");
	_tmp21_ = g_strdup ("twenty one");
	_tmp22_ = g_strdup ("twenty two");
	_tmp23_ = g_strdup ("twenty three");
	_tmp24_ = g_strdup ("twenty four");
	_tmp25_ = g_strdup ("twenty five");
	_tmp26_ = g_strdup ("twenty six");
	_tmp27_ = g_strdup ("twenty seven");
	_tmp28_ = g_strdup ("twenty eight");
	_tmp29_ = g_strdup ("twenty nine");
	_tmp30_ = g_strdup ("thirty");
	_tmp31_ = g_strdup ("thirty one");
	_tmp32_ = g_strdup ("thirty two");
	_tmp33_ = g_strdup ("thirty four");
	_tmp34_ = g_strdup ("thirty five");
	_tmp35_ = g_strdup ("thirty six");
	_tmp36_ = g_strdup ("thirty seven");
	_tmp37_ = g_strdup ("thirty eight");
	_tmp38_ = g_strdup ("thirty nine");
	_tmp39_ = g_strdup ("fourty");
	_tmp40_ = g_new0 (gchar*, 39 + 1);
	_tmp40_[0] = _tmp1_;
	_tmp40_[1] = _tmp2_;
	_tmp40_[2] = _tmp3_;
	_tmp40_[3] = _tmp4_;
	_tmp40_[4] = _tmp5_;
	_tmp40_[5] = _tmp6_;
	_tmp40_[6] = _tmp7_;
	_tmp40_[7] = _tmp8_;
	_tmp40_[8] = _tmp9_;
	_tmp40_[9] = _tmp10_;
	_tmp40_[10] = _tmp11_;
	_tmp40_[11] = _tmp12_;
	_tmp40_[12] = _tmp13_;
	_tmp40_[13] = _tmp14_;
	_tmp40_[14] = _tmp15_;
	_tmp40_[15] = _tmp16_;
	_tmp40_[16] = _tmp17_;
	_tmp40_[17] = _tmp18_;
	_tmp40_[18] = _tmp19_;
	_tmp40_[19] = _tmp20_;
	_tmp40_[20] = _tmp21_;
	_tmp40_[21] = _tmp22_;
	_tmp40_[22] = _tmp23_;
	_tmp40_[23] = _tmp24_;
	_tmp40_[24] = _tmp25_;
	_tmp40_[25] = _tmp26_;
	_tmp40_[26] = _tmp27_;
	_tmp40_[27] = _tmp28_;
	_tmp40_[28] = _tmp29_;
	_tmp40_[29] = _tmp30_;
	_tmp40_[30] = _tmp31_;
	_tmp40_[31] = _tmp32_;
	_tmp40_[32] = _tmp33_;
	_tmp40_[33] = _tmp34_;
	_tmp40_[34] = _tmp35_;
	_tmp40_[35] = _tmp36_;
	_tmp40_[36] = _tmp37_;
	_tmp40_[37] = _tmp38_;
	_tmp40_[38] = _tmp39_;
	to_add = _tmp40_;
	to_add_length1 = 39;
	_to_add_size_ = to_add_length1;
	expected_size = 0;
	_tmp41_ = to_add;
	_tmp41__length1 = to_add_length1;
	{
		gchar** a_collection = NULL;
		gint a_collection_length1 = 0;
		gint _a_collection_size_ = 0;
		gint a_it = 0;
		a_collection = _tmp41_;
		a_collection_length1 = _tmp41__length1;
		for (a_it = 0; a_it < _tmp41__length1; a_it = a_it + 1) {
			gchar* _tmp42_;
			gchar* a = NULL;
			_tmp42_ = g_strdup (a_collection[a_it]);
			a = _tmp42_;
			{
				GeeCollection* _tmp43_;
				const gchar* _tmp44_;
				gboolean _tmp45_ = FALSE;
				GeeCollection* _tmp46_;
				gint _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				GeeCollection* _tmp50_;
				const gchar* _tmp51_;
				gboolean _tmp52_ = FALSE;
				GeeCollection* _tmp53_;
				const gchar* _tmp54_;
				gboolean _tmp55_ = FALSE;
				_tmp43_ = self->test_collection;
				_tmp44_ = a;
				_tmp45_ = gee_collection_contains (_tmp43_, _tmp44_);
				_vala_assert (!_tmp45_, "!test_collection.contains (a)");
				_tmp46_ = self->test_collection;
				_tmp47_ = gee_collection_get_size (_tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = expected_size;
				expected_size = _tmp49_ + 1;
				_vala_assert (_tmp48_ == _tmp49_, "test_collection.size == expected_size++");
				_tmp50_ = self->test_collection;
				_tmp51_ = a;
				_tmp52_ = gee_collection_add (_tmp50_, _tmp51_);
				_vala_assert (_tmp52_, "test_collection.add (a)");
				_tmp53_ = self->test_collection;
				_tmp54_ = a;
				_tmp55_ = gee_collection_contains (_tmp53_, _tmp54_);
				_vala_assert (_tmp55_, "test_collection.contains (a)");
				_g_free0 (a);
			}
		}
	}
	_tmp56_ = self->test_collection;
	_tmp57_ = gee_collection_get_size (_tmp56_);
	_tmp58_ = _tmp57_;
	_tmp59_ = to_add;
	_tmp59__length1 = to_add_length1;
	_vala_assert (_tmp58_ == _tmp59__length1, "test_collection.size == to_add.length");
	_tmp60_ = to_add;
	_tmp60__length1 = to_add_length1;
	{
		gchar** a_collection = NULL;
		gint a_collection_length1 = 0;
		gint _a_collection_size_ = 0;
		gint a_it = 0;
		a_collection = _tmp60_;
		a_collection_length1 = _tmp60__length1;
		for (a_it = 0; a_it < _tmp60__length1; a_it = a_it + 1) {
			gchar* _tmp61_;
			gchar* a = NULL;
			_tmp61_ = g_strdup (a_collection[a_it]);
			a = _tmp61_;
			{
				GeeCollection* _tmp62_;
				const gchar* _tmp63_;
				gboolean _tmp64_ = FALSE;
				_tmp62_ = self->test_collection;
				_tmp63_ = a;
				_tmp64_ = gee_collection_contains (_tmp62_, _tmp63_);
				_vala_assert (_tmp64_, "test_collection.contains (a)");
				_g_free0 (a);
			}
		}
	}
	_tmp65_ = to_add;
	_tmp65__length1 = to_add_length1;
	{
		gchar** a_collection = NULL;
		gint a_collection_length1 = 0;
		gint _a_collection_size_ = 0;
		gint a_it = 0;
		a_collection = _tmp65_;
		a_collection_length1 = _tmp65__length1;
		for (a_it = 0; a_it < _tmp65__length1; a_it = a_it + 1) {
			gchar* _tmp66_;
			gchar* a = NULL;
			_tmp66_ = g_strdup (a_collection[a_it]);
			a = _tmp66_;
			{
				GeeCollection* _tmp67_;
				const gchar* _tmp68_;
				gboolean _tmp69_ = FALSE;
				GeeCollection* _tmp70_;
				gint _tmp71_;
				gint _tmp72_;
				gint _tmp73_;
				GeeCollection* _tmp74_;
				const gchar* _tmp75_;
				gboolean _tmp76_ = FALSE;
				GeeCollection* _tmp77_;
				const gchar* _tmp78_;
				gboolean _tmp79_ = FALSE;
				_tmp67_ = self->test_collection;
				_tmp68_ = a;
				_tmp69_ = gee_collection_contains (_tmp67_, _tmp68_);
				_vala_assert (_tmp69_, "test_collection.contains (a)");
				_tmp70_ = self->test_collection;
				_tmp71_ = gee_collection_get_size (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp73_ = expected_size;
				expected_size = _tmp73_ - 1;
				_vala_assert (_tmp72_ == _tmp73_, "test_collection.size == expected_size--");
				_tmp74_ = self->test_collection;
				_tmp75_ = a;
				_tmp76_ = gee_collection_remove (_tmp74_, _tmp75_);
				_vala_assert (_tmp76_, "test_collection.remove (a)");
				_tmp77_ = self->test_collection;
				_tmp78_ = a;
				_tmp79_ = gee_collection_contains (_tmp77_, _tmp78_);
				_vala_assert (!_tmp79_, "!test_collection.contains (a)");
				_g_free0 (a);
			}
		}
	}
	_tmp80_ = self->test_collection;
	_tmp81_ = gee_collection_get_size (_tmp80_);
	_tmp82_ = _tmp81_;
	_vala_assert (_tmp82_ == 0, "test_collection.size == 0");
	to_add = (_vala_array_free (to_add, to_add_length1, (GDestroyNotify) g_free), NULL);
}


void collection_tests_test_clear (CollectionTests* self) {
	GeeCollection* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar** _tmp40_ = NULL;
	gchar** to_add;
	gint to_add_length1;
	gint _to_add_size_;
	gint expected_size;
	gchar** _tmp41_;
	gint _tmp41__length1;
	GeeCollection* _tmp56_;
	gint _tmp57_;
	gint _tmp58_;
	gchar** _tmp59_;
	gint _tmp59__length1;
	GeeCollection* _tmp60_;
	GeeCollection* _tmp61_;
	gint _tmp62_;
	gint _tmp63_;
	GeeCollection* _tmp64_;
	GeeIterator* _tmp65_ = NULL;
	GeeIterator* iter;
	gboolean _tmp66_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp1_ = g_strdup ("one");
	_tmp2_ = g_strdup ("two");
	_tmp3_ = g_strdup ("three");
	_tmp4_ = g_strdup ("four");
	_tmp5_ = g_strdup ("five");
	_tmp6_ = g_strdup ("six");
	_tmp7_ = g_strdup ("seven");
	_tmp8_ = g_strdup ("eight");
	_tmp9_ = g_strdup ("nine");
	_tmp10_ = g_strdup ("ten");
	_tmp11_ = g_strdup ("eleven");
	_tmp12_ = g_strdup ("twelve");
	_tmp13_ = g_strdup ("thirteen");
	_tmp14_ = g_strdup ("fourteen");
	_tmp15_ = g_strdup ("fifteen");
	_tmp16_ = g_strdup ("sixteen");
	_tmp17_ = g_strdup ("seventeen");
	_tmp18_ = g_strdup ("eighteen");
	_tmp19_ = g_strdup ("nineteen");
	_tmp20_ = g_strdup ("twenty");
	_tmp21_ = g_strdup ("twenty one");
	_tmp22_ = g_strdup ("twenty two");
	_tmp23_ = g_strdup ("twenty three");
	_tmp24_ = g_strdup ("twenty four");
	_tmp25_ = g_strdup ("twenty five");
	_tmp26_ = g_strdup ("twenty six");
	_tmp27_ = g_strdup ("twenty seven");
	_tmp28_ = g_strdup ("twenty eight");
	_tmp29_ = g_strdup ("twenty nine");
	_tmp30_ = g_strdup ("thirty");
	_tmp31_ = g_strdup ("thirty one");
	_tmp32_ = g_strdup ("thirty two");
	_tmp33_ = g_strdup ("thirty four");
	_tmp34_ = g_strdup ("thirty five");
	_tmp35_ = g_strdup ("thirty six");
	_tmp36_ = g_strdup ("thirty seven");
	_tmp37_ = g_strdup ("thirty eight");
	_tmp38_ = g_strdup ("thirty nine");
	_tmp39_ = g_strdup ("fourty");
	_tmp40_ = g_new0 (gchar*, 39 + 1);
	_tmp40_[0] = _tmp1_;
	_tmp40_[1] = _tmp2_;
	_tmp40_[2] = _tmp3_;
	_tmp40_[3] = _tmp4_;
	_tmp40_[4] = _tmp5_;
	_tmp40_[5] = _tmp6_;
	_tmp40_[6] = _tmp7_;
	_tmp40_[7] = _tmp8_;
	_tmp40_[8] = _tmp9_;
	_tmp40_[9] = _tmp10_;
	_tmp40_[10] = _tmp11_;
	_tmp40_[11] = _tmp12_;
	_tmp40_[12] = _tmp13_;
	_tmp40_[13] = _tmp14_;
	_tmp40_[14] = _tmp15_;
	_tmp40_[15] = _tmp16_;
	_tmp40_[16] = _tmp17_;
	_tmp40_[17] = _tmp18_;
	_tmp40_[18] = _tmp19_;
	_tmp40_[19] = _tmp20_;
	_tmp40_[20] = _tmp21_;
	_tmp40_[21] = _tmp22_;
	_tmp40_[22] = _tmp23_;
	_tmp40_[23] = _tmp24_;
	_tmp40_[24] = _tmp25_;
	_tmp40_[25] = _tmp26_;
	_tmp40_[26] = _tmp27_;
	_tmp40_[27] = _tmp28_;
	_tmp40_[28] = _tmp29_;
	_tmp40_[29] = _tmp30_;
	_tmp40_[30] = _tmp31_;
	_tmp40_[31] = _tmp32_;
	_tmp40_[32] = _tmp33_;
	_tmp40_[33] = _tmp34_;
	_tmp40_[34] = _tmp35_;
	_tmp40_[35] = _tmp36_;
	_tmp40_[36] = _tmp37_;
	_tmp40_[37] = _tmp38_;
	_tmp40_[38] = _tmp39_;
	to_add = _tmp40_;
	to_add_length1 = 39;
	_to_add_size_ = to_add_length1;
	expected_size = 0;
	_tmp41_ = to_add;
	_tmp41__length1 = to_add_length1;
	{
		gchar** a_collection = NULL;
		gint a_collection_length1 = 0;
		gint _a_collection_size_ = 0;
		gint a_it = 0;
		a_collection = _tmp41_;
		a_collection_length1 = _tmp41__length1;
		for (a_it = 0; a_it < _tmp41__length1; a_it = a_it + 1) {
			gchar* _tmp42_;
			gchar* a = NULL;
			_tmp42_ = g_strdup (a_collection[a_it]);
			a = _tmp42_;
			{
				GeeCollection* _tmp43_;
				const gchar* _tmp44_;
				gboolean _tmp45_ = FALSE;
				GeeCollection* _tmp46_;
				gint _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				GeeCollection* _tmp50_;
				const gchar* _tmp51_;
				gboolean _tmp52_ = FALSE;
				GeeCollection* _tmp53_;
				const gchar* _tmp54_;
				gboolean _tmp55_ = FALSE;
				_tmp43_ = self->test_collection;
				_tmp44_ = a;
				_tmp45_ = gee_collection_contains (_tmp43_, _tmp44_);
				_vala_assert (!_tmp45_, "!test_collection.contains (a)");
				_tmp46_ = self->test_collection;
				_tmp47_ = gee_collection_get_size (_tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = expected_size;
				expected_size = _tmp49_ + 1;
				_vala_assert (_tmp48_ == _tmp49_, "test_collection.size == expected_size++");
				_tmp50_ = self->test_collection;
				_tmp51_ = a;
				_tmp52_ = gee_collection_add (_tmp50_, _tmp51_);
				_vala_assert (_tmp52_, "test_collection.add (a)");
				_tmp53_ = self->test_collection;
				_tmp54_ = a;
				_tmp55_ = gee_collection_contains (_tmp53_, _tmp54_);
				_vala_assert (_tmp55_, "test_collection.contains (a)");
				_g_free0 (a);
			}
		}
	}
	_tmp56_ = self->test_collection;
	_tmp57_ = gee_collection_get_size (_tmp56_);
	_tmp58_ = _tmp57_;
	_tmp59_ = to_add;
	_tmp59__length1 = to_add_length1;
	_vala_assert (_tmp58_ == _tmp59__length1, "test_collection.size == to_add.length");
	_tmp60_ = self->test_collection;
	gee_collection_clear (_tmp60_);
	_tmp61_ = self->test_collection;
	_tmp62_ = gee_collection_get_size (_tmp61_);
	_tmp63_ = _tmp62_;
	_vala_assert (_tmp63_ == 0, "test_collection.size == 0");
	_tmp64_ = self->test_collection;
	_tmp65_ = gee_iterable_iterator ((GeeIterable*) _tmp64_);
	iter = _tmp65_;
	_vala_assert (iter != NULL, "iter != null");
	_tmp66_ = gee_iterator_has_next (iter);
	_vala_assert (!_tmp66_, "!iter.has_next ()");
	_g_object_unref0 (iter);
	to_add = (_vala_array_free (to_add, to_add_length1, (GDestroyNotify) g_free), NULL);
}


void collection_tests_test_add_all (CollectionTests* self) {
	GeeCollection* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* dummy;
	GeeCollection* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	GeeCollection* _tmp9_;
	gboolean _tmp10_ = FALSE;
	GeeCollection* _tmp11_;
	gboolean _tmp12_ = FALSE;
	GeeCollection* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GeeCollection* _tmp16_;
	gboolean _tmp17_ = FALSE;
	GeeCollection* _tmp18_;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	GeeCollection* _tmp22_;
	gboolean _tmp23_ = FALSE;
	GeeCollection* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	GeeCollection* _tmp27_;
	gboolean _tmp28_ = FALSE;
	GeeCollection* _tmp29_;
	gboolean _tmp30_ = FALSE;
	GeeCollection* _tmp31_;
	gboolean _tmp32_ = FALSE;
	gint _tmp33_;
	gint _tmp34_;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_ = FALSE;
	GeeCollection* _tmp38_;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp41_ = FALSE;
	GeeCollection* _tmp42_;
	gboolean _tmp43_ = FALSE;
	GeeCollection* _tmp44_;
	gboolean _tmp45_ = FALSE;
	GeeCollection* _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	GeeCollection* _tmp49_;
	gboolean _tmp50_ = FALSE;
	GeeCollection* _tmp51_;
	gboolean _tmp52_ = FALSE;
	GeeCollection* _tmp53_;
	gboolean _tmp54_ = FALSE;
	GeeCollection* _tmp55_;
	gboolean _tmp56_ = FALSE;
	gint _tmp57_;
	gint _tmp58_;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp61_ = FALSE;
	GeeCollection* _tmp62_;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp65_ = FALSE;
	GeeCollection* _tmp66_;
	gboolean _tmp67_ = FALSE;
	GeeCollection* _tmp68_;
	gboolean _tmp69_ = FALSE;
	GeeCollection* _tmp70_;
	gint _tmp71_;
	gint _tmp72_;
	GeeCollection* _tmp73_;
	gboolean _tmp74_ = FALSE;
	GeeCollection* _tmp75_;
	gboolean _tmp76_ = FALSE;
	GeeCollection* _tmp77_;
	gboolean _tmp78_ = FALSE;
	gint _tmp79_;
	gint _tmp80_;
	gboolean _tmp81_ = FALSE;
	gboolean _tmp82_ = FALSE;
	gboolean _tmp83_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	dummy = _tmp1_;
	_tmp2_ = self->test_collection;
	_tmp3_ = gee_collection_add_all (_tmp2_, (GeeCollection*) dummy);
	_vala_assert (!_tmp3_, "! test_collection.add_all (dummy)");
	_tmp4_ = self->test_collection;
	_tmp5_ = gee_collection_get_is_empty (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_assert (_tmp6_, "test_collection.is_empty");
	_tmp7_ = gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) dummy);
	_tmp8_ = _tmp7_;
	_vala_assert (_tmp8_, "dummy.is_empty");
	_tmp9_ = self->test_collection;
	_tmp10_ = gee_collection_add (_tmp9_, "hello");
	_vala_assert (_tmp10_, "test_collection.add (\"hello\")");
	_tmp11_ = self->test_collection;
	_tmp12_ = gee_collection_add_all (_tmp11_, (GeeCollection*) dummy);
	_vala_assert (!_tmp12_, "! test_collection.add_all (dummy)");
	_tmp13_ = self->test_collection;
	_tmp14_ = gee_collection_get_size (_tmp13_);
	_tmp15_ = _tmp14_;
	_vala_assert (_tmp15_ == 1, "test_collection.size == 1");
	_tmp16_ = self->test_collection;
	_tmp17_ = gee_collection_contains (_tmp16_, "hello");
	_vala_assert (_tmp17_, "test_collection.contains (\"hello\")");
	_tmp18_ = self->test_collection;
	gee_collection_clear (_tmp18_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp19_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp19_, "dummy.add (\"hello1\")");
	_tmp20_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp20_, "dummy.add (\"hello2\")");
	_tmp21_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp21_, "dummy.add (\"hello3\")");
	_tmp22_ = self->test_collection;
	_tmp23_ = gee_collection_add_all (_tmp22_, (GeeCollection*) dummy);
	_vala_assert (_tmp23_, "test_collection.add_all (dummy)");
	_tmp24_ = self->test_collection;
	_tmp25_ = gee_collection_get_size (_tmp24_);
	_tmp26_ = _tmp25_;
	_vala_assert (_tmp26_ == 3, "test_collection.size == 3");
	_tmp27_ = self->test_collection;
	_tmp28_ = gee_collection_contains (_tmp27_, "hello1");
	_vala_assert (_tmp28_, "test_collection.contains (\"hello1\")");
	_tmp29_ = self->test_collection;
	_tmp30_ = gee_collection_contains (_tmp29_, "hello2");
	_vala_assert (_tmp30_, "test_collection.contains (\"hello2\")");
	_tmp31_ = self->test_collection;
	_tmp32_ = gee_collection_contains (_tmp31_, "hello3");
	_vala_assert (_tmp32_, "test_collection.contains (\"hello3\")");
	_tmp33_ = gee_abstract_collection_get_size ((GeeCollection*) dummy);
	_tmp34_ = _tmp33_;
	_vala_assert (_tmp34_ == 3, "dummy.size == 3");
	_tmp35_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp35_, "dummy.contains (\"hello1\")");
	_tmp36_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp36_, "dummy.contains (\"hello2\")");
	_tmp37_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp37_, "dummy.contains (\"hello3\")");
	_tmp38_ = self->test_collection;
	gee_collection_clear (_tmp38_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp39_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp39_, "dummy.add (\"hello1\")");
	_tmp40_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp40_, "dummy.add (\"hello2\")");
	_tmp41_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp41_, "dummy.add (\"hello3\")");
	_tmp42_ = self->test_collection;
	_tmp43_ = gee_collection_add (_tmp42_, "hello");
	_vala_assert (_tmp43_, "test_collection.add (\"hello\")");
	_tmp44_ = self->test_collection;
	_tmp45_ = gee_collection_add_all (_tmp44_, (GeeCollection*) dummy);
	_vala_assert (_tmp45_, "test_collection.add_all (dummy)");
	_tmp46_ = self->test_collection;
	_tmp47_ = gee_collection_get_size (_tmp46_);
	_tmp48_ = _tmp47_;
	_vala_assert (_tmp48_ == 4, "test_collection.size == 4");
	_tmp49_ = self->test_collection;
	_tmp50_ = gee_collection_contains (_tmp49_, "hello");
	_vala_assert (_tmp50_, "test_collection.contains (\"hello\")");
	_tmp51_ = self->test_collection;
	_tmp52_ = gee_collection_contains (_tmp51_, "hello1");
	_vala_assert (_tmp52_, "test_collection.contains (\"hello1\")");
	_tmp53_ = self->test_collection;
	_tmp54_ = gee_collection_contains (_tmp53_, "hello2");
	_vala_assert (_tmp54_, "test_collection.contains (\"hello2\")");
	_tmp55_ = self->test_collection;
	_tmp56_ = gee_collection_contains (_tmp55_, "hello3");
	_vala_assert (_tmp56_, "test_collection.contains (\"hello3\")");
	_tmp57_ = gee_abstract_collection_get_size ((GeeCollection*) dummy);
	_tmp58_ = _tmp57_;
	_vala_assert (_tmp58_ == 3, "dummy.size == 3");
	_tmp59_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp59_, "dummy.contains (\"hello1\")");
	_tmp60_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp60_, "dummy.contains (\"hello2\")");
	_tmp61_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp61_, "dummy.contains (\"hello3\")");
	_tmp62_ = self->test_collection;
	gee_collection_clear (_tmp62_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp63_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp63_, "dummy.add (\"hello1\")");
	_tmp64_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp64_, "dummy.add (\"hello2\")");
	_tmp65_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp65_, "dummy.add (\"hello3\")");
	_tmp66_ = self->test_collection;
	_tmp67_ = gee_collection_add (_tmp66_, "hello1");
	_vala_assert (_tmp67_, "test_collection.add (\"hello1\")");
	_tmp68_ = self->test_collection;
	_tmp69_ = gee_collection_add_all (_tmp68_, (GeeCollection*) dummy);
	_vala_assert (_tmp69_, "test_collection.add_all (dummy)");
	_tmp70_ = self->test_collection;
	_tmp71_ = gee_collection_get_size (_tmp70_);
	_tmp72_ = _tmp71_;
	_vala_assert (_tmp72_ >= 3, "test_collection.size >= 3");
	_tmp73_ = self->test_collection;
	_tmp74_ = gee_collection_contains (_tmp73_, "hello1");
	_vala_assert (_tmp74_, "test_collection.contains (\"hello1\")");
	_tmp75_ = self->test_collection;
	_tmp76_ = gee_collection_contains (_tmp75_, "hello2");
	_vala_assert (_tmp76_, "test_collection.contains (\"hello2\")");
	_tmp77_ = self->test_collection;
	_tmp78_ = gee_collection_contains (_tmp77_, "hello3");
	_vala_assert (_tmp78_, "test_collection.contains (\"hello3\")");
	_tmp79_ = gee_abstract_collection_get_size ((GeeCollection*) dummy);
	_tmp80_ = _tmp79_;
	_vala_assert (_tmp80_ == 3, "dummy.size == 3");
	_tmp81_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp81_, "dummy.contains (\"hello1\")");
	_tmp82_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp82_, "dummy.contains (\"hello2\")");
	_tmp83_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp83_, "dummy.contains (\"hello3\")");
	_g_object_unref0 (dummy);
}


void collection_tests_test_contains_all (CollectionTests* self) {
	GeeCollection* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* dummy;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GeeCollection* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GeeCollection* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GeeCollection* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GeeCollection* _tmp12_;
	gboolean _tmp13_ = FALSE;
	GeeCollection* _tmp14_;
	gboolean _tmp15_ = FALSE;
	GeeCollection* _tmp16_;
	gboolean _tmp17_ = FALSE;
	GeeCollection* _tmp18_;
	gboolean _tmp19_ = FALSE;
	GeeCollection* _tmp20_;
	gboolean _tmp21_ = FALSE;
	GeeCollection* _tmp22_;
	gboolean _tmp23_ = FALSE;
	GeeCollection* _tmp24_;
	gboolean _tmp25_ = FALSE;
	GeeCollection* _tmp26_;
	gboolean _tmp27_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	dummy = _tmp1_;
	_tmp2_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp2_, "dummy.add (\"hello1\")");
	_tmp3_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp3_, "dummy.add (\"hello2\")");
	_tmp4_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp4_, "dummy.add (\"hello3\")");
	_tmp5_ = self->test_collection;
	_tmp6_ = gee_collection_get_is_empty (_tmp5_);
	_tmp7_ = _tmp6_;
	_vala_assert (_tmp7_, "test_collection.is_empty");
	_tmp8_ = self->test_collection;
	_tmp9_ = gee_collection_contains_all (_tmp8_, (GeeCollection*) dummy);
	_vala_assert (!_tmp9_, "! test_collection.contains_all (dummy)");
	_tmp10_ = self->test_collection;
	_tmp11_ = gee_collection_add (_tmp10_, "hello4");
	_vala_assert (_tmp11_, "test_collection.add (\"hello4\")");
	_tmp12_ = self->test_collection;
	_tmp13_ = gee_collection_add (_tmp12_, "hello5");
	_vala_assert (_tmp13_, "test_collection.add (\"hello5\")");
	_tmp14_ = self->test_collection;
	_tmp15_ = gee_collection_contains_all (_tmp14_, (GeeCollection*) dummy);
	_vala_assert (!_tmp15_, "! test_collection.contains_all (dummy)");
	_tmp16_ = self->test_collection;
	_tmp17_ = gee_collection_add (_tmp16_, "hello1");
	_vala_assert (_tmp17_, "test_collection.add (\"hello1\")");
	_tmp18_ = self->test_collection;
	_tmp19_ = gee_collection_add (_tmp18_, "hello2");
	_vala_assert (_tmp19_, "test_collection.add (\"hello2\")");
	_tmp20_ = self->test_collection;
	_tmp21_ = gee_collection_contains_all (_tmp20_, (GeeCollection*) dummy);
	_vala_assert (!_tmp21_, "! test_collection.contains_all (dummy)");
	_tmp22_ = self->test_collection;
	_tmp23_ = gee_collection_add (_tmp22_, "hello3");
	_vala_assert (_tmp23_, "test_collection.add (\"hello3\")");
	_tmp24_ = self->test_collection;
	_tmp25_ = gee_collection_contains_all (_tmp24_, (GeeCollection*) dummy);
	_vala_assert (_tmp25_, "test_collection.contains_all (dummy)");
	_tmp26_ = self->test_collection;
	_tmp27_ = gee_abstract_collection_contains_all ((GeeAbstractCollection*) dummy, _tmp26_);
	_vala_assert (!_tmp27_, "! dummy.contains_all (test_collection)");
	_g_object_unref0 (dummy);
}


void collection_tests_test_remove_all (CollectionTests* self) {
	GeeCollection* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* dummy;
	GeeCollection* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	GeeCollection* _tmp12_;
	gboolean _tmp13_ = FALSE;
	GeeCollection* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	GeeCollection* _tmp17_;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	GeeCollection* _tmp21_;
	gboolean _tmp22_ = FALSE;
	GeeCollection* _tmp23_;
	gboolean _tmp24_ = FALSE;
	GeeCollection* _tmp25_;
	gboolean _tmp26_ = FALSE;
	GeeCollection* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	GeeCollection* _tmp32_;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	GeeCollection* _tmp36_;
	gboolean _tmp37_ = FALSE;
	GeeCollection* _tmp38_;
	gboolean _tmp39_ = FALSE;
	GeeCollection* _tmp40_;
	gboolean _tmp41_ = FALSE;
	GeeCollection* _tmp42_;
	gboolean _tmp43_ = FALSE;
	GeeCollection* _tmp44_;
	gboolean _tmp45_;
	gboolean _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	GeeCollection* _tmp49_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	dummy = _tmp1_;
	_tmp2_ = self->test_collection;
	_tmp3_ = gee_collection_remove_all (_tmp2_, (GeeCollection*) dummy);
	_vala_assert (!_tmp3_, "! test_collection.remove_all (dummy)");
	_tmp4_ = self->test_collection;
	_tmp5_ = gee_collection_get_is_empty (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_assert (_tmp6_, "test_collection.is_empty");
	_tmp7_ = gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) dummy);
	_tmp8_ = _tmp7_;
	_vala_assert (_tmp8_, "dummy.is_empty");
	_tmp9_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp9_, "dummy.add (\"hello1\")");
	_tmp10_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp10_, "dummy.add (\"hello2\")");
	_tmp11_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp11_, "dummy.add (\"hello3\")");
	_tmp12_ = self->test_collection;
	_tmp13_ = gee_collection_remove_all (_tmp12_, (GeeCollection*) dummy);
	_vala_assert (!_tmp13_, "! test_collection.remove_all (dummy)");
	_tmp14_ = self->test_collection;
	_tmp15_ = gee_collection_get_is_empty (_tmp14_);
	_tmp16_ = _tmp15_;
	_vala_assert (_tmp16_, "test_collection.is_empty");
	_tmp17_ = self->test_collection;
	gee_collection_clear (_tmp17_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp18_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp18_, "dummy.add (\"hello1\")");
	_tmp19_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp19_, "dummy.add (\"hello2\")");
	_tmp20_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp20_, "dummy.add (\"hello3\")");
	_tmp21_ = self->test_collection;
	_tmp22_ = gee_collection_add (_tmp21_, "hello4");
	_vala_assert (_tmp22_, "test_collection.add (\"hello4\")");
	_tmp23_ = self->test_collection;
	_tmp24_ = gee_collection_add (_tmp23_, "hello5");
	_vala_assert (_tmp24_, "test_collection.add (\"hello5\")");
	_tmp25_ = self->test_collection;
	_tmp26_ = gee_collection_remove_all (_tmp25_, (GeeCollection*) dummy);
	_vala_assert (!_tmp26_, "! test_collection.remove_all (dummy)");
	_tmp27_ = self->test_collection;
	_tmp28_ = gee_collection_get_size (_tmp27_);
	_tmp29_ = _tmp28_;
	_vala_assert (_tmp29_ == 2, "test_collection.size == 2");
	_tmp30_ = gee_abstract_collection_get_size ((GeeCollection*) dummy);
	_tmp31_ = _tmp30_;
	_vala_assert (_tmp31_ == 3, "dummy.size == 3");
	_tmp32_ = self->test_collection;
	gee_collection_clear (_tmp32_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp33_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp33_, "dummy.add (\"hello1\")");
	_tmp34_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp34_, "dummy.add (\"hello2\")");
	_tmp35_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp35_, "dummy.add (\"hello3\")");
	_tmp36_ = self->test_collection;
	_tmp37_ = gee_collection_add (_tmp36_, "hello1");
	_vala_assert (_tmp37_, "test_collection.add (\"hello1\")");
	_tmp38_ = self->test_collection;
	_tmp39_ = gee_collection_add (_tmp38_, "hello2");
	_vala_assert (_tmp39_, "test_collection.add (\"hello2\")");
	_tmp40_ = self->test_collection;
	_tmp41_ = gee_collection_add (_tmp40_, "hello3");
	_vala_assert (_tmp41_, "test_collection.add (\"hello3\")");
	_tmp42_ = self->test_collection;
	_tmp43_ = gee_collection_remove_all (_tmp42_, (GeeCollection*) dummy);
	_vala_assert (_tmp43_, "test_collection.remove_all (dummy)");
	_tmp44_ = self->test_collection;
	_tmp45_ = gee_collection_get_is_empty (_tmp44_);
	_tmp46_ = _tmp45_;
	_vala_assert (_tmp46_, "test_collection.is_empty");
	_tmp47_ = gee_abstract_collection_get_size ((GeeCollection*) dummy);
	_tmp48_ = _tmp47_;
	_vala_assert (_tmp48_ == 3, "dummy.size == 3");
	_tmp49_ = self->test_collection;
	gee_collection_clear (_tmp49_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_g_object_unref0 (dummy);
}


void collection_tests_test_retain_all (CollectionTests* self) {
	GeeCollection* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* dummy;
	GeeCollection* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	GeeCollection* _tmp9_;
	gboolean _tmp10_ = FALSE;
	GeeCollection* _tmp11_;
	gboolean _tmp12_ = FALSE;
	GeeCollection* _tmp13_;
	gboolean _tmp14_ = FALSE;
	GeeCollection* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	GeeCollection* _tmp20_;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	GeeCollection* _tmp24_;
	gboolean _tmp25_ = FALSE;
	GeeCollection* _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_ = FALSE;
	GeeCollection* _tmp34_;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_ = FALSE;
	GeeCollection* _tmp38_;
	gboolean _tmp39_ = FALSE;
	GeeCollection* _tmp40_;
	gboolean _tmp41_ = FALSE;
	GeeCollection* _tmp42_;
	gboolean _tmp43_ = FALSE;
	GeeCollection* _tmp44_;
	gboolean _tmp45_;
	gboolean _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	gboolean _tmp49_ = FALSE;
	gboolean _tmp50_ = FALSE;
	gboolean _tmp51_ = FALSE;
	GeeCollection* _tmp52_;
	gboolean _tmp53_ = FALSE;
	gboolean _tmp54_ = FALSE;
	gboolean _tmp55_ = FALSE;
	GeeCollection* _tmp56_;
	gboolean _tmp57_ = FALSE;
	GeeCollection* _tmp58_;
	gboolean _tmp59_ = FALSE;
	GeeCollection* _tmp60_;
	gboolean _tmp61_ = FALSE;
	GeeCollection* _tmp62_;
	gboolean _tmp63_ = FALSE;
	GeeCollection* _tmp64_;
	gint _tmp65_;
	gint _tmp66_;
	GeeCollection* _tmp67_;
	gboolean _tmp68_ = FALSE;
	GeeCollection* _tmp69_;
	gboolean _tmp70_ = FALSE;
	GeeCollection* _tmp71_;
	gboolean _tmp72_ = FALSE;
	gint _tmp73_;
	gint _tmp74_;
	gboolean _tmp75_ = FALSE;
	gboolean _tmp76_ = FALSE;
	gboolean _tmp77_ = FALSE;
	GeeCollection* _tmp78_;
	gboolean _tmp79_ = FALSE;
	gboolean _tmp80_ = FALSE;
	gboolean _tmp81_ = FALSE;
	GeeCollection* _tmp82_;
	gboolean _tmp83_ = FALSE;
	GeeCollection* _tmp84_;
	gboolean _tmp85_ = FALSE;
	GeeCollection* _tmp86_;
	gboolean _tmp87_ = FALSE;
	GeeCollection* _tmp88_;
	gboolean _tmp89_ = FALSE;
	GeeCollection* _tmp90_;
	gint _tmp91_;
	gint _tmp92_;
	GeeCollection* _tmp93_;
	gboolean _tmp94_ = FALSE;
	GeeCollection* _tmp95_;
	gboolean _tmp96_ = FALSE;
	gint _tmp97_;
	gint _tmp98_;
	gboolean _tmp99_ = FALSE;
	gboolean _tmp100_ = FALSE;
	gboolean _tmp101_ = FALSE;
	GeeCollection* _tmp102_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	dummy = _tmp1_;
	_tmp2_ = self->test_collection;
	_tmp3_ = gee_collection_retain_all (_tmp2_, (GeeCollection*) dummy);
	_vala_assert (!_tmp3_, "! test_collection.retain_all (dummy)");
	_tmp4_ = self->test_collection;
	_tmp5_ = gee_collection_get_is_empty (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_assert (_tmp6_, "test_collection.is_empty");
	_tmp7_ = gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) dummy);
	_tmp8_ = _tmp7_;
	_vala_assert (_tmp8_, "dummy.is_empty");
	_tmp9_ = self->test_collection;
	_tmp10_ = gee_collection_add (_tmp9_, "hello1");
	_vala_assert (_tmp10_, "test_collection.add (\"hello1\")");
	_tmp11_ = self->test_collection;
	_tmp12_ = gee_collection_add (_tmp11_, "hello2");
	_vala_assert (_tmp12_, "test_collection.add (\"hello2\")");
	_tmp13_ = self->test_collection;
	_tmp14_ = gee_collection_retain_all (_tmp13_, (GeeCollection*) dummy);
	_vala_assert (_tmp14_, "test_collection.retain_all (dummy)");
	_tmp15_ = self->test_collection;
	_tmp16_ = gee_collection_get_is_empty (_tmp15_);
	_tmp17_ = _tmp16_;
	_vala_assert (_tmp17_, "test_collection.is_empty");
	_tmp18_ = gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) dummy);
	_tmp19_ = _tmp18_;
	_vala_assert (_tmp19_, "dummy.is_empty");
	_tmp20_ = self->test_collection;
	gee_collection_clear (_tmp20_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp21_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp21_, "dummy.add (\"hello1\")");
	_tmp22_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp22_, "dummy.add (\"hello2\")");
	_tmp23_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp23_, "dummy.add (\"hello3\")");
	_tmp24_ = self->test_collection;
	_tmp25_ = gee_collection_retain_all (_tmp24_, (GeeCollection*) dummy);
	_vala_assert (!_tmp25_, "! test_collection.retain_all (dummy)");
	_tmp26_ = self->test_collection;
	_tmp27_ = gee_collection_get_is_empty (_tmp26_);
	_tmp28_ = _tmp27_;
	_vala_assert (_tmp28_, "test_collection.is_empty");
	_tmp29_ = gee_abstract_collection_get_size ((GeeCollection*) dummy);
	_tmp30_ = _tmp29_;
	_vala_assert (_tmp30_ == 3, "dummy.size == 3");
	_tmp31_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp31_, "dummy.contains (\"hello1\")");
	_tmp32_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp32_, "dummy.contains (\"hello2\")");
	_tmp33_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp33_, "dummy.contains (\"hello3\")");
	_tmp34_ = self->test_collection;
	gee_collection_clear (_tmp34_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp35_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp35_, "dummy.add (\"hello1\")");
	_tmp36_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp36_, "dummy.add (\"hello2\")");
	_tmp37_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp37_, "dummy.add (\"hello3\")");
	_tmp38_ = self->test_collection;
	_tmp39_ = gee_collection_add (_tmp38_, "hello4");
	_vala_assert (_tmp39_, "test_collection.add (\"hello4\")");
	_tmp40_ = self->test_collection;
	_tmp41_ = gee_collection_add (_tmp40_, "hello5");
	_vala_assert (_tmp41_, "test_collection.add (\"hello5\")");
	_tmp42_ = self->test_collection;
	_tmp43_ = gee_collection_retain_all (_tmp42_, (GeeCollection*) dummy);
	_vala_assert (_tmp43_, "test_collection.retain_all (dummy)");
	_tmp44_ = self->test_collection;
	_tmp45_ = gee_collection_get_is_empty (_tmp44_);
	_tmp46_ = _tmp45_;
	_vala_assert (_tmp46_, "test_collection.is_empty");
	_tmp47_ = gee_abstract_collection_get_size ((GeeCollection*) dummy);
	_tmp48_ = _tmp47_;
	_vala_assert (_tmp48_ == 3, "dummy.size == 3");
	_tmp49_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp49_, "dummy.contains (\"hello1\")");
	_tmp50_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp50_, "dummy.contains (\"hello2\")");
	_tmp51_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp51_, "dummy.contains (\"hello3\")");
	_tmp52_ = self->test_collection;
	gee_collection_clear (_tmp52_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp53_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp53_, "dummy.add (\"hello1\")");
	_tmp54_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp54_, "dummy.add (\"hello2\")");
	_tmp55_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp55_, "dummy.add (\"hello3\")");
	_tmp56_ = self->test_collection;
	_tmp57_ = gee_collection_add (_tmp56_, "hello1");
	_vala_assert (_tmp57_, "test_collection.add (\"hello1\")");
	_tmp58_ = self->test_collection;
	_tmp59_ = gee_collection_add (_tmp58_, "hello2");
	_vala_assert (_tmp59_, "test_collection.add (\"hello2\")");
	_tmp60_ = self->test_collection;
	_tmp61_ = gee_collection_add (_tmp60_, "hello3");
	_vala_assert (_tmp61_, "test_collection.add (\"hello3\")");
	_tmp62_ = self->test_collection;
	_tmp63_ = gee_collection_retain_all (_tmp62_, (GeeCollection*) dummy);
	_vala_assert (!_tmp63_, "! test_collection.retain_all (dummy)");
	_tmp64_ = self->test_collection;
	_tmp65_ = gee_collection_get_size (_tmp64_);
	_tmp66_ = _tmp65_;
	_vala_assert (_tmp66_ == 3, "test_collection.size == 3");
	_tmp67_ = self->test_collection;
	_tmp68_ = gee_collection_contains (_tmp67_, "hello1");
	_vala_assert (_tmp68_, "test_collection.contains (\"hello1\")");
	_tmp69_ = self->test_collection;
	_tmp70_ = gee_collection_contains (_tmp69_, "hello2");
	_vala_assert (_tmp70_, "test_collection.contains (\"hello2\")");
	_tmp71_ = self->test_collection;
	_tmp72_ = gee_collection_contains (_tmp71_, "hello3");
	_vala_assert (_tmp72_, "test_collection.contains (\"hello3\")");
	_tmp73_ = gee_abstract_collection_get_size ((GeeCollection*) dummy);
	_tmp74_ = _tmp73_;
	_vala_assert (_tmp74_ == 3, "dummy.size == 3");
	_tmp75_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp75_, "dummy.contains (\"hello1\")");
	_tmp76_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp76_, "dummy.contains (\"hello2\")");
	_tmp77_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp77_, "dummy.contains (\"hello3\")");
	_tmp78_ = self->test_collection;
	gee_collection_clear (_tmp78_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp79_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp79_, "dummy.add (\"hello1\")");
	_tmp80_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp80_, "dummy.add (\"hello2\")");
	_tmp81_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp81_, "dummy.add (\"hello3\")");
	_tmp82_ = self->test_collection;
	_tmp83_ = gee_collection_add (_tmp82_, "hello2");
	_vala_assert (_tmp83_, "test_collection.add (\"hello2\")");
	_tmp84_ = self->test_collection;
	_tmp85_ = gee_collection_add (_tmp84_, "hello3");
	_vala_assert (_tmp85_, "test_collection.add (\"hello3\")");
	_tmp86_ = self->test_collection;
	_tmp87_ = gee_collection_add (_tmp86_, "hello4");
	_vala_assert (_tmp87_, "test_collection.add (\"hello4\")");
	_tmp88_ = self->test_collection;
	_tmp89_ = gee_collection_retain_all (_tmp88_, (GeeCollection*) dummy);
	_vala_assert (_tmp89_, "test_collection.retain_all (dummy)");
	_tmp90_ = self->test_collection;
	_tmp91_ = gee_collection_get_size (_tmp90_);
	_tmp92_ = _tmp91_;
	_vala_assert (_tmp92_ == 2, "test_collection.size == 2");
	_tmp93_ = self->test_collection;
	_tmp94_ = gee_collection_contains (_tmp93_, "hello2");
	_vala_assert (_tmp94_, "test_collection.contains (\"hello2\")");
	_tmp95_ = self->test_collection;
	_tmp96_ = gee_collection_contains (_tmp95_, "hello3");
	_vala_assert (_tmp96_, "test_collection.contains (\"hello3\")");
	_tmp97_ = gee_abstract_collection_get_size ((GeeCollection*) dummy);
	_tmp98_ = _tmp97_;
	_vala_assert (_tmp98_ == 3, "dummy.size == 3");
	_tmp99_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp99_, "dummy.contains (\"hello1\")");
	_tmp100_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp100_, "dummy.contains (\"hello2\")");
	_tmp101_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp101_, "dummy.contains (\"hello3\")");
	_tmp102_ = self->test_collection;
	gee_collection_clear (_tmp102_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_g_object_unref0 (dummy);
}


void collection_tests_test_to_array (CollectionTests* self) {
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GeeCollection* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GeeCollection* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GeeCollection* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GeeCollection* _tmp10_;
	gint _tmp11_ = 0;
	gpointer* _tmp12_ = NULL;
	gchar** array;
	gint array_length1;
	gint _array_size_;
	gint index;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp1_ = self->test_collection;
	_tmp2_ = gee_collection_get_is_empty (_tmp1_);
	_tmp3_ = _tmp2_;
	_vala_assert (_tmp3_, "test_collection.is_empty");
	_tmp4_ = self->test_collection;
	_tmp5_ = gee_collection_add (_tmp4_, "hello1");
	_vala_assert (_tmp5_, "test_collection.add (\"hello1\")");
	_tmp6_ = self->test_collection;
	_tmp7_ = gee_collection_add (_tmp6_, "hello2");
	_vala_assert (_tmp7_, "test_collection.add (\"hello2\")");
	_tmp8_ = self->test_collection;
	_tmp9_ = gee_collection_add (_tmp8_, "hello3");
	_vala_assert (_tmp9_, "test_collection.add (\"hello3\")");
	_tmp10_ = self->test_collection;
	_tmp12_ = gee_collection_to_array (_tmp10_, &_tmp11_);
	array = (gchar**) _tmp12_;
	array_length1 = (_tmp11_ * sizeof (gchar*)) / sizeof (gchar*);
	_array_size_ = array_length1;
	index = 0;
	{
		GeeCollection* _tmp13_;
		GeeIterator* _tmp14_ = NULL;
		GeeIterator* _element_it;
		_tmp13_ = self->test_collection;
		_tmp14_ = gee_iterable_iterator ((GeeIterable*) _tmp13_);
		_element_it = _tmp14_;
		while (TRUE) {
			GeeIterator* _tmp15_;
			gboolean _tmp16_ = FALSE;
			GeeIterator* _tmp17_;
			gpointer _tmp18_ = NULL;
			gchar* element;
			const gchar* _tmp19_;
			gchar** _tmp20_;
			gint _tmp20__length1;
			gint _tmp21_;
			const gchar* _tmp22_;
			_tmp15_ = _element_it;
			_tmp16_ = gee_iterator_next (_tmp15_);
			if (!_tmp16_) {
				break;
			}
			_tmp17_ = _element_it;
			_tmp18_ = gee_iterator_get (_tmp17_);
			element = (gchar*) _tmp18_;
			_tmp19_ = element;
			_tmp20_ = array;
			_tmp20__length1 = array_length1;
			_tmp21_ = index;
			index = _tmp21_ + 1;
			_tmp22_ = _tmp20_[_tmp21_];
			_vala_assert (g_strcmp0 (_tmp19_, _tmp22_) == 0, "element == array[index++]");
			_g_free0 (element);
		}
		_g_object_unref0 (_element_it);
	}
	array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
}


void collection_tests_test_gobject_properties (CollectionTests* self) {
	GeeCollection* _tmp0_;
	GValue value = {0};
	GValue _tmp1_ = {0};
	GValue _tmp2_;
	GeeCollection* _tmp3_;
	GType _tmp4_ = 0UL;
	GeeCollection* _tmp5_;
	GType _tmp6_;
	GType _tmp7_;
	GValue _tmp8_ = {0};
	GValue _tmp9_;
	GeeCollection* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GeeCollection* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	GValue _tmp15_ = {0};
	GValue _tmp16_;
	GeeCollection* _tmp17_;
	gint _tmp18_ = 0;
	GeeCollection* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	g_value_init (&_tmp1_, G_TYPE_GTYPE);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	value = _tmp1_;
	_tmp2_ = value;
	_tmp3_ = self->test_collection;
	g_object_get_property ((GObject*) _tmp3_, "element-type", &value);
	_tmp4_ = g_value_get_gtype (&value);
	_tmp5_ = self->test_collection;
	_tmp6_ = gee_iterable_get_element_type ((GeeIterable*) _tmp5_);
	_tmp7_ = _tmp6_;
	_vala_assert (_tmp4_ == _tmp7_, "value.get_gtype () == test_collection.element_type");
	g_value_unset (&value);
	g_value_init (&_tmp8_, G_TYPE_BOOLEAN);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	value = _tmp8_;
	_tmp9_ = value;
	_tmp10_ = self->test_collection;
	g_object_get_property ((GObject*) _tmp10_, "is-empty", &value);
	_tmp11_ = g_value_get_boolean (&value);
	_tmp12_ = self->test_collection;
	_tmp13_ = gee_collection_get_is_empty (_tmp12_);
	_tmp14_ = _tmp13_;
	_vala_assert (_tmp11_ == _tmp14_, "value.get_boolean () == test_collection.is_empty");
	g_value_unset (&value);
	g_value_init (&_tmp15_, G_TYPE_INT);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	value = _tmp15_;
	_tmp16_ = value;
	_tmp17_ = self->test_collection;
	g_object_get_property ((GObject*) _tmp17_, "size", &value);
	_tmp18_ = g_value_get_int (&value);
	_tmp19_ = self->test_collection;
	_tmp20_ = gee_collection_get_size (_tmp19_);
	_tmp21_ = _tmp20_;
	_vala_assert (_tmp18_ == _tmp21_, "value.get_int () == test_collection.size");
	g_value_unset (&value);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
}


static void collection_tests_class_init (CollectionTestsClass * klass) {
	collection_tests_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = collection_tests_finalize;
}


static void collection_tests_instance_init (CollectionTests * self) {
}


static void collection_tests_finalize (GObject* obj) {
	CollectionTests * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COLLECTION_TESTS, CollectionTests);
	_g_object_unref0 (self->test_collection);
	G_OBJECT_CLASS (collection_tests_parent_class)->finalize (obj);
}


GType collection_tests_get_type (void) {
	static volatile gsize collection_tests_type_id__volatile = 0;
	if (g_once_init_enter (&collection_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CollectionTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) collection_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CollectionTests), 0, (GInstanceInitFunc) collection_tests_instance_init, NULL };
		GType collection_tests_type_id;
		collection_tests_type_id = g_type_register_static (GEE_TYPE_TEST_CASE, "CollectionTests", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&collection_tests_type_id__volatile, collection_tests_type_id);
	}
	return collection_tests_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



