; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-max-iterations-verify -attributor-annotate-decl-cs -attributor-max-iterations=2 -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC

target datalayout = "e-m:w-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-pc-windows-msvc"

define internal void @add(ptr %this, ptr sret(i32) %r) {
;
; TUNIT: Function Attrs: nofree norecurse nosync nounwind willreturn memory(argmem: write)
; TUNIT-LABEL: define {{[^@]+}}@add
; TUNIT-SAME: (ptr noalias nocapture nofree nonnull readnone align 8 dereferenceable(8) [[THIS:%.*]], ptr noalias nocapture nofree noundef nonnull writeonly sret(i32) align 4 dereferenceable(4) [[R:%.*]]) #[[ATTR0:[0-9]+]] {
; TUNIT-NEXT:    store i32 undef, ptr [[R]], align 4
; TUNIT-NEXT:    ret void
;
; CGSCC: Function Attrs: nofree norecurse nosync nounwind willreturn memory(argmem: readwrite)
; CGSCC-LABEL: define {{[^@]+}}@add
; CGSCC-SAME: (ptr noalias nocapture nofree noundef nonnull readonly align 8 dereferenceable(8) [[THIS:%.*]], ptr noalias nocapture nofree noundef nonnull writeonly sret(i32) align 4 dereferenceable(4) [[R:%.*]]) #[[ATTR0:[0-9]+]] {
; CGSCC-NEXT:    [[BP:%.*]] = getelementptr { i32, i32 }, ptr [[THIS]], i32 0, i32 1
; CGSCC-NEXT:    [[A:%.*]] = load i32, ptr [[THIS]], align 8
; CGSCC-NEXT:    [[B:%.*]] = load i32, ptr [[BP]], align 4
; CGSCC-NEXT:    [[AB:%.*]] = add i32 [[A]], [[B]]
; CGSCC-NEXT:    store i32 [[AB]], ptr [[R]], align 4
; CGSCC-NEXT:    ret void
;
  %ap = getelementptr {i32, i32}, ptr %this, i32 0, i32 0
  %bp = getelementptr {i32, i32}, ptr %this, i32 0, i32 1
  %a = load i32, ptr %ap
  %b = load i32, ptr %bp
  %ab = add i32 %a, %b
  store i32 %ab, ptr %r
  ret void
}

define void @f() {
; TUNIT: Function Attrs: nofree norecurse nosync nounwind willreturn memory(none)
; TUNIT-LABEL: define {{[^@]+}}@f
; TUNIT-SAME: () #[[ATTR1:[0-9]+]] {
; TUNIT-NEXT:    [[R:%.*]] = alloca i32, align 4
; TUNIT-NEXT:    call void @add(ptr noalias nocapture nofree nonnull readnone align 8 dereferenceable(8) undef, ptr noalias nocapture nofree noundef nonnull writeonly sret(i32) align 4 dereferenceable(4) [[R]]) #[[ATTR2:[0-9]+]]
; TUNIT-NEXT:    ret void
;
; CGSCC: Function Attrs: nofree nosync nounwind willreturn memory(none)
; CGSCC-LABEL: define {{[^@]+}}@f
; CGSCC-SAME: () #[[ATTR1:[0-9]+]] {
; CGSCC-NEXT:    [[R:%.*]] = alloca i32, align 4
; CGSCC-NEXT:    [[PAIR:%.*]] = alloca { i32, i32 }, align 8
; CGSCC-NEXT:    call void @add(ptr noalias nocapture nofree noundef nonnull readonly align 8 dereferenceable(8) [[PAIR]], ptr noalias nocapture nofree noundef nonnull writeonly sret(i32) align 4 dereferenceable(4) [[R]]) #[[ATTR2:[0-9]+]]
; CGSCC-NEXT:    ret void
;
  %r = alloca i32
  %pair = alloca {i32, i32}

  call void @add(ptr %pair, ptr sret(i32) %r)
  ret void
}
;.
; TUNIT: attributes #[[ATTR0]] = { nofree norecurse nosync nounwind willreturn memory(argmem: write) }
; TUNIT: attributes #[[ATTR1]] = { nofree norecurse nosync nounwind willreturn memory(none) }
; TUNIT: attributes #[[ATTR2]] = { nofree nosync nounwind willreturn }
;.
; CGSCC: attributes #[[ATTR0]] = { nofree norecurse nosync nounwind willreturn memory(argmem: readwrite) }
; CGSCC: attributes #[[ATTR1]] = { nofree nosync nounwind willreturn memory(none) }
; CGSCC: attributes #[[ATTR2]] = { nounwind willreturn }
;.
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK: {{.*}}
