.\" dpkg manual page - start-stop-daemon(8)
.\"
.\" Copyright © 1999 Klee Dienes <klee@mit.edu>
.\" Copyright © 1999 Ben Collins <bcollins@debian.org>
.\" Copyright © 2000-2001 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2002-2003 Adam Heath <doogie@debian.org>
.\" Copyright © 2004 Scott James Remnant <keybuk@debian.org>
.\" Copyright © 2008-2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH start\-stop\-daemon 8 %RELEASE_DATE% %VERSION% Dpkg\-sviten
.nh
.SH NAMN
start\-stop\-daemon \- startar och stoppar bakgrundsprocesser
.
.SH SYNOPS
\fBstart\-stop\-daemon\fP [\fIflagga\fP...] \fIåtgärd\fP
.
.SH BESKRIVNING
\fBstart\-stop\-daemon\fP används för att kontrollera hur processer på systemnivå
skapas och avslutas. Med hjälp av en av sökflaggorna kan
\fBstart\-stop\-daemon\fP ställas in att hitta befintliga instanser av en körande
process.
.PP
Observera att om inte \fB\-\-pid\fP eller \fB\-\-pidfile\fP anges kommer
\fBstart\-stop\-daemon\fP att jobba på ett sätt som liknar \fBkillall(1).\fP
\fBstart\-stop\-daemon\fP kommer att söka i processtabellen efter processer med
motsvarande namn på processen, användar\-id och/eller grupp\-id (om sådant
anges). Alla processer som stämmer överens kommer tillsändas signalen TERM
(eller den som anges med \fB\-\-signal\fP eller \fB\-\-retry\fP) om \fB\-\-stop\fP
anges. För processer som har långlivade barn som måste överleva en
\fB\-\-stop\fP, måste du ange en pidfil.
.
.SH KOMMANDON
.TP 
\fB\-S\fP, \fB\-\-start\fP [\fB\-\-\fP] \fIargument\fP
Se om en angiven process existerar, och om så är fallet gör
\fBstart\-stop\-daemon\fP ingenting och avslutar med status 1 (0 om \fB\-\-oknodo\fP
anges). Om en sådan process inte existerar startas en instans, antingen med
programfilen som anges med \fB\-\-exec\fP eller, om den anges, med
\fB\-\-startas\fP. Eventuella argument som ges efter \fB\-\-\fP på kommandoraden
skickas utan ändring till programmet som startas.
.TP 
\fB\-K\fP, \fB\-\-stop\fP
Testa om den angivna processen existerar. Om så är fallet sänder
\fBstart\-stop\-daemon\fP den signal som anges av \fB\-\-signal\fP till processen, och
avslutar med status 0. Om processen inte finns avslutar \fBstart\-stop\-daemon\fP
med status 1 (0 om \fB\-\-oknodo\fP anges). Om \fB\-\-retry\fP anges kommer
\fBstart\-stop\-daemon\fP kontrollera att processen har avslutats.
.TP 
\fB\-T\fP, \fB\-\-status\fP
Check for the existence of a specified process, and returns an exit status
code, according to the LSB Init Script Actions (since version 1.16.1).
.TP 
\fB\-H\fP, \fB\-\-help\fP
Visa hjälpskärm och avsluta.
.TP 
\fB\-V\fP, \fB\-\-version\fP
Visa programversion och avsluta.
.
.SH FLAGGOR
.SS Matchingsflaggor
.TP 
\fB\-\-pid\fP \fIpid\fP
Check for a process with the specified \fIpid\fP (since version 1.17.6).  The
\fIpid\fP must be a number greater than 0.
.TP 
\fB\-\-ppid\fP \fIppid\fP
Check for a process with the specified parent pid \fIppid\fP (since version
1.17.7).  The \fIppid\fP must be a number greater than 0.
.TP 
\fB\-p\fP, \fB\-\-pidfile\fP \fIpidfil\fP
Kontrollera om en process har skapat filen \fIpidfil\fP. Observera: om flaggan
används på egen hand kan den orsaka att oönskade processer berörs, om den
gamla processen avslutats utan att kunna ta bort \fIpidfil\fP.
.TP 
\fB\-x\fP, \fB\-\-exec\fP \fIprogramfil\fP
Se efter processer som är instanser av \fIprogramfil\fP. Flaggan \fIprogramfil\fP
bör vara en absolut sökväg. Observera: detta fungerar kanske inte som det
ska för tolkade skript eftersom programfilen kommer peka på tolken. Notera
att processer som körs inuti en chroot också kommer att träffas, så andra
begränsningar kan behövas.
.TP 
\fB\-n\fP, \fB\-\-name\fP \fIprocessnamn\fP
Se efter processer med namnet \fIprocessnamn\fP. \fIProcessnamn\fP är vanligtvis
processens filnamn, men kan ha ändrats av processen själv. Observera: på de
flesta system hämtas informationen från processens comm\-namn från kärnan,
vilket ofta har en relativt kort längdbegränsning (det är inte portablet att
anta fler än 15 tecken).
.TP 
\fB\-u\fP, \fB\-\-user\fP \fIanvändarnamn\fP|\fIanvändar\-id\fP
Se efter processer som ägs av användaren som anges av \fIanvändarnamn\fP eller
\fIanvänder\-id\fP. Observera: om den här flaggan används på egen hand träffas
alla processer som motsvarar användaren.
.
.SS "Generiska flaggor"
.TP 
\fB\-g\fP, \fB\-\-group\fP \fIgrupp\fP|\fIgrupp\-id\fP
Byt till \fIgrupp\fP eller \fIgrupp\-id\fP när processen startas.
.TP 
\fB\-s\fP, \fB\-\-signal\fP \fIsignal\fP
Tillsammans med \fB\-\-stop\fP anger detta den signal som skall sändas till
processen som stoppas (förval är TERM).
.TP 
\fB\-R\fP, \fB\-\-retry\fP \fItidsgräns\fP|\fIschema\fP
Tillsammans med \fB\-\-stop\fP anger detta att \fBstart\-stop\-daemon\fP skall
kontrollera att processen avslutas. Den testar flera gånger efter matchande
processer som körs, tills ingen längre finns kvar. Om processerna inte
avslutar kommer programmet utföra ytterligare kommandon enligt schemat.

Om \fItidsgräns\fP anges istället för \fIschema\fP kommer schemat
\fIsignal\fP\fB/\fP\fItimeout\fP\fB/KILL/\fP\fItimeout\fP att användas, där \fIsignal\fP är
den signal som anges med \fB\-\-signal\fP.

\fIschema\fP är den lista med åtminstone två poster avdelade med snedstreck
(\fB/\fP); varje post är antingen \fB\-\fP\fIsignalnummer\fP eller
[\fB\-\fP]\fIsignalnamn\fP, vilket betyder att signalen skall sändas, eller
\fItimeout\fP, vilket anger det antal sekunder programmet skall vänta på att
processen avslutar, eller \fBforever\fP, vilket betyder att resten av schemat
skall repetera för evigt om så behövs.

Om slutet på schemat nås och \fBforever\fP inte anges kommer
\fBstart\-stop\-daemon\fP avslutas med felkod 2. Om ett schema anges kommer
eventuell signal angiven med \fB\-\-signal\fP att ignoreras.
.TP 
\fB\-a\fP, \fB\-\-startas\fP \fIsökväg\fP
Tillsammans med \fB\-\-start\fP anger detta att processen som anges med \fIsökväg\fP
skall startas. Om den inte anges används argumentet som gavs till \fB\-\-exec\fP.
.TP 
\fB\-t\fP, \fB\-\-test\fP
Skriver ut vad som skulle ha utförts och sätter returvärdet, men utför
ingenting.
.TP 
\fB\-o\fP, \fB\-\-oknodo\fP
Returnerar felstatus 0 i stället för 1 om ingen åtgärd utförs/skulle
utförts.
.TP 
\fB\-q\fP, \fB\-\-quiet\fP
Skriv inte informationsmeddelanden; visa endast felmeddelanden.
.TP 
\fB\-c\fP, \fB\-\-chuid\fP \fIanvändarnamn\fP|\fIanvändar\-id\fP[\fB:\fP\fIgrupp\fP|\fIgrupp\-id\fP]
Change to this username/uid before starting the process. You can also
specify a group by appending a \fB:\fP, then the group or gid in the same way
as you would for the \fBchown\fP(1) command (\fIuser\fP\fB:\fP\fIgroup\fP).  If a user
is specified without a group, the primary GID for that user is used.  When
using this option you must realize that the primary and supplemental groups
are set as well, even if the \fB\-\-group\fP option is not specified. The
\fB\-\-group\fP option is only for groups that the user isn't normally a member
of (like adding per process group membership for generic users like
\fBnobody\fP).
.TP 
\fB\-r\fP, \fB\-\-chroot\fP \fIrot\fP
Byt katalog och rot till \fBrot\fP innan processen startas. Observera att även
pidfilen skrivs efter chroot har utförts.
.TP 
\fB\-d\fP, \fB\-\-chdir\fP \fIsökväg\fP
Byt katalog till \fIsökväg\fP innan processen startas. Detta görs efter byte av
rot om \fB\-r\fP|\fB\-\-chroot\fP\-flaggan anges. Om flaggan inte anges kommer
\fBstart\-stop\-daemon\fP byta till rotkatalogen innan processen startas.
.TP 
\fB\-b\fP, \fB\-\-background\fP
Typically used with programs that don't detach on their own. This option
will force \fBstart\-stop\-daemon\fP to fork before starting the process, and
force it into the background.  \fBWarning: start\-stop\-daemon\fP cannot check
the exit status if the process fails to execute for \fBany\fP reason. This is a
last resort, and is only meant for programs that either make no sense
forking on their own, or where it's not feasible to add the code for them to
do this themselves.
.TP 
\fB\-C\fP, \fB\-\-no\-close\fP
Do not close any file descriptor when forcing the daemon into the background
(since version 1.16.5).  Used for debugging purposes to see the process
output, or to redirect file descriptors to log the process output.  Only
relevant when using \fB\-\-background\fP.
.TP 
\fB\-N\fP, \fB\-\-nicelevel\fP \fIheltal\fP
Ändrar prioriteten på processen innan den startas.
.TP 
\fB\-P\fP, \fB\-\-procsched\fP \fIpolicy\fP\fB:\fP\fIprioritet\fP
This alters the process scheduler policy and priority of the process before
starting it (since version 1.15.0).  The priority can be optionally
specified by appending a \fB:\fP followed by the value. The default \fIpriority\fP
is 0. The currently supported policy values are \fBother\fP, \fBfifo\fP and \fBrr\fP.
.TP 
\fB\-I\fP, \fB\-\-iosched\fP \fIklass\fP\fB:\fP\fIprioritet\fP
This alters the IO scheduler class and priority of the process before
starting it (since version 1.15.0).  The priority can be optionally
specified by appending a \fB:\fP followed by the value. The default \fIpriority\fP
is 4, unless \fIclass\fP is \fBidle\fP, then \fIpriority\fP will always be 7. The
currently supported values for \fIclass\fP are \fBidle\fP, \fBbest\-effort\fP and
\fBreal\-time\fP.
.TP 
\fB\-k\fP, \fB\-\-umask\fP \fImaskvärde\fP
This sets the umask of the process before starting it (since version
1.13.22).
.TP 
\fB\-m\fP, \fB\-\-make\-pidfile\fP
Used when starting a program that does not create its own pid file. This
option will make \fBstart\-stop\-daemon\fP create the file referenced with
\fB\-\-pidfile\fP and place the pid into it just before executing the
process. Note, the file will only be removed when stopping the program if
\fB\-\-remove\-pidfile\fP is used.  \fBNote:\fP This feature may not work in all
cases. Most notably when the program being executed forks from its main
process. Because of this, it is usually only useful when combined with the
\fB\-\-background\fP option.
.TP 
\fB\-\-remove\-pidfile\fP
Used when stopping a program that does not remove its own pid file (since
version 1.17.19).  This option will make \fBstart\-stop\-daemon\fP remove the
file referenced with \fB\-\-pidfile\fP after terminating the process.
.TP 
\fB\-v\fP, \fB\-\-verbose\fP
Skriv ut pratsamma informationsmeddelanden.
.
.SH RETURVÄRDE
.TP 
\fB0\fP
Efterfrågad åtgärd utfördes. Om \fB\-\-oknodo\fP angavs är det även möjligt att
ingenting behövde utföras. Det kan hända när \fB\-\-start\fP angavs och en
motsvarande process redan körde, eller när \fB\-\-stop\fP angavs och det inte
fanns någon motsvarande process.
.TP 
\fB1\fP
Om \fB\-\-oknodo\fP inte angavs och ingenting gjordes.
.TP 
\fB2\fP
Om \fB\-\-stop\fP och \fB\-\-retry\fP angavs, men slutet på tidtabellen nåddes och
processen fortfarande kördes.
.TP 
\fB3\fP
Alla andra fel.
.PP
Med \fB\-\-status\fP\-åtgärden returneras följande statuskoder:
.TP 
\fB0\fP
Programmet kör.
.TP 
\fB1\fP
Programmet kör inte och pid\-filen finns.
.TP 
\fB3\fP
Programmet kör inte.
.TP 
\fB4\fP
Kan inte ta reda på programmets status.
.
.SH EXEMPEL
Starta serverprocessen \fBfood\fP, såvida inte en redan kör (en process med
namnet food, som körs som användaren food, med process\-id i food.pid):
.IP
.nf
start\-stop\-daemon \-\-start \-\-oknodo \-\-user food \-\-name food \e
	\-\-pidfile /run/food.pid \-\-startas /usr/sbin/food \e
	\-\-chuid food \-\- \-\-daemon
.fi
.PP
Sänd \fBSIGTERM\fP till \fBfood\fP och vänta upp till fem sekunder på att den
skall avslutas:
.IP
.nf
start\-stop\-daemon \-\-stop \-\-oknodo \-\-user food \-\-name food \e
	\-\-pidfile /run/food.pid \-\-retry 5
.fi
.PP
Demonstration av ett skräddarsytt schema för att avsluta \fBfood\fP:
.IP
.nf
start\-stop\-daemon \-\-stop \-\-oknodo \-\-user food \-\-name food \e
	\-\-pidfile /run/food.pid \-\-retry=TERM/30/KILL/5
.fi
.SH ÖVERSÄTTNING
Peter Krefting och Daniel Nylander.
